<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PoEdit extends Po
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PoEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "poedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->order_type->setVisibility();
        $this->buyer_id->setVisibility();
        $this->buyer_order_no->setVisibility();
        $this->buyer_order_date->setVisibility();
        $this->cart_id->setVisibility();
        $this->buyer_product_ref->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->despatch_date->setVisibility();
        $this->despatch_week->setVisibility();
        $this->fob_date->setVisibility();
        $this->part_dispatch->setVisibility();
        $this->payment_terms->setVisibility();
        $this->transport_terms->setVisibility();
        $this->buyer_shipping_id->setVisibility();
        $this->description_04->setVisibility();
        $this->description_03->setVisibility();
        $this->description_01->setVisibility();
        $this->description_02->setVisibility();
        $this->description_07->setVisibility();
        $this->description_20->setVisibility();
        $this->description_17->setVisibility();
        $this->description_18->setVisibility();
        $this->description_19->setVisibility();
        $this->quantity->setVisibility();
        $this->price->setVisibility();
        $this->currency->setVisibility();
        $this->amount->setVisibility();
        $this->cbm->setVisibility();
        $this->buyer_size->setVisibility();
        $this->description_05->setVisibility();
        $this->description_06->setVisibility();
        $this->description_08->setVisibility();
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
        $this->jc_no->Visible = false;
        $this->buyer_instruction->setVisibility();
        $this->d_09_head->setVisibility();
        $this->description_09->setVisibility();
        $this->d_10_head->setVisibility();
        $this->description_10->setVisibility();
        $this->d_11_head->setVisibility();
        $this->description_11->setVisibility();
        $this->d_12_head->setVisibility();
        $this->description_12->setVisibility();
        $this->po->Visible = false;
        $this->production_site->Visible = false;
        $this->c_total->Visible = false;
        $this->production_plan->Visible = false;
        $this->lot_no->Visible = false;
        $this->product_gcode->Visible = false;
        $this->batch_no->Visible = false;
        $this->uploads->Visible = false;
        $this->d_01_head->Visible = false;
        $this->d_02_head->Visible = false;
        $this->d_03_head->Visible = false;
        $this->d_04_head->Visible = false;
        $this->d_05_head->Visible = false;
        $this->d_06_head->Visible = false;
        $this->d_07_head->Visible = false;
        $this->d_08_head->Visible = false;
        $this->sample->Visible = false;
        $this->balance_quantity->Visible = false;
        $this->_action->Visible = false;
        $this->url->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'po';
        $this->TableName = 'po';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (po)
        if (!isset($GLOBALS["po"]) || $GLOBALS["po"]::class == PROJECT_NAMESPACE . "po") {
            $GLOBALS["po"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'po');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "poview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->order_type);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->cart_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->part_dispatch);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->description_04);
        $this->setupLookupOptions($this->description_03);
        $this->setupLookupOptions($this->description_20);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->description_05);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);
        $this->setupLookupOptions($this->d_09_head);
        $this->setupLookupOptions($this->d_10_head);
        $this->setupLookupOptions($this->d_11_head);
        $this->setupLookupOptions($this->d_12_head);
        $this->setupLookupOptions($this->production_site);
        $this->setupLookupOptions($this->production_plan);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("polist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "polist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "polist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "polist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'order_type' first before field var 'x_order_type'
        $val = $CurrentForm->hasValue("order_type") ? $CurrentForm->getValue("order_type") : $CurrentForm->getValue("x_order_type");
        if (!$this->order_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_type->Visible = false; // Disable update for API request
            } else {
                $this->order_type->setFormValue($val);
            }
        }

        // Check field name 'buyer_id' first before field var 'x_buyer_id'
        $val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
        if (!$this->buyer_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_id->setFormValue($val);
            }
        }

        // Check field name 'buyer_order_no' first before field var 'x_buyer_order_no'
        $val = $CurrentForm->hasValue("buyer_order_no") ? $CurrentForm->getValue("buyer_order_no") : $CurrentForm->getValue("x_buyer_order_no");
        if (!$this->buyer_order_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_order_no->Visible = false; // Disable update for API request
            } else {
                $this->buyer_order_no->setFormValue($val);
            }
        }

        // Check field name 'buyer_order_date' first before field var 'x_buyer_order_date'
        $val = $CurrentForm->hasValue("buyer_order_date") ? $CurrentForm->getValue("buyer_order_date") : $CurrentForm->getValue("x_buyer_order_date");
        if (!$this->buyer_order_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_order_date->Visible = false; // Disable update for API request
            } else {
                $this->buyer_order_date->setFormValue($val, true, $validate);
            }
            $this->buyer_order_date->CurrentValue = UnFormatDateTime($this->buyer_order_date->CurrentValue, $this->buyer_order_date->formatPattern());
        }

        // Check field name 'cart_id' first before field var 'x_cart_id'
        $val = $CurrentForm->hasValue("cart_id") ? $CurrentForm->getValue("cart_id") : $CurrentForm->getValue("x_cart_id");
        if (!$this->cart_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cart_id->Visible = false; // Disable update for API request
            } else {
                $this->cart_id->setFormValue($val);
            }
        }

        // Check field name 'buyer_product_ref' first before field var 'x_buyer_product_ref'
        $val = $CurrentForm->hasValue("buyer_product_ref") ? $CurrentForm->getValue("buyer_product_ref") : $CurrentForm->getValue("x_buyer_product_ref");
        if (!$this->buyer_product_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_product_ref->Visible = false; // Disable update for API request
            } else {
                $this->buyer_product_ref->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'despatch_date' first before field var 'x_despatch_date'
        $val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
        if (!$this->despatch_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_date->Visible = false; // Disable update for API request
            } else {
                $this->despatch_date->setFormValue($val, true, $validate);
            }
            $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        }

        // Check field name 'despatch_week' first before field var 'x_despatch_week'
        $val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
        if (!$this->despatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_week->Visible = false; // Disable update for API request
            } else {
                $this->despatch_week->setFormValue($val);
            }
        }

        // Check field name 'fob_date' first before field var 'x_fob_date'
        $val = $CurrentForm->hasValue("fob_date") ? $CurrentForm->getValue("fob_date") : $CurrentForm->getValue("x_fob_date");
        if (!$this->fob_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fob_date->Visible = false; // Disable update for API request
            } else {
                $this->fob_date->setFormValue($val, true, $validate);
            }
            $this->fob_date->CurrentValue = UnFormatDateTime($this->fob_date->CurrentValue, $this->fob_date->formatPattern());
        }

        // Check field name 'part_dispatch' first before field var 'x_part_dispatch'
        $val = $CurrentForm->hasValue("part_dispatch") ? $CurrentForm->getValue("part_dispatch") : $CurrentForm->getValue("x_part_dispatch");
        if (!$this->part_dispatch->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->part_dispatch->Visible = false; // Disable update for API request
            } else {
                $this->part_dispatch->setFormValue($val);
            }
        }

        // Check field name 'payment_terms' first before field var 'x_payment_terms'
        $val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
        if (!$this->payment_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_terms->Visible = false; // Disable update for API request
            } else {
                $this->payment_terms->setFormValue($val);
            }
        }

        // Check field name 'transport_terms' first before field var 'x_transport_terms'
        $val = $CurrentForm->hasValue("transport_terms") ? $CurrentForm->getValue("transport_terms") : $CurrentForm->getValue("x_transport_terms");
        if (!$this->transport_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->transport_terms->Visible = false; // Disable update for API request
            } else {
                $this->transport_terms->setFormValue($val);
            }
        }

        // Check field name 'buyer_shipping _id' first before field var 'x_buyer_shipping_id'
        $val = $CurrentForm->hasValue("buyer_shipping _id") ? $CurrentForm->getValue("buyer_shipping _id") : $CurrentForm->getValue("x_buyer_shipping_id");
        if (!$this->buyer_shipping_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_shipping_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_shipping_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'description_04' first before field var 'x_description_04'
        $val = $CurrentForm->hasValue("description_04") ? $CurrentForm->getValue("description_04") : $CurrentForm->getValue("x_description_04");
        if (!$this->description_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_04->Visible = false; // Disable update for API request
            } else {
                $this->description_04->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'description_03' first before field var 'x_description_03'
        $val = $CurrentForm->hasValue("description_03") ? $CurrentForm->getValue("description_03") : $CurrentForm->getValue("x_description_03");
        if (!$this->description_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_03->Visible = false; // Disable update for API request
            } else {
                $this->description_03->setFormValue($val);
            }
        }

        // Check field name 'description_01' first before field var 'x_description_01'
        $val = $CurrentForm->hasValue("description_01") ? $CurrentForm->getValue("description_01") : $CurrentForm->getValue("x_description_01");
        if (!$this->description_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_01->Visible = false; // Disable update for API request
            } else {
                $this->description_01->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'description_02' first before field var 'x_description_02'
        $val = $CurrentForm->hasValue("description_02") ? $CurrentForm->getValue("description_02") : $CurrentForm->getValue("x_description_02");
        if (!$this->description_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_02->Visible = false; // Disable update for API request
            } else {
                $this->description_02->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'description_07' first before field var 'x_description_07'
        $val = $CurrentForm->hasValue("description_07") ? $CurrentForm->getValue("description_07") : $CurrentForm->getValue("x_description_07");
        if (!$this->description_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_07->Visible = false; // Disable update for API request
            } else {
                $this->description_07->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'description_20' first before field var 'x_description_20'
        $val = $CurrentForm->hasValue("description_20") ? $CurrentForm->getValue("description_20") : $CurrentForm->getValue("x_description_20");
        if (!$this->description_20->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_20->Visible = false; // Disable update for API request
            } else {
                $this->description_20->setFormValue($val);
            }
        }

        // Check field name 'description_17' first before field var 'x_description_17'
        $val = $CurrentForm->hasValue("description_17") ? $CurrentForm->getValue("description_17") : $CurrentForm->getValue("x_description_17");
        if (!$this->description_17->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_17->Visible = false; // Disable update for API request
            } else {
                $this->description_17->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'description_18' first before field var 'x_description_18'
        $val = $CurrentForm->hasValue("description_18") ? $CurrentForm->getValue("description_18") : $CurrentForm->getValue("x_description_18");
        if (!$this->description_18->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_18->Visible = false; // Disable update for API request
            } else {
                $this->description_18->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'description_19' first before field var 'x_description_19'
        $val = $CurrentForm->hasValue("description_19") ? $CurrentForm->getValue("description_19") : $CurrentForm->getValue("x_description_19");
        if (!$this->description_19->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_19->Visible = false; // Disable update for API request
            } else {
                $this->description_19->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'cbm' first before field var 'x_cbm'
        $val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
        if (!$this->cbm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cbm->Visible = false; // Disable update for API request
            } else {
                $this->cbm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'buyer_size' first before field var 'x_buyer_size'
        $val = $CurrentForm->hasValue("buyer_size") ? $CurrentForm->getValue("buyer_size") : $CurrentForm->getValue("x_buyer_size");
        if (!$this->buyer_size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_size->Visible = false; // Disable update for API request
            } else {
                $this->buyer_size->setFormValue($val);
            }
        }

        // Check field name 'description_05' first before field var 'x_description_05'
        $val = $CurrentForm->hasValue("description_05") ? $CurrentForm->getValue("description_05") : $CurrentForm->getValue("x_description_05");
        if (!$this->description_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_05->Visible = false; // Disable update for API request
            } else {
                $this->description_05->setFormValue($val);
            }
        }

        // Check field name 'description_06' first before field var 'x_description_06'
        $val = $CurrentForm->hasValue("description_06") ? $CurrentForm->getValue("description_06") : $CurrentForm->getValue("x_description_06");
        if (!$this->description_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_06->Visible = false; // Disable update for API request
            } else {
                $this->description_06->setFormValue($val);
            }
        }

        // Check field name 'description_08' first before field var 'x_description_08'
        $val = $CurrentForm->hasValue("description_08") ? $CurrentForm->getValue("description_08") : $CurrentForm->getValue("x_description_08");
        if (!$this->description_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_08->Visible = false; // Disable update for API request
            } else {
                $this->description_08->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'buyer_instruction' first before field var 'x_buyer_instruction'
        $val = $CurrentForm->hasValue("buyer_instruction") ? $CurrentForm->getValue("buyer_instruction") : $CurrentForm->getValue("x_buyer_instruction");
        if (!$this->buyer_instruction->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_instruction->Visible = false; // Disable update for API request
            } else {
                $this->buyer_instruction->setFormValue($val);
            }
        }

        // Check field name 'd_09_head' first before field var 'x_d_09_head'
        $val = $CurrentForm->hasValue("d_09_head") ? $CurrentForm->getValue("d_09_head") : $CurrentForm->getValue("x_d_09_head");
        if (!$this->d_09_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_09_head->Visible = false; // Disable update for API request
            } else {
                $this->d_09_head->setFormValue($val);
            }
        }

        // Check field name 'description_09' first before field var 'x_description_09'
        $val = $CurrentForm->hasValue("description_09") ? $CurrentForm->getValue("description_09") : $CurrentForm->getValue("x_description_09");
        if (!$this->description_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_09->Visible = false; // Disable update for API request
            } else {
                $this->description_09->setFormValue($val);
            }
        }

        // Check field name 'd_10_head' first before field var 'x_d_10_head'
        $val = $CurrentForm->hasValue("d_10_head") ? $CurrentForm->getValue("d_10_head") : $CurrentForm->getValue("x_d_10_head");
        if (!$this->d_10_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_10_head->Visible = false; // Disable update for API request
            } else {
                $this->d_10_head->setFormValue($val);
            }
        }

        // Check field name 'description_10' first before field var 'x_description_10'
        $val = $CurrentForm->hasValue("description_10") ? $CurrentForm->getValue("description_10") : $CurrentForm->getValue("x_description_10");
        if (!$this->description_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_10->Visible = false; // Disable update for API request
            } else {
                $this->description_10->setFormValue($val);
            }
        }

        // Check field name 'd_11_head' first before field var 'x_d_11_head'
        $val = $CurrentForm->hasValue("d_11_head") ? $CurrentForm->getValue("d_11_head") : $CurrentForm->getValue("x_d_11_head");
        if (!$this->d_11_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_11_head->Visible = false; // Disable update for API request
            } else {
                $this->d_11_head->setFormValue($val);
            }
        }

        // Check field name 'description_11' first before field var 'x_description_11'
        $val = $CurrentForm->hasValue("description_11") ? $CurrentForm->getValue("description_11") : $CurrentForm->getValue("x_description_11");
        if (!$this->description_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_11->Visible = false; // Disable update for API request
            } else {
                $this->description_11->setFormValue($val);
            }
        }

        // Check field name 'd_12_head' first before field var 'x_d_12_head'
        $val = $CurrentForm->hasValue("d_12_head") ? $CurrentForm->getValue("d_12_head") : $CurrentForm->getValue("x_d_12_head");
        if (!$this->d_12_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_12_head->Visible = false; // Disable update for API request
            } else {
                $this->d_12_head->setFormValue($val);
            }
        }

        // Check field name 'description_12' first before field var 'x_description_12'
        $val = $CurrentForm->hasValue("description_12") ? $CurrentForm->getValue("description_12") : $CurrentForm->getValue("x_description_12");
        if (!$this->description_12->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_12->Visible = false; // Disable update for API request
            } else {
                $this->description_12->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->order_type->CurrentValue = $this->order_type->FormValue;
        $this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
        $this->buyer_order_no->CurrentValue = $this->buyer_order_no->FormValue;
        $this->buyer_order_date->CurrentValue = $this->buyer_order_date->FormValue;
        $this->buyer_order_date->CurrentValue = UnFormatDateTime($this->buyer_order_date->CurrentValue, $this->buyer_order_date->formatPattern());
        $this->cart_id->CurrentValue = $this->cart_id->FormValue;
        $this->buyer_product_ref->CurrentValue = $this->buyer_product_ref->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
        $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
        $this->fob_date->CurrentValue = $this->fob_date->FormValue;
        $this->fob_date->CurrentValue = UnFormatDateTime($this->fob_date->CurrentValue, $this->fob_date->formatPattern());
        $this->part_dispatch->CurrentValue = $this->part_dispatch->FormValue;
        $this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
        $this->transport_terms->CurrentValue = $this->transport_terms->FormValue;
        $this->buyer_shipping_id->CurrentValue = $this->buyer_shipping_id->FormValue;
        $this->description_04->CurrentValue = $this->description_04->FormValue;
        $this->description_03->CurrentValue = $this->description_03->FormValue;
        $this->description_01->CurrentValue = $this->description_01->FormValue;
        $this->description_02->CurrentValue = $this->description_02->FormValue;
        $this->description_07->CurrentValue = $this->description_07->FormValue;
        $this->description_20->CurrentValue = $this->description_20->FormValue;
        $this->description_17->CurrentValue = $this->description_17->FormValue;
        $this->description_18->CurrentValue = $this->description_18->FormValue;
        $this->description_19->CurrentValue = $this->description_19->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->cbm->CurrentValue = $this->cbm->FormValue;
        $this->buyer_size->CurrentValue = $this->buyer_size->FormValue;
        $this->description_05->CurrentValue = $this->description_05->FormValue;
        $this->description_06->CurrentValue = $this->description_06->FormValue;
        $this->description_08->CurrentValue = $this->description_08->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->buyer_instruction->CurrentValue = $this->buyer_instruction->FormValue;
        $this->d_09_head->CurrentValue = $this->d_09_head->FormValue;
        $this->description_09->CurrentValue = $this->description_09->FormValue;
        $this->d_10_head->CurrentValue = $this->d_10_head->FormValue;
        $this->description_10->CurrentValue = $this->description_10->FormValue;
        $this->d_11_head->CurrentValue = $this->d_11_head->FormValue;
        $this->description_11->CurrentValue = $this->description_11->FormValue;
        $this->d_12_head->CurrentValue = $this->d_12_head->FormValue;
        $this->description_12->CurrentValue = $this->description_12->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->order_type->setDbValue($row['order_type']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->buyer_order_no->setDbValue($row['buyer_order_no']);
        $this->buyer_order_date->setDbValue($row['buyer_order_date']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->buyer_product_ref->setDbValue($row['buyer_product_ref']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->fob_date->setDbValue($row['fob_date']);
        $this->part_dispatch->setDbValue($row['part_dispatch']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->transport_terms->setDbValue($row['transport_terms']);
        $this->buyer_shipping_id->setDbValue($row['buyer_shipping _id']);
        $this->description_04->setDbValue($row['description_04']);
        $this->description_03->setDbValue($row['description_03']);
        $this->description_01->setDbValue($row['description_01']);
        $this->description_02->setDbValue($row['description_02']);
        $this->description_07->setDbValue($row['description_07']);
        $this->description_20->setDbValue($row['description_20']);
        $this->description_17->setDbValue($row['description_17']);
        $this->description_18->setDbValue($row['description_18']);
        $this->description_19->setDbValue($row['description_19']);
        $this->quantity->setDbValue($row['quantity']);
        $this->price->setDbValue($row['price']);
        $this->currency->setDbValue($row['currency']);
        $this->amount->setDbValue($row['amount']);
        $this->cbm->setDbValue($row['cbm']);
        $this->buyer_size->setDbValue($row['buyer_size']);
        $this->description_05->setDbValue($row['description_05']);
        $this->description_06->setDbValue($row['description_06']);
        $this->description_08->setDbValue($row['description_08']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->buyer_instruction->setDbValue($row['buyer_instruction']);
        $this->d_09_head->setDbValue($row['d_09_head']);
        $this->description_09->setDbValue($row['description_09']);
        $this->d_10_head->setDbValue($row['d_10_head']);
        $this->description_10->setDbValue($row['description_10']);
        $this->d_11_head->setDbValue($row['d_11_head']);
        $this->description_11->setDbValue($row['description_11']);
        $this->d_12_head->setDbValue($row['d_12_head']);
        $this->description_12->setDbValue($row['description_12']);
        $this->po->setDbValue($row['po']);
        $this->production_site->setDbValue($row['production_site']);
        $this->c_total->setDbValue($row['c_total']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->product_gcode->setDbValue($row['product_gcode']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->uploads->setDbValue($row['uploads']);
        $this->d_01_head->setDbValue($row['d_01_head']);
        $this->d_02_head->setDbValue($row['d_02_head']);
        $this->d_03_head->setDbValue($row['d_03_head']);
        $this->d_04_head->setDbValue($row['d_04_head']);
        $this->d_05_head->setDbValue($row['d_05_head']);
        $this->d_06_head->setDbValue($row['d_06_head']);
        $this->d_07_head->setDbValue($row['d_07_head']);
        $this->d_08_head->setDbValue($row['d_08_head']);
        $this->sample->setDbValue($row['sample']);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->_action->setDbValue($row['action']);
        $this->url->setDbValue($row['url']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['order_type'] = $this->order_type->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['buyer_order_no'] = $this->buyer_order_no->DefaultValue;
        $row['buyer_order_date'] = $this->buyer_order_date->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['buyer_product_ref'] = $this->buyer_product_ref->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['fob_date'] = $this->fob_date->DefaultValue;
        $row['part_dispatch'] = $this->part_dispatch->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['transport_terms'] = $this->transport_terms->DefaultValue;
        $row['buyer_shipping _id'] = $this->buyer_shipping_id->DefaultValue;
        $row['description_04'] = $this->description_04->DefaultValue;
        $row['description_03'] = $this->description_03->DefaultValue;
        $row['description_01'] = $this->description_01->DefaultValue;
        $row['description_02'] = $this->description_02->DefaultValue;
        $row['description_07'] = $this->description_07->DefaultValue;
        $row['description_20'] = $this->description_20->DefaultValue;
        $row['description_17'] = $this->description_17->DefaultValue;
        $row['description_18'] = $this->description_18->DefaultValue;
        $row['description_19'] = $this->description_19->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['buyer_size'] = $this->buyer_size->DefaultValue;
        $row['description_05'] = $this->description_05->DefaultValue;
        $row['description_06'] = $this->description_06->DefaultValue;
        $row['description_08'] = $this->description_08->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['buyer_instruction'] = $this->buyer_instruction->DefaultValue;
        $row['d_09_head'] = $this->d_09_head->DefaultValue;
        $row['description_09'] = $this->description_09->DefaultValue;
        $row['d_10_head'] = $this->d_10_head->DefaultValue;
        $row['description_10'] = $this->description_10->DefaultValue;
        $row['d_11_head'] = $this->d_11_head->DefaultValue;
        $row['description_11'] = $this->description_11->DefaultValue;
        $row['d_12_head'] = $this->d_12_head->DefaultValue;
        $row['description_12'] = $this->description_12->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['production_site'] = $this->production_site->DefaultValue;
        $row['c_total'] = $this->c_total->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['product_gcode'] = $this->product_gcode->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['d_01_head'] = $this->d_01_head->DefaultValue;
        $row['d_02_head'] = $this->d_02_head->DefaultValue;
        $row['d_03_head'] = $this->d_03_head->DefaultValue;
        $row['d_04_head'] = $this->d_04_head->DefaultValue;
        $row['d_05_head'] = $this->d_05_head->DefaultValue;
        $row['d_06_head'] = $this->d_06_head->DefaultValue;
        $row['d_07_head'] = $this->d_07_head->DefaultValue;
        $row['d_08_head'] = $this->d_08_head->DefaultValue;
        $row['sample'] = $this->sample->DefaultValue;
        $row['balance_quantity'] = $this->balance_quantity->DefaultValue;
        $row['action'] = $this->_action->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // order_type
        $this->order_type->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // buyer_order_no
        $this->buyer_order_no->RowCssClass = "row";

        // buyer_order_date
        $this->buyer_order_date->RowCssClass = "row";

        // cart_id
        $this->cart_id->RowCssClass = "row";

        // buyer_product_ref
        $this->buyer_product_ref->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // fob_date
        $this->fob_date->RowCssClass = "row";

        // part_dispatch
        $this->part_dispatch->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // transport_terms
        $this->transport_terms->RowCssClass = "row";

        // buyer_shipping _id
        $this->buyer_shipping_id->RowCssClass = "row";

        // description_04
        $this->description_04->RowCssClass = "row";

        // description_03
        $this->description_03->RowCssClass = "row";

        // description_01
        $this->description_01->RowCssClass = "row";

        // description_02
        $this->description_02->RowCssClass = "row";

        // description_07
        $this->description_07->RowCssClass = "row";

        // description_20
        $this->description_20->RowCssClass = "row";

        // description_17
        $this->description_17->RowCssClass = "row";

        // description_18
        $this->description_18->RowCssClass = "row";

        // description_19
        $this->description_19->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // buyer_size
        $this->buyer_size->RowCssClass = "row";

        // description_05
        $this->description_05->RowCssClass = "row";

        // description_06
        $this->description_06->RowCssClass = "row";

        // description_08
        $this->description_08->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // buyer_instruction
        $this->buyer_instruction->RowCssClass = "row";

        // d_09_head
        $this->d_09_head->RowCssClass = "row";

        // description_09
        $this->description_09->RowCssClass = "row";

        // d_10_head
        $this->d_10_head->RowCssClass = "row";

        // description_10
        $this->description_10->RowCssClass = "row";

        // d_11_head
        $this->d_11_head->RowCssClass = "row";

        // description_11
        $this->description_11->RowCssClass = "row";

        // d_12_head
        $this->d_12_head->RowCssClass = "row";

        // description_12
        $this->description_12->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // production_site
        $this->production_site->RowCssClass = "row";

        // c_total
        $this->c_total->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // product_gcode
        $this->product_gcode->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // d_01_head
        $this->d_01_head->RowCssClass = "row";

        // d_02_head
        $this->d_02_head->RowCssClass = "row";

        // d_03_head
        $this->d_03_head->RowCssClass = "row";

        // d_04_head
        $this->d_04_head->RowCssClass = "row";

        // d_05_head
        $this->d_05_head->RowCssClass = "row";

        // d_06_head
        $this->d_06_head->RowCssClass = "row";

        // d_07_head
        $this->d_07_head->RowCssClass = "row";

        // d_08_head
        $this->d_08_head->RowCssClass = "row";

        // sample
        $this->sample->RowCssClass = "row";

        // balance_quantity
        $this->balance_quantity->RowCssClass = "row";

        // action
        $this->_action->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // order_type
            if (strval($this->order_type->CurrentValue) != "") {
                $this->order_type->ViewValue = $this->order_type->optionCaption($this->order_type->CurrentValue);
            } else {
                $this->order_type->ViewValue = null;
            }

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // buyer_order_no
            $this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;

            // buyer_order_date
            $this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
            $this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, $this->buyer_order_date->formatPattern());

            // cart_id
            $curVal = strval($this->cart_id->CurrentValue);
            if ($curVal != "") {
                $this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
                if ($this->cart_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->cart_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->cart_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->cart_id->Lookup->renderViewRow($row);
                            $this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
                        }
                    } else {
                        $this->cart_id->ViewValue = $this->cart_id->CurrentValue;
                    }
                }
            } else {
                $this->cart_id->ViewValue = null;
            }

            // buyer_product_ref
            $this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // fob_date
            $this->fob_date->ViewValue = $this->fob_date->CurrentValue;
            $this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, $this->fob_date->formatPattern());

            // part_dispatch
            if (strval($this->part_dispatch->CurrentValue) != "") {
                $this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
            } else {
                $this->part_dispatch->ViewValue = null;
            }

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // transport_terms
            $this->transport_terms->ViewValue = $this->transport_terms->CurrentValue;

            // buyer_shipping _id
            $this->buyer_shipping_id->ViewValue = $this->buyer_shipping_id->CurrentValue;
            $this->buyer_shipping_id->ViewValue = FormatNumber($this->buyer_shipping_id->ViewValue, $this->buyer_shipping_id->formatPattern());

            // description_04
            $this->description_04->ViewValue = $this->description_04->CurrentValue;

            // description_03
            if (strval($this->description_03->CurrentValue) != "") {
                $this->description_03->ViewValue = $this->description_03->optionCaption($this->description_03->CurrentValue);
            } else {
                $this->description_03->ViewValue = null;
            }

            // description_01
            $this->description_01->ViewValue = $this->description_01->CurrentValue;
            $this->description_01->ViewValue = FormatNumber($this->description_01->ViewValue, $this->description_01->formatPattern());

            // description_02
            $this->description_02->ViewValue = $this->description_02->CurrentValue;
            $this->description_02->ViewValue = FormatNumber($this->description_02->ViewValue, $this->description_02->formatPattern());

            // description_07
            $this->description_07->ViewValue = $this->description_07->CurrentValue;

            // description_20
            if (strval($this->description_20->CurrentValue) != "") {
                $this->description_20->ViewValue = $this->description_20->optionCaption($this->description_20->CurrentValue);
            } else {
                $this->description_20->ViewValue = null;
            }

            // description_17
            $this->description_17->ViewValue = $this->description_17->CurrentValue;
            $this->description_17->ViewValue = FormatNumber($this->description_17->ViewValue, $this->description_17->formatPattern());

            // description_18
            $this->description_18->ViewValue = $this->description_18->CurrentValue;
            $this->description_18->ViewValue = FormatNumber($this->description_18->ViewValue, $this->description_18->formatPattern());

            // description_19
            $this->description_19->ViewValue = $this->description_19->CurrentValue;
            $this->description_19->ViewValue = FormatNumber($this->description_19->ViewValue, $this->description_19->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // buyer_size
            $this->buyer_size->ViewValue = $this->buyer_size->CurrentValue;

            // description_05
            $curVal = strval($this->description_05->CurrentValue);
            if ($curVal != "") {
                $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
                if ($this->description_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->description_05->Lookup->renderViewRow($rswrk[0]);
                        $this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
                    } else {
                        $this->description_05->ViewValue = $this->description_05->CurrentValue;
                    }
                }
            } else {
                $this->description_05->ViewValue = null;
            }

            // description_06
            $this->description_06->ViewValue = $this->description_06->CurrentValue;

            // description_08
            $this->description_08->ViewValue = $this->description_08->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // buyer_instruction
            $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

            // d_09_head
            $curVal = strval($this->d_09_head->CurrentValue);
            if ($curVal != "") {
                $this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
                if ($this->d_09_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_09_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_09_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
                    } else {
                        $this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
                    }
                }
            } else {
                $this->d_09_head->ViewValue = null;
            }

            // description_09
            $this->description_09->ViewValue = $this->description_09->CurrentValue;

            // d_10_head
            $curVal = strval($this->d_10_head->CurrentValue);
            if ($curVal != "") {
                $this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
                if ($this->d_10_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_10_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_10_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
                    } else {
                        $this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
                    }
                }
            } else {
                $this->d_10_head->ViewValue = null;
            }

            // description_10
            $this->description_10->ViewValue = $this->description_10->CurrentValue;

            // d_11_head
            $curVal = strval($this->d_11_head->CurrentValue);
            if ($curVal != "") {
                $this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
                if ($this->d_11_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_11_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_11_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_11_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_11_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
                    } else {
                        $this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
                    }
                }
            } else {
                $this->d_11_head->ViewValue = null;
            }

            // description_11
            $this->description_11->ViewValue = $this->description_11->CurrentValue;

            // d_12_head
            $curVal = strval($this->d_12_head->CurrentValue);
            if ($curVal != "") {
                $this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
                if ($this->d_12_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_12_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_12_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_12_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_12_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
                    } else {
                        $this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
                    }
                }
            } else {
                $this->d_12_head->ViewValue = null;
            }

            // description_12
            $this->description_12->ViewValue = $this->description_12->CurrentValue;

            // action
            $this->_action->ViewValue = $this->_action->CurrentValue;
            $this->_action->CssClass = "fw-bold";
            $this->_action->ViewCustomAttributes = $this->_action->getViewCustomAttributes(); // PHP

            // id
            $this->id->HrefValue = "";

            // order_type
            $this->order_type->HrefValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // buyer_order_no
            $this->buyer_order_no->HrefValue = "";

            // buyer_order_date
            $this->buyer_order_date->HrefValue = "";

            // cart_id
            $this->cart_id->HrefValue = "";

            // buyer_product_ref
            $this->buyer_product_ref->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // fob_date
            $this->fob_date->HrefValue = "";

            // part_dispatch
            $this->part_dispatch->HrefValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";

            // transport_terms
            $this->transport_terms->HrefValue = "";

            // buyer_shipping _id
            $this->buyer_shipping_id->HrefValue = "";

            // description_04
            $this->description_04->HrefValue = "";

            // description_03
            $this->description_03->HrefValue = "";

            // description_01
            $this->description_01->HrefValue = "";

            // description_02
            $this->description_02->HrefValue = "";

            // description_07
            $this->description_07->HrefValue = "";

            // description_20
            $this->description_20->HrefValue = "";

            // description_17
            $this->description_17->HrefValue = "";

            // description_18
            $this->description_18->HrefValue = "";

            // description_19
            $this->description_19->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // buyer_size
            $this->buyer_size->HrefValue = "";

            // description_05
            $this->description_05->HrefValue = "";

            // description_06
            $this->description_06->HrefValue = "";

            // description_08
            $this->description_08->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";

            // d_09_head
            $this->d_09_head->HrefValue = "";

            // description_09
            $this->description_09->HrefValue = "";

            // d_10_head
            $this->d_10_head->HrefValue = "";

            // description_10
            $this->description_10->HrefValue = "";

            // d_11_head
            $this->d_11_head->HrefValue = "";

            // description_11
            $this->description_11->HrefValue = "";

            // d_12_head
            $this->d_12_head->HrefValue = "";

            // description_12
            $this->description_12->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // order_type
            $this->order_type->EditValue = $this->order_type->options(false);
            $this->order_type->PlaceHolder = RemoveHtml($this->order_type->caption());

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $curVal = trim(strval($this->buyer_id->CurrentValue));
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            } else {
                $this->buyer_id->ViewValue = $this->buyer_id->Lookup !== null && is_array($this->buyer_id->lookupOptions()) && count($this->buyer_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_id->ViewValue !== null) { // Load from cache
                $this->buyer_id->EditValue = array_values($this->buyer_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyer_id->CurrentValue, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyer_id->EditValue = $arwrk;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // buyer_order_no
            $this->buyer_order_no->setupEditAttributes();
            if (!$this->buyer_order_no->Raw) {
                $this->buyer_order_no->CurrentValue = HtmlDecode($this->buyer_order_no->CurrentValue);
            }
            $this->buyer_order_no->EditValue = HtmlEncode($this->buyer_order_no->CurrentValue);
            $this->buyer_order_no->PlaceHolder = RemoveHtml($this->buyer_order_no->caption());

            // buyer_order_date
            $this->buyer_order_date->setupEditAttributes();
            $this->buyer_order_date->EditValue = HtmlEncode(FormatDateTime($this->buyer_order_date->CurrentValue, $this->buyer_order_date->formatPattern()));
            $this->buyer_order_date->PlaceHolder = RemoveHtml($this->buyer_order_date->caption());

            // cart_id
            $curVal = trim(strval($this->cart_id->CurrentValue));
            if ($curVal != "") {
                $this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
            } else {
                $this->cart_id->ViewValue = $this->cart_id->Lookup !== null && is_array($this->cart_id->lookupOptions()) && count($this->cart_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->cart_id->ViewValue !== null) { // Load from cache
                $this->cart_id->EditValue = array_values($this->cart_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->cart_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->cart_id->Lookup->renderViewRow($row);
                }
                $this->cart_id->EditValue = $arwrk;
            }
            $this->cart_id->PlaceHolder = RemoveHtml($this->cart_id->caption());

            // buyer_product_ref
            $this->buyer_product_ref->setupEditAttributes();
            if (!$this->buyer_product_ref->Raw) {
                $this->buyer_product_ref->CurrentValue = HtmlDecode($this->buyer_product_ref->CurrentValue);
            }
            $this->buyer_product_ref->EditValue = HtmlEncode($this->buyer_product_ref->CurrentValue);
            $this->buyer_product_ref->PlaceHolder = RemoveHtml($this->buyer_product_ref->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $curVal = trim(strval($this->rid->CurrentValue));
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            } else {
                $this->rid->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid->ViewValue !== null) { // Load from cache
                $this->rid->EditValue = array_values($this->rid->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->CurrentValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->rid->EditValue = $arwrk;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()));
            $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->CurrentValue));
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->CurrentValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // fob_date
            $this->fob_date->setupEditAttributes();
            $this->fob_date->EditValue = HtmlEncode(FormatDateTime($this->fob_date->CurrentValue, $this->fob_date->formatPattern()));
            $this->fob_date->PlaceHolder = RemoveHtml($this->fob_date->caption());

            // part_dispatch
            $this->part_dispatch->setupEditAttributes();
            $this->part_dispatch->EditValue = $this->part_dispatch->options(true);
            $this->part_dispatch->PlaceHolder = RemoveHtml($this->part_dispatch->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            $curVal = trim(strval($this->payment_terms->CurrentValue));
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
            } else {
                $this->payment_terms->ViewValue = $this->payment_terms->Lookup !== null && is_array($this->payment_terms->lookupOptions()) && count($this->payment_terms->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment_terms->ViewValue !== null) { // Load from cache
                $this->payment_terms->EditValue = array_values($this->payment_terms->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->payment_terms->CurrentValue, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_terms->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->payment_terms->EditValue = $arwrk;
            }
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

            // transport_terms
            $this->transport_terms->setupEditAttributes();
            if (!$this->transport_terms->Raw) {
                $this->transport_terms->CurrentValue = HtmlDecode($this->transport_terms->CurrentValue);
            }
            $this->transport_terms->EditValue = HtmlEncode($this->transport_terms->CurrentValue);
            $this->transport_terms->PlaceHolder = RemoveHtml($this->transport_terms->caption());

            // buyer_shipping _id
            $this->buyer_shipping_id->setupEditAttributes();
            $this->buyer_shipping_id->EditValue = $this->buyer_shipping_id->CurrentValue;
            $this->buyer_shipping_id->PlaceHolder = RemoveHtml($this->buyer_shipping_id->caption());
            if (strval($this->buyer_shipping_id->EditValue) != "" && is_numeric($this->buyer_shipping_id->EditValue)) {
                $this->buyer_shipping_id->EditValue = FormatNumber($this->buyer_shipping_id->EditValue, null);
            }

            // description_04
            $this->description_04->setupEditAttributes();
            $this->description_04->EditValue = $this->description_04->CurrentValue;
            $this->description_04->PlaceHolder = RemoveHtml($this->description_04->caption());

            // description_03
            $this->description_03->setupEditAttributes();
            $this->description_03->EditValue = $this->description_03->options(true);
            $this->description_03->PlaceHolder = RemoveHtml($this->description_03->caption());

            // description_01
            $this->description_01->setupEditAttributes();
            $this->description_01->EditValue = $this->description_01->CurrentValue;
            $this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());
            if (strval($this->description_01->EditValue) != "" && is_numeric($this->description_01->EditValue)) {
                $this->description_01->EditValue = FormatNumber($this->description_01->EditValue, null);
            }

            // description_02
            $this->description_02->setupEditAttributes();
            $this->description_02->EditValue = $this->description_02->CurrentValue;
            $this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());
            if (strval($this->description_02->EditValue) != "" && is_numeric($this->description_02->EditValue)) {
                $this->description_02->EditValue = FormatNumber($this->description_02->EditValue, null);
            }

            // description_07
            $this->description_07->setupEditAttributes();
            $this->description_07->EditValue = $this->description_07->CurrentValue;
            $this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());
            if (strval($this->description_07->EditValue) != "" && is_numeric($this->description_07->EditValue)) {
                $this->description_07->EditValue = $this->description_07->EditValue;
            }

            // description_20
            $this->description_20->setupEditAttributes();
            $this->description_20->EditValue = $this->description_20->options(true);
            $this->description_20->PlaceHolder = RemoveHtml($this->description_20->caption());

            // description_17
            $this->description_17->setupEditAttributes();
            $this->description_17->EditCustomAttributes = $this->description_17->getEditCustomAttributes(); // PHP
            $this->description_17->EditValue = $this->description_17->CurrentValue;
            $this->description_17->PlaceHolder = RemoveHtml($this->description_17->caption());
            if (strval($this->description_17->EditValue) != "" && is_numeric($this->description_17->EditValue)) {
                $this->description_17->EditValue = FormatNumber($this->description_17->EditValue, null);
            }

            // description_18
            $this->description_18->setupEditAttributes();
            $this->description_18->EditCustomAttributes = $this->description_18->getEditCustomAttributes(); // PHP
            $this->description_18->EditValue = $this->description_18->CurrentValue;
            $this->description_18->PlaceHolder = RemoveHtml($this->description_18->caption());
            if (strval($this->description_18->EditValue) != "" && is_numeric($this->description_18->EditValue)) {
                $this->description_18->EditValue = FormatNumber($this->description_18->EditValue, null);
            }

            // description_19
            $this->description_19->setupEditAttributes();
            $this->description_19->EditCustomAttributes = $this->description_19->getEditCustomAttributes(); // PHP
            $this->description_19->EditValue = $this->description_19->CurrentValue;
            $this->description_19->PlaceHolder = RemoveHtml($this->description_19->caption());
            if (strval($this->description_19->EditValue) != "" && is_numeric($this->description_19->EditValue)) {
                $this->description_19->EditValue = FormatNumber($this->description_19->EditValue, null);
            }

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditCustomAttributes = $this->price->getEditCustomAttributes(); // PHP
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $this->currency->EditCustomAttributes = $this->currency->getEditCustomAttributes(); // PHP
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditCustomAttributes = $this->cbm->getEditCustomAttributes(); // PHP
            $this->cbm->EditValue = $this->cbm->CurrentValue;
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
            if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
                $this->cbm->EditValue = FormatNumber($this->cbm->EditValue, null);
            }

            // buyer_size
            $this->buyer_size->setupEditAttributes();
            if (!$this->buyer_size->Raw) {
                $this->buyer_size->CurrentValue = HtmlDecode($this->buyer_size->CurrentValue);
            }
            $this->buyer_size->EditValue = HtmlEncode($this->buyer_size->CurrentValue);
            $this->buyer_size->PlaceHolder = RemoveHtml($this->buyer_size->caption());

            // description_05
            $this->description_05->setupEditAttributes();
            $curVal = trim(strval($this->description_05->CurrentValue));
            if ($curVal != "") {
                $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
            } else {
                $this->description_05->ViewValue = $this->description_05->Lookup !== null && is_array($this->description_05->lookupOptions()) && count($this->description_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_05->ViewValue !== null) { // Load from cache
                $this->description_05->EditValue = array_values($this->description_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->description_05->CurrentValue, $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->description_05->EditValue = $arwrk;
            }
            $this->description_05->PlaceHolder = RemoveHtml($this->description_05->caption());

            // description_06
            $this->description_06->setupEditAttributes();
            $this->description_06->EditValue = $this->description_06->CurrentValue;
            $this->description_06->PlaceHolder = RemoveHtml($this->description_06->caption());
            if (strval($this->description_06->EditValue) != "" && is_numeric($this->description_06->EditValue)) {
                $this->description_06->EditValue = $this->description_06->EditValue;
            }

            // description_08
            $this->description_08->setupEditAttributes();
            $this->description_08->EditValue = $this->description_08->CurrentValue;
            $this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());
            if (strval($this->description_08->EditValue) != "" && is_numeric($this->description_08->EditValue)) {
                $this->description_08->EditValue = $this->description_08->EditValue;
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator

            // datetime

            // buyer_instruction
            $this->buyer_instruction->setupEditAttributes();
            $this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->CurrentValue);
            $this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

            // d_09_head
            $this->d_09_head->setupEditAttributes();
            $curVal = trim(strval($this->d_09_head->CurrentValue));
            if ($curVal != "") {
                $this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
            } else {
                $this->d_09_head->ViewValue = $this->d_09_head->Lookup !== null && is_array($this->d_09_head->lookupOptions()) && count($this->d_09_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_09_head->ViewValue !== null) { // Load from cache
                $this->d_09_head->EditValue = array_values($this->d_09_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_09_head->CurrentValue, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_09_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_09_head->EditValue = $arwrk;
            }
            $this->d_09_head->PlaceHolder = RemoveHtml($this->d_09_head->caption());

            // description_09
            $this->description_09->setupEditAttributes();
            if (!$this->description_09->Raw) {
                $this->description_09->CurrentValue = HtmlDecode($this->description_09->CurrentValue);
            }
            $this->description_09->EditValue = HtmlEncode($this->description_09->CurrentValue);
            $this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

            // d_10_head
            $this->d_10_head->setupEditAttributes();
            $curVal = trim(strval($this->d_10_head->CurrentValue));
            if ($curVal != "") {
                $this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
            } else {
                $this->d_10_head->ViewValue = $this->d_10_head->Lookup !== null && is_array($this->d_10_head->lookupOptions()) && count($this->d_10_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_10_head->ViewValue !== null) { // Load from cache
                $this->d_10_head->EditValue = array_values($this->d_10_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_10_head->CurrentValue, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_10_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_10_head->EditValue = $arwrk;
            }
            $this->d_10_head->PlaceHolder = RemoveHtml($this->d_10_head->caption());

            // description_10
            $this->description_10->setupEditAttributes();
            if (!$this->description_10->Raw) {
                $this->description_10->CurrentValue = HtmlDecode($this->description_10->CurrentValue);
            }
            $this->description_10->EditValue = HtmlEncode($this->description_10->CurrentValue);
            $this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

            // d_11_head
            $this->d_11_head->setupEditAttributes();
            $curVal = trim(strval($this->d_11_head->CurrentValue));
            if ($curVal != "") {
                $this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
            } else {
                $this->d_11_head->ViewValue = $this->d_11_head->Lookup !== null && is_array($this->d_11_head->lookupOptions()) && count($this->d_11_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_11_head->ViewValue !== null) { // Load from cache
                $this->d_11_head->EditValue = array_values($this->d_11_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_11_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_11_head->CurrentValue, $this->d_11_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_11_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_11_head->EditValue = $arwrk;
            }
            $this->d_11_head->PlaceHolder = RemoveHtml($this->d_11_head->caption());

            // description_11
            $this->description_11->setupEditAttributes();
            if (!$this->description_11->Raw) {
                $this->description_11->CurrentValue = HtmlDecode($this->description_11->CurrentValue);
            }
            $this->description_11->EditValue = HtmlEncode($this->description_11->CurrentValue);
            $this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

            // d_12_head
            $this->d_12_head->setupEditAttributes();
            $curVal = trim(strval($this->d_12_head->CurrentValue));
            if ($curVal != "") {
                $this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
            } else {
                $this->d_12_head->ViewValue = $this->d_12_head->Lookup !== null && is_array($this->d_12_head->lookupOptions()) && count($this->d_12_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_12_head->ViewValue !== null) { // Load from cache
                $this->d_12_head->EditValue = array_values($this->d_12_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_12_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_12_head->CurrentValue, $this->d_12_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_12_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_12_head->EditValue = $arwrk;
            }
            $this->d_12_head->PlaceHolder = RemoveHtml($this->d_12_head->caption());

            // description_12
            $this->description_12->setupEditAttributes();
            if (!$this->description_12->Raw) {
                $this->description_12->CurrentValue = HtmlDecode($this->description_12->CurrentValue);
            }
            $this->description_12->EditValue = HtmlEncode($this->description_12->CurrentValue);
            $this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // order_type
            $this->order_type->HrefValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // buyer_order_no
            $this->buyer_order_no->HrefValue = "";

            // buyer_order_date
            $this->buyer_order_date->HrefValue = "";

            // cart_id
            $this->cart_id->HrefValue = "";

            // buyer_product_ref
            $this->buyer_product_ref->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // fob_date
            $this->fob_date->HrefValue = "";

            // part_dispatch
            $this->part_dispatch->HrefValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";

            // transport_terms
            $this->transport_terms->HrefValue = "";

            // buyer_shipping _id
            $this->buyer_shipping_id->HrefValue = "";

            // description_04
            $this->description_04->HrefValue = "";

            // description_03
            $this->description_03->HrefValue = "";

            // description_01
            $this->description_01->HrefValue = "";

            // description_02
            $this->description_02->HrefValue = "";

            // description_07
            $this->description_07->HrefValue = "";

            // description_20
            $this->description_20->HrefValue = "";

            // description_17
            $this->description_17->HrefValue = "";

            // description_18
            $this->description_18->HrefValue = "";

            // description_19
            $this->description_19->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // buyer_size
            $this->buyer_size->HrefValue = "";

            // description_05
            $this->description_05->HrefValue = "";

            // description_06
            $this->description_06->HrefValue = "";

            // description_08
            $this->description_08->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";

            // d_09_head
            $this->d_09_head->HrefValue = "";

            // description_09
            $this->description_09->HrefValue = "";

            // d_10_head
            $this->d_10_head->HrefValue = "";

            // description_10
            $this->description_10->HrefValue = "";

            // d_11_head
            $this->d_11_head->HrefValue = "";

            // description_11
            $this->description_11->HrefValue = "";

            // d_12_head
            $this->d_12_head->HrefValue = "";

            // description_12
            $this->description_12->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->order_type->Visible && $this->order_type->Required) {
                if ($this->order_type->FormValue == "") {
                    $this->order_type->addErrorMessage(str_replace("%s", $this->order_type->caption(), $this->order_type->RequiredErrorMessage));
                }
            }
            if ($this->buyer_id->Visible && $this->buyer_id->Required) {
                if (!$this->buyer_id->IsDetailKey && EmptyValue($this->buyer_id->FormValue)) {
                    $this->buyer_id->addErrorMessage(str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
                }
            }
            if ($this->buyer_order_no->Visible && $this->buyer_order_no->Required) {
                if (!$this->buyer_order_no->IsDetailKey && EmptyValue($this->buyer_order_no->FormValue)) {
                    $this->buyer_order_no->addErrorMessage(str_replace("%s", $this->buyer_order_no->caption(), $this->buyer_order_no->RequiredErrorMessage));
                }
            }
            if ($this->buyer_order_date->Visible && $this->buyer_order_date->Required) {
                if (!$this->buyer_order_date->IsDetailKey && EmptyValue($this->buyer_order_date->FormValue)) {
                    $this->buyer_order_date->addErrorMessage(str_replace("%s", $this->buyer_order_date->caption(), $this->buyer_order_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->buyer_order_date->FormValue, $this->buyer_order_date->formatPattern())) {
                $this->buyer_order_date->addErrorMessage($this->buyer_order_date->getErrorMessage(false));
            }
            if ($this->cart_id->Visible && $this->cart_id->Required) {
                if ($this->cart_id->FormValue == "") {
                    $this->cart_id->addErrorMessage(str_replace("%s", $this->cart_id->caption(), $this->cart_id->RequiredErrorMessage));
                }
            }
            if ($this->buyer_product_ref->Visible && $this->buyer_product_ref->Required) {
                if (!$this->buyer_product_ref->IsDetailKey && EmptyValue($this->buyer_product_ref->FormValue)) {
                    $this->buyer_product_ref->addErrorMessage(str_replace("%s", $this->buyer_product_ref->caption(), $this->buyer_product_ref->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if ($this->rid->FormValue == "") {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->despatch_date->Visible && $this->despatch_date->Required) {
                if (!$this->despatch_date->IsDetailKey && EmptyValue($this->despatch_date->FormValue)) {
                    $this->despatch_date->addErrorMessage(str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->despatch_date->FormValue, $this->despatch_date->formatPattern())) {
                $this->despatch_date->addErrorMessage($this->despatch_date->getErrorMessage(false));
            }
            if ($this->despatch_week->Visible && $this->despatch_week->Required) {
                if (!$this->despatch_week->IsDetailKey && EmptyValue($this->despatch_week->FormValue)) {
                    $this->despatch_week->addErrorMessage(str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
                }
            }
            if ($this->fob_date->Visible && $this->fob_date->Required) {
                if (!$this->fob_date->IsDetailKey && EmptyValue($this->fob_date->FormValue)) {
                    $this->fob_date->addErrorMessage(str_replace("%s", $this->fob_date->caption(), $this->fob_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->fob_date->FormValue, $this->fob_date->formatPattern())) {
                $this->fob_date->addErrorMessage($this->fob_date->getErrorMessage(false));
            }
            if ($this->part_dispatch->Visible && $this->part_dispatch->Required) {
                if (!$this->part_dispatch->IsDetailKey && EmptyValue($this->part_dispatch->FormValue)) {
                    $this->part_dispatch->addErrorMessage(str_replace("%s", $this->part_dispatch->caption(), $this->part_dispatch->RequiredErrorMessage));
                }
            }
            if ($this->payment_terms->Visible && $this->payment_terms->Required) {
                if (!$this->payment_terms->IsDetailKey && EmptyValue($this->payment_terms->FormValue)) {
                    $this->payment_terms->addErrorMessage(str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
                }
            }
            if ($this->transport_terms->Visible && $this->transport_terms->Required) {
                if (!$this->transport_terms->IsDetailKey && EmptyValue($this->transport_terms->FormValue)) {
                    $this->transport_terms->addErrorMessage(str_replace("%s", $this->transport_terms->caption(), $this->transport_terms->RequiredErrorMessage));
                }
            }
            if ($this->buyer_shipping_id->Visible && $this->buyer_shipping_id->Required) {
                if (!$this->buyer_shipping_id->IsDetailKey && EmptyValue($this->buyer_shipping_id->FormValue)) {
                    $this->buyer_shipping_id->addErrorMessage(str_replace("%s", $this->buyer_shipping_id->caption(), $this->buyer_shipping_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->buyer_shipping_id->FormValue)) {
                $this->buyer_shipping_id->addErrorMessage($this->buyer_shipping_id->getErrorMessage(false));
            }
            if ($this->description_04->Visible && $this->description_04->Required) {
                if (!$this->description_04->IsDetailKey && EmptyValue($this->description_04->FormValue)) {
                    $this->description_04->addErrorMessage(str_replace("%s", $this->description_04->caption(), $this->description_04->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->description_04->FormValue)) {
                $this->description_04->addErrorMessage($this->description_04->getErrorMessage(false));
            }
            if ($this->description_03->Visible && $this->description_03->Required) {
                if (!$this->description_03->IsDetailKey && EmptyValue($this->description_03->FormValue)) {
                    $this->description_03->addErrorMessage(str_replace("%s", $this->description_03->caption(), $this->description_03->RequiredErrorMessage));
                }
            }
            if ($this->description_01->Visible && $this->description_01->Required) {
                if (!$this->description_01->IsDetailKey && EmptyValue($this->description_01->FormValue)) {
                    $this->description_01->addErrorMessage(str_replace("%s", $this->description_01->caption(), $this->description_01->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->description_01->FormValue)) {
                $this->description_01->addErrorMessage($this->description_01->getErrorMessage(false));
            }
            if ($this->description_02->Visible && $this->description_02->Required) {
                if (!$this->description_02->IsDetailKey && EmptyValue($this->description_02->FormValue)) {
                    $this->description_02->addErrorMessage(str_replace("%s", $this->description_02->caption(), $this->description_02->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->description_02->FormValue)) {
                $this->description_02->addErrorMessage($this->description_02->getErrorMessage(false));
            }
            if ($this->description_07->Visible && $this->description_07->Required) {
                if (!$this->description_07->IsDetailKey && EmptyValue($this->description_07->FormValue)) {
                    $this->description_07->addErrorMessage(str_replace("%s", $this->description_07->caption(), $this->description_07->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->description_07->FormValue)) {
                $this->description_07->addErrorMessage($this->description_07->getErrorMessage(false));
            }
            if ($this->description_20->Visible && $this->description_20->Required) {
                if (!$this->description_20->IsDetailKey && EmptyValue($this->description_20->FormValue)) {
                    $this->description_20->addErrorMessage(str_replace("%s", $this->description_20->caption(), $this->description_20->RequiredErrorMessage));
                }
            }
            if ($this->description_17->Visible && $this->description_17->Required) {
                if (!$this->description_17->IsDetailKey && EmptyValue($this->description_17->FormValue)) {
                    $this->description_17->addErrorMessage(str_replace("%s", $this->description_17->caption(), $this->description_17->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->description_17->FormValue)) {
                $this->description_17->addErrorMessage($this->description_17->getErrorMessage(false));
            }
            if ($this->description_18->Visible && $this->description_18->Required) {
                if (!$this->description_18->IsDetailKey && EmptyValue($this->description_18->FormValue)) {
                    $this->description_18->addErrorMessage(str_replace("%s", $this->description_18->caption(), $this->description_18->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->description_18->FormValue)) {
                $this->description_18->addErrorMessage($this->description_18->getErrorMessage(false));
            }
            if ($this->description_19->Visible && $this->description_19->Required) {
                if (!$this->description_19->IsDetailKey && EmptyValue($this->description_19->FormValue)) {
                    $this->description_19->addErrorMessage(str_replace("%s", $this->description_19->caption(), $this->description_19->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->description_19->FormValue)) {
                $this->description_19->addErrorMessage($this->description_19->getErrorMessage(false));
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->cbm->Visible && $this->cbm->Required) {
                if (!$this->cbm->IsDetailKey && EmptyValue($this->cbm->FormValue)) {
                    $this->cbm->addErrorMessage(str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->cbm->FormValue)) {
                $this->cbm->addErrorMessage($this->cbm->getErrorMessage(false));
            }
            if ($this->buyer_size->Visible && $this->buyer_size->Required) {
                if (!$this->buyer_size->IsDetailKey && EmptyValue($this->buyer_size->FormValue)) {
                    $this->buyer_size->addErrorMessage(str_replace("%s", $this->buyer_size->caption(), $this->buyer_size->RequiredErrorMessage));
                }
            }
            if ($this->description_05->Visible && $this->description_05->Required) {
                if (!$this->description_05->IsDetailKey && EmptyValue($this->description_05->FormValue)) {
                    $this->description_05->addErrorMessage(str_replace("%s", $this->description_05->caption(), $this->description_05->RequiredErrorMessage));
                }
            }
            if ($this->description_06->Visible && $this->description_06->Required) {
                if (!$this->description_06->IsDetailKey && EmptyValue($this->description_06->FormValue)) {
                    $this->description_06->addErrorMessage(str_replace("%s", $this->description_06->caption(), $this->description_06->RequiredErrorMessage));
                }
            }
            if ($this->description_08->Visible && $this->description_08->Required) {
                if (!$this->description_08->IsDetailKey && EmptyValue($this->description_08->FormValue)) {
                    $this->description_08->addErrorMessage(str_replace("%s", $this->description_08->caption(), $this->description_08->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->description_08->FormValue)) {
                $this->description_08->addErrorMessage($this->description_08->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->buyer_instruction->Visible && $this->buyer_instruction->Required) {
                if (!$this->buyer_instruction->IsDetailKey && EmptyValue($this->buyer_instruction->FormValue)) {
                    $this->buyer_instruction->addErrorMessage(str_replace("%s", $this->buyer_instruction->caption(), $this->buyer_instruction->RequiredErrorMessage));
                }
            }
            if ($this->d_09_head->Visible && $this->d_09_head->Required) {
                if (!$this->d_09_head->IsDetailKey && EmptyValue($this->d_09_head->FormValue)) {
                    $this->d_09_head->addErrorMessage(str_replace("%s", $this->d_09_head->caption(), $this->d_09_head->RequiredErrorMessage));
                }
            }
            if ($this->description_09->Visible && $this->description_09->Required) {
                if (!$this->description_09->IsDetailKey && EmptyValue($this->description_09->FormValue)) {
                    $this->description_09->addErrorMessage(str_replace("%s", $this->description_09->caption(), $this->description_09->RequiredErrorMessage));
                }
            }
            if ($this->d_10_head->Visible && $this->d_10_head->Required) {
                if (!$this->d_10_head->IsDetailKey && EmptyValue($this->d_10_head->FormValue)) {
                    $this->d_10_head->addErrorMessage(str_replace("%s", $this->d_10_head->caption(), $this->d_10_head->RequiredErrorMessage));
                }
            }
            if ($this->description_10->Visible && $this->description_10->Required) {
                if (!$this->description_10->IsDetailKey && EmptyValue($this->description_10->FormValue)) {
                    $this->description_10->addErrorMessage(str_replace("%s", $this->description_10->caption(), $this->description_10->RequiredErrorMessage));
                }
            }
            if ($this->d_11_head->Visible && $this->d_11_head->Required) {
                if (!$this->d_11_head->IsDetailKey && EmptyValue($this->d_11_head->FormValue)) {
                    $this->d_11_head->addErrorMessage(str_replace("%s", $this->d_11_head->caption(), $this->d_11_head->RequiredErrorMessage));
                }
            }
            if ($this->description_11->Visible && $this->description_11->Required) {
                if (!$this->description_11->IsDetailKey && EmptyValue($this->description_11->FormValue)) {
                    $this->description_11->addErrorMessage(str_replace("%s", $this->description_11->caption(), $this->description_11->RequiredErrorMessage));
                }
            }
            if ($this->d_12_head->Visible && $this->d_12_head->Required) {
                if (!$this->d_12_head->IsDetailKey && EmptyValue($this->d_12_head->FormValue)) {
                    $this->d_12_head->addErrorMessage(str_replace("%s", $this->d_12_head->caption(), $this->d_12_head->RequiredErrorMessage));
                }
            }
            if ($this->description_12->Visible && $this->description_12->Required) {
                if (!$this->description_12->IsDetailKey && EmptyValue($this->description_12->FormValue)) {
                    $this->description_12->addErrorMessage(str_replace("%s", $this->description_12->caption(), $this->description_12->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // order_type
        $this->order_type->setDbValueDef($rsnew, $this->order_type->CurrentValue, $this->order_type->ReadOnly);

        // buyer_id
        $this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, $this->buyer_id->ReadOnly);

        // buyer_order_no
        $this->buyer_order_no->setDbValueDef($rsnew, $this->buyer_order_no->CurrentValue, $this->buyer_order_no->ReadOnly);

        // buyer_order_date
        $this->buyer_order_date->setDbValueDef($rsnew, UnFormatDateTime($this->buyer_order_date->CurrentValue, $this->buyer_order_date->formatPattern()), $this->buyer_order_date->ReadOnly);

        // cart_id
        $this->cart_id->setDbValueDef($rsnew, $this->cart_id->CurrentValue, $this->cart_id->ReadOnly);

        // buyer_product_ref
        $this->buyer_product_ref->setDbValueDef($rsnew, $this->buyer_product_ref->CurrentValue, $this->buyer_product_ref->ReadOnly);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, $this->s_grp->ReadOnly);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, $this->product->ReadOnly);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, $this->rid->ReadOnly);

        // despatch_date
        $this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()), $this->despatch_date->ReadOnly);

        // despatch_week
        $this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, $this->despatch_week->ReadOnly);

        // fob_date
        $this->fob_date->setDbValueDef($rsnew, UnFormatDateTime($this->fob_date->CurrentValue, $this->fob_date->formatPattern()), $this->fob_date->ReadOnly);

        // part_dispatch
        $this->part_dispatch->setDbValueDef($rsnew, $this->part_dispatch->CurrentValue, $this->part_dispatch->ReadOnly);

        // payment_terms
        $this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, $this->payment_terms->ReadOnly);

        // transport_terms
        $this->transport_terms->setDbValueDef($rsnew, $this->transport_terms->CurrentValue, $this->transport_terms->ReadOnly);

        // buyer_shipping _id
        $this->buyer_shipping_id->setDbValueDef($rsnew, $this->buyer_shipping_id->CurrentValue, $this->buyer_shipping_id->ReadOnly);

        // description_04
        $this->description_04->setDbValueDef($rsnew, $this->description_04->CurrentValue, $this->description_04->ReadOnly);

        // description_03
        $this->description_03->setDbValueDef($rsnew, $this->description_03->CurrentValue, $this->description_03->ReadOnly);

        // description_01
        $this->description_01->setDbValueDef($rsnew, $this->description_01->CurrentValue, $this->description_01->ReadOnly);

        // description_02
        $this->description_02->setDbValueDef($rsnew, $this->description_02->CurrentValue, $this->description_02->ReadOnly);

        // description_07
        $this->description_07->setDbValueDef($rsnew, $this->description_07->CurrentValue, $this->description_07->ReadOnly);

        // description_20
        $this->description_20->setDbValueDef($rsnew, $this->description_20->CurrentValue, $this->description_20->ReadOnly);

        // description_17
        $this->description_17->setDbValueDef($rsnew, $this->description_17->CurrentValue, $this->description_17->ReadOnly);

        // description_18
        $this->description_18->setDbValueDef($rsnew, $this->description_18->CurrentValue, $this->description_18->ReadOnly);

        // description_19
        $this->description_19->setDbValueDef($rsnew, $this->description_19->CurrentValue, $this->description_19->ReadOnly);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, $this->quantity->ReadOnly);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, $this->price->ReadOnly);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, $this->currency->ReadOnly);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, $this->amount->ReadOnly);

        // cbm
        $this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, $this->cbm->ReadOnly);

        // buyer_size
        $this->buyer_size->setDbValueDef($rsnew, $this->buyer_size->CurrentValue, $this->buyer_size->ReadOnly);

        // description_05
        $this->description_05->setDbValueDef($rsnew, $this->description_05->CurrentValue, $this->description_05->ReadOnly);

        // description_06
        $this->description_06->setDbValueDef($rsnew, $this->description_06->CurrentValue, $this->description_06->ReadOnly);

        // description_08
        $this->description_08->setDbValueDef($rsnew, $this->description_08->CurrentValue, $this->description_08->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // buyer_instruction
        $this->buyer_instruction->setDbValueDef($rsnew, $this->buyer_instruction->CurrentValue, $this->buyer_instruction->ReadOnly);

        // d_09_head
        $this->d_09_head->setDbValueDef($rsnew, $this->d_09_head->CurrentValue, $this->d_09_head->ReadOnly);

        // description_09
        $this->description_09->setDbValueDef($rsnew, $this->description_09->CurrentValue, $this->description_09->ReadOnly);

        // d_10_head
        $this->d_10_head->setDbValueDef($rsnew, $this->d_10_head->CurrentValue, $this->d_10_head->ReadOnly);

        // description_10
        $this->description_10->setDbValueDef($rsnew, $this->description_10->CurrentValue, $this->description_10->ReadOnly);

        // d_11_head
        $this->d_11_head->setDbValueDef($rsnew, $this->d_11_head->CurrentValue, $this->d_11_head->ReadOnly);

        // description_11
        $this->description_11->setDbValueDef($rsnew, $this->description_11->CurrentValue, $this->description_11->ReadOnly);

        // d_12_head
        $this->d_12_head->setDbValueDef($rsnew, $this->d_12_head->CurrentValue, $this->d_12_head->ReadOnly);

        // description_12
        $this->description_12->setDbValueDef($rsnew, $this->description_12->CurrentValue, $this->description_12->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['order_type'])) { // order_type
            $this->order_type->CurrentValue = $row['order_type'];
        }
        if (isset($row['buyer_id'])) { // buyer_id
            $this->buyer_id->CurrentValue = $row['buyer_id'];
        }
        if (isset($row['buyer_order_no'])) { // buyer_order_no
            $this->buyer_order_no->CurrentValue = $row['buyer_order_no'];
        }
        if (isset($row['buyer_order_date'])) { // buyer_order_date
            $this->buyer_order_date->CurrentValue = $row['buyer_order_date'];
        }
        if (isset($row['cart_id'])) { // cart_id
            $this->cart_id->CurrentValue = $row['cart_id'];
        }
        if (isset($row['buyer_product_ref'])) { // buyer_product_ref
            $this->buyer_product_ref->CurrentValue = $row['buyer_product_ref'];
        }
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->CurrentValue = $row['s_grp'];
        }
        if (isset($row['product'])) { // product
            $this->product->CurrentValue = $row['product'];
        }
        if (isset($row['rid'])) { // rid
            $this->rid->CurrentValue = $row['rid'];
        }
        if (isset($row['despatch_date'])) { // despatch_date
            $this->despatch_date->CurrentValue = $row['despatch_date'];
        }
        if (isset($row['despatch_week'])) { // despatch_week
            $this->despatch_week->CurrentValue = $row['despatch_week'];
        }
        if (isset($row['fob_date'])) { // fob_date
            $this->fob_date->CurrentValue = $row['fob_date'];
        }
        if (isset($row['part_dispatch'])) { // part_dispatch
            $this->part_dispatch->CurrentValue = $row['part_dispatch'];
        }
        if (isset($row['payment_terms'])) { // payment_terms
            $this->payment_terms->CurrentValue = $row['payment_terms'];
        }
        if (isset($row['transport_terms'])) { // transport_terms
            $this->transport_terms->CurrentValue = $row['transport_terms'];
        }
        if (isset($row['buyer_shipping _id'])) { // buyer_shipping _id
            $this->buyer_shipping_id->CurrentValue = $row['buyer_shipping _id'];
        }
        if (isset($row['description_04'])) { // description_04
            $this->description_04->CurrentValue = $row['description_04'];
        }
        if (isset($row['description_03'])) { // description_03
            $this->description_03->CurrentValue = $row['description_03'];
        }
        if (isset($row['description_01'])) { // description_01
            $this->description_01->CurrentValue = $row['description_01'];
        }
        if (isset($row['description_02'])) { // description_02
            $this->description_02->CurrentValue = $row['description_02'];
        }
        if (isset($row['description_07'])) { // description_07
            $this->description_07->CurrentValue = $row['description_07'];
        }
        if (isset($row['description_20'])) { // description_20
            $this->description_20->CurrentValue = $row['description_20'];
        }
        if (isset($row['description_17'])) { // description_17
            $this->description_17->CurrentValue = $row['description_17'];
        }
        if (isset($row['description_18'])) { // description_18
            $this->description_18->CurrentValue = $row['description_18'];
        }
        if (isset($row['description_19'])) { // description_19
            $this->description_19->CurrentValue = $row['description_19'];
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->CurrentValue = $row['quantity'];
        }
        if (isset($row['price'])) { // price
            $this->price->CurrentValue = $row['price'];
        }
        if (isset($row['currency'])) { // currency
            $this->currency->CurrentValue = $row['currency'];
        }
        if (isset($row['amount'])) { // amount
            $this->amount->CurrentValue = $row['amount'];
        }
        if (isset($row['cbm'])) { // cbm
            $this->cbm->CurrentValue = $row['cbm'];
        }
        if (isset($row['buyer_size'])) { // buyer_size
            $this->buyer_size->CurrentValue = $row['buyer_size'];
        }
        if (isset($row['description_05'])) { // description_05
            $this->description_05->CurrentValue = $row['description_05'];
        }
        if (isset($row['description_06'])) { // description_06
            $this->description_06->CurrentValue = $row['description_06'];
        }
        if (isset($row['description_08'])) { // description_08
            $this->description_08->CurrentValue = $row['description_08'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['buyer_instruction'])) { // buyer_instruction
            $this->buyer_instruction->CurrentValue = $row['buyer_instruction'];
        }
        if (isset($row['d_09_head'])) { // d_09_head
            $this->d_09_head->CurrentValue = $row['d_09_head'];
        }
        if (isset($row['description_09'])) { // description_09
            $this->description_09->CurrentValue = $row['description_09'];
        }
        if (isset($row['d_10_head'])) { // d_10_head
            $this->d_10_head->CurrentValue = $row['d_10_head'];
        }
        if (isset($row['description_10'])) { // description_10
            $this->description_10->CurrentValue = $row['description_10'];
        }
        if (isset($row['d_11_head'])) { // d_11_head
            $this->d_11_head->CurrentValue = $row['d_11_head'];
        }
        if (isset($row['description_11'])) { // description_11
            $this->description_11->CurrentValue = $row['description_11'];
        }
        if (isset($row['d_12_head'])) { // d_12_head
            $this->d_12_head->CurrentValue = $row['d_12_head'];
        }
        if (isset($row['description_12'])) { // description_12
            $this->description_12->CurrentValue = $row['description_12'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("polist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_order_type":
                    break;
                case "x_buyer_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cart_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    break;
                case "x_part_dispatch":
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_04":
                    break;
                case "x_description_03":
                    break;
                case "x_description_20":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                case "x_d_09_head":
                    break;
                case "x_d_10_head":
                    break;
                case "x_d_11_head":
                    break;
                case "x_d_12_head":
                    break;
                case "x_production_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_production_plan":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'po');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
