<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PoBWbcAdd extends PoBWbc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PoBWbcAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "pobwbcadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->company_id->setVisibility();
        $this->grp->setVisibility();
        $this->reports_to->Visible = false;
        $this->s_grp->Visible = false;
        $this->location->setVisibility();
        $this->po->setVisibility();
        $this->partner_id->setVisibility();
        $this->cart_id->setVisibility();
        $this->quantity->setVisibility();
        $this->amount->setVisibility();
        $this->gst->setVisibility();
        $this->partner_order_no->setVisibility();
        $this->partner_order_date->setVisibility();
        $this->despatch_date->setVisibility();
        $this->despatch_week->setVisibility();
        $this->fob_date->setVisibility();
        $this->production_plan->setVisibility();
        $this->part_dispatch->setVisibility();
        $this->payment_terms->setVisibility();
        $this->transport_type->setVisibility();
        $this->partner_shipping_id->setVisibility();
        $this->remarks->setVisibility();
        $this->buyer_instruction->setVisibility();
        $this->uploads->setVisibility();
        $this->description_01->Visible = false;
        $this->description_02->Visible = false;
        $this->description_03->Visible = false;
        $this->description_04->Visible = false;
        $this->description_05->Visible = false;
        $this->description_06->Visible = false;
        $this->description_07->Visible = false;
        $this->description_08->Visible = false;
        $this->d_09_head->setVisibility();
        $this->description_09->setVisibility();
        $this->d_10_head->setVisibility();
        $this->description_10->setVisibility();
        $this->d_11_head->Visible = false;
        $this->description_11->Visible = false;
        $this->d_12_head->Visible = false;
        $this->description_12->Visible = false;
        $this->description_17->Visible = false;
        $this->description_18->Visible = false;
        $this->description_19->Visible = false;
        $this->description_20->Visible = false;
        $this->production_site->Visible = false;
        $this->jc_no->Visible = false;
        $this->__request->Visible = false;
        $this->balance_quantity->Visible = false;
        $this->operator->setVisibility();
        $this->e_mail->Visible = false;
        $this->billing_address_id->Visible = false;
        $this->shipping_address_id->Visible = false;
        $this->status->Visible = false;
        $this->datetime->setVisibility();
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
        $this->app_operator->Visible = false;
        $this->app_datetime->Visible = false;
        $this->c_operator->Visible = false;
        $this->c_datetime->Visible = false;
        $this->sqm->Visible = false;
        $this->cbm->Visible = false;
        $this->grp_type->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'po_b_wbc';
        $this->TableName = 'po_b_wbc';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (po_b_wbc)
        if (!isset($GLOBALS["po_b_wbc"]) || $GLOBALS["po_b_wbc"]::class == PROJECT_NAMESPACE . "po_b_wbc") {
            $GLOBALS["po_b_wbc"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_b_wbc');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "pobwbcview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->cart_id);
        $this->setupLookupOptions($this->gst);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->part_dispatch);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->transport_type);
        $this->setupLookupOptions($this->partner_shipping_id);
        $this->setupLookupOptions($this->description_03);
        $this->setupLookupOptions($this->description_04);
        $this->setupLookupOptions($this->description_05);
        $this->setupLookupOptions($this->d_09_head);
        $this->setupLookupOptions($this->d_10_head);
        $this->setupLookupOptions($this->d_11_head);
        $this->setupLookupOptions($this->d_12_head);
        $this->setupLookupOptions($this->description_20);
        $this->setupLookupOptions($this->production_site);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->a_operator);
        $this->setupLookupOptions($this->app_operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("pobwbclist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = 'autoprogramme?apcid=3e89ebdb49f712c7d90d1b39e348bbbf&type=sp&rurl=pobwbc';

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "pobwbclist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "pobwbclist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->location->DefaultValue = $this->location->getDefault(); // PHP
        $this->location->OldValue = $this->location->DefaultValue;
        $this->po->DefaultValue = $this->po->getDefault(); // PHP
        $this->po->OldValue = $this->po->DefaultValue;
        $this->partner_id->DefaultValue = $this->partner_id->getDefault(); // PHP
        $this->partner_id->OldValue = $this->partner_id->DefaultValue;
        $this->cart_id->DefaultValue = $this->cart_id->getDefault(); // PHP
        $this->cart_id->OldValue = $this->cart_id->DefaultValue;
        $this->gst->DefaultValue = $this->gst->getDefault(); // PHP
        $this->gst->OldValue = $this->gst->DefaultValue;
        $this->partner_order_date->DefaultValue = $this->partner_order_date->getDefault(); // PHP
        $this->partner_order_date->OldValue = $this->partner_order_date->DefaultValue;
        $this->despatch_week->DefaultValue = $this->despatch_week->getDefault(); // PHP
        $this->despatch_week->OldValue = $this->despatch_week->DefaultValue;
        $this->description_03->DefaultValue = $this->description_03->getDefault(); // PHP
        $this->description_03->OldValue = $this->description_03->DefaultValue;
        $this->description_04->DefaultValue = $this->description_04->getDefault(); // PHP
        $this->description_04->OldValue = $this->description_04->DefaultValue;
        $this->description_20->DefaultValue = $this->description_20->getDefault(); // PHP
        $this->description_20->OldValue = $this->description_20->DefaultValue;
        $this->balance_quantity->DefaultValue = $this->balance_quantity->getDefault(); // PHP
        $this->balance_quantity->OldValue = $this->balance_quantity->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->e_mail->DefaultValue = $this->e_mail->getDefault(); // PHP
        $this->e_mail->OldValue = $this->e_mail->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'partner_id' first before field var 'x_partner_id'
        $val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
        if (!$this->partner_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'cart_id' first before field var 'x_cart_id'
        $val = $CurrentForm->hasValue("cart_id") ? $CurrentForm->getValue("cart_id") : $CurrentForm->getValue("x_cart_id");
        if (!$this->cart_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cart_id->Visible = false; // Disable update for API request
            } else {
                $this->cart_id->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val);
            }
        }

        // Check field name 'gst' first before field var 'x_gst'
        $val = $CurrentForm->hasValue("gst") ? $CurrentForm->getValue("gst") : $CurrentForm->getValue("x_gst");
        if (!$this->gst->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gst->Visible = false; // Disable update for API request
            } else {
                $this->gst->setFormValue($val);
            }
        }

        // Check field name 'partner_order_no' first before field var 'x_partner_order_no'
        $val = $CurrentForm->hasValue("partner_order_no") ? $CurrentForm->getValue("partner_order_no") : $CurrentForm->getValue("x_partner_order_no");
        if (!$this->partner_order_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_order_no->Visible = false; // Disable update for API request
            } else {
                $this->partner_order_no->setFormValue($val);
            }
        }

        // Check field name 'partner_order_date' first before field var 'x_partner_order_date'
        $val = $CurrentForm->hasValue("partner_order_date") ? $CurrentForm->getValue("partner_order_date") : $CurrentForm->getValue("x_partner_order_date");
        if (!$this->partner_order_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_order_date->Visible = false; // Disable update for API request
            } else {
                $this->partner_order_date->setFormValue($val, true, $validate);
            }
            $this->partner_order_date->CurrentValue = UnFormatDateTime($this->partner_order_date->CurrentValue, $this->partner_order_date->formatPattern());
        }

        // Check field name 'despatch_date' first before field var 'x_despatch_date'
        $val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
        if (!$this->despatch_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_date->Visible = false; // Disable update for API request
            } else {
                $this->despatch_date->setFormValue($val, true, $validate);
            }
            $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        }

        // Check field name 'despatch_week' first before field var 'x_despatch_week'
        $val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
        if (!$this->despatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_week->Visible = false; // Disable update for API request
            } else {
                $this->despatch_week->setFormValue($val);
            }
        }

        // Check field name 'fob_date' first before field var 'x_fob_date'
        $val = $CurrentForm->hasValue("fob_date") ? $CurrentForm->getValue("fob_date") : $CurrentForm->getValue("x_fob_date");
        if (!$this->fob_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fob_date->Visible = false; // Disable update for API request
            } else {
                $this->fob_date->setFormValue($val, true, $validate);
            }
            $this->fob_date->CurrentValue = UnFormatDateTime($this->fob_date->CurrentValue, $this->fob_date->formatPattern());
        }

        // Check field name 'production_plan' first before field var 'x_production_plan'
        $val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
        if (!$this->production_plan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->production_plan->Visible = false; // Disable update for API request
            } else {
                $this->production_plan->setFormValue($val);
            }
        }

        // Check field name 'part_dispatch' first before field var 'x_part_dispatch'
        $val = $CurrentForm->hasValue("part_dispatch") ? $CurrentForm->getValue("part_dispatch") : $CurrentForm->getValue("x_part_dispatch");
        if (!$this->part_dispatch->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->part_dispatch->Visible = false; // Disable update for API request
            } else {
                $this->part_dispatch->setFormValue($val);
            }
        }

        // Check field name 'payment_terms' first before field var 'x_payment_terms'
        $val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
        if (!$this->payment_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_terms->Visible = false; // Disable update for API request
            } else {
                $this->payment_terms->setFormValue($val);
            }
        }

        // Check field name 'transport_type' first before field var 'x_transport_type'
        $val = $CurrentForm->hasValue("transport_type") ? $CurrentForm->getValue("transport_type") : $CurrentForm->getValue("x_transport_type");
        if (!$this->transport_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->transport_type->Visible = false; // Disable update for API request
            } else {
                $this->transport_type->setFormValue($val);
            }
        }

        // Check field name 'partner_shipping_id' first before field var 'x_partner_shipping_id'
        $val = $CurrentForm->hasValue("partner_shipping_id") ? $CurrentForm->getValue("partner_shipping_id") : $CurrentForm->getValue("x_partner_shipping_id");
        if (!$this->partner_shipping_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_shipping_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_shipping_id->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'buyer_instruction' first before field var 'x_buyer_instruction'
        $val = $CurrentForm->hasValue("buyer_instruction") ? $CurrentForm->getValue("buyer_instruction") : $CurrentForm->getValue("x_buyer_instruction");
        if (!$this->buyer_instruction->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_instruction->Visible = false; // Disable update for API request
            } else {
                $this->buyer_instruction->setFormValue($val);
            }
        }

        // Check field name 'd_09_head' first before field var 'x_d_09_head'
        $val = $CurrentForm->hasValue("d_09_head") ? $CurrentForm->getValue("d_09_head") : $CurrentForm->getValue("x_d_09_head");
        if (!$this->d_09_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_09_head->Visible = false; // Disable update for API request
            } else {
                $this->d_09_head->setFormValue($val);
            }
        }

        // Check field name 'description_09' first before field var 'x_description_09'
        $val = $CurrentForm->hasValue("description_09") ? $CurrentForm->getValue("description_09") : $CurrentForm->getValue("x_description_09");
        if (!$this->description_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_09->Visible = false; // Disable update for API request
            } else {
                $this->description_09->setFormValue($val);
            }
        }

        // Check field name 'd_10_head' first before field var 'x_d_10_head'
        $val = $CurrentForm->hasValue("d_10_head") ? $CurrentForm->getValue("d_10_head") : $CurrentForm->getValue("x_d_10_head");
        if (!$this->d_10_head->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_10_head->Visible = false; // Disable update for API request
            } else {
                $this->d_10_head->setFormValue($val);
            }
        }

        // Check field name 'description_10' first before field var 'x_description_10'
        $val = $CurrentForm->hasValue("description_10") ? $CurrentForm->getValue("description_10") : $CurrentForm->getValue("x_description_10");
        if (!$this->description_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_10->Visible = false; // Disable update for API request
            } else {
                $this->description_10->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
		$this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->location->CurrentValue = $this->location->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->partner_id->CurrentValue = $this->partner_id->FormValue;
        $this->cart_id->CurrentValue = $this->cart_id->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->gst->CurrentValue = $this->gst->FormValue;
        $this->partner_order_no->CurrentValue = $this->partner_order_no->FormValue;
        $this->partner_order_date->CurrentValue = $this->partner_order_date->FormValue;
        $this->partner_order_date->CurrentValue = UnFormatDateTime($this->partner_order_date->CurrentValue, $this->partner_order_date->formatPattern());
        $this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
        $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
        $this->fob_date->CurrentValue = $this->fob_date->FormValue;
        $this->fob_date->CurrentValue = UnFormatDateTime($this->fob_date->CurrentValue, $this->fob_date->formatPattern());
        $this->production_plan->CurrentValue = $this->production_plan->FormValue;
        $this->part_dispatch->CurrentValue = $this->part_dispatch->FormValue;
        $this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
        $this->transport_type->CurrentValue = $this->transport_type->FormValue;
        $this->partner_shipping_id->CurrentValue = $this->partner_shipping_id->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->buyer_instruction->CurrentValue = $this->buyer_instruction->FormValue;
        $this->d_09_head->CurrentValue = $this->d_09_head->FormValue;
        $this->description_09->CurrentValue = $this->description_09->FormValue;
        $this->d_10_head->CurrentValue = $this->d_10_head->FormValue;
        $this->description_10->CurrentValue = $this->description_10->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->company_id->setDbValue($row['company_id']);
        $this->grp->setDbValue($row['grp']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->location->setDbValue($row['location']);
        $this->po->setDbValue($row['po']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->quantity->setDbValue($row['quantity']);
        $this->amount->setDbValue($row['amount']);
        $this->gst->setDbValue($row['gst']);
        $this->partner_order_no->setDbValue($row['partner_order_no']);
        $this->partner_order_date->setDbValue($row['partner_order_date']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->fob_date->setDbValue($row['fob_date']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->part_dispatch->setDbValue($row['part_dispatch']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->transport_type->setDbValue($row['transport_type']);
        $this->partner_shipping_id->setDbValue($row['partner_shipping_id']);
        $this->remarks->setDbValue($row['remarks']);
        $this->buyer_instruction->setDbValue($row['buyer_instruction']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->description_01->setDbValue($row['description_01']);
        $this->description_02->setDbValue($row['description_02']);
        $this->description_03->setDbValue($row['description_03']);
        $this->description_04->setDbValue($row['description_04']);
        $this->description_05->setDbValue($row['description_05']);
        $this->description_06->setDbValue($row['description_06']);
        $this->description_07->setDbValue($row['description_07']);
        $this->description_08->setDbValue($row['description_08']);
        $this->d_09_head->setDbValue($row['d_09_head']);
        $this->description_09->setDbValue($row['description_09']);
        $this->d_10_head->setDbValue($row['d_10_head']);
        $this->description_10->setDbValue($row['description_10']);
        $this->d_11_head->setDbValue($row['d_11_head']);
        $this->description_11->setDbValue($row['description_11']);
        $this->d_12_head->setDbValue($row['d_12_head']);
        $this->description_12->setDbValue($row['description_12']);
        $this->description_17->setDbValue($row['description_17']);
        $this->description_18->setDbValue($row['description_18']);
        $this->description_19->setDbValue($row['description_19']);
        $this->description_20->setDbValue($row['description_20']);
        $this->production_site->setDbValue($row['production_site']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->__request->setDbValue($row['request']);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->operator->setDbValue($row['operator']);
        $this->e_mail->setDbValue($row['e_mail']);
        $this->billing_address_id->setDbValue($row['billing_address_id']);
        $this->shipping_address_id->setDbValue($row['shipping_address_id']);
        $this->status->setDbValue($row['status']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->app_operator->setDbValue($row['app_operator']);
        $this->app_datetime->setDbValue($row['app_datetime']);
        $this->c_operator->setDbValue($row['c_operator']);
        $this->c_datetime->setDbValue($row['c_datetime']);
        $this->sqm->setDbValue($row['sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->grp_type->setDbValue($row['grp_type']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['cart_id'] = $this->cart_id->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['gst'] = $this->gst->DefaultValue;
        $row['partner_order_no'] = $this->partner_order_no->DefaultValue;
        $row['partner_order_date'] = $this->partner_order_date->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['fob_date'] = $this->fob_date->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['part_dispatch'] = $this->part_dispatch->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['transport_type'] = $this->transport_type->DefaultValue;
        $row['partner_shipping_id'] = $this->partner_shipping_id->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['buyer_instruction'] = $this->buyer_instruction->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['description_01'] = $this->description_01->DefaultValue;
        $row['description_02'] = $this->description_02->DefaultValue;
        $row['description_03'] = $this->description_03->DefaultValue;
        $row['description_04'] = $this->description_04->DefaultValue;
        $row['description_05'] = $this->description_05->DefaultValue;
        $row['description_06'] = $this->description_06->DefaultValue;
        $row['description_07'] = $this->description_07->DefaultValue;
        $row['description_08'] = $this->description_08->DefaultValue;
        $row['d_09_head'] = $this->d_09_head->DefaultValue;
        $row['description_09'] = $this->description_09->DefaultValue;
        $row['d_10_head'] = $this->d_10_head->DefaultValue;
        $row['description_10'] = $this->description_10->DefaultValue;
        $row['d_11_head'] = $this->d_11_head->DefaultValue;
        $row['description_11'] = $this->description_11->DefaultValue;
        $row['d_12_head'] = $this->d_12_head->DefaultValue;
        $row['description_12'] = $this->description_12->DefaultValue;
        $row['description_17'] = $this->description_17->DefaultValue;
        $row['description_18'] = $this->description_18->DefaultValue;
        $row['description_19'] = $this->description_19->DefaultValue;
        $row['description_20'] = $this->description_20->DefaultValue;
        $row['production_site'] = $this->production_site->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['request'] = $this->__request->DefaultValue;
        $row['balance_quantity'] = $this->balance_quantity->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['e_mail'] = $this->e_mail->DefaultValue;
        $row['billing_address_id'] = $this->billing_address_id->DefaultValue;
        $row['shipping_address_id'] = $this->shipping_address_id->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['app_operator'] = $this->app_operator->DefaultValue;
        $row['app_datetime'] = $this->app_datetime->DefaultValue;
        $row['c_operator'] = $this->c_operator->DefaultValue;
        $row['c_datetime'] = $this->c_datetime->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['grp_type'] = $this->grp_type->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // cart_id
        $this->cart_id->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // gst
        $this->gst->RowCssClass = "row";

        // partner_order_no
        $this->partner_order_no->RowCssClass = "row";

        // partner_order_date
        $this->partner_order_date->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // fob_date
        $this->fob_date->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // part_dispatch
        $this->part_dispatch->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // transport_type
        $this->transport_type->RowCssClass = "row";

        // partner_shipping_id
        $this->partner_shipping_id->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // buyer_instruction
        $this->buyer_instruction->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // description_01
        $this->description_01->RowCssClass = "row";

        // description_02
        $this->description_02->RowCssClass = "row";

        // description_03
        $this->description_03->RowCssClass = "row";

        // description_04
        $this->description_04->RowCssClass = "row";

        // description_05
        $this->description_05->RowCssClass = "row";

        // description_06
        $this->description_06->RowCssClass = "row";

        // description_07
        $this->description_07->RowCssClass = "row";

        // description_08
        $this->description_08->RowCssClass = "row";

        // d_09_head
        $this->d_09_head->RowCssClass = "row";

        // description_09
        $this->description_09->RowCssClass = "row";

        // d_10_head
        $this->d_10_head->RowCssClass = "row";

        // description_10
        $this->description_10->RowCssClass = "row";

        // d_11_head
        $this->d_11_head->RowCssClass = "row";

        // description_11
        $this->description_11->RowCssClass = "row";

        // d_12_head
        $this->d_12_head->RowCssClass = "row";

        // description_12
        $this->description_12->RowCssClass = "row";

        // description_17
        $this->description_17->RowCssClass = "row";

        // description_18
        $this->description_18->RowCssClass = "row";

        // description_19
        $this->description_19->RowCssClass = "row";

        // description_20
        $this->description_20->RowCssClass = "row";

        // production_site
        $this->production_site->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // request
        $this->__request->RowCssClass = "row";

        // balance_quantity
        $this->balance_quantity->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // e_mail
        $this->e_mail->RowCssClass = "row";

        // billing_address_id
        $this->billing_address_id->RowCssClass = "row";

        // shipping_address_id
        $this->shipping_address_id->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // app_operator
        $this->app_operator->RowCssClass = "row";

        // app_datetime
        $this->app_datetime->RowCssClass = "row";

        // c_operator
        $this->c_operator->RowCssClass = "row";

        // c_datetime
        $this->c_datetime->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // grp_type
        $this->grp_type->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // cart_id
            $curVal = strval($this->cart_id->CurrentValue);
            if ($curVal != "") {
                $this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
                if ($this->cart_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->cart_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->cart_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->cart_id->Lookup->renderViewRow($row);
                            $this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
                        }
                    } else {
                        $this->cart_id->ViewValue = $this->cart_id->CurrentValue;
                    }
                }
            } else {
                $this->cart_id->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;

            // gst
            $curVal = strval($this->gst->CurrentValue);
            if ($curVal != "") {
                $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
                if ($this->gst->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                    $sqlWrk = $this->gst->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->gst->Lookup->renderViewRow($rswrk[0]);
                        $this->gst->ViewValue = $this->gst->displayValue($arwrk);
                    } else {
                        $this->gst->ViewValue = FormatNumber($this->gst->CurrentValue, $this->gst->formatPattern());
                    }
                }
            } else {
                $this->gst->ViewValue = null;
            }

            // partner_order_no
            $this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;

            // partner_order_date
            $this->partner_order_date->ViewValue = $this->partner_order_date->CurrentValue;
            $this->partner_order_date->ViewValue = FormatDateTime($this->partner_order_date->ViewValue, $this->partner_order_date->formatPattern());

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->despatch_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // fob_date
            $this->fob_date->ViewValue = $this->fob_date->CurrentValue;
            $this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, $this->fob_date->formatPattern());

            // production_plan
            $curVal = strval($this->production_plan->CurrentValue);
            if ($curVal != "") {
                $this->production_plan->ViewValue = $this->production_plan->lookupCacheOption($curVal);
                if ($this->production_plan->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->production_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->production_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->production_plan->getSelectFilter($this); // PHP
                    $sqlWrk = $this->production_plan->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->production_plan->Lookup->renderViewRow($rswrk[0]);
                        $this->production_plan->ViewValue = $this->production_plan->displayValue($arwrk);
                    } else {
                        $this->production_plan->ViewValue = $this->production_plan->CurrentValue;
                    }
                }
            } else {
                $this->production_plan->ViewValue = null;
            }

            // part_dispatch
            if (strval($this->part_dispatch->CurrentValue) != "") {
                $this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
            } else {
                $this->part_dispatch->ViewValue = null;
            }

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // transport_type
            $curVal = strval($this->transport_type->CurrentValue);
            if ($curVal != "") {
                $this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
                if ($this->transport_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->transport_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->transport_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->transport_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->transport_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->transport_type->Lookup->renderViewRow($rswrk[0]);
                        $this->transport_type->ViewValue = $this->transport_type->displayValue($arwrk);
                    } else {
                        $this->transport_type->ViewValue = $this->transport_type->CurrentValue;
                    }
                }
            } else {
                $this->transport_type->ViewValue = null;
            }

            // partner_shipping_id
            $curVal = strval($this->partner_shipping_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
                if ($this->partner_shipping_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_shipping_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_shipping_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_shipping_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->displayValue($arwrk);
                    } else {
                        $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_shipping_id->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // buyer_instruction
            $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }
            $this->uploads->CssClass = "fst-italic";

            // d_09_head
            $curVal = strval($this->d_09_head->CurrentValue);
            if ($curVal != "") {
                $this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
                if ($this->d_09_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_09_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_09_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
                    } else {
                        $this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
                    }
                }
            } else {
                $this->d_09_head->ViewValue = null;
            }

            // description_09
            $this->description_09->ViewValue = $this->description_09->CurrentValue;

            // d_10_head
            $curVal = strval($this->d_10_head->CurrentValue);
            if ($curVal != "") {
                $this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
                if ($this->d_10_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_10_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_10_head->Lookup->renderViewRow($rswrk[0]);
                        $this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
                    } else {
                        $this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
                    }
                }
            } else {
                $this->d_10_head->ViewValue = null;
            }

            // description_10
            $this->description_10->ViewValue = $this->description_10->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // app_operator
            $curVal = strval($this->app_operator->CurrentValue);
            if ($curVal != "") {
                $this->app_operator->ViewValue = $this->app_operator->lookupCacheOption($curVal);
                if ($this->app_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->app_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->app_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->app_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->app_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->app_operator->ViewValue = $this->app_operator->displayValue($arwrk);
                    } else {
                        $this->app_operator->ViewValue = FormatNumber($this->app_operator->CurrentValue, $this->app_operator->formatPattern());
                    }
                }
            } else {
                $this->app_operator->ViewValue = null;
            }

            // app_datetime
            $this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
            $this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, $this->app_datetime->formatPattern());

            // company_id
            $this->company_id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // po
            if (!EmptyValue($this->po->CurrentValue)) {
                $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
                $this->po->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
                }
            } else {
                $this->po->HrefValue = "";
            }
            $this->po->TooltipValue = "";

            // partner_id
            if (!EmptyValue($this->partner_id->CurrentValue)) {
                $this->partner_id->HrefValue = $this->partner_id->getLinkPrefix() . $this->partner_id->CurrentValue; // Add prefix/suffix
                $this->partner_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
                }
            } else {
                $this->partner_id->HrefValue = "";
            }

            // cart_id
            $this->cart_id->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // gst
            $this->gst->HrefValue = "";

            // partner_order_no
            $this->partner_order_no->HrefValue = "";

            // partner_order_date
            $this->partner_order_date->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // fob_date
            $this->fob_date->HrefValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";

            // part_dispatch
            if (!EmptyValue($this->part_dispatch->CurrentValue)) {
                $this->part_dispatch->HrefValue = $this->part_dispatch->getLinkPrefix() . $this->part_dispatch->CurrentValue; // Add prefix/suffix
                $this->part_dispatch->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->part_dispatch->HrefValue = FullUrl($this->part_dispatch->HrefValue, "href");
                }
            } else {
                $this->part_dispatch->HrefValue = "";
            }

            // payment_terms
            if (!EmptyValue($this->payment_terms->CurrentValue)) {
                $this->payment_terms->HrefValue = $this->payment_terms->getLinkPrefix() . $this->payment_terms->CurrentValue; // Add prefix/suffix
                $this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
                }
            } else {
                $this->payment_terms->HrefValue = "";
            }

            // transport_type
            if (!EmptyValue($this->transport_type->CurrentValue)) {
                $this->transport_type->HrefValue = $this->transport_type->getLinkPrefix() . $this->transport_type->CurrentValue; // Add prefix/suffix
                $this->transport_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
                }
            } else {
                $this->transport_type->HrefValue = "";
            }

            // partner_shipping_id
            $this->partner_shipping_id->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // d_09_head
            $this->d_09_head->HrefValue = "";

            // description_09
            $this->description_09->HrefValue = "";

            // d_10_head
            $this->d_10_head->HrefValue = "";

            // description_10
            $this->description_10->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->CurrentValue));
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->CurrentValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->CurrentValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
                $this->po->EditValue = FormatNumber($this->po->EditValue, null);
            }

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

            // cart_id
            $curVal = trim(strval($this->cart_id->CurrentValue));
            if ($curVal != "") {
                $this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
            } else {
                $this->cart_id->ViewValue = $this->cart_id->Lookup !== null && is_array($this->cart_id->lookupOptions()) && count($this->cart_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->cart_id->ViewValue !== null) { // Load from cache
                $this->cart_id->EditValue = array_values($this->cart_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->cart_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->cart_id->Lookup->renderViewRow($row);
                }
                $this->cart_id->EditValue = $arwrk;
            }
            $this->cart_id->PlaceHolder = RemoveHtml($this->cart_id->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditCustomAttributes = $this->quantity->getEditCustomAttributes(); // PHP
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            if (!$this->amount->Raw) {
                $this->amount->CurrentValue = HtmlDecode($this->amount->CurrentValue);
            }
            $this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // gst
            $this->gst->setupEditAttributes();
            $curVal = trim(strval($this->gst->CurrentValue));
            if ($curVal != "") {
                $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
            } else {
                $this->gst->ViewValue = $this->gst->Lookup !== null && is_array($this->gst->lookupOptions()) && count($this->gst->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->gst->ViewValue !== null) { // Load from cache
                $this->gst->EditValue = array_values($this->gst->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->gst->CurrentValue, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                $sqlWrk = $this->gst->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->gst->Lookup->renderViewRow($row);
                }
                $this->gst->EditValue = $arwrk;
            }
            $this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

            // partner_order_no
            $this->partner_order_no->setupEditAttributes();
            if (!$this->partner_order_no->Raw) {
                $this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
            }
            $this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->CurrentValue);
            $this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

            // partner_order_date
            $this->partner_order_date->setupEditAttributes();
            $this->partner_order_date->EditValue = HtmlEncode(FormatDateTime($this->partner_order_date->CurrentValue, $this->partner_order_date->formatPattern()));
            $this->partner_order_date->PlaceHolder = RemoveHtml($this->partner_order_date->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()));
            $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->CurrentValue));
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->CurrentValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->despatch_week->getSelectFilter($this); // PHP
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // fob_date
            $this->fob_date->setupEditAttributes();
            $this->fob_date->EditValue = HtmlEncode(FormatDateTime($this->fob_date->CurrentValue, $this->fob_date->formatPattern()));
            $this->fob_date->PlaceHolder = RemoveHtml($this->fob_date->caption());

            // production_plan
            $this->production_plan->setupEditAttributes();
            $curVal = trim(strval($this->production_plan->CurrentValue));
            if ($curVal != "") {
                $this->production_plan->ViewValue = $this->production_plan->lookupCacheOption($curVal);
            } else {
                $this->production_plan->ViewValue = $this->production_plan->Lookup !== null && is_array($this->production_plan->lookupOptions()) && count($this->production_plan->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->production_plan->ViewValue !== null) { // Load from cache
                $this->production_plan->EditValue = array_values($this->production_plan->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->production_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->production_plan->CurrentValue, $this->production_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->production_plan->getSelectFilter($this); // PHP
                $sqlWrk = $this->production_plan->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->production_plan->EditValue = $arwrk;
            }
            $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

            // part_dispatch
            $this->part_dispatch->setupEditAttributes();
            $this->part_dispatch->EditValue = $this->part_dispatch->options(true);
            $this->part_dispatch->PlaceHolder = RemoveHtml($this->part_dispatch->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            $curVal = trim(strval($this->payment_terms->CurrentValue));
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
            } else {
                $this->payment_terms->ViewValue = $this->payment_terms->Lookup !== null && is_array($this->payment_terms->lookupOptions()) && count($this->payment_terms->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment_terms->ViewValue !== null) { // Load from cache
                $this->payment_terms->EditValue = array_values($this->payment_terms->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->payment_terms->CurrentValue, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_terms->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->payment_terms->EditValue = $arwrk;
            }
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

            // transport_type
            $this->transport_type->setupEditAttributes();
            $curVal = trim(strval($this->transport_type->CurrentValue));
            if ($curVal != "") {
                $this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
            } else {
                $this->transport_type->ViewValue = $this->transport_type->Lookup !== null && is_array($this->transport_type->lookupOptions()) && count($this->transport_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->transport_type->ViewValue !== null) { // Load from cache
                $this->transport_type->EditValue = array_values($this->transport_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->transport_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->transport_type->CurrentValue, $this->transport_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->transport_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->transport_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->transport_type->EditValue = $arwrk;
            }
            $this->transport_type->PlaceHolder = RemoveHtml($this->transport_type->caption());

            // partner_shipping_id
            $this->partner_shipping_id->setupEditAttributes();
            $curVal = trim(strval($this->partner_shipping_id->CurrentValue));
            if ($curVal != "") {
                $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
            } else {
                $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->Lookup !== null && is_array($this->partner_shipping_id->lookupOptions()) && count($this->partner_shipping_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->partner_shipping_id->ViewValue !== null) { // Load from cache
                $this->partner_shipping_id->EditValue = array_values($this->partner_shipping_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->partner_shipping_id->CurrentValue, $this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->partner_shipping_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner_shipping_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->partner_shipping_id->EditValue = $arwrk;
            }
            $this->partner_shipping_id->PlaceHolder = RemoveHtml($this->partner_shipping_id->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // buyer_instruction
            $this->buyer_instruction->setupEditAttributes();
            $this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->CurrentValue);
            $this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->uploads->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->uploads);
            }

            // d_09_head
            $this->d_09_head->setupEditAttributes();
            $curVal = trim(strval($this->d_09_head->CurrentValue));
            if ($curVal != "") {
                $this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
            } else {
                $this->d_09_head->ViewValue = $this->d_09_head->Lookup !== null && is_array($this->d_09_head->lookupOptions()) && count($this->d_09_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_09_head->ViewValue !== null) { // Load from cache
                $this->d_09_head->EditValue = array_values($this->d_09_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_09_head->CurrentValue, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_09_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_09_head->EditValue = $arwrk;
            }
            $this->d_09_head->PlaceHolder = RemoveHtml($this->d_09_head->caption());

            // description_09
            $this->description_09->setupEditAttributes();
            if (!$this->description_09->Raw) {
                $this->description_09->CurrentValue = HtmlDecode($this->description_09->CurrentValue);
            }
            $this->description_09->EditValue = HtmlEncode($this->description_09->CurrentValue);
            $this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

            // d_10_head
            $this->d_10_head->setupEditAttributes();
            $curVal = trim(strval($this->d_10_head->CurrentValue));
            if ($curVal != "") {
                $this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
            } else {
                $this->d_10_head->ViewValue = $this->d_10_head->Lookup !== null && is_array($this->d_10_head->lookupOptions()) && count($this->d_10_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->d_10_head->ViewValue !== null) { // Load from cache
                $this->d_10_head->EditValue = array_values($this->d_10_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->d_10_head->CurrentValue, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->d_10_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->d_10_head->EditValue = $arwrk;
            }
            $this->d_10_head->PlaceHolder = RemoveHtml($this->d_10_head->caption());

            // description_10
            $this->description_10->setupEditAttributes();
            if (!$this->description_10->Raw) {
                $this->description_10->CurrentValue = HtmlDecode($this->description_10->CurrentValue);
            }
            $this->description_10->EditValue = HtmlEncode($this->description_10->CurrentValue);
            $this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

            // operator

            // datetime

            // Add refer script

            // company_id
            $this->company_id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // po
            if (!EmptyValue($this->po->CurrentValue)) {
                $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
                $this->po->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
                }
            } else {
                $this->po->HrefValue = "";
            }

            // partner_id
            if (!EmptyValue($this->partner_id->CurrentValue)) {
                $this->partner_id->HrefValue = $this->partner_id->getLinkPrefix() . $this->partner_id->CurrentValue; // Add prefix/suffix
                $this->partner_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
                }
            } else {
                $this->partner_id->HrefValue = "";
            }

            // cart_id
            $this->cart_id->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // gst
            $this->gst->HrefValue = "";

            // partner_order_no
            $this->partner_order_no->HrefValue = "";

            // partner_order_date
            $this->partner_order_date->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // fob_date
            $this->fob_date->HrefValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";

            // part_dispatch
            if (!EmptyValue($this->part_dispatch->CurrentValue)) {
                $this->part_dispatch->HrefValue = $this->part_dispatch->getLinkPrefix() . $this->part_dispatch->CurrentValue; // Add prefix/suffix
                $this->part_dispatch->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->part_dispatch->HrefValue = FullUrl($this->part_dispatch->HrefValue, "href");
                }
            } else {
                $this->part_dispatch->HrefValue = "";
            }

            // payment_terms
            if (!EmptyValue($this->payment_terms->CurrentValue)) {
                $this->payment_terms->HrefValue = $this->payment_terms->getLinkPrefix() . $this->payment_terms->CurrentValue; // Add prefix/suffix
                $this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
                }
            } else {
                $this->payment_terms->HrefValue = "";
            }

            // transport_type
            if (!EmptyValue($this->transport_type->CurrentValue)) {
                $this->transport_type->HrefValue = $this->transport_type->getLinkPrefix() . $this->transport_type->CurrentValue; // Add prefix/suffix
                $this->transport_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
                }
            } else {
                $this->transport_type->HrefValue = "";
            }

            // partner_shipping_id
            $this->partner_shipping_id->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // d_09_head
            $this->d_09_head->HrefValue = "";

            // description_09
            $this->description_09->HrefValue = "";

            // d_10_head
            $this->d_10_head->HrefValue = "";

            // description_10
            $this->description_10->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->location->Visible && $this->location->Required) {
                if (!$this->location->IsDetailKey && EmptyValue($this->location->FormValue)) {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->po->FormValue)) {
                $this->po->addErrorMessage($this->po->getErrorMessage(false));
            }
            if ($this->partner_id->Visible && $this->partner_id->Required) {
                if (!$this->partner_id->IsDetailKey && EmptyValue($this->partner_id->FormValue)) {
                    $this->partner_id->addErrorMessage(str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->partner_id->FormValue)) {
                $this->partner_id->addErrorMessage($this->partner_id->getErrorMessage(false));
            }
            if ($this->cart_id->Visible && $this->cart_id->Required) {
                if ($this->cart_id->FormValue == "") {
                    $this->cart_id->addErrorMessage(str_replace("%s", $this->cart_id->caption(), $this->cart_id->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if ($this->gst->Visible && $this->gst->Required) {
                if (!$this->gst->IsDetailKey && EmptyValue($this->gst->FormValue)) {
                    $this->gst->addErrorMessage(str_replace("%s", $this->gst->caption(), $this->gst->RequiredErrorMessage));
                }
            }
            if ($this->partner_order_no->Visible && $this->partner_order_no->Required) {
                if (!$this->partner_order_no->IsDetailKey && EmptyValue($this->partner_order_no->FormValue)) {
                    $this->partner_order_no->addErrorMessage(str_replace("%s", $this->partner_order_no->caption(), $this->partner_order_no->RequiredErrorMessage));
                }
            }
            if ($this->partner_order_date->Visible && $this->partner_order_date->Required) {
                if (!$this->partner_order_date->IsDetailKey && EmptyValue($this->partner_order_date->FormValue)) {
                    $this->partner_order_date->addErrorMessage(str_replace("%s", $this->partner_order_date->caption(), $this->partner_order_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->partner_order_date->FormValue, $this->partner_order_date->formatPattern())) {
                $this->partner_order_date->addErrorMessage($this->partner_order_date->getErrorMessage(false));
            }
            if ($this->despatch_date->Visible && $this->despatch_date->Required) {
                if (!$this->despatch_date->IsDetailKey && EmptyValue($this->despatch_date->FormValue)) {
                    $this->despatch_date->addErrorMessage(str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->despatch_date->FormValue, $this->despatch_date->formatPattern())) {
                $this->despatch_date->addErrorMessage($this->despatch_date->getErrorMessage(false));
            }
            if ($this->despatch_week->Visible && $this->despatch_week->Required) {
                if (!$this->despatch_week->IsDetailKey && EmptyValue($this->despatch_week->FormValue)) {
                    $this->despatch_week->addErrorMessage(str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
                }
            }
            if ($this->fob_date->Visible && $this->fob_date->Required) {
                if (!$this->fob_date->IsDetailKey && EmptyValue($this->fob_date->FormValue)) {
                    $this->fob_date->addErrorMessage(str_replace("%s", $this->fob_date->caption(), $this->fob_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->fob_date->FormValue, $this->fob_date->formatPattern())) {
                $this->fob_date->addErrorMessage($this->fob_date->getErrorMessage(false));
            }
            if ($this->production_plan->Visible && $this->production_plan->Required) {
                if (!$this->production_plan->IsDetailKey && EmptyValue($this->production_plan->FormValue)) {
                    $this->production_plan->addErrorMessage(str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
                }
            }
            if ($this->part_dispatch->Visible && $this->part_dispatch->Required) {
                if (!$this->part_dispatch->IsDetailKey && EmptyValue($this->part_dispatch->FormValue)) {
                    $this->part_dispatch->addErrorMessage(str_replace("%s", $this->part_dispatch->caption(), $this->part_dispatch->RequiredErrorMessage));
                }
            }
            if ($this->payment_terms->Visible && $this->payment_terms->Required) {
                if (!$this->payment_terms->IsDetailKey && EmptyValue($this->payment_terms->FormValue)) {
                    $this->payment_terms->addErrorMessage(str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
                }
            }
            if ($this->transport_type->Visible && $this->transport_type->Required) {
                if (!$this->transport_type->IsDetailKey && EmptyValue($this->transport_type->FormValue)) {
                    $this->transport_type->addErrorMessage(str_replace("%s", $this->transport_type->caption(), $this->transport_type->RequiredErrorMessage));
                }
            }
            if ($this->partner_shipping_id->Visible && $this->partner_shipping_id->Required) {
                if (!$this->partner_shipping_id->IsDetailKey && EmptyValue($this->partner_shipping_id->FormValue)) {
                    $this->partner_shipping_id->addErrorMessage(str_replace("%s", $this->partner_shipping_id->caption(), $this->partner_shipping_id->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->buyer_instruction->Visible && $this->buyer_instruction->Required) {
                if (!$this->buyer_instruction->IsDetailKey && EmptyValue($this->buyer_instruction->FormValue)) {
                    $this->buyer_instruction->addErrorMessage(str_replace("%s", $this->buyer_instruction->caption(), $this->buyer_instruction->RequiredErrorMessage));
                }
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }
            if ($this->d_09_head->Visible && $this->d_09_head->Required) {
                if (!$this->d_09_head->IsDetailKey && EmptyValue($this->d_09_head->FormValue)) {
                    $this->d_09_head->addErrorMessage(str_replace("%s", $this->d_09_head->caption(), $this->d_09_head->RequiredErrorMessage));
                }
            }
            if ($this->description_09->Visible && $this->description_09->Required) {
                if (!$this->description_09->IsDetailKey && EmptyValue($this->description_09->FormValue)) {
                    $this->description_09->addErrorMessage(str_replace("%s", $this->description_09->caption(), $this->description_09->RequiredErrorMessage));
                }
            }
            if ($this->d_10_head->Visible && $this->d_10_head->Required) {
                if (!$this->d_10_head->IsDetailKey && EmptyValue($this->d_10_head->FormValue)) {
                    $this->d_10_head->addErrorMessage(str_replace("%s", $this->d_10_head->caption(), $this->d_10_head->RequiredErrorMessage));
                }
            }
            if ($this->description_10->Visible && $this->description_10->Required) {
                if (!$this->description_10->IsDetailKey && EmptyValue($this->description_10->FormValue)) {
                    $this->description_10->addErrorMessage(str_replace("%s", $this->description_10->caption(), $this->description_10->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            $this->uploads->UploadPath = $this->uploads->getUploadPath();
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                $this->uploads->Upload->DbValue = null;
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $this->uploads->UploadPath = $this->uploads->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, strval($this->location->CurrentValue) == "");

        // po
        $this->po->setDbValueDef($rsnew, $this->po->CurrentValue, strval($this->po->CurrentValue) == "");

        // partner_id
        $this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, false);

        // cart_id
        $this->cart_id->setDbValueDef($rsnew, $this->cart_id->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, false);

        // gst
        $this->gst->setDbValueDef($rsnew, $this->gst->CurrentValue, strval($this->gst->CurrentValue) == "");

        // partner_order_no
        $this->partner_order_no->setDbValueDef($rsnew, $this->partner_order_no->CurrentValue, false);

        // partner_order_date
        $this->partner_order_date->setDbValueDef($rsnew, UnFormatDateTime($this->partner_order_date->CurrentValue, $this->partner_order_date->formatPattern()), false);

        // despatch_date
        $this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()), false);

        // despatch_week
        $this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, false);

        // fob_date
        $this->fob_date->setDbValueDef($rsnew, UnFormatDateTime($this->fob_date->CurrentValue, $this->fob_date->formatPattern()), false);

        // production_plan
        $this->production_plan->setDbValueDef($rsnew, $this->production_plan->CurrentValue, false);

        // part_dispatch
        $this->part_dispatch->setDbValueDef($rsnew, $this->part_dispatch->CurrentValue, false);

        // payment_terms
        $this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, false);

        // transport_type
        $this->transport_type->setDbValueDef($rsnew, $this->transport_type->CurrentValue, false);

        // partner_shipping_id
        $this->partner_shipping_id->setDbValueDef($rsnew, $this->partner_shipping_id->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // buyer_instruction
        $this->buyer_instruction->setDbValueDef($rsnew, $this->buyer_instruction->CurrentValue, false);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 640; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // d_09_head
        $this->d_09_head->setDbValueDef($rsnew, $this->d_09_head->CurrentValue, false);

        // description_09
        $this->description_09->setDbValueDef($rsnew, $this->description_09->CurrentValue, false);

        // d_10_head
        $this->d_10_head->setDbValueDef($rsnew, $this->d_10_head->CurrentValue, false);

        // description_10
        $this->description_10->setDbValueDef($rsnew, $this->description_10->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['location'])) { // location
            $this->location->setFormValue($row['location']);
        }
        if (isset($row['po'])) { // po
            $this->po->setFormValue($row['po']);
        }
        if (isset($row['partner_id'])) { // partner_id
            $this->partner_id->setFormValue($row['partner_id']);
        }
        if (isset($row['cart_id'])) { // cart_id
            $this->cart_id->setFormValue($row['cart_id']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['amount'])) { // amount
            $this->amount->setFormValue($row['amount']);
        }
        if (isset($row['gst'])) { // gst
            $this->gst->setFormValue($row['gst']);
        }
        if (isset($row['partner_order_no'])) { // partner_order_no
            $this->partner_order_no->setFormValue($row['partner_order_no']);
        }
        if (isset($row['partner_order_date'])) { // partner_order_date
            $this->partner_order_date->setFormValue($row['partner_order_date']);
        }
        if (isset($row['despatch_date'])) { // despatch_date
            $this->despatch_date->setFormValue($row['despatch_date']);
        }
        if (isset($row['despatch_week'])) { // despatch_week
            $this->despatch_week->setFormValue($row['despatch_week']);
        }
        if (isset($row['fob_date'])) { // fob_date
            $this->fob_date->setFormValue($row['fob_date']);
        }
        if (isset($row['production_plan'])) { // production_plan
            $this->production_plan->setFormValue($row['production_plan']);
        }
        if (isset($row['part_dispatch'])) { // part_dispatch
            $this->part_dispatch->setFormValue($row['part_dispatch']);
        }
        if (isset($row['payment_terms'])) { // payment_terms
            $this->payment_terms->setFormValue($row['payment_terms']);
        }
        if (isset($row['transport_type'])) { // transport_type
            $this->transport_type->setFormValue($row['transport_type']);
        }
        if (isset($row['partner_shipping_id'])) { // partner_shipping_id
            $this->partner_shipping_id->setFormValue($row['partner_shipping_id']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['buyer_instruction'])) { // buyer_instruction
            $this->buyer_instruction->setFormValue($row['buyer_instruction']);
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->setFormValue($row['uploads']);
        }
        if (isset($row['d_09_head'])) { // d_09_head
            $this->d_09_head->setFormValue($row['d_09_head']);
        }
        if (isset($row['description_09'])) { // description_09
            $this->description_09->setFormValue($row['description_09']);
        }
        if (isset($row['d_10_head'])) { // d_10_head
            $this->d_10_head->setFormValue($row['d_10_head']);
        }
        if (isset($row['description_10'])) { // description_10
            $this->description_10->setFormValue($row['description_10']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("pobwbclist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cart_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_gst":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_production_plan":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_part_dispatch":
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_transport_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_shipping_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_03":
                    break;
                case "x_description_04":
                    break;
                case "x_description_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_d_09_head":
                    break;
                case "x_d_10_head":
                    break;
                case "x_d_11_head":
                    break;
                case "x_d_12_head":
                    break;
                case "x_description_20":
                    break;
                case "x_production_site":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_status":
                    break;
                case "x_a_operator":
                    break;
                case "x_app_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'po_b_wbc');	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
