<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for po
 */
class Po extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $order_type;
    public $buyer_id;
    public $buyer_order_no;
    public $buyer_order_date;
    public $cart_id;
    public $buyer_product_ref;
    public $grp;
    public $s_grp;
    public $product;
    public $rid;
    public $despatch_date;
    public $despatch_week;
    public $fob_date;
    public $part_dispatch;
    public $payment_terms;
    public $transport_terms;
    public $buyer_shipping_id;
    public $description_04;
    public $description_03;
    public $description_01;
    public $description_02;
    public $description_07;
    public $description_20;
    public $description_17;
    public $description_18;
    public $description_19;
    public $quantity;
    public $price;
    public $currency;
    public $amount;
    public $cbm;
    public $buyer_size;
    public $description_05;
    public $description_06;
    public $description_08;
    public $remarks;
    public $operator;
    public $datetime;
    public $a_operator;
    public $a_datetime;
    public $jc_no;
    public $buyer_instruction;
    public $d_09_head;
    public $description_09;
    public $d_10_head;
    public $description_10;
    public $d_11_head;
    public $description_11;
    public $d_12_head;
    public $description_12;
    public $po;
    public $production_site;
    public $c_total;
    public $production_plan;
    public $lot_no;
    public $product_gcode;
    public $batch_no;
    public $uploads;
    public $d_01_head;
    public $d_02_head;
    public $d_03_head;
    public $d_04_head;
    public $d_05_head;
    public $d_06_head;
    public $d_07_head;
    public $d_08_head;
    public $sample;
    public $balance_quantity;
    public $_action;
    public $url;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "po";
        $this->TableName = 'po';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "po";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // order_type
        $this->order_type = new DbField(
            $this, // Table
            'x_order_type', // Variable name
            'order_type', // Name
            '`order_type`', // Expression
            '`order_type`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`order_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->order_type->addMethod("getDefault", fn() => 0);
        $this->order_type->InputTextType = "text";
        $this->order_type->Raw = true;
        $this->order_type->Nullable = false; // NOT NULL field
        $this->order_type->Required = true; // Required field
        $this->order_type->Lookup = new Lookup($this->order_type, 'po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->order_type->OptionCount = 2;
        $this->order_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->order_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['order_type'] = &$this->order_type;

        // buyer_id
        $this->buyer_id = new DbField(
            $this, // Table
            'x_buyer_id', // Variable name
            'buyer_id', // Name
            '`buyer_id`', // Expression
            '`buyer_id`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyer_id->addMethod("getSelectFilter", fn() => "`id` > 1000");
        $this->buyer_id->InputTextType = "text";
        $this->buyer_id->Raw = true;
        $this->buyer_id->Nullable = false; // NOT NULL field
        $this->buyer_id->Required = true; // Required field
        $this->buyer_id->setSelectMultiple(false); // Select one
        $this->buyer_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyer_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyer_id->Lookup = new Lookup($this->buyer_id, 'buyer', false, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->buyer_id) . "',COALESCE(`code`,''))");
        $this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['buyer_id'] = &$this->buyer_id;

        // buyer_order_no
        $this->buyer_order_no = new DbField(
            $this, // Table
            'x_buyer_order_no', // Variable name
            'buyer_order_no', // Name
            '`buyer_order_no`', // Expression
            '`buyer_order_no`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_order_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_order_no->InputTextType = "text";
        $this->buyer_order_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_order_no'] = &$this->buyer_order_no;

        // buyer_order_date
        $this->buyer_order_date = new DbField(
            $this, // Table
            'x_buyer_order_date', // Variable name
            'buyer_order_date', // Name
            '`buyer_order_date`', // Expression
            CastDateFieldForLike("`buyer_order_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`buyer_order_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_order_date->addMethod("getDefault", fn() => CurrentDate());
        $this->buyer_order_date->InputTextType = "text";
        $this->buyer_order_date->Raw = true;
        $this->buyer_order_date->Required = true; // Required field
        $this->buyer_order_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->buyer_order_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_order_date'] = &$this->buyer_order_date;

        // cart_id
        $this->cart_id = new DbField(
            $this, // Table
            'x_cart_id', // Variable name
            'cart_id', // Name
            '`cart_id`', // Expression
            '`cart_id`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cart_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->cart_id->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue);
        $this->cart_id->InputTextType = "text";
        $this->cart_id->Lookup = new Lookup($this->cart_id, 'product_cart_s', false, 'id', ["rid_1","quantity","price","amount"], '', '', [], [], [], [], [], [], false, '', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span></div>', "CONCAT(COALESCE(`rid_1`, ''),'" . ValueSeparator(1, $this->cart_id) . "',COALESCE(`quantity`,''),'" . ValueSeparator(2, $this->cart_id) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->cart_id) . "',COALESCE(`amount`,''))");
        $this->cart_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['cart_id'] = &$this->cart_id;

        // buyer_product_ref
        $this->buyer_product_ref = new DbField(
            $this, // Table
            'x_buyer_product_ref', // Variable name
            'buyer_product_ref', // Name
            '`buyer_product_ref`', // Expression
            '`buyer_product_ref`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_product_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_product_ref->InputTextType = "text";
        $this->buyer_product_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_product_ref'] = &$this->buyer_product_ref;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status` = 1 ");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp","x_description_05","x_description_06","x_d_09_head"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->s_grp->addMethod("getLinkPrefix", fn() => "poclist?x_s_grp=");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Nullable = false; // NOT NULL field
        $this->s_grp->Required = true; // Required field
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product","x_d_10_head","x_d_11_head","x_d_12_head"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getLinkPrefix", fn() => "poclist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Required = true; // Required field
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product', false, 'id', ["product","","",""], '', '', ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp[]"], [], [], false, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->rid->addMethod("getSelectFilter", fn() => "`status`=1 and `product_type`=0");
        $this->rid->addMethod("getLinkPrefix", fn() => "poclist?x_rid=");
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Lookup = new Lookup($this->rid, 'ref', true, 'id', ["product_code","","",""], '', '', ["x_product"], [], ["product"], ["x_product"], ["last_price","b_01","currency"], ["x_price","x_cbm","x_currency"], false, '`gcode` ASC', '', "`product_code`");
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid'] = &$this->rid;

        // despatch_date
        $this->despatch_date = new DbField(
            $this, // Table
            'x_despatch_date', // Variable name
            'despatch_date', // Name
            '`despatch_date`', // Expression
            CastDateFieldForLike("`despatch_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`despatch_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->despatch_date->InputTextType = "text";
        $this->despatch_date->Raw = true;
        $this->despatch_date->Nullable = false; // NOT NULL field
        $this->despatch_date->Required = true; // Required field
        $this->despatch_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->despatch_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['despatch_date'] = &$this->despatch_date;

        // despatch_week
        $this->despatch_week = new DbField(
            $this, // Table
            'x_despatch_week', // Variable name
            'despatch_week', // Name
            '`despatch_week`', // Expression
            '`despatch_week`', // Basic search expression
            18, // Type
            5, // Size
            7, // Date/Time format
            false, // Is upload field
            '`despatch_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->despatch_week->addMethod("getDefault", fn() => date('W'));
        $this->despatch_week->InputTextType = "text";
        $this->despatch_week->Raw = true;
        $this->despatch_week->Required = true; // Required field
        $this->despatch_week->setSelectMultiple(false); // Select one
        $this->despatch_week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->despatch_week->Lookup = new Lookup($this->despatch_week, 'not_week', true, 'id', ["wid","wed","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`wid`, ''),'" . ValueSeparator(1, $this->despatch_week) . "',COALESCE(`wed`,''))");
        $this->despatch_week->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->despatch_week->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_week'] = &$this->despatch_week;

        // fob_date
        $this->fob_date = new DbField(
            $this, // Table
            'x_fob_date', // Variable name
            'fob_date', // Name
            '`fob_date`', // Expression
            CastDateFieldForLike("`fob_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`fob_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fob_date->InputTextType = "text";
        $this->fob_date->Raw = true;
        $this->fob_date->Nullable = false; // NOT NULL field
        $this->fob_date->Required = true; // Required field
        $this->fob_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->fob_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['fob_date'] = &$this->fob_date;

        // part_dispatch
        $this->part_dispatch = new DbField(
            $this, // Table
            'x_part_dispatch', // Variable name
            'part_dispatch', // Name
            '`part_dispatch`', // Expression
            '`part_dispatch`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`part_dispatch`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->part_dispatch->InputTextType = "text";
        $this->part_dispatch->Raw = true;
        $this->part_dispatch->Nullable = false; // NOT NULL field
        $this->part_dispatch->Required = true; // Required field
        $this->part_dispatch->setSelectMultiple(false); // Select one
        $this->part_dispatch->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->part_dispatch->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->part_dispatch->Lookup = new Lookup($this->part_dispatch, 'po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->part_dispatch->OptionCount = 2;
        $this->part_dispatch->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->part_dispatch->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['part_dispatch'] = &$this->part_dispatch;

        // payment_terms
        $this->payment_terms = new DbField(
            $this, // Table
            'x_payment_terms', // Variable name
            'payment_terms', // Name
            '`payment_terms`', // Expression
            '`payment_terms`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_terms`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->payment_terms->addMethod("getSelectFilter", fn() => "`grp` = 81");
        $this->payment_terms->InputTextType = "text";
        $this->payment_terms->Nullable = false; // NOT NULL field
        $this->payment_terms->Required = true; // Required field
        $this->payment_terms->setSelectMultiple(false); // Select one
        $this->payment_terms->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->payment_terms->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->payment_terms->Lookup = new Lookup($this->payment_terms, 'misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->payment_terms->SearchOperators = ["=", "<>"];
        $this->Fields['payment_terms'] = &$this->payment_terms;

        // transport_terms
        $this->transport_terms = new DbField(
            $this, // Table
            'x_transport_terms', // Variable name
            'transport_terms', // Name
            '`transport_terms`', // Expression
            '`transport_terms`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`transport_terms`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->transport_terms->InputTextType = "text";
        $this->transport_terms->Nullable = false; // NOT NULL field
        $this->transport_terms->Required = true; // Required field
        $this->transport_terms->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['transport_terms'] = &$this->transport_terms;

        // buyer_shipping _id
        $this->buyer_shipping_id = new DbField(
            $this, // Table
            'x_buyer_shipping_id', // Variable name
            'buyer_shipping _id', // Name
            '`buyer_shipping _id`', // Expression
            '`buyer_shipping _id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_shipping _id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_shipping_id->InputTextType = "text";
        $this->buyer_shipping_id->Raw = true;
        $this->buyer_shipping_id->Nullable = false; // NOT NULL field
        $this->buyer_shipping_id->Required = true; // Required field
        $this->buyer_shipping_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer_shipping_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['buyer_shipping _id'] = &$this->buyer_shipping_id;

        // description_04
        $this->description_04 = new DbField(
            $this, // Table
            'x_description_04', // Variable name
            'description_04', // Name
            '`description_04`', // Expression
            '`description_04`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_04->addMethod("getDefault", fn() => 0);
        $this->description_04->InputTextType = "text";
        $this->description_04->Raw = true;
        $this->description_04->Required = true; // Required field
        $this->description_04->Lookup = new Lookup($this->description_04, 'po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->description_04->OptionCount = 3;
        $this->description_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->description_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_04'] = &$this->description_04;

        // description_03
        $this->description_03 = new DbField(
            $this, // Table
            'x_description_03', // Variable name
            'description_03', // Name
            '`description_03`', // Expression
            '`description_03`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->description_03->addMethod("getDefault", fn() => 1);
        $this->description_03->InputTextType = "text";
        $this->description_03->Raw = true;
        $this->description_03->Required = true; // Required field
        $this->description_03->setSelectMultiple(false); // Select one
        $this->description_03->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->description_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->description_03->Lookup = new Lookup($this->description_03, 'po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->description_03->OptionCount = 4;
        $this->description_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->description_03->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_03'] = &$this->description_03;

        // description_01
        $this->description_01 = new DbField(
            $this, // Table
            'x_description_01', // Variable name
            'description_01', // Name
            '`description_01`', // Expression
            '`description_01`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_01->InputTextType = "text";
        $this->description_01->Raw = true;
        $this->description_01->Required = true; // Required field
        $this->description_01->Sortable = false; // Allow sort
        $this->description_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_01'] = &$this->description_01;

        // description_02
        $this->description_02 = new DbField(
            $this, // Table
            'x_description_02', // Variable name
            'description_02', // Name
            '`description_02`', // Expression
            '`description_02`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_02->InputTextType = "text";
        $this->description_02->Raw = true;
        $this->description_02->Required = true; // Required field
        $this->description_02->Sortable = false; // Allow sort
        $this->description_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_02'] = &$this->description_02;

        // description_07
        $this->description_07 = new DbField(
            $this, // Table
            'x_description_07', // Variable name
            'description_07', // Name
            '`description_07`', // Expression
            '`description_07`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_07->InputTextType = "text";
        $this->description_07->Raw = true;
        $this->description_07->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_07->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_07'] = &$this->description_07;

        // description_20
        $this->description_20 = new DbField(
            $this, // Table
            'x_description_20', // Variable name
            'description_20', // Name
            '`description_20`', // Expression
            '`description_20`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_20`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->description_20->addMethod("getDefault", fn() => 1);
        $this->description_20->InputTextType = "text";
        $this->description_20->Raw = true;
        $this->description_20->Nullable = false; // NOT NULL field
        $this->description_20->Required = true; // Required field
        $this->description_20->setSelectMultiple(false); // Select one
        $this->description_20->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->description_20->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->description_20->Lookup = new Lookup($this->description_20, 'po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->description_20->OptionCount = 4;
        $this->description_20->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->description_20->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['description_20'] = &$this->description_20;

        // description_17
        $this->description_17 = new DbField(
            $this, // Table
            'x_description_17', // Variable name
            'description_17', // Name
            '`description_17`', // Expression
            '`description_17`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_17`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_17->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->description_17->InputTextType = "text";
        $this->description_17->Raw = true;
        $this->description_17->Nullable = false; // NOT NULL field
        $this->description_17->Required = true; // Required field
        $this->description_17->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_17->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['description_17'] = &$this->description_17;

        // description_18
        $this->description_18 = new DbField(
            $this, // Table
            'x_description_18', // Variable name
            'description_18', // Name
            '`description_18`', // Expression
            '`description_18`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_18`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_18->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->description_18->InputTextType = "text";
        $this->description_18->Raw = true;
        $this->description_18->Nullable = false; // NOT NULL field
        $this->description_18->Required = true; // Required field
        $this->description_18->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_18->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['description_18'] = &$this->description_18;

        // description_19
        $this->description_19 = new DbField(
            $this, // Table
            'x_description_19', // Variable name
            'description_19', // Name
            '`description_19`', // Expression
            '`description_19`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_19`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_19->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->description_19->InputTextType = "text";
        $this->description_19->Raw = true;
        $this->description_19->Nullable = false; // NOT NULL field
        $this->description_19->Required = true; // Required field
        $this->description_19->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_19->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['description_19'] = &$this->description_19;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Required = true; // Required field
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity'] = &$this->quantity;

        // price
        $this->price = new DbField(
            $this, // Table
            'x_price', // Variable name
            'price', // Name
            '`price`', // Expression
            '`price`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->price->InputTextType = "text";
        $this->price->Raw = true;
        $this->price->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['price'] = &$this->price;

        // currency
        $this->currency = new DbField(
            $this, // Table
            'x_currency', // Variable name
            'currency', // Name
            '`currency`', // Expression
            '`currency`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`currency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->currency->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->currency->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->currency->InputTextType = "text";
        $this->currency->Raw = true;
        $this->currency->Nullable = false; // NOT NULL field
        $this->currency->Required = true; // Required field
        $this->currency->Sortable = false; // Allow sort
        $this->currency->setSelectMultiple(false); // Select one
        $this->currency->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->currency->Lookup = new Lookup($this->currency, 'currency', false, 'id', ["code","name","",""], '', '', [], [], [], [], [], [], true, '`code` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->currency) . "',COALESCE(`name`,''))");
        $this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->currency->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['currency'] = &$this->currency;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->Nullable = false; // NOT NULL field
        $this->amount->Required = true; // Required field
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['amount'] = &$this->amount;

        // cbm
        $this->cbm = new DbField(
            $this, // Table
            'x_cbm', // Variable name
            'cbm', // Name
            '`cbm`', // Expression
            '`cbm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cbm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cbm->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->cbm->InputTextType = "text";
        $this->cbm->Raw = true;
        $this->cbm->Nullable = false; // NOT NULL field
        $this->cbm->Required = true; // Required field
        $this->cbm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cbm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cbm'] = &$this->cbm;

        // buyer_size
        $this->buyer_size = new DbField(
            $this, // Table
            'x_buyer_size', // Variable name
            'buyer_size', // Name
            '`buyer_size`', // Expression
            '`buyer_size`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_size->InputTextType = "text";
        $this->buyer_size->Nullable = false; // NOT NULL field
        $this->buyer_size->Required = true; // Required field
        $this->buyer_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['buyer_size'] = &$this->buyer_size;

        // description_05
        $this->description_05 = new DbField(
            $this, // Table
            'x_description_05', // Variable name
            'description_05', // Name
            '`description_05`', // Expression
            '`description_05`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->description_05->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->description_05->InputTextType = "text";
        $this->description_05->Raw = true;
        $this->description_05->setSelectMultiple(false); // Select one
        $this->description_05->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->description_05->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->description_05->Lookup = new Lookup($this->description_05, 'd_05', false, 'id', ["item","","",""], '', '', ["x_grp"], [], ["grp"], ["x_grp"], [], [], false, '`item` ASC', '', "`item`");
        $this->description_05->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_05'] = &$this->description_05;

        // description_06
        $this->description_06 = new DbField(
            $this, // Table
            'x_description_06', // Variable name
            'description_06', // Name
            '`description_06`', // Expression
            '`description_06`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_06->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->description_06->InputTextType = "text";
        $this->description_06->Raw = true;
        $this->description_06->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_06'] = &$this->description_06;

        // description_08
        $this->description_08 = new DbField(
            $this, // Table
            'x_description_08', // Variable name
            'description_08', // Name
            '`description_08`', // Expression
            '`description_08`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_08->InputTextType = "text";
        $this->description_08->Raw = true;
        $this->description_08->Required = true; // Required field
        $this->description_08->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_08->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_08'] = &$this->description_08;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // a_operator
        $this->a_operator = new DbField(
            $this, // Table
            'x_a_operator', // Variable name
            'a_operator', // Name
            '`a_operator`', // Expression
            '`a_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`a_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->a_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->a_operator->InputTextType = "text";
        $this->a_operator->Raw = true;
        $this->a_operator->setSelectMultiple(false); // Select one
        $this->a_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->a_operator->Lookup = new Lookup($this->a_operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->a_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_operator'] = &$this->a_operator;

        // a_datetime
        $this->a_datetime = new DbField(
            $this, // Table
            'x_a_datetime', // Variable name
            'a_datetime', // Name
            '`a_datetime`', // Expression
            CastDateFieldForLike("`a_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`a_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->a_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->a_datetime->InputTextType = "text";
        $this->a_datetime->Raw = true;
        $this->a_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_datetime'] = &$this->a_datetime;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Sortable = false; // Allow sort
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // buyer_instruction
        $this->buyer_instruction = new DbField(
            $this, // Table
            'x_buyer_instruction', // Variable name
            'buyer_instruction', // Name
            '`buyer_instruction`', // Expression
            '`buyer_instruction`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_instruction`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->buyer_instruction->InputTextType = "text";
        $this->buyer_instruction->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_instruction'] = &$this->buyer_instruction;

        // d_09_head
        $this->d_09_head = new DbField(
            $this, // Table
            'x_d_09_head', // Variable name
            'd_09_head', // Name
            '`d_09_head`', // Expression
            '`d_09_head`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_09_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->d_09_head->InputTextType = "text";
        $this->d_09_head->Raw = true;
        $this->d_09_head->setSelectMultiple(false); // Select one
        $this->d_09_head->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->d_09_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->d_09_head->Lookup = new Lookup($this->d_09_head, 'po_desc', false, 'id', ["description","","",""], '', '', ["x_grp"], [], ["grp"], ["x_grp"], [], [], false, '`description` ASC', '', "`description`");
        $this->d_09_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_09_head->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_09_head'] = &$this->d_09_head;

        // description_09
        $this->description_09 = new DbField(
            $this, // Table
            'x_description_09', // Variable name
            'description_09', // Name
            '`description_09`', // Expression
            '`description_09`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_09->InputTextType = "text";
        $this->description_09->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_09'] = &$this->description_09;

        // d_10_head
        $this->d_10_head = new DbField(
            $this, // Table
            'x_d_10_head', // Variable name
            'd_10_head', // Name
            '`d_10_head`', // Expression
            '`d_10_head`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_10_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->d_10_head->InputTextType = "text";
        $this->d_10_head->Raw = true;
        $this->d_10_head->setSelectMultiple(false); // Select one
        $this->d_10_head->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->d_10_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->d_10_head->Lookup = new Lookup($this->d_10_head, 'po_desc', false, 'id', ["description","","",""], '', '', ["x_s_grp"], [], ["grp"], ["x_grp"], [], [], false, '`description` ASC', '', "`description`");
        $this->d_10_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_10_head->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_10_head'] = &$this->d_10_head;

        // description_10
        $this->description_10 = new DbField(
            $this, // Table
            'x_description_10', // Variable name
            'description_10', // Name
            '`description_10`', // Expression
            '`description_10`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_10->InputTextType = "text";
        $this->description_10->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_10'] = &$this->description_10;

        // d_11_head
        $this->d_11_head = new DbField(
            $this, // Table
            'x_d_11_head', // Variable name
            'd_11_head', // Name
            '`d_11_head`', // Expression
            '`d_11_head`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_11_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->d_11_head->InputTextType = "text";
        $this->d_11_head->Raw = true;
        $this->d_11_head->setSelectMultiple(false); // Select one
        $this->d_11_head->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->d_11_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->d_11_head->Lookup = new Lookup($this->d_11_head, 'po_desc', false, 'id', ["description","","",""], '', '', ["x_s_grp"], [], ["grp"], ["x_grp"], [], [], false, '`description` ASC', '', "`description`");
        $this->d_11_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_11_head->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_11_head'] = &$this->d_11_head;

        // description_11
        $this->description_11 = new DbField(
            $this, // Table
            'x_description_11', // Variable name
            'description_11', // Name
            '`description_11`', // Expression
            '`description_11`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_11`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_11->InputTextType = "text";
        $this->description_11->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_11'] = &$this->description_11;

        // d_12_head
        $this->d_12_head = new DbField(
            $this, // Table
            'x_d_12_head', // Variable name
            'd_12_head', // Name
            '`d_12_head`', // Expression
            '`d_12_head`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_12_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->d_12_head->InputTextType = "text";
        $this->d_12_head->Raw = true;
        $this->d_12_head->setSelectMultiple(false); // Select one
        $this->d_12_head->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->d_12_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->d_12_head->Lookup = new Lookup($this->d_12_head, 'po_desc', false, 'id', ["description","","",""], '', '', ["x_s_grp"], [], ["grp"], ["x_grp"], [], [], false, '`description` ASC', '', "`description`");
        $this->d_12_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_12_head->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_12_head'] = &$this->d_12_head;

        // description_12
        $this->description_12 = new DbField(
            $this, // Table
            'x_description_12', // Variable name
            'description_12', // Name
            '`description_12`', // Expression
            '`description_12`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_12`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_12->InputTextType = "text";
        $this->description_12->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_12'] = &$this->description_12;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->addMethod("getDefault", fn() => 0000);
        $this->po->addMethod("getLinkPrefix", fn() => "poclist?x_po=");
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->Nullable = false; // NOT NULL field
        $this->po->Required = true; // Required field
        $this->po->Sortable = false; // Allow sort
        $this->po->DefaultErrorMessage = str_replace(["%1", "%2"], ["10001", "99999"], $Language->phrase("IncorrectRange"));
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['po'] = &$this->po;

        // production_site
        $this->production_site = new DbField(
            $this, // Table
            'x_production_site', // Variable name
            'production_site', // Name
            '`production_site`', // Expression
            '`production_site`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_site`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->production_site->addMethod("getSelectFilter", fn() => "`grp` IN (0,3)");
        $this->production_site->InputTextType = "text";
        $this->production_site->Raw = true;
        $this->production_site->Nullable = false; // NOT NULL field
        $this->production_site->Required = true; // Required field
        $this->production_site->Sortable = false; // Allow sort
        $this->production_site->setSelectMultiple(false); // Select one
        $this->production_site->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->production_site->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->production_site->Lookup = new Lookup($this->production_site, 'godown', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`name`");
        $this->production_site->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->production_site->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['production_site'] = &$this->production_site;

        // c_total
        $this->c_total = new DbField(
            $this, // Table
            'x_c_total', // Variable name
            'c_total', // Name
            '`c_total`', // Expression
            '`c_total`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`c_total`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->c_total->InputTextType = "text";
        $this->c_total->Raw = true;
        $this->c_total->Nullable = false; // NOT NULL field
        $this->c_total->Required = true; // Required field
        $this->c_total->Sortable = false; // Allow sort
        $this->c_total->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->c_total->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['c_total'] = &$this->c_total;

        // production_plan
        $this->production_plan = new DbField(
            $this, // Table
            'x_production_plan', // Variable name
            'production_plan', // Name
            '`production_plan`', // Expression
            '`production_plan`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->production_plan->InputTextType = "text";
        $this->production_plan->Raw = true;
        $this->production_plan->Required = true; // Required field
        $this->production_plan->Sortable = false; // Allow sort
        $this->production_plan->setSelectMultiple(false); // Select one
        $this->production_plan->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->production_plan->Lookup = new Lookup($this->production_plan, 'po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->production_plan->OptionCount = 6;
        $this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->production_plan->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['production_plan'] = &$this->production_plan;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->InputTextType = "text";
        $this->lot_no->Sortable = false; // Allow sort
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // product_gcode
        $this->product_gcode = new DbField(
            $this, // Table
            'x_product_gcode', // Variable name
            'product_gcode', // Name
            '`product_gcode`', // Expression
            '`product_gcode`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_gcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_gcode->InputTextType = "text";
        $this->product_gcode->Sortable = false; // Allow sort
        $this->product_gcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_gcode'] = &$this->product_gcode;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->batch_no->addMethod("getSelectFilter", fn() => (hs_bom_byepass() == 1) ? "" : "`a_operator` >  0 || `bom_app_id` > 0");
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->Nullable = false; // NOT NULL field
        $this->batch_no->Required = true; // Required field
        $this->batch_no->Sortable = false; // Allow sort
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // uploads
        $this->uploads = new DbField(
            $this, // Table
            'x_uploads', // Variable name
            'uploads', // Name
            '`uploads`', // Expression
            '`uploads`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`uploads`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->uploads->InputTextType = "text";
        $this->uploads->Sortable = false; // Allow sort
        $this->uploads->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uploads'] = &$this->uploads;

        // d_01_head
        $this->d_01_head = new DbField(
            $this, // Table
            'x_d_01_head', // Variable name
            'd_01_head', // Name
            '`d_01_head`', // Expression
            '`d_01_head`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_01_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_01_head->InputTextType = "text";
        $this->d_01_head->Raw = true;
        $this->d_01_head->Sortable = false; // Allow sort
        $this->d_01_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_01_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_01_head'] = &$this->d_01_head;

        // d_02_head
        $this->d_02_head = new DbField(
            $this, // Table
            'x_d_02_head', // Variable name
            'd_02_head', // Name
            '`d_02_head`', // Expression
            '`d_02_head`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_02_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_02_head->InputTextType = "text";
        $this->d_02_head->Raw = true;
        $this->d_02_head->Sortable = false; // Allow sort
        $this->d_02_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_02_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_02_head'] = &$this->d_02_head;

        // d_03_head
        $this->d_03_head = new DbField(
            $this, // Table
            'x_d_03_head', // Variable name
            'd_03_head', // Name
            '`d_03_head`', // Expression
            '`d_03_head`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_03_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_03_head->InputTextType = "text";
        $this->d_03_head->Raw = true;
        $this->d_03_head->Sortable = false; // Allow sort
        $this->d_03_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_03_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_03_head'] = &$this->d_03_head;

        // d_04_head
        $this->d_04_head = new DbField(
            $this, // Table
            'x_d_04_head', // Variable name
            'd_04_head', // Name
            '`d_04_head`', // Expression
            '`d_04_head`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_04_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_04_head->InputTextType = "text";
        $this->d_04_head->Raw = true;
        $this->d_04_head->Sortable = false; // Allow sort
        $this->d_04_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_04_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_04_head'] = &$this->d_04_head;

        // d_05_head
        $this->d_05_head = new DbField(
            $this, // Table
            'x_d_05_head', // Variable name
            'd_05_head', // Name
            '`d_05_head`', // Expression
            '`d_05_head`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_05_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_05_head->InputTextType = "text";
        $this->d_05_head->Raw = true;
        $this->d_05_head->Sortable = false; // Allow sort
        $this->d_05_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_05_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_05_head'] = &$this->d_05_head;

        // d_06_head
        $this->d_06_head = new DbField(
            $this, // Table
            'x_d_06_head', // Variable name
            'd_06_head', // Name
            '`d_06_head`', // Expression
            '`d_06_head`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_06_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_06_head->InputTextType = "text";
        $this->d_06_head->Raw = true;
        $this->d_06_head->Sortable = false; // Allow sort
        $this->d_06_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_06_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_06_head'] = &$this->d_06_head;

        // d_07_head
        $this->d_07_head = new DbField(
            $this, // Table
            'x_d_07_head', // Variable name
            'd_07_head', // Name
            '`d_07_head`', // Expression
            '`d_07_head`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_07_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_07_head->InputTextType = "text";
        $this->d_07_head->Raw = true;
        $this->d_07_head->Sortable = false; // Allow sort
        $this->d_07_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_07_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_07_head'] = &$this->d_07_head;

        // d_08_head
        $this->d_08_head = new DbField(
            $this, // Table
            'x_d_08_head', // Variable name
            'd_08_head', // Name
            '`d_08_head`', // Expression
            '`d_08_head`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_08_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_08_head->InputTextType = "text";
        $this->d_08_head->Raw = true;
        $this->d_08_head->Sortable = false; // Allow sort
        $this->d_08_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_08_head->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_08_head'] = &$this->d_08_head;

        // sample
        $this->sample = new DbField(
            $this, // Table
            'x_sample', // Variable name
            'sample', // Name
            '`sample`', // Expression
            '`sample`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sample`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sample->InputTextType = "text";
        $this->sample->Raw = true;
        $this->sample->Nullable = false; // NOT NULL field
        $this->sample->Required = true; // Required field
        $this->sample->Sortable = false; // Allow sort
        $this->sample->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sample->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sample'] = &$this->sample;

        // balance_quantity
        $this->balance_quantity = new DbField(
            $this, // Table
            'x_balance_quantity', // Variable name
            'balance_quantity', // Name
            '`balance_quantity`', // Expression
            '`balance_quantity`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`balance_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->balance_quantity->addMethod("getDefault", fn() => 0.00);
        $this->balance_quantity->InputTextType = "text";
        $this->balance_quantity->Raw = true;
        $this->balance_quantity->Sortable = false; // Allow sort
        $this->balance_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->balance_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['balance_quantity'] = &$this->balance_quantity;

        // action
        $this->_action = new DbField(
            $this, // Table
            'x__action', // Variable name
            'action', // Name
            'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), \'Update <BR>Batch Details\', if(`po`.`a_operator` = 0,  \'Authorize and Create <BR>Material Requirement\', \'Authorized\'))', // Expression
            'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), \'Update <BR>Batch Details\', if(`po`.`a_operator` = 0,  \'Authorize and Create <BR>Material Requirement\', \'Authorized\'))', // Basic search expression
            200, // Type
            45, // Size
            -1, // Date/Time format
            false, // Is upload field
            'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), \'Update <BR>Batch Details\', if(`po`.`a_operator` = 0,  \'Authorize and Create <BR>Material Requirement\', \'Authorized\'))', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_action->addMethod("getViewCustomAttributes", fn() => 'class = "btn btn-default"');
        $this->_action->InputTextType = "text";
        $this->_action->IsCustom = true; // Custom field
        $this->_action->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['action'] = &$this->_action;

        // url
        $this->url = new DbField(
            $this, // Table
            'x_url', // Variable name
            'url', // Name
            'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), concat(\'batchnolist?x_id=\',`batch_no`), if(`po`.`a_operator` = 0,  concat(\'apc?apcid=101&ID=\',`id`), \'\'))', // Expression
            'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), concat(\'batchnolist?x_id=\',`batch_no`), if(`po`.`a_operator` = 0,  concat(\'apc?apcid=101&ID=\',`id`), \'\'))', // Basic search expression
            200, // Type
            27, // Size
            -1, // Date/Time format
            false, // Is upload field
            'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), concat(\'batchnolist?x_id=\',`batch_no`), if(`po`.`a_operator` = 0,  concat(\'apc?apcid=101&ID=\',`id`), \'\'))', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->url->InputTextType = "text";
        $this->url->IsCustom = true; // Custom field
        $this->url->Sortable = false; // Allow sort
        $this->url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['url'] = &$this->url;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "po";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        return "*, if(((SELECT  `a_operator` FROM `batch_no` ) = 0), 'Update <BR>Batch Details', if(`po`.`a_operator` = 0,  'Authorize and Create <BR>Material Requirement', 'Authorized')) AS `action`, if(((SELECT  `a_operator` FROM `batch_no` ) = 0), concat('batchnolist?x_id=',`batch_no`), if(`po`.`a_operator` = 0,  concat('apc?apcid=101&ID=',`id`), '')) AS `url`";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->order_type->DbValue = $row['order_type'];
        $this->buyer_id->DbValue = $row['buyer_id'];
        $this->buyer_order_no->DbValue = $row['buyer_order_no'];
        $this->buyer_order_date->DbValue = $row['buyer_order_date'];
        $this->cart_id->DbValue = $row['cart_id'];
        $this->buyer_product_ref->DbValue = $row['buyer_product_ref'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->rid->DbValue = $row['rid'];
        $this->despatch_date->DbValue = $row['despatch_date'];
        $this->despatch_week->DbValue = $row['despatch_week'];
        $this->fob_date->DbValue = $row['fob_date'];
        $this->part_dispatch->DbValue = $row['part_dispatch'];
        $this->payment_terms->DbValue = $row['payment_terms'];
        $this->transport_terms->DbValue = $row['transport_terms'];
        $this->buyer_shipping_id->DbValue = $row['buyer_shipping _id'];
        $this->description_04->DbValue = $row['description_04'];
        $this->description_03->DbValue = $row['description_03'];
        $this->description_01->DbValue = $row['description_01'];
        $this->description_02->DbValue = $row['description_02'];
        $this->description_07->DbValue = $row['description_07'];
        $this->description_20->DbValue = $row['description_20'];
        $this->description_17->DbValue = $row['description_17'];
        $this->description_18->DbValue = $row['description_18'];
        $this->description_19->DbValue = $row['description_19'];
        $this->quantity->DbValue = $row['quantity'];
        $this->price->DbValue = $row['price'];
        $this->currency->DbValue = $row['currency'];
        $this->amount->DbValue = $row['amount'];
        $this->cbm->DbValue = $row['cbm'];
        $this->buyer_size->DbValue = $row['buyer_size'];
        $this->description_05->DbValue = $row['description_05'];
        $this->description_06->DbValue = $row['description_06'];
        $this->description_08->DbValue = $row['description_08'];
        $this->remarks->DbValue = $row['remarks'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->a_operator->DbValue = $row['a_operator'];
        $this->a_datetime->DbValue = $row['a_datetime'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->buyer_instruction->DbValue = $row['buyer_instruction'];
        $this->d_09_head->DbValue = $row['d_09_head'];
        $this->description_09->DbValue = $row['description_09'];
        $this->d_10_head->DbValue = $row['d_10_head'];
        $this->description_10->DbValue = $row['description_10'];
        $this->d_11_head->DbValue = $row['d_11_head'];
        $this->description_11->DbValue = $row['description_11'];
        $this->d_12_head->DbValue = $row['d_12_head'];
        $this->description_12->DbValue = $row['description_12'];
        $this->po->DbValue = $row['po'];
        $this->production_site->DbValue = $row['production_site'];
        $this->c_total->DbValue = $row['c_total'];
        $this->production_plan->DbValue = $row['production_plan'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->product_gcode->DbValue = $row['product_gcode'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->uploads->DbValue = $row['uploads'];
        $this->d_01_head->DbValue = $row['d_01_head'];
        $this->d_02_head->DbValue = $row['d_02_head'];
        $this->d_03_head->DbValue = $row['d_03_head'];
        $this->d_04_head->DbValue = $row['d_04_head'];
        $this->d_05_head->DbValue = $row['d_05_head'];
        $this->d_06_head->DbValue = $row['d_06_head'];
        $this->d_07_head->DbValue = $row['d_07_head'];
        $this->d_08_head->DbValue = $row['d_08_head'];
        $this->sample->DbValue = $row['sample'];
        $this->balance_quantity->DbValue = $row['balance_quantity'];
        $this->_action->DbValue = $row['action'];
        $this->url->DbValue = $row['url'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("polist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "poview" => $Language->phrase("View"),
            "poedit" => $Language->phrase("Edit"),
            "poadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "polist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PoView",
            Config("API_ADD_ACTION") => "PoAdd",
            Config("API_EDIT_ACTION") => "PoEdit",
            Config("API_DELETE_ACTION") => "PoDelete",
            Config("API_LIST_ACTION") => "PoList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "polist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("poview", $parm);
        } else {
            $url = $this->keyUrl("poview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "poadd?" . $parm;
        } else {
            $url = "poadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("poedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("polist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("poadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("polist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("podelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->order_type->setDbValue($row['order_type']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->buyer_order_no->setDbValue($row['buyer_order_no']);
        $this->buyer_order_date->setDbValue($row['buyer_order_date']);
        $this->cart_id->setDbValue($row['cart_id']);
        $this->buyer_product_ref->setDbValue($row['buyer_product_ref']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->fob_date->setDbValue($row['fob_date']);
        $this->part_dispatch->setDbValue($row['part_dispatch']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->transport_terms->setDbValue($row['transport_terms']);
        $this->buyer_shipping_id->setDbValue($row['buyer_shipping _id']);
        $this->description_04->setDbValue($row['description_04']);
        $this->description_03->setDbValue($row['description_03']);
        $this->description_01->setDbValue($row['description_01']);
        $this->description_02->setDbValue($row['description_02']);
        $this->description_07->setDbValue($row['description_07']);
        $this->description_20->setDbValue($row['description_20']);
        $this->description_17->setDbValue($row['description_17']);
        $this->description_18->setDbValue($row['description_18']);
        $this->description_19->setDbValue($row['description_19']);
        $this->quantity->setDbValue($row['quantity']);
        $this->price->setDbValue($row['price']);
        $this->currency->setDbValue($row['currency']);
        $this->amount->setDbValue($row['amount']);
        $this->cbm->setDbValue($row['cbm']);
        $this->buyer_size->setDbValue($row['buyer_size']);
        $this->description_05->setDbValue($row['description_05']);
        $this->description_06->setDbValue($row['description_06']);
        $this->description_08->setDbValue($row['description_08']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->buyer_instruction->setDbValue($row['buyer_instruction']);
        $this->d_09_head->setDbValue($row['d_09_head']);
        $this->description_09->setDbValue($row['description_09']);
        $this->d_10_head->setDbValue($row['d_10_head']);
        $this->description_10->setDbValue($row['description_10']);
        $this->d_11_head->setDbValue($row['d_11_head']);
        $this->description_11->setDbValue($row['description_11']);
        $this->d_12_head->setDbValue($row['d_12_head']);
        $this->description_12->setDbValue($row['description_12']);
        $this->po->setDbValue($row['po']);
        $this->production_site->setDbValue($row['production_site']);
        $this->c_total->setDbValue($row['c_total']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->product_gcode->setDbValue($row['product_gcode']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->uploads->setDbValue($row['uploads']);
        $this->d_01_head->setDbValue($row['d_01_head']);
        $this->d_02_head->setDbValue($row['d_02_head']);
        $this->d_03_head->setDbValue($row['d_03_head']);
        $this->d_04_head->setDbValue($row['d_04_head']);
        $this->d_05_head->setDbValue($row['d_05_head']);
        $this->d_06_head->setDbValue($row['d_06_head']);
        $this->d_07_head->setDbValue($row['d_07_head']);
        $this->d_08_head->setDbValue($row['d_08_head']);
        $this->sample->setDbValue($row['sample']);
        $this->balance_quantity->setDbValue($row['balance_quantity']);
        $this->_action->setDbValue($row['action']);
        $this->url->setDbValue($row['url']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PoList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // order_type

        // buyer_id

        // buyer_order_no

        // buyer_order_date

        // cart_id

        // buyer_product_ref

        // grp

        // s_grp

        // product

        // rid

        // despatch_date

        // despatch_week

        // fob_date

        // part_dispatch

        // payment_terms

        // transport_terms

        // buyer_shipping _id

        // description_04

        // description_03

        // description_01
        $this->description_01->CellCssStyle = "white-space: nowrap;";

        // description_02
        $this->description_02->CellCssStyle = "white-space: nowrap;";

        // description_07

        // description_20

        // description_17

        // description_18

        // description_19

        // quantity

        // price

        // currency
        $this->currency->CellCssStyle = "white-space: nowrap;";

        // amount

        // cbm

        // buyer_size

        // description_05

        // description_06

        // description_08

        // remarks

        // operator

        // datetime

        // a_operator

        // a_datetime

        // jc_no
        $this->jc_no->CellCssStyle = "white-space: nowrap;";

        // buyer_instruction

        // d_09_head

        // description_09

        // d_10_head

        // description_10

        // d_11_head

        // description_11

        // d_12_head

        // description_12

        // po
        $this->po->CellCssStyle = "white-space: nowrap;";

        // production_site
        $this->production_site->CellCssStyle = "white-space: nowrap;";

        // c_total
        $this->c_total->CellCssStyle = "white-space: nowrap;";

        // production_plan
        $this->production_plan->CellCssStyle = "white-space: nowrap;";

        // lot_no
        $this->lot_no->CellCssStyle = "white-space: nowrap;";

        // product_gcode
        $this->product_gcode->CellCssStyle = "white-space: nowrap;";

        // batch_no
        $this->batch_no->CellCssStyle = "white-space: nowrap;";

        // uploads
        $this->uploads->CellCssStyle = "white-space: nowrap;";

        // d_01_head
        $this->d_01_head->CellCssStyle = "white-space: nowrap;";

        // d_02_head
        $this->d_02_head->CellCssStyle = "white-space: nowrap;";

        // d_03_head
        $this->d_03_head->CellCssStyle = "white-space: nowrap;";

        // d_04_head
        $this->d_04_head->CellCssStyle = "white-space: nowrap;";

        // d_05_head
        $this->d_05_head->CellCssStyle = "white-space: nowrap;";

        // d_06_head
        $this->d_06_head->CellCssStyle = "white-space: nowrap;";

        // d_07_head
        $this->d_07_head->CellCssStyle = "white-space: nowrap;";

        // d_08_head
        $this->d_08_head->CellCssStyle = "white-space: nowrap;";

        // sample
        $this->sample->CellCssStyle = "white-space: nowrap;";

        // balance_quantity
        $this->balance_quantity->CellCssStyle = "white-space: nowrap;";

        // action

        // url
        $this->url->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // order_type
        if (strval($this->order_type->CurrentValue) != "") {
            $this->order_type->ViewValue = $this->order_type->optionCaption($this->order_type->CurrentValue);
        } else {
            $this->order_type->ViewValue = null;
        }

        // buyer_id
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                }
            }
        } else {
            $this->buyer_id->ViewValue = null;
        }

        // buyer_order_no
        $this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;

        // buyer_order_date
        $this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
        $this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, $this->buyer_order_date->formatPattern());

        // cart_id
        $curVal = strval($this->cart_id->CurrentValue);
        if ($curVal != "") {
            $this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
            if ($this->cart_id->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->cart_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->cart_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->cart_id->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->cart_id->Lookup->renderViewRow($row);
                        $this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
                    }
                } else {
                    $this->cart_id->ViewValue = $this->cart_id->CurrentValue;
                }
            }
        } else {
            $this->cart_id->ViewValue = null;
        }

        // buyer_product_ref
        $this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // rid
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->ViewValue = $this->rid->CurrentValue;
                }
            }
        } else {
            $this->rid->ViewValue = null;
        }

        // despatch_date
        $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
        $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

        // despatch_week
        $curVal = strval($this->despatch_week->CurrentValue);
        if ($curVal != "") {
            $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            if ($this->despatch_week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                    $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                } else {
                    $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                }
            }
        } else {
            $this->despatch_week->ViewValue = null;
        }

        // fob_date
        $this->fob_date->ViewValue = $this->fob_date->CurrentValue;
        $this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, $this->fob_date->formatPattern());

        // part_dispatch
        if (strval($this->part_dispatch->CurrentValue) != "") {
            $this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
        } else {
            $this->part_dispatch->ViewValue = null;
        }

        // payment_terms
        $curVal = strval($this->payment_terms->CurrentValue);
        if ($curVal != "") {
            $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
            if ($this->payment_terms->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                    $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                } else {
                    $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                }
            }
        } else {
            $this->payment_terms->ViewValue = null;
        }

        // transport_terms
        $this->transport_terms->ViewValue = $this->transport_terms->CurrentValue;

        // buyer_shipping _id
        $this->buyer_shipping_id->ViewValue = $this->buyer_shipping_id->CurrentValue;
        $this->buyer_shipping_id->ViewValue = FormatNumber($this->buyer_shipping_id->ViewValue, $this->buyer_shipping_id->formatPattern());

        // description_04
        $this->description_04->ViewValue = $this->description_04->CurrentValue;

        // description_03
        if (strval($this->description_03->CurrentValue) != "") {
            $this->description_03->ViewValue = $this->description_03->optionCaption($this->description_03->CurrentValue);
        } else {
            $this->description_03->ViewValue = null;
        }

        // description_01
        $this->description_01->ViewValue = $this->description_01->CurrentValue;
        $this->description_01->ViewValue = FormatNumber($this->description_01->ViewValue, $this->description_01->formatPattern());

        // description_02
        $this->description_02->ViewValue = $this->description_02->CurrentValue;
        $this->description_02->ViewValue = FormatNumber($this->description_02->ViewValue, $this->description_02->formatPattern());

        // description_07
        $this->description_07->ViewValue = $this->description_07->CurrentValue;

        // description_20
        if (strval($this->description_20->CurrentValue) != "") {
            $this->description_20->ViewValue = $this->description_20->optionCaption($this->description_20->CurrentValue);
        } else {
            $this->description_20->ViewValue = null;
        }

        // description_17
        $this->description_17->ViewValue = $this->description_17->CurrentValue;
        $this->description_17->ViewValue = FormatNumber($this->description_17->ViewValue, $this->description_17->formatPattern());

        // description_18
        $this->description_18->ViewValue = $this->description_18->CurrentValue;
        $this->description_18->ViewValue = FormatNumber($this->description_18->ViewValue, $this->description_18->formatPattern());

        // description_19
        $this->description_19->ViewValue = $this->description_19->CurrentValue;
        $this->description_19->ViewValue = FormatNumber($this->description_19->ViewValue, $this->description_19->formatPattern());

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // price
        $this->price->ViewValue = $this->price->CurrentValue;
        $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

        // currency
        $curVal = strval($this->currency->CurrentValue);
        if ($curVal != "") {
            $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            if ($this->currency->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                    $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                } else {
                    $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                }
            }
        } else {
            $this->currency->ViewValue = null;
        }

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

        // cbm
        $this->cbm->ViewValue = $this->cbm->CurrentValue;
        $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

        // buyer_size
        $this->buyer_size->ViewValue = $this->buyer_size->CurrentValue;

        // description_05
        $curVal = strval($this->description_05->CurrentValue);
        if ($curVal != "") {
            $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
            if ($this->description_05->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->description_05->Lookup->renderViewRow($rswrk[0]);
                    $this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
                } else {
                    $this->description_05->ViewValue = $this->description_05->CurrentValue;
                }
            }
        } else {
            $this->description_05->ViewValue = null;
        }

        // description_06
        $this->description_06->ViewValue = $this->description_06->CurrentValue;

        // description_08
        $this->description_08->ViewValue = $this->description_08->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // a_operator
        $curVal = strval($this->a_operator->CurrentValue);
        if ($curVal != "") {
            $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            if ($this->a_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                } else {
                    $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                }
            }
        } else {
            $this->a_operator->ViewValue = null;
        }

        // a_datetime
        $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
        $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;

        // buyer_instruction
        $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

        // d_09_head
        $curVal = strval($this->d_09_head->CurrentValue);
        if ($curVal != "") {
            $this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
            if ($this->d_09_head->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->d_09_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_09_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->d_09_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->d_09_head->Lookup->renderViewRow($rswrk[0]);
                    $this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
                } else {
                    $this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
                }
            }
        } else {
            $this->d_09_head->ViewValue = null;
        }

        // description_09
        $this->description_09->ViewValue = $this->description_09->CurrentValue;

        // d_10_head
        $curVal = strval($this->d_10_head->CurrentValue);
        if ($curVal != "") {
            $this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
            if ($this->d_10_head->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->d_10_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_10_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->d_10_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->d_10_head->Lookup->renderViewRow($rswrk[0]);
                    $this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
                } else {
                    $this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
                }
            }
        } else {
            $this->d_10_head->ViewValue = null;
        }

        // description_10
        $this->description_10->ViewValue = $this->description_10->CurrentValue;

        // d_11_head
        $curVal = strval($this->d_11_head->CurrentValue);
        if ($curVal != "") {
            $this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
            if ($this->d_11_head->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->d_11_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_11_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->d_11_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->d_11_head->Lookup->renderViewRow($rswrk[0]);
                    $this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
                } else {
                    $this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
                }
            }
        } else {
            $this->d_11_head->ViewValue = null;
        }

        // description_11
        $this->description_11->ViewValue = $this->description_11->CurrentValue;

        // d_12_head
        $curVal = strval($this->d_12_head->CurrentValue);
        if ($curVal != "") {
            $this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
            if ($this->d_12_head->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->d_12_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_12_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->d_12_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->d_12_head->Lookup->renderViewRow($rswrk[0]);
                    $this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
                } else {
                    $this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
                }
            }
        } else {
            $this->d_12_head->ViewValue = null;
        }

        // description_12
        $this->description_12->ViewValue = $this->description_12->CurrentValue;

        // po
        $this->po->ViewValue = $this->po->CurrentValue;

        // production_site
        $curVal = strval($this->production_site->CurrentValue);
        if ($curVal != "") {
            $this->production_site->ViewValue = $this->production_site->lookupCacheOption($curVal);
            if ($this->production_site->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->production_site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->production_site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->production_site->getSelectFilter($this); // PHP
                $sqlWrk = $this->production_site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->production_site->Lookup->renderViewRow($rswrk[0]);
                    $this->production_site->ViewValue = $this->production_site->displayValue($arwrk);
                } else {
                    $this->production_site->ViewValue = FormatNumber($this->production_site->CurrentValue, $this->production_site->formatPattern());
                }
            }
        } else {
            $this->production_site->ViewValue = null;
        }

        // c_total
        $this->c_total->ViewValue = $this->c_total->CurrentValue;
        $this->c_total->ViewValue = FormatNumber($this->c_total->ViewValue, $this->c_total->formatPattern());

        // production_plan
        if (strval($this->production_plan->CurrentValue) != "") {
            $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
        } else {
            $this->production_plan->ViewValue = null;
        }

        // lot_no
        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

        // product_gcode
        $this->product_gcode->ViewValue = $this->product_gcode->CurrentValue;

        // batch_no
        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;

        // uploads
        $this->uploads->ViewValue = $this->uploads->CurrentValue;

        // d_01_head
        $this->d_01_head->ViewValue = $this->d_01_head->CurrentValue;
        $this->d_01_head->ViewValue = FormatNumber($this->d_01_head->ViewValue, $this->d_01_head->formatPattern());

        // d_02_head
        $this->d_02_head->ViewValue = $this->d_02_head->CurrentValue;
        $this->d_02_head->ViewValue = FormatNumber($this->d_02_head->ViewValue, $this->d_02_head->formatPattern());

        // d_03_head
        $this->d_03_head->ViewValue = $this->d_03_head->CurrentValue;
        $this->d_03_head->ViewValue = FormatNumber($this->d_03_head->ViewValue, $this->d_03_head->formatPattern());

        // d_04_head
        $this->d_04_head->ViewValue = $this->d_04_head->CurrentValue;
        $this->d_04_head->ViewValue = FormatNumber($this->d_04_head->ViewValue, $this->d_04_head->formatPattern());

        // d_05_head
        $this->d_05_head->ViewValue = $this->d_05_head->CurrentValue;
        $this->d_05_head->ViewValue = FormatNumber($this->d_05_head->ViewValue, $this->d_05_head->formatPattern());

        // d_06_head
        $this->d_06_head->ViewValue = $this->d_06_head->CurrentValue;
        $this->d_06_head->ViewValue = FormatNumber($this->d_06_head->ViewValue, $this->d_06_head->formatPattern());

        // d_07_head
        $this->d_07_head->ViewValue = $this->d_07_head->CurrentValue;
        $this->d_07_head->ViewValue = FormatNumber($this->d_07_head->ViewValue, $this->d_07_head->formatPattern());

        // d_08_head
        $this->d_08_head->ViewValue = $this->d_08_head->CurrentValue;
        $this->d_08_head->ViewValue = FormatNumber($this->d_08_head->ViewValue, $this->d_08_head->formatPattern());

        // sample
        $this->sample->ViewValue = $this->sample->CurrentValue;
        $this->sample->ViewValue = FormatNumber($this->sample->ViewValue, $this->sample->formatPattern());

        // balance_quantity
        $this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
        $this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, $this->balance_quantity->formatPattern());

        // action
        $this->_action->ViewValue = $this->_action->CurrentValue;
        $this->_action->CssClass = "fw-bold";
        $this->_action->ViewCustomAttributes = $this->_action->getViewCustomAttributes(); // PHP

        // url
        $this->url->ViewValue = $this->url->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // order_type
        $this->order_type->HrefValue = "";
        $this->order_type->TooltipValue = "";

        // buyer_id
        $this->buyer_id->HrefValue = "";
        $this->buyer_id->TooltipValue = "";

        // buyer_order_no
        $this->buyer_order_no->HrefValue = "";
        $this->buyer_order_no->TooltipValue = "";

        // buyer_order_date
        $this->buyer_order_date->HrefValue = "";
        $this->buyer_order_date->TooltipValue = "";

        // cart_id
        $this->cart_id->HrefValue = "";
        $this->cart_id->TooltipValue = "";

        // buyer_product_ref
        $this->buyer_product_ref->HrefValue = "";
        $this->buyer_product_ref->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        if (!EmptyValue($this->s_grp->CurrentValue)) {
            $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
            $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
            }
        } else {
            $this->s_grp->HrefValue = "";
        }
        $this->s_grp->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // rid
        if (!EmptyValue($this->rid->CurrentValue)) {
            $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
            $this->rid->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
            }
        } else {
            $this->rid->HrefValue = "";
        }
        $this->rid->TooltipValue = "";

        // despatch_date
        $this->despatch_date->HrefValue = "";
        $this->despatch_date->TooltipValue = "";

        // despatch_week
        $this->despatch_week->HrefValue = "";
        $this->despatch_week->TooltipValue = "";

        // fob_date
        $this->fob_date->HrefValue = "";
        $this->fob_date->TooltipValue = "";

        // part_dispatch
        $this->part_dispatch->HrefValue = "";
        $this->part_dispatch->TooltipValue = "";

        // payment_terms
        $this->payment_terms->HrefValue = "";
        $this->payment_terms->TooltipValue = "";

        // transport_terms
        $this->transport_terms->HrefValue = "";
        $this->transport_terms->TooltipValue = "";

        // buyer_shipping _id
        $this->buyer_shipping_id->HrefValue = "";
        $this->buyer_shipping_id->TooltipValue = "";

        // description_04
        $this->description_04->HrefValue = "";
        $this->description_04->TooltipValue = "";

        // description_03
        $this->description_03->HrefValue = "";
        $this->description_03->TooltipValue = "";

        // description_01
        $this->description_01->HrefValue = "";
        $this->description_01->TooltipValue = "";

        // description_02
        $this->description_02->HrefValue = "";
        $this->description_02->TooltipValue = "";

        // description_07
        $this->description_07->HrefValue = "";
        $this->description_07->TooltipValue = "";

        // description_20
        $this->description_20->HrefValue = "";
        $this->description_20->TooltipValue = "";

        // description_17
        $this->description_17->HrefValue = "";
        $this->description_17->TooltipValue = "";

        // description_18
        $this->description_18->HrefValue = "";
        $this->description_18->TooltipValue = "";

        // description_19
        $this->description_19->HrefValue = "";
        $this->description_19->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // price
        $this->price->HrefValue = "";
        $this->price->TooltipValue = "";

        // currency
        $this->currency->HrefValue = "";
        $this->currency->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // cbm
        $this->cbm->HrefValue = "";
        $this->cbm->TooltipValue = "";

        // buyer_size
        $this->buyer_size->HrefValue = "";
        $this->buyer_size->TooltipValue = "";

        // description_05
        $this->description_05->HrefValue = "";
        $this->description_05->TooltipValue = "";

        // description_06
        $this->description_06->HrefValue = "";
        $this->description_06->TooltipValue = "";

        // description_08
        $this->description_08->HrefValue = "";
        $this->description_08->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // a_operator
        $this->a_operator->HrefValue = "";
        $this->a_operator->TooltipValue = "";

        // a_datetime
        $this->a_datetime->HrefValue = "";
        $this->a_datetime->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // buyer_instruction
        $this->buyer_instruction->HrefValue = "";
        $this->buyer_instruction->TooltipValue = "";

        // d_09_head
        $this->d_09_head->HrefValue = "";
        $this->d_09_head->TooltipValue = "";

        // description_09
        $this->description_09->HrefValue = "";
        $this->description_09->TooltipValue = "";

        // d_10_head
        $this->d_10_head->HrefValue = "";
        $this->d_10_head->TooltipValue = "";

        // description_10
        $this->description_10->HrefValue = "";
        $this->description_10->TooltipValue = "";

        // d_11_head
        $this->d_11_head->HrefValue = "";
        $this->d_11_head->TooltipValue = "";

        // description_11
        $this->description_11->HrefValue = "";
        $this->description_11->TooltipValue = "";

        // d_12_head
        $this->d_12_head->HrefValue = "";
        $this->d_12_head->TooltipValue = "";

        // description_12
        $this->description_12->HrefValue = "";
        $this->description_12->TooltipValue = "";

        // po
        if (!EmptyValue($this->po->CurrentValue)) {
            $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
            $this->po->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
            }
        } else {
            $this->po->HrefValue = "";
        }
        $this->po->TooltipValue = "";

        // production_site
        $this->production_site->HrefValue = "";
        $this->production_site->TooltipValue = "";

        // c_total
        $this->c_total->HrefValue = "";
        $this->c_total->TooltipValue = "";

        // production_plan
        $this->production_plan->HrefValue = "";
        $this->production_plan->TooltipValue = "";

        // lot_no
        $this->lot_no->HrefValue = "";
        $this->lot_no->TooltipValue = "";

        // product_gcode
        $this->product_gcode->HrefValue = "";
        $this->product_gcode->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // uploads
        $this->uploads->HrefValue = "";
        $this->uploads->TooltipValue = "";

        // d_01_head
        $this->d_01_head->HrefValue = "";
        $this->d_01_head->TooltipValue = "";

        // d_02_head
        $this->d_02_head->HrefValue = "";
        $this->d_02_head->TooltipValue = "";

        // d_03_head
        $this->d_03_head->HrefValue = "";
        $this->d_03_head->TooltipValue = "";

        // d_04_head
        $this->d_04_head->HrefValue = "";
        $this->d_04_head->TooltipValue = "";

        // d_05_head
        $this->d_05_head->HrefValue = "";
        $this->d_05_head->TooltipValue = "";

        // d_06_head
        $this->d_06_head->HrefValue = "";
        $this->d_06_head->TooltipValue = "";

        // d_07_head
        $this->d_07_head->HrefValue = "";
        $this->d_07_head->TooltipValue = "";

        // d_08_head
        $this->d_08_head->HrefValue = "";
        $this->d_08_head->TooltipValue = "";

        // sample
        $this->sample->HrefValue = "";
        $this->sample->TooltipValue = "";

        // balance_quantity
        $this->balance_quantity->HrefValue = "";
        $this->balance_quantity->TooltipValue = "";

        // action
        if (!EmptyValue($this->url->CurrentValue)) {
            $this->_action->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
            $this->_action->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->_action->HrefValue = FullUrl($this->_action->HrefValue, "href");
            }
        } else {
            $this->_action->HrefValue = "";
        }
        $this->_action->TooltipValue = "";

        // url
        $this->url->HrefValue = "";
        $this->url->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // order_type
        $this->order_type->EditValue = $this->order_type->options(false);
        $this->order_type->PlaceHolder = RemoveHtml($this->order_type->caption());

        // buyer_id
        $this->buyer_id->setupEditAttributes();
        $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

        // buyer_order_no
        $this->buyer_order_no->setupEditAttributes();
        if (!$this->buyer_order_no->Raw) {
            $this->buyer_order_no->CurrentValue = HtmlDecode($this->buyer_order_no->CurrentValue);
        }
        $this->buyer_order_no->EditValue = $this->buyer_order_no->CurrentValue;
        $this->buyer_order_no->PlaceHolder = RemoveHtml($this->buyer_order_no->caption());

        // buyer_order_date
        $this->buyer_order_date->setupEditAttributes();
        $this->buyer_order_date->EditValue = FormatDateTime($this->buyer_order_date->CurrentValue, $this->buyer_order_date->formatPattern());
        $this->buyer_order_date->PlaceHolder = RemoveHtml($this->buyer_order_date->caption());

        // cart_id
        $this->cart_id->PlaceHolder = RemoveHtml($this->cart_id->caption());

        // buyer_product_ref
        $this->buyer_product_ref->setupEditAttributes();
        if (!$this->buyer_product_ref->Raw) {
            $this->buyer_product_ref->CurrentValue = HtmlDecode($this->buyer_product_ref->CurrentValue);
        }
        $this->buyer_product_ref->EditValue = $this->buyer_product_ref->CurrentValue;
        $this->buyer_product_ref->PlaceHolder = RemoveHtml($this->buyer_product_ref->caption());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // rid
        $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

        // despatch_date
        $this->despatch_date->setupEditAttributes();
        $this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

        // despatch_week
        $this->despatch_week->setupEditAttributes();
        $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

        // fob_date
        $this->fob_date->setupEditAttributes();
        $this->fob_date->EditValue = FormatDateTime($this->fob_date->CurrentValue, $this->fob_date->formatPattern());
        $this->fob_date->PlaceHolder = RemoveHtml($this->fob_date->caption());

        // part_dispatch
        $this->part_dispatch->setupEditAttributes();
        $this->part_dispatch->EditValue = $this->part_dispatch->options(true);
        $this->part_dispatch->PlaceHolder = RemoveHtml($this->part_dispatch->caption());

        // payment_terms
        $this->payment_terms->setupEditAttributes();
        $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

        // transport_terms
        $this->transport_terms->setupEditAttributes();
        if (!$this->transport_terms->Raw) {
            $this->transport_terms->CurrentValue = HtmlDecode($this->transport_terms->CurrentValue);
        }
        $this->transport_terms->EditValue = $this->transport_terms->CurrentValue;
        $this->transport_terms->PlaceHolder = RemoveHtml($this->transport_terms->caption());

        // buyer_shipping _id
        $this->buyer_shipping_id->setupEditAttributes();
        $this->buyer_shipping_id->EditValue = $this->buyer_shipping_id->CurrentValue;
        $this->buyer_shipping_id->PlaceHolder = RemoveHtml($this->buyer_shipping_id->caption());
        if (strval($this->buyer_shipping_id->EditValue) != "" && is_numeric($this->buyer_shipping_id->EditValue)) {
            $this->buyer_shipping_id->EditValue = FormatNumber($this->buyer_shipping_id->EditValue, null);
        }

        // description_04
        $this->description_04->setupEditAttributes();
        $this->description_04->EditValue = $this->description_04->CurrentValue;
        $this->description_04->PlaceHolder = RemoveHtml($this->description_04->caption());

        // description_03
        $this->description_03->setupEditAttributes();
        $this->description_03->EditValue = $this->description_03->options(true);
        $this->description_03->PlaceHolder = RemoveHtml($this->description_03->caption());

        // description_01
        $this->description_01->setupEditAttributes();
        $this->description_01->EditValue = $this->description_01->CurrentValue;
        $this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());
        if (strval($this->description_01->EditValue) != "" && is_numeric($this->description_01->EditValue)) {
            $this->description_01->EditValue = FormatNumber($this->description_01->EditValue, null);
        }

        // description_02
        $this->description_02->setupEditAttributes();
        $this->description_02->EditValue = $this->description_02->CurrentValue;
        $this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());
        if (strval($this->description_02->EditValue) != "" && is_numeric($this->description_02->EditValue)) {
            $this->description_02->EditValue = FormatNumber($this->description_02->EditValue, null);
        }

        // description_07
        $this->description_07->setupEditAttributes();
        $this->description_07->EditValue = $this->description_07->CurrentValue;
        $this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());
        if (strval($this->description_07->EditValue) != "" && is_numeric($this->description_07->EditValue)) {
            $this->description_07->EditValue = $this->description_07->EditValue;
        }

        // description_20
        $this->description_20->setupEditAttributes();
        $this->description_20->EditValue = $this->description_20->options(true);
        $this->description_20->PlaceHolder = RemoveHtml($this->description_20->caption());

        // description_17
        $this->description_17->setupEditAttributes();
        $this->description_17->EditCustomAttributes = $this->description_17->getEditCustomAttributes(); // PHP
        $this->description_17->EditValue = $this->description_17->CurrentValue;
        $this->description_17->PlaceHolder = RemoveHtml($this->description_17->caption());
        if (strval($this->description_17->EditValue) != "" && is_numeric($this->description_17->EditValue)) {
            $this->description_17->EditValue = FormatNumber($this->description_17->EditValue, null);
        }

        // description_18
        $this->description_18->setupEditAttributes();
        $this->description_18->EditCustomAttributes = $this->description_18->getEditCustomAttributes(); // PHP
        $this->description_18->EditValue = $this->description_18->CurrentValue;
        $this->description_18->PlaceHolder = RemoveHtml($this->description_18->caption());
        if (strval($this->description_18->EditValue) != "" && is_numeric($this->description_18->EditValue)) {
            $this->description_18->EditValue = FormatNumber($this->description_18->EditValue, null);
        }

        // description_19
        $this->description_19->setupEditAttributes();
        $this->description_19->EditCustomAttributes = $this->description_19->getEditCustomAttributes(); // PHP
        $this->description_19->EditValue = $this->description_19->CurrentValue;
        $this->description_19->PlaceHolder = RemoveHtml($this->description_19->caption());
        if (strval($this->description_19->EditValue) != "" && is_numeric($this->description_19->EditValue)) {
            $this->description_19->EditValue = FormatNumber($this->description_19->EditValue, null);
        }

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // price
        $this->price->setupEditAttributes();
        $this->price->EditCustomAttributes = $this->price->getEditCustomAttributes(); // PHP
        $this->price->EditValue = $this->price->CurrentValue;
        $this->price->PlaceHolder = RemoveHtml($this->price->caption());
        if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
            $this->price->EditValue = FormatNumber($this->price->EditValue, null);
        }

        // currency
        $this->currency->setupEditAttributes();
        $this->currency->EditCustomAttributes = $this->currency->getEditCustomAttributes(); // PHP
        $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
        if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
        }

        // cbm
        $this->cbm->setupEditAttributes();
        $this->cbm->EditCustomAttributes = $this->cbm->getEditCustomAttributes(); // PHP
        $this->cbm->EditValue = $this->cbm->CurrentValue;
        $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
        if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
            $this->cbm->EditValue = FormatNumber($this->cbm->EditValue, null);
        }

        // buyer_size
        $this->buyer_size->setupEditAttributes();
        if (!$this->buyer_size->Raw) {
            $this->buyer_size->CurrentValue = HtmlDecode($this->buyer_size->CurrentValue);
        }
        $this->buyer_size->EditValue = $this->buyer_size->CurrentValue;
        $this->buyer_size->PlaceHolder = RemoveHtml($this->buyer_size->caption());

        // description_05
        $this->description_05->setupEditAttributes();
        $this->description_05->PlaceHolder = RemoveHtml($this->description_05->caption());

        // description_06
        $this->description_06->setupEditAttributes();
        $this->description_06->EditValue = $this->description_06->CurrentValue;
        $this->description_06->PlaceHolder = RemoveHtml($this->description_06->caption());
        if (strval($this->description_06->EditValue) != "" && is_numeric($this->description_06->EditValue)) {
            $this->description_06->EditValue = $this->description_06->EditValue;
        }

        // description_08
        $this->description_08->setupEditAttributes();
        $this->description_08->EditValue = $this->description_08->CurrentValue;
        $this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());
        if (strval($this->description_08->EditValue) != "" && is_numeric($this->description_08->EditValue)) {
            $this->description_08->EditValue = $this->description_08->EditValue;
        }

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // operator

        // datetime

        // a_operator

        // a_datetime

        // jc_no
        $this->jc_no->setupEditAttributes();
        if (!$this->jc_no->Raw) {
            $this->jc_no->CurrentValue = HtmlDecode($this->jc_no->CurrentValue);
        }
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

        // buyer_instruction
        $this->buyer_instruction->setupEditAttributes();
        $this->buyer_instruction->EditValue = $this->buyer_instruction->CurrentValue;
        $this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

        // d_09_head
        $this->d_09_head->setupEditAttributes();
        $this->d_09_head->PlaceHolder = RemoveHtml($this->d_09_head->caption());

        // description_09
        $this->description_09->setupEditAttributes();
        if (!$this->description_09->Raw) {
            $this->description_09->CurrentValue = HtmlDecode($this->description_09->CurrentValue);
        }
        $this->description_09->EditValue = $this->description_09->CurrentValue;
        $this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

        // d_10_head
        $this->d_10_head->setupEditAttributes();
        $this->d_10_head->PlaceHolder = RemoveHtml($this->d_10_head->caption());

        // description_10
        $this->description_10->setupEditAttributes();
        if (!$this->description_10->Raw) {
            $this->description_10->CurrentValue = HtmlDecode($this->description_10->CurrentValue);
        }
        $this->description_10->EditValue = $this->description_10->CurrentValue;
        $this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

        // d_11_head
        $this->d_11_head->setupEditAttributes();
        $this->d_11_head->PlaceHolder = RemoveHtml($this->d_11_head->caption());

        // description_11
        $this->description_11->setupEditAttributes();
        if (!$this->description_11->Raw) {
            $this->description_11->CurrentValue = HtmlDecode($this->description_11->CurrentValue);
        }
        $this->description_11->EditValue = $this->description_11->CurrentValue;
        $this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

        // d_12_head
        $this->d_12_head->setupEditAttributes();
        $this->d_12_head->PlaceHolder = RemoveHtml($this->d_12_head->caption());

        // description_12
        $this->description_12->setupEditAttributes();
        if (!$this->description_12->Raw) {
            $this->description_12->CurrentValue = HtmlDecode($this->description_12->CurrentValue);
        }
        $this->description_12->EditValue = $this->description_12->CurrentValue;
        $this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->PlaceHolder = RemoveHtml($this->po->caption());
        if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
            $this->po->EditValue = $this->po->EditValue;
        }

        // production_site
        $this->production_site->setupEditAttributes();
        $this->production_site->PlaceHolder = RemoveHtml($this->production_site->caption());

        // c_total
        $this->c_total->setupEditAttributes();
        $this->c_total->EditValue = $this->c_total->CurrentValue;
        $this->c_total->PlaceHolder = RemoveHtml($this->c_total->caption());
        if (strval($this->c_total->EditValue) != "" && is_numeric($this->c_total->EditValue)) {
            $this->c_total->EditValue = FormatNumber($this->c_total->EditValue, null);
        }

        // production_plan
        $this->production_plan->setupEditAttributes();
        $this->production_plan->EditValue = $this->production_plan->options(true);
        $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

        // lot_no
        $this->lot_no->setupEditAttributes();
        if (!$this->lot_no->Raw) {
            $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
        }
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;
        $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

        // product_gcode
        $this->product_gcode->setupEditAttributes();
        if (!$this->product_gcode->Raw) {
            $this->product_gcode->CurrentValue = HtmlDecode($this->product_gcode->CurrentValue);
        }
        $this->product_gcode->EditValue = $this->product_gcode->CurrentValue;
        $this->product_gcode->PlaceHolder = RemoveHtml($this->product_gcode->caption());

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->EditValue = $this->batch_no->CurrentValue;
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());
        if (strval($this->batch_no->EditValue) != "" && is_numeric($this->batch_no->EditValue)) {
            $this->batch_no->EditValue = $this->batch_no->EditValue;
        }

        // uploads
        $this->uploads->setupEditAttributes();
        $this->uploads->EditValue = $this->uploads->CurrentValue;
        $this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

        // d_01_head
        $this->d_01_head->setupEditAttributes();
        $this->d_01_head->EditValue = $this->d_01_head->CurrentValue;
        $this->d_01_head->PlaceHolder = RemoveHtml($this->d_01_head->caption());
        if (strval($this->d_01_head->EditValue) != "" && is_numeric($this->d_01_head->EditValue)) {
            $this->d_01_head->EditValue = FormatNumber($this->d_01_head->EditValue, null);
        }

        // d_02_head
        $this->d_02_head->setupEditAttributes();
        $this->d_02_head->EditValue = $this->d_02_head->CurrentValue;
        $this->d_02_head->PlaceHolder = RemoveHtml($this->d_02_head->caption());
        if (strval($this->d_02_head->EditValue) != "" && is_numeric($this->d_02_head->EditValue)) {
            $this->d_02_head->EditValue = FormatNumber($this->d_02_head->EditValue, null);
        }

        // d_03_head
        $this->d_03_head->setupEditAttributes();
        $this->d_03_head->EditValue = $this->d_03_head->CurrentValue;
        $this->d_03_head->PlaceHolder = RemoveHtml($this->d_03_head->caption());
        if (strval($this->d_03_head->EditValue) != "" && is_numeric($this->d_03_head->EditValue)) {
            $this->d_03_head->EditValue = FormatNumber($this->d_03_head->EditValue, null);
        }

        // d_04_head
        $this->d_04_head->setupEditAttributes();
        $this->d_04_head->EditValue = $this->d_04_head->CurrentValue;
        $this->d_04_head->PlaceHolder = RemoveHtml($this->d_04_head->caption());
        if (strval($this->d_04_head->EditValue) != "" && is_numeric($this->d_04_head->EditValue)) {
            $this->d_04_head->EditValue = FormatNumber($this->d_04_head->EditValue, null);
        }

        // d_05_head
        $this->d_05_head->setupEditAttributes();
        $this->d_05_head->EditValue = $this->d_05_head->CurrentValue;
        $this->d_05_head->PlaceHolder = RemoveHtml($this->d_05_head->caption());
        if (strval($this->d_05_head->EditValue) != "" && is_numeric($this->d_05_head->EditValue)) {
            $this->d_05_head->EditValue = FormatNumber($this->d_05_head->EditValue, null);
        }

        // d_06_head
        $this->d_06_head->setupEditAttributes();
        $this->d_06_head->EditValue = $this->d_06_head->CurrentValue;
        $this->d_06_head->PlaceHolder = RemoveHtml($this->d_06_head->caption());
        if (strval($this->d_06_head->EditValue) != "" && is_numeric($this->d_06_head->EditValue)) {
            $this->d_06_head->EditValue = FormatNumber($this->d_06_head->EditValue, null);
        }

        // d_07_head
        $this->d_07_head->setupEditAttributes();
        $this->d_07_head->EditValue = $this->d_07_head->CurrentValue;
        $this->d_07_head->PlaceHolder = RemoveHtml($this->d_07_head->caption());
        if (strval($this->d_07_head->EditValue) != "" && is_numeric($this->d_07_head->EditValue)) {
            $this->d_07_head->EditValue = FormatNumber($this->d_07_head->EditValue, null);
        }

        // d_08_head
        $this->d_08_head->setupEditAttributes();
        $this->d_08_head->EditValue = $this->d_08_head->CurrentValue;
        $this->d_08_head->PlaceHolder = RemoveHtml($this->d_08_head->caption());
        if (strval($this->d_08_head->EditValue) != "" && is_numeric($this->d_08_head->EditValue)) {
            $this->d_08_head->EditValue = FormatNumber($this->d_08_head->EditValue, null);
        }

        // sample
        $this->sample->setupEditAttributes();
        $this->sample->EditValue = $this->sample->CurrentValue;
        $this->sample->PlaceHolder = RemoveHtml($this->sample->caption());
        if (strval($this->sample->EditValue) != "" && is_numeric($this->sample->EditValue)) {
            $this->sample->EditValue = FormatNumber($this->sample->EditValue, null);
        }

        // balance_quantity
        $this->balance_quantity->setupEditAttributes();
        $this->balance_quantity->EditValue = $this->balance_quantity->CurrentValue;
        $this->balance_quantity->PlaceHolder = RemoveHtml($this->balance_quantity->caption());
        if (strval($this->balance_quantity->EditValue) != "" && is_numeric($this->balance_quantity->EditValue)) {
            $this->balance_quantity->EditValue = FormatNumber($this->balance_quantity->EditValue, null);
        }

        // action
        $this->_action->setupEditAttributes();
        if (!$this->_action->Raw) {
            $this->_action->CurrentValue = HtmlDecode($this->_action->CurrentValue);
        }
        $this->_action->EditValue = $this->_action->CurrentValue;
        $this->_action->PlaceHolder = RemoveHtml($this->_action->caption());

        // url
        $this->url->setupEditAttributes();
        if (!$this->url->Raw) {
            $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
        }
        $this->url->EditValue = $this->url->CurrentValue;
        $this->url->PlaceHolder = RemoveHtml($this->url->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->order_type);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->buyer_order_no);
                    $doc->exportCaption($this->buyer_order_date);
                    $doc->exportCaption($this->cart_id);
                    $doc->exportCaption($this->buyer_product_ref);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->despatch_date);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->fob_date);
                    $doc->exportCaption($this->part_dispatch);
                    $doc->exportCaption($this->payment_terms);
                    $doc->exportCaption($this->transport_terms);
                    $doc->exportCaption($this->buyer_shipping_id);
                    $doc->exportCaption($this->description_07);
                    $doc->exportCaption($this->description_20);
                    $doc->exportCaption($this->description_17);
                    $doc->exportCaption($this->description_18);
                    $doc->exportCaption($this->description_19);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->price);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->buyer_size);
                    $doc->exportCaption($this->description_05);
                    $doc->exportCaption($this->description_06);
                    $doc->exportCaption($this->description_08);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->a_datetime);
                    $doc->exportCaption($this->buyer_instruction);
                    $doc->exportCaption($this->d_09_head);
                    $doc->exportCaption($this->description_09);
                    $doc->exportCaption($this->d_10_head);
                    $doc->exportCaption($this->description_10);
                    $doc->exportCaption($this->d_11_head);
                    $doc->exportCaption($this->description_11);
                    $doc->exportCaption($this->d_12_head);
                    $doc->exportCaption($this->description_12);
                    $doc->exportCaption($this->_action);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->order_type);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->buyer_order_no);
                    $doc->exportCaption($this->buyer_order_date);
                    $doc->exportCaption($this->buyer_product_ref);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->payment_terms);
                    $doc->exportCaption($this->transport_terms);
                    $doc->exportCaption($this->buyer_shipping_id);
                    $doc->exportCaption($this->description_04);
                    $doc->exportCaption($this->description_03);
                    $doc->exportCaption($this->description_07);
                    $doc->exportCaption($this->description_20);
                    $doc->exportCaption($this->description_17);
                    $doc->exportCaption($this->description_18);
                    $doc->exportCaption($this->description_19);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->buyer_size);
                    $doc->exportCaption($this->description_05);
                    $doc->exportCaption($this->description_06);
                    $doc->exportCaption($this->description_08);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->a_datetime);
                    $doc->exportCaption($this->d_09_head);
                    $doc->exportCaption($this->description_09);
                    $doc->exportCaption($this->d_10_head);
                    $doc->exportCaption($this->description_10);
                    $doc->exportCaption($this->d_11_head);
                    $doc->exportCaption($this->description_11);
                    $doc->exportCaption($this->d_12_head);
                    $doc->exportCaption($this->description_12);
                    $doc->exportCaption($this->_action);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->order_type);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->buyer_order_no);
                        $doc->exportField($this->buyer_order_date);
                        $doc->exportField($this->cart_id);
                        $doc->exportField($this->buyer_product_ref);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->despatch_date);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->fob_date);
                        $doc->exportField($this->part_dispatch);
                        $doc->exportField($this->payment_terms);
                        $doc->exportField($this->transport_terms);
                        $doc->exportField($this->buyer_shipping_id);
                        $doc->exportField($this->description_07);
                        $doc->exportField($this->description_20);
                        $doc->exportField($this->description_17);
                        $doc->exportField($this->description_18);
                        $doc->exportField($this->description_19);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->price);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->buyer_size);
                        $doc->exportField($this->description_05);
                        $doc->exportField($this->description_06);
                        $doc->exportField($this->description_08);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->a_datetime);
                        $doc->exportField($this->buyer_instruction);
                        $doc->exportField($this->d_09_head);
                        $doc->exportField($this->description_09);
                        $doc->exportField($this->d_10_head);
                        $doc->exportField($this->description_10);
                        $doc->exportField($this->d_11_head);
                        $doc->exportField($this->description_11);
                        $doc->exportField($this->d_12_head);
                        $doc->exportField($this->description_12);
                        $doc->exportField($this->_action);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->order_type);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->buyer_order_no);
                        $doc->exportField($this->buyer_order_date);
                        $doc->exportField($this->buyer_product_ref);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->payment_terms);
                        $doc->exportField($this->transport_terms);
                        $doc->exportField($this->buyer_shipping_id);
                        $doc->exportField($this->description_04);
                        $doc->exportField($this->description_03);
                        $doc->exportField($this->description_07);
                        $doc->exportField($this->description_20);
                        $doc->exportField($this->description_17);
                        $doc->exportField($this->description_18);
                        $doc->exportField($this->description_19);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->buyer_size);
                        $doc->exportField($this->description_05);
                        $doc->exportField($this->description_06);
                        $doc->exportField($this->description_08);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->a_datetime);
                        $doc->exportField($this->d_09_head);
                        $doc->exportField($this->description_09);
                        $doc->exportField($this->d_10_head);
                        $doc->exportField($this->description_10);
                        $doc->exportField($this->d_11_head);
                        $doc->exportField($this->description_11);
                        $doc->exportField($this->d_12_head);
                        $doc->exportField($this->description_12);
                        $doc->exportField($this->_action);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
