<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PersonalInfoUpdate extends PersonalInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "update";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PersonalInfoUpdate";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "personalinfoupdate";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->formal_name->setVisibility();
        $this->gender->setVisibility();
        $this->mobile->setVisibility();
        $this->_email->setVisibility();
        $this->address->setVisibility();
        $this->country->setVisibility();
        $this->state->setVisibility();
        $this->city->setVisibility();
        $this->city_name->setVisibility();
        $this->dob->setVisibility();
        $this->dom->setVisibility();
        $this->marital_status->setVisibility();
        $this->spouse_details->setVisibility();
        $this->image->setVisibility();
        $this->father_name->setVisibility();
        $this->mother_name->setVisibility();
        $this->permanent_address->setVisibility();
        $this->mobile_other->setVisibility();
        $this->mobile_family->setVisibility();
        $this->emergency_details->setVisibility();
        $this->annual_income->setVisibility();
        $this->work_details->setVisibility();
        $this->status->setVisibility();
        $this->gst->setVisibility();
        $this->aadhaar_no->setVisibility();
        $this->pan_no->setVisibility();
        $this->id_proof->setVisibility();
        $this->reference_details->setVisibility();
        $this->other_details->setVisibility();
        $this->bank_name->setVisibility();
        $this->bank_ifsc_code->setVisibility();
        $this->bank_account_no->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'personal_info';
        $this->TableName = 'personal_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-update-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (personal_info)
        if (!isset($GLOBALS["personal_info"]) || $GLOBALS["personal_info"]::class == PROJECT_NAMESPACE . "personal_info") {
            $GLOBALS["personal_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'personal_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "personalinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-update-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $RecKeys;
    public $Disabled;
    public $UpdateCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->state);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->marital_status);
        $this->setupLookupOptions($this->status);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Try to load keys from list form
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        if (Post("action") !== null && Post("action") !== "") {
            // Get action
            $this->CurrentAction = Post("action");
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                $this->CurrentAction = "show"; // Form error, reset action
                if (!$this->hasInvalidFields()) { // No fields selected
                    $this->setFailureMessage($Language->phrase("NoFieldSelected"));
                }
            }
        } else {
            $this->loadMultiUpdateValues(); // Load initial values to form
        }
        if (count($this->RecKeys) <= 0) {
            $this->terminate("personalinfolist"); // No records selected, return to list
            return;
        }
        if ($this->isUpdate()) {
                if ($this->updateRows()) { // Update Records based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
                    }

                    // Do not return Json for UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                    }
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
        }

        // Render row
        if ($this->isConfirm()) { // Confirm page
            $this->RowType = RowType::VIEW; // Render view
            $this->Disabled = " disabled";
        } else {
            $this->RowType = RowType::EDIT; // Render edit
            $this->Disabled = "";
        }
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load initial values to form if field values are identical in all selected records
    protected function loadMultiUpdateValues()
    {
        $this->CurrentFilter = $this->getFilterFromRecordKeys();

        // Load result set
        if ($rs = $this->loadRecordset()) {
            $i = 1;
            while ($row = $rs->fetch()) {
                if ($i == 1) {
                    $this->formal_name->setDbValue($row['formal_name']);
                    $this->gender->setDbValue($row['gender']);
                    $this->mobile->setDbValue($row['mobile']);
                    $this->_email->setDbValue($row['email']);
                    $this->address->setDbValue($row['address']);
                    $this->country->setDbValue($row['country']);
                    $this->state->setDbValue($row['state']);
                    $this->city->setDbValue($row['city']);
                    $this->city_name->setDbValue($row['city_name']);
                    $this->dob->setDbValue($row['dob']);
                    $this->dom->setDbValue($row['dom']);
                    $this->marital_status->setDbValue($row['marital_status']);
                    $this->spouse_details->setDbValue($row['spouse_details']);
                    $this->father_name->setDbValue($row['father_name']);
                    $this->mother_name->setDbValue($row['mother_name']);
                    $this->permanent_address->setDbValue($row['permanent_address']);
                    $this->mobile_other->setDbValue($row['mobile_other']);
                    $this->mobile_family->setDbValue($row['mobile_family']);
                    $this->emergency_details->setDbValue($row['emergency_details']);
                    $this->annual_income->setDbValue($row['annual_income']);
                    $this->work_details->setDbValue($row['work_details']);
                    $this->status->setDbValue($row['status']);
                    $this->gst->setDbValue($row['gst']);
                    $this->aadhaar_no->setDbValue($row['aadhaar_no']);
                    $this->pan_no->setDbValue($row['pan_no']);
                    $this->reference_details->setDbValue($row['reference_details']);
                    $this->other_details->setDbValue($row['other_details']);
                    $this->bank_name->setDbValue($row['bank_name']);
                    $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
                    $this->bank_account_no->setDbValue($row['bank_account_no']);
                    $this->operator->setDbValue($row['operator']);
                    $this->datetime->setDbValue($row['datetime']);
                } else {
                    if (!CompareValue($this->formal_name->DbValue, $row['formal_name'])) {
                        $this->formal_name->CurrentValue = null;
                    }
                    if (!CompareValue($this->gender->DbValue, $row['gender'])) {
                        $this->gender->CurrentValue = null;
                    }
                    if (!CompareValue($this->mobile->DbValue, $row['mobile'])) {
                        $this->mobile->CurrentValue = null;
                    }
                    if (!CompareValue($this->_email->DbValue, $row['email'])) {
                        $this->_email->CurrentValue = null;
                    }
                    if (!CompareValue($this->address->DbValue, $row['address'])) {
                        $this->address->CurrentValue = null;
                    }
                    if (!CompareValue($this->country->DbValue, $row['country'])) {
                        $this->country->CurrentValue = null;
                    }
                    if (!CompareValue($this->state->DbValue, $row['state'])) {
                        $this->state->CurrentValue = null;
                    }
                    if (!CompareValue($this->city->DbValue, $row['city'])) {
                        $this->city->CurrentValue = null;
                    }
                    if (!CompareValue($this->city_name->DbValue, $row['city_name'])) {
                        $this->city_name->CurrentValue = null;
                    }
                    if (!CompareValue($this->dob->DbValue, $row['dob'])) {
                        $this->dob->CurrentValue = null;
                    }
                    if (!CompareValue($this->dom->DbValue, $row['dom'])) {
                        $this->dom->CurrentValue = null;
                    }
                    if (!CompareValue($this->marital_status->DbValue, $row['marital_status'])) {
                        $this->marital_status->CurrentValue = null;
                    }
                    if (!CompareValue($this->spouse_details->DbValue, $row['spouse_details'])) {
                        $this->spouse_details->CurrentValue = null;
                    }
                    if (!CompareValue($this->father_name->DbValue, $row['father_name'])) {
                        $this->father_name->CurrentValue = null;
                    }
                    if (!CompareValue($this->mother_name->DbValue, $row['mother_name'])) {
                        $this->mother_name->CurrentValue = null;
                    }
                    if (!CompareValue($this->permanent_address->DbValue, $row['permanent_address'])) {
                        $this->permanent_address->CurrentValue = null;
                    }
                    if (!CompareValue($this->mobile_other->DbValue, $row['mobile_other'])) {
                        $this->mobile_other->CurrentValue = null;
                    }
                    if (!CompareValue($this->mobile_family->DbValue, $row['mobile_family'])) {
                        $this->mobile_family->CurrentValue = null;
                    }
                    if (!CompareValue($this->emergency_details->DbValue, $row['emergency_details'])) {
                        $this->emergency_details->CurrentValue = null;
                    }
                    if (!CompareValue($this->annual_income->DbValue, $row['annual_income'])) {
                        $this->annual_income->CurrentValue = null;
                    }
                    if (!CompareValue($this->work_details->DbValue, $row['work_details'])) {
                        $this->work_details->CurrentValue = null;
                    }
                    if (!CompareValue($this->status->DbValue, $row['status'])) {
                        $this->status->CurrentValue = null;
                    }
                    if (!CompareValue($this->gst->DbValue, $row['gst'])) {
                        $this->gst->CurrentValue = null;
                    }
                    if (!CompareValue($this->aadhaar_no->DbValue, $row['aadhaar_no'])) {
                        $this->aadhaar_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->pan_no->DbValue, $row['pan_no'])) {
                        $this->pan_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->reference_details->DbValue, $row['reference_details'])) {
                        $this->reference_details->CurrentValue = null;
                    }
                    if (!CompareValue($this->other_details->DbValue, $row['other_details'])) {
                        $this->other_details->CurrentValue = null;
                    }
                    if (!CompareValue($this->bank_name->DbValue, $row['bank_name'])) {
                        $this->bank_name->CurrentValue = null;
                    }
                    if (!CompareValue($this->bank_ifsc_code->DbValue, $row['bank_ifsc_code'])) {
                        $this->bank_ifsc_code->CurrentValue = null;
                    }
                    if (!CompareValue($this->bank_account_no->DbValue, $row['bank_account_no'])) {
                        $this->bank_account_no->CurrentValue = null;
                    }
                    if (!CompareValue($this->operator->DbValue, $row['operator'])) {
                        $this->operator->CurrentValue = null;
                    }
                    if (!CompareValue($this->datetime->DbValue, $row['datetime'])) {
                        $this->datetime->CurrentValue = null;
                    }
                }
                $i++;
            }
            $rs->free();
        }
    }

    // Set up key value
    protected function setupKeyValues($key)
    {
        $keyFld = $key;
        if (!is_numeric($keyFld)) {
            return false;
        }
        $this->id->OldValue = $keyFld;
        return true;
    }

    // Update all selected rows
    protected function updateRows()
    {
        global $Language;
        $conn = $this->getConnection();
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }

        // Get old records
        $this->CurrentFilter = $this->getFilterFromRecordKeys(false);
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAllAssociative($sql);

        // Update all rows
        $successKeys = [];
        $failKeys = [];
        foreach ($this->RecKeys as $reckey) {
            if ($this->setupKeyValues($reckey)) {
                $thisKey = $reckey;
                $this->SendEmail = false; // Do not send email on update success
                $this->UpdateCount += 1; // Update record count for records being updated
                $rowUpdated = $this->editRow(); // Update this row
            } else {
                $rowUpdated = false;
            }
            if (!$rowUpdated) {
                if ($this->UseTransaction) { // Update failed
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                $successKeys[] = $thisKey;
            }
        }

        // Check if any rows updated
        if (count($successKeys) > 0) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if update some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("UpdateSomeRecordsFailed")));
            }

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            return true;
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            return false;
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
        $this->image->MultiUpdate = $CurrentForm->getValue("u_image");
        $this->id_proof->Upload->Index = $CurrentForm->Index;
        $this->id_proof->Upload->uploadFile();
        $this->id_proof->CurrentValue = $this->id_proof->Upload->FileName;
        $this->id_proof->MultiUpdate = $CurrentForm->getValue("u_id_proof");
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'formal_name' first before field var 'x_formal_name'
        $val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
        if (!$this->formal_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->formal_name->Visible = false; // Disable update for API request
            } else {
                $this->formal_name->setFormValue($val);
            }
        }
        $this->formal_name->MultiUpdate = $CurrentForm->getValue("u_formal_name");

        // Check field name 'gender' first before field var 'x_gender'
        $val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
        if (!$this->gender->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gender->Visible = false; // Disable update for API request
            } else {
                $this->gender->setFormValue($val);
            }
        }
        $this->gender->MultiUpdate = $CurrentForm->getValue("u_gender");

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val, true, $validate);
            }
        }
        $this->mobile->MultiUpdate = $CurrentForm->getValue("u_mobile");

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val, true, $validate);
            }
        }
        $this->_email->MultiUpdate = $CurrentForm->getValue("u__email");

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }
        $this->address->MultiUpdate = $CurrentForm->getValue("u_address");

        // Check field name 'country' first before field var 'x_country'
        $val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
        if (!$this->country->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->country->Visible = false; // Disable update for API request
            } else {
                $this->country->setFormValue($val);
            }
        }
        $this->country->MultiUpdate = $CurrentForm->getValue("u_country");

        // Check field name 'state' first before field var 'x_state'
        $val = $CurrentForm->hasValue("state") ? $CurrentForm->getValue("state") : $CurrentForm->getValue("x_state");
        if (!$this->state->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->state->Visible = false; // Disable update for API request
            } else {
                $this->state->setFormValue($val);
            }
        }
        $this->state->MultiUpdate = $CurrentForm->getValue("u_state");

        // Check field name 'city' first before field var 'x_city'
        $val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
        if (!$this->city->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->city->Visible = false; // Disable update for API request
            } else {
                $this->city->setFormValue($val);
            }
        }
        $this->city->MultiUpdate = $CurrentForm->getValue("u_city");

        // Check field name 'city_name' first before field var 'x_city_name'
        $val = $CurrentForm->hasValue("city_name") ? $CurrentForm->getValue("city_name") : $CurrentForm->getValue("x_city_name");
        if (!$this->city_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->city_name->Visible = false; // Disable update for API request
            } else {
                $this->city_name->setFormValue($val);
            }
        }
        $this->city_name->MultiUpdate = $CurrentForm->getValue("u_city_name");

        // Check field name 'dob' first before field var 'x_dob'
        $val = $CurrentForm->hasValue("dob") ? $CurrentForm->getValue("dob") : $CurrentForm->getValue("x_dob");
        if (!$this->dob->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dob->Visible = false; // Disable update for API request
            } else {
                $this->dob->setFormValue($val, true, $validate);
            }
            $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        }
        $this->dob->MultiUpdate = $CurrentForm->getValue("u_dob");

        // Check field name 'dom' first before field var 'x_dom'
        $val = $CurrentForm->hasValue("dom") ? $CurrentForm->getValue("dom") : $CurrentForm->getValue("x_dom");
        if (!$this->dom->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dom->Visible = false; // Disable update for API request
            } else {
                $this->dom->setFormValue($val, true, $validate);
            }
            $this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern());
        }
        $this->dom->MultiUpdate = $CurrentForm->getValue("u_dom");

        // Check field name 'marital_status' first before field var 'x_marital_status'
        $val = $CurrentForm->hasValue("marital_status") ? $CurrentForm->getValue("marital_status") : $CurrentForm->getValue("x_marital_status");
        if (!$this->marital_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->marital_status->Visible = false; // Disable update for API request
            } else {
                $this->marital_status->setFormValue($val);
            }
        }
        $this->marital_status->MultiUpdate = $CurrentForm->getValue("u_marital_status");

        // Check field name 'spouse_details' first before field var 'x_spouse_details'
        $val = $CurrentForm->hasValue("spouse_details") ? $CurrentForm->getValue("spouse_details") : $CurrentForm->getValue("x_spouse_details");
        if (!$this->spouse_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->spouse_details->Visible = false; // Disable update for API request
            } else {
                $this->spouse_details->setFormValue($val);
            }
        }
        $this->spouse_details->MultiUpdate = $CurrentForm->getValue("u_spouse_details");

        // Check field name 'father_name' first before field var 'x_father_name'
        $val = $CurrentForm->hasValue("father_name") ? $CurrentForm->getValue("father_name") : $CurrentForm->getValue("x_father_name");
        if (!$this->father_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->father_name->Visible = false; // Disable update for API request
            } else {
                $this->father_name->setFormValue($val);
            }
        }
        $this->father_name->MultiUpdate = $CurrentForm->getValue("u_father_name");

        // Check field name 'mother_name' first before field var 'x_mother_name'
        $val = $CurrentForm->hasValue("mother_name") ? $CurrentForm->getValue("mother_name") : $CurrentForm->getValue("x_mother_name");
        if (!$this->mother_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mother_name->Visible = false; // Disable update for API request
            } else {
                $this->mother_name->setFormValue($val);
            }
        }
        $this->mother_name->MultiUpdate = $CurrentForm->getValue("u_mother_name");

        // Check field name 'permanent_address' first before field var 'x_permanent_address'
        $val = $CurrentForm->hasValue("permanent_address") ? $CurrentForm->getValue("permanent_address") : $CurrentForm->getValue("x_permanent_address");
        if (!$this->permanent_address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->permanent_address->Visible = false; // Disable update for API request
            } else {
                $this->permanent_address->setFormValue($val);
            }
        }
        $this->permanent_address->MultiUpdate = $CurrentForm->getValue("u_permanent_address");

        // Check field name 'mobile_other' first before field var 'x_mobile_other'
        $val = $CurrentForm->hasValue("mobile_other") ? $CurrentForm->getValue("mobile_other") : $CurrentForm->getValue("x_mobile_other");
        if (!$this->mobile_other->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile_other->Visible = false; // Disable update for API request
            } else {
                $this->mobile_other->setFormValue($val);
            }
        }
        $this->mobile_other->MultiUpdate = $CurrentForm->getValue("u_mobile_other");

        // Check field name 'mobile_family' first before field var 'x_mobile_family'
        $val = $CurrentForm->hasValue("mobile_family") ? $CurrentForm->getValue("mobile_family") : $CurrentForm->getValue("x_mobile_family");
        if (!$this->mobile_family->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile_family->Visible = false; // Disable update for API request
            } else {
                $this->mobile_family->setFormValue($val);
            }
        }
        $this->mobile_family->MultiUpdate = $CurrentForm->getValue("u_mobile_family");

        // Check field name 'emergency_details' first before field var 'x_emergency_details'
        $val = $CurrentForm->hasValue("emergency_details") ? $CurrentForm->getValue("emergency_details") : $CurrentForm->getValue("x_emergency_details");
        if (!$this->emergency_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->emergency_details->Visible = false; // Disable update for API request
            } else {
                $this->emergency_details->setFormValue($val);
            }
        }
        $this->emergency_details->MultiUpdate = $CurrentForm->getValue("u_emergency_details");

        // Check field name 'annual_income' first before field var 'x_annual_income'
        $val = $CurrentForm->hasValue("annual_income") ? $CurrentForm->getValue("annual_income") : $CurrentForm->getValue("x_annual_income");
        if (!$this->annual_income->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->annual_income->Visible = false; // Disable update for API request
            } else {
                $this->annual_income->setFormValue($val, true, $validate);
            }
        }
        $this->annual_income->MultiUpdate = $CurrentForm->getValue("u_annual_income");

        // Check field name 'work_details' first before field var 'x_work_details'
        $val = $CurrentForm->hasValue("work_details") ? $CurrentForm->getValue("work_details") : $CurrentForm->getValue("x_work_details");
        if (!$this->work_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->work_details->Visible = false; // Disable update for API request
            } else {
                $this->work_details->setFormValue($val);
            }
        }
        $this->work_details->MultiUpdate = $CurrentForm->getValue("u_work_details");

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }
        $this->status->MultiUpdate = $CurrentForm->getValue("u_status");

        // Check field name 'gst' first before field var 'x_gst'
        $val = $CurrentForm->hasValue("gst") ? $CurrentForm->getValue("gst") : $CurrentForm->getValue("x_gst");
        if (!$this->gst->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gst->Visible = false; // Disable update for API request
            } else {
                $this->gst->setFormValue($val);
            }
        }
        $this->gst->MultiUpdate = $CurrentForm->getValue("u_gst");

        // Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
        $val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
        if (!$this->aadhaar_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->aadhaar_no->Visible = false; // Disable update for API request
            } else {
                $this->aadhaar_no->setFormValue($val, true, $validate);
            }
        }
        $this->aadhaar_no->MultiUpdate = $CurrentForm->getValue("u_aadhaar_no");

        // Check field name 'pan_no' first before field var 'x_pan_no'
        $val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
        if (!$this->pan_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pan_no->Visible = false; // Disable update for API request
            } else {
                $this->pan_no->setFormValue($val, true, $validate);
            }
        }
        $this->pan_no->MultiUpdate = $CurrentForm->getValue("u_pan_no");

        // Check field name 'reference_details' first before field var 'x_reference_details'
        $val = $CurrentForm->hasValue("reference_details") ? $CurrentForm->getValue("reference_details") : $CurrentForm->getValue("x_reference_details");
        if (!$this->reference_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reference_details->Visible = false; // Disable update for API request
            } else {
                $this->reference_details->setFormValue($val);
            }
        }
        $this->reference_details->MultiUpdate = $CurrentForm->getValue("u_reference_details");

        // Check field name 'other_details' first before field var 'x_other_details'
        $val = $CurrentForm->hasValue("other_details") ? $CurrentForm->getValue("other_details") : $CurrentForm->getValue("x_other_details");
        if (!$this->other_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other_details->Visible = false; // Disable update for API request
            } else {
                $this->other_details->setFormValue($val);
            }
        }
        $this->other_details->MultiUpdate = $CurrentForm->getValue("u_other_details");

        // Check field name 'bank_name' first before field var 'x_bank_name'
        $val = $CurrentForm->hasValue("bank_name") ? $CurrentForm->getValue("bank_name") : $CurrentForm->getValue("x_bank_name");
        if (!$this->bank_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_name->Visible = false; // Disable update for API request
            } else {
                $this->bank_name->setFormValue($val);
            }
        }
        $this->bank_name->MultiUpdate = $CurrentForm->getValue("u_bank_name");

        // Check field name 'bank_ifsc_code' first before field var 'x_bank_ifsc_code'
        $val = $CurrentForm->hasValue("bank_ifsc_code") ? $CurrentForm->getValue("bank_ifsc_code") : $CurrentForm->getValue("x_bank_ifsc_code");
        if (!$this->bank_ifsc_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_ifsc_code->Visible = false; // Disable update for API request
            } else {
                $this->bank_ifsc_code->setFormValue($val);
            }
        }
        $this->bank_ifsc_code->MultiUpdate = $CurrentForm->getValue("u_bank_ifsc_code");

        // Check field name 'bank_account_no' first before field var 'x_bank_account_no'
        $val = $CurrentForm->hasValue("bank_account_no") ? $CurrentForm->getValue("bank_account_no") : $CurrentForm->getValue("x_bank_account_no");
        if (!$this->bank_account_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_account_no->Visible = false; // Disable update for API request
            } else {
                $this->bank_account_no->setFormValue($val);
            }
        }
        $this->bank_account_no->MultiUpdate = $CurrentForm->getValue("u_bank_account_no");

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }
        $this->operator->MultiUpdate = $CurrentForm->getValue("u_operator");

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
        $this->datetime->MultiUpdate = $CurrentForm->getValue("u_datetime");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
		$this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
		$this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->formal_name->CurrentValue = $this->formal_name->FormValue;
        $this->gender->CurrentValue = $this->gender->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->country->CurrentValue = $this->country->FormValue;
        $this->state->CurrentValue = $this->state->FormValue;
        $this->city->CurrentValue = $this->city->FormValue;
        $this->city_name->CurrentValue = $this->city_name->FormValue;
        $this->dob->CurrentValue = $this->dob->FormValue;
        $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        $this->dom->CurrentValue = $this->dom->FormValue;
        $this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern());
        $this->marital_status->CurrentValue = $this->marital_status->FormValue;
        $this->spouse_details->CurrentValue = $this->spouse_details->FormValue;
        $this->father_name->CurrentValue = $this->father_name->FormValue;
        $this->mother_name->CurrentValue = $this->mother_name->FormValue;
        $this->permanent_address->CurrentValue = $this->permanent_address->FormValue;
        $this->mobile_other->CurrentValue = $this->mobile_other->FormValue;
        $this->mobile_family->CurrentValue = $this->mobile_family->FormValue;
        $this->emergency_details->CurrentValue = $this->emergency_details->FormValue;
        $this->annual_income->CurrentValue = $this->annual_income->FormValue;
        $this->work_details->CurrentValue = $this->work_details->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->gst->CurrentValue = $this->gst->FormValue;
        $this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
        $this->pan_no->CurrentValue = $this->pan_no->FormValue;
        $this->reference_details->CurrentValue = $this->reference_details->FormValue;
        $this->other_details->CurrentValue = $this->other_details->FormValue;
        $this->bank_name->CurrentValue = $this->bank_name->FormValue;
        $this->bank_ifsc_code->CurrentValue = $this->bank_ifsc_code->FormValue;
        $this->bank_account_no->CurrentValue = $this->bank_account_no->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->formal_name->setDbValue($row['formal_name']);
        $this->gender->setDbValue($row['gender']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->address->setDbValue($row['address']);
        $this->country->setDbValue($row['country']);
        $this->state->setDbValue($row['state']);
        $this->city->setDbValue($row['city']);
        $this->city_name->setDbValue($row['city_name']);
        $this->dob->setDbValue($row['dob']);
        $this->dom->setDbValue($row['dom']);
        $this->marital_status->setDbValue($row['marital_status']);
        $this->spouse_details->setDbValue($row['spouse_details']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->father_name->setDbValue($row['father_name']);
        $this->mother_name->setDbValue($row['mother_name']);
        $this->permanent_address->setDbValue($row['permanent_address']);
        $this->mobile_other->setDbValue($row['mobile_other']);
        $this->mobile_family->setDbValue($row['mobile_family']);
        $this->emergency_details->setDbValue($row['emergency_details']);
        $this->annual_income->setDbValue($row['annual_income']);
        $this->work_details->setDbValue($row['work_details']);
        $this->status->setDbValue($row['status']);
        $this->gst->setDbValue($row['gst']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
        $this->reference_details->setDbValue($row['reference_details']);
        $this->other_details->setDbValue($row['other_details']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['formal_name'] = $this->formal_name->DefaultValue;
        $row['gender'] = $this->gender->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['state'] = $this->state->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['dob'] = $this->dob->DefaultValue;
        $row['dom'] = $this->dom->DefaultValue;
        $row['marital_status'] = $this->marital_status->DefaultValue;
        $row['spouse_details'] = $this->spouse_details->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['father_name'] = $this->father_name->DefaultValue;
        $row['mother_name'] = $this->mother_name->DefaultValue;
        $row['permanent_address'] = $this->permanent_address->DefaultValue;
        $row['mobile_other'] = $this->mobile_other->DefaultValue;
        $row['mobile_family'] = $this->mobile_family->DefaultValue;
        $row['emergency_details'] = $this->emergency_details->DefaultValue;
        $row['annual_income'] = $this->annual_income->DefaultValue;
        $row['work_details'] = $this->work_details->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['gst'] = $this->gst->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['pan_no'] = $this->pan_no->DefaultValue;
        $row['id_proof'] = $this->id_proof->DefaultValue;
        $row['reference_details'] = $this->reference_details->DefaultValue;
        $row['other_details'] = $this->other_details->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_ifsc_code'] = $this->bank_ifsc_code->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // formal_name
        $this->formal_name->RowCssClass = "row";

        // gender
        $this->gender->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // state
        $this->state->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // city_name
        $this->city_name->RowCssClass = "row";

        // dob
        $this->dob->RowCssClass = "row";

        // dom
        $this->dom->RowCssClass = "row";

        // marital_status
        $this->marital_status->RowCssClass = "row";

        // spouse_details
        $this->spouse_details->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // father_name
        $this->father_name->RowCssClass = "row";

        // mother_name
        $this->mother_name->RowCssClass = "row";

        // permanent_address
        $this->permanent_address->RowCssClass = "row";

        // mobile_other
        $this->mobile_other->RowCssClass = "row";

        // mobile_family
        $this->mobile_family->RowCssClass = "row";

        // emergency_details
        $this->emergency_details->RowCssClass = "row";

        // annual_income
        $this->annual_income->RowCssClass = "row";

        // work_details
        $this->work_details->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // gst
        $this->gst->RowCssClass = "row";

        // aadhaar_no
        $this->aadhaar_no->RowCssClass = "row";

        // pan_no
        $this->pan_no->RowCssClass = "row";

        // id_proof
        $this->id_proof->RowCssClass = "row";

        // reference_details
        $this->reference_details->RowCssClass = "row";

        // other_details
        $this->other_details->RowCssClass = "row";

        // bank_name
        $this->bank_name->RowCssClass = "row";

        // bank_ifsc_code
        $this->bank_ifsc_code->RowCssClass = "row";

        // bank_account_no
        $this->bank_account_no->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // state
            $curVal = strval($this->state->CurrentValue);
            if ($curVal != "") {
                $this->state->ViewValue = $this->state->lookupCacheOption($curVal);
                if ($this->state->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->state->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->state->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->state->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->state->Lookup->renderViewRow($rswrk[0]);
                        $this->state->ViewValue = $this->state->displayValue($arwrk);
                    } else {
                        $this->state->ViewValue = FormatNumber($this->state->CurrentValue, $this->state->formatPattern());
                    }
                }
            } else {
                $this->state->ViewValue = null;
            }

            // city
            $curVal = strval($this->city->CurrentValue);
            if ($curVal != "") {
                $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
                if ($this->city->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                        $this->city->ViewValue = $this->city->displayValue($arwrk);
                    } else {
                        $this->city->ViewValue = FormatNumber($this->city->CurrentValue, $this->city->formatPattern());
                    }
                }
            } else {
                $this->city->ViewValue = null;
            }

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // dom
            $this->dom->ViewValue = $this->dom->CurrentValue;
            $this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, $this->dom->formatPattern());

            // marital_status
            if (strval($this->marital_status->CurrentValue) != "") {
                $this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
            } else {
                $this->marital_status->ViewValue = null;
            }

            // spouse_details
            $this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // mother_name
            $this->mother_name->ViewValue = $this->mother_name->CurrentValue;

            // permanent_address
            $this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;

            // mobile_other
            $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

            // mobile_family
            $this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;

            // emergency_details
            $this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;

            // annual_income
            $this->annual_income->ViewValue = $this->annual_income->CurrentValue;
            $this->annual_income->ViewValue = FormatNumber($this->annual_income->ViewValue, $this->annual_income->formatPattern());

            // work_details
            $this->work_details->ViewValue = $this->work_details->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // gst
            $this->gst->ViewValue = $this->gst->CurrentValue;

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // reference_details
            $this->reference_details->ViewValue = $this->reference_details->CurrentValue;

            // other_details
            $this->other_details->ViewValue = $this->other_details->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_ifsc_code
            $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // formal_name
            $this->formal_name->HrefValue = "";
            $this->formal_name->TooltipValue = "";

            // gender
            $this->gender->HrefValue = "";
            $this->gender->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // country
            $this->country->HrefValue = "";
            $this->country->TooltipValue = "";

            // state
            $this->state->HrefValue = "";
            $this->state->TooltipValue = "";

            // city
            $this->city->HrefValue = "";
            $this->city->TooltipValue = "";

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";

            // dob
            $this->dob->HrefValue = "";
            $this->dob->TooltipValue = "";

            // dom
            $this->dom->HrefValue = "";
            $this->dom->TooltipValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";
            $this->marital_status->TooltipValue = "";

            // spouse_details
            $this->spouse_details->HrefValue = "";
            $this->spouse_details->TooltipValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";

            // father_name
            $this->father_name->HrefValue = "";
            $this->father_name->TooltipValue = "";

            // mother_name
            $this->mother_name->HrefValue = "";
            $this->mother_name->TooltipValue = "";

            // permanent_address
            $this->permanent_address->HrefValue = "";
            $this->permanent_address->TooltipValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";
            $this->mobile_other->TooltipValue = "";

            // mobile_family
            $this->mobile_family->HrefValue = "";
            $this->mobile_family->TooltipValue = "";

            // emergency_details
            $this->emergency_details->HrefValue = "";
            $this->emergency_details->TooltipValue = "";

            // annual_income
            $this->annual_income->HrefValue = "";
            $this->annual_income->TooltipValue = "";

            // work_details
            $this->work_details->HrefValue = "";
            $this->work_details->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // gst
            $this->gst->HrefValue = "";
            $this->gst->TooltipValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";
            $this->aadhaar_no->TooltipValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";
            $this->pan_no->TooltipValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
            $this->id_proof->TooltipValue = "";

            // reference_details
            $this->reference_details->HrefValue = "";
            $this->reference_details->TooltipValue = "";

            // other_details
            $this->other_details->HrefValue = "";
            $this->other_details->TooltipValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";
            $this->bank_name->TooltipValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";
            $this->bank_ifsc_code->TooltipValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";
            $this->bank_account_no->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // formal_name
            $this->formal_name->setupEditAttributes();
            if (!$this->formal_name->Raw) {
                $this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
            }
            $this->formal_name->EditValue = HtmlEncode($this->formal_name->CurrentValue);
            $this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

            // gender
            $this->gender->setupEditAttributes();
            $this->gender->EditValue = $this->gender->options(true);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            $this->mobile->EditValue = $this->mobile->CurrentValue;
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());
            if (strval($this->mobile->EditValue) != "" && is_numeric($this->mobile->EditValue)) {
                $this->mobile->EditValue = FormatNumber($this->mobile->EditValue, null);
            }

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // address
            $this->address->setupEditAttributes();
            if (!$this->address->Raw) {
                $this->address->CurrentValue = HtmlDecode($this->address->CurrentValue);
            }
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // country
            $this->country->setupEditAttributes();
            $curVal = trim(strval($this->country->CurrentValue));
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
            } else {
                $this->country->ViewValue = $this->country->Lookup !== null && is_array($this->country->lookupOptions()) && count($this->country->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->country->ViewValue !== null) { // Load from cache
                $this->country->EditValue = array_values($this->country->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->country->CurrentValue, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->country->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->country->EditValue = $arwrk;
            }
            $this->country->PlaceHolder = RemoveHtml($this->country->caption());

            // state
            $this->state->setupEditAttributes();
            $curVal = trim(strval($this->state->CurrentValue));
            if ($curVal != "") {
                $this->state->ViewValue = $this->state->lookupCacheOption($curVal);
            } else {
                $this->state->ViewValue = $this->state->Lookup !== null && is_array($this->state->lookupOptions()) && count($this->state->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->state->ViewValue !== null) { // Load from cache
                $this->state->EditValue = array_values($this->state->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->state->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->state->CurrentValue, $this->state->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->state->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->state->EditValue = $arwrk;
            }
            $this->state->PlaceHolder = RemoveHtml($this->state->caption());

            // city
            $this->city->setupEditAttributes();
            $curVal = trim(strval($this->city->CurrentValue));
            if ($curVal != "") {
                $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
            } else {
                $this->city->ViewValue = $this->city->Lookup !== null && is_array($this->city->lookupOptions()) && count($this->city->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->city->ViewValue !== null) { // Load from cache
                $this->city->EditValue = array_values($this->city->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->city->CurrentValue, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->city->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->city->EditValue = $arwrk;
            }
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // city_name
            $this->city_name->setupEditAttributes();
            $this->city_name->EditCustomAttributes = $this->city_name->getEditCustomAttributes(); // PHP
            if (!$this->city_name->Raw) {
                $this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
            }
            $this->city_name->EditValue = HtmlEncode($this->city_name->CurrentValue);
            $this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // dom
            $this->dom->setupEditAttributes();
            $this->dom->EditValue = HtmlEncode(FormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern()));
            $this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

            // marital_status
            $this->marital_status->setupEditAttributes();
            $this->marital_status->EditValue = $this->marital_status->options(true);
            $this->marital_status->PlaceHolder = RemoveHtml($this->marital_status->caption());

            // spouse_details
            $this->spouse_details->setupEditAttributes();
            if (!$this->spouse_details->Raw) {
                $this->spouse_details->CurrentValue = HtmlDecode($this->spouse_details->CurrentValue);
            }
            $this->spouse_details->EditValue = HtmlEncode($this->spouse_details->CurrentValue);
            $this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                $this->image->Upload->FileName = $this->image->CurrentValue;
            }

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->CurrentValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // mother_name
            $this->mother_name->setupEditAttributes();
            if (!$this->mother_name->Raw) {
                $this->mother_name->CurrentValue = HtmlDecode($this->mother_name->CurrentValue);
            }
            $this->mother_name->EditValue = HtmlEncode($this->mother_name->CurrentValue);
            $this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

            // permanent_address
            $this->permanent_address->setupEditAttributes();
            if (!$this->permanent_address->Raw) {
                $this->permanent_address->CurrentValue = HtmlDecode($this->permanent_address->CurrentValue);
            }
            $this->permanent_address->EditValue = HtmlEncode($this->permanent_address->CurrentValue);
            $this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

            // mobile_other
            $this->mobile_other->setupEditAttributes();
            if (!$this->mobile_other->Raw) {
                $this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
            }
            $this->mobile_other->EditValue = HtmlEncode($this->mobile_other->CurrentValue);
            $this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

            // mobile_family
            $this->mobile_family->setupEditAttributes();
            if (!$this->mobile_family->Raw) {
                $this->mobile_family->CurrentValue = HtmlDecode($this->mobile_family->CurrentValue);
            }
            $this->mobile_family->EditValue = HtmlEncode($this->mobile_family->CurrentValue);
            $this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

            // emergency_details
            $this->emergency_details->setupEditAttributes();
            if (!$this->emergency_details->Raw) {
                $this->emergency_details->CurrentValue = HtmlDecode($this->emergency_details->CurrentValue);
            }
            $this->emergency_details->EditValue = HtmlEncode($this->emergency_details->CurrentValue);
            $this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

            // annual_income
            $this->annual_income->setupEditAttributes();
            $this->annual_income->EditValue = $this->annual_income->CurrentValue;
            $this->annual_income->PlaceHolder = RemoveHtml($this->annual_income->caption());
            if (strval($this->annual_income->EditValue) != "" && is_numeric($this->annual_income->EditValue)) {
                $this->annual_income->EditValue = FormatNumber($this->annual_income->EditValue, null);
            }

            // work_details
            $this->work_details->setupEditAttributes();
            if (!$this->work_details->Raw) {
                $this->work_details->CurrentValue = HtmlDecode($this->work_details->CurrentValue);
            }
            $this->work_details->EditValue = HtmlEncode($this->work_details->CurrentValue);
            $this->work_details->PlaceHolder = RemoveHtml($this->work_details->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // gst
            $this->gst->setupEditAttributes();
            if (!$this->gst->Raw) {
                $this->gst->CurrentValue = HtmlDecode($this->gst->CurrentValue);
            }
            $this->gst->EditValue = HtmlEncode($this->gst->CurrentValue);
            $this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

            // aadhaar_no
            $this->aadhaar_no->setupEditAttributes();
            if (!$this->aadhaar_no->Raw) {
                $this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
            }
            $this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
            $this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

            // pan_no
            $this->pan_no->setupEditAttributes();
            if (!$this->pan_no->Raw) {
                $this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
            }
            $this->pan_no->EditValue = HtmlEncode($this->pan_no->CurrentValue);
            $this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

            // id_proof
            $this->id_proof->setupEditAttributes();
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->EditValue = "";
            }
            if (!EmptyValue($this->id_proof->CurrentValue)) {
                $this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;
            }

            // reference_details
            $this->reference_details->setupEditAttributes();
            if (!$this->reference_details->Raw) {
                $this->reference_details->CurrentValue = HtmlDecode($this->reference_details->CurrentValue);
            }
            $this->reference_details->EditValue = HtmlEncode($this->reference_details->CurrentValue);
            $this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

            // other_details
            $this->other_details->setupEditAttributes();
            $this->other_details->EditValue = HtmlEncode($this->other_details->CurrentValue);
            $this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

            // bank_name
            $this->bank_name->setupEditAttributes();
            if (!$this->bank_name->Raw) {
                $this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
            }
            $this->bank_name->EditValue = HtmlEncode($this->bank_name->CurrentValue);
            $this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

            // bank_ifsc_code
            $this->bank_ifsc_code->setupEditAttributes();
            if (!$this->bank_ifsc_code->Raw) {
                $this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
            }
            $this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->CurrentValue);
            $this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

            // bank_account_no
            $this->bank_account_no->setupEditAttributes();
            if (!$this->bank_account_no->Raw) {
                $this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
            }
            $this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->CurrentValue);
            $this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

            // operator

            // datetime

            // Edit refer script

            // formal_name
            $this->formal_name->HrefValue = "";

            // gender
            $this->gender->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // state
            $this->state->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // city_name
            $this->city_name->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // dom
            $this->dom->HrefValue = "";

            // marital_status
            $this->marital_status->HrefValue = "";

            // spouse_details
            $this->spouse_details->HrefValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // father_name
            $this->father_name->HrefValue = "";

            // mother_name
            $this->mother_name->HrefValue = "";

            // permanent_address
            $this->permanent_address->HrefValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";

            // mobile_family
            $this->mobile_family->HrefValue = "";

            // emergency_details
            $this->emergency_details->HrefValue = "";

            // annual_income
            $this->annual_income->HrefValue = "";

            // work_details
            $this->work_details->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // gst
            $this->gst->HrefValue = "";

            // aadhaar_no
            $this->aadhaar_no->HrefValue = "";

            // pan_no
            $this->pan_no->HrefValue = "";

            // id_proof
            $this->id_proof->HrefValue = "";
            $this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;

            // reference_details
            $this->reference_details->HrefValue = "";

            // other_details
            $this->other_details->HrefValue = "";

            // bank_name
            $this->bank_name->HrefValue = "";

            // bank_ifsc_code
            $this->bank_ifsc_code->HrefValue = "";

            // bank_account_no
            $this->bank_account_no->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;
        $updateCnt = 0;
        if ($this->formal_name->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->gender->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->mobile->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->_email->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->address->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->country->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->state->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->city->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->city_name->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->dob->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->dom->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->marital_status->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->spouse_details->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->image->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->father_name->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->mother_name->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->permanent_address->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->mobile_other->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->mobile_family->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->emergency_details->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->annual_income->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->work_details->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->status->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->gst->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->aadhaar_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->pan_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->id_proof->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->reference_details->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->other_details->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->bank_name->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->bank_ifsc_code->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->bank_account_no->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->operator->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->datetime->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($updateCnt == 0) {
            return false;
        }

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->formal_name->Visible && $this->formal_name->Required) {
                if ($this->formal_name->MultiUpdate != "" && !$this->formal_name->IsDetailKey && EmptyValue($this->formal_name->FormValue)) {
                    $this->formal_name->addErrorMessage(str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
                }
            }
            if ($this->gender->Visible && $this->gender->Required) {
                if ($this->gender->MultiUpdate != "" && !$this->gender->IsDetailKey && EmptyValue($this->gender->FormValue)) {
                    $this->gender->addErrorMessage(str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if ($this->mobile->MultiUpdate != "" && !$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->mobile->MultiUpdate != "") {
                if (!CheckInteger($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage($this->mobile->getErrorMessage(false));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if ($this->_email->MultiUpdate != "" && !$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if ($this->_email->MultiUpdate != "") {
                if (!CheckEmail($this->_email->FormValue)) {
                    $this->_email->addErrorMessage($this->_email->getErrorMessage(false));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if ($this->address->MultiUpdate != "" && !$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->country->Visible && $this->country->Required) {
                if ($this->country->MultiUpdate != "" && !$this->country->IsDetailKey && EmptyValue($this->country->FormValue)) {
                    $this->country->addErrorMessage(str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
                }
            }
            if ($this->state->Visible && $this->state->Required) {
                if ($this->state->MultiUpdate != "" && !$this->state->IsDetailKey && EmptyValue($this->state->FormValue)) {
                    $this->state->addErrorMessage(str_replace("%s", $this->state->caption(), $this->state->RequiredErrorMessage));
                }
            }
            if ($this->city->Visible && $this->city->Required) {
                if ($this->city->MultiUpdate != "" && !$this->city->IsDetailKey && EmptyValue($this->city->FormValue)) {
                    $this->city->addErrorMessage(str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
                }
            }
            if ($this->city_name->Visible && $this->city_name->Required) {
                if ($this->city_name->MultiUpdate != "" && !$this->city_name->IsDetailKey && EmptyValue($this->city_name->FormValue)) {
                    $this->city_name->addErrorMessage(str_replace("%s", $this->city_name->caption(), $this->city_name->RequiredErrorMessage));
                }
            }
            if ($this->dob->Visible && $this->dob->Required) {
                if ($this->dob->MultiUpdate != "" && !$this->dob->IsDetailKey && EmptyValue($this->dob->FormValue)) {
                    $this->dob->addErrorMessage(str_replace("%s", $this->dob->caption(), $this->dob->RequiredErrorMessage));
                }
            }
            if ($this->dob->MultiUpdate != "") {
                if (!CheckDate($this->dob->FormValue, $this->dob->formatPattern())) {
                    $this->dob->addErrorMessage($this->dob->getErrorMessage(false));
                }
            }
            if ($this->dom->Visible && $this->dom->Required) {
                if ($this->dom->MultiUpdate != "" && !$this->dom->IsDetailKey && EmptyValue($this->dom->FormValue)) {
                    $this->dom->addErrorMessage(str_replace("%s", $this->dom->caption(), $this->dom->RequiredErrorMessage));
                }
            }
            if ($this->dom->MultiUpdate != "") {
                if (!CheckDate($this->dom->FormValue, $this->dom->formatPattern())) {
                    $this->dom->addErrorMessage($this->dom->getErrorMessage(false));
                }
            }
            if ($this->marital_status->Visible && $this->marital_status->Required) {
                if ($this->marital_status->MultiUpdate != "" && !$this->marital_status->IsDetailKey && EmptyValue($this->marital_status->FormValue)) {
                    $this->marital_status->addErrorMessage(str_replace("%s", $this->marital_status->caption(), $this->marital_status->RequiredErrorMessage));
                }
            }
            if ($this->spouse_details->Visible && $this->spouse_details->Required) {
                if ($this->spouse_details->MultiUpdate != "" && !$this->spouse_details->IsDetailKey && EmptyValue($this->spouse_details->FormValue)) {
                    $this->spouse_details->addErrorMessage(str_replace("%s", $this->spouse_details->caption(), $this->spouse_details->RequiredErrorMessage));
                }
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->MultiUpdate != "" && $this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }
            if ($this->father_name->Visible && $this->father_name->Required) {
                if ($this->father_name->MultiUpdate != "" && !$this->father_name->IsDetailKey && EmptyValue($this->father_name->FormValue)) {
                    $this->father_name->addErrorMessage(str_replace("%s", $this->father_name->caption(), $this->father_name->RequiredErrorMessage));
                }
            }
            if ($this->mother_name->Visible && $this->mother_name->Required) {
                if ($this->mother_name->MultiUpdate != "" && !$this->mother_name->IsDetailKey && EmptyValue($this->mother_name->FormValue)) {
                    $this->mother_name->addErrorMessage(str_replace("%s", $this->mother_name->caption(), $this->mother_name->RequiredErrorMessage));
                }
            }
            if ($this->permanent_address->Visible && $this->permanent_address->Required) {
                if ($this->permanent_address->MultiUpdate != "" && !$this->permanent_address->IsDetailKey && EmptyValue($this->permanent_address->FormValue)) {
                    $this->permanent_address->addErrorMessage(str_replace("%s", $this->permanent_address->caption(), $this->permanent_address->RequiredErrorMessage));
                }
            }
            if ($this->mobile_other->Visible && $this->mobile_other->Required) {
                if ($this->mobile_other->MultiUpdate != "" && !$this->mobile_other->IsDetailKey && EmptyValue($this->mobile_other->FormValue)) {
                    $this->mobile_other->addErrorMessage(str_replace("%s", $this->mobile_other->caption(), $this->mobile_other->RequiredErrorMessage));
                }
            }
            if ($this->mobile_family->Visible && $this->mobile_family->Required) {
                if ($this->mobile_family->MultiUpdate != "" && !$this->mobile_family->IsDetailKey && EmptyValue($this->mobile_family->FormValue)) {
                    $this->mobile_family->addErrorMessage(str_replace("%s", $this->mobile_family->caption(), $this->mobile_family->RequiredErrorMessage));
                }
            }
            if ($this->emergency_details->Visible && $this->emergency_details->Required) {
                if ($this->emergency_details->MultiUpdate != "" && !$this->emergency_details->IsDetailKey && EmptyValue($this->emergency_details->FormValue)) {
                    $this->emergency_details->addErrorMessage(str_replace("%s", $this->emergency_details->caption(), $this->emergency_details->RequiredErrorMessage));
                }
            }
            if ($this->annual_income->Visible && $this->annual_income->Required) {
                if ($this->annual_income->MultiUpdate != "" && !$this->annual_income->IsDetailKey && EmptyValue($this->annual_income->FormValue)) {
                    $this->annual_income->addErrorMessage(str_replace("%s", $this->annual_income->caption(), $this->annual_income->RequiredErrorMessage));
                }
            }
            if ($this->annual_income->MultiUpdate != "") {
                if (!CheckInteger($this->annual_income->FormValue)) {
                    $this->annual_income->addErrorMessage($this->annual_income->getErrorMessage(false));
                }
            }
            if ($this->work_details->Visible && $this->work_details->Required) {
                if ($this->work_details->MultiUpdate != "" && !$this->work_details->IsDetailKey && EmptyValue($this->work_details->FormValue)) {
                    $this->work_details->addErrorMessage(str_replace("%s", $this->work_details->caption(), $this->work_details->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if ($this->status->MultiUpdate != "" && !$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->gst->Visible && $this->gst->Required) {
                if ($this->gst->MultiUpdate != "" && !$this->gst->IsDetailKey && EmptyValue($this->gst->FormValue)) {
                    $this->gst->addErrorMessage(str_replace("%s", $this->gst->caption(), $this->gst->RequiredErrorMessage));
                }
            }
            if ($this->aadhaar_no->Visible && $this->aadhaar_no->Required) {
                if ($this->aadhaar_no->MultiUpdate != "" && !$this->aadhaar_no->IsDetailKey && EmptyValue($this->aadhaar_no->FormValue)) {
                    $this->aadhaar_no->addErrorMessage(str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
                }
            }
            if ($this->pan_no->Visible && $this->pan_no->Required) {
                if ($this->pan_no->MultiUpdate != "" && !$this->pan_no->IsDetailKey && EmptyValue($this->pan_no->FormValue)) {
                    $this->pan_no->addErrorMessage(str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
                }
            }
            if ($this->id_proof->Visible && $this->id_proof->Required) {
                if ($this->id_proof->MultiUpdate != "" && $this->id_proof->Upload->FileName == "" && !$this->id_proof->Upload->KeepFile) {
                    $this->id_proof->addErrorMessage(str_replace("%s", $this->id_proof->caption(), $this->id_proof->RequiredErrorMessage));
                }
            }
            if ($this->reference_details->Visible && $this->reference_details->Required) {
                if ($this->reference_details->MultiUpdate != "" && !$this->reference_details->IsDetailKey && EmptyValue($this->reference_details->FormValue)) {
                    $this->reference_details->addErrorMessage(str_replace("%s", $this->reference_details->caption(), $this->reference_details->RequiredErrorMessage));
                }
            }
            if ($this->other_details->Visible && $this->other_details->Required) {
                if ($this->other_details->MultiUpdate != "" && !$this->other_details->IsDetailKey && EmptyValue($this->other_details->FormValue)) {
                    $this->other_details->addErrorMessage(str_replace("%s", $this->other_details->caption(), $this->other_details->RequiredErrorMessage));
                }
            }
            if ($this->bank_name->Visible && $this->bank_name->Required) {
                if ($this->bank_name->MultiUpdate != "" && !$this->bank_name->IsDetailKey && EmptyValue($this->bank_name->FormValue)) {
                    $this->bank_name->addErrorMessage(str_replace("%s", $this->bank_name->caption(), $this->bank_name->RequiredErrorMessage));
                }
            }
            if ($this->bank_ifsc_code->Visible && $this->bank_ifsc_code->Required) {
                if ($this->bank_ifsc_code->MultiUpdate != "" && !$this->bank_ifsc_code->IsDetailKey && EmptyValue($this->bank_ifsc_code->FormValue)) {
                    $this->bank_ifsc_code->addErrorMessage(str_replace("%s", $this->bank_ifsc_code->caption(), $this->bank_ifsc_code->RequiredErrorMessage));
                }
            }
            if ($this->bank_account_no->Visible && $this->bank_account_no->Required) {
                if ($this->bank_account_no->MultiUpdate != "" && !$this->bank_account_no->IsDetailKey && EmptyValue($this->bank_account_no->FormValue)) {
                    $this->bank_account_no->addErrorMessage(str_replace("%s", $this->bank_account_no->caption(), $this->bank_account_no->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if ($this->operator->MultiUpdate != "" && !$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if ($this->datetime->MultiUpdate != "" && !$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            $this->image->UploadPath = $this->image->getUploadPath();
            if (!EmptyValue($this->image->Upload->FileName) && $this->UpdateCount == 1) {
                FixUploadFileNames($this->image);
                $this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, $this->image->ReadOnly || $this->image->MultiUpdate != "1");
            }
        }
        if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath();
            if (!EmptyValue($this->id_proof->Upload->FileName) && $this->UpdateCount == 1) {
                FixUploadFileNames($this->id_proof);
                $this->id_proof->setDbValueDef($rsnew, $this->id_proof->Upload->FileName, $this->id_proof->ReadOnly || $this->id_proof->MultiUpdate != "1");
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->image->Visible && !$this->image->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->image, $rsnew['image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->id_proof, $rsnew['id_proof'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;
        $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
        $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
        $rsnew = [];

        // formal_name
        $this->formal_name->setDbValueDef($rsnew, $this->formal_name->CurrentValue, $this->formal_name->ReadOnly || $this->formal_name->MultiUpdate != "1");

        // gender
        $this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, $this->gender->ReadOnly || $this->gender->MultiUpdate != "1");

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, $this->mobile->ReadOnly || $this->mobile->MultiUpdate != "1");

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, $this->_email->ReadOnly || $this->_email->MultiUpdate != "1");

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, $this->address->ReadOnly || $this->address->MultiUpdate != "1");

        // country
        $this->country->setDbValueDef($rsnew, $this->country->CurrentValue, $this->country->ReadOnly || $this->country->MultiUpdate != "1");

        // state
        $this->state->setDbValueDef($rsnew, $this->state->CurrentValue, $this->state->ReadOnly || $this->state->MultiUpdate != "1");

        // city
        $this->city->setDbValueDef($rsnew, $this->city->CurrentValue, $this->city->ReadOnly || $this->city->MultiUpdate != "1");

        // city_name
        $this->city_name->setDbValueDef($rsnew, $this->city_name->CurrentValue, $this->city_name->ReadOnly || $this->city_name->MultiUpdate != "1");

        // dob
        $this->dob->setDbValueDef($rsnew, UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()), $this->dob->ReadOnly || $this->dob->MultiUpdate != "1");

        // dom
        $this->dom->setDbValueDef($rsnew, UnFormatDateTime($this->dom->CurrentValue, $this->dom->formatPattern()), $this->dom->ReadOnly || $this->dom->MultiUpdate != "1");

        // marital_status
        $this->marital_status->setDbValueDef($rsnew, $this->marital_status->CurrentValue, $this->marital_status->ReadOnly || $this->marital_status->MultiUpdate != "1");

        // spouse_details
        $this->spouse_details->setDbValueDef($rsnew, $this->spouse_details->CurrentValue, $this->spouse_details->ReadOnly || $this->spouse_details->MultiUpdate != "1");

        // image
        if ($this->image->Visible && !$this->image->ReadOnly && strval($this->image->MultiUpdate) == "1" && !$this->image->Upload->KeepFile) {
            if ($this->image->Upload->FileName == "") {
                $rsnew['image'] = null;
            } else {
                FixUploadTempFileNames($this->image);
                $rsnew['image'] = $this->image->Upload->FileName;
            }
            $this->image->ImageWidth = 600; // Resize width
            $this->image->ImageHeight = 600; // Resize height
        }

        // father_name
        $this->father_name->setDbValueDef($rsnew, $this->father_name->CurrentValue, $this->father_name->ReadOnly || $this->father_name->MultiUpdate != "1");

        // mother_name
        $this->mother_name->setDbValueDef($rsnew, $this->mother_name->CurrentValue, $this->mother_name->ReadOnly || $this->mother_name->MultiUpdate != "1");

        // permanent_address
        $this->permanent_address->setDbValueDef($rsnew, $this->permanent_address->CurrentValue, $this->permanent_address->ReadOnly || $this->permanent_address->MultiUpdate != "1");

        // mobile_other
        $this->mobile_other->setDbValueDef($rsnew, $this->mobile_other->CurrentValue, $this->mobile_other->ReadOnly || $this->mobile_other->MultiUpdate != "1");

        // mobile_family
        $this->mobile_family->setDbValueDef($rsnew, $this->mobile_family->CurrentValue, $this->mobile_family->ReadOnly || $this->mobile_family->MultiUpdate != "1");

        // emergency_details
        $this->emergency_details->setDbValueDef($rsnew, $this->emergency_details->CurrentValue, $this->emergency_details->ReadOnly || $this->emergency_details->MultiUpdate != "1");

        // annual_income
        $this->annual_income->setDbValueDef($rsnew, $this->annual_income->CurrentValue, $this->annual_income->ReadOnly || $this->annual_income->MultiUpdate != "1");

        // work_details
        $this->work_details->setDbValueDef($rsnew, $this->work_details->CurrentValue, $this->work_details->ReadOnly || $this->work_details->MultiUpdate != "1");

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly || $this->status->MultiUpdate != "1");

        // gst
        $this->gst->setDbValueDef($rsnew, $this->gst->CurrentValue, $this->gst->ReadOnly || $this->gst->MultiUpdate != "1");

        // aadhaar_no
        $this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, $this->aadhaar_no->ReadOnly || $this->aadhaar_no->MultiUpdate != "1");

        // pan_no
        $this->pan_no->setDbValueDef($rsnew, $this->pan_no->CurrentValue, $this->pan_no->ReadOnly || $this->pan_no->MultiUpdate != "1");

        // id_proof
        if ($this->id_proof->Visible && !$this->id_proof->ReadOnly && strval($this->id_proof->MultiUpdate) == "1" && !$this->id_proof->Upload->KeepFile) {
            if ($this->id_proof->Upload->FileName == "") {
                $rsnew['id_proof'] = null;
            } else {
                FixUploadTempFileNames($this->id_proof);
                $rsnew['id_proof'] = $this->id_proof->Upload->FileName;
            }
            $this->id_proof->ImageWidth = 600; // Resize width
            $this->id_proof->ImageHeight = 600; // Resize height
        }

        // reference_details
        $this->reference_details->setDbValueDef($rsnew, $this->reference_details->CurrentValue, $this->reference_details->ReadOnly || $this->reference_details->MultiUpdate != "1");

        // other_details
        $this->other_details->setDbValueDef($rsnew, $this->other_details->CurrentValue, $this->other_details->ReadOnly || $this->other_details->MultiUpdate != "1");

        // bank_name
        $this->bank_name->setDbValueDef($rsnew, $this->bank_name->CurrentValue, $this->bank_name->ReadOnly || $this->bank_name->MultiUpdate != "1");

        // bank_ifsc_code
        $this->bank_ifsc_code->setDbValueDef($rsnew, $this->bank_ifsc_code->CurrentValue, $this->bank_ifsc_code->ReadOnly || $this->bank_ifsc_code->MultiUpdate != "1");

        // bank_account_no
        $this->bank_account_no->setDbValueDef($rsnew, $this->bank_account_no->CurrentValue, $this->bank_account_no->ReadOnly || $this->bank_account_no->MultiUpdate != "1");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly || $this->operator->MultiUpdate != "1");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly || $this->datetime->MultiUpdate != "1");
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['formal_name'])) { // formal_name
            $this->formal_name->CurrentValue = $row['formal_name'];
        }
        if (isset($row['gender'])) { // gender
            $this->gender->CurrentValue = $row['gender'];
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->CurrentValue = $row['mobile'];
        }
        if (isset($row['email'])) { // email
            $this->_email->CurrentValue = $row['email'];
        }
        if (isset($row['address'])) { // address
            $this->address->CurrentValue = $row['address'];
        }
        if (isset($row['country'])) { // country
            $this->country->CurrentValue = $row['country'];
        }
        if (isset($row['state'])) { // state
            $this->state->CurrentValue = $row['state'];
        }
        if (isset($row['city'])) { // city
            $this->city->CurrentValue = $row['city'];
        }
        if (isset($row['city_name'])) { // city_name
            $this->city_name->CurrentValue = $row['city_name'];
        }
        if (isset($row['dob'])) { // dob
            $this->dob->CurrentValue = $row['dob'];
        }
        if (isset($row['dom'])) { // dom
            $this->dom->CurrentValue = $row['dom'];
        }
        if (isset($row['marital_status'])) { // marital_status
            $this->marital_status->CurrentValue = $row['marital_status'];
        }
        if (isset($row['spouse_details'])) { // spouse_details
            $this->spouse_details->CurrentValue = $row['spouse_details'];
        }
        if (isset($row['image'])) { // image
            $this->image->CurrentValue = $row['image'];
        }
        if (isset($row['father_name'])) { // father_name
            $this->father_name->CurrentValue = $row['father_name'];
        }
        if (isset($row['mother_name'])) { // mother_name
            $this->mother_name->CurrentValue = $row['mother_name'];
        }
        if (isset($row['permanent_address'])) { // permanent_address
            $this->permanent_address->CurrentValue = $row['permanent_address'];
        }
        if (isset($row['mobile_other'])) { // mobile_other
            $this->mobile_other->CurrentValue = $row['mobile_other'];
        }
        if (isset($row['mobile_family'])) { // mobile_family
            $this->mobile_family->CurrentValue = $row['mobile_family'];
        }
        if (isset($row['emergency_details'])) { // emergency_details
            $this->emergency_details->CurrentValue = $row['emergency_details'];
        }
        if (isset($row['annual_income'])) { // annual_income
            $this->annual_income->CurrentValue = $row['annual_income'];
        }
        if (isset($row['work_details'])) { // work_details
            $this->work_details->CurrentValue = $row['work_details'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['gst'])) { // gst
            $this->gst->CurrentValue = $row['gst'];
        }
        if (isset($row['aadhaar_no'])) { // aadhaar_no
            $this->aadhaar_no->CurrentValue = $row['aadhaar_no'];
        }
        if (isset($row['pan_no'])) { // pan_no
            $this->pan_no->CurrentValue = $row['pan_no'];
        }
        if (isset($row['id_proof'])) { // id_proof
            $this->id_proof->CurrentValue = $row['id_proof'];
        }
        if (isset($row['reference_details'])) { // reference_details
            $this->reference_details->CurrentValue = $row['reference_details'];
        }
        if (isset($row['other_details'])) { // other_details
            $this->other_details->CurrentValue = $row['other_details'];
        }
        if (isset($row['bank_name'])) { // bank_name
            $this->bank_name->CurrentValue = $row['bank_name'];
        }
        if (isset($row['bank_ifsc_code'])) { // bank_ifsc_code
            $this->bank_ifsc_code->CurrentValue = $row['bank_ifsc_code'];
        }
        if (isset($row['bank_account_no'])) { // bank_account_no
            $this->bank_account_no->CurrentValue = $row['bank_account_no'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("personalinfolist"), "", $this->TableVar, true);
        $pageId = "update";
        $Breadcrumb->add("update", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_gender":
                    break;
                case "x_country":
                    break;
                case "x_state":
                    break;
                case "x_city":
                    break;
                case "x_marital_status":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'personal_info');		
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
