<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PersonalInfoList extends PersonalInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PersonalInfoList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fpersonal_infolist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "personalinfolist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->formal_name->setVisibility();
        $this->gender->setVisibility();
        $this->mobile->Visible = false;
        $this->_email->Visible = false;
        $this->address->setVisibility();
        $this->country->setVisibility();
        $this->state->setVisibility();
        $this->city->setVisibility();
        $this->city_name->setVisibility();
        $this->dob->setVisibility();
        $this->dom->setVisibility();
        $this->marital_status->setVisibility();
        $this->spouse_details->setVisibility();
        $this->image->Visible = false;
        $this->father_name->setVisibility();
        $this->mother_name->setVisibility();
        $this->permanent_address->setVisibility();
        $this->mobile_other->setVisibility();
        $this->mobile_family->setVisibility();
        $this->emergency_details->setVisibility();
        $this->annual_income->setVisibility();
        $this->work_details->setVisibility();
        $this->status->Visible = false;
        $this->gst->setVisibility();
        $this->aadhaar_no->Visible = false;
        $this->pan_no->Visible = false;
        $this->id_proof->Visible = false;
        $this->reference_details->Visible = false;
        $this->other_details->Visible = false;
        $this->bank_name->Visible = false;
        $this->bank_ifsc_code->Visible = false;
        $this->bank_account_no->Visible = false;
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'personal_info';
        $this->TableName = 'personal_info';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (personal_info)
        if (!isset($GLOBALS["personal_info"]) || $GLOBALS["personal_info"]::class == PROJECT_NAMESPACE . "personal_info") {
            $GLOBALS["personal_info"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "personalinfoadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "personalinfodelete";
        $this->MultiUpdateUrl = "personalinfoupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'personal_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "personalinfoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $this->id_proof->OldUploadPath = $this->id_proof->getUploadPath(); // PHP
                $this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "20,50,100,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->state);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->marital_status);
        $this->setupLookupOptions($this->status);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fpersonal_infogrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);

        // Export selected records
        if ($this->isExport()) {
            $this->CurrentFilter = $this->buildExportSelectedFilter();
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fpersonal_infosrch");
        }
        $filterList = Concat($filterList, $this->formal_name->AdvancedSearch->toJson(), ","); // Field formal_name
        $filterList = Concat($filterList, $this->gender->AdvancedSearch->toJson(), ","); // Field gender
        $filterList = Concat($filterList, $this->mobile->AdvancedSearch->toJson(), ","); // Field mobile
        $filterList = Concat($filterList, $this->_email->AdvancedSearch->toJson(), ","); // Field email
        $filterList = Concat($filterList, $this->address->AdvancedSearch->toJson(), ","); // Field address
        $filterList = Concat($filterList, $this->country->AdvancedSearch->toJson(), ","); // Field country
        $filterList = Concat($filterList, $this->state->AdvancedSearch->toJson(), ","); // Field state
        $filterList = Concat($filterList, $this->city->AdvancedSearch->toJson(), ","); // Field city
        $filterList = Concat($filterList, $this->city_name->AdvancedSearch->toJson(), ","); // Field city_name
        $filterList = Concat($filterList, $this->dob->AdvancedSearch->toJson(), ","); // Field dob
        $filterList = Concat($filterList, $this->dom->AdvancedSearch->toJson(), ","); // Field dom
        $filterList = Concat($filterList, $this->marital_status->AdvancedSearch->toJson(), ","); // Field marital_status
        $filterList = Concat($filterList, $this->spouse_details->AdvancedSearch->toJson(), ","); // Field spouse_details
        $filterList = Concat($filterList, $this->image->AdvancedSearch->toJson(), ","); // Field image
        $filterList = Concat($filterList, $this->father_name->AdvancedSearch->toJson(), ","); // Field father_name
        $filterList = Concat($filterList, $this->mother_name->AdvancedSearch->toJson(), ","); // Field mother_name
        $filterList = Concat($filterList, $this->permanent_address->AdvancedSearch->toJson(), ","); // Field permanent_address
        $filterList = Concat($filterList, $this->mobile_other->AdvancedSearch->toJson(), ","); // Field mobile_other
        $filterList = Concat($filterList, $this->mobile_family->AdvancedSearch->toJson(), ","); // Field mobile_family
        $filterList = Concat($filterList, $this->emergency_details->AdvancedSearch->toJson(), ","); // Field emergency_details
        $filterList = Concat($filterList, $this->annual_income->AdvancedSearch->toJson(), ","); // Field annual_income
        $filterList = Concat($filterList, $this->work_details->AdvancedSearch->toJson(), ","); // Field work_details
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->gst->AdvancedSearch->toJson(), ","); // Field gst
        $filterList = Concat($filterList, $this->aadhaar_no->AdvancedSearch->toJson(), ","); // Field aadhaar_no
        $filterList = Concat($filterList, $this->pan_no->AdvancedSearch->toJson(), ","); // Field pan_no
        $filterList = Concat($filterList, $this->id_proof->AdvancedSearch->toJson(), ","); // Field id_proof
        $filterList = Concat($filterList, $this->reference_details->AdvancedSearch->toJson(), ","); // Field reference_details
        $filterList = Concat($filterList, $this->other_details->AdvancedSearch->toJson(), ","); // Field other_details
        $filterList = Concat($filterList, $this->bank_name->AdvancedSearch->toJson(), ","); // Field bank_name
        $filterList = Concat($filterList, $this->bank_ifsc_code->AdvancedSearch->toJson(), ","); // Field bank_ifsc_code
        $filterList = Concat($filterList, $this->bank_account_no->AdvancedSearch->toJson(), ","); // Field bank_account_no
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fpersonal_infosrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field formal_name
        $this->formal_name->AdvancedSearch->SearchValue = @$filter["x_formal_name"];
        $this->formal_name->AdvancedSearch->SearchOperator = @$filter["z_formal_name"];
        $this->formal_name->AdvancedSearch->SearchCondition = @$filter["v_formal_name"];
        $this->formal_name->AdvancedSearch->SearchValue2 = @$filter["y_formal_name"];
        $this->formal_name->AdvancedSearch->SearchOperator2 = @$filter["w_formal_name"];
        $this->formal_name->AdvancedSearch->save();

        // Field gender
        $this->gender->AdvancedSearch->SearchValue = @$filter["x_gender"];
        $this->gender->AdvancedSearch->SearchOperator = @$filter["z_gender"];
        $this->gender->AdvancedSearch->SearchCondition = @$filter["v_gender"];
        $this->gender->AdvancedSearch->SearchValue2 = @$filter["y_gender"];
        $this->gender->AdvancedSearch->SearchOperator2 = @$filter["w_gender"];
        $this->gender->AdvancedSearch->save();

        // Field mobile
        $this->mobile->AdvancedSearch->SearchValue = @$filter["x_mobile"];
        $this->mobile->AdvancedSearch->SearchOperator = @$filter["z_mobile"];
        $this->mobile->AdvancedSearch->SearchCondition = @$filter["v_mobile"];
        $this->mobile->AdvancedSearch->SearchValue2 = @$filter["y_mobile"];
        $this->mobile->AdvancedSearch->SearchOperator2 = @$filter["w_mobile"];
        $this->mobile->AdvancedSearch->save();

        // Field email
        $this->_email->AdvancedSearch->SearchValue = @$filter["x__email"];
        $this->_email->AdvancedSearch->SearchOperator = @$filter["z__email"];
        $this->_email->AdvancedSearch->SearchCondition = @$filter["v__email"];
        $this->_email->AdvancedSearch->SearchValue2 = @$filter["y__email"];
        $this->_email->AdvancedSearch->SearchOperator2 = @$filter["w__email"];
        $this->_email->AdvancedSearch->save();

        // Field address
        $this->address->AdvancedSearch->SearchValue = @$filter["x_address"];
        $this->address->AdvancedSearch->SearchOperator = @$filter["z_address"];
        $this->address->AdvancedSearch->SearchCondition = @$filter["v_address"];
        $this->address->AdvancedSearch->SearchValue2 = @$filter["y_address"];
        $this->address->AdvancedSearch->SearchOperator2 = @$filter["w_address"];
        $this->address->AdvancedSearch->save();

        // Field country
        $this->country->AdvancedSearch->SearchValue = @$filter["x_country"];
        $this->country->AdvancedSearch->SearchOperator = @$filter["z_country"];
        $this->country->AdvancedSearch->SearchCondition = @$filter["v_country"];
        $this->country->AdvancedSearch->SearchValue2 = @$filter["y_country"];
        $this->country->AdvancedSearch->SearchOperator2 = @$filter["w_country"];
        $this->country->AdvancedSearch->save();

        // Field state
        $this->state->AdvancedSearch->SearchValue = @$filter["x_state"];
        $this->state->AdvancedSearch->SearchOperator = @$filter["z_state"];
        $this->state->AdvancedSearch->SearchCondition = @$filter["v_state"];
        $this->state->AdvancedSearch->SearchValue2 = @$filter["y_state"];
        $this->state->AdvancedSearch->SearchOperator2 = @$filter["w_state"];
        $this->state->AdvancedSearch->save();

        // Field city
        $this->city->AdvancedSearch->SearchValue = @$filter["x_city"];
        $this->city->AdvancedSearch->SearchOperator = @$filter["z_city"];
        $this->city->AdvancedSearch->SearchCondition = @$filter["v_city"];
        $this->city->AdvancedSearch->SearchValue2 = @$filter["y_city"];
        $this->city->AdvancedSearch->SearchOperator2 = @$filter["w_city"];
        $this->city->AdvancedSearch->save();

        // Field city_name
        $this->city_name->AdvancedSearch->SearchValue = @$filter["x_city_name"];
        $this->city_name->AdvancedSearch->SearchOperator = @$filter["z_city_name"];
        $this->city_name->AdvancedSearch->SearchCondition = @$filter["v_city_name"];
        $this->city_name->AdvancedSearch->SearchValue2 = @$filter["y_city_name"];
        $this->city_name->AdvancedSearch->SearchOperator2 = @$filter["w_city_name"];
        $this->city_name->AdvancedSearch->save();

        // Field dob
        $this->dob->AdvancedSearch->SearchValue = @$filter["x_dob"];
        $this->dob->AdvancedSearch->SearchOperator = @$filter["z_dob"];
        $this->dob->AdvancedSearch->SearchCondition = @$filter["v_dob"];
        $this->dob->AdvancedSearch->SearchValue2 = @$filter["y_dob"];
        $this->dob->AdvancedSearch->SearchOperator2 = @$filter["w_dob"];
        $this->dob->AdvancedSearch->save();

        // Field dom
        $this->dom->AdvancedSearch->SearchValue = @$filter["x_dom"];
        $this->dom->AdvancedSearch->SearchOperator = @$filter["z_dom"];
        $this->dom->AdvancedSearch->SearchCondition = @$filter["v_dom"];
        $this->dom->AdvancedSearch->SearchValue2 = @$filter["y_dom"];
        $this->dom->AdvancedSearch->SearchOperator2 = @$filter["w_dom"];
        $this->dom->AdvancedSearch->save();

        // Field marital_status
        $this->marital_status->AdvancedSearch->SearchValue = @$filter["x_marital_status"];
        $this->marital_status->AdvancedSearch->SearchOperator = @$filter["z_marital_status"];
        $this->marital_status->AdvancedSearch->SearchCondition = @$filter["v_marital_status"];
        $this->marital_status->AdvancedSearch->SearchValue2 = @$filter["y_marital_status"];
        $this->marital_status->AdvancedSearch->SearchOperator2 = @$filter["w_marital_status"];
        $this->marital_status->AdvancedSearch->save();

        // Field spouse_details
        $this->spouse_details->AdvancedSearch->SearchValue = @$filter["x_spouse_details"];
        $this->spouse_details->AdvancedSearch->SearchOperator = @$filter["z_spouse_details"];
        $this->spouse_details->AdvancedSearch->SearchCondition = @$filter["v_spouse_details"];
        $this->spouse_details->AdvancedSearch->SearchValue2 = @$filter["y_spouse_details"];
        $this->spouse_details->AdvancedSearch->SearchOperator2 = @$filter["w_spouse_details"];
        $this->spouse_details->AdvancedSearch->save();

        // Field image
        $this->image->AdvancedSearch->SearchValue = @$filter["x_image"];
        $this->image->AdvancedSearch->SearchOperator = @$filter["z_image"];
        $this->image->AdvancedSearch->SearchCondition = @$filter["v_image"];
        $this->image->AdvancedSearch->SearchValue2 = @$filter["y_image"];
        $this->image->AdvancedSearch->SearchOperator2 = @$filter["w_image"];
        $this->image->AdvancedSearch->save();

        // Field father_name
        $this->father_name->AdvancedSearch->SearchValue = @$filter["x_father_name"];
        $this->father_name->AdvancedSearch->SearchOperator = @$filter["z_father_name"];
        $this->father_name->AdvancedSearch->SearchCondition = @$filter["v_father_name"];
        $this->father_name->AdvancedSearch->SearchValue2 = @$filter["y_father_name"];
        $this->father_name->AdvancedSearch->SearchOperator2 = @$filter["w_father_name"];
        $this->father_name->AdvancedSearch->save();

        // Field mother_name
        $this->mother_name->AdvancedSearch->SearchValue = @$filter["x_mother_name"];
        $this->mother_name->AdvancedSearch->SearchOperator = @$filter["z_mother_name"];
        $this->mother_name->AdvancedSearch->SearchCondition = @$filter["v_mother_name"];
        $this->mother_name->AdvancedSearch->SearchValue2 = @$filter["y_mother_name"];
        $this->mother_name->AdvancedSearch->SearchOperator2 = @$filter["w_mother_name"];
        $this->mother_name->AdvancedSearch->save();

        // Field permanent_address
        $this->permanent_address->AdvancedSearch->SearchValue = @$filter["x_permanent_address"];
        $this->permanent_address->AdvancedSearch->SearchOperator = @$filter["z_permanent_address"];
        $this->permanent_address->AdvancedSearch->SearchCondition = @$filter["v_permanent_address"];
        $this->permanent_address->AdvancedSearch->SearchValue2 = @$filter["y_permanent_address"];
        $this->permanent_address->AdvancedSearch->SearchOperator2 = @$filter["w_permanent_address"];
        $this->permanent_address->AdvancedSearch->save();

        // Field mobile_other
        $this->mobile_other->AdvancedSearch->SearchValue = @$filter["x_mobile_other"];
        $this->mobile_other->AdvancedSearch->SearchOperator = @$filter["z_mobile_other"];
        $this->mobile_other->AdvancedSearch->SearchCondition = @$filter["v_mobile_other"];
        $this->mobile_other->AdvancedSearch->SearchValue2 = @$filter["y_mobile_other"];
        $this->mobile_other->AdvancedSearch->SearchOperator2 = @$filter["w_mobile_other"];
        $this->mobile_other->AdvancedSearch->save();

        // Field mobile_family
        $this->mobile_family->AdvancedSearch->SearchValue = @$filter["x_mobile_family"];
        $this->mobile_family->AdvancedSearch->SearchOperator = @$filter["z_mobile_family"];
        $this->mobile_family->AdvancedSearch->SearchCondition = @$filter["v_mobile_family"];
        $this->mobile_family->AdvancedSearch->SearchValue2 = @$filter["y_mobile_family"];
        $this->mobile_family->AdvancedSearch->SearchOperator2 = @$filter["w_mobile_family"];
        $this->mobile_family->AdvancedSearch->save();

        // Field emergency_details
        $this->emergency_details->AdvancedSearch->SearchValue = @$filter["x_emergency_details"];
        $this->emergency_details->AdvancedSearch->SearchOperator = @$filter["z_emergency_details"];
        $this->emergency_details->AdvancedSearch->SearchCondition = @$filter["v_emergency_details"];
        $this->emergency_details->AdvancedSearch->SearchValue2 = @$filter["y_emergency_details"];
        $this->emergency_details->AdvancedSearch->SearchOperator2 = @$filter["w_emergency_details"];
        $this->emergency_details->AdvancedSearch->save();

        // Field annual_income
        $this->annual_income->AdvancedSearch->SearchValue = @$filter["x_annual_income"];
        $this->annual_income->AdvancedSearch->SearchOperator = @$filter["z_annual_income"];
        $this->annual_income->AdvancedSearch->SearchCondition = @$filter["v_annual_income"];
        $this->annual_income->AdvancedSearch->SearchValue2 = @$filter["y_annual_income"];
        $this->annual_income->AdvancedSearch->SearchOperator2 = @$filter["w_annual_income"];
        $this->annual_income->AdvancedSearch->save();

        // Field work_details
        $this->work_details->AdvancedSearch->SearchValue = @$filter["x_work_details"];
        $this->work_details->AdvancedSearch->SearchOperator = @$filter["z_work_details"];
        $this->work_details->AdvancedSearch->SearchCondition = @$filter["v_work_details"];
        $this->work_details->AdvancedSearch->SearchValue2 = @$filter["y_work_details"];
        $this->work_details->AdvancedSearch->SearchOperator2 = @$filter["w_work_details"];
        $this->work_details->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field gst
        $this->gst->AdvancedSearch->SearchValue = @$filter["x_gst"];
        $this->gst->AdvancedSearch->SearchOperator = @$filter["z_gst"];
        $this->gst->AdvancedSearch->SearchCondition = @$filter["v_gst"];
        $this->gst->AdvancedSearch->SearchValue2 = @$filter["y_gst"];
        $this->gst->AdvancedSearch->SearchOperator2 = @$filter["w_gst"];
        $this->gst->AdvancedSearch->save();

        // Field aadhaar_no
        $this->aadhaar_no->AdvancedSearch->SearchValue = @$filter["x_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchOperator = @$filter["z_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchCondition = @$filter["v_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchValue2 = @$filter["y_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->SearchOperator2 = @$filter["w_aadhaar_no"];
        $this->aadhaar_no->AdvancedSearch->save();

        // Field pan_no
        $this->pan_no->AdvancedSearch->SearchValue = @$filter["x_pan_no"];
        $this->pan_no->AdvancedSearch->SearchOperator = @$filter["z_pan_no"];
        $this->pan_no->AdvancedSearch->SearchCondition = @$filter["v_pan_no"];
        $this->pan_no->AdvancedSearch->SearchValue2 = @$filter["y_pan_no"];
        $this->pan_no->AdvancedSearch->SearchOperator2 = @$filter["w_pan_no"];
        $this->pan_no->AdvancedSearch->save();

        // Field id_proof
        $this->id_proof->AdvancedSearch->SearchValue = @$filter["x_id_proof"];
        $this->id_proof->AdvancedSearch->SearchOperator = @$filter["z_id_proof"];
        $this->id_proof->AdvancedSearch->SearchCondition = @$filter["v_id_proof"];
        $this->id_proof->AdvancedSearch->SearchValue2 = @$filter["y_id_proof"];
        $this->id_proof->AdvancedSearch->SearchOperator2 = @$filter["w_id_proof"];
        $this->id_proof->AdvancedSearch->save();

        // Field reference_details
        $this->reference_details->AdvancedSearch->SearchValue = @$filter["x_reference_details"];
        $this->reference_details->AdvancedSearch->SearchOperator = @$filter["z_reference_details"];
        $this->reference_details->AdvancedSearch->SearchCondition = @$filter["v_reference_details"];
        $this->reference_details->AdvancedSearch->SearchValue2 = @$filter["y_reference_details"];
        $this->reference_details->AdvancedSearch->SearchOperator2 = @$filter["w_reference_details"];
        $this->reference_details->AdvancedSearch->save();

        // Field other_details
        $this->other_details->AdvancedSearch->SearchValue = @$filter["x_other_details"];
        $this->other_details->AdvancedSearch->SearchOperator = @$filter["z_other_details"];
        $this->other_details->AdvancedSearch->SearchCondition = @$filter["v_other_details"];
        $this->other_details->AdvancedSearch->SearchValue2 = @$filter["y_other_details"];
        $this->other_details->AdvancedSearch->SearchOperator2 = @$filter["w_other_details"];
        $this->other_details->AdvancedSearch->save();

        // Field bank_name
        $this->bank_name->AdvancedSearch->SearchValue = @$filter["x_bank_name"];
        $this->bank_name->AdvancedSearch->SearchOperator = @$filter["z_bank_name"];
        $this->bank_name->AdvancedSearch->SearchCondition = @$filter["v_bank_name"];
        $this->bank_name->AdvancedSearch->SearchValue2 = @$filter["y_bank_name"];
        $this->bank_name->AdvancedSearch->SearchOperator2 = @$filter["w_bank_name"];
        $this->bank_name->AdvancedSearch->save();

        // Field bank_ifsc_code
        $this->bank_ifsc_code->AdvancedSearch->SearchValue = @$filter["x_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchOperator = @$filter["z_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchCondition = @$filter["v_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchValue2 = @$filter["y_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->SearchOperator2 = @$filter["w_bank_ifsc_code"];
        $this->bank_ifsc_code->AdvancedSearch->save();

        // Field bank_account_no
        $this->bank_account_no->AdvancedSearch->SearchValue = @$filter["x_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchOperator = @$filter["z_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchCondition = @$filter["v_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchValue2 = @$filter["y_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->SearchOperator2 = @$filter["w_bank_account_no"];
        $this->bank_account_no->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->formal_name, $default, false); // formal_name
        $this->buildSearchSql($where, $this->gender, $default, false); // gender
        $this->buildSearchSql($where, $this->mobile, $default, false); // mobile
        $this->buildSearchSql($where, $this->_email, $default, false); // email
        $this->buildSearchSql($where, $this->address, $default, false); // address
        $this->buildSearchSql($where, $this->country, $default, false); // country
        $this->buildSearchSql($where, $this->state, $default, false); // state
        $this->buildSearchSql($where, $this->city, $default, false); // city
        $this->buildSearchSql($where, $this->city_name, $default, false); // city_name
        $this->buildSearchSql($where, $this->dob, $default, false); // dob
        $this->buildSearchSql($where, $this->dom, $default, false); // dom
        $this->buildSearchSql($where, $this->marital_status, $default, false); // marital_status
        $this->buildSearchSql($where, $this->spouse_details, $default, false); // spouse_details
        $this->buildSearchSql($where, $this->image, $default, false); // image
        $this->buildSearchSql($where, $this->father_name, $default, false); // father_name
        $this->buildSearchSql($where, $this->mother_name, $default, false); // mother_name
        $this->buildSearchSql($where, $this->permanent_address, $default, false); // permanent_address
        $this->buildSearchSql($where, $this->mobile_other, $default, false); // mobile_other
        $this->buildSearchSql($where, $this->mobile_family, $default, false); // mobile_family
        $this->buildSearchSql($where, $this->emergency_details, $default, false); // emergency_details
        $this->buildSearchSql($where, $this->annual_income, $default, false); // annual_income
        $this->buildSearchSql($where, $this->work_details, $default, false); // work_details
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->gst, $default, false); // gst
        $this->buildSearchSql($where, $this->aadhaar_no, $default, false); // aadhaar_no
        $this->buildSearchSql($where, $this->pan_no, $default, false); // pan_no
        $this->buildSearchSql($where, $this->id_proof, $default, false); // id_proof
        $this->buildSearchSql($where, $this->reference_details, $default, false); // reference_details
        $this->buildSearchSql($where, $this->other_details, $default, false); // other_details
        $this->buildSearchSql($where, $this->bank_name, $default, false); // bank_name
        $this->buildSearchSql($where, $this->bank_ifsc_code, $default, false); // bank_ifsc_code
        $this->buildSearchSql($where, $this->bank_account_no, $default, false); // bank_account_no
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->formal_name->AdvancedSearch->save(); // formal_name
            $this->gender->AdvancedSearch->save(); // gender
            $this->mobile->AdvancedSearch->save(); // mobile
            $this->_email->AdvancedSearch->save(); // email
            $this->address->AdvancedSearch->save(); // address
            $this->country->AdvancedSearch->save(); // country
            $this->state->AdvancedSearch->save(); // state
            $this->city->AdvancedSearch->save(); // city
            $this->city_name->AdvancedSearch->save(); // city_name
            $this->dob->AdvancedSearch->save(); // dob
            $this->dom->AdvancedSearch->save(); // dom
            $this->marital_status->AdvancedSearch->save(); // marital_status
            $this->spouse_details->AdvancedSearch->save(); // spouse_details
            $this->image->AdvancedSearch->save(); // image
            $this->father_name->AdvancedSearch->save(); // father_name
            $this->mother_name->AdvancedSearch->save(); // mother_name
            $this->permanent_address->AdvancedSearch->save(); // permanent_address
            $this->mobile_other->AdvancedSearch->save(); // mobile_other
            $this->mobile_family->AdvancedSearch->save(); // mobile_family
            $this->emergency_details->AdvancedSearch->save(); // emergency_details
            $this->annual_income->AdvancedSearch->save(); // annual_income
            $this->work_details->AdvancedSearch->save(); // work_details
            $this->status->AdvancedSearch->save(); // status
            $this->gst->AdvancedSearch->save(); // gst
            $this->aadhaar_no->AdvancedSearch->save(); // aadhaar_no
            $this->pan_no->AdvancedSearch->save(); // pan_no
            $this->id_proof->AdvancedSearch->save(); // id_proof
            $this->reference_details->AdvancedSearch->save(); // reference_details
            $this->other_details->AdvancedSearch->save(); // other_details
            $this->bank_name->AdvancedSearch->save(); // bank_name
            $this->bank_ifsc_code->AdvancedSearch->save(); // bank_ifsc_code
            $this->bank_account_no->AdvancedSearch->save(); // bank_account_no
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->formal_name->AdvancedSearch->save(); // formal_name
            $this->gender->AdvancedSearch->save(); // gender
            $this->mobile->AdvancedSearch->save(); // mobile
            $this->_email->AdvancedSearch->save(); // email
            $this->address->AdvancedSearch->save(); // address
            $this->country->AdvancedSearch->save(); // country
            $this->state->AdvancedSearch->save(); // state
            $this->city->AdvancedSearch->save(); // city
            $this->city_name->AdvancedSearch->save(); // city_name
            $this->dob->AdvancedSearch->save(); // dob
            $this->dom->AdvancedSearch->save(); // dom
            $this->marital_status->AdvancedSearch->save(); // marital_status
            $this->spouse_details->AdvancedSearch->save(); // spouse_details
            $this->image->AdvancedSearch->save(); // image
            $this->father_name->AdvancedSearch->save(); // father_name
            $this->mother_name->AdvancedSearch->save(); // mother_name
            $this->permanent_address->AdvancedSearch->save(); // permanent_address
            $this->mobile_other->AdvancedSearch->save(); // mobile_other
            $this->mobile_family->AdvancedSearch->save(); // mobile_family
            $this->emergency_details->AdvancedSearch->save(); // emergency_details
            $this->annual_income->AdvancedSearch->save(); // annual_income
            $this->work_details->AdvancedSearch->save(); // work_details
            $this->status->AdvancedSearch->save(); // status
            $this->gst->AdvancedSearch->save(); // gst
            $this->aadhaar_no->AdvancedSearch->save(); // aadhaar_no
            $this->pan_no->AdvancedSearch->save(); // pan_no
            $this->id_proof->AdvancedSearch->save(); // id_proof
            $this->reference_details->AdvancedSearch->save(); // reference_details
            $this->other_details->AdvancedSearch->save(); // other_details
            $this->bank_name->AdvancedSearch->save(); // bank_name
            $this->bank_ifsc_code->AdvancedSearch->save(); // bank_ifsc_code
            $this->bank_account_no->AdvancedSearch->save(); // bank_account_no
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field formal_name
        $filter = $this->queryBuilderWhere("formal_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->formal_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->formal_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field gender
        $filter = $this->queryBuilderWhere("gender");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->gender, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->gender->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field address
        $filter = $this->queryBuilderWhere("address");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->address, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->address->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field country
        $filter = $this->queryBuilderWhere("country");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->country, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->country->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field state
        $filter = $this->queryBuilderWhere("state");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->state, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->state->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field city
        $filter = $this->queryBuilderWhere("city");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->city, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->city->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field city_name
        $filter = $this->queryBuilderWhere("city_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->city_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->city_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field dob
        $filter = $this->queryBuilderWhere("dob");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->dob, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->dob->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field dom
        $filter = $this->queryBuilderWhere("dom");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->dom, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->dom->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field marital_status
        $filter = $this->queryBuilderWhere("marital_status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->marital_status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->marital_status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field spouse_details
        $filter = $this->queryBuilderWhere("spouse_details");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->spouse_details, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->spouse_details->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field father_name
        $filter = $this->queryBuilderWhere("father_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->father_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->father_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field mother_name
        $filter = $this->queryBuilderWhere("mother_name");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->mother_name, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->mother_name->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field permanent_address
        $filter = $this->queryBuilderWhere("permanent_address");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->permanent_address, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->permanent_address->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field mobile_other
        $filter = $this->queryBuilderWhere("mobile_other");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->mobile_other, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->mobile_other->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field mobile_family
        $filter = $this->queryBuilderWhere("mobile_family");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->mobile_family, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->mobile_family->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field emergency_details
        $filter = $this->queryBuilderWhere("emergency_details");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->emergency_details, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->emergency_details->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field annual_income
        $filter = $this->queryBuilderWhere("annual_income");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->annual_income, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->annual_income->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field work_details
        $filter = $this->queryBuilderWhere("work_details");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->work_details, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->work_details->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field gst
        $filter = $this->queryBuilderWhere("gst");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->gst, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->gst->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->id;
        $searchFlds[] = &$this->formal_name;
        $searchFlds[] = &$this->_email;
        $searchFlds[] = &$this->address;
        $searchFlds[] = &$this->city_name;
        $searchFlds[] = &$this->spouse_details;
        $searchFlds[] = &$this->image;
        $searchFlds[] = &$this->father_name;
        $searchFlds[] = &$this->mother_name;
        $searchFlds[] = &$this->permanent_address;
        $searchFlds[] = &$this->mobile_other;
        $searchFlds[] = &$this->mobile_family;
        $searchFlds[] = &$this->emergency_details;
        $searchFlds[] = &$this->work_details;
        $searchFlds[] = &$this->gst;
        $searchFlds[] = &$this->aadhaar_no;
        $searchFlds[] = &$this->pan_no;
        $searchFlds[] = &$this->id_proof;
        $searchFlds[] = &$this->reference_details;
        $searchFlds[] = &$this->other_details;
        $searchFlds[] = &$this->bank_name;
        $searchFlds[] = &$this->bank_ifsc_code;
        $searchFlds[] = &$this->bank_account_no;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->formal_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->gender->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mobile->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->address->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->country->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->state->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->city->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->city_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->dob->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->dom->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->marital_status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->spouse_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->image->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->father_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mother_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->permanent_address->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mobile_other->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mobile_family->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->emergency_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->annual_income->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->work_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->gst->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->aadhaar_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pan_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->id_proof->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->reference_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->other_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_name->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_ifsc_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->bank_account_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->formal_name->AdvancedSearch->unsetSession();
        $this->gender->AdvancedSearch->unsetSession();
        $this->mobile->AdvancedSearch->unsetSession();
        $this->_email->AdvancedSearch->unsetSession();
        $this->address->AdvancedSearch->unsetSession();
        $this->country->AdvancedSearch->unsetSession();
        $this->state->AdvancedSearch->unsetSession();
        $this->city->AdvancedSearch->unsetSession();
        $this->city_name->AdvancedSearch->unsetSession();
        $this->dob->AdvancedSearch->unsetSession();
        $this->dom->AdvancedSearch->unsetSession();
        $this->marital_status->AdvancedSearch->unsetSession();
        $this->spouse_details->AdvancedSearch->unsetSession();
        $this->image->AdvancedSearch->unsetSession();
        $this->father_name->AdvancedSearch->unsetSession();
        $this->mother_name->AdvancedSearch->unsetSession();
        $this->permanent_address->AdvancedSearch->unsetSession();
        $this->mobile_other->AdvancedSearch->unsetSession();
        $this->mobile_family->AdvancedSearch->unsetSession();
        $this->emergency_details->AdvancedSearch->unsetSession();
        $this->annual_income->AdvancedSearch->unsetSession();
        $this->work_details->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->gst->AdvancedSearch->unsetSession();
        $this->aadhaar_no->AdvancedSearch->unsetSession();
        $this->pan_no->AdvancedSearch->unsetSession();
        $this->id_proof->AdvancedSearch->unsetSession();
        $this->reference_details->AdvancedSearch->unsetSession();
        $this->other_details->AdvancedSearch->unsetSession();
        $this->bank_name->AdvancedSearch->unsetSession();
        $this->bank_ifsc_code->AdvancedSearch->unsetSession();
        $this->bank_account_no->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->formal_name->AdvancedSearch->load();
        $this->gender->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->country->AdvancedSearch->load();
        $this->state->AdvancedSearch->load();
        $this->city->AdvancedSearch->load();
        $this->city_name->AdvancedSearch->load();
        $this->dob->AdvancedSearch->load();
        $this->dom->AdvancedSearch->load();
        $this->marital_status->AdvancedSearch->load();
        $this->spouse_details->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->father_name->AdvancedSearch->load();
        $this->mother_name->AdvancedSearch->load();
        $this->permanent_address->AdvancedSearch->load();
        $this->mobile_other->AdvancedSearch->load();
        $this->mobile_family->AdvancedSearch->load();
        $this->emergency_details->AdvancedSearch->load();
        $this->annual_income->AdvancedSearch->load();
        $this->work_details->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->gst->AdvancedSearch->load();
        $this->aadhaar_no->AdvancedSearch->load();
        $this->pan_no->AdvancedSearch->load();
        $this->id_proof->AdvancedSearch->load();
        $this->reference_details->AdvancedSearch->load();
        $this->other_details->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_ifsc_code->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id); // id
            $this->updateSort($this->formal_name); // formal_name
            $this->updateSort($this->gender); // gender
            $this->updateSort($this->address); // address
            $this->updateSort($this->country); // country
            $this->updateSort($this->state); // state
            $this->updateSort($this->city); // city
            $this->updateSort($this->city_name); // city_name
            $this->updateSort($this->dob); // dob
            $this->updateSort($this->dom); // dom
            $this->updateSort($this->marital_status); // marital_status
            $this->updateSort($this->spouse_details); // spouse_details
            $this->updateSort($this->father_name); // father_name
            $this->updateSort($this->mother_name); // mother_name
            $this->updateSort($this->permanent_address); // permanent_address
            $this->updateSort($this->mobile_other); // mobile_other
            $this->updateSort($this->mobile_family); // mobile_family
            $this->updateSort($this->emergency_details); // emergency_details
            $this->updateSort($this->annual_income); // annual_income
            $this->updateSort($this->work_details); // work_details
            $this->updateSort($this->gst); // gst
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->formal_name->setSort("");
                $this->gender->setSort("");
                $this->mobile->setSort("");
                $this->_email->setSort("");
                $this->address->setSort("");
                $this->country->setSort("");
                $this->state->setSort("");
                $this->city->setSort("");
                $this->city_name->setSort("");
                $this->dob->setSort("");
                $this->dom->setSort("");
                $this->marital_status->setSort("");
                $this->spouse_details->setSort("");
                $this->image->setSort("");
                $this->father_name->setSort("");
                $this->mother_name->setSort("");
                $this->permanent_address->setSort("");
                $this->mobile_other->setSort("");
                $this->mobile_family->setSort("");
                $this->emergency_details->setSort("");
                $this->annual_income->setSort("");
                $this->work_details->setSort("");
                $this->status->setSort("");
                $this->gst->setSort("");
                $this->aadhaar_no->setSort("");
                $this->pan_no->setSort("");
                $this->id_proof->setSort("");
                $this->reference_details->setSort("");
                $this->other_details->setSort("");
                $this->bank_name->setSort("");
                $this->bank_ifsc_code->setSort("");
                $this->bank_account_no->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = true;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"personal_info\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"personal_info\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"personal_info\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fpersonal_infolist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fpersonal_infolist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"personal_info\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Add multi update
        $item = &$option->add("multiupdate");
        $item->Body = "<button type=\"button\" class=\"ew-action ew-multi-update\" title=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" data-table=\"personal_info\" data-caption=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" form=\"fpersonal_infolist\" data-ew-action=\"" .
            ($this->ModalUpdate && !IsMobile() ? "modal" : "submit") . "\"" .
            ($this->ModalUpdate && !IsMobile() ? " data-action=\"update\"" : "") .
            ($this->UseAjaxActions ? " data-ajax=\"true\"" : "") .
            " data-url=\"" . GetUrl($this->MultiUpdateUrl) . "\">" . $Language->phrase("UpdateSelectedLink") . "</button>";
        $item->Visible = $Security->canEdit();

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "formal_name");
            $this->createColumnOption($option, "gender");
            $this->createColumnOption($option, "address");
            $this->createColumnOption($option, "country");
            $this->createColumnOption($option, "state");
            $this->createColumnOption($option, "city");
            $this->createColumnOption($option, "city_name");
            $this->createColumnOption($option, "dob");
            $this->createColumnOption($option, "dom");
            $this->createColumnOption($option, "marital_status");
            $this->createColumnOption($option, "spouse_details");
            $this->createColumnOption($option, "father_name");
            $this->createColumnOption($option, "mother_name");
            $this->createColumnOption($option, "permanent_address");
            $this->createColumnOption($option, "mobile_other");
            $this->createColumnOption($option, "mobile_family");
            $this->createColumnOption($option, "emergency_details");
            $this->createColumnOption($option, "annual_income");
            $this->createColumnOption($option, "work_details");
            $this->createColumnOption($option, "gst");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fpersonal_infosrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fpersonal_infosrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fpersonal_infolist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_personal_info", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_personal_info",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // formal_name
        if ($this->formal_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->formal_name->AdvancedSearch->SearchValue != "" || $this->formal_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // gender
        if ($this->gender->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->gender->AdvancedSearch->SearchValue != "" || $this->gender->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mobile->AdvancedSearch->SearchValue != "" || $this->mobile->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // email
        if ($this->_email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_email->AdvancedSearch->SearchValue != "" || $this->_email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->address->AdvancedSearch->SearchValue != "" || $this->address->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // country
        if ($this->country->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->country->AdvancedSearch->SearchValue != "" || $this->country->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // state
        if ($this->state->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->state->AdvancedSearch->SearchValue != "" || $this->state->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // city
        if ($this->city->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->city->AdvancedSearch->SearchValue != "" || $this->city->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // city_name
        if ($this->city_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->city_name->AdvancedSearch->SearchValue != "" || $this->city_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // dob
        if ($this->dob->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->dob->AdvancedSearch->SearchValue != "" || $this->dob->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // dom
        if ($this->dom->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->dom->AdvancedSearch->SearchValue != "" || $this->dom->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // marital_status
        if ($this->marital_status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->marital_status->AdvancedSearch->SearchValue != "" || $this->marital_status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // spouse_details
        if ($this->spouse_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->spouse_details->AdvancedSearch->SearchValue != "" || $this->spouse_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->image->AdvancedSearch->SearchValue != "" || $this->image->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // father_name
        if ($this->father_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->father_name->AdvancedSearch->SearchValue != "" || $this->father_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mother_name
        if ($this->mother_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mother_name->AdvancedSearch->SearchValue != "" || $this->mother_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // permanent_address
        if ($this->permanent_address->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->permanent_address->AdvancedSearch->SearchValue != "" || $this->permanent_address->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mobile_other
        if ($this->mobile_other->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mobile_other->AdvancedSearch->SearchValue != "" || $this->mobile_other->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mobile_family
        if ($this->mobile_family->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mobile_family->AdvancedSearch->SearchValue != "" || $this->mobile_family->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // emergency_details
        if ($this->emergency_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->emergency_details->AdvancedSearch->SearchValue != "" || $this->emergency_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // annual_income
        if ($this->annual_income->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->annual_income->AdvancedSearch->SearchValue != "" || $this->annual_income->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // work_details
        if ($this->work_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->work_details->AdvancedSearch->SearchValue != "" || $this->work_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // gst
        if ($this->gst->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->gst->AdvancedSearch->SearchValue != "" || $this->gst->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // aadhaar_no
        if ($this->aadhaar_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->aadhaar_no->AdvancedSearch->SearchValue != "" || $this->aadhaar_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pan_no
        if ($this->pan_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pan_no->AdvancedSearch->SearchValue != "" || $this->pan_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // id_proof
        if ($this->id_proof->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id_proof->AdvancedSearch->SearchValue != "" || $this->id_proof->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // reference_details
        if ($this->reference_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->reference_details->AdvancedSearch->SearchValue != "" || $this->reference_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // other_details
        if ($this->other_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->other_details->AdvancedSearch->SearchValue != "" || $this->other_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_name
        if ($this->bank_name->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_name->AdvancedSearch->SearchValue != "" || $this->bank_name->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_ifsc_code
        if ($this->bank_ifsc_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_ifsc_code->AdvancedSearch->SearchValue != "" || $this->bank_ifsc_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // bank_account_no
        if ($this->bank_account_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->bank_account_no->AdvancedSearch->SearchValue != "" || $this->bank_account_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->formal_name->setDbValue($row['formal_name']);
        $this->gender->setDbValue($row['gender']);
        $this->mobile->setDbValue($row['mobile']);
        $this->_email->setDbValue($row['email']);
        $this->address->setDbValue($row['address']);
        $this->country->setDbValue($row['country']);
        $this->state->setDbValue($row['state']);
        $this->city->setDbValue($row['city']);
        $this->city_name->setDbValue($row['city_name']);
        $this->dob->setDbValue($row['dob']);
        $this->dom->setDbValue($row['dom']);
        $this->marital_status->setDbValue($row['marital_status']);
        $this->spouse_details->setDbValue($row['spouse_details']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->father_name->setDbValue($row['father_name']);
        $this->mother_name->setDbValue($row['mother_name']);
        $this->permanent_address->setDbValue($row['permanent_address']);
        $this->mobile_other->setDbValue($row['mobile_other']);
        $this->mobile_family->setDbValue($row['mobile_family']);
        $this->emergency_details->setDbValue($row['emergency_details']);
        $this->annual_income->setDbValue($row['annual_income']);
        $this->work_details->setDbValue($row['work_details']);
        $this->status->setDbValue($row['status']);
        $this->gst->setDbValue($row['gst']);
        $this->aadhaar_no->setDbValue($row['aadhaar_no']);
        $this->pan_no->setDbValue($row['pan_no']);
        $this->id_proof->Upload->DbValue = $row['id_proof'];
        $this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
        $this->reference_details->setDbValue($row['reference_details']);
        $this->other_details->setDbValue($row['other_details']);
        $this->bank_name->setDbValue($row['bank_name']);
        $this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
        $this->bank_account_no->setDbValue($row['bank_account_no']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['formal_name'] = $this->formal_name->DefaultValue;
        $row['gender'] = $this->gender->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['state'] = $this->state->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['dob'] = $this->dob->DefaultValue;
        $row['dom'] = $this->dom->DefaultValue;
        $row['marital_status'] = $this->marital_status->DefaultValue;
        $row['spouse_details'] = $this->spouse_details->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['father_name'] = $this->father_name->DefaultValue;
        $row['mother_name'] = $this->mother_name->DefaultValue;
        $row['permanent_address'] = $this->permanent_address->DefaultValue;
        $row['mobile_other'] = $this->mobile_other->DefaultValue;
        $row['mobile_family'] = $this->mobile_family->DefaultValue;
        $row['emergency_details'] = $this->emergency_details->DefaultValue;
        $row['annual_income'] = $this->annual_income->DefaultValue;
        $row['work_details'] = $this->work_details->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['gst'] = $this->gst->DefaultValue;
        $row['aadhaar_no'] = $this->aadhaar_no->DefaultValue;
        $row['pan_no'] = $this->pan_no->DefaultValue;
        $row['id_proof'] = $this->id_proof->DefaultValue;
        $row['reference_details'] = $this->reference_details->DefaultValue;
        $row['other_details'] = $this->other_details->DefaultValue;
        $row['bank_name'] = $this->bank_name->DefaultValue;
        $row['bank_ifsc_code'] = $this->bank_ifsc_code->DefaultValue;
        $row['bank_account_no'] = $this->bank_account_no->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // formal_name

        // gender

        // mobile

        // email

        // address

        // country

        // state

        // city

        // city_name

        // dob

        // dom

        // marital_status

        // spouse_details

        // image

        // father_name

        // mother_name

        // permanent_address

        // mobile_other

        // mobile_family

        // emergency_details

        // annual_income

        // work_details

        // status

        // gst

        // aadhaar_no

        // pan_no

        // id_proof

        // reference_details

        // other_details

        // bank_name

        // bank_ifsc_code

        // bank_account_no

        // operator

        // datetime

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, $this->mobile->formatPattern());

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // state
            $curVal = strval($this->state->CurrentValue);
            if ($curVal != "") {
                $this->state->ViewValue = $this->state->lookupCacheOption($curVal);
                if ($this->state->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->state->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->state->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->state->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->state->Lookup->renderViewRow($rswrk[0]);
                        $this->state->ViewValue = $this->state->displayValue($arwrk);
                    } else {
                        $this->state->ViewValue = FormatNumber($this->state->CurrentValue, $this->state->formatPattern());
                    }
                }
            } else {
                $this->state->ViewValue = null;
            }

            // city
            $curVal = strval($this->city->CurrentValue);
            if ($curVal != "") {
                $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
                if ($this->city->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                        $this->city->ViewValue = $this->city->displayValue($arwrk);
                    } else {
                        $this->city->ViewValue = FormatNumber($this->city->CurrentValue, $this->city->formatPattern());
                    }
                }
            } else {
                $this->city->ViewValue = null;
            }

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // dom
            $this->dom->ViewValue = $this->dom->CurrentValue;
            $this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, $this->dom->formatPattern());

            // marital_status
            if (strval($this->marital_status->CurrentValue) != "") {
                $this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
            } else {
                $this->marital_status->ViewValue = null;
            }

            // spouse_details
            $this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // mother_name
            $this->mother_name->ViewValue = $this->mother_name->CurrentValue;

            // permanent_address
            $this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;

            // mobile_other
            $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

            // mobile_family
            $this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;

            // emergency_details
            $this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;

            // annual_income
            $this->annual_income->ViewValue = $this->annual_income->CurrentValue;
            $this->annual_income->ViewValue = FormatNumber($this->annual_income->ViewValue, $this->annual_income->formatPattern());

            // work_details
            $this->work_details->ViewValue = $this->work_details->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // gst
            $this->gst->ViewValue = $this->gst->CurrentValue;

            // aadhaar_no
            $this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;

            // pan_no
            $this->pan_no->ViewValue = $this->pan_no->CurrentValue;

            // id_proof
            $this->id_proof->UploadPath = $this->id_proof->getUploadPath(); // PHP
            if (!EmptyValue($this->id_proof->Upload->DbValue)) {
                $this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
            } else {
                $this->id_proof->ViewValue = "";
            }

            // reference_details
            $this->reference_details->ViewValue = $this->reference_details->CurrentValue;

            // bank_name
            $this->bank_name->ViewValue = $this->bank_name->CurrentValue;

            // bank_ifsc_code
            $this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;

            // bank_account_no
            $this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";
            $this->formal_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->formal_name->ViewValue = $this->highlightValue($this->formal_name);
            }

            // gender
            $this->gender->HrefValue = "";
            $this->gender->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";
            if (!$this->isExport()) {
                $this->address->ViewValue = $this->highlightValue($this->address);
            }

            // country
            $this->country->HrefValue = "";
            $this->country->TooltipValue = "";

            // state
            $this->state->HrefValue = "";
            $this->state->TooltipValue = "";

            // city
            $this->city->HrefValue = "";
            $this->city->TooltipValue = "";

            // city_name
            $this->city_name->HrefValue = "";
            $this->city_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->city_name->ViewValue = $this->highlightValue($this->city_name);
            }

            // dob
            $this->dob->HrefValue = "";
            $this->dob->TooltipValue = "";
            if (!$this->isExport()) {
                $this->dob->ViewValue = $this->highlightValue($this->dob);
            }

            // dom
            $this->dom->HrefValue = "";
            $this->dom->TooltipValue = "";
            if (!$this->isExport()) {
                $this->dom->ViewValue = $this->highlightValue($this->dom);
            }

            // marital_status
            $this->marital_status->HrefValue = "";
            $this->marital_status->TooltipValue = "";

            // spouse_details
            $this->spouse_details->HrefValue = "";
            $this->spouse_details->TooltipValue = "";
            if (!$this->isExport()) {
                $this->spouse_details->ViewValue = $this->highlightValue($this->spouse_details);
            }

            // father_name
            $this->father_name->HrefValue = "";
            $this->father_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->father_name->ViewValue = $this->highlightValue($this->father_name);
            }

            // mother_name
            $this->mother_name->HrefValue = "";
            $this->mother_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->mother_name->ViewValue = $this->highlightValue($this->mother_name);
            }

            // permanent_address
            $this->permanent_address->HrefValue = "";
            $this->permanent_address->TooltipValue = "";
            if (!$this->isExport()) {
                $this->permanent_address->ViewValue = $this->highlightValue($this->permanent_address);
            }

            // mobile_other
            $this->mobile_other->HrefValue = "";
            $this->mobile_other->TooltipValue = "";
            if (!$this->isExport()) {
                $this->mobile_other->ViewValue = $this->highlightValue($this->mobile_other);
            }

            // mobile_family
            $this->mobile_family->HrefValue = "";
            $this->mobile_family->TooltipValue = "";
            if (!$this->isExport()) {
                $this->mobile_family->ViewValue = $this->highlightValue($this->mobile_family);
            }

            // emergency_details
            $this->emergency_details->HrefValue = "";
            $this->emergency_details->TooltipValue = "";
            if (!$this->isExport()) {
                $this->emergency_details->ViewValue = $this->highlightValue($this->emergency_details);
            }

            // annual_income
            $this->annual_income->HrefValue = "";
            $this->annual_income->TooltipValue = "";

            // work_details
            $this->work_details->HrefValue = "";
            $this->work_details->TooltipValue = "";
            if (!$this->isExport()) {
                $this->work_details->ViewValue = $this->highlightValue($this->work_details);
            }

            // gst
            $this->gst->HrefValue = "";
            $this->gst->TooltipValue = "";
            if (!$this->isExport()) {
                $this->gst->ViewValue = $this->highlightValue($this->gst);
            }
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->formal_name->AdvancedSearch->load();
        $this->gender->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->country->AdvancedSearch->load();
        $this->state->AdvancedSearch->load();
        $this->city->AdvancedSearch->load();
        $this->city_name->AdvancedSearch->load();
        $this->dob->AdvancedSearch->load();
        $this->dom->AdvancedSearch->load();
        $this->marital_status->AdvancedSearch->load();
        $this->spouse_details->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->father_name->AdvancedSearch->load();
        $this->mother_name->AdvancedSearch->load();
        $this->permanent_address->AdvancedSearch->load();
        $this->mobile_other->AdvancedSearch->load();
        $this->mobile_family->AdvancedSearch->load();
        $this->emergency_details->AdvancedSearch->load();
        $this->annual_income->AdvancedSearch->load();
        $this->work_details->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->gst->AdvancedSearch->load();
        $this->aadhaar_no->AdvancedSearch->load();
        $this->pan_no->AdvancedSearch->load();
        $this->id_proof->AdvancedSearch->load();
        $this->reference_details->AdvancedSearch->load();
        $this->other_details->AdvancedSearch->load();
        $this->bank_name->AdvancedSearch->load();
        $this->bank_ifsc_code->AdvancedSearch->load();
        $this->bank_account_no->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Build export filter for selected records
    protected function buildExportSelectedFilter()
    {
        global $Language;
        $wrkFilter = "";
        if ($this->isExport()) {
            $wrkFilter = $this->getFilterFromRecordKeys();
        }
        return $wrkFilter;
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToExcel") . "</button>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToWord") . "</button>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToPdf") . "</button>";
            }
        } elseif (SameText($type, "html")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"html\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToHtml") . "</button>";
        } elseif (SameText($type, "xml")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"xml\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToXml") . "</button>";
        } elseif (SameText($type, "csv")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"csv\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("ExportToCsv") . "</button>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fpersonal_infolist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="true"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" form=\"fpersonal_infolist\" data-url=\"" . $exportUrl . "\" data-ew-action=\"export\" data-export=\"print\" data-custom=\"false\" data-export-selected=\"true\">" . $Language->phrase("PrinterFriendly") . "</button>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"personal_info\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"personalinfosearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"personalinfosearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fpersonal_infosrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_gender":
                    break;
                case "x_country":
                    break;
                case "x_state":
                    break;
                case "x_city":
                    break;
                case "x_marital_status":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'personal_info');		
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
