<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PayrollTimeLogSearch extends PayrollTimeLog
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PayrollTimeLogSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "payrolltimelogsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->employee_id->setVisibility();
        $this->dated->setVisibility();
        $this->in_time->setVisibility();
        $this->out_time->setVisibility();
        $this->minutes->setVisibility();
        $this->late_arrival->setVisibility();
        $this->early_departure->setVisibility();
        $this->overtime->setVisibility();
        $this->breakduration->setVisibility();
        $this->employee_am_id->setVisibility();
        $this->offset_consumed->setVisibility();
        $this->c_offset->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->uid->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'payroll_time_log';
        $this->TableName = 'payroll_time_log';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (payroll_time_log)
        if (!isset($GLOBALS["payroll_time_log"]) || $GLOBALS["payroll_time_log"]::class == PROJECT_NAMESPACE . "payroll_time_log") {
            $GLOBALS["payroll_time_log"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'payroll_time_log');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "payrolltimelogview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->employee_id);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "payrolltimeloglist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->employee_id); // employee_id
        $this->buildSearchUrl($srchUrl, $this->dated); // dated
        $this->buildSearchUrl($srchUrl, $this->in_time); // in_time
        $this->buildSearchUrl($srchUrl, $this->out_time); // out_time
        $this->buildSearchUrl($srchUrl, $this->minutes); // minutes
        $this->buildSearchUrl($srchUrl, $this->late_arrival); // late_arrival
        $this->buildSearchUrl($srchUrl, $this->early_departure); // early_departure
        $this->buildSearchUrl($srchUrl, $this->overtime); // overtime
        $this->buildSearchUrl($srchUrl, $this->breakduration); // break duration
        $this->buildSearchUrl($srchUrl, $this->employee_am_id); // employee_am_id
        $this->buildSearchUrl($srchUrl, $this->offset_consumed); // offset_consumed
        $this->buildSearchUrl($srchUrl, $this->c_offset); // c_offset
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // employee_id
        if ($this->employee_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dated
        if ($this->dated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // in_time
        if ($this->in_time->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // out_time
        if ($this->out_time->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // minutes
        if ($this->minutes->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // late_arrival
        if ($this->late_arrival->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // early_departure
        if ($this->early_departure->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // overtime
        if ($this->overtime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // break duration
        if ($this->breakduration->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // employee_am_id
        if ($this->employee_am_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // offset_consumed
        if ($this->offset_consumed->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // c_offset
        if ($this->c_offset->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // in_time
        $this->in_time->RowCssClass = "row";

        // out_time
        $this->out_time->RowCssClass = "row";

        // minutes
        $this->minutes->RowCssClass = "row";

        // late_arrival
        $this->late_arrival->RowCssClass = "row";

        // early_departure
        $this->early_departure->RowCssClass = "row";

        // overtime
        $this->overtime->RowCssClass = "row";

        // break duration
        $this->breakduration->RowCssClass = "row";

        // employee_am_id
        $this->employee_am_id->RowCssClass = "row";

        // offset_consumed
        $this->offset_consumed->RowCssClass = "row";

        // c_offset
        $this->c_offset->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // employee_id
            $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_id->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_id->ViewValue = $this->employee_id->displayValue($arwrk);
                    } else {
                        $this->employee_id->ViewValue = FormatNumber($this->employee_id->CurrentValue, $this->employee_id->formatPattern());
                    }
                }
            } else {
                $this->employee_id->ViewValue = null;
            }

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // in_time
            $this->in_time->ViewValue = $this->in_time->CurrentValue;
            $this->in_time->ViewValue = FormatDateTime($this->in_time->ViewValue, $this->in_time->formatPattern());

            // out_time
            $this->out_time->ViewValue = $this->out_time->CurrentValue;
            $this->out_time->ViewValue = FormatDateTime($this->out_time->ViewValue, $this->out_time->formatPattern());

            // minutes
            $this->minutes->ViewValue = $this->minutes->CurrentValue;
            $this->minutes->ViewValue = FormatNumber($this->minutes->ViewValue, $this->minutes->formatPattern());

            // late_arrival
            $this->late_arrival->ViewValue = $this->late_arrival->CurrentValue;
            $this->late_arrival->ViewValue = FormatNumber($this->late_arrival->ViewValue, $this->late_arrival->formatPattern());

            // early_departure
            $this->early_departure->ViewValue = $this->early_departure->CurrentValue;
            $this->early_departure->ViewValue = FormatNumber($this->early_departure->ViewValue, $this->early_departure->formatPattern());

            // overtime
            $this->overtime->ViewValue = $this->overtime->CurrentValue;
            $this->overtime->ViewValue = FormatNumber($this->overtime->ViewValue, $this->overtime->formatPattern());

            // break duration
            $this->breakduration->ViewValue = $this->breakduration->CurrentValue;
            $this->breakduration->ViewValue = FormatNumber($this->breakduration->ViewValue, $this->breakduration->formatPattern());

            // employee_am_id
            $this->employee_am_id->ViewValue = $this->employee_am_id->CurrentValue;
            $this->employee_am_id->ViewValue = FormatNumber($this->employee_am_id->ViewValue, $this->employee_am_id->formatPattern());

            // offset_consumed
            $this->offset_consumed->ViewValue = $this->offset_consumed->CurrentValue;
            $this->offset_consumed->ViewValue = FormatNumber($this->offset_consumed->ViewValue, $this->offset_consumed->formatPattern());

            // c_offset
            $this->c_offset->ViewValue = $this->c_offset->CurrentValue;
            $this->c_offset->ViewValue = FormatNumber($this->c_offset->ViewValue, $this->c_offset->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";
            $this->employee_id->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // in_time
            $this->in_time->HrefValue = "";
            $this->in_time->TooltipValue = "";

            // out_time
            $this->out_time->HrefValue = "";
            $this->out_time->TooltipValue = "";

            // minutes
            $this->minutes->HrefValue = "";
            $this->minutes->TooltipValue = "";

            // late_arrival
            $this->late_arrival->HrefValue = "";
            $this->late_arrival->TooltipValue = "";

            // early_departure
            $this->early_departure->HrefValue = "";
            $this->early_departure->TooltipValue = "";

            // overtime
            $this->overtime->HrefValue = "";
            $this->overtime->TooltipValue = "";

            // break duration
            $this->breakduration->HrefValue = "";
            $this->breakduration->TooltipValue = "";

            // employee_am_id
            $this->employee_am_id->HrefValue = "";
            $this->employee_am_id->TooltipValue = "";

            // offset_consumed
            $this->offset_consumed->HrefValue = "";
            $this->offset_consumed->TooltipValue = "";

            // c_offset
            $this->c_offset->HrefValue = "";
            $this->c_offset->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // employee_id
            $this->employee_id->setupEditAttributes();
            $this->employee_id->EditValue = $this->employee_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->employee_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->employee_id->EditValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_id->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_id->EditValue = $this->employee_id->displayValue($arwrk);
                    } else {
                        $this->employee_id->EditValue = HtmlEncode(FormatNumber($this->employee_id->AdvancedSearch->SearchValue, $this->employee_id->formatPattern()));
                    }
                }
            } else {
                $this->employee_id->EditValue = null;
            }
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern()), $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());
            $this->dated->setupEditAttributes();
            $this->dated->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue2, $this->dated->formatPattern()), $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // in_time
            $this->in_time->setupEditAttributes();
            $this->in_time->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->in_time->AdvancedSearch->SearchValue, $this->in_time->formatPattern()), $this->in_time->formatPattern()));
            $this->in_time->PlaceHolder = RemoveHtml($this->in_time->caption());

            // out_time
            $this->out_time->setupEditAttributes();
            $this->out_time->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->out_time->AdvancedSearch->SearchValue, $this->out_time->formatPattern()), $this->out_time->formatPattern()));
            $this->out_time->PlaceHolder = RemoveHtml($this->out_time->caption());

            // minutes
            $this->minutes->setupEditAttributes();
            $this->minutes->EditValue = $this->minutes->AdvancedSearch->SearchValue;
            $this->minutes->PlaceHolder = RemoveHtml($this->minutes->caption());

            // late_arrival
            $this->late_arrival->setupEditAttributes();
            $this->late_arrival->EditValue = $this->late_arrival->AdvancedSearch->SearchValue;
            $this->late_arrival->PlaceHolder = RemoveHtml($this->late_arrival->caption());

            // early_departure
            $this->early_departure->setupEditAttributes();
            $this->early_departure->EditValue = $this->early_departure->AdvancedSearch->SearchValue;
            $this->early_departure->PlaceHolder = RemoveHtml($this->early_departure->caption());

            // overtime
            $this->overtime->setupEditAttributes();
            $this->overtime->EditValue = $this->overtime->AdvancedSearch->SearchValue;
            $this->overtime->PlaceHolder = RemoveHtml($this->overtime->caption());

            // break duration
            $this->breakduration->setupEditAttributes();
            $this->breakduration->EditValue = $this->breakduration->AdvancedSearch->SearchValue;
            $this->breakduration->PlaceHolder = RemoveHtml($this->breakduration->caption());

            // employee_am_id
            $this->employee_am_id->setupEditAttributes();
            $this->employee_am_id->EditValue = $this->employee_am_id->AdvancedSearch->SearchValue;
            $this->employee_am_id->PlaceHolder = RemoveHtml($this->employee_am_id->caption());

            // offset_consumed
            $this->offset_consumed->setupEditAttributes();
            $this->offset_consumed->EditValue = $this->offset_consumed->AdvancedSearch->SearchValue;
            $this->offset_consumed->PlaceHolder = RemoveHtml($this->offset_consumed->caption());

            // c_offset
            $this->c_offset->setupEditAttributes();
            $this->c_offset->EditValue = $this->c_offset->AdvancedSearch->SearchValue;
            $this->c_offset->PlaceHolder = RemoveHtml($this->c_offset->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->employee_id->AdvancedSearch->SearchValue)) {
            $this->employee_id->addErrorMessage($this->employee_id->getErrorMessage(false));
        }
        if (!CheckInteger($this->dated->AdvancedSearch->SearchValue)) {
            $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
        }
        if (!CheckInteger($this->dated->AdvancedSearch->SearchValue2)) {
            $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
        }
        if (!CheckDate($this->in_time->AdvancedSearch->SearchValue, $this->in_time->formatPattern())) {
            $this->in_time->addErrorMessage($this->in_time->getErrorMessage(false));
        }
        if (!CheckDate($this->out_time->AdvancedSearch->SearchValue, $this->out_time->formatPattern())) {
            $this->out_time->addErrorMessage($this->out_time->getErrorMessage(false));
        }
        if (!CheckInteger($this->minutes->AdvancedSearch->SearchValue)) {
            $this->minutes->addErrorMessage($this->minutes->getErrorMessage(false));
        }
        if (!CheckInteger($this->late_arrival->AdvancedSearch->SearchValue)) {
            $this->late_arrival->addErrorMessage($this->late_arrival->getErrorMessage(false));
        }
        if (!CheckInteger($this->early_departure->AdvancedSearch->SearchValue)) {
            $this->early_departure->addErrorMessage($this->early_departure->getErrorMessage(false));
        }
        if (!CheckInteger($this->overtime->AdvancedSearch->SearchValue)) {
            $this->overtime->addErrorMessage($this->overtime->getErrorMessage(false));
        }
        if (!CheckInteger($this->breakduration->AdvancedSearch->SearchValue)) {
            $this->breakduration->addErrorMessage($this->breakduration->getErrorMessage(false));
        }
        if (!CheckInteger($this->employee_am_id->AdvancedSearch->SearchValue)) {
            $this->employee_am_id->addErrorMessage($this->employee_am_id->getErrorMessage(false));
        }
        if (!CheckInteger($this->offset_consumed->AdvancedSearch->SearchValue)) {
            $this->offset_consumed->addErrorMessage($this->offset_consumed->getErrorMessage(false));
        }
        if (!CheckInteger($this->c_offset->AdvancedSearch->SearchValue)) {
            $this->c_offset->addErrorMessage($this->c_offset->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->employee_id->AdvancedSearch->load();
        $this->dated->AdvancedSearch->load();
        $this->in_time->AdvancedSearch->load();
        $this->out_time->AdvancedSearch->load();
        $this->minutes->AdvancedSearch->load();
        $this->late_arrival->AdvancedSearch->load();
        $this->early_departure->AdvancedSearch->load();
        $this->overtime->AdvancedSearch->load();
        $this->breakduration->AdvancedSearch->load();
        $this->employee_am_id->AdvancedSearch->load();
        $this->offset_consumed->AdvancedSearch->load();
        $this->c_offset->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("payrolltimeloglist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_employee_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
