<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PayrollFixDetailsEdit extends PayrollFixDetails
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PayrollFixDetailsEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "payrollfixdetailsedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->employee_id->setVisibility();
        $this->employee_am_id->setVisibility();
        $this->job_title->setVisibility();
        $this->daily_in->setVisibility();
        $this->daily_out->setVisibility();
        $this->lunch_break_min->setVisibility();
        $this->daily_min->setVisibility();
        $this->weekly_off->setVisibility();
        $this->offsets_benifit_min->setVisibility();
        $this->next_increment->setVisibility();
        $this->current_payroll_startdate->setVisibility();
        $this->base_salary->setVisibility();
        $this->additional_benefits->setVisibility();
        $this->extra_min_plan->setVisibility();
        $this->office_holidays->setVisibility();
        $this->paid_annual_leave->setVisibility();
        $this->employee_pf->setVisibility();
        $this->calculation_plan->setVisibility();
        $this->remarks->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->month_min->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'payroll_fix_details';
        $this->TableName = 'payroll_fix_details';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (payroll_fix_details)
        if (!isset($GLOBALS["payroll_fix_details"]) || $GLOBALS["payroll_fix_details"]::class == PROJECT_NAMESPACE . "payroll_fix_details") {
            $GLOBALS["payroll_fix_details"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'payroll_fix_details');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "payrollfixdetailsview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->employee_id);
        $this->setupLookupOptions($this->weekly_off);
        $this->setupLookupOptions($this->additional_benefits);
        $this->setupLookupOptions($this->extra_min_plan);
        $this->setupLookupOptions($this->office_holidays);
        $this->setupLookupOptions($this->employee_pf);
        $this->setupLookupOptions($this->calculation_plan);
        $this->setupLookupOptions($this->status);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("payrollfixdetailslist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "payrollfixdetailslist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "payrollfixdetailslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "payrollfixdetailslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'employee_id' first before field var 'x_employee_id'
        $val = $CurrentForm->hasValue("employee_id") ? $CurrentForm->getValue("employee_id") : $CurrentForm->getValue("x_employee_id");
        if (!$this->employee_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_id->Visible = false; // Disable update for API request
            } else {
                $this->employee_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'employee_am_id' first before field var 'x_employee_am_id'
        $val = $CurrentForm->hasValue("employee_am_id") ? $CurrentForm->getValue("employee_am_id") : $CurrentForm->getValue("x_employee_am_id");
        if (!$this->employee_am_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_am_id->Visible = false; // Disable update for API request
            } else {
                $this->employee_am_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'job_title' first before field var 'x_job_title'
        $val = $CurrentForm->hasValue("job_title") ? $CurrentForm->getValue("job_title") : $CurrentForm->getValue("x_job_title");
        if (!$this->job_title->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->job_title->Visible = false; // Disable update for API request
            } else {
                $this->job_title->setFormValue($val);
            }
        }

        // Check field name 'daily_in' first before field var 'x_daily_in'
        $val = $CurrentForm->hasValue("daily_in") ? $CurrentForm->getValue("daily_in") : $CurrentForm->getValue("x_daily_in");
        if (!$this->daily_in->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->daily_in->Visible = false; // Disable update for API request
            } else {
                $this->daily_in->setFormValue($val, true, $validate);
            }
            $this->daily_in->CurrentValue = UnFormatDateTime($this->daily_in->CurrentValue, $this->daily_in->formatPattern());
        }

        // Check field name 'daily_out' first before field var 'x_daily_out'
        $val = $CurrentForm->hasValue("daily_out") ? $CurrentForm->getValue("daily_out") : $CurrentForm->getValue("x_daily_out");
        if (!$this->daily_out->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->daily_out->Visible = false; // Disable update for API request
            } else {
                $this->daily_out->setFormValue($val, true, $validate);
            }
            $this->daily_out->CurrentValue = UnFormatDateTime($this->daily_out->CurrentValue, $this->daily_out->formatPattern());
        }

        // Check field name 'lunch_break_min' first before field var 'x_lunch_break_min'
        $val = $CurrentForm->hasValue("lunch_break_min") ? $CurrentForm->getValue("lunch_break_min") : $CurrentForm->getValue("x_lunch_break_min");
        if (!$this->lunch_break_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lunch_break_min->Visible = false; // Disable update for API request
            } else {
                $this->lunch_break_min->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'daily_min' first before field var 'x_daily_min'
        $val = $CurrentForm->hasValue("daily_min") ? $CurrentForm->getValue("daily_min") : $CurrentForm->getValue("x_daily_min");
        if (!$this->daily_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->daily_min->Visible = false; // Disable update for API request
            } else {
                $this->daily_min->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'weekly_off' first before field var 'x_weekly_off'
        $val = $CurrentForm->hasValue("weekly_off") ? $CurrentForm->getValue("weekly_off") : $CurrentForm->getValue("x_weekly_off");
        if (!$this->weekly_off->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weekly_off->Visible = false; // Disable update for API request
            } else {
                $this->weekly_off->setFormValue($val);
            }
        }

        // Check field name 'offsets_benifit_min' first before field var 'x_offsets_benifit_min'
        $val = $CurrentForm->hasValue("offsets_benifit_min") ? $CurrentForm->getValue("offsets_benifit_min") : $CurrentForm->getValue("x_offsets_benifit_min");
        if (!$this->offsets_benifit_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->offsets_benifit_min->Visible = false; // Disable update for API request
            } else {
                $this->offsets_benifit_min->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'next_increment' first before field var 'x_next_increment'
        $val = $CurrentForm->hasValue("next_increment") ? $CurrentForm->getValue("next_increment") : $CurrentForm->getValue("x_next_increment");
        if (!$this->next_increment->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->next_increment->Visible = false; // Disable update for API request
            } else {
                $this->next_increment->setFormValue($val, true, $validate);
            }
            $this->next_increment->CurrentValue = UnFormatDateTime($this->next_increment->CurrentValue, $this->next_increment->formatPattern());
        }

        // Check field name 'current_payroll_startdate' first before field var 'x_current_payroll_startdate'
        $val = $CurrentForm->hasValue("current_payroll_startdate") ? $CurrentForm->getValue("current_payroll_startdate") : $CurrentForm->getValue("x_current_payroll_startdate");
        if (!$this->current_payroll_startdate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->current_payroll_startdate->Visible = false; // Disable update for API request
            } else {
                $this->current_payroll_startdate->setFormValue($val, true, $validate);
            }
            $this->current_payroll_startdate->CurrentValue = UnFormatDateTime($this->current_payroll_startdate->CurrentValue, $this->current_payroll_startdate->formatPattern());
        }

        // Check field name 'base_salary' first before field var 'x_base_salary'
        $val = $CurrentForm->hasValue("base_salary") ? $CurrentForm->getValue("base_salary") : $CurrentForm->getValue("x_base_salary");
        if (!$this->base_salary->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->base_salary->Visible = false; // Disable update for API request
            } else {
                $this->base_salary->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'additional_benefits' first before field var 'x_additional_benefits'
        $val = $CurrentForm->hasValue("additional_benefits") ? $CurrentForm->getValue("additional_benefits") : $CurrentForm->getValue("x_additional_benefits");
        if (!$this->additional_benefits->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->additional_benefits->Visible = false; // Disable update for API request
            } else {
                $this->additional_benefits->setFormValue($val);
            }
        }

        // Check field name 'extra_min_plan' first before field var 'x_extra_min_plan'
        $val = $CurrentForm->hasValue("extra_min_plan") ? $CurrentForm->getValue("extra_min_plan") : $CurrentForm->getValue("x_extra_min_plan");
        if (!$this->extra_min_plan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->extra_min_plan->Visible = false; // Disable update for API request
            } else {
                $this->extra_min_plan->setFormValue($val);
            }
        }

        // Check field name 'office_holidays' first before field var 'x_office_holidays'
        $val = $CurrentForm->hasValue("office_holidays") ? $CurrentForm->getValue("office_holidays") : $CurrentForm->getValue("x_office_holidays");
        if (!$this->office_holidays->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->office_holidays->Visible = false; // Disable update for API request
            } else {
                $this->office_holidays->setFormValue($val);
            }
        }

        // Check field name 'paid_annual_leave' first before field var 'x_paid_annual_leave'
        $val = $CurrentForm->hasValue("paid_annual_leave") ? $CurrentForm->getValue("paid_annual_leave") : $CurrentForm->getValue("x_paid_annual_leave");
        if (!$this->paid_annual_leave->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->paid_annual_leave->Visible = false; // Disable update for API request
            } else {
                $this->paid_annual_leave->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'employee_pf' first before field var 'x_employee_pf'
        $val = $CurrentForm->hasValue("employee_pf") ? $CurrentForm->getValue("employee_pf") : $CurrentForm->getValue("x_employee_pf");
        if (!$this->employee_pf->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_pf->Visible = false; // Disable update for API request
            } else {
                $this->employee_pf->setFormValue($val);
            }
        }

        // Check field name 'calculation_plan' first before field var 'x_calculation_plan'
        $val = $CurrentForm->hasValue("calculation_plan") ? $CurrentForm->getValue("calculation_plan") : $CurrentForm->getValue("x_calculation_plan");
        if (!$this->calculation_plan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->calculation_plan->Visible = false; // Disable update for API request
            } else {
                $this->calculation_plan->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'month_min' first before field var 'x_month_min'
        $val = $CurrentForm->hasValue("month_min") ? $CurrentForm->getValue("month_min") : $CurrentForm->getValue("x_month_min");
        if (!$this->month_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->month_min->Visible = false; // Disable update for API request
            } else {
                $this->month_min->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->employee_id->CurrentValue = $this->employee_id->FormValue;
        $this->employee_am_id->CurrentValue = $this->employee_am_id->FormValue;
        $this->job_title->CurrentValue = $this->job_title->FormValue;
        $this->daily_in->CurrentValue = $this->daily_in->FormValue;
        $this->daily_in->CurrentValue = UnFormatDateTime($this->daily_in->CurrentValue, $this->daily_in->formatPattern());
        $this->daily_out->CurrentValue = $this->daily_out->FormValue;
        $this->daily_out->CurrentValue = UnFormatDateTime($this->daily_out->CurrentValue, $this->daily_out->formatPattern());
        $this->lunch_break_min->CurrentValue = $this->lunch_break_min->FormValue;
        $this->daily_min->CurrentValue = $this->daily_min->FormValue;
        $this->weekly_off->CurrentValue = $this->weekly_off->FormValue;
        $this->offsets_benifit_min->CurrentValue = $this->offsets_benifit_min->FormValue;
        $this->next_increment->CurrentValue = $this->next_increment->FormValue;
        $this->next_increment->CurrentValue = UnFormatDateTime($this->next_increment->CurrentValue, $this->next_increment->formatPattern());
        $this->current_payroll_startdate->CurrentValue = $this->current_payroll_startdate->FormValue;
        $this->current_payroll_startdate->CurrentValue = UnFormatDateTime($this->current_payroll_startdate->CurrentValue, $this->current_payroll_startdate->formatPattern());
        $this->base_salary->CurrentValue = $this->base_salary->FormValue;
        $this->additional_benefits->CurrentValue = $this->additional_benefits->FormValue;
        $this->extra_min_plan->CurrentValue = $this->extra_min_plan->FormValue;
        $this->office_holidays->CurrentValue = $this->office_holidays->FormValue;
        $this->paid_annual_leave->CurrentValue = $this->paid_annual_leave->FormValue;
        $this->employee_pf->CurrentValue = $this->employee_pf->FormValue;
        $this->calculation_plan->CurrentValue = $this->calculation_plan->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->month_min->CurrentValue = $this->month_min->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->employee_am_id->setDbValue($row['employee_am_id']);
        $this->job_title->setDbValue($row['job_title']);
        $this->daily_in->setDbValue($row['daily_in']);
        $this->daily_out->setDbValue($row['daily_out']);
        $this->lunch_break_min->setDbValue($row['lunch_break_min']);
        $this->daily_min->setDbValue($row['daily_min']);
        $this->weekly_off->setDbValue($row['weekly_off']);
        $this->offsets_benifit_min->setDbValue($row['offsets_benifit_min']);
        $this->next_increment->setDbValue($row['next_increment']);
        $this->current_payroll_startdate->setDbValue($row['current_payroll_startdate']);
        $this->base_salary->setDbValue($row['base_salary']);
        $this->additional_benefits->setDbValue($row['additional_benefits']);
        $this->extra_min_plan->setDbValue($row['extra_min_plan']);
        $this->office_holidays->setDbValue($row['office_holidays']);
        $this->paid_annual_leave->setDbValue($row['paid_annual_leave']);
        $this->employee_pf->setDbValue($row['employee_pf']);
        $this->calculation_plan->setDbValue($row['calculation_plan']);
        $this->remarks->setDbValue($row['remarks']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->month_min->setDbValue($row['month_min']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['employee_id'] = $this->employee_id->DefaultValue;
        $row['employee_am_id'] = $this->employee_am_id->DefaultValue;
        $row['job_title'] = $this->job_title->DefaultValue;
        $row['daily_in'] = $this->daily_in->DefaultValue;
        $row['daily_out'] = $this->daily_out->DefaultValue;
        $row['lunch_break_min'] = $this->lunch_break_min->DefaultValue;
        $row['daily_min'] = $this->daily_min->DefaultValue;
        $row['weekly_off'] = $this->weekly_off->DefaultValue;
        $row['offsets_benifit_min'] = $this->offsets_benifit_min->DefaultValue;
        $row['next_increment'] = $this->next_increment->DefaultValue;
        $row['current_payroll_startdate'] = $this->current_payroll_startdate->DefaultValue;
        $row['base_salary'] = $this->base_salary->DefaultValue;
        $row['additional_benefits'] = $this->additional_benefits->DefaultValue;
        $row['extra_min_plan'] = $this->extra_min_plan->DefaultValue;
        $row['office_holidays'] = $this->office_holidays->DefaultValue;
        $row['paid_annual_leave'] = $this->paid_annual_leave->DefaultValue;
        $row['employee_pf'] = $this->employee_pf->DefaultValue;
        $row['calculation_plan'] = $this->calculation_plan->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['month_min'] = $this->month_min->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // employee_am_id
        $this->employee_am_id->RowCssClass = "row";

        // job_title
        $this->job_title->RowCssClass = "row";

        // daily_in
        $this->daily_in->RowCssClass = "row";

        // daily_out
        $this->daily_out->RowCssClass = "row";

        // lunch_break_min
        $this->lunch_break_min->RowCssClass = "row";

        // daily_min
        $this->daily_min->RowCssClass = "row";

        // weekly_off
        $this->weekly_off->RowCssClass = "row";

        // offsets_benifit_min
        $this->offsets_benifit_min->RowCssClass = "row";

        // next_increment
        $this->next_increment->RowCssClass = "row";

        // current_payroll_startdate
        $this->current_payroll_startdate->RowCssClass = "row";

        // base_salary
        $this->base_salary->RowCssClass = "row";

        // additional_benefits
        $this->additional_benefits->RowCssClass = "row";

        // extra_min_plan
        $this->extra_min_plan->RowCssClass = "row";

        // office_holidays
        $this->office_holidays->RowCssClass = "row";

        // paid_annual_leave
        $this->paid_annual_leave->RowCssClass = "row";

        // employee_pf
        $this->employee_pf->RowCssClass = "row";

        // calculation_plan
        $this->calculation_plan->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // month_min
        $this->month_min->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // employee_id
            $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_id->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_id->ViewValue = $this->employee_id->displayValue($arwrk);
                    } else {
                        $this->employee_id->ViewValue = FormatNumber($this->employee_id->CurrentValue, $this->employee_id->formatPattern());
                    }
                }
            } else {
                $this->employee_id->ViewValue = null;
            }

            // employee_am_id
            $this->employee_am_id->ViewValue = $this->employee_am_id->CurrentValue;
            $this->employee_am_id->ViewValue = FormatNumber($this->employee_am_id->ViewValue, $this->employee_am_id->formatPattern());

            // job_title
            $this->job_title->ViewValue = $this->job_title->CurrentValue;

            // daily_in
            $this->daily_in->ViewValue = $this->daily_in->CurrentValue;
            $this->daily_in->ViewValue = FormatDateTime($this->daily_in->ViewValue, $this->daily_in->formatPattern());

            // daily_out
            $this->daily_out->ViewValue = $this->daily_out->CurrentValue;
            $this->daily_out->ViewValue = FormatDateTime($this->daily_out->ViewValue, $this->daily_out->formatPattern());

            // lunch_break_min
            $this->lunch_break_min->ViewValue = $this->lunch_break_min->CurrentValue;
            $this->lunch_break_min->ViewValue = FormatNumber($this->lunch_break_min->ViewValue, $this->lunch_break_min->formatPattern());

            // daily_min
            $this->daily_min->ViewValue = $this->daily_min->CurrentValue;
            $this->daily_min->ViewValue = FormatNumber($this->daily_min->ViewValue, $this->daily_min->formatPattern());

            // weekly_off
            if (strval($this->weekly_off->CurrentValue) != "") {
                $this->weekly_off->ViewValue = new OptionValues();
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), strval($this->weekly_off->CurrentValue));
                $cnt = count($arwrk);
                for ($ari = 0; $ari < $cnt; $ari++)
                    $this->weekly_off->ViewValue->add($this->weekly_off->optionCaption(trim($arwrk[$ari])));
            } else {
                $this->weekly_off->ViewValue = null;
            }

            // offsets_benifit_min
            $this->offsets_benifit_min->ViewValue = $this->offsets_benifit_min->CurrentValue;
            $this->offsets_benifit_min->ViewValue = FormatNumber($this->offsets_benifit_min->ViewValue, $this->offsets_benifit_min->formatPattern());

            // next_increment
            $this->next_increment->ViewValue = $this->next_increment->CurrentValue;
            $this->next_increment->ViewValue = FormatDateTime($this->next_increment->ViewValue, $this->next_increment->formatPattern());

            // current_payroll_startdate
            $this->current_payroll_startdate->ViewValue = $this->current_payroll_startdate->CurrentValue;
            $this->current_payroll_startdate->ViewValue = FormatDateTime($this->current_payroll_startdate->ViewValue, $this->current_payroll_startdate->formatPattern());

            // base_salary
            $this->base_salary->ViewValue = $this->base_salary->CurrentValue;
            $this->base_salary->ViewValue = FormatNumber($this->base_salary->ViewValue, $this->base_salary->formatPattern());

            // additional_benefits
            $curVal = strval($this->additional_benefits->CurrentValue);
            if ($curVal != "") {
                $this->additional_benefits->ViewValue = $this->additional_benefits->lookupCacheOption($curVal);
                if ($this->additional_benefits->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->additional_benefits->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->additional_benefits->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->additional_benefits->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->additional_benefits->Lookup->renderViewRow($rswrk[0]);
                        $this->additional_benefits->ViewValue = $this->additional_benefits->displayValue($arwrk);
                    } else {
                        $this->additional_benefits->ViewValue = $this->additional_benefits->CurrentValue;
                    }
                }
            } else {
                $this->additional_benefits->ViewValue = null;
            }

            // extra_min_plan
            if (strval($this->extra_min_plan->CurrentValue) != "") {
                $this->extra_min_plan->ViewValue = $this->extra_min_plan->optionCaption($this->extra_min_plan->CurrentValue);
            } else {
                $this->extra_min_plan->ViewValue = null;
            }

            // office_holidays
            if (strval($this->office_holidays->CurrentValue) != "") {
                $this->office_holidays->ViewValue = $this->office_holidays->optionCaption($this->office_holidays->CurrentValue);
            } else {
                $this->office_holidays->ViewValue = null;
            }

            // paid_annual_leave
            $this->paid_annual_leave->ViewValue = $this->paid_annual_leave->CurrentValue;
            $this->paid_annual_leave->ViewValue = FormatNumber($this->paid_annual_leave->ViewValue, $this->paid_annual_leave->formatPattern());

            // employee_pf
            if (strval($this->employee_pf->CurrentValue) != "") {
                $this->employee_pf->ViewValue = $this->employee_pf->optionCaption($this->employee_pf->CurrentValue);
            } else {
                $this->employee_pf->ViewValue = null;
            }

            // calculation_plan
            $curVal = strval($this->calculation_plan->CurrentValue);
            if ($curVal != "") {
                $this->calculation_plan->ViewValue = $this->calculation_plan->lookupCacheOption($curVal);
                if ($this->calculation_plan->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->calculation_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->calculation_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->calculation_plan->getSelectFilter($this); // PHP
                    $sqlWrk = $this->calculation_plan->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->calculation_plan->Lookup->renderViewRow($rswrk[0]);
                        $this->calculation_plan->ViewValue = $this->calculation_plan->displayValue($arwrk);
                    } else {
                        $this->calculation_plan->ViewValue = FormatNumber($this->calculation_plan->CurrentValue, $this->calculation_plan->formatPattern());
                    }
                }
            } else {
                $this->calculation_plan->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // status
            $this->status->ViewValue = $this->status->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // month_min
            $this->month_min->ViewValue = $this->month_min->CurrentValue;
            $this->month_min->ViewValue = FormatNumber($this->month_min->ViewValue, $this->month_min->formatPattern());

            // id
            $this->id->HrefValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";

            // employee_am_id
            $this->employee_am_id->HrefValue = "";

            // job_title
            $this->job_title->HrefValue = "";

            // daily_in
            $this->daily_in->HrefValue = "";

            // daily_out
            $this->daily_out->HrefValue = "";

            // lunch_break_min
            $this->lunch_break_min->HrefValue = "";

            // daily_min
            $this->daily_min->HrefValue = "";

            // weekly_off
            $this->weekly_off->HrefValue = "";

            // offsets_benifit_min
            $this->offsets_benifit_min->HrefValue = "";

            // next_increment
            $this->next_increment->HrefValue = "";

            // current_payroll_startdate
            $this->current_payroll_startdate->HrefValue = "";

            // base_salary
            $this->base_salary->HrefValue = "";

            // additional_benefits
            $this->additional_benefits->HrefValue = "";

            // extra_min_plan
            $this->extra_min_plan->HrefValue = "";

            // office_holidays
            $this->office_holidays->HrefValue = "";

            // paid_annual_leave
            $this->paid_annual_leave->HrefValue = "";

            // employee_pf
            $this->employee_pf->HrefValue = "";

            // calculation_plan
            $this->calculation_plan->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // month_min
            $this->month_min->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;
            $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

            // employee_id
            $this->employee_id->setupEditAttributes();
            $this->employee_id->EditValue = $this->employee_id->CurrentValue;
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->EditValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_id->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_id->EditValue = $this->employee_id->displayValue($arwrk);
                    } else {
                        $this->employee_id->EditValue = HtmlEncode(FormatNumber($this->employee_id->CurrentValue, $this->employee_id->formatPattern()));
                    }
                }
            } else {
                $this->employee_id->EditValue = null;
            }
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // employee_am_id
            $this->employee_am_id->setupEditAttributes();
            $this->employee_am_id->EditValue = $this->employee_am_id->CurrentValue;
            $this->employee_am_id->PlaceHolder = RemoveHtml($this->employee_am_id->caption());
            if (strval($this->employee_am_id->EditValue) != "" && is_numeric($this->employee_am_id->EditValue)) {
                $this->employee_am_id->EditValue = FormatNumber($this->employee_am_id->EditValue, null);
            }

            // job_title
            $this->job_title->setupEditAttributes();
            if (!$this->job_title->Raw) {
                $this->job_title->CurrentValue = HtmlDecode($this->job_title->CurrentValue);
            }
            $this->job_title->EditValue = HtmlEncode($this->job_title->CurrentValue);
            $this->job_title->PlaceHolder = RemoveHtml($this->job_title->caption());

            // daily_in
            $this->daily_in->setupEditAttributes();
            $this->daily_in->EditValue = HtmlEncode(FormatDateTime($this->daily_in->CurrentValue, $this->daily_in->formatPattern()));
            $this->daily_in->PlaceHolder = RemoveHtml($this->daily_in->caption());

            // daily_out
            $this->daily_out->setupEditAttributes();
            $this->daily_out->EditValue = HtmlEncode(FormatDateTime($this->daily_out->CurrentValue, $this->daily_out->formatPattern()));
            $this->daily_out->PlaceHolder = RemoveHtml($this->daily_out->caption());

            // lunch_break_min
            $this->lunch_break_min->setupEditAttributes();
            $this->lunch_break_min->EditValue = $this->lunch_break_min->CurrentValue;
            $this->lunch_break_min->PlaceHolder = RemoveHtml($this->lunch_break_min->caption());
            if (strval($this->lunch_break_min->EditValue) != "" && is_numeric($this->lunch_break_min->EditValue)) {
                $this->lunch_break_min->EditValue = FormatNumber($this->lunch_break_min->EditValue, null);
            }

            // daily_min
            $this->daily_min->setupEditAttributes();
            $this->daily_min->EditValue = $this->daily_min->CurrentValue;
            $this->daily_min->PlaceHolder = RemoveHtml($this->daily_min->caption());
            if (strval($this->daily_min->EditValue) != "" && is_numeric($this->daily_min->EditValue)) {
                $this->daily_min->EditValue = FormatNumber($this->daily_min->EditValue, null);
            }

            // weekly_off
            $this->weekly_off->setupEditAttributes();
            $this->weekly_off->EditValue = $this->weekly_off->options(false);
            $this->weekly_off->PlaceHolder = RemoveHtml($this->weekly_off->caption());

            // offsets_benifit_min
            $this->offsets_benifit_min->setupEditAttributes();
            $this->offsets_benifit_min->EditValue = $this->offsets_benifit_min->CurrentValue;
            $this->offsets_benifit_min->PlaceHolder = RemoveHtml($this->offsets_benifit_min->caption());
            if (strval($this->offsets_benifit_min->EditValue) != "" && is_numeric($this->offsets_benifit_min->EditValue)) {
                $this->offsets_benifit_min->EditValue = FormatNumber($this->offsets_benifit_min->EditValue, null);
            }

            // next_increment
            $this->next_increment->setupEditAttributes();
            $this->next_increment->EditValue = HtmlEncode(FormatDateTime($this->next_increment->CurrentValue, $this->next_increment->formatPattern()));
            $this->next_increment->PlaceHolder = RemoveHtml($this->next_increment->caption());

            // current_payroll_startdate
            $this->current_payroll_startdate->setupEditAttributes();
            $this->current_payroll_startdate->EditValue = HtmlEncode(FormatDateTime($this->current_payroll_startdate->CurrentValue, $this->current_payroll_startdate->formatPattern()));
            $this->current_payroll_startdate->PlaceHolder = RemoveHtml($this->current_payroll_startdate->caption());

            // base_salary
            $this->base_salary->setupEditAttributes();
            $this->base_salary->EditValue = $this->base_salary->CurrentValue;
            $this->base_salary->PlaceHolder = RemoveHtml($this->base_salary->caption());
            if (strval($this->base_salary->EditValue) != "" && is_numeric($this->base_salary->EditValue)) {
                $this->base_salary->EditValue = FormatNumber($this->base_salary->EditValue, null);
            }

            // additional_benefits
            $this->additional_benefits->setupEditAttributes();
            $curVal = trim(strval($this->additional_benefits->CurrentValue));
            if ($curVal != "") {
                $this->additional_benefits->ViewValue = $this->additional_benefits->lookupCacheOption($curVal);
            } else {
                $this->additional_benefits->ViewValue = $this->additional_benefits->Lookup !== null && is_array($this->additional_benefits->lookupOptions()) && count($this->additional_benefits->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->additional_benefits->ViewValue !== null) { // Load from cache
                $this->additional_benefits->EditValue = array_values($this->additional_benefits->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->additional_benefits->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->additional_benefits->CurrentValue, $this->additional_benefits->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->additional_benefits->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->additional_benefits->Lookup->renderViewRow($row);
                }
                $this->additional_benefits->EditValue = $arwrk;
            }
            $this->additional_benefits->PlaceHolder = RemoveHtml($this->additional_benefits->caption());

            // extra_min_plan
            $this->extra_min_plan->setupEditAttributes();
            $this->extra_min_plan->EditValue = $this->extra_min_plan->options(true);
            $this->extra_min_plan->PlaceHolder = RemoveHtml($this->extra_min_plan->caption());

            // office_holidays
            $this->office_holidays->setupEditAttributes();
            $this->office_holidays->EditValue = $this->office_holidays->options(true);
            $this->office_holidays->PlaceHolder = RemoveHtml($this->office_holidays->caption());

            // paid_annual_leave
            $this->paid_annual_leave->setupEditAttributes();
            $this->paid_annual_leave->EditValue = $this->paid_annual_leave->CurrentValue;
            $this->paid_annual_leave->PlaceHolder = RemoveHtml($this->paid_annual_leave->caption());
            if (strval($this->paid_annual_leave->EditValue) != "" && is_numeric($this->paid_annual_leave->EditValue)) {
                $this->paid_annual_leave->EditValue = FormatNumber($this->paid_annual_leave->EditValue, null);
            }

            // employee_pf
            $this->employee_pf->setupEditAttributes();
            $this->employee_pf->EditValue = $this->employee_pf->options(true);
            $this->employee_pf->PlaceHolder = RemoveHtml($this->employee_pf->caption());

            // calculation_plan
            $this->calculation_plan->setupEditAttributes();
            $curVal = trim(strval($this->calculation_plan->CurrentValue));
            if ($curVal != "") {
                $this->calculation_plan->ViewValue = $this->calculation_plan->lookupCacheOption($curVal);
            } else {
                $this->calculation_plan->ViewValue = $this->calculation_plan->Lookup !== null && is_array($this->calculation_plan->lookupOptions()) && count($this->calculation_plan->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->calculation_plan->ViewValue !== null) { // Load from cache
                $this->calculation_plan->EditValue = array_values($this->calculation_plan->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->calculation_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->calculation_plan->CurrentValue, $this->calculation_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->calculation_plan->getSelectFilter($this); // PHP
                $sqlWrk = $this->calculation_plan->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->calculation_plan->EditValue = $arwrk;
            }
            $this->calculation_plan->PlaceHolder = RemoveHtml($this->calculation_plan->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->CurrentValue;
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // month_min
            $this->month_min->setupEditAttributes();
            $this->month_min->EditValue = $this->month_min->CurrentValue;
            $this->month_min->PlaceHolder = RemoveHtml($this->month_min->caption());
            if (strval($this->month_min->EditValue) != "" && is_numeric($this->month_min->EditValue)) {
                $this->month_min->EditValue = FormatNumber($this->month_min->EditValue, null);
            }

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";

            // employee_am_id
            $this->employee_am_id->HrefValue = "";

            // job_title
            $this->job_title->HrefValue = "";

            // daily_in
            $this->daily_in->HrefValue = "";

            // daily_out
            $this->daily_out->HrefValue = "";

            // lunch_break_min
            $this->lunch_break_min->HrefValue = "";

            // daily_min
            $this->daily_min->HrefValue = "";

            // weekly_off
            $this->weekly_off->HrefValue = "";

            // offsets_benifit_min
            $this->offsets_benifit_min->HrefValue = "";

            // next_increment
            $this->next_increment->HrefValue = "";

            // current_payroll_startdate
            $this->current_payroll_startdate->HrefValue = "";

            // base_salary
            $this->base_salary->HrefValue = "";

            // additional_benefits
            $this->additional_benefits->HrefValue = "";

            // extra_min_plan
            $this->extra_min_plan->HrefValue = "";

            // office_holidays
            $this->office_holidays->HrefValue = "";

            // paid_annual_leave
            $this->paid_annual_leave->HrefValue = "";

            // employee_pf
            $this->employee_pf->HrefValue = "";

            // calculation_plan
            $this->calculation_plan->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // month_min
            $this->month_min->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->employee_id->Visible && $this->employee_id->Required) {
                if (!$this->employee_id->IsDetailKey && EmptyValue($this->employee_id->FormValue)) {
                    $this->employee_id->addErrorMessage(str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->employee_id->FormValue)) {
                $this->employee_id->addErrorMessage($this->employee_id->getErrorMessage(false));
            }
            if ($this->employee_am_id->Visible && $this->employee_am_id->Required) {
                if (!$this->employee_am_id->IsDetailKey && EmptyValue($this->employee_am_id->FormValue)) {
                    $this->employee_am_id->addErrorMessage(str_replace("%s", $this->employee_am_id->caption(), $this->employee_am_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->employee_am_id->FormValue)) {
                $this->employee_am_id->addErrorMessage($this->employee_am_id->getErrorMessage(false));
            }
            if ($this->job_title->Visible && $this->job_title->Required) {
                if (!$this->job_title->IsDetailKey && EmptyValue($this->job_title->FormValue)) {
                    $this->job_title->addErrorMessage(str_replace("%s", $this->job_title->caption(), $this->job_title->RequiredErrorMessage));
                }
            }
            if ($this->daily_in->Visible && $this->daily_in->Required) {
                if (!$this->daily_in->IsDetailKey && EmptyValue($this->daily_in->FormValue)) {
                    $this->daily_in->addErrorMessage(str_replace("%s", $this->daily_in->caption(), $this->daily_in->RequiredErrorMessage));
                }
            }
            if (!CheckTime($this->daily_in->FormValue, $this->daily_in->formatPattern())) {
                $this->daily_in->addErrorMessage($this->daily_in->getErrorMessage(false));
            }
            if ($this->daily_out->Visible && $this->daily_out->Required) {
                if (!$this->daily_out->IsDetailKey && EmptyValue($this->daily_out->FormValue)) {
                    $this->daily_out->addErrorMessage(str_replace("%s", $this->daily_out->caption(), $this->daily_out->RequiredErrorMessage));
                }
            }
            if (!CheckTime($this->daily_out->FormValue, $this->daily_out->formatPattern())) {
                $this->daily_out->addErrorMessage($this->daily_out->getErrorMessage(false));
            }
            if ($this->lunch_break_min->Visible && $this->lunch_break_min->Required) {
                if (!$this->lunch_break_min->IsDetailKey && EmptyValue($this->lunch_break_min->FormValue)) {
                    $this->lunch_break_min->addErrorMessage(str_replace("%s", $this->lunch_break_min->caption(), $this->lunch_break_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->lunch_break_min->FormValue)) {
                $this->lunch_break_min->addErrorMessage($this->lunch_break_min->getErrorMessage(false));
            }
            if ($this->daily_min->Visible && $this->daily_min->Required) {
                if (!$this->daily_min->IsDetailKey && EmptyValue($this->daily_min->FormValue)) {
                    $this->daily_min->addErrorMessage(str_replace("%s", $this->daily_min->caption(), $this->daily_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->daily_min->FormValue)) {
                $this->daily_min->addErrorMessage($this->daily_min->getErrorMessage(false));
            }
            if ($this->weekly_off->Visible && $this->weekly_off->Required) {
                if ($this->weekly_off->FormValue == "") {
                    $this->weekly_off->addErrorMessage(str_replace("%s", $this->weekly_off->caption(), $this->weekly_off->RequiredErrorMessage));
                }
            }
            if ($this->offsets_benifit_min->Visible && $this->offsets_benifit_min->Required) {
                if (!$this->offsets_benifit_min->IsDetailKey && EmptyValue($this->offsets_benifit_min->FormValue)) {
                    $this->offsets_benifit_min->addErrorMessage(str_replace("%s", $this->offsets_benifit_min->caption(), $this->offsets_benifit_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->offsets_benifit_min->FormValue)) {
                $this->offsets_benifit_min->addErrorMessage($this->offsets_benifit_min->getErrorMessage(false));
            }
            if ($this->next_increment->Visible && $this->next_increment->Required) {
                if (!$this->next_increment->IsDetailKey && EmptyValue($this->next_increment->FormValue)) {
                    $this->next_increment->addErrorMessage(str_replace("%s", $this->next_increment->caption(), $this->next_increment->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->next_increment->FormValue, $this->next_increment->formatPattern())) {
                $this->next_increment->addErrorMessage($this->next_increment->getErrorMessage(false));
            }
            if ($this->current_payroll_startdate->Visible && $this->current_payroll_startdate->Required) {
                if (!$this->current_payroll_startdate->IsDetailKey && EmptyValue($this->current_payroll_startdate->FormValue)) {
                    $this->current_payroll_startdate->addErrorMessage(str_replace("%s", $this->current_payroll_startdate->caption(), $this->current_payroll_startdate->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->current_payroll_startdate->FormValue, $this->current_payroll_startdate->formatPattern())) {
                $this->current_payroll_startdate->addErrorMessage($this->current_payroll_startdate->getErrorMessage(false));
            }
            if ($this->base_salary->Visible && $this->base_salary->Required) {
                if (!$this->base_salary->IsDetailKey && EmptyValue($this->base_salary->FormValue)) {
                    $this->base_salary->addErrorMessage(str_replace("%s", $this->base_salary->caption(), $this->base_salary->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->base_salary->FormValue)) {
                $this->base_salary->addErrorMessage($this->base_salary->getErrorMessage(false));
            }
            if ($this->additional_benefits->Visible && $this->additional_benefits->Required) {
                if (!$this->additional_benefits->IsDetailKey && EmptyValue($this->additional_benefits->FormValue)) {
                    $this->additional_benefits->addErrorMessage(str_replace("%s", $this->additional_benefits->caption(), $this->additional_benefits->RequiredErrorMessage));
                }
            }
            if ($this->extra_min_plan->Visible && $this->extra_min_plan->Required) {
                if (!$this->extra_min_plan->IsDetailKey && EmptyValue($this->extra_min_plan->FormValue)) {
                    $this->extra_min_plan->addErrorMessage(str_replace("%s", $this->extra_min_plan->caption(), $this->extra_min_plan->RequiredErrorMessage));
                }
            }
            if ($this->office_holidays->Visible && $this->office_holidays->Required) {
                if (!$this->office_holidays->IsDetailKey && EmptyValue($this->office_holidays->FormValue)) {
                    $this->office_holidays->addErrorMessage(str_replace("%s", $this->office_holidays->caption(), $this->office_holidays->RequiredErrorMessage));
                }
            }
            if ($this->paid_annual_leave->Visible && $this->paid_annual_leave->Required) {
                if (!$this->paid_annual_leave->IsDetailKey && EmptyValue($this->paid_annual_leave->FormValue)) {
                    $this->paid_annual_leave->addErrorMessage(str_replace("%s", $this->paid_annual_leave->caption(), $this->paid_annual_leave->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->paid_annual_leave->FormValue)) {
                $this->paid_annual_leave->addErrorMessage($this->paid_annual_leave->getErrorMessage(false));
            }
            if ($this->employee_pf->Visible && $this->employee_pf->Required) {
                if (!$this->employee_pf->IsDetailKey && EmptyValue($this->employee_pf->FormValue)) {
                    $this->employee_pf->addErrorMessage(str_replace("%s", $this->employee_pf->caption(), $this->employee_pf->RequiredErrorMessage));
                }
            }
            if ($this->calculation_plan->Visible && $this->calculation_plan->Required) {
                if (!$this->calculation_plan->IsDetailKey && EmptyValue($this->calculation_plan->FormValue)) {
                    $this->calculation_plan->addErrorMessage(str_replace("%s", $this->calculation_plan->caption(), $this->calculation_plan->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->status->FormValue)) {
                $this->status->addErrorMessage($this->status->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->month_min->Visible && $this->month_min->Required) {
                if (!$this->month_min->IsDetailKey && EmptyValue($this->month_min->FormValue)) {
                    $this->month_min->addErrorMessage(str_replace("%s", $this->month_min->caption(), $this->month_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->month_min->FormValue)) {
                $this->month_min->addErrorMessage($this->month_min->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // employee_id
        $this->employee_id->setDbValueDef($rsnew, $this->employee_id->CurrentValue, $this->employee_id->ReadOnly);

        // employee_am_id
        $this->employee_am_id->setDbValueDef($rsnew, $this->employee_am_id->CurrentValue, $this->employee_am_id->ReadOnly);

        // job_title
        $this->job_title->setDbValueDef($rsnew, $this->job_title->CurrentValue, $this->job_title->ReadOnly);

        // daily_in
        $this->daily_in->setDbValueDef($rsnew, UnFormatDateTime($this->daily_in->CurrentValue, $this->daily_in->formatPattern()), $this->daily_in->ReadOnly);

        // daily_out
        $this->daily_out->setDbValueDef($rsnew, UnFormatDateTime($this->daily_out->CurrentValue, $this->daily_out->formatPattern()), $this->daily_out->ReadOnly);

        // lunch_break_min
        $this->lunch_break_min->setDbValueDef($rsnew, $this->lunch_break_min->CurrentValue, $this->lunch_break_min->ReadOnly);

        // daily_min
        $this->daily_min->setDbValueDef($rsnew, $this->daily_min->CurrentValue, $this->daily_min->ReadOnly);

        // weekly_off
        $this->weekly_off->setDbValueDef($rsnew, $this->weekly_off->CurrentValue, $this->weekly_off->ReadOnly);

        // offsets_benifit_min
        $this->offsets_benifit_min->setDbValueDef($rsnew, $this->offsets_benifit_min->CurrentValue, $this->offsets_benifit_min->ReadOnly);

        // next_increment
        $this->next_increment->setDbValueDef($rsnew, UnFormatDateTime($this->next_increment->CurrentValue, $this->next_increment->formatPattern()), $this->next_increment->ReadOnly);

        // current_payroll_startdate
        $this->current_payroll_startdate->setDbValueDef($rsnew, UnFormatDateTime($this->current_payroll_startdate->CurrentValue, $this->current_payroll_startdate->formatPattern()), $this->current_payroll_startdate->ReadOnly);

        // base_salary
        $this->base_salary->setDbValueDef($rsnew, $this->base_salary->CurrentValue, $this->base_salary->ReadOnly);

        // additional_benefits
        $this->additional_benefits->setDbValueDef($rsnew, $this->additional_benefits->CurrentValue, $this->additional_benefits->ReadOnly);

        // extra_min_plan
        $this->extra_min_plan->setDbValueDef($rsnew, $this->extra_min_plan->CurrentValue, $this->extra_min_plan->ReadOnly);

        // office_holidays
        $this->office_holidays->setDbValueDef($rsnew, $this->office_holidays->CurrentValue, $this->office_holidays->ReadOnly);

        // paid_annual_leave
        $this->paid_annual_leave->setDbValueDef($rsnew, $this->paid_annual_leave->CurrentValue, $this->paid_annual_leave->ReadOnly);

        // employee_pf
        $this->employee_pf->setDbValueDef($rsnew, $this->employee_pf->CurrentValue, $this->employee_pf->ReadOnly);

        // calculation_plan
        $this->calculation_plan->setDbValueDef($rsnew, $this->calculation_plan->CurrentValue, $this->calculation_plan->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // month_min
        $this->month_min->setDbValueDef($rsnew, $this->month_min->CurrentValue, $this->month_min->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['employee_id'])) { // employee_id
            $this->employee_id->CurrentValue = $row['employee_id'];
        }
        if (isset($row['employee_am_id'])) { // employee_am_id
            $this->employee_am_id->CurrentValue = $row['employee_am_id'];
        }
        if (isset($row['job_title'])) { // job_title
            $this->job_title->CurrentValue = $row['job_title'];
        }
        if (isset($row['daily_in'])) { // daily_in
            $this->daily_in->CurrentValue = $row['daily_in'];
        }
        if (isset($row['daily_out'])) { // daily_out
            $this->daily_out->CurrentValue = $row['daily_out'];
        }
        if (isset($row['lunch_break_min'])) { // lunch_break_min
            $this->lunch_break_min->CurrentValue = $row['lunch_break_min'];
        }
        if (isset($row['daily_min'])) { // daily_min
            $this->daily_min->CurrentValue = $row['daily_min'];
        }
        if (isset($row['weekly_off'])) { // weekly_off
            $this->weekly_off->CurrentValue = $row['weekly_off'];
        }
        if (isset($row['offsets_benifit_min'])) { // offsets_benifit_min
            $this->offsets_benifit_min->CurrentValue = $row['offsets_benifit_min'];
        }
        if (isset($row['next_increment'])) { // next_increment
            $this->next_increment->CurrentValue = $row['next_increment'];
        }
        if (isset($row['current_payroll_startdate'])) { // current_payroll_startdate
            $this->current_payroll_startdate->CurrentValue = $row['current_payroll_startdate'];
        }
        if (isset($row['base_salary'])) { // base_salary
            $this->base_salary->CurrentValue = $row['base_salary'];
        }
        if (isset($row['additional_benefits'])) { // additional_benefits
            $this->additional_benefits->CurrentValue = $row['additional_benefits'];
        }
        if (isset($row['extra_min_plan'])) { // extra_min_plan
            $this->extra_min_plan->CurrentValue = $row['extra_min_plan'];
        }
        if (isset($row['office_holidays'])) { // office_holidays
            $this->office_holidays->CurrentValue = $row['office_holidays'];
        }
        if (isset($row['paid_annual_leave'])) { // paid_annual_leave
            $this->paid_annual_leave->CurrentValue = $row['paid_annual_leave'];
        }
        if (isset($row['employee_pf'])) { // employee_pf
            $this->employee_pf->CurrentValue = $row['employee_pf'];
        }
        if (isset($row['calculation_plan'])) { // calculation_plan
            $this->calculation_plan->CurrentValue = $row['calculation_plan'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['month_min'])) { // month_min
            $this->month_min->CurrentValue = $row['month_min'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("payrollfixdetailslist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_employee_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_weekly_off":
                    break;
                case "x_additional_benefits":
                    break;
                case "x_extra_min_plan":
                    break;
                case "x_office_holidays":
                    break;
                case "x_employee_pf":
                    break;
                case "x_calculation_plan":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
