<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PayrollDetailsEdit extends PayrollDetails
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PayrollDetailsEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "payrolldetailsedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->employee_id->setVisibility();
        $this->month->setVisibility();
        $this->default_min->setVisibility();
        $this->month_min->setVisibility();
        $this->offsets_benifit_min->setVisibility();
        $this->office_holidays_min->setVisibility();
        $this->paid_leave_adj_min->setVisibility();
        $this->weekly_off_min->setVisibility();
        $this->overtime->setVisibility();
        $this->total_min->setVisibility();
        $this->remarks->setVisibility();
        $this->base_salary->setVisibility();
        $this->additional_benefits->setVisibility();
        $this->employee_pf->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->employee_am_id->setVisibility();
        $this->salary_earned->setVisibility();
        $this->uid->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'payroll_details';
        $this->TableName = 'payroll_details';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (payroll_details)
        if (!isset($GLOBALS["payroll_details"]) || $GLOBALS["payroll_details"]::class == PROJECT_NAMESPACE . "payroll_details") {
            $GLOBALS["payroll_details"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'payroll_details');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "payrolldetailsview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->employee_id);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("payrolldetailslist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "payrolldetailslist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "payrolldetailslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "payrolldetailslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'employee_id' first before field var 'x_employee_id'
        $val = $CurrentForm->hasValue("employee_id") ? $CurrentForm->getValue("employee_id") : $CurrentForm->getValue("x_employee_id");
        if (!$this->employee_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_id->Visible = false; // Disable update for API request
            } else {
                $this->employee_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'month' first before field var 'x_month'
        $val = $CurrentForm->hasValue("month") ? $CurrentForm->getValue("month") : $CurrentForm->getValue("x_month");
        if (!$this->month->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->month->Visible = false; // Disable update for API request
            } else {
                $this->month->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'default_min' first before field var 'x_default_min'
        $val = $CurrentForm->hasValue("default_min") ? $CurrentForm->getValue("default_min") : $CurrentForm->getValue("x_default_min");
        if (!$this->default_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->default_min->Visible = false; // Disable update for API request
            } else {
                $this->default_min->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'month_min' first before field var 'x_month_min'
        $val = $CurrentForm->hasValue("month_min") ? $CurrentForm->getValue("month_min") : $CurrentForm->getValue("x_month_min");
        if (!$this->month_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->month_min->Visible = false; // Disable update for API request
            } else {
                $this->month_min->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'offsets_benifit_min' first before field var 'x_offsets_benifit_min'
        $val = $CurrentForm->hasValue("offsets_benifit_min") ? $CurrentForm->getValue("offsets_benifit_min") : $CurrentForm->getValue("x_offsets_benifit_min");
        if (!$this->offsets_benifit_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->offsets_benifit_min->Visible = false; // Disable update for API request
            } else {
                $this->offsets_benifit_min->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'office_holidays_min' first before field var 'x_office_holidays_min'
        $val = $CurrentForm->hasValue("office_holidays_min") ? $CurrentForm->getValue("office_holidays_min") : $CurrentForm->getValue("x_office_holidays_min");
        if (!$this->office_holidays_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->office_holidays_min->Visible = false; // Disable update for API request
            } else {
                $this->office_holidays_min->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'paid_leave_adj_min' first before field var 'x_paid_leave_adj_min'
        $val = $CurrentForm->hasValue("paid_leave_adj_min") ? $CurrentForm->getValue("paid_leave_adj_min") : $CurrentForm->getValue("x_paid_leave_adj_min");
        if (!$this->paid_leave_adj_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->paid_leave_adj_min->Visible = false; // Disable update for API request
            } else {
                $this->paid_leave_adj_min->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'weekly_off_min' first before field var 'x_weekly_off_min'
        $val = $CurrentForm->hasValue("weekly_off_min") ? $CurrentForm->getValue("weekly_off_min") : $CurrentForm->getValue("x_weekly_off_min");
        if (!$this->weekly_off_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weekly_off_min->Visible = false; // Disable update for API request
            } else {
                $this->weekly_off_min->setFormValue($val);
            }
        }

        // Check field name 'overtime' first before field var 'x_overtime'
        $val = $CurrentForm->hasValue("overtime") ? $CurrentForm->getValue("overtime") : $CurrentForm->getValue("x_overtime");
        if (!$this->overtime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->overtime->Visible = false; // Disable update for API request
            } else {
                $this->overtime->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'total_min' first before field var 'x_total_min'
        $val = $CurrentForm->hasValue("total_min") ? $CurrentForm->getValue("total_min") : $CurrentForm->getValue("x_total_min");
        if (!$this->total_min->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->total_min->Visible = false; // Disable update for API request
            } else {
                $this->total_min->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'base_salary' first before field var 'x_base_salary'
        $val = $CurrentForm->hasValue("base_salary") ? $CurrentForm->getValue("base_salary") : $CurrentForm->getValue("x_base_salary");
        if (!$this->base_salary->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->base_salary->Visible = false; // Disable update for API request
            } else {
                $this->base_salary->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'additional_benefits' first before field var 'x_additional_benefits'
        $val = $CurrentForm->hasValue("additional_benefits") ? $CurrentForm->getValue("additional_benefits") : $CurrentForm->getValue("x_additional_benefits");
        if (!$this->additional_benefits->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->additional_benefits->Visible = false; // Disable update for API request
            } else {
                $this->additional_benefits->setFormValue($val);
            }
        }

        // Check field name 'employee_pf' first before field var 'x_employee_pf'
        $val = $CurrentForm->hasValue("employee_pf") ? $CurrentForm->getValue("employee_pf") : $CurrentForm->getValue("x_employee_pf");
        if (!$this->employee_pf->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_pf->Visible = false; // Disable update for API request
            } else {
                $this->employee_pf->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'employee_am_id' first before field var 'x_employee_am_id'
        $val = $CurrentForm->hasValue("employee_am_id") ? $CurrentForm->getValue("employee_am_id") : $CurrentForm->getValue("x_employee_am_id");
        if (!$this->employee_am_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employee_am_id->Visible = false; // Disable update for API request
            } else {
                $this->employee_am_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'salary_earned' first before field var 'x_salary_earned'
        $val = $CurrentForm->hasValue("salary_earned") ? $CurrentForm->getValue("salary_earned") : $CurrentForm->getValue("x_salary_earned");
        if (!$this->salary_earned->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->salary_earned->Visible = false; // Disable update for API request
            } else {
                $this->salary_earned->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'uid' first before field var 'x_uid'
        $val = $CurrentForm->hasValue("uid") ? $CurrentForm->getValue("uid") : $CurrentForm->getValue("x_uid");
        if (!$this->uid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->uid->Visible = false; // Disable update for API request
            } else {
                $this->uid->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->employee_id->CurrentValue = $this->employee_id->FormValue;
        $this->month->CurrentValue = $this->month->FormValue;
        $this->default_min->CurrentValue = $this->default_min->FormValue;
        $this->month_min->CurrentValue = $this->month_min->FormValue;
        $this->offsets_benifit_min->CurrentValue = $this->offsets_benifit_min->FormValue;
        $this->office_holidays_min->CurrentValue = $this->office_holidays_min->FormValue;
        $this->paid_leave_adj_min->CurrentValue = $this->paid_leave_adj_min->FormValue;
        $this->weekly_off_min->CurrentValue = $this->weekly_off_min->FormValue;
        $this->overtime->CurrentValue = $this->overtime->FormValue;
        $this->total_min->CurrentValue = $this->total_min->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->base_salary->CurrentValue = $this->base_salary->FormValue;
        $this->additional_benefits->CurrentValue = $this->additional_benefits->FormValue;
        $this->employee_pf->CurrentValue = $this->employee_pf->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->employee_am_id->CurrentValue = $this->employee_am_id->FormValue;
        $this->salary_earned->CurrentValue = $this->salary_earned->FormValue;
        $this->uid->CurrentValue = $this->uid->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->month->setDbValue($row['month']);
        $this->default_min->setDbValue($row['default_min']);
        $this->month_min->setDbValue($row['month_min']);
        $this->offsets_benifit_min->setDbValue($row['offsets_benifit_min']);
        $this->office_holidays_min->setDbValue($row['office_holidays_min']);
        $this->paid_leave_adj_min->setDbValue($row['paid_leave_adj_min']);
        $this->weekly_off_min->setDbValue($row['weekly_off_min']);
        $this->overtime->setDbValue($row['overtime']);
        $this->total_min->setDbValue($row['total_min']);
        $this->remarks->setDbValue($row['remarks']);
        $this->base_salary->setDbValue($row['base_salary']);
        $this->additional_benefits->setDbValue($row['additional_benefits']);
        $this->employee_pf->setDbValue($row['employee_pf']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->employee_am_id->setDbValue($row['employee_am_id']);
        $this->salary_earned->setDbValue($row['salary_earned']);
        $this->uid->setDbValue($row['uid']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['employee_id'] = $this->employee_id->DefaultValue;
        $row['month'] = $this->month->DefaultValue;
        $row['default_min'] = $this->default_min->DefaultValue;
        $row['month_min'] = $this->month_min->DefaultValue;
        $row['offsets_benifit_min'] = $this->offsets_benifit_min->DefaultValue;
        $row['office_holidays_min'] = $this->office_holidays_min->DefaultValue;
        $row['paid_leave_adj_min'] = $this->paid_leave_adj_min->DefaultValue;
        $row['weekly_off_min'] = $this->weekly_off_min->DefaultValue;
        $row['overtime'] = $this->overtime->DefaultValue;
        $row['total_min'] = $this->total_min->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['base_salary'] = $this->base_salary->DefaultValue;
        $row['additional_benefits'] = $this->additional_benefits->DefaultValue;
        $row['employee_pf'] = $this->employee_pf->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['employee_am_id'] = $this->employee_am_id->DefaultValue;
        $row['salary_earned'] = $this->salary_earned->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // employee_id
        $this->employee_id->RowCssClass = "row";

        // month
        $this->month->RowCssClass = "row";

        // default_min
        $this->default_min->RowCssClass = "row";

        // month_min
        $this->month_min->RowCssClass = "row";

        // offsets_benifit_min
        $this->offsets_benifit_min->RowCssClass = "row";

        // office_holidays_min
        $this->office_holidays_min->RowCssClass = "row";

        // paid_leave_adj_min
        $this->paid_leave_adj_min->RowCssClass = "row";

        // weekly_off_min
        $this->weekly_off_min->RowCssClass = "row";

        // overtime
        $this->overtime->RowCssClass = "row";

        // total_min
        $this->total_min->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // base_salary
        $this->base_salary->RowCssClass = "row";

        // additional_benefits
        $this->additional_benefits->RowCssClass = "row";

        // employee_pf
        $this->employee_pf->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // employee_am_id
        $this->employee_am_id->RowCssClass = "row";

        // salary_earned
        $this->salary_earned->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // employee_id
            $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_id->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_id->ViewValue = $this->employee_id->displayValue($arwrk);
                    } else {
                        $this->employee_id->ViewValue = FormatNumber($this->employee_id->CurrentValue, $this->employee_id->formatPattern());
                    }
                }
            } else {
                $this->employee_id->ViewValue = null;
            }

            // month
            $this->month->ViewValue = $this->month->CurrentValue;
            $this->month->ViewValue = FormatNumber($this->month->ViewValue, $this->month->formatPattern());

            // default_min
            $this->default_min->ViewValue = $this->default_min->CurrentValue;
            $this->default_min->ViewValue = FormatNumber($this->default_min->ViewValue, $this->default_min->formatPattern());

            // month_min
            $this->month_min->ViewValue = $this->month_min->CurrentValue;
            $this->month_min->ViewValue = FormatNumber($this->month_min->ViewValue, $this->month_min->formatPattern());

            // offsets_benifit_min
            $this->offsets_benifit_min->ViewValue = $this->offsets_benifit_min->CurrentValue;
            $this->offsets_benifit_min->ViewValue = FormatNumber($this->offsets_benifit_min->ViewValue, $this->offsets_benifit_min->formatPattern());

            // office_holidays_min
            $this->office_holidays_min->ViewValue = $this->office_holidays_min->CurrentValue;
            $this->office_holidays_min->ViewValue = FormatNumber($this->office_holidays_min->ViewValue, $this->office_holidays_min->formatPattern());

            // paid_leave_adj_min
            $this->paid_leave_adj_min->ViewValue = $this->paid_leave_adj_min->CurrentValue;
            $this->paid_leave_adj_min->ViewValue = FormatNumber($this->paid_leave_adj_min->ViewValue, $this->paid_leave_adj_min->formatPattern());

            // weekly_off_min
            $this->weekly_off_min->ViewValue = $this->weekly_off_min->CurrentValue;

            // overtime
            $this->overtime->ViewValue = $this->overtime->CurrentValue;
            $this->overtime->ViewValue = FormatNumber($this->overtime->ViewValue, $this->overtime->formatPattern());

            // total_min
            $this->total_min->ViewValue = $this->total_min->CurrentValue;
            $this->total_min->ViewValue = FormatNumber($this->total_min->ViewValue, $this->total_min->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // base_salary
            $this->base_salary->ViewValue = $this->base_salary->CurrentValue;
            $this->base_salary->ViewValue = FormatNumber($this->base_salary->ViewValue, $this->base_salary->formatPattern());

            // additional_benefits
            $this->additional_benefits->ViewValue = $this->additional_benefits->CurrentValue;

            // employee_pf
            $this->employee_pf->ViewValue = $this->employee_pf->CurrentValue;
            $this->employee_pf->ViewValue = FormatNumber($this->employee_pf->ViewValue, $this->employee_pf->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // employee_am_id
            $this->employee_am_id->ViewValue = $this->employee_am_id->CurrentValue;
            $this->employee_am_id->ViewValue = FormatNumber($this->employee_am_id->ViewValue, $this->employee_am_id->formatPattern());

            // salary_earned
            $this->salary_earned->ViewValue = $this->salary_earned->CurrentValue;
            $this->salary_earned->ViewValue = FormatNumber($this->salary_earned->ViewValue, $this->salary_earned->formatPattern());

            // uid
            $this->uid->ViewValue = $this->uid->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";

            // month
            $this->month->HrefValue = "";

            // default_min
            $this->default_min->HrefValue = "";

            // month_min
            $this->month_min->HrefValue = "";

            // offsets_benifit_min
            $this->offsets_benifit_min->HrefValue = "";

            // office_holidays_min
            $this->office_holidays_min->HrefValue = "";

            // paid_leave_adj_min
            $this->paid_leave_adj_min->HrefValue = "";

            // weekly_off_min
            $this->weekly_off_min->HrefValue = "";

            // overtime
            $this->overtime->HrefValue = "";

            // total_min
            $this->total_min->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // base_salary
            $this->base_salary->HrefValue = "";

            // additional_benefits
            $this->additional_benefits->HrefValue = "";

            // employee_pf
            $this->employee_pf->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // employee_am_id
            $this->employee_am_id->HrefValue = "";

            // salary_earned
            $this->salary_earned->HrefValue = "";

            // uid
            $this->uid->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;
            $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

            // employee_id
            $this->employee_id->setupEditAttributes();
            $this->employee_id->EditValue = $this->employee_id->CurrentValue;
            $curVal = strval($this->employee_id->CurrentValue);
            if ($curVal != "") {
                $this->employee_id->EditValue = $this->employee_id->lookupCacheOption($curVal);
                if ($this->employee_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->employee_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->employee_id->Lookup->renderViewRow($rswrk[0]);
                        $this->employee_id->EditValue = $this->employee_id->displayValue($arwrk);
                    } else {
                        $this->employee_id->EditValue = HtmlEncode(FormatNumber($this->employee_id->CurrentValue, $this->employee_id->formatPattern()));
                    }
                }
            } else {
                $this->employee_id->EditValue = null;
            }
            $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

            // month
            $this->month->setupEditAttributes();
            $this->month->EditValue = $this->month->CurrentValue;
            $this->month->PlaceHolder = RemoveHtml($this->month->caption());
            if (strval($this->month->EditValue) != "" && is_numeric($this->month->EditValue)) {
                $this->month->EditValue = FormatNumber($this->month->EditValue, null);
            }

            // default_min
            $this->default_min->setupEditAttributes();
            $this->default_min->EditValue = $this->default_min->CurrentValue;
            $this->default_min->PlaceHolder = RemoveHtml($this->default_min->caption());
            if (strval($this->default_min->EditValue) != "" && is_numeric($this->default_min->EditValue)) {
                $this->default_min->EditValue = FormatNumber($this->default_min->EditValue, null);
            }

            // month_min
            $this->month_min->setupEditAttributes();
            $this->month_min->EditValue = $this->month_min->CurrentValue;
            $this->month_min->PlaceHolder = RemoveHtml($this->month_min->caption());
            if (strval($this->month_min->EditValue) != "" && is_numeric($this->month_min->EditValue)) {
                $this->month_min->EditValue = FormatNumber($this->month_min->EditValue, null);
            }

            // offsets_benifit_min
            $this->offsets_benifit_min->setupEditAttributes();
            $this->offsets_benifit_min->EditValue = $this->offsets_benifit_min->CurrentValue;
            $this->offsets_benifit_min->PlaceHolder = RemoveHtml($this->offsets_benifit_min->caption());
            if (strval($this->offsets_benifit_min->EditValue) != "" && is_numeric($this->offsets_benifit_min->EditValue)) {
                $this->offsets_benifit_min->EditValue = FormatNumber($this->offsets_benifit_min->EditValue, null);
            }

            // office_holidays_min
            $this->office_holidays_min->setupEditAttributes();
            $this->office_holidays_min->EditValue = $this->office_holidays_min->CurrentValue;
            $this->office_holidays_min->PlaceHolder = RemoveHtml($this->office_holidays_min->caption());
            if (strval($this->office_holidays_min->EditValue) != "" && is_numeric($this->office_holidays_min->EditValue)) {
                $this->office_holidays_min->EditValue = FormatNumber($this->office_holidays_min->EditValue, null);
            }

            // paid_leave_adj_min
            $this->paid_leave_adj_min->setupEditAttributes();
            $this->paid_leave_adj_min->EditValue = $this->paid_leave_adj_min->CurrentValue;
            $this->paid_leave_adj_min->PlaceHolder = RemoveHtml($this->paid_leave_adj_min->caption());
            if (strval($this->paid_leave_adj_min->EditValue) != "" && is_numeric($this->paid_leave_adj_min->EditValue)) {
                $this->paid_leave_adj_min->EditValue = FormatNumber($this->paid_leave_adj_min->EditValue, null);
            }

            // weekly_off_min
            $this->weekly_off_min->setupEditAttributes();
            if (!$this->weekly_off_min->Raw) {
                $this->weekly_off_min->CurrentValue = HtmlDecode($this->weekly_off_min->CurrentValue);
            }
            $this->weekly_off_min->EditValue = HtmlEncode($this->weekly_off_min->CurrentValue);
            $this->weekly_off_min->PlaceHolder = RemoveHtml($this->weekly_off_min->caption());

            // overtime
            $this->overtime->setupEditAttributes();
            $this->overtime->EditValue = $this->overtime->CurrentValue;
            $this->overtime->PlaceHolder = RemoveHtml($this->overtime->caption());
            if (strval($this->overtime->EditValue) != "" && is_numeric($this->overtime->EditValue)) {
                $this->overtime->EditValue = FormatNumber($this->overtime->EditValue, null);
            }

            // total_min
            $this->total_min->setupEditAttributes();
            $this->total_min->EditValue = $this->total_min->CurrentValue;
            $this->total_min->PlaceHolder = RemoveHtml($this->total_min->caption());
            if (strval($this->total_min->EditValue) != "" && is_numeric($this->total_min->EditValue)) {
                $this->total_min->EditValue = FormatNumber($this->total_min->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // base_salary
            $this->base_salary->setupEditAttributes();
            $this->base_salary->EditValue = $this->base_salary->CurrentValue;
            $this->base_salary->PlaceHolder = RemoveHtml($this->base_salary->caption());
            if (strval($this->base_salary->EditValue) != "" && is_numeric($this->base_salary->EditValue)) {
                $this->base_salary->EditValue = FormatNumber($this->base_salary->EditValue, null);
            }

            // additional_benefits
            $this->additional_benefits->setupEditAttributes();
            if (!$this->additional_benefits->Raw) {
                $this->additional_benefits->CurrentValue = HtmlDecode($this->additional_benefits->CurrentValue);
            }
            $this->additional_benefits->EditValue = HtmlEncode($this->additional_benefits->CurrentValue);
            $this->additional_benefits->PlaceHolder = RemoveHtml($this->additional_benefits->caption());

            // employee_pf
            $this->employee_pf->setupEditAttributes();
            $this->employee_pf->EditValue = $this->employee_pf->CurrentValue;
            $this->employee_pf->PlaceHolder = RemoveHtml($this->employee_pf->caption());
            if (strval($this->employee_pf->EditValue) != "" && is_numeric($this->employee_pf->EditValue)) {
                $this->employee_pf->EditValue = FormatNumber($this->employee_pf->EditValue, null);
            }

            // operator

            // datetime

            // employee_am_id
            $this->employee_am_id->setupEditAttributes();
            $this->employee_am_id->EditValue = $this->employee_am_id->CurrentValue;
            $this->employee_am_id->PlaceHolder = RemoveHtml($this->employee_am_id->caption());
            if (strval($this->employee_am_id->EditValue) != "" && is_numeric($this->employee_am_id->EditValue)) {
                $this->employee_am_id->EditValue = FormatNumber($this->employee_am_id->EditValue, null);
            }

            // salary_earned
            $this->salary_earned->setupEditAttributes();
            $this->salary_earned->EditValue = $this->salary_earned->CurrentValue;
            $this->salary_earned->PlaceHolder = RemoveHtml($this->salary_earned->caption());
            if (strval($this->salary_earned->EditValue) != "" && is_numeric($this->salary_earned->EditValue)) {
                $this->salary_earned->EditValue = FormatNumber($this->salary_earned->EditValue, null);
            }

            // uid
            $this->uid->setupEditAttributes();
            if (!$this->uid->Raw) {
                $this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
            }
            $this->uid->EditValue = HtmlEncode($this->uid->CurrentValue);
            $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // employee_id
            $this->employee_id->HrefValue = "";

            // month
            $this->month->HrefValue = "";

            // default_min
            $this->default_min->HrefValue = "";

            // month_min
            $this->month_min->HrefValue = "";

            // offsets_benifit_min
            $this->offsets_benifit_min->HrefValue = "";

            // office_holidays_min
            $this->office_holidays_min->HrefValue = "";

            // paid_leave_adj_min
            $this->paid_leave_adj_min->HrefValue = "";

            // weekly_off_min
            $this->weekly_off_min->HrefValue = "";

            // overtime
            $this->overtime->HrefValue = "";

            // total_min
            $this->total_min->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // base_salary
            $this->base_salary->HrefValue = "";

            // additional_benefits
            $this->additional_benefits->HrefValue = "";

            // employee_pf
            $this->employee_pf->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // employee_am_id
            $this->employee_am_id->HrefValue = "";

            // salary_earned
            $this->salary_earned->HrefValue = "";

            // uid
            $this->uid->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->employee_id->Visible && $this->employee_id->Required) {
                if (!$this->employee_id->IsDetailKey && EmptyValue($this->employee_id->FormValue)) {
                    $this->employee_id->addErrorMessage(str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->employee_id->FormValue)) {
                $this->employee_id->addErrorMessage($this->employee_id->getErrorMessage(false));
            }
            if ($this->month->Visible && $this->month->Required) {
                if (!$this->month->IsDetailKey && EmptyValue($this->month->FormValue)) {
                    $this->month->addErrorMessage(str_replace("%s", $this->month->caption(), $this->month->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->month->FormValue)) {
                $this->month->addErrorMessage($this->month->getErrorMessage(false));
            }
            if ($this->default_min->Visible && $this->default_min->Required) {
                if (!$this->default_min->IsDetailKey && EmptyValue($this->default_min->FormValue)) {
                    $this->default_min->addErrorMessage(str_replace("%s", $this->default_min->caption(), $this->default_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->default_min->FormValue)) {
                $this->default_min->addErrorMessage($this->default_min->getErrorMessage(false));
            }
            if ($this->month_min->Visible && $this->month_min->Required) {
                if (!$this->month_min->IsDetailKey && EmptyValue($this->month_min->FormValue)) {
                    $this->month_min->addErrorMessage(str_replace("%s", $this->month_min->caption(), $this->month_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->month_min->FormValue)) {
                $this->month_min->addErrorMessage($this->month_min->getErrorMessage(false));
            }
            if ($this->offsets_benifit_min->Visible && $this->offsets_benifit_min->Required) {
                if (!$this->offsets_benifit_min->IsDetailKey && EmptyValue($this->offsets_benifit_min->FormValue)) {
                    $this->offsets_benifit_min->addErrorMessage(str_replace("%s", $this->offsets_benifit_min->caption(), $this->offsets_benifit_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->offsets_benifit_min->FormValue)) {
                $this->offsets_benifit_min->addErrorMessage($this->offsets_benifit_min->getErrorMessage(false));
            }
            if ($this->office_holidays_min->Visible && $this->office_holidays_min->Required) {
                if (!$this->office_holidays_min->IsDetailKey && EmptyValue($this->office_holidays_min->FormValue)) {
                    $this->office_holidays_min->addErrorMessage(str_replace("%s", $this->office_holidays_min->caption(), $this->office_holidays_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->office_holidays_min->FormValue)) {
                $this->office_holidays_min->addErrorMessage($this->office_holidays_min->getErrorMessage(false));
            }
            if ($this->paid_leave_adj_min->Visible && $this->paid_leave_adj_min->Required) {
                if (!$this->paid_leave_adj_min->IsDetailKey && EmptyValue($this->paid_leave_adj_min->FormValue)) {
                    $this->paid_leave_adj_min->addErrorMessage(str_replace("%s", $this->paid_leave_adj_min->caption(), $this->paid_leave_adj_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->paid_leave_adj_min->FormValue)) {
                $this->paid_leave_adj_min->addErrorMessage($this->paid_leave_adj_min->getErrorMessage(false));
            }
            if ($this->weekly_off_min->Visible && $this->weekly_off_min->Required) {
                if (!$this->weekly_off_min->IsDetailKey && EmptyValue($this->weekly_off_min->FormValue)) {
                    $this->weekly_off_min->addErrorMessage(str_replace("%s", $this->weekly_off_min->caption(), $this->weekly_off_min->RequiredErrorMessage));
                }
            }
            if ($this->overtime->Visible && $this->overtime->Required) {
                if (!$this->overtime->IsDetailKey && EmptyValue($this->overtime->FormValue)) {
                    $this->overtime->addErrorMessage(str_replace("%s", $this->overtime->caption(), $this->overtime->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->overtime->FormValue)) {
                $this->overtime->addErrorMessage($this->overtime->getErrorMessage(false));
            }
            if ($this->total_min->Visible && $this->total_min->Required) {
                if (!$this->total_min->IsDetailKey && EmptyValue($this->total_min->FormValue)) {
                    $this->total_min->addErrorMessage(str_replace("%s", $this->total_min->caption(), $this->total_min->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->total_min->FormValue)) {
                $this->total_min->addErrorMessage($this->total_min->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->base_salary->Visible && $this->base_salary->Required) {
                if (!$this->base_salary->IsDetailKey && EmptyValue($this->base_salary->FormValue)) {
                    $this->base_salary->addErrorMessage(str_replace("%s", $this->base_salary->caption(), $this->base_salary->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->base_salary->FormValue)) {
                $this->base_salary->addErrorMessage($this->base_salary->getErrorMessage(false));
            }
            if ($this->additional_benefits->Visible && $this->additional_benefits->Required) {
                if (!$this->additional_benefits->IsDetailKey && EmptyValue($this->additional_benefits->FormValue)) {
                    $this->additional_benefits->addErrorMessage(str_replace("%s", $this->additional_benefits->caption(), $this->additional_benefits->RequiredErrorMessage));
                }
            }
            if ($this->employee_pf->Visible && $this->employee_pf->Required) {
                if (!$this->employee_pf->IsDetailKey && EmptyValue($this->employee_pf->FormValue)) {
                    $this->employee_pf->addErrorMessage(str_replace("%s", $this->employee_pf->caption(), $this->employee_pf->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->employee_pf->FormValue)) {
                $this->employee_pf->addErrorMessage($this->employee_pf->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->employee_am_id->Visible && $this->employee_am_id->Required) {
                if (!$this->employee_am_id->IsDetailKey && EmptyValue($this->employee_am_id->FormValue)) {
                    $this->employee_am_id->addErrorMessage(str_replace("%s", $this->employee_am_id->caption(), $this->employee_am_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->employee_am_id->FormValue)) {
                $this->employee_am_id->addErrorMessage($this->employee_am_id->getErrorMessage(false));
            }
            if ($this->salary_earned->Visible && $this->salary_earned->Required) {
                if (!$this->salary_earned->IsDetailKey && EmptyValue($this->salary_earned->FormValue)) {
                    $this->salary_earned->addErrorMessage(str_replace("%s", $this->salary_earned->caption(), $this->salary_earned->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->salary_earned->FormValue)) {
                $this->salary_earned->addErrorMessage($this->salary_earned->getErrorMessage(false));
            }
            if ($this->uid->Visible && $this->uid->Required) {
                if (!$this->uid->IsDetailKey && EmptyValue($this->uid->FormValue)) {
                    $this->uid->addErrorMessage(str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (uid)
        if ($this->uid->CurrentValue != "") {
            $filterChk = "(`uid` = '" . AdjustSql($this->uid->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->uid->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->uid->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // employee_id
        $this->employee_id->setDbValueDef($rsnew, $this->employee_id->CurrentValue, $this->employee_id->ReadOnly);

        // month
        $this->month->setDbValueDef($rsnew, $this->month->CurrentValue, $this->month->ReadOnly);

        // default_min
        $this->default_min->setDbValueDef($rsnew, $this->default_min->CurrentValue, $this->default_min->ReadOnly);

        // month_min
        $this->month_min->setDbValueDef($rsnew, $this->month_min->CurrentValue, $this->month_min->ReadOnly);

        // offsets_benifit_min
        $this->offsets_benifit_min->setDbValueDef($rsnew, $this->offsets_benifit_min->CurrentValue, $this->offsets_benifit_min->ReadOnly);

        // office_holidays_min
        $this->office_holidays_min->setDbValueDef($rsnew, $this->office_holidays_min->CurrentValue, $this->office_holidays_min->ReadOnly);

        // paid_leave_adj_min
        $this->paid_leave_adj_min->setDbValueDef($rsnew, $this->paid_leave_adj_min->CurrentValue, $this->paid_leave_adj_min->ReadOnly);

        // weekly_off_min
        $this->weekly_off_min->setDbValueDef($rsnew, $this->weekly_off_min->CurrentValue, $this->weekly_off_min->ReadOnly);

        // overtime
        $this->overtime->setDbValueDef($rsnew, $this->overtime->CurrentValue, $this->overtime->ReadOnly);

        // total_min
        $this->total_min->setDbValueDef($rsnew, $this->total_min->CurrentValue, $this->total_min->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // base_salary
        $this->base_salary->setDbValueDef($rsnew, $this->base_salary->CurrentValue, $this->base_salary->ReadOnly);

        // additional_benefits
        $this->additional_benefits->setDbValueDef($rsnew, $this->additional_benefits->CurrentValue, $this->additional_benefits->ReadOnly);

        // employee_pf
        $this->employee_pf->setDbValueDef($rsnew, $this->employee_pf->CurrentValue, $this->employee_pf->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // employee_am_id
        $this->employee_am_id->setDbValueDef($rsnew, $this->employee_am_id->CurrentValue, $this->employee_am_id->ReadOnly);

        // salary_earned
        $this->salary_earned->setDbValueDef($rsnew, $this->salary_earned->CurrentValue, $this->salary_earned->ReadOnly);

        // uid
        $this->uid->setDbValueDef($rsnew, $this->uid->CurrentValue, $this->uid->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['employee_id'])) { // employee_id
            $this->employee_id->CurrentValue = $row['employee_id'];
        }
        if (isset($row['month'])) { // month
            $this->month->CurrentValue = $row['month'];
        }
        if (isset($row['default_min'])) { // default_min
            $this->default_min->CurrentValue = $row['default_min'];
        }
        if (isset($row['month_min'])) { // month_min
            $this->month_min->CurrentValue = $row['month_min'];
        }
        if (isset($row['offsets_benifit_min'])) { // offsets_benifit_min
            $this->offsets_benifit_min->CurrentValue = $row['offsets_benifit_min'];
        }
        if (isset($row['office_holidays_min'])) { // office_holidays_min
            $this->office_holidays_min->CurrentValue = $row['office_holidays_min'];
        }
        if (isset($row['paid_leave_adj_min'])) { // paid_leave_adj_min
            $this->paid_leave_adj_min->CurrentValue = $row['paid_leave_adj_min'];
        }
        if (isset($row['weekly_off_min'])) { // weekly_off_min
            $this->weekly_off_min->CurrentValue = $row['weekly_off_min'];
        }
        if (isset($row['overtime'])) { // overtime
            $this->overtime->CurrentValue = $row['overtime'];
        }
        if (isset($row['total_min'])) { // total_min
            $this->total_min->CurrentValue = $row['total_min'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['base_salary'])) { // base_salary
            $this->base_salary->CurrentValue = $row['base_salary'];
        }
        if (isset($row['additional_benefits'])) { // additional_benefits
            $this->additional_benefits->CurrentValue = $row['additional_benefits'];
        }
        if (isset($row['employee_pf'])) { // employee_pf
            $this->employee_pf->CurrentValue = $row['employee_pf'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['employee_am_id'])) { // employee_am_id
            $this->employee_am_id->CurrentValue = $row['employee_am_id'];
        }
        if (isset($row['salary_earned'])) { // salary_earned
            $this->salary_earned->CurrentValue = $row['salary_earned'];
        }
        if (isset($row['uid'])) { // uid
            $this->uid->CurrentValue = $row['uid'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("payrolldetailslist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_employee_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
