<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for payroll_details
 */
class PayrollDetails extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $employee_id;
    public $month;
    public $default_min;
    public $month_min;
    public $offsets_benifit_min;
    public $office_holidays_min;
    public $paid_leave_adj_min;
    public $weekly_off_min;
    public $overtime;
    public $total_min;
    public $remarks;
    public $base_salary;
    public $additional_benefits;
    public $employee_pf;
    public $operator;
    public $datetime;
    public $employee_am_id;
    public $salary_earned;
    public $uid;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "payroll_details";
        $this->TableName = 'payroll_details';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "payroll_details";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // employee_id
        $this->employee_id = new DbField(
            $this, // Table
            'x_employee_id', // Variable name
            'employee_id', // Name
            '`employee_id`', // Expression
            '`employee_id`', // Basic search expression
            3, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`employee_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->employee_id->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->employee_id->InputTextType = "text";
        $this->employee_id->Raw = true;
        $this->employee_id->Nullable = false; // NOT NULL field
        $this->employee_id->Required = true; // Required field
        $this->employee_id->Lookup = new Lookup($this->employee_id, 'production_employee', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->employee_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->employee_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['employee_id'] = &$this->employee_id;

        // month
        $this->month = new DbField(
            $this, // Table
            'x_month', // Variable name
            'month', // Name
            '`month`', // Expression
            '`month`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`month`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->month->InputTextType = "text";
        $this->month->Raw = true;
        $this->month->Nullable = false; // NOT NULL field
        $this->month->Required = true; // Required field
        $this->month->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->month->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['month'] = &$this->month;

        // default_min
        $this->default_min = new DbField(
            $this, // Table
            'x_default_min', // Variable name
            'default_min', // Name
            '`default_min`', // Expression
            '`default_min`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`default_min`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->default_min->InputTextType = "text";
        $this->default_min->Raw = true;
        $this->default_min->Nullable = false; // NOT NULL field
        $this->default_min->Required = true; // Required field
        $this->default_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->default_min->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['default_min'] = &$this->default_min;

        // month_min
        $this->month_min = new DbField(
            $this, // Table
            'x_month_min', // Variable name
            'month_min', // Name
            '`month_min`', // Expression
            '`month_min`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`month_min`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->month_min->InputTextType = "text";
        $this->month_min->Raw = true;
        $this->month_min->Nullable = false; // NOT NULL field
        $this->month_min->Required = true; // Required field
        $this->month_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->month_min->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['month_min'] = &$this->month_min;

        // offsets_benifit_min
        $this->offsets_benifit_min = new DbField(
            $this, // Table
            'x_offsets_benifit_min', // Variable name
            'offsets_benifit_min', // Name
            '`offsets_benifit_min`', // Expression
            '`offsets_benifit_min`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`offsets_benifit_min`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->offsets_benifit_min->InputTextType = "text";
        $this->offsets_benifit_min->Raw = true;
        $this->offsets_benifit_min->Nullable = false; // NOT NULL field
        $this->offsets_benifit_min->Required = true; // Required field
        $this->offsets_benifit_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->offsets_benifit_min->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['offsets_benifit_min'] = &$this->offsets_benifit_min;

        // office_holidays_min
        $this->office_holidays_min = new DbField(
            $this, // Table
            'x_office_holidays_min', // Variable name
            'office_holidays_min', // Name
            '`office_holidays_min`', // Expression
            '`office_holidays_min`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`office_holidays_min`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->office_holidays_min->InputTextType = "text";
        $this->office_holidays_min->Raw = true;
        $this->office_holidays_min->Nullable = false; // NOT NULL field
        $this->office_holidays_min->Required = true; // Required field
        $this->office_holidays_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->office_holidays_min->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['office_holidays_min'] = &$this->office_holidays_min;

        // paid_leave_adj_min
        $this->paid_leave_adj_min = new DbField(
            $this, // Table
            'x_paid_leave_adj_min', // Variable name
            'paid_leave_adj_min', // Name
            '`paid_leave_adj_min`', // Expression
            '`paid_leave_adj_min`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`paid_leave_adj_min`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->paid_leave_adj_min->InputTextType = "text";
        $this->paid_leave_adj_min->Raw = true;
        $this->paid_leave_adj_min->Nullable = false; // NOT NULL field
        $this->paid_leave_adj_min->Required = true; // Required field
        $this->paid_leave_adj_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->paid_leave_adj_min->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['paid_leave_adj_min'] = &$this->paid_leave_adj_min;

        // weekly_off_min
        $this->weekly_off_min = new DbField(
            $this, // Table
            'x_weekly_off_min', // Variable name
            'weekly_off_min', // Name
            '`weekly_off_min`', // Expression
            '`weekly_off_min`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weekly_off_min`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->weekly_off_min->InputTextType = "text";
        $this->weekly_off_min->Nullable = false; // NOT NULL field
        $this->weekly_off_min->Required = true; // Required field
        $this->weekly_off_min->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['weekly_off_min'] = &$this->weekly_off_min;

        // overtime
        $this->overtime = new DbField(
            $this, // Table
            'x_overtime', // Variable name
            'overtime', // Name
            '`overtime`', // Expression
            '`overtime`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`overtime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->overtime->InputTextType = "text";
        $this->overtime->Raw = true;
        $this->overtime->Nullable = false; // NOT NULL field
        $this->overtime->Required = true; // Required field
        $this->overtime->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->overtime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['overtime'] = &$this->overtime;

        // total_min
        $this->total_min = new DbField(
            $this, // Table
            'x_total_min', // Variable name
            'total_min', // Name
            '`total_min`', // Expression
            '`total_min`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`total_min`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->total_min->InputTextType = "text";
        $this->total_min->Raw = true;
        $this->total_min->Nullable = false; // NOT NULL field
        $this->total_min->Required = true; // Required field
        $this->total_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->total_min->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['total_min'] = &$this->total_min;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->Nullable = false; // NOT NULL field
        $this->remarks->Required = true; // Required field
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['remarks'] = &$this->remarks;

        // base_salary
        $this->base_salary = new DbField(
            $this, // Table
            'x_base_salary', // Variable name
            'base_salary', // Name
            '`base_salary`', // Expression
            '`base_salary`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`base_salary`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->base_salary->InputTextType = "text";
        $this->base_salary->Raw = true;
        $this->base_salary->Nullable = false; // NOT NULL field
        $this->base_salary->Required = true; // Required field
        $this->base_salary->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->base_salary->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['base_salary'] = &$this->base_salary;

        // additional_benefits
        $this->additional_benefits = new DbField(
            $this, // Table
            'x_additional_benefits', // Variable name
            'additional_benefits', // Name
            '`additional_benefits`', // Expression
            '`additional_benefits`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`additional_benefits`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->additional_benefits->InputTextType = "text";
        $this->additional_benefits->Nullable = false; // NOT NULL field
        $this->additional_benefits->Required = true; // Required field
        $this->additional_benefits->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['additional_benefits'] = &$this->additional_benefits;

        // employee_pf
        $this->employee_pf = new DbField(
            $this, // Table
            'x_employee_pf', // Variable name
            'employee_pf', // Name
            '`employee_pf`', // Expression
            '`employee_pf`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`employee_pf`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->employee_pf->InputTextType = "text";
        $this->employee_pf->Raw = true;
        $this->employee_pf->Nullable = false; // NOT NULL field
        $this->employee_pf->Required = true; // Required field
        $this->employee_pf->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->employee_pf->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['employee_pf'] = &$this->employee_pf;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getSelectFilter", fn() => "`activated`=1");
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->Nullable = false; // NOT NULL field
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // employee_am_id
        $this->employee_am_id = new DbField(
            $this, // Table
            'x_employee_am_id', // Variable name
            'employee_am_id', // Name
            '`employee_am_id`', // Expression
            '`employee_am_id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`employee_am_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->employee_am_id->InputTextType = "text";
        $this->employee_am_id->Raw = true;
        $this->employee_am_id->Nullable = false; // NOT NULL field
        $this->employee_am_id->Required = true; // Required field
        $this->employee_am_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->employee_am_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['employee_am_id'] = &$this->employee_am_id;

        // salary_earned
        $this->salary_earned = new DbField(
            $this, // Table
            'x_salary_earned', // Variable name
            'salary_earned', // Name
            '`salary_earned`', // Expression
            '`salary_earned`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`salary_earned`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->salary_earned->InputTextType = "text";
        $this->salary_earned->Raw = true;
        $this->salary_earned->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->salary_earned->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['salary_earned'] = &$this->salary_earned;

        // uid
        $this->uid = new DbField(
            $this, // Table
            'x_uid', // Variable name
            'uid', // Name
            '`uid`', // Expression
            '`uid`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->uid->InputTextType = "text";
        $this->uid->Nullable = false; // NOT NULL field
        $this->uid->Required = true; // Required field
        $this->uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['uid'] = &$this->uid;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "payroll_details";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->employee_id->DbValue = $row['employee_id'];
        $this->month->DbValue = $row['month'];
        $this->default_min->DbValue = $row['default_min'];
        $this->month_min->DbValue = $row['month_min'];
        $this->offsets_benifit_min->DbValue = $row['offsets_benifit_min'];
        $this->office_holidays_min->DbValue = $row['office_holidays_min'];
        $this->paid_leave_adj_min->DbValue = $row['paid_leave_adj_min'];
        $this->weekly_off_min->DbValue = $row['weekly_off_min'];
        $this->overtime->DbValue = $row['overtime'];
        $this->total_min->DbValue = $row['total_min'];
        $this->remarks->DbValue = $row['remarks'];
        $this->base_salary->DbValue = $row['base_salary'];
        $this->additional_benefits->DbValue = $row['additional_benefits'];
        $this->employee_pf->DbValue = $row['employee_pf'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->employee_am_id->DbValue = $row['employee_am_id'];
        $this->salary_earned->DbValue = $row['salary_earned'];
        $this->uid->DbValue = $row['uid'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("payrolldetailslist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "payrolldetailsview" => $Language->phrase("View"),
            "payrolldetailsedit" => $Language->phrase("Edit"),
            "payrolldetailsadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "payrolldetailslist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PayrollDetailsView",
            Config("API_ADD_ACTION") => "PayrollDetailsAdd",
            Config("API_EDIT_ACTION") => "PayrollDetailsEdit",
            Config("API_DELETE_ACTION") => "PayrollDetailsDelete",
            Config("API_LIST_ACTION") => "PayrollDetailsList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "payrolldetailslist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("payrolldetailsview", $parm);
        } else {
            $url = $this->keyUrl("payrolldetailsview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "payrolldetailsadd?" . $parm;
        } else {
            $url = "payrolldetailsadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("payrolldetailsedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("payrolldetailslist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("payrolldetailsadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("payrolldetailslist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("payrolldetailsdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->employee_id->setDbValue($row['employee_id']);
        $this->month->setDbValue($row['month']);
        $this->default_min->setDbValue($row['default_min']);
        $this->month_min->setDbValue($row['month_min']);
        $this->offsets_benifit_min->setDbValue($row['offsets_benifit_min']);
        $this->office_holidays_min->setDbValue($row['office_holidays_min']);
        $this->paid_leave_adj_min->setDbValue($row['paid_leave_adj_min']);
        $this->weekly_off_min->setDbValue($row['weekly_off_min']);
        $this->overtime->setDbValue($row['overtime']);
        $this->total_min->setDbValue($row['total_min']);
        $this->remarks->setDbValue($row['remarks']);
        $this->base_salary->setDbValue($row['base_salary']);
        $this->additional_benefits->setDbValue($row['additional_benefits']);
        $this->employee_pf->setDbValue($row['employee_pf']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->employee_am_id->setDbValue($row['employee_am_id']);
        $this->salary_earned->setDbValue($row['salary_earned']);
        $this->uid->setDbValue($row['uid']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PayrollDetailsList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // employee_id

        // month

        // default_min

        // month_min

        // offsets_benifit_min

        // office_holidays_min

        // paid_leave_adj_min

        // weekly_off_min

        // overtime

        // total_min

        // remarks

        // base_salary

        // additional_benefits

        // employee_pf

        // operator

        // datetime

        // employee_am_id

        // salary_earned

        // uid

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // employee_id
        $this->employee_id->ViewValue = $this->employee_id->CurrentValue;
        $curVal = strval($this->employee_id->CurrentValue);
        if ($curVal != "") {
            $this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
            if ($this->employee_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->employee_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->employee_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->employee_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->employee_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->employee_id->Lookup->renderViewRow($rswrk[0]);
                    $this->employee_id->ViewValue = $this->employee_id->displayValue($arwrk);
                } else {
                    $this->employee_id->ViewValue = FormatNumber($this->employee_id->CurrentValue, $this->employee_id->formatPattern());
                }
            }
        } else {
            $this->employee_id->ViewValue = null;
        }

        // month
        $this->month->ViewValue = $this->month->CurrentValue;
        $this->month->ViewValue = FormatNumber($this->month->ViewValue, $this->month->formatPattern());

        // default_min
        $this->default_min->ViewValue = $this->default_min->CurrentValue;
        $this->default_min->ViewValue = FormatNumber($this->default_min->ViewValue, $this->default_min->formatPattern());

        // month_min
        $this->month_min->ViewValue = $this->month_min->CurrentValue;
        $this->month_min->ViewValue = FormatNumber($this->month_min->ViewValue, $this->month_min->formatPattern());

        // offsets_benifit_min
        $this->offsets_benifit_min->ViewValue = $this->offsets_benifit_min->CurrentValue;
        $this->offsets_benifit_min->ViewValue = FormatNumber($this->offsets_benifit_min->ViewValue, $this->offsets_benifit_min->formatPattern());

        // office_holidays_min
        $this->office_holidays_min->ViewValue = $this->office_holidays_min->CurrentValue;
        $this->office_holidays_min->ViewValue = FormatNumber($this->office_holidays_min->ViewValue, $this->office_holidays_min->formatPattern());

        // paid_leave_adj_min
        $this->paid_leave_adj_min->ViewValue = $this->paid_leave_adj_min->CurrentValue;
        $this->paid_leave_adj_min->ViewValue = FormatNumber($this->paid_leave_adj_min->ViewValue, $this->paid_leave_adj_min->formatPattern());

        // weekly_off_min
        $this->weekly_off_min->ViewValue = $this->weekly_off_min->CurrentValue;

        // overtime
        $this->overtime->ViewValue = $this->overtime->CurrentValue;
        $this->overtime->ViewValue = FormatNumber($this->overtime->ViewValue, $this->overtime->formatPattern());

        // total_min
        $this->total_min->ViewValue = $this->total_min->CurrentValue;
        $this->total_min->ViewValue = FormatNumber($this->total_min->ViewValue, $this->total_min->formatPattern());

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // base_salary
        $this->base_salary->ViewValue = $this->base_salary->CurrentValue;
        $this->base_salary->ViewValue = FormatNumber($this->base_salary->ViewValue, $this->base_salary->formatPattern());

        // additional_benefits
        $this->additional_benefits->ViewValue = $this->additional_benefits->CurrentValue;

        // employee_pf
        $this->employee_pf->ViewValue = $this->employee_pf->CurrentValue;
        $this->employee_pf->ViewValue = FormatNumber($this->employee_pf->ViewValue, $this->employee_pf->formatPattern());

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // employee_am_id
        $this->employee_am_id->ViewValue = $this->employee_am_id->CurrentValue;
        $this->employee_am_id->ViewValue = FormatNumber($this->employee_am_id->ViewValue, $this->employee_am_id->formatPattern());

        // salary_earned
        $this->salary_earned->ViewValue = $this->salary_earned->CurrentValue;
        $this->salary_earned->ViewValue = FormatNumber($this->salary_earned->ViewValue, $this->salary_earned->formatPattern());

        // uid
        $this->uid->ViewValue = $this->uid->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // employee_id
        $this->employee_id->HrefValue = "";
        $this->employee_id->TooltipValue = "";

        // month
        $this->month->HrefValue = "";
        $this->month->TooltipValue = "";

        // default_min
        $this->default_min->HrefValue = "";
        $this->default_min->TooltipValue = "";

        // month_min
        $this->month_min->HrefValue = "";
        $this->month_min->TooltipValue = "";

        // offsets_benifit_min
        $this->offsets_benifit_min->HrefValue = "";
        $this->offsets_benifit_min->TooltipValue = "";

        // office_holidays_min
        $this->office_holidays_min->HrefValue = "";
        $this->office_holidays_min->TooltipValue = "";

        // paid_leave_adj_min
        $this->paid_leave_adj_min->HrefValue = "";
        $this->paid_leave_adj_min->TooltipValue = "";

        // weekly_off_min
        $this->weekly_off_min->HrefValue = "";
        $this->weekly_off_min->TooltipValue = "";

        // overtime
        $this->overtime->HrefValue = "";
        $this->overtime->TooltipValue = "";

        // total_min
        $this->total_min->HrefValue = "";
        $this->total_min->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // base_salary
        $this->base_salary->HrefValue = "";
        $this->base_salary->TooltipValue = "";

        // additional_benefits
        $this->additional_benefits->HrefValue = "";
        $this->additional_benefits->TooltipValue = "";

        // employee_pf
        $this->employee_pf->HrefValue = "";
        $this->employee_pf->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // employee_am_id
        $this->employee_am_id->HrefValue = "";
        $this->employee_am_id->TooltipValue = "";

        // salary_earned
        $this->salary_earned->HrefValue = "";
        $this->salary_earned->TooltipValue = "";

        // uid
        $this->uid->HrefValue = "";
        $this->uid->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

        // employee_id
        $this->employee_id->setupEditAttributes();
        $this->employee_id->EditValue = $this->employee_id->CurrentValue;
        $this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

        // month
        $this->month->setupEditAttributes();
        $this->month->EditValue = $this->month->CurrentValue;
        $this->month->PlaceHolder = RemoveHtml($this->month->caption());
        if (strval($this->month->EditValue) != "" && is_numeric($this->month->EditValue)) {
            $this->month->EditValue = FormatNumber($this->month->EditValue, null);
        }

        // default_min
        $this->default_min->setupEditAttributes();
        $this->default_min->EditValue = $this->default_min->CurrentValue;
        $this->default_min->PlaceHolder = RemoveHtml($this->default_min->caption());
        if (strval($this->default_min->EditValue) != "" && is_numeric($this->default_min->EditValue)) {
            $this->default_min->EditValue = FormatNumber($this->default_min->EditValue, null);
        }

        // month_min
        $this->month_min->setupEditAttributes();
        $this->month_min->EditValue = $this->month_min->CurrentValue;
        $this->month_min->PlaceHolder = RemoveHtml($this->month_min->caption());
        if (strval($this->month_min->EditValue) != "" && is_numeric($this->month_min->EditValue)) {
            $this->month_min->EditValue = FormatNumber($this->month_min->EditValue, null);
        }

        // offsets_benifit_min
        $this->offsets_benifit_min->setupEditAttributes();
        $this->offsets_benifit_min->EditValue = $this->offsets_benifit_min->CurrentValue;
        $this->offsets_benifit_min->PlaceHolder = RemoveHtml($this->offsets_benifit_min->caption());
        if (strval($this->offsets_benifit_min->EditValue) != "" && is_numeric($this->offsets_benifit_min->EditValue)) {
            $this->offsets_benifit_min->EditValue = FormatNumber($this->offsets_benifit_min->EditValue, null);
        }

        // office_holidays_min
        $this->office_holidays_min->setupEditAttributes();
        $this->office_holidays_min->EditValue = $this->office_holidays_min->CurrentValue;
        $this->office_holidays_min->PlaceHolder = RemoveHtml($this->office_holidays_min->caption());
        if (strval($this->office_holidays_min->EditValue) != "" && is_numeric($this->office_holidays_min->EditValue)) {
            $this->office_holidays_min->EditValue = FormatNumber($this->office_holidays_min->EditValue, null);
        }

        // paid_leave_adj_min
        $this->paid_leave_adj_min->setupEditAttributes();
        $this->paid_leave_adj_min->EditValue = $this->paid_leave_adj_min->CurrentValue;
        $this->paid_leave_adj_min->PlaceHolder = RemoveHtml($this->paid_leave_adj_min->caption());
        if (strval($this->paid_leave_adj_min->EditValue) != "" && is_numeric($this->paid_leave_adj_min->EditValue)) {
            $this->paid_leave_adj_min->EditValue = FormatNumber($this->paid_leave_adj_min->EditValue, null);
        }

        // weekly_off_min
        $this->weekly_off_min->setupEditAttributes();
        if (!$this->weekly_off_min->Raw) {
            $this->weekly_off_min->CurrentValue = HtmlDecode($this->weekly_off_min->CurrentValue);
        }
        $this->weekly_off_min->EditValue = $this->weekly_off_min->CurrentValue;
        $this->weekly_off_min->PlaceHolder = RemoveHtml($this->weekly_off_min->caption());

        // overtime
        $this->overtime->setupEditAttributes();
        $this->overtime->EditValue = $this->overtime->CurrentValue;
        $this->overtime->PlaceHolder = RemoveHtml($this->overtime->caption());
        if (strval($this->overtime->EditValue) != "" && is_numeric($this->overtime->EditValue)) {
            $this->overtime->EditValue = FormatNumber($this->overtime->EditValue, null);
        }

        // total_min
        $this->total_min->setupEditAttributes();
        $this->total_min->EditValue = $this->total_min->CurrentValue;
        $this->total_min->PlaceHolder = RemoveHtml($this->total_min->caption());
        if (strval($this->total_min->EditValue) != "" && is_numeric($this->total_min->EditValue)) {
            $this->total_min->EditValue = FormatNumber($this->total_min->EditValue, null);
        }

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // base_salary
        $this->base_salary->setupEditAttributes();
        $this->base_salary->EditValue = $this->base_salary->CurrentValue;
        $this->base_salary->PlaceHolder = RemoveHtml($this->base_salary->caption());
        if (strval($this->base_salary->EditValue) != "" && is_numeric($this->base_salary->EditValue)) {
            $this->base_salary->EditValue = FormatNumber($this->base_salary->EditValue, null);
        }

        // additional_benefits
        $this->additional_benefits->setupEditAttributes();
        if (!$this->additional_benefits->Raw) {
            $this->additional_benefits->CurrentValue = HtmlDecode($this->additional_benefits->CurrentValue);
        }
        $this->additional_benefits->EditValue = $this->additional_benefits->CurrentValue;
        $this->additional_benefits->PlaceHolder = RemoveHtml($this->additional_benefits->caption());

        // employee_pf
        $this->employee_pf->setupEditAttributes();
        $this->employee_pf->EditValue = $this->employee_pf->CurrentValue;
        $this->employee_pf->PlaceHolder = RemoveHtml($this->employee_pf->caption());
        if (strval($this->employee_pf->EditValue) != "" && is_numeric($this->employee_pf->EditValue)) {
            $this->employee_pf->EditValue = FormatNumber($this->employee_pf->EditValue, null);
        }

        // operator

        // datetime

        // employee_am_id
        $this->employee_am_id->setupEditAttributes();
        $this->employee_am_id->EditValue = $this->employee_am_id->CurrentValue;
        $this->employee_am_id->PlaceHolder = RemoveHtml($this->employee_am_id->caption());
        if (strval($this->employee_am_id->EditValue) != "" && is_numeric($this->employee_am_id->EditValue)) {
            $this->employee_am_id->EditValue = FormatNumber($this->employee_am_id->EditValue, null);
        }

        // salary_earned
        $this->salary_earned->setupEditAttributes();
        $this->salary_earned->EditValue = $this->salary_earned->CurrentValue;
        $this->salary_earned->PlaceHolder = RemoveHtml($this->salary_earned->caption());
        if (strval($this->salary_earned->EditValue) != "" && is_numeric($this->salary_earned->EditValue)) {
            $this->salary_earned->EditValue = FormatNumber($this->salary_earned->EditValue, null);
        }

        // uid
        $this->uid->setupEditAttributes();
        if (!$this->uid->Raw) {
            $this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
        }
        $this->uid->EditValue = $this->uid->CurrentValue;
        $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->employee_id);
                    $doc->exportCaption($this->month);
                    $doc->exportCaption($this->default_min);
                    $doc->exportCaption($this->month_min);
                    $doc->exportCaption($this->offsets_benifit_min);
                    $doc->exportCaption($this->office_holidays_min);
                    $doc->exportCaption($this->paid_leave_adj_min);
                    $doc->exportCaption($this->weekly_off_min);
                    $doc->exportCaption($this->overtime);
                    $doc->exportCaption($this->total_min);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->base_salary);
                    $doc->exportCaption($this->additional_benefits);
                    $doc->exportCaption($this->employee_pf);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->employee_am_id);
                    $doc->exportCaption($this->salary_earned);
                    $doc->exportCaption($this->uid);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->employee_id);
                    $doc->exportCaption($this->month);
                    $doc->exportCaption($this->default_min);
                    $doc->exportCaption($this->month_min);
                    $doc->exportCaption($this->offsets_benifit_min);
                    $doc->exportCaption($this->office_holidays_min);
                    $doc->exportCaption($this->paid_leave_adj_min);
                    $doc->exportCaption($this->weekly_off_min);
                    $doc->exportCaption($this->overtime);
                    $doc->exportCaption($this->total_min);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->base_salary);
                    $doc->exportCaption($this->additional_benefits);
                    $doc->exportCaption($this->employee_pf);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->employee_am_id);
                    $doc->exportCaption($this->salary_earned);
                    $doc->exportCaption($this->uid);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->employee_id);
                        $doc->exportField($this->month);
                        $doc->exportField($this->default_min);
                        $doc->exportField($this->month_min);
                        $doc->exportField($this->offsets_benifit_min);
                        $doc->exportField($this->office_holidays_min);
                        $doc->exportField($this->paid_leave_adj_min);
                        $doc->exportField($this->weekly_off_min);
                        $doc->exportField($this->overtime);
                        $doc->exportField($this->total_min);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->base_salary);
                        $doc->exportField($this->additional_benefits);
                        $doc->exportField($this->employee_pf);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->employee_am_id);
                        $doc->exportField($this->salary_earned);
                        $doc->exportField($this->uid);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->employee_id);
                        $doc->exportField($this->month);
                        $doc->exportField($this->default_min);
                        $doc->exportField($this->month_min);
                        $doc->exportField($this->offsets_benifit_min);
                        $doc->exportField($this->office_holidays_min);
                        $doc->exportField($this->paid_leave_adj_min);
                        $doc->exportField($this->weekly_off_min);
                        $doc->exportField($this->overtime);
                        $doc->exportField($this->total_min);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->base_salary);
                        $doc->exportField($this->additional_benefits);
                        $doc->exportField($this->employee_pf);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->employee_am_id);
                        $doc->exportField($this->salary_earned);
                        $doc->exportField($this->uid);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
