<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PaymentResponseSearch extends PaymentResponse
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PaymentResponseSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "paymentresponsesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->type->setVisibility();
        $this->status->setVisibility();
        $this->_userid->setVisibility();
        $this->pg_order_number->setVisibility();
        $this->remarks->setVisibility();
        $this->cart_number->setVisibility();
        $this->order_id->setVisibility();
        $this->tracking_id->setVisibility();
        $this->bank_ref_no->setVisibility();
        $this->order_status->setVisibility();
        $this->failure_message->setVisibility();
        $this->payment_mode->setVisibility();
        $this->card_name->setVisibility();
        $this->status_code->setVisibility();
        $this->status_message->setVisibility();
        $this->amount->setVisibility();
        $this->trans_date->setVisibility();
        $this->datetime->setVisibility();
        $this->payment_gateway->setVisibility();
        $this->payment_signature->setVisibility();
        $this->currency_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'payment_response';
        $this->TableName = 'payment_response';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (payment_response)
        if (!isset($GLOBALS["payment_response"]) || $GLOBALS["payment_response"]::class == PROJECT_NAMESPACE . "payment_response") {
            $GLOBALS["payment_response"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'payment_response');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "paymentresponseview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->_userid);
        $this->setupLookupOptions($this->currency_id);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "paymentresponselist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->type); // type
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->_userid); // userid
        $this->buildSearchUrl($srchUrl, $this->pg_order_number); // pg_order_number
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->cart_number); // cart_number
        $this->buildSearchUrl($srchUrl, $this->order_id); // order_id
        $this->buildSearchUrl($srchUrl, $this->tracking_id); // tracking_id
        $this->buildSearchUrl($srchUrl, $this->bank_ref_no); // bank_ref_no
        $this->buildSearchUrl($srchUrl, $this->order_status); // order_status
        $this->buildSearchUrl($srchUrl, $this->failure_message); // failure_message
        $this->buildSearchUrl($srchUrl, $this->payment_mode); // payment_mode
        $this->buildSearchUrl($srchUrl, $this->card_name); // card_name
        $this->buildSearchUrl($srchUrl, $this->status_code); // status_code
        $this->buildSearchUrl($srchUrl, $this->status_message); // status_message
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->trans_date); // trans_date
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->payment_gateway); // payment_gateway
        $this->buildSearchUrl($srchUrl, $this->payment_signature); // payment_signature
        $this->buildSearchUrl($srchUrl, $this->currency_id); // currency_id
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // type
        if ($this->type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // userid
        if ($this->_userid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pg_order_number
        if ($this->pg_order_number->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cart_number
        if ($this->cart_number->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_id
        if ($this->order_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // tracking_id
        if ($this->tracking_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_ref_no
        if ($this->bank_ref_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_status
        if ($this->order_status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // failure_message
        if ($this->failure_message->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_mode
        if ($this->payment_mode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // card_name
        if ($this->card_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status_code
        if ($this->status_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status_message
        if ($this->status_message->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // trans_date
        if ($this->trans_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_gateway
        if ($this->payment_gateway->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment_signature
        if ($this->payment_signature->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // currency_id
        if ($this->currency_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // userid
        $this->_userid->RowCssClass = "row";

        // pg_order_number
        $this->pg_order_number->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // cart_number
        $this->cart_number->RowCssClass = "row";

        // order_id
        $this->order_id->RowCssClass = "row";

        // tracking_id
        $this->tracking_id->RowCssClass = "row";

        // bank_ref_no
        $this->bank_ref_no->RowCssClass = "row";

        // order_status
        $this->order_status->RowCssClass = "row";

        // failure_message
        $this->failure_message->RowCssClass = "row";

        // payment_mode
        $this->payment_mode->RowCssClass = "row";

        // card_name
        $this->card_name->RowCssClass = "row";

        // status_code
        $this->status_code->RowCssClass = "row";

        // status_message
        $this->status_message->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // trans_date
        $this->trans_date->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // payment_gateway
        $this->payment_gateway->RowCssClass = "row";

        // payment_signature
        $this->payment_signature->RowCssClass = "row";

        // currency_id
        $this->currency_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // type
            $this->type->ViewValue = $this->type->CurrentValue;
            $this->type->ViewValue = FormatNumber($this->type->ViewValue, $this->type->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // userid
            $this->_userid->ViewValue = $this->_userid->CurrentValue;
            $curVal = strval($this->_userid->CurrentValue);
            if ($curVal != "") {
                $this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
                if ($this->_userid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_userid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_userid->Lookup->renderViewRow($rswrk[0]);
                        $this->_userid->ViewValue = $this->_userid->displayValue($arwrk);
                    } else {
                        $this->_userid->ViewValue = FormatNumber($this->_userid->CurrentValue, $this->_userid->formatPattern());
                    }
                }
            } else {
                $this->_userid->ViewValue = null;
            }

            // pg_order_number
            $this->pg_order_number->ViewValue = $this->pg_order_number->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // cart_number
            $this->cart_number->ViewValue = $this->cart_number->CurrentValue;
            $this->cart_number->ViewValue = FormatNumber($this->cart_number->ViewValue, $this->cart_number->formatPattern());

            // order_id
            $this->order_id->ViewValue = $this->order_id->CurrentValue;
            $this->order_id->ViewValue = FormatNumber($this->order_id->ViewValue, $this->order_id->formatPattern());

            // tracking_id
            $this->tracking_id->ViewValue = $this->tracking_id->CurrentValue;

            // bank_ref_no
            $this->bank_ref_no->ViewValue = $this->bank_ref_no->CurrentValue;

            // order_status
            $this->order_status->ViewValue = $this->order_status->CurrentValue;

            // failure_message
            $this->failure_message->ViewValue = $this->failure_message->CurrentValue;

            // payment_mode
            $this->payment_mode->ViewValue = $this->payment_mode->CurrentValue;

            // card_name
            $this->card_name->ViewValue = $this->card_name->CurrentValue;

            // status_code
            $this->status_code->ViewValue = $this->status_code->CurrentValue;

            // status_message
            $this->status_message->ViewValue = $this->status_message->CurrentValue;

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // trans_date
            $this->trans_date->ViewValue = $this->trans_date->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // payment_gateway
            $this->payment_gateway->ViewValue = $this->payment_gateway->CurrentValue;

            // payment_signature
            $this->payment_signature->ViewValue = $this->payment_signature->CurrentValue;

            // currency_id
            $curVal = strval($this->currency_id->CurrentValue);
            if ($curVal != "") {
                $this->currency_id->ViewValue = $this->currency_id->lookupCacheOption($curVal);
                if ($this->currency_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency_id->Lookup->renderViewRow($rswrk[0]);
                        $this->currency_id->ViewValue = $this->currency_id->displayValue($arwrk);
                    } else {
                        $this->currency_id->ViewValue = FormatNumber($this->currency_id->CurrentValue, $this->currency_id->formatPattern());
                    }
                }
            } else {
                $this->currency_id->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // type
            if (!EmptyValue($this->type->CurrentValue)) {
                $this->type->HrefValue = $this->type->getLinkPrefix() . (!empty($this->type->ViewValue) && !is_array($this->type->ViewValue) ? RemoveHtml($this->type->ViewValue) : $this->type->CurrentValue); // Add prefix/suffix
                $this->type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
                }
            } else {
                $this->type->HrefValue = "";
            }
            $this->type->TooltipValue = "";

            // status
            if (!EmptyValue($this->status->CurrentValue)) {
                $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
                $this->status->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
                }
            } else {
                $this->status->HrefValue = "";
            }
            $this->status->TooltipValue = "";

            // userid
            if (!EmptyValue($this->_userid->CurrentValue)) {
                $this->_userid->HrefValue = $this->_userid->getLinkPrefix() . $this->_userid->CurrentValue; // Add prefix/suffix
                $this->_userid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_userid->HrefValue = FullUrl($this->_userid->HrefValue, "href");
                }
            } else {
                $this->_userid->HrefValue = "";
            }
            $this->_userid->TooltipValue = "";

            // pg_order_number
            $this->pg_order_number->HrefValue = "";
            $this->pg_order_number->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // cart_number
            $this->cart_number->HrefValue = "";
            $this->cart_number->TooltipValue = "";

            // order_id
            $this->order_id->HrefValue = "";
            $this->order_id->TooltipValue = "";

            // tracking_id
            $this->tracking_id->HrefValue = "";
            $this->tracking_id->TooltipValue = "";

            // bank_ref_no
            $this->bank_ref_no->HrefValue = "";
            $this->bank_ref_no->TooltipValue = "";

            // order_status
            $this->order_status->HrefValue = "";
            $this->order_status->TooltipValue = "";

            // failure_message
            $this->failure_message->HrefValue = "";
            $this->failure_message->TooltipValue = "";

            // payment_mode
            $this->payment_mode->HrefValue = "";
            $this->payment_mode->TooltipValue = "";

            // card_name
            $this->card_name->HrefValue = "";
            $this->card_name->TooltipValue = "";

            // status_code
            $this->status_code->HrefValue = "";
            $this->status_code->TooltipValue = "";

            // status_message
            $this->status_message->HrefValue = "";
            $this->status_message->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // trans_date
            $this->trans_date->HrefValue = "";
            $this->trans_date->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // payment_gateway
            $this->payment_gateway->HrefValue = "";
            $this->payment_gateway->TooltipValue = "";

            // payment_signature
            $this->payment_signature->HrefValue = "";
            $this->payment_signature->TooltipValue = "";

            // currency_id
            $this->currency_id->HrefValue = "";
            $this->currency_id->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // type
            $this->type->setupEditAttributes();
            $this->type->EditValue = $this->type->AdvancedSearch->SearchValue;
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // userid
            $this->_userid->setupEditAttributes();
            $this->_userid->EditValue = $this->_userid->AdvancedSearch->SearchValue;
            $curVal = strval($this->_userid->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->_userid->EditValue = $this->_userid->lookupCacheOption($curVal);
                if ($this->_userid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_userid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_userid->Lookup->renderViewRow($rswrk[0]);
                        $this->_userid->EditValue = $this->_userid->displayValue($arwrk);
                    } else {
                        $this->_userid->EditValue = HtmlEncode(FormatNumber($this->_userid->AdvancedSearch->SearchValue, $this->_userid->formatPattern()));
                    }
                }
            } else {
                $this->_userid->EditValue = null;
            }
            $this->_userid->PlaceHolder = RemoveHtml($this->_userid->caption());
            $this->_userid->setupEditAttributes();
            $this->_userid->EditValue2 = $this->_userid->AdvancedSearch->SearchValue2;
            $curVal = strval($this->_userid->AdvancedSearch->SearchValue2);
            if ($curVal != "") {
                $this->_userid->EditValue2 = $this->_userid->lookupCacheOption($curVal);
                if ($this->_userid->EditValue2 === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_userid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_userid->Lookup->renderViewRow($rswrk[0]);
                        $this->_userid->EditValue2 = $this->_userid->displayValue($arwrk);
                    } else {
                        $this->_userid->EditValue2 = HtmlEncode(FormatNumber($this->_userid->AdvancedSearch->SearchValue2, $this->_userid->formatPattern()));
                    }
                }
            } else {
                $this->_userid->EditValue2 = null;
            }
            $this->_userid->PlaceHolder = RemoveHtml($this->_userid->caption());

            // pg_order_number
            $this->pg_order_number->setupEditAttributes();
            if (!$this->pg_order_number->Raw) {
                $this->pg_order_number->AdvancedSearch->SearchValue = HtmlDecode($this->pg_order_number->AdvancedSearch->SearchValue);
            }
            $this->pg_order_number->EditValue = HtmlEncode($this->pg_order_number->AdvancedSearch->SearchValue);
            $this->pg_order_number->PlaceHolder = RemoveHtml($this->pg_order_number->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // cart_number
            $this->cart_number->setupEditAttributes();
            $this->cart_number->EditValue = $this->cart_number->AdvancedSearch->SearchValue;
            $this->cart_number->PlaceHolder = RemoveHtml($this->cart_number->caption());

            // order_id
            $this->order_id->setupEditAttributes();
            $this->order_id->EditValue = $this->order_id->AdvancedSearch->SearchValue;
            $this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());

            // tracking_id
            $this->tracking_id->setupEditAttributes();
            if (!$this->tracking_id->Raw) {
                $this->tracking_id->AdvancedSearch->SearchValue = HtmlDecode($this->tracking_id->AdvancedSearch->SearchValue);
            }
            $this->tracking_id->EditValue = HtmlEncode($this->tracking_id->AdvancedSearch->SearchValue);
            $this->tracking_id->PlaceHolder = RemoveHtml($this->tracking_id->caption());

            // bank_ref_no
            $this->bank_ref_no->setupEditAttributes();
            if (!$this->bank_ref_no->Raw) {
                $this->bank_ref_no->AdvancedSearch->SearchValue = HtmlDecode($this->bank_ref_no->AdvancedSearch->SearchValue);
            }
            $this->bank_ref_no->EditValue = HtmlEncode($this->bank_ref_no->AdvancedSearch->SearchValue);
            $this->bank_ref_no->PlaceHolder = RemoveHtml($this->bank_ref_no->caption());

            // order_status
            $this->order_status->setupEditAttributes();
            if (!$this->order_status->Raw) {
                $this->order_status->AdvancedSearch->SearchValue = HtmlDecode($this->order_status->AdvancedSearch->SearchValue);
            }
            $this->order_status->EditValue = HtmlEncode($this->order_status->AdvancedSearch->SearchValue);
            $this->order_status->PlaceHolder = RemoveHtml($this->order_status->caption());

            // failure_message
            $this->failure_message->setupEditAttributes();
            if (!$this->failure_message->Raw) {
                $this->failure_message->AdvancedSearch->SearchValue = HtmlDecode($this->failure_message->AdvancedSearch->SearchValue);
            }
            $this->failure_message->EditValue = HtmlEncode($this->failure_message->AdvancedSearch->SearchValue);
            $this->failure_message->PlaceHolder = RemoveHtml($this->failure_message->caption());

            // payment_mode
            $this->payment_mode->setupEditAttributes();
            if (!$this->payment_mode->Raw) {
                $this->payment_mode->AdvancedSearch->SearchValue = HtmlDecode($this->payment_mode->AdvancedSearch->SearchValue);
            }
            $this->payment_mode->EditValue = HtmlEncode($this->payment_mode->AdvancedSearch->SearchValue);
            $this->payment_mode->PlaceHolder = RemoveHtml($this->payment_mode->caption());

            // card_name
            $this->card_name->setupEditAttributes();
            if (!$this->card_name->Raw) {
                $this->card_name->AdvancedSearch->SearchValue = HtmlDecode($this->card_name->AdvancedSearch->SearchValue);
            }
            $this->card_name->EditValue = HtmlEncode($this->card_name->AdvancedSearch->SearchValue);
            $this->card_name->PlaceHolder = RemoveHtml($this->card_name->caption());

            // status_code
            $this->status_code->setupEditAttributes();
            if (!$this->status_code->Raw) {
                $this->status_code->AdvancedSearch->SearchValue = HtmlDecode($this->status_code->AdvancedSearch->SearchValue);
            }
            $this->status_code->EditValue = HtmlEncode($this->status_code->AdvancedSearch->SearchValue);
            $this->status_code->PlaceHolder = RemoveHtml($this->status_code->caption());

            // status_message
            $this->status_message->setupEditAttributes();
            if (!$this->status_message->Raw) {
                $this->status_message->AdvancedSearch->SearchValue = HtmlDecode($this->status_message->AdvancedSearch->SearchValue);
            }
            $this->status_message->EditValue = HtmlEncode($this->status_message->AdvancedSearch->SearchValue);
            $this->status_message->PlaceHolder = RemoveHtml($this->status_message->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // trans_date
            $this->trans_date->setupEditAttributes();
            if (!$this->trans_date->Raw) {
                $this->trans_date->AdvancedSearch->SearchValue = HtmlDecode($this->trans_date->AdvancedSearch->SearchValue);
            }
            $this->trans_date->EditValue = HtmlEncode($this->trans_date->AdvancedSearch->SearchValue);
            $this->trans_date->PlaceHolder = RemoveHtml($this->trans_date->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // payment_gateway
            $this->payment_gateway->setupEditAttributes();
            if (!$this->payment_gateway->Raw) {
                $this->payment_gateway->AdvancedSearch->SearchValue = HtmlDecode($this->payment_gateway->AdvancedSearch->SearchValue);
            }
            $this->payment_gateway->EditValue = HtmlEncode($this->payment_gateway->AdvancedSearch->SearchValue);
            $this->payment_gateway->PlaceHolder = RemoveHtml($this->payment_gateway->caption());

            // payment_signature
            $this->payment_signature->setupEditAttributes();
            if (!$this->payment_signature->Raw) {
                $this->payment_signature->AdvancedSearch->SearchValue = HtmlDecode($this->payment_signature->AdvancedSearch->SearchValue);
            }
            $this->payment_signature->EditValue = HtmlEncode($this->payment_signature->AdvancedSearch->SearchValue);
            $this->payment_signature->PlaceHolder = RemoveHtml($this->payment_signature->caption());

            // currency_id
            $this->currency_id->setupEditAttributes();
            $curVal = trim(strval($this->currency_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->currency_id->AdvancedSearch->ViewValue = $this->currency_id->lookupCacheOption($curVal);
            } else {
                $this->currency_id->AdvancedSearch->ViewValue = $this->currency_id->Lookup !== null && is_array($this->currency_id->lookupOptions()) && count($this->currency_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->currency_id->EditValue = array_values($this->currency_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency_id->AdvancedSearch->SearchValue, $this->currency_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency_id->EditValue = $arwrk;
            }
            $this->currency_id->PlaceHolder = RemoveHtml($this->currency_id->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->type->AdvancedSearch->SearchValue)) {
            $this->type->addErrorMessage($this->type->getErrorMessage(false));
        }
        if (!CheckInteger($this->_userid->AdvancedSearch->SearchValue)) {
            $this->_userid->addErrorMessage($this->_userid->getErrorMessage(false));
        }
        if (!CheckInteger($this->_userid->AdvancedSearch->SearchValue2)) {
            $this->_userid->addErrorMessage($this->_userid->getErrorMessage(false));
        }
        if (!CheckInteger($this->cart_number->AdvancedSearch->SearchValue)) {
            $this->cart_number->addErrorMessage($this->cart_number->getErrorMessage(false));
        }
        if (!CheckInteger($this->order_id->AdvancedSearch->SearchValue)) {
            $this->order_id->addErrorMessage($this->order_id->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->type->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->_userid->AdvancedSearch->load();
        $this->pg_order_number->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->cart_number->AdvancedSearch->load();
        $this->order_id->AdvancedSearch->load();
        $this->tracking_id->AdvancedSearch->load();
        $this->bank_ref_no->AdvancedSearch->load();
        $this->order_status->AdvancedSearch->load();
        $this->failure_message->AdvancedSearch->load();
        $this->payment_mode->AdvancedSearch->load();
        $this->card_name->AdvancedSearch->load();
        $this->status_code->AdvancedSearch->load();
        $this->status_message->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->trans_date->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->payment_gateway->AdvancedSearch->load();
        $this->payment_signature->AdvancedSearch->load();
        $this->currency_id->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("paymentresponselist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_status":
                    break;
                case "x__userid":
                    break;
                case "x_currency_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
