<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PaymentResponseEdit extends PaymentResponse
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PaymentResponseEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "paymentresponseedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->type->setVisibility();
        $this->status->setVisibility();
        $this->_userid->setVisibility();
        $this->pg_order_number->setVisibility();
        $this->remarks->setVisibility();
        $this->cart_number->setVisibility();
        $this->order_id->setVisibility();
        $this->tracking_id->setVisibility();
        $this->bank_ref_no->setVisibility();
        $this->order_status->setVisibility();
        $this->failure_message->setVisibility();
        $this->payment_mode->setVisibility();
        $this->card_name->setVisibility();
        $this->status_code->setVisibility();
        $this->status_message->setVisibility();
        $this->amount->setVisibility();
        $this->trans_date->setVisibility();
        $this->datetime->setVisibility();
        $this->payment_gateway->setVisibility();
        $this->payment_signature->setVisibility();
        $this->currency_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'payment_response';
        $this->TableName = 'payment_response';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (payment_response)
        if (!isset($GLOBALS["payment_response"]) || $GLOBALS["payment_response"]::class == PROJECT_NAMESPACE . "payment_response") {
            $GLOBALS["payment_response"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'payment_response');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "paymentresponseview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->_userid);
        $this->setupLookupOptions($this->currency_id);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("paymentresponselist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "paymentresponselist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "paymentresponselist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "paymentresponselist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'userid' first before field var 'x__userid'
        $val = $CurrentForm->hasValue("userid") ? $CurrentForm->getValue("userid") : $CurrentForm->getValue("x__userid");
        if (!$this->_userid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_userid->Visible = false; // Disable update for API request
            } else {
                $this->_userid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pg_order_number' first before field var 'x_pg_order_number'
        $val = $CurrentForm->hasValue("pg_order_number") ? $CurrentForm->getValue("pg_order_number") : $CurrentForm->getValue("x_pg_order_number");
        if (!$this->pg_order_number->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pg_order_number->Visible = false; // Disable update for API request
            } else {
                $this->pg_order_number->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'cart_number' first before field var 'x_cart_number'
        $val = $CurrentForm->hasValue("cart_number") ? $CurrentForm->getValue("cart_number") : $CurrentForm->getValue("x_cart_number");
        if (!$this->cart_number->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cart_number->Visible = false; // Disable update for API request
            } else {
                $this->cart_number->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'order_id' first before field var 'x_order_id'
        $val = $CurrentForm->hasValue("order_id") ? $CurrentForm->getValue("order_id") : $CurrentForm->getValue("x_order_id");
        if (!$this->order_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_id->Visible = false; // Disable update for API request
            } else {
                $this->order_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'tracking_id' first before field var 'x_tracking_id'
        $val = $CurrentForm->hasValue("tracking_id") ? $CurrentForm->getValue("tracking_id") : $CurrentForm->getValue("x_tracking_id");
        if (!$this->tracking_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tracking_id->Visible = false; // Disable update for API request
            } else {
                $this->tracking_id->setFormValue($val);
            }
        }

        // Check field name 'bank_ref_no' first before field var 'x_bank_ref_no'
        $val = $CurrentForm->hasValue("bank_ref_no") ? $CurrentForm->getValue("bank_ref_no") : $CurrentForm->getValue("x_bank_ref_no");
        if (!$this->bank_ref_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_ref_no->Visible = false; // Disable update for API request
            } else {
                $this->bank_ref_no->setFormValue($val);
            }
        }

        // Check field name 'order_status' first before field var 'x_order_status'
        $val = $CurrentForm->hasValue("order_status") ? $CurrentForm->getValue("order_status") : $CurrentForm->getValue("x_order_status");
        if (!$this->order_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_status->Visible = false; // Disable update for API request
            } else {
                $this->order_status->setFormValue($val);
            }
        }

        // Check field name 'failure_message' first before field var 'x_failure_message'
        $val = $CurrentForm->hasValue("failure_message") ? $CurrentForm->getValue("failure_message") : $CurrentForm->getValue("x_failure_message");
        if (!$this->failure_message->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->failure_message->Visible = false; // Disable update for API request
            } else {
                $this->failure_message->setFormValue($val);
            }
        }

        // Check field name 'payment_mode' first before field var 'x_payment_mode'
        $val = $CurrentForm->hasValue("payment_mode") ? $CurrentForm->getValue("payment_mode") : $CurrentForm->getValue("x_payment_mode");
        if (!$this->payment_mode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_mode->Visible = false; // Disable update for API request
            } else {
                $this->payment_mode->setFormValue($val);
            }
        }

        // Check field name 'card_name' first before field var 'x_card_name'
        $val = $CurrentForm->hasValue("card_name") ? $CurrentForm->getValue("card_name") : $CurrentForm->getValue("x_card_name");
        if (!$this->card_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->card_name->Visible = false; // Disable update for API request
            } else {
                $this->card_name->setFormValue($val);
            }
        }

        // Check field name 'status_code' first before field var 'x_status_code'
        $val = $CurrentForm->hasValue("status_code") ? $CurrentForm->getValue("status_code") : $CurrentForm->getValue("x_status_code");
        if (!$this->status_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status_code->Visible = false; // Disable update for API request
            } else {
                $this->status_code->setFormValue($val);
            }
        }

        // Check field name 'status_message' first before field var 'x_status_message'
        $val = $CurrentForm->hasValue("status_message") ? $CurrentForm->getValue("status_message") : $CurrentForm->getValue("x_status_message");
        if (!$this->status_message->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status_message->Visible = false; // Disable update for API request
            } else {
                $this->status_message->setFormValue($val);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'trans_date' first before field var 'x_trans_date'
        $val = $CurrentForm->hasValue("trans_date") ? $CurrentForm->getValue("trans_date") : $CurrentForm->getValue("x_trans_date");
        if (!$this->trans_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->trans_date->Visible = false; // Disable update for API request
            } else {
                $this->trans_date->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'payment_gateway' first before field var 'x_payment_gateway'
        $val = $CurrentForm->hasValue("payment_gateway") ? $CurrentForm->getValue("payment_gateway") : $CurrentForm->getValue("x_payment_gateway");
        if (!$this->payment_gateway->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_gateway->Visible = false; // Disable update for API request
            } else {
                $this->payment_gateway->setFormValue($val);
            }
        }

        // Check field name 'payment_signature' first before field var 'x_payment_signature'
        $val = $CurrentForm->hasValue("payment_signature") ? $CurrentForm->getValue("payment_signature") : $CurrentForm->getValue("x_payment_signature");
        if (!$this->payment_signature->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_signature->Visible = false; // Disable update for API request
            } else {
                $this->payment_signature->setFormValue($val);
            }
        }

        // Check field name 'currency_id' first before field var 'x_currency_id'
        $val = $CurrentForm->hasValue("currency_id") ? $CurrentForm->getValue("currency_id") : $CurrentForm->getValue("x_currency_id");
        if (!$this->currency_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency_id->Visible = false; // Disable update for API request
            } else {
                $this->currency_id->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->type->CurrentValue = $this->type->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->_userid->CurrentValue = $this->_userid->FormValue;
        $this->pg_order_number->CurrentValue = $this->pg_order_number->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->cart_number->CurrentValue = $this->cart_number->FormValue;
        $this->order_id->CurrentValue = $this->order_id->FormValue;
        $this->tracking_id->CurrentValue = $this->tracking_id->FormValue;
        $this->bank_ref_no->CurrentValue = $this->bank_ref_no->FormValue;
        $this->order_status->CurrentValue = $this->order_status->FormValue;
        $this->failure_message->CurrentValue = $this->failure_message->FormValue;
        $this->payment_mode->CurrentValue = $this->payment_mode->FormValue;
        $this->card_name->CurrentValue = $this->card_name->FormValue;
        $this->status_code->CurrentValue = $this->status_code->FormValue;
        $this->status_message->CurrentValue = $this->status_message->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->trans_date->CurrentValue = $this->trans_date->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->payment_gateway->CurrentValue = $this->payment_gateway->FormValue;
        $this->payment_signature->CurrentValue = $this->payment_signature->FormValue;
        $this->currency_id->CurrentValue = $this->currency_id->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->type->setDbValue($row['type']);
        $this->status->setDbValue($row['status']);
        $this->_userid->setDbValue($row['userid']);
        $this->pg_order_number->setDbValue($row['pg_order_number']);
        $this->remarks->setDbValue($row['remarks']);
        $this->cart_number->setDbValue($row['cart_number']);
        $this->order_id->setDbValue($row['order_id']);
        $this->tracking_id->setDbValue($row['tracking_id']);
        $this->bank_ref_no->setDbValue($row['bank_ref_no']);
        $this->order_status->setDbValue($row['order_status']);
        $this->failure_message->setDbValue($row['failure_message']);
        $this->payment_mode->setDbValue($row['payment_mode']);
        $this->card_name->setDbValue($row['card_name']);
        $this->status_code->setDbValue($row['status_code']);
        $this->status_message->setDbValue($row['status_message']);
        $this->amount->setDbValue($row['amount']);
        $this->trans_date->setDbValue($row['trans_date']);
        $this->datetime->setDbValue($row['datetime']);
        $this->payment_gateway->setDbValue($row['payment_gateway']);
        $this->payment_signature->setDbValue($row['payment_signature']);
        $this->currency_id->setDbValue($row['currency_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['userid'] = $this->_userid->DefaultValue;
        $row['pg_order_number'] = $this->pg_order_number->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['cart_number'] = $this->cart_number->DefaultValue;
        $row['order_id'] = $this->order_id->DefaultValue;
        $row['tracking_id'] = $this->tracking_id->DefaultValue;
        $row['bank_ref_no'] = $this->bank_ref_no->DefaultValue;
        $row['order_status'] = $this->order_status->DefaultValue;
        $row['failure_message'] = $this->failure_message->DefaultValue;
        $row['payment_mode'] = $this->payment_mode->DefaultValue;
        $row['card_name'] = $this->card_name->DefaultValue;
        $row['status_code'] = $this->status_code->DefaultValue;
        $row['status_message'] = $this->status_message->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['trans_date'] = $this->trans_date->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['payment_gateway'] = $this->payment_gateway->DefaultValue;
        $row['payment_signature'] = $this->payment_signature->DefaultValue;
        $row['currency_id'] = $this->currency_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // userid
        $this->_userid->RowCssClass = "row";

        // pg_order_number
        $this->pg_order_number->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // cart_number
        $this->cart_number->RowCssClass = "row";

        // order_id
        $this->order_id->RowCssClass = "row";

        // tracking_id
        $this->tracking_id->RowCssClass = "row";

        // bank_ref_no
        $this->bank_ref_no->RowCssClass = "row";

        // order_status
        $this->order_status->RowCssClass = "row";

        // failure_message
        $this->failure_message->RowCssClass = "row";

        // payment_mode
        $this->payment_mode->RowCssClass = "row";

        // card_name
        $this->card_name->RowCssClass = "row";

        // status_code
        $this->status_code->RowCssClass = "row";

        // status_message
        $this->status_message->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // trans_date
        $this->trans_date->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // payment_gateway
        $this->payment_gateway->RowCssClass = "row";

        // payment_signature
        $this->payment_signature->RowCssClass = "row";

        // currency_id
        $this->currency_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // type
            $this->type->ViewValue = $this->type->CurrentValue;
            $this->type->ViewValue = FormatNumber($this->type->ViewValue, $this->type->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // userid
            $this->_userid->ViewValue = $this->_userid->CurrentValue;
            $curVal = strval($this->_userid->CurrentValue);
            if ($curVal != "") {
                $this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
                if ($this->_userid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_userid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_userid->Lookup->renderViewRow($rswrk[0]);
                        $this->_userid->ViewValue = $this->_userid->displayValue($arwrk);
                    } else {
                        $this->_userid->ViewValue = FormatNumber($this->_userid->CurrentValue, $this->_userid->formatPattern());
                    }
                }
            } else {
                $this->_userid->ViewValue = null;
            }

            // pg_order_number
            $this->pg_order_number->ViewValue = $this->pg_order_number->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // cart_number
            $this->cart_number->ViewValue = $this->cart_number->CurrentValue;
            $this->cart_number->ViewValue = FormatNumber($this->cart_number->ViewValue, $this->cart_number->formatPattern());

            // order_id
            $this->order_id->ViewValue = $this->order_id->CurrentValue;
            $this->order_id->ViewValue = FormatNumber($this->order_id->ViewValue, $this->order_id->formatPattern());

            // tracking_id
            $this->tracking_id->ViewValue = $this->tracking_id->CurrentValue;

            // bank_ref_no
            $this->bank_ref_no->ViewValue = $this->bank_ref_no->CurrentValue;

            // order_status
            $this->order_status->ViewValue = $this->order_status->CurrentValue;

            // failure_message
            $this->failure_message->ViewValue = $this->failure_message->CurrentValue;

            // payment_mode
            $this->payment_mode->ViewValue = $this->payment_mode->CurrentValue;

            // card_name
            $this->card_name->ViewValue = $this->card_name->CurrentValue;

            // status_code
            $this->status_code->ViewValue = $this->status_code->CurrentValue;

            // status_message
            $this->status_message->ViewValue = $this->status_message->CurrentValue;

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // trans_date
            $this->trans_date->ViewValue = $this->trans_date->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // payment_gateway
            $this->payment_gateway->ViewValue = $this->payment_gateway->CurrentValue;

            // payment_signature
            $this->payment_signature->ViewValue = $this->payment_signature->CurrentValue;

            // currency_id
            $curVal = strval($this->currency_id->CurrentValue);
            if ($curVal != "") {
                $this->currency_id->ViewValue = $this->currency_id->lookupCacheOption($curVal);
                if ($this->currency_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency_id->Lookup->renderViewRow($rswrk[0]);
                        $this->currency_id->ViewValue = $this->currency_id->displayValue($arwrk);
                    } else {
                        $this->currency_id->ViewValue = FormatNumber($this->currency_id->CurrentValue, $this->currency_id->formatPattern());
                    }
                }
            } else {
                $this->currency_id->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";

            // type
            if (!EmptyValue($this->type->CurrentValue)) {
                $this->type->HrefValue = $this->type->getLinkPrefix() . (!empty($this->type->EditValue) && !is_array($this->type->EditValue) ? RemoveHtml($this->type->EditValue) : $this->type->CurrentValue); // Add prefix/suffix
                $this->type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
                }
            } else {
                $this->type->HrefValue = "";
            }

            // status
            if (!EmptyValue($this->status->CurrentValue)) {
                $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
                $this->status->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
                }
            } else {
                $this->status->HrefValue = "";
            }

            // userid
            if (!EmptyValue($this->_userid->CurrentValue)) {
                $this->_userid->HrefValue = $this->_userid->getLinkPrefix() . $this->_userid->CurrentValue; // Add prefix/suffix
                $this->_userid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_userid->HrefValue = FullUrl($this->_userid->HrefValue, "href");
                }
            } else {
                $this->_userid->HrefValue = "";
            }

            // pg_order_number
            $this->pg_order_number->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // cart_number
            $this->cart_number->HrefValue = "";

            // order_id
            $this->order_id->HrefValue = "";

            // tracking_id
            $this->tracking_id->HrefValue = "";

            // bank_ref_no
            $this->bank_ref_no->HrefValue = "";

            // order_status
            $this->order_status->HrefValue = "";

            // failure_message
            $this->failure_message->HrefValue = "";

            // payment_mode
            $this->payment_mode->HrefValue = "";

            // card_name
            $this->card_name->HrefValue = "";

            // status_code
            $this->status_code->HrefValue = "";

            // status_message
            $this->status_message->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // trans_date
            $this->trans_date->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // payment_gateway
            $this->payment_gateway->HrefValue = "";

            // payment_signature
            $this->payment_signature->HrefValue = "";

            // currency_id
            $this->currency_id->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // type
            $this->type->setupEditAttributes();
            $this->type->EditValue = $this->type->CurrentValue;
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());
            if (strval($this->type->EditValue) != "" && is_numeric($this->type->EditValue)) {
                $this->type->EditValue = FormatNumber($this->type->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // userid
            $this->_userid->setupEditAttributes();
            $this->_userid->EditValue = $this->_userid->CurrentValue;
            $curVal = strval($this->_userid->CurrentValue);
            if ($curVal != "") {
                $this->_userid->EditValue = $this->_userid->lookupCacheOption($curVal);
                if ($this->_userid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->_userid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_userid->Lookup->renderViewRow($rswrk[0]);
                        $this->_userid->EditValue = $this->_userid->displayValue($arwrk);
                    } else {
                        $this->_userid->EditValue = HtmlEncode(FormatNumber($this->_userid->CurrentValue, $this->_userid->formatPattern()));
                    }
                }
            } else {
                $this->_userid->EditValue = null;
            }
            $this->_userid->PlaceHolder = RemoveHtml($this->_userid->caption());

            // pg_order_number
            $this->pg_order_number->setupEditAttributes();
            if (!$this->pg_order_number->Raw) {
                $this->pg_order_number->CurrentValue = HtmlDecode($this->pg_order_number->CurrentValue);
            }
            $this->pg_order_number->EditValue = HtmlEncode($this->pg_order_number->CurrentValue);
            $this->pg_order_number->PlaceHolder = RemoveHtml($this->pg_order_number->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // cart_number
            $this->cart_number->setupEditAttributes();
            $this->cart_number->EditValue = $this->cart_number->CurrentValue;
            $this->cart_number->PlaceHolder = RemoveHtml($this->cart_number->caption());
            if (strval($this->cart_number->EditValue) != "" && is_numeric($this->cart_number->EditValue)) {
                $this->cart_number->EditValue = FormatNumber($this->cart_number->EditValue, null);
            }

            // order_id
            $this->order_id->setupEditAttributes();
            $this->order_id->EditValue = $this->order_id->CurrentValue;
            $this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());
            if (strval($this->order_id->EditValue) != "" && is_numeric($this->order_id->EditValue)) {
                $this->order_id->EditValue = FormatNumber($this->order_id->EditValue, null);
            }

            // tracking_id
            $this->tracking_id->setupEditAttributes();
            if (!$this->tracking_id->Raw) {
                $this->tracking_id->CurrentValue = HtmlDecode($this->tracking_id->CurrentValue);
            }
            $this->tracking_id->EditValue = HtmlEncode($this->tracking_id->CurrentValue);
            $this->tracking_id->PlaceHolder = RemoveHtml($this->tracking_id->caption());

            // bank_ref_no
            $this->bank_ref_no->setupEditAttributes();
            if (!$this->bank_ref_no->Raw) {
                $this->bank_ref_no->CurrentValue = HtmlDecode($this->bank_ref_no->CurrentValue);
            }
            $this->bank_ref_no->EditValue = HtmlEncode($this->bank_ref_no->CurrentValue);
            $this->bank_ref_no->PlaceHolder = RemoveHtml($this->bank_ref_no->caption());

            // order_status
            $this->order_status->setupEditAttributes();
            if (!$this->order_status->Raw) {
                $this->order_status->CurrentValue = HtmlDecode($this->order_status->CurrentValue);
            }
            $this->order_status->EditValue = HtmlEncode($this->order_status->CurrentValue);
            $this->order_status->PlaceHolder = RemoveHtml($this->order_status->caption());

            // failure_message
            $this->failure_message->setupEditAttributes();
            if (!$this->failure_message->Raw) {
                $this->failure_message->CurrentValue = HtmlDecode($this->failure_message->CurrentValue);
            }
            $this->failure_message->EditValue = HtmlEncode($this->failure_message->CurrentValue);
            $this->failure_message->PlaceHolder = RemoveHtml($this->failure_message->caption());

            // payment_mode
            $this->payment_mode->setupEditAttributes();
            if (!$this->payment_mode->Raw) {
                $this->payment_mode->CurrentValue = HtmlDecode($this->payment_mode->CurrentValue);
            }
            $this->payment_mode->EditValue = HtmlEncode($this->payment_mode->CurrentValue);
            $this->payment_mode->PlaceHolder = RemoveHtml($this->payment_mode->caption());

            // card_name
            $this->card_name->setupEditAttributes();
            if (!$this->card_name->Raw) {
                $this->card_name->CurrentValue = HtmlDecode($this->card_name->CurrentValue);
            }
            $this->card_name->EditValue = HtmlEncode($this->card_name->CurrentValue);
            $this->card_name->PlaceHolder = RemoveHtml($this->card_name->caption());

            // status_code
            $this->status_code->setupEditAttributes();
            if (!$this->status_code->Raw) {
                $this->status_code->CurrentValue = HtmlDecode($this->status_code->CurrentValue);
            }
            $this->status_code->EditValue = HtmlEncode($this->status_code->CurrentValue);
            $this->status_code->PlaceHolder = RemoveHtml($this->status_code->caption());

            // status_message
            $this->status_message->setupEditAttributes();
            if (!$this->status_message->Raw) {
                $this->status_message->CurrentValue = HtmlDecode($this->status_message->CurrentValue);
            }
            $this->status_message->EditValue = HtmlEncode($this->status_message->CurrentValue);
            $this->status_message->PlaceHolder = RemoveHtml($this->status_message->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // trans_date
            $this->trans_date->setupEditAttributes();
            if (!$this->trans_date->Raw) {
                $this->trans_date->CurrentValue = HtmlDecode($this->trans_date->CurrentValue);
            }
            $this->trans_date->EditValue = HtmlEncode($this->trans_date->CurrentValue);
            $this->trans_date->PlaceHolder = RemoveHtml($this->trans_date->caption());

            // datetime

            // payment_gateway
            $this->payment_gateway->setupEditAttributes();
            if (!$this->payment_gateway->Raw) {
                $this->payment_gateway->CurrentValue = HtmlDecode($this->payment_gateway->CurrentValue);
            }
            $this->payment_gateway->EditValue = HtmlEncode($this->payment_gateway->CurrentValue);
            $this->payment_gateway->PlaceHolder = RemoveHtml($this->payment_gateway->caption());

            // payment_signature
            $this->payment_signature->setupEditAttributes();
            if (!$this->payment_signature->Raw) {
                $this->payment_signature->CurrentValue = HtmlDecode($this->payment_signature->CurrentValue);
            }
            $this->payment_signature->EditValue = HtmlEncode($this->payment_signature->CurrentValue);
            $this->payment_signature->PlaceHolder = RemoveHtml($this->payment_signature->caption());

            // currency_id
            $this->currency_id->setupEditAttributes();
            $curVal = trim(strval($this->currency_id->CurrentValue));
            if ($curVal != "") {
                $this->currency_id->ViewValue = $this->currency_id->lookupCacheOption($curVal);
            } else {
                $this->currency_id->ViewValue = $this->currency_id->Lookup !== null && is_array($this->currency_id->lookupOptions()) && count($this->currency_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency_id->ViewValue !== null) { // Load from cache
                $this->currency_id->EditValue = array_values($this->currency_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency_id->CurrentValue, $this->currency_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency_id->EditValue = $arwrk;
            }
            $this->currency_id->PlaceHolder = RemoveHtml($this->currency_id->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // type
            if (!EmptyValue($this->type->CurrentValue)) {
                $this->type->HrefValue = $this->type->getLinkPrefix() . (!empty($this->type->EditValue) && !is_array($this->type->EditValue) ? RemoveHtml($this->type->EditValue) : $this->type->CurrentValue); // Add prefix/suffix
                $this->type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
                }
            } else {
                $this->type->HrefValue = "";
            }

            // status
            if (!EmptyValue($this->status->CurrentValue)) {
                $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
                $this->status->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
                }
            } else {
                $this->status->HrefValue = "";
            }

            // userid
            if (!EmptyValue($this->_userid->CurrentValue)) {
                $this->_userid->HrefValue = $this->_userid->getLinkPrefix() . $this->_userid->CurrentValue; // Add prefix/suffix
                $this->_userid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_userid->HrefValue = FullUrl($this->_userid->HrefValue, "href");
                }
            } else {
                $this->_userid->HrefValue = "";
            }

            // pg_order_number
            $this->pg_order_number->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // cart_number
            $this->cart_number->HrefValue = "";

            // order_id
            $this->order_id->HrefValue = "";

            // tracking_id
            $this->tracking_id->HrefValue = "";

            // bank_ref_no
            $this->bank_ref_no->HrefValue = "";

            // order_status
            $this->order_status->HrefValue = "";

            // failure_message
            $this->failure_message->HrefValue = "";

            // payment_mode
            $this->payment_mode->HrefValue = "";

            // card_name
            $this->card_name->HrefValue = "";

            // status_code
            $this->status_code->HrefValue = "";

            // status_message
            $this->status_message->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // trans_date
            $this->trans_date->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // payment_gateway
            $this->payment_gateway->HrefValue = "";

            // payment_signature
            $this->payment_signature->HrefValue = "";

            // currency_id
            $this->currency_id->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->type->Visible && $this->type->Required) {
                if (!$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->type->FormValue)) {
                $this->type->addErrorMessage($this->type->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->_userid->Visible && $this->_userid->Required) {
                if (!$this->_userid->IsDetailKey && EmptyValue($this->_userid->FormValue)) {
                    $this->_userid->addErrorMessage(str_replace("%s", $this->_userid->caption(), $this->_userid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->_userid->FormValue)) {
                $this->_userid->addErrorMessage($this->_userid->getErrorMessage(false));
            }
            if ($this->pg_order_number->Visible && $this->pg_order_number->Required) {
                if (!$this->pg_order_number->IsDetailKey && EmptyValue($this->pg_order_number->FormValue)) {
                    $this->pg_order_number->addErrorMessage(str_replace("%s", $this->pg_order_number->caption(), $this->pg_order_number->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->cart_number->Visible && $this->cart_number->Required) {
                if (!$this->cart_number->IsDetailKey && EmptyValue($this->cart_number->FormValue)) {
                    $this->cart_number->addErrorMessage(str_replace("%s", $this->cart_number->caption(), $this->cart_number->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->cart_number->FormValue)) {
                $this->cart_number->addErrorMessage($this->cart_number->getErrorMessage(false));
            }
            if ($this->order_id->Visible && $this->order_id->Required) {
                if (!$this->order_id->IsDetailKey && EmptyValue($this->order_id->FormValue)) {
                    $this->order_id->addErrorMessage(str_replace("%s", $this->order_id->caption(), $this->order_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->order_id->FormValue)) {
                $this->order_id->addErrorMessage($this->order_id->getErrorMessage(false));
            }
            if ($this->tracking_id->Visible && $this->tracking_id->Required) {
                if (!$this->tracking_id->IsDetailKey && EmptyValue($this->tracking_id->FormValue)) {
                    $this->tracking_id->addErrorMessage(str_replace("%s", $this->tracking_id->caption(), $this->tracking_id->RequiredErrorMessage));
                }
            }
            if ($this->bank_ref_no->Visible && $this->bank_ref_no->Required) {
                if (!$this->bank_ref_no->IsDetailKey && EmptyValue($this->bank_ref_no->FormValue)) {
                    $this->bank_ref_no->addErrorMessage(str_replace("%s", $this->bank_ref_no->caption(), $this->bank_ref_no->RequiredErrorMessage));
                }
            }
            if ($this->order_status->Visible && $this->order_status->Required) {
                if (!$this->order_status->IsDetailKey && EmptyValue($this->order_status->FormValue)) {
                    $this->order_status->addErrorMessage(str_replace("%s", $this->order_status->caption(), $this->order_status->RequiredErrorMessage));
                }
            }
            if ($this->failure_message->Visible && $this->failure_message->Required) {
                if (!$this->failure_message->IsDetailKey && EmptyValue($this->failure_message->FormValue)) {
                    $this->failure_message->addErrorMessage(str_replace("%s", $this->failure_message->caption(), $this->failure_message->RequiredErrorMessage));
                }
            }
            if ($this->payment_mode->Visible && $this->payment_mode->Required) {
                if (!$this->payment_mode->IsDetailKey && EmptyValue($this->payment_mode->FormValue)) {
                    $this->payment_mode->addErrorMessage(str_replace("%s", $this->payment_mode->caption(), $this->payment_mode->RequiredErrorMessage));
                }
            }
            if ($this->card_name->Visible && $this->card_name->Required) {
                if (!$this->card_name->IsDetailKey && EmptyValue($this->card_name->FormValue)) {
                    $this->card_name->addErrorMessage(str_replace("%s", $this->card_name->caption(), $this->card_name->RequiredErrorMessage));
                }
            }
            if ($this->status_code->Visible && $this->status_code->Required) {
                if (!$this->status_code->IsDetailKey && EmptyValue($this->status_code->FormValue)) {
                    $this->status_code->addErrorMessage(str_replace("%s", $this->status_code->caption(), $this->status_code->RequiredErrorMessage));
                }
            }
            if ($this->status_message->Visible && $this->status_message->Required) {
                if (!$this->status_message->IsDetailKey && EmptyValue($this->status_message->FormValue)) {
                    $this->status_message->addErrorMessage(str_replace("%s", $this->status_message->caption(), $this->status_message->RequiredErrorMessage));
                }
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->trans_date->Visible && $this->trans_date->Required) {
                if (!$this->trans_date->IsDetailKey && EmptyValue($this->trans_date->FormValue)) {
                    $this->trans_date->addErrorMessage(str_replace("%s", $this->trans_date->caption(), $this->trans_date->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->payment_gateway->Visible && $this->payment_gateway->Required) {
                if (!$this->payment_gateway->IsDetailKey && EmptyValue($this->payment_gateway->FormValue)) {
                    $this->payment_gateway->addErrorMessage(str_replace("%s", $this->payment_gateway->caption(), $this->payment_gateway->RequiredErrorMessage));
                }
            }
            if ($this->payment_signature->Visible && $this->payment_signature->Required) {
                if (!$this->payment_signature->IsDetailKey && EmptyValue($this->payment_signature->FormValue)) {
                    $this->payment_signature->addErrorMessage(str_replace("%s", $this->payment_signature->caption(), $this->payment_signature->RequiredErrorMessage));
                }
            }
            if ($this->currency_id->Visible && $this->currency_id->Required) {
                if (!$this->currency_id->IsDetailKey && EmptyValue($this->currency_id->FormValue)) {
                    $this->currency_id->addErrorMessage(str_replace("%s", $this->currency_id->caption(), $this->currency_id->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (pg_order_number)
        if ($this->pg_order_number->CurrentValue != "") {
            $filterChk = "(`pg_order_number` = '" . AdjustSql($this->pg_order_number->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->pg_order_number->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->pg_order_number->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // type
        $this->type->setDbValueDef($rsnew, $this->type->CurrentValue, $this->type->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // userid
        $this->_userid->setDbValueDef($rsnew, $this->_userid->CurrentValue, $this->_userid->ReadOnly);

        // pg_order_number
        $this->pg_order_number->setDbValueDef($rsnew, $this->pg_order_number->CurrentValue, $this->pg_order_number->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // cart_number
        $this->cart_number->setDbValueDef($rsnew, $this->cart_number->CurrentValue, $this->cart_number->ReadOnly);

        // order_id
        $this->order_id->setDbValueDef($rsnew, $this->order_id->CurrentValue, $this->order_id->ReadOnly);

        // tracking_id
        $this->tracking_id->setDbValueDef($rsnew, $this->tracking_id->CurrentValue, $this->tracking_id->ReadOnly);

        // bank_ref_no
        $this->bank_ref_no->setDbValueDef($rsnew, $this->bank_ref_no->CurrentValue, $this->bank_ref_no->ReadOnly);

        // order_status
        $this->order_status->setDbValueDef($rsnew, $this->order_status->CurrentValue, $this->order_status->ReadOnly);

        // failure_message
        $this->failure_message->setDbValueDef($rsnew, $this->failure_message->CurrentValue, $this->failure_message->ReadOnly);

        // payment_mode
        $this->payment_mode->setDbValueDef($rsnew, $this->payment_mode->CurrentValue, $this->payment_mode->ReadOnly);

        // card_name
        $this->card_name->setDbValueDef($rsnew, $this->card_name->CurrentValue, $this->card_name->ReadOnly);

        // status_code
        $this->status_code->setDbValueDef($rsnew, $this->status_code->CurrentValue, $this->status_code->ReadOnly);

        // status_message
        $this->status_message->setDbValueDef($rsnew, $this->status_message->CurrentValue, $this->status_message->ReadOnly);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, $this->amount->ReadOnly);

        // trans_date
        $this->trans_date->setDbValueDef($rsnew, $this->trans_date->CurrentValue, $this->trans_date->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // payment_gateway
        $this->payment_gateway->setDbValueDef($rsnew, $this->payment_gateway->CurrentValue, $this->payment_gateway->ReadOnly);

        // payment_signature
        $this->payment_signature->setDbValueDef($rsnew, $this->payment_signature->CurrentValue, $this->payment_signature->ReadOnly);

        // currency_id
        $this->currency_id->setDbValueDef($rsnew, $this->currency_id->CurrentValue, $this->currency_id->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['type'])) { // type
            $this->type->CurrentValue = $row['type'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['userid'])) { // userid
            $this->_userid->CurrentValue = $row['userid'];
        }
        if (isset($row['pg_order_number'])) { // pg_order_number
            $this->pg_order_number->CurrentValue = $row['pg_order_number'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['cart_number'])) { // cart_number
            $this->cart_number->CurrentValue = $row['cart_number'];
        }
        if (isset($row['order_id'])) { // order_id
            $this->order_id->CurrentValue = $row['order_id'];
        }
        if (isset($row['tracking_id'])) { // tracking_id
            $this->tracking_id->CurrentValue = $row['tracking_id'];
        }
        if (isset($row['bank_ref_no'])) { // bank_ref_no
            $this->bank_ref_no->CurrentValue = $row['bank_ref_no'];
        }
        if (isset($row['order_status'])) { // order_status
            $this->order_status->CurrentValue = $row['order_status'];
        }
        if (isset($row['failure_message'])) { // failure_message
            $this->failure_message->CurrentValue = $row['failure_message'];
        }
        if (isset($row['payment_mode'])) { // payment_mode
            $this->payment_mode->CurrentValue = $row['payment_mode'];
        }
        if (isset($row['card_name'])) { // card_name
            $this->card_name->CurrentValue = $row['card_name'];
        }
        if (isset($row['status_code'])) { // status_code
            $this->status_code->CurrentValue = $row['status_code'];
        }
        if (isset($row['status_message'])) { // status_message
            $this->status_message->CurrentValue = $row['status_message'];
        }
        if (isset($row['amount'])) { // amount
            $this->amount->CurrentValue = $row['amount'];
        }
        if (isset($row['trans_date'])) { // trans_date
            $this->trans_date->CurrentValue = $row['trans_date'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['payment_gateway'])) { // payment_gateway
            $this->payment_gateway->CurrentValue = $row['payment_gateway'];
        }
        if (isset($row['payment_signature'])) { // payment_signature
            $this->payment_signature->CurrentValue = $row['payment_signature'];
        }
        if (isset($row['currency_id'])) { // currency_id
            $this->currency_id->CurrentValue = $row['currency_id'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("paymentresponselist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_status":
                    break;
                case "x__userid":
                    break;
                case "x_currency_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
