<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for payment_response
 */
class PaymentResponse extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $type;
    public $status;
    public $_userid;
    public $pg_order_number;
    public $remarks;
    public $cart_number;
    public $order_id;
    public $tracking_id;
    public $bank_ref_no;
    public $order_status;
    public $failure_message;
    public $payment_mode;
    public $card_name;
    public $status_code;
    public $status_message;
    public $amount;
    public $trans_date;
    public $datetime;
    public $payment_gateway;
    public $payment_signature;
    public $currency_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "payment_response";
        $this->TableName = 'payment_response';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "payment_response";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // type
        $this->type = new DbField(
            $this, // Table
            'x_type', // Variable name
            'type', // Name
            '`type`', // Expression
            '`type`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->type->addMethod("getLinkPrefix", fn() => "paymentresponselist?x_type=");
        $this->type->InputTextType = "text";
        $this->type->Raw = true;
        $this->type->Nullable = false; // NOT NULL field
        $this->type->Required = true; // Required field
        $this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->type->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['type'] = &$this->type;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 0);
        $this->status->addMethod("getLinkPrefix", fn() => "paymentresponselist?x_status=");
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'payment_response', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 6;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // userid
        $this->_userid = new DbField(
            $this, // Table
            'x__userid', // Variable name
            'userid', // Name
            '`userid`', // Expression
            '`userid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`userid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_userid->addMethod("getLinkPrefix", fn() => "paymentresponselist?x__userid=");
        $this->_userid->InputTextType = "text";
        $this->_userid->Raw = true;
        $this->_userid->Nullable = false; // NOT NULL field
        $this->_userid->Required = true; // Required field
        $this->_userid->Lookup = new Lookup($this->_userid, 'buyer', false, 'id', ["name","mobile","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->_userid) . "',COALESCE(`mobile`,''))");
        $this->_userid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_userid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['userid'] = &$this->_userid;

        // pg_order_number
        $this->pg_order_number = new DbField(
            $this, // Table
            'x_pg_order_number', // Variable name
            'pg_order_number', // Name
            '`pg_order_number`', // Expression
            '`pg_order_number`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pg_order_number`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pg_order_number->InputTextType = "text";
        $this->pg_order_number->Nullable = false; // NOT NULL field
        $this->pg_order_number->Required = true; // Required field
        $this->pg_order_number->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pg_order_number'] = &$this->pg_order_number;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->Nullable = false; // NOT NULL field
        $this->remarks->Required = true; // Required field
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['remarks'] = &$this->remarks;

        // cart_number
        $this->cart_number = new DbField(
            $this, // Table
            'x_cart_number', // Variable name
            'cart_number', // Name
            '`cart_number`', // Expression
            '`cart_number`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cart_number`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cart_number->InputTextType = "text";
        $this->cart_number->Raw = true;
        $this->cart_number->Nullable = false; // NOT NULL field
        $this->cart_number->Required = true; // Required field
        $this->cart_number->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cart_number->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cart_number'] = &$this->cart_number;

        // order_id
        $this->order_id = new DbField(
            $this, // Table
            'x_order_id', // Variable name
            'order_id', // Name
            '`order_id`', // Expression
            '`order_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`order_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->order_id->InputTextType = "text";
        $this->order_id->Raw = true;
        $this->order_id->Nullable = false; // NOT NULL field
        $this->order_id->Required = true; // Required field
        $this->order_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->order_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['order_id'] = &$this->order_id;

        // tracking_id
        $this->tracking_id = new DbField(
            $this, // Table
            'x_tracking_id', // Variable name
            'tracking_id', // Name
            '`tracking_id`', // Expression
            '`tracking_id`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tracking_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tracking_id->InputTextType = "text";
        $this->tracking_id->Nullable = false; // NOT NULL field
        $this->tracking_id->Required = true; // Required field
        $this->tracking_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['tracking_id'] = &$this->tracking_id;

        // bank_ref_no
        $this->bank_ref_no = new DbField(
            $this, // Table
            'x_bank_ref_no', // Variable name
            'bank_ref_no', // Name
            '`bank_ref_no`', // Expression
            '`bank_ref_no`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_ref_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_ref_no->InputTextType = "text";
        $this->bank_ref_no->Nullable = false; // NOT NULL field
        $this->bank_ref_no->Required = true; // Required field
        $this->bank_ref_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['bank_ref_no'] = &$this->bank_ref_no;

        // order_status
        $this->order_status = new DbField(
            $this, // Table
            'x_order_status', // Variable name
            'order_status', // Name
            '`order_status`', // Expression
            '`order_status`', // Basic search expression
            200, // Type
            15, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`order_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->order_status->InputTextType = "text";
        $this->order_status->Nullable = false; // NOT NULL field
        $this->order_status->Required = true; // Required field
        $this->order_status->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['order_status'] = &$this->order_status;

        // failure_message
        $this->failure_message = new DbField(
            $this, // Table
            'x_failure_message', // Variable name
            'failure_message', // Name
            '`failure_message`', // Expression
            '`failure_message`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`failure_message`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->failure_message->InputTextType = "text";
        $this->failure_message->Nullable = false; // NOT NULL field
        $this->failure_message->Required = true; // Required field
        $this->failure_message->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['failure_message'] = &$this->failure_message;

        // payment_mode
        $this->payment_mode = new DbField(
            $this, // Table
            'x_payment_mode', // Variable name
            'payment_mode', // Name
            '`payment_mode`', // Expression
            '`payment_mode`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_mode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->payment_mode->InputTextType = "text";
        $this->payment_mode->Nullable = false; // NOT NULL field
        $this->payment_mode->Required = true; // Required field
        $this->payment_mode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['payment_mode'] = &$this->payment_mode;

        // card_name
        $this->card_name = new DbField(
            $this, // Table
            'x_card_name', // Variable name
            'card_name', // Name
            '`card_name`', // Expression
            '`card_name`', // Basic search expression
            200, // Type
            30, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`card_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->card_name->InputTextType = "text";
        $this->card_name->Nullable = false; // NOT NULL field
        $this->card_name->Required = true; // Required field
        $this->card_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['card_name'] = &$this->card_name;

        // status_code
        $this->status_code = new DbField(
            $this, // Table
            'x_status_code', // Variable name
            'status_code', // Name
            '`status_code`', // Expression
            '`status_code`', // Basic search expression
            200, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->status_code->InputTextType = "text";
        $this->status_code->Nullable = false; // NOT NULL field
        $this->status_code->Required = true; // Required field
        $this->status_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['status_code'] = &$this->status_code;

        // status_message
        $this->status_message = new DbField(
            $this, // Table
            'x_status_message', // Variable name
            'status_message', // Name
            '`status_message`', // Expression
            '`status_message`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_message`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->status_message->InputTextType = "text";
        $this->status_message->Nullable = false; // NOT NULL field
        $this->status_message->Required = true; // Required field
        $this->status_message->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['status_message'] = &$this->status_message;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['amount'] = &$this->amount;

        // trans_date
        $this->trans_date = new DbField(
            $this, // Table
            'x_trans_date', // Variable name
            'trans_date', // Name
            '`trans_date`', // Expression
            '`trans_date`', // Basic search expression
            200, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`trans_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->trans_date->InputTextType = "text";
        $this->trans_date->Nullable = false; // NOT NULL field
        $this->trans_date->Required = true; // Required field
        $this->trans_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['trans_date'] = &$this->trans_date;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // payment_gateway
        $this->payment_gateway = new DbField(
            $this, // Table
            'x_payment_gateway', // Variable name
            'payment_gateway', // Name
            '`payment_gateway`', // Expression
            '`payment_gateway`', // Basic search expression
            200, // Type
            30, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_gateway`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->payment_gateway->InputTextType = "text";
        $this->payment_gateway->Nullable = false; // NOT NULL field
        $this->payment_gateway->Required = true; // Required field
        $this->payment_gateway->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['payment_gateway'] = &$this->payment_gateway;

        // payment_signature
        $this->payment_signature = new DbField(
            $this, // Table
            'x_payment_signature', // Variable name
            'payment_signature', // Name
            '`payment_signature`', // Expression
            '`payment_signature`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_signature`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->payment_signature->InputTextType = "text";
        $this->payment_signature->Nullable = false; // NOT NULL field
        $this->payment_signature->Required = true; // Required field
        $this->payment_signature->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['payment_signature'] = &$this->payment_signature;

        // currency_id
        $this->currency_id = new DbField(
            $this, // Table
            'x_currency_id', // Variable name
            'currency_id', // Name
            '`currency_id`', // Expression
            '`currency_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`currency_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->currency_id->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->currency_id->InputTextType = "text";
        $this->currency_id->Raw = true;
        $this->currency_id->Nullable = false; // NOT NULL field
        $this->currency_id->Required = true; // Required field
        $this->currency_id->setSelectMultiple(false); // Select one
        $this->currency_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->currency_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->currency_id->Lookup = new Lookup($this->currency_id, 'currency', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->currency_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->currency_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['currency_id'] = &$this->currency_id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "payment_response";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->type->DbValue = $row['type'];
        $this->status->DbValue = $row['status'];
        $this->_userid->DbValue = $row['userid'];
        $this->pg_order_number->DbValue = $row['pg_order_number'];
        $this->remarks->DbValue = $row['remarks'];
        $this->cart_number->DbValue = $row['cart_number'];
        $this->order_id->DbValue = $row['order_id'];
        $this->tracking_id->DbValue = $row['tracking_id'];
        $this->bank_ref_no->DbValue = $row['bank_ref_no'];
        $this->order_status->DbValue = $row['order_status'];
        $this->failure_message->DbValue = $row['failure_message'];
        $this->payment_mode->DbValue = $row['payment_mode'];
        $this->card_name->DbValue = $row['card_name'];
        $this->status_code->DbValue = $row['status_code'];
        $this->status_message->DbValue = $row['status_message'];
        $this->amount->DbValue = $row['amount'];
        $this->trans_date->DbValue = $row['trans_date'];
        $this->datetime->DbValue = $row['datetime'];
        $this->payment_gateway->DbValue = $row['payment_gateway'];
        $this->payment_signature->DbValue = $row['payment_signature'];
        $this->currency_id->DbValue = $row['currency_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("paymentresponselist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "paymentresponseview" => $Language->phrase("View"),
            "paymentresponseedit" => $Language->phrase("Edit"),
            "paymentresponseadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "paymentresponselist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PaymentResponseView",
            Config("API_ADD_ACTION") => "PaymentResponseAdd",
            Config("API_EDIT_ACTION") => "PaymentResponseEdit",
            Config("API_DELETE_ACTION") => "PaymentResponseDelete",
            Config("API_LIST_ACTION") => "PaymentResponseList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "paymentresponselist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("paymentresponseview", $parm);
        } else {
            $url = $this->keyUrl("paymentresponseview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "paymentresponseadd?" . $parm;
        } else {
            $url = "paymentresponseadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("paymentresponseedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("paymentresponselist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("paymentresponseadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("paymentresponselist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("paymentresponsedelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->type->setDbValue($row['type']);
        $this->status->setDbValue($row['status']);
        $this->_userid->setDbValue($row['userid']);
        $this->pg_order_number->setDbValue($row['pg_order_number']);
        $this->remarks->setDbValue($row['remarks']);
        $this->cart_number->setDbValue($row['cart_number']);
        $this->order_id->setDbValue($row['order_id']);
        $this->tracking_id->setDbValue($row['tracking_id']);
        $this->bank_ref_no->setDbValue($row['bank_ref_no']);
        $this->order_status->setDbValue($row['order_status']);
        $this->failure_message->setDbValue($row['failure_message']);
        $this->payment_mode->setDbValue($row['payment_mode']);
        $this->card_name->setDbValue($row['card_name']);
        $this->status_code->setDbValue($row['status_code']);
        $this->status_message->setDbValue($row['status_message']);
        $this->amount->setDbValue($row['amount']);
        $this->trans_date->setDbValue($row['trans_date']);
        $this->datetime->setDbValue($row['datetime']);
        $this->payment_gateway->setDbValue($row['payment_gateway']);
        $this->payment_signature->setDbValue($row['payment_signature']);
        $this->currency_id->setDbValue($row['currency_id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PaymentResponseList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // type

        // status

        // userid

        // pg_order_number

        // remarks

        // cart_number

        // order_id

        // tracking_id

        // bank_ref_no

        // order_status

        // failure_message

        // payment_mode

        // card_name

        // status_code

        // status_message

        // amount

        // trans_date

        // datetime

        // payment_gateway

        // payment_signature

        // currency_id

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // type
        $this->type->ViewValue = $this->type->CurrentValue;
        $this->type->ViewValue = FormatNumber($this->type->ViewValue, $this->type->formatPattern());

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // userid
        $this->_userid->ViewValue = $this->_userid->CurrentValue;
        $curVal = strval($this->_userid->CurrentValue);
        if ($curVal != "") {
            $this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
            if ($this->_userid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->_userid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->_userid->Lookup->renderViewRow($rswrk[0]);
                    $this->_userid->ViewValue = $this->_userid->displayValue($arwrk);
                } else {
                    $this->_userid->ViewValue = FormatNumber($this->_userid->CurrentValue, $this->_userid->formatPattern());
                }
            }
        } else {
            $this->_userid->ViewValue = null;
        }

        // pg_order_number
        $this->pg_order_number->ViewValue = $this->pg_order_number->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // cart_number
        $this->cart_number->ViewValue = $this->cart_number->CurrentValue;
        $this->cart_number->ViewValue = FormatNumber($this->cart_number->ViewValue, $this->cart_number->formatPattern());

        // order_id
        $this->order_id->ViewValue = $this->order_id->CurrentValue;
        $this->order_id->ViewValue = FormatNumber($this->order_id->ViewValue, $this->order_id->formatPattern());

        // tracking_id
        $this->tracking_id->ViewValue = $this->tracking_id->CurrentValue;

        // bank_ref_no
        $this->bank_ref_no->ViewValue = $this->bank_ref_no->CurrentValue;

        // order_status
        $this->order_status->ViewValue = $this->order_status->CurrentValue;

        // failure_message
        $this->failure_message->ViewValue = $this->failure_message->CurrentValue;

        // payment_mode
        $this->payment_mode->ViewValue = $this->payment_mode->CurrentValue;

        // card_name
        $this->card_name->ViewValue = $this->card_name->CurrentValue;

        // status_code
        $this->status_code->ViewValue = $this->status_code->CurrentValue;

        // status_message
        $this->status_message->ViewValue = $this->status_message->CurrentValue;

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

        // trans_date
        $this->trans_date->ViewValue = $this->trans_date->CurrentValue;

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // payment_gateway
        $this->payment_gateway->ViewValue = $this->payment_gateway->CurrentValue;

        // payment_signature
        $this->payment_signature->ViewValue = $this->payment_signature->CurrentValue;

        // currency_id
        $curVal = strval($this->currency_id->CurrentValue);
        if ($curVal != "") {
            $this->currency_id->ViewValue = $this->currency_id->lookupCacheOption($curVal);
            if ($this->currency_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->currency_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->currency_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->currency_id->Lookup->renderViewRow($rswrk[0]);
                    $this->currency_id->ViewValue = $this->currency_id->displayValue($arwrk);
                } else {
                    $this->currency_id->ViewValue = FormatNumber($this->currency_id->CurrentValue, $this->currency_id->formatPattern());
                }
            }
        } else {
            $this->currency_id->ViewValue = null;
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // type
        if (!EmptyValue($this->type->CurrentValue)) {
            $this->type->HrefValue = $this->type->getLinkPrefix() . (!empty($this->type->ViewValue) && !is_array($this->type->ViewValue) ? RemoveHtml($this->type->ViewValue) : $this->type->CurrentValue); // Add prefix/suffix
            $this->type->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
            }
        } else {
            $this->type->HrefValue = "";
        }
        $this->type->TooltipValue = "";

        // status
        if (!EmptyValue($this->status->CurrentValue)) {
            $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
            $this->status->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
            }
        } else {
            $this->status->HrefValue = "";
        }
        $this->status->TooltipValue = "";

        // userid
        if (!EmptyValue($this->_userid->CurrentValue)) {
            $this->_userid->HrefValue = $this->_userid->getLinkPrefix() . $this->_userid->CurrentValue; // Add prefix/suffix
            $this->_userid->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->_userid->HrefValue = FullUrl($this->_userid->HrefValue, "href");
            }
        } else {
            $this->_userid->HrefValue = "";
        }
        $this->_userid->TooltipValue = "";

        // pg_order_number
        $this->pg_order_number->HrefValue = "";
        $this->pg_order_number->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // cart_number
        $this->cart_number->HrefValue = "";
        $this->cart_number->TooltipValue = "";

        // order_id
        $this->order_id->HrefValue = "";
        $this->order_id->TooltipValue = "";

        // tracking_id
        $this->tracking_id->HrefValue = "";
        $this->tracking_id->TooltipValue = "";

        // bank_ref_no
        $this->bank_ref_no->HrefValue = "";
        $this->bank_ref_no->TooltipValue = "";

        // order_status
        $this->order_status->HrefValue = "";
        $this->order_status->TooltipValue = "";

        // failure_message
        $this->failure_message->HrefValue = "";
        $this->failure_message->TooltipValue = "";

        // payment_mode
        $this->payment_mode->HrefValue = "";
        $this->payment_mode->TooltipValue = "";

        // card_name
        $this->card_name->HrefValue = "";
        $this->card_name->TooltipValue = "";

        // status_code
        $this->status_code->HrefValue = "";
        $this->status_code->TooltipValue = "";

        // status_message
        $this->status_message->HrefValue = "";
        $this->status_message->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // trans_date
        $this->trans_date->HrefValue = "";
        $this->trans_date->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // payment_gateway
        $this->payment_gateway->HrefValue = "";
        $this->payment_gateway->TooltipValue = "";

        // payment_signature
        $this->payment_signature->HrefValue = "";
        $this->payment_signature->TooltipValue = "";

        // currency_id
        $this->currency_id->HrefValue = "";
        $this->currency_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // type
        $this->type->setupEditAttributes();
        $this->type->EditValue = $this->type->CurrentValue;
        $this->type->PlaceHolder = RemoveHtml($this->type->caption());
        if (strval($this->type->EditValue) != "" && is_numeric($this->type->EditValue)) {
            $this->type->EditValue = FormatNumber($this->type->EditValue, null);
        }

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // userid
        $this->_userid->setupEditAttributes();
        $this->_userid->EditValue = $this->_userid->CurrentValue;
        $this->_userid->PlaceHolder = RemoveHtml($this->_userid->caption());

        // pg_order_number
        $this->pg_order_number->setupEditAttributes();
        if (!$this->pg_order_number->Raw) {
            $this->pg_order_number->CurrentValue = HtmlDecode($this->pg_order_number->CurrentValue);
        }
        $this->pg_order_number->EditValue = $this->pg_order_number->CurrentValue;
        $this->pg_order_number->PlaceHolder = RemoveHtml($this->pg_order_number->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // cart_number
        $this->cart_number->setupEditAttributes();
        $this->cart_number->EditValue = $this->cart_number->CurrentValue;
        $this->cart_number->PlaceHolder = RemoveHtml($this->cart_number->caption());
        if (strval($this->cart_number->EditValue) != "" && is_numeric($this->cart_number->EditValue)) {
            $this->cart_number->EditValue = FormatNumber($this->cart_number->EditValue, null);
        }

        // order_id
        $this->order_id->setupEditAttributes();
        $this->order_id->EditValue = $this->order_id->CurrentValue;
        $this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());
        if (strval($this->order_id->EditValue) != "" && is_numeric($this->order_id->EditValue)) {
            $this->order_id->EditValue = FormatNumber($this->order_id->EditValue, null);
        }

        // tracking_id
        $this->tracking_id->setupEditAttributes();
        if (!$this->tracking_id->Raw) {
            $this->tracking_id->CurrentValue = HtmlDecode($this->tracking_id->CurrentValue);
        }
        $this->tracking_id->EditValue = $this->tracking_id->CurrentValue;
        $this->tracking_id->PlaceHolder = RemoveHtml($this->tracking_id->caption());

        // bank_ref_no
        $this->bank_ref_no->setupEditAttributes();
        if (!$this->bank_ref_no->Raw) {
            $this->bank_ref_no->CurrentValue = HtmlDecode($this->bank_ref_no->CurrentValue);
        }
        $this->bank_ref_no->EditValue = $this->bank_ref_no->CurrentValue;
        $this->bank_ref_no->PlaceHolder = RemoveHtml($this->bank_ref_no->caption());

        // order_status
        $this->order_status->setupEditAttributes();
        if (!$this->order_status->Raw) {
            $this->order_status->CurrentValue = HtmlDecode($this->order_status->CurrentValue);
        }
        $this->order_status->EditValue = $this->order_status->CurrentValue;
        $this->order_status->PlaceHolder = RemoveHtml($this->order_status->caption());

        // failure_message
        $this->failure_message->setupEditAttributes();
        if (!$this->failure_message->Raw) {
            $this->failure_message->CurrentValue = HtmlDecode($this->failure_message->CurrentValue);
        }
        $this->failure_message->EditValue = $this->failure_message->CurrentValue;
        $this->failure_message->PlaceHolder = RemoveHtml($this->failure_message->caption());

        // payment_mode
        $this->payment_mode->setupEditAttributes();
        if (!$this->payment_mode->Raw) {
            $this->payment_mode->CurrentValue = HtmlDecode($this->payment_mode->CurrentValue);
        }
        $this->payment_mode->EditValue = $this->payment_mode->CurrentValue;
        $this->payment_mode->PlaceHolder = RemoveHtml($this->payment_mode->caption());

        // card_name
        $this->card_name->setupEditAttributes();
        if (!$this->card_name->Raw) {
            $this->card_name->CurrentValue = HtmlDecode($this->card_name->CurrentValue);
        }
        $this->card_name->EditValue = $this->card_name->CurrentValue;
        $this->card_name->PlaceHolder = RemoveHtml($this->card_name->caption());

        // status_code
        $this->status_code->setupEditAttributes();
        if (!$this->status_code->Raw) {
            $this->status_code->CurrentValue = HtmlDecode($this->status_code->CurrentValue);
        }
        $this->status_code->EditValue = $this->status_code->CurrentValue;
        $this->status_code->PlaceHolder = RemoveHtml($this->status_code->caption());

        // status_message
        $this->status_message->setupEditAttributes();
        if (!$this->status_message->Raw) {
            $this->status_message->CurrentValue = HtmlDecode($this->status_message->CurrentValue);
        }
        $this->status_message->EditValue = $this->status_message->CurrentValue;
        $this->status_message->PlaceHolder = RemoveHtml($this->status_message->caption());

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
        if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
        }

        // trans_date
        $this->trans_date->setupEditAttributes();
        if (!$this->trans_date->Raw) {
            $this->trans_date->CurrentValue = HtmlDecode($this->trans_date->CurrentValue);
        }
        $this->trans_date->EditValue = $this->trans_date->CurrentValue;
        $this->trans_date->PlaceHolder = RemoveHtml($this->trans_date->caption());

        // datetime

        // payment_gateway
        $this->payment_gateway->setupEditAttributes();
        if (!$this->payment_gateway->Raw) {
            $this->payment_gateway->CurrentValue = HtmlDecode($this->payment_gateway->CurrentValue);
        }
        $this->payment_gateway->EditValue = $this->payment_gateway->CurrentValue;
        $this->payment_gateway->PlaceHolder = RemoveHtml($this->payment_gateway->caption());

        // payment_signature
        $this->payment_signature->setupEditAttributes();
        if (!$this->payment_signature->Raw) {
            $this->payment_signature->CurrentValue = HtmlDecode($this->payment_signature->CurrentValue);
        }
        $this->payment_signature->EditValue = $this->payment_signature->CurrentValue;
        $this->payment_signature->PlaceHolder = RemoveHtml($this->payment_signature->caption());

        // currency_id
        $this->currency_id->setupEditAttributes();
        $this->currency_id->PlaceHolder = RemoveHtml($this->currency_id->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->_userid);
                    $doc->exportCaption($this->pg_order_number);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->cart_number);
                    $doc->exportCaption($this->order_id);
                    $doc->exportCaption($this->tracking_id);
                    $doc->exportCaption($this->bank_ref_no);
                    $doc->exportCaption($this->order_status);
                    $doc->exportCaption($this->failure_message);
                    $doc->exportCaption($this->payment_mode);
                    $doc->exportCaption($this->card_name);
                    $doc->exportCaption($this->status_code);
                    $doc->exportCaption($this->status_message);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->trans_date);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->payment_gateway);
                    $doc->exportCaption($this->payment_signature);
                    $doc->exportCaption($this->currency_id);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->_userid);
                    $doc->exportCaption($this->pg_order_number);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->cart_number);
                    $doc->exportCaption($this->order_id);
                    $doc->exportCaption($this->tracking_id);
                    $doc->exportCaption($this->bank_ref_no);
                    $doc->exportCaption($this->order_status);
                    $doc->exportCaption($this->failure_message);
                    $doc->exportCaption($this->payment_mode);
                    $doc->exportCaption($this->card_name);
                    $doc->exportCaption($this->status_code);
                    $doc->exportCaption($this->status_message);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->trans_date);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->payment_gateway);
                    $doc->exportCaption($this->payment_signature);
                    $doc->exportCaption($this->currency_id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->type);
                        $doc->exportField($this->status);
                        $doc->exportField($this->_userid);
                        $doc->exportField($this->pg_order_number);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->cart_number);
                        $doc->exportField($this->order_id);
                        $doc->exportField($this->tracking_id);
                        $doc->exportField($this->bank_ref_no);
                        $doc->exportField($this->order_status);
                        $doc->exportField($this->failure_message);
                        $doc->exportField($this->payment_mode);
                        $doc->exportField($this->card_name);
                        $doc->exportField($this->status_code);
                        $doc->exportField($this->status_message);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->trans_date);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->payment_gateway);
                        $doc->exportField($this->payment_signature);
                        $doc->exportField($this->currency_id);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->type);
                        $doc->exportField($this->status);
                        $doc->exportField($this->_userid);
                        $doc->exportField($this->pg_order_number);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->cart_number);
                        $doc->exportField($this->order_id);
                        $doc->exportField($this->tracking_id);
                        $doc->exportField($this->bank_ref_no);
                        $doc->exportField($this->order_status);
                        $doc->exportField($this->failure_message);
                        $doc->exportField($this->payment_mode);
                        $doc->exportField($this->card_name);
                        $doc->exportField($this->status_code);
                        $doc->exportField($this->status_message);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->trans_date);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->payment_gateway);
                        $doc->exportField($this->payment_signature);
                        $doc->exportField($this->currency_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
