<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PaymentPlanSearch extends PaymentPlan
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PaymentPlanSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "paymentplansearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->plan_type->setVisibility();
        $this->location->setVisibility();
        $this->from_date->setVisibility();
        $this->to_date->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->process->setVisibility();
        $this->product_type->setVisibility();
        $this->shape->setVisibility();
        $this->selection->setVisibility();
        $this->gcode->setVisibility();
        $this->ref->setVisibility();
        $this->description->setVisibility();
        $this->yes_no->setVisibility();
        $this->packing_payment_type->setVisibility();
        $this->fix->setVisibility();
        $this->method->setVisibility();
        $this->sqm_method->setVisibility();
        $this->unit->setVisibility();
        $this->_unit->setVisibility();
        $this->_40->setVisibility();
        $this->extra_plan->setVisibility();
        $this->custom_size->setVisibility();
        $this->custom_size_below_st->setVisibility();
        $this->status->setVisibility();
        $this->uploads->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'payment_plan';
        $this->TableName = 'payment_plan';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (payment_plan)
        if (!isset($GLOBALS["payment_plan"]) || $GLOBALS["payment_plan"]::class == PROJECT_NAMESPACE . "payment_plan") {
            $GLOBALS["payment_plan"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'payment_plan');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "paymentplanview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->plan_type);
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->selection);
        $this->setupLookupOptions($this->gcode);
        $this->setupLookupOptions($this->ref);
        $this->setupLookupOptions($this->yes_no);
        $this->setupLookupOptions($this->packing_payment_type);
        $this->setupLookupOptions($this->fix);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->sqm_method);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->extra_plan);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "paymentplanlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->plan_type); // plan_type
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->from_date); // from_date
        $this->buildSearchUrl($srchUrl, $this->to_date); // to_date
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
        $this->buildSearchUrl($srchUrl, $this->process); // process
        $this->buildSearchUrl($srchUrl, $this->product_type); // product_type
        $this->buildSearchUrl($srchUrl, $this->shape); // shape
        $this->buildSearchUrl($srchUrl, $this->selection); // selection
        $this->buildSearchUrl($srchUrl, $this->gcode); // gcode
        $this->buildSearchUrl($srchUrl, $this->ref); // ref
        $this->buildSearchUrl($srchUrl, $this->description); // description
        $this->buildSearchUrl($srchUrl, $this->yes_no); // yes_no
        $this->buildSearchUrl($srchUrl, $this->packing_payment_type); // packing_payment_type
        $this->buildSearchUrl($srchUrl, $this->fix); // fix
        $this->buildSearchUrl($srchUrl, $this->method); // method
        $this->buildSearchUrl($srchUrl, $this->sqm_method); // sqm_method
        $this->buildSearchUrl($srchUrl, $this->unit); // unit
        $this->buildSearchUrl($srchUrl, $this->_unit); // @_unit
        $this->buildSearchUrl($srchUrl, $this->_40); // @
        $this->buildSearchUrl($srchUrl, $this->extra_plan); // extra_plan
        $this->buildSearchUrl($srchUrl, $this->custom_size); // custom_size
        $this->buildSearchUrl($srchUrl, $this->custom_size_below_st); // custom_size_below_st
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->uploads); // uploads
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // plan_type
        if ($this->plan_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->location->AdvancedSearch->SearchValue)) {
            $this->location->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->location->AdvancedSearch->SearchValue);
        }
        if (is_array($this->location->AdvancedSearch->SearchValue2)) {
            $this->location->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->location->AdvancedSearch->SearchValue2);
        }

        // from_date
        if ($this->from_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // to_date
        if ($this->to_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process
        if ($this->process->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_type
        if ($this->product_type->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->product_type->AdvancedSearch->SearchValue)) {
            $this->product_type->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->product_type->AdvancedSearch->SearchValue);
        }
        if (is_array($this->product_type->AdvancedSearch->SearchValue2)) {
            $this->product_type->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->product_type->AdvancedSearch->SearchValue2);
        }

        // shape
        if ($this->shape->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->shape->AdvancedSearch->SearchValue)) {
            $this->shape->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->shape->AdvancedSearch->SearchValue);
        }
        if (is_array($this->shape->AdvancedSearch->SearchValue2)) {
            $this->shape->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->shape->AdvancedSearch->SearchValue2);
        }

        // selection
        if ($this->selection->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gcode
        if ($this->gcode->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->gcode->AdvancedSearch->SearchValue)) {
            $this->gcode->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->gcode->AdvancedSearch->SearchValue);
        }
        if (is_array($this->gcode->AdvancedSearch->SearchValue2)) {
            $this->gcode->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->gcode->AdvancedSearch->SearchValue2);
        }

        // ref
        if ($this->ref->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->ref->AdvancedSearch->SearchValue)) {
            $this->ref->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->ref->AdvancedSearch->SearchValue);
        }
        if (is_array($this->ref->AdvancedSearch->SearchValue2)) {
            $this->ref->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->ref->AdvancedSearch->SearchValue2);
        }

        // description
        if ($this->description->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // yes_no
        if ($this->yes_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_payment_type
        if ($this->packing_payment_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // fix
        if ($this->fix->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // method
        if ($this->method->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm_method
        if ($this->sqm_method->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // unit
        if ($this->unit->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // @_unit
        if ($this->_unit->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // @
        if ($this->_40->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // extra_plan
        if ($this->extra_plan->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // custom_size
        if ($this->custom_size->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // custom_size_below_st
        if ($this->custom_size_below_st->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // uploads
        if ($this->uploads->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // plan_type
        $this->plan_type->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // from_date
        $this->from_date->RowCssClass = "row";

        // to_date
        $this->to_date->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // selection
        $this->selection->RowCssClass = "row";

        // gcode
        $this->gcode->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // yes_no
        $this->yes_no->RowCssClass = "row";

        // packing_payment_type
        $this->packing_payment_type->RowCssClass = "row";

        // fix
        $this->fix->RowCssClass = "row";

        // method
        $this->method->RowCssClass = "row";

        // sqm_method
        $this->sqm_method->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // @_unit
        $this->_unit->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // extra_plan
        $this->extra_plan->RowCssClass = "row";

        // custom_size
        $this->custom_size->RowCssClass = "row";

        // custom_size_below_st
        $this->custom_size_below_st->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // plan_type
            if (strval($this->plan_type->CurrentValue) != "") {
                $this->plan_type->ViewValue = $this->plan_type->optionCaption($this->plan_type->CurrentValue);
            } else {
                $this->plan_type->ViewValue = null;
            }

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->location->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->location->Lookup->renderViewRow($row);
                            $this->location->ViewValue->add($this->location->displayValue($arwrk));
                        }
                    } else {
                        $this->location->ViewValue = $this->location->CurrentValue;
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // from_date
            $this->from_date->ViewValue = $this->from_date->CurrentValue;
            $this->from_date->ViewValue = FormatDateTime($this->from_date->ViewValue, $this->from_date->formatPattern());

            // to_date
            $this->to_date->ViewValue = $this->to_date->CurrentValue;
            $this->to_date->ViewValue = FormatDateTime($this->to_date->ViewValue, $this->to_date->formatPattern());

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->product_type->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->product_type->Lookup->renderViewRow($row);
                            $this->product_type->ViewValue->add($this->product_type->displayValue($arwrk));
                        }
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->shape->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->shape->Lookup->renderViewRow($row);
                            $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                        }
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // selection
            if (strval($this->selection->CurrentValue) != "") {
                $this->selection->ViewValue = $this->selection->optionCaption($this->selection->CurrentValue);
            } else {
                $this->selection->ViewValue = null;
            }

            // gcode
            $curVal = strval($this->gcode->CurrentValue);
            if ($curVal != "") {
                $this->gcode->ViewValue = $this->gcode->lookupCacheOption($curVal);
                if ($this->gcode->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->gcode->Lookup->getTable()->Fields["gcode"]->searchExpression(), "=", trim($wrk), $this->gcode->Lookup->getTable()->Fields["gcode"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->gcode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->gcode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->gcode->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->gcode->Lookup->renderViewRow($row);
                            $this->gcode->ViewValue->add($this->gcode->displayValue($arwrk));
                        }
                    } else {
                        $this->gcode->ViewValue = $this->gcode->CurrentValue;
                    }
                }
            } else {
                $this->gcode->ViewValue = null;
            }

            // ref
            if ($this->ref->VirtualValue != "") {
                $this->ref->ViewValue = $this->ref->VirtualValue;
            } else {
                $curVal = strval($this->ref->CurrentValue);
                if ($curVal != "") {
                    $this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
                    if ($this->ref->ViewValue === null) { // Lookup from database
                        $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                        $filterWrk = "";
                        foreach ($arwrk as $wrk) {
                            AddFilter($filterWrk, SearchFilter($this->ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                        }
                        $sqlWrk = $this->ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $this->ref->ViewValue = new OptionValues();
                            foreach ($rswrk as $row) {
                                $arwrk = $this->ref->Lookup->renderViewRow($row);
                                $this->ref->ViewValue->add($this->ref->displayValue($arwrk));
                            }
                        } else {
                            $this->ref->ViewValue = $this->ref->CurrentValue;
                        }
                    }
                } else {
                    $this->ref->ViewValue = null;
                }
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // yes_no
            if (strval($this->yes_no->CurrentValue) != "") {
                $this->yes_no->ViewValue = $this->yes_no->optionCaption($this->yes_no->CurrentValue);
            } else {
                $this->yes_no->ViewValue = null;
            }

            // packing_payment_type
            if (strval($this->packing_payment_type->CurrentValue) != "") {
                $this->packing_payment_type->ViewValue = $this->packing_payment_type->optionCaption($this->packing_payment_type->CurrentValue);
            } else {
                $this->packing_payment_type->ViewValue = null;
            }

            // fix
            if (strval($this->fix->CurrentValue) != "") {
                $this->fix->ViewValue = $this->fix->optionCaption($this->fix->CurrentValue);
            } else {
                $this->fix->ViewValue = null;
            }

            // method
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->ViewValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->ViewValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->ViewValue = null;
            }

            // sqm_method
            if (strval($this->sqm_method->CurrentValue) != "") {
                $this->sqm_method->ViewValue = $this->sqm_method->optionCaption($this->sqm_method->CurrentValue);
            } else {
                $this->sqm_method->ViewValue = null;
            }

            // unit
            if (strval($this->unit->CurrentValue) != "") {
                $this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
            } else {
                $this->unit->ViewValue = null;
            }

            // @_unit
            $this->_unit->ViewValue = $this->_unit->CurrentValue;
            $this->_unit->ViewValue = FormatNumber($this->_unit->ViewValue, $this->_unit->formatPattern());

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // extra_plan
            if (strval($this->extra_plan->CurrentValue) != "") {
                $this->extra_plan->ViewValue = $this->extra_plan->optionCaption($this->extra_plan->CurrentValue);
            } else {
                $this->extra_plan->ViewValue = null;
            }

            // custom_size
            $this->custom_size->ViewValue = $this->custom_size->CurrentValue;
            $this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, $this->custom_size->formatPattern());

            // custom_size_below_st
            $this->custom_size_below_st->ViewValue = $this->custom_size_below_st->CurrentValue;
            $this->custom_size_below_st->ViewValue = FormatNumber($this->custom_size_below_st->ViewValue, $this->custom_size_below_st->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // plan_type
            if (!EmptyValue($this->plan_type->CurrentValue)) {
                $this->plan_type->HrefValue = $this->plan_type->getLinkPrefix() . $this->plan_type->CurrentValue; // Add prefix/suffix
                $this->plan_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
                }
            } else {
                $this->plan_type->HrefValue = "";
            }
            $this->plan_type->TooltipValue = "";

            // location
            if (!EmptyValue($this->location->CurrentValue)) {
                $this->location->HrefValue = $this->location->getLinkPrefix() . $this->location->CurrentValue; // Add prefix/suffix
                $this->location->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
                }
            } else {
                $this->location->HrefValue = "";
            }
            $this->location->TooltipValue = "";

            // from_date
            $this->from_date->HrefValue = "";
            $this->from_date->TooltipValue = "";

            // to_date
            $this->to_date->HrefValue = "";
            $this->to_date->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // selection
            $this->selection->HrefValue = "";
            $this->selection->TooltipValue = "";

            // gcode
            if (!EmptyValue($this->gcode->CurrentValue)) {
                $this->gcode->HrefValue = $this->gcode->getLinkPrefix() . $this->gcode->CurrentValue; // Add prefix/suffix
                $this->gcode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
                }
            } else {
                $this->gcode->HrefValue = "";
            }
            $this->gcode->TooltipValue = "";

            // ref
            if (!EmptyValue($this->gcode->CurrentValue)) {
                $this->ref->HrefValue = $this->ref->getLinkPrefix() . $this->gcode->CurrentValue; // Add prefix/suffix
                $this->ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
                }
            } else {
                $this->ref->HrefValue = "";
            }
            $this->ref->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";

            // yes_no
            $this->yes_no->HrefValue = "";
            $this->yes_no->TooltipValue = "";

            // packing_payment_type
            $this->packing_payment_type->HrefValue = "";
            $this->packing_payment_type->TooltipValue = "";

            // fix
            $this->fix->HrefValue = "";
            $this->fix->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // sqm_method
            $this->sqm_method->HrefValue = "";
            $this->sqm_method->TooltipValue = "";

            // unit
            $this->unit->HrefValue = "";
            $this->unit->TooltipValue = "";

            // @_unit
            $this->_unit->HrefValue = "";
            $this->_unit->TooltipValue = "";

            // @
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // extra_plan
            $this->extra_plan->HrefValue = "";
            $this->extra_plan->TooltipValue = "";

            // custom_size
            $this->custom_size->HrefValue = "";
            $this->custom_size->TooltipValue = "";

            // custom_size_below_st
            $this->custom_size_below_st->HrefValue = "";
            $this->custom_size_below_st->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
            $this->uploads->TooltipValue = "";
            if ($this->uploads->UseColorbox) {
                if (EmptyValue($this->uploads->TooltipValue)) {
                    $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->uploads->LinkAttrs["data-rel"] = "payment_plan_x_uploads";
                $this->uploads->LinkAttrs->appendClass("ew-lightbox");
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // plan_type
            $this->plan_type->setupEditAttributes();
            $this->plan_type->EditValue = $this->plan_type->options(true);
            $this->plan_type->PlaceHolder = RemoveHtml($this->plan_type->caption());

            // location
            $curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
                if ($this->location->AdvancedSearch->ViewValue == "") {
                    $this->location->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->location->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->location->Lookup->renderViewRow($row);
                        $this->location->AdvancedSearch->ViewValue->add($this->location->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->location->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // from_date
            $this->from_date->setupEditAttributes();
            $this->from_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->from_date->AdvancedSearch->SearchValue, $this->from_date->formatPattern()), $this->from_date->formatPattern()));
            $this->from_date->PlaceHolder = RemoveHtml($this->from_date->caption());

            // to_date
            $this->to_date->setupEditAttributes();
            $this->to_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->to_date->AdvancedSearch->SearchValue, $this->to_date->formatPattern()), $this->to_date->formatPattern()));
            $this->to_date->PlaceHolder = RemoveHtml($this->to_date->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->AdvancedSearch->SearchValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->AdvancedSearch->SearchValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // product_type
            $curVal = trim(strval($this->product_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product_type->AdvancedSearch->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->AdvancedSearch->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());
            $curVal = trim(strval($this->product_type->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->product_type->AdvancedSearch->ViewValue2 = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->AdvancedSearch->ViewValue2 = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->product_type->EditValue2 = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue2 = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // shape
            $curVal = trim(strval($this->shape->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->shape->AdvancedSearch->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->AdvancedSearch->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // selection
            $this->selection->setupEditAttributes();
            $this->selection->EditValue = $this->selection->options(true);
            $this->selection->PlaceHolder = RemoveHtml($this->selection->caption());

            // gcode
            $curVal = trim(strval($this->gcode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->gcode->AdvancedSearch->ViewValue = $this->gcode->lookupCacheOption($curVal);
            } else {
                $this->gcode->AdvancedSearch->ViewValue = $this->gcode->Lookup !== null && is_array($this->gcode->lookupOptions()) && count($this->gcode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->gcode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->gcode->EditValue = array_values($this->gcode->lookupOptions());
                if ($this->gcode->AdvancedSearch->ViewValue == "") {
                    $this->gcode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->gcode->Lookup->getTable()->Fields["gcode"]->searchExpression(), "=", trim($wrk), $this->gcode->Lookup->getTable()->Fields["gcode"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->gcode->getSelectFilter($this); // PHP
                $sqlWrk = $this->gcode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->gcode->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->gcode->Lookup->renderViewRow($row);
                        $this->gcode->AdvancedSearch->ViewValue->add($this->gcode->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->gcode->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->gcode->EditValue = $arwrk;
            }
            $this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

            // ref
            $this->ref->setupEditAttributes();
            if (!$this->ref->Raw) {
                $this->ref->AdvancedSearch->SearchValue = HtmlDecode($this->ref->AdvancedSearch->SearchValue);
            }
            $this->ref->EditValue = HtmlEncode($this->ref->AdvancedSearch->SearchValue);
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->AdvancedSearch->SearchValue = HtmlDecode($this->description->AdvancedSearch->SearchValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // yes_no
            $this->yes_no->setupEditAttributes();
            $this->yes_no->EditValue = $this->yes_no->options(true);
            $this->yes_no->PlaceHolder = RemoveHtml($this->yes_no->caption());

            // packing_payment_type
            $this->packing_payment_type->setupEditAttributes();
            $this->packing_payment_type->EditValue = $this->packing_payment_type->options(true);
            $this->packing_payment_type->PlaceHolder = RemoveHtml($this->packing_payment_type->caption());

            // fix
            $this->fix->setupEditAttributes();
            $this->fix->EditValue = $this->fix->options(true);
            $this->fix->PlaceHolder = RemoveHtml($this->fix->caption());

            // method
            $this->method->setupEditAttributes();
            $curVal = trim(strval($this->method->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->method->AdvancedSearch->ViewValue = $this->method->lookupCacheOption($curVal);
            } else {
                $this->method->AdvancedSearch->ViewValue = $this->method->Lookup !== null && is_array($this->method->lookupOptions()) && count($this->method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->method->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->method->EditValue = array_values($this->method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->method->AdvancedSearch->SearchValue, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->method->EditValue = $arwrk;
            }
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // sqm_method
            $this->sqm_method->setupEditAttributes();
            $this->sqm_method->EditValue = $this->sqm_method->options(true);
            $this->sqm_method->PlaceHolder = RemoveHtml($this->sqm_method->caption());

            // unit
            $this->unit->setupEditAttributes();
            $this->unit->EditValue = $this->unit->options(true);
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // @_unit
            $this->_unit->setupEditAttributes();
            $this->_unit->EditValue = $this->_unit->AdvancedSearch->SearchValue;
            $this->_unit->PlaceHolder = RemoveHtml($this->_unit->caption());

            // @
            $this->_40->setupEditAttributes();
            $this->_40->EditValue = $this->_40->AdvancedSearch->SearchValue;
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

            // extra_plan
            $this->extra_plan->setupEditAttributes();
            $this->extra_plan->EditValue = $this->extra_plan->options(true);
            $this->extra_plan->PlaceHolder = RemoveHtml($this->extra_plan->caption());

            // custom_size
            $this->custom_size->setupEditAttributes();
            $this->custom_size->EditValue = $this->custom_size->AdvancedSearch->SearchValue;
            $this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());

            // custom_size_below_st
            $this->custom_size_below_st->setupEditAttributes();
            $this->custom_size_below_st->EditValue = $this->custom_size_below_st->AdvancedSearch->SearchValue;
            $this->custom_size_below_st->PlaceHolder = RemoveHtml($this->custom_size_below_st->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            if (!$this->uploads->Raw) {
                $this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
            }
            $this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
            $this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckDate($this->from_date->AdvancedSearch->SearchValue, $this->from_date->formatPattern())) {
            $this->from_date->addErrorMessage($this->from_date->getErrorMessage(false));
        }
        if (!CheckDate($this->to_date->AdvancedSearch->SearchValue, $this->to_date->formatPattern())) {
            $this->to_date->addErrorMessage($this->to_date->getErrorMessage(false));
        }
        if (!CheckNumber($this->_unit->AdvancedSearch->SearchValue)) {
            $this->_unit->addErrorMessage($this->_unit->getErrorMessage(false));
        }
        if (!CheckNumber($this->_40->AdvancedSearch->SearchValue)) {
            $this->_40->addErrorMessage($this->_40->getErrorMessage(false));
        }
        if (!CheckNumber($this->custom_size->AdvancedSearch->SearchValue)) {
            $this->custom_size->addErrorMessage($this->custom_size->getErrorMessage(false));
        }
        if (!CheckNumber($this->custom_size_below_st->AdvancedSearch->SearchValue)) {
            $this->custom_size_below_st->addErrorMessage($this->custom_size_below_st->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->plan_type->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->from_date->AdvancedSearch->load();
        $this->to_date->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->process->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->shape->AdvancedSearch->load();
        $this->selection->AdvancedSearch->load();
        $this->gcode->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->yes_no->AdvancedSearch->load();
        $this->packing_payment_type->AdvancedSearch->load();
        $this->fix->AdvancedSearch->load();
        $this->method->AdvancedSearch->load();
        $this->sqm_method->AdvancedSearch->load();
        $this->unit->AdvancedSearch->load();
        $this->_unit->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->extra_plan->AdvancedSearch->load();
        $this->custom_size->AdvancedSearch->load();
        $this->custom_size_below_st->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->uploads->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("paymentplanlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_plan_type":
                    break;
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_selection":
                    break;
                case "x_gcode":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_ref":
                    break;
                case "x_yes_no":
                    break;
                case "x_packing_payment_type":
                    break;
                case "x_fix":
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_sqm_method":
                    break;
                case "x_unit":
                    break;
                case "x_extra_plan":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
