<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PaymentPlanMaterialDelete extends PaymentPlanMaterial
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PaymentPlanMaterialDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "paymentplanmaterialdelete";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->type->setVisibility();
        $this->description->setVisibility();
        $this->from_date->setVisibility();
        $this->to_date->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->varient->Visible = false;
        $this->varient_ref->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->process->setVisibility();
        $this->yes_no->setVisibility();
        $this->method->setVisibility();
        $this->process_method->setVisibility();
        $this->input_type->setVisibility();
        $this->output_type->setVisibility();
        $this->ply->setVisibility();
        $this->_40->setVisibility();
        $this->status->setVisibility();
        $this->uploads->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'payment_plan_material';
        $this->TableName = 'payment_plan_material';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (payment_plan_material)
        if (!isset($GLOBALS["payment_plan_material"]) || $GLOBALS["payment_plan_material"]::class == PROJECT_NAMESPACE . "payment_plan_material") {
            $GLOBALS["payment_plan_material"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'payment_plan_material');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->varient);
        $this->setupLookupOptions($this->varient_ref);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->yes_no);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->process_method);
        $this->setupLookupOptions($this->input_type);
        $this->setupLookupOptions($this->output_type);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("paymentplanmateriallist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("paymentplanmateriallist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->type->setDbValue($row['type']);
        $this->description->setDbValue($row['description']);
        $this->from_date->setDbValue($row['from_date']);
        $this->to_date->setDbValue($row['to_date']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->varient->setDbValue($row['varient']);
        $this->varient_ref->setDbValue($row['varient_ref']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->process->setDbValue($row['process']);
        $this->yes_no->setDbValue($row['yes_no']);
        $this->method->setDbValue($row['method']);
        $this->process_method->setDbValue($row['process_method']);
        $this->input_type->setDbValue($row['input_type']);
        $this->output_type->setDbValue($row['output_type']);
        $this->ply->setDbValue($row['ply']);
        $this->_40->setDbValue($row['@']);
        $this->status->setDbValue($row['status']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['from_date'] = $this->from_date->DefaultValue;
        $row['to_date'] = $this->to_date->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['varient'] = $this->varient->DefaultValue;
        $row['varient_ref'] = $this->varient_ref->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['yes_no'] = $this->yes_no->DefaultValue;
        $row['method'] = $this->method->DefaultValue;
        $row['process_method'] = $this->process_method->DefaultValue;
        $row['input_type'] = $this->input_type->DefaultValue;
        $row['output_type'] = $this->output_type->DefaultValue;
        $row['ply'] = $this->ply->DefaultValue;
        $row['@'] = $this->_40->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // location

        // type

        // description

        // from_date

        // to_date

        // grp

        // s_grp

        // varient

        // varient_ref

        // product

        // rid

        // process

        // yes_no

        // method

        // process_method

        // input_type

        // output_type

        // ply

        // @

        // status

        // uploads

        // operator

        // datetime

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->location->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->location->Lookup->renderViewRow($row);
                            $this->location->ViewValue->add($this->location->displayValue($arwrk));
                        }
                    } else {
                        $this->location->ViewValue = $this->location->CurrentValue;
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // from_date
            $this->from_date->ViewValue = $this->from_date->CurrentValue;
            $this->from_date->ViewValue = FormatDateTime($this->from_date->ViewValue, $this->from_date->formatPattern());

            // to_date
            $this->to_date->ViewValue = $this->to_date->CurrentValue;
            $this->to_date->ViewValue = FormatDateTime($this->to_date->ViewValue, $this->to_date->formatPattern());

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->s_grp->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->s_grp->Lookup->renderViewRow($row);
                            $this->s_grp->ViewValue->add($this->s_grp->displayValue($arwrk));
                        }
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // varient
            $curVal = strval($this->varient->CurrentValue);
            if ($curVal != "") {
                $this->varient->ViewValue = $this->varient->lookupCacheOption($curVal);
                if ($this->varient->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->varient->Lookup->getTable()->Fields["no"]->searchExpression(), "=", $curVal, $this->varient->Lookup->getTable()->Fields["no"]->searchDataType(), "");
                    $lookupFilter = $this->varient->getSelectFilter($this); // PHP
                    $sqlWrk = $this->varient->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->varient->Lookup->renderViewRow($rswrk[0]);
                        $this->varient->ViewValue = $this->varient->displayValue($arwrk);
                    } else {
                        $this->varient->ViewValue = FormatNumber($this->varient->CurrentValue, $this->varient->formatPattern());
                    }
                }
            } else {
                $this->varient->ViewValue = null;
            }

            // varient_ref
            $curVal = strval($this->varient_ref->CurrentValue);
            if ($curVal != "") {
                $this->varient_ref->ViewValue = $this->varient_ref->lookupCacheOption($curVal);
                if ($this->varient_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->varient_ref->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->varient_ref->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->varient_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->varient_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->varient_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->varient_ref->Lookup->renderViewRow($row);
                            $this->varient_ref->ViewValue->add($this->varient_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->varient_ref->ViewValue = $this->varient_ref->CurrentValue;
                    }
                }
            } else {
                $this->varient_ref->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->product->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->product->Lookup->renderViewRow($row);
                            $this->product->ViewValue->add($this->product->displayValue($arwrk));
                        }
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->rid->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->rid->Lookup->renderViewRow($row);
                            $this->rid->ViewValue->add($this->rid->displayValue($arwrk));
                        }
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = FormatNumber($this->process->CurrentValue, $this->process->formatPattern());
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // yes_no
            if (strval($this->yes_no->CurrentValue) != "") {
                $this->yes_no->ViewValue = $this->yes_no->optionCaption($this->yes_no->CurrentValue);
            } else {
                $this->yes_no->ViewValue = null;
            }

            // method
            if (strval($this->method->CurrentValue) != "") {
                $this->method->ViewValue = $this->method->optionCaption($this->method->CurrentValue);
            } else {
                $this->method->ViewValue = null;
            }

            // process_method
            if (strval($this->process_method->CurrentValue) != "") {
                $this->process_method->ViewValue = $this->process_method->optionCaption($this->process_method->CurrentValue);
            } else {
                $this->process_method->ViewValue = null;
            }

            // input_type
            $curVal = strval($this->input_type->CurrentValue);
            if ($curVal != "") {
                $this->input_type->ViewValue = $this->input_type->lookupCacheOption($curVal);
                if ($this->input_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->input_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->input_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->input_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->input_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->input_type->Lookup->renderViewRow($rswrk[0]);
                        $this->input_type->ViewValue = $this->input_type->displayValue($arwrk);
                    } else {
                        $this->input_type->ViewValue = FormatNumber($this->input_type->CurrentValue, $this->input_type->formatPattern());
                    }
                }
            } else {
                $this->input_type->ViewValue = null;
            }

            // output_type
            $curVal = strval($this->output_type->CurrentValue);
            if ($curVal != "") {
                $this->output_type->ViewValue = $this->output_type->lookupCacheOption($curVal);
                if ($this->output_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->output_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->output_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->output_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->output_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->output_type->Lookup->renderViewRow($rswrk[0]);
                        $this->output_type->ViewValue = $this->output_type->displayValue($arwrk);
                    } else {
                        $this->output_type->ViewValue = FormatNumber($this->output_type->CurrentValue, $this->output_type->formatPattern());
                    }
                }
            } else {
                $this->output_type->ViewValue = null;
            }

            // ply
            $this->ply->ViewValue = $this->ply->CurrentValue;
            $this->ply->ViewValue = FormatNumber($this->ply->ViewValue, $this->ply->formatPattern());

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // type
            if (!EmptyValue($this->type->CurrentValue)) {
                $this->type->HrefValue = $this->type->getLinkPrefix() . $this->type->CurrentValue; // Add prefix/suffix
                $this->type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
                }
            } else {
                $this->type->HrefValue = "";
            }
            $this->type->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";

            // from_date
            $this->from_date->HrefValue = "";
            $this->from_date->TooltipValue = "";

            // to_date
            $this->to_date->HrefValue = "";
            $this->to_date->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // varient_ref
            $this->varient_ref->HrefValue = "";
            $this->varient_ref->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // rid
            $this->rid->HrefValue = "";
            $this->rid->TooltipValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }
            $this->process->TooltipValue = "";

            // yes_no
            $this->yes_no->HrefValue = "";
            $this->yes_no->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // process_method
            $this->process_method->HrefValue = "";
            $this->process_method->TooltipValue = "";

            // input_type
            $this->input_type->HrefValue = "";
            $this->input_type->TooltipValue = "";

            // output_type
            $this->output_type->HrefValue = "";
            $this->output_type->TooltipValue = "";

            // ply
            $this->ply->HrefValue = "";
            $this->ply->TooltipValue = "";

            // @
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
            $this->uploads->TooltipValue = "";
            if ($this->uploads->UseColorbox) {
                if (EmptyValue($this->uploads->TooltipValue)) {
                    $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->uploads->LinkAttrs["data-rel"] = "payment_plan_material_x" . $this->RowCount . "_uploads";
                $this->uploads->LinkAttrs->appendClass("ew-lightbox");
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("paymentplanmateriallist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_type":
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_varient":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_varient_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_yes_no":
                    break;
                case "x_method":
                    break;
                case "x_process_method":
                    break;
                case "x_input_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_output_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
