<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PaymentPlanAdd extends PaymentPlan
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PaymentPlanAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "paymentplanadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->plan_type->setVisibility();
        $this->location->setVisibility();
        $this->from_date->setVisibility();
        $this->to_date->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->process->setVisibility();
        $this->product_type->setVisibility();
        $this->shape->setVisibility();
        $this->selection->setVisibility();
        $this->gcode->setVisibility();
        $this->ref->setVisibility();
        $this->description->setVisibility();
        $this->yes_no->setVisibility();
        $this->packing_payment_type->setVisibility();
        $this->fix->setVisibility();
        $this->method->setVisibility();
        $this->sqm_method->setVisibility();
        $this->unit->setVisibility();
        $this->_unit->setVisibility();
        $this->_40->setVisibility();
        $this->extra_plan->setVisibility();
        $this->custom_size->setVisibility();
        $this->custom_size_below_st->setVisibility();
        $this->status->setVisibility();
        $this->uploads->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'payment_plan';
        $this->TableName = 'payment_plan';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (payment_plan)
        if (!isset($GLOBALS["payment_plan"]) || $GLOBALS["payment_plan"]::class == PROJECT_NAMESPACE . "payment_plan") {
            $GLOBALS["payment_plan"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'payment_plan');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "paymentplanview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->plan_type);
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->process);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->selection);
        $this->setupLookupOptions($this->gcode);
        $this->setupLookupOptions($this->ref);
        $this->setupLookupOptions($this->yes_no);
        $this->setupLookupOptions($this->packing_payment_type);
        $this->setupLookupOptions($this->fix);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->sqm_method);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->extra_plan);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("paymentplanlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "paymentplanlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "paymentplanview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "paymentplanlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "paymentplanlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->plan_type->DefaultValue = $this->plan_type->getDefault(); // PHP
        $this->plan_type->OldValue = $this->plan_type->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
        $this->selection->DefaultValue = $this->selection->getDefault(); // PHP
        $this->selection->OldValue = $this->selection->DefaultValue;
        $this->gcode->DefaultValue = $this->gcode->getDefault(); // PHP
        $this->gcode->OldValue = $this->gcode->DefaultValue;
        $this->ref->DefaultValue = $this->ref->getDefault(); // PHP
        $this->ref->OldValue = $this->ref->DefaultValue;
        $this->packing_payment_type->DefaultValue = $this->packing_payment_type->getDefault(); // PHP
        $this->packing_payment_type->OldValue = $this->packing_payment_type->DefaultValue;
        $this->fix->DefaultValue = $this->fix->getDefault(); // PHP
        $this->fix->OldValue = $this->fix->DefaultValue;
        $this->sqm_method->DefaultValue = $this->sqm_method->getDefault(); // PHP
        $this->sqm_method->OldValue = $this->sqm_method->DefaultValue;
        $this->unit->DefaultValue = $this->unit->getDefault(); // PHP
        $this->unit->OldValue = $this->unit->DefaultValue;
        $this->_unit->DefaultValue = $this->_unit->getDefault(); // PHP
        $this->_unit->OldValue = $this->_unit->DefaultValue;
        $this->_40->DefaultValue = $this->_40->getDefault(); // PHP
        $this->_40->OldValue = $this->_40->DefaultValue;
        $this->custom_size->DefaultValue = $this->custom_size->getDefault(); // PHP
        $this->custom_size->OldValue = $this->custom_size->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'plan_type' first before field var 'x_plan_type'
        $val = $CurrentForm->hasValue("plan_type") ? $CurrentForm->getValue("plan_type") : $CurrentForm->getValue("x_plan_type");
        if (!$this->plan_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->plan_type->Visible = false; // Disable update for API request
            } else {
                $this->plan_type->setFormValue($val);
            }
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }

        // Check field name 'from_date' first before field var 'x_from_date'
        $val = $CurrentForm->hasValue("from_date") ? $CurrentForm->getValue("from_date") : $CurrentForm->getValue("x_from_date");
        if (!$this->from_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->from_date->Visible = false; // Disable update for API request
            } else {
                $this->from_date->setFormValue($val, true, $validate);
            }
            $this->from_date->CurrentValue = UnFormatDateTime($this->from_date->CurrentValue, $this->from_date->formatPattern());
        }

        // Check field name 'to_date' first before field var 'x_to_date'
        $val = $CurrentForm->hasValue("to_date") ? $CurrentForm->getValue("to_date") : $CurrentForm->getValue("x_to_date");
        if (!$this->to_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->to_date->Visible = false; // Disable update for API request
            } else {
                $this->to_date->setFormValue($val, true, $validate);
            }
            $this->to_date->CurrentValue = UnFormatDateTime($this->to_date->CurrentValue, $this->to_date->formatPattern());
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'process' first before field var 'x_process'
        $val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
        if (!$this->process->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->process->Visible = false; // Disable update for API request
            } else {
                $this->process->setFormValue($val);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }

        // Check field name 'shape' first before field var 'x_shape'
        $val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
        if (!$this->shape->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shape->Visible = false; // Disable update for API request
            } else {
                $this->shape->setFormValue($val);
            }
        }

        // Check field name 'selection' first before field var 'x_selection'
        $val = $CurrentForm->hasValue("selection") ? $CurrentForm->getValue("selection") : $CurrentForm->getValue("x_selection");
        if (!$this->selection->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->selection->Visible = false; // Disable update for API request
            } else {
                $this->selection->setFormValue($val);
            }
        }

        // Check field name 'gcode' first before field var 'x_gcode'
        $val = $CurrentForm->hasValue("gcode") ? $CurrentForm->getValue("gcode") : $CurrentForm->getValue("x_gcode");
        if (!$this->gcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gcode->Visible = false; // Disable update for API request
            } else {
                $this->gcode->setFormValue($val);
            }
        }

        // Check field name 'ref' first before field var 'x_ref'
        $val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
        if (!$this->ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ref->Visible = false; // Disable update for API request
            } else {
                $this->ref->setFormValue($val);
            }
        }

        // Check field name 'description' first before field var 'x_description'
        $val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
        if (!$this->description->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description->Visible = false; // Disable update for API request
            } else {
                $this->description->setFormValue($val);
            }
        }

        // Check field name 'yes_no' first before field var 'x_yes_no'
        $val = $CurrentForm->hasValue("yes_no") ? $CurrentForm->getValue("yes_no") : $CurrentForm->getValue("x_yes_no");
        if (!$this->yes_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->yes_no->Visible = false; // Disable update for API request
            } else {
                $this->yes_no->setFormValue($val);
            }
        }

        // Check field name 'packing_payment_type' first before field var 'x_packing_payment_type'
        $val = $CurrentForm->hasValue("packing_payment_type") ? $CurrentForm->getValue("packing_payment_type") : $CurrentForm->getValue("x_packing_payment_type");
        if (!$this->packing_payment_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_payment_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_payment_type->setFormValue($val);
            }
        }

        // Check field name 'fix' first before field var 'x_fix'
        $val = $CurrentForm->hasValue("fix") ? $CurrentForm->getValue("fix") : $CurrentForm->getValue("x_fix");
        if (!$this->fix->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fix->Visible = false; // Disable update for API request
            } else {
                $this->fix->setFormValue($val);
            }
        }

        // Check field name 'method' first before field var 'x_method'
        $val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
        if (!$this->method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->method->Visible = false; // Disable update for API request
            } else {
                $this->method->setFormValue($val);
            }
        }

        // Check field name 'sqm_method' first before field var 'x_sqm_method'
        $val = $CurrentForm->hasValue("sqm_method") ? $CurrentForm->getValue("sqm_method") : $CurrentForm->getValue("x_sqm_method");
        if (!$this->sqm_method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm_method->Visible = false; // Disable update for API request
            } else {
                $this->sqm_method->setFormValue($val);
            }
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }

        // Check field name '@_unit' first before field var 'x__unit'
        $val = $CurrentForm->hasValue("@_unit") ? $CurrentForm->getValue("@_unit") : $CurrentForm->getValue("x__unit");
        if (!$this->_unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_unit->Visible = false; // Disable update for API request
            } else {
                $this->_unit->setFormValue($val, true, $validate);
            }
        }

        // Check field name '@' first before field var 'x__40'
        $val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
        if (!$this->_40->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_40->Visible = false; // Disable update for API request
            } else {
                $this->_40->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'extra_plan' first before field var 'x_extra_plan'
        $val = $CurrentForm->hasValue("extra_plan") ? $CurrentForm->getValue("extra_plan") : $CurrentForm->getValue("x_extra_plan");
        if (!$this->extra_plan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->extra_plan->Visible = false; // Disable update for API request
            } else {
                $this->extra_plan->setFormValue($val);
            }
        }

        // Check field name 'custom_size' first before field var 'x_custom_size'
        $val = $CurrentForm->hasValue("custom_size") ? $CurrentForm->getValue("custom_size") : $CurrentForm->getValue("x_custom_size");
        if (!$this->custom_size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->custom_size->Visible = false; // Disable update for API request
            } else {
                $this->custom_size->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'custom_size_below_st' first before field var 'x_custom_size_below_st'
        $val = $CurrentForm->hasValue("custom_size_below_st") ? $CurrentForm->getValue("custom_size_below_st") : $CurrentForm->getValue("x_custom_size_below_st");
        if (!$this->custom_size_below_st->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->custom_size_below_st->Visible = false; // Disable update for API request
            } else {
                $this->custom_size_below_st->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->plan_type->CurrentValue = $this->plan_type->FormValue;
        $this->location->CurrentValue = $this->location->FormValue;
        $this->from_date->CurrentValue = $this->from_date->FormValue;
        $this->from_date->CurrentValue = UnFormatDateTime($this->from_date->CurrentValue, $this->from_date->formatPattern());
        $this->to_date->CurrentValue = $this->to_date->FormValue;
        $this->to_date->CurrentValue = UnFormatDateTime($this->to_date->CurrentValue, $this->to_date->formatPattern());
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->process->CurrentValue = $this->process->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->shape->CurrentValue = $this->shape->FormValue;
        $this->selection->CurrentValue = $this->selection->FormValue;
        $this->gcode->CurrentValue = $this->gcode->FormValue;
        $this->ref->CurrentValue = $this->ref->FormValue;
        $this->description->CurrentValue = $this->description->FormValue;
        $this->yes_no->CurrentValue = $this->yes_no->FormValue;
        $this->packing_payment_type->CurrentValue = $this->packing_payment_type->FormValue;
        $this->fix->CurrentValue = $this->fix->FormValue;
        $this->method->CurrentValue = $this->method->FormValue;
        $this->sqm_method->CurrentValue = $this->sqm_method->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->_unit->CurrentValue = $this->_unit->FormValue;
        $this->_40->CurrentValue = $this->_40->FormValue;
        $this->extra_plan->CurrentValue = $this->extra_plan->FormValue;
        $this->custom_size->CurrentValue = $this->custom_size->FormValue;
        $this->custom_size_below_st->CurrentValue = $this->custom_size_below_st->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->plan_type->setDbValue($row['plan_type']);
        $this->location->setDbValue($row['location']);
        $this->from_date->setDbValue($row['from_date']);
        $this->to_date->setDbValue($row['to_date']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->process->setDbValue($row['process']);
        $this->product_type->setDbValue($row['product_type']);
        $this->shape->setDbValue($row['shape']);
        $this->selection->setDbValue($row['selection']);
        $this->gcode->setDbValue($row['gcode']);
        $this->ref->setDbValue($row['ref']);
        if (array_key_exists('EV__ref', $row)) {
            $this->ref->VirtualValue = $row['EV__ref']; // Set up virtual field value
        } else {
            $this->ref->VirtualValue = ""; // Clear value
        }
        $this->description->setDbValue($row['description']);
        $this->yes_no->setDbValue($row['yes_no']);
        $this->packing_payment_type->setDbValue($row['packing_payment_type']);
        $this->fix->setDbValue($row['fix']);
        $this->method->setDbValue($row['method']);
        $this->sqm_method->setDbValue($row['sqm_method']);
        $this->unit->setDbValue($row['unit']);
        $this->_unit->setDbValue($row['@_unit']);
        $this->_40->setDbValue($row['@']);
        $this->extra_plan->setDbValue($row['extra_plan']);
        $this->custom_size->setDbValue($row['custom_size']);
        $this->custom_size_below_st->setDbValue($row['custom_size_below_st']);
        $this->status->setDbValue($row['status']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['plan_type'] = $this->plan_type->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['from_date'] = $this->from_date->DefaultValue;
        $row['to_date'] = $this->to_date->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['process'] = $this->process->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['selection'] = $this->selection->DefaultValue;
        $row['gcode'] = $this->gcode->DefaultValue;
        $row['ref'] = $this->ref->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['yes_no'] = $this->yes_no->DefaultValue;
        $row['packing_payment_type'] = $this->packing_payment_type->DefaultValue;
        $row['fix'] = $this->fix->DefaultValue;
        $row['method'] = $this->method->DefaultValue;
        $row['sqm_method'] = $this->sqm_method->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['@_unit'] = $this->_unit->DefaultValue;
        $row['@'] = $this->_40->DefaultValue;
        $row['extra_plan'] = $this->extra_plan->DefaultValue;
        $row['custom_size'] = $this->custom_size->DefaultValue;
        $row['custom_size_below_st'] = $this->custom_size_below_st->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // plan_type
        $this->plan_type->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // from_date
        $this->from_date->RowCssClass = "row";

        // to_date
        $this->to_date->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // selection
        $this->selection->RowCssClass = "row";

        // gcode
        $this->gcode->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // yes_no
        $this->yes_no->RowCssClass = "row";

        // packing_payment_type
        $this->packing_payment_type->RowCssClass = "row";

        // fix
        $this->fix->RowCssClass = "row";

        // method
        $this->method->RowCssClass = "row";

        // sqm_method
        $this->sqm_method->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // @_unit
        $this->_unit->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // extra_plan
        $this->extra_plan->RowCssClass = "row";

        // custom_size
        $this->custom_size->RowCssClass = "row";

        // custom_size_below_st
        $this->custom_size_below_st->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // plan_type
            if (strval($this->plan_type->CurrentValue) != "") {
                $this->plan_type->ViewValue = $this->plan_type->optionCaption($this->plan_type->CurrentValue);
            } else {
                $this->plan_type->ViewValue = null;
            }

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->location->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->location->Lookup->renderViewRow($row);
                            $this->location->ViewValue->add($this->location->displayValue($arwrk));
                        }
                    } else {
                        $this->location->ViewValue = $this->location->CurrentValue;
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // from_date
            $this->from_date->ViewValue = $this->from_date->CurrentValue;
            $this->from_date->ViewValue = FormatDateTime($this->from_date->ViewValue, $this->from_date->formatPattern());

            // to_date
            $this->to_date->ViewValue = $this->to_date->CurrentValue;
            $this->to_date->ViewValue = FormatDateTime($this->to_date->ViewValue, $this->to_date->formatPattern());

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // process
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->process->getSelectFilter($this); // PHP
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                        $this->process->ViewValue = $this->process->displayValue($arwrk);
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->product_type->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->product_type->Lookup->renderViewRow($row);
                            $this->product_type->ViewValue->add($this->product_type->displayValue($arwrk));
                        }
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->shape->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->shape->Lookup->renderViewRow($row);
                            $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                        }
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // selection
            if (strval($this->selection->CurrentValue) != "") {
                $this->selection->ViewValue = $this->selection->optionCaption($this->selection->CurrentValue);
            } else {
                $this->selection->ViewValue = null;
            }

            // gcode
            $curVal = strval($this->gcode->CurrentValue);
            if ($curVal != "") {
                $this->gcode->ViewValue = $this->gcode->lookupCacheOption($curVal);
                if ($this->gcode->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->gcode->Lookup->getTable()->Fields["gcode"]->searchExpression(), "=", trim($wrk), $this->gcode->Lookup->getTable()->Fields["gcode"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->gcode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->gcode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->gcode->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->gcode->Lookup->renderViewRow($row);
                            $this->gcode->ViewValue->add($this->gcode->displayValue($arwrk));
                        }
                    } else {
                        $this->gcode->ViewValue = $this->gcode->CurrentValue;
                    }
                }
            } else {
                $this->gcode->ViewValue = null;
            }

            // ref
            if ($this->ref->VirtualValue != "") {
                $this->ref->ViewValue = $this->ref->VirtualValue;
            } else {
                $curVal = strval($this->ref->CurrentValue);
                if ($curVal != "") {
                    $this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
                    if ($this->ref->ViewValue === null) { // Lookup from database
                        $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                        $filterWrk = "";
                        foreach ($arwrk as $wrk) {
                            AddFilter($filterWrk, SearchFilter($this->ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                        }
                        $sqlWrk = $this->ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $this->ref->ViewValue = new OptionValues();
                            foreach ($rswrk as $row) {
                                $arwrk = $this->ref->Lookup->renderViewRow($row);
                                $this->ref->ViewValue->add($this->ref->displayValue($arwrk));
                            }
                        } else {
                            $this->ref->ViewValue = $this->ref->CurrentValue;
                        }
                    }
                } else {
                    $this->ref->ViewValue = null;
                }
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // yes_no
            if (strval($this->yes_no->CurrentValue) != "") {
                $this->yes_no->ViewValue = $this->yes_no->optionCaption($this->yes_no->CurrentValue);
            } else {
                $this->yes_no->ViewValue = null;
            }

            // packing_payment_type
            if (strval($this->packing_payment_type->CurrentValue) != "") {
                $this->packing_payment_type->ViewValue = $this->packing_payment_type->optionCaption($this->packing_payment_type->CurrentValue);
            } else {
                $this->packing_payment_type->ViewValue = null;
            }

            // fix
            if (strval($this->fix->CurrentValue) != "") {
                $this->fix->ViewValue = $this->fix->optionCaption($this->fix->CurrentValue);
            } else {
                $this->fix->ViewValue = null;
            }

            // method
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->ViewValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->ViewValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->ViewValue = null;
            }

            // sqm_method
            if (strval($this->sqm_method->CurrentValue) != "") {
                $this->sqm_method->ViewValue = $this->sqm_method->optionCaption($this->sqm_method->CurrentValue);
            } else {
                $this->sqm_method->ViewValue = null;
            }

            // unit
            if (strval($this->unit->CurrentValue) != "") {
                $this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
            } else {
                $this->unit->ViewValue = null;
            }

            // @_unit
            $this->_unit->ViewValue = $this->_unit->CurrentValue;
            $this->_unit->ViewValue = FormatNumber($this->_unit->ViewValue, $this->_unit->formatPattern());

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // extra_plan
            if (strval($this->extra_plan->CurrentValue) != "") {
                $this->extra_plan->ViewValue = $this->extra_plan->optionCaption($this->extra_plan->CurrentValue);
            } else {
                $this->extra_plan->ViewValue = null;
            }

            // custom_size
            $this->custom_size->ViewValue = $this->custom_size->CurrentValue;
            $this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, $this->custom_size->formatPattern());

            // custom_size_below_st
            $this->custom_size_below_st->ViewValue = $this->custom_size_below_st->CurrentValue;
            $this->custom_size_below_st->ViewValue = FormatNumber($this->custom_size_below_st->ViewValue, $this->custom_size_below_st->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // plan_type
            if (!EmptyValue($this->plan_type->CurrentValue)) {
                $this->plan_type->HrefValue = $this->plan_type->getLinkPrefix() . $this->plan_type->CurrentValue; // Add prefix/suffix
                $this->plan_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
                }
            } else {
                $this->plan_type->HrefValue = "";
            }

            // location
            if (!EmptyValue($this->location->CurrentValue)) {
                $this->location->HrefValue = $this->location->getLinkPrefix() . $this->location->CurrentValue; // Add prefix/suffix
                $this->location->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
                }
            } else {
                $this->location->HrefValue = "";
            }

            // from_date
            $this->from_date->HrefValue = "";

            // to_date
            $this->to_date->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }

            // product_type
            $this->product_type->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // selection
            $this->selection->HrefValue = "";

            // gcode
            if (!EmptyValue($this->gcode->CurrentValue)) {
                $this->gcode->HrefValue = $this->gcode->getLinkPrefix() . $this->gcode->CurrentValue; // Add prefix/suffix
                $this->gcode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
                }
            } else {
                $this->gcode->HrefValue = "";
            }

            // ref
            if (!EmptyValue($this->gcode->CurrentValue)) {
                $this->ref->HrefValue = $this->ref->getLinkPrefix() . $this->gcode->CurrentValue; // Add prefix/suffix
                $this->ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
                }
            } else {
                $this->ref->HrefValue = "";
            }

            // description
            $this->description->HrefValue = "";

            // yes_no
            $this->yes_no->HrefValue = "";

            // packing_payment_type
            $this->packing_payment_type->HrefValue = "";

            // fix
            $this->fix->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // sqm_method
            $this->sqm_method->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // @_unit
            $this->_unit->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // extra_plan
            $this->extra_plan->HrefValue = "";

            // custom_size
            $this->custom_size->HrefValue = "";

            // custom_size_below_st
            $this->custom_size_below_st->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // plan_type
            $this->plan_type->setupEditAttributes();
            $this->plan_type->EditValue = $this->plan_type->options(true);
            $this->plan_type->PlaceHolder = RemoveHtml($this->plan_type->caption());

            // location
            $curVal = trim(strval($this->location->CurrentValue));
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
                if ($this->location->ViewValue == "") {
                    $this->location->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->location->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->location->Lookup->renderViewRow($row);
                        $this->location->ViewValue->add($this->location->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->location->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // from_date
            $this->from_date->setupEditAttributes();
            $this->from_date->EditValue = HtmlEncode(FormatDateTime($this->from_date->CurrentValue, $this->from_date->formatPattern()));
            $this->from_date->PlaceHolder = RemoveHtml($this->from_date->caption());

            // to_date
            $this->to_date->setupEditAttributes();
            $this->to_date->EditValue = HtmlEncode(FormatDateTime($this->to_date->CurrentValue, $this->to_date->formatPattern()));
            $this->to_date->PlaceHolder = RemoveHtml($this->to_date->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // process
            $this->process->setupEditAttributes();
            $curVal = trim(strval($this->process->CurrentValue));
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            } else {
                $this->process->ViewValue = $this->process->Lookup !== null && is_array($this->process->lookupOptions()) && count($this->process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->process->ViewValue !== null) { // Load from cache
                $this->process->EditValue = array_values($this->process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->process->CurrentValue, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->process->EditValue = $arwrk;
            }
            $this->process->PlaceHolder = RemoveHtml($this->process->caption());

            // product_type
            $curVal = trim(strval($this->product_type->CurrentValue));
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // shape
            $curVal = trim(strval($this->shape->CurrentValue));
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // selection
            $this->selection->setupEditAttributes();
            $this->selection->EditValue = $this->selection->options(true);
            $this->selection->PlaceHolder = RemoveHtml($this->selection->caption());

            // gcode
            $curVal = trim(strval($this->gcode->CurrentValue));
            if ($curVal != "") {
                $this->gcode->ViewValue = $this->gcode->lookupCacheOption($curVal);
            } else {
                $this->gcode->ViewValue = $this->gcode->Lookup !== null && is_array($this->gcode->lookupOptions()) && count($this->gcode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->gcode->ViewValue !== null) { // Load from cache
                $this->gcode->EditValue = array_values($this->gcode->lookupOptions());
                if ($this->gcode->ViewValue == "") {
                    $this->gcode->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->gcode->Lookup->getTable()->Fields["gcode"]->searchExpression(), "=", trim($wrk), $this->gcode->Lookup->getTable()->Fields["gcode"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->gcode->getSelectFilter($this); // PHP
                $sqlWrk = $this->gcode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->gcode->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->gcode->Lookup->renderViewRow($row);
                        $this->gcode->ViewValue->add($this->gcode->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->gcode->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->gcode->EditValue = $arwrk;
            }
            $this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

            // ref
            $curVal = trim(strval($this->ref->CurrentValue));
            if ($curVal != "") {
                $this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
            } else {
                $this->ref->ViewValue = $this->ref->Lookup !== null && is_array($this->ref->lookupOptions()) && count($this->ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ref->ViewValue !== null) { // Load from cache
                $this->ref->EditValue = array_values($this->ref->lookupOptions());
                if ($this->ref->ViewValue == "") {
                    $this->ref->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->ref->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->ref->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->ref->Lookup->renderViewRow($row);
                        $this->ref->ViewValue->add($this->ref->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->ref->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->ref->EditValue = $arwrk;
            }
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->CurrentValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // yes_no
            $this->yes_no->setupEditAttributes();
            $this->yes_no->EditValue = $this->yes_no->options(true);
            $this->yes_no->PlaceHolder = RemoveHtml($this->yes_no->caption());

            // packing_payment_type
            $this->packing_payment_type->setupEditAttributes();
            $this->packing_payment_type->EditValue = $this->packing_payment_type->options(true);
            $this->packing_payment_type->PlaceHolder = RemoveHtml($this->packing_payment_type->caption());

            // fix
            $this->fix->setupEditAttributes();
            $this->fix->EditValue = $this->fix->options(true);
            $this->fix->PlaceHolder = RemoveHtml($this->fix->caption());

            // method
            $this->method->setupEditAttributes();
            $curVal = trim(strval($this->method->CurrentValue));
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            } else {
                $this->method->ViewValue = $this->method->Lookup !== null && is_array($this->method->lookupOptions()) && count($this->method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->method->ViewValue !== null) { // Load from cache
                $this->method->EditValue = array_values($this->method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->method->CurrentValue, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->method->EditValue = $arwrk;
            }
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // sqm_method
            $this->sqm_method->setupEditAttributes();
            $this->sqm_method->EditValue = $this->sqm_method->options(true);
            $this->sqm_method->PlaceHolder = RemoveHtml($this->sqm_method->caption());

            // unit
            $this->unit->setupEditAttributes();
            $this->unit->EditValue = $this->unit->options(true);
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // @_unit
            $this->_unit->setupEditAttributes();
            $this->_unit->EditValue = $this->_unit->CurrentValue;
            $this->_unit->PlaceHolder = RemoveHtml($this->_unit->caption());
            if (strval($this->_unit->EditValue) != "" && is_numeric($this->_unit->EditValue)) {
                $this->_unit->EditValue = FormatNumber($this->_unit->EditValue, null);
            }

            // @
            $this->_40->setupEditAttributes();
            $this->_40->EditValue = $this->_40->CurrentValue;
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
            if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
                $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
            }

            // extra_plan
            $this->extra_plan->setupEditAttributes();
            $this->extra_plan->EditValue = $this->extra_plan->options(true);
            $this->extra_plan->PlaceHolder = RemoveHtml($this->extra_plan->caption());

            // custom_size
            $this->custom_size->setupEditAttributes();
            $this->custom_size->EditValue = $this->custom_size->CurrentValue;
            $this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());
            if (strval($this->custom_size->EditValue) != "" && is_numeric($this->custom_size->EditValue)) {
                $this->custom_size->EditValue = FormatNumber($this->custom_size->EditValue, null);
            }

            // custom_size_below_st
            $this->custom_size_below_st->setupEditAttributes();
            $this->custom_size_below_st->EditValue = $this->custom_size_below_st->CurrentValue;
            $this->custom_size_below_st->PlaceHolder = RemoveHtml($this->custom_size_below_st->caption());
            if (strval($this->custom_size_below_st->EditValue) != "" && is_numeric($this->custom_size_below_st->EditValue)) {
                $this->custom_size_below_st->EditValue = FormatNumber($this->custom_size_below_st->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->uploads->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->uploads);
            }

            // operator

            // datetime

            // Add refer script

            // plan_type
            if (!EmptyValue($this->plan_type->CurrentValue)) {
                $this->plan_type->HrefValue = $this->plan_type->getLinkPrefix() . $this->plan_type->CurrentValue; // Add prefix/suffix
                $this->plan_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
                }
            } else {
                $this->plan_type->HrefValue = "";
            }

            // location
            if (!EmptyValue($this->location->CurrentValue)) {
                $this->location->HrefValue = $this->location->getLinkPrefix() . $this->location->CurrentValue; // Add prefix/suffix
                $this->location->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
                }
            } else {
                $this->location->HrefValue = "";
            }

            // from_date
            $this->from_date->HrefValue = "";

            // to_date
            $this->to_date->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // process
            if (!EmptyValue($this->process->CurrentValue)) {
                $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
                $this->process->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
                }
            } else {
                $this->process->HrefValue = "";
            }

            // product_type
            $this->product_type->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // selection
            $this->selection->HrefValue = "";

            // gcode
            if (!EmptyValue($this->gcode->CurrentValue)) {
                $this->gcode->HrefValue = $this->gcode->getLinkPrefix() . $this->gcode->CurrentValue; // Add prefix/suffix
                $this->gcode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
                }
            } else {
                $this->gcode->HrefValue = "";
            }

            // ref
            if (!EmptyValue($this->gcode->CurrentValue)) {
                $this->ref->HrefValue = $this->ref->getLinkPrefix() . $this->gcode->CurrentValue; // Add prefix/suffix
                $this->ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
                }
            } else {
                $this->ref->HrefValue = "";
            }

            // description
            $this->description->HrefValue = "";

            // yes_no
            $this->yes_no->HrefValue = "";

            // packing_payment_type
            $this->packing_payment_type->HrefValue = "";

            // fix
            $this->fix->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // sqm_method
            $this->sqm_method->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // @_unit
            $this->_unit->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // extra_plan
            $this->extra_plan->HrefValue = "";

            // custom_size
            $this->custom_size->HrefValue = "";

            // custom_size_below_st
            $this->custom_size_below_st->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->plan_type->Visible && $this->plan_type->Required) {
                if (!$this->plan_type->IsDetailKey && EmptyValue($this->plan_type->FormValue)) {
                    $this->plan_type->addErrorMessage(str_replace("%s", $this->plan_type->caption(), $this->plan_type->RequiredErrorMessage));
                }
            }
            if ($this->location->Visible && $this->location->Required) {
                if ($this->location->FormValue == "") {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->from_date->Visible && $this->from_date->Required) {
                if (!$this->from_date->IsDetailKey && EmptyValue($this->from_date->FormValue)) {
                    $this->from_date->addErrorMessage(str_replace("%s", $this->from_date->caption(), $this->from_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->from_date->FormValue, $this->from_date->formatPattern())) {
                $this->from_date->addErrorMessage($this->from_date->getErrorMessage(false));
            }
            if ($this->to_date->Visible && $this->to_date->Required) {
                if (!$this->to_date->IsDetailKey && EmptyValue($this->to_date->FormValue)) {
                    $this->to_date->addErrorMessage(str_replace("%s", $this->to_date->caption(), $this->to_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->to_date->FormValue, $this->to_date->formatPattern())) {
                $this->to_date->addErrorMessage($this->to_date->getErrorMessage(false));
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->process->Visible && $this->process->Required) {
                if (!$this->process->IsDetailKey && EmptyValue($this->process->FormValue)) {
                    $this->process->addErrorMessage(str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if ($this->product_type->FormValue == "") {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->shape->Visible && $this->shape->Required) {
                if ($this->shape->FormValue == "") {
                    $this->shape->addErrorMessage(str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
                }
            }
            if ($this->selection->Visible && $this->selection->Required) {
                if (!$this->selection->IsDetailKey && EmptyValue($this->selection->FormValue)) {
                    $this->selection->addErrorMessage(str_replace("%s", $this->selection->caption(), $this->selection->RequiredErrorMessage));
                }
            }
            if ($this->gcode->Visible && $this->gcode->Required) {
                if ($this->gcode->FormValue == "") {
                    $this->gcode->addErrorMessage(str_replace("%s", $this->gcode->caption(), $this->gcode->RequiredErrorMessage));
                }
            }
            if ($this->ref->Visible && $this->ref->Required) {
                if ($this->ref->FormValue == "") {
                    $this->ref->addErrorMessage(str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
                }
            }
            if ($this->description->Visible && $this->description->Required) {
                if (!$this->description->IsDetailKey && EmptyValue($this->description->FormValue)) {
                    $this->description->addErrorMessage(str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
                }
            }
            if ($this->yes_no->Visible && $this->yes_no->Required) {
                if (!$this->yes_no->IsDetailKey && EmptyValue($this->yes_no->FormValue)) {
                    $this->yes_no->addErrorMessage(str_replace("%s", $this->yes_no->caption(), $this->yes_no->RequiredErrorMessage));
                }
            }
            if ($this->packing_payment_type->Visible && $this->packing_payment_type->Required) {
                if (!$this->packing_payment_type->IsDetailKey && EmptyValue($this->packing_payment_type->FormValue)) {
                    $this->packing_payment_type->addErrorMessage(str_replace("%s", $this->packing_payment_type->caption(), $this->packing_payment_type->RequiredErrorMessage));
                }
            }
            if ($this->fix->Visible && $this->fix->Required) {
                if (!$this->fix->IsDetailKey && EmptyValue($this->fix->FormValue)) {
                    $this->fix->addErrorMessage(str_replace("%s", $this->fix->caption(), $this->fix->RequiredErrorMessage));
                }
            }
            if ($this->method->Visible && $this->method->Required) {
                if (!$this->method->IsDetailKey && EmptyValue($this->method->FormValue)) {
                    $this->method->addErrorMessage(str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
                }
            }
            if ($this->sqm_method->Visible && $this->sqm_method->Required) {
                if (!$this->sqm_method->IsDetailKey && EmptyValue($this->sqm_method->FormValue)) {
                    $this->sqm_method->addErrorMessage(str_replace("%s", $this->sqm_method->caption(), $this->sqm_method->RequiredErrorMessage));
                }
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->_unit->Visible && $this->_unit->Required) {
                if (!$this->_unit->IsDetailKey && EmptyValue($this->_unit->FormValue)) {
                    $this->_unit->addErrorMessage(str_replace("%s", $this->_unit->caption(), $this->_unit->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_unit->FormValue)) {
                $this->_unit->addErrorMessage($this->_unit->getErrorMessage(false));
            }
            if ($this->_40->Visible && $this->_40->Required) {
                if (!$this->_40->IsDetailKey && EmptyValue($this->_40->FormValue)) {
                    $this->_40->addErrorMessage(str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_40->FormValue)) {
                $this->_40->addErrorMessage($this->_40->getErrorMessage(false));
            }
            if ($this->extra_plan->Visible && $this->extra_plan->Required) {
                if (!$this->extra_plan->IsDetailKey && EmptyValue($this->extra_plan->FormValue)) {
                    $this->extra_plan->addErrorMessage(str_replace("%s", $this->extra_plan->caption(), $this->extra_plan->RequiredErrorMessage));
                }
            }
            if ($this->custom_size->Visible && $this->custom_size->Required) {
                if (!$this->custom_size->IsDetailKey && EmptyValue($this->custom_size->FormValue)) {
                    $this->custom_size->addErrorMessage(str_replace("%s", $this->custom_size->caption(), $this->custom_size->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->custom_size->FormValue)) {
                $this->custom_size->addErrorMessage($this->custom_size->getErrorMessage(false));
            }
            if ($this->custom_size_below_st->Visible && $this->custom_size_below_st->Required) {
                if (!$this->custom_size_below_st->IsDetailKey && EmptyValue($this->custom_size_below_st->FormValue)) {
                    $this->custom_size_below_st->addErrorMessage(str_replace("%s", $this->custom_size_below_st->caption(), $this->custom_size_below_st->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->custom_size_below_st->FormValue)) {
                $this->custom_size_below_st->addErrorMessage($this->custom_size_below_st->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                $this->uploads->Upload->DbValue = null;
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // plan_type
        $this->plan_type->setDbValueDef($rsnew, $this->plan_type->CurrentValue, false);

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, false);

        // from_date
        $this->from_date->setDbValueDef($rsnew, UnFormatDateTime($this->from_date->CurrentValue, $this->from_date->formatPattern()), false);

        // to_date
        $this->to_date->setDbValueDef($rsnew, UnFormatDateTime($this->to_date->CurrentValue, $this->to_date->formatPattern()), false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // process
        $this->process->setDbValueDef($rsnew, $this->process->CurrentValue, false);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, false);

        // shape
        $this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, false);

        // selection
        $this->selection->setDbValueDef($rsnew, $this->selection->CurrentValue, strval($this->selection->CurrentValue) == "");

        // gcode
        $this->gcode->setDbValueDef($rsnew, $this->gcode->CurrentValue, false);

        // ref
        $this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, false);

        // description
        $this->description->setDbValueDef($rsnew, $this->description->CurrentValue, false);

        // yes_no
        $this->yes_no->setDbValueDef($rsnew, $this->yes_no->CurrentValue, false);

        // packing_payment_type
        $this->packing_payment_type->setDbValueDef($rsnew, $this->packing_payment_type->CurrentValue, strval($this->packing_payment_type->CurrentValue) == "");

        // fix
        $this->fix->setDbValueDef($rsnew, $this->fix->CurrentValue, false);

        // method
        $this->method->setDbValueDef($rsnew, $this->method->CurrentValue, false);

        // sqm_method
        $this->sqm_method->setDbValueDef($rsnew, $this->sqm_method->CurrentValue, strval($this->sqm_method->CurrentValue) == "");

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, false);

        // @_unit
        $this->_unit->setDbValueDef($rsnew, $this->_unit->CurrentValue, false);

        // @
        $this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, false);

        // extra_plan
        $this->extra_plan->setDbValueDef($rsnew, $this->extra_plan->CurrentValue, false);

        // custom_size
        $this->custom_size->setDbValueDef($rsnew, $this->custom_size->CurrentValue, strval($this->custom_size->CurrentValue) == "");

        // custom_size_below_st
        $this->custom_size_below_st->setDbValueDef($rsnew, $this->custom_size_below_st->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 640; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['plan_type'])) { // plan_type
            $this->plan_type->setFormValue($row['plan_type']);
        }
        if (isset($row['location'])) { // location
            $this->location->setFormValue($row['location']);
        }
        if (isset($row['from_date'])) { // from_date
            $this->from_date->setFormValue($row['from_date']);
        }
        if (isset($row['to_date'])) { // to_date
            $this->to_date->setFormValue($row['to_date']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['process'])) { // process
            $this->process->setFormValue($row['process']);
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->setFormValue($row['product_type']);
        }
        if (isset($row['shape'])) { // shape
            $this->shape->setFormValue($row['shape']);
        }
        if (isset($row['selection'])) { // selection
            $this->selection->setFormValue($row['selection']);
        }
        if (isset($row['gcode'])) { // gcode
            $this->gcode->setFormValue($row['gcode']);
        }
        if (isset($row['ref'])) { // ref
            $this->ref->setFormValue($row['ref']);
        }
        if (isset($row['description'])) { // description
            $this->description->setFormValue($row['description']);
        }
        if (isset($row['yes_no'])) { // yes_no
            $this->yes_no->setFormValue($row['yes_no']);
        }
        if (isset($row['packing_payment_type'])) { // packing_payment_type
            $this->packing_payment_type->setFormValue($row['packing_payment_type']);
        }
        if (isset($row['fix'])) { // fix
            $this->fix->setFormValue($row['fix']);
        }
        if (isset($row['method'])) { // method
            $this->method->setFormValue($row['method']);
        }
        if (isset($row['sqm_method'])) { // sqm_method
            $this->sqm_method->setFormValue($row['sqm_method']);
        }
        if (isset($row['unit'])) { // unit
            $this->unit->setFormValue($row['unit']);
        }
        if (isset($row['@_unit'])) { // @_unit
            $this->_unit->setFormValue($row['@_unit']);
        }
        if (isset($row['@'])) { // @
            $this->_40->setFormValue($row['@']);
        }
        if (isset($row['extra_plan'])) { // extra_plan
            $this->extra_plan->setFormValue($row['extra_plan']);
        }
        if (isset($row['custom_size'])) { // custom_size
            $this->custom_size->setFormValue($row['custom_size']);
        }
        if (isset($row['custom_size_below_st'])) { // custom_size_below_st
            $this->custom_size_below_st->setFormValue($row['custom_size_below_st']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->setFormValue($row['uploads']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("paymentplanlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_plan_type":
                    break;
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_selection":
                    break;
                case "x_gcode":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_ref":
                    break;
                case "x_yes_no":
                    break;
                case "x_packing_payment_type":
                    break;
                case "x_fix":
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_sqm_method":
                    break;
                case "x_unit":
                    break;
                case "x_extra_plan":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	$this->_40->ReadOnly = True;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError) 
    {
    	// Return error message in CustomError
    	extract($_POST,EXTR_OVERWRITE);
    	$_SESSION[SESSION_MESSAGE] = '';
    	$x_ref == null ? $refc = 0 : $refc = count($x_ref);
    	$plt = $x_plan_type;
    	$x_location = explode(',', $x_location[0]);
    	$LCount = count($x_location);
    	for ($il=0; $il<$LCount; $il++) 
    	{
    		$l = $x_location[$il];		
    		$x_shape = explode(',', $x_shape[0]);
    		$SCount = count($x_shape);
    		for ($is=0; $is<$SCount; $is++) 
    		{
    			$s = $x_shape[$is];
    			$x_product_type = explode(',', $x_product_type[0]);
    			$ptCount = count($x_product_type);
    			for ($pt=0; $pt<$ptCount; $pt++) 
    			{
    				$p = $x_product_type[$pt];
    				if ($x_selection == 0)
    				{
    					$row = ExecuteRow("SELECT group_concat(`id`) as `id`,  count(`id`) as count FROM `payment_plan` WHERE  $x_status = 1 and `status` = 1 and (STR_TO_DATE('$x_from_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date` or STR_TO_DATE('$x_to_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date`) and $plt = `plan_type` and FIND_IN_SET($l, `location`) and FIND_IN_SET($p, `product_type`) and FIND_IN_SET($s, `shape`) and process = $x_process  and `s_grp` = $x_s_grp LIMIT 1");
    					$c = $row['count'];
    					if ($c > 0)
    					{
    						$_SESSION[SESSION_WARNING_MESSAGE].= 'Same Combination exist for Process in ID No. ' . $row['id'] . '<BR>';
    					}
    				}
    				else		
    				{
    					if ($refc > 0)
    					{
    						$Dref = count($x_ref);
    						for ($id=0; $id<$Dref; $id++) 
    						{
    						$d = $x_ref[$id];
    							$row1 = ExecuteRow("SELECT `id`,  count(`id`) as count,  `ref`,  `status` FROM `payment_plan` WHERE  $x_status = 1 and `status` = 1 and (STR_TO_DATE('$x_from_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date` or STR_TO_DATE('$x_to_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date`) and $plt = `plan_type` and FIND_IN_SET($l, `location`) and FIND_IN_SET($p, `product_type`) and FIND_IN_SET($s, `shape`) and FIND_IN_SET($d, `ref`) and process = $x_process LIMIT 1");
    							$c1 = $row1['count'];
    							if ($c1 > 0)
    							{
    								$_SESSION[SESSION_WARNING_MESSAGE].= 'Same Combination exist for Design ID: ' .$d. ' in ID No. ' . $row1['id'] . '<BR>';
    							}
    							if ($plt == 1)
    							{
    							$row2 = ExecuteRow("SELECT `id`,  count(`id`) as count,  `ref`,  `status` FROM `payment_plan` WHERE  $x_status = 1 and `status` = 1 and (STR_TO_DATE('$x_from_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date` or STR_TO_DATE('$x_to_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date`) and 0 = `plan_type` and FIND_IN_SET($l, `location`) and FIND_IN_SET($p, `product_type`) and FIND_IN_SET($s, `shape`) and FIND_IN_SET($d, `ref`) and process = $x_process LIMIT 1");
    							$c2 = $row2['count'];
    								if ($c2 > 0)
    								{
    									$_SESSION[SESSION_WARNING_MESSAGE].= '';
    								}
    								else
    								{
    									$_SESSION[SESSION_WARNING_MESSAGE].= 'Create Required Basic Plan for Design ID: ' .$d. ' First.<BR>';
    								}
    							}									
    						}
    					}
    					else
    					{
    						$_SESSION[SESSION_WARNING_MESSAGE].= 'Select One or more Designs for Payment Plan<BR>';
    					}								
    				}	
    			}		
    		}
    	}
    		if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    		{return TRUE;}
    		else
    		{return false;}
    }
}
