<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for payment_plan
 */
class PaymentPlan extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = true;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $plan_type;
    public $location;
    public $from_date;
    public $to_date;
    public $grp;
    public $s_grp;
    public $process;
    public $product_type;
    public $shape;
    public $selection;
    public $gcode;
    public $ref;
    public $description;
    public $yes_no;
    public $packing_payment_type;
    public $fix;
    public $method;
    public $sqm_method;
    public $unit;
    public $_unit;
    public $_40;
    public $extra_plan;
    public $custom_size;
    public $custom_size_below_st;
    public $status;
    public $uploads;
    public $operator;
    public $datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "payment_plan";
        $this->TableName = 'payment_plan';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "payment_plan";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // plan_type
        $this->plan_type = new DbField(
            $this, // Table
            'x_plan_type', // Variable name
            'plan_type', // Name
            '`plan_type`', // Expression
            '`plan_type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`plan_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->plan_type->addMethod("getDefault", fn() => 1);
        $this->plan_type->addMethod("getLinkPrefix", fn() => "paymentplanlist?x_plan_type=");
        $this->plan_type->InputTextType = "text";
        $this->plan_type->Raw = true;
        $this->plan_type->setSelectMultiple(false); // Select one
        $this->plan_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->plan_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->plan_type->Lookup = new Lookup($this->plan_type, 'payment_plan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->plan_type->OptionCount = 2;
        $this->plan_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->plan_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['plan_type'] = &$this->plan_type;

        // location
        $this->location = new DbField(
            $this, // Table
            'x_location', // Variable name
            'location', // Name
            '`location`', // Expression
            '`location`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`location`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->location->addMethod("getSelectFilter", fn() => "`status`=1 and `id` > 0");
        $this->location->addMethod("getLinkPrefix", fn() => "paymentplanlist?x_location=");
        $this->location->InputTextType = "text";
        $this->location->Required = true; // Required field
        $this->location->Lookup = new Lookup($this->location, 'godown_table', false, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->location) . "',COALESCE(`code`,''))");
        $this->location->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['location'] = &$this->location;

        // from_date
        $this->from_date = new DbField(
            $this, // Table
            'x_from_date', // Variable name
            'from_date', // Name
            '`from_date`', // Expression
            CastDateFieldForLike("`from_date`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`from_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->from_date->InputTextType = "text";
        $this->from_date->Raw = true;
        $this->from_date->Nullable = false; // NOT NULL field
        $this->from_date->Required = true; // Required field
        $this->from_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->from_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['from_date'] = &$this->from_date;

        // to_date
        $this->to_date = new DbField(
            $this, // Table
            'x_to_date', // Variable name
            'to_date', // Name
            '`to_date`', // Expression
            CastDateFieldForLike("`to_date`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`to_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->to_date->InputTextType = "text";
        $this->to_date->Raw = true;
        $this->to_date->Nullable = false; // NOT NULL field
        $this->to_date->Required = true; // Required field
        $this->to_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->to_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['to_date'] = &$this->to_date;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getDefault", fn() => (isset($_GET['GRP']))  ? $_GET['GRP'] : '');
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->s_grp->addMethod("getDefault", fn() => (isset($_GET['SGRP']))  ? $_GET['SGRP'] : '');
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Required = true; // Required field
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_process","x_gcode[]"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->addMethod("getSelectFilter", fn() => "`type`=1 and `status`=1");
        $this->process->addMethod("getLinkPrefix", fn() => "paymentplanlist?x_process=");
        $this->process->InputTextType = "text";
        $this->process->Raw = true;
        $this->process->Required = true; // Required field
        $this->process->setSelectMultiple(false); // Select one
        $this->process->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type_view2', true, 'id', ["name","","",""], '', '', ["x_s_grp"], [], ["process"], ["x_process"], [], [], false, '`name` ASC', '', "`name`");
        $this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // product_type
        $this->product_type = new DbField(
            $this, // Table
            'x_product_type', // Variable name
            'product_type', // Name
            '`product_type`', // Expression
            '`product_type`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->product_type->addMethod("getSelectFilter", fn() => "`status`=1 and `id` !=9");
        $this->product_type->InputTextType = "text";
        $this->product_type->Required = true; // Required field
        $this->product_type->Lookup = new Lookup($this->product_type, 'product_type', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_type->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_type'] = &$this->product_type;

        // shape
        $this->shape = new DbField(
            $this, // Table
            'x_shape', // Variable name
            'shape', // Name
            '`shape`', // Expression
            '`shape`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shape`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->shape->addMethod("getSelectFilter", fn() => "`status`=1 and id < 100");
        $this->shape->InputTextType = "text";
        $this->shape->Required = true; // Required field
        $this->shape->Lookup = new Lookup($this->shape, 'shape', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->shape->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['shape'] = &$this->shape;

        // selection
        $this->selection = new DbField(
            $this, // Table
            'x_selection', // Variable name
            'selection', // Name
            '`selection`', // Expression
            '`selection`', // Basic search expression
            16, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`selection`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->selection->addMethod("getDefault", fn() => 1);
        $this->selection->InputTextType = "text";
        $this->selection->Raw = true;
        $this->selection->Required = true; // Required field
        $this->selection->setSelectMultiple(false); // Select one
        $this->selection->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->selection->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->selection->Lookup = new Lookup($this->selection, 'payment_plan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->selection->OptionCount = 2;
        $this->selection->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->selection->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['selection'] = &$this->selection;

        // gcode
        $this->gcode = new DbField(
            $this, // Table
            'x_gcode', // Variable name
            'gcode', // Name
            '`gcode`', // Expression
            '`gcode`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->gcode->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->gcode->addMethod("getDefault", fn() => (isset($_GET['GC']))  ? $_GET['GC'] : '');
        $this->gcode->addMethod("getLinkPrefix", fn() => "paymentplanlist?x_gcode=");
        $this->gcode->InputTextType = "text";
        $this->gcode->setSelectMultiple(true); // Select multiple
        $this->gcode->Lookup = new Lookup($this->gcode, 'ref', true, 'gcode', ["gcode","","",""], '', '', ["x_s_grp"], ["x_ref[]"], ["s_grp"], ["x_s_grp"], [], [], false, '`gcode` ASC', '', "`gcode`");
        $this->gcode->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['gcode'] = &$this->gcode;

        // ref
        $this->ref = new DbField(
            $this, // Table
            'x_ref', // Variable name
            'ref', // Name
            '`ref`', // Expression
            '`ref`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__ref', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ref->addMethod("getDefault", fn() => (isset($_GET['RID']))  ? $_GET['RID'] : '');
        $this->ref->addMethod("getLinkPrefix", fn() => "paymentplanlist?x_ref=");
        $this->ref->InputTextType = "text";
        $this->ref->setSelectMultiple(true); // Select multiple
        $this->ref->Lookup = new Lookup($this->ref, 'ref', false, 'id', ["product_code","","",""], '', '', ["x_gcode[]"], [], ["gcode"], ["x_gcode"], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->ref->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ref'] = &$this->ref;

        // description
        $this->description = new DbField(
            $this, // Table
            'x_description', // Variable name
            'description', // Name
            '`description`', // Expression
            '`description`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description->InputTextType = "text";
        $this->description->Nullable = false; // NOT NULL field
        $this->description->Required = true; // Required field
        $this->description->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['description'] = &$this->description;

        // yes_no
        $this->yes_no = new DbField(
            $this, // Table
            'x_yes_no', // Variable name
            'yes_no', // Name
            '`yes_no`', // Expression
            '`yes_no`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`yes_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->yes_no->InputTextType = "text";
        $this->yes_no->Raw = true;
        $this->yes_no->Nullable = false; // NOT NULL field
        $this->yes_no->Required = true; // Required field
        $this->yes_no->setSelectMultiple(false); // Select one
        $this->yes_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->yes_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->yes_no->Lookup = new Lookup($this->yes_no, 'payment_plan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->yes_no->OptionCount = 2;
        $this->yes_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->yes_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['yes_no'] = &$this->yes_no;

        // packing_payment_type
        $this->packing_payment_type = new DbField(
            $this, // Table
            'x_packing_payment_type', // Variable name
            'packing_payment_type', // Name
            '`packing_payment_type`', // Expression
            '`packing_payment_type`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_payment_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_payment_type->addMethod("getDefault", fn() => 0);
        $this->packing_payment_type->InputTextType = "text";
        $this->packing_payment_type->Raw = true;
        $this->packing_payment_type->setSelectMultiple(false); // Select one
        $this->packing_payment_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_payment_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_payment_type->Lookup = new Lookup($this->packing_payment_type, 'payment_plan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->packing_payment_type->OptionCount = 2;
        $this->packing_payment_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_payment_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_payment_type'] = &$this->packing_payment_type;

        // fix
        $this->fix = new DbField(
            $this, // Table
            'x_fix', // Variable name
            'fix', // Name
            '`fix`', // Expression
            '`fix`', // Basic search expression
            16, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fix`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->fix->addMethod("getDefault", fn() => 1);
        $this->fix->InputTextType = "text";
        $this->fix->Raw = true;
        $this->fix->Required = true; // Required field
        $this->fix->setSelectMultiple(false); // Select one
        $this->fix->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->fix->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->fix->Lookup = new Lookup($this->fix, 'payment_plan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->fix->OptionCount = 2;
        $this->fix->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->fix->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fix'] = &$this->fix;

        // method
        $this->method = new DbField(
            $this, // Table
            'x_method', // Variable name
            'method', // Name
            '`method`', // Expression
            '`method`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->method->addMethod("getSelectFilter", fn() => "`grp`=11");
        $this->method->InputTextType = "text";
        $this->method->Nullable = false; // NOT NULL field
        $this->method->Required = true; // Required field
        $this->method->setSelectMultiple(false); // Select one
        $this->method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->method->Lookup = new Lookup($this->method, 'method', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->method->SearchOperators = ["=", "<>"];
        $this->Fields['method'] = &$this->method;

        // sqm_method
        $this->sqm_method = new DbField(
            $this, // Table
            'x_sqm_method', // Variable name
            'sqm_method', // Name
            '`sqm_method`', // Expression
            '`sqm_method`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm_method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sqm_method->addMethod("getDefault", fn() => 0);
        $this->sqm_method->InputTextType = "text";
        $this->sqm_method->Raw = true;
        $this->sqm_method->Nullable = false; // NOT NULL field
        $this->sqm_method->Required = true; // Required field
        $this->sqm_method->setSelectMultiple(false); // Select one
        $this->sqm_method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sqm_method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sqm_method->Lookup = new Lookup($this->sqm_method, 'payment_plan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->sqm_method->OptionCount = 2;
        $this->sqm_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sqm_method->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sqm_method'] = &$this->sqm_method;

        // unit
        $this->unit = new DbField(
            $this, // Table
            'x_unit', // Variable name
            'unit', // Name
            '`unit`', // Expression
            '`unit`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->unit->addMethod("getDefault", fn() => 5);
        $this->unit->InputTextType = "text";
        $this->unit->Raw = true;
        $this->unit->setSelectMultiple(false); // Select one
        $this->unit->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->unit->Lookup = new Lookup($this->unit, 'payment_plan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->unit->OptionCount = 5;
        $this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unit->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unit'] = &$this->unit;

        // @_unit
        $this->_unit = new DbField(
            $this, // Table
            'x__unit', // Variable name
            '@_unit', // Name
            '`@_unit`', // Expression
            '`@_unit`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@_unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_unit->addMethod("getDefault", fn() => 0);
        $this->_unit->InputTextType = "text";
        $this->_unit->Raw = true;
        $this->_unit->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_unit->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['@_unit'] = &$this->_unit;

        // @
        $this->_40 = new DbField(
            $this, // Table
            'x__40', // Variable name
            '@', // Name
            '`@`', // Expression
            '`@`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_40->addMethod("getDefault", fn() => 0);
        $this->_40->InputTextType = "text";
        $this->_40->Raw = true;
        $this->_40->Nullable = false; // NOT NULL field
        $this->_40->Required = true; // Required field
        $this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_40->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['@'] = &$this->_40;

        // extra_plan
        $this->extra_plan = new DbField(
            $this, // Table
            'x_extra_plan', // Variable name
            'extra_plan', // Name
            '`extra_plan`', // Expression
            '`extra_plan`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`extra_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->extra_plan->InputTextType = "text";
        $this->extra_plan->Raw = true;
        $this->extra_plan->Nullable = false; // NOT NULL field
        $this->extra_plan->Required = true; // Required field
        $this->extra_plan->setSelectMultiple(false); // Select one
        $this->extra_plan->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->extra_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->extra_plan->Lookup = new Lookup($this->extra_plan, 'payment_plan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->extra_plan->OptionCount = 4;
        $this->extra_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->extra_plan->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['extra_plan'] = &$this->extra_plan;

        // custom_size
        $this->custom_size = new DbField(
            $this, // Table
            'x_custom_size', // Variable name
            'custom_size', // Name
            '`custom_size`', // Expression
            '`custom_size`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`custom_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->custom_size->addMethod("getDefault", fn() => 0);
        $this->custom_size->InputTextType = "text";
        $this->custom_size->Raw = true;
        $this->custom_size->Nullable = false; // NOT NULL field
        $this->custom_size->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->custom_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['custom_size'] = &$this->custom_size;

        // custom_size_below_st
        $this->custom_size_below_st = new DbField(
            $this, // Table
            'x_custom_size_below_st', // Variable name
            'custom_size_below_st', // Name
            '`custom_size_below_st`', // Expression
            '`custom_size_below_st`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`custom_size_below_st`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->custom_size_below_st->InputTextType = "text";
        $this->custom_size_below_st->Raw = true;
        $this->custom_size_below_st->Nullable = false; // NOT NULL field
        $this->custom_size_below_st->Required = true; // Required field
        $this->custom_size_below_st->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->custom_size_below_st->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['custom_size_below_st'] = &$this->custom_size_below_st;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'payment_plan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // uploads
        $this->uploads = new DbField(
            $this, // Table
            'x_uploads', // Variable name
            'uploads', // Name
            '`uploads`', // Expression
            '`uploads`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`uploads`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->uploads->InputTextType = "text";
        $this->uploads->ImageResize = true;
        $this->uploads->UploadMultiple = true;
        $this->uploads->Upload->UploadMultiple = true;
        $this->uploads->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uploads'] = &$this->uploads;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "payment_plan";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `product_code` FROM ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = payment_plan.ref LIMIT 1) AS EV__ref FROM payment_plan)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->ref->AdvancedSearch->SearchValue != "" ||
            $this->ref->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->ref->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->ref->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->plan_type->DbValue = $row['plan_type'];
        $this->location->DbValue = $row['location'];
        $this->from_date->DbValue = $row['from_date'];
        $this->to_date->DbValue = $row['to_date'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->process->DbValue = $row['process'];
        $this->product_type->DbValue = $row['product_type'];
        $this->shape->DbValue = $row['shape'];
        $this->selection->DbValue = $row['selection'];
        $this->gcode->DbValue = $row['gcode'];
        $this->ref->DbValue = $row['ref'];
        $this->description->DbValue = $row['description'];
        $this->yes_no->DbValue = $row['yes_no'];
        $this->packing_payment_type->DbValue = $row['packing_payment_type'];
        $this->fix->DbValue = $row['fix'];
        $this->method->DbValue = $row['method'];
        $this->sqm_method->DbValue = $row['sqm_method'];
        $this->unit->DbValue = $row['unit'];
        $this->_unit->DbValue = $row['@_unit'];
        $this->_40->DbValue = $row['@'];
        $this->extra_plan->DbValue = $row['extra_plan'];
        $this->custom_size->DbValue = $row['custom_size'];
        $this->custom_size_below_st->DbValue = $row['custom_size_below_st'];
        $this->status->DbValue = $row['status'];
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $oldFiles = EmptyValue($row['uploads']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['uploads']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("paymentplanlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "paymentplanview" => $Language->phrase("View"),
            "paymentplanedit" => $Language->phrase("Edit"),
            "paymentplanadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "paymentplanlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PaymentPlanView",
            Config("API_ADD_ACTION") => "PaymentPlanAdd",
            Config("API_EDIT_ACTION") => "PaymentPlanEdit",
            Config("API_DELETE_ACTION") => "PaymentPlanDelete",
            Config("API_LIST_ACTION") => "PaymentPlanList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "paymentplanlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("paymentplanview", $parm);
        } else {
            $url = $this->keyUrl("paymentplanview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "paymentplanadd?" . $parm;
        } else {
            $url = "paymentplanadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("paymentplanedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("paymentplanlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("paymentplanadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("paymentplanlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("paymentplandelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->plan_type->setDbValue($row['plan_type']);
        $this->location->setDbValue($row['location']);
        $this->from_date->setDbValue($row['from_date']);
        $this->to_date->setDbValue($row['to_date']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->process->setDbValue($row['process']);
        $this->product_type->setDbValue($row['product_type']);
        $this->shape->setDbValue($row['shape']);
        $this->selection->setDbValue($row['selection']);
        $this->gcode->setDbValue($row['gcode']);
        $this->ref->setDbValue($row['ref']);
        $this->description->setDbValue($row['description']);
        $this->yes_no->setDbValue($row['yes_no']);
        $this->packing_payment_type->setDbValue($row['packing_payment_type']);
        $this->fix->setDbValue($row['fix']);
        $this->method->setDbValue($row['method']);
        $this->sqm_method->setDbValue($row['sqm_method']);
        $this->unit->setDbValue($row['unit']);
        $this->_unit->setDbValue($row['@_unit']);
        $this->_40->setDbValue($row['@']);
        $this->extra_plan->setDbValue($row['extra_plan']);
        $this->custom_size->setDbValue($row['custom_size']);
        $this->custom_size_below_st->setDbValue($row['custom_size_below_st']);
        $this->status->setDbValue($row['status']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PaymentPlanList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // plan_type

        // location

        // from_date

        // to_date

        // grp

        // s_grp

        // process

        // product_type

        // shape

        // selection

        // gcode

        // ref

        // description

        // yes_no

        // packing_payment_type

        // fix

        // method

        // sqm_method

        // unit

        // @_unit

        // @

        // extra_plan

        // custom_size

        // custom_size_below_st

        // status

        // uploads

        // operator

        // datetime

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // plan_type
        if (strval($this->plan_type->CurrentValue) != "") {
            $this->plan_type->ViewValue = $this->plan_type->optionCaption($this->plan_type->CurrentValue);
        } else {
            $this->plan_type->ViewValue = null;
        }

        // location
        $curVal = strval($this->location->CurrentValue);
        if ($curVal != "") {
            $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            if ($this->location->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->location->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->location->Lookup->renderViewRow($row);
                        $this->location->ViewValue->add($this->location->displayValue($arwrk));
                    }
                } else {
                    $this->location->ViewValue = $this->location->CurrentValue;
                }
            }
        } else {
            $this->location->ViewValue = null;
        }

        // from_date
        $this->from_date->ViewValue = $this->from_date->CurrentValue;
        $this->from_date->ViewValue = FormatDateTime($this->from_date->ViewValue, $this->from_date->formatPattern());

        // to_date
        $this->to_date->ViewValue = $this->to_date->CurrentValue;
        $this->to_date->ViewValue = FormatDateTime($this->to_date->ViewValue, $this->to_date->formatPattern());

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // process
        $curVal = strval($this->process->CurrentValue);
        if ($curVal != "") {
            $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
            if ($this->process->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->process->getSelectFilter($this); // PHP
                $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->process->Lookup->renderViewRow($rswrk[0]);
                    $this->process->ViewValue = $this->process->displayValue($arwrk);
                } else {
                    $this->process->ViewValue = $this->process->CurrentValue;
                }
            }
        } else {
            $this->process->ViewValue = null;
        }

        // product_type
        $curVal = strval($this->product_type->CurrentValue);
        if ($curVal != "") {
            $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            if ($this->product_type->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->product_type->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->product_type->Lookup->renderViewRow($row);
                        $this->product_type->ViewValue->add($this->product_type->displayValue($arwrk));
                    }
                } else {
                    $this->product_type->ViewValue = $this->product_type->CurrentValue;
                }
            }
        } else {
            $this->product_type->ViewValue = null;
        }

        // shape
        $curVal = strval($this->shape->CurrentValue);
        if ($curVal != "") {
            $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            if ($this->shape->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->shape->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->shape->Lookup->renderViewRow($row);
                        $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                    }
                } else {
                    $this->shape->ViewValue = $this->shape->CurrentValue;
                }
            }
        } else {
            $this->shape->ViewValue = null;
        }

        // selection
        if (strval($this->selection->CurrentValue) != "") {
            $this->selection->ViewValue = $this->selection->optionCaption($this->selection->CurrentValue);
        } else {
            $this->selection->ViewValue = null;
        }

        // gcode
        $curVal = strval($this->gcode->CurrentValue);
        if ($curVal != "") {
            $this->gcode->ViewValue = $this->gcode->lookupCacheOption($curVal);
            if ($this->gcode->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->gcode->Lookup->getTable()->Fields["gcode"]->searchExpression(), "=", trim($wrk), $this->gcode->Lookup->getTable()->Fields["gcode"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->gcode->getSelectFilter($this); // PHP
                $sqlWrk = $this->gcode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->gcode->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->gcode->Lookup->renderViewRow($row);
                        $this->gcode->ViewValue->add($this->gcode->displayValue($arwrk));
                    }
                } else {
                    $this->gcode->ViewValue = $this->gcode->CurrentValue;
                }
            }
        } else {
            $this->gcode->ViewValue = null;
        }

        // ref
        if ($this->ref->VirtualValue != "") {
            $this->ref->ViewValue = $this->ref->VirtualValue;
        } else {
            $curVal = strval($this->ref->CurrentValue);
            if ($curVal != "") {
                $this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
                if ($this->ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->ref->Lookup->renderViewRow($row);
                            $this->ref->ViewValue->add($this->ref->displayValue($arwrk));
                        }
                    } else {
                        $this->ref->ViewValue = $this->ref->CurrentValue;
                    }
                }
            } else {
                $this->ref->ViewValue = null;
            }
        }

        // description
        $this->description->ViewValue = $this->description->CurrentValue;

        // yes_no
        if (strval($this->yes_no->CurrentValue) != "") {
            $this->yes_no->ViewValue = $this->yes_no->optionCaption($this->yes_no->CurrentValue);
        } else {
            $this->yes_no->ViewValue = null;
        }

        // packing_payment_type
        if (strval($this->packing_payment_type->CurrentValue) != "") {
            $this->packing_payment_type->ViewValue = $this->packing_payment_type->optionCaption($this->packing_payment_type->CurrentValue);
        } else {
            $this->packing_payment_type->ViewValue = null;
        }

        // fix
        if (strval($this->fix->CurrentValue) != "") {
            $this->fix->ViewValue = $this->fix->optionCaption($this->fix->CurrentValue);
        } else {
            $this->fix->ViewValue = null;
        }

        // method
        $curVal = strval($this->method->CurrentValue);
        if ($curVal != "") {
            $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            if ($this->method->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                    $this->method->ViewValue = $this->method->displayValue($arwrk);
                } else {
                    $this->method->ViewValue = $this->method->CurrentValue;
                }
            }
        } else {
            $this->method->ViewValue = null;
        }

        // sqm_method
        if (strval($this->sqm_method->CurrentValue) != "") {
            $this->sqm_method->ViewValue = $this->sqm_method->optionCaption($this->sqm_method->CurrentValue);
        } else {
            $this->sqm_method->ViewValue = null;
        }

        // unit
        if (strval($this->unit->CurrentValue) != "") {
            $this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
        } else {
            $this->unit->ViewValue = null;
        }

        // @_unit
        $this->_unit->ViewValue = $this->_unit->CurrentValue;
        $this->_unit->ViewValue = FormatNumber($this->_unit->ViewValue, $this->_unit->formatPattern());

        // @
        $this->_40->ViewValue = $this->_40->CurrentValue;
        $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

        // extra_plan
        if (strval($this->extra_plan->CurrentValue) != "") {
            $this->extra_plan->ViewValue = $this->extra_plan->optionCaption($this->extra_plan->CurrentValue);
        } else {
            $this->extra_plan->ViewValue = null;
        }

        // custom_size
        $this->custom_size->ViewValue = $this->custom_size->CurrentValue;
        $this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, $this->custom_size->formatPattern());

        // custom_size_below_st
        $this->custom_size_below_st->ViewValue = $this->custom_size_below_st->CurrentValue;
        $this->custom_size_below_st->ViewValue = FormatNumber($this->custom_size_below_st->ViewValue, $this->custom_size_below_st->formatPattern());

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // uploads
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->ViewValue = "";
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // plan_type
        if (!EmptyValue($this->plan_type->CurrentValue)) {
            $this->plan_type->HrefValue = $this->plan_type->getLinkPrefix() . $this->plan_type->CurrentValue; // Add prefix/suffix
            $this->plan_type->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
            }
        } else {
            $this->plan_type->HrefValue = "";
        }
        $this->plan_type->TooltipValue = "";

        // location
        if (!EmptyValue($this->location->CurrentValue)) {
            $this->location->HrefValue = $this->location->getLinkPrefix() . $this->location->CurrentValue; // Add prefix/suffix
            $this->location->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
            }
        } else {
            $this->location->HrefValue = "";
        }
        $this->location->TooltipValue = "";

        // from_date
        $this->from_date->HrefValue = "";
        $this->from_date->TooltipValue = "";

        // to_date
        $this->to_date->HrefValue = "";
        $this->to_date->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // process
        if (!EmptyValue($this->process->CurrentValue)) {
            $this->process->HrefValue = $this->process->getLinkPrefix() . $this->process->CurrentValue; // Add prefix/suffix
            $this->process->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
            }
        } else {
            $this->process->HrefValue = "";
        }
        $this->process->TooltipValue = "";

        // product_type
        $this->product_type->HrefValue = "";
        $this->product_type->TooltipValue = "";

        // shape
        $this->shape->HrefValue = "";
        $this->shape->TooltipValue = "";

        // selection
        $this->selection->HrefValue = "";
        $this->selection->TooltipValue = "";

        // gcode
        if (!EmptyValue($this->gcode->CurrentValue)) {
            $this->gcode->HrefValue = $this->gcode->getLinkPrefix() . $this->gcode->CurrentValue; // Add prefix/suffix
            $this->gcode->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
            }
        } else {
            $this->gcode->HrefValue = "";
        }
        $this->gcode->TooltipValue = "";

        // ref
        if (!EmptyValue($this->gcode->CurrentValue)) {
            $this->ref->HrefValue = $this->ref->getLinkPrefix() . $this->gcode->CurrentValue; // Add prefix/suffix
            $this->ref->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
            }
        } else {
            $this->ref->HrefValue = "";
        }
        $this->ref->TooltipValue = "";

        // description
        $this->description->HrefValue = "";
        $this->description->TooltipValue = "";

        // yes_no
        $this->yes_no->HrefValue = "";
        $this->yes_no->TooltipValue = "";

        // packing_payment_type
        $this->packing_payment_type->HrefValue = "";
        $this->packing_payment_type->TooltipValue = "";

        // fix
        $this->fix->HrefValue = "";
        $this->fix->TooltipValue = "";

        // method
        $this->method->HrefValue = "";
        $this->method->TooltipValue = "";

        // sqm_method
        $this->sqm_method->HrefValue = "";
        $this->sqm_method->TooltipValue = "";

        // unit
        $this->unit->HrefValue = "";
        $this->unit->TooltipValue = "";

        // @_unit
        $this->_unit->HrefValue = "";
        $this->_unit->TooltipValue = "";

        // @
        $this->_40->HrefValue = "";
        $this->_40->TooltipValue = "";

        // extra_plan
        $this->extra_plan->HrefValue = "";
        $this->extra_plan->TooltipValue = "";

        // custom_size
        $this->custom_size->HrefValue = "";
        $this->custom_size->TooltipValue = "";

        // custom_size_below_st
        $this->custom_size_below_st->HrefValue = "";
        $this->custom_size_below_st->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // uploads
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->HrefValue = "%u"; // Add prefix/suffix
            $this->uploads->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
            }
        } else {
            $this->uploads->HrefValue = "";
        }
        $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        $this->uploads->TooltipValue = "";
        if ($this->uploads->UseColorbox) {
            if (EmptyValue($this->uploads->TooltipValue)) {
                $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->uploads->LinkAttrs["data-rel"] = "payment_plan_x_uploads";
            $this->uploads->LinkAttrs->appendClass("ew-lightbox");
        }

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // plan_type
        $this->plan_type->setupEditAttributes();
        $this->plan_type->EditValue = $this->plan_type->options(true);
        $this->plan_type->PlaceHolder = RemoveHtml($this->plan_type->caption());

        // location
        $this->location->PlaceHolder = RemoveHtml($this->location->caption());

        // from_date
        $this->from_date->setupEditAttributes();
        $this->from_date->EditValue = FormatDateTime($this->from_date->CurrentValue, $this->from_date->formatPattern());
        $this->from_date->PlaceHolder = RemoveHtml($this->from_date->caption());

        // to_date
        $this->to_date->setupEditAttributes();
        $this->to_date->EditValue = FormatDateTime($this->to_date->CurrentValue, $this->to_date->formatPattern());
        $this->to_date->PlaceHolder = RemoveHtml($this->to_date->caption());

        // grp
        $this->grp->setupEditAttributes();
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->EditValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->EditValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->EditValue = null;
        }

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // process
        $this->process->setupEditAttributes();
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // product_type
        $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

        // shape
        $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

        // selection
        $this->selection->setupEditAttributes();
        $this->selection->EditValue = $this->selection->options(true);
        $this->selection->PlaceHolder = RemoveHtml($this->selection->caption());

        // gcode
        $this->gcode->setupEditAttributes();
        $this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

        // ref
        $this->ref->setupEditAttributes();
        $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

        // description
        $this->description->setupEditAttributes();
        if (!$this->description->Raw) {
            $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
        }
        $this->description->EditValue = $this->description->CurrentValue;
        $this->description->PlaceHolder = RemoveHtml($this->description->caption());

        // yes_no
        $this->yes_no->setupEditAttributes();
        $this->yes_no->EditValue = $this->yes_no->options(true);
        $this->yes_no->PlaceHolder = RemoveHtml($this->yes_no->caption());

        // packing_payment_type
        $this->packing_payment_type->setupEditAttributes();
        $this->packing_payment_type->EditValue = $this->packing_payment_type->options(true);
        $this->packing_payment_type->PlaceHolder = RemoveHtml($this->packing_payment_type->caption());

        // fix
        $this->fix->setupEditAttributes();
        $this->fix->EditValue = $this->fix->options(true);
        $this->fix->PlaceHolder = RemoveHtml($this->fix->caption());

        // method
        $this->method->setupEditAttributes();
        $this->method->PlaceHolder = RemoveHtml($this->method->caption());

        // sqm_method
        $this->sqm_method->setupEditAttributes();
        $this->sqm_method->EditValue = $this->sqm_method->options(true);
        $this->sqm_method->PlaceHolder = RemoveHtml($this->sqm_method->caption());

        // unit
        $this->unit->setupEditAttributes();
        $this->unit->EditValue = $this->unit->options(true);
        $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

        // @_unit
        $this->_unit->setupEditAttributes();
        $this->_unit->EditValue = $this->_unit->CurrentValue;
        $this->_unit->PlaceHolder = RemoveHtml($this->_unit->caption());
        if (strval($this->_unit->EditValue) != "" && is_numeric($this->_unit->EditValue)) {
            $this->_unit->EditValue = FormatNumber($this->_unit->EditValue, null);
        }

        // @
        $this->_40->setupEditAttributes();
        $this->_40->EditValue = $this->_40->CurrentValue;
        $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
        if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
            $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
        }

        // extra_plan
        $this->extra_plan->setupEditAttributes();
        $this->extra_plan->EditValue = $this->extra_plan->options(true);
        $this->extra_plan->PlaceHolder = RemoveHtml($this->extra_plan->caption());

        // custom_size
        $this->custom_size->setupEditAttributes();
        $this->custom_size->EditValue = $this->custom_size->CurrentValue;
        $this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());
        if (strval($this->custom_size->EditValue) != "" && is_numeric($this->custom_size->EditValue)) {
            $this->custom_size->EditValue = FormatNumber($this->custom_size->EditValue, null);
        }

        // custom_size_below_st
        $this->custom_size_below_st->setupEditAttributes();
        $this->custom_size_below_st->EditValue = $this->custom_size_below_st->CurrentValue;
        $this->custom_size_below_st->PlaceHolder = RemoveHtml($this->custom_size_below_st->caption());
        if (strval($this->custom_size_below_st->EditValue) != "" && is_numeric($this->custom_size_below_st->EditValue)) {
            $this->custom_size_below_st->EditValue = FormatNumber($this->custom_size_below_st->EditValue, null);
        }

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // uploads
        $this->uploads->setupEditAttributes();
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->EditValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->EditValue = "";
        }
        if (!EmptyValue($this->uploads->CurrentValue)) {
            $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
        }

        // operator

        // datetime

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->plan_type);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->from_date);
                    $doc->exportCaption($this->to_date);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->selection);
                    $doc->exportCaption($this->gcode);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->yes_no);
                    $doc->exportCaption($this->packing_payment_type);
                    $doc->exportCaption($this->fix);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->sqm_method);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->_unit);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->extra_plan);
                    $doc->exportCaption($this->custom_size);
                    $doc->exportCaption($this->custom_size_below_st);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->uploads);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->plan_type);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->from_date);
                    $doc->exportCaption($this->to_date);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->selection);
                    $doc->exportCaption($this->gcode);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->yes_no);
                    $doc->exportCaption($this->packing_payment_type);
                    $doc->exportCaption($this->fix);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->sqm_method);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->_unit);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->extra_plan);
                    $doc->exportCaption($this->custom_size);
                    $doc->exportCaption($this->custom_size_below_st);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->uploads);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->plan_type);
                        $doc->exportField($this->location);
                        $doc->exportField($this->from_date);
                        $doc->exportField($this->to_date);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->process);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->selection);
                        $doc->exportField($this->gcode);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->description);
                        $doc->exportField($this->yes_no);
                        $doc->exportField($this->packing_payment_type);
                        $doc->exportField($this->fix);
                        $doc->exportField($this->method);
                        $doc->exportField($this->sqm_method);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->_unit);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->extra_plan);
                        $doc->exportField($this->custom_size);
                        $doc->exportField($this->custom_size_below_st);
                        $doc->exportField($this->status);
                        $doc->exportField($this->uploads);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->plan_type);
                        $doc->exportField($this->location);
                        $doc->exportField($this->from_date);
                        $doc->exportField($this->to_date);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->process);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->selection);
                        $doc->exportField($this->gcode);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->description);
                        $doc->exportField($this->yes_no);
                        $doc->exportField($this->packing_payment_type);
                        $doc->exportField($this->fix);
                        $doc->exportField($this->method);
                        $doc->exportField($this->sqm_method);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->_unit);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->extra_plan);
                        $doc->exportField($this->custom_size);
                        $doc->exportField($this->custom_size_below_st);
                        $doc->exportField($this->status);
                        $doc->exportField($this->uploads);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'uploads') {
            $fldName = "uploads";
            $fileNameFld = "uploads";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'payment_plan');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'payment_plan', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'payment_plan', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'payment_plan', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
