<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PartnerQuotationPpAdd extends PartnerQuotationPp
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PartnerQuotationPpAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "partnerquotationppadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->product_type->setVisibility();
        $this->product->setVisibility();
        $this->product_code->setVisibility();
        $this->partner_code->setVisibility();
        $this->packing_type->setVisibility();
        $this->unit->setVisibility();
        $this->quantity->setVisibility();
        $this->price->setVisibility();
        $this->amount->setVisibility();
        $this->currency->setVisibility();
        $this->total_amount->setVisibility();
        $this->remarks->setVisibility();
        $this->payment_terms->setVisibility();
        $this->tax_categories->setVisibility();
        $this->delivery_period->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->status->setVisibility();
        $this->pp_operator->setVisibility();
        $this->pp_datetime->setVisibility();
        $this->quantity_approx->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'partner_quotation_pp';
        $this->TableName = 'partner_quotation_pp';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (partner_quotation_pp)
        if (!isset($GLOBALS["partner_quotation_pp"]) || $GLOBALS["partner_quotation_pp"]::class == PROJECT_NAMESPACE . "partner_quotation_pp") {
            $GLOBALS["partner_quotation_pp"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'partner_quotation_pp');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "partnerquotationppview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("partnerquotationpplist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "partnerquotationpplist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "partnerquotationppview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "partnerquotationpplist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "partnerquotationpplist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->delivery_period->DefaultValue = $this->delivery_period->getDefault(); // PHP
        $this->delivery_period->OldValue = $this->delivery_period->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'partner_id' first before field var 'x_partner_id'
        $val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
        if (!$this->partner_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product_code' first before field var 'x_product_code'
        $val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
        if (!$this->product_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_code->Visible = false; // Disable update for API request
            } else {
                $this->product_code->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'partner_code' first before field var 'x_partner_code'
        $val = $CurrentForm->hasValue("partner_code") ? $CurrentForm->getValue("partner_code") : $CurrentForm->getValue("x_partner_code");
        if (!$this->partner_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_code->Visible = false; // Disable update for API request
            } else {
                $this->partner_code->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'total_amount' first before field var 'x_total_amount'
        $val = $CurrentForm->hasValue("total_amount") ? $CurrentForm->getValue("total_amount") : $CurrentForm->getValue("x_total_amount");
        if (!$this->total_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->total_amount->Visible = false; // Disable update for API request
            } else {
                $this->total_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'payment_terms' first before field var 'x_payment_terms'
        $val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
        if (!$this->payment_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_terms->Visible = false; // Disable update for API request
            } else {
                $this->payment_terms->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'tax_categories' first before field var 'x_tax_categories'
        $val = $CurrentForm->hasValue("tax_categories") ? $CurrentForm->getValue("tax_categories") : $CurrentForm->getValue("x_tax_categories");
        if (!$this->tax_categories->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tax_categories->Visible = false; // Disable update for API request
            } else {
                $this->tax_categories->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'delivery_period' first before field var 'x_delivery_period'
        $val = $CurrentForm->hasValue("delivery_period") ? $CurrentForm->getValue("delivery_period") : $CurrentForm->getValue("x_delivery_period");
        if (!$this->delivery_period->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery_period->Visible = false; // Disable update for API request
            } else {
                $this->delivery_period->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val, true, $validate);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pp_operator' first before field var 'x_pp_operator'
        $val = $CurrentForm->hasValue("pp_operator") ? $CurrentForm->getValue("pp_operator") : $CurrentForm->getValue("x_pp_operator");
        if (!$this->pp_operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pp_operator->Visible = false; // Disable update for API request
            } else {
                $this->pp_operator->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pp_datetime' first before field var 'x_pp_datetime'
        $val = $CurrentForm->hasValue("pp_datetime") ? $CurrentForm->getValue("pp_datetime") : $CurrentForm->getValue("x_pp_datetime");
        if (!$this->pp_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pp_datetime->Visible = false; // Disable update for API request
            } else {
                $this->pp_datetime->setFormValue($val, true, $validate);
            }
            $this->pp_datetime->CurrentValue = UnFormatDateTime($this->pp_datetime->CurrentValue, $this->pp_datetime->formatPattern());
        }

        // Check field name 'quantity_approx' first before field var 'x_quantity_approx'
        $val = $CurrentForm->hasValue("quantity_approx") ? $CurrentForm->getValue("quantity_approx") : $CurrentForm->getValue("x_quantity_approx");
        if (!$this->quantity_approx->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity_approx->Visible = false; // Disable update for API request
            } else {
                $this->quantity_approx->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->partner_id->CurrentValue = $this->partner_id->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->product_code->CurrentValue = $this->product_code->FormValue;
        $this->partner_code->CurrentValue = $this->partner_code->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->total_amount->CurrentValue = $this->total_amount->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
        $this->tax_categories->CurrentValue = $this->tax_categories->FormValue;
        $this->delivery_period->CurrentValue = $this->delivery_period->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->status->CurrentValue = $this->status->FormValue;
        $this->pp_operator->CurrentValue = $this->pp_operator->FormValue;
        $this->pp_datetime->CurrentValue = $this->pp_datetime->FormValue;
        $this->pp_datetime->CurrentValue = UnFormatDateTime($this->pp_datetime->CurrentValue, $this->pp_datetime->formatPattern());
        $this->quantity_approx->CurrentValue = $this->quantity_approx->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->product_type->setDbValue($row['product_type']);
        $this->product->setDbValue($row['product']);
        $this->product_code->setDbValue($row['product_code']);
        $this->partner_code->setDbValue($row['partner_code']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->unit->setDbValue($row['unit']);
        $this->quantity->setDbValue($row['quantity']);
        $this->price->setDbValue($row['price']);
        $this->amount->setDbValue($row['amount']);
        $this->currency->setDbValue($row['currency']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->remarks->setDbValue($row['remarks']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->tax_categories->setDbValue($row['tax_categories']);
        $this->delivery_period->setDbValue($row['delivery_period']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->status->setDbValue($row['status']);
        $this->pp_operator->setDbValue($row['pp_operator']);
        $this->pp_datetime->setDbValue($row['pp_datetime']);
        $this->quantity_approx->setDbValue($row['quantity_approx']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['partner_code'] = $this->partner_code->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['tax_categories'] = $this->tax_categories->DefaultValue;
        $row['delivery_period'] = $this->delivery_period->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['pp_operator'] = $this->pp_operator->DefaultValue;
        $row['pp_datetime'] = $this->pp_datetime->DefaultValue;
        $row['quantity_approx'] = $this->quantity_approx->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // partner_code
        $this->partner_code->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // total_amount
        $this->total_amount->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // tax_categories
        $this->tax_categories->RowCssClass = "row";

        // delivery_period
        $this->delivery_period->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // pp_operator
        $this->pp_operator->RowCssClass = "row";

        // pp_datetime
        $this->pp_datetime->RowCssClass = "row";

        // quantity_approx
        $this->quantity_approx->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, $this->company_id->formatPattern());

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $this->partner_id->ViewValue = FormatNumber($this->partner_id->ViewValue, $this->partner_id->formatPattern());

            // product_type
            $this->product_type->ViewValue = $this->product_type->CurrentValue;
            $this->product_type->ViewValue = FormatNumber($this->product_type->ViewValue, $this->product_type->formatPattern());

            // product
            $this->product->ViewValue = $this->product->CurrentValue;
            $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;
            $this->product_code->ViewValue = FormatNumber($this->product_code->ViewValue, $this->product_code->formatPattern());

            // partner_code
            $this->partner_code->ViewValue = $this->partner_code->CurrentValue;

            // packing_type
            $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
            $this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, $this->packing_type->formatPattern());

            // unit
            $this->unit->ViewValue = $this->unit->CurrentValue;
            $this->unit->ViewValue = FormatNumber($this->unit->ViewValue, $this->unit->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // currency
            $this->currency->ViewValue = $this->currency->CurrentValue;
            $this->currency->ViewValue = FormatNumber($this->currency->ViewValue, $this->currency->formatPattern());

            // total_amount
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // payment_terms
            $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
            $this->payment_terms->ViewValue = FormatNumber($this->payment_terms->ViewValue, $this->payment_terms->formatPattern());

            // tax_categories
            $this->tax_categories->ViewValue = $this->tax_categories->CurrentValue;
            $this->tax_categories->ViewValue = FormatNumber($this->tax_categories->ViewValue, $this->tax_categories->formatPattern());

            // delivery_period
            $this->delivery_period->ViewValue = $this->delivery_period->CurrentValue;
            $this->delivery_period->ViewValue = FormatNumber($this->delivery_period->ViewValue, $this->delivery_period->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // status
            $this->status->ViewValue = $this->status->CurrentValue;
            $this->status->ViewValue = FormatNumber($this->status->ViewValue, $this->status->formatPattern());

            // pp_operator
            $this->pp_operator->ViewValue = $this->pp_operator->CurrentValue;
            $this->pp_operator->ViewValue = FormatNumber($this->pp_operator->ViewValue, $this->pp_operator->formatPattern());

            // pp_datetime
            $this->pp_datetime->ViewValue = $this->pp_datetime->CurrentValue;
            $this->pp_datetime->ViewValue = FormatDateTime($this->pp_datetime->ViewValue, $this->pp_datetime->formatPattern());

            // quantity_approx
            $this->quantity_approx->ViewValue = $this->quantity_approx->CurrentValue;

            // company_id
            $this->company_id->HrefValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // partner_code
            $this->partner_code->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";

            // tax_categories
            $this->tax_categories->HrefValue = "";

            // delivery_period
            $this->delivery_period->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // pp_operator
            $this->pp_operator->HrefValue = "";

            // pp_datetime
            $this->pp_datetime->HrefValue = "";

            // quantity_approx
            $this->quantity_approx->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());
            if (strval($this->company_id->EditValue) != "" && is_numeric($this->company_id->EditValue)) {
                $this->company_id->EditValue = FormatNumber($this->company_id->EditValue, null);
            }

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->CurrentValue;
            $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());
            if (strval($this->partner_id->EditValue) != "" && is_numeric($this->partner_id->EditValue)) {
                $this->partner_id->EditValue = FormatNumber($this->partner_id->EditValue, null);
            }

            // product_type
            $this->product_type->setupEditAttributes();
            $this->product_type->EditValue = $this->product_type->CurrentValue;
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());
            if (strval($this->product_type->EditValue) != "" && is_numeric($this->product_type->EditValue)) {
                $this->product_type->EditValue = FormatNumber($this->product_type->EditValue, null);
            }

            // product
            $this->product->setupEditAttributes();
            $this->product->EditValue = $this->product->CurrentValue;
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());
            if (strval($this->product->EditValue) != "" && is_numeric($this->product->EditValue)) {
                $this->product->EditValue = FormatNumber($this->product->EditValue, null);
            }

            // product_code
            $this->product_code->setupEditAttributes();
            $this->product_code->EditValue = $this->product_code->CurrentValue;
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());
            if (strval($this->product_code->EditValue) != "" && is_numeric($this->product_code->EditValue)) {
                $this->product_code->EditValue = FormatNumber($this->product_code->EditValue, null);
            }

            // partner_code
            $this->partner_code->setupEditAttributes();
            if (!$this->partner_code->Raw) {
                $this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
            }
            $this->partner_code->EditValue = HtmlEncode($this->partner_code->CurrentValue);
            $this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $this->packing_type->EditValue = $this->packing_type->CurrentValue;
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
            if (strval($this->packing_type->EditValue) != "" && is_numeric($this->packing_type->EditValue)) {
                $this->packing_type->EditValue = FormatNumber($this->packing_type->EditValue, null);
            }

            // unit
            $this->unit->setupEditAttributes();
            $this->unit->EditValue = $this->unit->CurrentValue;
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());
            if (strval($this->unit->EditValue) != "" && is_numeric($this->unit->EditValue)) {
                $this->unit->EditValue = FormatNumber($this->unit->EditValue, null);
            }

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $this->currency->EditValue = $this->currency->CurrentValue;
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());
            if (strval($this->currency->EditValue) != "" && is_numeric($this->currency->EditValue)) {
                $this->currency->EditValue = FormatNumber($this->currency->EditValue, null);
            }

            // total_amount
            $this->total_amount->setupEditAttributes();
            $this->total_amount->EditValue = $this->total_amount->CurrentValue;
            $this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());
            if (strval($this->total_amount->EditValue) != "" && is_numeric($this->total_amount->EditValue)) {
                $this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            $this->payment_terms->EditValue = $this->payment_terms->CurrentValue;
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());
            if (strval($this->payment_terms->EditValue) != "" && is_numeric($this->payment_terms->EditValue)) {
                $this->payment_terms->EditValue = FormatNumber($this->payment_terms->EditValue, null);
            }

            // tax_categories
            $this->tax_categories->setupEditAttributes();
            $this->tax_categories->EditValue = $this->tax_categories->CurrentValue;
            $this->tax_categories->PlaceHolder = RemoveHtml($this->tax_categories->caption());
            if (strval($this->tax_categories->EditValue) != "" && is_numeric($this->tax_categories->EditValue)) {
                $this->tax_categories->EditValue = FormatNumber($this->tax_categories->EditValue, null);
            }

            // delivery_period
            $this->delivery_period->setupEditAttributes();
            $this->delivery_period->EditValue = $this->delivery_period->CurrentValue;
            $this->delivery_period->PlaceHolder = RemoveHtml($this->delivery_period->caption());
            if (strval($this->delivery_period->EditValue) != "" && is_numeric($this->delivery_period->EditValue)) {
                $this->delivery_period->EditValue = FormatNumber($this->delivery_period->EditValue, null);
            }

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->CurrentValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
            if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
                $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
            }

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->CurrentValue;
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());
            if (strval($this->status->EditValue) != "" && is_numeric($this->status->EditValue)) {
                $this->status->EditValue = FormatNumber($this->status->EditValue, null);
            }

            // pp_operator
            $this->pp_operator->setupEditAttributes();
            $this->pp_operator->EditValue = $this->pp_operator->CurrentValue;
            $this->pp_operator->PlaceHolder = RemoveHtml($this->pp_operator->caption());
            if (strval($this->pp_operator->EditValue) != "" && is_numeric($this->pp_operator->EditValue)) {
                $this->pp_operator->EditValue = FormatNumber($this->pp_operator->EditValue, null);
            }

            // pp_datetime
            $this->pp_datetime->setupEditAttributes();
            $this->pp_datetime->EditValue = HtmlEncode(FormatDateTime($this->pp_datetime->CurrentValue, $this->pp_datetime->formatPattern()));
            $this->pp_datetime->PlaceHolder = RemoveHtml($this->pp_datetime->caption());

            // quantity_approx
            $this->quantity_approx->setupEditAttributes();
            if (!$this->quantity_approx->Raw) {
                $this->quantity_approx->CurrentValue = HtmlDecode($this->quantity_approx->CurrentValue);
            }
            $this->quantity_approx->EditValue = HtmlEncode($this->quantity_approx->CurrentValue);
            $this->quantity_approx->PlaceHolder = RemoveHtml($this->quantity_approx->caption());

            // Add refer script

            // company_id
            $this->company_id->HrefValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // partner_code
            $this->partner_code->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // payment_terms
            $this->payment_terms->HrefValue = "";

            // tax_categories
            $this->tax_categories->HrefValue = "";

            // delivery_period
            $this->delivery_period->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // pp_operator
            $this->pp_operator->HrefValue = "";

            // pp_datetime
            $this->pp_datetime->HrefValue = "";

            // quantity_approx
            $this->quantity_approx->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->company_id->FormValue)) {
                $this->company_id->addErrorMessage($this->company_id->getErrorMessage(false));
            }
            if ($this->partner_id->Visible && $this->partner_id->Required) {
                if (!$this->partner_id->IsDetailKey && EmptyValue($this->partner_id->FormValue)) {
                    $this->partner_id->addErrorMessage(str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->partner_id->FormValue)) {
                $this->partner_id->addErrorMessage($this->partner_id->getErrorMessage(false));
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->product_type->FormValue)) {
                $this->product_type->addErrorMessage($this->product_type->getErrorMessage(false));
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->product->FormValue)) {
                $this->product->addErrorMessage($this->product->getErrorMessage(false));
            }
            if ($this->product_code->Visible && $this->product_code->Required) {
                if (!$this->product_code->IsDetailKey && EmptyValue($this->product_code->FormValue)) {
                    $this->product_code->addErrorMessage(str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->product_code->FormValue)) {
                $this->product_code->addErrorMessage($this->product_code->getErrorMessage(false));
            }
            if ($this->partner_code->Visible && $this->partner_code->Required) {
                if (!$this->partner_code->IsDetailKey && EmptyValue($this->partner_code->FormValue)) {
                    $this->partner_code->addErrorMessage(str_replace("%s", $this->partner_code->caption(), $this->partner_code->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->packing_type->FormValue)) {
                $this->packing_type->addErrorMessage($this->packing_type->getErrorMessage(false));
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->unit->FormValue)) {
                $this->unit->addErrorMessage($this->unit->getErrorMessage(false));
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price->FormValue)) {
                $this->price->addErrorMessage($this->price->getErrorMessage(false));
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->currency->FormValue)) {
                $this->currency->addErrorMessage($this->currency->getErrorMessage(false));
            }
            if ($this->total_amount->Visible && $this->total_amount->Required) {
                if (!$this->total_amount->IsDetailKey && EmptyValue($this->total_amount->FormValue)) {
                    $this->total_amount->addErrorMessage(str_replace("%s", $this->total_amount->caption(), $this->total_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->total_amount->FormValue)) {
                $this->total_amount->addErrorMessage($this->total_amount->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->payment_terms->Visible && $this->payment_terms->Required) {
                if (!$this->payment_terms->IsDetailKey && EmptyValue($this->payment_terms->FormValue)) {
                    $this->payment_terms->addErrorMessage(str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->payment_terms->FormValue)) {
                $this->payment_terms->addErrorMessage($this->payment_terms->getErrorMessage(false));
            }
            if ($this->tax_categories->Visible && $this->tax_categories->Required) {
                if (!$this->tax_categories->IsDetailKey && EmptyValue($this->tax_categories->FormValue)) {
                    $this->tax_categories->addErrorMessage(str_replace("%s", $this->tax_categories->caption(), $this->tax_categories->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->tax_categories->FormValue)) {
                $this->tax_categories->addErrorMessage($this->tax_categories->getErrorMessage(false));
            }
            if ($this->delivery_period->Visible && $this->delivery_period->Required) {
                if (!$this->delivery_period->IsDetailKey && EmptyValue($this->delivery_period->FormValue)) {
                    $this->delivery_period->addErrorMessage(str_replace("%s", $this->delivery_period->caption(), $this->delivery_period->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->delivery_period->FormValue)) {
                $this->delivery_period->addErrorMessage($this->delivery_period->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->operator->FormValue)) {
                $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->datetime->FormValue, $this->datetime->formatPattern())) {
                $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->status->FormValue)) {
                $this->status->addErrorMessage($this->status->getErrorMessage(false));
            }
            if ($this->pp_operator->Visible && $this->pp_operator->Required) {
                if (!$this->pp_operator->IsDetailKey && EmptyValue($this->pp_operator->FormValue)) {
                    $this->pp_operator->addErrorMessage(str_replace("%s", $this->pp_operator->caption(), $this->pp_operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->pp_operator->FormValue)) {
                $this->pp_operator->addErrorMessage($this->pp_operator->getErrorMessage(false));
            }
            if ($this->pp_datetime->Visible && $this->pp_datetime->Required) {
                if (!$this->pp_datetime->IsDetailKey && EmptyValue($this->pp_datetime->FormValue)) {
                    $this->pp_datetime->addErrorMessage(str_replace("%s", $this->pp_datetime->caption(), $this->pp_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->pp_datetime->FormValue, $this->pp_datetime->formatPattern())) {
                $this->pp_datetime->addErrorMessage($this->pp_datetime->getErrorMessage(false));
            }
            if ($this->quantity_approx->Visible && $this->quantity_approx->Required) {
                if (!$this->quantity_approx->IsDetailKey && EmptyValue($this->quantity_approx->FormValue)) {
                    $this->quantity_approx->addErrorMessage(str_replace("%s", $this->quantity_approx->caption(), $this->quantity_approx->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // partner_id
        $this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, false);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // product_code
        $this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, false);

        // partner_code
        $this->partner_code->setDbValueDef($rsnew, $this->partner_code->CurrentValue, false);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, false);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, false);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, false);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, false);

        // total_amount
        $this->total_amount->setDbValueDef($rsnew, $this->total_amount->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // payment_terms
        $this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, false);

        // tax_categories
        $this->tax_categories->setDbValueDef($rsnew, $this->tax_categories->CurrentValue, false);

        // delivery_period
        $this->delivery_period->setDbValueDef($rsnew, $this->delivery_period->CurrentValue, strval($this->delivery_period->CurrentValue) == "");

        // operator
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // pp_operator
        $this->pp_operator->setDbValueDef($rsnew, $this->pp_operator->CurrentValue, false);

        // pp_datetime
        $this->pp_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->pp_datetime->CurrentValue, $this->pp_datetime->formatPattern()), false);

        // quantity_approx
        $this->quantity_approx->setDbValueDef($rsnew, $this->quantity_approx->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['partner_id'])) { // partner_id
            $this->partner_id->setFormValue($row['partner_id']);
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->setFormValue($row['product_type']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['product_code'])) { // product_code
            $this->product_code->setFormValue($row['product_code']);
        }
        if (isset($row['partner_code'])) { // partner_code
            $this->partner_code->setFormValue($row['partner_code']);
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->setFormValue($row['packing_type']);
        }
        if (isset($row['unit'])) { // unit
            $this->unit->setFormValue($row['unit']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['price'])) { // price
            $this->price->setFormValue($row['price']);
        }
        if (isset($row['amount'])) { // amount
            $this->amount->setFormValue($row['amount']);
        }
        if (isset($row['currency'])) { // currency
            $this->currency->setFormValue($row['currency']);
        }
        if (isset($row['total_amount'])) { // total_amount
            $this->total_amount->setFormValue($row['total_amount']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['payment_terms'])) { // payment_terms
            $this->payment_terms->setFormValue($row['payment_terms']);
        }
        if (isset($row['tax_categories'])) { // tax_categories
            $this->tax_categories->setFormValue($row['tax_categories']);
        }
        if (isset($row['delivery_period'])) { // delivery_period
            $this->delivery_period->setFormValue($row['delivery_period']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['pp_operator'])) { // pp_operator
            $this->pp_operator->setFormValue($row['pp_operator']);
        }
        if (isset($row['pp_datetime'])) { // pp_datetime
            $this->pp_datetime->setFormValue($row['pp_datetime']);
        }
        if (isset($row['quantity_approx'])) { // quantity_approx
            $this->quantity_approx->setFormValue($row['quantity_approx']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("partnerquotationpplist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
