<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PartnerQuotationBuyerList extends PartnerQuotationBuyer
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PartnerQuotationBuyerList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fpartner_quotation_buyerlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "partnerquotationbuyerlist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->partner_details->Visible = false;
        $this->product_type->setVisibility();
        $this->product->setVisibility();
        $this->product_code->setVisibility();
        $this->partner_code->setVisibility();
        $this->packing_type->setVisibility();
        $this->unit->setVisibility();
        $this->quantity_approx->setVisibility();
        $this->quantity->setVisibility();
        $this->price->setVisibility();
        $this->amount->setVisibility();
        $this->currency->setVisibility();
        $this->total_amount->setVisibility();
        $this->remarks->setVisibility();
        $this->payment_terms->setVisibility();
        $this->tax_categories->setVisibility();
        $this->delivery_period->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->pp_operator->setVisibility();
        $this->pp_datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'partner_quotation_buyer';
        $this->TableName = 'partner_quotation_buyer';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (partner_quotation_buyer)
        if (!isset($GLOBALS["partner_quotation_buyer"]) || $GLOBALS["partner_quotation_buyer"]::class == PROJECT_NAMESPACE . "partner_quotation_buyer") {
            $GLOBALS["partner_quotation_buyer"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "partnerquotationbuyeradd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "partnerquotationbuyerdelete";
        $this->MultiUpdateUrl = "partnerquotationbuyerupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'partner_quotation_buyer');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "partnerquotationbuyerview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->pp_operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->pp_datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->product_code);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->tax_categories);
        $this->setupLookupOptions($this->status);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fpartner_quotation_buyergrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fpartner_quotation_buyersrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
        $filterList = Concat($filterList, $this->partner_id->AdvancedSearch->toJson(), ","); // Field partner_id
        $filterList = Concat($filterList, $this->partner_details->AdvancedSearch->toJson(), ","); // Field partner_details
        $filterList = Concat($filterList, $this->product_type->AdvancedSearch->toJson(), ","); // Field product_type
        $filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
        $filterList = Concat($filterList, $this->product_code->AdvancedSearch->toJson(), ","); // Field product_code
        $filterList = Concat($filterList, $this->partner_code->AdvancedSearch->toJson(), ","); // Field partner_code
        $filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
        $filterList = Concat($filterList, $this->unit->AdvancedSearch->toJson(), ","); // Field unit
        $filterList = Concat($filterList, $this->quantity_approx->AdvancedSearch->toJson(), ","); // Field quantity_approx
        $filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
        $filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
        $filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
        $filterList = Concat($filterList, $this->currency->AdvancedSearch->toJson(), ","); // Field currency
        $filterList = Concat($filterList, $this->total_amount->AdvancedSearch->toJson(), ","); // Field total_amount
        $filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
        $filterList = Concat($filterList, $this->payment_terms->AdvancedSearch->toJson(), ","); // Field payment_terms
        $filterList = Concat($filterList, $this->tax_categories->AdvancedSearch->toJson(), ","); // Field tax_categories
        $filterList = Concat($filterList, $this->delivery_period->AdvancedSearch->toJson(), ","); // Field delivery_period
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->pp_operator->AdvancedSearch->toJson(), ","); // Field pp_operator
        $filterList = Concat($filterList, $this->pp_datetime->AdvancedSearch->toJson(), ","); // Field pp_datetime
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fpartner_quotation_buyersrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field company_id
        $this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
        $this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
        $this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
        $this->company_id->AdvancedSearch->save();

        // Field partner_id
        $this->partner_id->AdvancedSearch->SearchValue = @$filter["x_partner_id"];
        $this->partner_id->AdvancedSearch->SearchOperator = @$filter["z_partner_id"];
        $this->partner_id->AdvancedSearch->SearchCondition = @$filter["v_partner_id"];
        $this->partner_id->AdvancedSearch->SearchValue2 = @$filter["y_partner_id"];
        $this->partner_id->AdvancedSearch->SearchOperator2 = @$filter["w_partner_id"];
        $this->partner_id->AdvancedSearch->save();

        // Field partner_details
        $this->partner_details->AdvancedSearch->SearchValue = @$filter["x_partner_details"];
        $this->partner_details->AdvancedSearch->SearchOperator = @$filter["z_partner_details"];
        $this->partner_details->AdvancedSearch->SearchCondition = @$filter["v_partner_details"];
        $this->partner_details->AdvancedSearch->SearchValue2 = @$filter["y_partner_details"];
        $this->partner_details->AdvancedSearch->SearchOperator2 = @$filter["w_partner_details"];
        $this->partner_details->AdvancedSearch->save();

        // Field product_type
        $this->product_type->AdvancedSearch->SearchValue = @$filter["x_product_type"];
        $this->product_type->AdvancedSearch->SearchOperator = @$filter["z_product_type"];
        $this->product_type->AdvancedSearch->SearchCondition = @$filter["v_product_type"];
        $this->product_type->AdvancedSearch->SearchValue2 = @$filter["y_product_type"];
        $this->product_type->AdvancedSearch->SearchOperator2 = @$filter["w_product_type"];
        $this->product_type->AdvancedSearch->save();

        // Field product
        $this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
        $this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
        $this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
        $this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
        $this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
        $this->product->AdvancedSearch->save();

        // Field product_code
        $this->product_code->AdvancedSearch->SearchValue = @$filter["x_product_code"];
        $this->product_code->AdvancedSearch->SearchOperator = @$filter["z_product_code"];
        $this->product_code->AdvancedSearch->SearchCondition = @$filter["v_product_code"];
        $this->product_code->AdvancedSearch->SearchValue2 = @$filter["y_product_code"];
        $this->product_code->AdvancedSearch->SearchOperator2 = @$filter["w_product_code"];
        $this->product_code->AdvancedSearch->save();

        // Field partner_code
        $this->partner_code->AdvancedSearch->SearchValue = @$filter["x_partner_code"];
        $this->partner_code->AdvancedSearch->SearchOperator = @$filter["z_partner_code"];
        $this->partner_code->AdvancedSearch->SearchCondition = @$filter["v_partner_code"];
        $this->partner_code->AdvancedSearch->SearchValue2 = @$filter["y_partner_code"];
        $this->partner_code->AdvancedSearch->SearchOperator2 = @$filter["w_partner_code"];
        $this->partner_code->AdvancedSearch->save();

        // Field packing_type
        $this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
        $this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
        $this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
        $this->packing_type->AdvancedSearch->save();

        // Field unit
        $this->unit->AdvancedSearch->SearchValue = @$filter["x_unit"];
        $this->unit->AdvancedSearch->SearchOperator = @$filter["z_unit"];
        $this->unit->AdvancedSearch->SearchCondition = @$filter["v_unit"];
        $this->unit->AdvancedSearch->SearchValue2 = @$filter["y_unit"];
        $this->unit->AdvancedSearch->SearchOperator2 = @$filter["w_unit"];
        $this->unit->AdvancedSearch->save();

        // Field quantity_approx
        $this->quantity_approx->AdvancedSearch->SearchValue = @$filter["x_quantity_approx"];
        $this->quantity_approx->AdvancedSearch->SearchOperator = @$filter["z_quantity_approx"];
        $this->quantity_approx->AdvancedSearch->SearchCondition = @$filter["v_quantity_approx"];
        $this->quantity_approx->AdvancedSearch->SearchValue2 = @$filter["y_quantity_approx"];
        $this->quantity_approx->AdvancedSearch->SearchOperator2 = @$filter["w_quantity_approx"];
        $this->quantity_approx->AdvancedSearch->save();

        // Field quantity
        $this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
        $this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
        $this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
        $this->quantity->AdvancedSearch->save();

        // Field price
        $this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
        $this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
        $this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
        $this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
        $this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
        $this->price->AdvancedSearch->save();

        // Field amount
        $this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
        $this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
        $this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
        $this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
        $this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
        $this->amount->AdvancedSearch->save();

        // Field currency
        $this->currency->AdvancedSearch->SearchValue = @$filter["x_currency"];
        $this->currency->AdvancedSearch->SearchOperator = @$filter["z_currency"];
        $this->currency->AdvancedSearch->SearchCondition = @$filter["v_currency"];
        $this->currency->AdvancedSearch->SearchValue2 = @$filter["y_currency"];
        $this->currency->AdvancedSearch->SearchOperator2 = @$filter["w_currency"];
        $this->currency->AdvancedSearch->save();

        // Field total_amount
        $this->total_amount->AdvancedSearch->SearchValue = @$filter["x_total_amount"];
        $this->total_amount->AdvancedSearch->SearchOperator = @$filter["z_total_amount"];
        $this->total_amount->AdvancedSearch->SearchCondition = @$filter["v_total_amount"];
        $this->total_amount->AdvancedSearch->SearchValue2 = @$filter["y_total_amount"];
        $this->total_amount->AdvancedSearch->SearchOperator2 = @$filter["w_total_amount"];
        $this->total_amount->AdvancedSearch->save();

        // Field remarks
        $this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
        $this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
        $this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
        $this->remarks->AdvancedSearch->save();

        // Field payment_terms
        $this->payment_terms->AdvancedSearch->SearchValue = @$filter["x_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchOperator = @$filter["z_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchCondition = @$filter["v_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchValue2 = @$filter["y_payment_terms"];
        $this->payment_terms->AdvancedSearch->SearchOperator2 = @$filter["w_payment_terms"];
        $this->payment_terms->AdvancedSearch->save();

        // Field tax_categories
        $this->tax_categories->AdvancedSearch->SearchValue = @$filter["x_tax_categories"];
        $this->tax_categories->AdvancedSearch->SearchOperator = @$filter["z_tax_categories"];
        $this->tax_categories->AdvancedSearch->SearchCondition = @$filter["v_tax_categories"];
        $this->tax_categories->AdvancedSearch->SearchValue2 = @$filter["y_tax_categories"];
        $this->tax_categories->AdvancedSearch->SearchOperator2 = @$filter["w_tax_categories"];
        $this->tax_categories->AdvancedSearch->save();

        // Field delivery_period
        $this->delivery_period->AdvancedSearch->SearchValue = @$filter["x_delivery_period"];
        $this->delivery_period->AdvancedSearch->SearchOperator = @$filter["z_delivery_period"];
        $this->delivery_period->AdvancedSearch->SearchCondition = @$filter["v_delivery_period"];
        $this->delivery_period->AdvancedSearch->SearchValue2 = @$filter["y_delivery_period"];
        $this->delivery_period->AdvancedSearch->SearchOperator2 = @$filter["w_delivery_period"];
        $this->delivery_period->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field pp_operator
        $this->pp_operator->AdvancedSearch->SearchValue = @$filter["x_pp_operator"];
        $this->pp_operator->AdvancedSearch->SearchOperator = @$filter["z_pp_operator"];
        $this->pp_operator->AdvancedSearch->SearchCondition = @$filter["v_pp_operator"];
        $this->pp_operator->AdvancedSearch->SearchValue2 = @$filter["y_pp_operator"];
        $this->pp_operator->AdvancedSearch->SearchOperator2 = @$filter["w_pp_operator"];
        $this->pp_operator->AdvancedSearch->save();

        // Field pp_datetime
        $this->pp_datetime->AdvancedSearch->SearchValue = @$filter["x_pp_datetime"];
        $this->pp_datetime->AdvancedSearch->SearchOperator = @$filter["z_pp_datetime"];
        $this->pp_datetime->AdvancedSearch->SearchCondition = @$filter["v_pp_datetime"];
        $this->pp_datetime->AdvancedSearch->SearchValue2 = @$filter["y_pp_datetime"];
        $this->pp_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_pp_datetime"];
        $this->pp_datetime->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->company_id, $default, false); // company_id
        $this->buildSearchSql($where, $this->partner_id, $default, false); // partner_id
        $this->buildSearchSql($where, $this->partner_details, $default, false); // partner_details
        $this->buildSearchSql($where, $this->product_type, $default, false); // product_type
        $this->buildSearchSql($where, $this->product, $default, false); // product
        $this->buildSearchSql($where, $this->product_code, $default, false); // product_code
        $this->buildSearchSql($where, $this->partner_code, $default, false); // partner_code
        $this->buildSearchSql($where, $this->packing_type, $default, false); // packing_type
        $this->buildSearchSql($where, $this->unit, $default, false); // unit
        $this->buildSearchSql($where, $this->quantity_approx, $default, false); // quantity_approx
        $this->buildSearchSql($where, $this->quantity, $default, false); // quantity
        $this->buildSearchSql($where, $this->price, $default, false); // price
        $this->buildSearchSql($where, $this->amount, $default, false); // amount
        $this->buildSearchSql($where, $this->currency, $default, false); // currency
        $this->buildSearchSql($where, $this->total_amount, $default, false); // total_amount
        $this->buildSearchSql($where, $this->remarks, $default, false); // remarks
        $this->buildSearchSql($where, $this->payment_terms, $default, false); // payment_terms
        $this->buildSearchSql($where, $this->tax_categories, $default, false); // tax_categories
        $this->buildSearchSql($where, $this->delivery_period, $default, false); // delivery_period
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->pp_operator, $default, false); // pp_operator
        $this->buildSearchSql($where, $this->pp_datetime, $default, false); // pp_datetime

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->company_id->AdvancedSearch->save(); // company_id
            $this->partner_id->AdvancedSearch->save(); // partner_id
            $this->partner_details->AdvancedSearch->save(); // partner_details
            $this->product_type->AdvancedSearch->save(); // product_type
            $this->product->AdvancedSearch->save(); // product
            $this->product_code->AdvancedSearch->save(); // product_code
            $this->partner_code->AdvancedSearch->save(); // partner_code
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->unit->AdvancedSearch->save(); // unit
            $this->quantity_approx->AdvancedSearch->save(); // quantity_approx
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->price->AdvancedSearch->save(); // price
            $this->amount->AdvancedSearch->save(); // amount
            $this->currency->AdvancedSearch->save(); // currency
            $this->total_amount->AdvancedSearch->save(); // total_amount
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->payment_terms->AdvancedSearch->save(); // payment_terms
            $this->tax_categories->AdvancedSearch->save(); // tax_categories
            $this->delivery_period->AdvancedSearch->save(); // delivery_period
            $this->status->AdvancedSearch->save(); // status
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->pp_operator->AdvancedSearch->save(); // pp_operator
            $this->pp_datetime->AdvancedSearch->save(); // pp_datetime

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->company_id->AdvancedSearch->save(); // company_id
            $this->partner_id->AdvancedSearch->save(); // partner_id
            $this->partner_details->AdvancedSearch->save(); // partner_details
            $this->product_type->AdvancedSearch->save(); // product_type
            $this->product->AdvancedSearch->save(); // product
            $this->product_code->AdvancedSearch->save(); // product_code
            $this->partner_code->AdvancedSearch->save(); // partner_code
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->unit->AdvancedSearch->save(); // unit
            $this->quantity_approx->AdvancedSearch->save(); // quantity_approx
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->price->AdvancedSearch->save(); // price
            $this->amount->AdvancedSearch->save(); // amount
            $this->currency->AdvancedSearch->save(); // currency
            $this->total_amount->AdvancedSearch->save(); // total_amount
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->payment_terms->AdvancedSearch->save(); // payment_terms
            $this->tax_categories->AdvancedSearch->save(); // tax_categories
            $this->delivery_period->AdvancedSearch->save(); // delivery_period
            $this->status->AdvancedSearch->save(); // status
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->pp_operator->AdvancedSearch->save(); // pp_operator
            $this->pp_datetime->AdvancedSearch->save(); // pp_datetime
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field company_id
        $filter = $this->queryBuilderWhere("company_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->company_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->company_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field partner_id
        $filter = $this->queryBuilderWhere("partner_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->partner_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->partner_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product_type
        $filter = $this->queryBuilderWhere("product_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product
        $filter = $this->queryBuilderWhere("product");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product_code
        $filter = $this->queryBuilderWhere("product_code");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product_code, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product_code->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field partner_code
        $filter = $this->queryBuilderWhere("partner_code");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->partner_code, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->partner_code->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field packing_type
        $filter = $this->queryBuilderWhere("packing_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->packing_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->packing_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field unit
        $filter = $this->queryBuilderWhere("unit");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->unit, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->unit->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field quantity_approx
        $filter = $this->queryBuilderWhere("quantity_approx");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->quantity_approx, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->quantity_approx->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field quantity
        $filter = $this->queryBuilderWhere("quantity");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->quantity, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->quantity->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field price
        $filter = $this->queryBuilderWhere("price");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->price, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->price->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field amount
        $filter = $this->queryBuilderWhere("amount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->amount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->amount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field currency
        $filter = $this->queryBuilderWhere("currency");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->currency, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->currency->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field total_amount
        $filter = $this->queryBuilderWhere("total_amount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->total_amount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->total_amount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field remarks
        $filter = $this->queryBuilderWhere("remarks");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->remarks, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->remarks->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field payment_terms
        $filter = $this->queryBuilderWhere("payment_terms");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->payment_terms, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->payment_terms->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field tax_categories
        $filter = $this->queryBuilderWhere("tax_categories");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->tax_categories, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->tax_categories->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field delivery_period
        $filter = $this->queryBuilderWhere("delivery_period");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->delivery_period, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->delivery_period->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status
        $filter = $this->queryBuilderWhere("status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field operator
        $filter = $this->queryBuilderWhere("operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field datetime
        $filter = $this->queryBuilderWhere("datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pp_operator
        $filter = $this->queryBuilderWhere("pp_operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pp_operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pp_operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pp_datetime
        $filter = $this->queryBuilderWhere("pp_datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pp_datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pp_datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->partner_details;
        $searchFlds[] = &$this->partner_code;
        $searchFlds[] = &$this->quantity_approx;
        $searchFlds[] = &$this->remarks;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->company_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->partner_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->partner_details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->partner_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->packing_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->unit->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity_approx->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->price->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->currency->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->total_amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->payment_terms->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->tax_categories->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->delivery_period->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pp_operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pp_datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->company_id->AdvancedSearch->unsetSession();
        $this->partner_id->AdvancedSearch->unsetSession();
        $this->partner_details->AdvancedSearch->unsetSession();
        $this->product_type->AdvancedSearch->unsetSession();
        $this->product->AdvancedSearch->unsetSession();
        $this->product_code->AdvancedSearch->unsetSession();
        $this->partner_code->AdvancedSearch->unsetSession();
        $this->packing_type->AdvancedSearch->unsetSession();
        $this->unit->AdvancedSearch->unsetSession();
        $this->quantity_approx->AdvancedSearch->unsetSession();
        $this->quantity->AdvancedSearch->unsetSession();
        $this->price->AdvancedSearch->unsetSession();
        $this->amount->AdvancedSearch->unsetSession();
        $this->currency->AdvancedSearch->unsetSession();
        $this->total_amount->AdvancedSearch->unsetSession();
        $this->remarks->AdvancedSearch->unsetSession();
        $this->payment_terms->AdvancedSearch->unsetSession();
        $this->tax_categories->AdvancedSearch->unsetSession();
        $this->delivery_period->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->pp_operator->AdvancedSearch->unsetSession();
        $this->pp_datetime->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->partner_id->AdvancedSearch->load();
        $this->partner_details->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->partner_code->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->unit->AdvancedSearch->load();
        $this->quantity_approx->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->total_amount->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->tax_categories->AdvancedSearch->load();
        $this->delivery_period->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->pp_operator->AdvancedSearch->load();
        $this->pp_datetime->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->company_id, $ctrl); // company_id
            $this->updateSort($this->partner_id, $ctrl); // partner_id
            $this->updateSort($this->product_type, $ctrl); // product_type
            $this->updateSort($this->product, $ctrl); // product
            $this->updateSort($this->product_code, $ctrl); // product_code
            $this->updateSort($this->partner_code, $ctrl); // partner_code
            $this->updateSort($this->packing_type, $ctrl); // packing_type
            $this->updateSort($this->unit, $ctrl); // unit
            $this->updateSort($this->quantity_approx, $ctrl); // quantity_approx
            $this->updateSort($this->quantity, $ctrl); // quantity
            $this->updateSort($this->price, $ctrl); // price
            $this->updateSort($this->amount, $ctrl); // amount
            $this->updateSort($this->currency, $ctrl); // currency
            $this->updateSort($this->total_amount, $ctrl); // total_amount
            $this->updateSort($this->remarks, $ctrl); // remarks
            $this->updateSort($this->payment_terms, $ctrl); // payment_terms
            $this->updateSort($this->tax_categories, $ctrl); // tax_categories
            $this->updateSort($this->delivery_period, $ctrl); // delivery_period
            $this->updateSort($this->status, $ctrl); // status
            $this->updateSort($this->operator, $ctrl); // operator
            $this->updateSort($this->datetime, $ctrl); // datetime
            $this->updateSort($this->pp_operator, $ctrl); // pp_operator
            $this->updateSort($this->pp_datetime, $ctrl); // pp_datetime
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->company_id->setSort("");
                $this->partner_id->setSort("");
                $this->partner_details->setSort("");
                $this->product_type->setSort("");
                $this->product->setSort("");
                $this->product_code->setSort("");
                $this->partner_code->setSort("");
                $this->packing_type->setSort("");
                $this->unit->setSort("");
                $this->quantity_approx->setSort("");
                $this->quantity->setSort("");
                $this->price->setSort("");
                $this->amount->setSort("");
                $this->currency->setSort("");
                $this->total_amount->setSort("");
                $this->remarks->setSort("");
                $this->payment_terms->setSort("");
                $this->tax_categories->setSort("");
                $this->delivery_period->setSort("");
                $this->status->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->pp_operator->setSort("");
                $this->pp_datetime->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"partner_quotation_buyer\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"partner_quotation_buyer\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"partner_quotation_buyer\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fpartner_quotation_buyerlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fpartner_quotation_buyerlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"partner_quotation_buyer\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "company_id");
            $this->createColumnOption($option, "partner_id");
            $this->createColumnOption($option, "product_type");
            $this->createColumnOption($option, "product");
            $this->createColumnOption($option, "product_code");
            $this->createColumnOption($option, "partner_code");
            $this->createColumnOption($option, "packing_type");
            $this->createColumnOption($option, "unit");
            $this->createColumnOption($option, "quantity_approx");
            $this->createColumnOption($option, "quantity");
            $this->createColumnOption($option, "price");
            $this->createColumnOption($option, "amount");
            $this->createColumnOption($option, "currency");
            $this->createColumnOption($option, "total_amount");
            $this->createColumnOption($option, "remarks");
            $this->createColumnOption($option, "payment_terms");
            $this->createColumnOption($option, "tax_categories");
            $this->createColumnOption($option, "delivery_period");
            $this->createColumnOption($option, "status");
            $this->createColumnOption($option, "operator");
            $this->createColumnOption($option, "datetime");
            $this->createColumnOption($option, "pp_operator");
            $this->createColumnOption($option, "pp_datetime");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fpartner_quotation_buyersrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fpartner_quotation_buyersrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fpartner_quotation_buyerlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_partner_quotation_buyer", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_partner_quotation_buyer",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->company_id->AdvancedSearch->SearchValue != "" || $this->company_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // partner_id
        if ($this->partner_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->partner_id->AdvancedSearch->SearchValue != "" || $this->partner_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // partner_details
        if ($this->partner_details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->partner_details->AdvancedSearch->SearchValue != "" || $this->partner_details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product_type
        if ($this->product_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product_type->AdvancedSearch->SearchValue != "" || $this->product_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product->AdvancedSearch->SearchValue != "" || $this->product->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product_code
        if ($this->product_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product_code->AdvancedSearch->SearchValue != "" || $this->product_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // partner_code
        if ($this->partner_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->partner_code->AdvancedSearch->SearchValue != "" || $this->partner_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->packing_type->AdvancedSearch->SearchValue != "" || $this->packing_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // unit
        if ($this->unit->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->unit->AdvancedSearch->SearchValue != "" || $this->unit->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity_approx
        if ($this->quantity_approx->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity_approx->AdvancedSearch->SearchValue != "" || $this->quantity_approx->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity->AdvancedSearch->SearchValue != "" || $this->quantity->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // price
        if ($this->price->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->price->AdvancedSearch->SearchValue != "" || $this->price->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->amount->AdvancedSearch->SearchValue != "" || $this->amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // currency
        if ($this->currency->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->currency->AdvancedSearch->SearchValue != "" || $this->currency->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // total_amount
        if ($this->total_amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->total_amount->AdvancedSearch->SearchValue != "" || $this->total_amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->remarks->AdvancedSearch->SearchValue != "" || $this->remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // payment_terms
        if ($this->payment_terms->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->payment_terms->AdvancedSearch->SearchValue != "" || $this->payment_terms->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // tax_categories
        if ($this->tax_categories->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->tax_categories->AdvancedSearch->SearchValue != "" || $this->tax_categories->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // delivery_period
        if ($this->delivery_period->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->delivery_period->AdvancedSearch->SearchValue != "" || $this->delivery_period->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pp_operator
        if ($this->pp_operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pp_operator->AdvancedSearch->SearchValue != "" || $this->pp_operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pp_datetime
        if ($this->pp_datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pp_datetime->AdvancedSearch->SearchValue != "" || $this->pp_datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->partner_details->setDbValue($row['partner_details']);
        $this->product_type->setDbValue($row['product_type']);
        $this->product->setDbValue($row['product']);
        $this->product_code->setDbValue($row['product_code']);
        $this->partner_code->setDbValue($row['partner_code']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->unit->setDbValue($row['unit']);
        $this->quantity_approx->setDbValue($row['quantity_approx']);
        $this->quantity->setDbValue($row['quantity']);
        $this->price->setDbValue($row['price']);
        $this->amount->setDbValue($row['amount']);
        $this->currency->setDbValue($row['currency']);
        $this->total_amount->setDbValue($row['total_amount']);
        $this->remarks->setDbValue($row['remarks']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->tax_categories->setDbValue($row['tax_categories']);
        $this->delivery_period->setDbValue($row['delivery_period']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->pp_operator->setDbValue($row['pp_operator']);
        $this->pp_datetime->setDbValue($row['pp_datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['partner_details'] = $this->partner_details->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['partner_code'] = $this->partner_code->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['quantity_approx'] = $this->quantity_approx->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['total_amount'] = $this->total_amount->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['tax_categories'] = $this->tax_categories->DefaultValue;
        $row['delivery_period'] = $this->delivery_period->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['pp_operator'] = $this->pp_operator->DefaultValue;
        $row['pp_datetime'] = $this->pp_datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // company_id

        // partner_id

        // partner_details

        // product_type

        // product

        // product_code

        // partner_code

        // packing_type

        // unit

        // quantity_approx

        // quantity

        // price

        // amount

        // currency

        // total_amount

        // remarks

        // payment_terms

        // tax_categories

        // delivery_period

        // status

        // operator

        // datetime

        // pp_operator

        // pp_datetime

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = $this->company_id->CurrentValue;
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = FormatNumber($this->partner_id->CurrentValue, $this->partner_id->formatPattern());
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = FormatNumber($this->product_type->CurrentValue, $this->product_type->formatPattern());
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_code
            $curVal = strval($this->product_code->CurrentValue);
            if ($curVal != "") {
                $this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
                if ($this->product_code->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_code->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_code->Lookup->renderViewRow($rswrk[0]);
                        $this->product_code->ViewValue = $this->product_code->displayValue($arwrk);
                    } else {
                        $this->product_code->ViewValue = FormatNumber($this->product_code->CurrentValue, $this->product_code->formatPattern());
                    }
                }
            } else {
                $this->product_code->ViewValue = null;
            }

            // partner_code
            $this->partner_code->ViewValue = $this->partner_code->CurrentValue;

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = FormatNumber($this->unit->CurrentValue, $this->unit->formatPattern());
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // quantity_approx
            $this->quantity_approx->ViewValue = $this->quantity_approx->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // total_amount
            $this->total_amount->ViewValue = $this->total_amount->CurrentValue;
            $this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, $this->total_amount->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = FormatNumber($this->payment_terms->CurrentValue, $this->payment_terms->formatPattern());
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // tax_categories
            $curVal = strval($this->tax_categories->CurrentValue);
            if ($curVal != "") {
                $this->tax_categories->ViewValue = $this->tax_categories->lookupCacheOption($curVal);
                if ($this->tax_categories->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->tax_categories->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->tax_categories->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->tax_categories->getSelectFilter($this); // PHP
                    $sqlWrk = $this->tax_categories->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->tax_categories->Lookup->renderViewRow($rswrk[0]);
                        $this->tax_categories->ViewValue = $this->tax_categories->displayValue($arwrk);
                    } else {
                        $this->tax_categories->ViewValue = FormatNumber($this->tax_categories->CurrentValue, $this->tax_categories->formatPattern());
                    }
                }
            } else {
                $this->tax_categories->ViewValue = null;
            }

            // delivery_period
            $this->delivery_period->ViewValue = $this->delivery_period->CurrentValue;
            $this->delivery_period->ViewValue = FormatNumber($this->delivery_period->ViewValue, $this->delivery_period->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // pp_operator
            $this->pp_operator->ViewValue = $this->pp_operator->CurrentValue;
            $this->pp_operator->ViewValue = FormatNumber($this->pp_operator->ViewValue, $this->pp_operator->formatPattern());

            // pp_datetime
            $this->pp_datetime->ViewValue = $this->pp_datetime->CurrentValue;
            $this->pp_datetime->ViewValue = FormatDateTime($this->pp_datetime->ViewValue, $this->pp_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // partner_id
            $this->partner_id->HrefValue = "";
            $this->partner_id->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // product_code
            $this->product_code->HrefValue = "";
            $this->product_code->TooltipValue = "";

            // partner_code
            $this->partner_code->HrefValue = "";
            $this->partner_code->TooltipValue = "";
            if (!$this->isExport()) {
                $this->partner_code->ViewValue = $this->highlightValue($this->partner_code);
            }

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // unit
            $this->unit->HrefValue = "";
            $this->unit->TooltipValue = "";

            // quantity_approx
            $this->quantity_approx->HrefValue = "";
            $this->quantity_approx->TooltipValue = "";
            if (!$this->isExport()) {
                $this->quantity_approx->ViewValue = $this->highlightValue($this->quantity_approx);
            }

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // total_amount
            $this->total_amount->HrefValue = "";
            $this->total_amount->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->remarks->ViewValue = $this->highlightValue($this->remarks);
            }

            // payment_terms
            $this->payment_terms->HrefValue = "";
            $this->payment_terms->TooltipValue = "";

            // tax_categories
            $this->tax_categories->HrefValue = "";
            $this->tax_categories->TooltipValue = "";

            // delivery_period
            $this->delivery_period->HrefValue = "";
            $this->delivery_period->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }

            // pp_operator
            $this->pp_operator->HrefValue = "";
            $this->pp_operator->TooltipValue = "";

            // pp_datetime
            $this->pp_datetime->HrefValue = "";
            $this->pp_datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pp_datetime->ViewValue = $this->highlightValue($this->pp_datetime);
            }
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->partner_id->AdvancedSearch->load();
        $this->partner_details->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->partner_code->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->unit->AdvancedSearch->load();
        $this->quantity_approx->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->total_amount->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->payment_terms->AdvancedSearch->load();
        $this->tax_categories->AdvancedSearch->load();
        $this->delivery_period->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->pp_operator->AdvancedSearch->load();
        $this->pp_datetime->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fpartner_quotation_buyerlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fpartner_quotation_buyerlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fpartner_quotation_buyerlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fpartner_quotation_buyerlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"partner_quotation_buyer\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"partnerquotationbuyersearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"partnerquotationbuyersearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fpartner_quotation_buyersrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    break;
                case "x_product_type":
                    break;
                case "x_product":
                    break;
                case "x_product_code":
                    break;
                case "x_packing_type":
                    break;
                case "x_unit":
                    break;
                case "x_currency":
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_tax_categories":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
