<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PartnerProductRefUpdate extends PartnerProductRef
{
    use MessagesTrait;

    // Page ID
    public $PageID = "update";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PartnerProductRefUpdate";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "partnerproductrefupdate";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->partner_type->Visible = false;
        $this->partner->Visible = false;
        $this->partner_ref->Visible = false;
        $this->_barcode->Visible = false;
        $this->partner_code->Visible = false;
        $this->product_type->Visible = false;
        $this->grp->setVisibility();
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->rid->Visible = false;
        $this->spl_ins->setVisibility();
        $this->packing_type->setVisibility();
        $this->batch_no->Visible = false;
        $this->shape->Visible = false;
        $this->unit->Visible = false;
        $this->w->Visible = false;
        $this->w_cm->Visible = false;
        $this->l->Visible = false;
        $this->l_cm->Visible = false;
        $this->h->Visible = false;
        $this->h_cm->Visible = false;
        $this->partner_size->Visible = false;
        $this->sqm->Visible = false;
        $this->cbm->setVisibility();
        $this->weight_sqm->setVisibility();
        $this->sqm_a->setVisibility();
        $this->_2srm_a->setVisibility();
        $this->_4srm_a->setVisibility();
        $this->price->setVisibility();
        $this->price_cs->setVisibility();
        $this->currency->setVisibility();
        $this->hsn->setVisibility();
        $this->composition->setVisibility();
        $this->status->Visible = false;
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->gcode->Visible = false;
        $this->d_01->setVisibility();
        $this->d_02->setVisibility();
        $this->d_03->setVisibility();
        $this->d_04->setVisibility();
        $this->d_05->setVisibility();
        $this->d_06->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'partner_product_ref';
        $this->TableName = 'partner_product_ref';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-update-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (partner_product_ref)
        if (!isset($GLOBALS["partner_product_ref"]) || $GLOBALS["partner_product_ref"]::class == PROJECT_NAMESPACE . "partner_product_ref") {
            $GLOBALS["partner_product_ref"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'partner_product_ref');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "partnerproductrefview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-update-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $RecKeys;
    public $Disabled;
    public $UpdateCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->partner_type);
        $this->setupLookupOptions($this->partner);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->hsn);
        $this->setupLookupOptions($this->composition);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->gcode);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Try to load keys from list form
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        if (Post("action") !== null && Post("action") !== "") {
            // Get action
            $this->CurrentAction = Post("action");
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                $this->CurrentAction = "show"; // Form error, reset action
                if (!$this->hasInvalidFields()) { // No fields selected
                    $this->setFailureMessage($Language->phrase("NoFieldSelected"));
                }
            }
        } else {
            $this->loadMultiUpdateValues(); // Load initial values to form
        }
        if (count($this->RecKeys) <= 0) {
            $this->terminate("partnerproductreflist"); // No records selected, return to list
            return;
        }
        if ($this->isUpdate()) {
                if ($this->updateRows()) { // Update Records based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
                    }

                    // Do not return Json for UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                    }
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
        }

        // Render row
        if ($this->isConfirm()) { // Confirm page
            $this->RowType = RowType::VIEW; // Render view
            $this->Disabled = " disabled";
        } else {
            $this->RowType = RowType::EDIT; // Render edit
            $this->Disabled = "";
        }
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load initial values to form if field values are identical in all selected records
    protected function loadMultiUpdateValues()
    {
        $this->CurrentFilter = $this->getFilterFromRecordKeys();

        // Load result set
        if ($rs = $this->loadRecordset()) {
            $i = 1;
            while ($row = $rs->fetch()) {
                if ($i == 1) {
                    $this->grp->setDbValue($row['grp']);
                    $this->spl_ins->setDbValue($row['spl_ins']);
                    $this->packing_type->setDbValue($row['packing_type']);
                    $this->cbm->setDbValue($row['cbm']);
                    $this->weight_sqm->setDbValue($row['weight_sqm']);
                    $this->sqm_a->setDbValue($row['sqm_a']);
                    $this->_2srm_a->setDbValue($row['2srm_a']);
                    $this->_4srm_a->setDbValue($row['4srm_a']);
                    $this->price->setDbValue($row['price']);
                    $this->price_cs->setDbValue($row['price_cs']);
                    $this->currency->setDbValue($row['currency']);
                    $this->hsn->setDbValue($row['hsn']);
                    $this->composition->setDbValue($row['composition']);
                    $this->d_01->setDbValue($row['d_01']);
                    $this->d_02->setDbValue($row['d_02']);
                    $this->d_03->setDbValue($row['d_03']);
                    $this->d_04->setDbValue($row['d_04']);
                    $this->d_05->setDbValue($row['d_05']);
                    $this->d_06->setDbValue($row['d_06']);
                } else {
                    if (!CompareValue($this->grp->DbValue, $row['grp'])) {
                        $this->grp->CurrentValue = null;
                    }
                    if (!CompareValue($this->spl_ins->DbValue, $row['spl_ins'])) {
                        $this->spl_ins->CurrentValue = null;
                    }
                    if (!CompareValue($this->packing_type->DbValue, $row['packing_type'])) {
                        $this->packing_type->CurrentValue = null;
                    }
                    if (!CompareValue($this->cbm->DbValue, $row['cbm'])) {
                        $this->cbm->CurrentValue = null;
                    }
                    if (!CompareValue($this->weight_sqm->DbValue, $row['weight_sqm'])) {
                        $this->weight_sqm->CurrentValue = null;
                    }
                    if (!CompareValue($this->sqm_a->DbValue, $row['sqm_a'])) {
                        $this->sqm_a->CurrentValue = null;
                    }
                    if (!CompareValue($this->_2srm_a->DbValue, $row['2srm_a'])) {
                        $this->_2srm_a->CurrentValue = null;
                    }
                    if (!CompareValue($this->_4srm_a->DbValue, $row['4srm_a'])) {
                        $this->_4srm_a->CurrentValue = null;
                    }
                    if (!CompareValue($this->price->DbValue, $row['price'])) {
                        $this->price->CurrentValue = null;
                    }
                    if (!CompareValue($this->price_cs->DbValue, $row['price_cs'])) {
                        $this->price_cs->CurrentValue = null;
                    }
                    if (!CompareValue($this->currency->DbValue, $row['currency'])) {
                        $this->currency->CurrentValue = null;
                    }
                    if (!CompareValue($this->hsn->DbValue, $row['hsn'])) {
                        $this->hsn->CurrentValue = null;
                    }
                    if (!CompareValue($this->composition->DbValue, $row['composition'])) {
                        $this->composition->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_01->DbValue, $row['d_01'])) {
                        $this->d_01->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_02->DbValue, $row['d_02'])) {
                        $this->d_02->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_03->DbValue, $row['d_03'])) {
                        $this->d_03->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_04->DbValue, $row['d_04'])) {
                        $this->d_04->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_05->DbValue, $row['d_05'])) {
                        $this->d_05->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_06->DbValue, $row['d_06'])) {
                        $this->d_06->CurrentValue = null;
                    }
                }
                $i++;
            }
            $rs->free();
        }
    }

    // Set up key value
    protected function setupKeyValues($key)
    {
        $keyFld = $key;
        if (!is_numeric($keyFld)) {
            return false;
        }
        $this->id->OldValue = $keyFld;
        return true;
    }

    // Update all selected rows
    protected function updateRows()
    {
        global $Language;
        $conn = $this->getConnection();
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Get old records
        $this->CurrentFilter = $this->getFilterFromRecordKeys(false);
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAllAssociative($sql);

        // Update all rows
        $successKeys = [];
        $failKeys = [];
        foreach ($this->RecKeys as $reckey) {
            if ($this->setupKeyValues($reckey)) {
                $thisKey = $reckey;
                $this->SendEmail = false; // Do not send email on update success
                $this->UpdateCount += 1; // Update record count for records being updated
                $rowUpdated = $this->editRow(); // Update this row
            } else {
                $rowUpdated = false;
            }
            if (!$rowUpdated) {
                if ($this->UseTransaction) { // Update failed
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                $successKeys[] = $thisKey;
            }
        }

        // Check if any rows updated
        if (count($successKeys) > 0) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if update some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("UpdateSomeRecordsFailed")));
            }

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);
            return true;
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            return false;
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }
        $this->grp->MultiUpdate = $CurrentForm->getValue("u_grp");

        // Check field name 'spl_ins' first before field var 'x_spl_ins'
        $val = $CurrentForm->hasValue("spl_ins") ? $CurrentForm->getValue("spl_ins") : $CurrentForm->getValue("x_spl_ins");
        if (!$this->spl_ins->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->spl_ins->Visible = false; // Disable update for API request
            } else {
                $this->spl_ins->setFormValue($val);
            }
        }
        $this->spl_ins->MultiUpdate = $CurrentForm->getValue("u_spl_ins");

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }
        $this->packing_type->MultiUpdate = $CurrentForm->getValue("u_packing_type");

        // Check field name 'cbm' first before field var 'x_cbm'
        $val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
        if (!$this->cbm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cbm->Visible = false; // Disable update for API request
            } else {
                $this->cbm->setFormValue($val, true, $validate);
            }
        }
        $this->cbm->MultiUpdate = $CurrentForm->getValue("u_cbm");

        // Check field name 'weight_sqm' first before field var 'x_weight_sqm'
        $val = $CurrentForm->hasValue("weight_sqm") ? $CurrentForm->getValue("weight_sqm") : $CurrentForm->getValue("x_weight_sqm");
        if (!$this->weight_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weight_sqm->Visible = false; // Disable update for API request
            } else {
                $this->weight_sqm->setFormValue($val, true, $validate);
            }
        }
        $this->weight_sqm->MultiUpdate = $CurrentForm->getValue("u_weight_sqm");

        // Check field name 'sqm_a' first before field var 'x_sqm_a'
        $val = $CurrentForm->hasValue("sqm_a") ? $CurrentForm->getValue("sqm_a") : $CurrentForm->getValue("x_sqm_a");
        if (!$this->sqm_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm_a->Visible = false; // Disable update for API request
            } else {
                $this->sqm_a->setFormValue($val, true, $validate);
            }
        }
        $this->sqm_a->MultiUpdate = $CurrentForm->getValue("u_sqm_a");

        // Check field name '2srm_a' first before field var 'x__2srm_a'
        $val = $CurrentForm->hasValue("2srm_a") ? $CurrentForm->getValue("2srm_a") : $CurrentForm->getValue("x__2srm_a");
        if (!$this->_2srm_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_2srm_a->Visible = false; // Disable update for API request
            } else {
                $this->_2srm_a->setFormValue($val, true, $validate);
            }
        }
        $this->_2srm_a->MultiUpdate = $CurrentForm->getValue("u__2srm_a");

        // Check field name '4srm_a' first before field var 'x__4srm_a'
        $val = $CurrentForm->hasValue("4srm_a") ? $CurrentForm->getValue("4srm_a") : $CurrentForm->getValue("x__4srm_a");
        if (!$this->_4srm_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_4srm_a->Visible = false; // Disable update for API request
            } else {
                $this->_4srm_a->setFormValue($val, true, $validate);
            }
        }
        $this->_4srm_a->MultiUpdate = $CurrentForm->getValue("u__4srm_a");

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val, true, $validate);
            }
        }
        $this->price->MultiUpdate = $CurrentForm->getValue("u_price");

        // Check field name 'price_cs' first before field var 'x_price_cs'
        $val = $CurrentForm->hasValue("price_cs") ? $CurrentForm->getValue("price_cs") : $CurrentForm->getValue("x_price_cs");
        if (!$this->price_cs->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price_cs->Visible = false; // Disable update for API request
            } else {
                $this->price_cs->setFormValue($val, true, $validate);
            }
        }
        $this->price_cs->MultiUpdate = $CurrentForm->getValue("u_price_cs");

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }
        $this->currency->MultiUpdate = $CurrentForm->getValue("u_currency");

        // Check field name 'hsn' first before field var 'x_hsn'
        $val = $CurrentForm->hasValue("hsn") ? $CurrentForm->getValue("hsn") : $CurrentForm->getValue("x_hsn");
        if (!$this->hsn->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->hsn->Visible = false; // Disable update for API request
            } else {
                $this->hsn->setFormValue($val);
            }
        }
        $this->hsn->MultiUpdate = $CurrentForm->getValue("u_hsn");

        // Check field name 'composition' first before field var 'x_composition'
        $val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
        if (!$this->composition->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->composition->Visible = false; // Disable update for API request
            } else {
                $this->composition->setFormValue($val);
            }
        }
        $this->composition->MultiUpdate = $CurrentForm->getValue("u_composition");

        // Check field name 'd_01' first before field var 'x_d_01'
        $val = $CurrentForm->hasValue("d_01") ? $CurrentForm->getValue("d_01") : $CurrentForm->getValue("x_d_01");
        if (!$this->d_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_01->Visible = false; // Disable update for API request
            } else {
                $this->d_01->setFormValue($val);
            }
        }
        $this->d_01->MultiUpdate = $CurrentForm->getValue("u_d_01");

        // Check field name 'd_02' first before field var 'x_d_02'
        $val = $CurrentForm->hasValue("d_02") ? $CurrentForm->getValue("d_02") : $CurrentForm->getValue("x_d_02");
        if (!$this->d_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_02->Visible = false; // Disable update for API request
            } else {
                $this->d_02->setFormValue($val);
            }
        }
        $this->d_02->MultiUpdate = $CurrentForm->getValue("u_d_02");

        // Check field name 'd_03' first before field var 'x_d_03'
        $val = $CurrentForm->hasValue("d_03") ? $CurrentForm->getValue("d_03") : $CurrentForm->getValue("x_d_03");
        if (!$this->d_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_03->Visible = false; // Disable update for API request
            } else {
                $this->d_03->setFormValue($val);
            }
        }
        $this->d_03->MultiUpdate = $CurrentForm->getValue("u_d_03");

        // Check field name 'd_04' first before field var 'x_d_04'
        $val = $CurrentForm->hasValue("d_04") ? $CurrentForm->getValue("d_04") : $CurrentForm->getValue("x_d_04");
        if (!$this->d_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_04->Visible = false; // Disable update for API request
            } else {
                $this->d_04->setFormValue($val);
            }
        }
        $this->d_04->MultiUpdate = $CurrentForm->getValue("u_d_04");

        // Check field name 'd_05' first before field var 'x_d_05'
        $val = $CurrentForm->hasValue("d_05") ? $CurrentForm->getValue("d_05") : $CurrentForm->getValue("x_d_05");
        if (!$this->d_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_05->Visible = false; // Disable update for API request
            } else {
                $this->d_05->setFormValue($val);
            }
        }
        $this->d_05->MultiUpdate = $CurrentForm->getValue("u_d_05");

        // Check field name 'd_06' first before field var 'x_d_06'
        $val = $CurrentForm->hasValue("d_06") ? $CurrentForm->getValue("d_06") : $CurrentForm->getValue("x_d_06");
        if (!$this->d_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_06->Visible = false; // Disable update for API request
            } else {
                $this->d_06->setFormValue($val);
            }
        }
        $this->d_06->MultiUpdate = $CurrentForm->getValue("u_d_06");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->spl_ins->CurrentValue = $this->spl_ins->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->cbm->CurrentValue = $this->cbm->FormValue;
        $this->weight_sqm->CurrentValue = $this->weight_sqm->FormValue;
        $this->sqm_a->CurrentValue = $this->sqm_a->FormValue;
        $this->_2srm_a->CurrentValue = $this->_2srm_a->FormValue;
        $this->_4srm_a->CurrentValue = $this->_4srm_a->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->price_cs->CurrentValue = $this->price_cs->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->hsn->CurrentValue = $this->hsn->FormValue;
        $this->composition->CurrentValue = $this->composition->FormValue;
        $this->d_01->CurrentValue = $this->d_01->FormValue;
        $this->d_02->CurrentValue = $this->d_02->FormValue;
        $this->d_03->CurrentValue = $this->d_03->FormValue;
        $this->d_04->CurrentValue = $this->d_04->FormValue;
        $this->d_05->CurrentValue = $this->d_05->FormValue;
        $this->d_06->CurrentValue = $this->d_06->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->partner_type->setDbValue($row['partner_type']);
        $this->partner->setDbValue($row['partner']);
        $this->partner_ref->setDbValue($row['partner_ref']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->partner_code->setDbValue($row['partner_code']);
        $this->product_type->setDbValue($row['product_type']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->spl_ins->setDbValue($row['spl_ins']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->shape->setDbValue($row['shape']);
        $this->unit->setDbValue($row['unit']);
        $this->w->setDbValue($row['w']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l->setDbValue($row['l']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->h->setDbValue($row['h']);
        $this->h_cm->setDbValue($row['h_cm']);
        $this->partner_size->setDbValue($row['partner_size']);
        $this->sqm->setDbValue($row['sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->weight_sqm->setDbValue($row['weight_sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->price->setDbValue($row['price']);
        $this->price_cs->setDbValue($row['price_cs']);
        $this->currency->setDbValue($row['currency']);
        $this->hsn->setDbValue($row['hsn']);
        $this->composition->setDbValue($row['composition']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->gcode->setDbValue($row['gcode']);
        $this->d_01->setDbValue($row['d_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->d_03->setDbValue($row['d_03']);
        $this->d_04->setDbValue($row['d_04']);
        $this->d_05->setDbValue($row['d_05']);
        $this->d_06->setDbValue($row['d_06']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['partner_type'] = $this->partner_type->DefaultValue;
        $row['partner'] = $this->partner->DefaultValue;
        $row['partner_ref'] = $this->partner_ref->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['partner_code'] = $this->partner_code->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['spl_ins'] = $this->spl_ins->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['w'] = $this->w->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l'] = $this->l->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['h'] = $this->h->DefaultValue;
        $row['h_cm'] = $this->h_cm->DefaultValue;
        $row['partner_size'] = $this->partner_size->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['weight_sqm'] = $this->weight_sqm->DefaultValue;
        $row['sqm_a'] = $this->sqm_a->DefaultValue;
        $row['2srm_a'] = $this->_2srm_a->DefaultValue;
        $row['4srm_a'] = $this->_4srm_a->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['price_cs'] = $this->price_cs->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['hsn'] = $this->hsn->DefaultValue;
        $row['composition'] = $this->composition->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['gcode'] = $this->gcode->DefaultValue;
        $row['d_01'] = $this->d_01->DefaultValue;
        $row['d_02'] = $this->d_02->DefaultValue;
        $row['d_03'] = $this->d_03->DefaultValue;
        $row['d_04'] = $this->d_04->DefaultValue;
        $row['d_05'] = $this->d_05->DefaultValue;
        $row['d_06'] = $this->d_06->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // partner_type
        $this->partner_type->RowCssClass = "row";

        // partner
        $this->partner->RowCssClass = "row";

        // partner_ref
        $this->partner_ref->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // partner_code
        $this->partner_code->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // spl_ins
        $this->spl_ins->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // w
        $this->w->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l
        $this->l->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // h
        $this->h->RowCssClass = "row";

        // h_cm
        $this->h_cm->RowCssClass = "row";

        // partner_size
        $this->partner_size->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // weight_sqm
        $this->weight_sqm->RowCssClass = "row";

        // sqm_a
        $this->sqm_a->RowCssClass = "row";

        // 2srm_a
        $this->_2srm_a->RowCssClass = "row";

        // 4srm_a
        $this->_4srm_a->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // price_cs
        $this->price_cs->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // hsn
        $this->hsn->RowCssClass = "row";

        // composition
        $this->composition->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // gcode
        $this->gcode->RowCssClass = "row";

        // d_01
        $this->d_01->RowCssClass = "row";

        // d_02
        $this->d_02->RowCssClass = "row";

        // d_03
        $this->d_03->RowCssClass = "row";

        // d_04
        $this->d_04->RowCssClass = "row";

        // d_05
        $this->d_05->RowCssClass = "row";

        // d_06
        $this->d_06->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // partner_type
            $curVal = strval($this->partner_type->CurrentValue);
            if ($curVal != "") {
                $this->partner_type->ViewValue = $this->partner_type->lookupCacheOption($curVal);
                if ($this->partner_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_type->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_type->ViewValue = $this->partner_type->displayValue($arwrk);
                    } else {
                        $this->partner_type->ViewValue = FormatNumber($this->partner_type->CurrentValue, $this->partner_type->formatPattern());
                    }
                }
            } else {
                $this->partner_type->ViewValue = null;
            }

            // partner
            $curVal = strval($this->partner->CurrentValue);
            if ($curVal != "") {
                $this->partner->ViewValue = $this->partner->lookupCacheOption($curVal);
                if ($this->partner->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner->Lookup->renderViewRow($rswrk[0]);
                        $this->partner->ViewValue = $this->partner->displayValue($arwrk);
                    } else {
                        $this->partner->ViewValue = FormatNumber($this->partner->CurrentValue, $this->partner->formatPattern());
                    }
                }
            } else {
                $this->partner->ViewValue = null;
            }

            // partner_ref
            $this->partner_ref->ViewValue = $this->partner_ref->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // partner_code
            $this->partner_code->ViewValue = $this->partner_code->CurrentValue;

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = FormatNumber($this->product_type->CurrentValue, $this->product_type->formatPattern());
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // spl_ins
            $this->spl_ins->ViewValue = $this->spl_ins->CurrentValue;

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // batch_no
            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // unit
            if (strval($this->unit->CurrentValue) != "") {
                $this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
            } else {
                $this->unit->ViewValue = null;
            }

            // w
            $this->w->ViewValue = $this->w->CurrentValue;

            // w_cm
            $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
            $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

            // l
            $this->l->ViewValue = $this->l->CurrentValue;

            // l_cm
            $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
            $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

            // h
            $this->h->ViewValue = $this->h->CurrentValue;

            // h_cm
            $this->h_cm->ViewValue = $this->h_cm->CurrentValue;
            $this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, $this->h_cm->formatPattern());

            // partner_size
            $this->partner_size->ViewValue = $this->partner_size->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // weight_sqm
            $this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
            $this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, $this->weight_sqm->formatPattern());

            // sqm_a
            $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

            // 2srm_a
            $this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
            $this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, $this->_2srm_a->formatPattern());

            // 4srm_a
            $this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
            $this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, $this->_4srm_a->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // price_cs
            $this->price_cs->ViewValue = $this->price_cs->CurrentValue;
            $this->price_cs->ViewValue = FormatNumber($this->price_cs->ViewValue, $this->price_cs->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // hsn
            $curVal = strval($this->hsn->CurrentValue);
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
                if ($this->hsn->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                    $sqlWrk = $this->hsn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->hsn->Lookup->renderViewRow($rswrk[0]);
                        $this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
                    } else {
                        $this->hsn->ViewValue = FormatNumber($this->hsn->CurrentValue, $this->hsn->formatPattern());
                    }
                }
            } else {
                $this->hsn->ViewValue = null;
            }

            // composition
            $curVal = strval($this->composition->CurrentValue);
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
                if ($this->composition->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                    $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                        $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                    } else {
                        $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                    }
                }
            } else {
                $this->composition->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;

            // d_03
            $this->d_03->ViewValue = $this->d_03->CurrentValue;

            // d_04
            $this->d_04->ViewValue = $this->d_04->CurrentValue;

            // d_05
            $this->d_05->ViewValue = $this->d_05->CurrentValue;

            // d_06
            $this->d_06->ViewValue = $this->d_06->CurrentValue;

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";

            // spl_ins
            $this->spl_ins->HrefValue = "";
            $this->spl_ins->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // weight_sqm
            $this->weight_sqm->HrefValue = "";
            $this->weight_sqm->TooltipValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";
            $this->sqm_a->TooltipValue = "";

            // 2srm_a
            $this->_2srm_a->HrefValue = "";
            $this->_2srm_a->TooltipValue = "";

            // 4srm_a
            $this->_4srm_a->HrefValue = "";
            $this->_4srm_a->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // price_cs
            $this->price_cs->HrefValue = "";
            $this->price_cs->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // hsn
            $this->hsn->HrefValue = "";
            $this->hsn->TooltipValue = "";

            // composition
            $this->composition->HrefValue = "";
            $this->composition->TooltipValue = "";

            // d_01
            $this->d_01->HrefValue = "";
            $this->d_01->TooltipValue = "";

            // d_02
            $this->d_02->HrefValue = "";
            $this->d_02->TooltipValue = "";

            // d_03
            $this->d_03->HrefValue = "";
            $this->d_03->TooltipValue = "";

            // d_04
            $this->d_04->HrefValue = "";
            $this->d_04->TooltipValue = "";

            // d_05
            $this->d_05->HrefValue = "";
            $this->d_05->TooltipValue = "";

            // d_06
            $this->d_06->HrefValue = "";
            $this->d_06->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // spl_ins
            $this->spl_ins->setupEditAttributes();
            if (!$this->spl_ins->Raw) {
                $this->spl_ins->CurrentValue = HtmlDecode($this->spl_ins->CurrentValue);
            }
            $this->spl_ins->EditValue = HtmlEncode($this->spl_ins->CurrentValue);
            $this->spl_ins->PlaceHolder = RemoveHtml($this->spl_ins->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditValue = $this->cbm->CurrentValue;
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
            if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
                $this->cbm->EditValue = FormatNumber($this->cbm->EditValue, null);
            }

            // weight_sqm
            $this->weight_sqm->setupEditAttributes();
            $this->weight_sqm->EditValue = $this->weight_sqm->CurrentValue;
            $this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
            if (strval($this->weight_sqm->EditValue) != "" && is_numeric($this->weight_sqm->EditValue)) {
                $this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, null);
            }

            // sqm_a
            $this->sqm_a->setupEditAttributes();
            $this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
            if (strval($this->sqm_a->EditValue) != "" && is_numeric($this->sqm_a->EditValue)) {
                $this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, null);
            }

            // 2srm_a
            $this->_2srm_a->setupEditAttributes();
            $this->_2srm_a->EditValue = $this->_2srm_a->CurrentValue;
            $this->_2srm_a->PlaceHolder = RemoveHtml($this->_2srm_a->caption());
            if (strval($this->_2srm_a->EditValue) != "" && is_numeric($this->_2srm_a->EditValue)) {
                $this->_2srm_a->EditValue = FormatNumber($this->_2srm_a->EditValue, null);
            }

            // 4srm_a
            $this->_4srm_a->setupEditAttributes();
            $this->_4srm_a->EditValue = $this->_4srm_a->CurrentValue;
            $this->_4srm_a->PlaceHolder = RemoveHtml($this->_4srm_a->caption());
            if (strval($this->_4srm_a->EditValue) != "" && is_numeric($this->_4srm_a->EditValue)) {
                $this->_4srm_a->EditValue = FormatNumber($this->_4srm_a->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // price_cs
            $this->price_cs->setupEditAttributes();
            $this->price_cs->EditValue = $this->price_cs->CurrentValue;
            $this->price_cs->PlaceHolder = RemoveHtml($this->price_cs->caption());
            if (strval($this->price_cs->EditValue) != "" && is_numeric($this->price_cs->EditValue)) {
                $this->price_cs->EditValue = FormatNumber($this->price_cs->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // hsn
            $this->hsn->setupEditAttributes();
            $curVal = trim(strval($this->hsn->CurrentValue));
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
            } else {
                $this->hsn->ViewValue = $this->hsn->Lookup !== null && is_array($this->hsn->lookupOptions()) && count($this->hsn->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->hsn->ViewValue !== null) { // Load from cache
                $this->hsn->EditValue = array_values($this->hsn->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->hsn->CurrentValue, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                $sqlWrk = $this->hsn->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->hsn->Lookup->renderViewRow($row);
                }
                $this->hsn->EditValue = $arwrk;
            }
            $this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

            // composition
            $this->composition->setupEditAttributes();
            $curVal = trim(strval($this->composition->CurrentValue));
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
            } else {
                $this->composition->ViewValue = $this->composition->Lookup !== null && is_array($this->composition->lookupOptions()) && count($this->composition->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->composition->ViewValue !== null) { // Load from cache
                $this->composition->EditValue = array_values($this->composition->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->composition->CurrentValue, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                $sqlWrk = $this->composition->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->composition->EditValue = $arwrk;
            }
            $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

            // d_01
            $this->d_01->setupEditAttributes();
            if (!$this->d_01->Raw) {
                $this->d_01->CurrentValue = HtmlDecode($this->d_01->CurrentValue);
            }
            $this->d_01->EditValue = HtmlEncode($this->d_01->CurrentValue);
            $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

            // d_02
            $this->d_02->setupEditAttributes();
            if (!$this->d_02->Raw) {
                $this->d_02->CurrentValue = HtmlDecode($this->d_02->CurrentValue);
            }
            $this->d_02->EditValue = HtmlEncode($this->d_02->CurrentValue);
            $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

            // d_03
            $this->d_03->setupEditAttributes();
            if (!$this->d_03->Raw) {
                $this->d_03->CurrentValue = HtmlDecode($this->d_03->CurrentValue);
            }
            $this->d_03->EditValue = HtmlEncode($this->d_03->CurrentValue);
            $this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());

            // d_04
            $this->d_04->setupEditAttributes();
            if (!$this->d_04->Raw) {
                $this->d_04->CurrentValue = HtmlDecode($this->d_04->CurrentValue);
            }
            $this->d_04->EditValue = HtmlEncode($this->d_04->CurrentValue);
            $this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());

            // d_05
            $this->d_05->setupEditAttributes();
            if (!$this->d_05->Raw) {
                $this->d_05->CurrentValue = HtmlDecode($this->d_05->CurrentValue);
            }
            $this->d_05->EditValue = HtmlEncode($this->d_05->CurrentValue);
            $this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());

            // d_06
            $this->d_06->setupEditAttributes();
            if (!$this->d_06->Raw) {
                $this->d_06->CurrentValue = HtmlDecode($this->d_06->CurrentValue);
            }
            $this->d_06->EditValue = HtmlEncode($this->d_06->CurrentValue);
            $this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());

            // Edit refer script

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // spl_ins
            $this->spl_ins->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // weight_sqm
            $this->weight_sqm->HrefValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";

            // 2srm_a
            $this->_2srm_a->HrefValue = "";

            // 4srm_a
            $this->_4srm_a->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // price_cs
            $this->price_cs->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // hsn
            $this->hsn->HrefValue = "";

            // composition
            $this->composition->HrefValue = "";

            // d_01
            $this->d_01->HrefValue = "";

            // d_02
            $this->d_02->HrefValue = "";

            // d_03
            $this->d_03->HrefValue = "";

            // d_04
            $this->d_04->HrefValue = "";

            // d_05
            $this->d_05->HrefValue = "";

            // d_06
            $this->d_06->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;
        $updateCnt = 0;
        if ($this->grp->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->spl_ins->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->packing_type->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->cbm->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->weight_sqm->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->sqm_a->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->_2srm_a->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->_4srm_a->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->price->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->price_cs->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->currency->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->hsn->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->composition->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_01->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_02->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_03->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_04->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_05->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_06->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($updateCnt == 0) {
            return false;
        }

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->grp->Visible && $this->grp->Required) {
                if ($this->grp->MultiUpdate != "" && !$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->spl_ins->Visible && $this->spl_ins->Required) {
                if ($this->spl_ins->MultiUpdate != "" && !$this->spl_ins->IsDetailKey && EmptyValue($this->spl_ins->FormValue)) {
                    $this->spl_ins->addErrorMessage(str_replace("%s", $this->spl_ins->caption(), $this->spl_ins->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if ($this->packing_type->MultiUpdate != "" && !$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->cbm->Visible && $this->cbm->Required) {
                if ($this->cbm->MultiUpdate != "" && !$this->cbm->IsDetailKey && EmptyValue($this->cbm->FormValue)) {
                    $this->cbm->addErrorMessage(str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
                }
            }
            if ($this->cbm->MultiUpdate != "") {
                if (!CheckNumber($this->cbm->FormValue)) {
                    $this->cbm->addErrorMessage($this->cbm->getErrorMessage(false));
                }
            }
            if ($this->weight_sqm->Visible && $this->weight_sqm->Required) {
                if ($this->weight_sqm->MultiUpdate != "" && !$this->weight_sqm->IsDetailKey && EmptyValue($this->weight_sqm->FormValue)) {
                    $this->weight_sqm->addErrorMessage(str_replace("%s", $this->weight_sqm->caption(), $this->weight_sqm->RequiredErrorMessage));
                }
            }
            if ($this->weight_sqm->MultiUpdate != "") {
                if (!CheckNumber($this->weight_sqm->FormValue)) {
                    $this->weight_sqm->addErrorMessage($this->weight_sqm->getErrorMessage(false));
                }
            }
            if ($this->sqm_a->Visible && $this->sqm_a->Required) {
                if ($this->sqm_a->MultiUpdate != "" && !$this->sqm_a->IsDetailKey && EmptyValue($this->sqm_a->FormValue)) {
                    $this->sqm_a->addErrorMessage(str_replace("%s", $this->sqm_a->caption(), $this->sqm_a->RequiredErrorMessage));
                }
            }
            if ($this->sqm_a->MultiUpdate != "") {
                if (!CheckNumber($this->sqm_a->FormValue)) {
                    $this->sqm_a->addErrorMessage($this->sqm_a->getErrorMessage(false));
                }
            }
            if ($this->_2srm_a->Visible && $this->_2srm_a->Required) {
                if ($this->_2srm_a->MultiUpdate != "" && !$this->_2srm_a->IsDetailKey && EmptyValue($this->_2srm_a->FormValue)) {
                    $this->_2srm_a->addErrorMessage(str_replace("%s", $this->_2srm_a->caption(), $this->_2srm_a->RequiredErrorMessage));
                }
            }
            if ($this->_2srm_a->MultiUpdate != "") {
                if (!CheckNumber($this->_2srm_a->FormValue)) {
                    $this->_2srm_a->addErrorMessage($this->_2srm_a->getErrorMessage(false));
                }
            }
            if ($this->_4srm_a->Visible && $this->_4srm_a->Required) {
                if ($this->_4srm_a->MultiUpdate != "" && !$this->_4srm_a->IsDetailKey && EmptyValue($this->_4srm_a->FormValue)) {
                    $this->_4srm_a->addErrorMessage(str_replace("%s", $this->_4srm_a->caption(), $this->_4srm_a->RequiredErrorMessage));
                }
            }
            if ($this->_4srm_a->MultiUpdate != "") {
                if (!CheckNumber($this->_4srm_a->FormValue)) {
                    $this->_4srm_a->addErrorMessage($this->_4srm_a->getErrorMessage(false));
                }
            }
            if ($this->price->Visible && $this->price->Required) {
                if ($this->price->MultiUpdate != "" && !$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if ($this->price->MultiUpdate != "") {
                if (!CheckNumber($this->price->FormValue)) {
                    $this->price->addErrorMessage($this->price->getErrorMessage(false));
                }
            }
            if ($this->price_cs->Visible && $this->price_cs->Required) {
                if ($this->price_cs->MultiUpdate != "" && !$this->price_cs->IsDetailKey && EmptyValue($this->price_cs->FormValue)) {
                    $this->price_cs->addErrorMessage(str_replace("%s", $this->price_cs->caption(), $this->price_cs->RequiredErrorMessage));
                }
            }
            if ($this->price_cs->MultiUpdate != "") {
                if (!CheckNumber($this->price_cs->FormValue)) {
                    $this->price_cs->addErrorMessage($this->price_cs->getErrorMessage(false));
                }
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if ($this->currency->MultiUpdate != "" && !$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->hsn->Visible && $this->hsn->Required) {
                if ($this->hsn->MultiUpdate != "" && !$this->hsn->IsDetailKey && EmptyValue($this->hsn->FormValue)) {
                    $this->hsn->addErrorMessage(str_replace("%s", $this->hsn->caption(), $this->hsn->RequiredErrorMessage));
                }
            }
            if ($this->composition->Visible && $this->composition->Required) {
                if ($this->composition->MultiUpdate != "" && !$this->composition->IsDetailKey && EmptyValue($this->composition->FormValue)) {
                    $this->composition->addErrorMessage(str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
                }
            }
            if ($this->d_01->Visible && $this->d_01->Required) {
                if ($this->d_01->MultiUpdate != "" && !$this->d_01->IsDetailKey && EmptyValue($this->d_01->FormValue)) {
                    $this->d_01->addErrorMessage(str_replace("%s", $this->d_01->caption(), $this->d_01->RequiredErrorMessage));
                }
            }
            if ($this->d_02->Visible && $this->d_02->Required) {
                if ($this->d_02->MultiUpdate != "" && !$this->d_02->IsDetailKey && EmptyValue($this->d_02->FormValue)) {
                    $this->d_02->addErrorMessage(str_replace("%s", $this->d_02->caption(), $this->d_02->RequiredErrorMessage));
                }
            }
            if ($this->d_03->Visible && $this->d_03->Required) {
                if ($this->d_03->MultiUpdate != "" && !$this->d_03->IsDetailKey && EmptyValue($this->d_03->FormValue)) {
                    $this->d_03->addErrorMessage(str_replace("%s", $this->d_03->caption(), $this->d_03->RequiredErrorMessage));
                }
            }
            if ($this->d_04->Visible && $this->d_04->Required) {
                if ($this->d_04->MultiUpdate != "" && !$this->d_04->IsDetailKey && EmptyValue($this->d_04->FormValue)) {
                    $this->d_04->addErrorMessage(str_replace("%s", $this->d_04->caption(), $this->d_04->RequiredErrorMessage));
                }
            }
            if ($this->d_05->Visible && $this->d_05->Required) {
                if ($this->d_05->MultiUpdate != "" && !$this->d_05->IsDetailKey && EmptyValue($this->d_05->FormValue)) {
                    $this->d_05->addErrorMessage(str_replace("%s", $this->d_05->caption(), $this->d_05->RequiredErrorMessage));
                }
            }
            if ($this->d_06->Visible && $this->d_06->Required) {
                if ($this->d_06->MultiUpdate != "" && !$this->d_06->IsDetailKey && EmptyValue($this->d_06->FormValue)) {
                    $this->d_06->addErrorMessage(str_replace("%s", $this->d_06->caption(), $this->d_06->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly || $this->grp->MultiUpdate != "1");

        // spl_ins
        $this->spl_ins->setDbValueDef($rsnew, $this->spl_ins->CurrentValue, $this->spl_ins->ReadOnly || $this->spl_ins->MultiUpdate != "1");

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, $this->packing_type->ReadOnly || $this->packing_type->MultiUpdate != "1");

        // cbm
        $this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, $this->cbm->ReadOnly || $this->cbm->MultiUpdate != "1");

        // weight_sqm
        $this->weight_sqm->setDbValueDef($rsnew, $this->weight_sqm->CurrentValue, $this->weight_sqm->ReadOnly || $this->weight_sqm->MultiUpdate != "1");

        // sqm_a
        $this->sqm_a->setDbValueDef($rsnew, $this->sqm_a->CurrentValue, $this->sqm_a->ReadOnly || $this->sqm_a->MultiUpdate != "1");

        // 2srm_a
        $this->_2srm_a->setDbValueDef($rsnew, $this->_2srm_a->CurrentValue, $this->_2srm_a->ReadOnly || $this->_2srm_a->MultiUpdate != "1");

        // 4srm_a
        $this->_4srm_a->setDbValueDef($rsnew, $this->_4srm_a->CurrentValue, $this->_4srm_a->ReadOnly || $this->_4srm_a->MultiUpdate != "1");

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, $this->price->ReadOnly || $this->price->MultiUpdate != "1");

        // price_cs
        $this->price_cs->setDbValueDef($rsnew, $this->price_cs->CurrentValue, $this->price_cs->ReadOnly || $this->price_cs->MultiUpdate != "1");

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, $this->currency->ReadOnly || $this->currency->MultiUpdate != "1");

        // hsn
        $this->hsn->setDbValueDef($rsnew, $this->hsn->CurrentValue, $this->hsn->ReadOnly || $this->hsn->MultiUpdate != "1");

        // composition
        $this->composition->setDbValueDef($rsnew, $this->composition->CurrentValue, $this->composition->ReadOnly || $this->composition->MultiUpdate != "1");

        // d_01
        $this->d_01->setDbValueDef($rsnew, $this->d_01->CurrentValue, $this->d_01->ReadOnly || $this->d_01->MultiUpdate != "1");

        // d_02
        $this->d_02->setDbValueDef($rsnew, $this->d_02->CurrentValue, $this->d_02->ReadOnly || $this->d_02->MultiUpdate != "1");

        // d_03
        $this->d_03->setDbValueDef($rsnew, $this->d_03->CurrentValue, $this->d_03->ReadOnly || $this->d_03->MultiUpdate != "1");

        // d_04
        $this->d_04->setDbValueDef($rsnew, $this->d_04->CurrentValue, $this->d_04->ReadOnly || $this->d_04->MultiUpdate != "1");

        // d_05
        $this->d_05->setDbValueDef($rsnew, $this->d_05->CurrentValue, $this->d_05->ReadOnly || $this->d_05->MultiUpdate != "1");

        // d_06
        $this->d_06->setDbValueDef($rsnew, $this->d_06->CurrentValue, $this->d_06->ReadOnly || $this->d_06->MultiUpdate != "1");
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['spl_ins'])) { // spl_ins
            $this->spl_ins->CurrentValue = $row['spl_ins'];
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->CurrentValue = $row['packing_type'];
        }
        if (isset($row['cbm'])) { // cbm
            $this->cbm->CurrentValue = $row['cbm'];
        }
        if (isset($row['weight_sqm'])) { // weight_sqm
            $this->weight_sqm->CurrentValue = $row['weight_sqm'];
        }
        if (isset($row['sqm_a'])) { // sqm_a
            $this->sqm_a->CurrentValue = $row['sqm_a'];
        }
        if (isset($row['2srm_a'])) { // 2srm_a
            $this->_2srm_a->CurrentValue = $row['2srm_a'];
        }
        if (isset($row['4srm_a'])) { // 4srm_a
            $this->_4srm_a->CurrentValue = $row['4srm_a'];
        }
        if (isset($row['price'])) { // price
            $this->price->CurrentValue = $row['price'];
        }
        if (isset($row['price_cs'])) { // price_cs
            $this->price_cs->CurrentValue = $row['price_cs'];
        }
        if (isset($row['currency'])) { // currency
            $this->currency->CurrentValue = $row['currency'];
        }
        if (isset($row['hsn'])) { // hsn
            $this->hsn->CurrentValue = $row['hsn'];
        }
        if (isset($row['composition'])) { // composition
            $this->composition->CurrentValue = $row['composition'];
        }
        if (isset($row['d_01'])) { // d_01
            $this->d_01->CurrentValue = $row['d_01'];
        }
        if (isset($row['d_02'])) { // d_02
            $this->d_02->CurrentValue = $row['d_02'];
        }
        if (isset($row['d_03'])) { // d_03
            $this->d_03->CurrentValue = $row['d_03'];
        }
        if (isset($row['d_04'])) { // d_04
            $this->d_04->CurrentValue = $row['d_04'];
        }
        if (isset($row['d_05'])) { // d_05
            $this->d_05->CurrentValue = $row['d_05'];
        }
        if (isset($row['d_06'])) { // d_06
            $this->d_06->CurrentValue = $row['d_06'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("partnerproductreflist"), "", $this->TableVar, true);
        $pageId = "update";
        $Breadcrumb->add("update", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_partner_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_hsn":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_composition":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                case "x_gcode":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'partner_product_ref');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
