<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PartnerProductRefAdd extends PartnerProductRef
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PartnerProductRefAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "partnerproductrefadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->partner_type->setVisibility();
        $this->partner->setVisibility();
        $this->partner_ref->setVisibility();
        $this->_barcode->setVisibility();
        $this->partner_code->setVisibility();
        $this->product_type->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->rid->setVisibility();
        $this->spl_ins->setVisibility();
        $this->packing_type->setVisibility();
        $this->batch_no->setVisibility();
        $this->shape->setVisibility();
        $this->unit->setVisibility();
        $this->w->setVisibility();
        $this->w_cm->setVisibility();
        $this->l->setVisibility();
        $this->l_cm->setVisibility();
        $this->h->setVisibility();
        $this->h_cm->setVisibility();
        $this->partner_size->setVisibility();
        $this->sqm->setVisibility();
        $this->cbm->setVisibility();
        $this->weight_sqm->setVisibility();
        $this->sqm_a->setVisibility();
        $this->_2srm_a->setVisibility();
        $this->_4srm_a->setVisibility();
        $this->price->setVisibility();
        $this->price_cs->setVisibility();
        $this->currency->setVisibility();
        $this->hsn->setVisibility();
        $this->composition->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->gcode->Visible = false;
        $this->d_01->setVisibility();
        $this->d_02->setVisibility();
        $this->d_03->setVisibility();
        $this->d_04->setVisibility();
        $this->d_05->setVisibility();
        $this->d_06->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'partner_product_ref';
        $this->TableName = 'partner_product_ref';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (partner_product_ref)
        if (!isset($GLOBALS["partner_product_ref"]) || $GLOBALS["partner_product_ref"]::class == PROJECT_NAMESPACE . "partner_product_ref") {
            $GLOBALS["partner_product_ref"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'partner_product_ref');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "partnerproductrefview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->partner_type);
        $this->setupLookupOptions($this->partner);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->hsn);
        $this->setupLookupOptions($this->composition);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->gcode);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("partnerproductreflist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "partnerproductreflist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "partnerproductrefview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "partnerproductreflist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "partnerproductreflist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->partner_type->DefaultValue = $this->partner_type->getDefault(); // PHP
        $this->partner_type->OldValue = $this->partner_type->DefaultValue;
        $this->partner->DefaultValue = $this->partner->getDefault(); // PHP
        $this->partner->OldValue = $this->partner->DefaultValue;
        $this->product_type->DefaultValue = $this->product_type->getDefault(); // PHP
        $this->product_type->OldValue = $this->product_type->DefaultValue;
        $this->shape->DefaultValue = $this->shape->getDefault(); // PHP
        $this->shape->OldValue = $this->shape->DefaultValue;
        $this->unit->DefaultValue = $this->unit->getDefault(); // PHP
        $this->unit->OldValue = $this->unit->DefaultValue;
        $this->w->DefaultValue = $this->w->getDefault(); // PHP
        $this->w->OldValue = $this->w->DefaultValue;
        $this->l->DefaultValue = $this->l->getDefault(); // PHP
        $this->l->OldValue = $this->l->DefaultValue;
        $this->h->DefaultValue = $this->h->getDefault(); // PHP
        $this->h->OldValue = $this->h->DefaultValue;
        $this->cbm->DefaultValue = $this->cbm->getDefault(); // PHP
        $this->cbm->OldValue = $this->cbm->DefaultValue;
        $this->price->DefaultValue = $this->price->getDefault(); // PHP
        $this->price->OldValue = $this->price->DefaultValue;
        $this->currency->DefaultValue = $this->currency->getDefault(); // PHP
        $this->currency->OldValue = $this->currency->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'partner_type' first before field var 'x_partner_type'
        $val = $CurrentForm->hasValue("partner_type") ? $CurrentForm->getValue("partner_type") : $CurrentForm->getValue("x_partner_type");
        if (!$this->partner_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_type->Visible = false; // Disable update for API request
            } else {
                $this->partner_type->setFormValue($val);
            }
        }

        // Check field name 'partner' first before field var 'x_partner'
        $val = $CurrentForm->hasValue("partner") ? $CurrentForm->getValue("partner") : $CurrentForm->getValue("x_partner");
        if (!$this->partner->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner->Visible = false; // Disable update for API request
            } else {
                $this->partner->setFormValue($val);
            }
        }

        // Check field name 'partner_ref' first before field var 'x_partner_ref'
        $val = $CurrentForm->hasValue("partner_ref") ? $CurrentForm->getValue("partner_ref") : $CurrentForm->getValue("x_partner_ref");
        if (!$this->partner_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_ref->Visible = false; // Disable update for API request
            } else {
                $this->partner_ref->setFormValue($val);
            }
        }

        // Check field name 'barcode' first before field var 'x__barcode'
        $val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
        if (!$this->_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_barcode->Visible = false; // Disable update for API request
            } else {
                $this->_barcode->setFormValue($val);
            }
        }

        // Check field name 'partner_code' first before field var 'x_partner_code'
        $val = $CurrentForm->hasValue("partner_code") ? $CurrentForm->getValue("partner_code") : $CurrentForm->getValue("x_partner_code");
        if (!$this->partner_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_code->Visible = false; // Disable update for API request
            } else {
                $this->partner_code->setFormValue($val);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'spl_ins' first before field var 'x_spl_ins'
        $val = $CurrentForm->hasValue("spl_ins") ? $CurrentForm->getValue("spl_ins") : $CurrentForm->getValue("x_spl_ins");
        if (!$this->spl_ins->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->spl_ins->Visible = false; // Disable update for API request
            } else {
                $this->spl_ins->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'shape' first before field var 'x_shape'
        $val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
        if (!$this->shape->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shape->Visible = false; // Disable update for API request
            } else {
                $this->shape->setFormValue($val);
            }
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }

        // Check field name 'w' first before field var 'x_w'
        $val = $CurrentForm->hasValue("w") ? $CurrentForm->getValue("w") : $CurrentForm->getValue("x_w");
        if (!$this->w->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->w->Visible = false; // Disable update for API request
            } else {
                $this->w->setFormValue($val);
            }
        }

        // Check field name 'w_cm' first before field var 'x_w_cm'
        $val = $CurrentForm->hasValue("w_cm") ? $CurrentForm->getValue("w_cm") : $CurrentForm->getValue("x_w_cm");
        if (!$this->w_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->w_cm->Visible = false; // Disable update for API request
            } else {
                $this->w_cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'l' first before field var 'x_l'
        $val = $CurrentForm->hasValue("l") ? $CurrentForm->getValue("l") : $CurrentForm->getValue("x_l");
        if (!$this->l->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->l->Visible = false; // Disable update for API request
            } else {
                $this->l->setFormValue($val);
            }
        }

        // Check field name 'l_cm' first before field var 'x_l_cm'
        $val = $CurrentForm->hasValue("l_cm") ? $CurrentForm->getValue("l_cm") : $CurrentForm->getValue("x_l_cm");
        if (!$this->l_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->l_cm->Visible = false; // Disable update for API request
            } else {
                $this->l_cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'h' first before field var 'x_h'
        $val = $CurrentForm->hasValue("h") ? $CurrentForm->getValue("h") : $CurrentForm->getValue("x_h");
        if (!$this->h->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->h->Visible = false; // Disable update for API request
            } else {
                $this->h->setFormValue($val);
            }
        }

        // Check field name 'h_cm' first before field var 'x_h_cm'
        $val = $CurrentForm->hasValue("h_cm") ? $CurrentForm->getValue("h_cm") : $CurrentForm->getValue("x_h_cm");
        if (!$this->h_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->h_cm->Visible = false; // Disable update for API request
            } else {
                $this->h_cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'partner_size' first before field var 'x_partner_size'
        $val = $CurrentForm->hasValue("partner_size") ? $CurrentForm->getValue("partner_size") : $CurrentForm->getValue("x_partner_size");
        if (!$this->partner_size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_size->Visible = false; // Disable update for API request
            } else {
                $this->partner_size->setFormValue($val);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val);
            }
        }

        // Check field name 'cbm' first before field var 'x_cbm'
        $val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
        if (!$this->cbm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cbm->Visible = false; // Disable update for API request
            } else {
                $this->cbm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'weight_sqm' first before field var 'x_weight_sqm'
        $val = $CurrentForm->hasValue("weight_sqm") ? $CurrentForm->getValue("weight_sqm") : $CurrentForm->getValue("x_weight_sqm");
        if (!$this->weight_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weight_sqm->Visible = false; // Disable update for API request
            } else {
                $this->weight_sqm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sqm_a' first before field var 'x_sqm_a'
        $val = $CurrentForm->hasValue("sqm_a") ? $CurrentForm->getValue("sqm_a") : $CurrentForm->getValue("x_sqm_a");
        if (!$this->sqm_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm_a->Visible = false; // Disable update for API request
            } else {
                $this->sqm_a->setFormValue($val, true, $validate);
            }
        }

        // Check field name '2srm_a' first before field var 'x__2srm_a'
        $val = $CurrentForm->hasValue("2srm_a") ? $CurrentForm->getValue("2srm_a") : $CurrentForm->getValue("x__2srm_a");
        if (!$this->_2srm_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_2srm_a->Visible = false; // Disable update for API request
            } else {
                $this->_2srm_a->setFormValue($val, true, $validate);
            }
        }

        // Check field name '4srm_a' first before field var 'x__4srm_a'
        $val = $CurrentForm->hasValue("4srm_a") ? $CurrentForm->getValue("4srm_a") : $CurrentForm->getValue("x__4srm_a");
        if (!$this->_4srm_a->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_4srm_a->Visible = false; // Disable update for API request
            } else {
                $this->_4srm_a->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'price_cs' first before field var 'x_price_cs'
        $val = $CurrentForm->hasValue("price_cs") ? $CurrentForm->getValue("price_cs") : $CurrentForm->getValue("x_price_cs");
        if (!$this->price_cs->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price_cs->Visible = false; // Disable update for API request
            } else {
                $this->price_cs->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }

        // Check field name 'hsn' first before field var 'x_hsn'
        $val = $CurrentForm->hasValue("hsn") ? $CurrentForm->getValue("hsn") : $CurrentForm->getValue("x_hsn");
        if (!$this->hsn->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->hsn->Visible = false; // Disable update for API request
            } else {
                $this->hsn->setFormValue($val);
            }
        }

        // Check field name 'composition' first before field var 'x_composition'
        $val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
        if (!$this->composition->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->composition->Visible = false; // Disable update for API request
            } else {
                $this->composition->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'd_01' first before field var 'x_d_01'
        $val = $CurrentForm->hasValue("d_01") ? $CurrentForm->getValue("d_01") : $CurrentForm->getValue("x_d_01");
        if (!$this->d_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_01->Visible = false; // Disable update for API request
            } else {
                $this->d_01->setFormValue($val);
            }
        }

        // Check field name 'd_02' first before field var 'x_d_02'
        $val = $CurrentForm->hasValue("d_02") ? $CurrentForm->getValue("d_02") : $CurrentForm->getValue("x_d_02");
        if (!$this->d_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_02->Visible = false; // Disable update for API request
            } else {
                $this->d_02->setFormValue($val);
            }
        }

        // Check field name 'd_03' first before field var 'x_d_03'
        $val = $CurrentForm->hasValue("d_03") ? $CurrentForm->getValue("d_03") : $CurrentForm->getValue("x_d_03");
        if (!$this->d_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_03->Visible = false; // Disable update for API request
            } else {
                $this->d_03->setFormValue($val);
            }
        }

        // Check field name 'd_04' first before field var 'x_d_04'
        $val = $CurrentForm->hasValue("d_04") ? $CurrentForm->getValue("d_04") : $CurrentForm->getValue("x_d_04");
        if (!$this->d_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_04->Visible = false; // Disable update for API request
            } else {
                $this->d_04->setFormValue($val);
            }
        }

        // Check field name 'd_05' first before field var 'x_d_05'
        $val = $CurrentForm->hasValue("d_05") ? $CurrentForm->getValue("d_05") : $CurrentForm->getValue("x_d_05");
        if (!$this->d_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_05->Visible = false; // Disable update for API request
            } else {
                $this->d_05->setFormValue($val);
            }
        }

        // Check field name 'd_06' first before field var 'x_d_06'
        $val = $CurrentForm->hasValue("d_06") ? $CurrentForm->getValue("d_06") : $CurrentForm->getValue("x_d_06");
        if (!$this->d_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_06->Visible = false; // Disable update for API request
            } else {
                $this->d_06->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->partner_type->CurrentValue = $this->partner_type->FormValue;
        $this->partner->CurrentValue = $this->partner->FormValue;
        $this->partner_ref->CurrentValue = $this->partner_ref->FormValue;
        $this->_barcode->CurrentValue = $this->_barcode->FormValue;
        $this->partner_code->CurrentValue = $this->partner_code->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->spl_ins->CurrentValue = $this->spl_ins->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->shape->CurrentValue = $this->shape->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->w->CurrentValue = $this->w->FormValue;
        $this->w_cm->CurrentValue = $this->w_cm->FormValue;
        $this->l->CurrentValue = $this->l->FormValue;
        $this->l_cm->CurrentValue = $this->l_cm->FormValue;
        $this->h->CurrentValue = $this->h->FormValue;
        $this->h_cm->CurrentValue = $this->h_cm->FormValue;
        $this->partner_size->CurrentValue = $this->partner_size->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->cbm->CurrentValue = $this->cbm->FormValue;
        $this->weight_sqm->CurrentValue = $this->weight_sqm->FormValue;
        $this->sqm_a->CurrentValue = $this->sqm_a->FormValue;
        $this->_2srm_a->CurrentValue = $this->_2srm_a->FormValue;
        $this->_4srm_a->CurrentValue = $this->_4srm_a->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->price_cs->CurrentValue = $this->price_cs->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->hsn->CurrentValue = $this->hsn->FormValue;
        $this->composition->CurrentValue = $this->composition->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->d_01->CurrentValue = $this->d_01->FormValue;
        $this->d_02->CurrentValue = $this->d_02->FormValue;
        $this->d_03->CurrentValue = $this->d_03->FormValue;
        $this->d_04->CurrentValue = $this->d_04->FormValue;
        $this->d_05->CurrentValue = $this->d_05->FormValue;
        $this->d_06->CurrentValue = $this->d_06->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->partner_type->setDbValue($row['partner_type']);
        $this->partner->setDbValue($row['partner']);
        $this->partner_ref->setDbValue($row['partner_ref']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->partner_code->setDbValue($row['partner_code']);
        $this->product_type->setDbValue($row['product_type']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->spl_ins->setDbValue($row['spl_ins']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->shape->setDbValue($row['shape']);
        $this->unit->setDbValue($row['unit']);
        $this->w->setDbValue($row['w']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l->setDbValue($row['l']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->h->setDbValue($row['h']);
        $this->h_cm->setDbValue($row['h_cm']);
        $this->partner_size->setDbValue($row['partner_size']);
        $this->sqm->setDbValue($row['sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->weight_sqm->setDbValue($row['weight_sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->price->setDbValue($row['price']);
        $this->price_cs->setDbValue($row['price_cs']);
        $this->currency->setDbValue($row['currency']);
        $this->hsn->setDbValue($row['hsn']);
        $this->composition->setDbValue($row['composition']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->gcode->setDbValue($row['gcode']);
        $this->d_01->setDbValue($row['d_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->d_03->setDbValue($row['d_03']);
        $this->d_04->setDbValue($row['d_04']);
        $this->d_05->setDbValue($row['d_05']);
        $this->d_06->setDbValue($row['d_06']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['partner_type'] = $this->partner_type->DefaultValue;
        $row['partner'] = $this->partner->DefaultValue;
        $row['partner_ref'] = $this->partner_ref->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['partner_code'] = $this->partner_code->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['spl_ins'] = $this->spl_ins->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['w'] = $this->w->DefaultValue;
        $row['w_cm'] = $this->w_cm->DefaultValue;
        $row['l'] = $this->l->DefaultValue;
        $row['l_cm'] = $this->l_cm->DefaultValue;
        $row['h'] = $this->h->DefaultValue;
        $row['h_cm'] = $this->h_cm->DefaultValue;
        $row['partner_size'] = $this->partner_size->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['weight_sqm'] = $this->weight_sqm->DefaultValue;
        $row['sqm_a'] = $this->sqm_a->DefaultValue;
        $row['2srm_a'] = $this->_2srm_a->DefaultValue;
        $row['4srm_a'] = $this->_4srm_a->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['price_cs'] = $this->price_cs->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['hsn'] = $this->hsn->DefaultValue;
        $row['composition'] = $this->composition->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['gcode'] = $this->gcode->DefaultValue;
        $row['d_01'] = $this->d_01->DefaultValue;
        $row['d_02'] = $this->d_02->DefaultValue;
        $row['d_03'] = $this->d_03->DefaultValue;
        $row['d_04'] = $this->d_04->DefaultValue;
        $row['d_05'] = $this->d_05->DefaultValue;
        $row['d_06'] = $this->d_06->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // partner_type
        $this->partner_type->RowCssClass = "row";

        // partner
        $this->partner->RowCssClass = "row";

        // partner_ref
        $this->partner_ref->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // partner_code
        $this->partner_code->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // spl_ins
        $this->spl_ins->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // w
        $this->w->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l
        $this->l->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // h
        $this->h->RowCssClass = "row";

        // h_cm
        $this->h_cm->RowCssClass = "row";

        // partner_size
        $this->partner_size->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // weight_sqm
        $this->weight_sqm->RowCssClass = "row";

        // sqm_a
        $this->sqm_a->RowCssClass = "row";

        // 2srm_a
        $this->_2srm_a->RowCssClass = "row";

        // 4srm_a
        $this->_4srm_a->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // price_cs
        $this->price_cs->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // hsn
        $this->hsn->RowCssClass = "row";

        // composition
        $this->composition->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // gcode
        $this->gcode->RowCssClass = "row";

        // d_01
        $this->d_01->RowCssClass = "row";

        // d_02
        $this->d_02->RowCssClass = "row";

        // d_03
        $this->d_03->RowCssClass = "row";

        // d_04
        $this->d_04->RowCssClass = "row";

        // d_05
        $this->d_05->RowCssClass = "row";

        // d_06
        $this->d_06->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // partner_type
            $curVal = strval($this->partner_type->CurrentValue);
            if ($curVal != "") {
                $this->partner_type->ViewValue = $this->partner_type->lookupCacheOption($curVal);
                if ($this->partner_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_type->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_type->ViewValue = $this->partner_type->displayValue($arwrk);
                    } else {
                        $this->partner_type->ViewValue = FormatNumber($this->partner_type->CurrentValue, $this->partner_type->formatPattern());
                    }
                }
            } else {
                $this->partner_type->ViewValue = null;
            }

            // partner
            $curVal = strval($this->partner->CurrentValue);
            if ($curVal != "") {
                $this->partner->ViewValue = $this->partner->lookupCacheOption($curVal);
                if ($this->partner->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner->Lookup->renderViewRow($rswrk[0]);
                        $this->partner->ViewValue = $this->partner->displayValue($arwrk);
                    } else {
                        $this->partner->ViewValue = FormatNumber($this->partner->CurrentValue, $this->partner->formatPattern());
                    }
                }
            } else {
                $this->partner->ViewValue = null;
            }

            // partner_ref
            $this->partner_ref->ViewValue = $this->partner_ref->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // partner_code
            $this->partner_code->ViewValue = $this->partner_code->CurrentValue;

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = FormatNumber($this->product_type->CurrentValue, $this->product_type->formatPattern());
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = $this->grp->CurrentValue;
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // rid
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // spl_ins
            $this->spl_ins->ViewValue = $this->spl_ins->CurrentValue;

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // batch_no
            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                        $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // unit
            if (strval($this->unit->CurrentValue) != "") {
                $this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
            } else {
                $this->unit->ViewValue = null;
            }

            // w
            $this->w->ViewValue = $this->w->CurrentValue;

            // w_cm
            $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
            $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

            // l
            $this->l->ViewValue = $this->l->CurrentValue;

            // l_cm
            $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
            $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

            // h
            $this->h->ViewValue = $this->h->CurrentValue;

            // h_cm
            $this->h_cm->ViewValue = $this->h_cm->CurrentValue;
            $this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, $this->h_cm->formatPattern());

            // partner_size
            $this->partner_size->ViewValue = $this->partner_size->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // weight_sqm
            $this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
            $this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, $this->weight_sqm->formatPattern());

            // sqm_a
            $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

            // 2srm_a
            $this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
            $this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, $this->_2srm_a->formatPattern());

            // 4srm_a
            $this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
            $this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, $this->_4srm_a->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // price_cs
            $this->price_cs->ViewValue = $this->price_cs->CurrentValue;
            $this->price_cs->ViewValue = FormatNumber($this->price_cs->ViewValue, $this->price_cs->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // hsn
            $curVal = strval($this->hsn->CurrentValue);
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
                if ($this->hsn->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                    $sqlWrk = $this->hsn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->hsn->Lookup->renderViewRow($rswrk[0]);
                        $this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
                    } else {
                        $this->hsn->ViewValue = FormatNumber($this->hsn->CurrentValue, $this->hsn->formatPattern());
                    }
                }
            } else {
                $this->hsn->ViewValue = null;
            }

            // composition
            $curVal = strval($this->composition->CurrentValue);
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
                if ($this->composition->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                    $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                        $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                    } else {
                        $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                    }
                }
            } else {
                $this->composition->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;

            // d_03
            $this->d_03->ViewValue = $this->d_03->CurrentValue;

            // d_04
            $this->d_04->ViewValue = $this->d_04->CurrentValue;

            // d_05
            $this->d_05->ViewValue = $this->d_05->CurrentValue;

            // d_06
            $this->d_06->ViewValue = $this->d_06->CurrentValue;

            // partner_type
            $this->partner_type->HrefValue = "";

            // partner
            $this->partner->HrefValue = "";

            // partner_ref
            $this->partner_ref->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // partner_code
            $this->partner_code->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // spl_ins
            $this->spl_ins->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // unit
            if (!EmptyValue($this->unit->CurrentValue)) {
                $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
                $this->unit->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
                }
            } else {
                $this->unit->HrefValue = "";
            }

            // w
            $this->w->HrefValue = "";

            // w_cm
            $this->w_cm->HrefValue = "";

            // l
            $this->l->HrefValue = "";

            // l_cm
            $this->l_cm->HrefValue = "";

            // h
            $this->h->HrefValue = "";

            // h_cm
            $this->h_cm->HrefValue = "";

            // partner_size
            $this->partner_size->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // weight_sqm
            $this->weight_sqm->HrefValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";

            // 2srm_a
            $this->_2srm_a->HrefValue = "";

            // 4srm_a
            $this->_4srm_a->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // price_cs
            $this->price_cs->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // hsn
            $this->hsn->HrefValue = "";

            // composition
            $this->composition->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // d_01
            $this->d_01->HrefValue = "";

            // d_02
            $this->d_02->HrefValue = "";

            // d_03
            $this->d_03->HrefValue = "";

            // d_04
            $this->d_04->HrefValue = "";

            // d_05
            $this->d_05->HrefValue = "";

            // d_06
            $this->d_06->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // partner_type
            $this->partner_type->setupEditAttributes();
            $curVal = trim(strval($this->partner_type->CurrentValue));
            if ($curVal != "") {
                $this->partner_type->ViewValue = $this->partner_type->lookupCacheOption($curVal);
            } else {
                $this->partner_type->ViewValue = $this->partner_type->Lookup !== null && is_array($this->partner_type->lookupOptions()) && count($this->partner_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->partner_type->ViewValue !== null) { // Load from cache
                $this->partner_type->EditValue = array_values($this->partner_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->partner_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->partner_type->CurrentValue, $this->partner_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->partner_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->partner_type->EditValue = $arwrk;
            }
            $this->partner_type->PlaceHolder = RemoveHtml($this->partner_type->caption());

            // partner
            $curVal = trim(strval($this->partner->CurrentValue));
            if ($curVal != "") {
                $this->partner->ViewValue = $this->partner->lookupCacheOption($curVal);
            } else {
                $this->partner->ViewValue = $this->partner->Lookup !== null && is_array($this->partner->lookupOptions()) && count($this->partner->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->partner->ViewValue !== null) { // Load from cache
                $this->partner->EditValue = array_values($this->partner->lookupOptions());
                if ($this->partner->ViewValue == "") {
                    $this->partner->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->partner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->partner->CurrentValue, $this->partner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->partner->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->partner->Lookup->renderViewRow($rswrk[0]);
                    $this->partner->ViewValue = $this->partner->displayValue($arwrk);
                } else {
                    $this->partner->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->partner->EditValue = $arwrk;
            }
            $this->partner->PlaceHolder = RemoveHtml($this->partner->caption());

            // partner_ref
            $this->partner_ref->setupEditAttributes();
            if (!$this->partner_ref->Raw) {
                $this->partner_ref->CurrentValue = HtmlDecode($this->partner_ref->CurrentValue);
            }
            $this->partner_ref->EditValue = HtmlEncode($this->partner_ref->CurrentValue);
            $this->partner_ref->PlaceHolder = RemoveHtml($this->partner_ref->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            if (!$this->_barcode->Raw) {
                $this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
            }
            $this->_barcode->EditValue = HtmlEncode($this->_barcode->CurrentValue);
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // partner_code
            $this->partner_code->setupEditAttributes();
            if (!$this->partner_code->Raw) {
                $this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
            }
            $this->partner_code->EditValue = HtmlEncode($this->partner_code->CurrentValue);
            $this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $curVal = trim(strval($this->product_type->CurrentValue));
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_type->CurrentValue, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // rid
            $this->rid->setupEditAttributes();
            if ($this->rid->getSessionValue() != "") {
                $this->rid->CurrentValue = GetForeignKeyValue($this->rid->getSessionValue());
                $curVal = strval($this->rid->CurrentValue);
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                    if ($this->rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                        $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                            $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                        } else {
                            $this->rid->ViewValue = $this->rid->CurrentValue;
                        }
                    }
                } else {
                    $this->rid->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->rid->CurrentValue));
                if ($curVal != "") {
                    $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                } else {
                    $this->rid->ViewValue = $this->rid->Lookup !== null && is_array($this->rid->lookupOptions()) && count($this->rid->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->rid->ViewValue !== null) { // Load from cache
                    $this->rid->EditValue = array_values($this->rid->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid->CurrentValue, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->rid->EditValue = $arwrk;
                }
                $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
            }

            // spl_ins
            $this->spl_ins->setupEditAttributes();
            if (!$this->spl_ins->Raw) {
                $this->spl_ins->CurrentValue = HtmlDecode($this->spl_ins->CurrentValue);
            }
            $this->spl_ins->EditValue = HtmlEncode($this->spl_ins->CurrentValue);
            $this->spl_ins->PlaceHolder = RemoveHtml($this->spl_ins->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue = $this->batch_no->CurrentValue;
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->EditValue = HtmlEncode(FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern()));
                    }
                }
            } else {
                $this->batch_no->EditValue = null;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // shape
            $this->shape->setupEditAttributes();
            $curVal = trim(strval($this->shape->CurrentValue));
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->shape->CurrentValue, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // unit
            $this->unit->setupEditAttributes();
            $this->unit->EditValue = $this->unit->options(true);
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // w
            $this->w->setupEditAttributes();
            if (!$this->w->Raw) {
                $this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
            }
            $this->w->EditValue = HtmlEncode($this->w->CurrentValue);
            $this->w->PlaceHolder = RemoveHtml($this->w->caption());

            // w_cm
            $this->w_cm->setupEditAttributes();
            $this->w_cm->EditCustomAttributes = $this->w_cm->getEditCustomAttributes(); // PHP
            $this->w_cm->EditValue = $this->w_cm->CurrentValue;
            $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
            if (strval($this->w_cm->EditValue) != "" && is_numeric($this->w_cm->EditValue)) {
                $this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, null);
            }

            // l
            $this->l->setupEditAttributes();
            if (!$this->l->Raw) {
                $this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
            }
            $this->l->EditValue = HtmlEncode($this->l->CurrentValue);
            $this->l->PlaceHolder = RemoveHtml($this->l->caption());

            // l_cm
            $this->l_cm->setupEditAttributes();
            $this->l_cm->EditCustomAttributes = $this->l_cm->getEditCustomAttributes(); // PHP
            $this->l_cm->EditValue = $this->l_cm->CurrentValue;
            $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
            if (strval($this->l_cm->EditValue) != "" && is_numeric($this->l_cm->EditValue)) {
                $this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, null);
            }

            // h
            $this->h->setupEditAttributes();
            if (!$this->h->Raw) {
                $this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
            }
            $this->h->EditValue = HtmlEncode($this->h->CurrentValue);
            $this->h->PlaceHolder = RemoveHtml($this->h->caption());

            // h_cm
            $this->h_cm->setupEditAttributes();
            $this->h_cm->EditCustomAttributes = $this->h_cm->getEditCustomAttributes(); // PHP
            $this->h_cm->EditValue = $this->h_cm->CurrentValue;
            $this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());
            if (strval($this->h_cm->EditValue) != "" && is_numeric($this->h_cm->EditValue)) {
                $this->h_cm->EditValue = FormatNumber($this->h_cm->EditValue, null);
            }

            // partner_size
            $this->partner_size->setupEditAttributes();
            if (!$this->partner_size->Raw) {
                $this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
            }
            $this->partner_size->EditValue = HtmlEncode($this->partner_size->CurrentValue);
            $this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditCustomAttributes = $this->sqm->getEditCustomAttributes(); // PHP
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
            if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
                $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
            }

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditValue = $this->cbm->CurrentValue;
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
            if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
                $this->cbm->EditValue = FormatNumber($this->cbm->EditValue, null);
            }

            // weight_sqm
            $this->weight_sqm->setupEditAttributes();
            $this->weight_sqm->EditValue = $this->weight_sqm->CurrentValue;
            $this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
            if (strval($this->weight_sqm->EditValue) != "" && is_numeric($this->weight_sqm->EditValue)) {
                $this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, null);
            }

            // sqm_a
            $this->sqm_a->setupEditAttributes();
            $this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
            if (strval($this->sqm_a->EditValue) != "" && is_numeric($this->sqm_a->EditValue)) {
                $this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, null);
            }

            // 2srm_a
            $this->_2srm_a->setupEditAttributes();
            $this->_2srm_a->EditValue = $this->_2srm_a->CurrentValue;
            $this->_2srm_a->PlaceHolder = RemoveHtml($this->_2srm_a->caption());
            if (strval($this->_2srm_a->EditValue) != "" && is_numeric($this->_2srm_a->EditValue)) {
                $this->_2srm_a->EditValue = FormatNumber($this->_2srm_a->EditValue, null);
            }

            // 4srm_a
            $this->_4srm_a->setupEditAttributes();
            $this->_4srm_a->EditValue = $this->_4srm_a->CurrentValue;
            $this->_4srm_a->PlaceHolder = RemoveHtml($this->_4srm_a->caption());
            if (strval($this->_4srm_a->EditValue) != "" && is_numeric($this->_4srm_a->EditValue)) {
                $this->_4srm_a->EditValue = FormatNumber($this->_4srm_a->EditValue, null);
            }

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());
            if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
                $this->price->EditValue = FormatNumber($this->price->EditValue, null);
            }

            // price_cs
            $this->price_cs->setupEditAttributes();
            $this->price_cs->EditValue = $this->price_cs->CurrentValue;
            $this->price_cs->PlaceHolder = RemoveHtml($this->price_cs->caption());
            if (strval($this->price_cs->EditValue) != "" && is_numeric($this->price_cs->EditValue)) {
                $this->price_cs->EditValue = FormatNumber($this->price_cs->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // hsn
            $this->hsn->setupEditAttributes();
            $curVal = trim(strval($this->hsn->CurrentValue));
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
            } else {
                $this->hsn->ViewValue = $this->hsn->Lookup !== null && is_array($this->hsn->lookupOptions()) && count($this->hsn->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->hsn->ViewValue !== null) { // Load from cache
                $this->hsn->EditValue = array_values($this->hsn->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->hsn->CurrentValue, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                $sqlWrk = $this->hsn->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->hsn->Lookup->renderViewRow($row);
                }
                $this->hsn->EditValue = $arwrk;
            }
            $this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

            // composition
            $this->composition->setupEditAttributes();
            $curVal = trim(strval($this->composition->CurrentValue));
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
            } else {
                $this->composition->ViewValue = $this->composition->Lookup !== null && is_array($this->composition->lookupOptions()) && count($this->composition->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->composition->ViewValue !== null) { // Load from cache
                $this->composition->EditValue = array_values($this->composition->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->composition->CurrentValue, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                $sqlWrk = $this->composition->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->composition->EditValue = $arwrk;
            }
            $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // d_01
            $this->d_01->setupEditAttributes();
            if (!$this->d_01->Raw) {
                $this->d_01->CurrentValue = HtmlDecode($this->d_01->CurrentValue);
            }
            $this->d_01->EditValue = HtmlEncode($this->d_01->CurrentValue);
            $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

            // d_02
            $this->d_02->setupEditAttributes();
            if (!$this->d_02->Raw) {
                $this->d_02->CurrentValue = HtmlDecode($this->d_02->CurrentValue);
            }
            $this->d_02->EditValue = HtmlEncode($this->d_02->CurrentValue);
            $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

            // d_03
            $this->d_03->setupEditAttributes();
            if (!$this->d_03->Raw) {
                $this->d_03->CurrentValue = HtmlDecode($this->d_03->CurrentValue);
            }
            $this->d_03->EditValue = HtmlEncode($this->d_03->CurrentValue);
            $this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());

            // d_04
            $this->d_04->setupEditAttributes();
            if (!$this->d_04->Raw) {
                $this->d_04->CurrentValue = HtmlDecode($this->d_04->CurrentValue);
            }
            $this->d_04->EditValue = HtmlEncode($this->d_04->CurrentValue);
            $this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());

            // d_05
            $this->d_05->setupEditAttributes();
            if (!$this->d_05->Raw) {
                $this->d_05->CurrentValue = HtmlDecode($this->d_05->CurrentValue);
            }
            $this->d_05->EditValue = HtmlEncode($this->d_05->CurrentValue);
            $this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());

            // d_06
            $this->d_06->setupEditAttributes();
            if (!$this->d_06->Raw) {
                $this->d_06->CurrentValue = HtmlDecode($this->d_06->CurrentValue);
            }
            $this->d_06->EditValue = HtmlEncode($this->d_06->CurrentValue);
            $this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());

            // Add refer script

            // partner_type
            $this->partner_type->HrefValue = "";

            // partner
            $this->partner->HrefValue = "";

            // partner_ref
            $this->partner_ref->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // partner_code
            $this->partner_code->HrefValue = "";

            // product_type
            $this->product_type->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // rid
            $this->rid->HrefValue = "";

            // spl_ins
            $this->spl_ins->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // unit
            if (!EmptyValue($this->unit->CurrentValue)) {
                $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
                $this->unit->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
                }
            } else {
                $this->unit->HrefValue = "";
            }

            // w
            $this->w->HrefValue = "";

            // w_cm
            $this->w_cm->HrefValue = "";

            // l
            $this->l->HrefValue = "";

            // l_cm
            $this->l_cm->HrefValue = "";

            // h
            $this->h->HrefValue = "";

            // h_cm
            $this->h_cm->HrefValue = "";

            // partner_size
            $this->partner_size->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // weight_sqm
            $this->weight_sqm->HrefValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";

            // 2srm_a
            $this->_2srm_a->HrefValue = "";

            // 4srm_a
            $this->_4srm_a->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // price_cs
            $this->price_cs->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // hsn
            $this->hsn->HrefValue = "";

            // composition
            $this->composition->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // d_01
            $this->d_01->HrefValue = "";

            // d_02
            $this->d_02->HrefValue = "";

            // d_03
            $this->d_03->HrefValue = "";

            // d_04
            $this->d_04->HrefValue = "";

            // d_05
            $this->d_05->HrefValue = "";

            // d_06
            $this->d_06->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->partner_type->Visible && $this->partner_type->Required) {
                if (!$this->partner_type->IsDetailKey && EmptyValue($this->partner_type->FormValue)) {
                    $this->partner_type->addErrorMessage(str_replace("%s", $this->partner_type->caption(), $this->partner_type->RequiredErrorMessage));
                }
            }
            if ($this->partner->Visible && $this->partner->Required) {
                if (!$this->partner->IsDetailKey && EmptyValue($this->partner->FormValue)) {
                    $this->partner->addErrorMessage(str_replace("%s", $this->partner->caption(), $this->partner->RequiredErrorMessage));
                }
            }
            if ($this->partner_ref->Visible && $this->partner_ref->Required) {
                if (!$this->partner_ref->IsDetailKey && EmptyValue($this->partner_ref->FormValue)) {
                    $this->partner_ref->addErrorMessage(str_replace("%s", $this->partner_ref->caption(), $this->partner_ref->RequiredErrorMessage));
                }
            }
            if ($this->_barcode->Visible && $this->_barcode->Required) {
                if (!$this->_barcode->IsDetailKey && EmptyValue($this->_barcode->FormValue)) {
                    $this->_barcode->addErrorMessage(str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
                }
            }
            if ($this->partner_code->Visible && $this->partner_code->Required) {
                if (!$this->partner_code->IsDetailKey && EmptyValue($this->partner_code->FormValue)) {
                    $this->partner_code->addErrorMessage(str_replace("%s", $this->partner_code->caption(), $this->partner_code->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->spl_ins->Visible && $this->spl_ins->Required) {
                if (!$this->spl_ins->IsDetailKey && EmptyValue($this->spl_ins->FormValue)) {
                    $this->spl_ins->addErrorMessage(str_replace("%s", $this->spl_ins->caption(), $this->spl_ins->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->batch_no->FormValue)) {
                $this->batch_no->addErrorMessage($this->batch_no->getErrorMessage(false));
            }
            if ($this->shape->Visible && $this->shape->Required) {
                if (!$this->shape->IsDetailKey && EmptyValue($this->shape->FormValue)) {
                    $this->shape->addErrorMessage(str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
                }
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->w->Visible && $this->w->Required) {
                if (!$this->w->IsDetailKey && EmptyValue($this->w->FormValue)) {
                    $this->w->addErrorMessage(str_replace("%s", $this->w->caption(), $this->w->RequiredErrorMessage));
                }
            }
            if ($this->w_cm->Visible && $this->w_cm->Required) {
                if (!$this->w_cm->IsDetailKey && EmptyValue($this->w_cm->FormValue)) {
                    $this->w_cm->addErrorMessage(str_replace("%s", $this->w_cm->caption(), $this->w_cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->w_cm->FormValue)) {
                $this->w_cm->addErrorMessage($this->w_cm->getErrorMessage(false));
            }
            if ($this->l->Visible && $this->l->Required) {
                if (!$this->l->IsDetailKey && EmptyValue($this->l->FormValue)) {
                    $this->l->addErrorMessage(str_replace("%s", $this->l->caption(), $this->l->RequiredErrorMessage));
                }
            }
            if ($this->l_cm->Visible && $this->l_cm->Required) {
                if (!$this->l_cm->IsDetailKey && EmptyValue($this->l_cm->FormValue)) {
                    $this->l_cm->addErrorMessage(str_replace("%s", $this->l_cm->caption(), $this->l_cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->l_cm->FormValue)) {
                $this->l_cm->addErrorMessage($this->l_cm->getErrorMessage(false));
            }
            if ($this->h->Visible && $this->h->Required) {
                if (!$this->h->IsDetailKey && EmptyValue($this->h->FormValue)) {
                    $this->h->addErrorMessage(str_replace("%s", $this->h->caption(), $this->h->RequiredErrorMessage));
                }
            }
            if ($this->h_cm->Visible && $this->h_cm->Required) {
                if (!$this->h_cm->IsDetailKey && EmptyValue($this->h_cm->FormValue)) {
                    $this->h_cm->addErrorMessage(str_replace("%s", $this->h_cm->caption(), $this->h_cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->h_cm->FormValue)) {
                $this->h_cm->addErrorMessage($this->h_cm->getErrorMessage(false));
            }
            if ($this->partner_size->Visible && $this->partner_size->Required) {
                if (!$this->partner_size->IsDetailKey && EmptyValue($this->partner_size->FormValue)) {
                    $this->partner_size->addErrorMessage(str_replace("%s", $this->partner_size->caption(), $this->partner_size->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if ($this->cbm->Visible && $this->cbm->Required) {
                if (!$this->cbm->IsDetailKey && EmptyValue($this->cbm->FormValue)) {
                    $this->cbm->addErrorMessage(str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->cbm->FormValue)) {
                $this->cbm->addErrorMessage($this->cbm->getErrorMessage(false));
            }
            if ($this->weight_sqm->Visible && $this->weight_sqm->Required) {
                if (!$this->weight_sqm->IsDetailKey && EmptyValue($this->weight_sqm->FormValue)) {
                    $this->weight_sqm->addErrorMessage(str_replace("%s", $this->weight_sqm->caption(), $this->weight_sqm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->weight_sqm->FormValue)) {
                $this->weight_sqm->addErrorMessage($this->weight_sqm->getErrorMessage(false));
            }
            if ($this->sqm_a->Visible && $this->sqm_a->Required) {
                if (!$this->sqm_a->IsDetailKey && EmptyValue($this->sqm_a->FormValue)) {
                    $this->sqm_a->addErrorMessage(str_replace("%s", $this->sqm_a->caption(), $this->sqm_a->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->sqm_a->FormValue)) {
                $this->sqm_a->addErrorMessage($this->sqm_a->getErrorMessage(false));
            }
            if ($this->_2srm_a->Visible && $this->_2srm_a->Required) {
                if (!$this->_2srm_a->IsDetailKey && EmptyValue($this->_2srm_a->FormValue)) {
                    $this->_2srm_a->addErrorMessage(str_replace("%s", $this->_2srm_a->caption(), $this->_2srm_a->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_2srm_a->FormValue)) {
                $this->_2srm_a->addErrorMessage($this->_2srm_a->getErrorMessage(false));
            }
            if ($this->_4srm_a->Visible && $this->_4srm_a->Required) {
                if (!$this->_4srm_a->IsDetailKey && EmptyValue($this->_4srm_a->FormValue)) {
                    $this->_4srm_a->addErrorMessage(str_replace("%s", $this->_4srm_a->caption(), $this->_4srm_a->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_4srm_a->FormValue)) {
                $this->_4srm_a->addErrorMessage($this->_4srm_a->getErrorMessage(false));
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price->FormValue)) {
                $this->price->addErrorMessage($this->price->getErrorMessage(false));
            }
            if ($this->price_cs->Visible && $this->price_cs->Required) {
                if (!$this->price_cs->IsDetailKey && EmptyValue($this->price_cs->FormValue)) {
                    $this->price_cs->addErrorMessage(str_replace("%s", $this->price_cs->caption(), $this->price_cs->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price_cs->FormValue)) {
                $this->price_cs->addErrorMessage($this->price_cs->getErrorMessage(false));
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->hsn->Visible && $this->hsn->Required) {
                if (!$this->hsn->IsDetailKey && EmptyValue($this->hsn->FormValue)) {
                    $this->hsn->addErrorMessage(str_replace("%s", $this->hsn->caption(), $this->hsn->RequiredErrorMessage));
                }
            }
            if ($this->composition->Visible && $this->composition->Required) {
                if (!$this->composition->IsDetailKey && EmptyValue($this->composition->FormValue)) {
                    $this->composition->addErrorMessage(str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->d_01->Visible && $this->d_01->Required) {
                if (!$this->d_01->IsDetailKey && EmptyValue($this->d_01->FormValue)) {
                    $this->d_01->addErrorMessage(str_replace("%s", $this->d_01->caption(), $this->d_01->RequiredErrorMessage));
                }
            }
            if ($this->d_02->Visible && $this->d_02->Required) {
                if (!$this->d_02->IsDetailKey && EmptyValue($this->d_02->FormValue)) {
                    $this->d_02->addErrorMessage(str_replace("%s", $this->d_02->caption(), $this->d_02->RequiredErrorMessage));
                }
            }
            if ($this->d_03->Visible && $this->d_03->Required) {
                if (!$this->d_03->IsDetailKey && EmptyValue($this->d_03->FormValue)) {
                    $this->d_03->addErrorMessage(str_replace("%s", $this->d_03->caption(), $this->d_03->RequiredErrorMessage));
                }
            }
            if ($this->d_04->Visible && $this->d_04->Required) {
                if (!$this->d_04->IsDetailKey && EmptyValue($this->d_04->FormValue)) {
                    $this->d_04->addErrorMessage(str_replace("%s", $this->d_04->caption(), $this->d_04->RequiredErrorMessage));
                }
            }
            if ($this->d_05->Visible && $this->d_05->Required) {
                if (!$this->d_05->IsDetailKey && EmptyValue($this->d_05->FormValue)) {
                    $this->d_05->addErrorMessage(str_replace("%s", $this->d_05->caption(), $this->d_05->RequiredErrorMessage));
                }
            }
            if ($this->d_06->Visible && $this->d_06->Required) {
                if (!$this->d_06->IsDetailKey && EmptyValue($this->d_06->FormValue)) {
                    $this->d_06->addErrorMessage(str_replace("%s", $this->d_06->caption(), $this->d_06->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // partner_type
        $this->partner_type->setDbValueDef($rsnew, $this->partner_type->CurrentValue, false);

        // partner
        $this->partner->setDbValueDef($rsnew, $this->partner->CurrentValue, false);

        // partner_ref
        $this->partner_ref->setDbValueDef($rsnew, $this->partner_ref->CurrentValue, false);

        // barcode
        $this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, false);

        // partner_code
        $this->partner_code->setDbValueDef($rsnew, $this->partner_code->CurrentValue, false);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // spl_ins
        $this->spl_ins->setDbValueDef($rsnew, $this->spl_ins->CurrentValue, false);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, false);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, false);

        // shape
        $this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, false);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, false);

        // w
        $this->w->setDbValueDef($rsnew, $this->w->CurrentValue, false);

        // w_cm
        $this->w_cm->setDbValueDef($rsnew, $this->w_cm->CurrentValue, false);

        // l
        $this->l->setDbValueDef($rsnew, $this->l->CurrentValue, false);

        // l_cm
        $this->l_cm->setDbValueDef($rsnew, $this->l_cm->CurrentValue, false);

        // h
        $this->h->setDbValueDef($rsnew, $this->h->CurrentValue, false);

        // h_cm
        $this->h_cm->setDbValueDef($rsnew, $this->h_cm->CurrentValue, false);

        // partner_size
        $this->partner_size->setDbValueDef($rsnew, $this->partner_size->CurrentValue, false);

        // sqm
        $this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, false);

        // cbm
        $this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, strval($this->cbm->CurrentValue) == "");

        // weight_sqm
        $this->weight_sqm->setDbValueDef($rsnew, $this->weight_sqm->CurrentValue, false);

        // sqm_a
        $this->sqm_a->setDbValueDef($rsnew, $this->sqm_a->CurrentValue, false);

        // 2srm_a
        $this->_2srm_a->setDbValueDef($rsnew, $this->_2srm_a->CurrentValue, false);

        // 4srm_a
        $this->_4srm_a->setDbValueDef($rsnew, $this->_4srm_a->CurrentValue, false);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, false);

        // price_cs
        $this->price_cs->setDbValueDef($rsnew, $this->price_cs->CurrentValue, false);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, false);

        // hsn
        $this->hsn->setDbValueDef($rsnew, $this->hsn->CurrentValue, false);

        // composition
        $this->composition->setDbValueDef($rsnew, $this->composition->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // d_01
        $this->d_01->setDbValueDef($rsnew, $this->d_01->CurrentValue, false);

        // d_02
        $this->d_02->setDbValueDef($rsnew, $this->d_02->CurrentValue, false);

        // d_03
        $this->d_03->setDbValueDef($rsnew, $this->d_03->CurrentValue, false);

        // d_04
        $this->d_04->setDbValueDef($rsnew, $this->d_04->CurrentValue, false);

        // d_05
        $this->d_05->setDbValueDef($rsnew, $this->d_05->CurrentValue, false);

        // d_06
        $this->d_06->setDbValueDef($rsnew, $this->d_06->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['partner_type'])) { // partner_type
            $this->partner_type->setFormValue($row['partner_type']);
        }
        if (isset($row['partner'])) { // partner
            $this->partner->setFormValue($row['partner']);
        }
        if (isset($row['partner_ref'])) { // partner_ref
            $this->partner_ref->setFormValue($row['partner_ref']);
        }
        if (isset($row['barcode'])) { // barcode
            $this->_barcode->setFormValue($row['barcode']);
        }
        if (isset($row['partner_code'])) { // partner_code
            $this->partner_code->setFormValue($row['partner_code']);
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->setFormValue($row['product_type']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['spl_ins'])) { // spl_ins
            $this->spl_ins->setFormValue($row['spl_ins']);
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->setFormValue($row['packing_type']);
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->setFormValue($row['batch_no']);
        }
        if (isset($row['shape'])) { // shape
            $this->shape->setFormValue($row['shape']);
        }
        if (isset($row['unit'])) { // unit
            $this->unit->setFormValue($row['unit']);
        }
        if (isset($row['w'])) { // w
            $this->w->setFormValue($row['w']);
        }
        if (isset($row['w_cm'])) { // w_cm
            $this->w_cm->setFormValue($row['w_cm']);
        }
        if (isset($row['l'])) { // l
            $this->l->setFormValue($row['l']);
        }
        if (isset($row['l_cm'])) { // l_cm
            $this->l_cm->setFormValue($row['l_cm']);
        }
        if (isset($row['h'])) { // h
            $this->h->setFormValue($row['h']);
        }
        if (isset($row['h_cm'])) { // h_cm
            $this->h_cm->setFormValue($row['h_cm']);
        }
        if (isset($row['partner_size'])) { // partner_size
            $this->partner_size->setFormValue($row['partner_size']);
        }
        if (isset($row['sqm'])) { // sqm
            $this->sqm->setFormValue($row['sqm']);
        }
        if (isset($row['cbm'])) { // cbm
            $this->cbm->setFormValue($row['cbm']);
        }
        if (isset($row['weight_sqm'])) { // weight_sqm
            $this->weight_sqm->setFormValue($row['weight_sqm']);
        }
        if (isset($row['sqm_a'])) { // sqm_a
            $this->sqm_a->setFormValue($row['sqm_a']);
        }
        if (isset($row['2srm_a'])) { // 2srm_a
            $this->_2srm_a->setFormValue($row['2srm_a']);
        }
        if (isset($row['4srm_a'])) { // 4srm_a
            $this->_4srm_a->setFormValue($row['4srm_a']);
        }
        if (isset($row['price'])) { // price
            $this->price->setFormValue($row['price']);
        }
        if (isset($row['price_cs'])) { // price_cs
            $this->price_cs->setFormValue($row['price_cs']);
        }
        if (isset($row['currency'])) { // currency
            $this->currency->setFormValue($row['currency']);
        }
        if (isset($row['hsn'])) { // hsn
            $this->hsn->setFormValue($row['hsn']);
        }
        if (isset($row['composition'])) { // composition
            $this->composition->setFormValue($row['composition']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['d_01'])) { // d_01
            $this->d_01->setFormValue($row['d_01']);
        }
        if (isset($row['d_02'])) { // d_02
            $this->d_02->setFormValue($row['d_02']);
        }
        if (isset($row['d_03'])) { // d_03
            $this->d_03->setFormValue($row['d_03']);
        }
        if (isset($row['d_04'])) { // d_04
            $this->d_04->setFormValue($row['d_04']);
        }
        if (isset($row['d_05'])) { // d_05
            $this->d_05->setFormValue($row['d_05']);
        }
        if (isset($row['d_06'])) { // d_06
            $this->d_06->setFormValue($row['d_06']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "ref") {
                $validMaster = true;
                $masterTbl = Container("ref");
                if (($parm = Get("fk_id", Get("rid"))) !== null) {
                    $masterTbl->id->setQueryStringValue($parm);
                    $this->rid->QueryStringValue = $masterTbl->id->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->rid->setSessionValue($this->rid->QueryStringValue);
                    $foreignKeys["rid"] = $this->rid->QueryStringValue;
                    if (!is_numeric($masterTbl->id->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
            if ($masterTblVar == "ref_code") {
                $validMaster = true;
                $masterTbl = Container("ref_code");
                if (($parm = Get("fk_id", Get("rid"))) !== null) {
                    $masterTbl->id->setQueryStringValue($parm);
                    $this->rid->QueryStringValue = $masterTbl->id->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->rid->setSessionValue($this->rid->QueryStringValue);
                    $foreignKeys["rid"] = $this->rid->QueryStringValue;
                    if (!is_numeric($masterTbl->id->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "ref") {
                $validMaster = true;
                $masterTbl = Container("ref");
                if (($parm = Post("fk_id", Post("rid"))) !== null) {
                    $masterTbl->id->setFormValue($parm);
                    $this->rid->FormValue = $masterTbl->id->FormValue;
                    $this->rid->setSessionValue($this->rid->FormValue);
                    $foreignKeys["rid"] = $this->rid->FormValue;
                    if (!is_numeric($masterTbl->id->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
            if ($masterTblVar == "ref_code") {
                $validMaster = true;
                $masterTbl = Container("ref_code");
                if (($parm = Post("fk_id", Post("rid"))) !== null) {
                    $masterTbl->id->setFormValue($parm);
                    $this->rid->FormValue = $masterTbl->id->FormValue;
                    $this->rid->setSessionValue($this->rid->FormValue);
                    $foreignKeys["rid"] = $this->rid->FormValue;
                    if (!is_numeric($masterTbl->id->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "ref") {
                if (!array_key_exists("rid", $foreignKeys)) { // Not current foreign key
                    $this->rid->setSessionValue("");
                }
            }
            if ($masterTblVar != "ref_code") {
                if (!array_key_exists("rid", $foreignKeys)) { // Not current foreign key
                    $this->rid->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("partnerproductreflist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_partner_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_hsn":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_composition":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                case "x_gcode":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'partner_product_ref');
    	$this->w_cm->ReadOnly = True;
    	$this->l_cm->ReadOnly = True;
    	$this->h_cm->ReadOnly = True;
    	$this->gcode->ReadOnly=TRUE;
    	IF (isset($_GET['showmaster']) && isset($_GET['fk_id']))
    	{
    	$this->grp->Visible = False;
    	$this->s_grp->Visible = False;
    	$this->product->Visible = False;
    	} else {
    	$this->grp->Visible = True;
    	$this->s_grp->Visible = True;
    	$this->product->Visible = True;
    	}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
