<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for partner_product_ref
 */
class PartnerProductRef extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $partner_type;
    public $partner;
    public $partner_ref;
    public $_barcode;
    public $partner_code;
    public $product_type;
    public $grp;
    public $s_grp;
    public $product;
    public $rid;
    public $spl_ins;
    public $packing_type;
    public $batch_no;
    public $shape;
    public $unit;
    public $w;
    public $w_cm;
    public $l;
    public $l_cm;
    public $h;
    public $h_cm;
    public $partner_size;
    public $sqm;
    public $cbm;
    public $weight_sqm;
    public $sqm_a;
    public $_2srm_a;
    public $_4srm_a;
    public $price;
    public $price_cs;
    public $currency;
    public $hsn;
    public $composition;
    public $status;
    public $operator;
    public $datetime;
    public $gcode;
    public $d_01;
    public $d_02;
    public $d_03;
    public $d_04;
    public $d_05;
    public $d_06;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "partner_product_ref";
        $this->TableName = 'partner_product_ref';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "partner_product_ref";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            3, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // partner_type
        $this->partner_type = new DbField(
            $this, // Table
            'x_partner_type', // Variable name
            'partner_type', // Name
            '`partner_type`', // Expression
            '`partner_type`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`partner_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->partner_type->addMethod("getSelectFilter", fn() => ((User_Category() == 0) ? "FIND_IN_SET(`id`, '1,2') and `status` = 1" : ((User_Category() == 1) ? "`id` = 1 and `status` = 1" : ((User_Category() == 2) ? "`id` = 2 and `status` = 1" : "FIND_IN_SET(`id`, '1,2') and `status` = 1"))));
        $this->partner_type->addMethod("getDefault", fn() => User_Category());
        $this->partner_type->InputTextType = "text";
        $this->partner_type->Raw = true;
        $this->partner_type->Nullable = false; // NOT NULL field
        $this->partner_type->Required = true; // Required field
        $this->partner_type->setSelectMultiple(false); // Select one
        $this->partner_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->partner_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->partner_type->Lookup = new Lookup($this->partner_type, 'admin_category', false, 'id', ["item","","",""], '', '', [], ["x_partner"], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->partner_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->partner_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['partner_type'] = &$this->partner_type;

        // partner
        $this->partner = new DbField(
            $this, // Table
            'x_partner', // Variable name
            'partner', // Name
            '`partner`', // Expression
            '`partner`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`partner`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->partner->addMethod("getSelectFilter", fn() => (User_Category() == 0) ?  "(`status` = 1 || `category` = 1)" : "((`id` = " .  User_Company_ID()  . " and `status` = 1)  || (`status` = 1 && `category` = 1))");
        $this->partner->addMethod("getDefault", fn() => User_Company_ID());
        $this->partner->InputTextType = "text";
        $this->partner->Raw = true;
        $this->partner->Nullable = false; // NOT NULL field
        $this->partner->Required = true; // Required field
        $this->partner->setSelectMultiple(false); // Select one
        $this->partner->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->partner->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->partner->Lookup = new Lookup($this->partner, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', ["x_partner_type"], [], ["partner_type"], ["x_partner_type"], ["currency"], ["x_currency"], false, '`name` ASC', '', "`name`");
        $this->partner->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->partner->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['partner'] = &$this->partner;

        // partner_ref
        $this->partner_ref = new DbField(
            $this, // Table
            'x_partner_ref', // Variable name
            'partner_ref', // Name
            '`partner_ref`', // Expression
            '`partner_ref`', // Basic search expression
            200, // Type
            144, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`partner_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->partner_ref->InputTextType = "text";
        $this->partner_ref->Nullable = false; // NOT NULL field
        $this->partner_ref->Required = true; // Required field
        $this->partner_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['partner_ref'] = &$this->partner_ref;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_barcode->InputTextType = "text";
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['barcode'] = &$this->_barcode;

        // partner_code
        $this->partner_code = new DbField(
            $this, // Table
            'x_partner_code', // Variable name
            'partner_code', // Name
            '`partner_code`', // Expression
            '`partner_code`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`partner_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->partner_code->InputTextType = "text";
        $this->partner_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['partner_code'] = &$this->partner_code;

        // product_type
        $this->product_type = new DbField(
            $this, // Table
            'x_product_type', // Variable name
            'product_type', // Name
            '`product_type`', // Expression
            '`product_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product_type->addMethod("getSelectFilter", fn() => "`status`=1 and `id` != 9");
        $this->product_type->addMethod("getDefault", fn() => 0);
        $this->product_type->InputTextType = "text";
        $this->product_type->Raw = true;
        $this->product_type->Required = true; // Required field
        $this->product_type->setSelectMultiple(false); // Select one
        $this->product_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product_type->Lookup = new Lookup($this->product_type, 'product_type', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_type'] = &$this->product_type;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->grp->addMethod("getLinkPrefix", fn() => "productcartblist?x_grp=");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp","x_packing_type","x_hsn","x_composition"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->s_grp->addMethod("getLinkPrefix", fn() => "productcartblist?x_s_grp=");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Required = true; // Required field
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->product->addMethod("getLinkPrefix", fn() => "productcartblist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Required = true; // Required field
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product_view2', false, 'id', ["product","","",""], '', '', ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], false, '`product` ASC', '', "`product`");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->rid->addMethod("getSelectFilter", fn() => "`status` =1");
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->IsForeignKey = true; // Foreign key field
        $this->rid->Required = true; // Required field
        $this->rid->setSelectMultiple(false); // Select one
        $this->rid->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->rid->Lookup = new Lookup($this->rid, 'ref', true, 'id', ["product_code","","",""], '', '', ["x_product"], ["x_batch_no","x_gcode"], ["product"], ["x_product"], ["cbm"], ["x_cbm"], false, '`product_code` ASC', '', "`product_code`");
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid'] = &$this->rid;

        // spl_ins
        $this->spl_ins = new DbField(
            $this, // Table
            'x_spl_ins', // Variable name
            'spl_ins', // Name
            '`spl_ins`', // Expression
            '`spl_ins`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`spl_ins`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->spl_ins->InputTextType = "text";
        $this->spl_ins->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['spl_ins'] = &$this->spl_ins;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->setSelectMultiple(false); // Select one
        $this->packing_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_type->Lookup = new Lookup($this->packing_type, 'packing_type', false, 'id', ["code","packing","",""], '', '', ["x_grp"], [], ["grp"], ["x_grp"], [], [], false, '`code` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`packing`,''))");
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->batch_no->addMethod("getSelectFilter", fn() => ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "((`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1))" : "(`a_operator` > 0 and `status` = 1)")));
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', false, 'id', ["batch_no","description","",""], '', '', ["x_rid"], [], ["rid"], ["x_rid"], [], [], false, '`batch_no` ASC', '', "CONCAT(COALESCE(`batch_no`, ''),'" . ValueSeparator(1, $this->batch_no) . "',COALESCE(`description`,''))");
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // shape
        $this->shape = new DbField(
            $this, // Table
            'x_shape', // Variable name
            'shape', // Name
            '`shape`', // Expression
            '`shape`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shape`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->shape->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->shape->addMethod("getDefault", fn() => 1);
        $this->shape->InputTextType = "text";
        $this->shape->setSelectMultiple(false); // Select one
        $this->shape->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->shape->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->shape->Lookup = new Lookup($this->shape, 'shape', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->shape->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['shape'] = &$this->shape;

        // unit
        $this->unit = new DbField(
            $this, // Table
            'x_unit', // Variable name
            'unit', // Name
            '`unit`', // Expression
            '`unit`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->unit->addMethod("getDefault", fn() => 1);
        $this->unit->addMethod("getLinkPrefix", fn() => "productcartblist?x_ref=");
        $this->unit->InputTextType = "text";
        $this->unit->Raw = true;
        $this->unit->setSelectMultiple(false); // Select one
        $this->unit->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->unit->Lookup = new Lookup($this->unit, 'partner_product_ref', false, '', ["","","",""], '', '', [], [], [], [], ["currency"], ["x_currency"], false, '', '', "");
        $this->unit->OptionCount = 5;
        $this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unit->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unit'] = &$this->unit;

        // w
        $this->w = new DbField(
            $this, // Table
            'x_w', // Variable name
            'w', // Name
            '`w`', // Expression
            '`w`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`w`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->w->addMethod("getDefault", fn() => 00);
        $this->w->InputTextType = "text";
        $this->w->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['w'] = &$this->w;

        // w_cm
        $this->w_cm = new DbField(
            $this, // Table
            'x_w_cm', // Variable name
            'w_cm', // Name
            '`w_cm`', // Expression
            '`w_cm`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`w_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->w_cm->addMethod("getEditCustomAttributes", fn() => 'tabindex="999"');
        $this->w_cm->InputTextType = "text";
        $this->w_cm->Raw = true;
        $this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->w_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['w_cm'] = &$this->w_cm;

        // l
        $this->l = new DbField(
            $this, // Table
            'x_l', // Variable name
            'l', // Name
            '`l`', // Expression
            '`l`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`l`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->l->addMethod("getDefault", fn() => 00);
        $this->l->InputTextType = "text";
        $this->l->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['l'] = &$this->l;

        // l_cm
        $this->l_cm = new DbField(
            $this, // Table
            'x_l_cm', // Variable name
            'l_cm', // Name
            '`l_cm`', // Expression
            '`l_cm`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`l_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->l_cm->addMethod("getEditCustomAttributes", fn() => 'tabindex="999"');
        $this->l_cm->InputTextType = "text";
        $this->l_cm->Raw = true;
        $this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->l_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['l_cm'] = &$this->l_cm;

        // h
        $this->h = new DbField(
            $this, // Table
            'x_h', // Variable name
            'h', // Name
            '`h`', // Expression
            '`h`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`h`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->h->addMethod("getDefault", fn() => 00);
        $this->h->InputTextType = "text";
        $this->h->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['h'] = &$this->h;

        // h_cm
        $this->h_cm = new DbField(
            $this, // Table
            'x_h_cm', // Variable name
            'h_cm', // Name
            '`h_cm`', // Expression
            '`h_cm`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`h_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->h_cm->addMethod("getEditCustomAttributes", fn() => 'tabindex="999"');
        $this->h_cm->InputTextType = "text";
        $this->h_cm->Raw = true;
        $this->h_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->h_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['h_cm'] = &$this->h_cm;

        // partner_size
        $this->partner_size = new DbField(
            $this, // Table
            'x_partner_size', // Variable name
            'partner_size', // Name
            '`partner_size`', // Expression
            '`partner_size`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`partner_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->partner_size->InputTextType = "text";
        $this->partner_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['partner_size'] = &$this->partner_size;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm'] = &$this->sqm;

        // cbm
        $this->cbm = new DbField(
            $this, // Table
            'x_cbm', // Variable name
            'cbm', // Name
            '`cbm`', // Expression
            '`cbm`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cbm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cbm->addMethod("getDefault", fn() => 0.0000);
        $this->cbm->InputTextType = "text";
        $this->cbm->Raw = true;
        $this->cbm->Nullable = false; // NOT NULL field
        $this->cbm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cbm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cbm'] = &$this->cbm;

        // weight_sqm
        $this->weight_sqm = new DbField(
            $this, // Table
            'x_weight_sqm', // Variable name
            'weight_sqm', // Name
            '`weight_sqm`', // Expression
            '`weight_sqm`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weight_sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->weight_sqm->InputTextType = "text";
        $this->weight_sqm->Raw = true;
        $this->weight_sqm->Nullable = false; // NOT NULL field
        $this->weight_sqm->Required = true; // Required field
        $this->weight_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->weight_sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['weight_sqm'] = &$this->weight_sqm;

        // sqm_a
        $this->sqm_a = new DbField(
            $this, // Table
            'x_sqm_a', // Variable name
            'sqm_a', // Name
            '`sqm_a`', // Expression
            '`sqm_a`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm_a->InputTextType = "text";
        $this->sqm_a->Raw = true;
        $this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm_a'] = &$this->sqm_a;

        // 2srm_a
        $this->_2srm_a = new DbField(
            $this, // Table
            'x__2srm_a', // Variable name
            '2srm_a', // Name
            '`2srm_a`', // Expression
            '`2srm_a`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`2srm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_2srm_a->InputTextType = "text";
        $this->_2srm_a->Raw = true;
        $this->_2srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_2srm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['2srm_a'] = &$this->_2srm_a;

        // 4srm_a
        $this->_4srm_a = new DbField(
            $this, // Table
            'x__4srm_a', // Variable name
            '4srm_a', // Name
            '`4srm_a`', // Expression
            '`4srm_a`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`4srm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_4srm_a->InputTextType = "text";
        $this->_4srm_a->Raw = true;
        $this->_4srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_4srm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['4srm_a'] = &$this->_4srm_a;

        // price
        $this->price = new DbField(
            $this, // Table
            'x_price', // Variable name
            'price', // Name
            '`price`', // Expression
            '`price`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price->addMethod("getDefault", fn() => 0);
        $this->price->InputTextType = "text";
        $this->price->Raw = true;
        $this->price->Required = true; // Required field
        $this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['price'] = &$this->price;

        // price_cs
        $this->price_cs = new DbField(
            $this, // Table
            'x_price_cs', // Variable name
            'price_cs', // Name
            '`price_cs`', // Expression
            '`price_cs`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price_cs`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price_cs->InputTextType = "text";
        $this->price_cs->Raw = true;
        $this->price_cs->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price_cs->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['price_cs'] = &$this->price_cs;

        // currency
        $this->currency = new DbField(
            $this, // Table
            'x_currency', // Variable name
            'currency', // Name
            '`currency`', // Expression
            '`currency`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`currency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->currency->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->currency->addMethod("getDefault", fn() => 1);
        $this->currency->InputTextType = "text";
        $this->currency->Raw = true;
        $this->currency->setSelectMultiple(false); // Select one
        $this->currency->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->currency->Lookup = new Lookup($this->currency, 'currency', false, 'id', ["code","name","",""], '', '', [], [], [], [], [], [], true, '`code` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->currency) . "',COALESCE(`name`,''))");
        $this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->currency->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['currency'] = &$this->currency;

        // hsn
        $this->hsn = new DbField(
            $this, // Table
            'x_hsn', // Variable name
            'hsn', // Name
            '`hsn`', // Expression
            '`hsn`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`hsn`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->hsn->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->hsn->InputTextType = "text";
        $this->hsn->Raw = true;
        $this->hsn->setSelectMultiple(false); // Select one
        $this->hsn->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->hsn->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->hsn->Lookup = new Lookup($this->hsn, 'tax_category', false, 'id', ["item","hsn_code","tax_percent",""], '', '', ["x_grp"], [], ["grp"], ["x_grp"], [], [], false, '`item` ASC', '', "CONCAT(COALESCE(`item`, ''),'" . ValueSeparator(1, $this->hsn) . "',COALESCE(`hsn_code`,''),'" . ValueSeparator(2, $this->hsn) . "',COALESCE(`tax_percent`,''))");
        $this->hsn->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->hsn->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['hsn'] = &$this->hsn;

        // composition
        $this->composition = new DbField(
            $this, // Table
            'x_composition', // Variable name
            'composition', // Name
            '`composition`', // Expression
            '`composition`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`composition`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->composition->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->composition->InputTextType = "text";
        $this->composition->Raw = true;
        $this->composition->setSelectMultiple(false); // Select one
        $this->composition->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->composition->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->composition->Lookup = new Lookup($this->composition, 'composition', false, 'id', ["composition","","",""], '', '', ["x_grp"], [], ["grp"], ["x_grp"], [], [], false, '`composition` ASC', '', "`composition`");
        $this->composition->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->composition->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['composition'] = &$this->composition;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'partner_product_ref', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // gcode
        $this->gcode = new DbField(
            $this, // Table
            'x_gcode', // Variable name
            'gcode', // Name
            '`gcode`', // Expression
            '`gcode`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->gcode->InputTextType = "text";
        $this->gcode->Nullable = false; // NOT NULL field
        $this->gcode->Required = true; // Required field
        $this->gcode->Sortable = false; // Allow sort
        $this->gcode->setSelectMultiple(false); // Select one
        $this->gcode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->gcode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->gcode->Lookup = new Lookup($this->gcode, 'ref', false, 'gcode', ["gcode","","",""], '', '', ["x_rid"], [], ["id"], ["x_id"], [], [], false, '`gcode` ASC', '', "`gcode`");
        $this->gcode->SearchOperators = ["=", "<>"];
        $this->Fields['gcode'] = &$this->gcode;

        // d_01
        $this->d_01 = new DbField(
            $this, // Table
            'x_d_01', // Variable name
            'd_01', // Name
            '`d_01`', // Expression
            '`d_01`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_01->InputTextType = "text";
        $this->d_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_01'] = &$this->d_01;

        // d_02
        $this->d_02 = new DbField(
            $this, // Table
            'x_d_02', // Variable name
            'd_02', // Name
            '`d_02`', // Expression
            '`d_02`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_02->InputTextType = "text";
        $this->d_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_02'] = &$this->d_02;

        // d_03
        $this->d_03 = new DbField(
            $this, // Table
            'x_d_03', // Variable name
            'd_03', // Name
            '`d_03`', // Expression
            '`d_03`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_03->InputTextType = "text";
        $this->d_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_03'] = &$this->d_03;

        // d_04
        $this->d_04 = new DbField(
            $this, // Table
            'x_d_04', // Variable name
            'd_04', // Name
            '`d_04`', // Expression
            '`d_04`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_04->InputTextType = "text";
        $this->d_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_04'] = &$this->d_04;

        // d_05
        $this->d_05 = new DbField(
            $this, // Table
            'x_d_05', // Variable name
            'd_05', // Name
            '`d_05`', // Expression
            '`d_05`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_05->InputTextType = "text";
        $this->d_05->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_05'] = &$this->d_05;

        // d_06
        $this->d_06 = new DbField(
            $this, // Table
            'x_d_06', // Variable name
            'd_06', // Name
            '`d_06`', // Expression
            '`d_06`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_06->InputTextType = "text";
        $this->d_06->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_06'] = &$this->d_06;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "ref") {
            $masterTable = Container("ref");
            if ($this->rid->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->id, $this->rid->getSessionValue(), $masterTable->id->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        if ($this->getCurrentMasterTable() == "ref_code") {
            $masterTable = Container("ref_code");
            if ($this->rid->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->id, $this->rid->getSessionValue(), $masterTable->id->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "ref") {
            $masterTable = Container("ref");
            if ($this->rid->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->rid, $this->rid->getSessionValue(), $masterTable->id->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        if ($this->getCurrentMasterTable() == "ref_code") {
            $masterTable = Container("ref_code");
            if ($this->rid->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->rid, $this->rid->getSessionValue(), $masterTable->id->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "ref":
                $key = $keys["rid"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->id->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->id, $keys["rid"], $this->rid->DataType, $this->Dbid);
                }
                break;
            case "ref_code":
                $key = $keys["rid"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->id->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->id, $keys["rid"], $this->rid->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "ref":
                return GetKeyFilter($this->rid, $masterTable->id->DbValue, $masterTable->id->DataType, $masterTable->Dbid);
            case "ref_code":
                return GetKeyFilter($this->rid, $masterTable->id->DbValue, $masterTable->id->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "partner_product_ref";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Category() == 0) ?  "" : "`partner` = " .  User_Company_ID()  . "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->partner_type->DbValue = $row['partner_type'];
        $this->partner->DbValue = $row['partner'];
        $this->partner_ref->DbValue = $row['partner_ref'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->partner_code->DbValue = $row['partner_code'];
        $this->product_type->DbValue = $row['product_type'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->rid->DbValue = $row['rid'];
        $this->spl_ins->DbValue = $row['spl_ins'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->shape->DbValue = $row['shape'];
        $this->unit->DbValue = $row['unit'];
        $this->w->DbValue = $row['w'];
        $this->w_cm->DbValue = $row['w_cm'];
        $this->l->DbValue = $row['l'];
        $this->l_cm->DbValue = $row['l_cm'];
        $this->h->DbValue = $row['h'];
        $this->h_cm->DbValue = $row['h_cm'];
        $this->partner_size->DbValue = $row['partner_size'];
        $this->sqm->DbValue = $row['sqm'];
        $this->cbm->DbValue = $row['cbm'];
        $this->weight_sqm->DbValue = $row['weight_sqm'];
        $this->sqm_a->DbValue = $row['sqm_a'];
        $this->_2srm_a->DbValue = $row['2srm_a'];
        $this->_4srm_a->DbValue = $row['4srm_a'];
        $this->price->DbValue = $row['price'];
        $this->price_cs->DbValue = $row['price_cs'];
        $this->currency->DbValue = $row['currency'];
        $this->hsn->DbValue = $row['hsn'];
        $this->composition->DbValue = $row['composition'];
        $this->status->DbValue = $row['status'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->gcode->DbValue = $row['gcode'];
        $this->d_01->DbValue = $row['d_01'];
        $this->d_02->DbValue = $row['d_02'];
        $this->d_03->DbValue = $row['d_03'];
        $this->d_04->DbValue = $row['d_04'];
        $this->d_05->DbValue = $row['d_05'];
        $this->d_06->DbValue = $row['d_06'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("partnerproductreflist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "partnerproductrefview" => $Language->phrase("View"),
            "partnerproductrefedit" => $Language->phrase("Edit"),
            "partnerproductrefadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "partnerproductreflist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PartnerProductRefView",
            Config("API_ADD_ACTION") => "PartnerProductRefAdd",
            Config("API_EDIT_ACTION") => "PartnerProductRefEdit",
            Config("API_DELETE_ACTION") => "PartnerProductRefDelete",
            Config("API_LIST_ACTION") => "PartnerProductRefList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "partnerproductreflist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("partnerproductrefview", $parm);
        } else {
            $url = $this->keyUrl("partnerproductrefview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "partnerproductrefadd?" . $parm;
        } else {
            $url = "partnerproductrefadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("partnerproductrefedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("partnerproductreflist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("partnerproductrefadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("partnerproductreflist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("partnerproductrefdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "ref" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_id", $this->rid->getSessionValue()); // Use Session Value
        }
        if ($this->getCurrentMasterTable() == "ref_code" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_id", $this->rid->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->partner_type->setDbValue($row['partner_type']);
        $this->partner->setDbValue($row['partner']);
        $this->partner_ref->setDbValue($row['partner_ref']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->partner_code->setDbValue($row['partner_code']);
        $this->product_type->setDbValue($row['product_type']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid->setDbValue($row['rid']);
        $this->spl_ins->setDbValue($row['spl_ins']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->shape->setDbValue($row['shape']);
        $this->unit->setDbValue($row['unit']);
        $this->w->setDbValue($row['w']);
        $this->w_cm->setDbValue($row['w_cm']);
        $this->l->setDbValue($row['l']);
        $this->l_cm->setDbValue($row['l_cm']);
        $this->h->setDbValue($row['h']);
        $this->h_cm->setDbValue($row['h_cm']);
        $this->partner_size->setDbValue($row['partner_size']);
        $this->sqm->setDbValue($row['sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->weight_sqm->setDbValue($row['weight_sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->_2srm_a->setDbValue($row['2srm_a']);
        $this->_4srm_a->setDbValue($row['4srm_a']);
        $this->price->setDbValue($row['price']);
        $this->price_cs->setDbValue($row['price_cs']);
        $this->currency->setDbValue($row['currency']);
        $this->hsn->setDbValue($row['hsn']);
        $this->composition->setDbValue($row['composition']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->gcode->setDbValue($row['gcode']);
        $this->d_01->setDbValue($row['d_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->d_03->setDbValue($row['d_03']);
        $this->d_04->setDbValue($row['d_04']);
        $this->d_05->setDbValue($row['d_05']);
        $this->d_06->setDbValue($row['d_06']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PartnerProductRefList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // partner_type

        // partner

        // partner_ref

        // barcode

        // partner_code

        // product_type

        // grp

        // s_grp

        // product

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // spl_ins

        // packing_type

        // batch_no

        // shape

        // unit

        // w

        // w_cm

        // l

        // l_cm

        // h

        // h_cm

        // partner_size

        // sqm

        // cbm

        // weight_sqm

        // sqm_a

        // 2srm_a

        // 4srm_a

        // price

        // price_cs

        // currency

        // hsn

        // composition

        // status

        // operator

        // datetime

        // gcode
        $this->gcode->CellCssStyle = "white-space: nowrap;";

        // d_01

        // d_02

        // d_03

        // d_04

        // d_05

        // d_06

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // partner_type
        $curVal = strval($this->partner_type->CurrentValue);
        if ($curVal != "") {
            $this->partner_type->ViewValue = $this->partner_type->lookupCacheOption($curVal);
            if ($this->partner_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->partner_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->partner_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->partner_type->Lookup->renderViewRow($rswrk[0]);
                    $this->partner_type->ViewValue = $this->partner_type->displayValue($arwrk);
                } else {
                    $this->partner_type->ViewValue = FormatNumber($this->partner_type->CurrentValue, $this->partner_type->formatPattern());
                }
            }
        } else {
            $this->partner_type->ViewValue = null;
        }

        // partner
        $curVal = strval($this->partner->CurrentValue);
        if ($curVal != "") {
            $this->partner->ViewValue = $this->partner->lookupCacheOption($curVal);
            if ($this->partner->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->partner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->partner->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->partner->Lookup->renderViewRow($rswrk[0]);
                    $this->partner->ViewValue = $this->partner->displayValue($arwrk);
                } else {
                    $this->partner->ViewValue = FormatNumber($this->partner->CurrentValue, $this->partner->formatPattern());
                }
            }
        } else {
            $this->partner->ViewValue = null;
        }

        // partner_ref
        $this->partner_ref->ViewValue = $this->partner_ref->CurrentValue;

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

        // partner_code
        $this->partner_code->ViewValue = $this->partner_code->CurrentValue;

        // product_type
        $curVal = strval($this->product_type->CurrentValue);
        if ($curVal != "") {
            $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            if ($this->product_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                    $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                } else {
                    $this->product_type->ViewValue = FormatNumber($this->product_type->CurrentValue, $this->product_type->formatPattern());
                }
            }
        } else {
            $this->product_type->ViewValue = null;
        }

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = $this->grp->CurrentValue;
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // rid
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->ViewValue = $this->rid->CurrentValue;
                }
            }
        } else {
            $this->rid->ViewValue = null;
        }

        // spl_ins
        $this->spl_ins->ViewValue = $this->spl_ins->CurrentValue;

        // packing_type
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                }
            }
        } else {
            $this->packing_type->ViewValue = null;
        }

        // batch_no
        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                }
            }
        } else {
            $this->batch_no->ViewValue = null;
        }

        // shape
        $curVal = strval($this->shape->CurrentValue);
        if ($curVal != "") {
            $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            if ($this->shape->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->shape->Lookup->renderViewRow($rswrk[0]);
                    $this->shape->ViewValue = $this->shape->displayValue($arwrk);
                } else {
                    $this->shape->ViewValue = $this->shape->CurrentValue;
                }
            }
        } else {
            $this->shape->ViewValue = null;
        }

        // unit
        if (strval($this->unit->CurrentValue) != "") {
            $this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
        } else {
            $this->unit->ViewValue = null;
        }

        // w
        $this->w->ViewValue = $this->w->CurrentValue;

        // w_cm
        $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
        $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

        // l
        $this->l->ViewValue = $this->l->CurrentValue;

        // l_cm
        $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
        $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

        // h
        $this->h->ViewValue = $this->h->CurrentValue;

        // h_cm
        $this->h_cm->ViewValue = $this->h_cm->CurrentValue;
        $this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, $this->h_cm->formatPattern());

        // partner_size
        $this->partner_size->ViewValue = $this->partner_size->CurrentValue;

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // cbm
        $this->cbm->ViewValue = $this->cbm->CurrentValue;
        $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

        // weight_sqm
        $this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
        $this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, $this->weight_sqm->formatPattern());

        // sqm_a
        $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

        // 2srm_a
        $this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
        $this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, $this->_2srm_a->formatPattern());

        // 4srm_a
        $this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
        $this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, $this->_4srm_a->formatPattern());

        // price
        $this->price->ViewValue = $this->price->CurrentValue;
        $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

        // price_cs
        $this->price_cs->ViewValue = $this->price_cs->CurrentValue;
        $this->price_cs->ViewValue = FormatNumber($this->price_cs->ViewValue, $this->price_cs->formatPattern());

        // currency
        $curVal = strval($this->currency->CurrentValue);
        if ($curVal != "") {
            $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            if ($this->currency->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                    $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                } else {
                    $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                }
            }
        } else {
            $this->currency->ViewValue = null;
        }

        // hsn
        $curVal = strval($this->hsn->CurrentValue);
        if ($curVal != "") {
            $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
            if ($this->hsn->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                $sqlWrk = $this->hsn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->hsn->Lookup->renderViewRow($rswrk[0]);
                    $this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
                } else {
                    $this->hsn->ViewValue = FormatNumber($this->hsn->CurrentValue, $this->hsn->formatPattern());
                }
            }
        } else {
            $this->hsn->ViewValue = null;
        }

        // composition
        $curVal = strval($this->composition->CurrentValue);
        if ($curVal != "") {
            $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
            if ($this->composition->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                    $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                } else {
                    $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                }
            }
        } else {
            $this->composition->ViewValue = null;
        }

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // gcode
        $curVal = strval($this->gcode->CurrentValue);
        if ($curVal != "") {
            $this->gcode->ViewValue = $this->gcode->lookupCacheOption($curVal);
            if ($this->gcode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->gcode->Lookup->getTable()->Fields["gcode"]->searchExpression(), "=", $curVal, $this->gcode->Lookup->getTable()->Fields["gcode"]->searchDataType(), "");
                $sqlWrk = $this->gcode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->gcode->Lookup->renderViewRow($rswrk[0]);
                    $this->gcode->ViewValue = $this->gcode->displayValue($arwrk);
                } else {
                    $this->gcode->ViewValue = $this->gcode->CurrentValue;
                }
            }
        } else {
            $this->gcode->ViewValue = null;
        }

        // d_01
        $this->d_01->ViewValue = $this->d_01->CurrentValue;

        // d_02
        $this->d_02->ViewValue = $this->d_02->CurrentValue;

        // d_03
        $this->d_03->ViewValue = $this->d_03->CurrentValue;

        // d_04
        $this->d_04->ViewValue = $this->d_04->CurrentValue;

        // d_05
        $this->d_05->ViewValue = $this->d_05->CurrentValue;

        // d_06
        $this->d_06->ViewValue = $this->d_06->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // partner_type
        $this->partner_type->HrefValue = "";
        $this->partner_type->TooltipValue = "";

        // partner
        $this->partner->HrefValue = "";
        $this->partner->TooltipValue = "";

        // partner_ref
        $this->partner_ref->HrefValue = "";
        $this->partner_ref->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // partner_code
        $this->partner_code->HrefValue = "";
        $this->partner_code->TooltipValue = "";

        // product_type
        $this->product_type->HrefValue = "";
        $this->product_type->TooltipValue = "";

        // grp
        if (!EmptyValue($this->grp->CurrentValue)) {
            $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
            $this->grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
            }
        } else {
            $this->grp->HrefValue = "";
        }
        $this->grp->TooltipValue = "";

        // s_grp
        if (!EmptyValue($this->s_grp->CurrentValue)) {
            $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
            $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
            }
        } else {
            $this->s_grp->HrefValue = "";
        }
        $this->s_grp->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // rid
        $this->rid->HrefValue = "";
        $this->rid->TooltipValue = "";

        // spl_ins
        $this->spl_ins->HrefValue = "";
        $this->spl_ins->TooltipValue = "";

        // packing_type
        $this->packing_type->HrefValue = "";
        $this->packing_type->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // shape
        $this->shape->HrefValue = "";
        $this->shape->TooltipValue = "";

        // unit
        if (!EmptyValue($this->unit->CurrentValue)) {
            $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
            $this->unit->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
            }
        } else {
            $this->unit->HrefValue = "";
        }
        $this->unit->TooltipValue = "";

        // w
        $this->w->HrefValue = "";
        $this->w->TooltipValue = "";

        // w_cm
        $this->w_cm->HrefValue = "";
        $this->w_cm->TooltipValue = "";

        // l
        $this->l->HrefValue = "";
        $this->l->TooltipValue = "";

        // l_cm
        $this->l_cm->HrefValue = "";
        $this->l_cm->TooltipValue = "";

        // h
        $this->h->HrefValue = "";
        $this->h->TooltipValue = "";

        // h_cm
        $this->h_cm->HrefValue = "";
        $this->h_cm->TooltipValue = "";

        // partner_size
        $this->partner_size->HrefValue = "";
        $this->partner_size->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // cbm
        $this->cbm->HrefValue = "";
        $this->cbm->TooltipValue = "";

        // weight_sqm
        $this->weight_sqm->HrefValue = "";
        $this->weight_sqm->TooltipValue = "";

        // sqm_a
        $this->sqm_a->HrefValue = "";
        $this->sqm_a->TooltipValue = "";

        // 2srm_a
        $this->_2srm_a->HrefValue = "";
        $this->_2srm_a->TooltipValue = "";

        // 4srm_a
        $this->_4srm_a->HrefValue = "";
        $this->_4srm_a->TooltipValue = "";

        // price
        $this->price->HrefValue = "";
        $this->price->TooltipValue = "";

        // price_cs
        $this->price_cs->HrefValue = "";
        $this->price_cs->TooltipValue = "";

        // currency
        $this->currency->HrefValue = "";
        $this->currency->TooltipValue = "";

        // hsn
        $this->hsn->HrefValue = "";
        $this->hsn->TooltipValue = "";

        // composition
        $this->composition->HrefValue = "";
        $this->composition->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // gcode
        $this->gcode->HrefValue = "";
        $this->gcode->TooltipValue = "";

        // d_01
        $this->d_01->HrefValue = "";
        $this->d_01->TooltipValue = "";

        // d_02
        $this->d_02->HrefValue = "";
        $this->d_02->TooltipValue = "";

        // d_03
        $this->d_03->HrefValue = "";
        $this->d_03->TooltipValue = "";

        // d_04
        $this->d_04->HrefValue = "";
        $this->d_04->TooltipValue = "";

        // d_05
        $this->d_05->HrefValue = "";
        $this->d_05->TooltipValue = "";

        // d_06
        $this->d_06->HrefValue = "";
        $this->d_06->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // partner_type
        $this->partner_type->setupEditAttributes();
        $this->partner_type->PlaceHolder = RemoveHtml($this->partner_type->caption());

        // partner
        $this->partner->setupEditAttributes();
        $this->partner->PlaceHolder = RemoveHtml($this->partner->caption());

        // partner_ref
        $this->partner_ref->setupEditAttributes();
        if (!$this->partner_ref->Raw) {
            $this->partner_ref->CurrentValue = HtmlDecode($this->partner_ref->CurrentValue);
        }
        $this->partner_ref->EditValue = $this->partner_ref->CurrentValue;
        $this->partner_ref->PlaceHolder = RemoveHtml($this->partner_ref->caption());

        // barcode
        $this->_barcode->setupEditAttributes();
        if (!$this->_barcode->Raw) {
            $this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
        }
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;
        $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

        // partner_code
        $this->partner_code->setupEditAttributes();
        if (!$this->partner_code->Raw) {
            $this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
        }
        $this->partner_code->EditValue = $this->partner_code->CurrentValue;
        $this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

        // product_type
        $this->product_type->setupEditAttributes();
        $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // rid
        $this->rid->setupEditAttributes();
        if ($this->rid->getSessionValue() != "") {
            $this->rid->CurrentValue = GetForeignKeyValue($this->rid->getSessionValue());
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }
        } else {
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
        }

        // spl_ins
        $this->spl_ins->setupEditAttributes();
        if (!$this->spl_ins->Raw) {
            $this->spl_ins->CurrentValue = HtmlDecode($this->spl_ins->CurrentValue);
        }
        $this->spl_ins->EditValue = $this->spl_ins->CurrentValue;
        $this->spl_ins->PlaceHolder = RemoveHtml($this->spl_ins->caption());

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->EditValue = $this->batch_no->CurrentValue;
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // shape
        $this->shape->setupEditAttributes();
        $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

        // unit
        $this->unit->setupEditAttributes();
        $this->unit->EditValue = $this->unit->options(true);
        $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

        // w
        $this->w->setupEditAttributes();
        if (!$this->w->Raw) {
            $this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
        }
        $this->w->EditValue = $this->w->CurrentValue;
        $this->w->PlaceHolder = RemoveHtml($this->w->caption());

        // w_cm
        $this->w_cm->setupEditAttributes();
        $this->w_cm->EditCustomAttributes = $this->w_cm->getEditCustomAttributes(); // PHP
        $this->w_cm->EditValue = $this->w_cm->CurrentValue;
        $this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
        if (strval($this->w_cm->EditValue) != "" && is_numeric($this->w_cm->EditValue)) {
            $this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, null);
        }

        // l
        $this->l->setupEditAttributes();
        if (!$this->l->Raw) {
            $this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
        }
        $this->l->EditValue = $this->l->CurrentValue;
        $this->l->PlaceHolder = RemoveHtml($this->l->caption());

        // l_cm
        $this->l_cm->setupEditAttributes();
        $this->l_cm->EditCustomAttributes = $this->l_cm->getEditCustomAttributes(); // PHP
        $this->l_cm->EditValue = $this->l_cm->CurrentValue;
        $this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
        if (strval($this->l_cm->EditValue) != "" && is_numeric($this->l_cm->EditValue)) {
            $this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, null);
        }

        // h
        $this->h->setupEditAttributes();
        if (!$this->h->Raw) {
            $this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
        }
        $this->h->EditValue = $this->h->CurrentValue;
        $this->h->PlaceHolder = RemoveHtml($this->h->caption());

        // h_cm
        $this->h_cm->setupEditAttributes();
        $this->h_cm->EditCustomAttributes = $this->h_cm->getEditCustomAttributes(); // PHP
        $this->h_cm->EditValue = $this->h_cm->CurrentValue;
        $this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());
        if (strval($this->h_cm->EditValue) != "" && is_numeric($this->h_cm->EditValue)) {
            $this->h_cm->EditValue = FormatNumber($this->h_cm->EditValue, null);
        }

        // partner_size
        $this->partner_size->setupEditAttributes();
        if (!$this->partner_size->Raw) {
            $this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
        }
        $this->partner_size->EditValue = $this->partner_size->CurrentValue;
        $this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditCustomAttributes = $this->sqm->getEditCustomAttributes(); // PHP
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // cbm
        $this->cbm->setupEditAttributes();
        $this->cbm->EditValue = $this->cbm->CurrentValue;
        $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
        if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
            $this->cbm->EditValue = FormatNumber($this->cbm->EditValue, null);
        }

        // weight_sqm
        $this->weight_sqm->setupEditAttributes();
        $this->weight_sqm->EditValue = $this->weight_sqm->CurrentValue;
        $this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
        if (strval($this->weight_sqm->EditValue) != "" && is_numeric($this->weight_sqm->EditValue)) {
            $this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, null);
        }

        // sqm_a
        $this->sqm_a->setupEditAttributes();
        $this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
        if (strval($this->sqm_a->EditValue) != "" && is_numeric($this->sqm_a->EditValue)) {
            $this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, null);
        }

        // 2srm_a
        $this->_2srm_a->setupEditAttributes();
        $this->_2srm_a->EditValue = $this->_2srm_a->CurrentValue;
        $this->_2srm_a->PlaceHolder = RemoveHtml($this->_2srm_a->caption());
        if (strval($this->_2srm_a->EditValue) != "" && is_numeric($this->_2srm_a->EditValue)) {
            $this->_2srm_a->EditValue = FormatNumber($this->_2srm_a->EditValue, null);
        }

        // 4srm_a
        $this->_4srm_a->setupEditAttributes();
        $this->_4srm_a->EditValue = $this->_4srm_a->CurrentValue;
        $this->_4srm_a->PlaceHolder = RemoveHtml($this->_4srm_a->caption());
        if (strval($this->_4srm_a->EditValue) != "" && is_numeric($this->_4srm_a->EditValue)) {
            $this->_4srm_a->EditValue = FormatNumber($this->_4srm_a->EditValue, null);
        }

        // price
        $this->price->setupEditAttributes();
        $this->price->EditValue = $this->price->CurrentValue;
        $this->price->PlaceHolder = RemoveHtml($this->price->caption());
        if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
            $this->price->EditValue = FormatNumber($this->price->EditValue, null);
        }

        // price_cs
        $this->price_cs->setupEditAttributes();
        $this->price_cs->EditValue = $this->price_cs->CurrentValue;
        $this->price_cs->PlaceHolder = RemoveHtml($this->price_cs->caption());
        if (strval($this->price_cs->EditValue) != "" && is_numeric($this->price_cs->EditValue)) {
            $this->price_cs->EditValue = FormatNumber($this->price_cs->EditValue, null);
        }

        // currency
        $this->currency->setupEditAttributes();
        $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

        // hsn
        $this->hsn->setupEditAttributes();
        $this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

        // composition
        $this->composition->setupEditAttributes();
        $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // operator

        // datetime

        // gcode
        $this->gcode->setupEditAttributes();
        $this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

        // d_01
        $this->d_01->setupEditAttributes();
        if (!$this->d_01->Raw) {
            $this->d_01->CurrentValue = HtmlDecode($this->d_01->CurrentValue);
        }
        $this->d_01->EditValue = $this->d_01->CurrentValue;
        $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

        // d_02
        $this->d_02->setupEditAttributes();
        if (!$this->d_02->Raw) {
            $this->d_02->CurrentValue = HtmlDecode($this->d_02->CurrentValue);
        }
        $this->d_02->EditValue = $this->d_02->CurrentValue;
        $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

        // d_03
        $this->d_03->setupEditAttributes();
        if (!$this->d_03->Raw) {
            $this->d_03->CurrentValue = HtmlDecode($this->d_03->CurrentValue);
        }
        $this->d_03->EditValue = $this->d_03->CurrentValue;
        $this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());

        // d_04
        $this->d_04->setupEditAttributes();
        if (!$this->d_04->Raw) {
            $this->d_04->CurrentValue = HtmlDecode($this->d_04->CurrentValue);
        }
        $this->d_04->EditValue = $this->d_04->CurrentValue;
        $this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());

        // d_05
        $this->d_05->setupEditAttributes();
        if (!$this->d_05->Raw) {
            $this->d_05->CurrentValue = HtmlDecode($this->d_05->CurrentValue);
        }
        $this->d_05->EditValue = $this->d_05->CurrentValue;
        $this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());

        // d_06
        $this->d_06->setupEditAttributes();
        if (!$this->d_06->Raw) {
            $this->d_06->CurrentValue = HtmlDecode($this->d_06->CurrentValue);
        }
        $this->d_06->EditValue = $this->d_06->CurrentValue;
        $this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->partner_type);
                    $doc->exportCaption($this->partner);
                    $doc->exportCaption($this->partner_ref);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->partner_code);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->spl_ins);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->w);
                    $doc->exportCaption($this->w_cm);
                    $doc->exportCaption($this->l);
                    $doc->exportCaption($this->l_cm);
                    $doc->exportCaption($this->h);
                    $doc->exportCaption($this->h_cm);
                    $doc->exportCaption($this->partner_size);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->weight_sqm);
                    $doc->exportCaption($this->sqm_a);
                    $doc->exportCaption($this->_2srm_a);
                    $doc->exportCaption($this->_4srm_a);
                    $doc->exportCaption($this->price);
                    $doc->exportCaption($this->price_cs);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->hsn);
                    $doc->exportCaption($this->composition);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->d_01);
                    $doc->exportCaption($this->d_02);
                    $doc->exportCaption($this->d_03);
                    $doc->exportCaption($this->d_04);
                    $doc->exportCaption($this->d_05);
                    $doc->exportCaption($this->d_06);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->partner_type);
                    $doc->exportCaption($this->partner);
                    $doc->exportCaption($this->partner_ref);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->partner_code);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->spl_ins);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->w);
                    $doc->exportCaption($this->w_cm);
                    $doc->exportCaption($this->l);
                    $doc->exportCaption($this->l_cm);
                    $doc->exportCaption($this->h);
                    $doc->exportCaption($this->h_cm);
                    $doc->exportCaption($this->partner_size);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->weight_sqm);
                    $doc->exportCaption($this->sqm_a);
                    $doc->exportCaption($this->_2srm_a);
                    $doc->exportCaption($this->_4srm_a);
                    $doc->exportCaption($this->price);
                    $doc->exportCaption($this->price_cs);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->hsn);
                    $doc->exportCaption($this->composition);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->d_01);
                    $doc->exportCaption($this->d_02);
                    $doc->exportCaption($this->d_03);
                    $doc->exportCaption($this->d_04);
                    $doc->exportCaption($this->d_05);
                    $doc->exportCaption($this->d_06);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->partner_type);
                        $doc->exportField($this->partner);
                        $doc->exportField($this->partner_ref);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->partner_code);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->spl_ins);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->w);
                        $doc->exportField($this->w_cm);
                        $doc->exportField($this->l);
                        $doc->exportField($this->l_cm);
                        $doc->exportField($this->h);
                        $doc->exportField($this->h_cm);
                        $doc->exportField($this->partner_size);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->weight_sqm);
                        $doc->exportField($this->sqm_a);
                        $doc->exportField($this->_2srm_a);
                        $doc->exportField($this->_4srm_a);
                        $doc->exportField($this->price);
                        $doc->exportField($this->price_cs);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->hsn);
                        $doc->exportField($this->composition);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->d_01);
                        $doc->exportField($this->d_02);
                        $doc->exportField($this->d_03);
                        $doc->exportField($this->d_04);
                        $doc->exportField($this->d_05);
                        $doc->exportField($this->d_06);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->partner_type);
                        $doc->exportField($this->partner);
                        $doc->exportField($this->partner_ref);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->partner_code);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->spl_ins);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->w);
                        $doc->exportField($this->w_cm);
                        $doc->exportField($this->l);
                        $doc->exportField($this->l_cm);
                        $doc->exportField($this->h);
                        $doc->exportField($this->h_cm);
                        $doc->exportField($this->partner_size);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->weight_sqm);
                        $doc->exportField($this->sqm_a);
                        $doc->exportField($this->_2srm_a);
                        $doc->exportField($this->_4srm_a);
                        $doc->exportField($this->price);
                        $doc->exportField($this->price_cs);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->hsn);
                        $doc->exportField($this->composition);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->d_01);
                        $doc->exportField($this->d_02);
                        $doc->exportField($this->d_03);
                        $doc->exportField($this->d_04);
                        $doc->exportField($this->d_05);
                        $doc->exportField($this->d_06);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
