<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for packing_process_f
 */
class PackingProcessF extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $dated;
    public $product;
    public $product_code;
    public $godown;
    public $Balance;
    public $IN;
    public $OUT;
    public $packets;
    public $packing_type;
    public $lot_no;
    public $remarks;
    public $status;
    public $code;
    public $godown_n;
    public $rid;
    public $tmp_lot;
    public $product_n;
    public $process_type;
    public $gcode;
    public $avg_yield;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "packing_process_f";
        $this->TableName = 'packing_process_f';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "packing_process_f";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // dated
        $this->dated = new DbField(
            $this, // Table
            'x_dated', // Variable name
            'dated', // Name
            '`dated`', // Expression
            CastDateFieldForLike("`dated`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`dated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dated->InputTextType = "text";
        $this->dated->Raw = true;
        $this->dated->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->dated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dated'] = &$this->dated;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product->addMethod("getLinkPrefix", fn() => "packingprocesfslist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Lookup = new Lookup($this->product, 'product_f', false, 'id', ["product","","",""], '', '', [], [], [], [], [], [], false, '`product` ASC', '', "`product`");
        $this->product->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // product_code
        $this->product_code = new DbField(
            $this, // Table
            'x_product_code', // Variable name
            'product_code', // Name
            '`product_code`', // Expression
            '`product_code`', // Basic search expression
            200, // Type
            300, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_code->addMethod("getLinkPrefix", fn() => "packingprocessflist?x_product_code=");
        $this->product_code->InputTextType = "text";
        $this->product_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_code'] = &$this->product_code;

        // godown
        $this->godown = new DbField(
            $this, // Table
            'x_godown', // Variable name
            'godown', // Name
            '`godown`', // Expression
            '`godown`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->godown->addMethod("getLinkPrefix", fn() => "packingprocessflist?x_godown=");
        $this->godown->InputTextType = "text";
        $this->godown->Raw = true;
        $this->godown->setSelectMultiple(false); // Select one
        $this->godown->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->godown->Lookup = new Lookup($this->godown, 'godown_table', false, 'id', ["code","name","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->godown) . "',COALESCE(`name`,''))");
        $this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->godown->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['godown'] = &$this->godown;

        // Balance
        $this->Balance = new DbField(
            $this, // Table
            'x_Balance', // Variable name
            'Balance', // Name
            '`Balance`', // Expression
            '`Balance`', // Basic search expression
            131, // Type
            35, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Balance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Balance->InputTextType = "text";
        $this->Balance->Raw = true;
        $this->Balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Balance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Balance'] = &$this->Balance;

        // IN
        $this->IN = new DbField(
            $this, // Table
            'x_IN', // Variable name
            'IN', // Name
            '`IN`', // Expression
            '`IN`', // Basic search expression
            131, // Type
            34, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`IN`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->IN->InputTextType = "text";
        $this->IN->Raw = true;
        $this->IN->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->IN->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['IN'] = &$this->IN;

        // OUT
        $this->OUT = new DbField(
            $this, // Table
            'x_OUT', // Variable name
            'OUT', // Name
            '`OUT`', // Expression
            '`OUT`', // Basic search expression
            131, // Type
            32, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`OUT`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->OUT->addMethod("getDefault", fn() => 0);
        $this->OUT->InputTextType = "text";
        $this->OUT->Raw = true;
        $this->OUT->Nullable = false; // NOT NULL field
        $this->OUT->Required = true; // Required field
        $this->OUT->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->OUT->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['OUT'] = &$this->OUT;

        // packets
        $this->packets = new DbField(
            $this, // Table
            'x_packets', // Variable name
            'packets', // Name
            '`packets`', // Expression
            '`packets`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets->InputTextType = "text";
        $this->packets->Raw = true;
        $this->packets->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packets'] = &$this->packets;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_type->addMethod("getDefault", fn() => 0);
        $this->packing_type->addMethod("getLinkPrefix", fn() => "packingprocessflist?x_packing_type=");
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Nullable = false; // NOT NULL field
        $this->packing_type->Required = true; // Required field
        $this->packing_type->setSelectMultiple(false); // Select one
        $this->packing_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_type->Lookup = new Lookup($this->packing_type, 'packing_type', false, 'id', ["code","packing","",""], '', '', [], [], [], [], [], [], false, '`packing` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`packing`,''))");
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->addMethod("getDefault", fn() => "NA");
        $this->lot_no->addMethod("getLinkPrefix", fn() => "packingprocessflist?x_lot_no=");
        $this->lot_no->InputTextType = "text";
        $this->lot_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->addMethod("getLinkPrefix", fn() => "packingprocessflist?x_status=");
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'packing_process_f', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 3;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // code
        $this->code = new DbField(
            $this, // Table
            'x_code', // Variable name
            'code', // Name
            '`code`', // Expression
            '`code`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->code->InputTextType = "text";
        $this->code->Sortable = false; // Allow sort
        $this->code->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['code'] = &$this->code;

        // godown_n
        $this->godown_n = new DbField(
            $this, // Table
            'x_godown_n', // Variable name
            'godown_n', // Name
            '`godown_n`', // Expression
            '`godown_n`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown_n`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->godown_n->InputTextType = "text";
        $this->godown_n->Sortable = false; // Allow sort
        $this->godown_n->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['godown_n'] = &$this->godown_n;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Nullable = false; // NOT NULL field
        $this->rid->Required = true; // Required field
        $this->rid->Sortable = false; // Allow sort
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['rid'] = &$this->rid;

        // tmp_lot
        $this->tmp_lot = new DbField(
            $this, // Table
            'x_tmp_lot', // Variable name
            'tmp_lot', // Name
            '`tmp_lot`', // Expression
            '`tmp_lot`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tmp_lot`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tmp_lot->InputTextType = "text";
        $this->tmp_lot->Raw = true;
        $this->tmp_lot->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->tmp_lot->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tmp_lot'] = &$this->tmp_lot;

        // product_n
        $this->product_n = new DbField(
            $this, // Table
            'x_product_n', // Variable name
            'product_n', // Name
            '`product_n`', // Expression
            '`product_n`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_n`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_n->InputTextType = "text";
        $this->product_n->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_n'] = &$this->product_n;

        // process_type
        $this->process_type = new DbField(
            $this, // Table
            'x_process_type', // Variable name
            'process_type', // Name
            '`process_type`', // Expression
            '`process_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->process_type->InputTextType = "text";
        $this->process_type->Raw = true;
        $this->process_type->Nullable = false; // NOT NULL field
        $this->process_type->Required = true; // Required field
        $this->process_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->process_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['process_type'] = &$this->process_type;

        // gcode
        $this->gcode = new DbField(
            $this, // Table
            'x_gcode', // Variable name
            'gcode', // Name
            '`gcode`', // Expression
            '`gcode`', // Basic search expression
            200, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gcode->InputTextType = "text";
        $this->gcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['gcode'] = &$this->gcode;

        // avg_yield
        $this->avg_yield = new DbField(
            $this, // Table
            'x_avg_yield', // Variable name
            'avg_yield', // Name
            '`avg_yield`', // Expression
            '`avg_yield`', // Basic search expression
            3, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`avg_yield`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->avg_yield->addMethod("getDefault", fn() => 0);
        $this->avg_yield->InputTextType = "text";
        $this->avg_yield->Raw = true;
        $this->avg_yield->Nullable = false; // NOT NULL field
        $this->avg_yield->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->avg_yield->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['avg_yield'] = &$this->avg_yield;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "packing_process_f";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "`status` = 1";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->dated->DbValue = $row['dated'];
        $this->product->DbValue = $row['product'];
        $this->product_code->DbValue = $row['product_code'];
        $this->godown->DbValue = $row['godown'];
        $this->Balance->DbValue = $row['Balance'];
        $this->IN->DbValue = $row['IN'];
        $this->OUT->DbValue = $row['OUT'];
        $this->packets->DbValue = $row['packets'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->remarks->DbValue = $row['remarks'];
        $this->status->DbValue = $row['status'];
        $this->code->DbValue = $row['code'];
        $this->godown_n->DbValue = $row['godown_n'];
        $this->rid->DbValue = $row['rid'];
        $this->tmp_lot->DbValue = $row['tmp_lot'];
        $this->product_n->DbValue = $row['product_n'];
        $this->process_type->DbValue = $row['process_type'];
        $this->gcode->DbValue = $row['gcode'];
        $this->avg_yield->DbValue = $row['avg_yield'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("packingprocessflist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "packingprocessfview" => $Language->phrase("View"),
            "packingprocessfedit" => $Language->phrase("Edit"),
            "packingprocessfadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "packingprocessflist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PackingProcessFView",
            Config("API_ADD_ACTION") => "PackingProcessFAdd",
            Config("API_EDIT_ACTION") => "PackingProcessFEdit",
            Config("API_DELETE_ACTION") => "PackingProcessFDelete",
            Config("API_LIST_ACTION") => "PackingProcessFList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "packingprocessflist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("packingprocessfview", $parm);
        } else {
            $url = $this->keyUrl("packingprocessfview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "packingprocessfadd?" . $parm;
        } else {
            $url = "packingprocessfadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("packingprocessfedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("packingprocessflist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("packingprocessfadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("packingprocessflist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("packingprocessfdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->dated->setDbValue($row['dated']);
        $this->product->setDbValue($row['product']);
        $this->product_code->setDbValue($row['product_code']);
        $this->godown->setDbValue($row['godown']);
        $this->Balance->setDbValue($row['Balance']);
        $this->IN->setDbValue($row['IN']);
        $this->OUT->setDbValue($row['OUT']);
        $this->packets->setDbValue($row['packets']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->remarks->setDbValue($row['remarks']);
        $this->status->setDbValue($row['status']);
        $this->code->setDbValue($row['code']);
        $this->godown_n->setDbValue($row['godown_n']);
        $this->rid->setDbValue($row['rid']);
        $this->tmp_lot->setDbValue($row['tmp_lot']);
        $this->product_n->setDbValue($row['product_n']);
        $this->process_type->setDbValue($row['process_type']);
        $this->gcode->setDbValue($row['gcode']);
        $this->avg_yield->setDbValue($row['avg_yield']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PackingProcessFList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // dated

        // product

        // product_code

        // godown

        // Balance

        // IN

        // OUT

        // packets

        // packing_type

        // lot_no

        // remarks

        // status

        // code
        $this->code->CellCssStyle = "white-space: nowrap;";

        // godown_n
        $this->godown_n->CellCssStyle = "white-space: nowrap;";

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // tmp_lot

        // product_n

        // process_type

        // gcode

        // avg_yield

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // dated
        $this->dated->ViewValue = $this->dated->CurrentValue;
        $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

        // product
        $this->product->ViewValue = $this->product->CurrentValue;
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // product_code
        $this->product_code->ViewValue = $this->product_code->CurrentValue;

        // godown
        $curVal = strval($this->godown->CurrentValue);
        if ($curVal != "") {
            $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            if ($this->godown->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                    $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                } else {
                    $this->godown->ViewValue = $this->godown->CurrentValue;
                }
            }
        } else {
            $this->godown->ViewValue = null;
        }

        // Balance
        $this->Balance->ViewValue = $this->Balance->CurrentValue;
        $this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, $this->Balance->formatPattern());

        // IN
        $this->IN->ViewValue = $this->IN->CurrentValue;
        $this->IN->ViewValue = FormatNumber($this->IN->ViewValue, $this->IN->formatPattern());

        // OUT
        $this->OUT->ViewValue = $this->OUT->CurrentValue;
        $this->OUT->ViewValue = FormatNumber($this->OUT->ViewValue, $this->OUT->formatPattern());

        // packets
        $this->packets->ViewValue = $this->packets->CurrentValue;
        $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

        // packing_type
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                }
            }
        } else {
            $this->packing_type->ViewValue = null;
        }

        // lot_no
        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // code
        $this->code->ViewValue = $this->code->CurrentValue;

        // godown_n
        $this->godown_n->ViewValue = $this->godown_n->CurrentValue;

        // rid
        $this->rid->ViewValue = $this->rid->CurrentValue;

        // tmp_lot
        $this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;
        $this->tmp_lot->ViewValue = FormatNumber($this->tmp_lot->ViewValue, $this->tmp_lot->formatPattern());

        // product_n
        $this->product_n->ViewValue = $this->product_n->CurrentValue;

        // process_type
        $this->process_type->ViewValue = $this->process_type->CurrentValue;
        $this->process_type->ViewValue = FormatNumber($this->process_type->ViewValue, $this->process_type->formatPattern());

        // gcode
        $this->gcode->ViewValue = $this->gcode->CurrentValue;

        // avg_yield
        $this->avg_yield->ViewValue = $this->avg_yield->CurrentValue;
        $this->avg_yield->ViewValue = FormatNumber($this->avg_yield->ViewValue, $this->avg_yield->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // dated
        $this->dated->HrefValue = "";
        $this->dated->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // product_code
        if (!EmptyValue($this->product_code->CurrentValue)) {
            $this->product_code->HrefValue = $this->product_code->getLinkPrefix() . $this->product_code->CurrentValue; // Add prefix/suffix
            $this->product_code->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
            }
        } else {
            $this->product_code->HrefValue = "";
        }
        $this->product_code->TooltipValue = "";

        // godown
        if (!EmptyValue($this->godown->CurrentValue)) {
            $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
            $this->godown->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
            }
        } else {
            $this->godown->HrefValue = "";
        }
        $this->godown->TooltipValue = "";

        // Balance
        $this->Balance->HrefValue = "";
        $this->Balance->TooltipValue = "";

        // IN
        $this->IN->HrefValue = "";
        $this->IN->TooltipValue = "";

        // OUT
        $this->OUT->HrefValue = "";
        $this->OUT->TooltipValue = "";

        // packets
        $this->packets->HrefValue = "";
        $this->packets->TooltipValue = "";

        // packing_type
        if (!EmptyValue($this->packing_type->CurrentValue)) {
            $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
            $this->packing_type->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
            }
        } else {
            $this->packing_type->HrefValue = "";
        }
        $this->packing_type->TooltipValue = "";

        // lot_no
        if (!EmptyValue($this->lot_no->CurrentValue)) {
            $this->lot_no->HrefValue = $this->lot_no->getLinkPrefix() . $this->lot_no->CurrentValue; // Add prefix/suffix
            $this->lot_no->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->lot_no->HrefValue = FullUrl($this->lot_no->HrefValue, "href");
            }
        } else {
            $this->lot_no->HrefValue = "";
        }
        $this->lot_no->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // status
        if (!EmptyValue($this->status->CurrentValue)) {
            $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
            $this->status->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
            }
        } else {
            $this->status->HrefValue = "";
        }
        $this->status->TooltipValue = "";

        // code
        $this->code->HrefValue = "";
        $this->code->TooltipValue = "";

        // godown_n
        $this->godown_n->HrefValue = "";
        $this->godown_n->TooltipValue = "";

        // rid
        $this->rid->HrefValue = "";
        $this->rid->TooltipValue = "";

        // tmp_lot
        $this->tmp_lot->HrefValue = "";
        $this->tmp_lot->TooltipValue = "";

        // product_n
        $this->product_n->HrefValue = "";
        $this->product_n->TooltipValue = "";

        // process_type
        $this->process_type->HrefValue = "";
        $this->process_type->TooltipValue = "";

        // gcode
        $this->gcode->HrefValue = "";
        $this->gcode->TooltipValue = "";

        // avg_yield
        $this->avg_yield->HrefValue = "";
        $this->avg_yield->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // dated
        $this->dated->setupEditAttributes();
        $this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->EditValue = $this->product->CurrentValue;
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // product_code
        $this->product_code->setupEditAttributes();
        if (!$this->product_code->Raw) {
            $this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
        }
        $this->product_code->EditValue = $this->product_code->CurrentValue;
        $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

        // godown
        $this->godown->setupEditAttributes();
        $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

        // Balance
        $this->Balance->setupEditAttributes();
        $this->Balance->EditValue = $this->Balance->CurrentValue;
        $this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());
        if (strval($this->Balance->EditValue) != "" && is_numeric($this->Balance->EditValue)) {
            $this->Balance->EditValue = FormatNumber($this->Balance->EditValue, null);
        }

        // IN
        $this->IN->setupEditAttributes();
        $this->IN->EditValue = $this->IN->CurrentValue;
        $this->IN->PlaceHolder = RemoveHtml($this->IN->caption());
        if (strval($this->IN->EditValue) != "" && is_numeric($this->IN->EditValue)) {
            $this->IN->EditValue = FormatNumber($this->IN->EditValue, null);
        }

        // OUT
        $this->OUT->setupEditAttributes();
        $this->OUT->EditValue = $this->OUT->CurrentValue;
        $this->OUT->PlaceHolder = RemoveHtml($this->OUT->caption());
        if (strval($this->OUT->EditValue) != "" && is_numeric($this->OUT->EditValue)) {
            $this->OUT->EditValue = FormatNumber($this->OUT->EditValue, null);
        }

        // packets
        $this->packets->setupEditAttributes();
        $this->packets->EditValue = $this->packets->CurrentValue;
        $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
        if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
            $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
        }

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

        // lot_no
        $this->lot_no->setupEditAttributes();
        if (!$this->lot_no->Raw) {
            $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
        }
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;
        $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // code
        $this->code->setupEditAttributes();
        if (!$this->code->Raw) {
            $this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
        }
        $this->code->EditValue = $this->code->CurrentValue;
        $this->code->PlaceHolder = RemoveHtml($this->code->caption());

        // godown_n
        $this->godown_n->setupEditAttributes();
        if (!$this->godown_n->Raw) {
            $this->godown_n->CurrentValue = HtmlDecode($this->godown_n->CurrentValue);
        }
        $this->godown_n->EditValue = $this->godown_n->CurrentValue;
        $this->godown_n->PlaceHolder = RemoveHtml($this->godown_n->caption());

        // rid
        $this->rid->setupEditAttributes();
        $this->rid->EditValue = $this->rid->CurrentValue;
        $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
        if (strval($this->rid->EditValue) != "" && is_numeric($this->rid->EditValue)) {
            $this->rid->EditValue = $this->rid->EditValue;
        }

        // tmp_lot
        $this->tmp_lot->setupEditAttributes();
        $this->tmp_lot->EditValue = $this->tmp_lot->CurrentValue;
        $this->tmp_lot->PlaceHolder = RemoveHtml($this->tmp_lot->caption());
        if (strval($this->tmp_lot->EditValue) != "" && is_numeric($this->tmp_lot->EditValue)) {
            $this->tmp_lot->EditValue = FormatNumber($this->tmp_lot->EditValue, null);
        }

        // product_n
        $this->product_n->setupEditAttributes();
        if (!$this->product_n->Raw) {
            $this->product_n->CurrentValue = HtmlDecode($this->product_n->CurrentValue);
        }
        $this->product_n->EditValue = $this->product_n->CurrentValue;
        $this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

        // process_type
        $this->process_type->setupEditAttributes();
        $this->process_type->EditValue = $this->process_type->CurrentValue;
        $this->process_type->PlaceHolder = RemoveHtml($this->process_type->caption());
        if (strval($this->process_type->EditValue) != "" && is_numeric($this->process_type->EditValue)) {
            $this->process_type->EditValue = FormatNumber($this->process_type->EditValue, null);
        }

        // gcode
        $this->gcode->setupEditAttributes();
        if (!$this->gcode->Raw) {
            $this->gcode->CurrentValue = HtmlDecode($this->gcode->CurrentValue);
        }
        $this->gcode->EditValue = $this->gcode->CurrentValue;
        $this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

        // avg_yield
        $this->avg_yield->setupEditAttributes();
        $this->avg_yield->EditValue = $this->avg_yield->CurrentValue;
        $this->avg_yield->PlaceHolder = RemoveHtml($this->avg_yield->caption());
        if (strval($this->avg_yield->EditValue) != "" && is_numeric($this->avg_yield->EditValue)) {
            $this->avg_yield->EditValue = FormatNumber($this->avg_yield->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->Balance->CurrentValue)) {
                $this->Balance->Total += $this->Balance->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->IN->CurrentValue)) {
                $this->IN->Total += $this->IN->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->OUT->CurrentValue)) {
                $this->OUT->Total += $this->OUT->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->Balance->CurrentValue = $this->Balance->Total;
            $this->Balance->ViewValue = $this->Balance->CurrentValue;
            $this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, $this->Balance->formatPattern());
            $this->Balance->HrefValue = ""; // Clear href value
            $this->IN->CurrentValue = $this->IN->Total;
            $this->IN->ViewValue = $this->IN->CurrentValue;
            $this->IN->ViewValue = FormatNumber($this->IN->ViewValue, $this->IN->formatPattern());
            $this->IN->HrefValue = ""; // Clear href value
            $this->OUT->CurrentValue = $this->OUT->Total;
            $this->OUT->ViewValue = $this->OUT->CurrentValue;
            $this->OUT->ViewValue = FormatNumber($this->OUT->ViewValue, $this->OUT->formatPattern());
            $this->OUT->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->Balance);
                    $doc->exportCaption($this->IN);
                    $doc->exportCaption($this->OUT);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->tmp_lot);
                    $doc->exportCaption($this->product_n);
                    $doc->exportCaption($this->process_type);
                    $doc->exportCaption($this->gcode);
                    $doc->exportCaption($this->avg_yield);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->Balance);
                    $doc->exportCaption($this->IN);
                    $doc->exportCaption($this->OUT);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->tmp_lot);
                    $doc->exportCaption($this->product_n);
                    $doc->exportCaption($this->process_type);
                    $doc->exportCaption($this->gcode);
                    $doc->exportCaption($this->avg_yield);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->Balance);
                        $doc->exportField($this->IN);
                        $doc->exportField($this->OUT);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->status);
                        $doc->exportField($this->tmp_lot);
                        $doc->exportField($this->product_n);
                        $doc->exportField($this->process_type);
                        $doc->exportField($this->gcode);
                        $doc->exportField($this->avg_yield);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->Balance);
                        $doc->exportField($this->IN);
                        $doc->exportField($this->OUT);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->status);
                        $doc->exportField($this->tmp_lot);
                        $doc->exportField($this->product_n);
                        $doc->exportField($this->process_type);
                        $doc->exportField($this->gcode);
                        $doc->exportField($this->avg_yield);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->dated, '');
                $doc->exportAggregate($this->product, '');
                $doc->exportAggregate($this->product_code, '');
                $doc->exportAggregate($this->godown, '');
                $doc->exportAggregate($this->Balance, 'TOTAL');
                $doc->exportAggregate($this->IN, 'TOTAL');
                $doc->exportAggregate($this->OUT, 'TOTAL');
                $doc->exportAggregate($this->packets, '');
                $doc->exportAggregate($this->packing_type, '');
                $doc->exportAggregate($this->lot_no, '');
                $doc->exportAggregate($this->remarks, '');
                $doc->exportAggregate($this->status, '');
                $doc->exportAggregate($this->tmp_lot, '');
                $doc->exportAggregate($this->product_n, '');
                $doc->exportAggregate($this->process_type, '');
                $doc->exportAggregate($this->gcode, '');
                $doc->exportAggregate($this->avg_yield, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
