<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PackingListNoSearch extends PackingListNo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PackingListNoSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "packinglistnosearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->buyer_po->setVisibility();
        $this->roll_no->setVisibility();
        $this->qty->setVisibility();
        $this->pl_no->setVisibility();
        $this->_barcode->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->design_id->setVisibility();
        $this->size_buyer->setVisibility();
        $this->buyers_id->setVisibility();
        $this->po->setVisibility();
        $this->despatch_week->setVisibility();
        $this->sqm->setVisibility();
        $this->sqm_a->setVisibility();
        $this->current_works->setVisibility();
        $this->id->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->po_price->Visible = false;
        $this->po_discount->Visible = false;
        $this->po_currency->Visible = false;
        $this->buyer_uid->Visible = false;
        $this->buyer_loc->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'packing_list_no';
        $this->TableName = 'packing_list_no';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (packing_list_no)
        if (!isset($GLOBALS["packing_list_no"]) || $GLOBALS["packing_list_no"]::class == PROJECT_NAMESPACE . "packing_list_no") {
            $GLOBALS["packing_list_no"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'packing_list_no');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "packinglistnoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->current_works);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "packinglistnolist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->buyer_po); // buyer_po
        $this->buildSearchUrl($srchUrl, $this->roll_no); // roll_no
        $this->buildSearchUrl($srchUrl, $this->qty); // qty
        $this->buildSearchUrl($srchUrl, $this->pl_no); // pl_no
        $this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
        $this->buildSearchUrl($srchUrl, $this->buyer_ref); // buyer_ref
        $this->buildSearchUrl($srchUrl, $this->design_id); // design_id
        $this->buildSearchUrl($srchUrl, $this->size_buyer); // size_buyer
        $this->buildSearchUrl($srchUrl, $this->buyers_id); // buyers_id
        $this->buildSearchUrl($srchUrl, $this->po); // po
        $this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->sqm_a); // sqm_a
        $this->buildSearchUrl($srchUrl, $this->current_works); // current_works
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->buyer_loc); // buyer_loc
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // buyer_po
        if ($this->buyer_po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // roll_no
        if ($this->roll_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty
        if ($this->qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pl_no
        if ($this->pl_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_ref
        if ($this->buyer_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design_id
        if ($this->design_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_buyer
        if ($this->size_buyer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyers_id
        if ($this->buyers_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // despatch_week
        if ($this->despatch_week->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm_a
        if ($this->sqm_a->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // current_works
        if ($this->current_works->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_loc
        if ($this->buyer_loc->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // buyer_po
        $this->buyer_po->RowCssClass = "row";

        // roll_no
        $this->roll_no->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // pl_no
        $this->pl_no->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // buyer_ref
        $this->buyer_ref->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // size_buyer
        $this->size_buyer->RowCssClass = "row";

        // buyers_id
        $this->buyers_id->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // sqm_a
        $this->sqm_a->RowCssClass = "row";

        // current_works
        $this->current_works->RowCssClass = "row";

        // id
        $this->id->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // po_price
        $this->po_price->RowCssClass = "row";

        // po_discount
        $this->po_discount->RowCssClass = "row";

        // po_currency
        $this->po_currency->RowCssClass = "row";

        // buyer_uid
        $this->buyer_uid->RowCssClass = "row";

        // buyer_loc
        $this->buyer_loc->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;
            $this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, $this->roll_no->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
            $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
            $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

            // buyer_ref
            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // sqm_a
            $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // buyer_loc
            $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

            // buyer_po
            $this->buyer_po->HrefValue = "";
            $this->buyer_po->TooltipValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // buyer_ref
            $this->buyer_ref->HrefValue = "";
            $this->buyer_ref->TooltipValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . $this->design_id->CurrentValue; // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // size_buyer
            $this->size_buyer->HrefValue = "";
            $this->size_buyer->TooltipValue = "";

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";
            $this->sqm_a->TooltipValue = "";

            // current_works
            $this->current_works->HrefValue = "";
            $this->current_works->TooltipValue = "";

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // buyer_loc
            $this->buyer_loc->HrefValue = "";
            $this->buyer_loc->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // buyer_po
            $this->buyer_po->setupEditAttributes();
            if (!$this->buyer_po->Raw) {
                $this->buyer_po->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_po->AdvancedSearch->SearchValue);
            }
            $this->buyer_po->EditValue = HtmlEncode($this->buyer_po->AdvancedSearch->SearchValue);
            $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

            // roll_no
            $this->roll_no->setupEditAttributes();
            $this->roll_no->EditValue = $this->roll_no->AdvancedSearch->SearchValue;
            $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());
            $this->roll_no->setupEditAttributes();
            $this->roll_no->EditValue2 = $this->roll_no->AdvancedSearch->SearchValue2;
            $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->AdvancedSearch->SearchValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

            // pl_no
            $this->pl_no->setupEditAttributes();
            $this->pl_no->EditValue = $this->pl_no->AdvancedSearch->SearchValue;
            $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = $this->_barcode->AdvancedSearch->SearchValue;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue2 = $this->_barcode->AdvancedSearch->SearchValue2;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            $this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
            $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

            // design_id
            $this->design_id->setupEditAttributes();
            $curVal = trim(strval($this->design_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->lookupCacheOption($curVal);
            } else {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->Lookup !== null && is_array($this->design_id->lookupOptions()) && count($this->design_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->design_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->design_id->EditValue = array_values($this->design_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->design_id->AdvancedSearch->SearchValue, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->design_id->EditValue = $arwrk;
            }
            $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

            // size_buyer
            $this->size_buyer->setupEditAttributes();
            if (!$this->size_buyer->Raw) {
                $this->size_buyer->AdvancedSearch->SearchValue = HtmlDecode($this->size_buyer->AdvancedSearch->SearchValue);
            }
            $this->size_buyer->EditValue = HtmlEncode($this->size_buyer->AdvancedSearch->SearchValue);
            $this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $curVal = trim(strval($this->buyers_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            } else {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->Lookup !== null && is_array($this->buyers_id->lookupOptions()) && count($this->buyers_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyers_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyers_id->EditValue = array_values($this->buyers_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyers_id->AdvancedSearch->SearchValue, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyers_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyers_id->EditValue = $arwrk;
            }
            $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            $this->po->setupEditAttributes();
            $this->po->EditValue2 = $this->po->AdvancedSearch->SearchValue2;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->AdvancedSearch->SearchValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // sqm_a
            $this->sqm_a->setupEditAttributes();
            $this->sqm_a->EditValue = $this->sqm_a->AdvancedSearch->SearchValue;
            $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
            } else {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== null && is_array($this->current_works->lookupOptions()) && count($this->current_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->current_works->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->current_works->EditValue = array_values($this->current_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->current_works->AdvancedSearch->SearchValue, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->current_works->EditValue = $arwrk;
            }
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // buyer_loc
            $this->buyer_loc->setupEditAttributes();
            if (!$this->buyer_loc->Raw) {
                $this->buyer_loc->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_loc->AdvancedSearch->SearchValue);
            }
            $this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->AdvancedSearch->SearchValue);
            $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->roll_no->AdvancedSearch->SearchValue)) {
            $this->roll_no->addErrorMessage($this->roll_no->getErrorMessage(false));
        }
        if (!CheckInteger($this->roll_no->AdvancedSearch->SearchValue2)) {
            $this->roll_no->addErrorMessage($this->roll_no->getErrorMessage(false));
        }
        if (!CheckInteger($this->qty->AdvancedSearch->SearchValue)) {
            $this->qty->addErrorMessage($this->qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->pl_no->AdvancedSearch->SearchValue)) {
            $this->pl_no->addErrorMessage($this->pl_no->getErrorMessage(false));
        }
        if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue)) {
            $this->_barcode->addErrorMessage($this->_barcode->getErrorMessage(false));
        }
        if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue2)) {
            $this->_barcode->addErrorMessage($this->_barcode->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm_a->AdvancedSearch->SearchValue)) {
            $this->sqm_a->addErrorMessage($this->sqm_a->getErrorMessage(false));
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->buyer_po->AdvancedSearch->load();
        $this->roll_no->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->design_id->AdvancedSearch->load();
        $this->size_buyer->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->despatch_week->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->sqm_a->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->id->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->buyer_loc->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("packinglistnolist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyers_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
