<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PackingListList extends PackingList
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PackingListList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fpacking_listlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "packinglistlist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->pl_no->setVisibility();
        $this->buyers_id->setVisibility();
        $this->_barcode->setVisibility();
        $this->roll_no->setVisibility();
        $this->no_of_bales->setVisibility();
        $this->design->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->buyer_code->setVisibility();
        $this->buyer_po->setVisibility();
        $this->quantity->setVisibility();
        $this->size->setVisibility();
        $this->sqm->setVisibility();
        $this->sqm_a->setVisibility();
        $this->price->setVisibility();
        $this->price_a->setVisibility();
        $this->discount->setVisibility();
        $this->amount->setVisibility();
        $this->currency->setVisibility();
        $this->composition->setVisibility();
        $this->hsn->setVisibility();
        $this->gst->setVisibility();
        $this->price_exchange->setVisibility();
        $this->price_exchange_a->setVisibility();
        $this->amount_exchange->setVisibility();
        $this->cbm->setVisibility();
        $this->weight->setVisibility();
        $this->partner_other_ref->setVisibility();
        $this->roll_no_start->Visible = false;
        $this->roll_no_end->Visible = false;
        $this->buyer_loc->setVisibility();
        $this->po->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'packing_list';
        $this->TableName = 'packing_list';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (packing_list)
        if (!isset($GLOBALS["packing_list"]) || $GLOBALS["packing_list"]::class == PROJECT_NAMESPACE . "packing_list") {
            $GLOBALS["packing_list"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "packinglistadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "packinglistdelete";
        $this->MultiUpdateUrl = "packinglistupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'packing_list');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "packinglistview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "20,50,100,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->design);
        $this->setupLookupOptions($this->buyer_ref);
        $this->setupLookupOptions($this->currency);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fpacking_listgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fpacking_listsrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->pl_no->AdvancedSearch->toJson(), ","); // Field pl_no
        $filterList = Concat($filterList, $this->buyers_id->AdvancedSearch->toJson(), ","); // Field buyers_id
        $filterList = Concat($filterList, $this->_barcode->AdvancedSearch->toJson(), ","); // Field barcode
        $filterList = Concat($filterList, $this->no_of_bales->AdvancedSearch->toJson(), ","); // Field no_of_bales
        $filterList = Concat($filterList, $this->buyer_ref->AdvancedSearch->toJson(), ","); // Field buyer_ref
        $filterList = Concat($filterList, $this->buyer_code->AdvancedSearch->toJson(), ","); // Field buyer_code
        $filterList = Concat($filterList, $this->buyer_po->AdvancedSearch->toJson(), ","); // Field buyer_po
        $filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
        $filterList = Concat($filterList, $this->size->AdvancedSearch->toJson(), ","); // Field size
        $filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
        $filterList = Concat($filterList, $this->sqm_a->AdvancedSearch->toJson(), ","); // Field sqm_a
        $filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
        $filterList = Concat($filterList, $this->price_a->AdvancedSearch->toJson(), ","); // Field price_a
        $filterList = Concat($filterList, $this->discount->AdvancedSearch->toJson(), ","); // Field discount
        $filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
        $filterList = Concat($filterList, $this->currency->AdvancedSearch->toJson(), ","); // Field currency
        $filterList = Concat($filterList, $this->composition->AdvancedSearch->toJson(), ","); // Field composition
        $filterList = Concat($filterList, $this->hsn->AdvancedSearch->toJson(), ","); // Field hsn
        $filterList = Concat($filterList, $this->gst->AdvancedSearch->toJson(), ","); // Field gst
        $filterList = Concat($filterList, $this->price_exchange->AdvancedSearch->toJson(), ","); // Field price_exchange
        $filterList = Concat($filterList, $this->price_exchange_a->AdvancedSearch->toJson(), ","); // Field price_exchange_a
        $filterList = Concat($filterList, $this->amount_exchange->AdvancedSearch->toJson(), ","); // Field amount_exchange
        $filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
        $filterList = Concat($filterList, $this->weight->AdvancedSearch->toJson(), ","); // Field weight
        $filterList = Concat($filterList, $this->partner_other_ref->AdvancedSearch->toJson(), ","); // Field partner_other_ref
        $filterList = Concat($filterList, $this->buyer_loc->AdvancedSearch->toJson(), ","); // Field buyer_loc
        $filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fpacking_listsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field pl_no
        $this->pl_no->AdvancedSearch->SearchValue = @$filter["x_pl_no"];
        $this->pl_no->AdvancedSearch->SearchOperator = @$filter["z_pl_no"];
        $this->pl_no->AdvancedSearch->SearchCondition = @$filter["v_pl_no"];
        $this->pl_no->AdvancedSearch->SearchValue2 = @$filter["y_pl_no"];
        $this->pl_no->AdvancedSearch->SearchOperator2 = @$filter["w_pl_no"];
        $this->pl_no->AdvancedSearch->save();

        // Field buyers_id
        $this->buyers_id->AdvancedSearch->SearchValue = @$filter["x_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchOperator = @$filter["z_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchCondition = @$filter["v_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchValue2 = @$filter["y_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyers_id"];
        $this->buyers_id->AdvancedSearch->save();

        // Field barcode
        $this->_barcode->AdvancedSearch->SearchValue = @$filter["x__barcode"];
        $this->_barcode->AdvancedSearch->SearchOperator = @$filter["z__barcode"];
        $this->_barcode->AdvancedSearch->SearchCondition = @$filter["v__barcode"];
        $this->_barcode->AdvancedSearch->SearchValue2 = @$filter["y__barcode"];
        $this->_barcode->AdvancedSearch->SearchOperator2 = @$filter["w__barcode"];
        $this->_barcode->AdvancedSearch->save();

        // Field no_of_bales
        $this->no_of_bales->AdvancedSearch->SearchValue = @$filter["x_no_of_bales"];
        $this->no_of_bales->AdvancedSearch->SearchOperator = @$filter["z_no_of_bales"];
        $this->no_of_bales->AdvancedSearch->SearchCondition = @$filter["v_no_of_bales"];
        $this->no_of_bales->AdvancedSearch->SearchValue2 = @$filter["y_no_of_bales"];
        $this->no_of_bales->AdvancedSearch->SearchOperator2 = @$filter["w_no_of_bales"];
        $this->no_of_bales->AdvancedSearch->save();

        // Field buyer_ref
        $this->buyer_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->save();

        // Field buyer_code
        $this->buyer_code->AdvancedSearch->SearchValue = @$filter["x_buyer_code"];
        $this->buyer_code->AdvancedSearch->SearchOperator = @$filter["z_buyer_code"];
        $this->buyer_code->AdvancedSearch->SearchCondition = @$filter["v_buyer_code"];
        $this->buyer_code->AdvancedSearch->SearchValue2 = @$filter["y_buyer_code"];
        $this->buyer_code->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_code"];
        $this->buyer_code->AdvancedSearch->save();

        // Field buyer_po
        $this->buyer_po->AdvancedSearch->SearchValue = @$filter["x_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchOperator = @$filter["z_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchCondition = @$filter["v_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchValue2 = @$filter["y_buyer_po"];
        $this->buyer_po->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_po"];
        $this->buyer_po->AdvancedSearch->save();

        // Field quantity
        $this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
        $this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
        $this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
        $this->quantity->AdvancedSearch->save();

        // Field size
        $this->size->AdvancedSearch->SearchValue = @$filter["x_size"];
        $this->size->AdvancedSearch->SearchOperator = @$filter["z_size"];
        $this->size->AdvancedSearch->SearchCondition = @$filter["v_size"];
        $this->size->AdvancedSearch->SearchValue2 = @$filter["y_size"];
        $this->size->AdvancedSearch->SearchOperator2 = @$filter["w_size"];
        $this->size->AdvancedSearch->save();

        // Field sqm
        $this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
        $this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
        $this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
        $this->sqm->AdvancedSearch->save();

        // Field sqm_a
        $this->sqm_a->AdvancedSearch->SearchValue = @$filter["x_sqm_a"];
        $this->sqm_a->AdvancedSearch->SearchOperator = @$filter["z_sqm_a"];
        $this->sqm_a->AdvancedSearch->SearchCondition = @$filter["v_sqm_a"];
        $this->sqm_a->AdvancedSearch->SearchValue2 = @$filter["y_sqm_a"];
        $this->sqm_a->AdvancedSearch->SearchOperator2 = @$filter["w_sqm_a"];
        $this->sqm_a->AdvancedSearch->save();

        // Field price
        $this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
        $this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
        $this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
        $this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
        $this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
        $this->price->AdvancedSearch->save();

        // Field price_a
        $this->price_a->AdvancedSearch->SearchValue = @$filter["x_price_a"];
        $this->price_a->AdvancedSearch->SearchOperator = @$filter["z_price_a"];
        $this->price_a->AdvancedSearch->SearchCondition = @$filter["v_price_a"];
        $this->price_a->AdvancedSearch->SearchValue2 = @$filter["y_price_a"];
        $this->price_a->AdvancedSearch->SearchOperator2 = @$filter["w_price_a"];
        $this->price_a->AdvancedSearch->save();

        // Field discount
        $this->discount->AdvancedSearch->SearchValue = @$filter["x_discount"];
        $this->discount->AdvancedSearch->SearchOperator = @$filter["z_discount"];
        $this->discount->AdvancedSearch->SearchCondition = @$filter["v_discount"];
        $this->discount->AdvancedSearch->SearchValue2 = @$filter["y_discount"];
        $this->discount->AdvancedSearch->SearchOperator2 = @$filter["w_discount"];
        $this->discount->AdvancedSearch->save();

        // Field amount
        $this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
        $this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
        $this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
        $this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
        $this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
        $this->amount->AdvancedSearch->save();

        // Field currency
        $this->currency->AdvancedSearch->SearchValue = @$filter["x_currency"];
        $this->currency->AdvancedSearch->SearchOperator = @$filter["z_currency"];
        $this->currency->AdvancedSearch->SearchCondition = @$filter["v_currency"];
        $this->currency->AdvancedSearch->SearchValue2 = @$filter["y_currency"];
        $this->currency->AdvancedSearch->SearchOperator2 = @$filter["w_currency"];
        $this->currency->AdvancedSearch->save();

        // Field composition
        $this->composition->AdvancedSearch->SearchValue = @$filter["x_composition"];
        $this->composition->AdvancedSearch->SearchOperator = @$filter["z_composition"];
        $this->composition->AdvancedSearch->SearchCondition = @$filter["v_composition"];
        $this->composition->AdvancedSearch->SearchValue2 = @$filter["y_composition"];
        $this->composition->AdvancedSearch->SearchOperator2 = @$filter["w_composition"];
        $this->composition->AdvancedSearch->save();

        // Field hsn
        $this->hsn->AdvancedSearch->SearchValue = @$filter["x_hsn"];
        $this->hsn->AdvancedSearch->SearchOperator = @$filter["z_hsn"];
        $this->hsn->AdvancedSearch->SearchCondition = @$filter["v_hsn"];
        $this->hsn->AdvancedSearch->SearchValue2 = @$filter["y_hsn"];
        $this->hsn->AdvancedSearch->SearchOperator2 = @$filter["w_hsn"];
        $this->hsn->AdvancedSearch->save();

        // Field gst
        $this->gst->AdvancedSearch->SearchValue = @$filter["x_gst"];
        $this->gst->AdvancedSearch->SearchOperator = @$filter["z_gst"];
        $this->gst->AdvancedSearch->SearchCondition = @$filter["v_gst"];
        $this->gst->AdvancedSearch->SearchValue2 = @$filter["y_gst"];
        $this->gst->AdvancedSearch->SearchOperator2 = @$filter["w_gst"];
        $this->gst->AdvancedSearch->save();

        // Field price_exchange
        $this->price_exchange->AdvancedSearch->SearchValue = @$filter["x_price_exchange"];
        $this->price_exchange->AdvancedSearch->SearchOperator = @$filter["z_price_exchange"];
        $this->price_exchange->AdvancedSearch->SearchCondition = @$filter["v_price_exchange"];
        $this->price_exchange->AdvancedSearch->SearchValue2 = @$filter["y_price_exchange"];
        $this->price_exchange->AdvancedSearch->SearchOperator2 = @$filter["w_price_exchange"];
        $this->price_exchange->AdvancedSearch->save();

        // Field price_exchange_a
        $this->price_exchange_a->AdvancedSearch->SearchValue = @$filter["x_price_exchange_a"];
        $this->price_exchange_a->AdvancedSearch->SearchOperator = @$filter["z_price_exchange_a"];
        $this->price_exchange_a->AdvancedSearch->SearchCondition = @$filter["v_price_exchange_a"];
        $this->price_exchange_a->AdvancedSearch->SearchValue2 = @$filter["y_price_exchange_a"];
        $this->price_exchange_a->AdvancedSearch->SearchOperator2 = @$filter["w_price_exchange_a"];
        $this->price_exchange_a->AdvancedSearch->save();

        // Field amount_exchange
        $this->amount_exchange->AdvancedSearch->SearchValue = @$filter["x_amount_exchange"];
        $this->amount_exchange->AdvancedSearch->SearchOperator = @$filter["z_amount_exchange"];
        $this->amount_exchange->AdvancedSearch->SearchCondition = @$filter["v_amount_exchange"];
        $this->amount_exchange->AdvancedSearch->SearchValue2 = @$filter["y_amount_exchange"];
        $this->amount_exchange->AdvancedSearch->SearchOperator2 = @$filter["w_amount_exchange"];
        $this->amount_exchange->AdvancedSearch->save();

        // Field cbm
        $this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
        $this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
        $this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
        $this->cbm->AdvancedSearch->save();

        // Field weight
        $this->weight->AdvancedSearch->SearchValue = @$filter["x_weight"];
        $this->weight->AdvancedSearch->SearchOperator = @$filter["z_weight"];
        $this->weight->AdvancedSearch->SearchCondition = @$filter["v_weight"];
        $this->weight->AdvancedSearch->SearchValue2 = @$filter["y_weight"];
        $this->weight->AdvancedSearch->SearchOperator2 = @$filter["w_weight"];
        $this->weight->AdvancedSearch->save();

        // Field partner_other_ref
        $this->partner_other_ref->AdvancedSearch->SearchValue = @$filter["x_partner_other_ref"];
        $this->partner_other_ref->AdvancedSearch->SearchOperator = @$filter["z_partner_other_ref"];
        $this->partner_other_ref->AdvancedSearch->SearchCondition = @$filter["v_partner_other_ref"];
        $this->partner_other_ref->AdvancedSearch->SearchValue2 = @$filter["y_partner_other_ref"];
        $this->partner_other_ref->AdvancedSearch->SearchOperator2 = @$filter["w_partner_other_ref"];
        $this->partner_other_ref->AdvancedSearch->save();

        // Field buyer_loc
        $this->buyer_loc->AdvancedSearch->SearchValue = @$filter["x_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchOperator = @$filter["z_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchCondition = @$filter["v_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchValue2 = @$filter["y_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_loc"];
        $this->buyer_loc->AdvancedSearch->save();

        // Field po
        $this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
        $this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
        $this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
        $this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
        $this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
        $this->po->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->pl_no, $default, false); // pl_no
        $this->buildSearchSql($where, $this->buyers_id, $default, false); // buyers_id
        $this->buildSearchSql($where, $this->_barcode, $default, false); // barcode
        $this->buildSearchSql($where, $this->no_of_bales, $default, false); // no_of_bales
        $this->buildSearchSql($where, $this->buyer_ref, $default, false); // buyer_ref
        $this->buildSearchSql($where, $this->buyer_code, $default, false); // buyer_code
        $this->buildSearchSql($where, $this->buyer_po, $default, false); // buyer_po
        $this->buildSearchSql($where, $this->quantity, $default, false); // quantity
        $this->buildSearchSql($where, $this->size, $default, false); // size
        $this->buildSearchSql($where, $this->sqm, $default, false); // sqm
        $this->buildSearchSql($where, $this->sqm_a, $default, false); // sqm_a
        $this->buildSearchSql($where, $this->price, $default, false); // price
        $this->buildSearchSql($where, $this->price_a, $default, false); // price_a
        $this->buildSearchSql($where, $this->discount, $default, false); // discount
        $this->buildSearchSql($where, $this->amount, $default, false); // amount
        $this->buildSearchSql($where, $this->currency, $default, false); // currency
        $this->buildSearchSql($where, $this->composition, $default, false); // composition
        $this->buildSearchSql($where, $this->hsn, $default, false); // hsn
        $this->buildSearchSql($where, $this->gst, $default, false); // gst
        $this->buildSearchSql($where, $this->price_exchange, $default, false); // price_exchange
        $this->buildSearchSql($where, $this->price_exchange_a, $default, false); // price_exchange_a
        $this->buildSearchSql($where, $this->amount_exchange, $default, false); // amount_exchange
        $this->buildSearchSql($where, $this->cbm, $default, false); // cbm
        $this->buildSearchSql($where, $this->weight, $default, false); // weight
        $this->buildSearchSql($where, $this->partner_other_ref, $default, false); // partner_other_ref
        $this->buildSearchSql($where, $this->buyer_loc, $default, false); // buyer_loc
        $this->buildSearchSql($where, $this->po, $default, false); // po

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->pl_no->AdvancedSearch->save(); // pl_no
            $this->buyers_id->AdvancedSearch->save(); // buyers_id
            $this->_barcode->AdvancedSearch->save(); // barcode
            $this->no_of_bales->AdvancedSearch->save(); // no_of_bales
            $this->buyer_ref->AdvancedSearch->save(); // buyer_ref
            $this->buyer_code->AdvancedSearch->save(); // buyer_code
            $this->buyer_po->AdvancedSearch->save(); // buyer_po
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->size->AdvancedSearch->save(); // size
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->sqm_a->AdvancedSearch->save(); // sqm_a
            $this->price->AdvancedSearch->save(); // price
            $this->price_a->AdvancedSearch->save(); // price_a
            $this->discount->AdvancedSearch->save(); // discount
            $this->amount->AdvancedSearch->save(); // amount
            $this->currency->AdvancedSearch->save(); // currency
            $this->composition->AdvancedSearch->save(); // composition
            $this->hsn->AdvancedSearch->save(); // hsn
            $this->gst->AdvancedSearch->save(); // gst
            $this->price_exchange->AdvancedSearch->save(); // price_exchange
            $this->price_exchange_a->AdvancedSearch->save(); // price_exchange_a
            $this->amount_exchange->AdvancedSearch->save(); // amount_exchange
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->weight->AdvancedSearch->save(); // weight
            $this->partner_other_ref->AdvancedSearch->save(); // partner_other_ref
            $this->buyer_loc->AdvancedSearch->save(); // buyer_loc
            $this->po->AdvancedSearch->save(); // po

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->pl_no->AdvancedSearch->save(); // pl_no
            $this->buyers_id->AdvancedSearch->save(); // buyers_id
            $this->_barcode->AdvancedSearch->save(); // barcode
            $this->no_of_bales->AdvancedSearch->save(); // no_of_bales
            $this->buyer_ref->AdvancedSearch->save(); // buyer_ref
            $this->buyer_code->AdvancedSearch->save(); // buyer_code
            $this->buyer_po->AdvancedSearch->save(); // buyer_po
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->size->AdvancedSearch->save(); // size
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->sqm_a->AdvancedSearch->save(); // sqm_a
            $this->price->AdvancedSearch->save(); // price
            $this->price_a->AdvancedSearch->save(); // price_a
            $this->discount->AdvancedSearch->save(); // discount
            $this->amount->AdvancedSearch->save(); // amount
            $this->currency->AdvancedSearch->save(); // currency
            $this->composition->AdvancedSearch->save(); // composition
            $this->hsn->AdvancedSearch->save(); // hsn
            $this->gst->AdvancedSearch->save(); // gst
            $this->price_exchange->AdvancedSearch->save(); // price_exchange
            $this->price_exchange_a->AdvancedSearch->save(); // price_exchange_a
            $this->amount_exchange->AdvancedSearch->save(); // amount_exchange
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->weight->AdvancedSearch->save(); // weight
            $this->partner_other_ref->AdvancedSearch->save(); // partner_other_ref
            $this->buyer_loc->AdvancedSearch->save(); // buyer_loc
            $this->po->AdvancedSearch->save(); // po
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_no
        $filter = $this->queryBuilderWhere("pl_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyers_id
        $filter = $this->queryBuilderWhere("buyers_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyers_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyers_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field barcode
        $filter = $this->queryBuilderWhere("barcode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_barcode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_barcode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field no_of_bales
        $filter = $this->queryBuilderWhere("no_of_bales");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->no_of_bales, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->no_of_bales->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_ref
        $filter = $this->queryBuilderWhere("buyer_ref");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_ref, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_ref->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_code
        $filter = $this->queryBuilderWhere("buyer_code");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_code, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_code->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_po
        $filter = $this->queryBuilderWhere("buyer_po");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_po, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_po->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field quantity
        $filter = $this->queryBuilderWhere("quantity");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->quantity, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->quantity->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field size
        $filter = $this->queryBuilderWhere("size");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->size, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->size->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sqm
        $filter = $this->queryBuilderWhere("sqm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sqm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sqm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sqm_a
        $filter = $this->queryBuilderWhere("sqm_a");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sqm_a, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sqm_a->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field price
        $filter = $this->queryBuilderWhere("price");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->price, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->price->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field price_a
        $filter = $this->queryBuilderWhere("price_a");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->price_a, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->price_a->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field discount
        $filter = $this->queryBuilderWhere("discount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->discount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->discount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field amount
        $filter = $this->queryBuilderWhere("amount");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->amount, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->amount->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field currency
        $filter = $this->queryBuilderWhere("currency");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->currency, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->currency->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field composition
        $filter = $this->queryBuilderWhere("composition");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->composition, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->composition->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field hsn
        $filter = $this->queryBuilderWhere("hsn");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->hsn, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->hsn->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field gst
        $filter = $this->queryBuilderWhere("gst");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->gst, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->gst->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field price_exchange
        $filter = $this->queryBuilderWhere("price_exchange");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->price_exchange, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->price_exchange->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field price_exchange_a
        $filter = $this->queryBuilderWhere("price_exchange_a");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->price_exchange_a, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->price_exchange_a->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field amount_exchange
        $filter = $this->queryBuilderWhere("amount_exchange");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->amount_exchange, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->amount_exchange->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cbm
        $filter = $this->queryBuilderWhere("cbm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cbm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cbm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field weight
        $filter = $this->queryBuilderWhere("weight");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->weight, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->weight->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field partner_other_ref
        $filter = $this->queryBuilderWhere("partner_other_ref");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->partner_other_ref, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->partner_other_ref->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_loc
        $filter = $this->queryBuilderWhere("buyer_loc");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_loc, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_loc->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po
        $filter = $this->queryBuilderWhere("po");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->buyers_id;
        $searchFlds[] = &$this->design;
        $searchFlds[] = &$this->buyer_ref;
        $searchFlds[] = &$this->buyer_code;
        $searchFlds[] = &$this->buyer_po;
        $searchFlds[] = &$this->size;
        $searchFlds[] = &$this->composition;
        $searchFlds[] = &$this->hsn;
        $searchFlds[] = &$this->buyer_loc;
        $searchFlds[] = &$this->po;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyers_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_barcode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->no_of_bales->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_ref->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_po->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->size->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sqm_a->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->price->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->price_a->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->discount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->amount->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->currency->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->composition->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->hsn->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->gst->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->price_exchange->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->price_exchange_a->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->amount_exchange->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cbm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->weight->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->partner_other_ref->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_loc->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->pl_no->AdvancedSearch->unsetSession();
        $this->buyers_id->AdvancedSearch->unsetSession();
        $this->_barcode->AdvancedSearch->unsetSession();
        $this->no_of_bales->AdvancedSearch->unsetSession();
        $this->buyer_ref->AdvancedSearch->unsetSession();
        $this->buyer_code->AdvancedSearch->unsetSession();
        $this->buyer_po->AdvancedSearch->unsetSession();
        $this->quantity->AdvancedSearch->unsetSession();
        $this->size->AdvancedSearch->unsetSession();
        $this->sqm->AdvancedSearch->unsetSession();
        $this->sqm_a->AdvancedSearch->unsetSession();
        $this->price->AdvancedSearch->unsetSession();
        $this->price_a->AdvancedSearch->unsetSession();
        $this->discount->AdvancedSearch->unsetSession();
        $this->amount->AdvancedSearch->unsetSession();
        $this->currency->AdvancedSearch->unsetSession();
        $this->composition->AdvancedSearch->unsetSession();
        $this->hsn->AdvancedSearch->unsetSession();
        $this->gst->AdvancedSearch->unsetSession();
        $this->price_exchange->AdvancedSearch->unsetSession();
        $this->price_exchange_a->AdvancedSearch->unsetSession();
        $this->amount_exchange->AdvancedSearch->unsetSession();
        $this->cbm->AdvancedSearch->unsetSession();
        $this->weight->AdvancedSearch->unsetSession();
        $this->partner_other_ref->AdvancedSearch->unsetSession();
        $this->buyer_loc->AdvancedSearch->unsetSession();
        $this->po->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->no_of_bales->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->buyer_code->AdvancedSearch->load();
        $this->buyer_po->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->size->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->sqm_a->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->price_a->AdvancedSearch->load();
        $this->discount->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->composition->AdvancedSearch->load();
        $this->hsn->AdvancedSearch->load();
        $this->gst->AdvancedSearch->load();
        $this->price_exchange->AdvancedSearch->load();
        $this->price_exchange_a->AdvancedSearch->load();
        $this->amount_exchange->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->weight->AdvancedSearch->load();
        $this->partner_other_ref->AdvancedSearch->load();
        $this->buyer_loc->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " ASC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
            $defaultSortList = ($this->id->VirtualExpression != "" ? $this->id->VirtualExpression : $this->id->Expression) . " ASC"; // Set up default sort
            if ($this->getSessionOrderByList() == "" && $defaultSortList != "") {
                $this->setSessionOrderByList($defaultSortList);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->pl_no, $ctrl); // pl_no
            $this->updateSort($this->buyers_id, $ctrl); // buyers_id
            $this->updateSort($this->_barcode, $ctrl); // barcode
            $this->updateSort($this->roll_no, $ctrl); // roll_no
            $this->updateSort($this->no_of_bales, $ctrl); // no_of_bales
            $this->updateSort($this->design, $ctrl); // design
            $this->updateSort($this->buyer_ref, $ctrl); // buyer_ref
            $this->updateSort($this->buyer_code, $ctrl); // buyer_code
            $this->updateSort($this->buyer_po, $ctrl); // buyer_po
            $this->updateSort($this->quantity, $ctrl); // quantity
            $this->updateSort($this->size, $ctrl); // size
            $this->updateSort($this->sqm, $ctrl); // sqm
            $this->updateSort($this->sqm_a, $ctrl); // sqm_a
            $this->updateSort($this->price, $ctrl); // price
            $this->updateSort($this->price_a, $ctrl); // price_a
            $this->updateSort($this->discount, $ctrl); // discount
            $this->updateSort($this->amount, $ctrl); // amount
            $this->updateSort($this->currency, $ctrl); // currency
            $this->updateSort($this->composition, $ctrl); // composition
            $this->updateSort($this->hsn, $ctrl); // hsn
            $this->updateSort($this->gst, $ctrl); // gst
            $this->updateSort($this->price_exchange, $ctrl); // price_exchange
            $this->updateSort($this->price_exchange_a, $ctrl); // price_exchange_a
            $this->updateSort($this->amount_exchange, $ctrl); // amount_exchange
            $this->updateSort($this->cbm, $ctrl); // cbm
            $this->updateSort($this->weight, $ctrl); // weight
            $this->updateSort($this->partner_other_ref, $ctrl); // partner_other_ref
            $this->updateSort($this->buyer_loc, $ctrl); // buyer_loc
            $this->updateSort($this->po, $ctrl); // po
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->setSessionOrderByList($orderBy);
                $this->id->setSort("");
                $this->pl_no->setSort("");
                $this->buyers_id->setSort("");
                $this->_barcode->setSort("");
                $this->roll_no->setSort("");
                $this->no_of_bales->setSort("");
                $this->design->setSort("");
                $this->buyer_ref->setSort("");
                $this->buyer_code->setSort("");
                $this->buyer_po->setSort("");
                $this->quantity->setSort("");
                $this->size->setSort("");
                $this->sqm->setSort("");
                $this->sqm_a->setSort("");
                $this->price->setSort("");
                $this->price_a->setSort("");
                $this->discount->setSort("");
                $this->amount->setSort("");
                $this->currency->setSort("");
                $this->composition->setSort("");
                $this->hsn->setSort("");
                $this->gst->setSort("");
                $this->price_exchange->setSort("");
                $this->price_exchange_a->setSort("");
                $this->amount_exchange->setSort("");
                $this->cbm->setSort("");
                $this->weight->setSort("");
                $this->partner_other_ref->setSort("");
                $this->roll_no_start->setSort("");
                $this->roll_no_end->setSort("");
                $this->buyer_loc->setSort("");
                $this->po->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = false;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"packing_list\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fpacking_listlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fpacking_listlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "pl_no");
            $this->createColumnOption($option, "buyers_id");
            $this->createColumnOption($option, "barcode");
            $this->createColumnOption($option, "roll_no");
            $this->createColumnOption($option, "no_of_bales");
            $this->createColumnOption($option, "design");
            $this->createColumnOption($option, "buyer_ref");
            $this->createColumnOption($option, "buyer_code");
            $this->createColumnOption($option, "buyer_po");
            $this->createColumnOption($option, "quantity");
            $this->createColumnOption($option, "size");
            $this->createColumnOption($option, "sqm");
            $this->createColumnOption($option, "sqm_a");
            $this->createColumnOption($option, "price");
            $this->createColumnOption($option, "price_a");
            $this->createColumnOption($option, "discount");
            $this->createColumnOption($option, "amount");
            $this->createColumnOption($option, "currency");
            $this->createColumnOption($option, "composition");
            $this->createColumnOption($option, "hsn");
            $this->createColumnOption($option, "gst");
            $this->createColumnOption($option, "price_exchange");
            $this->createColumnOption($option, "price_exchange_a");
            $this->createColumnOption($option, "amount_exchange");
            $this->createColumnOption($option, "cbm");
            $this->createColumnOption($option, "weight");
            $this->createColumnOption($option, "partner_other_ref");
            $this->createColumnOption($option, "buyer_loc");
            $this->createColumnOption($option, "po");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = false;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fpacking_listsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fpacking_listsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fpacking_listlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_packing_list", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_packing_list",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_no
        if ($this->pl_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_no->AdvancedSearch->SearchValue != "" || $this->pl_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyers_id
        if ($this->buyers_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyers_id->AdvancedSearch->SearchValue != "" || $this->buyers_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_barcode->AdvancedSearch->SearchValue != "" || $this->_barcode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // no_of_bales
        if ($this->no_of_bales->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->no_of_bales->AdvancedSearch->SearchValue != "" || $this->no_of_bales->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_ref
        if ($this->buyer_ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_ref->AdvancedSearch->SearchValue != "" || $this->buyer_ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_code
        if ($this->buyer_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_code->AdvancedSearch->SearchValue != "" || $this->buyer_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_po
        if ($this->buyer_po->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_po->AdvancedSearch->SearchValue != "" || $this->buyer_po->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity->AdvancedSearch->SearchValue != "" || $this->quantity->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // size
        if ($this->size->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->size->AdvancedSearch->SearchValue != "" || $this->size->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sqm->AdvancedSearch->SearchValue != "" || $this->sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sqm_a
        if ($this->sqm_a->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sqm_a->AdvancedSearch->SearchValue != "" || $this->sqm_a->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // price
        if ($this->price->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->price->AdvancedSearch->SearchValue != "" || $this->price->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // price_a
        if ($this->price_a->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->price_a->AdvancedSearch->SearchValue != "" || $this->price_a->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // discount
        if ($this->discount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->discount->AdvancedSearch->SearchValue != "" || $this->discount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->amount->AdvancedSearch->SearchValue != "" || $this->amount->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // currency
        if ($this->currency->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->currency->AdvancedSearch->SearchValue != "" || $this->currency->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // composition
        if ($this->composition->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->composition->AdvancedSearch->SearchValue != "" || $this->composition->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // hsn
        if ($this->hsn->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->hsn->AdvancedSearch->SearchValue != "" || $this->hsn->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // gst
        if ($this->gst->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->gst->AdvancedSearch->SearchValue != "" || $this->gst->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // price_exchange
        if ($this->price_exchange->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->price_exchange->AdvancedSearch->SearchValue != "" || $this->price_exchange->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // price_exchange_a
        if ($this->price_exchange_a->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->price_exchange_a->AdvancedSearch->SearchValue != "" || $this->price_exchange_a->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // amount_exchange
        if ($this->amount_exchange->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->amount_exchange->AdvancedSearch->SearchValue != "" || $this->amount_exchange->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cbm->AdvancedSearch->SearchValue != "" || $this->cbm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // weight
        if ($this->weight->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->weight->AdvancedSearch->SearchValue != "" || $this->weight->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // partner_other_ref
        if ($this->partner_other_ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->partner_other_ref->AdvancedSearch->SearchValue != "" || $this->partner_other_ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_loc
        if ($this->buyer_loc->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_loc->AdvancedSearch->SearchValue != "" || $this->buyer_loc->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po->AdvancedSearch->SearchValue != "" || $this->po->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->no_of_bales->setDbValue($row['no_of_bales']);
        $this->design->setDbValue($row['design']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        if (array_key_exists('EV__buyer_ref', $row)) {
            $this->buyer_ref->VirtualValue = $row['EV__buyer_ref']; // Set up virtual field value
        } else {
            $this->buyer_ref->VirtualValue = ""; // Clear value
        }
        $this->buyer_code->setDbValue($row['buyer_code']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->quantity->setDbValue($row['quantity']);
        $this->size->setDbValue($row['size']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->price->setDbValue($row['price']);
        $this->price_a->setDbValue($row['price_a']);
        $this->discount->setDbValue($row['discount']);
        $this->amount->setDbValue($row['amount']);
        $this->currency->setDbValue($row['currency']);
        $this->composition->setDbValue($row['composition']);
        $this->hsn->setDbValue($row['hsn']);
        $this->gst->setDbValue($row['gst']);
        $this->price_exchange->setDbValue($row['price_exchange']);
        $this->price_exchange_a->setDbValue($row['price_exchange_a']);
        $this->amount_exchange->setDbValue($row['amount_exchange']);
        $this->cbm->setDbValue($row['cbm']);
        $this->weight->setDbValue($row['weight']);
        $this->partner_other_ref->setDbValue($row['partner_other_ref']);
        $this->roll_no_start->setDbValue($row['roll_no_start']);
        $this->roll_no_end->setDbValue($row['roll_no_end']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->po->setDbValue($row['po']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['pl_no'] = $this->pl_no->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['roll_no'] = $this->roll_no->DefaultValue;
        $row['no_of_bales'] = $this->no_of_bales->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['buyer_code'] = $this->buyer_code->DefaultValue;
        $row['buyer_po'] = $this->buyer_po->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['sqm_a'] = $this->sqm_a->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['price_a'] = $this->price_a->DefaultValue;
        $row['discount'] = $this->discount->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['composition'] = $this->composition->DefaultValue;
        $row['hsn'] = $this->hsn->DefaultValue;
        $row['gst'] = $this->gst->DefaultValue;
        $row['price_exchange'] = $this->price_exchange->DefaultValue;
        $row['price_exchange_a'] = $this->price_exchange_a->DefaultValue;
        $row['amount_exchange'] = $this->amount_exchange->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['weight'] = $this->weight->DefaultValue;
        $row['partner_other_ref'] = $this->partner_other_ref->DefaultValue;
        $row['roll_no_start'] = $this->roll_no_start->DefaultValue;
        $row['roll_no_end'] = $this->roll_no_end->DefaultValue;
        $row['buyer_loc'] = $this->buyer_loc->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // pl_no

        // buyers_id

        // barcode

        // roll_no
        $this->roll_no->CellCssStyle = "white-space: nowrap;";

        // no_of_bales

        // design
        $this->design->CellCssStyle = "white-space: nowrap;";

        // buyer_ref

        // buyer_code

        // buyer_po

        // quantity

        // size

        // sqm

        // sqm_a

        // price

        // price_a

        // discount

        // amount

        // currency

        // composition

        // hsn

        // gst

        // price_exchange

        // price_exchange_a

        // amount_exchange

        // cbm

        // weight

        // partner_other_ref

        // roll_no_start
        $this->roll_no_start->CellCssStyle = "white-space: nowrap;";

        // roll_no_end
        $this->roll_no_end->CellCssStyle = "white-space: nowrap;";

        // buyer_loc

        // po

        // Accumulate aggregate value
        if ($this->RowType != RowType::AGGREGATEINIT && $this->RowType != RowType::AGGREGATE && $this->RowType != RowType::PREVIEWFIELD) {
            if (is_numeric($this->no_of_bales->CurrentValue)) {
                $this->no_of_bales->Total += $this->no_of_bales->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->quantity->CurrentValue)) {
                $this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->sqm->CurrentValue)) {
                $this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->amount->CurrentValue)) {
                $this->amount->Total += $this->amount->CurrentValue; // Accumulate total
            }
        }

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
            $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;

            // no_of_bales
            $this->no_of_bales->ViewValue = $this->no_of_bales->CurrentValue;
            $this->no_of_bales->ViewValue = FormatNumber($this->no_of_bales->ViewValue, $this->no_of_bales->formatPattern());

            // design
            $this->design->ViewValue = $this->design->CurrentValue;
            $curVal = strval($this->design->CurrentValue);
            if ($curVal != "") {
                $this->design->ViewValue = $this->design->lookupCacheOption($curVal);
                if ($this->design->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design->Lookup->renderViewRow($rswrk[0]);
                        $this->design->ViewValue = $this->design->displayValue($arwrk);
                    } else {
                        $this->design->ViewValue = $this->design->CurrentValue;
                    }
                }
            } else {
                $this->design->ViewValue = null;
            }

            // buyer_ref
            if ($this->buyer_ref->VirtualValue != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
            } else {
                $curVal = strval($this->buyer_ref->CurrentValue);
                if ($curVal != "") {
                    $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                    if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                            $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                        } else {
                            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                        }
                    }
                } else {
                    $this->buyer_ref->ViewValue = null;
                }
            }

            // buyer_code
            $this->buyer_code->ViewValue = $this->buyer_code->CurrentValue;

            // buyer_po
            $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // sqm_a
            $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // price_a
            $this->price_a->ViewValue = $this->price_a->CurrentValue;
            $this->price_a->ViewValue = FormatNumber($this->price_a->ViewValue, $this->price_a->formatPattern());

            // discount
            $this->discount->ViewValue = $this->discount->CurrentValue;
            $this->discount->ViewValue = FormatNumber($this->discount->ViewValue, $this->discount->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // composition
            $this->composition->ViewValue = $this->composition->CurrentValue;

            // hsn
            $this->hsn->ViewValue = $this->hsn->CurrentValue;

            // gst
            $this->gst->ViewValue = $this->gst->CurrentValue;

            // price_exchange
            $this->price_exchange->ViewValue = $this->price_exchange->CurrentValue;
            $this->price_exchange->ViewValue = FormatNumber($this->price_exchange->ViewValue, $this->price_exchange->formatPattern());

            // price_exchange_a
            $this->price_exchange_a->ViewValue = $this->price_exchange_a->CurrentValue;
            $this->price_exchange_a->ViewValue = FormatNumber($this->price_exchange_a->ViewValue, $this->price_exchange_a->formatPattern());

            // amount_exchange
            $this->amount_exchange->ViewValue = $this->amount_exchange->CurrentValue;
            $this->amount_exchange->ViewValue = FormatNumber($this->amount_exchange->ViewValue, $this->amount_exchange->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // weight
            $this->weight->ViewValue = $this->weight->CurrentValue;
            $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

            // partner_other_ref
            $this->partner_other_ref->ViewValue = $this->partner_other_ref->CurrentValue;

            // buyer_loc
            $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

            // po
            $this->po->ViewValue = $this->po->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";

            // buyers_id
            if (!EmptyValue($this->buyers_id->CurrentValue)) {
                $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
                $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
                }
            } else {
                $this->buyers_id->HrefValue = "";
            }
            $this->buyers_id->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // no_of_bales
            $this->no_of_bales->HrefValue = "";
            $this->no_of_bales->TooltipValue = "";

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // buyer_ref
            if (!EmptyValue($this->buyer_ref->CurrentValue)) {
                $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
                $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
                }
            } else {
                $this->buyer_ref->HrefValue = "";
            }
            $this->buyer_ref->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_ref->ViewValue = $this->highlightValue($this->buyer_ref);
            }

            // buyer_code
            $this->buyer_code->HrefValue = "";
            $this->buyer_code->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_code->ViewValue = $this->highlightValue($this->buyer_code);
            }

            // buyer_po
            $this->buyer_po->HrefValue = "";
            $this->buyer_po->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_po->ViewValue = $this->highlightValue($this->buyer_po);
            }

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";
            if (!$this->isExport()) {
                $this->size->ViewValue = $this->highlightValue($this->size);
            }

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";
            $this->sqm_a->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // price_a
            $this->price_a->HrefValue = "";
            $this->price_a->TooltipValue = "";

            // discount
            $this->discount->HrefValue = "";
            $this->discount->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // composition
            $this->composition->HrefValue = "";
            $this->composition->TooltipValue = "";
            if (!$this->isExport()) {
                $this->composition->ViewValue = $this->highlightValue($this->composition);
            }

            // hsn
            $this->hsn->HrefValue = "";
            $this->hsn->TooltipValue = "";
            if (!$this->isExport()) {
                $this->hsn->ViewValue = $this->highlightValue($this->hsn);
            }

            // gst
            $this->gst->HrefValue = "";
            $this->gst->TooltipValue = "";

            // price_exchange
            $this->price_exchange->HrefValue = "";
            $this->price_exchange->TooltipValue = "";

            // price_exchange_a
            $this->price_exchange_a->HrefValue = "";
            $this->price_exchange_a->TooltipValue = "";

            // amount_exchange
            $this->amount_exchange->HrefValue = "";
            $this->amount_exchange->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // weight
            $this->weight->HrefValue = "";
            $this->weight->TooltipValue = "";

            // partner_other_ref
            $this->partner_other_ref->HrefValue = "";
            $this->partner_other_ref->TooltipValue = "";
            if (!$this->isExport()) {
                $this->partner_other_ref->ViewValue = $this->highlightValue($this->partner_other_ref);
            }

            // buyer_loc
            $this->buyer_loc->HrefValue = "";
            $this->buyer_loc->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_loc->ViewValue = $this->highlightValue($this->buyer_loc);
            }

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";
            if (!$this->isExport()) {
                $this->po->ViewValue = $this->highlightValue($this->po);
            }
        } elseif ($this->RowType == RowType::AGGREGATEINIT) { // Initialize aggregate row
                    $this->no_of_bales->Total = 0; // Initialize total
                    $this->quantity->Total = 0; // Initialize total
                    $this->sqm->Total = 0; // Initialize total
                    $this->amount->Total = 0; // Initialize total
        } elseif ($this->RowType == RowType::AGGREGATE) { // Aggregate row
            $this->no_of_bales->CurrentValue = $this->no_of_bales->Total;
            $this->no_of_bales->ViewValue = $this->no_of_bales->CurrentValue;
            $this->no_of_bales->ViewValue = FormatNumber($this->no_of_bales->ViewValue, $this->no_of_bales->formatPattern());
            $this->no_of_bales->HrefValue = ""; // Clear href value
            $this->quantity->CurrentValue = $this->quantity->Total;
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
            $this->quantity->HrefValue = ""; // Clear href value
            $this->sqm->CurrentValue = $this->sqm->Total;
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());
            $this->sqm->HrefValue = ""; // Clear href value
            $this->amount->CurrentValue = $this->amount->Total;
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());
            $this->amount->HrefValue = ""; // Clear href value
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->no_of_bales->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->buyer_code->AdvancedSearch->load();
        $this->buyer_po->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->size->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->sqm_a->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->price_a->AdvancedSearch->load();
        $this->discount->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->composition->AdvancedSearch->load();
        $this->hsn->AdvancedSearch->load();
        $this->gst->AdvancedSearch->load();
        $this->price_exchange->AdvancedSearch->load();
        $this->price_exchange_a->AdvancedSearch->load();
        $this->amount_exchange->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->weight->AdvancedSearch->load();
        $this->partner_other_ref->AdvancedSearch->load();
        $this->buyer_loc->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fpacking_listlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fpacking_listlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fpacking_listlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fpacking_listlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"packing_list\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"packinglistsearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"packinglistsearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fpacking_listsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_buyers_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_ref":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad() {
    	//echo "Page Load";
    	IF (isset($_GET['CID']))
    	{
    	ExecuteStatement("UPDATE `pl_setup` set `pl_refresh` =  `pl_refresh`+1");
    	}	
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type) {
    	if ($type == 'success') {
    		//$msg = "your success message";
    	} elseif ($type == 'failure') {
    		//$msg = "your failure message";
    	} elseif ($type == 'warning') {
    		//$msg = "your warning message";
    	} else {
    		$msg = '<button class="btn btn-danger ew-action" onclick="ew.modalDialogShow({btn:\'SaveBtn\',url:\'plsetupedit\/1\'});">Change PL No.</button>';
    	}
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	$item = &$this->OtherOptions['action']->Add("Change PL No.");
    	$item->Body = '<button class="btn btn-danger ew-action" onclick="ew.modalDialogShow({btn:\'SaveBtn\',url:\'plsetupedit\/1\'});">Change PL No.</button>';
    	$item->Visible = True;
    	$item = &$this->OtherOptions['action']->Add("Re-fresh");
    	$item->Body = '<a href="packinglistlist?CID=7fa7" data-bs-original-title ="Re-fresh"><i data-phrase="Re-fresh"  class="fa fa-refresh fa-2x ew-icon" ></i></a>';
    	$item->Visible = True;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
