<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for packing_list
 */
class PackingList extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $pl_no;
    public $buyers_id;
    public $_barcode;
    public $roll_no;
    public $no_of_bales;
    public $design;
    public $buyer_ref;
    public $buyer_code;
    public $buyer_po;
    public $quantity;
    public $size;
    public $sqm;
    public $sqm_a;
    public $price;
    public $price_a;
    public $discount;
    public $amount;
    public $currency;
    public $composition;
    public $hsn;
    public $gst;
    public $price_exchange;
    public $price_exchange_a;
    public $amount_exchange;
    public $cbm;
    public $weight;
    public $partner_other_ref;
    public $roll_no_start;
    public $roll_no_end;
    public $buyer_loc;
    public $po;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "packing_list";
        $this->TableName = 'packing_list';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "packing_list";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // pl_no
        $this->pl_no = new DbField(
            $this, // Table
            'x_pl_no', // Variable name
            'pl_no', // Name
            '`pl_no`', // Expression
            '`pl_no`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pl_no->InputTextType = "text";
        $this->pl_no->Raw = true;
        $this->pl_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pl_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pl_no'] = &$this->pl_no;

        // buyers_id
        $this->buyers_id = new DbField(
            $this, // Table
            'x_buyers_id', // Variable name
            'buyers_id', // Name
            '`buyers_id`', // Expression
            '`buyers_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyers_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyers_id->addMethod("getSelectFilter", fn() => "`id` > 1000 and `grp` = 3");
        $this->buyers_id->addMethod("getLinkPrefix", fn() => "bcodelist?x_buyers_id=");
        $this->buyers_id->InputTextType = "text";
        $this->buyers_id->Raw = true;
        $this->buyers_id->setSelectMultiple(false); // Select one
        $this->buyers_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyers_id->Lookup = new Lookup($this->buyers_id, 'buyer', false, 'id', ["name","code","",""], '', '', [], ["x_buyer_ref"], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->buyers_id) . "',COALESCE(`code`,''))");
        $this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyers_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyers_id'] = &$this->buyers_id;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_barcode->InputTextType = "text";
        $this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['barcode'] = &$this->_barcode;

        // roll_no
        $this->roll_no = new DbField(
            $this, // Table
            'x_roll_no', // Variable name
            'roll_no', // Name
            '`roll_no`', // Expression
            '`roll_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`roll_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->roll_no->InputTextType = "text";
        $this->roll_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['roll_no'] = &$this->roll_no;

        // no_of_bales
        $this->no_of_bales = new DbField(
            $this, // Table
            'x_no_of_bales', // Variable name
            'no_of_bales', // Name
            '`no_of_bales`', // Expression
            '`no_of_bales`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`no_of_bales`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->no_of_bales->addMethod("getDefault", fn() => 0);
        $this->no_of_bales->InputTextType = "text";
        $this->no_of_bales->Raw = true;
        $this->no_of_bales->Nullable = false; // NOT NULL field
        $this->no_of_bales->Required = true; // Required field
        $this->no_of_bales->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->no_of_bales->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['no_of_bales'] = &$this->no_of_bales;

        // design
        $this->design = new DbField(
            $this, // Table
            'x_design', // Variable name
            'design', // Name
            '`design`', // Expression
            '`design`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design->addMethod("getSelectFilter", fn() => "`product_type`  != 9 and `status` = 1");
        $this->design->InputTextType = "text";
        $this->design->Lookup = new Lookup($this->design, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->design->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design'] = &$this->design;

        // buyer_ref
        $this->buyer_ref = new DbField(
            $this, // Table
            'x_buyer_ref', // Variable name
            'buyer_ref', // Name
            '`buyer_ref`', // Expression
            '`buyer_ref`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__buyer_ref', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyer_ref->addMethod("getLinkPrefix", fn() => "bcodelist?x_buyer_ref=");
        $this->buyer_ref->InputTextType = "text";
        $this->buyer_ref->setSelectMultiple(false); // Select one
        $this->buyer_ref->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyer_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyer_ref->Lookup = new Lookup($this->buyer_ref, 'partner_product_ref', false, 'id', ["partner_ref","","",""], '', '', ["x_buyers_id"], [], ["partner"], ["x_partner"], [], [], false, '`partner_ref` ASC', '', "`partner_ref`");
        $this->buyer_ref->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_ref'] = &$this->buyer_ref;

        // buyer_code
        $this->buyer_code = new DbField(
            $this, // Table
            'x_buyer_code', // Variable name
            'buyer_code', // Name
            '`buyer_code`', // Expression
            '`buyer_code`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_code->InputTextType = "text";
        $this->buyer_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_code'] = &$this->buyer_code;

        // buyer_po
        $this->buyer_po = new DbField(
            $this, // Table
            'x_buyer_po', // Variable name
            'buyer_po', // Name
            '`buyer_po`', // Expression
            '`buyer_po`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_po->InputTextType = "text";
        $this->buyer_po->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_po'] = &$this->buyer_po;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            20, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->addMethod("getDefault", fn() => 0);
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Nullable = false; // NOT NULL field
        $this->quantity->Required = true; // Required field
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity'] = &$this->quantity;

        // size
        $this->size = new DbField(
            $this, // Table
            'x_size', // Variable name
            'size', // Name
            '`size`', // Expression
            '`size`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size->InputTextType = "text";
        $this->size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size'] = &$this->size;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->Nullable = false; // NOT NULL field
        $this->sqm->Required = true; // Required field
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['sqm'] = &$this->sqm;

        // sqm_a
        $this->sqm_a = new DbField(
            $this, // Table
            'x_sqm_a', // Variable name
            'sqm_a', // Name
            '`sqm_a`', // Expression
            '`sqm_a`', // Basic search expression
            131, // Type
            13, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm_a->InputTextType = "text";
        $this->sqm_a->Raw = true;
        $this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm_a'] = &$this->sqm_a;

        // price
        $this->price = new DbField(
            $this, // Table
            'x_price', // Variable name
            'price', // Name
            '`price`', // Expression
            '`price`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price->InputTextType = "text";
        $this->price->Raw = true;
        $this->price->Nullable = false; // NOT NULL field
        $this->price->Required = true; // Required field
        $this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['price'] = &$this->price;

        // price_a
        $this->price_a = new DbField(
            $this, // Table
            'x_price_a', // Variable name
            'price_a', // Name
            '`price_a`', // Expression
            '`price_a`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price_a->InputTextType = "text";
        $this->price_a->Raw = true;
        $this->price_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['price_a'] = &$this->price_a;

        // discount
        $this->discount = new DbField(
            $this, // Table
            'x_discount', // Variable name
            'discount', // Name
            '`discount`', // Expression
            '`discount`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`discount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->discount->addMethod("getDefault", fn() => 0.00);
        $this->discount->InputTextType = "text";
        $this->discount->Raw = true;
        $this->discount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->discount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['discount'] = &$this->discount;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->Nullable = false; // NOT NULL field
        $this->amount->Required = true; // Required field
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['amount'] = &$this->amount;

        // currency
        $this->currency = new DbField(
            $this, // Table
            'x_currency', // Variable name
            'currency', // Name
            '`currency`', // Expression
            '`currency`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`currency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->currency->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->currency->InputTextType = "text";
        $this->currency->Raw = true;
        $this->currency->Nullable = false; // NOT NULL field
        $this->currency->Required = true; // Required field
        $this->currency->setSelectMultiple(false); // Select one
        $this->currency->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->currency->Lookup = new Lookup($this->currency, 'currency', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->currency->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['currency'] = &$this->currency;

        // composition
        $this->composition = new DbField(
            $this, // Table
            'x_composition', // Variable name
            'composition', // Name
            '`composition`', // Expression
            '`composition`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`composition`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->composition->InputTextType = "text";
        $this->composition->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['composition'] = &$this->composition;

        // hsn
        $this->hsn = new DbField(
            $this, // Table
            'x_hsn', // Variable name
            'hsn', // Name
            '`hsn`', // Expression
            '`hsn`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`hsn`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->hsn->InputTextType = "text";
        $this->hsn->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['hsn'] = &$this->hsn;

        // gst
        $this->gst = new DbField(
            $this, // Table
            'x_gst', // Variable name
            'gst', // Name
            '`gst`', // Expression
            '`gst`', // Basic search expression
            200, // Type
            190, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gst`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gst->InputTextType = "text";
        $this->gst->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->gst->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['gst'] = &$this->gst;

        // price_exchange
        $this->price_exchange = new DbField(
            $this, // Table
            'x_price_exchange', // Variable name
            'price_exchange', // Name
            '`price_exchange`', // Expression
            '`price_exchange`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price_exchange`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price_exchange->addMethod("getDefault", fn() => 0.0000);
        $this->price_exchange->InputTextType = "text";
        $this->price_exchange->Raw = true;
        $this->price_exchange->Nullable = false; // NOT NULL field
        $this->price_exchange->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price_exchange->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['price_exchange'] = &$this->price_exchange;

        // price_exchange_a
        $this->price_exchange_a = new DbField(
            $this, // Table
            'x_price_exchange_a', // Variable name
            'price_exchange_a', // Name
            '`price_exchange_a`', // Expression
            '`price_exchange_a`', // Basic search expression
            131, // Type
            13, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price_exchange_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price_exchange_a->InputTextType = "text";
        $this->price_exchange_a->Raw = true;
        $this->price_exchange_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price_exchange_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['price_exchange_a'] = &$this->price_exchange_a;

        // amount_exchange
        $this->amount_exchange = new DbField(
            $this, // Table
            'x_amount_exchange', // Variable name
            'amount_exchange', // Name
            '`amount_exchange`', // Expression
            '`amount_exchange`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount_exchange`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount_exchange->addMethod("getDefault", fn() => 0.0000);
        $this->amount_exchange->InputTextType = "text";
        $this->amount_exchange->Raw = true;
        $this->amount_exchange->Nullable = false; // NOT NULL field
        $this->amount_exchange->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount_exchange->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['amount_exchange'] = &$this->amount_exchange;

        // cbm
        $this->cbm = new DbField(
            $this, // Table
            'x_cbm', // Variable name
            'cbm', // Name
            '`cbm`', // Expression
            '`cbm`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cbm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cbm->InputTextType = "text";
        $this->cbm->Raw = true;
        $this->cbm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cbm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cbm'] = &$this->cbm;

        // weight
        $this->weight = new DbField(
            $this, // Table
            'x_weight', // Variable name
            'weight', // Name
            '`weight`', // Expression
            '`weight`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->weight->InputTextType = "text";
        $this->weight->Raw = true;
        $this->weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['weight'] = &$this->weight;

        // partner_other_ref
        $this->partner_other_ref = new DbField(
            $this, // Table
            'x_partner_other_ref', // Variable name
            'partner_other_ref', // Name
            '`partner_other_ref`', // Expression
            '`partner_other_ref`', // Basic search expression
            200, // Type
            492, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`partner_other_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->partner_other_ref->InputTextType = "text";
        $this->partner_other_ref->Required = true; // Required field
        $this->partner_other_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['partner_other_ref'] = &$this->partner_other_ref;

        // roll_no_start
        $this->roll_no_start = new DbField(
            $this, // Table
            'x_roll_no_start', // Variable name
            'roll_no_start', // Name
            '`roll_no_start`', // Expression
            '`roll_no_start`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`roll_no_start`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->roll_no_start->InputTextType = "text";
        $this->roll_no_start->Raw = true;
        $this->roll_no_start->Sortable = false; // Allow sort
        $this->roll_no_start->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->roll_no_start->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['roll_no_start'] = &$this->roll_no_start;

        // roll_no_end
        $this->roll_no_end = new DbField(
            $this, // Table
            'x_roll_no_end', // Variable name
            'roll_no_end', // Name
            '`roll_no_end`', // Expression
            '`roll_no_end`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`roll_no_end`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->roll_no_end->addMethod("getDefault", fn() => 0);
        $this->roll_no_end->InputTextType = "text";
        $this->roll_no_end->Raw = true;
        $this->roll_no_end->Sortable = false; // Allow sort
        $this->roll_no_end->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->roll_no_end->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['roll_no_end'] = &$this->roll_no_end;

        // buyer_loc
        $this->buyer_loc = new DbField(
            $this, // Table
            'x_buyer_loc', // Variable name
            'buyer_loc', // Name
            '`buyer_loc`', // Expression
            '`buyer_loc`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_loc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_loc->InputTextType = "text";
        $this->buyer_loc->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_loc'] = &$this->buyer_loc;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->InputTextType = "text";
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "packing_list";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `partner_ref` FROM partner_product_ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = packing_list.buyer_ref LIMIT 1) AS EV__buyer_ref FROM packing_list)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->buyer_ref->AdvancedSearch->SearchValue != "" ||
            $this->buyer_ref->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->buyer_ref->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->buyer_ref->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->pl_no->DbValue = $row['pl_no'];
        $this->buyers_id->DbValue = $row['buyers_id'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->roll_no->DbValue = $row['roll_no'];
        $this->no_of_bales->DbValue = $row['no_of_bales'];
        $this->design->DbValue = $row['design'];
        $this->buyer_ref->DbValue = $row['buyer_ref'];
        $this->buyer_code->DbValue = $row['buyer_code'];
        $this->buyer_po->DbValue = $row['buyer_po'];
        $this->quantity->DbValue = $row['quantity'];
        $this->size->DbValue = $row['size'];
        $this->sqm->DbValue = $row['sqm'];
        $this->sqm_a->DbValue = $row['sqm_a'];
        $this->price->DbValue = $row['price'];
        $this->price_a->DbValue = $row['price_a'];
        $this->discount->DbValue = $row['discount'];
        $this->amount->DbValue = $row['amount'];
        $this->currency->DbValue = $row['currency'];
        $this->composition->DbValue = $row['composition'];
        $this->hsn->DbValue = $row['hsn'];
        $this->gst->DbValue = $row['gst'];
        $this->price_exchange->DbValue = $row['price_exchange'];
        $this->price_exchange_a->DbValue = $row['price_exchange_a'];
        $this->amount_exchange->DbValue = $row['amount_exchange'];
        $this->cbm->DbValue = $row['cbm'];
        $this->weight->DbValue = $row['weight'];
        $this->partner_other_ref->DbValue = $row['partner_other_ref'];
        $this->roll_no_start->DbValue = $row['roll_no_start'];
        $this->roll_no_end->DbValue = $row['roll_no_end'];
        $this->buyer_loc->DbValue = $row['buyer_loc'];
        $this->po->DbValue = $row['po'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("packinglistlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "packinglistview" => $Language->phrase("View"),
            "packinglistedit" => $Language->phrase("Edit"),
            "packinglistadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "packinglistlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PackingListView",
            Config("API_ADD_ACTION") => "PackingListAdd",
            Config("API_EDIT_ACTION") => "PackingListEdit",
            Config("API_DELETE_ACTION") => "PackingListDelete",
            Config("API_LIST_ACTION") => "PackingListList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "packinglistlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("packinglistview", $parm);
        } else {
            $url = $this->keyUrl("packinglistview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "packinglistadd?" . $parm;
        } else {
            $url = "packinglistadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("packinglistedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("packinglistlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("packinglistadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("packinglistlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("packinglistdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->no_of_bales->setDbValue($row['no_of_bales']);
        $this->design->setDbValue($row['design']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->buyer_code->setDbValue($row['buyer_code']);
        $this->buyer_po->setDbValue($row['buyer_po']);
        $this->quantity->setDbValue($row['quantity']);
        $this->size->setDbValue($row['size']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->price->setDbValue($row['price']);
        $this->price_a->setDbValue($row['price_a']);
        $this->discount->setDbValue($row['discount']);
        $this->amount->setDbValue($row['amount']);
        $this->currency->setDbValue($row['currency']);
        $this->composition->setDbValue($row['composition']);
        $this->hsn->setDbValue($row['hsn']);
        $this->gst->setDbValue($row['gst']);
        $this->price_exchange->setDbValue($row['price_exchange']);
        $this->price_exchange_a->setDbValue($row['price_exchange_a']);
        $this->amount_exchange->setDbValue($row['amount_exchange']);
        $this->cbm->setDbValue($row['cbm']);
        $this->weight->setDbValue($row['weight']);
        $this->partner_other_ref->setDbValue($row['partner_other_ref']);
        $this->roll_no_start->setDbValue($row['roll_no_start']);
        $this->roll_no_end->setDbValue($row['roll_no_end']);
        $this->buyer_loc->setDbValue($row['buyer_loc']);
        $this->po->setDbValue($row['po']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PackingListList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // pl_no

        // buyers_id

        // barcode

        // roll_no
        $this->roll_no->CellCssStyle = "white-space: nowrap;";

        // no_of_bales

        // design
        $this->design->CellCssStyle = "white-space: nowrap;";

        // buyer_ref

        // buyer_code

        // buyer_po

        // quantity

        // size

        // sqm

        // sqm_a

        // price

        // price_a

        // discount

        // amount

        // currency

        // composition

        // hsn

        // gst

        // price_exchange

        // price_exchange_a

        // amount_exchange

        // cbm

        // weight

        // partner_other_ref

        // roll_no_start
        $this->roll_no_start->CellCssStyle = "white-space: nowrap;";

        // roll_no_end
        $this->roll_no_end->CellCssStyle = "white-space: nowrap;";

        // buyer_loc

        // po

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // pl_no
        $this->pl_no->ViewValue = $this->pl_no->CurrentValue;
        $this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, $this->pl_no->formatPattern());

        // buyers_id
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->ViewValue = null;
        }

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

        // roll_no
        $this->roll_no->ViewValue = $this->roll_no->CurrentValue;

        // no_of_bales
        $this->no_of_bales->ViewValue = $this->no_of_bales->CurrentValue;
        $this->no_of_bales->ViewValue = FormatNumber($this->no_of_bales->ViewValue, $this->no_of_bales->formatPattern());

        // design
        $this->design->ViewValue = $this->design->CurrentValue;
        $curVal = strval($this->design->CurrentValue);
        if ($curVal != "") {
            $this->design->ViewValue = $this->design->lookupCacheOption($curVal);
            if ($this->design->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design->getSelectFilter($this); // PHP
                $sqlWrk = $this->design->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design->Lookup->renderViewRow($rswrk[0]);
                    $this->design->ViewValue = $this->design->displayValue($arwrk);
                } else {
                    $this->design->ViewValue = $this->design->CurrentValue;
                }
            }
        } else {
            $this->design->ViewValue = null;
        }

        // buyer_ref
        if ($this->buyer_ref->VirtualValue != "") {
            $this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
        } else {
            $curVal = strval($this->buyer_ref->CurrentValue);
            if ($curVal != "") {
                $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                    }
                }
            } else {
                $this->buyer_ref->ViewValue = null;
            }
        }

        // buyer_code
        $this->buyer_code->ViewValue = $this->buyer_code->CurrentValue;

        // buyer_po
        $this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // size
        $this->size->ViewValue = $this->size->CurrentValue;

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // sqm_a
        $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

        // price
        $this->price->ViewValue = $this->price->CurrentValue;
        $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

        // price_a
        $this->price_a->ViewValue = $this->price_a->CurrentValue;
        $this->price_a->ViewValue = FormatNumber($this->price_a->ViewValue, $this->price_a->formatPattern());

        // discount
        $this->discount->ViewValue = $this->discount->CurrentValue;
        $this->discount->ViewValue = FormatNumber($this->discount->ViewValue, $this->discount->formatPattern());

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

        // currency
        $curVal = strval($this->currency->CurrentValue);
        if ($curVal != "") {
            $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            if ($this->currency->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                    $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                } else {
                    $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                }
            }
        } else {
            $this->currency->ViewValue = null;
        }

        // composition
        $this->composition->ViewValue = $this->composition->CurrentValue;

        // hsn
        $this->hsn->ViewValue = $this->hsn->CurrentValue;

        // gst
        $this->gst->ViewValue = $this->gst->CurrentValue;

        // price_exchange
        $this->price_exchange->ViewValue = $this->price_exchange->CurrentValue;
        $this->price_exchange->ViewValue = FormatNumber($this->price_exchange->ViewValue, $this->price_exchange->formatPattern());

        // price_exchange_a
        $this->price_exchange_a->ViewValue = $this->price_exchange_a->CurrentValue;
        $this->price_exchange_a->ViewValue = FormatNumber($this->price_exchange_a->ViewValue, $this->price_exchange_a->formatPattern());

        // amount_exchange
        $this->amount_exchange->ViewValue = $this->amount_exchange->CurrentValue;
        $this->amount_exchange->ViewValue = FormatNumber($this->amount_exchange->ViewValue, $this->amount_exchange->formatPattern());

        // cbm
        $this->cbm->ViewValue = $this->cbm->CurrentValue;
        $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

        // weight
        $this->weight->ViewValue = $this->weight->CurrentValue;
        $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

        // partner_other_ref
        $this->partner_other_ref->ViewValue = $this->partner_other_ref->CurrentValue;

        // roll_no_start
        $this->roll_no_start->ViewValue = $this->roll_no_start->CurrentValue;
        $this->roll_no_start->ViewValue = FormatNumber($this->roll_no_start->ViewValue, $this->roll_no_start->formatPattern());

        // roll_no_end
        $this->roll_no_end->ViewValue = $this->roll_no_end->CurrentValue;
        $this->roll_no_end->ViewValue = FormatNumber($this->roll_no_end->ViewValue, $this->roll_no_end->formatPattern());

        // buyer_loc
        $this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;

        // po
        $this->po->ViewValue = $this->po->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // pl_no
        $this->pl_no->HrefValue = "";
        $this->pl_no->TooltipValue = "";

        // buyers_id
        if (!EmptyValue($this->buyers_id->CurrentValue)) {
            $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
            $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
            }
        } else {
            $this->buyers_id->HrefValue = "";
        }
        $this->buyers_id->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // roll_no
        $this->roll_no->HrefValue = "";
        $this->roll_no->TooltipValue = "";

        // no_of_bales
        $this->no_of_bales->HrefValue = "";
        $this->no_of_bales->TooltipValue = "";

        // design
        $this->design->HrefValue = "";
        $this->design->TooltipValue = "";

        // buyer_ref
        if (!EmptyValue($this->buyer_ref->CurrentValue)) {
            $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
            $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
            }
        } else {
            $this->buyer_ref->HrefValue = "";
        }
        $this->buyer_ref->TooltipValue = "";

        // buyer_code
        $this->buyer_code->HrefValue = "";
        $this->buyer_code->TooltipValue = "";

        // buyer_po
        $this->buyer_po->HrefValue = "";
        $this->buyer_po->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // size
        $this->size->HrefValue = "";
        $this->size->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // sqm_a
        $this->sqm_a->HrefValue = "";
        $this->sqm_a->TooltipValue = "";

        // price
        $this->price->HrefValue = "";
        $this->price->TooltipValue = "";

        // price_a
        $this->price_a->HrefValue = "";
        $this->price_a->TooltipValue = "";

        // discount
        $this->discount->HrefValue = "";
        $this->discount->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // currency
        $this->currency->HrefValue = "";
        $this->currency->TooltipValue = "";

        // composition
        $this->composition->HrefValue = "";
        $this->composition->TooltipValue = "";

        // hsn
        $this->hsn->HrefValue = "";
        $this->hsn->TooltipValue = "";

        // gst
        $this->gst->HrefValue = "";
        $this->gst->TooltipValue = "";

        // price_exchange
        $this->price_exchange->HrefValue = "";
        $this->price_exchange->TooltipValue = "";

        // price_exchange_a
        $this->price_exchange_a->HrefValue = "";
        $this->price_exchange_a->TooltipValue = "";

        // amount_exchange
        $this->amount_exchange->HrefValue = "";
        $this->amount_exchange->TooltipValue = "";

        // cbm
        $this->cbm->HrefValue = "";
        $this->cbm->TooltipValue = "";

        // weight
        $this->weight->HrefValue = "";
        $this->weight->TooltipValue = "";

        // partner_other_ref
        $this->partner_other_ref->HrefValue = "";
        $this->partner_other_ref->TooltipValue = "";

        // roll_no_start
        $this->roll_no_start->HrefValue = "";
        $this->roll_no_start->TooltipValue = "";

        // roll_no_end
        $this->roll_no_end->HrefValue = "";
        $this->roll_no_end->TooltipValue = "";

        // buyer_loc
        $this->buyer_loc->HrefValue = "";
        $this->buyer_loc->TooltipValue = "";

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // pl_no
        $this->pl_no->setupEditAttributes();
        $this->pl_no->EditValue = $this->pl_no->CurrentValue;
        $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());
        if (strval($this->pl_no->EditValue) != "" && is_numeric($this->pl_no->EditValue)) {
            $this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, null);
        }

        // buyers_id
        $this->buyers_id->setupEditAttributes();
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->EditValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->EditValue = null;
        }

        // barcode
        $this->_barcode->setupEditAttributes();
        if (!$this->_barcode->Raw) {
            $this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
        }
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;
        $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

        // roll_no
        $this->roll_no->setupEditAttributes();
        if (!$this->roll_no->Raw) {
            $this->roll_no->CurrentValue = HtmlDecode($this->roll_no->CurrentValue);
        }
        $this->roll_no->EditValue = $this->roll_no->CurrentValue;
        $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

        // no_of_bales
        $this->no_of_bales->setupEditAttributes();
        $this->no_of_bales->EditValue = $this->no_of_bales->CurrentValue;
        $this->no_of_bales->PlaceHolder = RemoveHtml($this->no_of_bales->caption());
        if (strval($this->no_of_bales->EditValue) != "" && is_numeric($this->no_of_bales->EditValue)) {
            $this->no_of_bales->EditValue = FormatNumber($this->no_of_bales->EditValue, null);
        }

        // design
        $this->design->setupEditAttributes();
        if (!$this->design->Raw) {
            $this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
        }
        $this->design->EditValue = $this->design->CurrentValue;
        $this->design->PlaceHolder = RemoveHtml($this->design->caption());

        // buyer_ref
        $this->buyer_ref->setupEditAttributes();
        if ($this->buyer_ref->VirtualValue != "") {
            $this->buyer_ref->EditValue = $this->buyer_ref->VirtualValue;
        } else {
            $curVal = strval($this->buyer_ref->CurrentValue);
            if ($curVal != "") {
                $this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
                if ($this->buyer_ref->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
                    } else {
                        $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
                    }
                }
            } else {
                $this->buyer_ref->EditValue = null;
            }
        }

        // buyer_code
        $this->buyer_code->setupEditAttributes();
        if (!$this->buyer_code->Raw) {
            $this->buyer_code->CurrentValue = HtmlDecode($this->buyer_code->CurrentValue);
        }
        $this->buyer_code->EditValue = $this->buyer_code->CurrentValue;
        $this->buyer_code->PlaceHolder = RemoveHtml($this->buyer_code->caption());

        // buyer_po
        $this->buyer_po->setupEditAttributes();
        if (!$this->buyer_po->Raw) {
            $this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
        }
        $this->buyer_po->EditValue = $this->buyer_po->CurrentValue;
        $this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // size
        $this->size->setupEditAttributes();
        if (!$this->size->Raw) {
            $this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
        }
        $this->size->EditValue = $this->size->CurrentValue;
        $this->size->PlaceHolder = RemoveHtml($this->size->caption());

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // sqm_a
        $this->sqm_a->setupEditAttributes();
        $this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
        if (strval($this->sqm_a->EditValue) != "" && is_numeric($this->sqm_a->EditValue)) {
            $this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, null);
        }

        // price
        $this->price->setupEditAttributes();
        $this->price->EditValue = $this->price->CurrentValue;
        $this->price->PlaceHolder = RemoveHtml($this->price->caption());
        if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
            $this->price->EditValue = FormatNumber($this->price->EditValue, null);
        }

        // price_a
        $this->price_a->setupEditAttributes();
        $this->price_a->EditValue = $this->price_a->CurrentValue;
        $this->price_a->PlaceHolder = RemoveHtml($this->price_a->caption());
        if (strval($this->price_a->EditValue) != "" && is_numeric($this->price_a->EditValue)) {
            $this->price_a->EditValue = FormatNumber($this->price_a->EditValue, null);
        }

        // discount
        $this->discount->setupEditAttributes();
        $this->discount->EditValue = $this->discount->CurrentValue;
        $this->discount->PlaceHolder = RemoveHtml($this->discount->caption());
        if (strval($this->discount->EditValue) != "" && is_numeric($this->discount->EditValue)) {
            $this->discount->EditValue = FormatNumber($this->discount->EditValue, null);
        }

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
        if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
        }

        // currency
        $this->currency->setupEditAttributes();
        $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

        // composition
        $this->composition->setupEditAttributes();
        if (!$this->composition->Raw) {
            $this->composition->CurrentValue = HtmlDecode($this->composition->CurrentValue);
        }
        $this->composition->EditValue = $this->composition->CurrentValue;
        $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

        // hsn
        $this->hsn->setupEditAttributes();
        if (!$this->hsn->Raw) {
            $this->hsn->CurrentValue = HtmlDecode($this->hsn->CurrentValue);
        }
        $this->hsn->EditValue = $this->hsn->CurrentValue;
        $this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

        // gst
        $this->gst->setupEditAttributes();
        if (!$this->gst->Raw) {
            $this->gst->CurrentValue = HtmlDecode($this->gst->CurrentValue);
        }
        $this->gst->EditValue = $this->gst->CurrentValue;
        $this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

        // price_exchange
        $this->price_exchange->setupEditAttributes();
        $this->price_exchange->EditValue = $this->price_exchange->CurrentValue;
        $this->price_exchange->PlaceHolder = RemoveHtml($this->price_exchange->caption());
        if (strval($this->price_exchange->EditValue) != "" && is_numeric($this->price_exchange->EditValue)) {
            $this->price_exchange->EditValue = FormatNumber($this->price_exchange->EditValue, null);
        }

        // price_exchange_a
        $this->price_exchange_a->setupEditAttributes();
        $this->price_exchange_a->EditValue = $this->price_exchange_a->CurrentValue;
        $this->price_exchange_a->PlaceHolder = RemoveHtml($this->price_exchange_a->caption());
        if (strval($this->price_exchange_a->EditValue) != "" && is_numeric($this->price_exchange_a->EditValue)) {
            $this->price_exchange_a->EditValue = FormatNumber($this->price_exchange_a->EditValue, null);
        }

        // amount_exchange
        $this->amount_exchange->setupEditAttributes();
        $this->amount_exchange->EditValue = $this->amount_exchange->CurrentValue;
        $this->amount_exchange->PlaceHolder = RemoveHtml($this->amount_exchange->caption());
        if (strval($this->amount_exchange->EditValue) != "" && is_numeric($this->amount_exchange->EditValue)) {
            $this->amount_exchange->EditValue = FormatNumber($this->amount_exchange->EditValue, null);
        }

        // cbm
        $this->cbm->setupEditAttributes();
        $this->cbm->EditValue = $this->cbm->CurrentValue;
        $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
        if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
            $this->cbm->EditValue = FormatNumber($this->cbm->EditValue, null);
        }

        // weight
        $this->weight->setupEditAttributes();
        $this->weight->EditValue = $this->weight->CurrentValue;
        $this->weight->PlaceHolder = RemoveHtml($this->weight->caption());
        if (strval($this->weight->EditValue) != "" && is_numeric($this->weight->EditValue)) {
            $this->weight->EditValue = FormatNumber($this->weight->EditValue, null);
        }

        // partner_other_ref
        $this->partner_other_ref->setupEditAttributes();
        if (!$this->partner_other_ref->Raw) {
            $this->partner_other_ref->CurrentValue = HtmlDecode($this->partner_other_ref->CurrentValue);
        }
        $this->partner_other_ref->EditValue = $this->partner_other_ref->CurrentValue;
        $this->partner_other_ref->PlaceHolder = RemoveHtml($this->partner_other_ref->caption());

        // roll_no_start
        $this->roll_no_start->setupEditAttributes();
        $this->roll_no_start->EditValue = $this->roll_no_start->CurrentValue;
        $this->roll_no_start->PlaceHolder = RemoveHtml($this->roll_no_start->caption());
        if (strval($this->roll_no_start->EditValue) != "" && is_numeric($this->roll_no_start->EditValue)) {
            $this->roll_no_start->EditValue = FormatNumber($this->roll_no_start->EditValue, null);
        }

        // roll_no_end
        $this->roll_no_end->setupEditAttributes();
        $this->roll_no_end->EditValue = $this->roll_no_end->CurrentValue;
        $this->roll_no_end->PlaceHolder = RemoveHtml($this->roll_no_end->caption());
        if (strval($this->roll_no_end->EditValue) != "" && is_numeric($this->roll_no_end->EditValue)) {
            $this->roll_no_end->EditValue = FormatNumber($this->roll_no_end->EditValue, null);
        }

        // buyer_loc
        $this->buyer_loc->setupEditAttributes();
        if (!$this->buyer_loc->Raw) {
            $this->buyer_loc->CurrentValue = HtmlDecode($this->buyer_loc->CurrentValue);
        }
        $this->buyer_loc->EditValue = $this->buyer_loc->CurrentValue;
        $this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

        // po
        $this->po->setupEditAttributes();
        if (!$this->po->Raw) {
            $this->po->CurrentValue = HtmlDecode($this->po->CurrentValue);
        }
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->PlaceHolder = RemoveHtml($this->po->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->no_of_bales->CurrentValue)) {
                $this->no_of_bales->Total += $this->no_of_bales->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->quantity->CurrentValue)) {
                $this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->sqm->CurrentValue)) {
                $this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->amount->CurrentValue)) {
                $this->amount->Total += $this->amount->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->no_of_bales->CurrentValue = $this->no_of_bales->Total;
            $this->no_of_bales->ViewValue = $this->no_of_bales->CurrentValue;
            $this->no_of_bales->ViewValue = FormatNumber($this->no_of_bales->ViewValue, $this->no_of_bales->formatPattern());
            $this->no_of_bales->HrefValue = ""; // Clear href value
            $this->quantity->CurrentValue = $this->quantity->Total;
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());
            $this->quantity->HrefValue = ""; // Clear href value
            $this->sqm->CurrentValue = $this->sqm->Total;
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());
            $this->sqm->HrefValue = ""; // Clear href value
            $this->amount->CurrentValue = $this->amount->Total;
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());
            $this->amount->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->no_of_bales);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->buyer_code);
                    $doc->exportCaption($this->buyer_po);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->size);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->sqm_a);
                    $doc->exportCaption($this->price);
                    $doc->exportCaption($this->price_a);
                    $doc->exportCaption($this->discount);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->composition);
                    $doc->exportCaption($this->hsn);
                    $doc->exportCaption($this->gst);
                    $doc->exportCaption($this->price_exchange);
                    $doc->exportCaption($this->price_exchange_a);
                    $doc->exportCaption($this->amount_exchange);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->weight);
                    $doc->exportCaption($this->partner_other_ref);
                    $doc->exportCaption($this->buyer_loc);
                    $doc->exportCaption($this->po);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->roll_no);
                    $doc->exportCaption($this->no_of_bales);
                    $doc->exportCaption($this->design);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->buyer_code);
                    $doc->exportCaption($this->buyer_po);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->size);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->sqm_a);
                    $doc->exportCaption($this->price);
                    $doc->exportCaption($this->price_a);
                    $doc->exportCaption($this->discount);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->composition);
                    $doc->exportCaption($this->hsn);
                    $doc->exportCaption($this->gst);
                    $doc->exportCaption($this->price_exchange);
                    $doc->exportCaption($this->price_exchange_a);
                    $doc->exportCaption($this->amount_exchange);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->weight);
                    $doc->exportCaption($this->partner_other_ref);
                    $doc->exportCaption($this->buyer_loc);
                    $doc->exportCaption($this->po);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->no_of_bales);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->buyer_code);
                        $doc->exportField($this->buyer_po);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->size);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->sqm_a);
                        $doc->exportField($this->price);
                        $doc->exportField($this->price_a);
                        $doc->exportField($this->discount);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->composition);
                        $doc->exportField($this->hsn);
                        $doc->exportField($this->gst);
                        $doc->exportField($this->price_exchange);
                        $doc->exportField($this->price_exchange_a);
                        $doc->exportField($this->amount_exchange);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->weight);
                        $doc->exportField($this->partner_other_ref);
                        $doc->exportField($this->buyer_loc);
                        $doc->exportField($this->po);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->roll_no);
                        $doc->exportField($this->no_of_bales);
                        $doc->exportField($this->design);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->buyer_code);
                        $doc->exportField($this->buyer_po);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->size);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->sqm_a);
                        $doc->exportField($this->price);
                        $doc->exportField($this->price_a);
                        $doc->exportField($this->discount);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->composition);
                        $doc->exportField($this->hsn);
                        $doc->exportField($this->gst);
                        $doc->exportField($this->price_exchange);
                        $doc->exportField($this->price_exchange_a);
                        $doc->exportField($this->amount_exchange);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->weight);
                        $doc->exportField($this->partner_other_ref);
                        $doc->exportField($this->buyer_loc);
                        $doc->exportField($this->po);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->pl_no, '');
                $doc->exportAggregate($this->buyers_id, '');
                $doc->exportAggregate($this->_barcode, '');
                $doc->exportAggregate($this->roll_no, '');
                $doc->exportAggregate($this->no_of_bales, 'TOTAL');
                $doc->exportAggregate($this->design, '');
                $doc->exportAggregate($this->buyer_ref, '');
                $doc->exportAggregate($this->buyer_code, '');
                $doc->exportAggregate($this->buyer_po, '');
                $doc->exportAggregate($this->quantity, 'TOTAL');
                $doc->exportAggregate($this->size, '');
                $doc->exportAggregate($this->sqm, 'TOTAL');
                $doc->exportAggregate($this->sqm_a, '');
                $doc->exportAggregate($this->price, '');
                $doc->exportAggregate($this->price_a, '');
                $doc->exportAggregate($this->discount, '');
                $doc->exportAggregate($this->amount, 'TOTAL');
                $doc->exportAggregate($this->currency, '');
                $doc->exportAggregate($this->composition, '');
                $doc->exportAggregate($this->hsn, '');
                $doc->exportAggregate($this->gst, '');
                $doc->exportAggregate($this->price_exchange, '');
                $doc->exportAggregate($this->price_exchange_a, '');
                $doc->exportAggregate($this->amount_exchange, '');
                $doc->exportAggregate($this->cbm, '');
                $doc->exportAggregate($this->weight, '');
                $doc->exportAggregate($this->partner_other_ref, '');
                $doc->exportAggregate($this->buyer_loc, '');
                $doc->exportAggregate($this->po, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
