<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for p_po
 */
class PPo extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $po;
    public $type;
    public $job_category;
    public $company_id;
    public $item;
    public $quantity;
    public $item_size;
    public $description_03;
    public $description_02;
    public $description_09;
    public $description_01;
    public $description_08;
    public $description_07;
    public $description_10;
    public $description_04;
    public $description_06;
    public $description_05;
    public $description_11;
    public $amount;
    public $gst;
    public $buyer_instruction;
    public $remarks;
    public $despatch_date;
    public $uploads;
    public $operator;
    public $datetime;
    public $production_plan;
    public $part_dispatch;
    public $payment_terms;
    public $transport_type;
    public $partner_shipping_id;
    public $description_12;
    public $description_17;
    public $description_18;
    public $description_19;
    public $description_20;
    public $production_site;
    public $jc_no;
    public $a_operator;
    public $a_datetime;
    public $app_operator;
    public $app_datetime;
    public $c_operator;
    public $c_datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "p_po";
        $this->TableName = 'p_po';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "p_po";
        $this->Dbid = 'DB';
        $this->ExportAll = false;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->addMethod("getDefault", fn() => 0);
        $this->po->addMethod("getLinkPrefix", fn() => "poblist?x_po=");
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // type
        $this->type = new DbField(
            $this, // Table
            'x_type', // Variable name
            'type', // Name
            '`type`', // Expression
            '`type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->type->addMethod("getDefault", fn() => 0);
        $this->type->InputTextType = "text";
        $this->type->Raw = true;
        $this->type->Nullable = false; // NOT NULL field
        $this->type->Required = true; // Required field
        $this->type->setSelectMultiple(false); // Select one
        $this->type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->type->Lookup = new Lookup($this->type, 'p_po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->type->OptionCount = 4;
        $this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['type'] = &$this->type;

        // job_category
        $this->job_category = new DbField(
            $this, // Table
            'x_job_category', // Variable name
            'job_category', // Name
            '`job_category`', // Expression
            '`job_category`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`job_category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->job_category->addMethod("getDefault", fn() => 0);
        $this->job_category->InputTextType = "text";
        $this->job_category->Raw = true;
        $this->job_category->Nullable = false; // NOT NULL field
        $this->job_category->Required = true; // Required field
        $this->job_category->Lookup = new Lookup($this->job_category, 'p_po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->job_category->OptionCount = 2;
        $this->job_category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->job_category->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['job_category'] = &$this->job_category;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => (User_Company_ID() == 0) ? ((User_Site() == 0) ? "" : "(`status` = 1 and `partner_type` = 2 and `id` >= 1000)") : "(`id` = " .  User_Company_ID()  . " || `id` = " .  User_Company_ID()  . ") and `status` = 1 and `id` >= 1000 and `partner_type` = 2");
        $this->company_id->addMethod("getDefault", fn() => ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["CID"]))? $_COOKIE["CID"]:User_Company_ID())));
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Required = true; // Required field
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], ["x_description_03[]","x_description_02[]","x_description_09[]","x_description_01[]","x_description_08[]","x_description_07[]","x_description_10[]","x_description_04[]","x_description_05[]","x_partner_shipping_id"], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // item
        $this->item = new DbField(
            $this, // Table
            'x_item', // Variable name
            'item', // Name
            '`item`', // Expression
            '`item`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`item`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->item->addMethod("getDefault", fn() => (isset($_COOKIE["ITEM"]))? $_COOKIE["ITEM"]:'');
        $this->item->InputTextType = "text";
        $this->item->Nullable = false; // NOT NULL field
        $this->item->Required = true; // Required field
        $this->item->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['item'] = &$this->item;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->addMethod("getDefault", fn() => (isset($_COOKIE["QTY"]))? $_COOKIE["QTY"]:'');
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Required = true; // Required field
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity'] = &$this->quantity;

        // item_size
        $this->item_size = new DbField(
            $this, // Table
            'x_item_size', // Variable name
            'item_size', // Name
            '`item_size`', // Expression
            '`item_size`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`item_size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->item_size->addMethod("getDefault", fn() => (isset($_COOKIE["SIZE"]))? $_COOKIE["SIZE"]:'');
        $this->item_size->InputTextType = "text";
        $this->item_size->Required = true; // Required field
        $this->item_size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['item_size'] = &$this->item_size;

        // description_03
        $this->description_03 = new DbField(
            $this, // Table
            'x_description_03', // Variable name
            'description_03', // Name
            '`description_03`', // Expression
            '`description_03`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_03->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (116)" : "`s_grp` IN (116) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_03->addMethod("getDefault", fn() => (isset($_COOKIE["D03"]))? $_COOKIE["D03"]:'');
        $this->description_03->InputTextType = "text";
        $this->description_03->Sortable = false; // Allow sort
        $this->description_03->Lookup = new Lookup($this->description_03, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_03) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_03) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_03) . "',COALESCE(`amount`,''))");
        $this->description_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->description_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_03'] = &$this->description_03;

        // description_02
        $this->description_02 = new DbField(
            $this, // Table
            'x_description_02', // Variable name
            'description_02', // Name
            '`description_02`', // Expression
            '`description_02`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_02->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (115)" : "`s_grp` IN (115) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_02->addMethod("getDefault", fn() => (isset($_COOKIE["D02"]))? $_COOKIE["D02"]:'');
        $this->description_02->InputTextType = "text";
        $this->description_02->Sortable = false; // Allow sort
        $this->description_02->Lookup = new Lookup($this->description_02, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_02) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_02) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_02) . "',COALESCE(`amount`,''))");
        $this->description_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_02->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_02'] = &$this->description_02;

        // description_09
        $this->description_09 = new DbField(
            $this, // Table
            'x_description_09', // Variable name
            'description_09', // Name
            '`description_09`', // Expression
            '`description_09`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_09->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (126)" : "`s_grp` IN (126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_09->addMethod("getDefault", fn() => (isset($_COOKIE["D09"]))? $_COOKIE["D09"]:'');
        $this->description_09->InputTextType = "text";
        $this->description_09->Sortable = false; // Allow sort
        $this->description_09->Lookup = new Lookup($this->description_09, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_09) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_09) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_09) . "',COALESCE(`amount`,''))");
        $this->description_09->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_09'] = &$this->description_09;

        // description_01
        $this->description_01 = new DbField(
            $this, // Table
            'x_description_01', // Variable name
            'description_01', // Name
            '`description_01`', // Expression
            '`description_01`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_01->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (101,102,112)" : "`s_grp` IN (101,102,112) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_01->addMethod("getDefault", fn() => (isset($_COOKIE["D01"]))? $_COOKIE["D01"]:'');
        $this->description_01->InputTextType = "text";
        $this->description_01->Sortable = false; // Allow sort
        $this->description_01->Lookup = new Lookup($this->description_01, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_01) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_01) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_01) . "',COALESCE(`amount`,''))");
        $this->description_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_01'] = &$this->description_01;

        // description_08
        $this->description_08 = new DbField(
            $this, // Table
            'x_description_08', // Variable name
            'description_08', // Name
            '`description_08`', // Expression
            '`description_08`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_08->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (125)" : "`s_grp` IN (125) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_08->addMethod("getDefault", fn() => (isset($_COOKIE["D08"]))? $_COOKIE["D08"]:'');
        $this->description_08->InputTextType = "text";
        $this->description_08->Sortable = false; // Allow sort
        $this->description_08->Lookup = new Lookup($this->description_08, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_08) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_08) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_08) . "',COALESCE(`amount`,''))");
        $this->description_08->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_08->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_08'] = &$this->description_08;

        // description_07
        $this->description_07 = new DbField(
            $this, // Table
            'x_description_07', // Variable name
            'description_07', // Name
            '`description_07`', // Expression
            '`description_07`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_07->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (123)" : "`s_grp` IN (123) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_07->addMethod("getDefault", fn() => (isset($_COOKIE["D07"]))? $_COOKIE["D07"]:'');
        $this->description_07->InputTextType = "text";
        $this->description_07->Sortable = false; // Allow sort
        $this->description_07->Lookup = new Lookup($this->description_07, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_07) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_07) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_07) . "',COALESCE(`amount`,''))");
        $this->description_07->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_07->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_07'] = &$this->description_07;

        // description_10
        $this->description_10 = new DbField(
            $this, // Table
            'x_description_10', // Variable name
            'description_10', // Name
            '`description_10`', // Expression
            '`description_10`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_10->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (124)" : "`s_grp` IN (124) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_10->addMethod("getDefault", fn() => (isset($_COOKIE["D10"]))? $_COOKIE["D10"]:'');
        $this->description_10->InputTextType = "text";
        $this->description_10->Sortable = false; // Allow sort
        $this->description_10->Lookup = new Lookup($this->description_10, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_10) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_10) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_10) . "',COALESCE(`amount`,''))");
        $this->description_10->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_10'] = &$this->description_10;

        // description_04
        $this->description_04 = new DbField(
            $this, // Table
            'x_description_04', // Variable name
            'description_04', // Name
            '`description_04`', // Expression
            '`description_04`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_04->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (114)" : "`s_grp` IN (114) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_04->addMethod("getDefault", fn() => (isset($_COOKIE["D04"]))? $_COOKIE["D04"]:'');
        $this->description_04->InputTextType = "text";
        $this->description_04->Sortable = false; // Allow sort
        $this->description_04->Lookup = new Lookup($this->description_04, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_04) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_04) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_04) . "',COALESCE(`amount`,''))");
        $this->description_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->description_04->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_04'] = &$this->description_04;

        // description_06
        $this->description_06 = new DbField(
            $this, // Table
            'x_description_06', // Variable name
            'description_06', // Name
            '`description_06`', // Expression
            '`description_06`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_06->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (121)" : "`s_grp` IN (121) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_06->addMethod("getDefault", fn() => (isset($_COOKIE["D06"]))? $_COOKIE["D06"]:'');
        $this->description_06->InputTextType = "text";
        $this->description_06->Sortable = false; // Allow sort
        $this->description_06->Lookup = new Lookup($this->description_06, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', [], [], [], [], [], [], false, '', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_06) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_06) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_06) . "',COALESCE(`amount`,''))");
        $this->description_06->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_06'] = &$this->description_06;

        // description_05
        $this->description_05 = new DbField(
            $this, // Table
            'x_description_05', // Variable name
            'description_05', // Name
            '`description_05`', // Expression
            '`description_05`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_05->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126)" : "`s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_05->addMethod("getDefault", fn() => (isset($_COOKIE["D05"]))? $_COOKIE["D05"]:'');
        $this->description_05->InputTextType = "text";
        $this->description_05->Sortable = false; // Allow sort
        $this->description_05->Lookup = new Lookup($this->description_05, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="p_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/pcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title=" Edit ">Edit</a></span><span ><a style="color:red" data-ew-action="inline-delete" href="/pcartdelete/{{:lf}}"> Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_05) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_05) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_05) . "',COALESCE(`amount`,''))");
        $this->description_05->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_05'] = &$this->description_05;

        // description_11
        $this->description_11 = new DbField(
            $this, // Table
            'x_description_11', // Variable name
            'description_11', // Name
            '`description_11`', // Expression
            '`description_11`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_11`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_11->InputTextType = "text";
        $this->description_11->Sortable = false; // Allow sort
        $this->description_11->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_11'] = &$this->description_11;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->amount->addMethod("getDefault", fn() => "0");
        $this->amount->InputTextType = "text";
        $this->amount->Nullable = false; // NOT NULL field
        $this->amount->Required = true; // Required field
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['amount'] = &$this->amount;

        // gst
        $this->gst = new DbField(
            $this, // Table
            'x_gst', // Variable name
            'gst', // Name
            '`gst`', // Expression
            '`gst`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gst`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->gst->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->gst->addMethod("getDefault", fn() => 1);
        $this->gst->InputTextType = "text";
        $this->gst->Raw = true;
        $this->gst->Nullable = false; // NOT NULL field
        $this->gst->Required = true; // Required field
        $this->gst->setSelectMultiple(false); // Select one
        $this->gst->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->gst->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->gst->Lookup = new Lookup($this->gst, 'tax_category', false, 'id', ["item","tax_percent","hsn_code",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "CONCAT(COALESCE(`item`, ''),'" . ValueSeparator(1, $this->gst) . "',COALESCE(`tax_percent`,''),'" . ValueSeparator(2, $this->gst) . "',COALESCE(`hsn_code`,''))");
        $this->gst->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->gst->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['gst'] = &$this->gst;

        // buyer_instruction
        $this->buyer_instruction = new DbField(
            $this, // Table
            'x_buyer_instruction', // Variable name
            'buyer_instruction', // Name
            '`buyer_instruction`', // Expression
            '`buyer_instruction`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_instruction`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->buyer_instruction->InputTextType = "text";
        $this->buyer_instruction->Sortable = false; // Allow sort
        $this->buyer_instruction->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_instruction'] = &$this->buyer_instruction;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->Sortable = false; // Allow sort
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // despatch_date
        $this->despatch_date = new DbField(
            $this, // Table
            'x_despatch_date', // Variable name
            'despatch_date', // Name
            '`despatch_date`', // Expression
            CastDateFieldForLike("`despatch_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`despatch_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->despatch_date->InputTextType = "text";
        $this->despatch_date->Raw = true;
        $this->despatch_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->despatch_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_date'] = &$this->despatch_date;

        // uploads
        $this->uploads = new DbField(
            $this, // Table
            'x_uploads', // Variable name
            'uploads', // Name
            '`uploads`', // Expression
            '`uploads`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`uploads`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->uploads->addMethod("getUploadPath", fn() => '.p_uploads/ppo/');
        $this->uploads->InputTextType = "text";
        $this->uploads->Sortable = false; // Allow sort
        $this->uploads->UploadMultiple = true;
        $this->uploads->Upload->UploadMultiple = true;
        $this->uploads->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uploads'] = &$this->uploads;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // production_plan
        $this->production_plan = new DbField(
            $this, // Table
            'x_production_plan', // Variable name
            'production_plan', // Name
            '`production_plan`', // Expression
            '`production_plan`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->production_plan->addMethod("getSelectFilter", fn() => "`status` =1");
        $this->production_plan->InputTextType = "text";
        $this->production_plan->Raw = true;
        $this->production_plan->Sortable = false; // Allow sort
        $this->production_plan->setSelectMultiple(false); // Select one
        $this->production_plan->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->production_plan->Lookup = new Lookup($this->production_plan, 'production_plan_head', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->production_plan->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['production_plan'] = &$this->production_plan;

        // part_dispatch
        $this->part_dispatch = new DbField(
            $this, // Table
            'x_part_dispatch', // Variable name
            'part_dispatch', // Name
            '`part_dispatch`', // Expression
            '`part_dispatch`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`part_dispatch`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->part_dispatch->addMethod("getLinkPrefix", fn() => "poblist?x_part_dispatch=");
        $this->part_dispatch->InputTextType = "text";
        $this->part_dispatch->Raw = true;
        $this->part_dispatch->Sortable = false; // Allow sort
        $this->part_dispatch->setSelectMultiple(false); // Select one
        $this->part_dispatch->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->part_dispatch->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->part_dispatch->Lookup = new Lookup($this->part_dispatch, 'p_po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->part_dispatch->OptionCount = 2;
        $this->part_dispatch->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->part_dispatch->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['part_dispatch'] = &$this->part_dispatch;

        // payment_terms
        $this->payment_terms = new DbField(
            $this, // Table
            'x_payment_terms', // Variable name
            'payment_terms', // Name
            '`payment_terms`', // Expression
            '`payment_terms`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_terms`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->payment_terms->addMethod("getSelectFilter", fn() => "`grp` = 81");
        $this->payment_terms->addMethod("getLinkPrefix", fn() => "poblist?x_payment_terms=");
        $this->payment_terms->InputTextType = "text";
        $this->payment_terms->Sortable = false; // Allow sort
        $this->payment_terms->setSelectMultiple(false); // Select one
        $this->payment_terms->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->payment_terms->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->payment_terms->Lookup = new Lookup($this->payment_terms, 'misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->payment_terms->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment_terms'] = &$this->payment_terms;

        // transport_type
        $this->transport_type = new DbField(
            $this, // Table
            'x_transport_type', // Variable name
            'transport_type', // Name
            '`transport_type`', // Expression
            '`transport_type`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`transport_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->transport_type->addMethod("getSelectFilter", fn() => "`grp` = 82");
        $this->transport_type->addMethod("getLinkPrefix", fn() => "poblist?x_transport_type=");
        $this->transport_type->InputTextType = "text";
        $this->transport_type->Sortable = false; // Allow sort
        $this->transport_type->setSelectMultiple(false); // Select one
        $this->transport_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->transport_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->transport_type->Lookup = new Lookup($this->transport_type, 'misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->transport_type->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['transport_type'] = &$this->transport_type;

        // partner_shipping_id
        $this->partner_shipping_id = new DbField(
            $this, // Table
            'x_partner_shipping_id', // Variable name
            'partner_shipping_id', // Name
            '`partner_shipping_id`', // Expression
            '`partner_shipping_id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`partner_shipping_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->partner_shipping_id->addMethod("getSelectFilter", fn() => "`status` < 3");
        $this->partner_shipping_id->InputTextType = "text";
        $this->partner_shipping_id->Raw = true;
        $this->partner_shipping_id->Sortable = false; // Allow sort
        $this->partner_shipping_id->setSelectMultiple(false); // Select one
        $this->partner_shipping_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->partner_shipping_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->partner_shipping_id->Lookup = new Lookup($this->partner_shipping_id, 'shipping_address', false, 'id', ["name","address","city_name","gst_number"], '', '', ["x_company_id"], [], ["userid"], ["x__userid"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->partner_shipping_id) . "',COALESCE(`address`,''),'" . ValueSeparator(2, $this->partner_shipping_id) . "',COALESCE(`city_name`,''),'" . ValueSeparator(3, $this->partner_shipping_id) . "',COALESCE(`gst_number`,''))");
        $this->partner_shipping_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->partner_shipping_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['partner_shipping_id'] = &$this->partner_shipping_id;

        // description_12
        $this->description_12 = new DbField(
            $this, // Table
            'x_description_12', // Variable name
            'description_12', // Name
            '`description_12`', // Expression
            '`description_12`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_12`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_12->InputTextType = "text";
        $this->description_12->Sortable = false; // Allow sort
        $this->description_12->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_12'] = &$this->description_12;

        // description_17
        $this->description_17 = new DbField(
            $this, // Table
            'x_description_17', // Variable name
            'description_17', // Name
            '`description_17`', // Expression
            '`description_17`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_17`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_17->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->description_17->InputTextType = "text";
        $this->description_17->Sortable = false; // Allow sort
        $this->description_17->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_17->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_17'] = &$this->description_17;

        // description_18
        $this->description_18 = new DbField(
            $this, // Table
            'x_description_18', // Variable name
            'description_18', // Name
            '`description_18`', // Expression
            '`description_18`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_18`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_18->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->description_18->InputTextType = "text";
        $this->description_18->Sortable = false; // Allow sort
        $this->description_18->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_18->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_18'] = &$this->description_18;

        // description_19
        $this->description_19 = new DbField(
            $this, // Table
            'x_description_19', // Variable name
            'description_19', // Name
            '`description_19`', // Expression
            '`description_19`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_19`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description_19->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->description_19->InputTextType = "text";
        $this->description_19->Sortable = false; // Allow sort
        $this->description_19->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_19->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_19'] = &$this->description_19;

        // description_20
        $this->description_20 = new DbField(
            $this, // Table
            'x_description_20', // Variable name
            'description_20', // Name
            '`description_20`', // Expression
            '`description_20`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_20`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->description_20->addMethod("getDefault", fn() => 1);
        $this->description_20->InputTextType = "text";
        $this->description_20->Sortable = false; // Allow sort
        $this->description_20->setSelectMultiple(false); // Select one
        $this->description_20->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->description_20->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->description_20->Lookup = new Lookup($this->description_20, 'p_po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->description_20->OptionCount = 4;
        $this->description_20->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->description_20->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_20'] = &$this->description_20;

        // production_site
        $this->production_site = new DbField(
            $this, // Table
            'x_production_site', // Variable name
            'production_site', // Name
            '`production_site`', // Expression
            '`production_site`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_site`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->production_site->addMethod("getSelectFilter", fn() => "`grp` IN (0,3)");
        $this->production_site->InputTextType = "text";
        $this->production_site->Raw = true;
        $this->production_site->Nullable = false; // NOT NULL field
        $this->production_site->Sortable = false; // Allow sort
        $this->production_site->setSelectMultiple(false); // Select one
        $this->production_site->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->production_site->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->production_site->Lookup = new Lookup($this->production_site, 'godown', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`name`");
        $this->production_site->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->production_site->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['production_site'] = &$this->production_site;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Sortable = false; // Allow sort
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // a_operator
        $this->a_operator = new DbField(
            $this, // Table
            'x_a_operator', // Variable name
            'a_operator', // Name
            '`a_operator`', // Expression
            '`a_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`a_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->a_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->a_operator->InputTextType = "text";
        $this->a_operator->Raw = true;
        $this->a_operator->Sortable = false; // Allow sort
        $this->a_operator->setSelectMultiple(false); // Select one
        $this->a_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->a_operator->Lookup = new Lookup($this->a_operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->a_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_operator'] = &$this->a_operator;

        // a_datetime
        $this->a_datetime = new DbField(
            $this, // Table
            'x_a_datetime', // Variable name
            'a_datetime', // Name
            '`a_datetime`', // Expression
            CastDateFieldForLike("`a_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`a_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->a_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->a_datetime->InputTextType = "text";
        $this->a_datetime->Raw = true;
        $this->a_datetime->Sortable = false; // Allow sort
        $this->a_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_datetime'] = &$this->a_datetime;

        // app_operator
        $this->app_operator = new DbField(
            $this, // Table
            'x_app_operator', // Variable name
            'app_operator', // Name
            '`app_operator`', // Expression
            '`app_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`app_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->app_operator->InputTextType = "text";
        $this->app_operator->Raw = true;
        $this->app_operator->Sortable = false; // Allow sort
        $this->app_operator->setSelectMultiple(false); // Select one
        $this->app_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->app_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->app_operator->Lookup = new Lookup($this->app_operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->app_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->app_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['app_operator'] = &$this->app_operator;

        // app_datetime
        $this->app_datetime = new DbField(
            $this, // Table
            'x_app_datetime', // Variable name
            'app_datetime', // Name
            '`app_datetime`', // Expression
            CastDateFieldForLike("`app_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`app_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->app_datetime->InputTextType = "text";
        $this->app_datetime->Raw = true;
        $this->app_datetime->Sortable = false; // Allow sort
        $this->app_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->app_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['app_datetime'] = &$this->app_datetime;

        // c_operator
        $this->c_operator = new DbField(
            $this, // Table
            'x_c_operator', // Variable name
            'c_operator', // Name
            '`c_operator`', // Expression
            '`c_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`c_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->c_operator->addMethod("getSelectFilter", fn() => "`activated`=1");
        $this->c_operator->InputTextType = "text";
        $this->c_operator->Raw = true;
        $this->c_operator->Sortable = false; // Allow sort
        $this->c_operator->setSelectMultiple(false); // Select one
        $this->c_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->c_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->c_operator->Lookup = new Lookup($this->c_operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->c_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->c_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['c_operator'] = &$this->c_operator;

        // c_datetime
        $this->c_datetime = new DbField(
            $this, // Table
            'x_c_datetime', // Variable name
            'c_datetime', // Name
            '`c_datetime`', // Expression
            CastDateFieldForLike("`c_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`c_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->c_datetime->InputTextType = "text";
        $this->c_datetime->Raw = true;
        $this->c_datetime->Sortable = false; // Allow sort
        $this->c_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->c_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['c_datetime'] = &$this->c_datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "p_po";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Company_ID() == 0) ? "" : "`company_id` = " . $_GET['uios'] . "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->po->DbValue = $row['po'];
        $this->type->DbValue = $row['type'];
        $this->job_category->DbValue = $row['job_category'];
        $this->company_id->DbValue = $row['company_id'];
        $this->item->DbValue = $row['item'];
        $this->quantity->DbValue = $row['quantity'];
        $this->item_size->DbValue = $row['item_size'];
        $this->description_03->DbValue = $row['description_03'];
        $this->description_02->DbValue = $row['description_02'];
        $this->description_09->DbValue = $row['description_09'];
        $this->description_01->DbValue = $row['description_01'];
        $this->description_08->DbValue = $row['description_08'];
        $this->description_07->DbValue = $row['description_07'];
        $this->description_10->DbValue = $row['description_10'];
        $this->description_04->DbValue = $row['description_04'];
        $this->description_06->DbValue = $row['description_06'];
        $this->description_05->DbValue = $row['description_05'];
        $this->description_11->DbValue = $row['description_11'];
        $this->amount->DbValue = $row['amount'];
        $this->gst->DbValue = $row['gst'];
        $this->buyer_instruction->DbValue = $row['buyer_instruction'];
        $this->remarks->DbValue = $row['remarks'];
        $this->despatch_date->DbValue = $row['despatch_date'];
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->production_plan->DbValue = $row['production_plan'];
        $this->part_dispatch->DbValue = $row['part_dispatch'];
        $this->payment_terms->DbValue = $row['payment_terms'];
        $this->transport_type->DbValue = $row['transport_type'];
        $this->partner_shipping_id->DbValue = $row['partner_shipping_id'];
        $this->description_12->DbValue = $row['description_12'];
        $this->description_17->DbValue = $row['description_17'];
        $this->description_18->DbValue = $row['description_18'];
        $this->description_19->DbValue = $row['description_19'];
        $this->description_20->DbValue = $row['description_20'];
        $this->production_site->DbValue = $row['production_site'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->a_operator->DbValue = $row['a_operator'];
        $this->a_datetime->DbValue = $row['a_datetime'];
        $this->app_operator->DbValue = $row['app_operator'];
        $this->app_datetime->DbValue = $row['app_datetime'];
        $this->c_operator->DbValue = $row['c_operator'];
        $this->c_datetime->DbValue = $row['c_datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['uploads']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['uploads']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("ppolist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "ppoview" => $Language->phrase("View"),
            "ppoedit" => $Language->phrase("Edit"),
            "ppoadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "ppolist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PPoView",
            Config("API_ADD_ACTION") => "PPoAdd",
            Config("API_EDIT_ACTION") => "PPoEdit",
            Config("API_DELETE_ACTION") => "PPoDelete",
            Config("API_LIST_ACTION") => "PPoList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "ppolist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ppoview", $parm);
        } else {
            $url = $this->keyUrl("ppoview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "ppoadd?" . $parm;
        } else {
            $url = "ppoadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("ppoedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("ppolist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("ppoadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("ppolist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("ppodelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->po->setDbValue($row['po']);
        $this->type->setDbValue($row['type']);
        $this->job_category->setDbValue($row['job_category']);
        $this->company_id->setDbValue($row['company_id']);
        $this->item->setDbValue($row['item']);
        $this->quantity->setDbValue($row['quantity']);
        $this->item_size->setDbValue($row['item_size']);
        $this->description_03->setDbValue($row['description_03']);
        $this->description_02->setDbValue($row['description_02']);
        $this->description_09->setDbValue($row['description_09']);
        $this->description_01->setDbValue($row['description_01']);
        $this->description_08->setDbValue($row['description_08']);
        $this->description_07->setDbValue($row['description_07']);
        $this->description_10->setDbValue($row['description_10']);
        $this->description_04->setDbValue($row['description_04']);
        $this->description_06->setDbValue($row['description_06']);
        $this->description_05->setDbValue($row['description_05']);
        $this->description_11->setDbValue($row['description_11']);
        $this->amount->setDbValue($row['amount']);
        $this->gst->setDbValue($row['gst']);
        $this->buyer_instruction->setDbValue($row['buyer_instruction']);
        $this->remarks->setDbValue($row['remarks']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->part_dispatch->setDbValue($row['part_dispatch']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->transport_type->setDbValue($row['transport_type']);
        $this->partner_shipping_id->setDbValue($row['partner_shipping_id']);
        $this->description_12->setDbValue($row['description_12']);
        $this->description_17->setDbValue($row['description_17']);
        $this->description_18->setDbValue($row['description_18']);
        $this->description_19->setDbValue($row['description_19']);
        $this->description_20->setDbValue($row['description_20']);
        $this->production_site->setDbValue($row['production_site']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->app_operator->setDbValue($row['app_operator']);
        $this->app_datetime->setDbValue($row['app_datetime']);
        $this->c_operator->setDbValue($row['c_operator']);
        $this->c_datetime->setDbValue($row['c_datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PPoList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // po

        // type

        // job_category

        // company_id

        // item

        // quantity

        // item_size

        // description_03
        $this->description_03->CellCssStyle = "white-space: nowrap;";

        // description_02
        $this->description_02->CellCssStyle = "white-space: nowrap;";

        // description_09
        $this->description_09->CellCssStyle = "white-space: nowrap;";

        // description_01
        $this->description_01->CellCssStyle = "white-space: nowrap;";

        // description_08
        $this->description_08->CellCssStyle = "white-space: nowrap;";

        // description_07
        $this->description_07->CellCssStyle = "white-space: nowrap;";

        // description_10
        $this->description_10->CellCssStyle = "white-space: nowrap;";

        // description_04
        $this->description_04->CellCssStyle = "white-space: nowrap;";

        // description_06
        $this->description_06->CellCssStyle = "white-space: nowrap;";

        // description_05
        $this->description_05->CellCssStyle = "white-space: nowrap;";

        // description_11
        $this->description_11->CellCssStyle = "white-space: nowrap;";

        // amount

        // gst

        // buyer_instruction
        $this->buyer_instruction->CellCssStyle = "white-space: nowrap;";

        // remarks
        $this->remarks->CellCssStyle = "white-space: nowrap;";

        // despatch_date

        // uploads
        $this->uploads->CellCssStyle = "white-space: nowrap;";

        // operator

        // datetime

        // production_plan
        $this->production_plan->CellCssStyle = "white-space: nowrap;";

        // part_dispatch
        $this->part_dispatch->CellCssStyle = "white-space: nowrap;";

        // payment_terms
        $this->payment_terms->CellCssStyle = "white-space: nowrap;";

        // transport_type
        $this->transport_type->CellCssStyle = "white-space: nowrap;";

        // partner_shipping_id
        $this->partner_shipping_id->CellCssStyle = "white-space: nowrap;";

        // description_12
        $this->description_12->CellCssStyle = "white-space: nowrap;";

        // description_17
        $this->description_17->CellCssStyle = "white-space: nowrap;";

        // description_18
        $this->description_18->CellCssStyle = "white-space: nowrap;";

        // description_19
        $this->description_19->CellCssStyle = "white-space: nowrap;";

        // description_20
        $this->description_20->CellCssStyle = "white-space: nowrap;";

        // production_site
        $this->production_site->CellCssStyle = "white-space: nowrap;";

        // jc_no
        $this->jc_no->CellCssStyle = "white-space: nowrap;";

        // a_operator
        $this->a_operator->CellCssStyle = "white-space: nowrap;";

        // a_datetime
        $this->a_datetime->CellCssStyle = "white-space: nowrap;";

        // app_operator
        $this->app_operator->CellCssStyle = "white-space: nowrap;";

        // app_datetime
        $this->app_datetime->CellCssStyle = "white-space: nowrap;";

        // c_operator
        $this->c_operator->CellCssStyle = "white-space: nowrap;";

        // c_datetime
        $this->c_datetime->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // po
        $this->po->ViewValue = $this->po->CurrentValue;
        $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

        // type
        if (strval($this->type->CurrentValue) != "") {
            $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
        } else {
            $this->type->ViewValue = null;
        }

        // job_category
        if (strval($this->job_category->CurrentValue) != "") {
            $this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
        } else {
            $this->job_category->ViewValue = null;
        }

        // company_id
        $this->company_id->ViewValue = $this->company_id->CurrentValue;
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // item
        $this->item->ViewValue = $this->item->CurrentValue;

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // item_size
        $this->item_size->ViewValue = $this->item_size->CurrentValue;

        // description_03
        $curVal = strval($this->description_03->CurrentValue);
        if ($curVal != "") {
            $this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
            if ($this->description_03->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_03->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_03->Lookup->renderViewRow($row);
                        $this->description_03->ViewValue->add($this->description_03->displayValue($arwrk));
                    }
                } else {
                    $this->description_03->ViewValue = $this->description_03->CurrentValue;
                }
            }
        } else {
            $this->description_03->ViewValue = null;
        }

        // description_02
        $curVal = strval($this->description_02->CurrentValue);
        if ($curVal != "") {
            $this->description_02->ViewValue = $this->description_02->lookupCacheOption($curVal);
            if ($this->description_02->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_02->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_02->Lookup->renderViewRow($row);
                        $this->description_02->ViewValue->add($this->description_02->displayValue($arwrk));
                    }
                } else {
                    $this->description_02->ViewValue = $this->description_02->CurrentValue;
                }
            }
        } else {
            $this->description_02->ViewValue = null;
        }

        // description_09
        $curVal = strval($this->description_09->CurrentValue);
        if ($curVal != "") {
            $this->description_09->ViewValue = $this->description_09->lookupCacheOption($curVal);
            if ($this->description_09->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_09->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_09->Lookup->renderViewRow($row);
                        $this->description_09->ViewValue->add($this->description_09->displayValue($arwrk));
                    }
                } else {
                    $this->description_09->ViewValue = $this->description_09->CurrentValue;
                }
            }
        } else {
            $this->description_09->ViewValue = null;
        }

        // description_01
        $curVal = strval($this->description_01->CurrentValue);
        if ($curVal != "") {
            $this->description_01->ViewValue = $this->description_01->lookupCacheOption($curVal);
            if ($this->description_01->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_01->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_01->Lookup->renderViewRow($row);
                        $this->description_01->ViewValue->add($this->description_01->displayValue($arwrk));
                    }
                } else {
                    $this->description_01->ViewValue = $this->description_01->CurrentValue;
                }
            }
        } else {
            $this->description_01->ViewValue = null;
        }

        // description_08
        $curVal = strval($this->description_08->CurrentValue);
        if ($curVal != "") {
            $this->description_08->ViewValue = $this->description_08->lookupCacheOption($curVal);
            if ($this->description_08->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_08->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_08->Lookup->renderViewRow($row);
                        $this->description_08->ViewValue->add($this->description_08->displayValue($arwrk));
                    }
                } else {
                    $this->description_08->ViewValue = $this->description_08->CurrentValue;
                }
            }
        } else {
            $this->description_08->ViewValue = null;
        }

        // description_07
        $curVal = strval($this->description_07->CurrentValue);
        if ($curVal != "") {
            $this->description_07->ViewValue = $this->description_07->lookupCacheOption($curVal);
            if ($this->description_07->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_07->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_07->Lookup->renderViewRow($row);
                        $this->description_07->ViewValue->add($this->description_07->displayValue($arwrk));
                    }
                } else {
                    $this->description_07->ViewValue = $this->description_07->CurrentValue;
                }
            }
        } else {
            $this->description_07->ViewValue = null;
        }

        // description_10
        $curVal = strval($this->description_10->CurrentValue);
        if ($curVal != "") {
            $this->description_10->ViewValue = $this->description_10->lookupCacheOption($curVal);
            if ($this->description_10->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_10->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_10->Lookup->renderViewRow($row);
                        $this->description_10->ViewValue->add($this->description_10->displayValue($arwrk));
                    }
                } else {
                    $this->description_10->ViewValue = $this->description_10->CurrentValue;
                }
            }
        } else {
            $this->description_10->ViewValue = null;
        }

        // description_04
        $curVal = strval($this->description_04->CurrentValue);
        if ($curVal != "") {
            $this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
            if ($this->description_04->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_04->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_04->Lookup->renderViewRow($row);
                        $this->description_04->ViewValue->add($this->description_04->displayValue($arwrk));
                    }
                } else {
                    $this->description_04->ViewValue = $this->description_04->CurrentValue;
                }
            }
        } else {
            $this->description_04->ViewValue = null;
        }

        // description_06
        $curVal = strval($this->description_06->CurrentValue);
        if ($curVal != "") {
            $this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
            if ($this->description_06->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_06->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_06->Lookup->renderViewRow($row);
                        $this->description_06->ViewValue->add($this->description_06->displayValue($arwrk));
                    }
                } else {
                    $this->description_06->ViewValue = $this->description_06->CurrentValue;
                }
            }
        } else {
            $this->description_06->ViewValue = null;
        }

        // description_05
        $curVal = strval($this->description_05->CurrentValue);
        if ($curVal != "") {
            $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
            if ($this->description_05->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_05->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_05->Lookup->renderViewRow($row);
                        $this->description_05->ViewValue->add($this->description_05->displayValue($arwrk));
                    }
                } else {
                    $this->description_05->ViewValue = $this->description_05->CurrentValue;
                }
            }
        } else {
            $this->description_05->ViewValue = null;
        }

        // description_11
        $this->description_11->ViewValue = $this->description_11->CurrentValue;

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;

        // gst
        $curVal = strval($this->gst->CurrentValue);
        if ($curVal != "") {
            $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
            if ($this->gst->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                $sqlWrk = $this->gst->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->gst->Lookup->renderViewRow($rswrk[0]);
                    $this->gst->ViewValue = $this->gst->displayValue($arwrk);
                } else {
                    $this->gst->ViewValue = FormatNumber($this->gst->CurrentValue, $this->gst->formatPattern());
                }
            }
        } else {
            $this->gst->ViewValue = null;
        }

        // buyer_instruction
        $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // despatch_date
        $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
        $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->ViewValue = "";
        }
        $this->uploads->CssClass = "fst-italic";

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // production_plan
        $curVal = strval($this->production_plan->CurrentValue);
        if ($curVal != "") {
            $this->production_plan->ViewValue = $this->production_plan->lookupCacheOption($curVal);
            if ($this->production_plan->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->production_plan->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->production_plan->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->production_plan->getSelectFilter($this); // PHP
                $sqlWrk = $this->production_plan->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->production_plan->Lookup->renderViewRow($rswrk[0]);
                    $this->production_plan->ViewValue = $this->production_plan->displayValue($arwrk);
                } else {
                    $this->production_plan->ViewValue = $this->production_plan->CurrentValue;
                }
            }
        } else {
            $this->production_plan->ViewValue = null;
        }

        // part_dispatch
        if (strval($this->part_dispatch->CurrentValue) != "") {
            $this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
        } else {
            $this->part_dispatch->ViewValue = null;
        }

        // payment_terms
        $curVal = strval($this->payment_terms->CurrentValue);
        if ($curVal != "") {
            $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
            if ($this->payment_terms->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                    $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                } else {
                    $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                }
            }
        } else {
            $this->payment_terms->ViewValue = null;
        }

        // transport_type
        $curVal = strval($this->transport_type->CurrentValue);
        if ($curVal != "") {
            $this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
            if ($this->transport_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->transport_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->transport_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->transport_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->transport_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->transport_type->Lookup->renderViewRow($rswrk[0]);
                    $this->transport_type->ViewValue = $this->transport_type->displayValue($arwrk);
                } else {
                    $this->transport_type->ViewValue = $this->transport_type->CurrentValue;
                }
            }
        } else {
            $this->transport_type->ViewValue = null;
        }

        // partner_shipping_id
        $curVal = strval($this->partner_shipping_id->CurrentValue);
        if ($curVal != "") {
            $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
            if ($this->partner_shipping_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_shipping_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->partner_shipping_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner_shipping_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->partner_shipping_id->Lookup->renderViewRow($rswrk[0]);
                    $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->displayValue($arwrk);
                } else {
                    $this->partner_shipping_id->ViewValue = $this->partner_shipping_id->CurrentValue;
                }
            }
        } else {
            $this->partner_shipping_id->ViewValue = null;
        }

        // description_12
        $this->description_12->ViewValue = $this->description_12->CurrentValue;

        // description_17
        $this->description_17->ViewValue = $this->description_17->CurrentValue;

        // description_18
        $this->description_18->ViewValue = $this->description_18->CurrentValue;

        // description_19
        $this->description_19->ViewValue = $this->description_19->CurrentValue;

        // description_20
        if (strval($this->description_20->CurrentValue) != "") {
            $this->description_20->ViewValue = $this->description_20->optionCaption($this->description_20->CurrentValue);
        } else {
            $this->description_20->ViewValue = null;
        }

        // production_site
        $curVal = strval($this->production_site->CurrentValue);
        if ($curVal != "") {
            $this->production_site->ViewValue = $this->production_site->lookupCacheOption($curVal);
            if ($this->production_site->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->production_site->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->production_site->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->production_site->getSelectFilter($this); // PHP
                $sqlWrk = $this->production_site->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->production_site->Lookup->renderViewRow($rswrk[0]);
                    $this->production_site->ViewValue = $this->production_site->displayValue($arwrk);
                } else {
                    $this->production_site->ViewValue = FormatNumber($this->production_site->CurrentValue, $this->production_site->formatPattern());
                }
            }
        } else {
            $this->production_site->ViewValue = null;
        }

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;

        // a_operator
        $curVal = strval($this->a_operator->CurrentValue);
        if ($curVal != "") {
            $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            if ($this->a_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                } else {
                    $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                }
            }
        } else {
            $this->a_operator->ViewValue = null;
        }

        // a_datetime
        $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
        $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

        // app_operator
        $curVal = strval($this->app_operator->CurrentValue);
        if ($curVal != "") {
            $this->app_operator->ViewValue = $this->app_operator->lookupCacheOption($curVal);
            if ($this->app_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->app_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->app_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->app_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->app_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->app_operator->ViewValue = $this->app_operator->displayValue($arwrk);
                } else {
                    $this->app_operator->ViewValue = FormatNumber($this->app_operator->CurrentValue, $this->app_operator->formatPattern());
                }
            }
        } else {
            $this->app_operator->ViewValue = null;
        }

        // app_datetime
        $this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
        $this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, $this->app_datetime->formatPattern());

        // c_operator
        $curVal = strval($this->c_operator->CurrentValue);
        if ($curVal != "") {
            $this->c_operator->ViewValue = $this->c_operator->lookupCacheOption($curVal);
            if ($this->c_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->c_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->c_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->c_operator->getSelectFilter($this); // PHP
                $sqlWrk = $this->c_operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->c_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->c_operator->ViewValue = $this->c_operator->displayValue($arwrk);
                } else {
                    $this->c_operator->ViewValue = FormatNumber($this->c_operator->CurrentValue, $this->c_operator->formatPattern());
                }
            }
        } else {
            $this->c_operator->ViewValue = null;
        }

        // c_datetime
        $this->c_datetime->ViewValue = $this->c_datetime->CurrentValue;
        $this->c_datetime->ViewValue = FormatDateTime($this->c_datetime->ViewValue, $this->c_datetime->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // po
        if (!EmptyValue($this->po->CurrentValue)) {
            $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
            $this->po->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
            }
        } else {
            $this->po->HrefValue = "";
        }
        $this->po->TooltipValue = "";

        // type
        $this->type->HrefValue = "";
        $this->type->TooltipValue = "";

        // job_category
        $this->job_category->HrefValue = "";
        $this->job_category->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // item
        $this->item->HrefValue = "";
        $this->item->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // item_size
        $this->item_size->HrefValue = "";
        $this->item_size->TooltipValue = "";

        // description_03
        $this->description_03->HrefValue = "";
        $this->description_03->TooltipValue = "";

        // description_02
        $this->description_02->HrefValue = "";
        $this->description_02->TooltipValue = "";

        // description_09
        $this->description_09->HrefValue = "";
        $this->description_09->TooltipValue = "";

        // description_01
        $this->description_01->HrefValue = "";
        $this->description_01->TooltipValue = "";

        // description_08
        $this->description_08->HrefValue = "";
        $this->description_08->TooltipValue = "";

        // description_07
        $this->description_07->HrefValue = "";
        $this->description_07->TooltipValue = "";

        // description_10
        $this->description_10->HrefValue = "";
        $this->description_10->TooltipValue = "";

        // description_04
        $this->description_04->HrefValue = "";
        $this->description_04->TooltipValue = "";

        // description_06
        $this->description_06->HrefValue = "";
        $this->description_06->TooltipValue = "";

        // description_05
        $this->description_05->HrefValue = "";
        $this->description_05->TooltipValue = "";

        // description_11
        $this->description_11->HrefValue = "";
        $this->description_11->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // gst
        $this->gst->HrefValue = "";
        $this->gst->TooltipValue = "";

        // buyer_instruction
        $this->buyer_instruction->HrefValue = "";
        $this->buyer_instruction->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // despatch_date
        $this->despatch_date->HrefValue = "";
        $this->despatch_date->TooltipValue = "";

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->HrefValue = "%u"; // Add prefix/suffix
            $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
            }
        } else {
            $this->uploads->HrefValue = "";
        }
        $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        $this->uploads->TooltipValue = "";
        if ($this->uploads->UseColorbox) {
            if (EmptyValue($this->uploads->TooltipValue)) {
                $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->uploads->LinkAttrs["data-rel"] = "p_po_x_uploads";
            $this->uploads->LinkAttrs->appendClass("ew-lightbox");
        }

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // production_plan
        $this->production_plan->HrefValue = "";
        $this->production_plan->TooltipValue = "";

        // part_dispatch
        if (!EmptyValue($this->part_dispatch->CurrentValue)) {
            $this->part_dispatch->HrefValue = $this->part_dispatch->getLinkPrefix() . $this->part_dispatch->CurrentValue; // Add prefix/suffix
            $this->part_dispatch->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->part_dispatch->HrefValue = FullUrl($this->part_dispatch->HrefValue, "href");
            }
        } else {
            $this->part_dispatch->HrefValue = "";
        }
        $this->part_dispatch->TooltipValue = "";

        // payment_terms
        if (!EmptyValue($this->payment_terms->CurrentValue)) {
            $this->payment_terms->HrefValue = $this->payment_terms->getLinkPrefix() . $this->payment_terms->CurrentValue; // Add prefix/suffix
            $this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
            }
        } else {
            $this->payment_terms->HrefValue = "";
        }
        $this->payment_terms->TooltipValue = "";

        // transport_type
        if (!EmptyValue($this->transport_type->CurrentValue)) {
            $this->transport_type->HrefValue = $this->transport_type->getLinkPrefix() . $this->transport_type->CurrentValue; // Add prefix/suffix
            $this->transport_type->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
            }
        } else {
            $this->transport_type->HrefValue = "";
        }
        $this->transport_type->TooltipValue = "";

        // partner_shipping_id
        $this->partner_shipping_id->HrefValue = "";
        $this->partner_shipping_id->TooltipValue = "";

        // description_12
        $this->description_12->HrefValue = "";
        $this->description_12->TooltipValue = "";

        // description_17
        $this->description_17->HrefValue = "";
        $this->description_17->TooltipValue = "";

        // description_18
        $this->description_18->HrefValue = "";
        $this->description_18->TooltipValue = "";

        // description_19
        $this->description_19->HrefValue = "";
        $this->description_19->TooltipValue = "";

        // description_20
        $this->description_20->HrefValue = "";
        $this->description_20->TooltipValue = "";

        // production_site
        $this->production_site->HrefValue = "";
        $this->production_site->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // a_operator
        $this->a_operator->HrefValue = "";
        $this->a_operator->TooltipValue = "";

        // a_datetime
        $this->a_datetime->HrefValue = "";
        $this->a_datetime->TooltipValue = "";

        // app_operator
        $this->app_operator->HrefValue = "";
        $this->app_operator->TooltipValue = "";

        // app_datetime
        $this->app_datetime->HrefValue = "";
        $this->app_datetime->TooltipValue = "";

        // c_operator
        $this->c_operator->HrefValue = "";
        $this->c_operator->TooltipValue = "";

        // c_datetime
        $this->c_datetime->HrefValue = "";
        $this->c_datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->EditValue = FormatNumber($this->po->EditValue, $this->po->formatPattern());

        // type
        $this->type->setupEditAttributes();
        $this->type->EditValue = $this->type->options(true);
        $this->type->PlaceHolder = RemoveHtml($this->type->caption());

        // job_category
        $this->job_category->EditValue = $this->job_category->options(false);
        $this->job_category->PlaceHolder = RemoveHtml($this->job_category->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->EditValue = $this->company_id->CurrentValue;
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // item
        $this->item->setupEditAttributes();
        if (!$this->item->Raw) {
            $this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
        }
        $this->item->EditValue = $this->item->CurrentValue;
        $this->item->PlaceHolder = RemoveHtml($this->item->caption());

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // item_size
        $this->item_size->setupEditAttributes();
        if (!$this->item_size->Raw) {
            $this->item_size->CurrentValue = HtmlDecode($this->item_size->CurrentValue);
        }
        $this->item_size->EditValue = $this->item_size->CurrentValue;
        $this->item_size->PlaceHolder = RemoveHtml($this->item_size->caption());

        // description_03
        $this->description_03->PlaceHolder = RemoveHtml($this->description_03->caption());

        // description_02
        $this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

        // description_09
        $this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

        // description_01
        $this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

        // description_08
        $this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

        // description_07
        $this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

        // description_10
        $this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

        // description_04
        $this->description_04->PlaceHolder = RemoveHtml($this->description_04->caption());

        // description_06
        $this->description_06->PlaceHolder = RemoveHtml($this->description_06->caption());

        // description_05
        $this->description_05->PlaceHolder = RemoveHtml($this->description_05->caption());

        // description_11
        $this->description_11->setupEditAttributes();
        if (!$this->description_11->Raw) {
            $this->description_11->CurrentValue = HtmlDecode($this->description_11->CurrentValue);
        }
        $this->description_11->EditValue = $this->description_11->CurrentValue;
        $this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
        if (!$this->amount->Raw) {
            $this->amount->CurrentValue = HtmlDecode($this->amount->CurrentValue);
        }
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

        // gst
        $this->gst->setupEditAttributes();
        $this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

        // buyer_instruction
        $this->buyer_instruction->setupEditAttributes();
        $this->buyer_instruction->EditValue = $this->buyer_instruction->CurrentValue;
        $this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // despatch_date
        $this->despatch_date->setupEditAttributes();
        $this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

        // uploads
        $this->uploads->setupEditAttributes();
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->EditValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->EditValue = "";
        }
        if (!EmptyValue($this->uploads->CurrentValue)) {
            $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
        }

        // operator

        // datetime

        // production_plan
        $this->production_plan->setupEditAttributes();
        $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

        // part_dispatch
        $this->part_dispatch->setupEditAttributes();
        $this->part_dispatch->EditValue = $this->part_dispatch->options(true);
        $this->part_dispatch->PlaceHolder = RemoveHtml($this->part_dispatch->caption());

        // payment_terms
        $this->payment_terms->setupEditAttributes();
        $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

        // transport_type
        $this->transport_type->setupEditAttributes();
        $this->transport_type->PlaceHolder = RemoveHtml($this->transport_type->caption());

        // partner_shipping_id
        $this->partner_shipping_id->setupEditAttributes();
        $this->partner_shipping_id->PlaceHolder = RemoveHtml($this->partner_shipping_id->caption());

        // description_12
        $this->description_12->setupEditAttributes();
        if (!$this->description_12->Raw) {
            $this->description_12->CurrentValue = HtmlDecode($this->description_12->CurrentValue);
        }
        $this->description_12->EditValue = $this->description_12->CurrentValue;
        $this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

        // description_17
        $this->description_17->setupEditAttributes();
        $this->description_17->EditCustomAttributes = $this->description_17->getEditCustomAttributes(); // PHP
        if (!$this->description_17->Raw) {
            $this->description_17->CurrentValue = HtmlDecode($this->description_17->CurrentValue);
        }
        $this->description_17->EditValue = $this->description_17->CurrentValue;
        $this->description_17->PlaceHolder = RemoveHtml($this->description_17->caption());

        // description_18
        $this->description_18->setupEditAttributes();
        $this->description_18->EditCustomAttributes = $this->description_18->getEditCustomAttributes(); // PHP
        if (!$this->description_18->Raw) {
            $this->description_18->CurrentValue = HtmlDecode($this->description_18->CurrentValue);
        }
        $this->description_18->EditValue = $this->description_18->CurrentValue;
        $this->description_18->PlaceHolder = RemoveHtml($this->description_18->caption());

        // description_19
        $this->description_19->setupEditAttributes();
        $this->description_19->EditCustomAttributes = $this->description_19->getEditCustomAttributes(); // PHP
        if (!$this->description_19->Raw) {
            $this->description_19->CurrentValue = HtmlDecode($this->description_19->CurrentValue);
        }
        $this->description_19->EditValue = $this->description_19->CurrentValue;
        $this->description_19->PlaceHolder = RemoveHtml($this->description_19->caption());

        // description_20
        $this->description_20->setupEditAttributes();
        $this->description_20->EditValue = $this->description_20->options(true);
        $this->description_20->PlaceHolder = RemoveHtml($this->description_20->caption());

        // production_site
        $this->production_site->setupEditAttributes();
        $this->production_site->PlaceHolder = RemoveHtml($this->production_site->caption());

        // jc_no
        $this->jc_no->setupEditAttributes();
        if (!$this->jc_no->Raw) {
            $this->jc_no->CurrentValue = HtmlDecode($this->jc_no->CurrentValue);
        }
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

        // a_operator

        // a_datetime

        // app_operator
        $this->app_operator->setupEditAttributes();
        $this->app_operator->PlaceHolder = RemoveHtml($this->app_operator->caption());

        // app_datetime
        $this->app_datetime->setupEditAttributes();
        $this->app_datetime->EditValue = FormatDateTime($this->app_datetime->CurrentValue, $this->app_datetime->formatPattern());
        $this->app_datetime->PlaceHolder = RemoveHtml($this->app_datetime->caption());

        // c_operator
        $this->c_operator->setupEditAttributes();
        $this->c_operator->PlaceHolder = RemoveHtml($this->c_operator->caption());

        // c_datetime
        $this->c_datetime->setupEditAttributes();
        $this->c_datetime->EditValue = FormatDateTime($this->c_datetime->CurrentValue, $this->c_datetime->formatPattern());
        $this->c_datetime->PlaceHolder = RemoveHtml($this->c_datetime->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->job_category);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->item_size);
                    $doc->exportCaption($this->description_03);
                    $doc->exportCaption($this->description_02);
                    $doc->exportCaption($this->description_09);
                    $doc->exportCaption($this->description_01);
                    $doc->exportCaption($this->description_08);
                    $doc->exportCaption($this->description_07);
                    $doc->exportCaption($this->description_10);
                    $doc->exportCaption($this->description_04);
                    $doc->exportCaption($this->description_06);
                    $doc->exportCaption($this->description_05);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->gst);
                    $doc->exportCaption($this->despatch_date);
                    $doc->exportCaption($this->uploads);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->job_category);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->item);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->item_size);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->gst);
                    $doc->exportCaption($this->despatch_date);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->transport_type);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->po);
                        $doc->exportField($this->type);
                        $doc->exportField($this->job_category);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->item_size);
                        $doc->exportField($this->description_03);
                        $doc->exportField($this->description_02);
                        $doc->exportField($this->description_09);
                        $doc->exportField($this->description_01);
                        $doc->exportField($this->description_08);
                        $doc->exportField($this->description_07);
                        $doc->exportField($this->description_10);
                        $doc->exportField($this->description_04);
                        $doc->exportField($this->description_06);
                        $doc->exportField($this->description_05);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->gst);
                        $doc->exportField($this->despatch_date);
                        $doc->exportField($this->uploads);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->po);
                        $doc->exportField($this->type);
                        $doc->exportField($this->job_category);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->item);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->item_size);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->gst);
                        $doc->exportField($this->despatch_date);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->transport_type);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'uploads') {
            $fldName = "uploads";
            $fileNameFld = "uploads";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'p_po');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'p_po', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'p_po', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'p_po', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
