<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PEastimateView extends PEastimate
{
    use MessagesTrait;

    // Page ID
    public $PageID = "view";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PEastimateView";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "peastimateview";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->job_type->setVisibility();
        $this->job_category->setVisibility();
        $this->company_id->setVisibility();
        $this->description->setVisibility();
        $this->size->setVisibility();
        $this->quantity->setVisibility();
        $this->pages->setVisibility();
        $this->paper->setVisibility();
        $this->remarks->setVisibility();
        $this->pr_01->setVisibility();
        $this->qty_pr_01->setVisibility();
        $this->pl_01->setVisibility();
        $this->qty_pl_01->setVisibility();
        $this->pr_02->setVisibility();
        $this->qty_pr_02->setVisibility();
        $this->pl_02->setVisibility();
        $this->qty_pl_02->setVisibility();
        $this->pr_03->setVisibility();
        $this->qty_pr_03->setVisibility();
        $this->pl_03->setVisibility();
        $this->qty_pl_03->setVisibility();
        $this->pr_04->setVisibility();
        $this->qty_pr_04->setVisibility();
        $this->pl_04->setVisibility();
        $this->qty_pl_04->setVisibility();
        $this->pa_01->setVisibility();
        $this->qty_pa_01->setVisibility();
        $this->pa_02->setVisibility();
        $this->qty_pa_02->setVisibility();
        $this->pa_03->setVisibility();
        $this->qty_pa_03->setVisibility();
        $this->pa_04->setVisibility();
        $this->qty_pa_04->setVisibility();
        $this->pa_05->setVisibility();
        $this->qty_pa_05->setVisibility();
        $this->pc_01->setVisibility();
        $this->qty_pc_01->setVisibility();
        $this->pc_02->setVisibility();
        $this->qty_pc_02->setVisibility();
        $this->o_01->setVisibility();
        $this->qty_o_01->setVisibility();
        $this->lamination_type->setVisibility();
        $this->lamination_qty->setVisibility();
        $this->die_type->setVisibility();
        $this->die_qty->setVisibility();
        $this->binding_type->setVisibility();
        $this->binding_qty->setVisibility();
        $this->number_type->setVisibility();
        $this->number_qty->setVisibility();
        $this->de_01->setVisibility();
        $this->qty_de_01->setVisibility();
        $this->de_02->setVisibility();
        $this->qty_de_02->setVisibility();
        $this->de_03->setVisibility();
        $this->qty_de_03->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'p_eastimate';
        $this->TableName = 'p_eastimate';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (p_eastimate)
        if (!isset($GLOBALS["p_eastimate"]) || $GLOBALS["p_eastimate"]::class == PROJECT_NAMESPACE . "p_eastimate") {
            $GLOBALS["p_eastimate"] = &$this;
        }

        // Set up record key
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->RecKey["id"] = $keyValue;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_eastimate');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "peastimateview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $ExportOptions; // Export options
    public $OtherOptions; // Other options
    public $DisplayRecords = 1;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecKey = [];
    public $IsModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->job_type);
        $this->setupLookupOptions($this->job_category);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->size);
        $this->setupLookupOptions($this->pr_01);
        $this->setupLookupOptions($this->pl_01);
        $this->setupLookupOptions($this->pr_02);
        $this->setupLookupOptions($this->pl_02);
        $this->setupLookupOptions($this->pr_03);
        $this->setupLookupOptions($this->pl_03);
        $this->setupLookupOptions($this->pr_04);
        $this->setupLookupOptions($this->pl_04);
        $this->setupLookupOptions($this->pa_01);
        $this->setupLookupOptions($this->pa_02);
        $this->setupLookupOptions($this->pa_03);
        $this->setupLookupOptions($this->pa_04);
        $this->setupLookupOptions($this->pa_05);
        $this->setupLookupOptions($this->pc_01);
        $this->setupLookupOptions($this->pc_02);
        $this->setupLookupOptions($this->o_01);
        $this->setupLookupOptions($this->lamination_type);
        $this->setupLookupOptions($this->die_type);
        $this->setupLookupOptions($this->binding_type);
        $this->setupLookupOptions($this->number_type);
        $this->setupLookupOptions($this->de_01);
        $this->setupLookupOptions($this->de_02);
        $this->setupLookupOptions($this->de_03);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }

        // Load current record
        $loadCurrentRecord = false;
        $returnUrl = "";
        $matchRecord = false;
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (Post("id") !== null) {
            $this->id->setFormValue(Post("id"));
            $this->RecKey["id"] = $this->id->FormValue;
        } elseif (IsApi() && ($keyValue = Key(0) ?? Route(2)) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (!$loadCurrentRecord) {
            $returnUrl = "peastimatelist"; // Return to list
        }

        // Get action
        $this->CurrentAction = "show"; // Display
        switch ($this->CurrentAction) {
            case "show": // Get a record to display

                    // Load record based on key
                    if (IsApi()) {
                        $filter = $this->getRecordFilter();
                        $this->CurrentFilter = $filter;
                        $sql = $this->getCurrentSql();
                        $conn = $this->getConnection();
                        $res = ($this->Recordset = ExecuteQuery($sql, $conn));
                    } else {
                        $res = $this->loadRow();
                    }
                    if (!$res) { // Load record based on key
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $returnUrl = "peastimatelist"; // No matching record, return to list
                    }
                break;
        }
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->RowType = RowType::VIEW;
        $this->resetAttributes();
        $this->renderRow();

        // Normal return
        if (IsApi()) {
            if (!$this->isExport()) {
                $row = $this->getRecordsFromRecordset($this->Recordset, true); // Get current record only
                $this->Recordset?->free();
                WriteJson(["success" => true, "action" => Config("API_VIEW_ACTION"), $this->TableVar => $row]);
                $this->terminate(true);
            }
            return;
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Disable Add/Edit/Copy/Delete for Modal and UseAjaxActions
        /*
        if ($this->IsModal && $this->UseAjaxActions) {
            $this->AddUrl = "";
            $this->EditUrl = "";
            $this->CopyUrl = "";
            $this->DeleteUrl = "";
        }
        */
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();

        // Copy
        $item = &$option->add("copy");
        $copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        }
        $item->Visible = $this->CopyUrl != "" && $Security->canAdd();

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
        $option->UseDropDownButton = !IsJsonResponse() && false;
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->job_type->setDbValue($row['job_type']);
        $this->job_category->setDbValue($row['job_category']);
        $this->company_id->setDbValue($row['company_id']);
        $this->description->setDbValue($row['description']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->pages->setDbValue($row['pages']);
        $this->paper->setDbValue($row['paper']);
        $this->remarks->setDbValue($row['remarks']);
        $this->pr_01->setDbValue($row['pr_01']);
        $this->qty_pr_01->setDbValue($row['qty_pr_01']);
        $this->pl_01->setDbValue($row['pl_01']);
        $this->qty_pl_01->setDbValue($row['qty_pl_01']);
        $this->pr_02->setDbValue($row['pr_02']);
        $this->qty_pr_02->setDbValue($row['qty_pr_02']);
        $this->pl_02->setDbValue($row['pl_02']);
        $this->qty_pl_02->setDbValue($row['qty_pl_02']);
        $this->pr_03->setDbValue($row['pr_03']);
        $this->qty_pr_03->setDbValue($row['qty_pr_03']);
        $this->pl_03->setDbValue($row['pl_03']);
        $this->qty_pl_03->setDbValue($row['qty_pl_03']);
        $this->pr_04->setDbValue($row['pr_04']);
        $this->qty_pr_04->setDbValue($row['qty_pr_04']);
        $this->pl_04->setDbValue($row['pl_04']);
        $this->qty_pl_04->setDbValue($row['qty_pl_04']);
        $this->pa_01->setDbValue($row['pa_01']);
        $this->qty_pa_01->setDbValue($row['qty_pa_01']);
        $this->pa_02->setDbValue($row['pa_02']);
        $this->qty_pa_02->setDbValue($row['qty_pa_02']);
        $this->pa_03->setDbValue($row['pa_03']);
        $this->qty_pa_03->setDbValue($row['qty_pa_03']);
        $this->pa_04->setDbValue($row['pa_04']);
        $this->qty_pa_04->setDbValue($row['qty_pa_04']);
        $this->pa_05->setDbValue($row['pa_05']);
        $this->qty_pa_05->setDbValue($row['qty_pa_05']);
        $this->pc_01->setDbValue($row['pc_01']);
        $this->qty_pc_01->setDbValue($row['qty_pc_01']);
        $this->pc_02->setDbValue($row['pc_02']);
        $this->qty_pc_02->setDbValue($row['qty_pc_02']);
        $this->o_01->setDbValue($row['o_01']);
        $this->qty_o_01->setDbValue($row['qty_o_01']);
        $this->lamination_type->setDbValue($row['lamination_type']);
        $this->lamination_qty->setDbValue($row['lamination_qty']);
        $this->die_type->setDbValue($row['die_type']);
        $this->die_qty->setDbValue($row['die_qty']);
        $this->binding_type->setDbValue($row['binding_type']);
        $this->binding_qty->setDbValue($row['binding_qty']);
        $this->number_type->setDbValue($row['number_type']);
        $this->number_qty->setDbValue($row['number_qty']);
        $this->de_01->setDbValue($row['de_01']);
        $this->qty_de_01->setDbValue($row['qty_de_01']);
        $this->de_02->setDbValue($row['de_02']);
        $this->qty_de_02->setDbValue($row['qty_de_02']);
        $this->de_03->setDbValue($row['de_03']);
        $this->qty_de_03->setDbValue($row['qty_de_03']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['job_type'] = $this->job_type->DefaultValue;
        $row['job_category'] = $this->job_category->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['pages'] = $this->pages->DefaultValue;
        $row['paper'] = $this->paper->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['pr_01'] = $this->pr_01->DefaultValue;
        $row['qty_pr_01'] = $this->qty_pr_01->DefaultValue;
        $row['pl_01'] = $this->pl_01->DefaultValue;
        $row['qty_pl_01'] = $this->qty_pl_01->DefaultValue;
        $row['pr_02'] = $this->pr_02->DefaultValue;
        $row['qty_pr_02'] = $this->qty_pr_02->DefaultValue;
        $row['pl_02'] = $this->pl_02->DefaultValue;
        $row['qty_pl_02'] = $this->qty_pl_02->DefaultValue;
        $row['pr_03'] = $this->pr_03->DefaultValue;
        $row['qty_pr_03'] = $this->qty_pr_03->DefaultValue;
        $row['pl_03'] = $this->pl_03->DefaultValue;
        $row['qty_pl_03'] = $this->qty_pl_03->DefaultValue;
        $row['pr_04'] = $this->pr_04->DefaultValue;
        $row['qty_pr_04'] = $this->qty_pr_04->DefaultValue;
        $row['pl_04'] = $this->pl_04->DefaultValue;
        $row['qty_pl_04'] = $this->qty_pl_04->DefaultValue;
        $row['pa_01'] = $this->pa_01->DefaultValue;
        $row['qty_pa_01'] = $this->qty_pa_01->DefaultValue;
        $row['pa_02'] = $this->pa_02->DefaultValue;
        $row['qty_pa_02'] = $this->qty_pa_02->DefaultValue;
        $row['pa_03'] = $this->pa_03->DefaultValue;
        $row['qty_pa_03'] = $this->qty_pa_03->DefaultValue;
        $row['pa_04'] = $this->pa_04->DefaultValue;
        $row['qty_pa_04'] = $this->qty_pa_04->DefaultValue;
        $row['pa_05'] = $this->pa_05->DefaultValue;
        $row['qty_pa_05'] = $this->qty_pa_05->DefaultValue;
        $row['pc_01'] = $this->pc_01->DefaultValue;
        $row['qty_pc_01'] = $this->qty_pc_01->DefaultValue;
        $row['pc_02'] = $this->pc_02->DefaultValue;
        $row['qty_pc_02'] = $this->qty_pc_02->DefaultValue;
        $row['o_01'] = $this->o_01->DefaultValue;
        $row['qty_o_01'] = $this->qty_o_01->DefaultValue;
        $row['lamination_type'] = $this->lamination_type->DefaultValue;
        $row['lamination_qty'] = $this->lamination_qty->DefaultValue;
        $row['die_type'] = $this->die_type->DefaultValue;
        $row['die_qty'] = $this->die_qty->DefaultValue;
        $row['binding_type'] = $this->binding_type->DefaultValue;
        $row['binding_qty'] = $this->binding_qty->DefaultValue;
        $row['number_type'] = $this->number_type->DefaultValue;
        $row['number_qty'] = $this->number_qty->DefaultValue;
        $row['de_01'] = $this->de_01->DefaultValue;
        $row['qty_de_01'] = $this->qty_de_01->DefaultValue;
        $row['de_02'] = $this->de_02->DefaultValue;
        $row['qty_de_02'] = $this->qty_de_02->DefaultValue;
        $row['de_03'] = $this->de_03->DefaultValue;
        $row['qty_de_03'] = $this->qty_de_03->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // job_type

        // job_category

        // company_id

        // description

        // size

        // quantity

        // pages

        // paper

        // remarks

        // pr_01

        // qty_pr_01

        // pl_01

        // qty_pl_01

        // pr_02

        // qty_pr_02

        // pl_02

        // qty_pl_02

        // pr_03

        // qty_pr_03

        // pl_03

        // qty_pl_03

        // pr_04

        // qty_pr_04

        // pl_04

        // qty_pl_04

        // pa_01

        // qty_pa_01

        // pa_02

        // qty_pa_02

        // pa_03

        // qty_pa_03

        // pa_04

        // qty_pa_04

        // pa_05

        // qty_pa_05

        // pc_01

        // qty_pc_01

        // pc_02

        // qty_pc_02

        // o_01

        // qty_o_01

        // lamination_type

        // lamination_qty

        // die_type

        // die_qty

        // binding_type

        // binding_qty

        // number_type

        // number_qty

        // de_01

        // qty_de_01

        // de_02

        // qty_de_02

        // de_03

        // qty_de_03

        // operator

        // datetime

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // job_type
            if (strval($this->job_type->CurrentValue) != "") {
                $this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
            } else {
                $this->job_type->ViewValue = null;
            }

            // job_category
            if (strval($this->job_category->CurrentValue) != "") {
                $this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
            } else {
                $this->job_category->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // size
            $curVal = strval($this->size->CurrentValue);
            if ($curVal != "") {
                $this->size->ViewValue = $this->size->lookupCacheOption($curVal);
                if ($this->size->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->size->Lookup->getTable()->Fields["description"]->searchExpression(), "=", $curVal, $this->size->Lookup->getTable()->Fields["description"]->searchDataType(), "");
                    $lookupFilter = $this->size->getSelectFilter($this); // PHP
                    $sqlWrk = $this->size->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->size->Lookup->renderViewRow($rswrk[0]);
                        $this->size->ViewValue = $this->size->displayValue($arwrk);
                    } else {
                        $this->size->ViewValue = $this->size->CurrentValue;
                    }
                }
            } else {
                $this->size->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // pages
            $this->pages->ViewValue = $this->pages->CurrentValue;

            // paper
            $this->paper->ViewValue = $this->paper->CurrentValue;
            $this->paper->ViewValue = FormatNumber($this->paper->ViewValue, $this->paper->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pr_01
            $curVal = strval($this->pr_01->CurrentValue);
            if ($curVal != "") {
                $this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
                if ($this->pr_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
                    } else {
                        $this->pr_01->ViewValue = $this->pr_01->CurrentValue;
                    }
                }
            } else {
                $this->pr_01->ViewValue = null;
            }

            // qty_pr_01
            $this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
            $this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, $this->qty_pr_01->formatPattern());

            // pl_01
            $curVal = strval($this->pl_01->CurrentValue);
            if ($curVal != "") {
                $this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
                if ($this->pl_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
                    } else {
                        $this->pl_01->ViewValue = $this->pl_01->CurrentValue;
                    }
                }
            } else {
                $this->pl_01->ViewValue = null;
            }

            // qty_pl_01
            $this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
            $this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, $this->qty_pl_01->formatPattern());

            // pr_02
            $curVal = strval($this->pr_02->CurrentValue);
            if ($curVal != "") {
                $this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
                if ($this->pr_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
                    } else {
                        $this->pr_02->ViewValue = $this->pr_02->CurrentValue;
                    }
                }
            } else {
                $this->pr_02->ViewValue = null;
            }

            // qty_pr_02
            $this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
            $this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, $this->qty_pr_02->formatPattern());

            // pl_02
            $curVal = strval($this->pl_02->CurrentValue);
            if ($curVal != "") {
                $this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
                if ($this->pl_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
                    } else {
                        $this->pl_02->ViewValue = $this->pl_02->CurrentValue;
                    }
                }
            } else {
                $this->pl_02->ViewValue = null;
            }

            // qty_pl_02
            $this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
            $this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, $this->qty_pl_02->formatPattern());

            // pr_03
            $curVal = strval($this->pr_03->CurrentValue);
            if ($curVal != "") {
                $this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
                if ($this->pr_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
                    } else {
                        $this->pr_03->ViewValue = $this->pr_03->CurrentValue;
                    }
                }
            } else {
                $this->pr_03->ViewValue = null;
            }

            // qty_pr_03
            $this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
            $this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, $this->qty_pr_03->formatPattern());

            // pl_03
            $curVal = strval($this->pl_03->CurrentValue);
            if ($curVal != "") {
                $this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
                if ($this->pl_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
                    } else {
                        $this->pl_03->ViewValue = $this->pl_03->CurrentValue;
                    }
                }
            } else {
                $this->pl_03->ViewValue = null;
            }

            // qty_pl_03
            $this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
            $this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, $this->qty_pl_03->formatPattern());

            // pr_04
            $curVal = strval($this->pr_04->CurrentValue);
            if ($curVal != "") {
                $this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
                if ($this->pr_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
                    } else {
                        $this->pr_04->ViewValue = $this->pr_04->CurrentValue;
                    }
                }
            } else {
                $this->pr_04->ViewValue = null;
            }

            // qty_pr_04
            $this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
            $this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, $this->qty_pr_04->formatPattern());

            // pl_04
            $curVal = strval($this->pl_04->CurrentValue);
            if ($curVal != "") {
                $this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
                if ($this->pl_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
                    } else {
                        $this->pl_04->ViewValue = $this->pl_04->CurrentValue;
                    }
                }
            } else {
                $this->pl_04->ViewValue = null;
            }

            // qty_pl_04
            $this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
            $this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, $this->qty_pl_04->formatPattern());

            // pa_01
            $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
            $curVal = strval($this->pa_01->CurrentValue);
            if ($curVal != "") {
                $this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
                if ($this->pa_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
                    } else {
                        $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
                    }
                }
            } else {
                $this->pa_01->ViewValue = null;
            }

            // qty_pa_01
            $this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
            $this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, $this->qty_pa_01->formatPattern());

            // pa_02
            $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
            $curVal = strval($this->pa_02->CurrentValue);
            if ($curVal != "") {
                $this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
                if ($this->pa_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
                    } else {
                        $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
                    }
                }
            } else {
                $this->pa_02->ViewValue = null;
            }

            // qty_pa_02
            $this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
            $this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, $this->qty_pa_02->formatPattern());

            // pa_03
            $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
            $curVal = strval($this->pa_03->CurrentValue);
            if ($curVal != "") {
                $this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
                if ($this->pa_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
                    } else {
                        $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
                    }
                }
            } else {
                $this->pa_03->ViewValue = null;
            }

            // qty_pa_03
            $this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
            $this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, $this->qty_pa_03->formatPattern());

            // pa_04
            $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
            $curVal = strval($this->pa_04->CurrentValue);
            if ($curVal != "") {
                $this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
                if ($this->pa_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
                    } else {
                        $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
                    }
                }
            } else {
                $this->pa_04->ViewValue = null;
            }

            // qty_pa_04
            $this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
            $this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, $this->qty_pa_04->formatPattern());

            // pa_05
            $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
            $curVal = strval($this->pa_05->CurrentValue);
            if ($curVal != "") {
                $this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
                if ($this->pa_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_05->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
                    } else {
                        $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
                    }
                }
            } else {
                $this->pa_05->ViewValue = null;
            }

            // qty_pa_05
            $this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
            $this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, $this->qty_pa_05->formatPattern());

            // pc_01
            $curVal = strval($this->pc_01->CurrentValue);
            if ($curVal != "") {
                $this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
                if ($this->pc_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pc_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pc_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pc_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pc_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
                    } else {
                        $this->pc_01->ViewValue = $this->pc_01->CurrentValue;
                    }
                }
            } else {
                $this->pc_01->ViewValue = null;
            }

            // qty_pc_01
            $this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
            $this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, $this->qty_pc_01->formatPattern());

            // pc_02
            $curVal = strval($this->pc_02->CurrentValue);
            if ($curVal != "") {
                $this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
                if ($this->pc_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pc_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pc_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pc_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pc_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
                    } else {
                        $this->pc_02->ViewValue = $this->pc_02->CurrentValue;
                    }
                }
            } else {
                $this->pc_02->ViewValue = null;
            }

            // qty_pc_02
            $this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
            $this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, $this->qty_pc_02->formatPattern());

            // o_01
            $curVal = strval($this->o_01->CurrentValue);
            if ($curVal != "") {
                $this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
                if ($this->o_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->o_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->o_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->o_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->o_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->o_01->Lookup->renderViewRow($rswrk[0]);
                        $this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
                    } else {
                        $this->o_01->ViewValue = $this->o_01->CurrentValue;
                    }
                }
            } else {
                $this->o_01->ViewValue = null;
            }

            // qty_o_01
            $this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
            $this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, $this->qty_o_01->formatPattern());

            // lamination_type
            $curVal = strval($this->lamination_type->CurrentValue);
            if ($curVal != "") {
                $this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
                if ($this->lamination_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->lamination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->lamination_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->lamination_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->lamination_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->lamination_type->Lookup->renderViewRow($rswrk[0]);
                        $this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
                    } else {
                        $this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
                    }
                }
            } else {
                $this->lamination_type->ViewValue = null;
            }

            // lamination_qty
            $this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
            $this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, $this->lamination_qty->formatPattern());

            // die_type
            $curVal = strval($this->die_type->CurrentValue);
            if ($curVal != "") {
                $this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
                if ($this->die_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->die_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->die_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->die_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->die_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->die_type->Lookup->renderViewRow($rswrk[0]);
                        $this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
                    } else {
                        $this->die_type->ViewValue = $this->die_type->CurrentValue;
                    }
                }
            } else {
                $this->die_type->ViewValue = null;
            }

            // die_qty
            $this->die_qty->ViewValue = $this->die_qty->CurrentValue;
            $this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, $this->die_qty->formatPattern());

            // binding_type
            $curVal = strval($this->binding_type->CurrentValue);
            if ($curVal != "") {
                $this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
                if ($this->binding_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->binding_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->binding_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->binding_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->binding_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->binding_type->Lookup->renderViewRow($rswrk[0]);
                        $this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
                    } else {
                        $this->binding_type->ViewValue = $this->binding_type->CurrentValue;
                    }
                }
            } else {
                $this->binding_type->ViewValue = null;
            }

            // binding_qty
            $this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
            $this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, $this->binding_qty->formatPattern());

            // number_type
            $curVal = strval($this->number_type->CurrentValue);
            if ($curVal != "") {
                $this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
                if ($this->number_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->number_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->number_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->number_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->number_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->number_type->Lookup->renderViewRow($rswrk[0]);
                        $this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
                    } else {
                        $this->number_type->ViewValue = $this->number_type->CurrentValue;
                    }
                }
            } else {
                $this->number_type->ViewValue = null;
            }

            // number_qty
            $this->number_qty->ViewValue = $this->number_qty->CurrentValue;
            $this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, $this->number_qty->formatPattern());

            // de_01
            $curVal = strval($this->de_01->CurrentValue);
            if ($curVal != "") {
                $this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
                if ($this->de_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_01->Lookup->renderViewRow($rswrk[0]);
                        $this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
                    } else {
                        $this->de_01->ViewValue = $this->de_01->CurrentValue;
                    }
                }
            } else {
                $this->de_01->ViewValue = null;
            }

            // qty_de_01
            $this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
            $this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, $this->qty_de_01->formatPattern());

            // de_02
            $curVal = strval($this->de_02->CurrentValue);
            if ($curVal != "") {
                $this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
                if ($this->de_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_02->Lookup->renderViewRow($rswrk[0]);
                        $this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
                    } else {
                        $this->de_02->ViewValue = $this->de_02->CurrentValue;
                    }
                }
            } else {
                $this->de_02->ViewValue = null;
            }

            // qty_de_02
            $this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
            $this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, $this->qty_de_02->formatPattern());

            // de_03
            $curVal = strval($this->de_03->CurrentValue);
            if ($curVal != "") {
                $this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
                if ($this->de_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_03->Lookup->renderViewRow($rswrk[0]);
                        $this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
                    } else {
                        $this->de_03->ViewValue = $this->de_03->CurrentValue;
                    }
                }
            } else {
                $this->de_03->ViewValue = null;
            }

            // qty_de_03
            $this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
            $this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, $this->qty_de_03->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // job_type
            $this->job_type->HrefValue = "";
            $this->job_type->TooltipValue = "";

            // job_category
            $this->job_category->HrefValue = "";
            $this->job_category->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // pages
            $this->pages->HrefValue = "";
            $this->pages->TooltipValue = "";

            // paper
            $this->paper->HrefValue = "";
            $this->paper->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // pr_01
            $this->pr_01->HrefValue = "";
            $this->pr_01->TooltipValue = "";

            // qty_pr_01
            $this->qty_pr_01->HrefValue = "";
            $this->qty_pr_01->TooltipValue = "";

            // pl_01
            $this->pl_01->HrefValue = "";
            $this->pl_01->TooltipValue = "";

            // qty_pl_01
            $this->qty_pl_01->HrefValue = "";
            $this->qty_pl_01->TooltipValue = "";

            // pr_02
            $this->pr_02->HrefValue = "";
            $this->pr_02->TooltipValue = "";

            // qty_pr_02
            $this->qty_pr_02->HrefValue = "";
            $this->qty_pr_02->TooltipValue = "";

            // pl_02
            $this->pl_02->HrefValue = "";
            $this->pl_02->TooltipValue = "";

            // qty_pl_02
            $this->qty_pl_02->HrefValue = "";
            $this->qty_pl_02->TooltipValue = "";

            // pr_03
            $this->pr_03->HrefValue = "";
            $this->pr_03->TooltipValue = "";

            // qty_pr_03
            $this->qty_pr_03->HrefValue = "";
            $this->qty_pr_03->TooltipValue = "";

            // pl_03
            $this->pl_03->HrefValue = "";
            $this->pl_03->TooltipValue = "";

            // qty_pl_03
            $this->qty_pl_03->HrefValue = "";
            $this->qty_pl_03->TooltipValue = "";

            // pr_04
            $this->pr_04->HrefValue = "";
            $this->pr_04->TooltipValue = "";

            // qty_pr_04
            $this->qty_pr_04->HrefValue = "";
            $this->qty_pr_04->TooltipValue = "";

            // pl_04
            $this->pl_04->HrefValue = "";
            $this->pl_04->TooltipValue = "";

            // qty_pl_04
            $this->qty_pl_04->HrefValue = "";
            $this->qty_pl_04->TooltipValue = "";

            // pa_01
            $this->pa_01->HrefValue = "";
            $this->pa_01->TooltipValue = "";

            // qty_pa_01
            $this->qty_pa_01->HrefValue = "";
            $this->qty_pa_01->TooltipValue = "";

            // pa_02
            $this->pa_02->HrefValue = "";
            $this->pa_02->TooltipValue = "";

            // qty_pa_02
            $this->qty_pa_02->HrefValue = "";
            $this->qty_pa_02->TooltipValue = "";

            // pa_03
            $this->pa_03->HrefValue = "";
            $this->pa_03->TooltipValue = "";

            // qty_pa_03
            $this->qty_pa_03->HrefValue = "";
            $this->qty_pa_03->TooltipValue = "";

            // pa_04
            $this->pa_04->HrefValue = "";
            $this->pa_04->TooltipValue = "";

            // qty_pa_04
            $this->qty_pa_04->HrefValue = "";
            $this->qty_pa_04->TooltipValue = "";

            // pa_05
            $this->pa_05->HrefValue = "";
            $this->pa_05->TooltipValue = "";

            // qty_pa_05
            $this->qty_pa_05->HrefValue = "";
            $this->qty_pa_05->TooltipValue = "";

            // pc_01
            $this->pc_01->HrefValue = "";
            $this->pc_01->TooltipValue = "";

            // qty_pc_01
            $this->qty_pc_01->HrefValue = "";
            $this->qty_pc_01->TooltipValue = "";

            // pc_02
            $this->pc_02->HrefValue = "";
            $this->pc_02->TooltipValue = "";

            // qty_pc_02
            $this->qty_pc_02->HrefValue = "";
            $this->qty_pc_02->TooltipValue = "";

            // o_01
            $this->o_01->HrefValue = "";
            $this->o_01->TooltipValue = "";

            // qty_o_01
            $this->qty_o_01->HrefValue = "";
            $this->qty_o_01->TooltipValue = "";

            // lamination_type
            $this->lamination_type->HrefValue = "";
            $this->lamination_type->TooltipValue = "";

            // lamination_qty
            $this->lamination_qty->HrefValue = "";
            $this->lamination_qty->TooltipValue = "";

            // die_type
            $this->die_type->HrefValue = "";
            $this->die_type->TooltipValue = "";

            // die_qty
            $this->die_qty->HrefValue = "";
            $this->die_qty->TooltipValue = "";

            // binding_type
            $this->binding_type->HrefValue = "";
            $this->binding_type->TooltipValue = "";

            // binding_qty
            $this->binding_qty->HrefValue = "";
            $this->binding_qty->TooltipValue = "";

            // number_type
            $this->number_type->HrefValue = "";
            $this->number_type->TooltipValue = "";

            // number_qty
            $this->number_qty->HrefValue = "";
            $this->number_qty->TooltipValue = "";

            // de_01
            $this->de_01->HrefValue = "";
            $this->de_01->TooltipValue = "";

            // qty_de_01
            $this->qty_de_01->HrefValue = "";
            $this->qty_de_01->TooltipValue = "";

            // de_02
            $this->de_02->HrefValue = "";
            $this->de_02->TooltipValue = "";

            // qty_de_02
            $this->qty_de_02->HrefValue = "";
            $this->qty_de_02->TooltipValue = "";

            // de_03
            $this->de_03->HrefValue = "";
            $this->de_03->TooltipValue = "";

            // qty_de_03
            $this->qty_de_03->HrefValue = "";
            $this->qty_de_03->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("peastimatelist"), "", $this->TableVar, true);
        $pageId = "view";
        $Breadcrumb->add("view", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $pages->add(8);
        $pages->add(9);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_job_type":
                    break;
                case "x_job_category":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_size":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pc_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pc_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_o_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lamination_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_die_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_binding_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_number_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }
}
