<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PEastimateSearch extends PEastimate
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PEastimateSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "peastimatesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->job_type->setVisibility();
        $this->job_category->setVisibility();
        $this->company_id->setVisibility();
        $this->description->setVisibility();
        $this->size->setVisibility();
        $this->quantity->setVisibility();
        $this->pages->setVisibility();
        $this->paper->setVisibility();
        $this->remarks->setVisibility();
        $this->pr_01->setVisibility();
        $this->qty_pr_01->setVisibility();
        $this->pl_01->setVisibility();
        $this->qty_pl_01->setVisibility();
        $this->pr_02->setVisibility();
        $this->qty_pr_02->setVisibility();
        $this->pl_02->setVisibility();
        $this->qty_pl_02->setVisibility();
        $this->pr_03->setVisibility();
        $this->qty_pr_03->setVisibility();
        $this->pl_03->setVisibility();
        $this->qty_pl_03->setVisibility();
        $this->pr_04->setVisibility();
        $this->qty_pr_04->setVisibility();
        $this->pl_04->setVisibility();
        $this->qty_pl_04->setVisibility();
        $this->pa_01->setVisibility();
        $this->qty_pa_01->setVisibility();
        $this->pa_02->setVisibility();
        $this->qty_pa_02->setVisibility();
        $this->pa_03->setVisibility();
        $this->qty_pa_03->setVisibility();
        $this->pa_04->setVisibility();
        $this->qty_pa_04->setVisibility();
        $this->pa_05->setVisibility();
        $this->qty_pa_05->setVisibility();
        $this->pc_01->setVisibility();
        $this->qty_pc_01->setVisibility();
        $this->pc_02->setVisibility();
        $this->qty_pc_02->setVisibility();
        $this->o_01->setVisibility();
        $this->qty_o_01->setVisibility();
        $this->lamination_type->setVisibility();
        $this->lamination_qty->setVisibility();
        $this->die_type->setVisibility();
        $this->die_qty->setVisibility();
        $this->binding_type->setVisibility();
        $this->binding_qty->setVisibility();
        $this->number_type->setVisibility();
        $this->number_qty->setVisibility();
        $this->de_01->setVisibility();
        $this->qty_de_01->setVisibility();
        $this->de_02->setVisibility();
        $this->qty_de_02->setVisibility();
        $this->de_03->setVisibility();
        $this->qty_de_03->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'p_eastimate';
        $this->TableName = 'p_eastimate';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (p_eastimate)
        if (!isset($GLOBALS["p_eastimate"]) || $GLOBALS["p_eastimate"]::class == PROJECT_NAMESPACE . "p_eastimate") {
            $GLOBALS["p_eastimate"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_eastimate');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "peastimateview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->job_type);
        $this->setupLookupOptions($this->job_category);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->size);
        $this->setupLookupOptions($this->pr_01);
        $this->setupLookupOptions($this->pl_01);
        $this->setupLookupOptions($this->pr_02);
        $this->setupLookupOptions($this->pl_02);
        $this->setupLookupOptions($this->pr_03);
        $this->setupLookupOptions($this->pl_03);
        $this->setupLookupOptions($this->pr_04);
        $this->setupLookupOptions($this->pl_04);
        $this->setupLookupOptions($this->pa_01);
        $this->setupLookupOptions($this->pa_02);
        $this->setupLookupOptions($this->pa_03);
        $this->setupLookupOptions($this->pa_04);
        $this->setupLookupOptions($this->pa_05);
        $this->setupLookupOptions($this->pc_01);
        $this->setupLookupOptions($this->pc_02);
        $this->setupLookupOptions($this->o_01);
        $this->setupLookupOptions($this->lamination_type);
        $this->setupLookupOptions($this->die_type);
        $this->setupLookupOptions($this->binding_type);
        $this->setupLookupOptions($this->number_type);
        $this->setupLookupOptions($this->de_01);
        $this->setupLookupOptions($this->de_02);
        $this->setupLookupOptions($this->de_03);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "peastimatelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->job_type); // job_type
        $this->buildSearchUrl($srchUrl, $this->job_category); // job_category
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        $this->buildSearchUrl($srchUrl, $this->description); // description
        $this->buildSearchUrl($srchUrl, $this->size); // size
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->pages); // pages
        $this->buildSearchUrl($srchUrl, $this->paper); // paper
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->pr_01); // pr_01
        $this->buildSearchUrl($srchUrl, $this->qty_pr_01); // qty_pr_01
        $this->buildSearchUrl($srchUrl, $this->pl_01); // pl_01
        $this->buildSearchUrl($srchUrl, $this->qty_pl_01); // qty_pl_01
        $this->buildSearchUrl($srchUrl, $this->pr_02); // pr_02
        $this->buildSearchUrl($srchUrl, $this->qty_pr_02); // qty_pr_02
        $this->buildSearchUrl($srchUrl, $this->pl_02); // pl_02
        $this->buildSearchUrl($srchUrl, $this->qty_pl_02); // qty_pl_02
        $this->buildSearchUrl($srchUrl, $this->pr_03); // pr_03
        $this->buildSearchUrl($srchUrl, $this->qty_pr_03); // qty_pr_03
        $this->buildSearchUrl($srchUrl, $this->pl_03); // pl_03
        $this->buildSearchUrl($srchUrl, $this->qty_pl_03); // qty_pl_03
        $this->buildSearchUrl($srchUrl, $this->pr_04); // pr_04
        $this->buildSearchUrl($srchUrl, $this->qty_pr_04); // qty_pr_04
        $this->buildSearchUrl($srchUrl, $this->pl_04); // pl_04
        $this->buildSearchUrl($srchUrl, $this->qty_pl_04); // qty_pl_04
        $this->buildSearchUrl($srchUrl, $this->pa_01); // pa_01
        $this->buildSearchUrl($srchUrl, $this->qty_pa_01); // qty_pa_01
        $this->buildSearchUrl($srchUrl, $this->pa_02); // pa_02
        $this->buildSearchUrl($srchUrl, $this->qty_pa_02); // qty_pa_02
        $this->buildSearchUrl($srchUrl, $this->pa_03); // pa_03
        $this->buildSearchUrl($srchUrl, $this->qty_pa_03); // qty_pa_03
        $this->buildSearchUrl($srchUrl, $this->pa_04); // pa_04
        $this->buildSearchUrl($srchUrl, $this->qty_pa_04); // qty_pa_04
        $this->buildSearchUrl($srchUrl, $this->pa_05); // pa_05
        $this->buildSearchUrl($srchUrl, $this->qty_pa_05); // qty_pa_05
        $this->buildSearchUrl($srchUrl, $this->pc_01); // pc_01
        $this->buildSearchUrl($srchUrl, $this->qty_pc_01); // qty_pc_01
        $this->buildSearchUrl($srchUrl, $this->pc_02); // pc_02
        $this->buildSearchUrl($srchUrl, $this->qty_pc_02); // qty_pc_02
        $this->buildSearchUrl($srchUrl, $this->o_01); // o_01
        $this->buildSearchUrl($srchUrl, $this->qty_o_01); // qty_o_01
        $this->buildSearchUrl($srchUrl, $this->lamination_type); // lamination_type
        $this->buildSearchUrl($srchUrl, $this->lamination_qty); // lamination_qty
        $this->buildSearchUrl($srchUrl, $this->die_type); // die_type
        $this->buildSearchUrl($srchUrl, $this->die_qty); // die_qty
        $this->buildSearchUrl($srchUrl, $this->binding_type); // binding_type
        $this->buildSearchUrl($srchUrl, $this->binding_qty); // binding_qty
        $this->buildSearchUrl($srchUrl, $this->number_type); // number_type
        $this->buildSearchUrl($srchUrl, $this->number_qty); // number_qty
        $this->buildSearchUrl($srchUrl, $this->de_01); // de_01
        $this->buildSearchUrl($srchUrl, $this->qty_de_01); // qty_de_01
        $this->buildSearchUrl($srchUrl, $this->de_02); // de_02
        $this->buildSearchUrl($srchUrl, $this->qty_de_02); // qty_de_02
        $this->buildSearchUrl($srchUrl, $this->de_03); // de_03
        $this->buildSearchUrl($srchUrl, $this->qty_de_03); // qty_de_03
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // job_type
        if ($this->job_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // job_category
        if ($this->job_category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description
        if ($this->description->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size
        if ($this->size->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pages
        if ($this->pages->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // paper
        if ($this->paper->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pr_01
        if ($this->pr_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pr_01
        if ($this->qty_pr_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pl_01
        if ($this->pl_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pl_01
        if ($this->qty_pl_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pr_02
        if ($this->pr_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pr_02
        if ($this->qty_pr_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pl_02
        if ($this->pl_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pl_02
        if ($this->qty_pl_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pr_03
        if ($this->pr_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pr_03
        if ($this->qty_pr_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pl_03
        if ($this->pl_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pl_03
        if ($this->qty_pl_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pr_04
        if ($this->pr_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pr_04
        if ($this->qty_pr_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pl_04
        if ($this->pl_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pl_04
        if ($this->qty_pl_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_01
        if ($this->pa_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pa_01
        if ($this->qty_pa_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_02
        if ($this->pa_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pa_02
        if ($this->qty_pa_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_03
        if ($this->pa_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pa_03
        if ($this->qty_pa_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_04
        if ($this->pa_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pa_04
        if ($this->qty_pa_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pa_05
        if ($this->pa_05->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pa_05
        if ($this->qty_pa_05->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_01
        if ($this->pc_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pc_01
        if ($this->qty_pc_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pc_02
        if ($this->pc_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_pc_02
        if ($this->qty_pc_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // o_01
        if ($this->o_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_o_01
        if ($this->qty_o_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lamination_type
        if ($this->lamination_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lamination_qty
        if ($this->lamination_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // die_type
        if ($this->die_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // die_qty
        if ($this->die_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // binding_type
        if ($this->binding_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // binding_qty
        if ($this->binding_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // number_type
        if ($this->number_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // number_qty
        if ($this->number_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // de_01
        if ($this->de_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_de_01
        if ($this->qty_de_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // de_02
        if ($this->de_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_de_02
        if ($this->qty_de_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // de_03
        if ($this->de_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty_de_03
        if ($this->qty_de_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // job_type
        $this->job_type->RowCssClass = "row";

        // job_category
        $this->job_category->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // pages
        $this->pages->RowCssClass = "row";

        // paper
        $this->paper->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // pr_01
        $this->pr_01->RowCssClass = "row";

        // qty_pr_01
        $this->qty_pr_01->RowCssClass = "row";

        // pl_01
        $this->pl_01->RowCssClass = "row";

        // qty_pl_01
        $this->qty_pl_01->RowCssClass = "row";

        // pr_02
        $this->pr_02->RowCssClass = "row";

        // qty_pr_02
        $this->qty_pr_02->RowCssClass = "row";

        // pl_02
        $this->pl_02->RowCssClass = "row";

        // qty_pl_02
        $this->qty_pl_02->RowCssClass = "row";

        // pr_03
        $this->pr_03->RowCssClass = "row";

        // qty_pr_03
        $this->qty_pr_03->RowCssClass = "row";

        // pl_03
        $this->pl_03->RowCssClass = "row";

        // qty_pl_03
        $this->qty_pl_03->RowCssClass = "row";

        // pr_04
        $this->pr_04->RowCssClass = "row";

        // qty_pr_04
        $this->qty_pr_04->RowCssClass = "row";

        // pl_04
        $this->pl_04->RowCssClass = "row";

        // qty_pl_04
        $this->qty_pl_04->RowCssClass = "row";

        // pa_01
        $this->pa_01->RowCssClass = "row";

        // qty_pa_01
        $this->qty_pa_01->RowCssClass = "row";

        // pa_02
        $this->pa_02->RowCssClass = "row";

        // qty_pa_02
        $this->qty_pa_02->RowCssClass = "row";

        // pa_03
        $this->pa_03->RowCssClass = "row";

        // qty_pa_03
        $this->qty_pa_03->RowCssClass = "row";

        // pa_04
        $this->pa_04->RowCssClass = "row";

        // qty_pa_04
        $this->qty_pa_04->RowCssClass = "row";

        // pa_05
        $this->pa_05->RowCssClass = "row";

        // qty_pa_05
        $this->qty_pa_05->RowCssClass = "row";

        // pc_01
        $this->pc_01->RowCssClass = "row";

        // qty_pc_01
        $this->qty_pc_01->RowCssClass = "row";

        // pc_02
        $this->pc_02->RowCssClass = "row";

        // qty_pc_02
        $this->qty_pc_02->RowCssClass = "row";

        // o_01
        $this->o_01->RowCssClass = "row";

        // qty_o_01
        $this->qty_o_01->RowCssClass = "row";

        // lamination_type
        $this->lamination_type->RowCssClass = "row";

        // lamination_qty
        $this->lamination_qty->RowCssClass = "row";

        // die_type
        $this->die_type->RowCssClass = "row";

        // die_qty
        $this->die_qty->RowCssClass = "row";

        // binding_type
        $this->binding_type->RowCssClass = "row";

        // binding_qty
        $this->binding_qty->RowCssClass = "row";

        // number_type
        $this->number_type->RowCssClass = "row";

        // number_qty
        $this->number_qty->RowCssClass = "row";

        // de_01
        $this->de_01->RowCssClass = "row";

        // qty_de_01
        $this->qty_de_01->RowCssClass = "row";

        // de_02
        $this->de_02->RowCssClass = "row";

        // qty_de_02
        $this->qty_de_02->RowCssClass = "row";

        // de_03
        $this->de_03->RowCssClass = "row";

        // qty_de_03
        $this->qty_de_03->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // job_type
            if (strval($this->job_type->CurrentValue) != "") {
                $this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
            } else {
                $this->job_type->ViewValue = null;
            }

            // job_category
            if (strval($this->job_category->CurrentValue) != "") {
                $this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
            } else {
                $this->job_category->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // size
            $curVal = strval($this->size->CurrentValue);
            if ($curVal != "") {
                $this->size->ViewValue = $this->size->lookupCacheOption($curVal);
                if ($this->size->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->size->Lookup->getTable()->Fields["description"]->searchExpression(), "=", $curVal, $this->size->Lookup->getTable()->Fields["description"]->searchDataType(), "");
                    $lookupFilter = $this->size->getSelectFilter($this); // PHP
                    $sqlWrk = $this->size->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->size->Lookup->renderViewRow($rswrk[0]);
                        $this->size->ViewValue = $this->size->displayValue($arwrk);
                    } else {
                        $this->size->ViewValue = $this->size->CurrentValue;
                    }
                }
            } else {
                $this->size->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // pages
            $this->pages->ViewValue = $this->pages->CurrentValue;

            // paper
            $this->paper->ViewValue = $this->paper->CurrentValue;
            $this->paper->ViewValue = FormatNumber($this->paper->ViewValue, $this->paper->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pr_01
            $curVal = strval($this->pr_01->CurrentValue);
            if ($curVal != "") {
                $this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
                if ($this->pr_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
                    } else {
                        $this->pr_01->ViewValue = $this->pr_01->CurrentValue;
                    }
                }
            } else {
                $this->pr_01->ViewValue = null;
            }

            // qty_pr_01
            $this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
            $this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, $this->qty_pr_01->formatPattern());

            // pl_01
            $curVal = strval($this->pl_01->CurrentValue);
            if ($curVal != "") {
                $this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
                if ($this->pl_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
                    } else {
                        $this->pl_01->ViewValue = $this->pl_01->CurrentValue;
                    }
                }
            } else {
                $this->pl_01->ViewValue = null;
            }

            // qty_pl_01
            $this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
            $this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, $this->qty_pl_01->formatPattern());

            // pr_02
            $curVal = strval($this->pr_02->CurrentValue);
            if ($curVal != "") {
                $this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
                if ($this->pr_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
                    } else {
                        $this->pr_02->ViewValue = $this->pr_02->CurrentValue;
                    }
                }
            } else {
                $this->pr_02->ViewValue = null;
            }

            // qty_pr_02
            $this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
            $this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, $this->qty_pr_02->formatPattern());

            // pl_02
            $curVal = strval($this->pl_02->CurrentValue);
            if ($curVal != "") {
                $this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
                if ($this->pl_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
                    } else {
                        $this->pl_02->ViewValue = $this->pl_02->CurrentValue;
                    }
                }
            } else {
                $this->pl_02->ViewValue = null;
            }

            // qty_pl_02
            $this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
            $this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, $this->qty_pl_02->formatPattern());

            // pr_03
            $curVal = strval($this->pr_03->CurrentValue);
            if ($curVal != "") {
                $this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
                if ($this->pr_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
                    } else {
                        $this->pr_03->ViewValue = $this->pr_03->CurrentValue;
                    }
                }
            } else {
                $this->pr_03->ViewValue = null;
            }

            // qty_pr_03
            $this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
            $this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, $this->qty_pr_03->formatPattern());

            // pl_03
            $curVal = strval($this->pl_03->CurrentValue);
            if ($curVal != "") {
                $this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
                if ($this->pl_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
                    } else {
                        $this->pl_03->ViewValue = $this->pl_03->CurrentValue;
                    }
                }
            } else {
                $this->pl_03->ViewValue = null;
            }

            // qty_pl_03
            $this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
            $this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, $this->qty_pl_03->formatPattern());

            // pr_04
            $curVal = strval($this->pr_04->CurrentValue);
            if ($curVal != "") {
                $this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
                if ($this->pr_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
                    } else {
                        $this->pr_04->ViewValue = $this->pr_04->CurrentValue;
                    }
                }
            } else {
                $this->pr_04->ViewValue = null;
            }

            // qty_pr_04
            $this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
            $this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, $this->qty_pr_04->formatPattern());

            // pl_04
            $curVal = strval($this->pl_04->CurrentValue);
            if ($curVal != "") {
                $this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
                if ($this->pl_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
                    } else {
                        $this->pl_04->ViewValue = $this->pl_04->CurrentValue;
                    }
                }
            } else {
                $this->pl_04->ViewValue = null;
            }

            // qty_pl_04
            $this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
            $this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, $this->qty_pl_04->formatPattern());

            // pa_01
            $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
            $curVal = strval($this->pa_01->CurrentValue);
            if ($curVal != "") {
                $this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
                if ($this->pa_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
                    } else {
                        $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
                    }
                }
            } else {
                $this->pa_01->ViewValue = null;
            }

            // qty_pa_01
            $this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
            $this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, $this->qty_pa_01->formatPattern());

            // pa_02
            $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
            $curVal = strval($this->pa_02->CurrentValue);
            if ($curVal != "") {
                $this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
                if ($this->pa_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
                    } else {
                        $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
                    }
                }
            } else {
                $this->pa_02->ViewValue = null;
            }

            // qty_pa_02
            $this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
            $this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, $this->qty_pa_02->formatPattern());

            // pa_03
            $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
            $curVal = strval($this->pa_03->CurrentValue);
            if ($curVal != "") {
                $this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
                if ($this->pa_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
                    } else {
                        $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
                    }
                }
            } else {
                $this->pa_03->ViewValue = null;
            }

            // qty_pa_03
            $this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
            $this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, $this->qty_pa_03->formatPattern());

            // pa_04
            $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
            $curVal = strval($this->pa_04->CurrentValue);
            if ($curVal != "") {
                $this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
                if ($this->pa_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
                    } else {
                        $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
                    }
                }
            } else {
                $this->pa_04->ViewValue = null;
            }

            // qty_pa_04
            $this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
            $this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, $this->qty_pa_04->formatPattern());

            // pa_05
            $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
            $curVal = strval($this->pa_05->CurrentValue);
            if ($curVal != "") {
                $this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
                if ($this->pa_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_05->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
                    } else {
                        $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
                    }
                }
            } else {
                $this->pa_05->ViewValue = null;
            }

            // qty_pa_05
            $this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
            $this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, $this->qty_pa_05->formatPattern());

            // pc_01
            $curVal = strval($this->pc_01->CurrentValue);
            if ($curVal != "") {
                $this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
                if ($this->pc_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pc_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pc_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pc_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pc_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
                    } else {
                        $this->pc_01->ViewValue = $this->pc_01->CurrentValue;
                    }
                }
            } else {
                $this->pc_01->ViewValue = null;
            }

            // qty_pc_01
            $this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
            $this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, $this->qty_pc_01->formatPattern());

            // pc_02
            $curVal = strval($this->pc_02->CurrentValue);
            if ($curVal != "") {
                $this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
                if ($this->pc_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pc_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pc_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pc_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pc_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
                    } else {
                        $this->pc_02->ViewValue = $this->pc_02->CurrentValue;
                    }
                }
            } else {
                $this->pc_02->ViewValue = null;
            }

            // qty_pc_02
            $this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
            $this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, $this->qty_pc_02->formatPattern());

            // o_01
            $curVal = strval($this->o_01->CurrentValue);
            if ($curVal != "") {
                $this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
                if ($this->o_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->o_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->o_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->o_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->o_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->o_01->Lookup->renderViewRow($rswrk[0]);
                        $this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
                    } else {
                        $this->o_01->ViewValue = $this->o_01->CurrentValue;
                    }
                }
            } else {
                $this->o_01->ViewValue = null;
            }

            // qty_o_01
            $this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
            $this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, $this->qty_o_01->formatPattern());

            // lamination_type
            $curVal = strval($this->lamination_type->CurrentValue);
            if ($curVal != "") {
                $this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
                if ($this->lamination_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->lamination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->lamination_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->lamination_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->lamination_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->lamination_type->Lookup->renderViewRow($rswrk[0]);
                        $this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
                    } else {
                        $this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
                    }
                }
            } else {
                $this->lamination_type->ViewValue = null;
            }

            // lamination_qty
            $this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
            $this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, $this->lamination_qty->formatPattern());

            // die_type
            $curVal = strval($this->die_type->CurrentValue);
            if ($curVal != "") {
                $this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
                if ($this->die_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->die_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->die_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->die_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->die_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->die_type->Lookup->renderViewRow($rswrk[0]);
                        $this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
                    } else {
                        $this->die_type->ViewValue = $this->die_type->CurrentValue;
                    }
                }
            } else {
                $this->die_type->ViewValue = null;
            }

            // die_qty
            $this->die_qty->ViewValue = $this->die_qty->CurrentValue;
            $this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, $this->die_qty->formatPattern());

            // binding_type
            $curVal = strval($this->binding_type->CurrentValue);
            if ($curVal != "") {
                $this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
                if ($this->binding_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->binding_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->binding_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->binding_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->binding_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->binding_type->Lookup->renderViewRow($rswrk[0]);
                        $this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
                    } else {
                        $this->binding_type->ViewValue = $this->binding_type->CurrentValue;
                    }
                }
            } else {
                $this->binding_type->ViewValue = null;
            }

            // binding_qty
            $this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
            $this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, $this->binding_qty->formatPattern());

            // number_type
            $curVal = strval($this->number_type->CurrentValue);
            if ($curVal != "") {
                $this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
                if ($this->number_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->number_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->number_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->number_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->number_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->number_type->Lookup->renderViewRow($rswrk[0]);
                        $this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
                    } else {
                        $this->number_type->ViewValue = $this->number_type->CurrentValue;
                    }
                }
            } else {
                $this->number_type->ViewValue = null;
            }

            // number_qty
            $this->number_qty->ViewValue = $this->number_qty->CurrentValue;
            $this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, $this->number_qty->formatPattern());

            // de_01
            $curVal = strval($this->de_01->CurrentValue);
            if ($curVal != "") {
                $this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
                if ($this->de_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_01->Lookup->renderViewRow($rswrk[0]);
                        $this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
                    } else {
                        $this->de_01->ViewValue = $this->de_01->CurrentValue;
                    }
                }
            } else {
                $this->de_01->ViewValue = null;
            }

            // qty_de_01
            $this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
            $this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, $this->qty_de_01->formatPattern());

            // de_02
            $curVal = strval($this->de_02->CurrentValue);
            if ($curVal != "") {
                $this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
                if ($this->de_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_02->Lookup->renderViewRow($rswrk[0]);
                        $this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
                    } else {
                        $this->de_02->ViewValue = $this->de_02->CurrentValue;
                    }
                }
            } else {
                $this->de_02->ViewValue = null;
            }

            // qty_de_02
            $this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
            $this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, $this->qty_de_02->formatPattern());

            // de_03
            $curVal = strval($this->de_03->CurrentValue);
            if ($curVal != "") {
                $this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
                if ($this->de_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_03->Lookup->renderViewRow($rswrk[0]);
                        $this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
                    } else {
                        $this->de_03->ViewValue = $this->de_03->CurrentValue;
                    }
                }
            } else {
                $this->de_03->ViewValue = null;
            }

            // qty_de_03
            $this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
            $this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, $this->qty_de_03->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // job_type
            $this->job_type->HrefValue = "";
            $this->job_type->TooltipValue = "";

            // job_category
            $this->job_category->HrefValue = "";
            $this->job_category->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // pages
            $this->pages->HrefValue = "";
            $this->pages->TooltipValue = "";

            // paper
            $this->paper->HrefValue = "";
            $this->paper->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // pr_01
            $this->pr_01->HrefValue = "";
            $this->pr_01->TooltipValue = "";

            // qty_pr_01
            $this->qty_pr_01->HrefValue = "";
            $this->qty_pr_01->TooltipValue = "";

            // pl_01
            $this->pl_01->HrefValue = "";
            $this->pl_01->TooltipValue = "";

            // qty_pl_01
            $this->qty_pl_01->HrefValue = "";
            $this->qty_pl_01->TooltipValue = "";

            // pr_02
            $this->pr_02->HrefValue = "";
            $this->pr_02->TooltipValue = "";

            // qty_pr_02
            $this->qty_pr_02->HrefValue = "";
            $this->qty_pr_02->TooltipValue = "";

            // pl_02
            $this->pl_02->HrefValue = "";
            $this->pl_02->TooltipValue = "";

            // qty_pl_02
            $this->qty_pl_02->HrefValue = "";
            $this->qty_pl_02->TooltipValue = "";

            // pr_03
            $this->pr_03->HrefValue = "";
            $this->pr_03->TooltipValue = "";

            // qty_pr_03
            $this->qty_pr_03->HrefValue = "";
            $this->qty_pr_03->TooltipValue = "";

            // pl_03
            $this->pl_03->HrefValue = "";
            $this->pl_03->TooltipValue = "";

            // qty_pl_03
            $this->qty_pl_03->HrefValue = "";
            $this->qty_pl_03->TooltipValue = "";

            // pr_04
            $this->pr_04->HrefValue = "";
            $this->pr_04->TooltipValue = "";

            // qty_pr_04
            $this->qty_pr_04->HrefValue = "";
            $this->qty_pr_04->TooltipValue = "";

            // pl_04
            $this->pl_04->HrefValue = "";
            $this->pl_04->TooltipValue = "";

            // qty_pl_04
            $this->qty_pl_04->HrefValue = "";
            $this->qty_pl_04->TooltipValue = "";

            // pa_01
            $this->pa_01->HrefValue = "";
            $this->pa_01->TooltipValue = "";

            // qty_pa_01
            $this->qty_pa_01->HrefValue = "";
            $this->qty_pa_01->TooltipValue = "";

            // pa_02
            $this->pa_02->HrefValue = "";
            $this->pa_02->TooltipValue = "";

            // qty_pa_02
            $this->qty_pa_02->HrefValue = "";
            $this->qty_pa_02->TooltipValue = "";

            // pa_03
            $this->pa_03->HrefValue = "";
            $this->pa_03->TooltipValue = "";

            // qty_pa_03
            $this->qty_pa_03->HrefValue = "";
            $this->qty_pa_03->TooltipValue = "";

            // pa_04
            $this->pa_04->HrefValue = "";
            $this->pa_04->TooltipValue = "";

            // qty_pa_04
            $this->qty_pa_04->HrefValue = "";
            $this->qty_pa_04->TooltipValue = "";

            // pa_05
            $this->pa_05->HrefValue = "";
            $this->pa_05->TooltipValue = "";

            // qty_pa_05
            $this->qty_pa_05->HrefValue = "";
            $this->qty_pa_05->TooltipValue = "";

            // pc_01
            $this->pc_01->HrefValue = "";
            $this->pc_01->TooltipValue = "";

            // qty_pc_01
            $this->qty_pc_01->HrefValue = "";
            $this->qty_pc_01->TooltipValue = "";

            // pc_02
            $this->pc_02->HrefValue = "";
            $this->pc_02->TooltipValue = "";

            // qty_pc_02
            $this->qty_pc_02->HrefValue = "";
            $this->qty_pc_02->TooltipValue = "";

            // o_01
            $this->o_01->HrefValue = "";
            $this->o_01->TooltipValue = "";

            // qty_o_01
            $this->qty_o_01->HrefValue = "";
            $this->qty_o_01->TooltipValue = "";

            // lamination_type
            $this->lamination_type->HrefValue = "";
            $this->lamination_type->TooltipValue = "";

            // lamination_qty
            $this->lamination_qty->HrefValue = "";
            $this->lamination_qty->TooltipValue = "";

            // die_type
            $this->die_type->HrefValue = "";
            $this->die_type->TooltipValue = "";

            // die_qty
            $this->die_qty->HrefValue = "";
            $this->die_qty->TooltipValue = "";

            // binding_type
            $this->binding_type->HrefValue = "";
            $this->binding_type->TooltipValue = "";

            // binding_qty
            $this->binding_qty->HrefValue = "";
            $this->binding_qty->TooltipValue = "";

            // number_type
            $this->number_type->HrefValue = "";
            $this->number_type->TooltipValue = "";

            // number_qty
            $this->number_qty->HrefValue = "";
            $this->number_qty->TooltipValue = "";

            // de_01
            $this->de_01->HrefValue = "";
            $this->de_01->TooltipValue = "";

            // qty_de_01
            $this->qty_de_01->HrefValue = "";
            $this->qty_de_01->TooltipValue = "";

            // de_02
            $this->de_02->HrefValue = "";
            $this->de_02->TooltipValue = "";

            // qty_de_02
            $this->qty_de_02->HrefValue = "";
            $this->qty_de_02->TooltipValue = "";

            // de_03
            $this->de_03->HrefValue = "";
            $this->de_03->TooltipValue = "";

            // qty_de_03
            $this->qty_de_03->HrefValue = "";
            $this->qty_de_03->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // job_type
            $this->job_type->EditValue = $this->job_type->options(false);
            $this->job_type->PlaceHolder = RemoveHtml($this->job_type->caption());

            // job_category
            $this->job_category->EditValue = $this->job_category->options(false);
            $this->job_category->PlaceHolder = RemoveHtml($this->job_category->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->company_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->AdvancedSearch->SearchValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->AdvancedSearch->SearchValue = HtmlDecode($this->description->AdvancedSearch->SearchValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // size
            $this->size->setupEditAttributes();
            $curVal = trim(strval($this->size->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->size->AdvancedSearch->ViewValue = $this->size->lookupCacheOption($curVal);
            } else {
                $this->size->AdvancedSearch->ViewValue = $this->size->Lookup !== null && is_array($this->size->lookupOptions()) && count($this->size->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->size->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->size->EditValue = array_values($this->size->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->size->Lookup->getTable()->Fields["description"]->searchExpression(), "=", $this->size->AdvancedSearch->SearchValue, $this->size->Lookup->getTable()->Fields["description"]->searchDataType(), "");
                }
                $lookupFilter = $this->size->getSelectFilter($this); // PHP
                $sqlWrk = $this->size->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->size->EditValue = $arwrk;
            }
            $this->size->PlaceHolder = RemoveHtml($this->size->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // pages
            $this->pages->setupEditAttributes();
            if (!$this->pages->Raw) {
                $this->pages->AdvancedSearch->SearchValue = HtmlDecode($this->pages->AdvancedSearch->SearchValue);
            }
            $this->pages->EditValue = HtmlEncode($this->pages->AdvancedSearch->SearchValue);
            $this->pages->PlaceHolder = RemoveHtml($this->pages->caption());

            // paper
            $this->paper->setupEditAttributes();
            $this->paper->EditValue = $this->paper->AdvancedSearch->SearchValue;
            $this->paper->PlaceHolder = RemoveHtml($this->paper->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // pr_01
            $this->pr_01->setupEditAttributes();
            $curVal = trim(strval($this->pr_01->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pr_01->AdvancedSearch->ViewValue = $this->pr_01->lookupCacheOption($curVal);
            } else {
                $this->pr_01->AdvancedSearch->ViewValue = $this->pr_01->Lookup !== null && is_array($this->pr_01->lookupOptions()) && count($this->pr_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pr_01->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pr_01->EditValue = array_values($this->pr_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pr_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pr_01->AdvancedSearch->SearchValue, $this->pr_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pr_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pr_01->EditValue = $arwrk;
            }
            $this->pr_01->PlaceHolder = RemoveHtml($this->pr_01->caption());

            // qty_pr_01
            $this->qty_pr_01->setupEditAttributes();
            $this->qty_pr_01->EditValue = $this->qty_pr_01->AdvancedSearch->SearchValue;
            $this->qty_pr_01->PlaceHolder = RemoveHtml($this->qty_pr_01->caption());

            // pl_01
            $this->pl_01->setupEditAttributes();
            $curVal = trim(strval($this->pl_01->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pl_01->AdvancedSearch->ViewValue = $this->pl_01->lookupCacheOption($curVal);
            } else {
                $this->pl_01->AdvancedSearch->ViewValue = $this->pl_01->Lookup !== null && is_array($this->pl_01->lookupOptions()) && count($this->pl_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_01->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pl_01->EditValue = array_values($this->pl_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_01->AdvancedSearch->SearchValue, $this->pl_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_01->EditValue = $arwrk;
            }
            $this->pl_01->PlaceHolder = RemoveHtml($this->pl_01->caption());

            // qty_pl_01
            $this->qty_pl_01->setupEditAttributes();
            $this->qty_pl_01->EditValue = $this->qty_pl_01->AdvancedSearch->SearchValue;
            $this->qty_pl_01->PlaceHolder = RemoveHtml($this->qty_pl_01->caption());

            // pr_02
            $this->pr_02->setupEditAttributes();
            $curVal = trim(strval($this->pr_02->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pr_02->AdvancedSearch->ViewValue = $this->pr_02->lookupCacheOption($curVal);
            } else {
                $this->pr_02->AdvancedSearch->ViewValue = $this->pr_02->Lookup !== null && is_array($this->pr_02->lookupOptions()) && count($this->pr_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pr_02->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pr_02->EditValue = array_values($this->pr_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pr_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pr_02->AdvancedSearch->SearchValue, $this->pr_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pr_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pr_02->EditValue = $arwrk;
            }
            $this->pr_02->PlaceHolder = RemoveHtml($this->pr_02->caption());

            // qty_pr_02
            $this->qty_pr_02->setupEditAttributes();
            $this->qty_pr_02->EditValue = $this->qty_pr_02->AdvancedSearch->SearchValue;
            $this->qty_pr_02->PlaceHolder = RemoveHtml($this->qty_pr_02->caption());

            // pl_02
            $this->pl_02->setupEditAttributes();
            $curVal = trim(strval($this->pl_02->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pl_02->AdvancedSearch->ViewValue = $this->pl_02->lookupCacheOption($curVal);
            } else {
                $this->pl_02->AdvancedSearch->ViewValue = $this->pl_02->Lookup !== null && is_array($this->pl_02->lookupOptions()) && count($this->pl_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_02->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pl_02->EditValue = array_values($this->pl_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_02->AdvancedSearch->SearchValue, $this->pl_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_02->EditValue = $arwrk;
            }
            $this->pl_02->PlaceHolder = RemoveHtml($this->pl_02->caption());

            // qty_pl_02
            $this->qty_pl_02->setupEditAttributes();
            $this->qty_pl_02->EditValue = $this->qty_pl_02->AdvancedSearch->SearchValue;
            $this->qty_pl_02->PlaceHolder = RemoveHtml($this->qty_pl_02->caption());

            // pr_03
            $this->pr_03->setupEditAttributes();
            $curVal = trim(strval($this->pr_03->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pr_03->AdvancedSearch->ViewValue = $this->pr_03->lookupCacheOption($curVal);
            } else {
                $this->pr_03->AdvancedSearch->ViewValue = $this->pr_03->Lookup !== null && is_array($this->pr_03->lookupOptions()) && count($this->pr_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pr_03->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pr_03->EditValue = array_values($this->pr_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pr_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pr_03->AdvancedSearch->SearchValue, $this->pr_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pr_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pr_03->EditValue = $arwrk;
            }
            $this->pr_03->PlaceHolder = RemoveHtml($this->pr_03->caption());

            // qty_pr_03
            $this->qty_pr_03->setupEditAttributes();
            $this->qty_pr_03->EditValue = $this->qty_pr_03->AdvancedSearch->SearchValue;
            $this->qty_pr_03->PlaceHolder = RemoveHtml($this->qty_pr_03->caption());

            // pl_03
            $this->pl_03->setupEditAttributes();
            $curVal = trim(strval($this->pl_03->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pl_03->AdvancedSearch->ViewValue = $this->pl_03->lookupCacheOption($curVal);
            } else {
                $this->pl_03->AdvancedSearch->ViewValue = $this->pl_03->Lookup !== null && is_array($this->pl_03->lookupOptions()) && count($this->pl_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_03->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pl_03->EditValue = array_values($this->pl_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_03->AdvancedSearch->SearchValue, $this->pl_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_03->EditValue = $arwrk;
            }
            $this->pl_03->PlaceHolder = RemoveHtml($this->pl_03->caption());

            // qty_pl_03
            $this->qty_pl_03->setupEditAttributes();
            $this->qty_pl_03->EditValue = $this->qty_pl_03->AdvancedSearch->SearchValue;
            $this->qty_pl_03->PlaceHolder = RemoveHtml($this->qty_pl_03->caption());

            // pr_04
            $this->pr_04->setupEditAttributes();
            $curVal = trim(strval($this->pr_04->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pr_04->AdvancedSearch->ViewValue = $this->pr_04->lookupCacheOption($curVal);
            } else {
                $this->pr_04->AdvancedSearch->ViewValue = $this->pr_04->Lookup !== null && is_array($this->pr_04->lookupOptions()) && count($this->pr_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pr_04->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pr_04->EditValue = array_values($this->pr_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pr_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pr_04->AdvancedSearch->SearchValue, $this->pr_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pr_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pr_04->EditValue = $arwrk;
            }
            $this->pr_04->PlaceHolder = RemoveHtml($this->pr_04->caption());

            // qty_pr_04
            $this->qty_pr_04->setupEditAttributes();
            $this->qty_pr_04->EditValue = $this->qty_pr_04->AdvancedSearch->SearchValue;
            $this->qty_pr_04->PlaceHolder = RemoveHtml($this->qty_pr_04->caption());

            // pl_04
            $this->pl_04->setupEditAttributes();
            $curVal = trim(strval($this->pl_04->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pl_04->AdvancedSearch->ViewValue = $this->pl_04->lookupCacheOption($curVal);
            } else {
                $this->pl_04->AdvancedSearch->ViewValue = $this->pl_04->Lookup !== null && is_array($this->pl_04->lookupOptions()) && count($this->pl_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_04->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pl_04->EditValue = array_values($this->pl_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_04->AdvancedSearch->SearchValue, $this->pl_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_04->EditValue = $arwrk;
            }
            $this->pl_04->PlaceHolder = RemoveHtml($this->pl_04->caption());

            // qty_pl_04
            $this->qty_pl_04->setupEditAttributes();
            $this->qty_pl_04->EditValue = $this->qty_pl_04->AdvancedSearch->SearchValue;
            $this->qty_pl_04->PlaceHolder = RemoveHtml($this->qty_pl_04->caption());

            // pa_01
            $this->pa_01->setupEditAttributes();
            if (!$this->pa_01->Raw) {
                $this->pa_01->AdvancedSearch->SearchValue = HtmlDecode($this->pa_01->AdvancedSearch->SearchValue);
            }
            $this->pa_01->EditValue = HtmlEncode($this->pa_01->AdvancedSearch->SearchValue);
            $curVal = strval($this->pa_01->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->pa_01->EditValue = $this->pa_01->lookupCacheOption($curVal);
                if ($this->pa_01->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_01->EditValue = $this->pa_01->displayValue($arwrk);
                    } else {
                        $this->pa_01->EditValue = HtmlEncode($this->pa_01->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->pa_01->EditValue = null;
            }
            $this->pa_01->PlaceHolder = RemoveHtml($this->pa_01->caption());

            // qty_pa_01
            $this->qty_pa_01->setupEditAttributes();
            $this->qty_pa_01->EditValue = $this->qty_pa_01->AdvancedSearch->SearchValue;
            $this->qty_pa_01->PlaceHolder = RemoveHtml($this->qty_pa_01->caption());

            // pa_02
            $this->pa_02->setupEditAttributes();
            if (!$this->pa_02->Raw) {
                $this->pa_02->AdvancedSearch->SearchValue = HtmlDecode($this->pa_02->AdvancedSearch->SearchValue);
            }
            $this->pa_02->EditValue = HtmlEncode($this->pa_02->AdvancedSearch->SearchValue);
            $curVal = strval($this->pa_02->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->pa_02->EditValue = $this->pa_02->lookupCacheOption($curVal);
                if ($this->pa_02->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_02->EditValue = $this->pa_02->displayValue($arwrk);
                    } else {
                        $this->pa_02->EditValue = HtmlEncode($this->pa_02->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->pa_02->EditValue = null;
            }
            $this->pa_02->PlaceHolder = RemoveHtml($this->pa_02->caption());

            // qty_pa_02
            $this->qty_pa_02->setupEditAttributes();
            $this->qty_pa_02->EditValue = $this->qty_pa_02->AdvancedSearch->SearchValue;
            $this->qty_pa_02->PlaceHolder = RemoveHtml($this->qty_pa_02->caption());

            // pa_03
            $this->pa_03->setupEditAttributes();
            if (!$this->pa_03->Raw) {
                $this->pa_03->AdvancedSearch->SearchValue = HtmlDecode($this->pa_03->AdvancedSearch->SearchValue);
            }
            $this->pa_03->EditValue = HtmlEncode($this->pa_03->AdvancedSearch->SearchValue);
            $curVal = strval($this->pa_03->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->pa_03->EditValue = $this->pa_03->lookupCacheOption($curVal);
                if ($this->pa_03->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_03->EditValue = $this->pa_03->displayValue($arwrk);
                    } else {
                        $this->pa_03->EditValue = HtmlEncode($this->pa_03->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->pa_03->EditValue = null;
            }
            $this->pa_03->PlaceHolder = RemoveHtml($this->pa_03->caption());

            // qty_pa_03
            $this->qty_pa_03->setupEditAttributes();
            $this->qty_pa_03->EditValue = $this->qty_pa_03->AdvancedSearch->SearchValue;
            $this->qty_pa_03->PlaceHolder = RemoveHtml($this->qty_pa_03->caption());

            // pa_04
            $this->pa_04->setupEditAttributes();
            if (!$this->pa_04->Raw) {
                $this->pa_04->AdvancedSearch->SearchValue = HtmlDecode($this->pa_04->AdvancedSearch->SearchValue);
            }
            $this->pa_04->EditValue = HtmlEncode($this->pa_04->AdvancedSearch->SearchValue);
            $curVal = strval($this->pa_04->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->pa_04->EditValue = $this->pa_04->lookupCacheOption($curVal);
                if ($this->pa_04->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_04->EditValue = $this->pa_04->displayValue($arwrk);
                    } else {
                        $this->pa_04->EditValue = HtmlEncode($this->pa_04->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->pa_04->EditValue = null;
            }
            $this->pa_04->PlaceHolder = RemoveHtml($this->pa_04->caption());

            // qty_pa_04
            $this->qty_pa_04->setupEditAttributes();
            $this->qty_pa_04->EditValue = $this->qty_pa_04->AdvancedSearch->SearchValue;
            $this->qty_pa_04->PlaceHolder = RemoveHtml($this->qty_pa_04->caption());

            // pa_05
            $this->pa_05->setupEditAttributes();
            if (!$this->pa_05->Raw) {
                $this->pa_05->AdvancedSearch->SearchValue = HtmlDecode($this->pa_05->AdvancedSearch->SearchValue);
            }
            $this->pa_05->EditValue = HtmlEncode($this->pa_05->AdvancedSearch->SearchValue);
            $curVal = strval($this->pa_05->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->pa_05->EditValue = $this->pa_05->lookupCacheOption($curVal);
                if ($this->pa_05->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_05->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_05->EditValue = $this->pa_05->displayValue($arwrk);
                    } else {
                        $this->pa_05->EditValue = HtmlEncode($this->pa_05->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->pa_05->EditValue = null;
            }
            $this->pa_05->PlaceHolder = RemoveHtml($this->pa_05->caption());

            // qty_pa_05
            $this->qty_pa_05->setupEditAttributes();
            $this->qty_pa_05->EditValue = $this->qty_pa_05->AdvancedSearch->SearchValue;
            $this->qty_pa_05->PlaceHolder = RemoveHtml($this->qty_pa_05->caption());

            // pc_01
            $this->pc_01->setupEditAttributes();
            $curVal = trim(strval($this->pc_01->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pc_01->AdvancedSearch->ViewValue = $this->pc_01->lookupCacheOption($curVal);
            } else {
                $this->pc_01->AdvancedSearch->ViewValue = $this->pc_01->Lookup !== null && is_array($this->pc_01->lookupOptions()) && count($this->pc_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pc_01->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pc_01->EditValue = array_values($this->pc_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pc_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pc_01->AdvancedSearch->SearchValue, $this->pc_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pc_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pc_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pc_01->EditValue = $arwrk;
            }
            $this->pc_01->PlaceHolder = RemoveHtml($this->pc_01->caption());

            // qty_pc_01
            $this->qty_pc_01->setupEditAttributes();
            $this->qty_pc_01->EditValue = $this->qty_pc_01->AdvancedSearch->SearchValue;
            $this->qty_pc_01->PlaceHolder = RemoveHtml($this->qty_pc_01->caption());

            // pc_02
            $this->pc_02->setupEditAttributes();
            $curVal = trim(strval($this->pc_02->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->pc_02->AdvancedSearch->ViewValue = $this->pc_02->lookupCacheOption($curVal);
            } else {
                $this->pc_02->AdvancedSearch->ViewValue = $this->pc_02->Lookup !== null && is_array($this->pc_02->lookupOptions()) && count($this->pc_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pc_02->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->pc_02->EditValue = array_values($this->pc_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pc_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pc_02->AdvancedSearch->SearchValue, $this->pc_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pc_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pc_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pc_02->EditValue = $arwrk;
            }
            $this->pc_02->PlaceHolder = RemoveHtml($this->pc_02->caption());

            // qty_pc_02
            $this->qty_pc_02->setupEditAttributes();
            $this->qty_pc_02->EditValue = $this->qty_pc_02->AdvancedSearch->SearchValue;
            $this->qty_pc_02->PlaceHolder = RemoveHtml($this->qty_pc_02->caption());

            // o_01
            $this->o_01->setupEditAttributes();
            $curVal = trim(strval($this->o_01->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->o_01->AdvancedSearch->ViewValue = $this->o_01->lookupCacheOption($curVal);
            } else {
                $this->o_01->AdvancedSearch->ViewValue = $this->o_01->Lookup !== null && is_array($this->o_01->lookupOptions()) && count($this->o_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->o_01->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->o_01->EditValue = array_values($this->o_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->o_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->o_01->AdvancedSearch->SearchValue, $this->o_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->o_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->o_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->o_01->EditValue = $arwrk;
            }
            $this->o_01->PlaceHolder = RemoveHtml($this->o_01->caption());

            // qty_o_01
            $this->qty_o_01->setupEditAttributes();
            $this->qty_o_01->EditValue = $this->qty_o_01->AdvancedSearch->SearchValue;
            $this->qty_o_01->PlaceHolder = RemoveHtml($this->qty_o_01->caption());

            // lamination_type
            $this->lamination_type->setupEditAttributes();
            $curVal = trim(strval($this->lamination_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->lamination_type->AdvancedSearch->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
            } else {
                $this->lamination_type->AdvancedSearch->ViewValue = $this->lamination_type->Lookup !== null && is_array($this->lamination_type->lookupOptions()) && count($this->lamination_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->lamination_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->lamination_type->EditValue = array_values($this->lamination_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->lamination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->lamination_type->AdvancedSearch->SearchValue, $this->lamination_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->lamination_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->lamination_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->lamination_type->EditValue = $arwrk;
            }
            $this->lamination_type->PlaceHolder = RemoveHtml($this->lamination_type->caption());

            // lamination_qty
            $this->lamination_qty->setupEditAttributes();
            $this->lamination_qty->EditValue = $this->lamination_qty->AdvancedSearch->SearchValue;
            $this->lamination_qty->PlaceHolder = RemoveHtml($this->lamination_qty->caption());

            // die_type
            $this->die_type->setupEditAttributes();
            $curVal = trim(strval($this->die_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->die_type->AdvancedSearch->ViewValue = $this->die_type->lookupCacheOption($curVal);
            } else {
                $this->die_type->AdvancedSearch->ViewValue = $this->die_type->Lookup !== null && is_array($this->die_type->lookupOptions()) && count($this->die_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->die_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->die_type->EditValue = array_values($this->die_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->die_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->die_type->AdvancedSearch->SearchValue, $this->die_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->die_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->die_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->die_type->EditValue = $arwrk;
            }
            $this->die_type->PlaceHolder = RemoveHtml($this->die_type->caption());

            // die_qty
            $this->die_qty->setupEditAttributes();
            $this->die_qty->EditValue = $this->die_qty->AdvancedSearch->SearchValue;
            $this->die_qty->PlaceHolder = RemoveHtml($this->die_qty->caption());

            // binding_type
            $this->binding_type->setupEditAttributes();
            $curVal = trim(strval($this->binding_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->binding_type->AdvancedSearch->ViewValue = $this->binding_type->lookupCacheOption($curVal);
            } else {
                $this->binding_type->AdvancedSearch->ViewValue = $this->binding_type->Lookup !== null && is_array($this->binding_type->lookupOptions()) && count($this->binding_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->binding_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->binding_type->EditValue = array_values($this->binding_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->binding_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->binding_type->AdvancedSearch->SearchValue, $this->binding_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->binding_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->binding_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->binding_type->EditValue = $arwrk;
            }
            $this->binding_type->PlaceHolder = RemoveHtml($this->binding_type->caption());

            // binding_qty
            $this->binding_qty->setupEditAttributes();
            $this->binding_qty->EditValue = $this->binding_qty->AdvancedSearch->SearchValue;
            $this->binding_qty->PlaceHolder = RemoveHtml($this->binding_qty->caption());

            // number_type
            $this->number_type->setupEditAttributes();
            $curVal = trim(strval($this->number_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->number_type->AdvancedSearch->ViewValue = $this->number_type->lookupCacheOption($curVal);
            } else {
                $this->number_type->AdvancedSearch->ViewValue = $this->number_type->Lookup !== null && is_array($this->number_type->lookupOptions()) && count($this->number_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->number_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->number_type->EditValue = array_values($this->number_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->number_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->number_type->AdvancedSearch->SearchValue, $this->number_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->number_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->number_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->number_type->EditValue = $arwrk;
            }
            $this->number_type->PlaceHolder = RemoveHtml($this->number_type->caption());

            // number_qty
            $this->number_qty->setupEditAttributes();
            $this->number_qty->EditValue = $this->number_qty->AdvancedSearch->SearchValue;
            $this->number_qty->PlaceHolder = RemoveHtml($this->number_qty->caption());

            // de_01
            $this->de_01->setupEditAttributes();
            $curVal = trim(strval($this->de_01->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->de_01->AdvancedSearch->ViewValue = $this->de_01->lookupCacheOption($curVal);
            } else {
                $this->de_01->AdvancedSearch->ViewValue = $this->de_01->Lookup !== null && is_array($this->de_01->lookupOptions()) && count($this->de_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->de_01->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->de_01->EditValue = array_values($this->de_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->de_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->de_01->AdvancedSearch->SearchValue, $this->de_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->de_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->de_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->de_01->EditValue = $arwrk;
            }
            $this->de_01->PlaceHolder = RemoveHtml($this->de_01->caption());

            // qty_de_01
            $this->qty_de_01->setupEditAttributes();
            $this->qty_de_01->EditValue = $this->qty_de_01->AdvancedSearch->SearchValue;
            $this->qty_de_01->PlaceHolder = RemoveHtml($this->qty_de_01->caption());

            // de_02
            $this->de_02->setupEditAttributes();
            $curVal = trim(strval($this->de_02->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->de_02->AdvancedSearch->ViewValue = $this->de_02->lookupCacheOption($curVal);
            } else {
                $this->de_02->AdvancedSearch->ViewValue = $this->de_02->Lookup !== null && is_array($this->de_02->lookupOptions()) && count($this->de_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->de_02->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->de_02->EditValue = array_values($this->de_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->de_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->de_02->AdvancedSearch->SearchValue, $this->de_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->de_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->de_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->de_02->EditValue = $arwrk;
            }
            $this->de_02->PlaceHolder = RemoveHtml($this->de_02->caption());

            // qty_de_02
            $this->qty_de_02->setupEditAttributes();
            $this->qty_de_02->EditValue = $this->qty_de_02->AdvancedSearch->SearchValue;
            $this->qty_de_02->PlaceHolder = RemoveHtml($this->qty_de_02->caption());

            // de_03
            $this->de_03->setupEditAttributes();
            $curVal = trim(strval($this->de_03->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->de_03->AdvancedSearch->ViewValue = $this->de_03->lookupCacheOption($curVal);
            } else {
                $this->de_03->AdvancedSearch->ViewValue = $this->de_03->Lookup !== null && is_array($this->de_03->lookupOptions()) && count($this->de_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->de_03->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->de_03->EditValue = array_values($this->de_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->de_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->de_03->AdvancedSearch->SearchValue, $this->de_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->de_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->de_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->de_03->EditValue = $arwrk;
            }
            $this->de_03->PlaceHolder = RemoveHtml($this->de_03->caption());

            // qty_de_03
            $this->qty_de_03->setupEditAttributes();
            $this->qty_de_03->EditValue = $this->qty_de_03->AdvancedSearch->SearchValue;
            $this->qty_de_03->PlaceHolder = RemoveHtml($this->qty_de_03->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->company_id->AdvancedSearch->SearchValue)) {
            $this->company_id->addErrorMessage($this->company_id->getErrorMessage(false));
        }
        if (!CheckNumber($this->quantity->AdvancedSearch->SearchValue)) {
            $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
        }
        if (!CheckInteger($this->paper->AdvancedSearch->SearchValue)) {
            $this->paper->addErrorMessage($this->paper->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pr_01->AdvancedSearch->SearchValue)) {
            $this->qty_pr_01->addErrorMessage($this->qty_pr_01->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pl_01->AdvancedSearch->SearchValue)) {
            $this->qty_pl_01->addErrorMessage($this->qty_pl_01->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pr_02->AdvancedSearch->SearchValue)) {
            $this->qty_pr_02->addErrorMessage($this->qty_pr_02->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pl_02->AdvancedSearch->SearchValue)) {
            $this->qty_pl_02->addErrorMessage($this->qty_pl_02->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pr_03->AdvancedSearch->SearchValue)) {
            $this->qty_pr_03->addErrorMessage($this->qty_pr_03->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pl_03->AdvancedSearch->SearchValue)) {
            $this->qty_pl_03->addErrorMessage($this->qty_pl_03->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pr_04->AdvancedSearch->SearchValue)) {
            $this->qty_pr_04->addErrorMessage($this->qty_pr_04->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pl_04->AdvancedSearch->SearchValue)) {
            $this->qty_pl_04->addErrorMessage($this->qty_pl_04->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pa_01->AdvancedSearch->SearchValue)) {
            $this->qty_pa_01->addErrorMessage($this->qty_pa_01->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pa_02->AdvancedSearch->SearchValue)) {
            $this->qty_pa_02->addErrorMessage($this->qty_pa_02->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pa_03->AdvancedSearch->SearchValue)) {
            $this->qty_pa_03->addErrorMessage($this->qty_pa_03->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pa_04->AdvancedSearch->SearchValue)) {
            $this->qty_pa_04->addErrorMessage($this->qty_pa_04->getErrorMessage(false));
        }
        if (!CheckInteger($this->pa_05->AdvancedSearch->SearchValue)) {
            $this->pa_05->addErrorMessage($this->pa_05->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pa_05->AdvancedSearch->SearchValue)) {
            $this->qty_pa_05->addErrorMessage($this->qty_pa_05->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pc_01->AdvancedSearch->SearchValue)) {
            $this->qty_pc_01->addErrorMessage($this->qty_pc_01->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_pc_02->AdvancedSearch->SearchValue)) {
            $this->qty_pc_02->addErrorMessage($this->qty_pc_02->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_o_01->AdvancedSearch->SearchValue)) {
            $this->qty_o_01->addErrorMessage($this->qty_o_01->getErrorMessage(false));
        }
        if (!CheckInteger($this->lamination_qty->AdvancedSearch->SearchValue)) {
            $this->lamination_qty->addErrorMessage($this->lamination_qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->die_qty->AdvancedSearch->SearchValue)) {
            $this->die_qty->addErrorMessage($this->die_qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->binding_qty->AdvancedSearch->SearchValue)) {
            $this->binding_qty->addErrorMessage($this->binding_qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->number_qty->AdvancedSearch->SearchValue)) {
            $this->number_qty->addErrorMessage($this->number_qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_de_01->AdvancedSearch->SearchValue)) {
            $this->qty_de_01->addErrorMessage($this->qty_de_01->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_de_02->AdvancedSearch->SearchValue)) {
            $this->qty_de_02->addErrorMessage($this->qty_de_02->getErrorMessage(false));
        }
        if (!CheckNumber($this->qty_de_03->AdvancedSearch->SearchValue)) {
            $this->qty_de_03->addErrorMessage($this->qty_de_03->getErrorMessage(false));
        }
        if (!CheckInteger($this->datetime->AdvancedSearch->SearchValue)) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->job_type->AdvancedSearch->load();
        $this->job_category->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->size->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->pages->AdvancedSearch->load();
        $this->paper->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->pr_01->AdvancedSearch->load();
        $this->qty_pr_01->AdvancedSearch->load();
        $this->pl_01->AdvancedSearch->load();
        $this->qty_pl_01->AdvancedSearch->load();
        $this->pr_02->AdvancedSearch->load();
        $this->qty_pr_02->AdvancedSearch->load();
        $this->pl_02->AdvancedSearch->load();
        $this->qty_pl_02->AdvancedSearch->load();
        $this->pr_03->AdvancedSearch->load();
        $this->qty_pr_03->AdvancedSearch->load();
        $this->pl_03->AdvancedSearch->load();
        $this->qty_pl_03->AdvancedSearch->load();
        $this->pr_04->AdvancedSearch->load();
        $this->qty_pr_04->AdvancedSearch->load();
        $this->pl_04->AdvancedSearch->load();
        $this->qty_pl_04->AdvancedSearch->load();
        $this->pa_01->AdvancedSearch->load();
        $this->qty_pa_01->AdvancedSearch->load();
        $this->pa_02->AdvancedSearch->load();
        $this->qty_pa_02->AdvancedSearch->load();
        $this->pa_03->AdvancedSearch->load();
        $this->qty_pa_03->AdvancedSearch->load();
        $this->pa_04->AdvancedSearch->load();
        $this->qty_pa_04->AdvancedSearch->load();
        $this->pa_05->AdvancedSearch->load();
        $this->qty_pa_05->AdvancedSearch->load();
        $this->pc_01->AdvancedSearch->load();
        $this->qty_pc_01->AdvancedSearch->load();
        $this->pc_02->AdvancedSearch->load();
        $this->qty_pc_02->AdvancedSearch->load();
        $this->o_01->AdvancedSearch->load();
        $this->qty_o_01->AdvancedSearch->load();
        $this->lamination_type->AdvancedSearch->load();
        $this->lamination_qty->AdvancedSearch->load();
        $this->die_type->AdvancedSearch->load();
        $this->die_qty->AdvancedSearch->load();
        $this->binding_type->AdvancedSearch->load();
        $this->binding_qty->AdvancedSearch->load();
        $this->number_type->AdvancedSearch->load();
        $this->number_qty->AdvancedSearch->load();
        $this->de_01->AdvancedSearch->load();
        $this->qty_de_01->AdvancedSearch->load();
        $this->de_02->AdvancedSearch->load();
        $this->qty_de_02->AdvancedSearch->load();
        $this->de_03->AdvancedSearch->load();
        $this->qty_de_03->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("peastimatelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $pages->add(8);
        $pages->add(9);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_job_type":
                    break;
                case "x_job_category":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_size":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pc_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pc_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_o_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lamination_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_die_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_binding_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_number_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
