<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PEastimateList extends PEastimate
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PEastimateList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fp_eastimatelist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "peastimatelist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->job_type->setVisibility();
        $this->job_category->setVisibility();
        $this->company_id->setVisibility();
        $this->description->setVisibility();
        $this->size->setVisibility();
        $this->quantity->setVisibility();
        $this->pages->setVisibility();
        $this->paper->setVisibility();
        $this->remarks->setVisibility();
        $this->pr_01->setVisibility();
        $this->qty_pr_01->setVisibility();
        $this->pl_01->setVisibility();
        $this->qty_pl_01->setVisibility();
        $this->pr_02->setVisibility();
        $this->qty_pr_02->setVisibility();
        $this->pl_02->setVisibility();
        $this->qty_pl_02->setVisibility();
        $this->pr_03->setVisibility();
        $this->qty_pr_03->setVisibility();
        $this->pl_03->setVisibility();
        $this->qty_pl_03->setVisibility();
        $this->pr_04->setVisibility();
        $this->qty_pr_04->setVisibility();
        $this->pl_04->setVisibility();
        $this->qty_pl_04->setVisibility();
        $this->pa_01->setVisibility();
        $this->qty_pa_01->setVisibility();
        $this->pa_02->setVisibility();
        $this->qty_pa_02->setVisibility();
        $this->pa_03->setVisibility();
        $this->qty_pa_03->setVisibility();
        $this->pa_04->setVisibility();
        $this->qty_pa_04->setVisibility();
        $this->pa_05->setVisibility();
        $this->qty_pa_05->setVisibility();
        $this->pc_01->setVisibility();
        $this->qty_pc_01->setVisibility();
        $this->pc_02->setVisibility();
        $this->qty_pc_02->setVisibility();
        $this->o_01->setVisibility();
        $this->qty_o_01->setVisibility();
        $this->lamination_type->setVisibility();
        $this->lamination_qty->setVisibility();
        $this->die_type->setVisibility();
        $this->die_qty->setVisibility();
        $this->binding_type->setVisibility();
        $this->binding_qty->setVisibility();
        $this->number_type->setVisibility();
        $this->number_qty->setVisibility();
        $this->de_01->setVisibility();
        $this->qty_de_01->setVisibility();
        $this->de_02->setVisibility();
        $this->qty_de_02->setVisibility();
        $this->de_03->setVisibility();
        $this->qty_de_03->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'p_eastimate';
        $this->TableName = 'p_eastimate';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (p_eastimate)
        if (!isset($GLOBALS["p_eastimate"]) || $GLOBALS["p_eastimate"]::class == PROJECT_NAMESPACE . "p_eastimate") {
            $GLOBALS["p_eastimate"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "peastimateadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "peastimatedelete";
        $this->MultiUpdateUrl = "peastimateupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_eastimate');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "peastimateview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->job_type);
        $this->setupLookupOptions($this->job_category);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->size);
        $this->setupLookupOptions($this->pr_01);
        $this->setupLookupOptions($this->pl_01);
        $this->setupLookupOptions($this->pr_02);
        $this->setupLookupOptions($this->pl_02);
        $this->setupLookupOptions($this->pr_03);
        $this->setupLookupOptions($this->pl_03);
        $this->setupLookupOptions($this->pr_04);
        $this->setupLookupOptions($this->pl_04);
        $this->setupLookupOptions($this->pa_01);
        $this->setupLookupOptions($this->pa_02);
        $this->setupLookupOptions($this->pa_03);
        $this->setupLookupOptions($this->pa_04);
        $this->setupLookupOptions($this->pa_05);
        $this->setupLookupOptions($this->pc_01);
        $this->setupLookupOptions($this->pc_02);
        $this->setupLookupOptions($this->o_01);
        $this->setupLookupOptions($this->lamination_type);
        $this->setupLookupOptions($this->die_type);
        $this->setupLookupOptions($this->binding_type);
        $this->setupLookupOptions($this->number_type);
        $this->setupLookupOptions($this->de_01);
        $this->setupLookupOptions($this->de_02);
        $this->setupLookupOptions($this->de_03);
        $this->setupLookupOptions($this->operator);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fp_eastimategrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fp_eastimatesrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->job_type->AdvancedSearch->toJson(), ","); // Field job_type
        $filterList = Concat($filterList, $this->job_category->AdvancedSearch->toJson(), ","); // Field job_category
        $filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
        $filterList = Concat($filterList, $this->description->AdvancedSearch->toJson(), ","); // Field description
        $filterList = Concat($filterList, $this->size->AdvancedSearch->toJson(), ","); // Field size
        $filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
        $filterList = Concat($filterList, $this->pages->AdvancedSearch->toJson(), ","); // Field pages
        $filterList = Concat($filterList, $this->paper->AdvancedSearch->toJson(), ","); // Field paper
        $filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
        $filterList = Concat($filterList, $this->pr_01->AdvancedSearch->toJson(), ","); // Field pr_01
        $filterList = Concat($filterList, $this->qty_pr_01->AdvancedSearch->toJson(), ","); // Field qty_pr_01
        $filterList = Concat($filterList, $this->pl_01->AdvancedSearch->toJson(), ","); // Field pl_01
        $filterList = Concat($filterList, $this->qty_pl_01->AdvancedSearch->toJson(), ","); // Field qty_pl_01
        $filterList = Concat($filterList, $this->pr_02->AdvancedSearch->toJson(), ","); // Field pr_02
        $filterList = Concat($filterList, $this->qty_pr_02->AdvancedSearch->toJson(), ","); // Field qty_pr_02
        $filterList = Concat($filterList, $this->pl_02->AdvancedSearch->toJson(), ","); // Field pl_02
        $filterList = Concat($filterList, $this->qty_pl_02->AdvancedSearch->toJson(), ","); // Field qty_pl_02
        $filterList = Concat($filterList, $this->pr_03->AdvancedSearch->toJson(), ","); // Field pr_03
        $filterList = Concat($filterList, $this->qty_pr_03->AdvancedSearch->toJson(), ","); // Field qty_pr_03
        $filterList = Concat($filterList, $this->pl_03->AdvancedSearch->toJson(), ","); // Field pl_03
        $filterList = Concat($filterList, $this->qty_pl_03->AdvancedSearch->toJson(), ","); // Field qty_pl_03
        $filterList = Concat($filterList, $this->pr_04->AdvancedSearch->toJson(), ","); // Field pr_04
        $filterList = Concat($filterList, $this->qty_pr_04->AdvancedSearch->toJson(), ","); // Field qty_pr_04
        $filterList = Concat($filterList, $this->pl_04->AdvancedSearch->toJson(), ","); // Field pl_04
        $filterList = Concat($filterList, $this->qty_pl_04->AdvancedSearch->toJson(), ","); // Field qty_pl_04
        $filterList = Concat($filterList, $this->pa_01->AdvancedSearch->toJson(), ","); // Field pa_01
        $filterList = Concat($filterList, $this->qty_pa_01->AdvancedSearch->toJson(), ","); // Field qty_pa_01
        $filterList = Concat($filterList, $this->pa_02->AdvancedSearch->toJson(), ","); // Field pa_02
        $filterList = Concat($filterList, $this->qty_pa_02->AdvancedSearch->toJson(), ","); // Field qty_pa_02
        $filterList = Concat($filterList, $this->pa_03->AdvancedSearch->toJson(), ","); // Field pa_03
        $filterList = Concat($filterList, $this->qty_pa_03->AdvancedSearch->toJson(), ","); // Field qty_pa_03
        $filterList = Concat($filterList, $this->pa_04->AdvancedSearch->toJson(), ","); // Field pa_04
        $filterList = Concat($filterList, $this->qty_pa_04->AdvancedSearch->toJson(), ","); // Field qty_pa_04
        $filterList = Concat($filterList, $this->pa_05->AdvancedSearch->toJson(), ","); // Field pa_05
        $filterList = Concat($filterList, $this->qty_pa_05->AdvancedSearch->toJson(), ","); // Field qty_pa_05
        $filterList = Concat($filterList, $this->pc_01->AdvancedSearch->toJson(), ","); // Field pc_01
        $filterList = Concat($filterList, $this->qty_pc_01->AdvancedSearch->toJson(), ","); // Field qty_pc_01
        $filterList = Concat($filterList, $this->pc_02->AdvancedSearch->toJson(), ","); // Field pc_02
        $filterList = Concat($filterList, $this->qty_pc_02->AdvancedSearch->toJson(), ","); // Field qty_pc_02
        $filterList = Concat($filterList, $this->o_01->AdvancedSearch->toJson(), ","); // Field o_01
        $filterList = Concat($filterList, $this->qty_o_01->AdvancedSearch->toJson(), ","); // Field qty_o_01
        $filterList = Concat($filterList, $this->lamination_type->AdvancedSearch->toJson(), ","); // Field lamination_type
        $filterList = Concat($filterList, $this->lamination_qty->AdvancedSearch->toJson(), ","); // Field lamination_qty
        $filterList = Concat($filterList, $this->die_type->AdvancedSearch->toJson(), ","); // Field die_type
        $filterList = Concat($filterList, $this->die_qty->AdvancedSearch->toJson(), ","); // Field die_qty
        $filterList = Concat($filterList, $this->binding_type->AdvancedSearch->toJson(), ","); // Field binding_type
        $filterList = Concat($filterList, $this->binding_qty->AdvancedSearch->toJson(), ","); // Field binding_qty
        $filterList = Concat($filterList, $this->number_type->AdvancedSearch->toJson(), ","); // Field number_type
        $filterList = Concat($filterList, $this->number_qty->AdvancedSearch->toJson(), ","); // Field number_qty
        $filterList = Concat($filterList, $this->de_01->AdvancedSearch->toJson(), ","); // Field de_01
        $filterList = Concat($filterList, $this->qty_de_01->AdvancedSearch->toJson(), ","); // Field qty_de_01
        $filterList = Concat($filterList, $this->de_02->AdvancedSearch->toJson(), ","); // Field de_02
        $filterList = Concat($filterList, $this->qty_de_02->AdvancedSearch->toJson(), ","); // Field qty_de_02
        $filterList = Concat($filterList, $this->de_03->AdvancedSearch->toJson(), ","); // Field de_03
        $filterList = Concat($filterList, $this->qty_de_03->AdvancedSearch->toJson(), ","); // Field qty_de_03
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fp_eastimatesrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field job_type
        $this->job_type->AdvancedSearch->SearchValue = @$filter["x_job_type"];
        $this->job_type->AdvancedSearch->SearchOperator = @$filter["z_job_type"];
        $this->job_type->AdvancedSearch->SearchCondition = @$filter["v_job_type"];
        $this->job_type->AdvancedSearch->SearchValue2 = @$filter["y_job_type"];
        $this->job_type->AdvancedSearch->SearchOperator2 = @$filter["w_job_type"];
        $this->job_type->AdvancedSearch->save();

        // Field job_category
        $this->job_category->AdvancedSearch->SearchValue = @$filter["x_job_category"];
        $this->job_category->AdvancedSearch->SearchOperator = @$filter["z_job_category"];
        $this->job_category->AdvancedSearch->SearchCondition = @$filter["v_job_category"];
        $this->job_category->AdvancedSearch->SearchValue2 = @$filter["y_job_category"];
        $this->job_category->AdvancedSearch->SearchOperator2 = @$filter["w_job_category"];
        $this->job_category->AdvancedSearch->save();

        // Field company_id
        $this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
        $this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
        $this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
        $this->company_id->AdvancedSearch->save();

        // Field description
        $this->description->AdvancedSearch->SearchValue = @$filter["x_description"];
        $this->description->AdvancedSearch->SearchOperator = @$filter["z_description"];
        $this->description->AdvancedSearch->SearchCondition = @$filter["v_description"];
        $this->description->AdvancedSearch->SearchValue2 = @$filter["y_description"];
        $this->description->AdvancedSearch->SearchOperator2 = @$filter["w_description"];
        $this->description->AdvancedSearch->save();

        // Field size
        $this->size->AdvancedSearch->SearchValue = @$filter["x_size"];
        $this->size->AdvancedSearch->SearchOperator = @$filter["z_size"];
        $this->size->AdvancedSearch->SearchCondition = @$filter["v_size"];
        $this->size->AdvancedSearch->SearchValue2 = @$filter["y_size"];
        $this->size->AdvancedSearch->SearchOperator2 = @$filter["w_size"];
        $this->size->AdvancedSearch->save();

        // Field quantity
        $this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
        $this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
        $this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
        $this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
        $this->quantity->AdvancedSearch->save();

        // Field pages
        $this->pages->AdvancedSearch->SearchValue = @$filter["x_pages"];
        $this->pages->AdvancedSearch->SearchOperator = @$filter["z_pages"];
        $this->pages->AdvancedSearch->SearchCondition = @$filter["v_pages"];
        $this->pages->AdvancedSearch->SearchValue2 = @$filter["y_pages"];
        $this->pages->AdvancedSearch->SearchOperator2 = @$filter["w_pages"];
        $this->pages->AdvancedSearch->save();

        // Field paper
        $this->paper->AdvancedSearch->SearchValue = @$filter["x_paper"];
        $this->paper->AdvancedSearch->SearchOperator = @$filter["z_paper"];
        $this->paper->AdvancedSearch->SearchCondition = @$filter["v_paper"];
        $this->paper->AdvancedSearch->SearchValue2 = @$filter["y_paper"];
        $this->paper->AdvancedSearch->SearchOperator2 = @$filter["w_paper"];
        $this->paper->AdvancedSearch->save();

        // Field remarks
        $this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
        $this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
        $this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
        $this->remarks->AdvancedSearch->save();

        // Field pr_01
        $this->pr_01->AdvancedSearch->SearchValue = @$filter["x_pr_01"];
        $this->pr_01->AdvancedSearch->SearchOperator = @$filter["z_pr_01"];
        $this->pr_01->AdvancedSearch->SearchCondition = @$filter["v_pr_01"];
        $this->pr_01->AdvancedSearch->SearchValue2 = @$filter["y_pr_01"];
        $this->pr_01->AdvancedSearch->SearchOperator2 = @$filter["w_pr_01"];
        $this->pr_01->AdvancedSearch->save();

        // Field qty_pr_01
        $this->qty_pr_01->AdvancedSearch->SearchValue = @$filter["x_qty_pr_01"];
        $this->qty_pr_01->AdvancedSearch->SearchOperator = @$filter["z_qty_pr_01"];
        $this->qty_pr_01->AdvancedSearch->SearchCondition = @$filter["v_qty_pr_01"];
        $this->qty_pr_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_pr_01"];
        $this->qty_pr_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pr_01"];
        $this->qty_pr_01->AdvancedSearch->save();

        // Field pl_01
        $this->pl_01->AdvancedSearch->SearchValue = @$filter["x_pl_01"];
        $this->pl_01->AdvancedSearch->SearchOperator = @$filter["z_pl_01"];
        $this->pl_01->AdvancedSearch->SearchCondition = @$filter["v_pl_01"];
        $this->pl_01->AdvancedSearch->SearchValue2 = @$filter["y_pl_01"];
        $this->pl_01->AdvancedSearch->SearchOperator2 = @$filter["w_pl_01"];
        $this->pl_01->AdvancedSearch->save();

        // Field qty_pl_01
        $this->qty_pl_01->AdvancedSearch->SearchValue = @$filter["x_qty_pl_01"];
        $this->qty_pl_01->AdvancedSearch->SearchOperator = @$filter["z_qty_pl_01"];
        $this->qty_pl_01->AdvancedSearch->SearchCondition = @$filter["v_qty_pl_01"];
        $this->qty_pl_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_pl_01"];
        $this->qty_pl_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pl_01"];
        $this->qty_pl_01->AdvancedSearch->save();

        // Field pr_02
        $this->pr_02->AdvancedSearch->SearchValue = @$filter["x_pr_02"];
        $this->pr_02->AdvancedSearch->SearchOperator = @$filter["z_pr_02"];
        $this->pr_02->AdvancedSearch->SearchCondition = @$filter["v_pr_02"];
        $this->pr_02->AdvancedSearch->SearchValue2 = @$filter["y_pr_02"];
        $this->pr_02->AdvancedSearch->SearchOperator2 = @$filter["w_pr_02"];
        $this->pr_02->AdvancedSearch->save();

        // Field qty_pr_02
        $this->qty_pr_02->AdvancedSearch->SearchValue = @$filter["x_qty_pr_02"];
        $this->qty_pr_02->AdvancedSearch->SearchOperator = @$filter["z_qty_pr_02"];
        $this->qty_pr_02->AdvancedSearch->SearchCondition = @$filter["v_qty_pr_02"];
        $this->qty_pr_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_pr_02"];
        $this->qty_pr_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pr_02"];
        $this->qty_pr_02->AdvancedSearch->save();

        // Field pl_02
        $this->pl_02->AdvancedSearch->SearchValue = @$filter["x_pl_02"];
        $this->pl_02->AdvancedSearch->SearchOperator = @$filter["z_pl_02"];
        $this->pl_02->AdvancedSearch->SearchCondition = @$filter["v_pl_02"];
        $this->pl_02->AdvancedSearch->SearchValue2 = @$filter["y_pl_02"];
        $this->pl_02->AdvancedSearch->SearchOperator2 = @$filter["w_pl_02"];
        $this->pl_02->AdvancedSearch->save();

        // Field qty_pl_02
        $this->qty_pl_02->AdvancedSearch->SearchValue = @$filter["x_qty_pl_02"];
        $this->qty_pl_02->AdvancedSearch->SearchOperator = @$filter["z_qty_pl_02"];
        $this->qty_pl_02->AdvancedSearch->SearchCondition = @$filter["v_qty_pl_02"];
        $this->qty_pl_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_pl_02"];
        $this->qty_pl_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pl_02"];
        $this->qty_pl_02->AdvancedSearch->save();

        // Field pr_03
        $this->pr_03->AdvancedSearch->SearchValue = @$filter["x_pr_03"];
        $this->pr_03->AdvancedSearch->SearchOperator = @$filter["z_pr_03"];
        $this->pr_03->AdvancedSearch->SearchCondition = @$filter["v_pr_03"];
        $this->pr_03->AdvancedSearch->SearchValue2 = @$filter["y_pr_03"];
        $this->pr_03->AdvancedSearch->SearchOperator2 = @$filter["w_pr_03"];
        $this->pr_03->AdvancedSearch->save();

        // Field qty_pr_03
        $this->qty_pr_03->AdvancedSearch->SearchValue = @$filter["x_qty_pr_03"];
        $this->qty_pr_03->AdvancedSearch->SearchOperator = @$filter["z_qty_pr_03"];
        $this->qty_pr_03->AdvancedSearch->SearchCondition = @$filter["v_qty_pr_03"];
        $this->qty_pr_03->AdvancedSearch->SearchValue2 = @$filter["y_qty_pr_03"];
        $this->qty_pr_03->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pr_03"];
        $this->qty_pr_03->AdvancedSearch->save();

        // Field pl_03
        $this->pl_03->AdvancedSearch->SearchValue = @$filter["x_pl_03"];
        $this->pl_03->AdvancedSearch->SearchOperator = @$filter["z_pl_03"];
        $this->pl_03->AdvancedSearch->SearchCondition = @$filter["v_pl_03"];
        $this->pl_03->AdvancedSearch->SearchValue2 = @$filter["y_pl_03"];
        $this->pl_03->AdvancedSearch->SearchOperator2 = @$filter["w_pl_03"];
        $this->pl_03->AdvancedSearch->save();

        // Field qty_pl_03
        $this->qty_pl_03->AdvancedSearch->SearchValue = @$filter["x_qty_pl_03"];
        $this->qty_pl_03->AdvancedSearch->SearchOperator = @$filter["z_qty_pl_03"];
        $this->qty_pl_03->AdvancedSearch->SearchCondition = @$filter["v_qty_pl_03"];
        $this->qty_pl_03->AdvancedSearch->SearchValue2 = @$filter["y_qty_pl_03"];
        $this->qty_pl_03->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pl_03"];
        $this->qty_pl_03->AdvancedSearch->save();

        // Field pr_04
        $this->pr_04->AdvancedSearch->SearchValue = @$filter["x_pr_04"];
        $this->pr_04->AdvancedSearch->SearchOperator = @$filter["z_pr_04"];
        $this->pr_04->AdvancedSearch->SearchCondition = @$filter["v_pr_04"];
        $this->pr_04->AdvancedSearch->SearchValue2 = @$filter["y_pr_04"];
        $this->pr_04->AdvancedSearch->SearchOperator2 = @$filter["w_pr_04"];
        $this->pr_04->AdvancedSearch->save();

        // Field qty_pr_04
        $this->qty_pr_04->AdvancedSearch->SearchValue = @$filter["x_qty_pr_04"];
        $this->qty_pr_04->AdvancedSearch->SearchOperator = @$filter["z_qty_pr_04"];
        $this->qty_pr_04->AdvancedSearch->SearchCondition = @$filter["v_qty_pr_04"];
        $this->qty_pr_04->AdvancedSearch->SearchValue2 = @$filter["y_qty_pr_04"];
        $this->qty_pr_04->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pr_04"];
        $this->qty_pr_04->AdvancedSearch->save();

        // Field pl_04
        $this->pl_04->AdvancedSearch->SearchValue = @$filter["x_pl_04"];
        $this->pl_04->AdvancedSearch->SearchOperator = @$filter["z_pl_04"];
        $this->pl_04->AdvancedSearch->SearchCondition = @$filter["v_pl_04"];
        $this->pl_04->AdvancedSearch->SearchValue2 = @$filter["y_pl_04"];
        $this->pl_04->AdvancedSearch->SearchOperator2 = @$filter["w_pl_04"];
        $this->pl_04->AdvancedSearch->save();

        // Field qty_pl_04
        $this->qty_pl_04->AdvancedSearch->SearchValue = @$filter["x_qty_pl_04"];
        $this->qty_pl_04->AdvancedSearch->SearchOperator = @$filter["z_qty_pl_04"];
        $this->qty_pl_04->AdvancedSearch->SearchCondition = @$filter["v_qty_pl_04"];
        $this->qty_pl_04->AdvancedSearch->SearchValue2 = @$filter["y_qty_pl_04"];
        $this->qty_pl_04->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pl_04"];
        $this->qty_pl_04->AdvancedSearch->save();

        // Field pa_01
        $this->pa_01->AdvancedSearch->SearchValue = @$filter["x_pa_01"];
        $this->pa_01->AdvancedSearch->SearchOperator = @$filter["z_pa_01"];
        $this->pa_01->AdvancedSearch->SearchCondition = @$filter["v_pa_01"];
        $this->pa_01->AdvancedSearch->SearchValue2 = @$filter["y_pa_01"];
        $this->pa_01->AdvancedSearch->SearchOperator2 = @$filter["w_pa_01"];
        $this->pa_01->AdvancedSearch->save();

        // Field qty_pa_01
        $this->qty_pa_01->AdvancedSearch->SearchValue = @$filter["x_qty_pa_01"];
        $this->qty_pa_01->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_01"];
        $this->qty_pa_01->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_01"];
        $this->qty_pa_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_01"];
        $this->qty_pa_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_01"];
        $this->qty_pa_01->AdvancedSearch->save();

        // Field pa_02
        $this->pa_02->AdvancedSearch->SearchValue = @$filter["x_pa_02"];
        $this->pa_02->AdvancedSearch->SearchOperator = @$filter["z_pa_02"];
        $this->pa_02->AdvancedSearch->SearchCondition = @$filter["v_pa_02"];
        $this->pa_02->AdvancedSearch->SearchValue2 = @$filter["y_pa_02"];
        $this->pa_02->AdvancedSearch->SearchOperator2 = @$filter["w_pa_02"];
        $this->pa_02->AdvancedSearch->save();

        // Field qty_pa_02
        $this->qty_pa_02->AdvancedSearch->SearchValue = @$filter["x_qty_pa_02"];
        $this->qty_pa_02->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_02"];
        $this->qty_pa_02->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_02"];
        $this->qty_pa_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_02"];
        $this->qty_pa_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_02"];
        $this->qty_pa_02->AdvancedSearch->save();

        // Field pa_03
        $this->pa_03->AdvancedSearch->SearchValue = @$filter["x_pa_03"];
        $this->pa_03->AdvancedSearch->SearchOperator = @$filter["z_pa_03"];
        $this->pa_03->AdvancedSearch->SearchCondition = @$filter["v_pa_03"];
        $this->pa_03->AdvancedSearch->SearchValue2 = @$filter["y_pa_03"];
        $this->pa_03->AdvancedSearch->SearchOperator2 = @$filter["w_pa_03"];
        $this->pa_03->AdvancedSearch->save();

        // Field qty_pa_03
        $this->qty_pa_03->AdvancedSearch->SearchValue = @$filter["x_qty_pa_03"];
        $this->qty_pa_03->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_03"];
        $this->qty_pa_03->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_03"];
        $this->qty_pa_03->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_03"];
        $this->qty_pa_03->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_03"];
        $this->qty_pa_03->AdvancedSearch->save();

        // Field pa_04
        $this->pa_04->AdvancedSearch->SearchValue = @$filter["x_pa_04"];
        $this->pa_04->AdvancedSearch->SearchOperator = @$filter["z_pa_04"];
        $this->pa_04->AdvancedSearch->SearchCondition = @$filter["v_pa_04"];
        $this->pa_04->AdvancedSearch->SearchValue2 = @$filter["y_pa_04"];
        $this->pa_04->AdvancedSearch->SearchOperator2 = @$filter["w_pa_04"];
        $this->pa_04->AdvancedSearch->save();

        // Field qty_pa_04
        $this->qty_pa_04->AdvancedSearch->SearchValue = @$filter["x_qty_pa_04"];
        $this->qty_pa_04->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_04"];
        $this->qty_pa_04->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_04"];
        $this->qty_pa_04->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_04"];
        $this->qty_pa_04->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_04"];
        $this->qty_pa_04->AdvancedSearch->save();

        // Field pa_05
        $this->pa_05->AdvancedSearch->SearchValue = @$filter["x_pa_05"];
        $this->pa_05->AdvancedSearch->SearchOperator = @$filter["z_pa_05"];
        $this->pa_05->AdvancedSearch->SearchCondition = @$filter["v_pa_05"];
        $this->pa_05->AdvancedSearch->SearchValue2 = @$filter["y_pa_05"];
        $this->pa_05->AdvancedSearch->SearchOperator2 = @$filter["w_pa_05"];
        $this->pa_05->AdvancedSearch->save();

        // Field qty_pa_05
        $this->qty_pa_05->AdvancedSearch->SearchValue = @$filter["x_qty_pa_05"];
        $this->qty_pa_05->AdvancedSearch->SearchOperator = @$filter["z_qty_pa_05"];
        $this->qty_pa_05->AdvancedSearch->SearchCondition = @$filter["v_qty_pa_05"];
        $this->qty_pa_05->AdvancedSearch->SearchValue2 = @$filter["y_qty_pa_05"];
        $this->qty_pa_05->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pa_05"];
        $this->qty_pa_05->AdvancedSearch->save();

        // Field pc_01
        $this->pc_01->AdvancedSearch->SearchValue = @$filter["x_pc_01"];
        $this->pc_01->AdvancedSearch->SearchOperator = @$filter["z_pc_01"];
        $this->pc_01->AdvancedSearch->SearchCondition = @$filter["v_pc_01"];
        $this->pc_01->AdvancedSearch->SearchValue2 = @$filter["y_pc_01"];
        $this->pc_01->AdvancedSearch->SearchOperator2 = @$filter["w_pc_01"];
        $this->pc_01->AdvancedSearch->save();

        // Field qty_pc_01
        $this->qty_pc_01->AdvancedSearch->SearchValue = @$filter["x_qty_pc_01"];
        $this->qty_pc_01->AdvancedSearch->SearchOperator = @$filter["z_qty_pc_01"];
        $this->qty_pc_01->AdvancedSearch->SearchCondition = @$filter["v_qty_pc_01"];
        $this->qty_pc_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_pc_01"];
        $this->qty_pc_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pc_01"];
        $this->qty_pc_01->AdvancedSearch->save();

        // Field pc_02
        $this->pc_02->AdvancedSearch->SearchValue = @$filter["x_pc_02"];
        $this->pc_02->AdvancedSearch->SearchOperator = @$filter["z_pc_02"];
        $this->pc_02->AdvancedSearch->SearchCondition = @$filter["v_pc_02"];
        $this->pc_02->AdvancedSearch->SearchValue2 = @$filter["y_pc_02"];
        $this->pc_02->AdvancedSearch->SearchOperator2 = @$filter["w_pc_02"];
        $this->pc_02->AdvancedSearch->save();

        // Field qty_pc_02
        $this->qty_pc_02->AdvancedSearch->SearchValue = @$filter["x_qty_pc_02"];
        $this->qty_pc_02->AdvancedSearch->SearchOperator = @$filter["z_qty_pc_02"];
        $this->qty_pc_02->AdvancedSearch->SearchCondition = @$filter["v_qty_pc_02"];
        $this->qty_pc_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_pc_02"];
        $this->qty_pc_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_pc_02"];
        $this->qty_pc_02->AdvancedSearch->save();

        // Field o_01
        $this->o_01->AdvancedSearch->SearchValue = @$filter["x_o_01"];
        $this->o_01->AdvancedSearch->SearchOperator = @$filter["z_o_01"];
        $this->o_01->AdvancedSearch->SearchCondition = @$filter["v_o_01"];
        $this->o_01->AdvancedSearch->SearchValue2 = @$filter["y_o_01"];
        $this->o_01->AdvancedSearch->SearchOperator2 = @$filter["w_o_01"];
        $this->o_01->AdvancedSearch->save();

        // Field qty_o_01
        $this->qty_o_01->AdvancedSearch->SearchValue = @$filter["x_qty_o_01"];
        $this->qty_o_01->AdvancedSearch->SearchOperator = @$filter["z_qty_o_01"];
        $this->qty_o_01->AdvancedSearch->SearchCondition = @$filter["v_qty_o_01"];
        $this->qty_o_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_o_01"];
        $this->qty_o_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_o_01"];
        $this->qty_o_01->AdvancedSearch->save();

        // Field lamination_type
        $this->lamination_type->AdvancedSearch->SearchValue = @$filter["x_lamination_type"];
        $this->lamination_type->AdvancedSearch->SearchOperator = @$filter["z_lamination_type"];
        $this->lamination_type->AdvancedSearch->SearchCondition = @$filter["v_lamination_type"];
        $this->lamination_type->AdvancedSearch->SearchValue2 = @$filter["y_lamination_type"];
        $this->lamination_type->AdvancedSearch->SearchOperator2 = @$filter["w_lamination_type"];
        $this->lamination_type->AdvancedSearch->save();

        // Field lamination_qty
        $this->lamination_qty->AdvancedSearch->SearchValue = @$filter["x_lamination_qty"];
        $this->lamination_qty->AdvancedSearch->SearchOperator = @$filter["z_lamination_qty"];
        $this->lamination_qty->AdvancedSearch->SearchCondition = @$filter["v_lamination_qty"];
        $this->lamination_qty->AdvancedSearch->SearchValue2 = @$filter["y_lamination_qty"];
        $this->lamination_qty->AdvancedSearch->SearchOperator2 = @$filter["w_lamination_qty"];
        $this->lamination_qty->AdvancedSearch->save();

        // Field die_type
        $this->die_type->AdvancedSearch->SearchValue = @$filter["x_die_type"];
        $this->die_type->AdvancedSearch->SearchOperator = @$filter["z_die_type"];
        $this->die_type->AdvancedSearch->SearchCondition = @$filter["v_die_type"];
        $this->die_type->AdvancedSearch->SearchValue2 = @$filter["y_die_type"];
        $this->die_type->AdvancedSearch->SearchOperator2 = @$filter["w_die_type"];
        $this->die_type->AdvancedSearch->save();

        // Field die_qty
        $this->die_qty->AdvancedSearch->SearchValue = @$filter["x_die_qty"];
        $this->die_qty->AdvancedSearch->SearchOperator = @$filter["z_die_qty"];
        $this->die_qty->AdvancedSearch->SearchCondition = @$filter["v_die_qty"];
        $this->die_qty->AdvancedSearch->SearchValue2 = @$filter["y_die_qty"];
        $this->die_qty->AdvancedSearch->SearchOperator2 = @$filter["w_die_qty"];
        $this->die_qty->AdvancedSearch->save();

        // Field binding_type
        $this->binding_type->AdvancedSearch->SearchValue = @$filter["x_binding_type"];
        $this->binding_type->AdvancedSearch->SearchOperator = @$filter["z_binding_type"];
        $this->binding_type->AdvancedSearch->SearchCondition = @$filter["v_binding_type"];
        $this->binding_type->AdvancedSearch->SearchValue2 = @$filter["y_binding_type"];
        $this->binding_type->AdvancedSearch->SearchOperator2 = @$filter["w_binding_type"];
        $this->binding_type->AdvancedSearch->save();

        // Field binding_qty
        $this->binding_qty->AdvancedSearch->SearchValue = @$filter["x_binding_qty"];
        $this->binding_qty->AdvancedSearch->SearchOperator = @$filter["z_binding_qty"];
        $this->binding_qty->AdvancedSearch->SearchCondition = @$filter["v_binding_qty"];
        $this->binding_qty->AdvancedSearch->SearchValue2 = @$filter["y_binding_qty"];
        $this->binding_qty->AdvancedSearch->SearchOperator2 = @$filter["w_binding_qty"];
        $this->binding_qty->AdvancedSearch->save();

        // Field number_type
        $this->number_type->AdvancedSearch->SearchValue = @$filter["x_number_type"];
        $this->number_type->AdvancedSearch->SearchOperator = @$filter["z_number_type"];
        $this->number_type->AdvancedSearch->SearchCondition = @$filter["v_number_type"];
        $this->number_type->AdvancedSearch->SearchValue2 = @$filter["y_number_type"];
        $this->number_type->AdvancedSearch->SearchOperator2 = @$filter["w_number_type"];
        $this->number_type->AdvancedSearch->save();

        // Field number_qty
        $this->number_qty->AdvancedSearch->SearchValue = @$filter["x_number_qty"];
        $this->number_qty->AdvancedSearch->SearchOperator = @$filter["z_number_qty"];
        $this->number_qty->AdvancedSearch->SearchCondition = @$filter["v_number_qty"];
        $this->number_qty->AdvancedSearch->SearchValue2 = @$filter["y_number_qty"];
        $this->number_qty->AdvancedSearch->SearchOperator2 = @$filter["w_number_qty"];
        $this->number_qty->AdvancedSearch->save();

        // Field de_01
        $this->de_01->AdvancedSearch->SearchValue = @$filter["x_de_01"];
        $this->de_01->AdvancedSearch->SearchOperator = @$filter["z_de_01"];
        $this->de_01->AdvancedSearch->SearchCondition = @$filter["v_de_01"];
        $this->de_01->AdvancedSearch->SearchValue2 = @$filter["y_de_01"];
        $this->de_01->AdvancedSearch->SearchOperator2 = @$filter["w_de_01"];
        $this->de_01->AdvancedSearch->save();

        // Field qty_de_01
        $this->qty_de_01->AdvancedSearch->SearchValue = @$filter["x_qty_de_01"];
        $this->qty_de_01->AdvancedSearch->SearchOperator = @$filter["z_qty_de_01"];
        $this->qty_de_01->AdvancedSearch->SearchCondition = @$filter["v_qty_de_01"];
        $this->qty_de_01->AdvancedSearch->SearchValue2 = @$filter["y_qty_de_01"];
        $this->qty_de_01->AdvancedSearch->SearchOperator2 = @$filter["w_qty_de_01"];
        $this->qty_de_01->AdvancedSearch->save();

        // Field de_02
        $this->de_02->AdvancedSearch->SearchValue = @$filter["x_de_02"];
        $this->de_02->AdvancedSearch->SearchOperator = @$filter["z_de_02"];
        $this->de_02->AdvancedSearch->SearchCondition = @$filter["v_de_02"];
        $this->de_02->AdvancedSearch->SearchValue2 = @$filter["y_de_02"];
        $this->de_02->AdvancedSearch->SearchOperator2 = @$filter["w_de_02"];
        $this->de_02->AdvancedSearch->save();

        // Field qty_de_02
        $this->qty_de_02->AdvancedSearch->SearchValue = @$filter["x_qty_de_02"];
        $this->qty_de_02->AdvancedSearch->SearchOperator = @$filter["z_qty_de_02"];
        $this->qty_de_02->AdvancedSearch->SearchCondition = @$filter["v_qty_de_02"];
        $this->qty_de_02->AdvancedSearch->SearchValue2 = @$filter["y_qty_de_02"];
        $this->qty_de_02->AdvancedSearch->SearchOperator2 = @$filter["w_qty_de_02"];
        $this->qty_de_02->AdvancedSearch->save();

        // Field de_03
        $this->de_03->AdvancedSearch->SearchValue = @$filter["x_de_03"];
        $this->de_03->AdvancedSearch->SearchOperator = @$filter["z_de_03"];
        $this->de_03->AdvancedSearch->SearchCondition = @$filter["v_de_03"];
        $this->de_03->AdvancedSearch->SearchValue2 = @$filter["y_de_03"];
        $this->de_03->AdvancedSearch->SearchOperator2 = @$filter["w_de_03"];
        $this->de_03->AdvancedSearch->save();

        // Field qty_de_03
        $this->qty_de_03->AdvancedSearch->SearchValue = @$filter["x_qty_de_03"];
        $this->qty_de_03->AdvancedSearch->SearchOperator = @$filter["z_qty_de_03"];
        $this->qty_de_03->AdvancedSearch->SearchCondition = @$filter["v_qty_de_03"];
        $this->qty_de_03->AdvancedSearch->SearchValue2 = @$filter["y_qty_de_03"];
        $this->qty_de_03->AdvancedSearch->SearchOperator2 = @$filter["w_qty_de_03"];
        $this->qty_de_03->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->job_type, $default, false); // job_type
        $this->buildSearchSql($where, $this->job_category, $default, false); // job_category
        $this->buildSearchSql($where, $this->company_id, $default, false); // company_id
        $this->buildSearchSql($where, $this->description, $default, false); // description
        $this->buildSearchSql($where, $this->size, $default, false); // size
        $this->buildSearchSql($where, $this->quantity, $default, false); // quantity
        $this->buildSearchSql($where, $this->pages, $default, false); // pages
        $this->buildSearchSql($where, $this->paper, $default, false); // paper
        $this->buildSearchSql($where, $this->remarks, $default, false); // remarks
        $this->buildSearchSql($where, $this->pr_01, $default, false); // pr_01
        $this->buildSearchSql($where, $this->qty_pr_01, $default, false); // qty_pr_01
        $this->buildSearchSql($where, $this->pl_01, $default, false); // pl_01
        $this->buildSearchSql($where, $this->qty_pl_01, $default, false); // qty_pl_01
        $this->buildSearchSql($where, $this->pr_02, $default, false); // pr_02
        $this->buildSearchSql($where, $this->qty_pr_02, $default, false); // qty_pr_02
        $this->buildSearchSql($where, $this->pl_02, $default, false); // pl_02
        $this->buildSearchSql($where, $this->qty_pl_02, $default, false); // qty_pl_02
        $this->buildSearchSql($where, $this->pr_03, $default, false); // pr_03
        $this->buildSearchSql($where, $this->qty_pr_03, $default, false); // qty_pr_03
        $this->buildSearchSql($where, $this->pl_03, $default, false); // pl_03
        $this->buildSearchSql($where, $this->qty_pl_03, $default, false); // qty_pl_03
        $this->buildSearchSql($where, $this->pr_04, $default, false); // pr_04
        $this->buildSearchSql($where, $this->qty_pr_04, $default, false); // qty_pr_04
        $this->buildSearchSql($where, $this->pl_04, $default, false); // pl_04
        $this->buildSearchSql($where, $this->qty_pl_04, $default, false); // qty_pl_04
        $this->buildSearchSql($where, $this->pa_01, $default, false); // pa_01
        $this->buildSearchSql($where, $this->qty_pa_01, $default, false); // qty_pa_01
        $this->buildSearchSql($where, $this->pa_02, $default, false); // pa_02
        $this->buildSearchSql($where, $this->qty_pa_02, $default, false); // qty_pa_02
        $this->buildSearchSql($where, $this->pa_03, $default, false); // pa_03
        $this->buildSearchSql($where, $this->qty_pa_03, $default, false); // qty_pa_03
        $this->buildSearchSql($where, $this->pa_04, $default, false); // pa_04
        $this->buildSearchSql($where, $this->qty_pa_04, $default, false); // qty_pa_04
        $this->buildSearchSql($where, $this->pa_05, $default, false); // pa_05
        $this->buildSearchSql($where, $this->qty_pa_05, $default, false); // qty_pa_05
        $this->buildSearchSql($where, $this->pc_01, $default, false); // pc_01
        $this->buildSearchSql($where, $this->qty_pc_01, $default, false); // qty_pc_01
        $this->buildSearchSql($where, $this->pc_02, $default, false); // pc_02
        $this->buildSearchSql($where, $this->qty_pc_02, $default, false); // qty_pc_02
        $this->buildSearchSql($where, $this->o_01, $default, false); // o_01
        $this->buildSearchSql($where, $this->qty_o_01, $default, false); // qty_o_01
        $this->buildSearchSql($where, $this->lamination_type, $default, false); // lamination_type
        $this->buildSearchSql($where, $this->lamination_qty, $default, false); // lamination_qty
        $this->buildSearchSql($where, $this->die_type, $default, false); // die_type
        $this->buildSearchSql($where, $this->die_qty, $default, false); // die_qty
        $this->buildSearchSql($where, $this->binding_type, $default, false); // binding_type
        $this->buildSearchSql($where, $this->binding_qty, $default, false); // binding_qty
        $this->buildSearchSql($where, $this->number_type, $default, false); // number_type
        $this->buildSearchSql($where, $this->number_qty, $default, false); // number_qty
        $this->buildSearchSql($where, $this->de_01, $default, false); // de_01
        $this->buildSearchSql($where, $this->qty_de_01, $default, false); // qty_de_01
        $this->buildSearchSql($where, $this->de_02, $default, false); // de_02
        $this->buildSearchSql($where, $this->qty_de_02, $default, false); // qty_de_02
        $this->buildSearchSql($where, $this->de_03, $default, false); // de_03
        $this->buildSearchSql($where, $this->qty_de_03, $default, false); // qty_de_03
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->job_type->AdvancedSearch->save(); // job_type
            $this->job_category->AdvancedSearch->save(); // job_category
            $this->company_id->AdvancedSearch->save(); // company_id
            $this->description->AdvancedSearch->save(); // description
            $this->size->AdvancedSearch->save(); // size
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->pages->AdvancedSearch->save(); // pages
            $this->paper->AdvancedSearch->save(); // paper
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->pr_01->AdvancedSearch->save(); // pr_01
            $this->qty_pr_01->AdvancedSearch->save(); // qty_pr_01
            $this->pl_01->AdvancedSearch->save(); // pl_01
            $this->qty_pl_01->AdvancedSearch->save(); // qty_pl_01
            $this->pr_02->AdvancedSearch->save(); // pr_02
            $this->qty_pr_02->AdvancedSearch->save(); // qty_pr_02
            $this->pl_02->AdvancedSearch->save(); // pl_02
            $this->qty_pl_02->AdvancedSearch->save(); // qty_pl_02
            $this->pr_03->AdvancedSearch->save(); // pr_03
            $this->qty_pr_03->AdvancedSearch->save(); // qty_pr_03
            $this->pl_03->AdvancedSearch->save(); // pl_03
            $this->qty_pl_03->AdvancedSearch->save(); // qty_pl_03
            $this->pr_04->AdvancedSearch->save(); // pr_04
            $this->qty_pr_04->AdvancedSearch->save(); // qty_pr_04
            $this->pl_04->AdvancedSearch->save(); // pl_04
            $this->qty_pl_04->AdvancedSearch->save(); // qty_pl_04
            $this->pa_01->AdvancedSearch->save(); // pa_01
            $this->qty_pa_01->AdvancedSearch->save(); // qty_pa_01
            $this->pa_02->AdvancedSearch->save(); // pa_02
            $this->qty_pa_02->AdvancedSearch->save(); // qty_pa_02
            $this->pa_03->AdvancedSearch->save(); // pa_03
            $this->qty_pa_03->AdvancedSearch->save(); // qty_pa_03
            $this->pa_04->AdvancedSearch->save(); // pa_04
            $this->qty_pa_04->AdvancedSearch->save(); // qty_pa_04
            $this->pa_05->AdvancedSearch->save(); // pa_05
            $this->qty_pa_05->AdvancedSearch->save(); // qty_pa_05
            $this->pc_01->AdvancedSearch->save(); // pc_01
            $this->qty_pc_01->AdvancedSearch->save(); // qty_pc_01
            $this->pc_02->AdvancedSearch->save(); // pc_02
            $this->qty_pc_02->AdvancedSearch->save(); // qty_pc_02
            $this->o_01->AdvancedSearch->save(); // o_01
            $this->qty_o_01->AdvancedSearch->save(); // qty_o_01
            $this->lamination_type->AdvancedSearch->save(); // lamination_type
            $this->lamination_qty->AdvancedSearch->save(); // lamination_qty
            $this->die_type->AdvancedSearch->save(); // die_type
            $this->die_qty->AdvancedSearch->save(); // die_qty
            $this->binding_type->AdvancedSearch->save(); // binding_type
            $this->binding_qty->AdvancedSearch->save(); // binding_qty
            $this->number_type->AdvancedSearch->save(); // number_type
            $this->number_qty->AdvancedSearch->save(); // number_qty
            $this->de_01->AdvancedSearch->save(); // de_01
            $this->qty_de_01->AdvancedSearch->save(); // qty_de_01
            $this->de_02->AdvancedSearch->save(); // de_02
            $this->qty_de_02->AdvancedSearch->save(); // qty_de_02
            $this->de_03->AdvancedSearch->save(); // de_03
            $this->qty_de_03->AdvancedSearch->save(); // qty_de_03
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->job_type->AdvancedSearch->save(); // job_type
            $this->job_category->AdvancedSearch->save(); // job_category
            $this->company_id->AdvancedSearch->save(); // company_id
            $this->description->AdvancedSearch->save(); // description
            $this->size->AdvancedSearch->save(); // size
            $this->quantity->AdvancedSearch->save(); // quantity
            $this->pages->AdvancedSearch->save(); // pages
            $this->paper->AdvancedSearch->save(); // paper
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->pr_01->AdvancedSearch->save(); // pr_01
            $this->qty_pr_01->AdvancedSearch->save(); // qty_pr_01
            $this->pl_01->AdvancedSearch->save(); // pl_01
            $this->qty_pl_01->AdvancedSearch->save(); // qty_pl_01
            $this->pr_02->AdvancedSearch->save(); // pr_02
            $this->qty_pr_02->AdvancedSearch->save(); // qty_pr_02
            $this->pl_02->AdvancedSearch->save(); // pl_02
            $this->qty_pl_02->AdvancedSearch->save(); // qty_pl_02
            $this->pr_03->AdvancedSearch->save(); // pr_03
            $this->qty_pr_03->AdvancedSearch->save(); // qty_pr_03
            $this->pl_03->AdvancedSearch->save(); // pl_03
            $this->qty_pl_03->AdvancedSearch->save(); // qty_pl_03
            $this->pr_04->AdvancedSearch->save(); // pr_04
            $this->qty_pr_04->AdvancedSearch->save(); // qty_pr_04
            $this->pl_04->AdvancedSearch->save(); // pl_04
            $this->qty_pl_04->AdvancedSearch->save(); // qty_pl_04
            $this->pa_01->AdvancedSearch->save(); // pa_01
            $this->qty_pa_01->AdvancedSearch->save(); // qty_pa_01
            $this->pa_02->AdvancedSearch->save(); // pa_02
            $this->qty_pa_02->AdvancedSearch->save(); // qty_pa_02
            $this->pa_03->AdvancedSearch->save(); // pa_03
            $this->qty_pa_03->AdvancedSearch->save(); // qty_pa_03
            $this->pa_04->AdvancedSearch->save(); // pa_04
            $this->qty_pa_04->AdvancedSearch->save(); // qty_pa_04
            $this->pa_05->AdvancedSearch->save(); // pa_05
            $this->qty_pa_05->AdvancedSearch->save(); // qty_pa_05
            $this->pc_01->AdvancedSearch->save(); // pc_01
            $this->qty_pc_01->AdvancedSearch->save(); // qty_pc_01
            $this->pc_02->AdvancedSearch->save(); // pc_02
            $this->qty_pc_02->AdvancedSearch->save(); // qty_pc_02
            $this->o_01->AdvancedSearch->save(); // o_01
            $this->qty_o_01->AdvancedSearch->save(); // qty_o_01
            $this->lamination_type->AdvancedSearch->save(); // lamination_type
            $this->lamination_qty->AdvancedSearch->save(); // lamination_qty
            $this->die_type->AdvancedSearch->save(); // die_type
            $this->die_qty->AdvancedSearch->save(); // die_qty
            $this->binding_type->AdvancedSearch->save(); // binding_type
            $this->binding_qty->AdvancedSearch->save(); // binding_qty
            $this->number_type->AdvancedSearch->save(); // number_type
            $this->number_qty->AdvancedSearch->save(); // number_qty
            $this->de_01->AdvancedSearch->save(); // de_01
            $this->qty_de_01->AdvancedSearch->save(); // qty_de_01
            $this->de_02->AdvancedSearch->save(); // de_02
            $this->qty_de_02->AdvancedSearch->save(); // qty_de_02
            $this->de_03->AdvancedSearch->save(); // de_03
            $this->qty_de_03->AdvancedSearch->save(); // qty_de_03
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field job_type
        $filter = $this->queryBuilderWhere("job_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->job_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->job_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field job_category
        $filter = $this->queryBuilderWhere("job_category");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->job_category, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->job_category->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field company_id
        $filter = $this->queryBuilderWhere("company_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->company_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->company_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field description
        $filter = $this->queryBuilderWhere("description");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->description, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->description->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field size
        $filter = $this->queryBuilderWhere("size");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->size, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->size->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field quantity
        $filter = $this->queryBuilderWhere("quantity");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->quantity, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->quantity->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pages
        $filter = $this->queryBuilderWhere("pages");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pages, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pages->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field paper
        $filter = $this->queryBuilderWhere("paper");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->paper, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->paper->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field remarks
        $filter = $this->queryBuilderWhere("remarks");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->remarks, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->remarks->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pr_01
        $filter = $this->queryBuilderWhere("pr_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pr_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pr_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pr_01
        $filter = $this->queryBuilderWhere("qty_pr_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pr_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pr_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_01
        $filter = $this->queryBuilderWhere("pl_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pl_01
        $filter = $this->queryBuilderWhere("qty_pl_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pl_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pl_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pr_02
        $filter = $this->queryBuilderWhere("pr_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pr_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pr_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pr_02
        $filter = $this->queryBuilderWhere("qty_pr_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pr_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pr_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_02
        $filter = $this->queryBuilderWhere("pl_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pl_02
        $filter = $this->queryBuilderWhere("qty_pl_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pl_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pl_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pr_03
        $filter = $this->queryBuilderWhere("pr_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pr_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pr_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pr_03
        $filter = $this->queryBuilderWhere("qty_pr_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pr_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pr_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_03
        $filter = $this->queryBuilderWhere("pl_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pl_03
        $filter = $this->queryBuilderWhere("qty_pl_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pl_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pl_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pr_04
        $filter = $this->queryBuilderWhere("pr_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pr_04, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pr_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pr_04
        $filter = $this->queryBuilderWhere("qty_pr_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pr_04, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pr_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_04
        $filter = $this->queryBuilderWhere("pl_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_04, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pl_04
        $filter = $this->queryBuilderWhere("qty_pl_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pl_04, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pl_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_01
        $filter = $this->queryBuilderWhere("pa_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pa_01
        $filter = $this->queryBuilderWhere("qty_pa_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pa_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pa_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_02
        $filter = $this->queryBuilderWhere("pa_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pa_02
        $filter = $this->queryBuilderWhere("qty_pa_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pa_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pa_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_03
        $filter = $this->queryBuilderWhere("pa_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pa_03
        $filter = $this->queryBuilderWhere("qty_pa_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pa_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pa_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_04
        $filter = $this->queryBuilderWhere("pa_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_04, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pa_04
        $filter = $this->queryBuilderWhere("qty_pa_04");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pa_04, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pa_04->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pa_05
        $filter = $this->queryBuilderWhere("pa_05");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pa_05, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pa_05->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pa_05
        $filter = $this->queryBuilderWhere("qty_pa_05");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pa_05, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pa_05->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_01
        $filter = $this->queryBuilderWhere("pc_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pc_01
        $filter = $this->queryBuilderWhere("qty_pc_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pc_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pc_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pc_02
        $filter = $this->queryBuilderWhere("pc_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pc_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pc_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_pc_02
        $filter = $this->queryBuilderWhere("qty_pc_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_pc_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_pc_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field o_01
        $filter = $this->queryBuilderWhere("o_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->o_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->o_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_o_01
        $filter = $this->queryBuilderWhere("qty_o_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_o_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_o_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field lamination_type
        $filter = $this->queryBuilderWhere("lamination_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->lamination_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->lamination_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field lamination_qty
        $filter = $this->queryBuilderWhere("lamination_qty");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->lamination_qty, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->lamination_qty->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field die_type
        $filter = $this->queryBuilderWhere("die_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->die_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->die_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field die_qty
        $filter = $this->queryBuilderWhere("die_qty");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->die_qty, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->die_qty->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field binding_type
        $filter = $this->queryBuilderWhere("binding_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->binding_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->binding_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field binding_qty
        $filter = $this->queryBuilderWhere("binding_qty");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->binding_qty, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->binding_qty->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field number_type
        $filter = $this->queryBuilderWhere("number_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->number_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->number_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field number_qty
        $filter = $this->queryBuilderWhere("number_qty");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->number_qty, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->number_qty->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field de_01
        $filter = $this->queryBuilderWhere("de_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->de_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->de_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_de_01
        $filter = $this->queryBuilderWhere("qty_de_01");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_de_01, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_de_01->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field de_02
        $filter = $this->queryBuilderWhere("de_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->de_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->de_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_de_02
        $filter = $this->queryBuilderWhere("qty_de_02");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_de_02, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_de_02->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field de_03
        $filter = $this->queryBuilderWhere("de_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->de_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->de_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty_de_03
        $filter = $this->queryBuilderWhere("qty_de_03");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty_de_03, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty_de_03->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field operator
        $filter = $this->queryBuilderWhere("operator");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->operator, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->operator->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field datetime
        $filter = $this->queryBuilderWhere("datetime");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->datetime, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datetime->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->id;
        $searchFlds[] = &$this->company_id;
        $searchFlds[] = &$this->description;
        $searchFlds[] = &$this->remarks;
        $searchFlds[] = &$this->pr_01;
        $searchFlds[] = &$this->pr_02;
        $searchFlds[] = &$this->pr_03;
        $searchFlds[] = &$this->pr_04;
        $searchFlds[] = &$this->pa_01;
        $searchFlds[] = &$this->pa_02;
        $searchFlds[] = &$this->pa_03;
        $searchFlds[] = &$this->pa_04;
        $searchFlds[] = &$this->pa_05;
        $searchFlds[] = &$this->pc_01;
        $searchFlds[] = &$this->pc_02;
        $searchFlds[] = &$this->o_01;
        $searchFlds[] = &$this->die_type;
        $searchFlds[] = &$this->number_type;
        $searchFlds[] = &$this->de_01;
        $searchFlds[] = &$this->de_02;
        $searchFlds[] = &$this->de_03;
        $searchFlds[] = &$this->operator;
        $searchFlds[] = &$this->datetime;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->job_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->job_category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->company_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->size->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->quantity->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pages->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->paper->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pr_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pr_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pl_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pr_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pr_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pl_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pr_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pr_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pl_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pr_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pr_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pl_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pa_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pa_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pa_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pa_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pa_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pa_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pc_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pc_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_pc_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->o_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_o_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->lamination_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->lamination_qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->die_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->die_qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->binding_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->binding_qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->number_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->number_qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->de_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_de_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->de_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_de_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->de_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty_de_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->job_type->AdvancedSearch->unsetSession();
        $this->job_category->AdvancedSearch->unsetSession();
        $this->company_id->AdvancedSearch->unsetSession();
        $this->description->AdvancedSearch->unsetSession();
        $this->size->AdvancedSearch->unsetSession();
        $this->quantity->AdvancedSearch->unsetSession();
        $this->pages->AdvancedSearch->unsetSession();
        $this->paper->AdvancedSearch->unsetSession();
        $this->remarks->AdvancedSearch->unsetSession();
        $this->pr_01->AdvancedSearch->unsetSession();
        $this->qty_pr_01->AdvancedSearch->unsetSession();
        $this->pl_01->AdvancedSearch->unsetSession();
        $this->qty_pl_01->AdvancedSearch->unsetSession();
        $this->pr_02->AdvancedSearch->unsetSession();
        $this->qty_pr_02->AdvancedSearch->unsetSession();
        $this->pl_02->AdvancedSearch->unsetSession();
        $this->qty_pl_02->AdvancedSearch->unsetSession();
        $this->pr_03->AdvancedSearch->unsetSession();
        $this->qty_pr_03->AdvancedSearch->unsetSession();
        $this->pl_03->AdvancedSearch->unsetSession();
        $this->qty_pl_03->AdvancedSearch->unsetSession();
        $this->pr_04->AdvancedSearch->unsetSession();
        $this->qty_pr_04->AdvancedSearch->unsetSession();
        $this->pl_04->AdvancedSearch->unsetSession();
        $this->qty_pl_04->AdvancedSearch->unsetSession();
        $this->pa_01->AdvancedSearch->unsetSession();
        $this->qty_pa_01->AdvancedSearch->unsetSession();
        $this->pa_02->AdvancedSearch->unsetSession();
        $this->qty_pa_02->AdvancedSearch->unsetSession();
        $this->pa_03->AdvancedSearch->unsetSession();
        $this->qty_pa_03->AdvancedSearch->unsetSession();
        $this->pa_04->AdvancedSearch->unsetSession();
        $this->qty_pa_04->AdvancedSearch->unsetSession();
        $this->pa_05->AdvancedSearch->unsetSession();
        $this->qty_pa_05->AdvancedSearch->unsetSession();
        $this->pc_01->AdvancedSearch->unsetSession();
        $this->qty_pc_01->AdvancedSearch->unsetSession();
        $this->pc_02->AdvancedSearch->unsetSession();
        $this->qty_pc_02->AdvancedSearch->unsetSession();
        $this->o_01->AdvancedSearch->unsetSession();
        $this->qty_o_01->AdvancedSearch->unsetSession();
        $this->lamination_type->AdvancedSearch->unsetSession();
        $this->lamination_qty->AdvancedSearch->unsetSession();
        $this->die_type->AdvancedSearch->unsetSession();
        $this->die_qty->AdvancedSearch->unsetSession();
        $this->binding_type->AdvancedSearch->unsetSession();
        $this->binding_qty->AdvancedSearch->unsetSession();
        $this->number_type->AdvancedSearch->unsetSession();
        $this->number_qty->AdvancedSearch->unsetSession();
        $this->de_01->AdvancedSearch->unsetSession();
        $this->qty_de_01->AdvancedSearch->unsetSession();
        $this->de_02->AdvancedSearch->unsetSession();
        $this->qty_de_02->AdvancedSearch->unsetSession();
        $this->de_03->AdvancedSearch->unsetSession();
        $this->qty_de_03->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->job_type->AdvancedSearch->load();
        $this->job_category->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->size->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->pages->AdvancedSearch->load();
        $this->paper->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->pr_01->AdvancedSearch->load();
        $this->qty_pr_01->AdvancedSearch->load();
        $this->pl_01->AdvancedSearch->load();
        $this->qty_pl_01->AdvancedSearch->load();
        $this->pr_02->AdvancedSearch->load();
        $this->qty_pr_02->AdvancedSearch->load();
        $this->pl_02->AdvancedSearch->load();
        $this->qty_pl_02->AdvancedSearch->load();
        $this->pr_03->AdvancedSearch->load();
        $this->qty_pr_03->AdvancedSearch->load();
        $this->pl_03->AdvancedSearch->load();
        $this->qty_pl_03->AdvancedSearch->load();
        $this->pr_04->AdvancedSearch->load();
        $this->qty_pr_04->AdvancedSearch->load();
        $this->pl_04->AdvancedSearch->load();
        $this->qty_pl_04->AdvancedSearch->load();
        $this->pa_01->AdvancedSearch->load();
        $this->qty_pa_01->AdvancedSearch->load();
        $this->pa_02->AdvancedSearch->load();
        $this->qty_pa_02->AdvancedSearch->load();
        $this->pa_03->AdvancedSearch->load();
        $this->qty_pa_03->AdvancedSearch->load();
        $this->pa_04->AdvancedSearch->load();
        $this->qty_pa_04->AdvancedSearch->load();
        $this->pa_05->AdvancedSearch->load();
        $this->qty_pa_05->AdvancedSearch->load();
        $this->pc_01->AdvancedSearch->load();
        $this->qty_pc_01->AdvancedSearch->load();
        $this->pc_02->AdvancedSearch->load();
        $this->qty_pc_02->AdvancedSearch->load();
        $this->o_01->AdvancedSearch->load();
        $this->qty_o_01->AdvancedSearch->load();
        $this->lamination_type->AdvancedSearch->load();
        $this->lamination_qty->AdvancedSearch->load();
        $this->die_type->AdvancedSearch->load();
        $this->die_qty->AdvancedSearch->load();
        $this->binding_type->AdvancedSearch->load();
        $this->binding_qty->AdvancedSearch->load();
        $this->number_type->AdvancedSearch->load();
        $this->number_qty->AdvancedSearch->load();
        $this->de_01->AdvancedSearch->load();
        $this->qty_de_01->AdvancedSearch->load();
        $this->de_02->AdvancedSearch->load();
        $this->qty_de_02->AdvancedSearch->load();
        $this->de_03->AdvancedSearch->load();
        $this->qty_de_03->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->job_type, $ctrl); // job_type
            $this->updateSort($this->job_category, $ctrl); // job_category
            $this->updateSort($this->company_id, $ctrl); // company_id
            $this->updateSort($this->description, $ctrl); // description
            $this->updateSort($this->size, $ctrl); // size
            $this->updateSort($this->quantity, $ctrl); // quantity
            $this->updateSort($this->pages, $ctrl); // pages
            $this->updateSort($this->paper, $ctrl); // paper
            $this->updateSort($this->remarks, $ctrl); // remarks
            $this->updateSort($this->pr_01, $ctrl); // pr_01
            $this->updateSort($this->qty_pr_01, $ctrl); // qty_pr_01
            $this->updateSort($this->pl_01, $ctrl); // pl_01
            $this->updateSort($this->qty_pl_01, $ctrl); // qty_pl_01
            $this->updateSort($this->pr_02, $ctrl); // pr_02
            $this->updateSort($this->qty_pr_02, $ctrl); // qty_pr_02
            $this->updateSort($this->pl_02, $ctrl); // pl_02
            $this->updateSort($this->qty_pl_02, $ctrl); // qty_pl_02
            $this->updateSort($this->pr_03, $ctrl); // pr_03
            $this->updateSort($this->qty_pr_03, $ctrl); // qty_pr_03
            $this->updateSort($this->pl_03, $ctrl); // pl_03
            $this->updateSort($this->qty_pl_03, $ctrl); // qty_pl_03
            $this->updateSort($this->pr_04, $ctrl); // pr_04
            $this->updateSort($this->qty_pr_04, $ctrl); // qty_pr_04
            $this->updateSort($this->pl_04, $ctrl); // pl_04
            $this->updateSort($this->qty_pl_04, $ctrl); // qty_pl_04
            $this->updateSort($this->pa_01, $ctrl); // pa_01
            $this->updateSort($this->qty_pa_01, $ctrl); // qty_pa_01
            $this->updateSort($this->pa_02, $ctrl); // pa_02
            $this->updateSort($this->qty_pa_02, $ctrl); // qty_pa_02
            $this->updateSort($this->pa_03, $ctrl); // pa_03
            $this->updateSort($this->qty_pa_03, $ctrl); // qty_pa_03
            $this->updateSort($this->pa_04, $ctrl); // pa_04
            $this->updateSort($this->qty_pa_04, $ctrl); // qty_pa_04
            $this->updateSort($this->pa_05, $ctrl); // pa_05
            $this->updateSort($this->qty_pa_05, $ctrl); // qty_pa_05
            $this->updateSort($this->pc_01, $ctrl); // pc_01
            $this->updateSort($this->qty_pc_01, $ctrl); // qty_pc_01
            $this->updateSort($this->pc_02, $ctrl); // pc_02
            $this->updateSort($this->qty_pc_02, $ctrl); // qty_pc_02
            $this->updateSort($this->o_01, $ctrl); // o_01
            $this->updateSort($this->qty_o_01, $ctrl); // qty_o_01
            $this->updateSort($this->lamination_type, $ctrl); // lamination_type
            $this->updateSort($this->lamination_qty, $ctrl); // lamination_qty
            $this->updateSort($this->die_type, $ctrl); // die_type
            $this->updateSort($this->die_qty, $ctrl); // die_qty
            $this->updateSort($this->binding_type, $ctrl); // binding_type
            $this->updateSort($this->binding_qty, $ctrl); // binding_qty
            $this->updateSort($this->number_type, $ctrl); // number_type
            $this->updateSort($this->number_qty, $ctrl); // number_qty
            $this->updateSort($this->de_01, $ctrl); // de_01
            $this->updateSort($this->qty_de_01, $ctrl); // qty_de_01
            $this->updateSort($this->de_02, $ctrl); // de_02
            $this->updateSort($this->qty_de_02, $ctrl); // qty_de_02
            $this->updateSort($this->de_03, $ctrl); // de_03
            $this->updateSort($this->qty_de_03, $ctrl); // qty_de_03
            $this->updateSort($this->operator, $ctrl); // operator
            $this->updateSort($this->datetime, $ctrl); // datetime
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->job_type->setSort("");
                $this->job_category->setSort("");
                $this->company_id->setSort("");
                $this->description->setSort("");
                $this->size->setSort("");
                $this->quantity->setSort("");
                $this->pages->setSort("");
                $this->paper->setSort("");
                $this->remarks->setSort("");
                $this->pr_01->setSort("");
                $this->qty_pr_01->setSort("");
                $this->pl_01->setSort("");
                $this->qty_pl_01->setSort("");
                $this->pr_02->setSort("");
                $this->qty_pr_02->setSort("");
                $this->pl_02->setSort("");
                $this->qty_pl_02->setSort("");
                $this->pr_03->setSort("");
                $this->qty_pr_03->setSort("");
                $this->pl_03->setSort("");
                $this->qty_pl_03->setSort("");
                $this->pr_04->setSort("");
                $this->qty_pr_04->setSort("");
                $this->pl_04->setSort("");
                $this->qty_pl_04->setSort("");
                $this->pa_01->setSort("");
                $this->qty_pa_01->setSort("");
                $this->pa_02->setSort("");
                $this->qty_pa_02->setSort("");
                $this->pa_03->setSort("");
                $this->qty_pa_03->setSort("");
                $this->pa_04->setSort("");
                $this->qty_pa_04->setSort("");
                $this->pa_05->setSort("");
                $this->qty_pa_05->setSort("");
                $this->pc_01->setSort("");
                $this->qty_pc_01->setSort("");
                $this->pc_02->setSort("");
                $this->qty_pc_02->setSort("");
                $this->o_01->setSort("");
                $this->qty_o_01->setSort("");
                $this->lamination_type->setSort("");
                $this->lamination_qty->setSort("");
                $this->die_type->setSort("");
                $this->die_qty->setSort("");
                $this->binding_type->setSort("");
                $this->binding_qty->setSort("");
                $this->number_type->setSort("");
                $this->number_qty->setSort("");
                $this->de_01->setSort("");
                $this->qty_de_01->setSort("");
                $this->de_02->setSort("");
                $this->qty_de_02->setSort("");
                $this->de_03->setSort("");
                $this->qty_de_03->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"p_eastimate\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"p_eastimate\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fp_eastimatelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fp_eastimatelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"p_eastimate\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "job_type");
            $this->createColumnOption($option, "job_category");
            $this->createColumnOption($option, "company_id");
            $this->createColumnOption($option, "description");
            $this->createColumnOption($option, "size");
            $this->createColumnOption($option, "quantity");
            $this->createColumnOption($option, "pages");
            $this->createColumnOption($option, "paper");
            $this->createColumnOption($option, "remarks");
            $this->createColumnOption($option, "pr_01");
            $this->createColumnOption($option, "qty_pr_01");
            $this->createColumnOption($option, "pl_01");
            $this->createColumnOption($option, "qty_pl_01");
            $this->createColumnOption($option, "pr_02");
            $this->createColumnOption($option, "qty_pr_02");
            $this->createColumnOption($option, "pl_02");
            $this->createColumnOption($option, "qty_pl_02");
            $this->createColumnOption($option, "pr_03");
            $this->createColumnOption($option, "qty_pr_03");
            $this->createColumnOption($option, "pl_03");
            $this->createColumnOption($option, "qty_pl_03");
            $this->createColumnOption($option, "pr_04");
            $this->createColumnOption($option, "qty_pr_04");
            $this->createColumnOption($option, "pl_04");
            $this->createColumnOption($option, "qty_pl_04");
            $this->createColumnOption($option, "pa_01");
            $this->createColumnOption($option, "qty_pa_01");
            $this->createColumnOption($option, "pa_02");
            $this->createColumnOption($option, "qty_pa_02");
            $this->createColumnOption($option, "pa_03");
            $this->createColumnOption($option, "qty_pa_03");
            $this->createColumnOption($option, "pa_04");
            $this->createColumnOption($option, "qty_pa_04");
            $this->createColumnOption($option, "pa_05");
            $this->createColumnOption($option, "qty_pa_05");
            $this->createColumnOption($option, "pc_01");
            $this->createColumnOption($option, "qty_pc_01");
            $this->createColumnOption($option, "pc_02");
            $this->createColumnOption($option, "qty_pc_02");
            $this->createColumnOption($option, "o_01");
            $this->createColumnOption($option, "qty_o_01");
            $this->createColumnOption($option, "lamination_type");
            $this->createColumnOption($option, "lamination_qty");
            $this->createColumnOption($option, "die_type");
            $this->createColumnOption($option, "die_qty");
            $this->createColumnOption($option, "binding_type");
            $this->createColumnOption($option, "binding_qty");
            $this->createColumnOption($option, "number_type");
            $this->createColumnOption($option, "number_qty");
            $this->createColumnOption($option, "de_01");
            $this->createColumnOption($option, "qty_de_01");
            $this->createColumnOption($option, "de_02");
            $this->createColumnOption($option, "qty_de_02");
            $this->createColumnOption($option, "de_03");
            $this->createColumnOption($option, "qty_de_03");
            $this->createColumnOption($option, "operator");
            $this->createColumnOption($option, "datetime");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fp_eastimatesrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fp_eastimatesrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fp_eastimatelist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_p_eastimate", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_p_eastimate",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // job_type
        if ($this->job_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->job_type->AdvancedSearch->SearchValue != "" || $this->job_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // job_category
        if ($this->job_category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->job_category->AdvancedSearch->SearchValue != "" || $this->job_category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->company_id->AdvancedSearch->SearchValue != "" || $this->company_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description
        if ($this->description->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description->AdvancedSearch->SearchValue != "" || $this->description->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // size
        if ($this->size->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->size->AdvancedSearch->SearchValue != "" || $this->size->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->quantity->AdvancedSearch->SearchValue != "" || $this->quantity->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pages
        if ($this->pages->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pages->AdvancedSearch->SearchValue != "" || $this->pages->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // paper
        if ($this->paper->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->paper->AdvancedSearch->SearchValue != "" || $this->paper->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->remarks->AdvancedSearch->SearchValue != "" || $this->remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pr_01
        if ($this->pr_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pr_01->AdvancedSearch->SearchValue != "" || $this->pr_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pr_01
        if ($this->qty_pr_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pr_01->AdvancedSearch->SearchValue != "" || $this->qty_pr_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_01
        if ($this->pl_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_01->AdvancedSearch->SearchValue != "" || $this->pl_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pl_01
        if ($this->qty_pl_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pl_01->AdvancedSearch->SearchValue != "" || $this->qty_pl_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pr_02
        if ($this->pr_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pr_02->AdvancedSearch->SearchValue != "" || $this->pr_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pr_02
        if ($this->qty_pr_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pr_02->AdvancedSearch->SearchValue != "" || $this->qty_pr_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_02
        if ($this->pl_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_02->AdvancedSearch->SearchValue != "" || $this->pl_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pl_02
        if ($this->qty_pl_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pl_02->AdvancedSearch->SearchValue != "" || $this->qty_pl_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pr_03
        if ($this->pr_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pr_03->AdvancedSearch->SearchValue != "" || $this->pr_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pr_03
        if ($this->qty_pr_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pr_03->AdvancedSearch->SearchValue != "" || $this->qty_pr_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_03
        if ($this->pl_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_03->AdvancedSearch->SearchValue != "" || $this->pl_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pl_03
        if ($this->qty_pl_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pl_03->AdvancedSearch->SearchValue != "" || $this->qty_pl_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pr_04
        if ($this->pr_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pr_04->AdvancedSearch->SearchValue != "" || $this->pr_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pr_04
        if ($this->qty_pr_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pr_04->AdvancedSearch->SearchValue != "" || $this->qty_pr_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_04
        if ($this->pl_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_04->AdvancedSearch->SearchValue != "" || $this->pl_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pl_04
        if ($this->qty_pl_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pl_04->AdvancedSearch->SearchValue != "" || $this->qty_pl_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_01
        if ($this->pa_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_01->AdvancedSearch->SearchValue != "" || $this->pa_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pa_01
        if ($this->qty_pa_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pa_01->AdvancedSearch->SearchValue != "" || $this->qty_pa_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_02
        if ($this->pa_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_02->AdvancedSearch->SearchValue != "" || $this->pa_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pa_02
        if ($this->qty_pa_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pa_02->AdvancedSearch->SearchValue != "" || $this->qty_pa_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_03
        if ($this->pa_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_03->AdvancedSearch->SearchValue != "" || $this->pa_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pa_03
        if ($this->qty_pa_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pa_03->AdvancedSearch->SearchValue != "" || $this->qty_pa_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_04
        if ($this->pa_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_04->AdvancedSearch->SearchValue != "" || $this->pa_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pa_04
        if ($this->qty_pa_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pa_04->AdvancedSearch->SearchValue != "" || $this->qty_pa_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pa_05
        if ($this->pa_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pa_05->AdvancedSearch->SearchValue != "" || $this->pa_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pa_05
        if ($this->qty_pa_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pa_05->AdvancedSearch->SearchValue != "" || $this->qty_pa_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_01
        if ($this->pc_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_01->AdvancedSearch->SearchValue != "" || $this->pc_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pc_01
        if ($this->qty_pc_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pc_01->AdvancedSearch->SearchValue != "" || $this->qty_pc_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pc_02
        if ($this->pc_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pc_02->AdvancedSearch->SearchValue != "" || $this->pc_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_pc_02
        if ($this->qty_pc_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_pc_02->AdvancedSearch->SearchValue != "" || $this->qty_pc_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // o_01
        if ($this->o_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->o_01->AdvancedSearch->SearchValue != "" || $this->o_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_o_01
        if ($this->qty_o_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_o_01->AdvancedSearch->SearchValue != "" || $this->qty_o_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // lamination_type
        if ($this->lamination_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->lamination_type->AdvancedSearch->SearchValue != "" || $this->lamination_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // lamination_qty
        if ($this->lamination_qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->lamination_qty->AdvancedSearch->SearchValue != "" || $this->lamination_qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // die_type
        if ($this->die_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->die_type->AdvancedSearch->SearchValue != "" || $this->die_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // die_qty
        if ($this->die_qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->die_qty->AdvancedSearch->SearchValue != "" || $this->die_qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // binding_type
        if ($this->binding_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->binding_type->AdvancedSearch->SearchValue != "" || $this->binding_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // binding_qty
        if ($this->binding_qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->binding_qty->AdvancedSearch->SearchValue != "" || $this->binding_qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // number_type
        if ($this->number_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->number_type->AdvancedSearch->SearchValue != "" || $this->number_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // number_qty
        if ($this->number_qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->number_qty->AdvancedSearch->SearchValue != "" || $this->number_qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // de_01
        if ($this->de_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->de_01->AdvancedSearch->SearchValue != "" || $this->de_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_de_01
        if ($this->qty_de_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_de_01->AdvancedSearch->SearchValue != "" || $this->qty_de_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // de_02
        if ($this->de_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->de_02->AdvancedSearch->SearchValue != "" || $this->de_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_de_02
        if ($this->qty_de_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_de_02->AdvancedSearch->SearchValue != "" || $this->qty_de_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // de_03
        if ($this->de_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->de_03->AdvancedSearch->SearchValue != "" || $this->de_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty_de_03
        if ($this->qty_de_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty_de_03->AdvancedSearch->SearchValue != "" || $this->qty_de_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->job_type->setDbValue($row['job_type']);
        $this->job_category->setDbValue($row['job_category']);
        $this->company_id->setDbValue($row['company_id']);
        $this->description->setDbValue($row['description']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->pages->setDbValue($row['pages']);
        $this->paper->setDbValue($row['paper']);
        $this->remarks->setDbValue($row['remarks']);
        $this->pr_01->setDbValue($row['pr_01']);
        $this->qty_pr_01->setDbValue($row['qty_pr_01']);
        $this->pl_01->setDbValue($row['pl_01']);
        $this->qty_pl_01->setDbValue($row['qty_pl_01']);
        $this->pr_02->setDbValue($row['pr_02']);
        $this->qty_pr_02->setDbValue($row['qty_pr_02']);
        $this->pl_02->setDbValue($row['pl_02']);
        $this->qty_pl_02->setDbValue($row['qty_pl_02']);
        $this->pr_03->setDbValue($row['pr_03']);
        $this->qty_pr_03->setDbValue($row['qty_pr_03']);
        $this->pl_03->setDbValue($row['pl_03']);
        $this->qty_pl_03->setDbValue($row['qty_pl_03']);
        $this->pr_04->setDbValue($row['pr_04']);
        $this->qty_pr_04->setDbValue($row['qty_pr_04']);
        $this->pl_04->setDbValue($row['pl_04']);
        $this->qty_pl_04->setDbValue($row['qty_pl_04']);
        $this->pa_01->setDbValue($row['pa_01']);
        $this->qty_pa_01->setDbValue($row['qty_pa_01']);
        $this->pa_02->setDbValue($row['pa_02']);
        $this->qty_pa_02->setDbValue($row['qty_pa_02']);
        $this->pa_03->setDbValue($row['pa_03']);
        $this->qty_pa_03->setDbValue($row['qty_pa_03']);
        $this->pa_04->setDbValue($row['pa_04']);
        $this->qty_pa_04->setDbValue($row['qty_pa_04']);
        $this->pa_05->setDbValue($row['pa_05']);
        $this->qty_pa_05->setDbValue($row['qty_pa_05']);
        $this->pc_01->setDbValue($row['pc_01']);
        $this->qty_pc_01->setDbValue($row['qty_pc_01']);
        $this->pc_02->setDbValue($row['pc_02']);
        $this->qty_pc_02->setDbValue($row['qty_pc_02']);
        $this->o_01->setDbValue($row['o_01']);
        $this->qty_o_01->setDbValue($row['qty_o_01']);
        $this->lamination_type->setDbValue($row['lamination_type']);
        $this->lamination_qty->setDbValue($row['lamination_qty']);
        $this->die_type->setDbValue($row['die_type']);
        $this->die_qty->setDbValue($row['die_qty']);
        $this->binding_type->setDbValue($row['binding_type']);
        $this->binding_qty->setDbValue($row['binding_qty']);
        $this->number_type->setDbValue($row['number_type']);
        $this->number_qty->setDbValue($row['number_qty']);
        $this->de_01->setDbValue($row['de_01']);
        $this->qty_de_01->setDbValue($row['qty_de_01']);
        $this->de_02->setDbValue($row['de_02']);
        $this->qty_de_02->setDbValue($row['qty_de_02']);
        $this->de_03->setDbValue($row['de_03']);
        $this->qty_de_03->setDbValue($row['qty_de_03']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['job_type'] = $this->job_type->DefaultValue;
        $row['job_category'] = $this->job_category->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['pages'] = $this->pages->DefaultValue;
        $row['paper'] = $this->paper->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['pr_01'] = $this->pr_01->DefaultValue;
        $row['qty_pr_01'] = $this->qty_pr_01->DefaultValue;
        $row['pl_01'] = $this->pl_01->DefaultValue;
        $row['qty_pl_01'] = $this->qty_pl_01->DefaultValue;
        $row['pr_02'] = $this->pr_02->DefaultValue;
        $row['qty_pr_02'] = $this->qty_pr_02->DefaultValue;
        $row['pl_02'] = $this->pl_02->DefaultValue;
        $row['qty_pl_02'] = $this->qty_pl_02->DefaultValue;
        $row['pr_03'] = $this->pr_03->DefaultValue;
        $row['qty_pr_03'] = $this->qty_pr_03->DefaultValue;
        $row['pl_03'] = $this->pl_03->DefaultValue;
        $row['qty_pl_03'] = $this->qty_pl_03->DefaultValue;
        $row['pr_04'] = $this->pr_04->DefaultValue;
        $row['qty_pr_04'] = $this->qty_pr_04->DefaultValue;
        $row['pl_04'] = $this->pl_04->DefaultValue;
        $row['qty_pl_04'] = $this->qty_pl_04->DefaultValue;
        $row['pa_01'] = $this->pa_01->DefaultValue;
        $row['qty_pa_01'] = $this->qty_pa_01->DefaultValue;
        $row['pa_02'] = $this->pa_02->DefaultValue;
        $row['qty_pa_02'] = $this->qty_pa_02->DefaultValue;
        $row['pa_03'] = $this->pa_03->DefaultValue;
        $row['qty_pa_03'] = $this->qty_pa_03->DefaultValue;
        $row['pa_04'] = $this->pa_04->DefaultValue;
        $row['qty_pa_04'] = $this->qty_pa_04->DefaultValue;
        $row['pa_05'] = $this->pa_05->DefaultValue;
        $row['qty_pa_05'] = $this->qty_pa_05->DefaultValue;
        $row['pc_01'] = $this->pc_01->DefaultValue;
        $row['qty_pc_01'] = $this->qty_pc_01->DefaultValue;
        $row['pc_02'] = $this->pc_02->DefaultValue;
        $row['qty_pc_02'] = $this->qty_pc_02->DefaultValue;
        $row['o_01'] = $this->o_01->DefaultValue;
        $row['qty_o_01'] = $this->qty_o_01->DefaultValue;
        $row['lamination_type'] = $this->lamination_type->DefaultValue;
        $row['lamination_qty'] = $this->lamination_qty->DefaultValue;
        $row['die_type'] = $this->die_type->DefaultValue;
        $row['die_qty'] = $this->die_qty->DefaultValue;
        $row['binding_type'] = $this->binding_type->DefaultValue;
        $row['binding_qty'] = $this->binding_qty->DefaultValue;
        $row['number_type'] = $this->number_type->DefaultValue;
        $row['number_qty'] = $this->number_qty->DefaultValue;
        $row['de_01'] = $this->de_01->DefaultValue;
        $row['qty_de_01'] = $this->qty_de_01->DefaultValue;
        $row['de_02'] = $this->de_02->DefaultValue;
        $row['qty_de_02'] = $this->qty_de_02->DefaultValue;
        $row['de_03'] = $this->de_03->DefaultValue;
        $row['qty_de_03'] = $this->qty_de_03->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // job_type

        // job_category

        // company_id

        // description

        // size

        // quantity

        // pages

        // paper

        // remarks

        // pr_01

        // qty_pr_01

        // pl_01

        // qty_pl_01

        // pr_02

        // qty_pr_02

        // pl_02

        // qty_pl_02

        // pr_03

        // qty_pr_03

        // pl_03

        // qty_pl_03

        // pr_04

        // qty_pr_04

        // pl_04

        // qty_pl_04

        // pa_01

        // qty_pa_01

        // pa_02

        // qty_pa_02

        // pa_03

        // qty_pa_03

        // pa_04

        // qty_pa_04

        // pa_05

        // qty_pa_05

        // pc_01

        // qty_pc_01

        // pc_02

        // qty_pc_02

        // o_01

        // qty_o_01

        // lamination_type

        // lamination_qty

        // die_type

        // die_qty

        // binding_type

        // binding_qty

        // number_type

        // number_qty

        // de_01

        // qty_de_01

        // de_02

        // qty_de_02

        // de_03

        // qty_de_03

        // operator

        // datetime

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // job_type
            if (strval($this->job_type->CurrentValue) != "") {
                $this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
            } else {
                $this->job_type->ViewValue = null;
            }

            // job_category
            if (strval($this->job_category->CurrentValue) != "") {
                $this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
            } else {
                $this->job_category->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // size
            $curVal = strval($this->size->CurrentValue);
            if ($curVal != "") {
                $this->size->ViewValue = $this->size->lookupCacheOption($curVal);
                if ($this->size->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->size->Lookup->getTable()->Fields["description"]->searchExpression(), "=", $curVal, $this->size->Lookup->getTable()->Fields["description"]->searchDataType(), "");
                    $lookupFilter = $this->size->getSelectFilter($this); // PHP
                    $sqlWrk = $this->size->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->size->Lookup->renderViewRow($rswrk[0]);
                        $this->size->ViewValue = $this->size->displayValue($arwrk);
                    } else {
                        $this->size->ViewValue = $this->size->CurrentValue;
                    }
                }
            } else {
                $this->size->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // pages
            $this->pages->ViewValue = $this->pages->CurrentValue;

            // paper
            $this->paper->ViewValue = $this->paper->CurrentValue;
            $this->paper->ViewValue = FormatNumber($this->paper->ViewValue, $this->paper->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pr_01
            $curVal = strval($this->pr_01->CurrentValue);
            if ($curVal != "") {
                $this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
                if ($this->pr_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
                    } else {
                        $this->pr_01->ViewValue = $this->pr_01->CurrentValue;
                    }
                }
            } else {
                $this->pr_01->ViewValue = null;
            }

            // qty_pr_01
            $this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
            $this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, $this->qty_pr_01->formatPattern());

            // pl_01
            $curVal = strval($this->pl_01->CurrentValue);
            if ($curVal != "") {
                $this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
                if ($this->pl_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
                    } else {
                        $this->pl_01->ViewValue = $this->pl_01->CurrentValue;
                    }
                }
            } else {
                $this->pl_01->ViewValue = null;
            }

            // qty_pl_01
            $this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
            $this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, $this->qty_pl_01->formatPattern());

            // pr_02
            $curVal = strval($this->pr_02->CurrentValue);
            if ($curVal != "") {
                $this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
                if ($this->pr_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
                    } else {
                        $this->pr_02->ViewValue = $this->pr_02->CurrentValue;
                    }
                }
            } else {
                $this->pr_02->ViewValue = null;
            }

            // qty_pr_02
            $this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
            $this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, $this->qty_pr_02->formatPattern());

            // pl_02
            $curVal = strval($this->pl_02->CurrentValue);
            if ($curVal != "") {
                $this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
                if ($this->pl_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
                    } else {
                        $this->pl_02->ViewValue = $this->pl_02->CurrentValue;
                    }
                }
            } else {
                $this->pl_02->ViewValue = null;
            }

            // qty_pl_02
            $this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
            $this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, $this->qty_pl_02->formatPattern());

            // pr_03
            $curVal = strval($this->pr_03->CurrentValue);
            if ($curVal != "") {
                $this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
                if ($this->pr_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
                    } else {
                        $this->pr_03->ViewValue = $this->pr_03->CurrentValue;
                    }
                }
            } else {
                $this->pr_03->ViewValue = null;
            }

            // qty_pr_03
            $this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
            $this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, $this->qty_pr_03->formatPattern());

            // pl_03
            $curVal = strval($this->pl_03->CurrentValue);
            if ($curVal != "") {
                $this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
                if ($this->pl_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
                    } else {
                        $this->pl_03->ViewValue = $this->pl_03->CurrentValue;
                    }
                }
            } else {
                $this->pl_03->ViewValue = null;
            }

            // qty_pl_03
            $this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
            $this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, $this->qty_pl_03->formatPattern());

            // pr_04
            $curVal = strval($this->pr_04->CurrentValue);
            if ($curVal != "") {
                $this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
                if ($this->pr_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
                    } else {
                        $this->pr_04->ViewValue = $this->pr_04->CurrentValue;
                    }
                }
            } else {
                $this->pr_04->ViewValue = null;
            }

            // qty_pr_04
            $this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
            $this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, $this->qty_pr_04->formatPattern());

            // pl_04
            $curVal = strval($this->pl_04->CurrentValue);
            if ($curVal != "") {
                $this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
                if ($this->pl_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
                    } else {
                        $this->pl_04->ViewValue = $this->pl_04->CurrentValue;
                    }
                }
            } else {
                $this->pl_04->ViewValue = null;
            }

            // qty_pl_04
            $this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
            $this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, $this->qty_pl_04->formatPattern());

            // pa_01
            $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
            $curVal = strval($this->pa_01->CurrentValue);
            if ($curVal != "") {
                $this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
                if ($this->pa_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
                    } else {
                        $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
                    }
                }
            } else {
                $this->pa_01->ViewValue = null;
            }

            // qty_pa_01
            $this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
            $this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, $this->qty_pa_01->formatPattern());

            // pa_02
            $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
            $curVal = strval($this->pa_02->CurrentValue);
            if ($curVal != "") {
                $this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
                if ($this->pa_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
                    } else {
                        $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
                    }
                }
            } else {
                $this->pa_02->ViewValue = null;
            }

            // qty_pa_02
            $this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
            $this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, $this->qty_pa_02->formatPattern());

            // pa_03
            $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
            $curVal = strval($this->pa_03->CurrentValue);
            if ($curVal != "") {
                $this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
                if ($this->pa_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
                    } else {
                        $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
                    }
                }
            } else {
                $this->pa_03->ViewValue = null;
            }

            // qty_pa_03
            $this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
            $this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, $this->qty_pa_03->formatPattern());

            // pa_04
            $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
            $curVal = strval($this->pa_04->CurrentValue);
            if ($curVal != "") {
                $this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
                if ($this->pa_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
                    } else {
                        $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
                    }
                }
            } else {
                $this->pa_04->ViewValue = null;
            }

            // qty_pa_04
            $this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
            $this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, $this->qty_pa_04->formatPattern());

            // pa_05
            $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
            $curVal = strval($this->pa_05->CurrentValue);
            if ($curVal != "") {
                $this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
                if ($this->pa_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_05->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
                    } else {
                        $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
                    }
                }
            } else {
                $this->pa_05->ViewValue = null;
            }

            // qty_pa_05
            $this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
            $this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, $this->qty_pa_05->formatPattern());

            // pc_01
            $curVal = strval($this->pc_01->CurrentValue);
            if ($curVal != "") {
                $this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
                if ($this->pc_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pc_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pc_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pc_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pc_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
                    } else {
                        $this->pc_01->ViewValue = $this->pc_01->CurrentValue;
                    }
                }
            } else {
                $this->pc_01->ViewValue = null;
            }

            // qty_pc_01
            $this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
            $this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, $this->qty_pc_01->formatPattern());

            // pc_02
            $curVal = strval($this->pc_02->CurrentValue);
            if ($curVal != "") {
                $this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
                if ($this->pc_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pc_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pc_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pc_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pc_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
                    } else {
                        $this->pc_02->ViewValue = $this->pc_02->CurrentValue;
                    }
                }
            } else {
                $this->pc_02->ViewValue = null;
            }

            // qty_pc_02
            $this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
            $this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, $this->qty_pc_02->formatPattern());

            // o_01
            $curVal = strval($this->o_01->CurrentValue);
            if ($curVal != "") {
                $this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
                if ($this->o_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->o_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->o_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->o_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->o_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->o_01->Lookup->renderViewRow($rswrk[0]);
                        $this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
                    } else {
                        $this->o_01->ViewValue = $this->o_01->CurrentValue;
                    }
                }
            } else {
                $this->o_01->ViewValue = null;
            }

            // qty_o_01
            $this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
            $this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, $this->qty_o_01->formatPattern());

            // lamination_type
            $curVal = strval($this->lamination_type->CurrentValue);
            if ($curVal != "") {
                $this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
                if ($this->lamination_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->lamination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->lamination_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->lamination_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->lamination_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->lamination_type->Lookup->renderViewRow($rswrk[0]);
                        $this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
                    } else {
                        $this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
                    }
                }
            } else {
                $this->lamination_type->ViewValue = null;
            }

            // lamination_qty
            $this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
            $this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, $this->lamination_qty->formatPattern());

            // die_type
            $curVal = strval($this->die_type->CurrentValue);
            if ($curVal != "") {
                $this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
                if ($this->die_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->die_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->die_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->die_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->die_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->die_type->Lookup->renderViewRow($rswrk[0]);
                        $this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
                    } else {
                        $this->die_type->ViewValue = $this->die_type->CurrentValue;
                    }
                }
            } else {
                $this->die_type->ViewValue = null;
            }

            // die_qty
            $this->die_qty->ViewValue = $this->die_qty->CurrentValue;
            $this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, $this->die_qty->formatPattern());

            // binding_type
            $curVal = strval($this->binding_type->CurrentValue);
            if ($curVal != "") {
                $this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
                if ($this->binding_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->binding_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->binding_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->binding_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->binding_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->binding_type->Lookup->renderViewRow($rswrk[0]);
                        $this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
                    } else {
                        $this->binding_type->ViewValue = $this->binding_type->CurrentValue;
                    }
                }
            } else {
                $this->binding_type->ViewValue = null;
            }

            // binding_qty
            $this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
            $this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, $this->binding_qty->formatPattern());

            // number_type
            $curVal = strval($this->number_type->CurrentValue);
            if ($curVal != "") {
                $this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
                if ($this->number_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->number_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->number_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->number_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->number_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->number_type->Lookup->renderViewRow($rswrk[0]);
                        $this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
                    } else {
                        $this->number_type->ViewValue = $this->number_type->CurrentValue;
                    }
                }
            } else {
                $this->number_type->ViewValue = null;
            }

            // number_qty
            $this->number_qty->ViewValue = $this->number_qty->CurrentValue;
            $this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, $this->number_qty->formatPattern());

            // de_01
            $curVal = strval($this->de_01->CurrentValue);
            if ($curVal != "") {
                $this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
                if ($this->de_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_01->Lookup->renderViewRow($rswrk[0]);
                        $this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
                    } else {
                        $this->de_01->ViewValue = $this->de_01->CurrentValue;
                    }
                }
            } else {
                $this->de_01->ViewValue = null;
            }

            // qty_de_01
            $this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
            $this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, $this->qty_de_01->formatPattern());

            // de_02
            $curVal = strval($this->de_02->CurrentValue);
            if ($curVal != "") {
                $this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
                if ($this->de_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_02->Lookup->renderViewRow($rswrk[0]);
                        $this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
                    } else {
                        $this->de_02->ViewValue = $this->de_02->CurrentValue;
                    }
                }
            } else {
                $this->de_02->ViewValue = null;
            }

            // qty_de_02
            $this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
            $this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, $this->qty_de_02->formatPattern());

            // de_03
            $curVal = strval($this->de_03->CurrentValue);
            if ($curVal != "") {
                $this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
                if ($this->de_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_03->Lookup->renderViewRow($rswrk[0]);
                        $this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
                    } else {
                        $this->de_03->ViewValue = $this->de_03->CurrentValue;
                    }
                }
            } else {
                $this->de_03->ViewValue = null;
            }

            // qty_de_03
            $this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
            $this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, $this->qty_de_03->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // job_type
            $this->job_type->HrefValue = "";
            $this->job_type->TooltipValue = "";

            // job_category
            $this->job_category->HrefValue = "";
            $this->job_category->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";
            if (!$this->isExport()) {
                $this->description->ViewValue = $this->highlightValue($this->description);
            }

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // pages
            $this->pages->HrefValue = "";
            $this->pages->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pages->ViewValue = $this->highlightValue($this->pages);
            }

            // paper
            $this->paper->HrefValue = "";
            $this->paper->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->remarks->ViewValue = $this->highlightValue($this->remarks);
            }

            // pr_01
            $this->pr_01->HrefValue = "";
            $this->pr_01->TooltipValue = "";

            // qty_pr_01
            $this->qty_pr_01->HrefValue = "";
            $this->qty_pr_01->TooltipValue = "";

            // pl_01
            $this->pl_01->HrefValue = "";
            $this->pl_01->TooltipValue = "";

            // qty_pl_01
            $this->qty_pl_01->HrefValue = "";
            $this->qty_pl_01->TooltipValue = "";

            // pr_02
            $this->pr_02->HrefValue = "";
            $this->pr_02->TooltipValue = "";

            // qty_pr_02
            $this->qty_pr_02->HrefValue = "";
            $this->qty_pr_02->TooltipValue = "";

            // pl_02
            $this->pl_02->HrefValue = "";
            $this->pl_02->TooltipValue = "";

            // qty_pl_02
            $this->qty_pl_02->HrefValue = "";
            $this->qty_pl_02->TooltipValue = "";

            // pr_03
            $this->pr_03->HrefValue = "";
            $this->pr_03->TooltipValue = "";

            // qty_pr_03
            $this->qty_pr_03->HrefValue = "";
            $this->qty_pr_03->TooltipValue = "";

            // pl_03
            $this->pl_03->HrefValue = "";
            $this->pl_03->TooltipValue = "";

            // qty_pl_03
            $this->qty_pl_03->HrefValue = "";
            $this->qty_pl_03->TooltipValue = "";

            // pr_04
            $this->pr_04->HrefValue = "";
            $this->pr_04->TooltipValue = "";

            // qty_pr_04
            $this->qty_pr_04->HrefValue = "";
            $this->qty_pr_04->TooltipValue = "";

            // pl_04
            $this->pl_04->HrefValue = "";
            $this->pl_04->TooltipValue = "";

            // qty_pl_04
            $this->qty_pl_04->HrefValue = "";
            $this->qty_pl_04->TooltipValue = "";

            // pa_01
            $this->pa_01->HrefValue = "";
            $this->pa_01->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_01->ViewValue = $this->highlightValue($this->pa_01);
            }

            // qty_pa_01
            $this->qty_pa_01->HrefValue = "";
            $this->qty_pa_01->TooltipValue = "";

            // pa_02
            $this->pa_02->HrefValue = "";
            $this->pa_02->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_02->ViewValue = $this->highlightValue($this->pa_02);
            }

            // qty_pa_02
            $this->qty_pa_02->HrefValue = "";
            $this->qty_pa_02->TooltipValue = "";

            // pa_03
            $this->pa_03->HrefValue = "";
            $this->pa_03->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_03->ViewValue = $this->highlightValue($this->pa_03);
            }

            // qty_pa_03
            $this->qty_pa_03->HrefValue = "";
            $this->qty_pa_03->TooltipValue = "";

            // pa_04
            $this->pa_04->HrefValue = "";
            $this->pa_04->TooltipValue = "";

            // qty_pa_04
            $this->qty_pa_04->HrefValue = "";
            $this->qty_pa_04->TooltipValue = "";

            // pa_05
            $this->pa_05->HrefValue = "";
            $this->pa_05->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pa_05->ViewValue = $this->highlightValue($this->pa_05);
            }

            // qty_pa_05
            $this->qty_pa_05->HrefValue = "";
            $this->qty_pa_05->TooltipValue = "";

            // pc_01
            $this->pc_01->HrefValue = "";
            $this->pc_01->TooltipValue = "";

            // qty_pc_01
            $this->qty_pc_01->HrefValue = "";
            $this->qty_pc_01->TooltipValue = "";

            // pc_02
            $this->pc_02->HrefValue = "";
            $this->pc_02->TooltipValue = "";

            // qty_pc_02
            $this->qty_pc_02->HrefValue = "";
            $this->qty_pc_02->TooltipValue = "";

            // o_01
            $this->o_01->HrefValue = "";
            $this->o_01->TooltipValue = "";

            // qty_o_01
            $this->qty_o_01->HrefValue = "";
            $this->qty_o_01->TooltipValue = "";

            // lamination_type
            $this->lamination_type->HrefValue = "";
            $this->lamination_type->TooltipValue = "";

            // lamination_qty
            $this->lamination_qty->HrefValue = "";
            $this->lamination_qty->TooltipValue = "";

            // die_type
            $this->die_type->HrefValue = "";
            $this->die_type->TooltipValue = "";

            // die_qty
            $this->die_qty->HrefValue = "";
            $this->die_qty->TooltipValue = "";

            // binding_type
            $this->binding_type->HrefValue = "";
            $this->binding_type->TooltipValue = "";

            // binding_qty
            $this->binding_qty->HrefValue = "";
            $this->binding_qty->TooltipValue = "";

            // number_type
            $this->number_type->HrefValue = "";
            $this->number_type->TooltipValue = "";

            // number_qty
            $this->number_qty->HrefValue = "";
            $this->number_qty->TooltipValue = "";

            // de_01
            $this->de_01->HrefValue = "";
            $this->de_01->TooltipValue = "";

            // qty_de_01
            $this->qty_de_01->HrefValue = "";
            $this->qty_de_01->TooltipValue = "";

            // de_02
            $this->de_02->HrefValue = "";
            $this->de_02->TooltipValue = "";

            // qty_de_02
            $this->qty_de_02->HrefValue = "";
            $this->qty_de_02->TooltipValue = "";

            // de_03
            $this->de_03->HrefValue = "";
            $this->de_03->TooltipValue = "";

            // qty_de_03
            $this->qty_de_03->HrefValue = "";
            $this->qty_de_03->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime->ViewValue = $this->highlightValue($this->datetime);
            }
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->job_type->AdvancedSearch->load();
        $this->job_category->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->size->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->pages->AdvancedSearch->load();
        $this->paper->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->pr_01->AdvancedSearch->load();
        $this->qty_pr_01->AdvancedSearch->load();
        $this->pl_01->AdvancedSearch->load();
        $this->qty_pl_01->AdvancedSearch->load();
        $this->pr_02->AdvancedSearch->load();
        $this->qty_pr_02->AdvancedSearch->load();
        $this->pl_02->AdvancedSearch->load();
        $this->qty_pl_02->AdvancedSearch->load();
        $this->pr_03->AdvancedSearch->load();
        $this->qty_pr_03->AdvancedSearch->load();
        $this->pl_03->AdvancedSearch->load();
        $this->qty_pl_03->AdvancedSearch->load();
        $this->pr_04->AdvancedSearch->load();
        $this->qty_pr_04->AdvancedSearch->load();
        $this->pl_04->AdvancedSearch->load();
        $this->qty_pl_04->AdvancedSearch->load();
        $this->pa_01->AdvancedSearch->load();
        $this->qty_pa_01->AdvancedSearch->load();
        $this->pa_02->AdvancedSearch->load();
        $this->qty_pa_02->AdvancedSearch->load();
        $this->pa_03->AdvancedSearch->load();
        $this->qty_pa_03->AdvancedSearch->load();
        $this->pa_04->AdvancedSearch->load();
        $this->qty_pa_04->AdvancedSearch->load();
        $this->pa_05->AdvancedSearch->load();
        $this->qty_pa_05->AdvancedSearch->load();
        $this->pc_01->AdvancedSearch->load();
        $this->qty_pc_01->AdvancedSearch->load();
        $this->pc_02->AdvancedSearch->load();
        $this->qty_pc_02->AdvancedSearch->load();
        $this->o_01->AdvancedSearch->load();
        $this->qty_o_01->AdvancedSearch->load();
        $this->lamination_type->AdvancedSearch->load();
        $this->lamination_qty->AdvancedSearch->load();
        $this->die_type->AdvancedSearch->load();
        $this->die_qty->AdvancedSearch->load();
        $this->binding_type->AdvancedSearch->load();
        $this->binding_qty->AdvancedSearch->load();
        $this->number_type->AdvancedSearch->load();
        $this->number_qty->AdvancedSearch->load();
        $this->de_01->AdvancedSearch->load();
        $this->qty_de_01->AdvancedSearch->load();
        $this->de_02->AdvancedSearch->load();
        $this->qty_de_02->AdvancedSearch->load();
        $this->de_03->AdvancedSearch->load();
        $this->qty_de_03->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fp_eastimatelist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fp_eastimatelist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fp_eastimatelist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fp_eastimatelist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"p_eastimate\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"peastimatesearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"peastimatesearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fp_eastimatesrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_job_type":
                    break;
                case "x_job_category":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_size":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pc_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pc_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_o_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lamination_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_die_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_binding_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_number_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
