<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PEastimateAdd extends PEastimate
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PEastimateAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "peastimateadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->job_type->setVisibility();
        $this->job_category->setVisibility();
        $this->company_id->setVisibility();
        $this->description->setVisibility();
        $this->size->setVisibility();
        $this->quantity->setVisibility();
        $this->pages->setVisibility();
        $this->paper->setVisibility();
        $this->remarks->setVisibility();
        $this->pr_01->setVisibility();
        $this->qty_pr_01->setVisibility();
        $this->pl_01->setVisibility();
        $this->qty_pl_01->setVisibility();
        $this->pr_02->setVisibility();
        $this->qty_pr_02->setVisibility();
        $this->pl_02->setVisibility();
        $this->qty_pl_02->setVisibility();
        $this->pr_03->setVisibility();
        $this->qty_pr_03->setVisibility();
        $this->pl_03->setVisibility();
        $this->qty_pl_03->setVisibility();
        $this->pr_04->setVisibility();
        $this->qty_pr_04->setVisibility();
        $this->pl_04->setVisibility();
        $this->qty_pl_04->setVisibility();
        $this->pa_01->setVisibility();
        $this->qty_pa_01->setVisibility();
        $this->pa_02->setVisibility();
        $this->qty_pa_02->setVisibility();
        $this->pa_03->setVisibility();
        $this->qty_pa_03->setVisibility();
        $this->pa_04->setVisibility();
        $this->qty_pa_04->setVisibility();
        $this->pa_05->setVisibility();
        $this->qty_pa_05->setVisibility();
        $this->pc_01->setVisibility();
        $this->qty_pc_01->setVisibility();
        $this->pc_02->setVisibility();
        $this->qty_pc_02->setVisibility();
        $this->o_01->setVisibility();
        $this->qty_o_01->setVisibility();
        $this->lamination_type->setVisibility();
        $this->lamination_qty->setVisibility();
        $this->die_type->setVisibility();
        $this->die_qty->setVisibility();
        $this->binding_type->setVisibility();
        $this->binding_qty->setVisibility();
        $this->number_type->setVisibility();
        $this->number_qty->setVisibility();
        $this->de_01->setVisibility();
        $this->qty_de_01->setVisibility();
        $this->de_02->setVisibility();
        $this->qty_de_02->setVisibility();
        $this->de_03->setVisibility();
        $this->qty_de_03->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'p_eastimate';
        $this->TableName = 'p_eastimate';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (p_eastimate)
        if (!isset($GLOBALS["p_eastimate"]) || $GLOBALS["p_eastimate"]::class == PROJECT_NAMESPACE . "p_eastimate") {
            $GLOBALS["p_eastimate"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_eastimate');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "peastimateview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->job_type);
        $this->setupLookupOptions($this->job_category);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->size);
        $this->setupLookupOptions($this->pr_01);
        $this->setupLookupOptions($this->pl_01);
        $this->setupLookupOptions($this->pr_02);
        $this->setupLookupOptions($this->pl_02);
        $this->setupLookupOptions($this->pr_03);
        $this->setupLookupOptions($this->pl_03);
        $this->setupLookupOptions($this->pr_04);
        $this->setupLookupOptions($this->pl_04);
        $this->setupLookupOptions($this->pa_01);
        $this->setupLookupOptions($this->pa_02);
        $this->setupLookupOptions($this->pa_03);
        $this->setupLookupOptions($this->pa_04);
        $this->setupLookupOptions($this->pa_05);
        $this->setupLookupOptions($this->pc_01);
        $this->setupLookupOptions($this->pc_02);
        $this->setupLookupOptions($this->o_01);
        $this->setupLookupOptions($this->lamination_type);
        $this->setupLookupOptions($this->die_type);
        $this->setupLookupOptions($this->binding_type);
        $this->setupLookupOptions($this->number_type);
        $this->setupLookupOptions($this->de_01);
        $this->setupLookupOptions($this->de_02);
        $this->setupLookupOptions($this->de_03);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("peastimatelist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = 'ppolist';

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "peastimatelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "peastimatelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->quantity->DefaultValue = $this->quantity->getDefault(); // PHP
        $this->quantity->OldValue = $this->quantity->DefaultValue;
        $this->pages->DefaultValue = $this->pages->getDefault(); // PHP
        $this->pages->OldValue = $this->pages->DefaultValue;
        $this->paper->DefaultValue = $this->paper->getDefault(); // PHP
        $this->paper->OldValue = $this->paper->DefaultValue;
        $this->qty_pr_01->DefaultValue = $this->qty_pr_01->getDefault(); // PHP
        $this->qty_pr_01->OldValue = $this->qty_pr_01->DefaultValue;
        $this->qty_pl_01->DefaultValue = $this->qty_pl_01->getDefault(); // PHP
        $this->qty_pl_01->OldValue = $this->qty_pl_01->DefaultValue;
        $this->qty_pr_02->DefaultValue = $this->qty_pr_02->getDefault(); // PHP
        $this->qty_pr_02->OldValue = $this->qty_pr_02->DefaultValue;
        $this->qty_pl_02->DefaultValue = $this->qty_pl_02->getDefault(); // PHP
        $this->qty_pl_02->OldValue = $this->qty_pl_02->DefaultValue;
        $this->qty_pr_03->DefaultValue = $this->qty_pr_03->getDefault(); // PHP
        $this->qty_pr_03->OldValue = $this->qty_pr_03->DefaultValue;
        $this->qty_pl_03->DefaultValue = $this->qty_pl_03->getDefault(); // PHP
        $this->qty_pl_03->OldValue = $this->qty_pl_03->DefaultValue;
        $this->qty_pr_04->DefaultValue = $this->qty_pr_04->getDefault(); // PHP
        $this->qty_pr_04->OldValue = $this->qty_pr_04->DefaultValue;
        $this->qty_pl_04->DefaultValue = $this->qty_pl_04->getDefault(); // PHP
        $this->qty_pl_04->OldValue = $this->qty_pl_04->DefaultValue;
        $this->qty_pa_01->DefaultValue = $this->qty_pa_01->getDefault(); // PHP
        $this->qty_pa_01->OldValue = $this->qty_pa_01->DefaultValue;
        $this->qty_pa_02->DefaultValue = $this->qty_pa_02->getDefault(); // PHP
        $this->qty_pa_02->OldValue = $this->qty_pa_02->DefaultValue;
        $this->qty_pa_03->DefaultValue = $this->qty_pa_03->getDefault(); // PHP
        $this->qty_pa_03->OldValue = $this->qty_pa_03->DefaultValue;
        $this->qty_pa_04->DefaultValue = $this->qty_pa_04->getDefault(); // PHP
        $this->qty_pa_04->OldValue = $this->qty_pa_04->DefaultValue;
        $this->qty_pa_05->DefaultValue = $this->qty_pa_05->getDefault(); // PHP
        $this->qty_pa_05->OldValue = $this->qty_pa_05->DefaultValue;
        $this->qty_pc_01->DefaultValue = $this->qty_pc_01->getDefault(); // PHP
        $this->qty_pc_01->OldValue = $this->qty_pc_01->DefaultValue;
        $this->qty_pc_02->DefaultValue = $this->qty_pc_02->getDefault(); // PHP
        $this->qty_pc_02->OldValue = $this->qty_pc_02->DefaultValue;
        $this->qty_o_01->DefaultValue = $this->qty_o_01->getDefault(); // PHP
        $this->qty_o_01->OldValue = $this->qty_o_01->DefaultValue;
        $this->lamination_qty->DefaultValue = $this->lamination_qty->getDefault(); // PHP
        $this->lamination_qty->OldValue = $this->lamination_qty->DefaultValue;
        $this->die_qty->DefaultValue = $this->die_qty->getDefault(); // PHP
        $this->die_qty->OldValue = $this->die_qty->DefaultValue;
        $this->binding_qty->DefaultValue = $this->binding_qty->getDefault(); // PHP
        $this->binding_qty->OldValue = $this->binding_qty->DefaultValue;
        $this->number_qty->DefaultValue = $this->number_qty->getDefault(); // PHP
        $this->number_qty->OldValue = $this->number_qty->DefaultValue;
        $this->qty_de_01->DefaultValue = $this->qty_de_01->getDefault(); // PHP
        $this->qty_de_01->OldValue = $this->qty_de_01->DefaultValue;
        $this->qty_de_02->DefaultValue = $this->qty_de_02->getDefault(); // PHP
        $this->qty_de_02->OldValue = $this->qty_de_02->DefaultValue;
        $this->qty_de_03->DefaultValue = $this->qty_de_03->getDefault(); // PHP
        $this->qty_de_03->OldValue = $this->qty_de_03->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'job_type' first before field var 'x_job_type'
        $val = $CurrentForm->hasValue("job_type") ? $CurrentForm->getValue("job_type") : $CurrentForm->getValue("x_job_type");
        if (!$this->job_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->job_type->Visible = false; // Disable update for API request
            } else {
                $this->job_type->setFormValue($val);
            }
        }

        // Check field name 'job_category' first before field var 'x_job_category'
        $val = $CurrentForm->hasValue("job_category") ? $CurrentForm->getValue("job_category") : $CurrentForm->getValue("x_job_category");
        if (!$this->job_category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->job_category->Visible = false; // Disable update for API request
            } else {
                $this->job_category->setFormValue($val);
            }
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'description' first before field var 'x_description'
        $val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
        if (!$this->description->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description->Visible = false; // Disable update for API request
            } else {
                $this->description->setFormValue($val);
            }
        }

        // Check field name 'size' first before field var 'x_size'
        $val = $CurrentForm->hasValue("size") ? $CurrentForm->getValue("size") : $CurrentForm->getValue("x_size");
        if (!$this->size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size->Visible = false; // Disable update for API request
            } else {
                $this->size->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pages' first before field var 'x_pages'
        $val = $CurrentForm->hasValue("pages") ? $CurrentForm->getValue("pages") : $CurrentForm->getValue("x_pages");
        if (!$this->pages->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pages->Visible = false; // Disable update for API request
            } else {
                $this->pages->setFormValue($val);
            }
        }

        // Check field name 'paper' first before field var 'x_paper'
        $val = $CurrentForm->hasValue("paper") ? $CurrentForm->getValue("paper") : $CurrentForm->getValue("x_paper");
        if (!$this->paper->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->paper->Visible = false; // Disable update for API request
            } else {
                $this->paper->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'pr_01' first before field var 'x_pr_01'
        $val = $CurrentForm->hasValue("pr_01") ? $CurrentForm->getValue("pr_01") : $CurrentForm->getValue("x_pr_01");
        if (!$this->pr_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pr_01->Visible = false; // Disable update for API request
            } else {
                $this->pr_01->setFormValue($val);
            }
        }

        // Check field name 'qty_pr_01' first before field var 'x_qty_pr_01'
        $val = $CurrentForm->hasValue("qty_pr_01") ? $CurrentForm->getValue("qty_pr_01") : $CurrentForm->getValue("x_qty_pr_01");
        if (!$this->qty_pr_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pr_01->Visible = false; // Disable update for API request
            } else {
                $this->qty_pr_01->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pl_01' first before field var 'x_pl_01'
        $val = $CurrentForm->hasValue("pl_01") ? $CurrentForm->getValue("pl_01") : $CurrentForm->getValue("x_pl_01");
        if (!$this->pl_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pl_01->Visible = false; // Disable update for API request
            } else {
                $this->pl_01->setFormValue($val);
            }
        }

        // Check field name 'qty_pl_01' first before field var 'x_qty_pl_01'
        $val = $CurrentForm->hasValue("qty_pl_01") ? $CurrentForm->getValue("qty_pl_01") : $CurrentForm->getValue("x_qty_pl_01");
        if (!$this->qty_pl_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pl_01->Visible = false; // Disable update for API request
            } else {
                $this->qty_pl_01->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pr_02' first before field var 'x_pr_02'
        $val = $CurrentForm->hasValue("pr_02") ? $CurrentForm->getValue("pr_02") : $CurrentForm->getValue("x_pr_02");
        if (!$this->pr_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pr_02->Visible = false; // Disable update for API request
            } else {
                $this->pr_02->setFormValue($val);
            }
        }

        // Check field name 'qty_pr_02' first before field var 'x_qty_pr_02'
        $val = $CurrentForm->hasValue("qty_pr_02") ? $CurrentForm->getValue("qty_pr_02") : $CurrentForm->getValue("x_qty_pr_02");
        if (!$this->qty_pr_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pr_02->Visible = false; // Disable update for API request
            } else {
                $this->qty_pr_02->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pl_02' first before field var 'x_pl_02'
        $val = $CurrentForm->hasValue("pl_02") ? $CurrentForm->getValue("pl_02") : $CurrentForm->getValue("x_pl_02");
        if (!$this->pl_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pl_02->Visible = false; // Disable update for API request
            } else {
                $this->pl_02->setFormValue($val);
            }
        }

        // Check field name 'qty_pl_02' first before field var 'x_qty_pl_02'
        $val = $CurrentForm->hasValue("qty_pl_02") ? $CurrentForm->getValue("qty_pl_02") : $CurrentForm->getValue("x_qty_pl_02");
        if (!$this->qty_pl_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pl_02->Visible = false; // Disable update for API request
            } else {
                $this->qty_pl_02->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pr_03' first before field var 'x_pr_03'
        $val = $CurrentForm->hasValue("pr_03") ? $CurrentForm->getValue("pr_03") : $CurrentForm->getValue("x_pr_03");
        if (!$this->pr_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pr_03->Visible = false; // Disable update for API request
            } else {
                $this->pr_03->setFormValue($val);
            }
        }

        // Check field name 'qty_pr_03' first before field var 'x_qty_pr_03'
        $val = $CurrentForm->hasValue("qty_pr_03") ? $CurrentForm->getValue("qty_pr_03") : $CurrentForm->getValue("x_qty_pr_03");
        if (!$this->qty_pr_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pr_03->Visible = false; // Disable update for API request
            } else {
                $this->qty_pr_03->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pl_03' first before field var 'x_pl_03'
        $val = $CurrentForm->hasValue("pl_03") ? $CurrentForm->getValue("pl_03") : $CurrentForm->getValue("x_pl_03");
        if (!$this->pl_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pl_03->Visible = false; // Disable update for API request
            } else {
                $this->pl_03->setFormValue($val);
            }
        }

        // Check field name 'qty_pl_03' first before field var 'x_qty_pl_03'
        $val = $CurrentForm->hasValue("qty_pl_03") ? $CurrentForm->getValue("qty_pl_03") : $CurrentForm->getValue("x_qty_pl_03");
        if (!$this->qty_pl_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pl_03->Visible = false; // Disable update for API request
            } else {
                $this->qty_pl_03->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pr_04' first before field var 'x_pr_04'
        $val = $CurrentForm->hasValue("pr_04") ? $CurrentForm->getValue("pr_04") : $CurrentForm->getValue("x_pr_04");
        if (!$this->pr_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pr_04->Visible = false; // Disable update for API request
            } else {
                $this->pr_04->setFormValue($val);
            }
        }

        // Check field name 'qty_pr_04' first before field var 'x_qty_pr_04'
        $val = $CurrentForm->hasValue("qty_pr_04") ? $CurrentForm->getValue("qty_pr_04") : $CurrentForm->getValue("x_qty_pr_04");
        if (!$this->qty_pr_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pr_04->Visible = false; // Disable update for API request
            } else {
                $this->qty_pr_04->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pl_04' first before field var 'x_pl_04'
        $val = $CurrentForm->hasValue("pl_04") ? $CurrentForm->getValue("pl_04") : $CurrentForm->getValue("x_pl_04");
        if (!$this->pl_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pl_04->Visible = false; // Disable update for API request
            } else {
                $this->pl_04->setFormValue($val);
            }
        }

        // Check field name 'qty_pl_04' first before field var 'x_qty_pl_04'
        $val = $CurrentForm->hasValue("qty_pl_04") ? $CurrentForm->getValue("qty_pl_04") : $CurrentForm->getValue("x_qty_pl_04");
        if (!$this->qty_pl_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pl_04->Visible = false; // Disable update for API request
            } else {
                $this->qty_pl_04->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pa_01' first before field var 'x_pa_01'
        $val = $CurrentForm->hasValue("pa_01") ? $CurrentForm->getValue("pa_01") : $CurrentForm->getValue("x_pa_01");
        if (!$this->pa_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_01->Visible = false; // Disable update for API request
            } else {
                $this->pa_01->setFormValue($val);
            }
        }

        // Check field name 'qty_pa_01' first before field var 'x_qty_pa_01'
        $val = $CurrentForm->hasValue("qty_pa_01") ? $CurrentForm->getValue("qty_pa_01") : $CurrentForm->getValue("x_qty_pa_01");
        if (!$this->qty_pa_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pa_01->Visible = false; // Disable update for API request
            } else {
                $this->qty_pa_01->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pa_02' first before field var 'x_pa_02'
        $val = $CurrentForm->hasValue("pa_02") ? $CurrentForm->getValue("pa_02") : $CurrentForm->getValue("x_pa_02");
        if (!$this->pa_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_02->Visible = false; // Disable update for API request
            } else {
                $this->pa_02->setFormValue($val);
            }
        }

        // Check field name 'qty_pa_02' first before field var 'x_qty_pa_02'
        $val = $CurrentForm->hasValue("qty_pa_02") ? $CurrentForm->getValue("qty_pa_02") : $CurrentForm->getValue("x_qty_pa_02");
        if (!$this->qty_pa_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pa_02->Visible = false; // Disable update for API request
            } else {
                $this->qty_pa_02->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pa_03' first before field var 'x_pa_03'
        $val = $CurrentForm->hasValue("pa_03") ? $CurrentForm->getValue("pa_03") : $CurrentForm->getValue("x_pa_03");
        if (!$this->pa_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_03->Visible = false; // Disable update for API request
            } else {
                $this->pa_03->setFormValue($val);
            }
        }

        // Check field name 'qty_pa_03' first before field var 'x_qty_pa_03'
        $val = $CurrentForm->hasValue("qty_pa_03") ? $CurrentForm->getValue("qty_pa_03") : $CurrentForm->getValue("x_qty_pa_03");
        if (!$this->qty_pa_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pa_03->Visible = false; // Disable update for API request
            } else {
                $this->qty_pa_03->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pa_04' first before field var 'x_pa_04'
        $val = $CurrentForm->hasValue("pa_04") ? $CurrentForm->getValue("pa_04") : $CurrentForm->getValue("x_pa_04");
        if (!$this->pa_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_04->Visible = false; // Disable update for API request
            } else {
                $this->pa_04->setFormValue($val);
            }
        }

        // Check field name 'qty_pa_04' first before field var 'x_qty_pa_04'
        $val = $CurrentForm->hasValue("qty_pa_04") ? $CurrentForm->getValue("qty_pa_04") : $CurrentForm->getValue("x_qty_pa_04");
        if (!$this->qty_pa_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pa_04->Visible = false; // Disable update for API request
            } else {
                $this->qty_pa_04->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pa_05' first before field var 'x_pa_05'
        $val = $CurrentForm->hasValue("pa_05") ? $CurrentForm->getValue("pa_05") : $CurrentForm->getValue("x_pa_05");
        if (!$this->pa_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pa_05->Visible = false; // Disable update for API request
            } else {
                $this->pa_05->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'qty_pa_05' first before field var 'x_qty_pa_05'
        $val = $CurrentForm->hasValue("qty_pa_05") ? $CurrentForm->getValue("qty_pa_05") : $CurrentForm->getValue("x_qty_pa_05");
        if (!$this->qty_pa_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pa_05->Visible = false; // Disable update for API request
            } else {
                $this->qty_pa_05->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pc_01' first before field var 'x_pc_01'
        $val = $CurrentForm->hasValue("pc_01") ? $CurrentForm->getValue("pc_01") : $CurrentForm->getValue("x_pc_01");
        if (!$this->pc_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_01->Visible = false; // Disable update for API request
            } else {
                $this->pc_01->setFormValue($val);
            }
        }

        // Check field name 'qty_pc_01' first before field var 'x_qty_pc_01'
        $val = $CurrentForm->hasValue("qty_pc_01") ? $CurrentForm->getValue("qty_pc_01") : $CurrentForm->getValue("x_qty_pc_01");
        if (!$this->qty_pc_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pc_01->Visible = false; // Disable update for API request
            } else {
                $this->qty_pc_01->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pc_02' first before field var 'x_pc_02'
        $val = $CurrentForm->hasValue("pc_02") ? $CurrentForm->getValue("pc_02") : $CurrentForm->getValue("x_pc_02");
        if (!$this->pc_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pc_02->Visible = false; // Disable update for API request
            } else {
                $this->pc_02->setFormValue($val);
            }
        }

        // Check field name 'qty_pc_02' first before field var 'x_qty_pc_02'
        $val = $CurrentForm->hasValue("qty_pc_02") ? $CurrentForm->getValue("qty_pc_02") : $CurrentForm->getValue("x_qty_pc_02");
        if (!$this->qty_pc_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_pc_02->Visible = false; // Disable update for API request
            } else {
                $this->qty_pc_02->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'o_01' first before field var 'x_o_01'
        $val = $CurrentForm->hasValue("o_01") ? $CurrentForm->getValue("o_01") : $CurrentForm->getValue("x_o_01");
        if (!$this->o_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->o_01->Visible = false; // Disable update for API request
            } else {
                $this->o_01->setFormValue($val);
            }
        }

        // Check field name 'qty_o_01' first before field var 'x_qty_o_01'
        $val = $CurrentForm->hasValue("qty_o_01") ? $CurrentForm->getValue("qty_o_01") : $CurrentForm->getValue("x_qty_o_01");
        if (!$this->qty_o_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_o_01->Visible = false; // Disable update for API request
            } else {
                $this->qty_o_01->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'lamination_type' first before field var 'x_lamination_type'
        $val = $CurrentForm->hasValue("lamination_type") ? $CurrentForm->getValue("lamination_type") : $CurrentForm->getValue("x_lamination_type");
        if (!$this->lamination_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lamination_type->Visible = false; // Disable update for API request
            } else {
                $this->lamination_type->setFormValue($val);
            }
        }

        // Check field name 'lamination_qty' first before field var 'x_lamination_qty'
        $val = $CurrentForm->hasValue("lamination_qty") ? $CurrentForm->getValue("lamination_qty") : $CurrentForm->getValue("x_lamination_qty");
        if (!$this->lamination_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lamination_qty->Visible = false; // Disable update for API request
            } else {
                $this->lamination_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'die_type' first before field var 'x_die_type'
        $val = $CurrentForm->hasValue("die_type") ? $CurrentForm->getValue("die_type") : $CurrentForm->getValue("x_die_type");
        if (!$this->die_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->die_type->Visible = false; // Disable update for API request
            } else {
                $this->die_type->setFormValue($val);
            }
        }

        // Check field name 'die_qty' first before field var 'x_die_qty'
        $val = $CurrentForm->hasValue("die_qty") ? $CurrentForm->getValue("die_qty") : $CurrentForm->getValue("x_die_qty");
        if (!$this->die_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->die_qty->Visible = false; // Disable update for API request
            } else {
                $this->die_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'binding_type' first before field var 'x_binding_type'
        $val = $CurrentForm->hasValue("binding_type") ? $CurrentForm->getValue("binding_type") : $CurrentForm->getValue("x_binding_type");
        if (!$this->binding_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->binding_type->Visible = false; // Disable update for API request
            } else {
                $this->binding_type->setFormValue($val);
            }
        }

        // Check field name 'binding_qty' first before field var 'x_binding_qty'
        $val = $CurrentForm->hasValue("binding_qty") ? $CurrentForm->getValue("binding_qty") : $CurrentForm->getValue("x_binding_qty");
        if (!$this->binding_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->binding_qty->Visible = false; // Disable update for API request
            } else {
                $this->binding_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'number_type' first before field var 'x_number_type'
        $val = $CurrentForm->hasValue("number_type") ? $CurrentForm->getValue("number_type") : $CurrentForm->getValue("x_number_type");
        if (!$this->number_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->number_type->Visible = false; // Disable update for API request
            } else {
                $this->number_type->setFormValue($val);
            }
        }

        // Check field name 'number_qty' first before field var 'x_number_qty'
        $val = $CurrentForm->hasValue("number_qty") ? $CurrentForm->getValue("number_qty") : $CurrentForm->getValue("x_number_qty");
        if (!$this->number_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->number_qty->Visible = false; // Disable update for API request
            } else {
                $this->number_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'de_01' first before field var 'x_de_01'
        $val = $CurrentForm->hasValue("de_01") ? $CurrentForm->getValue("de_01") : $CurrentForm->getValue("x_de_01");
        if (!$this->de_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->de_01->Visible = false; // Disable update for API request
            } else {
                $this->de_01->setFormValue($val);
            }
        }

        // Check field name 'qty_de_01' first before field var 'x_qty_de_01'
        $val = $CurrentForm->hasValue("qty_de_01") ? $CurrentForm->getValue("qty_de_01") : $CurrentForm->getValue("x_qty_de_01");
        if (!$this->qty_de_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_de_01->Visible = false; // Disable update for API request
            } else {
                $this->qty_de_01->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'de_02' first before field var 'x_de_02'
        $val = $CurrentForm->hasValue("de_02") ? $CurrentForm->getValue("de_02") : $CurrentForm->getValue("x_de_02");
        if (!$this->de_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->de_02->Visible = false; // Disable update for API request
            } else {
                $this->de_02->setFormValue($val);
            }
        }

        // Check field name 'qty_de_02' first before field var 'x_qty_de_02'
        $val = $CurrentForm->hasValue("qty_de_02") ? $CurrentForm->getValue("qty_de_02") : $CurrentForm->getValue("x_qty_de_02");
        if (!$this->qty_de_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_de_02->Visible = false; // Disable update for API request
            } else {
                $this->qty_de_02->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'de_03' first before field var 'x_de_03'
        $val = $CurrentForm->hasValue("de_03") ? $CurrentForm->getValue("de_03") : $CurrentForm->getValue("x_de_03");
        if (!$this->de_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->de_03->Visible = false; // Disable update for API request
            } else {
                $this->de_03->setFormValue($val);
            }
        }

        // Check field name 'qty_de_03' first before field var 'x_qty_de_03'
        $val = $CurrentForm->hasValue("qty_de_03") ? $CurrentForm->getValue("qty_de_03") : $CurrentForm->getValue("x_qty_de_03");
        if (!$this->qty_de_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty_de_03->Visible = false; // Disable update for API request
            } else {
                $this->qty_de_03->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->job_type->CurrentValue = $this->job_type->FormValue;
        $this->job_category->CurrentValue = $this->job_category->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->description->CurrentValue = $this->description->FormValue;
        $this->size->CurrentValue = $this->size->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->pages->CurrentValue = $this->pages->FormValue;
        $this->paper->CurrentValue = $this->paper->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->pr_01->CurrentValue = $this->pr_01->FormValue;
        $this->qty_pr_01->CurrentValue = $this->qty_pr_01->FormValue;
        $this->pl_01->CurrentValue = $this->pl_01->FormValue;
        $this->qty_pl_01->CurrentValue = $this->qty_pl_01->FormValue;
        $this->pr_02->CurrentValue = $this->pr_02->FormValue;
        $this->qty_pr_02->CurrentValue = $this->qty_pr_02->FormValue;
        $this->pl_02->CurrentValue = $this->pl_02->FormValue;
        $this->qty_pl_02->CurrentValue = $this->qty_pl_02->FormValue;
        $this->pr_03->CurrentValue = $this->pr_03->FormValue;
        $this->qty_pr_03->CurrentValue = $this->qty_pr_03->FormValue;
        $this->pl_03->CurrentValue = $this->pl_03->FormValue;
        $this->qty_pl_03->CurrentValue = $this->qty_pl_03->FormValue;
        $this->pr_04->CurrentValue = $this->pr_04->FormValue;
        $this->qty_pr_04->CurrentValue = $this->qty_pr_04->FormValue;
        $this->pl_04->CurrentValue = $this->pl_04->FormValue;
        $this->qty_pl_04->CurrentValue = $this->qty_pl_04->FormValue;
        $this->pa_01->CurrentValue = $this->pa_01->FormValue;
        $this->qty_pa_01->CurrentValue = $this->qty_pa_01->FormValue;
        $this->pa_02->CurrentValue = $this->pa_02->FormValue;
        $this->qty_pa_02->CurrentValue = $this->qty_pa_02->FormValue;
        $this->pa_03->CurrentValue = $this->pa_03->FormValue;
        $this->qty_pa_03->CurrentValue = $this->qty_pa_03->FormValue;
        $this->pa_04->CurrentValue = $this->pa_04->FormValue;
        $this->qty_pa_04->CurrentValue = $this->qty_pa_04->FormValue;
        $this->pa_05->CurrentValue = $this->pa_05->FormValue;
        $this->qty_pa_05->CurrentValue = $this->qty_pa_05->FormValue;
        $this->pc_01->CurrentValue = $this->pc_01->FormValue;
        $this->qty_pc_01->CurrentValue = $this->qty_pc_01->FormValue;
        $this->pc_02->CurrentValue = $this->pc_02->FormValue;
        $this->qty_pc_02->CurrentValue = $this->qty_pc_02->FormValue;
        $this->o_01->CurrentValue = $this->o_01->FormValue;
        $this->qty_o_01->CurrentValue = $this->qty_o_01->FormValue;
        $this->lamination_type->CurrentValue = $this->lamination_type->FormValue;
        $this->lamination_qty->CurrentValue = $this->lamination_qty->FormValue;
        $this->die_type->CurrentValue = $this->die_type->FormValue;
        $this->die_qty->CurrentValue = $this->die_qty->FormValue;
        $this->binding_type->CurrentValue = $this->binding_type->FormValue;
        $this->binding_qty->CurrentValue = $this->binding_qty->FormValue;
        $this->number_type->CurrentValue = $this->number_type->FormValue;
        $this->number_qty->CurrentValue = $this->number_qty->FormValue;
        $this->de_01->CurrentValue = $this->de_01->FormValue;
        $this->qty_de_01->CurrentValue = $this->qty_de_01->FormValue;
        $this->de_02->CurrentValue = $this->de_02->FormValue;
        $this->qty_de_02->CurrentValue = $this->qty_de_02->FormValue;
        $this->de_03->CurrentValue = $this->de_03->FormValue;
        $this->qty_de_03->CurrentValue = $this->qty_de_03->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->job_type->setDbValue($row['job_type']);
        $this->job_category->setDbValue($row['job_category']);
        $this->company_id->setDbValue($row['company_id']);
        $this->description->setDbValue($row['description']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->pages->setDbValue($row['pages']);
        $this->paper->setDbValue($row['paper']);
        $this->remarks->setDbValue($row['remarks']);
        $this->pr_01->setDbValue($row['pr_01']);
        $this->qty_pr_01->setDbValue($row['qty_pr_01']);
        $this->pl_01->setDbValue($row['pl_01']);
        $this->qty_pl_01->setDbValue($row['qty_pl_01']);
        $this->pr_02->setDbValue($row['pr_02']);
        $this->qty_pr_02->setDbValue($row['qty_pr_02']);
        $this->pl_02->setDbValue($row['pl_02']);
        $this->qty_pl_02->setDbValue($row['qty_pl_02']);
        $this->pr_03->setDbValue($row['pr_03']);
        $this->qty_pr_03->setDbValue($row['qty_pr_03']);
        $this->pl_03->setDbValue($row['pl_03']);
        $this->qty_pl_03->setDbValue($row['qty_pl_03']);
        $this->pr_04->setDbValue($row['pr_04']);
        $this->qty_pr_04->setDbValue($row['qty_pr_04']);
        $this->pl_04->setDbValue($row['pl_04']);
        $this->qty_pl_04->setDbValue($row['qty_pl_04']);
        $this->pa_01->setDbValue($row['pa_01']);
        $this->qty_pa_01->setDbValue($row['qty_pa_01']);
        $this->pa_02->setDbValue($row['pa_02']);
        $this->qty_pa_02->setDbValue($row['qty_pa_02']);
        $this->pa_03->setDbValue($row['pa_03']);
        $this->qty_pa_03->setDbValue($row['qty_pa_03']);
        $this->pa_04->setDbValue($row['pa_04']);
        $this->qty_pa_04->setDbValue($row['qty_pa_04']);
        $this->pa_05->setDbValue($row['pa_05']);
        $this->qty_pa_05->setDbValue($row['qty_pa_05']);
        $this->pc_01->setDbValue($row['pc_01']);
        $this->qty_pc_01->setDbValue($row['qty_pc_01']);
        $this->pc_02->setDbValue($row['pc_02']);
        $this->qty_pc_02->setDbValue($row['qty_pc_02']);
        $this->o_01->setDbValue($row['o_01']);
        $this->qty_o_01->setDbValue($row['qty_o_01']);
        $this->lamination_type->setDbValue($row['lamination_type']);
        $this->lamination_qty->setDbValue($row['lamination_qty']);
        $this->die_type->setDbValue($row['die_type']);
        $this->die_qty->setDbValue($row['die_qty']);
        $this->binding_type->setDbValue($row['binding_type']);
        $this->binding_qty->setDbValue($row['binding_qty']);
        $this->number_type->setDbValue($row['number_type']);
        $this->number_qty->setDbValue($row['number_qty']);
        $this->de_01->setDbValue($row['de_01']);
        $this->qty_de_01->setDbValue($row['qty_de_01']);
        $this->de_02->setDbValue($row['de_02']);
        $this->qty_de_02->setDbValue($row['qty_de_02']);
        $this->de_03->setDbValue($row['de_03']);
        $this->qty_de_03->setDbValue($row['qty_de_03']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['job_type'] = $this->job_type->DefaultValue;
        $row['job_category'] = $this->job_category->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['pages'] = $this->pages->DefaultValue;
        $row['paper'] = $this->paper->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['pr_01'] = $this->pr_01->DefaultValue;
        $row['qty_pr_01'] = $this->qty_pr_01->DefaultValue;
        $row['pl_01'] = $this->pl_01->DefaultValue;
        $row['qty_pl_01'] = $this->qty_pl_01->DefaultValue;
        $row['pr_02'] = $this->pr_02->DefaultValue;
        $row['qty_pr_02'] = $this->qty_pr_02->DefaultValue;
        $row['pl_02'] = $this->pl_02->DefaultValue;
        $row['qty_pl_02'] = $this->qty_pl_02->DefaultValue;
        $row['pr_03'] = $this->pr_03->DefaultValue;
        $row['qty_pr_03'] = $this->qty_pr_03->DefaultValue;
        $row['pl_03'] = $this->pl_03->DefaultValue;
        $row['qty_pl_03'] = $this->qty_pl_03->DefaultValue;
        $row['pr_04'] = $this->pr_04->DefaultValue;
        $row['qty_pr_04'] = $this->qty_pr_04->DefaultValue;
        $row['pl_04'] = $this->pl_04->DefaultValue;
        $row['qty_pl_04'] = $this->qty_pl_04->DefaultValue;
        $row['pa_01'] = $this->pa_01->DefaultValue;
        $row['qty_pa_01'] = $this->qty_pa_01->DefaultValue;
        $row['pa_02'] = $this->pa_02->DefaultValue;
        $row['qty_pa_02'] = $this->qty_pa_02->DefaultValue;
        $row['pa_03'] = $this->pa_03->DefaultValue;
        $row['qty_pa_03'] = $this->qty_pa_03->DefaultValue;
        $row['pa_04'] = $this->pa_04->DefaultValue;
        $row['qty_pa_04'] = $this->qty_pa_04->DefaultValue;
        $row['pa_05'] = $this->pa_05->DefaultValue;
        $row['qty_pa_05'] = $this->qty_pa_05->DefaultValue;
        $row['pc_01'] = $this->pc_01->DefaultValue;
        $row['qty_pc_01'] = $this->qty_pc_01->DefaultValue;
        $row['pc_02'] = $this->pc_02->DefaultValue;
        $row['qty_pc_02'] = $this->qty_pc_02->DefaultValue;
        $row['o_01'] = $this->o_01->DefaultValue;
        $row['qty_o_01'] = $this->qty_o_01->DefaultValue;
        $row['lamination_type'] = $this->lamination_type->DefaultValue;
        $row['lamination_qty'] = $this->lamination_qty->DefaultValue;
        $row['die_type'] = $this->die_type->DefaultValue;
        $row['die_qty'] = $this->die_qty->DefaultValue;
        $row['binding_type'] = $this->binding_type->DefaultValue;
        $row['binding_qty'] = $this->binding_qty->DefaultValue;
        $row['number_type'] = $this->number_type->DefaultValue;
        $row['number_qty'] = $this->number_qty->DefaultValue;
        $row['de_01'] = $this->de_01->DefaultValue;
        $row['qty_de_01'] = $this->qty_de_01->DefaultValue;
        $row['de_02'] = $this->de_02->DefaultValue;
        $row['qty_de_02'] = $this->qty_de_02->DefaultValue;
        $row['de_03'] = $this->de_03->DefaultValue;
        $row['qty_de_03'] = $this->qty_de_03->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // job_type
        $this->job_type->RowCssClass = "row";

        // job_category
        $this->job_category->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // pages
        $this->pages->RowCssClass = "row";

        // paper
        $this->paper->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // pr_01
        $this->pr_01->RowCssClass = "row";

        // qty_pr_01
        $this->qty_pr_01->RowCssClass = "row";

        // pl_01
        $this->pl_01->RowCssClass = "row";

        // qty_pl_01
        $this->qty_pl_01->RowCssClass = "row";

        // pr_02
        $this->pr_02->RowCssClass = "row";

        // qty_pr_02
        $this->qty_pr_02->RowCssClass = "row";

        // pl_02
        $this->pl_02->RowCssClass = "row";

        // qty_pl_02
        $this->qty_pl_02->RowCssClass = "row";

        // pr_03
        $this->pr_03->RowCssClass = "row";

        // qty_pr_03
        $this->qty_pr_03->RowCssClass = "row";

        // pl_03
        $this->pl_03->RowCssClass = "row";

        // qty_pl_03
        $this->qty_pl_03->RowCssClass = "row";

        // pr_04
        $this->pr_04->RowCssClass = "row";

        // qty_pr_04
        $this->qty_pr_04->RowCssClass = "row";

        // pl_04
        $this->pl_04->RowCssClass = "row";

        // qty_pl_04
        $this->qty_pl_04->RowCssClass = "row";

        // pa_01
        $this->pa_01->RowCssClass = "row";

        // qty_pa_01
        $this->qty_pa_01->RowCssClass = "row";

        // pa_02
        $this->pa_02->RowCssClass = "row";

        // qty_pa_02
        $this->qty_pa_02->RowCssClass = "row";

        // pa_03
        $this->pa_03->RowCssClass = "row";

        // qty_pa_03
        $this->qty_pa_03->RowCssClass = "row";

        // pa_04
        $this->pa_04->RowCssClass = "row";

        // qty_pa_04
        $this->qty_pa_04->RowCssClass = "row";

        // pa_05
        $this->pa_05->RowCssClass = "row";

        // qty_pa_05
        $this->qty_pa_05->RowCssClass = "row";

        // pc_01
        $this->pc_01->RowCssClass = "row";

        // qty_pc_01
        $this->qty_pc_01->RowCssClass = "row";

        // pc_02
        $this->pc_02->RowCssClass = "row";

        // qty_pc_02
        $this->qty_pc_02->RowCssClass = "row";

        // o_01
        $this->o_01->RowCssClass = "row";

        // qty_o_01
        $this->qty_o_01->RowCssClass = "row";

        // lamination_type
        $this->lamination_type->RowCssClass = "row";

        // lamination_qty
        $this->lamination_qty->RowCssClass = "row";

        // die_type
        $this->die_type->RowCssClass = "row";

        // die_qty
        $this->die_qty->RowCssClass = "row";

        // binding_type
        $this->binding_type->RowCssClass = "row";

        // binding_qty
        $this->binding_qty->RowCssClass = "row";

        // number_type
        $this->number_type->RowCssClass = "row";

        // number_qty
        $this->number_qty->RowCssClass = "row";

        // de_01
        $this->de_01->RowCssClass = "row";

        // qty_de_01
        $this->qty_de_01->RowCssClass = "row";

        // de_02
        $this->de_02->RowCssClass = "row";

        // qty_de_02
        $this->qty_de_02->RowCssClass = "row";

        // de_03
        $this->de_03->RowCssClass = "row";

        // qty_de_03
        $this->qty_de_03->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // job_type
            if (strval($this->job_type->CurrentValue) != "") {
                $this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
            } else {
                $this->job_type->ViewValue = null;
            }

            // job_category
            if (strval($this->job_category->CurrentValue) != "") {
                $this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
            } else {
                $this->job_category->ViewValue = null;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // size
            $curVal = strval($this->size->CurrentValue);
            if ($curVal != "") {
                $this->size->ViewValue = $this->size->lookupCacheOption($curVal);
                if ($this->size->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->size->Lookup->getTable()->Fields["description"]->searchExpression(), "=", $curVal, $this->size->Lookup->getTable()->Fields["description"]->searchDataType(), "");
                    $lookupFilter = $this->size->getSelectFilter($this); // PHP
                    $sqlWrk = $this->size->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->size->Lookup->renderViewRow($rswrk[0]);
                        $this->size->ViewValue = $this->size->displayValue($arwrk);
                    } else {
                        $this->size->ViewValue = $this->size->CurrentValue;
                    }
                }
            } else {
                $this->size->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // pages
            $this->pages->ViewValue = $this->pages->CurrentValue;

            // paper
            $this->paper->ViewValue = $this->paper->CurrentValue;
            $this->paper->ViewValue = FormatNumber($this->paper->ViewValue, $this->paper->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pr_01
            $curVal = strval($this->pr_01->CurrentValue);
            if ($curVal != "") {
                $this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
                if ($this->pr_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
                    } else {
                        $this->pr_01->ViewValue = $this->pr_01->CurrentValue;
                    }
                }
            } else {
                $this->pr_01->ViewValue = null;
            }

            // qty_pr_01
            $this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
            $this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, $this->qty_pr_01->formatPattern());

            // pl_01
            $curVal = strval($this->pl_01->CurrentValue);
            if ($curVal != "") {
                $this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
                if ($this->pl_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
                    } else {
                        $this->pl_01->ViewValue = $this->pl_01->CurrentValue;
                    }
                }
            } else {
                $this->pl_01->ViewValue = null;
            }

            // qty_pl_01
            $this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
            $this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, $this->qty_pl_01->formatPattern());

            // pr_02
            $curVal = strval($this->pr_02->CurrentValue);
            if ($curVal != "") {
                $this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
                if ($this->pr_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
                    } else {
                        $this->pr_02->ViewValue = $this->pr_02->CurrentValue;
                    }
                }
            } else {
                $this->pr_02->ViewValue = null;
            }

            // qty_pr_02
            $this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
            $this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, $this->qty_pr_02->formatPattern());

            // pl_02
            $curVal = strval($this->pl_02->CurrentValue);
            if ($curVal != "") {
                $this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
                if ($this->pl_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
                    } else {
                        $this->pl_02->ViewValue = $this->pl_02->CurrentValue;
                    }
                }
            } else {
                $this->pl_02->ViewValue = null;
            }

            // qty_pl_02
            $this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
            $this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, $this->qty_pl_02->formatPattern());

            // pr_03
            $curVal = strval($this->pr_03->CurrentValue);
            if ($curVal != "") {
                $this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
                if ($this->pr_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
                    } else {
                        $this->pr_03->ViewValue = $this->pr_03->CurrentValue;
                    }
                }
            } else {
                $this->pr_03->ViewValue = null;
            }

            // qty_pr_03
            $this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
            $this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, $this->qty_pr_03->formatPattern());

            // pl_03
            $curVal = strval($this->pl_03->CurrentValue);
            if ($curVal != "") {
                $this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
                if ($this->pl_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
                    } else {
                        $this->pl_03->ViewValue = $this->pl_03->CurrentValue;
                    }
                }
            } else {
                $this->pl_03->ViewValue = null;
            }

            // qty_pl_03
            $this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
            $this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, $this->qty_pl_03->formatPattern());

            // pr_04
            $curVal = strval($this->pr_04->CurrentValue);
            if ($curVal != "") {
                $this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
                if ($this->pr_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pr_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pr_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pr_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pr_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
                    } else {
                        $this->pr_04->ViewValue = $this->pr_04->CurrentValue;
                    }
                }
            } else {
                $this->pr_04->ViewValue = null;
            }

            // qty_pr_04
            $this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
            $this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, $this->qty_pr_04->formatPattern());

            // pl_04
            $curVal = strval($this->pl_04->CurrentValue);
            if ($curVal != "") {
                $this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
                if ($this->pl_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pl_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pl_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pl_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pl_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
                    } else {
                        $this->pl_04->ViewValue = $this->pl_04->CurrentValue;
                    }
                }
            } else {
                $this->pl_04->ViewValue = null;
            }

            // qty_pl_04
            $this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
            $this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, $this->qty_pl_04->formatPattern());

            // pa_01
            $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
            $curVal = strval($this->pa_01->CurrentValue);
            if ($curVal != "") {
                $this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
                if ($this->pa_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
                    } else {
                        $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
                    }
                }
            } else {
                $this->pa_01->ViewValue = null;
            }

            // qty_pa_01
            $this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
            $this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, $this->qty_pa_01->formatPattern());

            // pa_02
            $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
            $curVal = strval($this->pa_02->CurrentValue);
            if ($curVal != "") {
                $this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
                if ($this->pa_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
                    } else {
                        $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
                    }
                }
            } else {
                $this->pa_02->ViewValue = null;
            }

            // qty_pa_02
            $this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
            $this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, $this->qty_pa_02->formatPattern());

            // pa_03
            $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
            $curVal = strval($this->pa_03->CurrentValue);
            if ($curVal != "") {
                $this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
                if ($this->pa_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
                    } else {
                        $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
                    }
                }
            } else {
                $this->pa_03->ViewValue = null;
            }

            // qty_pa_03
            $this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
            $this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, $this->qty_pa_03->formatPattern());

            // pa_04
            $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
            $curVal = strval($this->pa_04->CurrentValue);
            if ($curVal != "") {
                $this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
                if ($this->pa_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
                    } else {
                        $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
                    }
                }
            } else {
                $this->pa_04->ViewValue = null;
            }

            // qty_pa_04
            $this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
            $this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, $this->qty_pa_04->formatPattern());

            // pa_05
            $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
            $curVal = strval($this->pa_05->CurrentValue);
            if ($curVal != "") {
                $this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
                if ($this->pa_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_05->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
                    } else {
                        $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
                    }
                }
            } else {
                $this->pa_05->ViewValue = null;
            }

            // qty_pa_05
            $this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
            $this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, $this->qty_pa_05->formatPattern());

            // pc_01
            $curVal = strval($this->pc_01->CurrentValue);
            if ($curVal != "") {
                $this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
                if ($this->pc_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pc_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pc_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pc_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pc_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
                    } else {
                        $this->pc_01->ViewValue = $this->pc_01->CurrentValue;
                    }
                }
            } else {
                $this->pc_01->ViewValue = null;
            }

            // qty_pc_01
            $this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
            $this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, $this->qty_pc_01->formatPattern());

            // pc_02
            $curVal = strval($this->pc_02->CurrentValue);
            if ($curVal != "") {
                $this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
                if ($this->pc_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pc_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pc_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pc_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pc_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
                    } else {
                        $this->pc_02->ViewValue = $this->pc_02->CurrentValue;
                    }
                }
            } else {
                $this->pc_02->ViewValue = null;
            }

            // qty_pc_02
            $this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
            $this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, $this->qty_pc_02->formatPattern());

            // o_01
            $curVal = strval($this->o_01->CurrentValue);
            if ($curVal != "") {
                $this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
                if ($this->o_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->o_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->o_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->o_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->o_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->o_01->Lookup->renderViewRow($rswrk[0]);
                        $this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
                    } else {
                        $this->o_01->ViewValue = $this->o_01->CurrentValue;
                    }
                }
            } else {
                $this->o_01->ViewValue = null;
            }

            // qty_o_01
            $this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
            $this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, $this->qty_o_01->formatPattern());

            // lamination_type
            $curVal = strval($this->lamination_type->CurrentValue);
            if ($curVal != "") {
                $this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
                if ($this->lamination_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->lamination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->lamination_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->lamination_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->lamination_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->lamination_type->Lookup->renderViewRow($rswrk[0]);
                        $this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
                    } else {
                        $this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
                    }
                }
            } else {
                $this->lamination_type->ViewValue = null;
            }

            // lamination_qty
            $this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
            $this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, $this->lamination_qty->formatPattern());

            // die_type
            $curVal = strval($this->die_type->CurrentValue);
            if ($curVal != "") {
                $this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
                if ($this->die_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->die_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->die_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->die_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->die_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->die_type->Lookup->renderViewRow($rswrk[0]);
                        $this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
                    } else {
                        $this->die_type->ViewValue = $this->die_type->CurrentValue;
                    }
                }
            } else {
                $this->die_type->ViewValue = null;
            }

            // die_qty
            $this->die_qty->ViewValue = $this->die_qty->CurrentValue;
            $this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, $this->die_qty->formatPattern());

            // binding_type
            $curVal = strval($this->binding_type->CurrentValue);
            if ($curVal != "") {
                $this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
                if ($this->binding_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->binding_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->binding_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->binding_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->binding_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->binding_type->Lookup->renderViewRow($rswrk[0]);
                        $this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
                    } else {
                        $this->binding_type->ViewValue = $this->binding_type->CurrentValue;
                    }
                }
            } else {
                $this->binding_type->ViewValue = null;
            }

            // binding_qty
            $this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
            $this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, $this->binding_qty->formatPattern());

            // number_type
            $curVal = strval($this->number_type->CurrentValue);
            if ($curVal != "") {
                $this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
                if ($this->number_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->number_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->number_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->number_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->number_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->number_type->Lookup->renderViewRow($rswrk[0]);
                        $this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
                    } else {
                        $this->number_type->ViewValue = $this->number_type->CurrentValue;
                    }
                }
            } else {
                $this->number_type->ViewValue = null;
            }

            // number_qty
            $this->number_qty->ViewValue = $this->number_qty->CurrentValue;
            $this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, $this->number_qty->formatPattern());

            // de_01
            $curVal = strval($this->de_01->CurrentValue);
            if ($curVal != "") {
                $this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
                if ($this->de_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_01->Lookup->renderViewRow($rswrk[0]);
                        $this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
                    } else {
                        $this->de_01->ViewValue = $this->de_01->CurrentValue;
                    }
                }
            } else {
                $this->de_01->ViewValue = null;
            }

            // qty_de_01
            $this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
            $this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, $this->qty_de_01->formatPattern());

            // de_02
            $curVal = strval($this->de_02->CurrentValue);
            if ($curVal != "") {
                $this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
                if ($this->de_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_02->Lookup->renderViewRow($rswrk[0]);
                        $this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
                    } else {
                        $this->de_02->ViewValue = $this->de_02->CurrentValue;
                    }
                }
            } else {
                $this->de_02->ViewValue = null;
            }

            // qty_de_02
            $this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
            $this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, $this->qty_de_02->formatPattern());

            // de_03
            $curVal = strval($this->de_03->CurrentValue);
            if ($curVal != "") {
                $this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
                if ($this->de_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->de_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->de_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->de_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->de_03->Lookup->renderViewRow($rswrk[0]);
                        $this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
                    } else {
                        $this->de_03->ViewValue = $this->de_03->CurrentValue;
                    }
                }
            } else {
                $this->de_03->ViewValue = null;
            }

            // qty_de_03
            $this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
            $this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, $this->qty_de_03->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;

            // job_type
            $this->job_type->HrefValue = "";

            // job_category
            $this->job_category->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // description
            $this->description->HrefValue = "";

            // size
            $this->size->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // pages
            $this->pages->HrefValue = "";

            // paper
            $this->paper->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // pr_01
            $this->pr_01->HrefValue = "";

            // qty_pr_01
            $this->qty_pr_01->HrefValue = "";

            // pl_01
            $this->pl_01->HrefValue = "";

            // qty_pl_01
            $this->qty_pl_01->HrefValue = "";

            // pr_02
            $this->pr_02->HrefValue = "";

            // qty_pr_02
            $this->qty_pr_02->HrefValue = "";

            // pl_02
            $this->pl_02->HrefValue = "";

            // qty_pl_02
            $this->qty_pl_02->HrefValue = "";

            // pr_03
            $this->pr_03->HrefValue = "";

            // qty_pr_03
            $this->qty_pr_03->HrefValue = "";

            // pl_03
            $this->pl_03->HrefValue = "";

            // qty_pl_03
            $this->qty_pl_03->HrefValue = "";

            // pr_04
            $this->pr_04->HrefValue = "";

            // qty_pr_04
            $this->qty_pr_04->HrefValue = "";

            // pl_04
            $this->pl_04->HrefValue = "";

            // qty_pl_04
            $this->qty_pl_04->HrefValue = "";

            // pa_01
            $this->pa_01->HrefValue = "";

            // qty_pa_01
            $this->qty_pa_01->HrefValue = "";

            // pa_02
            $this->pa_02->HrefValue = "";

            // qty_pa_02
            $this->qty_pa_02->HrefValue = "";

            // pa_03
            $this->pa_03->HrefValue = "";

            // qty_pa_03
            $this->qty_pa_03->HrefValue = "";

            // pa_04
            $this->pa_04->HrefValue = "";

            // qty_pa_04
            $this->qty_pa_04->HrefValue = "";

            // pa_05
            $this->pa_05->HrefValue = "";

            // qty_pa_05
            $this->qty_pa_05->HrefValue = "";

            // pc_01
            $this->pc_01->HrefValue = "";

            // qty_pc_01
            $this->qty_pc_01->HrefValue = "";

            // pc_02
            $this->pc_02->HrefValue = "";

            // qty_pc_02
            $this->qty_pc_02->HrefValue = "";

            // o_01
            $this->o_01->HrefValue = "";

            // qty_o_01
            $this->qty_o_01->HrefValue = "";

            // lamination_type
            $this->lamination_type->HrefValue = "";

            // lamination_qty
            $this->lamination_qty->HrefValue = "";

            // die_type
            $this->die_type->HrefValue = "";

            // die_qty
            $this->die_qty->HrefValue = "";

            // binding_type
            $this->binding_type->HrefValue = "";

            // binding_qty
            $this->binding_qty->HrefValue = "";

            // number_type
            $this->number_type->HrefValue = "";

            // number_qty
            $this->number_qty->HrefValue = "";

            // de_01
            $this->de_01->HrefValue = "";

            // qty_de_01
            $this->qty_de_01->HrefValue = "";

            // de_02
            $this->de_02->HrefValue = "";

            // qty_de_02
            $this->qty_de_02->HrefValue = "";

            // de_03
            $this->de_03->HrefValue = "";

            // qty_de_03
            $this->qty_de_03->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // job_type
            $this->job_type->EditValue = $this->job_type->options(false);
            $this->job_type->PlaceHolder = RemoveHtml($this->job_type->caption());

            // job_category
            $this->job_category->EditValue = $this->job_category->options(false);
            $this->job_category->PlaceHolder = RemoveHtml($this->job_category->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->CurrentValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // size
            $this->size->setupEditAttributes();
            $curVal = trim(strval($this->size->CurrentValue));
            if ($curVal != "") {
                $this->size->ViewValue = $this->size->lookupCacheOption($curVal);
            } else {
                $this->size->ViewValue = $this->size->Lookup !== null && is_array($this->size->lookupOptions()) && count($this->size->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->size->ViewValue !== null) { // Load from cache
                $this->size->EditValue = array_values($this->size->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->size->Lookup->getTable()->Fields["description"]->searchExpression(), "=", $this->size->CurrentValue, $this->size->Lookup->getTable()->Fields["description"]->searchDataType(), "");
                }
                $lookupFilter = $this->size->getSelectFilter($this); // PHP
                $sqlWrk = $this->size->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->size->EditValue = $arwrk;
            }
            $this->size->PlaceHolder = RemoveHtml($this->size->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // pages
            $this->pages->setupEditAttributes();
            if (!$this->pages->Raw) {
                $this->pages->CurrentValue = HtmlDecode($this->pages->CurrentValue);
            }
            $this->pages->EditValue = HtmlEncode($this->pages->CurrentValue);
            $this->pages->PlaceHolder = RemoveHtml($this->pages->caption());

            // paper
            $this->paper->setupEditAttributes();
            $this->paper->EditValue = $this->paper->CurrentValue;
            $this->paper->PlaceHolder = RemoveHtml($this->paper->caption());
            if (strval($this->paper->EditValue) != "" && is_numeric($this->paper->EditValue)) {
                $this->paper->EditValue = FormatNumber($this->paper->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // pr_01
            $this->pr_01->setupEditAttributes();
            $curVal = trim(strval($this->pr_01->CurrentValue));
            if ($curVal != "") {
                $this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
            } else {
                $this->pr_01->ViewValue = $this->pr_01->Lookup !== null && is_array($this->pr_01->lookupOptions()) && count($this->pr_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pr_01->ViewValue !== null) { // Load from cache
                $this->pr_01->EditValue = array_values($this->pr_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pr_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pr_01->CurrentValue, $this->pr_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pr_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pr_01->EditValue = $arwrk;
            }
            $this->pr_01->PlaceHolder = RemoveHtml($this->pr_01->caption());

            // qty_pr_01
            $this->qty_pr_01->setupEditAttributes();
            $this->qty_pr_01->EditValue = $this->qty_pr_01->CurrentValue;
            $this->qty_pr_01->PlaceHolder = RemoveHtml($this->qty_pr_01->caption());
            if (strval($this->qty_pr_01->EditValue) != "" && is_numeric($this->qty_pr_01->EditValue)) {
                $this->qty_pr_01->EditValue = FormatNumber($this->qty_pr_01->EditValue, null);
            }

            // pl_01
            $this->pl_01->setupEditAttributes();
            $curVal = trim(strval($this->pl_01->CurrentValue));
            if ($curVal != "") {
                $this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
            } else {
                $this->pl_01->ViewValue = $this->pl_01->Lookup !== null && is_array($this->pl_01->lookupOptions()) && count($this->pl_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_01->ViewValue !== null) { // Load from cache
                $this->pl_01->EditValue = array_values($this->pl_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_01->CurrentValue, $this->pl_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_01->EditValue = $arwrk;
            }
            $this->pl_01->PlaceHolder = RemoveHtml($this->pl_01->caption());

            // qty_pl_01
            $this->qty_pl_01->setupEditAttributes();
            $this->qty_pl_01->EditValue = $this->qty_pl_01->CurrentValue;
            $this->qty_pl_01->PlaceHolder = RemoveHtml($this->qty_pl_01->caption());
            if (strval($this->qty_pl_01->EditValue) != "" && is_numeric($this->qty_pl_01->EditValue)) {
                $this->qty_pl_01->EditValue = FormatNumber($this->qty_pl_01->EditValue, null);
            }

            // pr_02
            $this->pr_02->setupEditAttributes();
            $curVal = trim(strval($this->pr_02->CurrentValue));
            if ($curVal != "") {
                $this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
            } else {
                $this->pr_02->ViewValue = $this->pr_02->Lookup !== null && is_array($this->pr_02->lookupOptions()) && count($this->pr_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pr_02->ViewValue !== null) { // Load from cache
                $this->pr_02->EditValue = array_values($this->pr_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pr_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pr_02->CurrentValue, $this->pr_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pr_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pr_02->EditValue = $arwrk;
            }
            $this->pr_02->PlaceHolder = RemoveHtml($this->pr_02->caption());

            // qty_pr_02
            $this->qty_pr_02->setupEditAttributes();
            $this->qty_pr_02->EditValue = $this->qty_pr_02->CurrentValue;
            $this->qty_pr_02->PlaceHolder = RemoveHtml($this->qty_pr_02->caption());
            if (strval($this->qty_pr_02->EditValue) != "" && is_numeric($this->qty_pr_02->EditValue)) {
                $this->qty_pr_02->EditValue = FormatNumber($this->qty_pr_02->EditValue, null);
            }

            // pl_02
            $this->pl_02->setupEditAttributes();
            $curVal = trim(strval($this->pl_02->CurrentValue));
            if ($curVal != "") {
                $this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
            } else {
                $this->pl_02->ViewValue = $this->pl_02->Lookup !== null && is_array($this->pl_02->lookupOptions()) && count($this->pl_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_02->ViewValue !== null) { // Load from cache
                $this->pl_02->EditValue = array_values($this->pl_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_02->CurrentValue, $this->pl_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_02->EditValue = $arwrk;
            }
            $this->pl_02->PlaceHolder = RemoveHtml($this->pl_02->caption());

            // qty_pl_02
            $this->qty_pl_02->setupEditAttributes();
            $this->qty_pl_02->EditValue = $this->qty_pl_02->CurrentValue;
            $this->qty_pl_02->PlaceHolder = RemoveHtml($this->qty_pl_02->caption());
            if (strval($this->qty_pl_02->EditValue) != "" && is_numeric($this->qty_pl_02->EditValue)) {
                $this->qty_pl_02->EditValue = FormatNumber($this->qty_pl_02->EditValue, null);
            }

            // pr_03
            $this->pr_03->setupEditAttributes();
            $curVal = trim(strval($this->pr_03->CurrentValue));
            if ($curVal != "") {
                $this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
            } else {
                $this->pr_03->ViewValue = $this->pr_03->Lookup !== null && is_array($this->pr_03->lookupOptions()) && count($this->pr_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pr_03->ViewValue !== null) { // Load from cache
                $this->pr_03->EditValue = array_values($this->pr_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pr_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pr_03->CurrentValue, $this->pr_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pr_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pr_03->EditValue = $arwrk;
            }
            $this->pr_03->PlaceHolder = RemoveHtml($this->pr_03->caption());

            // qty_pr_03
            $this->qty_pr_03->setupEditAttributes();
            $this->qty_pr_03->EditValue = $this->qty_pr_03->CurrentValue;
            $this->qty_pr_03->PlaceHolder = RemoveHtml($this->qty_pr_03->caption());
            if (strval($this->qty_pr_03->EditValue) != "" && is_numeric($this->qty_pr_03->EditValue)) {
                $this->qty_pr_03->EditValue = FormatNumber($this->qty_pr_03->EditValue, null);
            }

            // pl_03
            $this->pl_03->setupEditAttributes();
            $curVal = trim(strval($this->pl_03->CurrentValue));
            if ($curVal != "") {
                $this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
            } else {
                $this->pl_03->ViewValue = $this->pl_03->Lookup !== null && is_array($this->pl_03->lookupOptions()) && count($this->pl_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_03->ViewValue !== null) { // Load from cache
                $this->pl_03->EditValue = array_values($this->pl_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_03->CurrentValue, $this->pl_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_03->EditValue = $arwrk;
            }
            $this->pl_03->PlaceHolder = RemoveHtml($this->pl_03->caption());

            // qty_pl_03
            $this->qty_pl_03->setupEditAttributes();
            $this->qty_pl_03->EditValue = $this->qty_pl_03->CurrentValue;
            $this->qty_pl_03->PlaceHolder = RemoveHtml($this->qty_pl_03->caption());
            if (strval($this->qty_pl_03->EditValue) != "" && is_numeric($this->qty_pl_03->EditValue)) {
                $this->qty_pl_03->EditValue = FormatNumber($this->qty_pl_03->EditValue, null);
            }

            // pr_04
            $this->pr_04->setupEditAttributes();
            $curVal = trim(strval($this->pr_04->CurrentValue));
            if ($curVal != "") {
                $this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
            } else {
                $this->pr_04->ViewValue = $this->pr_04->Lookup !== null && is_array($this->pr_04->lookupOptions()) && count($this->pr_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pr_04->ViewValue !== null) { // Load from cache
                $this->pr_04->EditValue = array_values($this->pr_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pr_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pr_04->CurrentValue, $this->pr_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pr_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pr_04->EditValue = $arwrk;
            }
            $this->pr_04->PlaceHolder = RemoveHtml($this->pr_04->caption());

            // qty_pr_04
            $this->qty_pr_04->setupEditAttributes();
            $this->qty_pr_04->EditValue = $this->qty_pr_04->CurrentValue;
            $this->qty_pr_04->PlaceHolder = RemoveHtml($this->qty_pr_04->caption());
            if (strval($this->qty_pr_04->EditValue) != "" && is_numeric($this->qty_pr_04->EditValue)) {
                $this->qty_pr_04->EditValue = FormatNumber($this->qty_pr_04->EditValue, null);
            }

            // pl_04
            $this->pl_04->setupEditAttributes();
            $curVal = trim(strval($this->pl_04->CurrentValue));
            if ($curVal != "") {
                $this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
            } else {
                $this->pl_04->ViewValue = $this->pl_04->Lookup !== null && is_array($this->pl_04->lookupOptions()) && count($this->pl_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pl_04->ViewValue !== null) { // Load from cache
                $this->pl_04->EditValue = array_values($this->pl_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pl_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pl_04->CurrentValue, $this->pl_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pl_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pl_04->EditValue = $arwrk;
            }
            $this->pl_04->PlaceHolder = RemoveHtml($this->pl_04->caption());

            // qty_pl_04
            $this->qty_pl_04->setupEditAttributes();
            $this->qty_pl_04->EditValue = $this->qty_pl_04->CurrentValue;
            $this->qty_pl_04->PlaceHolder = RemoveHtml($this->qty_pl_04->caption());
            if (strval($this->qty_pl_04->EditValue) != "" && is_numeric($this->qty_pl_04->EditValue)) {
                $this->qty_pl_04->EditValue = FormatNumber($this->qty_pl_04->EditValue, null);
            }

            // pa_01
            $this->pa_01->setupEditAttributes();
            if (!$this->pa_01->Raw) {
                $this->pa_01->CurrentValue = HtmlDecode($this->pa_01->CurrentValue);
            }
            $this->pa_01->EditValue = HtmlEncode($this->pa_01->CurrentValue);
            $curVal = strval($this->pa_01->CurrentValue);
            if ($curVal != "") {
                $this->pa_01->EditValue = $this->pa_01->lookupCacheOption($curVal);
                if ($this->pa_01->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_01->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_01->EditValue = $this->pa_01->displayValue($arwrk);
                    } else {
                        $this->pa_01->EditValue = HtmlEncode($this->pa_01->CurrentValue);
                    }
                }
            } else {
                $this->pa_01->EditValue = null;
            }
            $this->pa_01->PlaceHolder = RemoveHtml($this->pa_01->caption());

            // qty_pa_01
            $this->qty_pa_01->setupEditAttributes();
            $this->qty_pa_01->EditValue = $this->qty_pa_01->CurrentValue;
            $this->qty_pa_01->PlaceHolder = RemoveHtml($this->qty_pa_01->caption());
            if (strval($this->qty_pa_01->EditValue) != "" && is_numeric($this->qty_pa_01->EditValue)) {
                $this->qty_pa_01->EditValue = FormatNumber($this->qty_pa_01->EditValue, null);
            }

            // pa_02
            $this->pa_02->setupEditAttributes();
            if (!$this->pa_02->Raw) {
                $this->pa_02->CurrentValue = HtmlDecode($this->pa_02->CurrentValue);
            }
            $this->pa_02->EditValue = HtmlEncode($this->pa_02->CurrentValue);
            $curVal = strval($this->pa_02->CurrentValue);
            if ($curVal != "") {
                $this->pa_02->EditValue = $this->pa_02->lookupCacheOption($curVal);
                if ($this->pa_02->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_02->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_02->EditValue = $this->pa_02->displayValue($arwrk);
                    } else {
                        $this->pa_02->EditValue = HtmlEncode($this->pa_02->CurrentValue);
                    }
                }
            } else {
                $this->pa_02->EditValue = null;
            }
            $this->pa_02->PlaceHolder = RemoveHtml($this->pa_02->caption());

            // qty_pa_02
            $this->qty_pa_02->setupEditAttributes();
            $this->qty_pa_02->EditValue = $this->qty_pa_02->CurrentValue;
            $this->qty_pa_02->PlaceHolder = RemoveHtml($this->qty_pa_02->caption());
            if (strval($this->qty_pa_02->EditValue) != "" && is_numeric($this->qty_pa_02->EditValue)) {
                $this->qty_pa_02->EditValue = FormatNumber($this->qty_pa_02->EditValue, null);
            }

            // pa_03
            $this->pa_03->setupEditAttributes();
            if (!$this->pa_03->Raw) {
                $this->pa_03->CurrentValue = HtmlDecode($this->pa_03->CurrentValue);
            }
            $this->pa_03->EditValue = HtmlEncode($this->pa_03->CurrentValue);
            $curVal = strval($this->pa_03->CurrentValue);
            if ($curVal != "") {
                $this->pa_03->EditValue = $this->pa_03->lookupCacheOption($curVal);
                if ($this->pa_03->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_03->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_03->EditValue = $this->pa_03->displayValue($arwrk);
                    } else {
                        $this->pa_03->EditValue = HtmlEncode($this->pa_03->CurrentValue);
                    }
                }
            } else {
                $this->pa_03->EditValue = null;
            }
            $this->pa_03->PlaceHolder = RemoveHtml($this->pa_03->caption());

            // qty_pa_03
            $this->qty_pa_03->setupEditAttributes();
            $this->qty_pa_03->EditValue = $this->qty_pa_03->CurrentValue;
            $this->qty_pa_03->PlaceHolder = RemoveHtml($this->qty_pa_03->caption());
            if (strval($this->qty_pa_03->EditValue) != "" && is_numeric($this->qty_pa_03->EditValue)) {
                $this->qty_pa_03->EditValue = FormatNumber($this->qty_pa_03->EditValue, null);
            }

            // pa_04
            $this->pa_04->setupEditAttributes();
            if (!$this->pa_04->Raw) {
                $this->pa_04->CurrentValue = HtmlDecode($this->pa_04->CurrentValue);
            }
            $this->pa_04->EditValue = HtmlEncode($this->pa_04->CurrentValue);
            $curVal = strval($this->pa_04->CurrentValue);
            if ($curVal != "") {
                $this->pa_04->EditValue = $this->pa_04->lookupCacheOption($curVal);
                if ($this->pa_04->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_04->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_04->EditValue = $this->pa_04->displayValue($arwrk);
                    } else {
                        $this->pa_04->EditValue = HtmlEncode($this->pa_04->CurrentValue);
                    }
                }
            } else {
                $this->pa_04->EditValue = null;
            }
            $this->pa_04->PlaceHolder = RemoveHtml($this->pa_04->caption());

            // qty_pa_04
            $this->qty_pa_04->setupEditAttributes();
            $this->qty_pa_04->EditValue = $this->qty_pa_04->CurrentValue;
            $this->qty_pa_04->PlaceHolder = RemoveHtml($this->qty_pa_04->caption());
            if (strval($this->qty_pa_04->EditValue) != "" && is_numeric($this->qty_pa_04->EditValue)) {
                $this->qty_pa_04->EditValue = FormatNumber($this->qty_pa_04->EditValue, null);
            }

            // pa_05
            $this->pa_05->setupEditAttributes();
            if (!$this->pa_05->Raw) {
                $this->pa_05->CurrentValue = HtmlDecode($this->pa_05->CurrentValue);
            }
            $this->pa_05->EditValue = HtmlEncode($this->pa_05->CurrentValue);
            $curVal = strval($this->pa_05->CurrentValue);
            if ($curVal != "") {
                $this->pa_05->EditValue = $this->pa_05->lookupCacheOption($curVal);
                if ($this->pa_05->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pa_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->pa_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->pa_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pa_05->Lookup->renderViewRow($rswrk[0]);
                        $this->pa_05->EditValue = $this->pa_05->displayValue($arwrk);
                    } else {
                        $this->pa_05->EditValue = HtmlEncode($this->pa_05->CurrentValue);
                    }
                }
            } else {
                $this->pa_05->EditValue = null;
            }
            $this->pa_05->PlaceHolder = RemoveHtml($this->pa_05->caption());

            // qty_pa_05
            $this->qty_pa_05->setupEditAttributes();
            $this->qty_pa_05->EditValue = $this->qty_pa_05->CurrentValue;
            $this->qty_pa_05->PlaceHolder = RemoveHtml($this->qty_pa_05->caption());
            if (strval($this->qty_pa_05->EditValue) != "" && is_numeric($this->qty_pa_05->EditValue)) {
                $this->qty_pa_05->EditValue = FormatNumber($this->qty_pa_05->EditValue, null);
            }

            // pc_01
            $this->pc_01->setupEditAttributes();
            $curVal = trim(strval($this->pc_01->CurrentValue));
            if ($curVal != "") {
                $this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
            } else {
                $this->pc_01->ViewValue = $this->pc_01->Lookup !== null && is_array($this->pc_01->lookupOptions()) && count($this->pc_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pc_01->ViewValue !== null) { // Load from cache
                $this->pc_01->EditValue = array_values($this->pc_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pc_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pc_01->CurrentValue, $this->pc_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pc_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pc_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pc_01->EditValue = $arwrk;
            }
            $this->pc_01->PlaceHolder = RemoveHtml($this->pc_01->caption());

            // qty_pc_01
            $this->qty_pc_01->setupEditAttributes();
            $this->qty_pc_01->EditValue = $this->qty_pc_01->CurrentValue;
            $this->qty_pc_01->PlaceHolder = RemoveHtml($this->qty_pc_01->caption());
            if (strval($this->qty_pc_01->EditValue) != "" && is_numeric($this->qty_pc_01->EditValue)) {
                $this->qty_pc_01->EditValue = FormatNumber($this->qty_pc_01->EditValue, null);
            }

            // pc_02
            $this->pc_02->setupEditAttributes();
            $curVal = trim(strval($this->pc_02->CurrentValue));
            if ($curVal != "") {
                $this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
            } else {
                $this->pc_02->ViewValue = $this->pc_02->Lookup !== null && is_array($this->pc_02->lookupOptions()) && count($this->pc_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->pc_02->ViewValue !== null) { // Load from cache
                $this->pc_02->EditValue = array_values($this->pc_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->pc_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->pc_02->CurrentValue, $this->pc_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->pc_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pc_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->pc_02->EditValue = $arwrk;
            }
            $this->pc_02->PlaceHolder = RemoveHtml($this->pc_02->caption());

            // qty_pc_02
            $this->qty_pc_02->setupEditAttributes();
            $this->qty_pc_02->EditValue = $this->qty_pc_02->CurrentValue;
            $this->qty_pc_02->PlaceHolder = RemoveHtml($this->qty_pc_02->caption());
            if (strval($this->qty_pc_02->EditValue) != "" && is_numeric($this->qty_pc_02->EditValue)) {
                $this->qty_pc_02->EditValue = FormatNumber($this->qty_pc_02->EditValue, null);
            }

            // o_01
            $this->o_01->setupEditAttributes();
            $curVal = trim(strval($this->o_01->CurrentValue));
            if ($curVal != "") {
                $this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
            } else {
                $this->o_01->ViewValue = $this->o_01->Lookup !== null && is_array($this->o_01->lookupOptions()) && count($this->o_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->o_01->ViewValue !== null) { // Load from cache
                $this->o_01->EditValue = array_values($this->o_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->o_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->o_01->CurrentValue, $this->o_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->o_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->o_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->o_01->EditValue = $arwrk;
            }
            $this->o_01->PlaceHolder = RemoveHtml($this->o_01->caption());

            // qty_o_01
            $this->qty_o_01->setupEditAttributes();
            $this->qty_o_01->EditValue = $this->qty_o_01->CurrentValue;
            $this->qty_o_01->PlaceHolder = RemoveHtml($this->qty_o_01->caption());
            if (strval($this->qty_o_01->EditValue) != "" && is_numeric($this->qty_o_01->EditValue)) {
                $this->qty_o_01->EditValue = FormatNumber($this->qty_o_01->EditValue, null);
            }

            // lamination_type
            $this->lamination_type->setupEditAttributes();
            $curVal = trim(strval($this->lamination_type->CurrentValue));
            if ($curVal != "") {
                $this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
            } else {
                $this->lamination_type->ViewValue = $this->lamination_type->Lookup !== null && is_array($this->lamination_type->lookupOptions()) && count($this->lamination_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->lamination_type->ViewValue !== null) { // Load from cache
                $this->lamination_type->EditValue = array_values($this->lamination_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->lamination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->lamination_type->CurrentValue, $this->lamination_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->lamination_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->lamination_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->lamination_type->EditValue = $arwrk;
            }
            $this->lamination_type->PlaceHolder = RemoveHtml($this->lamination_type->caption());

            // lamination_qty
            $this->lamination_qty->setupEditAttributes();
            $this->lamination_qty->EditValue = $this->lamination_qty->CurrentValue;
            $this->lamination_qty->PlaceHolder = RemoveHtml($this->lamination_qty->caption());
            if (strval($this->lamination_qty->EditValue) != "" && is_numeric($this->lamination_qty->EditValue)) {
                $this->lamination_qty->EditValue = FormatNumber($this->lamination_qty->EditValue, null);
            }

            // die_type
            $this->die_type->setupEditAttributes();
            $curVal = trim(strval($this->die_type->CurrentValue));
            if ($curVal != "") {
                $this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
            } else {
                $this->die_type->ViewValue = $this->die_type->Lookup !== null && is_array($this->die_type->lookupOptions()) && count($this->die_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->die_type->ViewValue !== null) { // Load from cache
                $this->die_type->EditValue = array_values($this->die_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->die_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->die_type->CurrentValue, $this->die_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->die_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->die_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->die_type->EditValue = $arwrk;
            }
            $this->die_type->PlaceHolder = RemoveHtml($this->die_type->caption());

            // die_qty
            $this->die_qty->setupEditAttributes();
            $this->die_qty->EditValue = $this->die_qty->CurrentValue;
            $this->die_qty->PlaceHolder = RemoveHtml($this->die_qty->caption());
            if (strval($this->die_qty->EditValue) != "" && is_numeric($this->die_qty->EditValue)) {
                $this->die_qty->EditValue = FormatNumber($this->die_qty->EditValue, null);
            }

            // binding_type
            $this->binding_type->setupEditAttributes();
            $curVal = trim(strval($this->binding_type->CurrentValue));
            if ($curVal != "") {
                $this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
            } else {
                $this->binding_type->ViewValue = $this->binding_type->Lookup !== null && is_array($this->binding_type->lookupOptions()) && count($this->binding_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->binding_type->ViewValue !== null) { // Load from cache
                $this->binding_type->EditValue = array_values($this->binding_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->binding_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->binding_type->CurrentValue, $this->binding_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->binding_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->binding_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->binding_type->EditValue = $arwrk;
            }
            $this->binding_type->PlaceHolder = RemoveHtml($this->binding_type->caption());

            // binding_qty
            $this->binding_qty->setupEditAttributes();
            $this->binding_qty->EditValue = $this->binding_qty->CurrentValue;
            $this->binding_qty->PlaceHolder = RemoveHtml($this->binding_qty->caption());
            if (strval($this->binding_qty->EditValue) != "" && is_numeric($this->binding_qty->EditValue)) {
                $this->binding_qty->EditValue = FormatNumber($this->binding_qty->EditValue, null);
            }

            // number_type
            $this->number_type->setupEditAttributes();
            $curVal = trim(strval($this->number_type->CurrentValue));
            if ($curVal != "") {
                $this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
            } else {
                $this->number_type->ViewValue = $this->number_type->Lookup !== null && is_array($this->number_type->lookupOptions()) && count($this->number_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->number_type->ViewValue !== null) { // Load from cache
                $this->number_type->EditValue = array_values($this->number_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->number_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->number_type->CurrentValue, $this->number_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->number_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->number_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->number_type->EditValue = $arwrk;
            }
            $this->number_type->PlaceHolder = RemoveHtml($this->number_type->caption());

            // number_qty
            $this->number_qty->setupEditAttributes();
            $this->number_qty->EditValue = $this->number_qty->CurrentValue;
            $this->number_qty->PlaceHolder = RemoveHtml($this->number_qty->caption());
            if (strval($this->number_qty->EditValue) != "" && is_numeric($this->number_qty->EditValue)) {
                $this->number_qty->EditValue = FormatNumber($this->number_qty->EditValue, null);
            }

            // de_01
            $this->de_01->setupEditAttributes();
            $curVal = trim(strval($this->de_01->CurrentValue));
            if ($curVal != "") {
                $this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
            } else {
                $this->de_01->ViewValue = $this->de_01->Lookup !== null && is_array($this->de_01->lookupOptions()) && count($this->de_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->de_01->ViewValue !== null) { // Load from cache
                $this->de_01->EditValue = array_values($this->de_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->de_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->de_01->CurrentValue, $this->de_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->de_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->de_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->de_01->EditValue = $arwrk;
            }
            $this->de_01->PlaceHolder = RemoveHtml($this->de_01->caption());

            // qty_de_01
            $this->qty_de_01->setupEditAttributes();
            $this->qty_de_01->EditValue = $this->qty_de_01->CurrentValue;
            $this->qty_de_01->PlaceHolder = RemoveHtml($this->qty_de_01->caption());
            if (strval($this->qty_de_01->EditValue) != "" && is_numeric($this->qty_de_01->EditValue)) {
                $this->qty_de_01->EditValue = FormatNumber($this->qty_de_01->EditValue, null);
            }

            // de_02
            $this->de_02->setupEditAttributes();
            $curVal = trim(strval($this->de_02->CurrentValue));
            if ($curVal != "") {
                $this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
            } else {
                $this->de_02->ViewValue = $this->de_02->Lookup !== null && is_array($this->de_02->lookupOptions()) && count($this->de_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->de_02->ViewValue !== null) { // Load from cache
                $this->de_02->EditValue = array_values($this->de_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->de_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->de_02->CurrentValue, $this->de_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->de_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->de_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->de_02->EditValue = $arwrk;
            }
            $this->de_02->PlaceHolder = RemoveHtml($this->de_02->caption());

            // qty_de_02
            $this->qty_de_02->setupEditAttributes();
            $this->qty_de_02->EditValue = $this->qty_de_02->CurrentValue;
            $this->qty_de_02->PlaceHolder = RemoveHtml($this->qty_de_02->caption());
            if (strval($this->qty_de_02->EditValue) != "" && is_numeric($this->qty_de_02->EditValue)) {
                $this->qty_de_02->EditValue = FormatNumber($this->qty_de_02->EditValue, null);
            }

            // de_03
            $this->de_03->setupEditAttributes();
            $curVal = trim(strval($this->de_03->CurrentValue));
            if ($curVal != "") {
                $this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
            } else {
                $this->de_03->ViewValue = $this->de_03->Lookup !== null && is_array($this->de_03->lookupOptions()) && count($this->de_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->de_03->ViewValue !== null) { // Load from cache
                $this->de_03->EditValue = array_values($this->de_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->de_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->de_03->CurrentValue, $this->de_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->de_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->de_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->de_03->EditValue = $arwrk;
            }
            $this->de_03->PlaceHolder = RemoveHtml($this->de_03->caption());

            // qty_de_03
            $this->qty_de_03->setupEditAttributes();
            $this->qty_de_03->EditValue = $this->qty_de_03->CurrentValue;
            $this->qty_de_03->PlaceHolder = RemoveHtml($this->qty_de_03->caption());
            if (strval($this->qty_de_03->EditValue) != "" && is_numeric($this->qty_de_03->EditValue)) {
                $this->qty_de_03->EditValue = FormatNumber($this->qty_de_03->EditValue, null);
            }

            // operator

            // datetime

            // Add refer script

            // job_type
            $this->job_type->HrefValue = "";

            // job_category
            $this->job_category->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // description
            $this->description->HrefValue = "";

            // size
            $this->size->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // pages
            $this->pages->HrefValue = "";

            // paper
            $this->paper->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // pr_01
            $this->pr_01->HrefValue = "";

            // qty_pr_01
            $this->qty_pr_01->HrefValue = "";

            // pl_01
            $this->pl_01->HrefValue = "";

            // qty_pl_01
            $this->qty_pl_01->HrefValue = "";

            // pr_02
            $this->pr_02->HrefValue = "";

            // qty_pr_02
            $this->qty_pr_02->HrefValue = "";

            // pl_02
            $this->pl_02->HrefValue = "";

            // qty_pl_02
            $this->qty_pl_02->HrefValue = "";

            // pr_03
            $this->pr_03->HrefValue = "";

            // qty_pr_03
            $this->qty_pr_03->HrefValue = "";

            // pl_03
            $this->pl_03->HrefValue = "";

            // qty_pl_03
            $this->qty_pl_03->HrefValue = "";

            // pr_04
            $this->pr_04->HrefValue = "";

            // qty_pr_04
            $this->qty_pr_04->HrefValue = "";

            // pl_04
            $this->pl_04->HrefValue = "";

            // qty_pl_04
            $this->qty_pl_04->HrefValue = "";

            // pa_01
            $this->pa_01->HrefValue = "";

            // qty_pa_01
            $this->qty_pa_01->HrefValue = "";

            // pa_02
            $this->pa_02->HrefValue = "";

            // qty_pa_02
            $this->qty_pa_02->HrefValue = "";

            // pa_03
            $this->pa_03->HrefValue = "";

            // qty_pa_03
            $this->qty_pa_03->HrefValue = "";

            // pa_04
            $this->pa_04->HrefValue = "";

            // qty_pa_04
            $this->qty_pa_04->HrefValue = "";

            // pa_05
            $this->pa_05->HrefValue = "";

            // qty_pa_05
            $this->qty_pa_05->HrefValue = "";

            // pc_01
            $this->pc_01->HrefValue = "";

            // qty_pc_01
            $this->qty_pc_01->HrefValue = "";

            // pc_02
            $this->pc_02->HrefValue = "";

            // qty_pc_02
            $this->qty_pc_02->HrefValue = "";

            // o_01
            $this->o_01->HrefValue = "";

            // qty_o_01
            $this->qty_o_01->HrefValue = "";

            // lamination_type
            $this->lamination_type->HrefValue = "";

            // lamination_qty
            $this->lamination_qty->HrefValue = "";

            // die_type
            $this->die_type->HrefValue = "";

            // die_qty
            $this->die_qty->HrefValue = "";

            // binding_type
            $this->binding_type->HrefValue = "";

            // binding_qty
            $this->binding_qty->HrefValue = "";

            // number_type
            $this->number_type->HrefValue = "";

            // number_qty
            $this->number_qty->HrefValue = "";

            // de_01
            $this->de_01->HrefValue = "";

            // qty_de_01
            $this->qty_de_01->HrefValue = "";

            // de_02
            $this->de_02->HrefValue = "";

            // qty_de_02
            $this->qty_de_02->HrefValue = "";

            // de_03
            $this->de_03->HrefValue = "";

            // qty_de_03
            $this->qty_de_03->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->job_type->Visible && $this->job_type->Required) {
                if ($this->job_type->FormValue == "") {
                    $this->job_type->addErrorMessage(str_replace("%s", $this->job_type->caption(), $this->job_type->RequiredErrorMessage));
                }
            }
            if ($this->job_category->Visible && $this->job_category->Required) {
                if ($this->job_category->FormValue == "") {
                    $this->job_category->addErrorMessage(str_replace("%s", $this->job_category->caption(), $this->job_category->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->company_id->FormValue)) {
                $this->company_id->addErrorMessage($this->company_id->getErrorMessage(false));
            }
            if ($this->description->Visible && $this->description->Required) {
                if (!$this->description->IsDetailKey && EmptyValue($this->description->FormValue)) {
                    $this->description->addErrorMessage(str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
                }
            }
            if ($this->size->Visible && $this->size->Required) {
                if (!$this->size->IsDetailKey && EmptyValue($this->size->FormValue)) {
                    $this->size->addErrorMessage(str_replace("%s", $this->size->caption(), $this->size->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->pages->Visible && $this->pages->Required) {
                if (!$this->pages->IsDetailKey && EmptyValue($this->pages->FormValue)) {
                    $this->pages->addErrorMessage(str_replace("%s", $this->pages->caption(), $this->pages->RequiredErrorMessage));
                }
            }
            if ($this->paper->Visible && $this->paper->Required) {
                if (!$this->paper->IsDetailKey && EmptyValue($this->paper->FormValue)) {
                    $this->paper->addErrorMessage(str_replace("%s", $this->paper->caption(), $this->paper->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->paper->FormValue)) {
                $this->paper->addErrorMessage($this->paper->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->pr_01->Visible && $this->pr_01->Required) {
                if (!$this->pr_01->IsDetailKey && EmptyValue($this->pr_01->FormValue)) {
                    $this->pr_01->addErrorMessage(str_replace("%s", $this->pr_01->caption(), $this->pr_01->RequiredErrorMessage));
                }
            }
            if ($this->qty_pr_01->Visible && $this->qty_pr_01->Required) {
                if (!$this->qty_pr_01->IsDetailKey && EmptyValue($this->qty_pr_01->FormValue)) {
                    $this->qty_pr_01->addErrorMessage(str_replace("%s", $this->qty_pr_01->caption(), $this->qty_pr_01->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pr_01->FormValue)) {
                $this->qty_pr_01->addErrorMessage($this->qty_pr_01->getErrorMessage(false));
            }
            if ($this->pl_01->Visible && $this->pl_01->Required) {
                if (!$this->pl_01->IsDetailKey && EmptyValue($this->pl_01->FormValue)) {
                    $this->pl_01->addErrorMessage(str_replace("%s", $this->pl_01->caption(), $this->pl_01->RequiredErrorMessage));
                }
            }
            if ($this->qty_pl_01->Visible && $this->qty_pl_01->Required) {
                if (!$this->qty_pl_01->IsDetailKey && EmptyValue($this->qty_pl_01->FormValue)) {
                    $this->qty_pl_01->addErrorMessage(str_replace("%s", $this->qty_pl_01->caption(), $this->qty_pl_01->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pl_01->FormValue)) {
                $this->qty_pl_01->addErrorMessage($this->qty_pl_01->getErrorMessage(false));
            }
            if ($this->pr_02->Visible && $this->pr_02->Required) {
                if (!$this->pr_02->IsDetailKey && EmptyValue($this->pr_02->FormValue)) {
                    $this->pr_02->addErrorMessage(str_replace("%s", $this->pr_02->caption(), $this->pr_02->RequiredErrorMessage));
                }
            }
            if ($this->qty_pr_02->Visible && $this->qty_pr_02->Required) {
                if (!$this->qty_pr_02->IsDetailKey && EmptyValue($this->qty_pr_02->FormValue)) {
                    $this->qty_pr_02->addErrorMessage(str_replace("%s", $this->qty_pr_02->caption(), $this->qty_pr_02->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pr_02->FormValue)) {
                $this->qty_pr_02->addErrorMessage($this->qty_pr_02->getErrorMessage(false));
            }
            if ($this->pl_02->Visible && $this->pl_02->Required) {
                if (!$this->pl_02->IsDetailKey && EmptyValue($this->pl_02->FormValue)) {
                    $this->pl_02->addErrorMessage(str_replace("%s", $this->pl_02->caption(), $this->pl_02->RequiredErrorMessage));
                }
            }
            if ($this->qty_pl_02->Visible && $this->qty_pl_02->Required) {
                if (!$this->qty_pl_02->IsDetailKey && EmptyValue($this->qty_pl_02->FormValue)) {
                    $this->qty_pl_02->addErrorMessage(str_replace("%s", $this->qty_pl_02->caption(), $this->qty_pl_02->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pl_02->FormValue)) {
                $this->qty_pl_02->addErrorMessage($this->qty_pl_02->getErrorMessage(false));
            }
            if ($this->pr_03->Visible && $this->pr_03->Required) {
                if (!$this->pr_03->IsDetailKey && EmptyValue($this->pr_03->FormValue)) {
                    $this->pr_03->addErrorMessage(str_replace("%s", $this->pr_03->caption(), $this->pr_03->RequiredErrorMessage));
                }
            }
            if ($this->qty_pr_03->Visible && $this->qty_pr_03->Required) {
                if (!$this->qty_pr_03->IsDetailKey && EmptyValue($this->qty_pr_03->FormValue)) {
                    $this->qty_pr_03->addErrorMessage(str_replace("%s", $this->qty_pr_03->caption(), $this->qty_pr_03->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pr_03->FormValue)) {
                $this->qty_pr_03->addErrorMessage($this->qty_pr_03->getErrorMessage(false));
            }
            if ($this->pl_03->Visible && $this->pl_03->Required) {
                if (!$this->pl_03->IsDetailKey && EmptyValue($this->pl_03->FormValue)) {
                    $this->pl_03->addErrorMessage(str_replace("%s", $this->pl_03->caption(), $this->pl_03->RequiredErrorMessage));
                }
            }
            if ($this->qty_pl_03->Visible && $this->qty_pl_03->Required) {
                if (!$this->qty_pl_03->IsDetailKey && EmptyValue($this->qty_pl_03->FormValue)) {
                    $this->qty_pl_03->addErrorMessage(str_replace("%s", $this->qty_pl_03->caption(), $this->qty_pl_03->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pl_03->FormValue)) {
                $this->qty_pl_03->addErrorMessage($this->qty_pl_03->getErrorMessage(false));
            }
            if ($this->pr_04->Visible && $this->pr_04->Required) {
                if (!$this->pr_04->IsDetailKey && EmptyValue($this->pr_04->FormValue)) {
                    $this->pr_04->addErrorMessage(str_replace("%s", $this->pr_04->caption(), $this->pr_04->RequiredErrorMessage));
                }
            }
            if ($this->qty_pr_04->Visible && $this->qty_pr_04->Required) {
                if (!$this->qty_pr_04->IsDetailKey && EmptyValue($this->qty_pr_04->FormValue)) {
                    $this->qty_pr_04->addErrorMessage(str_replace("%s", $this->qty_pr_04->caption(), $this->qty_pr_04->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pr_04->FormValue)) {
                $this->qty_pr_04->addErrorMessage($this->qty_pr_04->getErrorMessage(false));
            }
            if ($this->pl_04->Visible && $this->pl_04->Required) {
                if (!$this->pl_04->IsDetailKey && EmptyValue($this->pl_04->FormValue)) {
                    $this->pl_04->addErrorMessage(str_replace("%s", $this->pl_04->caption(), $this->pl_04->RequiredErrorMessage));
                }
            }
            if ($this->qty_pl_04->Visible && $this->qty_pl_04->Required) {
                if (!$this->qty_pl_04->IsDetailKey && EmptyValue($this->qty_pl_04->FormValue)) {
                    $this->qty_pl_04->addErrorMessage(str_replace("%s", $this->qty_pl_04->caption(), $this->qty_pl_04->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pl_04->FormValue)) {
                $this->qty_pl_04->addErrorMessage($this->qty_pl_04->getErrorMessage(false));
            }
            if ($this->pa_01->Visible && $this->pa_01->Required) {
                if (!$this->pa_01->IsDetailKey && EmptyValue($this->pa_01->FormValue)) {
                    $this->pa_01->addErrorMessage(str_replace("%s", $this->pa_01->caption(), $this->pa_01->RequiredErrorMessage));
                }
            }
            if ($this->qty_pa_01->Visible && $this->qty_pa_01->Required) {
                if (!$this->qty_pa_01->IsDetailKey && EmptyValue($this->qty_pa_01->FormValue)) {
                    $this->qty_pa_01->addErrorMessage(str_replace("%s", $this->qty_pa_01->caption(), $this->qty_pa_01->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pa_01->FormValue)) {
                $this->qty_pa_01->addErrorMessage($this->qty_pa_01->getErrorMessage(false));
            }
            if ($this->pa_02->Visible && $this->pa_02->Required) {
                if (!$this->pa_02->IsDetailKey && EmptyValue($this->pa_02->FormValue)) {
                    $this->pa_02->addErrorMessage(str_replace("%s", $this->pa_02->caption(), $this->pa_02->RequiredErrorMessage));
                }
            }
            if ($this->qty_pa_02->Visible && $this->qty_pa_02->Required) {
                if (!$this->qty_pa_02->IsDetailKey && EmptyValue($this->qty_pa_02->FormValue)) {
                    $this->qty_pa_02->addErrorMessage(str_replace("%s", $this->qty_pa_02->caption(), $this->qty_pa_02->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pa_02->FormValue)) {
                $this->qty_pa_02->addErrorMessage($this->qty_pa_02->getErrorMessage(false));
            }
            if ($this->pa_03->Visible && $this->pa_03->Required) {
                if (!$this->pa_03->IsDetailKey && EmptyValue($this->pa_03->FormValue)) {
                    $this->pa_03->addErrorMessage(str_replace("%s", $this->pa_03->caption(), $this->pa_03->RequiredErrorMessage));
                }
            }
            if ($this->qty_pa_03->Visible && $this->qty_pa_03->Required) {
                if (!$this->qty_pa_03->IsDetailKey && EmptyValue($this->qty_pa_03->FormValue)) {
                    $this->qty_pa_03->addErrorMessage(str_replace("%s", $this->qty_pa_03->caption(), $this->qty_pa_03->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pa_03->FormValue)) {
                $this->qty_pa_03->addErrorMessage($this->qty_pa_03->getErrorMessage(false));
            }
            if ($this->pa_04->Visible && $this->pa_04->Required) {
                if (!$this->pa_04->IsDetailKey && EmptyValue($this->pa_04->FormValue)) {
                    $this->pa_04->addErrorMessage(str_replace("%s", $this->pa_04->caption(), $this->pa_04->RequiredErrorMessage));
                }
            }
            if ($this->qty_pa_04->Visible && $this->qty_pa_04->Required) {
                if (!$this->qty_pa_04->IsDetailKey && EmptyValue($this->qty_pa_04->FormValue)) {
                    $this->qty_pa_04->addErrorMessage(str_replace("%s", $this->qty_pa_04->caption(), $this->qty_pa_04->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pa_04->FormValue)) {
                $this->qty_pa_04->addErrorMessage($this->qty_pa_04->getErrorMessage(false));
            }
            if ($this->pa_05->Visible && $this->pa_05->Required) {
                if (!$this->pa_05->IsDetailKey && EmptyValue($this->pa_05->FormValue)) {
                    $this->pa_05->addErrorMessage(str_replace("%s", $this->pa_05->caption(), $this->pa_05->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->pa_05->FormValue)) {
                $this->pa_05->addErrorMessage($this->pa_05->getErrorMessage(false));
            }
            if ($this->qty_pa_05->Visible && $this->qty_pa_05->Required) {
                if (!$this->qty_pa_05->IsDetailKey && EmptyValue($this->qty_pa_05->FormValue)) {
                    $this->qty_pa_05->addErrorMessage(str_replace("%s", $this->qty_pa_05->caption(), $this->qty_pa_05->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pa_05->FormValue)) {
                $this->qty_pa_05->addErrorMessage($this->qty_pa_05->getErrorMessage(false));
            }
            if ($this->pc_01->Visible && $this->pc_01->Required) {
                if (!$this->pc_01->IsDetailKey && EmptyValue($this->pc_01->FormValue)) {
                    $this->pc_01->addErrorMessage(str_replace("%s", $this->pc_01->caption(), $this->pc_01->RequiredErrorMessage));
                }
            }
            if ($this->qty_pc_01->Visible && $this->qty_pc_01->Required) {
                if (!$this->qty_pc_01->IsDetailKey && EmptyValue($this->qty_pc_01->FormValue)) {
                    $this->qty_pc_01->addErrorMessage(str_replace("%s", $this->qty_pc_01->caption(), $this->qty_pc_01->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pc_01->FormValue)) {
                $this->qty_pc_01->addErrorMessage($this->qty_pc_01->getErrorMessage(false));
            }
            if ($this->pc_02->Visible && $this->pc_02->Required) {
                if (!$this->pc_02->IsDetailKey && EmptyValue($this->pc_02->FormValue)) {
                    $this->pc_02->addErrorMessage(str_replace("%s", $this->pc_02->caption(), $this->pc_02->RequiredErrorMessage));
                }
            }
            if ($this->qty_pc_02->Visible && $this->qty_pc_02->Required) {
                if (!$this->qty_pc_02->IsDetailKey && EmptyValue($this->qty_pc_02->FormValue)) {
                    $this->qty_pc_02->addErrorMessage(str_replace("%s", $this->qty_pc_02->caption(), $this->qty_pc_02->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_pc_02->FormValue)) {
                $this->qty_pc_02->addErrorMessage($this->qty_pc_02->getErrorMessage(false));
            }
            if ($this->o_01->Visible && $this->o_01->Required) {
                if (!$this->o_01->IsDetailKey && EmptyValue($this->o_01->FormValue)) {
                    $this->o_01->addErrorMessage(str_replace("%s", $this->o_01->caption(), $this->o_01->RequiredErrorMessage));
                }
            }
            if ($this->qty_o_01->Visible && $this->qty_o_01->Required) {
                if (!$this->qty_o_01->IsDetailKey && EmptyValue($this->qty_o_01->FormValue)) {
                    $this->qty_o_01->addErrorMessage(str_replace("%s", $this->qty_o_01->caption(), $this->qty_o_01->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_o_01->FormValue)) {
                $this->qty_o_01->addErrorMessage($this->qty_o_01->getErrorMessage(false));
            }
            if ($this->lamination_type->Visible && $this->lamination_type->Required) {
                if (!$this->lamination_type->IsDetailKey && EmptyValue($this->lamination_type->FormValue)) {
                    $this->lamination_type->addErrorMessage(str_replace("%s", $this->lamination_type->caption(), $this->lamination_type->RequiredErrorMessage));
                }
            }
            if ($this->lamination_qty->Visible && $this->lamination_qty->Required) {
                if (!$this->lamination_qty->IsDetailKey && EmptyValue($this->lamination_qty->FormValue)) {
                    $this->lamination_qty->addErrorMessage(str_replace("%s", $this->lamination_qty->caption(), $this->lamination_qty->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->lamination_qty->FormValue)) {
                $this->lamination_qty->addErrorMessage($this->lamination_qty->getErrorMessage(false));
            }
            if ($this->die_type->Visible && $this->die_type->Required) {
                if (!$this->die_type->IsDetailKey && EmptyValue($this->die_type->FormValue)) {
                    $this->die_type->addErrorMessage(str_replace("%s", $this->die_type->caption(), $this->die_type->RequiredErrorMessage));
                }
            }
            if ($this->die_qty->Visible && $this->die_qty->Required) {
                if (!$this->die_qty->IsDetailKey && EmptyValue($this->die_qty->FormValue)) {
                    $this->die_qty->addErrorMessage(str_replace("%s", $this->die_qty->caption(), $this->die_qty->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->die_qty->FormValue)) {
                $this->die_qty->addErrorMessage($this->die_qty->getErrorMessage(false));
            }
            if ($this->binding_type->Visible && $this->binding_type->Required) {
                if (!$this->binding_type->IsDetailKey && EmptyValue($this->binding_type->FormValue)) {
                    $this->binding_type->addErrorMessage(str_replace("%s", $this->binding_type->caption(), $this->binding_type->RequiredErrorMessage));
                }
            }
            if ($this->binding_qty->Visible && $this->binding_qty->Required) {
                if (!$this->binding_qty->IsDetailKey && EmptyValue($this->binding_qty->FormValue)) {
                    $this->binding_qty->addErrorMessage(str_replace("%s", $this->binding_qty->caption(), $this->binding_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->binding_qty->FormValue)) {
                $this->binding_qty->addErrorMessage($this->binding_qty->getErrorMessage(false));
            }
            if ($this->number_type->Visible && $this->number_type->Required) {
                if (!$this->number_type->IsDetailKey && EmptyValue($this->number_type->FormValue)) {
                    $this->number_type->addErrorMessage(str_replace("%s", $this->number_type->caption(), $this->number_type->RequiredErrorMessage));
                }
            }
            if ($this->number_qty->Visible && $this->number_qty->Required) {
                if (!$this->number_qty->IsDetailKey && EmptyValue($this->number_qty->FormValue)) {
                    $this->number_qty->addErrorMessage(str_replace("%s", $this->number_qty->caption(), $this->number_qty->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->number_qty->FormValue)) {
                $this->number_qty->addErrorMessage($this->number_qty->getErrorMessage(false));
            }
            if ($this->de_01->Visible && $this->de_01->Required) {
                if (!$this->de_01->IsDetailKey && EmptyValue($this->de_01->FormValue)) {
                    $this->de_01->addErrorMessage(str_replace("%s", $this->de_01->caption(), $this->de_01->RequiredErrorMessage));
                }
            }
            if ($this->qty_de_01->Visible && $this->qty_de_01->Required) {
                if (!$this->qty_de_01->IsDetailKey && EmptyValue($this->qty_de_01->FormValue)) {
                    $this->qty_de_01->addErrorMessage(str_replace("%s", $this->qty_de_01->caption(), $this->qty_de_01->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_de_01->FormValue)) {
                $this->qty_de_01->addErrorMessage($this->qty_de_01->getErrorMessage(false));
            }
            if ($this->de_02->Visible && $this->de_02->Required) {
                if (!$this->de_02->IsDetailKey && EmptyValue($this->de_02->FormValue)) {
                    $this->de_02->addErrorMessage(str_replace("%s", $this->de_02->caption(), $this->de_02->RequiredErrorMessage));
                }
            }
            if ($this->qty_de_02->Visible && $this->qty_de_02->Required) {
                if (!$this->qty_de_02->IsDetailKey && EmptyValue($this->qty_de_02->FormValue)) {
                    $this->qty_de_02->addErrorMessage(str_replace("%s", $this->qty_de_02->caption(), $this->qty_de_02->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_de_02->FormValue)) {
                $this->qty_de_02->addErrorMessage($this->qty_de_02->getErrorMessage(false));
            }
            if ($this->de_03->Visible && $this->de_03->Required) {
                if (!$this->de_03->IsDetailKey && EmptyValue($this->de_03->FormValue)) {
                    $this->de_03->addErrorMessage(str_replace("%s", $this->de_03->caption(), $this->de_03->RequiredErrorMessage));
                }
            }
            if ($this->qty_de_03->Visible && $this->qty_de_03->Required) {
                if (!$this->qty_de_03->IsDetailKey && EmptyValue($this->qty_de_03->FormValue)) {
                    $this->qty_de_03->addErrorMessage(str_replace("%s", $this->qty_de_03->caption(), $this->qty_de_03->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->qty_de_03->FormValue)) {
                $this->qty_de_03->addErrorMessage($this->qty_de_03->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // job_type
        $this->job_type->setDbValueDef($rsnew, $this->job_type->CurrentValue, strval($this->job_type->CurrentValue) == "");

        // job_category
        $this->job_category->setDbValueDef($rsnew, $this->job_category->CurrentValue, strval($this->job_category->CurrentValue) == "");

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // description
        $this->description->setDbValueDef($rsnew, $this->description->CurrentValue, false);

        // size
        $this->size->setDbValueDef($rsnew, $this->size->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, strval($this->quantity->CurrentValue) == "");

        // pages
        $this->pages->setDbValueDef($rsnew, $this->pages->CurrentValue, strval($this->pages->CurrentValue) == "");

        // paper
        $this->paper->setDbValueDef($rsnew, $this->paper->CurrentValue, strval($this->paper->CurrentValue) == "");

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // pr_01
        $this->pr_01->setDbValueDef($rsnew, $this->pr_01->CurrentValue, false);

        // qty_pr_01
        $this->qty_pr_01->setDbValueDef($rsnew, $this->qty_pr_01->CurrentValue, strval($this->qty_pr_01->CurrentValue) == "");

        // pl_01
        $this->pl_01->setDbValueDef($rsnew, $this->pl_01->CurrentValue, false);

        // qty_pl_01
        $this->qty_pl_01->setDbValueDef($rsnew, $this->qty_pl_01->CurrentValue, strval($this->qty_pl_01->CurrentValue) == "");

        // pr_02
        $this->pr_02->setDbValueDef($rsnew, $this->pr_02->CurrentValue, false);

        // qty_pr_02
        $this->qty_pr_02->setDbValueDef($rsnew, $this->qty_pr_02->CurrentValue, strval($this->qty_pr_02->CurrentValue) == "");

        // pl_02
        $this->pl_02->setDbValueDef($rsnew, $this->pl_02->CurrentValue, false);

        // qty_pl_02
        $this->qty_pl_02->setDbValueDef($rsnew, $this->qty_pl_02->CurrentValue, strval($this->qty_pl_02->CurrentValue) == "");

        // pr_03
        $this->pr_03->setDbValueDef($rsnew, $this->pr_03->CurrentValue, false);

        // qty_pr_03
        $this->qty_pr_03->setDbValueDef($rsnew, $this->qty_pr_03->CurrentValue, strval($this->qty_pr_03->CurrentValue) == "");

        // pl_03
        $this->pl_03->setDbValueDef($rsnew, $this->pl_03->CurrentValue, false);

        // qty_pl_03
        $this->qty_pl_03->setDbValueDef($rsnew, $this->qty_pl_03->CurrentValue, strval($this->qty_pl_03->CurrentValue) == "");

        // pr_04
        $this->pr_04->setDbValueDef($rsnew, $this->pr_04->CurrentValue, false);

        // qty_pr_04
        $this->qty_pr_04->setDbValueDef($rsnew, $this->qty_pr_04->CurrentValue, strval($this->qty_pr_04->CurrentValue) == "");

        // pl_04
        $this->pl_04->setDbValueDef($rsnew, $this->pl_04->CurrentValue, false);

        // qty_pl_04
        $this->qty_pl_04->setDbValueDef($rsnew, $this->qty_pl_04->CurrentValue, strval($this->qty_pl_04->CurrentValue) == "");

        // pa_01
        $this->pa_01->setDbValueDef($rsnew, $this->pa_01->CurrentValue, false);

        // qty_pa_01
        $this->qty_pa_01->setDbValueDef($rsnew, $this->qty_pa_01->CurrentValue, strval($this->qty_pa_01->CurrentValue) == "");

        // pa_02
        $this->pa_02->setDbValueDef($rsnew, $this->pa_02->CurrentValue, false);

        // qty_pa_02
        $this->qty_pa_02->setDbValueDef($rsnew, $this->qty_pa_02->CurrentValue, strval($this->qty_pa_02->CurrentValue) == "");

        // pa_03
        $this->pa_03->setDbValueDef($rsnew, $this->pa_03->CurrentValue, false);

        // qty_pa_03
        $this->qty_pa_03->setDbValueDef($rsnew, $this->qty_pa_03->CurrentValue, strval($this->qty_pa_03->CurrentValue) == "");

        // pa_04
        $this->pa_04->setDbValueDef($rsnew, $this->pa_04->CurrentValue, false);

        // qty_pa_04
        $this->qty_pa_04->setDbValueDef($rsnew, $this->qty_pa_04->CurrentValue, strval($this->qty_pa_04->CurrentValue) == "");

        // pa_05
        $this->pa_05->setDbValueDef($rsnew, $this->pa_05->CurrentValue, false);

        // qty_pa_05
        $this->qty_pa_05->setDbValueDef($rsnew, $this->qty_pa_05->CurrentValue, strval($this->qty_pa_05->CurrentValue) == "");

        // pc_01
        $this->pc_01->setDbValueDef($rsnew, $this->pc_01->CurrentValue, false);

        // qty_pc_01
        $this->qty_pc_01->setDbValueDef($rsnew, $this->qty_pc_01->CurrentValue, false);

        // pc_02
        $this->pc_02->setDbValueDef($rsnew, $this->pc_02->CurrentValue, false);

        // qty_pc_02
        $this->qty_pc_02->setDbValueDef($rsnew, $this->qty_pc_02->CurrentValue, false);

        // o_01
        $this->o_01->setDbValueDef($rsnew, $this->o_01->CurrentValue, false);

        // qty_o_01
        $this->qty_o_01->setDbValueDef($rsnew, $this->qty_o_01->CurrentValue, false);

        // lamination_type
        $this->lamination_type->setDbValueDef($rsnew, $this->lamination_type->CurrentValue, false);

        // lamination_qty
        $this->lamination_qty->setDbValueDef($rsnew, $this->lamination_qty->CurrentValue, false);

        // die_type
        $this->die_type->setDbValueDef($rsnew, $this->die_type->CurrentValue, false);

        // die_qty
        $this->die_qty->setDbValueDef($rsnew, $this->die_qty->CurrentValue, strval($this->die_qty->CurrentValue) == "");

        // binding_type
        $this->binding_type->setDbValueDef($rsnew, $this->binding_type->CurrentValue, false);

        // binding_qty
        $this->binding_qty->setDbValueDef($rsnew, $this->binding_qty->CurrentValue, strval($this->binding_qty->CurrentValue) == "");

        // number_type
        $this->number_type->setDbValueDef($rsnew, $this->number_type->CurrentValue, false);

        // number_qty
        $this->number_qty->setDbValueDef($rsnew, $this->number_qty->CurrentValue, strval($this->number_qty->CurrentValue) == "");

        // de_01
        $this->de_01->setDbValueDef($rsnew, $this->de_01->CurrentValue, false);

        // qty_de_01
        $this->qty_de_01->setDbValueDef($rsnew, $this->qty_de_01->CurrentValue, strval($this->qty_de_01->CurrentValue) == "");

        // de_02
        $this->de_02->setDbValueDef($rsnew, $this->de_02->CurrentValue, false);

        // qty_de_02
        $this->qty_de_02->setDbValueDef($rsnew, $this->qty_de_02->CurrentValue, strval($this->qty_de_02->CurrentValue) == "");

        // de_03
        $this->de_03->setDbValueDef($rsnew, $this->de_03->CurrentValue, false);

        // qty_de_03
        $this->qty_de_03->setDbValueDef($rsnew, $this->qty_de_03->CurrentValue, strval($this->qty_de_03->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['job_type'])) { // job_type
            $this->job_type->setFormValue($row['job_type']);
        }
        if (isset($row['job_category'])) { // job_category
            $this->job_category->setFormValue($row['job_category']);
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['description'])) { // description
            $this->description->setFormValue($row['description']);
        }
        if (isset($row['size'])) { // size
            $this->size->setFormValue($row['size']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['pages'])) { // pages
            $this->pages->setFormValue($row['pages']);
        }
        if (isset($row['paper'])) { // paper
            $this->paper->setFormValue($row['paper']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['pr_01'])) { // pr_01
            $this->pr_01->setFormValue($row['pr_01']);
        }
        if (isset($row['qty_pr_01'])) { // qty_pr_01
            $this->qty_pr_01->setFormValue($row['qty_pr_01']);
        }
        if (isset($row['pl_01'])) { // pl_01
            $this->pl_01->setFormValue($row['pl_01']);
        }
        if (isset($row['qty_pl_01'])) { // qty_pl_01
            $this->qty_pl_01->setFormValue($row['qty_pl_01']);
        }
        if (isset($row['pr_02'])) { // pr_02
            $this->pr_02->setFormValue($row['pr_02']);
        }
        if (isset($row['qty_pr_02'])) { // qty_pr_02
            $this->qty_pr_02->setFormValue($row['qty_pr_02']);
        }
        if (isset($row['pl_02'])) { // pl_02
            $this->pl_02->setFormValue($row['pl_02']);
        }
        if (isset($row['qty_pl_02'])) { // qty_pl_02
            $this->qty_pl_02->setFormValue($row['qty_pl_02']);
        }
        if (isset($row['pr_03'])) { // pr_03
            $this->pr_03->setFormValue($row['pr_03']);
        }
        if (isset($row['qty_pr_03'])) { // qty_pr_03
            $this->qty_pr_03->setFormValue($row['qty_pr_03']);
        }
        if (isset($row['pl_03'])) { // pl_03
            $this->pl_03->setFormValue($row['pl_03']);
        }
        if (isset($row['qty_pl_03'])) { // qty_pl_03
            $this->qty_pl_03->setFormValue($row['qty_pl_03']);
        }
        if (isset($row['pr_04'])) { // pr_04
            $this->pr_04->setFormValue($row['pr_04']);
        }
        if (isset($row['qty_pr_04'])) { // qty_pr_04
            $this->qty_pr_04->setFormValue($row['qty_pr_04']);
        }
        if (isset($row['pl_04'])) { // pl_04
            $this->pl_04->setFormValue($row['pl_04']);
        }
        if (isset($row['qty_pl_04'])) { // qty_pl_04
            $this->qty_pl_04->setFormValue($row['qty_pl_04']);
        }
        if (isset($row['pa_01'])) { // pa_01
            $this->pa_01->setFormValue($row['pa_01']);
        }
        if (isset($row['qty_pa_01'])) { // qty_pa_01
            $this->qty_pa_01->setFormValue($row['qty_pa_01']);
        }
        if (isset($row['pa_02'])) { // pa_02
            $this->pa_02->setFormValue($row['pa_02']);
        }
        if (isset($row['qty_pa_02'])) { // qty_pa_02
            $this->qty_pa_02->setFormValue($row['qty_pa_02']);
        }
        if (isset($row['pa_03'])) { // pa_03
            $this->pa_03->setFormValue($row['pa_03']);
        }
        if (isset($row['qty_pa_03'])) { // qty_pa_03
            $this->qty_pa_03->setFormValue($row['qty_pa_03']);
        }
        if (isset($row['pa_04'])) { // pa_04
            $this->pa_04->setFormValue($row['pa_04']);
        }
        if (isset($row['qty_pa_04'])) { // qty_pa_04
            $this->qty_pa_04->setFormValue($row['qty_pa_04']);
        }
        if (isset($row['pa_05'])) { // pa_05
            $this->pa_05->setFormValue($row['pa_05']);
        }
        if (isset($row['qty_pa_05'])) { // qty_pa_05
            $this->qty_pa_05->setFormValue($row['qty_pa_05']);
        }
        if (isset($row['pc_01'])) { // pc_01
            $this->pc_01->setFormValue($row['pc_01']);
        }
        if (isset($row['qty_pc_01'])) { // qty_pc_01
            $this->qty_pc_01->setFormValue($row['qty_pc_01']);
        }
        if (isset($row['pc_02'])) { // pc_02
            $this->pc_02->setFormValue($row['pc_02']);
        }
        if (isset($row['qty_pc_02'])) { // qty_pc_02
            $this->qty_pc_02->setFormValue($row['qty_pc_02']);
        }
        if (isset($row['o_01'])) { // o_01
            $this->o_01->setFormValue($row['o_01']);
        }
        if (isset($row['qty_o_01'])) { // qty_o_01
            $this->qty_o_01->setFormValue($row['qty_o_01']);
        }
        if (isset($row['lamination_type'])) { // lamination_type
            $this->lamination_type->setFormValue($row['lamination_type']);
        }
        if (isset($row['lamination_qty'])) { // lamination_qty
            $this->lamination_qty->setFormValue($row['lamination_qty']);
        }
        if (isset($row['die_type'])) { // die_type
            $this->die_type->setFormValue($row['die_type']);
        }
        if (isset($row['die_qty'])) { // die_qty
            $this->die_qty->setFormValue($row['die_qty']);
        }
        if (isset($row['binding_type'])) { // binding_type
            $this->binding_type->setFormValue($row['binding_type']);
        }
        if (isset($row['binding_qty'])) { // binding_qty
            $this->binding_qty->setFormValue($row['binding_qty']);
        }
        if (isset($row['number_type'])) { // number_type
            $this->number_type->setFormValue($row['number_type']);
        }
        if (isset($row['number_qty'])) { // number_qty
            $this->number_qty->setFormValue($row['number_qty']);
        }
        if (isset($row['de_01'])) { // de_01
            $this->de_01->setFormValue($row['de_01']);
        }
        if (isset($row['qty_de_01'])) { // qty_de_01
            $this->qty_de_01->setFormValue($row['qty_de_01']);
        }
        if (isset($row['de_02'])) { // de_02
            $this->de_02->setFormValue($row['de_02']);
        }
        if (isset($row['qty_de_02'])) { // qty_de_02
            $this->qty_de_02->setFormValue($row['qty_de_02']);
        }
        if (isset($row['de_03'])) { // de_03
            $this->de_03->setFormValue($row['de_03']);
        }
        if (isset($row['qty_de_03'])) { // qty_de_03
            $this->qty_de_03->setFormValue($row['qty_de_03']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("peastimatelist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $pages->add(8);
        $pages->add(9);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_job_type":
                    break;
                case "x_job_category":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_size":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pr_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pl_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pa_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pc_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_pc_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_o_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lamination_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_die_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_binding_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_number_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_de_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
