<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for p_eastimate
 */
class PEastimate extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $job_type;
    public $job_category;
    public $company_id;
    public $description;
    public $size;
    public $quantity;
    public $pages;
    public $paper;
    public $remarks;
    public $pr_01;
    public $qty_pr_01;
    public $pl_01;
    public $qty_pl_01;
    public $pr_02;
    public $qty_pr_02;
    public $pl_02;
    public $qty_pl_02;
    public $pr_03;
    public $qty_pr_03;
    public $pl_03;
    public $qty_pl_03;
    public $pr_04;
    public $qty_pr_04;
    public $pl_04;
    public $qty_pl_04;
    public $pa_01;
    public $qty_pa_01;
    public $pa_02;
    public $qty_pa_02;
    public $pa_03;
    public $qty_pa_03;
    public $pa_04;
    public $qty_pa_04;
    public $pa_05;
    public $qty_pa_05;
    public $pc_01;
    public $qty_pc_01;
    public $pc_02;
    public $qty_pc_02;
    public $o_01;
    public $qty_o_01;
    public $lamination_type;
    public $lamination_qty;
    public $die_type;
    public $die_qty;
    public $binding_type;
    public $binding_qty;
    public $number_type;
    public $number_qty;
    public $de_01;
    public $qty_de_01;
    public $de_02;
    public $qty_de_02;
    public $de_03;
    public $qty_de_03;
    public $operator;
    public $datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "p_eastimate";
        $this->TableName = 'p_eastimate';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "p_eastimate";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // job_type
        $this->job_type = new DbField(
            $this, // Table
            'x_job_type', // Variable name
            'job_type', // Name
            '`job_type`', // Expression
            '`job_type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`job_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->job_type->InputTextType = "text";
        $this->job_type->Raw = true;
        $this->job_type->Nullable = false; // NOT NULL field
        $this->job_type->Required = true; // Required field
        $this->job_type->Lookup = new Lookup($this->job_type, 'p_eastimate', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->job_type->OptionCount = 2;
        $this->job_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->job_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['job_type'] = &$this->job_type;

        // job_category
        $this->job_category = new DbField(
            $this, // Table
            'x_job_category', // Variable name
            'job_category', // Name
            '`job_category`', // Expression
            '`job_category`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`job_category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->job_category->InputTextType = "text";
        $this->job_category->Raw = true;
        $this->job_category->Nullable = false; // NOT NULL field
        $this->job_category->Required = true; // Required field
        $this->job_category->Lookup = new Lookup($this->job_category, 'p_eastimate', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->job_category->OptionCount = 2;
        $this->job_category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->job_category->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['job_category'] = &$this->job_category;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->company_id->addMethod("getDefault", fn() => ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["CID"]))? $_COOKIE["CID"]:User_Company_ID())));
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Required = true; // Required field
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // description
        $this->description = new DbField(
            $this, // Table
            'x_description', // Variable name
            'description', // Name
            '`description`', // Expression
            '`description`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description->InputTextType = "text";
        $this->description->Required = true; // Required field
        $this->description->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['description'] = &$this->description;

        // size
        $this->size = new DbField(
            $this, // Table
            'x_size', // Variable name
            'size', // Name
            '`size`', // Expression
            '`size`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->size->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->size->InputTextType = "text";
        $this->size->Nullable = false; // NOT NULL field
        $this->size->Required = true; // Required field
        $this->size->setSelectMultiple(false); // Select one
        $this->size->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->size->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->size->Lookup = new Lookup($this->size, 'p_size', true, 'description', ["description","","",""], '', '', [], [], [], [], [], [], false, '`description` ASC', '', "`description`");
        $this->size->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->size->SearchOperators = ["=", "<>"];
        $this->Fields['size'] = &$this->size;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->addMethod("getDefault", fn() => 0.00);
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Nullable = false; // NOT NULL field
        $this->quantity->Required = true; // Required field
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity'] = &$this->quantity;

        // pages
        $this->pages = new DbField(
            $this, // Table
            'x_pages', // Variable name
            'pages', // Name
            '`pages`', // Expression
            '`pages`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pages`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pages->addMethod("getDefault", fn() => "0");
        $this->pages->InputTextType = "text";
        $this->pages->Nullable = false; // NOT NULL field
        $this->pages->Required = true; // Required field
        $this->pages->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['pages'] = &$this->pages;

        // paper
        $this->paper = new DbField(
            $this, // Table
            'x_paper', // Variable name
            'paper', // Name
            '`paper`', // Expression
            '`paper`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`paper`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->paper->addMethod("getDefault", fn() => 1);
        $this->paper->InputTextType = "text";
        $this->paper->Raw = true;
        $this->paper->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->paper->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['paper'] = &$this->paper;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            252, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // pr_01
        $this->pr_01 = new DbField(
            $this, // Table
            'x_pr_01', // Variable name
            'pr_01', // Name
            '`pr_01`', // Expression
            '`pr_01`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pr_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pr_01->addMethod("getSelectFilter", fn() => "`s_grp` IN (116)");
        $this->pr_01->InputTextType = "text";
        $this->pr_01->setSelectMultiple(false); // Select one
        $this->pr_01->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pr_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pr_01->Lookup = new Lookup($this->pr_01, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pr_01->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pr_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pr_01'] = &$this->pr_01;

        // qty_pr_01
        $this->qty_pr_01 = new DbField(
            $this, // Table
            'x_qty_pr_01', // Variable name
            'qty_pr_01', // Name
            '`qty_pr_01`', // Expression
            '`qty_pr_01`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pr_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pr_01->addMethod("getDefault", fn() => 0.00);
        $this->qty_pr_01->InputTextType = "text";
        $this->qty_pr_01->Raw = true;
        $this->qty_pr_01->Nullable = false; // NOT NULL field
        $this->qty_pr_01->Required = true; // Required field
        $this->qty_pr_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pr_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pr_01'] = &$this->qty_pr_01;

        // pl_01
        $this->pl_01 = new DbField(
            $this, // Table
            'x_pl_01', // Variable name
            'pl_01', // Name
            '`pl_01`', // Expression
            '`pl_01`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pl_01->addMethod("getSelectFilter", fn() => "`s_grp` IN (115)");
        $this->pl_01->InputTextType = "text";
        $this->pl_01->setSelectMultiple(false); // Select one
        $this->pl_01->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pl_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pl_01->Lookup = new Lookup($this->pl_01, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pl_01->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pl_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pl_01'] = &$this->pl_01;

        // qty_pl_01
        $this->qty_pl_01 = new DbField(
            $this, // Table
            'x_qty_pl_01', // Variable name
            'qty_pl_01', // Name
            '`qty_pl_01`', // Expression
            '`qty_pl_01`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pl_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pl_01->addMethod("getDefault", fn() => 0.00);
        $this->qty_pl_01->InputTextType = "text";
        $this->qty_pl_01->Raw = true;
        $this->qty_pl_01->Nullable = false; // NOT NULL field
        $this->qty_pl_01->Required = true; // Required field
        $this->qty_pl_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pl_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pl_01'] = &$this->qty_pl_01;

        // pr_02
        $this->pr_02 = new DbField(
            $this, // Table
            'x_pr_02', // Variable name
            'pr_02', // Name
            '`pr_02`', // Expression
            '`pr_02`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pr_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pr_02->addMethod("getSelectFilter", fn() => "`s_grp` IN (116)");
        $this->pr_02->InputTextType = "text";
        $this->pr_02->setSelectMultiple(false); // Select one
        $this->pr_02->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pr_02->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pr_02->Lookup = new Lookup($this->pr_02, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pr_02->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pr_02->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pr_02'] = &$this->pr_02;

        // qty_pr_02
        $this->qty_pr_02 = new DbField(
            $this, // Table
            'x_qty_pr_02', // Variable name
            'qty_pr_02', // Name
            '`qty_pr_02`', // Expression
            '`qty_pr_02`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pr_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pr_02->addMethod("getDefault", fn() => 0.00);
        $this->qty_pr_02->InputTextType = "text";
        $this->qty_pr_02->Raw = true;
        $this->qty_pr_02->Nullable = false; // NOT NULL field
        $this->qty_pr_02->Required = true; // Required field
        $this->qty_pr_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pr_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pr_02'] = &$this->qty_pr_02;

        // pl_02
        $this->pl_02 = new DbField(
            $this, // Table
            'x_pl_02', // Variable name
            'pl_02', // Name
            '`pl_02`', // Expression
            '`pl_02`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pl_02->addMethod("getSelectFilter", fn() => "`s_grp` IN (115)");
        $this->pl_02->InputTextType = "text";
        $this->pl_02->setSelectMultiple(false); // Select one
        $this->pl_02->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pl_02->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pl_02->Lookup = new Lookup($this->pl_02, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pl_02->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pl_02->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pl_02'] = &$this->pl_02;

        // qty_pl_02
        $this->qty_pl_02 = new DbField(
            $this, // Table
            'x_qty_pl_02', // Variable name
            'qty_pl_02', // Name
            '`qty_pl_02`', // Expression
            '`qty_pl_02`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pl_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pl_02->addMethod("getDefault", fn() => 0.00);
        $this->qty_pl_02->InputTextType = "text";
        $this->qty_pl_02->Raw = true;
        $this->qty_pl_02->Nullable = false; // NOT NULL field
        $this->qty_pl_02->Required = true; // Required field
        $this->qty_pl_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pl_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pl_02'] = &$this->qty_pl_02;

        // pr_03
        $this->pr_03 = new DbField(
            $this, // Table
            'x_pr_03', // Variable name
            'pr_03', // Name
            '`pr_03`', // Expression
            '`pr_03`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pr_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pr_03->addMethod("getSelectFilter", fn() => "`s_grp` IN (116)");
        $this->pr_03->InputTextType = "text";
        $this->pr_03->setSelectMultiple(false); // Select one
        $this->pr_03->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pr_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pr_03->Lookup = new Lookup($this->pr_03, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pr_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pr_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pr_03'] = &$this->pr_03;

        // qty_pr_03
        $this->qty_pr_03 = new DbField(
            $this, // Table
            'x_qty_pr_03', // Variable name
            'qty_pr_03', // Name
            '`qty_pr_03`', // Expression
            '`qty_pr_03`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pr_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pr_03->addMethod("getDefault", fn() => 0.00);
        $this->qty_pr_03->InputTextType = "text";
        $this->qty_pr_03->Raw = true;
        $this->qty_pr_03->Nullable = false; // NOT NULL field
        $this->qty_pr_03->Required = true; // Required field
        $this->qty_pr_03->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pr_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pr_03'] = &$this->qty_pr_03;

        // pl_03
        $this->pl_03 = new DbField(
            $this, // Table
            'x_pl_03', // Variable name
            'pl_03', // Name
            '`pl_03`', // Expression
            '`pl_03`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pl_03->addMethod("getSelectFilter", fn() => "`s_grp` IN (115)");
        $this->pl_03->InputTextType = "text";
        $this->pl_03->setSelectMultiple(false); // Select one
        $this->pl_03->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pl_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pl_03->Lookup = new Lookup($this->pl_03, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pl_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pl_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pl_03'] = &$this->pl_03;

        // qty_pl_03
        $this->qty_pl_03 = new DbField(
            $this, // Table
            'x_qty_pl_03', // Variable name
            'qty_pl_03', // Name
            '`qty_pl_03`', // Expression
            '`qty_pl_03`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pl_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pl_03->addMethod("getDefault", fn() => 0.00);
        $this->qty_pl_03->InputTextType = "text";
        $this->qty_pl_03->Raw = true;
        $this->qty_pl_03->Nullable = false; // NOT NULL field
        $this->qty_pl_03->Required = true; // Required field
        $this->qty_pl_03->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pl_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pl_03'] = &$this->qty_pl_03;

        // pr_04
        $this->pr_04 = new DbField(
            $this, // Table
            'x_pr_04', // Variable name
            'pr_04', // Name
            '`pr_04`', // Expression
            '`pr_04`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pr_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pr_04->addMethod("getSelectFilter", fn() => "`s_grp` IN (116)");
        $this->pr_04->InputTextType = "text";
        $this->pr_04->setSelectMultiple(false); // Select one
        $this->pr_04->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pr_04->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pr_04->Lookup = new Lookup($this->pr_04, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pr_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pr_04->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pr_04'] = &$this->pr_04;

        // qty_pr_04
        $this->qty_pr_04 = new DbField(
            $this, // Table
            'x_qty_pr_04', // Variable name
            'qty_pr_04', // Name
            '`qty_pr_04`', // Expression
            '`qty_pr_04`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pr_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pr_04->addMethod("getDefault", fn() => 0.00);
        $this->qty_pr_04->InputTextType = "text";
        $this->qty_pr_04->Raw = true;
        $this->qty_pr_04->Nullable = false; // NOT NULL field
        $this->qty_pr_04->Required = true; // Required field
        $this->qty_pr_04->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pr_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pr_04'] = &$this->qty_pr_04;

        // pl_04
        $this->pl_04 = new DbField(
            $this, // Table
            'x_pl_04', // Variable name
            'pl_04', // Name
            '`pl_04`', // Expression
            '`pl_04`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pl_04->addMethod("getSelectFilter", fn() => "`s_grp` IN (115)");
        $this->pl_04->InputTextType = "text";
        $this->pl_04->setSelectMultiple(false); // Select one
        $this->pl_04->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pl_04->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pl_04->Lookup = new Lookup($this->pl_04, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pl_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pl_04->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pl_04'] = &$this->pl_04;

        // qty_pl_04
        $this->qty_pl_04 = new DbField(
            $this, // Table
            'x_qty_pl_04', // Variable name
            'qty_pl_04', // Name
            '`qty_pl_04`', // Expression
            '`qty_pl_04`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pl_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pl_04->addMethod("getDefault", fn() => 0.00);
        $this->qty_pl_04->InputTextType = "text";
        $this->qty_pl_04->Raw = true;
        $this->qty_pl_04->Nullable = false; // NOT NULL field
        $this->qty_pl_04->Required = true; // Required field
        $this->qty_pl_04->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pl_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pl_04'] = &$this->qty_pl_04;

        // pa_01
        $this->pa_01 = new DbField(
            $this, // Table
            'x_pa_01', // Variable name
            'pa_01', // Name
            '`pa_01`', // Expression
            '`pa_01`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_01->addMethod("getSelectFilter", fn() => "`s_grp` IN (101,102,112)");
        $this->pa_01->InputTextType = "text";
        $this->pa_01->Lookup = new Lookup($this->pa_01, 'stock_lcgp', false, 'id', ["product_code_pg","","",""], '', '', [], [], [], [], [], [], false, '`product_code_pg` DESC', '', "`product_code_pg`");
        $this->pa_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_01'] = &$this->pa_01;

        // qty_pa_01
        $this->qty_pa_01 = new DbField(
            $this, // Table
            'x_qty_pa_01', // Variable name
            'qty_pa_01', // Name
            '`qty_pa_01`', // Expression
            '`qty_pa_01`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pa_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pa_01->addMethod("getDefault", fn() => 0.00);
        $this->qty_pa_01->InputTextType = "text";
        $this->qty_pa_01->Raw = true;
        $this->qty_pa_01->Nullable = false; // NOT NULL field
        $this->qty_pa_01->Required = true; // Required field
        $this->qty_pa_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pa_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pa_01'] = &$this->qty_pa_01;

        // pa_02
        $this->pa_02 = new DbField(
            $this, // Table
            'x_pa_02', // Variable name
            'pa_02', // Name
            '`pa_02`', // Expression
            '`pa_02`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_02->addMethod("getSelectFilter", fn() => "`s_grp` IN (101,102,112)");
        $this->pa_02->InputTextType = "text";
        $this->pa_02->Lookup = new Lookup($this->pa_02, 'stock_lcgp', false, 'id', ["product_code_pg","","",""], '', '', [], [], [], [], [], [], false, '`product_code_pg` DESC', '', "`product_code_pg`");
        $this->pa_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_02'] = &$this->pa_02;

        // qty_pa_02
        $this->qty_pa_02 = new DbField(
            $this, // Table
            'x_qty_pa_02', // Variable name
            'qty_pa_02', // Name
            '`qty_pa_02`', // Expression
            '`qty_pa_02`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pa_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pa_02->addMethod("getDefault", fn() => 0.00);
        $this->qty_pa_02->InputTextType = "text";
        $this->qty_pa_02->Raw = true;
        $this->qty_pa_02->Nullable = false; // NOT NULL field
        $this->qty_pa_02->Required = true; // Required field
        $this->qty_pa_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pa_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pa_02'] = &$this->qty_pa_02;

        // pa_03
        $this->pa_03 = new DbField(
            $this, // Table
            'x_pa_03', // Variable name
            'pa_03', // Name
            '`pa_03`', // Expression
            '`pa_03`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_03->addMethod("getSelectFilter", fn() => "`s_grp` IN (101,102,112)");
        $this->pa_03->InputTextType = "text";
        $this->pa_03->Lookup = new Lookup($this->pa_03, 'stock_lcgp', false, 'id', ["product_code_pg","","",""], '', '', [], [], [], [], [], [], false, '`product_code_pg` DESC', '', "`product_code_pg`");
        $this->pa_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_03'] = &$this->pa_03;

        // qty_pa_03
        $this->qty_pa_03 = new DbField(
            $this, // Table
            'x_qty_pa_03', // Variable name
            'qty_pa_03', // Name
            '`qty_pa_03`', // Expression
            '`qty_pa_03`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pa_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pa_03->addMethod("getDefault", fn() => 0.00);
        $this->qty_pa_03->InputTextType = "text";
        $this->qty_pa_03->Raw = true;
        $this->qty_pa_03->Nullable = false; // NOT NULL field
        $this->qty_pa_03->Required = true; // Required field
        $this->qty_pa_03->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pa_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pa_03'] = &$this->qty_pa_03;

        // pa_04
        $this->pa_04 = new DbField(
            $this, // Table
            'x_pa_04', // Variable name
            'pa_04', // Name
            '`pa_04`', // Expression
            '`pa_04`', // Basic search expression
            200, // Type
            24, // Size
            111, // Date/Time format
            false, // Is upload field
            '`pa_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_04->addMethod("getSelectFilter", fn() => "`s_grp` IN (101,102,112)");
        $this->pa_04->InputTextType = "text";
        $this->pa_04->Lookup = new Lookup($this->pa_04, 'stock_lcgp', false, 'id', ["product_code_pg","","",""], '', '', [], [], [], [], [], [], false, '`product_code_pg` DESC', '', "`product_code_pg`");
        $this->pa_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_04'] = &$this->pa_04;

        // qty_pa_04
        $this->qty_pa_04 = new DbField(
            $this, // Table
            'x_qty_pa_04', // Variable name
            'qty_pa_04', // Name
            '`qty_pa_04`', // Expression
            '`qty_pa_04`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pa_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pa_04->addMethod("getDefault", fn() => 0.00);
        $this->qty_pa_04->InputTextType = "text";
        $this->qty_pa_04->Raw = true;
        $this->qty_pa_04->Nullable = false; // NOT NULL field
        $this->qty_pa_04->Required = true; // Required field
        $this->qty_pa_04->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pa_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pa_04'] = &$this->qty_pa_04;

        // pa_05
        $this->pa_05 = new DbField(
            $this, // Table
            'x_pa_05', // Variable name
            'pa_05', // Name
            '`pa_05`', // Expression
            '`pa_05`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pa_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pa_05->addMethod("getSelectFilter", fn() => "`s_grp` IN (101,102,112)");
        $this->pa_05->InputTextType = "text";
        $this->pa_05->Lookup = new Lookup($this->pa_05, 'stock_lcgp', false, 'id', ["product_code_pg","","",""], '', '', [], [], [], [], [], [], false, '`product_code_pg` DESC', '', "`product_code_pg`");
        $this->pa_05->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pa_05->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pa_05'] = &$this->pa_05;

        // qty_pa_05
        $this->qty_pa_05 = new DbField(
            $this, // Table
            'x_qty_pa_05', // Variable name
            'qty_pa_05', // Name
            '`qty_pa_05`', // Expression
            '`qty_pa_05`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pa_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pa_05->addMethod("getDefault", fn() => 0.00);
        $this->qty_pa_05->InputTextType = "text";
        $this->qty_pa_05->Raw = true;
        $this->qty_pa_05->Nullable = false; // NOT NULL field
        $this->qty_pa_05->Required = true; // Required field
        $this->qty_pa_05->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pa_05->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pa_05'] = &$this->qty_pa_05;

        // pc_01
        $this->pc_01 = new DbField(
            $this, // Table
            'x_pc_01', // Variable name
            'pc_01', // Name
            '`pc_01`', // Expression
            '`pc_01`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pc_01->addMethod("getSelectFilter", fn() => "`s_grp` IN (125) and `status` = 1");
        $this->pc_01->InputTextType = "text";
        $this->pc_01->setSelectMultiple(false); // Select one
        $this->pc_01->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pc_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pc_01->Lookup = new Lookup($this->pc_01, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pc_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pc_01'] = &$this->pc_01;

        // qty_pc_01
        $this->qty_pc_01 = new DbField(
            $this, // Table
            'x_qty_pc_01', // Variable name
            'qty_pc_01', // Name
            '`qty_pc_01`', // Expression
            '`qty_pc_01`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pc_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pc_01->addMethod("getDefault", fn() => 0.00);
        $this->qty_pc_01->InputTextType = "text";
        $this->qty_pc_01->Raw = true;
        $this->qty_pc_01->Nullable = false; // NOT NULL field
        $this->qty_pc_01->Required = true; // Required field
        $this->qty_pc_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pc_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pc_01'] = &$this->qty_pc_01;

        // pc_02
        $this->pc_02 = new DbField(
            $this, // Table
            'x_pc_02', // Variable name
            'pc_02', // Name
            '`pc_02`', // Expression
            '`pc_02`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pc_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pc_02->addMethod("getSelectFilter", fn() => "`s_grp` IN (125) and `status` = 1");
        $this->pc_02->InputTextType = "text";
        $this->pc_02->setSelectMultiple(false); // Select one
        $this->pc_02->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pc_02->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pc_02->Lookup = new Lookup($this->pc_02, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->pc_02->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['pc_02'] = &$this->pc_02;

        // qty_pc_02
        $this->qty_pc_02 = new DbField(
            $this, // Table
            'x_qty_pc_02', // Variable name
            'qty_pc_02', // Name
            '`qty_pc_02`', // Expression
            '`qty_pc_02`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_pc_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_pc_02->addMethod("getDefault", fn() => 0.00);
        $this->qty_pc_02->InputTextType = "text";
        $this->qty_pc_02->Raw = true;
        $this->qty_pc_02->Nullable = false; // NOT NULL field
        $this->qty_pc_02->Required = true; // Required field
        $this->qty_pc_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_pc_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_pc_02'] = &$this->qty_pc_02;

        // o_01
        $this->o_01 = new DbField(
            $this, // Table
            'x_o_01', // Variable name
            'o_01', // Name
            '`o_01`', // Expression
            '`o_01`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`o_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->o_01->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->o_01->InputTextType = "text";
        $this->o_01->setSelectMultiple(false); // Select one
        $this->o_01->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->o_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->o_01->Lookup = new Lookup($this->o_01, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->o_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['o_01'] = &$this->o_01;

        // qty_o_01
        $this->qty_o_01 = new DbField(
            $this, // Table
            'x_qty_o_01', // Variable name
            'qty_o_01', // Name
            '`qty_o_01`', // Expression
            '`qty_o_01`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_o_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_o_01->addMethod("getDefault", fn() => 0.00);
        $this->qty_o_01->InputTextType = "text";
        $this->qty_o_01->Raw = true;
        $this->qty_o_01->Nullable = false; // NOT NULL field
        $this->qty_o_01->Required = true; // Required field
        $this->qty_o_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_o_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_o_01'] = &$this->qty_o_01;

        // lamination_type
        $this->lamination_type = new DbField(
            $this, // Table
            'x_lamination_type', // Variable name
            'lamination_type', // Name
            '`lamination_type`', // Expression
            '`lamination_type`', // Basic search expression
            200, // Type
            24, // Size
            111, // Date/Time format
            false, // Is upload field
            '`lamination_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->lamination_type->addMethod("getSelectFilter", fn() => "`s_grp` IN (123) and `status` = 1");
        $this->lamination_type->InputTextType = "text";
        $this->lamination_type->setSelectMultiple(false); // Select one
        $this->lamination_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->lamination_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->lamination_type->Lookup = new Lookup($this->lamination_type, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->lamination_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->lamination_type->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['lamination_type'] = &$this->lamination_type;

        // lamination_qty
        $this->lamination_qty = new DbField(
            $this, // Table
            'x_lamination_qty', // Variable name
            'lamination_qty', // Name
            '`lamination_qty`', // Expression
            '`lamination_qty`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lamination_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lamination_qty->addMethod("getDefault", fn() => 0.00);
        $this->lamination_qty->InputTextType = "text";
        $this->lamination_qty->Raw = true;
        $this->lamination_qty->Required = true; // Required field
        $this->lamination_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->lamination_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['lamination_qty'] = &$this->lamination_qty;

        // die_type
        $this->die_type = new DbField(
            $this, // Table
            'x_die_type', // Variable name
            'die_type', // Name
            '`die_type`', // Expression
            '`die_type`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`die_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->die_type->addMethod("getSelectFilter", fn() => "`s_grp` IN (124) and `status` = 1");
        $this->die_type->InputTextType = "text";
        $this->die_type->setSelectMultiple(false); // Select one
        $this->die_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->die_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->die_type->Lookup = new Lookup($this->die_type, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->die_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->die_type->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['die_type'] = &$this->die_type;

        // die_qty
        $this->die_qty = new DbField(
            $this, // Table
            'x_die_qty', // Variable name
            'die_qty', // Name
            '`die_qty`', // Expression
            '`die_qty`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`die_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->die_qty->addMethod("getDefault", fn() => 0.00);
        $this->die_qty->InputTextType = "text";
        $this->die_qty->Raw = true;
        $this->die_qty->Nullable = false; // NOT NULL field
        $this->die_qty->Required = true; // Required field
        $this->die_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->die_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['die_qty'] = &$this->die_qty;

        // binding_type
        $this->binding_type = new DbField(
            $this, // Table
            'x_binding_type', // Variable name
            'binding_type', // Name
            '`binding_type`', // Expression
            '`binding_type`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`binding_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->binding_type->addMethod("getSelectFilter", fn() => "`s_grp` IN (114) and `status` = 1");
        $this->binding_type->InputTextType = "text";
        $this->binding_type->setSelectMultiple(false); // Select one
        $this->binding_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->binding_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->binding_type->Lookup = new Lookup($this->binding_type, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->binding_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->binding_type->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['binding_type'] = &$this->binding_type;

        // binding_qty
        $this->binding_qty = new DbField(
            $this, // Table
            'x_binding_qty', // Variable name
            'binding_qty', // Name
            '`binding_qty`', // Expression
            '`binding_qty`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`binding_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->binding_qty->addMethod("getDefault", fn() => 0.00);
        $this->binding_qty->InputTextType = "text";
        $this->binding_qty->Raw = true;
        $this->binding_qty->Nullable = false; // NOT NULL field
        $this->binding_qty->Required = true; // Required field
        $this->binding_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->binding_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['binding_qty'] = &$this->binding_qty;

        // number_type
        $this->number_type = new DbField(
            $this, // Table
            'x_number_type', // Variable name
            'number_type', // Name
            '`number_type`', // Expression
            '`number_type`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`number_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->number_type->addMethod("getSelectFilter", fn() => "`s_grp` IN (114) and `status` = 1");
        $this->number_type->InputTextType = "text";
        $this->number_type->setSelectMultiple(false); // Select one
        $this->number_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->number_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->number_type->Lookup = new Lookup($this->number_type, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->number_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->number_type->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['number_type'] = &$this->number_type;

        // number_qty
        $this->number_qty = new DbField(
            $this, // Table
            'x_number_qty', // Variable name
            'number_qty', // Name
            '`number_qty`', // Expression
            '`number_qty`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`number_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->number_qty->addMethod("getDefault", fn() => 0.00);
        $this->number_qty->InputTextType = "text";
        $this->number_qty->Raw = true;
        $this->number_qty->Nullable = false; // NOT NULL field
        $this->number_qty->Required = true; // Required field
        $this->number_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->number_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['number_qty'] = &$this->number_qty;

        // de_01
        $this->de_01 = new DbField(
            $this, // Table
            'x_de_01', // Variable name
            'de_01', // Name
            '`de_01`', // Expression
            '`de_01`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`de_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->de_01->addMethod("getSelectFilter", fn() => "`s_grp` IN (121) and `status` = 1");
        $this->de_01->InputTextType = "text";
        $this->de_01->setSelectMultiple(false); // Select one
        $this->de_01->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->de_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->de_01->Lookup = new Lookup($this->de_01, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->de_01->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->de_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['de_01'] = &$this->de_01;

        // qty_de_01
        $this->qty_de_01 = new DbField(
            $this, // Table
            'x_qty_de_01', // Variable name
            'qty_de_01', // Name
            '`qty_de_01`', // Expression
            '`qty_de_01`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_de_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_de_01->addMethod("getDefault", fn() => 0.00);
        $this->qty_de_01->InputTextType = "text";
        $this->qty_de_01->Raw = true;
        $this->qty_de_01->Nullable = false; // NOT NULL field
        $this->qty_de_01->Required = true; // Required field
        $this->qty_de_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_de_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_de_01'] = &$this->qty_de_01;

        // de_02
        $this->de_02 = new DbField(
            $this, // Table
            'x_de_02', // Variable name
            'de_02', // Name
            '`de_02`', // Expression
            '`de_02`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`de_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->de_02->addMethod("getSelectFilter", fn() => "`s_grp` IN (121) and `status` = 1");
        $this->de_02->InputTextType = "text";
        $this->de_02->setSelectMultiple(false); // Select one
        $this->de_02->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->de_02->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->de_02->Lookup = new Lookup($this->de_02, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->de_02->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->de_02->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['de_02'] = &$this->de_02;

        // qty_de_02
        $this->qty_de_02 = new DbField(
            $this, // Table
            'x_qty_de_02', // Variable name
            'qty_de_02', // Name
            '`qty_de_02`', // Expression
            '`qty_de_02`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_de_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_de_02->addMethod("getDefault", fn() => 0.00);
        $this->qty_de_02->InputTextType = "text";
        $this->qty_de_02->Raw = true;
        $this->qty_de_02->Nullable = false; // NOT NULL field
        $this->qty_de_02->Required = true; // Required field
        $this->qty_de_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_de_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_de_02'] = &$this->qty_de_02;

        // de_03
        $this->de_03 = new DbField(
            $this, // Table
            'x_de_03', // Variable name
            'de_03', // Name
            '`de_03`', // Expression
            '`de_03`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`de_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->de_03->addMethod("getSelectFilter", fn() => "`s_grp` IN (121) and `status` = 1");
        $this->de_03->InputTextType = "text";
        $this->de_03->setSelectMultiple(false); // Select one
        $this->de_03->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->de_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->de_03->Lookup = new Lookup($this->de_03, 'material_status', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->de_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->de_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['de_03'] = &$this->de_03;

        // qty_de_03
        $this->qty_de_03 = new DbField(
            $this, // Table
            'x_qty_de_03', // Variable name
            'qty_de_03', // Name
            '`qty_de_03`', // Expression
            '`qty_de_03`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty_de_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty_de_03->addMethod("getDefault", fn() => 0.00);
        $this->qty_de_03->InputTextType = "text";
        $this->qty_de_03->Raw = true;
        $this->qty_de_03->Nullable = false; // NOT NULL field
        $this->qty_de_03->Required = true; // Required field
        $this->qty_de_03->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->qty_de_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qty_de_03'] = &$this->qty_de_03;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "p_eastimate";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->job_type->DbValue = $row['job_type'];
        $this->job_category->DbValue = $row['job_category'];
        $this->company_id->DbValue = $row['company_id'];
        $this->description->DbValue = $row['description'];
        $this->size->DbValue = $row['size'];
        $this->quantity->DbValue = $row['quantity'];
        $this->pages->DbValue = $row['pages'];
        $this->paper->DbValue = $row['paper'];
        $this->remarks->DbValue = $row['remarks'];
        $this->pr_01->DbValue = $row['pr_01'];
        $this->qty_pr_01->DbValue = $row['qty_pr_01'];
        $this->pl_01->DbValue = $row['pl_01'];
        $this->qty_pl_01->DbValue = $row['qty_pl_01'];
        $this->pr_02->DbValue = $row['pr_02'];
        $this->qty_pr_02->DbValue = $row['qty_pr_02'];
        $this->pl_02->DbValue = $row['pl_02'];
        $this->qty_pl_02->DbValue = $row['qty_pl_02'];
        $this->pr_03->DbValue = $row['pr_03'];
        $this->qty_pr_03->DbValue = $row['qty_pr_03'];
        $this->pl_03->DbValue = $row['pl_03'];
        $this->qty_pl_03->DbValue = $row['qty_pl_03'];
        $this->pr_04->DbValue = $row['pr_04'];
        $this->qty_pr_04->DbValue = $row['qty_pr_04'];
        $this->pl_04->DbValue = $row['pl_04'];
        $this->qty_pl_04->DbValue = $row['qty_pl_04'];
        $this->pa_01->DbValue = $row['pa_01'];
        $this->qty_pa_01->DbValue = $row['qty_pa_01'];
        $this->pa_02->DbValue = $row['pa_02'];
        $this->qty_pa_02->DbValue = $row['qty_pa_02'];
        $this->pa_03->DbValue = $row['pa_03'];
        $this->qty_pa_03->DbValue = $row['qty_pa_03'];
        $this->pa_04->DbValue = $row['pa_04'];
        $this->qty_pa_04->DbValue = $row['qty_pa_04'];
        $this->pa_05->DbValue = $row['pa_05'];
        $this->qty_pa_05->DbValue = $row['qty_pa_05'];
        $this->pc_01->DbValue = $row['pc_01'];
        $this->qty_pc_01->DbValue = $row['qty_pc_01'];
        $this->pc_02->DbValue = $row['pc_02'];
        $this->qty_pc_02->DbValue = $row['qty_pc_02'];
        $this->o_01->DbValue = $row['o_01'];
        $this->qty_o_01->DbValue = $row['qty_o_01'];
        $this->lamination_type->DbValue = $row['lamination_type'];
        $this->lamination_qty->DbValue = $row['lamination_qty'];
        $this->die_type->DbValue = $row['die_type'];
        $this->die_qty->DbValue = $row['die_qty'];
        $this->binding_type->DbValue = $row['binding_type'];
        $this->binding_qty->DbValue = $row['binding_qty'];
        $this->number_type->DbValue = $row['number_type'];
        $this->number_qty->DbValue = $row['number_qty'];
        $this->de_01->DbValue = $row['de_01'];
        $this->qty_de_01->DbValue = $row['qty_de_01'];
        $this->de_02->DbValue = $row['de_02'];
        $this->qty_de_02->DbValue = $row['qty_de_02'];
        $this->de_03->DbValue = $row['de_03'];
        $this->qty_de_03->DbValue = $row['qty_de_03'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("peastimatelist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "peastimateview" => $Language->phrase("View"),
            "peastimateedit" => $Language->phrase("Edit"),
            "peastimateadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "peastimatelist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PEastimateView",
            Config("API_ADD_ACTION") => "PEastimateAdd",
            Config("API_EDIT_ACTION") => "PEastimateEdit",
            Config("API_DELETE_ACTION") => "PEastimateDelete",
            Config("API_LIST_ACTION") => "PEastimateList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "peastimatelist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("peastimateview", $parm);
        } else {
            $url = $this->keyUrl("peastimateview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "peastimateadd?" . $parm;
        } else {
            $url = "peastimateadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("peastimateedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("peastimatelist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("peastimateadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("peastimatelist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("peastimatedelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->job_type->setDbValue($row['job_type']);
        $this->job_category->setDbValue($row['job_category']);
        $this->company_id->setDbValue($row['company_id']);
        $this->description->setDbValue($row['description']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->pages->setDbValue($row['pages']);
        $this->paper->setDbValue($row['paper']);
        $this->remarks->setDbValue($row['remarks']);
        $this->pr_01->setDbValue($row['pr_01']);
        $this->qty_pr_01->setDbValue($row['qty_pr_01']);
        $this->pl_01->setDbValue($row['pl_01']);
        $this->qty_pl_01->setDbValue($row['qty_pl_01']);
        $this->pr_02->setDbValue($row['pr_02']);
        $this->qty_pr_02->setDbValue($row['qty_pr_02']);
        $this->pl_02->setDbValue($row['pl_02']);
        $this->qty_pl_02->setDbValue($row['qty_pl_02']);
        $this->pr_03->setDbValue($row['pr_03']);
        $this->qty_pr_03->setDbValue($row['qty_pr_03']);
        $this->pl_03->setDbValue($row['pl_03']);
        $this->qty_pl_03->setDbValue($row['qty_pl_03']);
        $this->pr_04->setDbValue($row['pr_04']);
        $this->qty_pr_04->setDbValue($row['qty_pr_04']);
        $this->pl_04->setDbValue($row['pl_04']);
        $this->qty_pl_04->setDbValue($row['qty_pl_04']);
        $this->pa_01->setDbValue($row['pa_01']);
        $this->qty_pa_01->setDbValue($row['qty_pa_01']);
        $this->pa_02->setDbValue($row['pa_02']);
        $this->qty_pa_02->setDbValue($row['qty_pa_02']);
        $this->pa_03->setDbValue($row['pa_03']);
        $this->qty_pa_03->setDbValue($row['qty_pa_03']);
        $this->pa_04->setDbValue($row['pa_04']);
        $this->qty_pa_04->setDbValue($row['qty_pa_04']);
        $this->pa_05->setDbValue($row['pa_05']);
        $this->qty_pa_05->setDbValue($row['qty_pa_05']);
        $this->pc_01->setDbValue($row['pc_01']);
        $this->qty_pc_01->setDbValue($row['qty_pc_01']);
        $this->pc_02->setDbValue($row['pc_02']);
        $this->qty_pc_02->setDbValue($row['qty_pc_02']);
        $this->o_01->setDbValue($row['o_01']);
        $this->qty_o_01->setDbValue($row['qty_o_01']);
        $this->lamination_type->setDbValue($row['lamination_type']);
        $this->lamination_qty->setDbValue($row['lamination_qty']);
        $this->die_type->setDbValue($row['die_type']);
        $this->die_qty->setDbValue($row['die_qty']);
        $this->binding_type->setDbValue($row['binding_type']);
        $this->binding_qty->setDbValue($row['binding_qty']);
        $this->number_type->setDbValue($row['number_type']);
        $this->number_qty->setDbValue($row['number_qty']);
        $this->de_01->setDbValue($row['de_01']);
        $this->qty_de_01->setDbValue($row['qty_de_01']);
        $this->de_02->setDbValue($row['de_02']);
        $this->qty_de_02->setDbValue($row['qty_de_02']);
        $this->de_03->setDbValue($row['de_03']);
        $this->qty_de_03->setDbValue($row['qty_de_03']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PEastimateList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // job_type

        // job_category

        // company_id

        // description

        // size

        // quantity

        // pages

        // paper

        // remarks

        // pr_01

        // qty_pr_01

        // pl_01

        // qty_pl_01

        // pr_02

        // qty_pr_02

        // pl_02

        // qty_pl_02

        // pr_03

        // qty_pr_03

        // pl_03

        // qty_pl_03

        // pr_04

        // qty_pr_04

        // pl_04

        // qty_pl_04

        // pa_01

        // qty_pa_01

        // pa_02

        // qty_pa_02

        // pa_03

        // qty_pa_03

        // pa_04

        // qty_pa_04

        // pa_05

        // qty_pa_05

        // pc_01

        // qty_pc_01

        // pc_02

        // qty_pc_02

        // o_01

        // qty_o_01

        // lamination_type

        // lamination_qty

        // die_type

        // die_qty

        // binding_type

        // binding_qty

        // number_type

        // number_qty

        // de_01

        // qty_de_01

        // de_02

        // qty_de_02

        // de_03

        // qty_de_03

        // operator

        // datetime

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // job_type
        if (strval($this->job_type->CurrentValue) != "") {
            $this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
        } else {
            $this->job_type->ViewValue = null;
        }

        // job_category
        if (strval($this->job_category->CurrentValue) != "") {
            $this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
        } else {
            $this->job_category->ViewValue = null;
        }

        // company_id
        $this->company_id->ViewValue = $this->company_id->CurrentValue;
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // description
        $this->description->ViewValue = $this->description->CurrentValue;

        // size
        $curVal = strval($this->size->CurrentValue);
        if ($curVal != "") {
            $this->size->ViewValue = $this->size->lookupCacheOption($curVal);
            if ($this->size->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->size->Lookup->getTable()->Fields["description"]->searchExpression(), "=", $curVal, $this->size->Lookup->getTable()->Fields["description"]->searchDataType(), "");
                $lookupFilter = $this->size->getSelectFilter($this); // PHP
                $sqlWrk = $this->size->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->size->Lookup->renderViewRow($rswrk[0]);
                    $this->size->ViewValue = $this->size->displayValue($arwrk);
                } else {
                    $this->size->ViewValue = $this->size->CurrentValue;
                }
            }
        } else {
            $this->size->ViewValue = null;
        }

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // pages
        $this->pages->ViewValue = $this->pages->CurrentValue;

        // paper
        $this->paper->ViewValue = $this->paper->CurrentValue;
        $this->paper->ViewValue = FormatNumber($this->paper->ViewValue, $this->paper->formatPattern());

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // pr_01
        $curVal = strval($this->pr_01->CurrentValue);
        if ($curVal != "") {
            $this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
            if ($this->pr_01->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pr_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pr_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pr_01->Lookup->renderViewRow($rswrk[0]);
                    $this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
                } else {
                    $this->pr_01->ViewValue = $this->pr_01->CurrentValue;
                }
            }
        } else {
            $this->pr_01->ViewValue = null;
        }

        // qty_pr_01
        $this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
        $this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, $this->qty_pr_01->formatPattern());

        // pl_01
        $curVal = strval($this->pl_01->CurrentValue);
        if ($curVal != "") {
            $this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
            if ($this->pl_01->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pl_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pl_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pl_01->Lookup->renderViewRow($rswrk[0]);
                    $this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
                } else {
                    $this->pl_01->ViewValue = $this->pl_01->CurrentValue;
                }
            }
        } else {
            $this->pl_01->ViewValue = null;
        }

        // qty_pl_01
        $this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
        $this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, $this->qty_pl_01->formatPattern());

        // pr_02
        $curVal = strval($this->pr_02->CurrentValue);
        if ($curVal != "") {
            $this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
            if ($this->pr_02->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pr_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pr_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pr_02->Lookup->renderViewRow($rswrk[0]);
                    $this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
                } else {
                    $this->pr_02->ViewValue = $this->pr_02->CurrentValue;
                }
            }
        } else {
            $this->pr_02->ViewValue = null;
        }

        // qty_pr_02
        $this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
        $this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, $this->qty_pr_02->formatPattern());

        // pl_02
        $curVal = strval($this->pl_02->CurrentValue);
        if ($curVal != "") {
            $this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
            if ($this->pl_02->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pl_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pl_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pl_02->Lookup->renderViewRow($rswrk[0]);
                    $this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
                } else {
                    $this->pl_02->ViewValue = $this->pl_02->CurrentValue;
                }
            }
        } else {
            $this->pl_02->ViewValue = null;
        }

        // qty_pl_02
        $this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
        $this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, $this->qty_pl_02->formatPattern());

        // pr_03
        $curVal = strval($this->pr_03->CurrentValue);
        if ($curVal != "") {
            $this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
            if ($this->pr_03->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pr_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pr_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pr_03->Lookup->renderViewRow($rswrk[0]);
                    $this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
                } else {
                    $this->pr_03->ViewValue = $this->pr_03->CurrentValue;
                }
            }
        } else {
            $this->pr_03->ViewValue = null;
        }

        // qty_pr_03
        $this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
        $this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, $this->qty_pr_03->formatPattern());

        // pl_03
        $curVal = strval($this->pl_03->CurrentValue);
        if ($curVal != "") {
            $this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
            if ($this->pl_03->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pl_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pl_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pl_03->Lookup->renderViewRow($rswrk[0]);
                    $this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
                } else {
                    $this->pl_03->ViewValue = $this->pl_03->CurrentValue;
                }
            }
        } else {
            $this->pl_03->ViewValue = null;
        }

        // qty_pl_03
        $this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
        $this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, $this->qty_pl_03->formatPattern());

        // pr_04
        $curVal = strval($this->pr_04->CurrentValue);
        if ($curVal != "") {
            $this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
            if ($this->pr_04->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pr_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pr_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pr_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pr_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pr_04->Lookup->renderViewRow($rswrk[0]);
                    $this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
                } else {
                    $this->pr_04->ViewValue = $this->pr_04->CurrentValue;
                }
            }
        } else {
            $this->pr_04->ViewValue = null;
        }

        // qty_pr_04
        $this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
        $this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, $this->qty_pr_04->formatPattern());

        // pl_04
        $curVal = strval($this->pl_04->CurrentValue);
        if ($curVal != "") {
            $this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
            if ($this->pl_04->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pl_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pl_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pl_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pl_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pl_04->Lookup->renderViewRow($rswrk[0]);
                    $this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
                } else {
                    $this->pl_04->ViewValue = $this->pl_04->CurrentValue;
                }
            }
        } else {
            $this->pl_04->ViewValue = null;
        }

        // qty_pl_04
        $this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
        $this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, $this->qty_pl_04->formatPattern());

        // pa_01
        $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
        $curVal = strval($this->pa_01->CurrentValue);
        if ($curVal != "") {
            $this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
            if ($this->pa_01->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pa_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pa_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pa_01->Lookup->renderViewRow($rswrk[0]);
                    $this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
                } else {
                    $this->pa_01->ViewValue = $this->pa_01->CurrentValue;
                }
            }
        } else {
            $this->pa_01->ViewValue = null;
        }

        // qty_pa_01
        $this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
        $this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, $this->qty_pa_01->formatPattern());

        // pa_02
        $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
        $curVal = strval($this->pa_02->CurrentValue);
        if ($curVal != "") {
            $this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
            if ($this->pa_02->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pa_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pa_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pa_02->Lookup->renderViewRow($rswrk[0]);
                    $this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
                } else {
                    $this->pa_02->ViewValue = $this->pa_02->CurrentValue;
                }
            }
        } else {
            $this->pa_02->ViewValue = null;
        }

        // qty_pa_02
        $this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
        $this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, $this->qty_pa_02->formatPattern());

        // pa_03
        $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
        $curVal = strval($this->pa_03->CurrentValue);
        if ($curVal != "") {
            $this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
            if ($this->pa_03->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pa_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pa_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pa_03->Lookup->renderViewRow($rswrk[0]);
                    $this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
                } else {
                    $this->pa_03->ViewValue = $this->pa_03->CurrentValue;
                }
            }
        } else {
            $this->pa_03->ViewValue = null;
        }

        // qty_pa_03
        $this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
        $this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, $this->qty_pa_03->formatPattern());

        // pa_04
        $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
        $curVal = strval($this->pa_04->CurrentValue);
        if ($curVal != "") {
            $this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
            if ($this->pa_04->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pa_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_04->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pa_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pa_04->Lookup->renderViewRow($rswrk[0]);
                    $this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
                } else {
                    $this->pa_04->ViewValue = $this->pa_04->CurrentValue;
                }
            }
        } else {
            $this->pa_04->ViewValue = null;
        }

        // qty_pa_04
        $this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
        $this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, $this->qty_pa_04->formatPattern());

        // pa_05
        $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
        $curVal = strval($this->pa_05->CurrentValue);
        if ($curVal != "") {
            $this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
            if ($this->pa_05->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pa_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pa_05->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pa_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->pa_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pa_05->Lookup->renderViewRow($rswrk[0]);
                    $this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
                } else {
                    $this->pa_05->ViewValue = $this->pa_05->CurrentValue;
                }
            }
        } else {
            $this->pa_05->ViewValue = null;
        }

        // qty_pa_05
        $this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
        $this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, $this->qty_pa_05->formatPattern());

        // pc_01
        $curVal = strval($this->pc_01->CurrentValue);
        if ($curVal != "") {
            $this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
            if ($this->pc_01->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pc_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pc_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->pc_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pc_01->Lookup->renderViewRow($rswrk[0]);
                    $this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
                } else {
                    $this->pc_01->ViewValue = $this->pc_01->CurrentValue;
                }
            }
        } else {
            $this->pc_01->ViewValue = null;
        }

        // qty_pc_01
        $this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
        $this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, $this->qty_pc_01->formatPattern());

        // pc_02
        $curVal = strval($this->pc_02->CurrentValue);
        if ($curVal != "") {
            $this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
            if ($this->pc_02->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pc_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pc_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pc_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->pc_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pc_02->Lookup->renderViewRow($rswrk[0]);
                    $this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
                } else {
                    $this->pc_02->ViewValue = $this->pc_02->CurrentValue;
                }
            }
        } else {
            $this->pc_02->ViewValue = null;
        }

        // qty_pc_02
        $this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
        $this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, $this->qty_pc_02->formatPattern());

        // o_01
        $curVal = strval($this->o_01->CurrentValue);
        if ($curVal != "") {
            $this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
            if ($this->o_01->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->o_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->o_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->o_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->o_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->o_01->Lookup->renderViewRow($rswrk[0]);
                    $this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
                } else {
                    $this->o_01->ViewValue = $this->o_01->CurrentValue;
                }
            }
        } else {
            $this->o_01->ViewValue = null;
        }

        // qty_o_01
        $this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
        $this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, $this->qty_o_01->formatPattern());

        // lamination_type
        $curVal = strval($this->lamination_type->CurrentValue);
        if ($curVal != "") {
            $this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
            if ($this->lamination_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->lamination_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->lamination_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->lamination_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->lamination_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->lamination_type->Lookup->renderViewRow($rswrk[0]);
                    $this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
                } else {
                    $this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
                }
            }
        } else {
            $this->lamination_type->ViewValue = null;
        }

        // lamination_qty
        $this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
        $this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, $this->lamination_qty->formatPattern());

        // die_type
        $curVal = strval($this->die_type->CurrentValue);
        if ($curVal != "") {
            $this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
            if ($this->die_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->die_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->die_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->die_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->die_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->die_type->Lookup->renderViewRow($rswrk[0]);
                    $this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
                } else {
                    $this->die_type->ViewValue = $this->die_type->CurrentValue;
                }
            }
        } else {
            $this->die_type->ViewValue = null;
        }

        // die_qty
        $this->die_qty->ViewValue = $this->die_qty->CurrentValue;
        $this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, $this->die_qty->formatPattern());

        // binding_type
        $curVal = strval($this->binding_type->CurrentValue);
        if ($curVal != "") {
            $this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
            if ($this->binding_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->binding_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->binding_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->binding_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->binding_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->binding_type->Lookup->renderViewRow($rswrk[0]);
                    $this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
                } else {
                    $this->binding_type->ViewValue = $this->binding_type->CurrentValue;
                }
            }
        } else {
            $this->binding_type->ViewValue = null;
        }

        // binding_qty
        $this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
        $this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, $this->binding_qty->formatPattern());

        // number_type
        $curVal = strval($this->number_type->CurrentValue);
        if ($curVal != "") {
            $this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
            if ($this->number_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->number_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->number_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->number_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->number_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->number_type->Lookup->renderViewRow($rswrk[0]);
                    $this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
                } else {
                    $this->number_type->ViewValue = $this->number_type->CurrentValue;
                }
            }
        } else {
            $this->number_type->ViewValue = null;
        }

        // number_qty
        $this->number_qty->ViewValue = $this->number_qty->CurrentValue;
        $this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, $this->number_qty->formatPattern());

        // de_01
        $curVal = strval($this->de_01->CurrentValue);
        if ($curVal != "") {
            $this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
            if ($this->de_01->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->de_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_01->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->de_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->de_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->de_01->Lookup->renderViewRow($rswrk[0]);
                    $this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
                } else {
                    $this->de_01->ViewValue = $this->de_01->CurrentValue;
                }
            }
        } else {
            $this->de_01->ViewValue = null;
        }

        // qty_de_01
        $this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
        $this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, $this->qty_de_01->formatPattern());

        // de_02
        $curVal = strval($this->de_02->CurrentValue);
        if ($curVal != "") {
            $this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
            if ($this->de_02->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->de_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_02->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->de_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->de_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->de_02->Lookup->renderViewRow($rswrk[0]);
                    $this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
                } else {
                    $this->de_02->ViewValue = $this->de_02->CurrentValue;
                }
            }
        } else {
            $this->de_02->ViewValue = null;
        }

        // qty_de_02
        $this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
        $this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, $this->qty_de_02->formatPattern());

        // de_03
        $curVal = strval($this->de_03->CurrentValue);
        if ($curVal != "") {
            $this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
            if ($this->de_03->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->de_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->de_03->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->de_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->de_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->de_03->Lookup->renderViewRow($rswrk[0]);
                    $this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
                } else {
                    $this->de_03->ViewValue = $this->de_03->CurrentValue;
                }
            }
        } else {
            $this->de_03->ViewValue = null;
        }

        // qty_de_03
        $this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
        $this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, $this->qty_de_03->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // job_type
        $this->job_type->HrefValue = "";
        $this->job_type->TooltipValue = "";

        // job_category
        $this->job_category->HrefValue = "";
        $this->job_category->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // description
        $this->description->HrefValue = "";
        $this->description->TooltipValue = "";

        // size
        $this->size->HrefValue = "";
        $this->size->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // pages
        $this->pages->HrefValue = "";
        $this->pages->TooltipValue = "";

        // paper
        $this->paper->HrefValue = "";
        $this->paper->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // pr_01
        $this->pr_01->HrefValue = "";
        $this->pr_01->TooltipValue = "";

        // qty_pr_01
        $this->qty_pr_01->HrefValue = "";
        $this->qty_pr_01->TooltipValue = "";

        // pl_01
        $this->pl_01->HrefValue = "";
        $this->pl_01->TooltipValue = "";

        // qty_pl_01
        $this->qty_pl_01->HrefValue = "";
        $this->qty_pl_01->TooltipValue = "";

        // pr_02
        $this->pr_02->HrefValue = "";
        $this->pr_02->TooltipValue = "";

        // qty_pr_02
        $this->qty_pr_02->HrefValue = "";
        $this->qty_pr_02->TooltipValue = "";

        // pl_02
        $this->pl_02->HrefValue = "";
        $this->pl_02->TooltipValue = "";

        // qty_pl_02
        $this->qty_pl_02->HrefValue = "";
        $this->qty_pl_02->TooltipValue = "";

        // pr_03
        $this->pr_03->HrefValue = "";
        $this->pr_03->TooltipValue = "";

        // qty_pr_03
        $this->qty_pr_03->HrefValue = "";
        $this->qty_pr_03->TooltipValue = "";

        // pl_03
        $this->pl_03->HrefValue = "";
        $this->pl_03->TooltipValue = "";

        // qty_pl_03
        $this->qty_pl_03->HrefValue = "";
        $this->qty_pl_03->TooltipValue = "";

        // pr_04
        $this->pr_04->HrefValue = "";
        $this->pr_04->TooltipValue = "";

        // qty_pr_04
        $this->qty_pr_04->HrefValue = "";
        $this->qty_pr_04->TooltipValue = "";

        // pl_04
        $this->pl_04->HrefValue = "";
        $this->pl_04->TooltipValue = "";

        // qty_pl_04
        $this->qty_pl_04->HrefValue = "";
        $this->qty_pl_04->TooltipValue = "";

        // pa_01
        $this->pa_01->HrefValue = "";
        $this->pa_01->TooltipValue = "";

        // qty_pa_01
        $this->qty_pa_01->HrefValue = "";
        $this->qty_pa_01->TooltipValue = "";

        // pa_02
        $this->pa_02->HrefValue = "";
        $this->pa_02->TooltipValue = "";

        // qty_pa_02
        $this->qty_pa_02->HrefValue = "";
        $this->qty_pa_02->TooltipValue = "";

        // pa_03
        $this->pa_03->HrefValue = "";
        $this->pa_03->TooltipValue = "";

        // qty_pa_03
        $this->qty_pa_03->HrefValue = "";
        $this->qty_pa_03->TooltipValue = "";

        // pa_04
        $this->pa_04->HrefValue = "";
        $this->pa_04->TooltipValue = "";

        // qty_pa_04
        $this->qty_pa_04->HrefValue = "";
        $this->qty_pa_04->TooltipValue = "";

        // pa_05
        $this->pa_05->HrefValue = "";
        $this->pa_05->TooltipValue = "";

        // qty_pa_05
        $this->qty_pa_05->HrefValue = "";
        $this->qty_pa_05->TooltipValue = "";

        // pc_01
        $this->pc_01->HrefValue = "";
        $this->pc_01->TooltipValue = "";

        // qty_pc_01
        $this->qty_pc_01->HrefValue = "";
        $this->qty_pc_01->TooltipValue = "";

        // pc_02
        $this->pc_02->HrefValue = "";
        $this->pc_02->TooltipValue = "";

        // qty_pc_02
        $this->qty_pc_02->HrefValue = "";
        $this->qty_pc_02->TooltipValue = "";

        // o_01
        $this->o_01->HrefValue = "";
        $this->o_01->TooltipValue = "";

        // qty_o_01
        $this->qty_o_01->HrefValue = "";
        $this->qty_o_01->TooltipValue = "";

        // lamination_type
        $this->lamination_type->HrefValue = "";
        $this->lamination_type->TooltipValue = "";

        // lamination_qty
        $this->lamination_qty->HrefValue = "";
        $this->lamination_qty->TooltipValue = "";

        // die_type
        $this->die_type->HrefValue = "";
        $this->die_type->TooltipValue = "";

        // die_qty
        $this->die_qty->HrefValue = "";
        $this->die_qty->TooltipValue = "";

        // binding_type
        $this->binding_type->HrefValue = "";
        $this->binding_type->TooltipValue = "";

        // binding_qty
        $this->binding_qty->HrefValue = "";
        $this->binding_qty->TooltipValue = "";

        // number_type
        $this->number_type->HrefValue = "";
        $this->number_type->TooltipValue = "";

        // number_qty
        $this->number_qty->HrefValue = "";
        $this->number_qty->TooltipValue = "";

        // de_01
        $this->de_01->HrefValue = "";
        $this->de_01->TooltipValue = "";

        // qty_de_01
        $this->qty_de_01->HrefValue = "";
        $this->qty_de_01->TooltipValue = "";

        // de_02
        $this->de_02->HrefValue = "";
        $this->de_02->TooltipValue = "";

        // qty_de_02
        $this->qty_de_02->HrefValue = "";
        $this->qty_de_02->TooltipValue = "";

        // de_03
        $this->de_03->HrefValue = "";
        $this->de_03->TooltipValue = "";

        // qty_de_03
        $this->qty_de_03->HrefValue = "";
        $this->qty_de_03->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

        // job_type
        $this->job_type->EditValue = $this->job_type->options(false);
        $this->job_type->PlaceHolder = RemoveHtml($this->job_type->caption());

        // job_category
        $this->job_category->EditValue = $this->job_category->options(false);
        $this->job_category->PlaceHolder = RemoveHtml($this->job_category->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->EditValue = $this->company_id->CurrentValue;
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // description
        $this->description->setupEditAttributes();
        if (!$this->description->Raw) {
            $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
        }
        $this->description->EditValue = $this->description->CurrentValue;
        $this->description->PlaceHolder = RemoveHtml($this->description->caption());

        // size
        $this->size->setupEditAttributes();
        $this->size->PlaceHolder = RemoveHtml($this->size->caption());

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // pages
        $this->pages->setupEditAttributes();
        if (!$this->pages->Raw) {
            $this->pages->CurrentValue = HtmlDecode($this->pages->CurrentValue);
        }
        $this->pages->EditValue = $this->pages->CurrentValue;
        $this->pages->PlaceHolder = RemoveHtml($this->pages->caption());

        // paper
        $this->paper->setupEditAttributes();
        $this->paper->EditValue = $this->paper->CurrentValue;
        $this->paper->PlaceHolder = RemoveHtml($this->paper->caption());
        if (strval($this->paper->EditValue) != "" && is_numeric($this->paper->EditValue)) {
            $this->paper->EditValue = FormatNumber($this->paper->EditValue, null);
        }

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // pr_01
        $this->pr_01->setupEditAttributes();
        $this->pr_01->PlaceHolder = RemoveHtml($this->pr_01->caption());

        // qty_pr_01
        $this->qty_pr_01->setupEditAttributes();
        $this->qty_pr_01->EditValue = $this->qty_pr_01->CurrentValue;
        $this->qty_pr_01->PlaceHolder = RemoveHtml($this->qty_pr_01->caption());
        if (strval($this->qty_pr_01->EditValue) != "" && is_numeric($this->qty_pr_01->EditValue)) {
            $this->qty_pr_01->EditValue = FormatNumber($this->qty_pr_01->EditValue, null);
        }

        // pl_01
        $this->pl_01->setupEditAttributes();
        $this->pl_01->PlaceHolder = RemoveHtml($this->pl_01->caption());

        // qty_pl_01
        $this->qty_pl_01->setupEditAttributes();
        $this->qty_pl_01->EditValue = $this->qty_pl_01->CurrentValue;
        $this->qty_pl_01->PlaceHolder = RemoveHtml($this->qty_pl_01->caption());
        if (strval($this->qty_pl_01->EditValue) != "" && is_numeric($this->qty_pl_01->EditValue)) {
            $this->qty_pl_01->EditValue = FormatNumber($this->qty_pl_01->EditValue, null);
        }

        // pr_02
        $this->pr_02->setupEditAttributes();
        $this->pr_02->PlaceHolder = RemoveHtml($this->pr_02->caption());

        // qty_pr_02
        $this->qty_pr_02->setupEditAttributes();
        $this->qty_pr_02->EditValue = $this->qty_pr_02->CurrentValue;
        $this->qty_pr_02->PlaceHolder = RemoveHtml($this->qty_pr_02->caption());
        if (strval($this->qty_pr_02->EditValue) != "" && is_numeric($this->qty_pr_02->EditValue)) {
            $this->qty_pr_02->EditValue = FormatNumber($this->qty_pr_02->EditValue, null);
        }

        // pl_02
        $this->pl_02->setupEditAttributes();
        $this->pl_02->PlaceHolder = RemoveHtml($this->pl_02->caption());

        // qty_pl_02
        $this->qty_pl_02->setupEditAttributes();
        $this->qty_pl_02->EditValue = $this->qty_pl_02->CurrentValue;
        $this->qty_pl_02->PlaceHolder = RemoveHtml($this->qty_pl_02->caption());
        if (strval($this->qty_pl_02->EditValue) != "" && is_numeric($this->qty_pl_02->EditValue)) {
            $this->qty_pl_02->EditValue = FormatNumber($this->qty_pl_02->EditValue, null);
        }

        // pr_03
        $this->pr_03->setupEditAttributes();
        $this->pr_03->PlaceHolder = RemoveHtml($this->pr_03->caption());

        // qty_pr_03
        $this->qty_pr_03->setupEditAttributes();
        $this->qty_pr_03->EditValue = $this->qty_pr_03->CurrentValue;
        $this->qty_pr_03->PlaceHolder = RemoveHtml($this->qty_pr_03->caption());
        if (strval($this->qty_pr_03->EditValue) != "" && is_numeric($this->qty_pr_03->EditValue)) {
            $this->qty_pr_03->EditValue = FormatNumber($this->qty_pr_03->EditValue, null);
        }

        // pl_03
        $this->pl_03->setupEditAttributes();
        $this->pl_03->PlaceHolder = RemoveHtml($this->pl_03->caption());

        // qty_pl_03
        $this->qty_pl_03->setupEditAttributes();
        $this->qty_pl_03->EditValue = $this->qty_pl_03->CurrentValue;
        $this->qty_pl_03->PlaceHolder = RemoveHtml($this->qty_pl_03->caption());
        if (strval($this->qty_pl_03->EditValue) != "" && is_numeric($this->qty_pl_03->EditValue)) {
            $this->qty_pl_03->EditValue = FormatNumber($this->qty_pl_03->EditValue, null);
        }

        // pr_04
        $this->pr_04->setupEditAttributes();
        $this->pr_04->PlaceHolder = RemoveHtml($this->pr_04->caption());

        // qty_pr_04
        $this->qty_pr_04->setupEditAttributes();
        $this->qty_pr_04->EditValue = $this->qty_pr_04->CurrentValue;
        $this->qty_pr_04->PlaceHolder = RemoveHtml($this->qty_pr_04->caption());
        if (strval($this->qty_pr_04->EditValue) != "" && is_numeric($this->qty_pr_04->EditValue)) {
            $this->qty_pr_04->EditValue = FormatNumber($this->qty_pr_04->EditValue, null);
        }

        // pl_04
        $this->pl_04->setupEditAttributes();
        $this->pl_04->PlaceHolder = RemoveHtml($this->pl_04->caption());

        // qty_pl_04
        $this->qty_pl_04->setupEditAttributes();
        $this->qty_pl_04->EditValue = $this->qty_pl_04->CurrentValue;
        $this->qty_pl_04->PlaceHolder = RemoveHtml($this->qty_pl_04->caption());
        if (strval($this->qty_pl_04->EditValue) != "" && is_numeric($this->qty_pl_04->EditValue)) {
            $this->qty_pl_04->EditValue = FormatNumber($this->qty_pl_04->EditValue, null);
        }

        // pa_01
        $this->pa_01->setupEditAttributes();
        if (!$this->pa_01->Raw) {
            $this->pa_01->CurrentValue = HtmlDecode($this->pa_01->CurrentValue);
        }
        $this->pa_01->EditValue = $this->pa_01->CurrentValue;
        $this->pa_01->PlaceHolder = RemoveHtml($this->pa_01->caption());

        // qty_pa_01
        $this->qty_pa_01->setupEditAttributes();
        $this->qty_pa_01->EditValue = $this->qty_pa_01->CurrentValue;
        $this->qty_pa_01->PlaceHolder = RemoveHtml($this->qty_pa_01->caption());
        if (strval($this->qty_pa_01->EditValue) != "" && is_numeric($this->qty_pa_01->EditValue)) {
            $this->qty_pa_01->EditValue = FormatNumber($this->qty_pa_01->EditValue, null);
        }

        // pa_02
        $this->pa_02->setupEditAttributes();
        if (!$this->pa_02->Raw) {
            $this->pa_02->CurrentValue = HtmlDecode($this->pa_02->CurrentValue);
        }
        $this->pa_02->EditValue = $this->pa_02->CurrentValue;
        $this->pa_02->PlaceHolder = RemoveHtml($this->pa_02->caption());

        // qty_pa_02
        $this->qty_pa_02->setupEditAttributes();
        $this->qty_pa_02->EditValue = $this->qty_pa_02->CurrentValue;
        $this->qty_pa_02->PlaceHolder = RemoveHtml($this->qty_pa_02->caption());
        if (strval($this->qty_pa_02->EditValue) != "" && is_numeric($this->qty_pa_02->EditValue)) {
            $this->qty_pa_02->EditValue = FormatNumber($this->qty_pa_02->EditValue, null);
        }

        // pa_03
        $this->pa_03->setupEditAttributes();
        if (!$this->pa_03->Raw) {
            $this->pa_03->CurrentValue = HtmlDecode($this->pa_03->CurrentValue);
        }
        $this->pa_03->EditValue = $this->pa_03->CurrentValue;
        $this->pa_03->PlaceHolder = RemoveHtml($this->pa_03->caption());

        // qty_pa_03
        $this->qty_pa_03->setupEditAttributes();
        $this->qty_pa_03->EditValue = $this->qty_pa_03->CurrentValue;
        $this->qty_pa_03->PlaceHolder = RemoveHtml($this->qty_pa_03->caption());
        if (strval($this->qty_pa_03->EditValue) != "" && is_numeric($this->qty_pa_03->EditValue)) {
            $this->qty_pa_03->EditValue = FormatNumber($this->qty_pa_03->EditValue, null);
        }

        // pa_04
        $this->pa_04->setupEditAttributes();
        if (!$this->pa_04->Raw) {
            $this->pa_04->CurrentValue = HtmlDecode($this->pa_04->CurrentValue);
        }
        $this->pa_04->EditValue = $this->pa_04->CurrentValue;
        $this->pa_04->PlaceHolder = RemoveHtml($this->pa_04->caption());

        // qty_pa_04
        $this->qty_pa_04->setupEditAttributes();
        $this->qty_pa_04->EditValue = $this->qty_pa_04->CurrentValue;
        $this->qty_pa_04->PlaceHolder = RemoveHtml($this->qty_pa_04->caption());
        if (strval($this->qty_pa_04->EditValue) != "" && is_numeric($this->qty_pa_04->EditValue)) {
            $this->qty_pa_04->EditValue = FormatNumber($this->qty_pa_04->EditValue, null);
        }

        // pa_05
        $this->pa_05->setupEditAttributes();
        if (!$this->pa_05->Raw) {
            $this->pa_05->CurrentValue = HtmlDecode($this->pa_05->CurrentValue);
        }
        $this->pa_05->EditValue = $this->pa_05->CurrentValue;
        $this->pa_05->PlaceHolder = RemoveHtml($this->pa_05->caption());

        // qty_pa_05
        $this->qty_pa_05->setupEditAttributes();
        $this->qty_pa_05->EditValue = $this->qty_pa_05->CurrentValue;
        $this->qty_pa_05->PlaceHolder = RemoveHtml($this->qty_pa_05->caption());
        if (strval($this->qty_pa_05->EditValue) != "" && is_numeric($this->qty_pa_05->EditValue)) {
            $this->qty_pa_05->EditValue = FormatNumber($this->qty_pa_05->EditValue, null);
        }

        // pc_01
        $this->pc_01->setupEditAttributes();
        $this->pc_01->PlaceHolder = RemoveHtml($this->pc_01->caption());

        // qty_pc_01
        $this->qty_pc_01->setupEditAttributes();
        $this->qty_pc_01->EditValue = $this->qty_pc_01->CurrentValue;
        $this->qty_pc_01->PlaceHolder = RemoveHtml($this->qty_pc_01->caption());
        if (strval($this->qty_pc_01->EditValue) != "" && is_numeric($this->qty_pc_01->EditValue)) {
            $this->qty_pc_01->EditValue = FormatNumber($this->qty_pc_01->EditValue, null);
        }

        // pc_02
        $this->pc_02->setupEditAttributes();
        $this->pc_02->PlaceHolder = RemoveHtml($this->pc_02->caption());

        // qty_pc_02
        $this->qty_pc_02->setupEditAttributes();
        $this->qty_pc_02->EditValue = $this->qty_pc_02->CurrentValue;
        $this->qty_pc_02->PlaceHolder = RemoveHtml($this->qty_pc_02->caption());
        if (strval($this->qty_pc_02->EditValue) != "" && is_numeric($this->qty_pc_02->EditValue)) {
            $this->qty_pc_02->EditValue = FormatNumber($this->qty_pc_02->EditValue, null);
        }

        // o_01
        $this->o_01->setupEditAttributes();
        $this->o_01->PlaceHolder = RemoveHtml($this->o_01->caption());

        // qty_o_01
        $this->qty_o_01->setupEditAttributes();
        $this->qty_o_01->EditValue = $this->qty_o_01->CurrentValue;
        $this->qty_o_01->PlaceHolder = RemoveHtml($this->qty_o_01->caption());
        if (strval($this->qty_o_01->EditValue) != "" && is_numeric($this->qty_o_01->EditValue)) {
            $this->qty_o_01->EditValue = FormatNumber($this->qty_o_01->EditValue, null);
        }

        // lamination_type
        $this->lamination_type->setupEditAttributes();
        $this->lamination_type->PlaceHolder = RemoveHtml($this->lamination_type->caption());

        // lamination_qty
        $this->lamination_qty->setupEditAttributes();
        $this->lamination_qty->EditValue = $this->lamination_qty->CurrentValue;
        $this->lamination_qty->PlaceHolder = RemoveHtml($this->lamination_qty->caption());
        if (strval($this->lamination_qty->EditValue) != "" && is_numeric($this->lamination_qty->EditValue)) {
            $this->lamination_qty->EditValue = FormatNumber($this->lamination_qty->EditValue, null);
        }

        // die_type
        $this->die_type->setupEditAttributes();
        $this->die_type->PlaceHolder = RemoveHtml($this->die_type->caption());

        // die_qty
        $this->die_qty->setupEditAttributes();
        $this->die_qty->EditValue = $this->die_qty->CurrentValue;
        $this->die_qty->PlaceHolder = RemoveHtml($this->die_qty->caption());
        if (strval($this->die_qty->EditValue) != "" && is_numeric($this->die_qty->EditValue)) {
            $this->die_qty->EditValue = FormatNumber($this->die_qty->EditValue, null);
        }

        // binding_type
        $this->binding_type->setupEditAttributes();
        $this->binding_type->PlaceHolder = RemoveHtml($this->binding_type->caption());

        // binding_qty
        $this->binding_qty->setupEditAttributes();
        $this->binding_qty->EditValue = $this->binding_qty->CurrentValue;
        $this->binding_qty->PlaceHolder = RemoveHtml($this->binding_qty->caption());
        if (strval($this->binding_qty->EditValue) != "" && is_numeric($this->binding_qty->EditValue)) {
            $this->binding_qty->EditValue = FormatNumber($this->binding_qty->EditValue, null);
        }

        // number_type
        $this->number_type->setupEditAttributes();
        $this->number_type->PlaceHolder = RemoveHtml($this->number_type->caption());

        // number_qty
        $this->number_qty->setupEditAttributes();
        $this->number_qty->EditValue = $this->number_qty->CurrentValue;
        $this->number_qty->PlaceHolder = RemoveHtml($this->number_qty->caption());
        if (strval($this->number_qty->EditValue) != "" && is_numeric($this->number_qty->EditValue)) {
            $this->number_qty->EditValue = FormatNumber($this->number_qty->EditValue, null);
        }

        // de_01
        $this->de_01->setupEditAttributes();
        $this->de_01->PlaceHolder = RemoveHtml($this->de_01->caption());

        // qty_de_01
        $this->qty_de_01->setupEditAttributes();
        $this->qty_de_01->EditValue = $this->qty_de_01->CurrentValue;
        $this->qty_de_01->PlaceHolder = RemoveHtml($this->qty_de_01->caption());
        if (strval($this->qty_de_01->EditValue) != "" && is_numeric($this->qty_de_01->EditValue)) {
            $this->qty_de_01->EditValue = FormatNumber($this->qty_de_01->EditValue, null);
        }

        // de_02
        $this->de_02->setupEditAttributes();
        $this->de_02->PlaceHolder = RemoveHtml($this->de_02->caption());

        // qty_de_02
        $this->qty_de_02->setupEditAttributes();
        $this->qty_de_02->EditValue = $this->qty_de_02->CurrentValue;
        $this->qty_de_02->PlaceHolder = RemoveHtml($this->qty_de_02->caption());
        if (strval($this->qty_de_02->EditValue) != "" && is_numeric($this->qty_de_02->EditValue)) {
            $this->qty_de_02->EditValue = FormatNumber($this->qty_de_02->EditValue, null);
        }

        // de_03
        $this->de_03->setupEditAttributes();
        $this->de_03->PlaceHolder = RemoveHtml($this->de_03->caption());

        // qty_de_03
        $this->qty_de_03->setupEditAttributes();
        $this->qty_de_03->EditValue = $this->qty_de_03->CurrentValue;
        $this->qty_de_03->PlaceHolder = RemoveHtml($this->qty_de_03->caption());
        if (strval($this->qty_de_03->EditValue) != "" && is_numeric($this->qty_de_03->EditValue)) {
            $this->qty_de_03->EditValue = FormatNumber($this->qty_de_03->EditValue, null);
        }

        // operator

        // datetime

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->job_type);
                    $doc->exportCaption($this->job_category);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->size);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->pages);
                    $doc->exportCaption($this->paper);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->pr_01);
                    $doc->exportCaption($this->qty_pr_01);
                    $doc->exportCaption($this->pl_01);
                    $doc->exportCaption($this->qty_pl_01);
                    $doc->exportCaption($this->pr_02);
                    $doc->exportCaption($this->qty_pr_02);
                    $doc->exportCaption($this->pl_02);
                    $doc->exportCaption($this->qty_pl_02);
                    $doc->exportCaption($this->pr_03);
                    $doc->exportCaption($this->qty_pr_03);
                    $doc->exportCaption($this->pl_03);
                    $doc->exportCaption($this->qty_pl_03);
                    $doc->exportCaption($this->pr_04);
                    $doc->exportCaption($this->qty_pr_04);
                    $doc->exportCaption($this->pl_04);
                    $doc->exportCaption($this->qty_pl_04);
                    $doc->exportCaption($this->pa_01);
                    $doc->exportCaption($this->qty_pa_01);
                    $doc->exportCaption($this->pa_02);
                    $doc->exportCaption($this->qty_pa_02);
                    $doc->exportCaption($this->pa_03);
                    $doc->exportCaption($this->qty_pa_03);
                    $doc->exportCaption($this->pa_04);
                    $doc->exportCaption($this->qty_pa_04);
                    $doc->exportCaption($this->pa_05);
                    $doc->exportCaption($this->qty_pa_05);
                    $doc->exportCaption($this->pc_01);
                    $doc->exportCaption($this->qty_pc_01);
                    $doc->exportCaption($this->pc_02);
                    $doc->exportCaption($this->qty_pc_02);
                    $doc->exportCaption($this->o_01);
                    $doc->exportCaption($this->qty_o_01);
                    $doc->exportCaption($this->lamination_type);
                    $doc->exportCaption($this->lamination_qty);
                    $doc->exportCaption($this->die_type);
                    $doc->exportCaption($this->die_qty);
                    $doc->exportCaption($this->binding_type);
                    $doc->exportCaption($this->binding_qty);
                    $doc->exportCaption($this->number_type);
                    $doc->exportCaption($this->number_qty);
                    $doc->exportCaption($this->de_01);
                    $doc->exportCaption($this->qty_de_01);
                    $doc->exportCaption($this->de_02);
                    $doc->exportCaption($this->qty_de_02);
                    $doc->exportCaption($this->de_03);
                    $doc->exportCaption($this->qty_de_03);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->job_type);
                    $doc->exportCaption($this->job_category);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->size);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->pages);
                    $doc->exportCaption($this->paper);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->pr_01);
                    $doc->exportCaption($this->qty_pr_01);
                    $doc->exportCaption($this->pl_01);
                    $doc->exportCaption($this->qty_pl_01);
                    $doc->exportCaption($this->pr_02);
                    $doc->exportCaption($this->qty_pr_02);
                    $doc->exportCaption($this->pl_02);
                    $doc->exportCaption($this->qty_pl_02);
                    $doc->exportCaption($this->pr_03);
                    $doc->exportCaption($this->qty_pr_03);
                    $doc->exportCaption($this->pl_03);
                    $doc->exportCaption($this->qty_pl_03);
                    $doc->exportCaption($this->pr_04);
                    $doc->exportCaption($this->qty_pr_04);
                    $doc->exportCaption($this->pl_04);
                    $doc->exportCaption($this->qty_pl_04);
                    $doc->exportCaption($this->pa_01);
                    $doc->exportCaption($this->qty_pa_01);
                    $doc->exportCaption($this->pa_02);
                    $doc->exportCaption($this->qty_pa_02);
                    $doc->exportCaption($this->pa_03);
                    $doc->exportCaption($this->qty_pa_03);
                    $doc->exportCaption($this->pa_04);
                    $doc->exportCaption($this->qty_pa_04);
                    $doc->exportCaption($this->pa_05);
                    $doc->exportCaption($this->qty_pa_05);
                    $doc->exportCaption($this->pc_01);
                    $doc->exportCaption($this->qty_pc_01);
                    $doc->exportCaption($this->pc_02);
                    $doc->exportCaption($this->qty_pc_02);
                    $doc->exportCaption($this->o_01);
                    $doc->exportCaption($this->qty_o_01);
                    $doc->exportCaption($this->lamination_type);
                    $doc->exportCaption($this->lamination_qty);
                    $doc->exportCaption($this->die_type);
                    $doc->exportCaption($this->die_qty);
                    $doc->exportCaption($this->binding_type);
                    $doc->exportCaption($this->binding_qty);
                    $doc->exportCaption($this->number_type);
                    $doc->exportCaption($this->number_qty);
                    $doc->exportCaption($this->de_01);
                    $doc->exportCaption($this->qty_de_01);
                    $doc->exportCaption($this->de_02);
                    $doc->exportCaption($this->qty_de_02);
                    $doc->exportCaption($this->de_03);
                    $doc->exportCaption($this->qty_de_03);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->job_type);
                        $doc->exportField($this->job_category);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->description);
                        $doc->exportField($this->size);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->pages);
                        $doc->exportField($this->paper);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->pr_01);
                        $doc->exportField($this->qty_pr_01);
                        $doc->exportField($this->pl_01);
                        $doc->exportField($this->qty_pl_01);
                        $doc->exportField($this->pr_02);
                        $doc->exportField($this->qty_pr_02);
                        $doc->exportField($this->pl_02);
                        $doc->exportField($this->qty_pl_02);
                        $doc->exportField($this->pr_03);
                        $doc->exportField($this->qty_pr_03);
                        $doc->exportField($this->pl_03);
                        $doc->exportField($this->qty_pl_03);
                        $doc->exportField($this->pr_04);
                        $doc->exportField($this->qty_pr_04);
                        $doc->exportField($this->pl_04);
                        $doc->exportField($this->qty_pl_04);
                        $doc->exportField($this->pa_01);
                        $doc->exportField($this->qty_pa_01);
                        $doc->exportField($this->pa_02);
                        $doc->exportField($this->qty_pa_02);
                        $doc->exportField($this->pa_03);
                        $doc->exportField($this->qty_pa_03);
                        $doc->exportField($this->pa_04);
                        $doc->exportField($this->qty_pa_04);
                        $doc->exportField($this->pa_05);
                        $doc->exportField($this->qty_pa_05);
                        $doc->exportField($this->pc_01);
                        $doc->exportField($this->qty_pc_01);
                        $doc->exportField($this->pc_02);
                        $doc->exportField($this->qty_pc_02);
                        $doc->exportField($this->o_01);
                        $doc->exportField($this->qty_o_01);
                        $doc->exportField($this->lamination_type);
                        $doc->exportField($this->lamination_qty);
                        $doc->exportField($this->die_type);
                        $doc->exportField($this->die_qty);
                        $doc->exportField($this->binding_type);
                        $doc->exportField($this->binding_qty);
                        $doc->exportField($this->number_type);
                        $doc->exportField($this->number_qty);
                        $doc->exportField($this->de_01);
                        $doc->exportField($this->qty_de_01);
                        $doc->exportField($this->de_02);
                        $doc->exportField($this->qty_de_02);
                        $doc->exportField($this->de_03);
                        $doc->exportField($this->qty_de_03);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->job_type);
                        $doc->exportField($this->job_category);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->description);
                        $doc->exportField($this->size);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->pages);
                        $doc->exportField($this->paper);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->pr_01);
                        $doc->exportField($this->qty_pr_01);
                        $doc->exportField($this->pl_01);
                        $doc->exportField($this->qty_pl_01);
                        $doc->exportField($this->pr_02);
                        $doc->exportField($this->qty_pr_02);
                        $doc->exportField($this->pl_02);
                        $doc->exportField($this->qty_pl_02);
                        $doc->exportField($this->pr_03);
                        $doc->exportField($this->qty_pr_03);
                        $doc->exportField($this->pl_03);
                        $doc->exportField($this->qty_pl_03);
                        $doc->exportField($this->pr_04);
                        $doc->exportField($this->qty_pr_04);
                        $doc->exportField($this->pl_04);
                        $doc->exportField($this->qty_pl_04);
                        $doc->exportField($this->pa_01);
                        $doc->exportField($this->qty_pa_01);
                        $doc->exportField($this->pa_02);
                        $doc->exportField($this->qty_pa_02);
                        $doc->exportField($this->pa_03);
                        $doc->exportField($this->qty_pa_03);
                        $doc->exportField($this->pa_04);
                        $doc->exportField($this->qty_pa_04);
                        $doc->exportField($this->pa_05);
                        $doc->exportField($this->qty_pa_05);
                        $doc->exportField($this->pc_01);
                        $doc->exportField($this->qty_pc_01);
                        $doc->exportField($this->pc_02);
                        $doc->exportField($this->qty_pc_02);
                        $doc->exportField($this->o_01);
                        $doc->exportField($this->qty_o_01);
                        $doc->exportField($this->lamination_type);
                        $doc->exportField($this->lamination_qty);
                        $doc->exportField($this->die_type);
                        $doc->exportField($this->die_qty);
                        $doc->exportField($this->binding_type);
                        $doc->exportField($this->binding_qty);
                        $doc->exportField($this->number_type);
                        $doc->exportField($this->number_qty);
                        $doc->exportField($this->de_01);
                        $doc->exportField($this->qty_de_01);
                        $doc->exportField($this->de_02);
                        $doc->exportField($this->qty_de_02);
                        $doc->exportField($this->de_03);
                        $doc->exportField($this->qty_de_03);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
