<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class OtherAllSearch extends OtherAll
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "OtherAllSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "otherallsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->emp_id->setVisibility();
        $this->item->setVisibility();
        $this->quantity->setVisibility();
        $this->amount->setVisibility();
        $this->description->setVisibility();
        $this->upload->setVisibility();
        $this->payment->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->e_operator->setVisibility();
        $this->e_datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'other_all';
        $this->TableName = 'other_all';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (other_all)
        if (!isset($GLOBALS["other_all"]) || $GLOBALS["other_all"]::class == PROJECT_NAMESPACE . "other_all") {
            $GLOBALS["other_all"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'other_all');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "otherallview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
                $this->upload->UploadPath = $this->upload->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->emp_id);
        $this->setupLookupOptions($this->payment);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "otheralllist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->emp_id); // emp_id
        $this->buildSearchUrl($srchUrl, $this->item); // item
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->description); // description
        $this->buildSearchUrl($srchUrl, $this->upload); // upload
        $this->buildSearchUrl($srchUrl, $this->payment); // payment
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->e_operator); // e_operator
        $this->buildSearchUrl($srchUrl, $this->e_datetime); // e_datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // emp_id
        if ($this->emp_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->emp_id->AdvancedSearch->SearchValue)) {
            $this->emp_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->emp_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->emp_id->AdvancedSearch->SearchValue2)) {
            $this->emp_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->emp_id->AdvancedSearch->SearchValue2);
        }

        // item
        if ($this->item->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description
        if ($this->description->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // upload
        if ($this->upload->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // payment
        if ($this->payment->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // e_operator
        if ($this->e_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // e_datetime
        if ($this->e_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // emp_id
        $this->emp_id->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // upload
        $this->upload->RowCssClass = "row";

        // payment
        $this->payment->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // e_operator
        $this->e_operator->RowCssClass = "row";

        // e_datetime
        $this->e_datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // emp_id
            $curVal = strval($this->emp_id->CurrentValue);
            if ($curVal != "") {
                $this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
                if ($this->emp_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->emp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->emp_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->emp_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->emp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->emp_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->emp_id->Lookup->renderViewRow($row);
                            $this->emp_id->ViewValue->add($this->emp_id->displayValue($arwrk));
                        }
                    } else {
                        $this->emp_id->ViewValue = $this->emp_id->CurrentValue;
                    }
                }
            } else {
                $this->emp_id->ViewValue = null;
            }

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->ViewValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->ViewValue = "";
            }

            // payment
            $curVal = strval($this->payment->CurrentValue);
            if ($curVal != "") {
                $this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
                if ($this->payment->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->payment->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment->Lookup->renderViewRow($rswrk[0]);
                        $this->payment->ViewValue = $this->payment->displayValue($arwrk);
                    } else {
                        $this->payment->ViewValue = FormatNumber($this->payment->CurrentValue, $this->payment->formatPattern());
                    }
                }
            } else {
                $this->payment->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // e_operator
            $this->e_operator->ViewValue = $this->e_operator->CurrentValue;
            $this->e_operator->ViewValue = FormatNumber($this->e_operator->ViewValue, $this->e_operator->formatPattern());

            // e_datetime
            $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
            $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // emp_id
            $this->emp_id->HrefValue = "";
            $this->emp_id->TooltipValue = "";

            // item
            $this->item->HrefValue = "";
            $this->item->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = "%u"; // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
            $this->upload->TooltipValue = "";
            if ($this->upload->UseColorbox) {
                if (EmptyValue($this->upload->TooltipValue)) {
                    $this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->upload->LinkAttrs["data-rel"] = "other_all_x_upload";
                $this->upload->LinkAttrs->appendClass("ew-lightbox");
            }

            // payment
            $this->payment->HrefValue = "";
            $this->payment->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // e_operator
            $this->e_operator->HrefValue = "";
            $this->e_operator->TooltipValue = "";

            // e_datetime
            $this->e_datetime->HrefValue = "";
            $this->e_datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // location
            $this->location->setupEditAttributes();
            $this->location->EditCustomAttributes = $this->location->getEditCustomAttributes(); // PHP
            $curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->AdvancedSearch->SearchValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // emp_id
            $curVal = trim(strval($this->emp_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->emp_id->AdvancedSearch->ViewValue = $this->emp_id->lookupCacheOption($curVal);
            } else {
                $this->emp_id->AdvancedSearch->ViewValue = $this->emp_id->Lookup !== null && is_array($this->emp_id->lookupOptions()) && count($this->emp_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->emp_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->emp_id->EditValue = array_values($this->emp_id->lookupOptions());
                if ($this->emp_id->AdvancedSearch->ViewValue == "") {
                    $this->emp_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->emp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->emp_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->emp_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->emp_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->emp_id->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->emp_id->Lookup->renderViewRow($row);
                        $this->emp_id->AdvancedSearch->ViewValue->add($this->emp_id->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->emp_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->emp_id->Lookup->renderViewRow($row);
                }
                $this->emp_id->EditValue = $arwrk;
            }
            $this->emp_id->PlaceHolder = RemoveHtml($this->emp_id->caption());

            // item
            $this->item->setupEditAttributes();
            if (!$this->item->Raw) {
                $this->item->AdvancedSearch->SearchValue = HtmlDecode($this->item->AdvancedSearch->SearchValue);
            }
            $this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditCustomAttributes = $this->quantity->getEditCustomAttributes(); // PHP
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // description
            $this->description->setupEditAttributes();
            $this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // upload
            $this->upload->setupEditAttributes();
            if (!$this->upload->Raw) {
                $this->upload->AdvancedSearch->SearchValue = HtmlDecode($this->upload->AdvancedSearch->SearchValue);
            }
            $this->upload->EditValue = HtmlEncode($this->upload->AdvancedSearch->SearchValue);
            $this->upload->PlaceHolder = RemoveHtml($this->upload->caption());

            // payment
            $this->payment->setupEditAttributes();
            $curVal = trim(strval($this->payment->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->payment->AdvancedSearch->ViewValue = $this->payment->lookupCacheOption($curVal);
            } else {
                $this->payment->AdvancedSearch->ViewValue = $this->payment->Lookup !== null && is_array($this->payment->lookupOptions()) && count($this->payment->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->payment->EditValue = array_values($this->payment->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->payment->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->payment->AdvancedSearch->SearchValue, $this->payment->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->payment->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->payment->EditValue = $arwrk;
            }
            $this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // e_operator
            $this->e_operator->setupEditAttributes();
            $this->e_operator->EditValue = $this->e_operator->AdvancedSearch->SearchValue;
            $this->e_operator->PlaceHolder = RemoveHtml($this->e_operator->caption());

            // e_datetime
            $this->e_datetime->setupEditAttributes();
            $this->e_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->e_datetime->AdvancedSearch->SearchValue, $this->e_datetime->formatPattern()), $this->e_datetime->formatPattern()));
            $this->e_datetime->PlaceHolder = RemoveHtml($this->e_datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->quantity->AdvancedSearch->SearchValue)) {
            $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->e_operator->AdvancedSearch->SearchValue)) {
            $this->e_operator->addErrorMessage($this->e_operator->getErrorMessage(false));
        }
        if (!CheckDate($this->e_datetime->AdvancedSearch->SearchValue, $this->e_datetime->formatPattern())) {
            $this->e_datetime->addErrorMessage($this->e_datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->emp_id->AdvancedSearch->load();
        $this->item->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->upload->AdvancedSearch->load();
        $this->payment->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->e_operator->AdvancedSearch->load();
        $this->e_datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("otheralllist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_emp_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_payment":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
