<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class OmsTableEdit extends OmsTable
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "OmsTableEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "omstableedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->buyers_id->setVisibility();
        $this->reports_to->setVisibility();
        $this->buyer_order->setVisibility();
        $this->item->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->order_week->setVisibility();
        $this->order_date->setVisibility();
        $this->ex_factory->setVisibility();
        $this->ex_factory_p->setVisibility();
        $this->shipping_mode->setVisibility();
        $this->po->setVisibility();
        $this->design->setVisibility();
        $this->size_buyer->setVisibility();
        $this->width->setVisibility();
        $this->length->setVisibility();
        $this->qty->setVisibility();
        $this->revised_qty->setVisibility();
        $this->sqm->setVisibility();
        $this->d_qty->setVisibility();
        $this->pending->setVisibility();
        $this->pending_sqm->setVisibility();
        $this->offloom->setVisibility();
        $this->pending_offloom->setVisibility();
        $this->pending_offloom_sqm->setVisibility();
        $this->cbm->setVisibility();
        $this->total_cbm->setVisibility();
        $this->remarks->setVisibility();
        $this->pl_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->sailing_week->setVisibility();
        $this->seller_remarks->setVisibility();
        $this->status->setVisibility();
        $this->rejection->setVisibility();
        $this->completed->Visible = false;
        $this->url->Visible = false;
        $this->url2->Visible = false;
        $this->weight_sqm->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'oms_table';
        $this->TableName = 'oms_table';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (oms_table)
        if (!isset($GLOBALS["oms_table"]) || $GLOBALS["oms_table"]::class == PROJECT_NAMESPACE . "oms_table") {
            $GLOBALS["oms_table"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'oms_table');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "omstableview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->id->Required = false;
        $this->ex_factory_p->Required = false;
        $this->cbm->Required = false;
        $this->total_cbm->Required = false;
        $this->invoice_date->Required = false;
        $this->sailing_week->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->order_week);
        $this->setupLookupOptions($this->ex_factory);
        $this->setupLookupOptions($this->ex_factory_p);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->completed);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("omstablelist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "omstablelist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "omstablelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "omstablelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id->Visible = false; // Disable update for API request
            } else {
                $this->id->setFormValue($val);
            }
        }

        // Check field name 'buyers_id' first before field var 'x_buyers_id'
        $val = $CurrentForm->hasValue("buyers_id") ? $CurrentForm->getValue("buyers_id") : $CurrentForm->getValue("x_buyers_id");
        if (!$this->buyers_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyers_id->Visible = false; // Disable update for API request
            } else {
                $this->buyers_id->setFormValue($val);
            }
        }

        // Check field name 'reports_to' first before field var 'x_reports_to'
        $val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
        if (!$this->reports_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reports_to->Visible = false; // Disable update for API request
            } else {
                $this->reports_to->setFormValue($val);
            }
        }

        // Check field name 'buyer_order' first before field var 'x_buyer_order'
        $val = $CurrentForm->hasValue("buyer_order") ? $CurrentForm->getValue("buyer_order") : $CurrentForm->getValue("x_buyer_order");
        if (!$this->buyer_order->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_order->Visible = false; // Disable update for API request
            } else {
                $this->buyer_order->setFormValue($val);
            }
        }

        // Check field name 'item' first before field var 'x_item'
        $val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
        if (!$this->item->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->item->Visible = false; // Disable update for API request
            } else {
                $this->item->setFormValue($val);
            }
        }

        // Check field name 'buyer_ref' first before field var 'x_buyer_ref'
        $val = $CurrentForm->hasValue("buyer_ref") ? $CurrentForm->getValue("buyer_ref") : $CurrentForm->getValue("x_buyer_ref");
        if (!$this->buyer_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_ref->Visible = false; // Disable update for API request
            } else {
                $this->buyer_ref->setFormValue($val);
            }
        }

        // Check field name 'order_week' first before field var 'x_order_week'
        $val = $CurrentForm->hasValue("order_week") ? $CurrentForm->getValue("order_week") : $CurrentForm->getValue("x_order_week");
        if (!$this->order_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_week->Visible = false; // Disable update for API request
            } else {
                $this->order_week->setFormValue($val);
            }
        }

        // Check field name 'order_date' first before field var 'x_order_date'
        $val = $CurrentForm->hasValue("order_date") ? $CurrentForm->getValue("order_date") : $CurrentForm->getValue("x_order_date");
        if (!$this->order_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->order_date->Visible = false; // Disable update for API request
            } else {
                $this->order_date->setFormValue($val);
            }
            $this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        }

        // Check field name 'ex_factory' first before field var 'x_ex_factory'
        $val = $CurrentForm->hasValue("ex_factory") ? $CurrentForm->getValue("ex_factory") : $CurrentForm->getValue("x_ex_factory");
        if (!$this->ex_factory->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ex_factory->Visible = false; // Disable update for API request
            } else {
                $this->ex_factory->setFormValue($val);
            }
        }

        // Check field name 'ex_factory_p' first before field var 'x_ex_factory_p'
        $val = $CurrentForm->hasValue("ex_factory_p") ? $CurrentForm->getValue("ex_factory_p") : $CurrentForm->getValue("x_ex_factory_p");
        if (!$this->ex_factory_p->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ex_factory_p->Visible = false; // Disable update for API request
            } else {
                $this->ex_factory_p->setFormValue($val);
            }
        }

        // Check field name 'shipping_mode' first before field var 'x_shipping_mode'
        $val = $CurrentForm->hasValue("shipping_mode") ? $CurrentForm->getValue("shipping_mode") : $CurrentForm->getValue("x_shipping_mode");
        if (!$this->shipping_mode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipping_mode->Visible = false; // Disable update for API request
            } else {
                $this->shipping_mode->setFormValue($val);
            }
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val);
            }
        }

        // Check field name 'design' first before field var 'x_design'
        $val = $CurrentForm->hasValue("design") ? $CurrentForm->getValue("design") : $CurrentForm->getValue("x_design");
        if (!$this->design->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->design->Visible = false; // Disable update for API request
            } else {
                $this->design->setFormValue($val);
            }
        }

        // Check field name 'size_buyer' first before field var 'x_size_buyer'
        $val = $CurrentForm->hasValue("size_buyer") ? $CurrentForm->getValue("size_buyer") : $CurrentForm->getValue("x_size_buyer");
        if (!$this->size_buyer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_buyer->Visible = false; // Disable update for API request
            } else {
                $this->size_buyer->setFormValue($val);
            }
        }

        // Check field name 'width' first before field var 'x_width'
        $val = $CurrentForm->hasValue("width") ? $CurrentForm->getValue("width") : $CurrentForm->getValue("x_width");
        if (!$this->width->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->width->Visible = false; // Disable update for API request
            } else {
                $this->width->setFormValue($val);
            }
        }

        // Check field name 'length' first before field var 'x_length'
        $val = $CurrentForm->hasValue("length") ? $CurrentForm->getValue("length") : $CurrentForm->getValue("x_length");
        if (!$this->length->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->length->Visible = false; // Disable update for API request
            } else {
                $this->length->setFormValue($val);
            }
        }

        // Check field name 'qty' first before field var 'x_qty'
        $val = $CurrentForm->hasValue("qty") ? $CurrentForm->getValue("qty") : $CurrentForm->getValue("x_qty");
        if (!$this->qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty->Visible = false; // Disable update for API request
            } else {
                $this->qty->setFormValue($val);
            }
        }

        // Check field name 'revised_qty' first before field var 'x_revised_qty'
        $val = $CurrentForm->hasValue("revised_qty") ? $CurrentForm->getValue("revised_qty") : $CurrentForm->getValue("x_revised_qty");
        if (!$this->revised_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->revised_qty->Visible = false; // Disable update for API request
            } else {
                $this->revised_qty->setFormValue($val);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val);
            }
        }

        // Check field name 'd_qty' first before field var 'x_d_qty'
        $val = $CurrentForm->hasValue("d_qty") ? $CurrentForm->getValue("d_qty") : $CurrentForm->getValue("x_d_qty");
        if (!$this->d_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_qty->Visible = false; // Disable update for API request
            } else {
                $this->d_qty->setFormValue($val);
            }
        }

        // Check field name 'pending' first before field var 'x_pending'
        $val = $CurrentForm->hasValue("pending") ? $CurrentForm->getValue("pending") : $CurrentForm->getValue("x_pending");
        if (!$this->pending->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pending->Visible = false; // Disable update for API request
            } else {
                $this->pending->setFormValue($val);
            }
        }

        // Check field name 'pending_sqm' first before field var 'x_pending_sqm'
        $val = $CurrentForm->hasValue("pending_sqm") ? $CurrentForm->getValue("pending_sqm") : $CurrentForm->getValue("x_pending_sqm");
        if (!$this->pending_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pending_sqm->Visible = false; // Disable update for API request
            } else {
                $this->pending_sqm->setFormValue($val);
            }
        }

        // Check field name 'offloom' first before field var 'x_offloom'
        $val = $CurrentForm->hasValue("offloom") ? $CurrentForm->getValue("offloom") : $CurrentForm->getValue("x_offloom");
        if (!$this->offloom->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->offloom->Visible = false; // Disable update for API request
            } else {
                $this->offloom->setFormValue($val);
            }
        }

        // Check field name 'pending_offloom' first before field var 'x_pending_offloom'
        $val = $CurrentForm->hasValue("pending_offloom") ? $CurrentForm->getValue("pending_offloom") : $CurrentForm->getValue("x_pending_offloom");
        if (!$this->pending_offloom->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pending_offloom->Visible = false; // Disable update for API request
            } else {
                $this->pending_offloom->setFormValue($val);
            }
        }

        // Check field name 'pending_offloom_sqm' first before field var 'x_pending_offloom_sqm'
        $val = $CurrentForm->hasValue("pending_offloom_sqm") ? $CurrentForm->getValue("pending_offloom_sqm") : $CurrentForm->getValue("x_pending_offloom_sqm");
        if (!$this->pending_offloom_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pending_offloom_sqm->Visible = false; // Disable update for API request
            } else {
                $this->pending_offloom_sqm->setFormValue($val);
            }
        }

        // Check field name 'cbm' first before field var 'x_cbm'
        $val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
        if (!$this->cbm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cbm->Visible = false; // Disable update for API request
            } else {
                $this->cbm->setFormValue($val);
            }
        }

        // Check field name 'total_cbm' first before field var 'x_total_cbm'
        $val = $CurrentForm->hasValue("total_cbm") ? $CurrentForm->getValue("total_cbm") : $CurrentForm->getValue("x_total_cbm");
        if (!$this->total_cbm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->total_cbm->Visible = false; // Disable update for API request
            } else {
                $this->total_cbm->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'pl_no' first before field var 'x_pl_no'
        $val = $CurrentForm->hasValue("pl_no") ? $CurrentForm->getValue("pl_no") : $CurrentForm->getValue("x_pl_no");
        if (!$this->pl_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pl_no->Visible = false; // Disable update for API request
            } else {
                $this->pl_no->setFormValue($val);
            }
        }

        // Check field name 'invoice_date' first before field var 'x_invoice_date'
        $val = $CurrentForm->hasValue("invoice_date") ? $CurrentForm->getValue("invoice_date") : $CurrentForm->getValue("x_invoice_date");
        if (!$this->invoice_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_date->Visible = false; // Disable update for API request
            } else {
                $this->invoice_date->setFormValue($val);
            }
            $this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        }

        // Check field name 'sailing_week' first before field var 'x_sailing_week'
        $val = $CurrentForm->hasValue("sailing_week") ? $CurrentForm->getValue("sailing_week") : $CurrentForm->getValue("x_sailing_week");
        if (!$this->sailing_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sailing_week->Visible = false; // Disable update for API request
            } else {
                $this->sailing_week->setFormValue($val);
            }
        }

        // Check field name 'seller_remarks' first before field var 'x_seller_remarks'
        $val = $CurrentForm->hasValue("seller_remarks") ? $CurrentForm->getValue("seller_remarks") : $CurrentForm->getValue("x_seller_remarks");
        if (!$this->seller_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->seller_remarks->Visible = false; // Disable update for API request
            } else {
                $this->seller_remarks->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'rejection' first before field var 'x_rejection'
        $val = $CurrentForm->hasValue("rejection") ? $CurrentForm->getValue("rejection") : $CurrentForm->getValue("x_rejection");
        if (!$this->rejection->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rejection->Visible = false; // Disable update for API request
            } else {
                $this->rejection->setFormValue($val);
            }
        }

        // Check field name 'weight_sqm' first before field var 'x_weight_sqm'
        $val = $CurrentForm->hasValue("weight_sqm") ? $CurrentForm->getValue("weight_sqm") : $CurrentForm->getValue("x_weight_sqm");
        if (!$this->weight_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weight_sqm->Visible = false; // Disable update for API request
            } else {
                $this->weight_sqm->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->buyers_id->CurrentValue = $this->buyers_id->FormValue;
        $this->reports_to->CurrentValue = $this->reports_to->FormValue;
        $this->buyer_order->CurrentValue = $this->buyer_order->FormValue;
        $this->item->CurrentValue = $this->item->FormValue;
        $this->buyer_ref->CurrentValue = $this->buyer_ref->FormValue;
        $this->order_week->CurrentValue = $this->order_week->FormValue;
        $this->order_date->CurrentValue = $this->order_date->FormValue;
        $this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        $this->ex_factory->CurrentValue = $this->ex_factory->FormValue;
        $this->ex_factory_p->CurrentValue = $this->ex_factory_p->FormValue;
        $this->shipping_mode->CurrentValue = $this->shipping_mode->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->design->CurrentValue = $this->design->FormValue;
        $this->size_buyer->CurrentValue = $this->size_buyer->FormValue;
        $this->width->CurrentValue = $this->width->FormValue;
        $this->length->CurrentValue = $this->length->FormValue;
        $this->qty->CurrentValue = $this->qty->FormValue;
        $this->revised_qty->CurrentValue = $this->revised_qty->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->d_qty->CurrentValue = $this->d_qty->FormValue;
        $this->pending->CurrentValue = $this->pending->FormValue;
        $this->pending_sqm->CurrentValue = $this->pending_sqm->FormValue;
        $this->offloom->CurrentValue = $this->offloom->FormValue;
        $this->pending_offloom->CurrentValue = $this->pending_offloom->FormValue;
        $this->pending_offloom_sqm->CurrentValue = $this->pending_offloom_sqm->FormValue;
        $this->cbm->CurrentValue = $this->cbm->FormValue;
        $this->total_cbm->CurrentValue = $this->total_cbm->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->pl_no->CurrentValue = $this->pl_no->FormValue;
        $this->invoice_date->CurrentValue = $this->invoice_date->FormValue;
        $this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        $this->sailing_week->CurrentValue = $this->sailing_week->FormValue;
        $this->seller_remarks->CurrentValue = $this->seller_remarks->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->rejection->CurrentValue = $this->rejection->FormValue;
        $this->weight_sqm->CurrentValue = $this->weight_sqm->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->buyer_order->setDbValue($row['buyer_order']);
        $this->item->setDbValue($row['item']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->order_week->setDbValue($row['order_week']);
        $this->order_date->setDbValue($row['order_date']);
        $this->ex_factory->setDbValue($row['ex_factory']);
        $this->ex_factory_p->setDbValue($row['ex_factory_p']);
        $this->shipping_mode->setDbValue($row['shipping_mode']);
        $this->po->setDbValue($row['po']);
        $this->design->setDbValue($row['design']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->width->setDbValue($row['width']);
        $this->length->setDbValue($row['length']);
        $this->qty->setDbValue($row['qty']);
        $this->revised_qty->setDbValue($row['revised_qty']);
        $this->sqm->setDbValue($row['sqm']);
        $this->d_qty->setDbValue($row['d_qty']);
        $this->pending->setDbValue($row['pending']);
        $this->pending_sqm->setDbValue($row['pending_sqm']);
        $this->offloom->setDbValue($row['offloom']);
        $this->pending_offloom->setDbValue($row['pending_offloom']);
        $this->pending_offloom_sqm->setDbValue($row['pending_offloom_sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->total_cbm->setDbValue($row['total_cbm']);
        $this->remarks->setDbValue($row['remarks']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->sailing_week->setDbValue($row['sailing_week']);
        $this->seller_remarks->setDbValue($row['seller_remarks']);
        $this->status->setDbValue($row['status']);
        $this->rejection->setDbValue($row['rejection']);
        $this->completed->setDbValue($row['completed']);
        $this->url->setDbValue($row['url']);
        $this->url2->setDbValue($row['url2']);
        $this->weight_sqm->setDbValue($row['weight_sqm']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['buyer_order'] = $this->buyer_order->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['order_week'] = $this->order_week->DefaultValue;
        $row['order_date'] = $this->order_date->DefaultValue;
        $row['ex_factory'] = $this->ex_factory->DefaultValue;
        $row['ex_factory_p'] = $this->ex_factory_p->DefaultValue;
        $row['shipping_mode'] = $this->shipping_mode->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['size_buyer'] = $this->size_buyer->DefaultValue;
        $row['width'] = $this->width->DefaultValue;
        $row['length'] = $this->length->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['revised_qty'] = $this->revised_qty->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['d_qty'] = $this->d_qty->DefaultValue;
        $row['pending'] = $this->pending->DefaultValue;
        $row['pending_sqm'] = $this->pending_sqm->DefaultValue;
        $row['offloom'] = $this->offloom->DefaultValue;
        $row['pending_offloom'] = $this->pending_offloom->DefaultValue;
        $row['pending_offloom_sqm'] = $this->pending_offloom_sqm->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['total_cbm'] = $this->total_cbm->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['pl_no'] = $this->pl_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['sailing_week'] = $this->sailing_week->DefaultValue;
        $row['seller_remarks'] = $this->seller_remarks->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['rejection'] = $this->rejection->DefaultValue;
        $row['completed'] = $this->completed->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        $row['url2'] = $this->url2->DefaultValue;
        $row['weight_sqm'] = $this->weight_sqm->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // buyers_id
        $this->buyers_id->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // buyer_order
        $this->buyer_order->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // buyer_ref
        $this->buyer_ref->RowCssClass = "row";

        // order_week
        $this->order_week->RowCssClass = "row";

        // order_date
        $this->order_date->RowCssClass = "row";

        // ex_factory
        $this->ex_factory->RowCssClass = "row";

        // ex_factory_p
        $this->ex_factory_p->RowCssClass = "row";

        // shipping_mode
        $this->shipping_mode->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // size_buyer
        $this->size_buyer->RowCssClass = "row";

        // width
        $this->width->RowCssClass = "row";

        // length
        $this->length->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // revised_qty
        $this->revised_qty->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // d_qty
        $this->d_qty->RowCssClass = "row";

        // pending
        $this->pending->RowCssClass = "row";

        // pending_sqm
        $this->pending_sqm->RowCssClass = "row";

        // offloom
        $this->offloom->RowCssClass = "row";

        // pending_offloom
        $this->pending_offloom->RowCssClass = "row";

        // pending_offloom_sqm
        $this->pending_offloom_sqm->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // total_cbm
        $this->total_cbm->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // pl_no
        $this->pl_no->RowCssClass = "row";

        // invoice_date
        $this->invoice_date->RowCssClass = "row";

        // sailing_week
        $this->sailing_week->RowCssClass = "row";

        // seller_remarks
        $this->seller_remarks->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // rejection
        $this->rejection->RowCssClass = "row";

        // completed
        $this->completed->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // url2
        $this->url2->RowCssClass = "row";

        // weight_sqm
        $this->weight_sqm->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->reports_to->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->reports_to->Lookup->renderViewRow($row);
                            $this->reports_to->ViewValue->add($this->reports_to->displayValue($arwrk));
                        }
                    } else {
                        $this->reports_to->ViewValue = $this->reports_to->CurrentValue;
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // buyer_order
            $this->buyer_order->ViewValue = $this->buyer_order->CurrentValue;

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // buyer_ref
            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;

            // order_week
            $curVal = strval($this->order_week->CurrentValue);
            if ($curVal != "") {
                $this->order_week->ViewValue = $this->order_week->lookupCacheOption($curVal);
                if ($this->order_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->order_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->order_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->order_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->order_week->Lookup->renderViewRow($rswrk[0]);
                        $this->order_week->ViewValue = $this->order_week->displayValue($arwrk);
                    } else {
                        $this->order_week->ViewValue = FormatNumber($this->order_week->CurrentValue, $this->order_week->formatPattern());
                    }
                }
            } else {
                $this->order_week->ViewValue = null;
            }

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // ex_factory
            $curVal = strval($this->ex_factory->CurrentValue);
            if ($curVal != "") {
                $this->ex_factory->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
                if ($this->ex_factory->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ex_factory->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ex_factory->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->ex_factory->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ex_factory->Lookup->renderViewRow($rswrk[0]);
                        $this->ex_factory->ViewValue = $this->ex_factory->displayValue($arwrk);
                    } else {
                        $this->ex_factory->ViewValue = FormatNumber($this->ex_factory->CurrentValue, $this->ex_factory->formatPattern());
                    }
                }
            } else {
                $this->ex_factory->ViewValue = null;
            }

            // ex_factory_p
            $curVal = strval($this->ex_factory_p->CurrentValue);
            if ($curVal != "") {
                $this->ex_factory_p->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
                if ($this->ex_factory_p->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->ex_factory_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->ex_factory_p->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->ex_factory_p->Lookup->renderViewRow($row);
                            $this->ex_factory_p->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
                        }
                    } else {
                        $this->ex_factory_p->ViewValue = $this->ex_factory_p->CurrentValue;
                    }
                }
            } else {
                $this->ex_factory_p->ViewValue = null;
            }

            // shipping_mode
            $this->shipping_mode->ViewValue = $this->shipping_mode->CurrentValue;

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // width
            $this->width->ViewValue = $this->width->CurrentValue;
            $this->width->ViewValue = FormatNumber($this->width->ViewValue, $this->width->formatPattern());

            // length
            $this->length->ViewValue = $this->length->CurrentValue;
            $this->length->ViewValue = FormatNumber($this->length->ViewValue, $this->length->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // revised_qty
            $this->revised_qty->ViewValue = $this->revised_qty->CurrentValue;
            $this->revised_qty->ViewValue = FormatNumber($this->revised_qty->ViewValue, $this->revised_qty->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // d_qty
            $this->d_qty->ViewValue = $this->d_qty->CurrentValue;
            $this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, $this->d_qty->formatPattern());

            // pending
            $this->pending->ViewValue = $this->pending->CurrentValue;
            $this->pending->ViewValue = FormatNumber($this->pending->ViewValue, $this->pending->formatPattern());

            // pending_sqm
            $this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
            $this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, $this->pending_sqm->formatPattern());

            // offloom
            $this->offloom->ViewValue = $this->offloom->CurrentValue;
            $this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, $this->offloom->formatPattern());

            // pending_offloom
            $this->pending_offloom->ViewValue = $this->pending_offloom->CurrentValue;
            $this->pending_offloom->ViewValue = FormatNumber($this->pending_offloom->ViewValue, $this->pending_offloom->formatPattern());

            // pending_offloom_sqm
            $this->pending_offloom_sqm->ViewValue = $this->pending_offloom_sqm->CurrentValue;
            $this->pending_offloom_sqm->ViewValue = FormatNumber($this->pending_offloom_sqm->ViewValue, $this->pending_offloom_sqm->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // total_cbm
            $this->total_cbm->ViewValue = $this->total_cbm->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;

            // sailing_week
            $this->sailing_week->ViewValue = $this->sailing_week->CurrentValue;

            // seller_remarks
            $this->seller_remarks->ViewValue = $this->seller_remarks->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->status->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->status->Lookup->renderViewRow($row);
                            $this->status->ViewValue->add($this->status->displayValue($arwrk));
                        }
                    } else {
                        $this->status->ViewValue = $this->status->CurrentValue;
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // rejection
            $this->rejection->ViewValue = FormatNumber($this->rejection->ViewValue, $this->rejection->formatPattern());

            // completed
            if (ConvertToBool($this->completed->CurrentValue)) {
                $this->completed->ViewValue = $this->completed->tagCaption(2) != "" ? $this->completed->tagCaption(2) : "Completed";
            } else {
                $this->completed->ViewValue = $this->completed->tagCaption(1) != "" ? $this->completed->tagCaption(1) : "Not Completed";
            }

            // weight_sqm
            $this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
            $this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, $this->weight_sqm->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // buyers_id
            $this->buyers_id->HrefValue = "";
            $this->buyers_id->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // buyer_order
            $this->buyer_order->HrefValue = "";
            $this->buyer_order->TooltipValue = "";

            // item
            $this->item->HrefValue = "";
            $this->item->TooltipValue = "";

            // buyer_ref
            $this->buyer_ref->HrefValue = "";
            $this->buyer_ref->TooltipValue = "";

            // order_week
            $this->order_week->HrefValue = "";
            $this->order_week->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";

            // ex_factory
            $this->ex_factory->HrefValue = "";
            $this->ex_factory->TooltipValue = "";

            // ex_factory_p
            $this->ex_factory_p->HrefValue = "";
            $this->ex_factory_p->TooltipValue = "";

            // shipping_mode
            $this->shipping_mode->HrefValue = "";
            $this->shipping_mode->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // size_buyer
            $this->size_buyer->HrefValue = "";
            $this->size_buyer->TooltipValue = "";

            // width
            $this->width->HrefValue = "";
            $this->width->TooltipValue = "";

            // length
            $this->length->HrefValue = "";
            $this->length->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // revised_qty
            $this->revised_qty->HrefValue = "";
            $this->revised_qty->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // d_qty
            $this->d_qty->HrefValue = "";
            $this->d_qty->TooltipValue = "";

            // pending
            if (!EmptyValue($this->url2->CurrentValue)) {
                $this->pending->HrefValue = $this->url2->CurrentValue; // Add prefix/suffix
                $this->pending->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->pending->HrefValue = FullUrl($this->pending->HrefValue, "href");
                }
            } else {
                $this->pending->HrefValue = "";
            }
            $this->pending->TooltipValue = "";

            // pending_sqm
            $this->pending_sqm->HrefValue = "";
            $this->pending_sqm->TooltipValue = "";

            // offloom
            $this->offloom->HrefValue = "";
            $this->offloom->TooltipValue = "";

            // pending_offloom
            $this->pending_offloom->HrefValue = "";
            $this->pending_offloom->TooltipValue = "";

            // pending_offloom_sqm
            $this->pending_offloom_sqm->HrefValue = "";
            $this->pending_offloom_sqm->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // total_cbm
            $this->total_cbm->HrefValue = "";
            $this->total_cbm->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // pl_no
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->pl_no->HrefValue = $this->pl_no->getLinkPrefix() . $this->url->CurrentValue . $this->pl_no->getLinkSuffix(); // Add prefix/suffix
                $this->pl_no->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->pl_no->HrefValue = FullUrl($this->pl_no->HrefValue, "href");
                }
            } else {
                $this->pl_no->HrefValue = "";
            }
            $this->pl_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // sailing_week
            $this->sailing_week->HrefValue = "";
            $this->sailing_week->TooltipValue = "";

            // seller_remarks
            $this->seller_remarks->HrefValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // rejection
            $this->rejection->HrefValue = "";
            $this->rejection->TooltipValue = "";

            // weight_sqm
            $this->weight_sqm->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;
            $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->EditValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->EditValue = null;
            }

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->EditValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->EditValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->reports_to->EditValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->reports_to->Lookup->renderViewRow($row);
                            $this->reports_to->EditValue->add($this->reports_to->displayValue($arwrk));
                        }
                    } else {
                        $this->reports_to->EditValue = $this->reports_to->CurrentValue;
                    }
                }
            } else {
                $this->reports_to->EditValue = null;
            }

            // buyer_order
            $this->buyer_order->setupEditAttributes();
            $this->buyer_order->EditValue = $this->buyer_order->CurrentValue;

            // item
            $this->item->setupEditAttributes();
            $this->item->EditValue = $this->item->CurrentValue;

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;

            // order_week
            $this->order_week->setupEditAttributes();
            $curVal = strval($this->order_week->CurrentValue);
            if ($curVal != "") {
                $this->order_week->EditValue = $this->order_week->lookupCacheOption($curVal);
                if ($this->order_week->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->order_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->order_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->order_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->order_week->Lookup->renderViewRow($rswrk[0]);
                        $this->order_week->EditValue = $this->order_week->displayValue($arwrk);
                    } else {
                        $this->order_week->EditValue = FormatNumber($this->order_week->CurrentValue, $this->order_week->formatPattern());
                    }
                }
            } else {
                $this->order_week->EditValue = null;
            }

            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = $this->order_date->CurrentValue;
            $this->order_date->EditValue = FormatDateTime($this->order_date->EditValue, $this->order_date->formatPattern());

            // ex_factory
            $this->ex_factory->setupEditAttributes();
            $curVal = strval($this->ex_factory->CurrentValue);
            if ($curVal != "") {
                $this->ex_factory->EditValue = $this->ex_factory->lookupCacheOption($curVal);
                if ($this->ex_factory->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ex_factory->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ex_factory->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->ex_factory->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ex_factory->Lookup->renderViewRow($rswrk[0]);
                        $this->ex_factory->EditValue = $this->ex_factory->displayValue($arwrk);
                    } else {
                        $this->ex_factory->EditValue = FormatNumber($this->ex_factory->CurrentValue, $this->ex_factory->formatPattern());
                    }
                }
            } else {
                $this->ex_factory->EditValue = null;
            }

            // ex_factory_p
            $this->ex_factory_p->setupEditAttributes();
            $curVal = strval($this->ex_factory_p->CurrentValue);
            if ($curVal != "") {
                $this->ex_factory_p->EditValue = $this->ex_factory_p->lookupCacheOption($curVal);
                if ($this->ex_factory_p->EditValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->ex_factory_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->ex_factory_p->EditValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->ex_factory_p->Lookup->renderViewRow($row);
                            $this->ex_factory_p->EditValue->add($this->ex_factory_p->displayValue($arwrk));
                        }
                    } else {
                        $this->ex_factory_p->EditValue = $this->ex_factory_p->CurrentValue;
                    }
                }
            } else {
                $this->ex_factory_p->EditValue = null;
            }

            // shipping_mode
            $this->shipping_mode->setupEditAttributes();
            $this->shipping_mode->EditValue = $this->shipping_mode->CurrentValue;

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->CurrentValue;
            $this->po->EditValue = FormatNumber($this->po->EditValue, $this->po->formatPattern());

            // design
            $this->design->setupEditAttributes();
            $this->design->EditValue = $this->design->CurrentValue;

            // size_buyer
            $this->size_buyer->setupEditAttributes();
            $this->size_buyer->EditValue = $this->size_buyer->CurrentValue;

            // width
            $this->width->setupEditAttributes();
            $this->width->EditValue = $this->width->CurrentValue;
            $this->width->EditValue = FormatNumber($this->width->EditValue, $this->width->formatPattern());

            // length
            $this->length->setupEditAttributes();
            $this->length->EditValue = $this->length->CurrentValue;
            $this->length->EditValue = FormatNumber($this->length->EditValue, $this->length->formatPattern());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->CurrentValue;
            $this->qty->EditValue = FormatNumber($this->qty->EditValue, $this->qty->formatPattern());

            // revised_qty
            $this->revised_qty->setupEditAttributes();
            $this->revised_qty->EditValue = $this->revised_qty->CurrentValue;
            $this->revised_qty->EditValue = FormatNumber($this->revised_qty->EditValue, $this->revised_qty->formatPattern());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, $this->sqm->formatPattern());

            // d_qty
            $this->d_qty->setupEditAttributes();
            $this->d_qty->EditValue = $this->d_qty->CurrentValue;
            $this->d_qty->EditValue = FormatNumber($this->d_qty->EditValue, $this->d_qty->formatPattern());

            // pending
            $this->pending->setupEditAttributes();
            $this->pending->EditValue = $this->pending->CurrentValue;
            $this->pending->EditValue = FormatNumber($this->pending->EditValue, $this->pending->formatPattern());

            // pending_sqm
            $this->pending_sqm->setupEditAttributes();
            $this->pending_sqm->EditValue = $this->pending_sqm->CurrentValue;
            $this->pending_sqm->EditValue = FormatNumber($this->pending_sqm->EditValue, $this->pending_sqm->formatPattern());

            // offloom
            $this->offloom->setupEditAttributes();
            $this->offloom->EditValue = $this->offloom->CurrentValue;
            $this->offloom->EditValue = FormatNumber($this->offloom->EditValue, $this->offloom->formatPattern());

            // pending_offloom
            $this->pending_offloom->setupEditAttributes();
            $this->pending_offloom->EditValue = $this->pending_offloom->CurrentValue;
            $this->pending_offloom->EditValue = FormatNumber($this->pending_offloom->EditValue, $this->pending_offloom->formatPattern());

            // pending_offloom_sqm
            $this->pending_offloom_sqm->setupEditAttributes();
            $this->pending_offloom_sqm->EditValue = $this->pending_offloom_sqm->CurrentValue;
            $this->pending_offloom_sqm->EditValue = FormatNumber($this->pending_offloom_sqm->EditValue, $this->pending_offloom_sqm->formatPattern());

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditValue = $this->cbm->CurrentValue;

            // total_cbm
            $this->total_cbm->setupEditAttributes();
            $this->total_cbm->EditValue = $this->total_cbm->CurrentValue;

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = $this->remarks->CurrentValue;

            // pl_no
            $this->pl_no->setupEditAttributes();
            $this->pl_no->EditValue = $this->pl_no->CurrentValue;

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = $this->invoice_date->CurrentValue;

            // sailing_week
            $this->sailing_week->setupEditAttributes();
            $this->sailing_week->EditValue = $this->sailing_week->CurrentValue;

            // seller_remarks
            $this->seller_remarks->setupEditAttributes();
            $this->seller_remarks->EditValue = HtmlEncode($this->seller_remarks->CurrentValue);
            $this->seller_remarks->PlaceHolder = RemoveHtml($this->seller_remarks->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->EditValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->EditValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->status->EditValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->status->Lookup->renderViewRow($row);
                            $this->status->EditValue->add($this->status->displayValue($arwrk));
                        }
                    } else {
                        $this->status->EditValue = $this->status->CurrentValue;
                    }
                }
            } else {
                $this->status->EditValue = null;
            }

            // rejection
            $this->rejection->setupEditAttributes();
            $this->rejection->EditValue = FormatNumber($this->rejection->EditValue, $this->rejection->formatPattern());

            // weight_sqm
            $this->weight_sqm->setupEditAttributes();
            $this->weight_sqm->EditValue = $this->weight_sqm->CurrentValue;
            $this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
            if (strval($this->weight_sqm->EditValue) != "" && is_numeric($this->weight_sqm->EditValue)) {
                $this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, null);
            }

            // Edit refer script

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // buyers_id
            $this->buyers_id->HrefValue = "";
            $this->buyers_id->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // buyer_order
            $this->buyer_order->HrefValue = "";
            $this->buyer_order->TooltipValue = "";

            // item
            $this->item->HrefValue = "";
            $this->item->TooltipValue = "";

            // buyer_ref
            $this->buyer_ref->HrefValue = "";
            $this->buyer_ref->TooltipValue = "";

            // order_week
            $this->order_week->HrefValue = "";
            $this->order_week->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";

            // ex_factory
            $this->ex_factory->HrefValue = "";
            $this->ex_factory->TooltipValue = "";

            // ex_factory_p
            $this->ex_factory_p->HrefValue = "";
            $this->ex_factory_p->TooltipValue = "";

            // shipping_mode
            $this->shipping_mode->HrefValue = "";
            $this->shipping_mode->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // size_buyer
            $this->size_buyer->HrefValue = "";
            $this->size_buyer->TooltipValue = "";

            // width
            $this->width->HrefValue = "";
            $this->width->TooltipValue = "";

            // length
            $this->length->HrefValue = "";
            $this->length->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // revised_qty
            $this->revised_qty->HrefValue = "";
            $this->revised_qty->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // d_qty
            $this->d_qty->HrefValue = "";
            $this->d_qty->TooltipValue = "";

            // pending
            if (!EmptyValue($this->url2->CurrentValue)) {
                $this->pending->HrefValue = $this->url2->CurrentValue; // Add prefix/suffix
                $this->pending->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->pending->HrefValue = FullUrl($this->pending->HrefValue, "href");
                }
            } else {
                $this->pending->HrefValue = "";
            }
            $this->pending->TooltipValue = "";

            // pending_sqm
            $this->pending_sqm->HrefValue = "";
            $this->pending_sqm->TooltipValue = "";

            // offloom
            $this->offloom->HrefValue = "";
            $this->offloom->TooltipValue = "";

            // pending_offloom
            $this->pending_offloom->HrefValue = "";
            $this->pending_offloom->TooltipValue = "";

            // pending_offloom_sqm
            $this->pending_offloom_sqm->HrefValue = "";
            $this->pending_offloom_sqm->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // total_cbm
            $this->total_cbm->HrefValue = "";
            $this->total_cbm->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // pl_no
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->pl_no->HrefValue = $this->pl_no->getLinkPrefix() . $this->url->CurrentValue . $this->pl_no->getLinkSuffix(); // Add prefix/suffix
                $this->pl_no->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->pl_no->HrefValue = FullUrl($this->pl_no->HrefValue, "href");
                }
            } else {
                $this->pl_no->HrefValue = "";
            }
            $this->pl_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // sailing_week
            $this->sailing_week->HrefValue = "";
            $this->sailing_week->TooltipValue = "";

            // seller_remarks
            $this->seller_remarks->HrefValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // rejection
            $this->rejection->HrefValue = "";
            $this->rejection->TooltipValue = "";

            // weight_sqm
            $this->weight_sqm->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->buyers_id->Visible && $this->buyers_id->Required) {
                if (!$this->buyers_id->IsDetailKey && EmptyValue($this->buyers_id->FormValue)) {
                    $this->buyers_id->addErrorMessage(str_replace("%s", $this->buyers_id->caption(), $this->buyers_id->RequiredErrorMessage));
                }
            }
            if ($this->reports_to->Visible && $this->reports_to->Required) {
                if ($this->reports_to->FormValue == "") {
                    $this->reports_to->addErrorMessage(str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
                }
            }
            if ($this->buyer_order->Visible && $this->buyer_order->Required) {
                if (!$this->buyer_order->IsDetailKey && EmptyValue($this->buyer_order->FormValue)) {
                    $this->buyer_order->addErrorMessage(str_replace("%s", $this->buyer_order->caption(), $this->buyer_order->RequiredErrorMessage));
                }
            }
            if ($this->item->Visible && $this->item->Required) {
                if (!$this->item->IsDetailKey && EmptyValue($this->item->FormValue)) {
                    $this->item->addErrorMessage(str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
                }
            }
            if ($this->buyer_ref->Visible && $this->buyer_ref->Required) {
                if (!$this->buyer_ref->IsDetailKey && EmptyValue($this->buyer_ref->FormValue)) {
                    $this->buyer_ref->addErrorMessage(str_replace("%s", $this->buyer_ref->caption(), $this->buyer_ref->RequiredErrorMessage));
                }
            }
            if ($this->order_week->Visible && $this->order_week->Required) {
                if (!$this->order_week->IsDetailKey && EmptyValue($this->order_week->FormValue)) {
                    $this->order_week->addErrorMessage(str_replace("%s", $this->order_week->caption(), $this->order_week->RequiredErrorMessage));
                }
            }
            if ($this->order_date->Visible && $this->order_date->Required) {
                if (!$this->order_date->IsDetailKey && EmptyValue($this->order_date->FormValue)) {
                    $this->order_date->addErrorMessage(str_replace("%s", $this->order_date->caption(), $this->order_date->RequiredErrorMessage));
                }
            }
            if ($this->ex_factory->Visible && $this->ex_factory->Required) {
                if (!$this->ex_factory->IsDetailKey && EmptyValue($this->ex_factory->FormValue)) {
                    $this->ex_factory->addErrorMessage(str_replace("%s", $this->ex_factory->caption(), $this->ex_factory->RequiredErrorMessage));
                }
            }
            if ($this->ex_factory_p->Visible && $this->ex_factory_p->Required) {
                if ($this->ex_factory_p->FormValue == "") {
                    $this->ex_factory_p->addErrorMessage(str_replace("%s", $this->ex_factory_p->caption(), $this->ex_factory_p->RequiredErrorMessage));
                }
            }
            if ($this->shipping_mode->Visible && $this->shipping_mode->Required) {
                if (!$this->shipping_mode->IsDetailKey && EmptyValue($this->shipping_mode->FormValue)) {
                    $this->shipping_mode->addErrorMessage(str_replace("%s", $this->shipping_mode->caption(), $this->shipping_mode->RequiredErrorMessage));
                }
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if ($this->design->Visible && $this->design->Required) {
                if (!$this->design->IsDetailKey && EmptyValue($this->design->FormValue)) {
                    $this->design->addErrorMessage(str_replace("%s", $this->design->caption(), $this->design->RequiredErrorMessage));
                }
            }
            if ($this->size_buyer->Visible && $this->size_buyer->Required) {
                if (!$this->size_buyer->IsDetailKey && EmptyValue($this->size_buyer->FormValue)) {
                    $this->size_buyer->addErrorMessage(str_replace("%s", $this->size_buyer->caption(), $this->size_buyer->RequiredErrorMessage));
                }
            }
            if ($this->width->Visible && $this->width->Required) {
                if (!$this->width->IsDetailKey && EmptyValue($this->width->FormValue)) {
                    $this->width->addErrorMessage(str_replace("%s", $this->width->caption(), $this->width->RequiredErrorMessage));
                }
            }
            if ($this->length->Visible && $this->length->Required) {
                if (!$this->length->IsDetailKey && EmptyValue($this->length->FormValue)) {
                    $this->length->addErrorMessage(str_replace("%s", $this->length->caption(), $this->length->RequiredErrorMessage));
                }
            }
            if ($this->qty->Visible && $this->qty->Required) {
                if (!$this->qty->IsDetailKey && EmptyValue($this->qty->FormValue)) {
                    $this->qty->addErrorMessage(str_replace("%s", $this->qty->caption(), $this->qty->RequiredErrorMessage));
                }
            }
            if ($this->revised_qty->Visible && $this->revised_qty->Required) {
                if (!$this->revised_qty->IsDetailKey && EmptyValue($this->revised_qty->FormValue)) {
                    $this->revised_qty->addErrorMessage(str_replace("%s", $this->revised_qty->caption(), $this->revised_qty->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if ($this->d_qty->Visible && $this->d_qty->Required) {
                if (!$this->d_qty->IsDetailKey && EmptyValue($this->d_qty->FormValue)) {
                    $this->d_qty->addErrorMessage(str_replace("%s", $this->d_qty->caption(), $this->d_qty->RequiredErrorMessage));
                }
            }
            if ($this->pending->Visible && $this->pending->Required) {
                if (!$this->pending->IsDetailKey && EmptyValue($this->pending->FormValue)) {
                    $this->pending->addErrorMessage(str_replace("%s", $this->pending->caption(), $this->pending->RequiredErrorMessage));
                }
            }
            if ($this->pending_sqm->Visible && $this->pending_sqm->Required) {
                if (!$this->pending_sqm->IsDetailKey && EmptyValue($this->pending_sqm->FormValue)) {
                    $this->pending_sqm->addErrorMessage(str_replace("%s", $this->pending_sqm->caption(), $this->pending_sqm->RequiredErrorMessage));
                }
            }
            if ($this->offloom->Visible && $this->offloom->Required) {
                if (!$this->offloom->IsDetailKey && EmptyValue($this->offloom->FormValue)) {
                    $this->offloom->addErrorMessage(str_replace("%s", $this->offloom->caption(), $this->offloom->RequiredErrorMessage));
                }
            }
            if ($this->pending_offloom->Visible && $this->pending_offloom->Required) {
                if (!$this->pending_offloom->IsDetailKey && EmptyValue($this->pending_offloom->FormValue)) {
                    $this->pending_offloom->addErrorMessage(str_replace("%s", $this->pending_offloom->caption(), $this->pending_offloom->RequiredErrorMessage));
                }
            }
            if ($this->pending_offloom_sqm->Visible && $this->pending_offloom_sqm->Required) {
                if (!$this->pending_offloom_sqm->IsDetailKey && EmptyValue($this->pending_offloom_sqm->FormValue)) {
                    $this->pending_offloom_sqm->addErrorMessage(str_replace("%s", $this->pending_offloom_sqm->caption(), $this->pending_offloom_sqm->RequiredErrorMessage));
                }
            }
            if ($this->cbm->Visible && $this->cbm->Required) {
                if (!$this->cbm->IsDetailKey && EmptyValue($this->cbm->FormValue)) {
                    $this->cbm->addErrorMessage(str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
                }
            }
            if ($this->total_cbm->Visible && $this->total_cbm->Required) {
                if (!$this->total_cbm->IsDetailKey && EmptyValue($this->total_cbm->FormValue)) {
                    $this->total_cbm->addErrorMessage(str_replace("%s", $this->total_cbm->caption(), $this->total_cbm->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->pl_no->Visible && $this->pl_no->Required) {
                if (!$this->pl_no->IsDetailKey && EmptyValue($this->pl_no->FormValue)) {
                    $this->pl_no->addErrorMessage(str_replace("%s", $this->pl_no->caption(), $this->pl_no->RequiredErrorMessage));
                }
            }
            if ($this->invoice_date->Visible && $this->invoice_date->Required) {
                if (!$this->invoice_date->IsDetailKey && EmptyValue($this->invoice_date->FormValue)) {
                    $this->invoice_date->addErrorMessage(str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
                }
            }
            if ($this->sailing_week->Visible && $this->sailing_week->Required) {
                if (!$this->sailing_week->IsDetailKey && EmptyValue($this->sailing_week->FormValue)) {
                    $this->sailing_week->addErrorMessage(str_replace("%s", $this->sailing_week->caption(), $this->sailing_week->RequiredErrorMessage));
                }
            }
            if ($this->seller_remarks->Visible && $this->seller_remarks->Required) {
                if (!$this->seller_remarks->IsDetailKey && EmptyValue($this->seller_remarks->FormValue)) {
                    $this->seller_remarks->addErrorMessage(str_replace("%s", $this->seller_remarks->caption(), $this->seller_remarks->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if ($this->status->FormValue == "") {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->rejection->Visible && $this->rejection->Required) {
                if (!$this->rejection->IsDetailKey && EmptyValue($this->rejection->FormValue)) {
                    $this->rejection->addErrorMessage(str_replace("%s", $this->rejection->caption(), $this->rejection->RequiredErrorMessage));
                }
            }
            if ($this->weight_sqm->Visible && $this->weight_sqm->Required) {
                if (!$this->weight_sqm->IsDetailKey && EmptyValue($this->weight_sqm->FormValue)) {
                    $this->weight_sqm->addErrorMessage(str_replace("%s", $this->weight_sqm->caption(), $this->weight_sqm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->weight_sqm->FormValue)) {
                $this->weight_sqm->addErrorMessage($this->weight_sqm->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (id)
        if ($this->id->CurrentValue != "") {
            $filterChk = "(`id` = " . AdjustSql($this->id->CurrentValue, $this->Dbid) . ")";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->id->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->id->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);

        // Check for duplicate key when key changed
        if ($updateRow) {
            $newKeyFilter = $this->getRecordFilter($rsnew);
            if ($newKeyFilter != $oldKeyFilter) {
                $rsChk = $this->loadRs($newKeyFilter)->fetch();
                if ($rsChk !== false) {
                    $keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
                    $this->setFailureMessage($keyErrMsg);
                    $updateRow = false;
                }
            }
        }
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // seller_remarks
        $this->seller_remarks->setDbValueDef($rsnew, $this->seller_remarks->CurrentValue, $this->seller_remarks->ReadOnly);

        // weight_sqm
        $this->weight_sqm->setDbValueDef($rsnew, $this->weight_sqm->CurrentValue, $this->weight_sqm->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['seller_remarks'])) { // seller_remarks
            $this->seller_remarks->CurrentValue = $row['seller_remarks'];
        }
        if (isset($row['weight_sqm'])) { // weight_sqm
            $this->weight_sqm->CurrentValue = $row['weight_sqm'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("omstablelist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_buyers_id":
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_order_week":
                    break;
                case "x_ex_factory":
                    break;
                case "x_ex_factory_p":
                    break;
                case "x_status":
                    break;
                case "x_completed":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
