<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class OmsTable2Search extends OmsTable2
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "OmsTable2Search";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "omstable2search";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->buyers_id->setVisibility();
        $this->reports_to->setVisibility();
        $this->buyer_order->setVisibility();
        $this->item->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->order_week->setVisibility();
        $this->order_date->setVisibility();
        $this->ex_factory->setVisibility();
        $this->ex_factory_p->setVisibility();
        $this->shipping_mode->setVisibility();
        $this->category->setVisibility();
        $this->cs->setVisibility();
        $this->po->setVisibility();
        $this->design->setVisibility();
        $this->size_buyer->setVisibility();
        $this->width->setVisibility();
        $this->length->setVisibility();
        $this->qty->setVisibility();
        $this->revised_qty->setVisibility();
        $this->sqm->setVisibility();
        $this->d_qty->setVisibility();
        $this->pending->setVisibility();
        $this->pending_sqm->setVisibility();
        $this->offloom->setVisibility();
        $this->pending_offloom->setVisibility();
        $this->pending_offloom_sqm->setVisibility();
        $this->cbm->setVisibility();
        $this->total_cbm->setVisibility();
        $this->weaving_works->setVisibility();
        $this->current_works->setVisibility();
        $this->remarks->setVisibility();
        $this->pl_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->sailing_week->setVisibility();
        $this->status->setVisibility();
        $this->completed->setVisibility();
        $this->rejection->Visible = false;
        $this->label->setVisibility();
        $this->weight_sqm->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'oms_table_2';
        $this->TableName = 'oms_table_2';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (oms_table_2)
        if (!isset($GLOBALS["oms_table_2"]) || $GLOBALS["oms_table_2"]::class == PROJECT_NAMESPACE . "oms_table_2") {
            $GLOBALS["oms_table_2"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'oms_table_2');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "omstable2view"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->order_week);
        $this->setupLookupOptions($this->ex_factory);
        $this->setupLookupOptions($this->ex_factory_p);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->cs);
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->completed);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "omstable2list" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->buyers_id); // buyers_id
        $this->buildSearchUrl($srchUrl, $this->reports_to); // reports_to
        $this->buildSearchUrl($srchUrl, $this->buyer_order); // buyer_order
        $this->buildSearchUrl($srchUrl, $this->item); // item
        $this->buildSearchUrl($srchUrl, $this->buyer_ref); // buyer_ref
        $this->buildSearchUrl($srchUrl, $this->order_week); // order_week
        $this->buildSearchUrl($srchUrl, $this->order_date); // order_date
        $this->buildSearchUrl($srchUrl, $this->ex_factory); // ex_factory
        $this->buildSearchUrl($srchUrl, $this->ex_factory_p); // ex_factory_p
        $this->buildSearchUrl($srchUrl, $this->shipping_mode); // shipping_mode
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->cs); // cs
        $this->buildSearchUrl($srchUrl, $this->po); // po
        $this->buildSearchUrl($srchUrl, $this->design); // design
        $this->buildSearchUrl($srchUrl, $this->size_buyer); // size_buyer
        $this->buildSearchUrl($srchUrl, $this->width); // width
        $this->buildSearchUrl($srchUrl, $this->length); // length
        $this->buildSearchUrl($srchUrl, $this->qty); // qty
        $this->buildSearchUrl($srchUrl, $this->revised_qty); // revised_qty
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->d_qty); // d_qty
        $this->buildSearchUrl($srchUrl, $this->pending); // pending
        $this->buildSearchUrl($srchUrl, $this->pending_sqm); // pending_sqm
        $this->buildSearchUrl($srchUrl, $this->offloom); // offloom
        $this->buildSearchUrl($srchUrl, $this->pending_offloom); // pending_offloom
        $this->buildSearchUrl($srchUrl, $this->pending_offloom_sqm); // pending_offloom_sqm
        $this->buildSearchUrl($srchUrl, $this->cbm); // cbm
        $this->buildSearchUrl($srchUrl, $this->total_cbm); // total_cbm
        $this->buildSearchUrl($srchUrl, $this->weaving_works); // weaving_works
        $this->buildSearchUrl($srchUrl, $this->current_works); // current_works
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->pl_no); // pl_no
        $this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
        $this->buildSearchUrl($srchUrl, $this->sailing_week); // sailing_week
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->completed); // completed
        $this->buildSearchUrl($srchUrl, $this->label); // label
        $this->buildSearchUrl($srchUrl, $this->weight_sqm); // weight_sqm
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyers_id
        if ($this->buyers_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reports_to
        if ($this->reports_to->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->reports_to->AdvancedSearch->SearchValue)) {
            $this->reports_to->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->reports_to->AdvancedSearch->SearchValue);
        }
        if (is_array($this->reports_to->AdvancedSearch->SearchValue2)) {
            $this->reports_to->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->reports_to->AdvancedSearch->SearchValue2);
        }

        // buyer_order
        if ($this->buyer_order->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // item
        if ($this->item->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_ref
        if ($this->buyer_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_week
        if ($this->order_week->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_date
        if ($this->order_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ex_factory
        if ($this->ex_factory->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ex_factory_p
        if ($this->ex_factory_p->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->ex_factory_p->AdvancedSearch->SearchValue)) {
            $this->ex_factory_p->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->ex_factory_p->AdvancedSearch->SearchValue);
        }
        if (is_array($this->ex_factory_p->AdvancedSearch->SearchValue2)) {
            $this->ex_factory_p->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->ex_factory_p->AdvancedSearch->SearchValue2);
        }

        // shipping_mode
        if ($this->shipping_mode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cs
        if ($this->cs->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design
        if ($this->design->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_buyer
        if ($this->size_buyer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // width
        if ($this->width->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // length
        if ($this->length->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qty
        if ($this->qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // revised_qty
        if ($this->revised_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_qty
        if ($this->d_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pending
        if ($this->pending->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pending_sqm
        if ($this->pending_sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // offloom
        if ($this->offloom->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pending_offloom
        if ($this->pending_offloom->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pending_offloom_sqm
        if ($this->pending_offloom_sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // total_cbm
        if ($this->total_cbm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // weaving_works
        if ($this->weaving_works->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // current_works
        if ($this->current_works->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pl_no
        if ($this->pl_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_date
        if ($this->invoice_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sailing_week
        if ($this->sailing_week->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->status->AdvancedSearch->SearchValue)) {
            $this->status->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->status->AdvancedSearch->SearchValue);
        }
        if (is_array($this->status->AdvancedSearch->SearchValue2)) {
            $this->status->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->status->AdvancedSearch->SearchValue2);
        }

        // completed
        if ($this->completed->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // label
        if ($this->label->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // weight_sqm
        if ($this->weight_sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // buyers_id
        $this->buyers_id->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // buyer_order
        $this->buyer_order->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // buyer_ref
        $this->buyer_ref->RowCssClass = "row";

        // order_week
        $this->order_week->RowCssClass = "row";

        // order_date
        $this->order_date->RowCssClass = "row";

        // ex_factory
        $this->ex_factory->RowCssClass = "row";

        // ex_factory_p
        $this->ex_factory_p->RowCssClass = "row";

        // shipping_mode
        $this->shipping_mode->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // cs
        $this->cs->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // size_buyer
        $this->size_buyer->RowCssClass = "row";

        // width
        $this->width->RowCssClass = "row";

        // length
        $this->length->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // revised_qty
        $this->revised_qty->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // d_qty
        $this->d_qty->RowCssClass = "row";

        // pending
        $this->pending->RowCssClass = "row";

        // pending_sqm
        $this->pending_sqm->RowCssClass = "row";

        // offloom
        $this->offloom->RowCssClass = "row";

        // pending_offloom
        $this->pending_offloom->RowCssClass = "row";

        // pending_offloom_sqm
        $this->pending_offloom_sqm->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // total_cbm
        $this->total_cbm->RowCssClass = "row";

        // weaving_works
        $this->weaving_works->RowCssClass = "row";

        // current_works
        $this->current_works->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // pl_no
        $this->pl_no->RowCssClass = "row";

        // invoice_date
        $this->invoice_date->RowCssClass = "row";

        // sailing_week
        $this->sailing_week->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // completed
        $this->completed->RowCssClass = "row";

        // rejection
        $this->rejection->RowCssClass = "row";

        // label
        $this->label->RowCssClass = "row";

        // weight_sqm
        $this->weight_sqm->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->reports_to->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->reports_to->Lookup->renderViewRow($row);
                            $this->reports_to->ViewValue->add($this->reports_to->displayValue($arwrk));
                        }
                    } else {
                        $this->reports_to->ViewValue = $this->reports_to->CurrentValue;
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // buyer_order
            $this->buyer_order->ViewValue = $this->buyer_order->CurrentValue;

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // buyer_ref
            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;

            // order_week
            $curVal = strval($this->order_week->CurrentValue);
            if ($curVal != "") {
                $this->order_week->ViewValue = $this->order_week->lookupCacheOption($curVal);
                if ($this->order_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->order_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->order_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->order_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->order_week->Lookup->renderViewRow($rswrk[0]);
                        $this->order_week->ViewValue = $this->order_week->displayValue($arwrk);
                    } else {
                        $this->order_week->ViewValue = FormatNumber($this->order_week->CurrentValue, $this->order_week->formatPattern());
                    }
                }
            } else {
                $this->order_week->ViewValue = null;
            }

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // ex_factory
            $curVal = strval($this->ex_factory->CurrentValue);
            if ($curVal != "") {
                $this->ex_factory->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
                if ($this->ex_factory->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ex_factory->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ex_factory->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->ex_factory->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ex_factory->Lookup->renderViewRow($rswrk[0]);
                        $this->ex_factory->ViewValue = $this->ex_factory->displayValue($arwrk);
                    } else {
                        $this->ex_factory->ViewValue = FormatNumber($this->ex_factory->CurrentValue, $this->ex_factory->formatPattern());
                    }
                }
            } else {
                $this->ex_factory->ViewValue = null;
            }

            // ex_factory_p
            $curVal = strval($this->ex_factory_p->CurrentValue);
            if ($curVal != "") {
                $this->ex_factory_p->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
                if ($this->ex_factory_p->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->ex_factory_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->ex_factory_p->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->ex_factory_p->Lookup->renderViewRow($row);
                            $this->ex_factory_p->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
                        }
                    } else {
                        $this->ex_factory_p->ViewValue = $this->ex_factory_p->CurrentValue;
                    }
                }
            } else {
                $this->ex_factory_p->ViewValue = null;
            }

            // shipping_mode
            $this->shipping_mode->ViewValue = $this->shipping_mode->CurrentValue;

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // cs
            if (strval($this->cs->CurrentValue) != "") {
                $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
            } else {
                $this->cs->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // width
            $this->width->ViewValue = $this->width->CurrentValue;
            $this->width->ViewValue = FormatNumber($this->width->ViewValue, $this->width->formatPattern());

            // length
            $this->length->ViewValue = $this->length->CurrentValue;
            $this->length->ViewValue = FormatNumber($this->length->ViewValue, $this->length->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // revised_qty
            $this->revised_qty->ViewValue = $this->revised_qty->CurrentValue;
            $this->revised_qty->ViewValue = FormatNumber($this->revised_qty->ViewValue, $this->revised_qty->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // d_qty
            $this->d_qty->ViewValue = $this->d_qty->CurrentValue;
            $this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, $this->d_qty->formatPattern());

            // pending
            $this->pending->ViewValue = $this->pending->CurrentValue;
            $this->pending->ViewValue = FormatNumber($this->pending->ViewValue, $this->pending->formatPattern());

            // pending_sqm
            $this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
            $this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, $this->pending_sqm->formatPattern());

            // offloom
            $this->offloom->ViewValue = $this->offloom->CurrentValue;
            $this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, $this->offloom->formatPattern());

            // pending_offloom
            $this->pending_offloom->ViewValue = $this->pending_offloom->CurrentValue;
            $this->pending_offloom->ViewValue = FormatNumber($this->pending_offloom->ViewValue, $this->pending_offloom->formatPattern());

            // pending_offloom_sqm
            $this->pending_offloom_sqm->ViewValue = $this->pending_offloom_sqm->CurrentValue;
            $this->pending_offloom_sqm->ViewValue = FormatNumber($this->pending_offloom_sqm->ViewValue, $this->pending_offloom_sqm->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // total_cbm
            $this->total_cbm->ViewValue = $this->total_cbm->CurrentValue;

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;

            // sailing_week
            $this->sailing_week->ViewValue = $this->sailing_week->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->status->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->status->Lookup->renderViewRow($row);
                            $this->status->ViewValue->add($this->status->displayValue($arwrk));
                        }
                    } else {
                        $this->status->ViewValue = $this->status->CurrentValue;
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // label
            $this->label->ViewValue = $this->label->CurrentValue;

            // weight_sqm
            $this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
            $this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, $this->weight_sqm->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // buyers_id
            $this->buyers_id->HrefValue = "";
            $this->buyers_id->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // buyer_order
            $this->buyer_order->HrefValue = "";
            $this->buyer_order->TooltipValue = "";

            // item
            $this->item->HrefValue = "";
            $this->item->TooltipValue = "";

            // buyer_ref
            $this->buyer_ref->HrefValue = "";
            $this->buyer_ref->TooltipValue = "";

            // order_week
            $this->order_week->HrefValue = "";
            $this->order_week->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";

            // ex_factory
            $this->ex_factory->HrefValue = "";
            $this->ex_factory->TooltipValue = "";

            // ex_factory_p
            $this->ex_factory_p->HrefValue = "";
            $this->ex_factory_p->TooltipValue = "";

            // shipping_mode
            $this->shipping_mode->HrefValue = "";
            $this->shipping_mode->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // cs
            $this->cs->HrefValue = "";
            $this->cs->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // size_buyer
            $this->size_buyer->HrefValue = "";
            $this->size_buyer->TooltipValue = "";

            // width
            $this->width->HrefValue = "";
            $this->width->TooltipValue = "";

            // length
            $this->length->HrefValue = "";
            $this->length->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // revised_qty
            $this->revised_qty->HrefValue = "";
            $this->revised_qty->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // d_qty
            $this->d_qty->HrefValue = "";
            $this->d_qty->TooltipValue = "";

            // pending
            $this->pending->HrefValue = "";
            $this->pending->TooltipValue = "";

            // pending_sqm
            $this->pending_sqm->HrefValue = "";
            $this->pending_sqm->TooltipValue = "";

            // offloom
            $this->offloom->HrefValue = "";
            $this->offloom->TooltipValue = "";

            // pending_offloom
            $this->pending_offloom->HrefValue = "";
            $this->pending_offloom->TooltipValue = "";

            // pending_offloom_sqm
            $this->pending_offloom_sqm->HrefValue = "";
            $this->pending_offloom_sqm->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // total_cbm
            $this->total_cbm->HrefValue = "";
            $this->total_cbm->TooltipValue = "";

            // weaving_works
            $this->weaving_works->HrefValue = "";
            $this->weaving_works->TooltipValue = "";

            // current_works
            $this->current_works->HrefValue = "";
            $this->current_works->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // sailing_week
            $this->sailing_week->HrefValue = "";
            $this->sailing_week->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";
            $this->completed->TooltipValue = "";

            // label
            $this->label->HrefValue = "";
            $this->label->TooltipValue = "";

            // weight_sqm
            $this->weight_sqm->HrefValue = "";
            $this->weight_sqm->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $curVal = trim(strval($this->buyers_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            } else {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->Lookup !== null && is_array($this->buyers_id->lookupOptions()) && count($this->buyers_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyers_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyers_id->EditValue = array_values($this->buyers_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyers_id->AdvancedSearch->SearchValue, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->buyers_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyers_id->EditValue = $arwrk;
            }
            $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // buyer_order
            $this->buyer_order->setupEditAttributes();
            if (!$this->buyer_order->Raw) {
                $this->buyer_order->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_order->AdvancedSearch->SearchValue);
            }
            $this->buyer_order->EditValue = HtmlEncode($this->buyer_order->AdvancedSearch->SearchValue);
            $this->buyer_order->PlaceHolder = RemoveHtml($this->buyer_order->caption());

            // item
            $this->item->setupEditAttributes();
            if (!$this->item->Raw) {
                $this->item->AdvancedSearch->SearchValue = HtmlDecode($this->item->AdvancedSearch->SearchValue);
            }
            $this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            if (!$this->buyer_ref->Raw) {
                $this->buyer_ref->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_ref->AdvancedSearch->SearchValue);
            }
            $this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
            $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

            // order_week
            $this->order_week->setupEditAttributes();
            $curVal = trim(strval($this->order_week->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->order_week->AdvancedSearch->ViewValue = $this->order_week->lookupCacheOption($curVal);
            } else {
                $this->order_week->AdvancedSearch->ViewValue = $this->order_week->Lookup !== null && is_array($this->order_week->lookupOptions()) && count($this->order_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->order_week->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->order_week->EditValue = array_values($this->order_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->order_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->order_week->AdvancedSearch->SearchValue, $this->order_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->order_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->order_week->EditValue = $arwrk;
            }
            $this->order_week->PlaceHolder = RemoveHtml($this->order_week->caption());

            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, $this->order_date->formatPattern()), $this->order_date->formatPattern()));
            $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

            // ex_factory
            $this->ex_factory->setupEditAttributes();
            $curVal = trim(strval($this->ex_factory->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->ex_factory->AdvancedSearch->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
            } else {
                $this->ex_factory->AdvancedSearch->ViewValue = $this->ex_factory->Lookup !== null && is_array($this->ex_factory->lookupOptions()) && count($this->ex_factory->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ex_factory->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->ex_factory->EditValue = array_values($this->ex_factory->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->ex_factory->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->ex_factory->AdvancedSearch->SearchValue, $this->ex_factory->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->ex_factory->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ex_factory->EditValue = $arwrk;
            }
            $this->ex_factory->PlaceHolder = RemoveHtml($this->ex_factory->caption());

            // ex_factory_p
            $curVal = trim(strval($this->ex_factory_p->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->ex_factory_p->AdvancedSearch->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
            } else {
                $this->ex_factory_p->AdvancedSearch->ViewValue = $this->ex_factory_p->Lookup !== null && is_array($this->ex_factory_p->lookupOptions()) && count($this->ex_factory_p->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ex_factory_p->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->ex_factory_p->EditValue = array_values($this->ex_factory_p->lookupOptions());
                if ($this->ex_factory_p->AdvancedSearch->ViewValue == "") {
                    $this->ex_factory_p->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->ex_factory_p->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->ex_factory_p->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->ex_factory_p->Lookup->renderViewRow($row);
                        $this->ex_factory_p->AdvancedSearch->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->ex_factory_p->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->ex_factory_p->EditValue = $arwrk;
            }
            $this->ex_factory_p->PlaceHolder = RemoveHtml($this->ex_factory_p->caption());
            $curVal = trim(strval($this->ex_factory_p->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->ex_factory_p->AdvancedSearch->ViewValue2 = $this->ex_factory_p->lookupCacheOption($curVal);
            } else {
                $this->ex_factory_p->AdvancedSearch->ViewValue2 = $this->ex_factory_p->Lookup !== null && is_array($this->ex_factory_p->lookupOptions()) && count($this->ex_factory_p->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ex_factory_p->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->ex_factory_p->EditValue2 = array_values($this->ex_factory_p->lookupOptions());
                if ($this->ex_factory_p->AdvancedSearch->ViewValue2 == "") {
                    $this->ex_factory_p->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->ex_factory_p->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->ex_factory_p->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->ex_factory_p->Lookup->renderViewRow($row);
                        $this->ex_factory_p->AdvancedSearch->ViewValue2->add($this->ex_factory_p->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->ex_factory_p->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->ex_factory_p->EditValue2 = $arwrk;
            }
            $this->ex_factory_p->PlaceHolder = RemoveHtml($this->ex_factory_p->caption());

            // shipping_mode
            $this->shipping_mode->setupEditAttributes();
            if (!$this->shipping_mode->Raw) {
                $this->shipping_mode->AdvancedSearch->SearchValue = HtmlDecode($this->shipping_mode->AdvancedSearch->SearchValue);
            }
            $this->shipping_mode->EditValue = HtmlEncode($this->shipping_mode->AdvancedSearch->SearchValue);
            $this->shipping_mode->PlaceHolder = RemoveHtml($this->shipping_mode->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->AdvancedSearch->SearchValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // cs
            $this->cs->setupEditAttributes();
            $this->cs->EditValue = $this->cs->options(true);
            $this->cs->PlaceHolder = RemoveHtml($this->cs->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            $this->po->setupEditAttributes();
            $this->po->EditValue2 = $this->po->AdvancedSearch->SearchValue2;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // design
            $this->design->setupEditAttributes();
            if (!$this->design->Raw) {
                $this->design->AdvancedSearch->SearchValue = HtmlDecode($this->design->AdvancedSearch->SearchValue);
            }
            $this->design->EditValue = HtmlEncode($this->design->AdvancedSearch->SearchValue);
            $this->design->PlaceHolder = RemoveHtml($this->design->caption());

            // size_buyer
            $this->size_buyer->setupEditAttributes();
            if (!$this->size_buyer->Raw) {
                $this->size_buyer->AdvancedSearch->SearchValue = HtmlDecode($this->size_buyer->AdvancedSearch->SearchValue);
            }
            $this->size_buyer->EditValue = HtmlEncode($this->size_buyer->AdvancedSearch->SearchValue);
            $this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

            // width
            $this->width->setupEditAttributes();
            $this->width->EditValue = $this->width->AdvancedSearch->SearchValue;
            $this->width->PlaceHolder = RemoveHtml($this->width->caption());

            // length
            $this->length->setupEditAttributes();
            $this->length->EditValue = $this->length->AdvancedSearch->SearchValue;
            $this->length->PlaceHolder = RemoveHtml($this->length->caption());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->AdvancedSearch->SearchValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

            // revised_qty
            $this->revised_qty->setupEditAttributes();
            $this->revised_qty->EditValue = $this->revised_qty->AdvancedSearch->SearchValue;
            $this->revised_qty->PlaceHolder = RemoveHtml($this->revised_qty->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // d_qty
            $this->d_qty->setupEditAttributes();
            $this->d_qty->EditValue = $this->d_qty->AdvancedSearch->SearchValue;
            $this->d_qty->PlaceHolder = RemoveHtml($this->d_qty->caption());

            // pending
            $this->pending->setupEditAttributes();
            $this->pending->EditValue = $this->pending->AdvancedSearch->SearchValue;
            $this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
            $this->pending->setupEditAttributes();
            $this->pending->EditValue2 = $this->pending->AdvancedSearch->SearchValue2;
            $this->pending->PlaceHolder = RemoveHtml($this->pending->caption());

            // pending_sqm
            $this->pending_sqm->setupEditAttributes();
            $this->pending_sqm->EditValue = $this->pending_sqm->AdvancedSearch->SearchValue;
            $this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());
            $this->pending_sqm->setupEditAttributes();
            $this->pending_sqm->EditValue2 = $this->pending_sqm->AdvancedSearch->SearchValue2;
            $this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());

            // offloom
            $this->offloom->setupEditAttributes();
            $this->offloom->EditValue = $this->offloom->AdvancedSearch->SearchValue;
            $this->offloom->PlaceHolder = RemoveHtml($this->offloom->caption());

            // pending_offloom
            $this->pending_offloom->setupEditAttributes();
            $this->pending_offloom->EditValue = $this->pending_offloom->AdvancedSearch->SearchValue;
            $this->pending_offloom->PlaceHolder = RemoveHtml($this->pending_offloom->caption());

            // pending_offloom_sqm
            $this->pending_offloom_sqm->setupEditAttributes();
            $this->pending_offloom_sqm->EditValue = $this->pending_offloom_sqm->AdvancedSearch->SearchValue;
            $this->pending_offloom_sqm->PlaceHolder = RemoveHtml($this->pending_offloom_sqm->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

            // total_cbm
            $this->total_cbm->setupEditAttributes();
            $this->total_cbm->EditValue = HtmlEncode($this->total_cbm->AdvancedSearch->SearchValue);
            $this->total_cbm->PlaceHolder = RemoveHtml($this->total_cbm->caption());

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $curVal = trim(strval($this->weaving_works->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            } else {
                $this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->Lookup !== null && is_array($this->weaving_works->lookupOptions()) && count($this->weaving_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->weaving_works->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->weaving_works->EditValue = array_values($this->weaving_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->weaving_works->AdvancedSearch->SearchValue, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->weaving_works->EditValue = $arwrk;
            }
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
            } else {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== null && is_array($this->current_works->lookupOptions()) && count($this->current_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->current_works->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->current_works->EditValue = array_values($this->current_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->current_works->AdvancedSearch->SearchValue, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->current_works->EditValue = $arwrk;
            }
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // pl_no
            $this->pl_no->setupEditAttributes();
            if (!$this->pl_no->Raw) {
                $this->pl_no->AdvancedSearch->SearchValue = HtmlDecode($this->pl_no->AdvancedSearch->SearchValue);
            }
            $this->pl_no->EditValue = HtmlEncode($this->pl_no->AdvancedSearch->SearchValue);
            $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = HtmlEncode($this->invoice_date->AdvancedSearch->SearchValue);
            $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

            // sailing_week
            $this->sailing_week->setupEditAttributes();
            $this->sailing_week->EditValue = HtmlEncode($this->sailing_week->AdvancedSearch->SearchValue);
            $this->sailing_week->PlaceHolder = RemoveHtml($this->sailing_week->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // label
            $this->label->setupEditAttributes();
            if (!$this->label->Raw) {
                $this->label->AdvancedSearch->SearchValue = HtmlDecode($this->label->AdvancedSearch->SearchValue);
            }
            $this->label->EditValue = HtmlEncode($this->label->AdvancedSearch->SearchValue);
            $this->label->PlaceHolder = RemoveHtml($this->label->caption());

            // weight_sqm
            $this->weight_sqm->setupEditAttributes();
            $this->weight_sqm->EditValue = $this->weight_sqm->AdvancedSearch->SearchValue;
            $this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckDate($this->order_date->AdvancedSearch->SearchValue, $this->order_date->formatPattern())) {
            $this->order_date->addErrorMessage($this->order_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->width->AdvancedSearch->SearchValue)) {
            $this->width->addErrorMessage($this->width->getErrorMessage(false));
        }
        if (!CheckInteger($this->length->AdvancedSearch->SearchValue)) {
            $this->length->addErrorMessage($this->length->getErrorMessage(false));
        }
        if (!CheckInteger($this->qty->AdvancedSearch->SearchValue)) {
            $this->qty->addErrorMessage($this->qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->revised_qty->AdvancedSearch->SearchValue)) {
            $this->revised_qty->addErrorMessage($this->revised_qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->d_qty->AdvancedSearch->SearchValue)) {
            $this->d_qty->addErrorMessage($this->d_qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->pending->AdvancedSearch->SearchValue)) {
            $this->pending->addErrorMessage($this->pending->getErrorMessage(false));
        }
        if (!CheckNumber($this->pending->AdvancedSearch->SearchValue2)) {
            $this->pending->addErrorMessage($this->pending->getErrorMessage(false));
        }
        if (!CheckNumber($this->pending_sqm->AdvancedSearch->SearchValue)) {
            $this->pending_sqm->addErrorMessage($this->pending_sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->pending_sqm->AdvancedSearch->SearchValue2)) {
            $this->pending_sqm->addErrorMessage($this->pending_sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->offloom->AdvancedSearch->SearchValue)) {
            $this->offloom->addErrorMessage($this->offloom->getErrorMessage(false));
        }
        if (!CheckInteger($this->pending_offloom->AdvancedSearch->SearchValue)) {
            $this->pending_offloom->addErrorMessage($this->pending_offloom->getErrorMessage(false));
        }
        if (!CheckNumber($this->pending_offloom_sqm->AdvancedSearch->SearchValue)) {
            $this->pending_offloom_sqm->addErrorMessage($this->pending_offloom_sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->weight_sqm->AdvancedSearch->SearchValue)) {
            $this->weight_sqm->addErrorMessage($this->weight_sqm->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
        $this->buyer_order->AdvancedSearch->load();
        $this->item->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->order_week->AdvancedSearch->load();
        $this->order_date->AdvancedSearch->load();
        $this->ex_factory->AdvancedSearch->load();
        $this->ex_factory_p->AdvancedSearch->load();
        $this->shipping_mode->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->cs->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->design->AdvancedSearch->load();
        $this->size_buyer->AdvancedSearch->load();
        $this->width->AdvancedSearch->load();
        $this->length->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->revised_qty->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->d_qty->AdvancedSearch->load();
        $this->pending->AdvancedSearch->load();
        $this->pending_sqm->AdvancedSearch->load();
        $this->offloom->AdvancedSearch->load();
        $this->pending_offloom->AdvancedSearch->load();
        $this->pending_offloom_sqm->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->total_cbm->AdvancedSearch->load();
        $this->weaving_works->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->sailing_week->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->completed->AdvancedSearch->load();
        $this->label->AdvancedSearch->load();
        $this->weight_sqm->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("omstable2list"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_buyers_id":
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_order_week":
                    break;
                case "x_ex_factory":
                    break;
                case "x_ex_factory_p":
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cs":
                    break;
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_completed":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
