<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class OmsTable2List extends OmsTable2
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "OmsTable2List";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "foms_table_2list";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "omstable2list";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->buyers_id->setVisibility();
        $this->reports_to->setVisibility();
        $this->buyer_order->setVisibility();
        $this->item->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->order_week->setVisibility();
        $this->order_date->setVisibility();
        $this->ex_factory->setVisibility();
        $this->ex_factory_p->setVisibility();
        $this->shipping_mode->setVisibility();
        $this->category->setVisibility();
        $this->cs->setVisibility();
        $this->po->setVisibility();
        $this->design->setVisibility();
        $this->size_buyer->setVisibility();
        $this->width->setVisibility();
        $this->length->setVisibility();
        $this->qty->setVisibility();
        $this->revised_qty->setVisibility();
        $this->sqm->setVisibility();
        $this->d_qty->setVisibility();
        $this->pending->setVisibility();
        $this->pending_sqm->setVisibility();
        $this->offloom->setVisibility();
        $this->pending_offloom->setVisibility();
        $this->pending_offloom_sqm->setVisibility();
        $this->cbm->setVisibility();
        $this->total_cbm->setVisibility();
        $this->weaving_works->setVisibility();
        $this->current_works->setVisibility();
        $this->remarks->setVisibility();
        $this->pl_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->sailing_week->setVisibility();
        $this->status->setVisibility();
        $this->completed->setVisibility();
        $this->rejection->setVisibility();
        $this->label->setVisibility();
        $this->weight_sqm->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'oms_table_2';
        $this->TableName = 'oms_table_2';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (oms_table_2)
        if (!isset($GLOBALS["oms_table_2"]) || $GLOBALS["oms_table_2"]::class == PROJECT_NAMESPACE . "oms_table_2") {
            $GLOBALS["oms_table_2"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "omstable2add";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "omstable2delete";
        $this->MultiUpdateUrl = "omstable2update";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'oms_table_2');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "omstable2view"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->buyers_id);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->order_week);
        $this->setupLookupOptions($this->ex_factory);
        $this->setupLookupOptions($this->ex_factory_p);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->cs);
        $this->setupLookupOptions($this->weaving_works);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->completed);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "foms_table_2grid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("foms_table_2srch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->buyers_id->AdvancedSearch->toJson(), ","); // Field buyers_id
        $filterList = Concat($filterList, $this->reports_to->AdvancedSearch->toJson(), ","); // Field reports_to
        $filterList = Concat($filterList, $this->buyer_order->AdvancedSearch->toJson(), ","); // Field buyer_order
        $filterList = Concat($filterList, $this->item->AdvancedSearch->toJson(), ","); // Field item
        $filterList = Concat($filterList, $this->buyer_ref->AdvancedSearch->toJson(), ","); // Field buyer_ref
        $filterList = Concat($filterList, $this->order_week->AdvancedSearch->toJson(), ","); // Field order_week
        $filterList = Concat($filterList, $this->order_date->AdvancedSearch->toJson(), ","); // Field order_date
        $filterList = Concat($filterList, $this->ex_factory->AdvancedSearch->toJson(), ","); // Field ex_factory
        $filterList = Concat($filterList, $this->ex_factory_p->AdvancedSearch->toJson(), ","); // Field ex_factory_p
        $filterList = Concat($filterList, $this->shipping_mode->AdvancedSearch->toJson(), ","); // Field shipping_mode
        $filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
        $filterList = Concat($filterList, $this->cs->AdvancedSearch->toJson(), ","); // Field cs
        $filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
        $filterList = Concat($filterList, $this->design->AdvancedSearch->toJson(), ","); // Field design
        $filterList = Concat($filterList, $this->size_buyer->AdvancedSearch->toJson(), ","); // Field size_buyer
        $filterList = Concat($filterList, $this->width->AdvancedSearch->toJson(), ","); // Field width
        $filterList = Concat($filterList, $this->length->AdvancedSearch->toJson(), ","); // Field length
        $filterList = Concat($filterList, $this->qty->AdvancedSearch->toJson(), ","); // Field qty
        $filterList = Concat($filterList, $this->revised_qty->AdvancedSearch->toJson(), ","); // Field revised_qty
        $filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
        $filterList = Concat($filterList, $this->d_qty->AdvancedSearch->toJson(), ","); // Field d_qty
        $filterList = Concat($filterList, $this->pending->AdvancedSearch->toJson(), ","); // Field pending
        $filterList = Concat($filterList, $this->pending_sqm->AdvancedSearch->toJson(), ","); // Field pending_sqm
        $filterList = Concat($filterList, $this->offloom->AdvancedSearch->toJson(), ","); // Field offloom
        $filterList = Concat($filterList, $this->pending_offloom->AdvancedSearch->toJson(), ","); // Field pending_offloom
        $filterList = Concat($filterList, $this->pending_offloom_sqm->AdvancedSearch->toJson(), ","); // Field pending_offloom_sqm
        $filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
        $filterList = Concat($filterList, $this->total_cbm->AdvancedSearch->toJson(), ","); // Field total_cbm
        $filterList = Concat($filterList, $this->weaving_works->AdvancedSearch->toJson(), ","); // Field weaving_works
        $filterList = Concat($filterList, $this->current_works->AdvancedSearch->toJson(), ","); // Field current_works
        $filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
        $filterList = Concat($filterList, $this->pl_no->AdvancedSearch->toJson(), ","); // Field pl_no
        $filterList = Concat($filterList, $this->invoice_date->AdvancedSearch->toJson(), ","); // Field invoice_date
        $filterList = Concat($filterList, $this->sailing_week->AdvancedSearch->toJson(), ","); // Field sailing_week
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->completed->AdvancedSearch->toJson(), ","); // Field completed
        $filterList = Concat($filterList, $this->label->AdvancedSearch->toJson(), ","); // Field label
        $filterList = Concat($filterList, $this->weight_sqm->AdvancedSearch->toJson(), ","); // Field weight_sqm
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("foms_table_2srch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field buyers_id
        $this->buyers_id->AdvancedSearch->SearchValue = @$filter["x_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchOperator = @$filter["z_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchCondition = @$filter["v_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchValue2 = @$filter["y_buyers_id"];
        $this->buyers_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyers_id"];
        $this->buyers_id->AdvancedSearch->save();

        // Field reports_to
        $this->reports_to->AdvancedSearch->SearchValue = @$filter["x_reports_to"];
        $this->reports_to->AdvancedSearch->SearchOperator = @$filter["z_reports_to"];
        $this->reports_to->AdvancedSearch->SearchCondition = @$filter["v_reports_to"];
        $this->reports_to->AdvancedSearch->SearchValue2 = @$filter["y_reports_to"];
        $this->reports_to->AdvancedSearch->SearchOperator2 = @$filter["w_reports_to"];
        $this->reports_to->AdvancedSearch->save();

        // Field buyer_order
        $this->buyer_order->AdvancedSearch->SearchValue = @$filter["x_buyer_order"];
        $this->buyer_order->AdvancedSearch->SearchOperator = @$filter["z_buyer_order"];
        $this->buyer_order->AdvancedSearch->SearchCondition = @$filter["v_buyer_order"];
        $this->buyer_order->AdvancedSearch->SearchValue2 = @$filter["y_buyer_order"];
        $this->buyer_order->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_order"];
        $this->buyer_order->AdvancedSearch->save();

        // Field item
        $this->item->AdvancedSearch->SearchValue = @$filter["x_item"];
        $this->item->AdvancedSearch->SearchOperator = @$filter["z_item"];
        $this->item->AdvancedSearch->SearchCondition = @$filter["v_item"];
        $this->item->AdvancedSearch->SearchValue2 = @$filter["y_item"];
        $this->item->AdvancedSearch->SearchOperator2 = @$filter["w_item"];
        $this->item->AdvancedSearch->save();

        // Field buyer_ref
        $this->buyer_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_ref"];
        $this->buyer_ref->AdvancedSearch->save();

        // Field order_week
        $this->order_week->AdvancedSearch->SearchValue = @$filter["x_order_week"];
        $this->order_week->AdvancedSearch->SearchOperator = @$filter["z_order_week"];
        $this->order_week->AdvancedSearch->SearchCondition = @$filter["v_order_week"];
        $this->order_week->AdvancedSearch->SearchValue2 = @$filter["y_order_week"];
        $this->order_week->AdvancedSearch->SearchOperator2 = @$filter["w_order_week"];
        $this->order_week->AdvancedSearch->save();

        // Field order_date
        $this->order_date->AdvancedSearch->SearchValue = @$filter["x_order_date"];
        $this->order_date->AdvancedSearch->SearchOperator = @$filter["z_order_date"];
        $this->order_date->AdvancedSearch->SearchCondition = @$filter["v_order_date"];
        $this->order_date->AdvancedSearch->SearchValue2 = @$filter["y_order_date"];
        $this->order_date->AdvancedSearch->SearchOperator2 = @$filter["w_order_date"];
        $this->order_date->AdvancedSearch->save();

        // Field ex_factory
        $this->ex_factory->AdvancedSearch->SearchValue = @$filter["x_ex_factory"];
        $this->ex_factory->AdvancedSearch->SearchOperator = @$filter["z_ex_factory"];
        $this->ex_factory->AdvancedSearch->SearchCondition = @$filter["v_ex_factory"];
        $this->ex_factory->AdvancedSearch->SearchValue2 = @$filter["y_ex_factory"];
        $this->ex_factory->AdvancedSearch->SearchOperator2 = @$filter["w_ex_factory"];
        $this->ex_factory->AdvancedSearch->save();

        // Field ex_factory_p
        $this->ex_factory_p->AdvancedSearch->SearchValue = @$filter["x_ex_factory_p"];
        $this->ex_factory_p->AdvancedSearch->SearchOperator = @$filter["z_ex_factory_p"];
        $this->ex_factory_p->AdvancedSearch->SearchCondition = @$filter["v_ex_factory_p"];
        $this->ex_factory_p->AdvancedSearch->SearchValue2 = @$filter["y_ex_factory_p"];
        $this->ex_factory_p->AdvancedSearch->SearchOperator2 = @$filter["w_ex_factory_p"];
        $this->ex_factory_p->AdvancedSearch->save();

        // Field shipping_mode
        $this->shipping_mode->AdvancedSearch->SearchValue = @$filter["x_shipping_mode"];
        $this->shipping_mode->AdvancedSearch->SearchOperator = @$filter["z_shipping_mode"];
        $this->shipping_mode->AdvancedSearch->SearchCondition = @$filter["v_shipping_mode"];
        $this->shipping_mode->AdvancedSearch->SearchValue2 = @$filter["y_shipping_mode"];
        $this->shipping_mode->AdvancedSearch->SearchOperator2 = @$filter["w_shipping_mode"];
        $this->shipping_mode->AdvancedSearch->save();

        // Field category
        $this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
        $this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
        $this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
        $this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
        $this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
        $this->category->AdvancedSearch->save();

        // Field cs
        $this->cs->AdvancedSearch->SearchValue = @$filter["x_cs"];
        $this->cs->AdvancedSearch->SearchOperator = @$filter["z_cs"];
        $this->cs->AdvancedSearch->SearchCondition = @$filter["v_cs"];
        $this->cs->AdvancedSearch->SearchValue2 = @$filter["y_cs"];
        $this->cs->AdvancedSearch->SearchOperator2 = @$filter["w_cs"];
        $this->cs->AdvancedSearch->save();

        // Field po
        $this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
        $this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
        $this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
        $this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
        $this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
        $this->po->AdvancedSearch->save();

        // Field design
        $this->design->AdvancedSearch->SearchValue = @$filter["x_design"];
        $this->design->AdvancedSearch->SearchOperator = @$filter["z_design"];
        $this->design->AdvancedSearch->SearchCondition = @$filter["v_design"];
        $this->design->AdvancedSearch->SearchValue2 = @$filter["y_design"];
        $this->design->AdvancedSearch->SearchOperator2 = @$filter["w_design"];
        $this->design->AdvancedSearch->save();

        // Field size_buyer
        $this->size_buyer->AdvancedSearch->SearchValue = @$filter["x_size_buyer"];
        $this->size_buyer->AdvancedSearch->SearchOperator = @$filter["z_size_buyer"];
        $this->size_buyer->AdvancedSearch->SearchCondition = @$filter["v_size_buyer"];
        $this->size_buyer->AdvancedSearch->SearchValue2 = @$filter["y_size_buyer"];
        $this->size_buyer->AdvancedSearch->SearchOperator2 = @$filter["w_size_buyer"];
        $this->size_buyer->AdvancedSearch->save();

        // Field width
        $this->width->AdvancedSearch->SearchValue = @$filter["x_width"];
        $this->width->AdvancedSearch->SearchOperator = @$filter["z_width"];
        $this->width->AdvancedSearch->SearchCondition = @$filter["v_width"];
        $this->width->AdvancedSearch->SearchValue2 = @$filter["y_width"];
        $this->width->AdvancedSearch->SearchOperator2 = @$filter["w_width"];
        $this->width->AdvancedSearch->save();

        // Field length
        $this->length->AdvancedSearch->SearchValue = @$filter["x_length"];
        $this->length->AdvancedSearch->SearchOperator = @$filter["z_length"];
        $this->length->AdvancedSearch->SearchCondition = @$filter["v_length"];
        $this->length->AdvancedSearch->SearchValue2 = @$filter["y_length"];
        $this->length->AdvancedSearch->SearchOperator2 = @$filter["w_length"];
        $this->length->AdvancedSearch->save();

        // Field qty
        $this->qty->AdvancedSearch->SearchValue = @$filter["x_qty"];
        $this->qty->AdvancedSearch->SearchOperator = @$filter["z_qty"];
        $this->qty->AdvancedSearch->SearchCondition = @$filter["v_qty"];
        $this->qty->AdvancedSearch->SearchValue2 = @$filter["y_qty"];
        $this->qty->AdvancedSearch->SearchOperator2 = @$filter["w_qty"];
        $this->qty->AdvancedSearch->save();

        // Field revised_qty
        $this->revised_qty->AdvancedSearch->SearchValue = @$filter["x_revised_qty"];
        $this->revised_qty->AdvancedSearch->SearchOperator = @$filter["z_revised_qty"];
        $this->revised_qty->AdvancedSearch->SearchCondition = @$filter["v_revised_qty"];
        $this->revised_qty->AdvancedSearch->SearchValue2 = @$filter["y_revised_qty"];
        $this->revised_qty->AdvancedSearch->SearchOperator2 = @$filter["w_revised_qty"];
        $this->revised_qty->AdvancedSearch->save();

        // Field sqm
        $this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
        $this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
        $this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
        $this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
        $this->sqm->AdvancedSearch->save();

        // Field d_qty
        $this->d_qty->AdvancedSearch->SearchValue = @$filter["x_d_qty"];
        $this->d_qty->AdvancedSearch->SearchOperator = @$filter["z_d_qty"];
        $this->d_qty->AdvancedSearch->SearchCondition = @$filter["v_d_qty"];
        $this->d_qty->AdvancedSearch->SearchValue2 = @$filter["y_d_qty"];
        $this->d_qty->AdvancedSearch->SearchOperator2 = @$filter["w_d_qty"];
        $this->d_qty->AdvancedSearch->save();

        // Field pending
        $this->pending->AdvancedSearch->SearchValue = @$filter["x_pending"];
        $this->pending->AdvancedSearch->SearchOperator = @$filter["z_pending"];
        $this->pending->AdvancedSearch->SearchCondition = @$filter["v_pending"];
        $this->pending->AdvancedSearch->SearchValue2 = @$filter["y_pending"];
        $this->pending->AdvancedSearch->SearchOperator2 = @$filter["w_pending"];
        $this->pending->AdvancedSearch->save();

        // Field pending_sqm
        $this->pending_sqm->AdvancedSearch->SearchValue = @$filter["x_pending_sqm"];
        $this->pending_sqm->AdvancedSearch->SearchOperator = @$filter["z_pending_sqm"];
        $this->pending_sqm->AdvancedSearch->SearchCondition = @$filter["v_pending_sqm"];
        $this->pending_sqm->AdvancedSearch->SearchValue2 = @$filter["y_pending_sqm"];
        $this->pending_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_pending_sqm"];
        $this->pending_sqm->AdvancedSearch->save();

        // Field offloom
        $this->offloom->AdvancedSearch->SearchValue = @$filter["x_offloom"];
        $this->offloom->AdvancedSearch->SearchOperator = @$filter["z_offloom"];
        $this->offloom->AdvancedSearch->SearchCondition = @$filter["v_offloom"];
        $this->offloom->AdvancedSearch->SearchValue2 = @$filter["y_offloom"];
        $this->offloom->AdvancedSearch->SearchOperator2 = @$filter["w_offloom"];
        $this->offloom->AdvancedSearch->save();

        // Field pending_offloom
        $this->pending_offloom->AdvancedSearch->SearchValue = @$filter["x_pending_offloom"];
        $this->pending_offloom->AdvancedSearch->SearchOperator = @$filter["z_pending_offloom"];
        $this->pending_offloom->AdvancedSearch->SearchCondition = @$filter["v_pending_offloom"];
        $this->pending_offloom->AdvancedSearch->SearchValue2 = @$filter["y_pending_offloom"];
        $this->pending_offloom->AdvancedSearch->SearchOperator2 = @$filter["w_pending_offloom"];
        $this->pending_offloom->AdvancedSearch->save();

        // Field pending_offloom_sqm
        $this->pending_offloom_sqm->AdvancedSearch->SearchValue = @$filter["x_pending_offloom_sqm"];
        $this->pending_offloom_sqm->AdvancedSearch->SearchOperator = @$filter["z_pending_offloom_sqm"];
        $this->pending_offloom_sqm->AdvancedSearch->SearchCondition = @$filter["v_pending_offloom_sqm"];
        $this->pending_offloom_sqm->AdvancedSearch->SearchValue2 = @$filter["y_pending_offloom_sqm"];
        $this->pending_offloom_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_pending_offloom_sqm"];
        $this->pending_offloom_sqm->AdvancedSearch->save();

        // Field cbm
        $this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
        $this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
        $this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
        $this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
        $this->cbm->AdvancedSearch->save();

        // Field total_cbm
        $this->total_cbm->AdvancedSearch->SearchValue = @$filter["x_total_cbm"];
        $this->total_cbm->AdvancedSearch->SearchOperator = @$filter["z_total_cbm"];
        $this->total_cbm->AdvancedSearch->SearchCondition = @$filter["v_total_cbm"];
        $this->total_cbm->AdvancedSearch->SearchValue2 = @$filter["y_total_cbm"];
        $this->total_cbm->AdvancedSearch->SearchOperator2 = @$filter["w_total_cbm"];
        $this->total_cbm->AdvancedSearch->save();

        // Field weaving_works
        $this->weaving_works->AdvancedSearch->SearchValue = @$filter["x_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchOperator = @$filter["z_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchCondition = @$filter["v_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchValue2 = @$filter["y_weaving_works"];
        $this->weaving_works->AdvancedSearch->SearchOperator2 = @$filter["w_weaving_works"];
        $this->weaving_works->AdvancedSearch->save();

        // Field current_works
        $this->current_works->AdvancedSearch->SearchValue = @$filter["x_current_works"];
        $this->current_works->AdvancedSearch->SearchOperator = @$filter["z_current_works"];
        $this->current_works->AdvancedSearch->SearchCondition = @$filter["v_current_works"];
        $this->current_works->AdvancedSearch->SearchValue2 = @$filter["y_current_works"];
        $this->current_works->AdvancedSearch->SearchOperator2 = @$filter["w_current_works"];
        $this->current_works->AdvancedSearch->save();

        // Field remarks
        $this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
        $this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
        $this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
        $this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
        $this->remarks->AdvancedSearch->save();

        // Field pl_no
        $this->pl_no->AdvancedSearch->SearchValue = @$filter["x_pl_no"];
        $this->pl_no->AdvancedSearch->SearchOperator = @$filter["z_pl_no"];
        $this->pl_no->AdvancedSearch->SearchCondition = @$filter["v_pl_no"];
        $this->pl_no->AdvancedSearch->SearchValue2 = @$filter["y_pl_no"];
        $this->pl_no->AdvancedSearch->SearchOperator2 = @$filter["w_pl_no"];
        $this->pl_no->AdvancedSearch->save();

        // Field invoice_date
        $this->invoice_date->AdvancedSearch->SearchValue = @$filter["x_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchOperator = @$filter["z_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchCondition = @$filter["v_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchValue2 = @$filter["y_invoice_date"];
        $this->invoice_date->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_date"];
        $this->invoice_date->AdvancedSearch->save();

        // Field sailing_week
        $this->sailing_week->AdvancedSearch->SearchValue = @$filter["x_sailing_week"];
        $this->sailing_week->AdvancedSearch->SearchOperator = @$filter["z_sailing_week"];
        $this->sailing_week->AdvancedSearch->SearchCondition = @$filter["v_sailing_week"];
        $this->sailing_week->AdvancedSearch->SearchValue2 = @$filter["y_sailing_week"];
        $this->sailing_week->AdvancedSearch->SearchOperator2 = @$filter["w_sailing_week"];
        $this->sailing_week->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field completed
        $this->completed->AdvancedSearch->SearchValue = @$filter["x_completed"];
        $this->completed->AdvancedSearch->SearchOperator = @$filter["z_completed"];
        $this->completed->AdvancedSearch->SearchCondition = @$filter["v_completed"];
        $this->completed->AdvancedSearch->SearchValue2 = @$filter["y_completed"];
        $this->completed->AdvancedSearch->SearchOperator2 = @$filter["w_completed"];
        $this->completed->AdvancedSearch->save();

        // Field label
        $this->label->AdvancedSearch->SearchValue = @$filter["x_label"];
        $this->label->AdvancedSearch->SearchOperator = @$filter["z_label"];
        $this->label->AdvancedSearch->SearchCondition = @$filter["v_label"];
        $this->label->AdvancedSearch->SearchValue2 = @$filter["y_label"];
        $this->label->AdvancedSearch->SearchOperator2 = @$filter["w_label"];
        $this->label->AdvancedSearch->save();

        // Field weight_sqm
        $this->weight_sqm->AdvancedSearch->SearchValue = @$filter["x_weight_sqm"];
        $this->weight_sqm->AdvancedSearch->SearchOperator = @$filter["z_weight_sqm"];
        $this->weight_sqm->AdvancedSearch->SearchCondition = @$filter["v_weight_sqm"];
        $this->weight_sqm->AdvancedSearch->SearchValue2 = @$filter["y_weight_sqm"];
        $this->weight_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_weight_sqm"];
        $this->weight_sqm->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->buyers_id, $default, false); // buyers_id
        $this->buildSearchSql($where, $this->reports_to, $default, true); // reports_to
        $this->buildSearchSql($where, $this->buyer_order, $default, false); // buyer_order
        $this->buildSearchSql($where, $this->item, $default, false); // item
        $this->buildSearchSql($where, $this->buyer_ref, $default, false); // buyer_ref
        $this->buildSearchSql($where, $this->order_week, $default, false); // order_week
        $this->buildSearchSql($where, $this->order_date, $default, false); // order_date
        $this->buildSearchSql($where, $this->ex_factory, $default, false); // ex_factory
        $this->buildSearchSql($where, $this->ex_factory_p, $default, true); // ex_factory_p
        $this->buildSearchSql($where, $this->shipping_mode, $default, false); // shipping_mode
        $this->buildSearchSql($where, $this->category, $default, false); // category
        $this->buildSearchSql($where, $this->cs, $default, false); // cs
        $this->buildSearchSql($where, $this->po, $default, false); // po
        $this->buildSearchSql($where, $this->design, $default, false); // design
        $this->buildSearchSql($where, $this->size_buyer, $default, false); // size_buyer
        $this->buildSearchSql($where, $this->width, $default, false); // width
        $this->buildSearchSql($where, $this->length, $default, false); // length
        $this->buildSearchSql($where, $this->qty, $default, false); // qty
        $this->buildSearchSql($where, $this->revised_qty, $default, false); // revised_qty
        $this->buildSearchSql($where, $this->sqm, $default, false); // sqm
        $this->buildSearchSql($where, $this->d_qty, $default, false); // d_qty
        $this->buildSearchSql($where, $this->pending, $default, false); // pending
        $this->buildSearchSql($where, $this->pending_sqm, $default, false); // pending_sqm
        $this->buildSearchSql($where, $this->offloom, $default, false); // offloom
        $this->buildSearchSql($where, $this->pending_offloom, $default, false); // pending_offloom
        $this->buildSearchSql($where, $this->pending_offloom_sqm, $default, false); // pending_offloom_sqm
        $this->buildSearchSql($where, $this->cbm, $default, false); // cbm
        $this->buildSearchSql($where, $this->total_cbm, $default, false); // total_cbm
        $this->buildSearchSql($where, $this->weaving_works, $default, false); // weaving_works
        $this->buildSearchSql($where, $this->current_works, $default, false); // current_works
        $this->buildSearchSql($where, $this->remarks, $default, false); // remarks
        $this->buildSearchSql($where, $this->pl_no, $default, false); // pl_no
        $this->buildSearchSql($where, $this->invoice_date, $default, false); // invoice_date
        $this->buildSearchSql($where, $this->sailing_week, $default, false); // sailing_week
        $this->buildSearchSql($where, $this->status, $default, true); // status
        $this->buildSearchSql($where, $this->completed, $default, false); // completed
        $this->buildSearchSql($where, $this->label, $default, false); // label
        $this->buildSearchSql($where, $this->weight_sqm, $default, false); // weight_sqm

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->buyers_id->AdvancedSearch->save(); // buyers_id
            $this->reports_to->AdvancedSearch->save(); // reports_to
            $this->buyer_order->AdvancedSearch->save(); // buyer_order
            $this->item->AdvancedSearch->save(); // item
            $this->buyer_ref->AdvancedSearch->save(); // buyer_ref
            $this->order_week->AdvancedSearch->save(); // order_week
            $this->order_date->AdvancedSearch->save(); // order_date
            $this->ex_factory->AdvancedSearch->save(); // ex_factory
            $this->ex_factory_p->AdvancedSearch->save(); // ex_factory_p
            $this->shipping_mode->AdvancedSearch->save(); // shipping_mode
            $this->category->AdvancedSearch->save(); // category
            $this->cs->AdvancedSearch->save(); // cs
            $this->po->AdvancedSearch->save(); // po
            $this->design->AdvancedSearch->save(); // design
            $this->size_buyer->AdvancedSearch->save(); // size_buyer
            $this->width->AdvancedSearch->save(); // width
            $this->length->AdvancedSearch->save(); // length
            $this->qty->AdvancedSearch->save(); // qty
            $this->revised_qty->AdvancedSearch->save(); // revised_qty
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->d_qty->AdvancedSearch->save(); // d_qty
            $this->pending->AdvancedSearch->save(); // pending
            $this->pending_sqm->AdvancedSearch->save(); // pending_sqm
            $this->offloom->AdvancedSearch->save(); // offloom
            $this->pending_offloom->AdvancedSearch->save(); // pending_offloom
            $this->pending_offloom_sqm->AdvancedSearch->save(); // pending_offloom_sqm
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->total_cbm->AdvancedSearch->save(); // total_cbm
            $this->weaving_works->AdvancedSearch->save(); // weaving_works
            $this->current_works->AdvancedSearch->save(); // current_works
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->pl_no->AdvancedSearch->save(); // pl_no
            $this->invoice_date->AdvancedSearch->save(); // invoice_date
            $this->sailing_week->AdvancedSearch->save(); // sailing_week
            $this->status->AdvancedSearch->save(); // status
            $this->completed->AdvancedSearch->save(); // completed
            $this->label->AdvancedSearch->save(); // label
            $this->weight_sqm->AdvancedSearch->save(); // weight_sqm

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->buyers_id->AdvancedSearch->save(); // buyers_id
            $this->reports_to->AdvancedSearch->save(); // reports_to
            $this->buyer_order->AdvancedSearch->save(); // buyer_order
            $this->item->AdvancedSearch->save(); // item
            $this->buyer_ref->AdvancedSearch->save(); // buyer_ref
            $this->order_week->AdvancedSearch->save(); // order_week
            $this->order_date->AdvancedSearch->save(); // order_date
            $this->ex_factory->AdvancedSearch->save(); // ex_factory
            $this->ex_factory_p->AdvancedSearch->save(); // ex_factory_p
            $this->shipping_mode->AdvancedSearch->save(); // shipping_mode
            $this->category->AdvancedSearch->save(); // category
            $this->cs->AdvancedSearch->save(); // cs
            $this->po->AdvancedSearch->save(); // po
            $this->design->AdvancedSearch->save(); // design
            $this->size_buyer->AdvancedSearch->save(); // size_buyer
            $this->width->AdvancedSearch->save(); // width
            $this->length->AdvancedSearch->save(); // length
            $this->qty->AdvancedSearch->save(); // qty
            $this->revised_qty->AdvancedSearch->save(); // revised_qty
            $this->sqm->AdvancedSearch->save(); // sqm
            $this->d_qty->AdvancedSearch->save(); // d_qty
            $this->pending->AdvancedSearch->save(); // pending
            $this->pending_sqm->AdvancedSearch->save(); // pending_sqm
            $this->offloom->AdvancedSearch->save(); // offloom
            $this->pending_offloom->AdvancedSearch->save(); // pending_offloom
            $this->pending_offloom_sqm->AdvancedSearch->save(); // pending_offloom_sqm
            $this->cbm->AdvancedSearch->save(); // cbm
            $this->total_cbm->AdvancedSearch->save(); // total_cbm
            $this->weaving_works->AdvancedSearch->save(); // weaving_works
            $this->current_works->AdvancedSearch->save(); // current_works
            $this->remarks->AdvancedSearch->save(); // remarks
            $this->pl_no->AdvancedSearch->save(); // pl_no
            $this->invoice_date->AdvancedSearch->save(); // invoice_date
            $this->sailing_week->AdvancedSearch->save(); // sailing_week
            $this->status->AdvancedSearch->save(); // status
            $this->completed->AdvancedSearch->save(); // completed
            $this->label->AdvancedSearch->save(); // label
            $this->weight_sqm->AdvancedSearch->save(); // weight_sqm
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyers_id
        $filter = $this->queryBuilderWhere("buyers_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyers_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyers_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field reports_to
        $filter = $this->queryBuilderWhere("reports_to");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->reports_to, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->reports_to->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_order
        $filter = $this->queryBuilderWhere("buyer_order");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_order, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_order->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field item
        $filter = $this->queryBuilderWhere("item");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->item, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->item->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field buyer_ref
        $filter = $this->queryBuilderWhere("buyer_ref");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->buyer_ref, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->buyer_ref->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field order_week
        $filter = $this->queryBuilderWhere("order_week");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->order_week, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->order_week->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field order_date
        $filter = $this->queryBuilderWhere("order_date");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->order_date, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->order_date->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ex_factory
        $filter = $this->queryBuilderWhere("ex_factory");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ex_factory, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ex_factory->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ex_factory_p
        $filter = $this->queryBuilderWhere("ex_factory_p");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ex_factory_p, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ex_factory_p->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field shipping_mode
        $filter = $this->queryBuilderWhere("shipping_mode");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->shipping_mode, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->shipping_mode->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field category
        $filter = $this->queryBuilderWhere("category");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->category, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->category->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cs
        $filter = $this->queryBuilderWhere("cs");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cs, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cs->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field po
        $filter = $this->queryBuilderWhere("po");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->po, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->po->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field design
        $filter = $this->queryBuilderWhere("design");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->design, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->design->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field size_buyer
        $filter = $this->queryBuilderWhere("size_buyer");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->size_buyer, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->size_buyer->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field width
        $filter = $this->queryBuilderWhere("width");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->width, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->width->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field length
        $filter = $this->queryBuilderWhere("length");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->length, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->length->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field qty
        $filter = $this->queryBuilderWhere("qty");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->qty, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qty->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field revised_qty
        $filter = $this->queryBuilderWhere("revised_qty");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->revised_qty, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->revised_qty->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sqm
        $filter = $this->queryBuilderWhere("sqm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sqm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sqm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field d_qty
        $filter = $this->queryBuilderWhere("d_qty");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->d_qty, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->d_qty->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pending
        $filter = $this->queryBuilderWhere("pending");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pending, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pending->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pending_sqm
        $filter = $this->queryBuilderWhere("pending_sqm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pending_sqm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pending_sqm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field offloom
        $filter = $this->queryBuilderWhere("offloom");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->offloom, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->offloom->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pending_offloom
        $filter = $this->queryBuilderWhere("pending_offloom");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pending_offloom, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pending_offloom->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pending_offloom_sqm
        $filter = $this->queryBuilderWhere("pending_offloom_sqm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pending_offloom_sqm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pending_offloom_sqm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cbm
        $filter = $this->queryBuilderWhere("cbm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cbm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cbm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field total_cbm
        $filter = $this->queryBuilderWhere("total_cbm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->total_cbm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->total_cbm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field weaving_works
        $filter = $this->queryBuilderWhere("weaving_works");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->weaving_works, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->weaving_works->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field current_works
        $filter = $this->queryBuilderWhere("current_works");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->current_works, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->current_works->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field remarks
        $filter = $this->queryBuilderWhere("remarks");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->remarks, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->remarks->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pl_no
        $filter = $this->queryBuilderWhere("pl_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pl_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pl_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field invoice_date
        $filter = $this->queryBuilderWhere("invoice_date");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->invoice_date, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->invoice_date->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sailing_week
        $filter = $this->queryBuilderWhere("sailing_week");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sailing_week, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sailing_week->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status
        $filter = $this->queryBuilderWhere("status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field completed
        $filter = $this->queryBuilderWhere("completed");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->completed, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->completed->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field label
        $filter = $this->queryBuilderWhere("label");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->label, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->label->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field weight_sqm
        $filter = $this->queryBuilderWhere("weight_sqm");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->weight_sqm, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->weight_sqm->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->buyer_order;
        $searchFlds[] = &$this->item;
        $searchFlds[] = &$this->buyer_ref;
        $searchFlds[] = &$this->ex_factory_p;
        $searchFlds[] = &$this->shipping_mode;
        $searchFlds[] = &$this->category;
        $searchFlds[] = &$this->design;
        $searchFlds[] = &$this->size_buyer;
        $searchFlds[] = &$this->cbm;
        $searchFlds[] = &$this->total_cbm;
        $searchFlds[] = &$this->remarks;
        $searchFlds[] = &$this->pl_no;
        $searchFlds[] = &$this->invoice_date;
        $searchFlds[] = &$this->sailing_week;
        $searchFlds[] = &$this->status;
        $searchFlds[] = &$this->completed;
        $searchFlds[] = &$this->label;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyers_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->reports_to->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_order->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->item->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->buyer_ref->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->order_week->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->order_date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ex_factory->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ex_factory_p->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->shipping_mode->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cs->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->po->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->design->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->size_buyer->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->width->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->length->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->revised_qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pending->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pending_sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->offloom->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pending_offloom->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pending_offloom_sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cbm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->total_cbm->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->weaving_works->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->current_works->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pl_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->invoice_date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sailing_week->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->completed->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->label->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->weight_sqm->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->buyers_id->AdvancedSearch->unsetSession();
        $this->reports_to->AdvancedSearch->unsetSession();
        $this->buyer_order->AdvancedSearch->unsetSession();
        $this->item->AdvancedSearch->unsetSession();
        $this->buyer_ref->AdvancedSearch->unsetSession();
        $this->order_week->AdvancedSearch->unsetSession();
        $this->order_date->AdvancedSearch->unsetSession();
        $this->ex_factory->AdvancedSearch->unsetSession();
        $this->ex_factory_p->AdvancedSearch->unsetSession();
        $this->shipping_mode->AdvancedSearch->unsetSession();
        $this->category->AdvancedSearch->unsetSession();
        $this->cs->AdvancedSearch->unsetSession();
        $this->po->AdvancedSearch->unsetSession();
        $this->design->AdvancedSearch->unsetSession();
        $this->size_buyer->AdvancedSearch->unsetSession();
        $this->width->AdvancedSearch->unsetSession();
        $this->length->AdvancedSearch->unsetSession();
        $this->qty->AdvancedSearch->unsetSession();
        $this->revised_qty->AdvancedSearch->unsetSession();
        $this->sqm->AdvancedSearch->unsetSession();
        $this->d_qty->AdvancedSearch->unsetSession();
        $this->pending->AdvancedSearch->unsetSession();
        $this->pending_sqm->AdvancedSearch->unsetSession();
        $this->offloom->AdvancedSearch->unsetSession();
        $this->pending_offloom->AdvancedSearch->unsetSession();
        $this->pending_offloom_sqm->AdvancedSearch->unsetSession();
        $this->cbm->AdvancedSearch->unsetSession();
        $this->total_cbm->AdvancedSearch->unsetSession();
        $this->weaving_works->AdvancedSearch->unsetSession();
        $this->current_works->AdvancedSearch->unsetSession();
        $this->remarks->AdvancedSearch->unsetSession();
        $this->pl_no->AdvancedSearch->unsetSession();
        $this->invoice_date->AdvancedSearch->unsetSession();
        $this->sailing_week->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->completed->AdvancedSearch->unsetSession();
        $this->label->AdvancedSearch->unsetSession();
        $this->weight_sqm->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
        $this->buyer_order->AdvancedSearch->load();
        $this->item->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->order_week->AdvancedSearch->load();
        $this->order_date->AdvancedSearch->load();
        $this->ex_factory->AdvancedSearch->load();
        $this->ex_factory_p->AdvancedSearch->load();
        $this->shipping_mode->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->cs->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->design->AdvancedSearch->load();
        $this->size_buyer->AdvancedSearch->load();
        $this->width->AdvancedSearch->load();
        $this->length->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->revised_qty->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->d_qty->AdvancedSearch->load();
        $this->pending->AdvancedSearch->load();
        $this->pending_sqm->AdvancedSearch->load();
        $this->offloom->AdvancedSearch->load();
        $this->pending_offloom->AdvancedSearch->load();
        $this->pending_offloom_sqm->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->total_cbm->AdvancedSearch->load();
        $this->weaving_works->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->sailing_week->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->completed->AdvancedSearch->load();
        $this->label->AdvancedSearch->load();
        $this->weight_sqm->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->buyers_id, $ctrl); // buyers_id
            $this->updateSort($this->reports_to, $ctrl); // reports_to
            $this->updateSort($this->buyer_order, $ctrl); // buyer_order
            $this->updateSort($this->item, $ctrl); // item
            $this->updateSort($this->buyer_ref, $ctrl); // buyer_ref
            $this->updateSort($this->order_week, $ctrl); // order_week
            $this->updateSort($this->order_date, $ctrl); // order_date
            $this->updateSort($this->ex_factory, $ctrl); // ex_factory
            $this->updateSort($this->ex_factory_p, $ctrl); // ex_factory_p
            $this->updateSort($this->shipping_mode, $ctrl); // shipping_mode
            $this->updateSort($this->category, $ctrl); // category
            $this->updateSort($this->cs, $ctrl); // cs
            $this->updateSort($this->po, $ctrl); // po
            $this->updateSort($this->design, $ctrl); // design
            $this->updateSort($this->size_buyer, $ctrl); // size_buyer
            $this->updateSort($this->width, $ctrl); // width
            $this->updateSort($this->length, $ctrl); // length
            $this->updateSort($this->qty, $ctrl); // qty
            $this->updateSort($this->revised_qty, $ctrl); // revised_qty
            $this->updateSort($this->sqm, $ctrl); // sqm
            $this->updateSort($this->d_qty, $ctrl); // d_qty
            $this->updateSort($this->pending, $ctrl); // pending
            $this->updateSort($this->pending_sqm, $ctrl); // pending_sqm
            $this->updateSort($this->offloom, $ctrl); // offloom
            $this->updateSort($this->pending_offloom, $ctrl); // pending_offloom
            $this->updateSort($this->pending_offloom_sqm, $ctrl); // pending_offloom_sqm
            $this->updateSort($this->cbm, $ctrl); // cbm
            $this->updateSort($this->total_cbm, $ctrl); // total_cbm
            $this->updateSort($this->weaving_works, $ctrl); // weaving_works
            $this->updateSort($this->current_works, $ctrl); // current_works
            $this->updateSort($this->remarks, $ctrl); // remarks
            $this->updateSort($this->pl_no, $ctrl); // pl_no
            $this->updateSort($this->invoice_date, $ctrl); // invoice_date
            $this->updateSort($this->sailing_week, $ctrl); // sailing_week
            $this->updateSort($this->status, $ctrl); // status
            $this->updateSort($this->completed, $ctrl); // completed
            $this->updateSort($this->rejection, $ctrl); // rejection
            $this->updateSort($this->label, $ctrl); // label
            $this->updateSort($this->weight_sqm, $ctrl); // weight_sqm
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->buyers_id->setSort("");
                $this->reports_to->setSort("");
                $this->buyer_order->setSort("");
                $this->item->setSort("");
                $this->buyer_ref->setSort("");
                $this->order_week->setSort("");
                $this->order_date->setSort("");
                $this->ex_factory->setSort("");
                $this->ex_factory_p->setSort("");
                $this->shipping_mode->setSort("");
                $this->category->setSort("");
                $this->cs->setSort("");
                $this->po->setSort("");
                $this->design->setSort("");
                $this->size_buyer->setSort("");
                $this->width->setSort("");
                $this->length->setSort("");
                $this->qty->setSort("");
                $this->revised_qty->setSort("");
                $this->sqm->setSort("");
                $this->d_qty->setSort("");
                $this->pending->setSort("");
                $this->pending_sqm->setSort("");
                $this->offloom->setSort("");
                $this->pending_offloom->setSort("");
                $this->pending_offloom_sqm->setSort("");
                $this->cbm->setSort("");
                $this->total_cbm->setSort("");
                $this->weaving_works->setSort("");
                $this->current_works->setSort("");
                $this->remarks->setSort("");
                $this->pl_no->setSort("");
                $this->invoice_date->setSort("");
                $this->sailing_week->setSort("");
                $this->status->setSort("");
                $this->completed->setSort("");
                $this->rejection->setSort("");
                $this->label->setSort("");
                $this->weight_sqm->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") { // Check view mode
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"foms_table_2list\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"foms_table_2list\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "buyers_id");
            $this->createColumnOption($option, "reports_to");
            $this->createColumnOption($option, "buyer_order");
            $this->createColumnOption($option, "item");
            $this->createColumnOption($option, "buyer_ref");
            $this->createColumnOption($option, "order_week");
            $this->createColumnOption($option, "order_date");
            $this->createColumnOption($option, "ex_factory");
            $this->createColumnOption($option, "ex_factory_p");
            $this->createColumnOption($option, "shipping_mode");
            $this->createColumnOption($option, "category");
            $this->createColumnOption($option, "cs");
            $this->createColumnOption($option, "po");
            $this->createColumnOption($option, "design");
            $this->createColumnOption($option, "size_buyer");
            $this->createColumnOption($option, "width");
            $this->createColumnOption($option, "length");
            $this->createColumnOption($option, "qty");
            $this->createColumnOption($option, "revised_qty");
            $this->createColumnOption($option, "sqm");
            $this->createColumnOption($option, "d_qty");
            $this->createColumnOption($option, "pending");
            $this->createColumnOption($option, "pending_sqm");
            $this->createColumnOption($option, "offloom");
            $this->createColumnOption($option, "pending_offloom");
            $this->createColumnOption($option, "pending_offloom_sqm");
            $this->createColumnOption($option, "cbm");
            $this->createColumnOption($option, "total_cbm");
            $this->createColumnOption($option, "weaving_works");
            $this->createColumnOption($option, "current_works");
            $this->createColumnOption($option, "remarks");
            $this->createColumnOption($option, "pl_no");
            $this->createColumnOption($option, "invoice_date");
            $this->createColumnOption($option, "sailing_week");
            $this->createColumnOption($option, "status");
            $this->createColumnOption($option, "completed");
            $this->createColumnOption($option, "rejection");
            $this->createColumnOption($option, "label");
            $this->createColumnOption($option, "weight_sqm");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"foms_table_2srch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"foms_table_2srch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="foms_table_2list"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_oms_table_2", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_oms_table_2",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyers_id
        if ($this->buyers_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyers_id->AdvancedSearch->SearchValue != "" || $this->buyers_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // reports_to
        if ($this->reports_to->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->reports_to->AdvancedSearch->SearchValue != "" || $this->reports_to->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->reports_to->AdvancedSearch->SearchValue)) {
            $this->reports_to->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->reports_to->AdvancedSearch->SearchValue);
        }
        if (is_array($this->reports_to->AdvancedSearch->SearchValue2)) {
            $this->reports_to->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->reports_to->AdvancedSearch->SearchValue2);
        }

        // buyer_order
        if ($this->buyer_order->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_order->AdvancedSearch->SearchValue != "" || $this->buyer_order->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // item
        if ($this->item->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->item->AdvancedSearch->SearchValue != "" || $this->item->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // buyer_ref
        if ($this->buyer_ref->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->buyer_ref->AdvancedSearch->SearchValue != "" || $this->buyer_ref->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // order_week
        if ($this->order_week->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->order_week->AdvancedSearch->SearchValue != "" || $this->order_week->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // order_date
        if ($this->order_date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->order_date->AdvancedSearch->SearchValue != "" || $this->order_date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ex_factory
        if ($this->ex_factory->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ex_factory->AdvancedSearch->SearchValue != "" || $this->ex_factory->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ex_factory_p
        if ($this->ex_factory_p->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ex_factory_p->AdvancedSearch->SearchValue != "" || $this->ex_factory_p->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->ex_factory_p->AdvancedSearch->SearchValue)) {
            $this->ex_factory_p->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->ex_factory_p->AdvancedSearch->SearchValue);
        }
        if (is_array($this->ex_factory_p->AdvancedSearch->SearchValue2)) {
            $this->ex_factory_p->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->ex_factory_p->AdvancedSearch->SearchValue2);
        }

        // shipping_mode
        if ($this->shipping_mode->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->shipping_mode->AdvancedSearch->SearchValue != "" || $this->shipping_mode->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->category->AdvancedSearch->SearchValue != "" || $this->category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cs
        if ($this->cs->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cs->AdvancedSearch->SearchValue != "" || $this->cs->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->po->AdvancedSearch->SearchValue != "" || $this->po->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // design
        if ($this->design->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->design->AdvancedSearch->SearchValue != "" || $this->design->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // size_buyer
        if ($this->size_buyer->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->size_buyer->AdvancedSearch->SearchValue != "" || $this->size_buyer->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // width
        if ($this->width->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->width->AdvancedSearch->SearchValue != "" || $this->width->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // length
        if ($this->length->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->length->AdvancedSearch->SearchValue != "" || $this->length->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // qty
        if ($this->qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->qty->AdvancedSearch->SearchValue != "" || $this->qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // revised_qty
        if ($this->revised_qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->revised_qty->AdvancedSearch->SearchValue != "" || $this->revised_qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sqm->AdvancedSearch->SearchValue != "" || $this->sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_qty
        if ($this->d_qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_qty->AdvancedSearch->SearchValue != "" || $this->d_qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pending
        if ($this->pending->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pending->AdvancedSearch->SearchValue != "" || $this->pending->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pending_sqm
        if ($this->pending_sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pending_sqm->AdvancedSearch->SearchValue != "" || $this->pending_sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // offloom
        if ($this->offloom->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->offloom->AdvancedSearch->SearchValue != "" || $this->offloom->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pending_offloom
        if ($this->pending_offloom->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pending_offloom->AdvancedSearch->SearchValue != "" || $this->pending_offloom->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pending_offloom_sqm
        if ($this->pending_offloom_sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pending_offloom_sqm->AdvancedSearch->SearchValue != "" || $this->pending_offloom_sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cbm
        if ($this->cbm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cbm->AdvancedSearch->SearchValue != "" || $this->cbm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // total_cbm
        if ($this->total_cbm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->total_cbm->AdvancedSearch->SearchValue != "" || $this->total_cbm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // weaving_works
        if ($this->weaving_works->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->weaving_works->AdvancedSearch->SearchValue != "" || $this->weaving_works->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // current_works
        if ($this->current_works->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->current_works->AdvancedSearch->SearchValue != "" || $this->current_works->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->remarks->AdvancedSearch->SearchValue != "" || $this->remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pl_no
        if ($this->pl_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pl_no->AdvancedSearch->SearchValue != "" || $this->pl_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // invoice_date
        if ($this->invoice_date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->invoice_date->AdvancedSearch->SearchValue != "" || $this->invoice_date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sailing_week
        if ($this->sailing_week->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sailing_week->AdvancedSearch->SearchValue != "" || $this->sailing_week->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->status->AdvancedSearch->SearchValue)) {
            $this->status->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->status->AdvancedSearch->SearchValue);
        }
        if (is_array($this->status->AdvancedSearch->SearchValue2)) {
            $this->status->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->status->AdvancedSearch->SearchValue2);
        }

        // completed
        if ($this->completed->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->completed->AdvancedSearch->SearchValue != "" || $this->completed->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // label
        if ($this->label->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->label->AdvancedSearch->SearchValue != "" || $this->label->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // weight_sqm
        if ($this->weight_sqm->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->weight_sqm->AdvancedSearch->SearchValue != "" || $this->weight_sqm->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->buyer_order->setDbValue($row['buyer_order']);
        $this->item->setDbValue($row['item']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->order_week->setDbValue($row['order_week']);
        $this->order_date->setDbValue($row['order_date']);
        $this->ex_factory->setDbValue($row['ex_factory']);
        $this->ex_factory_p->setDbValue($row['ex_factory_p']);
        $this->shipping_mode->setDbValue($row['shipping_mode']);
        $this->category->setDbValue($row['category']);
        $this->cs->setDbValue($row['cs']);
        $this->po->setDbValue($row['po']);
        $this->design->setDbValue($row['design']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->width->setDbValue($row['width']);
        $this->length->setDbValue($row['length']);
        $this->qty->setDbValue($row['qty']);
        $this->revised_qty->setDbValue($row['revised_qty']);
        $this->sqm->setDbValue($row['sqm']);
        $this->d_qty->setDbValue($row['d_qty']);
        $this->pending->setDbValue($row['pending']);
        $this->pending_sqm->setDbValue($row['pending_sqm']);
        $this->offloom->setDbValue($row['offloom']);
        $this->pending_offloom->setDbValue($row['pending_offloom']);
        $this->pending_offloom_sqm->setDbValue($row['pending_offloom_sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->total_cbm->setDbValue($row['total_cbm']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->current_works->setDbValue($row['current_works']);
        $this->remarks->setDbValue($row['remarks']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->sailing_week->setDbValue($row['sailing_week']);
        $this->status->setDbValue($row['status']);
        $this->completed->setDbValue($row['completed']);
        $this->rejection->setDbValue($row['rejection']);
        $this->label->setDbValue($row['label']);
        $this->weight_sqm->setDbValue($row['weight_sqm']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['buyers_id'] = $this->buyers_id->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['buyer_order'] = $this->buyer_order->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['buyer_ref'] = $this->buyer_ref->DefaultValue;
        $row['order_week'] = $this->order_week->DefaultValue;
        $row['order_date'] = $this->order_date->DefaultValue;
        $row['ex_factory'] = $this->ex_factory->DefaultValue;
        $row['ex_factory_p'] = $this->ex_factory_p->DefaultValue;
        $row['shipping_mode'] = $this->shipping_mode->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['cs'] = $this->cs->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['size_buyer'] = $this->size_buyer->DefaultValue;
        $row['width'] = $this->width->DefaultValue;
        $row['length'] = $this->length->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['revised_qty'] = $this->revised_qty->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['d_qty'] = $this->d_qty->DefaultValue;
        $row['pending'] = $this->pending->DefaultValue;
        $row['pending_sqm'] = $this->pending_sqm->DefaultValue;
        $row['offloom'] = $this->offloom->DefaultValue;
        $row['pending_offloom'] = $this->pending_offloom->DefaultValue;
        $row['pending_offloom_sqm'] = $this->pending_offloom_sqm->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['total_cbm'] = $this->total_cbm->DefaultValue;
        $row['weaving_works'] = $this->weaving_works->DefaultValue;
        $row['current_works'] = $this->current_works->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['pl_no'] = $this->pl_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['sailing_week'] = $this->sailing_week->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['completed'] = $this->completed->DefaultValue;
        $row['rejection'] = $this->rejection->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['weight_sqm'] = $this->weight_sqm->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // buyers_id

        // reports_to

        // buyer_order

        // item

        // buyer_ref

        // order_week

        // order_date

        // ex_factory

        // ex_factory_p

        // shipping_mode

        // category

        // cs

        // po

        // design

        // size_buyer

        // width

        // length

        // qty

        // revised_qty

        // sqm

        // d_qty

        // pending

        // pending_sqm

        // offloom

        // pending_offloom

        // pending_offloom_sqm

        // cbm

        // total_cbm

        // weaving_works

        // current_works

        // remarks

        // pl_no

        // invoice_date

        // sailing_week

        // status

        // completed

        // rejection
        $this->rejection->CellCssStyle = "white-space: nowrap;";

        // label

        // weight_sqm

        // Accumulate aggregate value
        if ($this->RowType != RowType::AGGREGATEINIT && $this->RowType != RowType::AGGREGATE && $this->RowType != RowType::PREVIEWFIELD) {
            if (is_numeric($this->qty->CurrentValue)) {
                $this->qty->Total += $this->qty->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->sqm->CurrentValue)) {
                $this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->d_qty->CurrentValue)) {
                $this->d_qty->Total += $this->d_qty->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->pending->CurrentValue)) {
                $this->pending->Total += $this->pending->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->pending_sqm->CurrentValue)) {
                $this->pending_sqm->Total += $this->pending_sqm->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->offloom->CurrentValue)) {
                $this->offloom->Total += $this->offloom->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->pending_offloom->CurrentValue)) {
                $this->pending_offloom->Total += $this->pending_offloom->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->pending_offloom_sqm->CurrentValue)) {
                $this->pending_offloom_sqm->Total += $this->pending_offloom_sqm->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->rejection->CurrentValue)) {
                $this->rejection->Total += $this->rejection->CurrentValue; // Accumulate total
            }
        }

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // buyers_id
            $curVal = strval($this->buyers_id->CurrentValue);
            if ($curVal != "") {
                $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
                if ($this->buyers_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                    } else {
                        $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                    }
                }
            } else {
                $this->buyers_id->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->reports_to->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->reports_to->Lookup->renderViewRow($row);
                            $this->reports_to->ViewValue->add($this->reports_to->displayValue($arwrk));
                        }
                    } else {
                        $this->reports_to->ViewValue = $this->reports_to->CurrentValue;
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // buyer_order
            $this->buyer_order->ViewValue = $this->buyer_order->CurrentValue;

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // buyer_ref
            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;

            // order_week
            $curVal = strval($this->order_week->CurrentValue);
            if ($curVal != "") {
                $this->order_week->ViewValue = $this->order_week->lookupCacheOption($curVal);
                if ($this->order_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->order_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->order_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->order_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->order_week->Lookup->renderViewRow($rswrk[0]);
                        $this->order_week->ViewValue = $this->order_week->displayValue($arwrk);
                    } else {
                        $this->order_week->ViewValue = FormatNumber($this->order_week->CurrentValue, $this->order_week->formatPattern());
                    }
                }
            } else {
                $this->order_week->ViewValue = null;
            }

            // order_date
            $this->order_date->ViewValue = $this->order_date->CurrentValue;
            $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

            // ex_factory
            $curVal = strval($this->ex_factory->CurrentValue);
            if ($curVal != "") {
                $this->ex_factory->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
                if ($this->ex_factory->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ex_factory->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ex_factory->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->ex_factory->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ex_factory->Lookup->renderViewRow($rswrk[0]);
                        $this->ex_factory->ViewValue = $this->ex_factory->displayValue($arwrk);
                    } else {
                        $this->ex_factory->ViewValue = FormatNumber($this->ex_factory->CurrentValue, $this->ex_factory->formatPattern());
                    }
                }
            } else {
                $this->ex_factory->ViewValue = null;
            }

            // ex_factory_p
            $curVal = strval($this->ex_factory_p->CurrentValue);
            if ($curVal != "") {
                $this->ex_factory_p->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
                if ($this->ex_factory_p->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->ex_factory_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->ex_factory_p->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->ex_factory_p->Lookup->renderViewRow($row);
                            $this->ex_factory_p->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
                        }
                    } else {
                        $this->ex_factory_p->ViewValue = $this->ex_factory_p->CurrentValue;
                    }
                }
            } else {
                $this->ex_factory_p->ViewValue = null;
            }

            // shipping_mode
            $this->shipping_mode->ViewValue = $this->shipping_mode->CurrentValue;

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // cs
            if (strval($this->cs->CurrentValue) != "") {
                $this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
            } else {
                $this->cs->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // size_buyer
            $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

            // width
            $this->width->ViewValue = $this->width->CurrentValue;
            $this->width->ViewValue = FormatNumber($this->width->ViewValue, $this->width->formatPattern());

            // length
            $this->length->ViewValue = $this->length->CurrentValue;
            $this->length->ViewValue = FormatNumber($this->length->ViewValue, $this->length->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // revised_qty
            $this->revised_qty->ViewValue = $this->revised_qty->CurrentValue;
            $this->revised_qty->ViewValue = FormatNumber($this->revised_qty->ViewValue, $this->revised_qty->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // d_qty
            $this->d_qty->ViewValue = $this->d_qty->CurrentValue;
            $this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, $this->d_qty->formatPattern());

            // pending
            $this->pending->ViewValue = $this->pending->CurrentValue;
            $this->pending->ViewValue = FormatNumber($this->pending->ViewValue, $this->pending->formatPattern());

            // pending_sqm
            $this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
            $this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, $this->pending_sqm->formatPattern());

            // offloom
            $this->offloom->ViewValue = $this->offloom->CurrentValue;
            $this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, $this->offloom->formatPattern());

            // pending_offloom
            $this->pending_offloom->ViewValue = $this->pending_offloom->CurrentValue;
            $this->pending_offloom->ViewValue = FormatNumber($this->pending_offloom->ViewValue, $this->pending_offloom->formatPattern());

            // pending_offloom_sqm
            $this->pending_offloom_sqm->ViewValue = $this->pending_offloom_sqm->CurrentValue;
            $this->pending_offloom_sqm->ViewValue = FormatNumber($this->pending_offloom_sqm->ViewValue, $this->pending_offloom_sqm->formatPattern());

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;

            // total_cbm
            $this->total_cbm->ViewValue = $this->total_cbm->CurrentValue;

            // weaving_works
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pl_no
            $this->pl_no->ViewValue = $this->pl_no->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;

            // sailing_week
            $this->sailing_week->ViewValue = $this->sailing_week->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->status->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->status->Lookup->renderViewRow($row);
                            $this->status->ViewValue->add($this->status->displayValue($arwrk));
                        }
                    } else {
                        $this->status->ViewValue = $this->status->CurrentValue;
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // completed
            if (strval($this->completed->CurrentValue) != "") {
                $this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
            } else {
                $this->completed->ViewValue = null;
            }

            // rejection
            $this->rejection->ViewValue = FormatNumber($this->rejection->ViewValue, $this->rejection->formatPattern());

            // label
            $this->label->ViewValue = $this->label->CurrentValue;

            // weight_sqm
            $this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
            $this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, $this->weight_sqm->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // buyers_id
            $this->buyers_id->HrefValue = "";
            $this->buyers_id->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // buyer_order
            $this->buyer_order->HrefValue = "";
            $this->buyer_order->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_order->ViewValue = $this->highlightValue($this->buyer_order);
            }

            // item
            $this->item->HrefValue = "";
            $this->item->TooltipValue = "";
            if (!$this->isExport()) {
                $this->item->ViewValue = $this->highlightValue($this->item);
            }

            // buyer_ref
            $this->buyer_ref->HrefValue = "";
            $this->buyer_ref->TooltipValue = "";
            if (!$this->isExport()) {
                $this->buyer_ref->ViewValue = $this->highlightValue($this->buyer_ref);
            }

            // order_week
            $this->order_week->HrefValue = "";
            $this->order_week->TooltipValue = "";

            // order_date
            $this->order_date->HrefValue = "";
            $this->order_date->TooltipValue = "";
            if (!$this->isExport()) {
                $this->order_date->ViewValue = $this->highlightValue($this->order_date);
            }

            // ex_factory
            $this->ex_factory->HrefValue = "";
            $this->ex_factory->TooltipValue = "";

            // ex_factory_p
            $this->ex_factory_p->HrefValue = "";
            $this->ex_factory_p->TooltipValue = "";

            // shipping_mode
            $this->shipping_mode->HrefValue = "";
            $this->shipping_mode->TooltipValue = "";
            if (!$this->isExport()) {
                $this->shipping_mode->ViewValue = $this->highlightValue($this->shipping_mode);
            }

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // cs
            $this->cs->HrefValue = "";
            $this->cs->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";
            if (!$this->isExport()) {
                $this->design->ViewValue = $this->highlightValue($this->design);
            }

            // size_buyer
            $this->size_buyer->HrefValue = "";
            $this->size_buyer->TooltipValue = "";
            if (!$this->isExport()) {
                $this->size_buyer->ViewValue = $this->highlightValue($this->size_buyer);
            }

            // width
            $this->width->HrefValue = "";
            $this->width->TooltipValue = "";

            // length
            $this->length->HrefValue = "";
            $this->length->TooltipValue = "";

            // qty
            $this->qty->HrefValue = "";
            $this->qty->TooltipValue = "";

            // revised_qty
            $this->revised_qty->HrefValue = "";
            $this->revised_qty->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // d_qty
            $this->d_qty->HrefValue = "";
            $this->d_qty->TooltipValue = "";

            // pending
            $this->pending->HrefValue = "";
            $this->pending->TooltipValue = "";

            // pending_sqm
            $this->pending_sqm->HrefValue = "";
            $this->pending_sqm->TooltipValue = "";

            // offloom
            $this->offloom->HrefValue = "";
            $this->offloom->TooltipValue = "";

            // pending_offloom
            $this->pending_offloom->HrefValue = "";
            $this->pending_offloom->TooltipValue = "";

            // pending_offloom_sqm
            $this->pending_offloom_sqm->HrefValue = "";
            $this->pending_offloom_sqm->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";
            if (!$this->isExport()) {
                $this->cbm->ViewValue = $this->highlightValue($this->cbm);
            }

            // total_cbm
            $this->total_cbm->HrefValue = "";
            $this->total_cbm->TooltipValue = "";
            if (!$this->isExport()) {
                $this->total_cbm->ViewValue = $this->highlightValue($this->total_cbm);
            }

            // weaving_works
            $this->weaving_works->HrefValue = "";
            $this->weaving_works->TooltipValue = "";

            // current_works
            $this->current_works->HrefValue = "";
            $this->current_works->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->remarks->ViewValue = $this->highlightValue($this->remarks);
            }

            // pl_no
            $this->pl_no->HrefValue = "";
            $this->pl_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->pl_no->ViewValue = $this->highlightValue($this->pl_no);
            }

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";
            if (!$this->isExport()) {
                $this->invoice_date->ViewValue = $this->highlightValue($this->invoice_date);
            }

            // sailing_week
            $this->sailing_week->HrefValue = "";
            $this->sailing_week->TooltipValue = "";
            if (!$this->isExport()) {
                $this->sailing_week->ViewValue = $this->highlightValue($this->sailing_week);
            }

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // completed
            $this->completed->HrefValue = "";
            $this->completed->TooltipValue = "";

            // rejection
            $this->rejection->HrefValue = "";
            $this->rejection->TooltipValue = "";

            // label
            $this->label->HrefValue = "";
            $this->label->TooltipValue = "";
            if (!$this->isExport()) {
                $this->label->ViewValue = $this->highlightValue($this->label);
            }

            // weight_sqm
            $this->weight_sqm->HrefValue = "";
            $this->weight_sqm->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // buyers_id
            $this->buyers_id->setupEditAttributes();
            $curVal = trim(strval($this->buyers_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            } else {
                $this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->Lookup !== null && is_array($this->buyers_id->lookupOptions()) && count($this->buyers_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyers_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyers_id->EditValue = array_values($this->buyers_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyers_id->AdvancedSearch->SearchValue, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->buyers_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyers_id->EditValue = $arwrk;
            }
            $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // buyer_order
            $this->buyer_order->setupEditAttributes();
            if (!$this->buyer_order->Raw) {
                $this->buyer_order->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_order->AdvancedSearch->SearchValue);
            }
            $this->buyer_order->EditValue = HtmlEncode($this->buyer_order->AdvancedSearch->SearchValue);
            $this->buyer_order->PlaceHolder = RemoveHtml($this->buyer_order->caption());

            // item
            $this->item->setupEditAttributes();
            if (!$this->item->Raw) {
                $this->item->AdvancedSearch->SearchValue = HtmlDecode($this->item->AdvancedSearch->SearchValue);
            }
            $this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            if (!$this->buyer_ref->Raw) {
                $this->buyer_ref->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_ref->AdvancedSearch->SearchValue);
            }
            $this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
            $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

            // order_week
            $this->order_week->setupEditAttributes();
            $this->order_week->PlaceHolder = RemoveHtml($this->order_week->caption());

            // order_date
            $this->order_date->setupEditAttributes();
            $this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, $this->order_date->formatPattern()), $this->order_date->formatPattern()));
            $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

            // ex_factory
            $this->ex_factory->setupEditAttributes();
            $this->ex_factory->PlaceHolder = RemoveHtml($this->ex_factory->caption());

            // ex_factory_p
            $curVal = trim(strval($this->ex_factory_p->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->ex_factory_p->AdvancedSearch->ViewValue = $this->ex_factory_p->lookupCacheOption($curVal);
            } else {
                $this->ex_factory_p->AdvancedSearch->ViewValue = $this->ex_factory_p->Lookup !== null && is_array($this->ex_factory_p->lookupOptions()) && count($this->ex_factory_p->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ex_factory_p->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->ex_factory_p->EditValue = array_values($this->ex_factory_p->lookupOptions());
                if ($this->ex_factory_p->AdvancedSearch->ViewValue == "") {
                    $this->ex_factory_p->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->ex_factory_p->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->ex_factory_p->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->ex_factory_p->Lookup->renderViewRow($row);
                        $this->ex_factory_p->AdvancedSearch->ViewValue->add($this->ex_factory_p->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->ex_factory_p->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->ex_factory_p->EditValue = $arwrk;
            }
            $this->ex_factory_p->PlaceHolder = RemoveHtml($this->ex_factory_p->caption());
            $curVal = trim(strval($this->ex_factory_p->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->ex_factory_p->AdvancedSearch->ViewValue2 = $this->ex_factory_p->lookupCacheOption($curVal);
            } else {
                $this->ex_factory_p->AdvancedSearch->ViewValue2 = $this->ex_factory_p->Lookup !== null && is_array($this->ex_factory_p->lookupOptions()) && count($this->ex_factory_p->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ex_factory_p->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->ex_factory_p->EditValue2 = array_values($this->ex_factory_p->lookupOptions());
                if ($this->ex_factory_p->AdvancedSearch->ViewValue2 == "") {
                    $this->ex_factory_p->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->ex_factory_p->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->ex_factory_p->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->ex_factory_p->AdvancedSearch->ViewValue2 = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->ex_factory_p->Lookup->renderViewRow($row);
                        $this->ex_factory_p->AdvancedSearch->ViewValue2->add($this->ex_factory_p->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->ex_factory_p->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->ex_factory_p->EditValue2 = $arwrk;
            }
            $this->ex_factory_p->PlaceHolder = RemoveHtml($this->ex_factory_p->caption());

            // shipping_mode
            $this->shipping_mode->setupEditAttributes();
            if (!$this->shipping_mode->Raw) {
                $this->shipping_mode->AdvancedSearch->SearchValue = HtmlDecode($this->shipping_mode->AdvancedSearch->SearchValue);
            }
            $this->shipping_mode->EditValue = HtmlEncode($this->shipping_mode->AdvancedSearch->SearchValue);
            $this->shipping_mode->PlaceHolder = RemoveHtml($this->shipping_mode->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // cs
            $this->cs->setupEditAttributes();
            $this->cs->EditValue = $this->cs->options(true);
            $this->cs->PlaceHolder = RemoveHtml($this->cs->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            $this->po->setupEditAttributes();
            $this->po->EditValue2 = $this->po->AdvancedSearch->SearchValue2;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // design
            $this->design->setupEditAttributes();
            if (!$this->design->Raw) {
                $this->design->AdvancedSearch->SearchValue = HtmlDecode($this->design->AdvancedSearch->SearchValue);
            }
            $this->design->EditValue = HtmlEncode($this->design->AdvancedSearch->SearchValue);
            $this->design->PlaceHolder = RemoveHtml($this->design->caption());

            // size_buyer
            $this->size_buyer->setupEditAttributes();
            if (!$this->size_buyer->Raw) {
                $this->size_buyer->AdvancedSearch->SearchValue = HtmlDecode($this->size_buyer->AdvancedSearch->SearchValue);
            }
            $this->size_buyer->EditValue = HtmlEncode($this->size_buyer->AdvancedSearch->SearchValue);
            $this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

            // width
            $this->width->setupEditAttributes();
            $this->width->EditValue = $this->width->AdvancedSearch->SearchValue;
            $this->width->PlaceHolder = RemoveHtml($this->width->caption());

            // length
            $this->length->setupEditAttributes();
            $this->length->EditValue = $this->length->AdvancedSearch->SearchValue;
            $this->length->PlaceHolder = RemoveHtml($this->length->caption());

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->AdvancedSearch->SearchValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

            // revised_qty
            $this->revised_qty->setupEditAttributes();
            $this->revised_qty->EditValue = $this->revised_qty->AdvancedSearch->SearchValue;
            $this->revised_qty->PlaceHolder = RemoveHtml($this->revised_qty->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // d_qty
            $this->d_qty->setupEditAttributes();
            $this->d_qty->EditValue = $this->d_qty->AdvancedSearch->SearchValue;
            $this->d_qty->PlaceHolder = RemoveHtml($this->d_qty->caption());

            // pending
            $this->pending->setupEditAttributes();
            $this->pending->EditValue = $this->pending->AdvancedSearch->SearchValue;
            $this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
            $this->pending->setupEditAttributes();
            $this->pending->EditValue2 = $this->pending->AdvancedSearch->SearchValue2;
            $this->pending->PlaceHolder = RemoveHtml($this->pending->caption());

            // pending_sqm
            $this->pending_sqm->setupEditAttributes();
            $this->pending_sqm->EditValue = $this->pending_sqm->AdvancedSearch->SearchValue;
            $this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());
            $this->pending_sqm->setupEditAttributes();
            $this->pending_sqm->EditValue2 = $this->pending_sqm->AdvancedSearch->SearchValue2;
            $this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());

            // offloom
            $this->offloom->setupEditAttributes();
            $this->offloom->EditValue = $this->offloom->AdvancedSearch->SearchValue;
            $this->offloom->PlaceHolder = RemoveHtml($this->offloom->caption());

            // pending_offloom
            $this->pending_offloom->setupEditAttributes();
            $this->pending_offloom->EditValue = $this->pending_offloom->AdvancedSearch->SearchValue;
            $this->pending_offloom->PlaceHolder = RemoveHtml($this->pending_offloom->caption());

            // pending_offloom_sqm
            $this->pending_offloom_sqm->setupEditAttributes();
            $this->pending_offloom_sqm->EditValue = $this->pending_offloom_sqm->AdvancedSearch->SearchValue;
            $this->pending_offloom_sqm->PlaceHolder = RemoveHtml($this->pending_offloom_sqm->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

            // total_cbm
            $this->total_cbm->setupEditAttributes();
            $this->total_cbm->EditValue = HtmlEncode($this->total_cbm->AdvancedSearch->SearchValue);
            $this->total_cbm->PlaceHolder = RemoveHtml($this->total_cbm->caption());

            // weaving_works
            $this->weaving_works->setupEditAttributes();
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // pl_no
            $this->pl_no->setupEditAttributes();
            if (!$this->pl_no->Raw) {
                $this->pl_no->AdvancedSearch->SearchValue = HtmlDecode($this->pl_no->AdvancedSearch->SearchValue);
            }
            $this->pl_no->EditValue = HtmlEncode($this->pl_no->AdvancedSearch->SearchValue);
            $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = HtmlEncode($this->invoice_date->AdvancedSearch->SearchValue);
            $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

            // sailing_week
            $this->sailing_week->setupEditAttributes();
            $this->sailing_week->EditValue = HtmlEncode($this->sailing_week->AdvancedSearch->SearchValue);
            $this->sailing_week->PlaceHolder = RemoveHtml($this->sailing_week->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // completed
            $this->completed->setupEditAttributes();
            $this->completed->EditValue = $this->completed->options(true);
            $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

            // rejection
            $this->rejection->setupEditAttributes();
            $this->rejection->PlaceHolder = RemoveHtml($this->rejection->caption());

            // label
            $this->label->setupEditAttributes();
            if (!$this->label->Raw) {
                $this->label->AdvancedSearch->SearchValue = HtmlDecode($this->label->AdvancedSearch->SearchValue);
            }
            $this->label->EditValue = HtmlEncode($this->label->AdvancedSearch->SearchValue);
            $this->label->PlaceHolder = RemoveHtml($this->label->caption());

            // weight_sqm
            $this->weight_sqm->setupEditAttributes();
            $this->weight_sqm->EditValue = $this->weight_sqm->AdvancedSearch->SearchValue;
            $this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
        } elseif ($this->RowType == RowType::AGGREGATEINIT) { // Initialize aggregate row
                    $this->qty->Total = 0; // Initialize total
                    $this->sqm->Total = 0; // Initialize total
                    $this->d_qty->Total = 0; // Initialize total
                    $this->pending->Total = 0; // Initialize total
                    $this->pending_sqm->Total = 0; // Initialize total
                    $this->offloom->Total = 0; // Initialize total
                    $this->pending_offloom->Total = 0; // Initialize total
                    $this->pending_offloom_sqm->Total = 0; // Initialize total
                    $this->rejection->Total = 0; // Initialize total
        } elseif ($this->RowType == RowType::AGGREGATE) { // Aggregate row
            $this->qty->CurrentValue = $this->qty->Total;
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());
            $this->qty->HrefValue = ""; // Clear href value
            $this->sqm->CurrentValue = $this->sqm->Total;
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());
            $this->sqm->HrefValue = ""; // Clear href value
            $this->d_qty->CurrentValue = $this->d_qty->Total;
            $this->d_qty->ViewValue = $this->d_qty->CurrentValue;
            $this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, $this->d_qty->formatPattern());
            $this->d_qty->HrefValue = ""; // Clear href value
            $this->pending->CurrentValue = $this->pending->Total;
            $this->pending->ViewValue = $this->pending->CurrentValue;
            $this->pending->ViewValue = FormatNumber($this->pending->ViewValue, $this->pending->formatPattern());
            $this->pending->HrefValue = ""; // Clear href value
            $this->pending_sqm->CurrentValue = $this->pending_sqm->Total;
            $this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
            $this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, $this->pending_sqm->formatPattern());
            $this->pending_sqm->HrefValue = ""; // Clear href value
            $this->offloom->CurrentValue = $this->offloom->Total;
            $this->offloom->ViewValue = $this->offloom->CurrentValue;
            $this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, $this->offloom->formatPattern());
            $this->offloom->HrefValue = ""; // Clear href value
            $this->pending_offloom->CurrentValue = $this->pending_offloom->Total;
            $this->pending_offloom->ViewValue = $this->pending_offloom->CurrentValue;
            $this->pending_offloom->ViewValue = FormatNumber($this->pending_offloom->ViewValue, $this->pending_offloom->formatPattern());
            $this->pending_offloom->HrefValue = ""; // Clear href value
            $this->pending_offloom_sqm->CurrentValue = $this->pending_offloom_sqm->Total;
            $this->pending_offloom_sqm->ViewValue = $this->pending_offloom_sqm->CurrentValue;
            $this->pending_offloom_sqm->ViewValue = FormatNumber($this->pending_offloom_sqm->ViewValue, $this->pending_offloom_sqm->formatPattern());
            $this->pending_offloom_sqm->HrefValue = ""; // Clear href value
            $this->rejection->CurrentValue = $this->rejection->Total;
            $this->rejection->ViewValue = $this->rejection->CurrentValue;
            $this->rejection->ViewValue = FormatNumber($this->rejection->ViewValue, $this->rejection->formatPattern());
            $this->rejection->HrefValue = ""; // Clear href value
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckNumber($this->pending->AdvancedSearch->SearchValue)) {
            $this->pending->addErrorMessage($this->pending->getErrorMessage(false));
        }
        if (!CheckNumber($this->pending->AdvancedSearch->SearchValue2)) {
            $this->pending->addErrorMessage($this->pending->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->buyers_id->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
        $this->buyer_order->AdvancedSearch->load();
        $this->item->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->order_week->AdvancedSearch->load();
        $this->order_date->AdvancedSearch->load();
        $this->ex_factory->AdvancedSearch->load();
        $this->ex_factory_p->AdvancedSearch->load();
        $this->shipping_mode->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->cs->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->design->AdvancedSearch->load();
        $this->size_buyer->AdvancedSearch->load();
        $this->width->AdvancedSearch->load();
        $this->length->AdvancedSearch->load();
        $this->qty->AdvancedSearch->load();
        $this->revised_qty->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->d_qty->AdvancedSearch->load();
        $this->pending->AdvancedSearch->load();
        $this->pending_sqm->AdvancedSearch->load();
        $this->offloom->AdvancedSearch->load();
        $this->pending_offloom->AdvancedSearch->load();
        $this->pending_offloom_sqm->AdvancedSearch->load();
        $this->cbm->AdvancedSearch->load();
        $this->total_cbm->AdvancedSearch->load();
        $this->weaving_works->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->pl_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->sailing_week->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->completed->AdvancedSearch->load();
        $this->label->AdvancedSearch->load();
        $this->weight_sqm->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"foms_table_2list\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"foms_table_2list\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"foms_table_2list\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="foms_table_2list" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"foms_table_2srch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"oms_table_2\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"omstable2search\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"omstable2search\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"foms_table_2srch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_buyers_id":
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_order_week":
                    break;
                case "x_ex_factory":
                    break;
                case "x_ex_factory_p":
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_cs":
                    break;
                case "x_weaving_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_completed":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad() {
    	//echo "Page Load";
    	IF (isset($_GET['CID']))
    	{
    	ExecuteStatement("TRUNCATE TABLE `oms_table_2`");
    	ExecuteStatement("INSERT INTO `oms_table_2` (`id`, `buyers_id`, `reports_to`, `order_week`, `order_date`, `category`, `weaving_works`, `current_works`, `buyer_order`, `po`, `item`, `buyer_ref`, `design`, `size_buyer`, `width`, `length`, `qty`, `revised_qty`, `sqm`, `weight_sqm`, `ex_factory`, `ex_factory_p`, `shipping_mode`, `remarks`, `d_qty`, `pl_no`, `invoice_date`, `sailing_week`, `pending`, `pending_sqm`, `cbm`, `total_cbm`, `offloom`, `status`, `rejection`, `completed`, `cs`) SELECT `id`, `buyers_id`, `reports_to`, `order_week`, `order_date`, `category`, `weaving_works`, `current_works`, `buyer_order`, `po`, `item`, `buyer_ref`, `design`, `size_buyer`, `width`, `length`, `qty`, `revised_qty`, `sqm`, `weight_sqm`, `ex_factory`, `ex_factory_p`, `shipping_mode`, `remarks`, `d_qty`, `pl_no`, `invoice_date`, `sailing_week`, `pending`, `pending_sqm`, `cbm`, `total_cbm`, `offloom`, `status`, `rejection`, `completed`, `cs` FROM `query_oms_2`");
    header("location: omstable2list");	
    	}	
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	$item = &$this->OtherOptions['action']->Add("Re-fresh");
    	$item->Body = '<a href="omstable2list?CID=7fa7" data-bs-original-title ="Re-fresh"><i data-phrase="Re-fresh"  class="fa fa-refresh fa-2x ew-icon" style="color:red" ></i></a>';
    	$item->Visible = True;	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
