<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MultiplePriceSearch extends MultiplePrice
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MultiplePriceSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "multiplepricesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->company_id->setVisibility();
        $this->buyer->setVisibility();
        $this->buyer_1->setVisibility();
        $this->buyer_id->setVisibility();
        $this->grp->setVisibility();
        $this->product->setVisibility();
        $this->code->setVisibility();
        $this->packing_type->setVisibility();
        $this->level->setVisibility();
        $this->min_qty->setVisibility();
        $this->max_qty->setVisibility();
        $this->increment->setVisibility();
        $this->price_min_qty->setVisibility();
        $this->currency->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->s_grp->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'multiple_price';
        $this->TableName = 'multiple_price';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (multiple_price)
        if (!isset($GLOBALS["multiple_price"]) || $GLOBALS["multiple_price"]::class == PROJECT_NAMESPACE . "multiple_price") {
            $GLOBALS["multiple_price"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'multiple_price');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "multiplepriceview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->buyer);
        $this->setupLookupOptions($this->buyer_1);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->code);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->level);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->s_grp);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "multiplepricelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        $this->buildSearchUrl($srchUrl, $this->buyer); // buyer
        $this->buildSearchUrl($srchUrl, $this->buyer_1); // buyer_1
        $this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->product); // product
        $this->buildSearchUrl($srchUrl, $this->code); // code
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        $this->buildSearchUrl($srchUrl, $this->level); // level
        $this->buildSearchUrl($srchUrl, $this->min_qty); // min_qty
        $this->buildSearchUrl($srchUrl, $this->max_qty); // max_qty
        $this->buildSearchUrl($srchUrl, $this->increment); // increment
        $this->buildSearchUrl($srchUrl, $this->price_min_qty); // price_min_qty
        $this->buildSearchUrl($srchUrl, $this->currency); // currency
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer
        if ($this->buyer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_1
        if ($this->buyer_1->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->buyer_1->AdvancedSearch->SearchValue)) {
            $this->buyer_1->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->buyer_1->AdvancedSearch->SearchValue);
        }
        if (is_array($this->buyer_1->AdvancedSearch->SearchValue2)) {
            $this->buyer_1->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->buyer_1->AdvancedSearch->SearchValue2);
        }

        // buyer_id
        if ($this->buyer_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // code
        if ($this->code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // level
        if ($this->level->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // min_qty
        if ($this->min_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // max_qty
        if ($this->max_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // increment
        if ($this->increment->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // price_min_qty
        if ($this->price_min_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // currency
        if ($this->currency->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // buyer
        $this->buyer->RowCssClass = "row";

        // buyer_1
        $this->buyer_1->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // level
        $this->level->RowCssClass = "row";

        // min_qty
        $this->min_qty->RowCssClass = "row";

        // max_qty
        $this->max_qty->RowCssClass = "row";

        // increment
        $this->increment->RowCssClass = "row";

        // price_min_qty
        $this->price_min_qty->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // buyer
            if (strval($this->buyer->CurrentValue) != "") {
                $this->buyer->ViewValue = $this->buyer->optionCaption($this->buyer->CurrentValue);
            } else {
                $this->buyer->ViewValue = null;
            }

            // buyer_1
            $curVal = strval($this->buyer_1->CurrentValue);
            if ($curVal != "") {
                $this->buyer_1->ViewValue = $this->buyer_1->lookupCacheOption($curVal);
                if ($this->buyer_1->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->buyer_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->buyer_1->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->buyer_1->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->buyer_1->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->buyer_1->Lookup->renderViewRow($row);
                            $this->buyer_1->ViewValue->add($this->buyer_1->displayValue($arwrk));
                        }
                    } else {
                        $this->buyer_1->ViewValue = $this->buyer_1->CurrentValue;
                    }
                }
            } else {
                $this->buyer_1->ViewValue = null;
            }

            // buyer_id
            $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // code
            $curVal = strval($this->code->CurrentValue);
            if ($curVal != "") {
                $this->code->ViewValue = $this->code->lookupCacheOption($curVal);
                if ($this->code->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->code->getSelectFilter($this); // PHP
                    $sqlWrk = $this->code->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->code->Lookup->renderViewRow($rswrk[0]);
                        $this->code->ViewValue = $this->code->displayValue($arwrk);
                    } else {
                        $this->code->ViewValue = $this->code->CurrentValue;
                    }
                }
            } else {
                $this->code->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // level
            if (strval($this->level->CurrentValue) != "") {
                $this->level->ViewValue = $this->level->optionCaption($this->level->CurrentValue);
            } else {
                $this->level->ViewValue = null;
            }

            // min_qty
            $this->min_qty->ViewValue = $this->min_qty->CurrentValue;
            $this->min_qty->ViewValue = FormatNumber($this->min_qty->ViewValue, $this->min_qty->formatPattern());

            // max_qty
            $this->max_qty->ViewValue = $this->max_qty->CurrentValue;
            $this->max_qty->ViewValue = FormatNumber($this->max_qty->ViewValue, $this->max_qty->formatPattern());

            // increment
            $this->increment->ViewValue = $this->increment->CurrentValue;
            $this->increment->ViewValue = FormatNumber($this->increment->ViewValue, $this->increment->formatPattern());

            // price_min_qty
            $this->price_min_qty->ViewValue = $this->price_min_qty->CurrentValue;
            $this->price_min_qty->ViewValue = FormatNumber($this->price_min_qty->ViewValue, $this->price_min_qty->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // buyer
            $this->buyer->HrefValue = "";
            $this->buyer->TooltipValue = "";

            // buyer_1
            $this->buyer_1->HrefValue = "";
            $this->buyer_1->TooltipValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";
            $this->buyer_id->TooltipValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // code
            if (!EmptyValue($this->code->CurrentValue)) {
                $this->code->HrefValue = $this->code->getLinkPrefix() . $this->code->CurrentValue; // Add prefix/suffix
                $this->code->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
                }
            } else {
                $this->code->HrefValue = "";
            }
            $this->code->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // level
            if (!EmptyValue($this->level->CurrentValue)) {
                $this->level->HrefValue = $this->level->getLinkPrefix() . $this->level->CurrentValue; // Add prefix/suffix
                $this->level->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->level->HrefValue = FullUrl($this->level->HrefValue, "href");
                }
            } else {
                $this->level->HrefValue = "";
            }
            $this->level->TooltipValue = "";

            // min_qty
            $this->min_qty->HrefValue = "";
            $this->min_qty->TooltipValue = "";

            // max_qty
            $this->max_qty->HrefValue = "";
            $this->max_qty->TooltipValue = "";

            // increment
            $this->increment->HrefValue = "";
            $this->increment->TooltipValue = "";

            // price_min_qty
            $this->price_min_qty->HrefValue = "";
            $this->price_min_qty->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // operator
            if (!EmptyValue($this->operator->CurrentValue)) {
                $this->operator->HrefValue = $this->operator->getLinkPrefix() . $this->operator->CurrentValue; // Add prefix/suffix
                $this->operator->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
                }
            } else {
                $this->operator->HrefValue = "";
            }
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->AdvancedSearch->SearchValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // buyer
            $this->buyer->setupEditAttributes();
            $this->buyer->EditValue = $this->buyer->options(true);
            $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

            // buyer_1
            $curVal = trim(strval($this->buyer_1->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyer_1->AdvancedSearch->ViewValue = $this->buyer_1->lookupCacheOption($curVal);
            } else {
                $this->buyer_1->AdvancedSearch->ViewValue = $this->buyer_1->Lookup !== null && is_array($this->buyer_1->lookupOptions()) && count($this->buyer_1->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_1->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyer_1->EditValue = array_values($this->buyer_1->lookupOptions());
                if ($this->buyer_1->AdvancedSearch->ViewValue == "") {
                    $this->buyer_1->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->buyer_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->buyer_1->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->buyer_1->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_1->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->buyer_1->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->buyer_1->Lookup->renderViewRow($row);
                        $this->buyer_1->AdvancedSearch->ViewValue->add($this->buyer_1->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->buyer_1->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->buyer_1->EditValue = $arwrk;
            }
            $this->buyer_1->PlaceHolder = RemoveHtml($this->buyer_1->caption());

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $this->buyer_id->EditCustomAttributes = $this->buyer_id->getEditCustomAttributes(); // PHP
            if (!$this->buyer_id->Raw) {
                $this->buyer_id->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_id->AdvancedSearch->SearchValue);
            }
            $this->buyer_id->EditValue = HtmlEncode($this->buyer_id->AdvancedSearch->SearchValue);
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // code
            $curVal = trim(strval($this->code->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->code->AdvancedSearch->ViewValue = $this->code->lookupCacheOption($curVal);
            } else {
                $this->code->AdvancedSearch->ViewValue = $this->code->Lookup !== null && is_array($this->code->lookupOptions()) && count($this->code->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->code->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->code->EditValue = array_values($this->code->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->code->AdvancedSearch->SearchValue, $this->code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->code->getSelectFilter($this); // PHP
                $sqlWrk = $this->code->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->code->EditValue = $arwrk;
            }
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->AdvancedSearch->SearchValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // level
            $this->level->setupEditAttributes();
            $this->level->EditValue = $this->level->options(true);
            $this->level->PlaceHolder = RemoveHtml($this->level->caption());

            // min_qty
            $this->min_qty->setupEditAttributes();
            $this->min_qty->EditValue = $this->min_qty->AdvancedSearch->SearchValue;
            $this->min_qty->PlaceHolder = RemoveHtml($this->min_qty->caption());

            // max_qty
            $this->max_qty->setupEditAttributes();
            $this->max_qty->EditValue = $this->max_qty->AdvancedSearch->SearchValue;
            $this->max_qty->PlaceHolder = RemoveHtml($this->max_qty->caption());

            // increment
            $this->increment->setupEditAttributes();
            $this->increment->EditValue = $this->increment->AdvancedSearch->SearchValue;
            $this->increment->PlaceHolder = RemoveHtml($this->increment->caption());

            // price_min_qty
            $this->price_min_qty->setupEditAttributes();
            $this->price_min_qty->EditValue = $this->price_min_qty->AdvancedSearch->SearchValue;
            $this->price_min_qty->PlaceHolder = RemoveHtml($this->price_min_qty->caption());

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->currency->AdvancedSearch->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->AdvancedSearch->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->AdvancedSearch->SearchValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $curVal = strval($this->operator->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->operator->EditValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->EditValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->EditValue = HtmlEncode(FormatNumber($this->operator->AdvancedSearch->SearchValue, $this->operator->formatPattern()));
                    }
                }
            } else {
                $this->operator->EditValue = null;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->min_qty->AdvancedSearch->SearchValue)) {
            $this->min_qty->addErrorMessage($this->min_qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->max_qty->AdvancedSearch->SearchValue)) {
            $this->max_qty->addErrorMessage($this->max_qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->increment->AdvancedSearch->SearchValue)) {
            $this->increment->addErrorMessage($this->increment->getErrorMessage(false));
        }
        if (!CheckNumber($this->price_min_qty->AdvancedSearch->SearchValue)) {
            $this->price_min_qty->addErrorMessage($this->price_min_qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->buyer->AdvancedSearch->load();
        $this->buyer_1->AdvancedSearch->load();
        $this->buyer_id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->level->AdvancedSearch->load();
        $this->min_qty->AdvancedSearch->load();
        $this->max_qty->AdvancedSearch->load();
        $this->increment->AdvancedSearch->load();
        $this->price_min_qty->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("multiplepricelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer":
                    break;
                case "x_buyer_1":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_code":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_level":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
