<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MultiplePriceEdit extends MultiplePrice
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MultiplePriceEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "multiplepriceedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->company_id->setVisibility();
        $this->buyer->setVisibility();
        $this->buyer_1->setVisibility();
        $this->buyer_id->setVisibility();
        $this->grp->setVisibility();
        $this->product->setVisibility();
        $this->code->setVisibility();
        $this->packing_type->setVisibility();
        $this->level->setVisibility();
        $this->min_qty->setVisibility();
        $this->max_qty->setVisibility();
        $this->increment->setVisibility();
        $this->price_min_qty->setVisibility();
        $this->currency->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->s_grp->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'multiple_price';
        $this->TableName = 'multiple_price';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (multiple_price)
        if (!isset($GLOBALS["multiple_price"]) || $GLOBALS["multiple_price"]::class == PROJECT_NAMESPACE . "multiple_price") {
            $GLOBALS["multiple_price"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'multiple_price');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "multiplepriceview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->buyer);
        $this->setupLookupOptions($this->buyer_1);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->code);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->level);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->s_grp);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Set up master detail parameters
            $this->setupMasterParms();

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("multiplepricelist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "multiplepricelist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "multiplepricelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "multiplepricelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'buyer' first before field var 'x_buyer'
        $val = $CurrentForm->hasValue("buyer") ? $CurrentForm->getValue("buyer") : $CurrentForm->getValue("x_buyer");
        if (!$this->buyer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer->Visible = false; // Disable update for API request
            } else {
                $this->buyer->setFormValue($val);
            }
        }

        // Check field name 'buyer_1' first before field var 'x_buyer_1'
        $val = $CurrentForm->hasValue("buyer_1") ? $CurrentForm->getValue("buyer_1") : $CurrentForm->getValue("x_buyer_1");
        if (!$this->buyer_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_1->Visible = false; // Disable update for API request
            } else {
                $this->buyer_1->setFormValue($val);
            }
        }

        // Check field name 'buyer_id' first before field var 'x_buyer_id'
        $val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
        if (!$this->buyer_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_id->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->code->Visible = false; // Disable update for API request
            } else {
                $this->code->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'level' first before field var 'x_level'
        $val = $CurrentForm->hasValue("level") ? $CurrentForm->getValue("level") : $CurrentForm->getValue("x_level");
        if (!$this->level->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->level->Visible = false; // Disable update for API request
            } else {
                $this->level->setFormValue($val);
            }
        }

        // Check field name 'min_qty' first before field var 'x_min_qty'
        $val = $CurrentForm->hasValue("min_qty") ? $CurrentForm->getValue("min_qty") : $CurrentForm->getValue("x_min_qty");
        if (!$this->min_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->min_qty->Visible = false; // Disable update for API request
            } else {
                $this->min_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'max_qty' first before field var 'x_max_qty'
        $val = $CurrentForm->hasValue("max_qty") ? $CurrentForm->getValue("max_qty") : $CurrentForm->getValue("x_max_qty");
        if (!$this->max_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->max_qty->Visible = false; // Disable update for API request
            } else {
                $this->max_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'increment' first before field var 'x_increment'
        $val = $CurrentForm->hasValue("increment") ? $CurrentForm->getValue("increment") : $CurrentForm->getValue("x_increment");
        if (!$this->increment->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->increment->Visible = false; // Disable update for API request
            } else {
                $this->increment->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'price_min_qty' first before field var 'x_price_min_qty'
        $val = $CurrentForm->hasValue("price_min_qty") ? $CurrentForm->getValue("price_min_qty") : $CurrentForm->getValue("x_price_min_qty");
        if (!$this->price_min_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price_min_qty->Visible = false; // Disable update for API request
            } else {
                $this->price_min_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->buyer->CurrentValue = $this->buyer->FormValue;
        $this->buyer_1->CurrentValue = $this->buyer_1->FormValue;
        $this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->code->CurrentValue = $this->code->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->level->CurrentValue = $this->level->FormValue;
        $this->min_qty->CurrentValue = $this->min_qty->FormValue;
        $this->max_qty->CurrentValue = $this->max_qty->FormValue;
        $this->increment->CurrentValue = $this->increment->FormValue;
        $this->price_min_qty->CurrentValue = $this->price_min_qty->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->company_id->setDbValue($row['company_id']);
        $this->buyer->setDbValue($row['buyer']);
        $this->buyer_1->setDbValue($row['buyer_1']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->grp->setDbValue($row['grp']);
        $this->product->setDbValue($row['product']);
        $this->code->setDbValue($row['code']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->level->setDbValue($row['level']);
        $this->min_qty->setDbValue($row['min_qty']);
        $this->max_qty->setDbValue($row['max_qty']);
        $this->increment->setDbValue($row['increment']);
        $this->price_min_qty->setDbValue($row['price_min_qty']);
        $this->currency->setDbValue($row['currency']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->s_grp->setDbValue($row['s_grp']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['buyer'] = $this->buyer->DefaultValue;
        $row['buyer_1'] = $this->buyer_1->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['level'] = $this->level->DefaultValue;
        $row['min_qty'] = $this->min_qty->DefaultValue;
        $row['max_qty'] = $this->max_qty->DefaultValue;
        $row['increment'] = $this->increment->DefaultValue;
        $row['price_min_qty'] = $this->price_min_qty->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // buyer
        $this->buyer->RowCssClass = "row";

        // buyer_1
        $this->buyer_1->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // level
        $this->level->RowCssClass = "row";

        // min_qty
        $this->min_qty->RowCssClass = "row";

        // max_qty
        $this->max_qty->RowCssClass = "row";

        // increment
        $this->increment->RowCssClass = "row";

        // price_min_qty
        $this->price_min_qty->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // buyer
            if (strval($this->buyer->CurrentValue) != "") {
                $this->buyer->ViewValue = $this->buyer->optionCaption($this->buyer->CurrentValue);
            } else {
                $this->buyer->ViewValue = null;
            }

            // buyer_1
            $curVal = strval($this->buyer_1->CurrentValue);
            if ($curVal != "") {
                $this->buyer_1->ViewValue = $this->buyer_1->lookupCacheOption($curVal);
                if ($this->buyer_1->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->buyer_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->buyer_1->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->buyer_1->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_1->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->buyer_1->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->buyer_1->Lookup->renderViewRow($row);
                            $this->buyer_1->ViewValue->add($this->buyer_1->displayValue($arwrk));
                        }
                    } else {
                        $this->buyer_1->ViewValue = $this->buyer_1->CurrentValue;
                    }
                }
            } else {
                $this->buyer_1->ViewValue = null;
            }

            // buyer_id
            $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // code
            $curVal = strval($this->code->CurrentValue);
            if ($curVal != "") {
                $this->code->ViewValue = $this->code->lookupCacheOption($curVal);
                if ($this->code->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->code->getSelectFilter($this); // PHP
                    $sqlWrk = $this->code->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->code->Lookup->renderViewRow($rswrk[0]);
                        $this->code->ViewValue = $this->code->displayValue($arwrk);
                    } else {
                        $this->code->ViewValue = $this->code->CurrentValue;
                    }
                }
            } else {
                $this->code->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // level
            if (strval($this->level->CurrentValue) != "") {
                $this->level->ViewValue = $this->level->optionCaption($this->level->CurrentValue);
            } else {
                $this->level->ViewValue = null;
            }

            // min_qty
            $this->min_qty->ViewValue = $this->min_qty->CurrentValue;
            $this->min_qty->ViewValue = FormatNumber($this->min_qty->ViewValue, $this->min_qty->formatPattern());

            // max_qty
            $this->max_qty->ViewValue = $this->max_qty->CurrentValue;
            $this->max_qty->ViewValue = FormatNumber($this->max_qty->ViewValue, $this->max_qty->formatPattern());

            // increment
            $this->increment->ViewValue = $this->increment->CurrentValue;
            $this->increment->ViewValue = FormatNumber($this->increment->ViewValue, $this->increment->formatPattern());

            // price_min_qty
            $this->price_min_qty->ViewValue = $this->price_min_qty->CurrentValue;
            $this->price_min_qty->ViewValue = FormatNumber($this->price_min_qty->ViewValue, $this->price_min_qty->formatPattern());

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // buyer
            $this->buyer->HrefValue = "";

            // buyer_1
            $this->buyer_1->HrefValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // code
            if (!EmptyValue($this->code->CurrentValue)) {
                $this->code->HrefValue = $this->code->getLinkPrefix() . $this->code->CurrentValue; // Add prefix/suffix
                $this->code->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
                }
            } else {
                $this->code->HrefValue = "";
            }

            // packing_type
            $this->packing_type->HrefValue = "";

            // level
            if (!EmptyValue($this->level->CurrentValue)) {
                $this->level->HrefValue = $this->level->getLinkPrefix() . $this->level->CurrentValue; // Add prefix/suffix
                $this->level->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->level->HrefValue = FullUrl($this->level->HrefValue, "href");
                }
            } else {
                $this->level->HrefValue = "";
            }

            // min_qty
            $this->min_qty->HrefValue = "";

            // max_qty
            $this->max_qty->HrefValue = "";

            // increment
            $this->increment->HrefValue = "";

            // price_min_qty
            $this->price_min_qty->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // operator
            if (!EmptyValue($this->operator->CurrentValue)) {
                $this->operator->HrefValue = $this->operator->getLinkPrefix() . $this->operator->CurrentValue; // Add prefix/suffix
                $this->operator->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
                }
            } else {
                $this->operator->HrefValue = "";
            }

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // buyer
            $this->buyer->setupEditAttributes();
            $this->buyer->EditValue = $this->buyer->options(true);
            $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

            // buyer_1
            $curVal = trim(strval($this->buyer_1->CurrentValue));
            if ($curVal != "") {
                $this->buyer_1->ViewValue = $this->buyer_1->lookupCacheOption($curVal);
            } else {
                $this->buyer_1->ViewValue = $this->buyer_1->Lookup !== null && is_array($this->buyer_1->lookupOptions()) && count($this->buyer_1->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_1->ViewValue !== null) { // Load from cache
                $this->buyer_1->EditValue = array_values($this->buyer_1->lookupOptions());
                if ($this->buyer_1->ViewValue == "") {
                    $this->buyer_1->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->buyer_1->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->buyer_1->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->buyer_1->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_1->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->buyer_1->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->buyer_1->Lookup->renderViewRow($row);
                        $this->buyer_1->ViewValue->add($this->buyer_1->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->buyer_1->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->buyer_1->EditValue = $arwrk;
            }
            $this->buyer_1->PlaceHolder = RemoveHtml($this->buyer_1->caption());

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $this->buyer_id->EditCustomAttributes = $this->buyer_id->getEditCustomAttributes(); // PHP
            if (!$this->buyer_id->Raw) {
                $this->buyer_id->CurrentValue = HtmlDecode($this->buyer_id->CurrentValue);
            }
            $this->buyer_id->EditValue = HtmlEncode($this->buyer_id->CurrentValue);
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // code
            if ($this->code->getSessionValue() != "") {
                $this->code->CurrentValue = GetForeignKeyValue($this->code->getSessionValue());
                $curVal = strval($this->code->CurrentValue);
                if ($curVal != "") {
                    $this->code->ViewValue = $this->code->lookupCacheOption($curVal);
                    if ($this->code->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $lookupFilter = $this->code->getSelectFilter($this); // PHP
                        $sqlWrk = $this->code->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->code->Lookup->renderViewRow($rswrk[0]);
                            $this->code->ViewValue = $this->code->displayValue($arwrk);
                        } else {
                            $this->code->ViewValue = $this->code->CurrentValue;
                        }
                    }
                } else {
                    $this->code->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->code->CurrentValue));
                if ($curVal != "") {
                    $this->code->ViewValue = $this->code->lookupCacheOption($curVal);
                } else {
                    $this->code->ViewValue = $this->code->Lookup !== null && is_array($this->code->lookupOptions()) && count($this->code->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->code->ViewValue !== null) { // Load from cache
                    $this->code->EditValue = array_values($this->code->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->code->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->code->CurrentValue, $this->code->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->code->getSelectFilter($this); // PHP
                    $sqlWrk = $this->code->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->code->EditValue = $arwrk;
                }
                $this->code->PlaceHolder = RemoveHtml($this->code->caption());
            }

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // level
            $this->level->setupEditAttributes();
            $this->level->EditValue = $this->level->options(true);
            $this->level->PlaceHolder = RemoveHtml($this->level->caption());

            // min_qty
            $this->min_qty->setupEditAttributes();
            $this->min_qty->EditValue = $this->min_qty->CurrentValue;
            $this->min_qty->PlaceHolder = RemoveHtml($this->min_qty->caption());
            if (strval($this->min_qty->EditValue) != "" && is_numeric($this->min_qty->EditValue)) {
                $this->min_qty->EditValue = FormatNumber($this->min_qty->EditValue, null);
            }

            // max_qty
            $this->max_qty->setupEditAttributes();
            $this->max_qty->EditValue = $this->max_qty->CurrentValue;
            $this->max_qty->PlaceHolder = RemoveHtml($this->max_qty->caption());
            if (strval($this->max_qty->EditValue) != "" && is_numeric($this->max_qty->EditValue)) {
                $this->max_qty->EditValue = FormatNumber($this->max_qty->EditValue, null);
            }

            // increment
            $this->increment->setupEditAttributes();
            $this->increment->EditValue = $this->increment->CurrentValue;
            $this->increment->PlaceHolder = RemoveHtml($this->increment->caption());
            if (strval($this->increment->EditValue) != "" && is_numeric($this->increment->EditValue)) {
                $this->increment->EditValue = FormatNumber($this->increment->EditValue, null);
            }

            // price_min_qty
            $this->price_min_qty->setupEditAttributes();
            $this->price_min_qty->EditValue = $this->price_min_qty->CurrentValue;
            $this->price_min_qty->PlaceHolder = RemoveHtml($this->price_min_qty->caption());
            if (strval($this->price_min_qty->EditValue) != "" && is_numeric($this->price_min_qty->EditValue)) {
                $this->price_min_qty->EditValue = FormatNumber($this->price_min_qty->EditValue, null);
            }

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // buyer
            $this->buyer->HrefValue = "";

            // buyer_1
            $this->buyer_1->HrefValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // code
            if (!EmptyValue($this->code->CurrentValue)) {
                $this->code->HrefValue = $this->code->getLinkPrefix() . $this->code->CurrentValue; // Add prefix/suffix
                $this->code->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
                }
            } else {
                $this->code->HrefValue = "";
            }

            // packing_type
            $this->packing_type->HrefValue = "";

            // level
            if (!EmptyValue($this->level->CurrentValue)) {
                $this->level->HrefValue = $this->level->getLinkPrefix() . $this->level->CurrentValue; // Add prefix/suffix
                $this->level->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->level->HrefValue = FullUrl($this->level->HrefValue, "href");
                }
            } else {
                $this->level->HrefValue = "";
            }

            // min_qty
            $this->min_qty->HrefValue = "";

            // max_qty
            $this->max_qty->HrefValue = "";

            // increment
            $this->increment->HrefValue = "";

            // price_min_qty
            $this->price_min_qty->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // operator
            if (!EmptyValue($this->operator->CurrentValue)) {
                $this->operator->HrefValue = $this->operator->getLinkPrefix() . $this->operator->CurrentValue; // Add prefix/suffix
                $this->operator->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
                }
            } else {
                $this->operator->HrefValue = "";
            }

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->buyer->Visible && $this->buyer->Required) {
                if (!$this->buyer->IsDetailKey && EmptyValue($this->buyer->FormValue)) {
                    $this->buyer->addErrorMessage(str_replace("%s", $this->buyer->caption(), $this->buyer->RequiredErrorMessage));
                }
            }
            if ($this->buyer_1->Visible && $this->buyer_1->Required) {
                if ($this->buyer_1->FormValue == "") {
                    $this->buyer_1->addErrorMessage(str_replace("%s", $this->buyer_1->caption(), $this->buyer_1->RequiredErrorMessage));
                }
            }
            if ($this->buyer_id->Visible && $this->buyer_id->Required) {
                if (!$this->buyer_id->IsDetailKey && EmptyValue($this->buyer_id->FormValue)) {
                    $this->buyer_id->addErrorMessage(str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->code->Visible && $this->code->Required) {
                if ($this->code->FormValue == "") {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->level->Visible && $this->level->Required) {
                if (!$this->level->IsDetailKey && EmptyValue($this->level->FormValue)) {
                    $this->level->addErrorMessage(str_replace("%s", $this->level->caption(), $this->level->RequiredErrorMessage));
                }
            }
            if ($this->min_qty->Visible && $this->min_qty->Required) {
                if (!$this->min_qty->IsDetailKey && EmptyValue($this->min_qty->FormValue)) {
                    $this->min_qty->addErrorMessage(str_replace("%s", $this->min_qty->caption(), $this->min_qty->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->min_qty->FormValue)) {
                $this->min_qty->addErrorMessage($this->min_qty->getErrorMessage(false));
            }
            if ($this->max_qty->Visible && $this->max_qty->Required) {
                if (!$this->max_qty->IsDetailKey && EmptyValue($this->max_qty->FormValue)) {
                    $this->max_qty->addErrorMessage(str_replace("%s", $this->max_qty->caption(), $this->max_qty->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->max_qty->FormValue)) {
                $this->max_qty->addErrorMessage($this->max_qty->getErrorMessage(false));
            }
            if ($this->increment->Visible && $this->increment->Required) {
                if (!$this->increment->IsDetailKey && EmptyValue($this->increment->FormValue)) {
                    $this->increment->addErrorMessage(str_replace("%s", $this->increment->caption(), $this->increment->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->increment->FormValue)) {
                $this->increment->addErrorMessage($this->increment->getErrorMessage(false));
            }
            if ($this->price_min_qty->Visible && $this->price_min_qty->Required) {
                if (!$this->price_min_qty->IsDetailKey && EmptyValue($this->price_min_qty->FormValue)) {
                    $this->price_min_qty->addErrorMessage(str_replace("%s", $this->price_min_qty->caption(), $this->price_min_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->price_min_qty->FormValue)) {
                $this->price_min_qty->addErrorMessage($this->price_min_qty->getErrorMessage(false));
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, $this->company_id->ReadOnly);

        // buyer
        $this->buyer->setDbValueDef($rsnew, $this->buyer->CurrentValue, $this->buyer->ReadOnly);

        // buyer_1
        $this->buyer_1->setDbValueDef($rsnew, $this->buyer_1->CurrentValue, $this->buyer_1->ReadOnly);

        // buyer_id
        $this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, $this->buyer_id->ReadOnly);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, $this->product->ReadOnly);

        // code
        if ($this->code->getSessionValue() != "") {
            $this->code->ReadOnly = true;
        }
        $this->code->setDbValueDef($rsnew, $this->code->CurrentValue, $this->code->ReadOnly);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, $this->packing_type->ReadOnly);

        // level
        $this->level->setDbValueDef($rsnew, $this->level->CurrentValue, $this->level->ReadOnly);

        // min_qty
        $this->min_qty->setDbValueDef($rsnew, $this->min_qty->CurrentValue, $this->min_qty->ReadOnly);

        // max_qty
        $this->max_qty->setDbValueDef($rsnew, $this->max_qty->CurrentValue, $this->max_qty->ReadOnly);

        // increment
        $this->increment->setDbValueDef($rsnew, $this->increment->CurrentValue, $this->increment->ReadOnly);

        // price_min_qty
        $this->price_min_qty->setDbValueDef($rsnew, $this->price_min_qty->CurrentValue, $this->price_min_qty->ReadOnly);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, $this->currency->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['company_id'])) { // company_id
            $this->company_id->CurrentValue = $row['company_id'];
        }
        if (isset($row['buyer'])) { // buyer
            $this->buyer->CurrentValue = $row['buyer'];
        }
        if (isset($row['buyer_1'])) { // buyer_1
            $this->buyer_1->CurrentValue = $row['buyer_1'];
        }
        if (isset($row['buyer_id'])) { // buyer_id
            $this->buyer_id->CurrentValue = $row['buyer_id'];
        }
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['product'])) { // product
            $this->product->CurrentValue = $row['product'];
        }
        if (isset($row['code'])) { // code
            $this->code->CurrentValue = $row['code'];
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->CurrentValue = $row['packing_type'];
        }
        if (isset($row['level'])) { // level
            $this->level->CurrentValue = $row['level'];
        }
        if (isset($row['min_qty'])) { // min_qty
            $this->min_qty->CurrentValue = $row['min_qty'];
        }
        if (isset($row['max_qty'])) { // max_qty
            $this->max_qty->CurrentValue = $row['max_qty'];
        }
        if (isset($row['increment'])) { // increment
            $this->increment->CurrentValue = $row['increment'];
        }
        if (isset($row['price_min_qty'])) { // price_min_qty
            $this->price_min_qty->CurrentValue = $row['price_min_qty'];
        }
        if (isset($row['currency'])) { // currency
            $this->currency->CurrentValue = $row['currency'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "ref") {
                $validMaster = true;
                $masterTbl = Container("ref");
                if (($parm = Get("fk_id", Get("code"))) !== null) {
                    $masterTbl->id->setQueryStringValue($parm);
                    $this->code->QueryStringValue = $masterTbl->id->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->code->setSessionValue($this->code->QueryStringValue);
                    $foreignKeys["code"] = $this->code->QueryStringValue;
                    if (!is_numeric($masterTbl->id->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
            if ($masterTblVar == "ref_code") {
                $validMaster = true;
                $masterTbl = Container("ref_code");
                if (($parm = Get("fk_id", Get("code"))) !== null) {
                    $masterTbl->id->setQueryStringValue($parm);
                    $this->code->QueryStringValue = $masterTbl->id->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->code->setSessionValue($this->code->QueryStringValue);
                    $foreignKeys["code"] = $this->code->QueryStringValue;
                    if (!is_numeric($masterTbl->id->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "ref") {
                $validMaster = true;
                $masterTbl = Container("ref");
                if (($parm = Post("fk_id", Post("code"))) !== null) {
                    $masterTbl->id->setFormValue($parm);
                    $this->code->FormValue = $masterTbl->id->FormValue;
                    $this->code->setSessionValue($this->code->FormValue);
                    $foreignKeys["code"] = $this->code->FormValue;
                    if (!is_numeric($masterTbl->id->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
            if ($masterTblVar == "ref_code") {
                $validMaster = true;
                $masterTbl = Container("ref_code");
                if (($parm = Post("fk_id", Post("code"))) !== null) {
                    $masterTbl->id->setFormValue($parm);
                    $this->code->FormValue = $masterTbl->id->FormValue;
                    $this->code->setSessionValue($this->code->FormValue);
                    $foreignKeys["code"] = $this->code->FormValue;
                    if (!is_numeric($masterTbl->id->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);
            $this->setSessionWhere($this->getDetailFilterFromSession());

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "ref") {
                if (!array_key_exists("code", $foreignKeys)) { // Not current foreign key
                    $this->code->setSessionValue("");
                }
            }
            if ($masterTblVar != "ref_code") {
                if (!array_key_exists("code", $foreignKeys)) { // Not current foreign key
                    $this->code->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("multiplepricelist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer":
                    break;
                case "x_buyer_1":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_code":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_level":
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError) {
    	// Return error message in CustomError
    	extract($_POST,EXTR_OVERWRITE);
    	$buyer_arr = $x_buyer_id;
    	$buyer_n = (explode(',',$buyer_arr));
    	$Count = count($buyer_n);
    	$_SESSION[SESSION_WARNING_MESSAGE] = '';
    for ($i=0; $i<$Count; $i++) 
    { 
    $buyer = $buyer_arr[$i];
    $row = ExecuteRow("SELECT `id`, `buyer_id`, `code`, `min_qty`, `max_qty`, `level`  FROM `multiple_price` WHERE `id` != $x_id and `code` = $x_code and $x_min_qty between `min_qty` and `max_qty` and FIND_IN_SET($x_buyer, `buyer_id`) LIMIT 1");
    if (($row['id'])>0)
    {
    $_SESSION[SESSION_WARNING_MESSAGE] .= 'ID : ' . $row['id']. '# exist for Product Code Minimum Quantity<BR>' ;
    }
    $row = ExecuteRow("SELECT `id`, `buyer_id`, `code`, `min_qty`, `max_qty`, `level`  FROM `multiple_price` WHERE `id` != $x_id and `code` = $x_code and $x_max_qty between `min_qty` and `max_qty` and FIND_IN_SET($buyer, `buyer_id`)  LIMIT 1");
    if (($row['id'])>0)
    {
    $_SESSION[SESSION_WARNING_MESSAGE] .= 'ID : ' . $row['id']. '# exist for Product Code Maximum Quantity<BR>' ;
    }
    $row = ExecuteRow("SELECT `id`, `buyer_id`, `code`, `min_qty`, `max_qty`, `level`  FROM `multiple_price` WHERE `id` != $x_id and `code` = $x_code and $x_level = `level` and  FIND_IN_SET($buyer, `buyer_id`) LIMIT 1");
    if (($row['id'])>0)
    {
    $_SESSION[SESSION_WARNING_MESSAGE] .= 'ID : ' . $row['id']. '# level exist for Product Code<BR>';
    }
    }
    	if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    	{return TRUE;}
    	else
    	{return FALSE;}
    }
}
