<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MgsCertificateDataEdit extends MgsCertificateData
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MgsCertificateDataEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "mgscertificatedataedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->certificate_id->setVisibility();
        $this->name->setVisibility();
        $this->line_1->setVisibility();
        $this->line_2->setVisibility();
        $this->e_mail->setVisibility();
        $this->updated->setVisibility();
        $this->jpg->setVisibility();
        $this->pdf->setVisibility();
        $this->mail_status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'mgs_certificate_data';
        $this->TableName = 'mgs_certificate_data';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (mgs_certificate_data)
        if (!isset($GLOBALS["mgs_certificate_data"]) || $GLOBALS["mgs_certificate_data"]::class == PROJECT_NAMESPACE . "mgs_certificate_data") {
            $GLOBALS["mgs_certificate_data"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'mgs_certificate_data');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "mgscertificatedataview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->jpg->OldUploadPath = $this->jpg->getUploadPath(); // PHP
                $this->jpg->UploadPath = $this->jpg->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->jpg->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->certificate_id);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("mgscertificatedatalist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "mgscertificatedatalist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "mgscertificatedatalist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "mgscertificatedatalist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->jpg->Upload->Index = $CurrentForm->Index;
        $this->jpg->Upload->uploadFile();
        $this->jpg->CurrentValue = $this->jpg->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'certificate_id' first before field var 'x_certificate_id'
        $val = $CurrentForm->hasValue("certificate_id") ? $CurrentForm->getValue("certificate_id") : $CurrentForm->getValue("x_certificate_id");
        if (!$this->certificate_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->certificate_id->Visible = false; // Disable update for API request
            } else {
                $this->certificate_id->setFormValue($val);
            }
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'line_1' first before field var 'x_line_1'
        $val = $CurrentForm->hasValue("line_1") ? $CurrentForm->getValue("line_1") : $CurrentForm->getValue("x_line_1");
        if (!$this->line_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->line_1->Visible = false; // Disable update for API request
            } else {
                $this->line_1->setFormValue($val);
            }
        }

        // Check field name 'line_2' first before field var 'x_line_2'
        $val = $CurrentForm->hasValue("line_2") ? $CurrentForm->getValue("line_2") : $CurrentForm->getValue("x_line_2");
        if (!$this->line_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->line_2->Visible = false; // Disable update for API request
            } else {
                $this->line_2->setFormValue($val);
            }
        }

        // Check field name 'e_mail' first before field var 'x_e_mail'
        $val = $CurrentForm->hasValue("e_mail") ? $CurrentForm->getValue("e_mail") : $CurrentForm->getValue("x_e_mail");
        if (!$this->e_mail->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->e_mail->Visible = false; // Disable update for API request
            } else {
                $this->e_mail->setFormValue($val);
            }
        }

        // Check field name 'updated' first before field var 'x_updated'
        $val = $CurrentForm->hasValue("updated") ? $CurrentForm->getValue("updated") : $CurrentForm->getValue("x_updated");
        if (!$this->updated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->updated->Visible = false; // Disable update for API request
            } else {
                $this->updated->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pdf' first before field var 'x_pdf'
        $val = $CurrentForm->hasValue("pdf") ? $CurrentForm->getValue("pdf") : $CurrentForm->getValue("x_pdf");
        if (!$this->pdf->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pdf->Visible = false; // Disable update for API request
            } else {
                $this->pdf->setFormValue($val);
            }
        }

        // Check field name 'mail_status' first before field var 'x_mail_status'
        $val = $CurrentForm->hasValue("mail_status") ? $CurrentForm->getValue("mail_status") : $CurrentForm->getValue("x_mail_status");
        if (!$this->mail_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mail_status->Visible = false; // Disable update for API request
            } else {
                $this->mail_status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val, true, $validate);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
		$this->jpg->OldUploadPath = $this->jpg->getUploadPath(); // PHP
		$this->jpg->UploadPath = $this->jpg->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->certificate_id->CurrentValue = $this->certificate_id->FormValue;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->line_1->CurrentValue = $this->line_1->FormValue;
        $this->line_2->CurrentValue = $this->line_2->FormValue;
        $this->e_mail->CurrentValue = $this->e_mail->FormValue;
        $this->updated->CurrentValue = $this->updated->FormValue;
        $this->pdf->CurrentValue = $this->pdf->FormValue;
        $this->mail_status->CurrentValue = $this->mail_status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->certificate_id->setDbValue($row['certificate_id']);
        $this->name->setDbValue($row['name']);
        $this->line_1->setDbValue($row['line_1']);
        $this->line_2->setDbValue($row['line_2']);
        $this->e_mail->setDbValue($row['e_mail']);
        $this->updated->setDbValue($row['updated']);
        $this->jpg->Upload->DbValue = $row['jpg'];
        $this->jpg->setDbValue($this->jpg->Upload->DbValue);
        $this->pdf->setDbValue($row['pdf']);
        $this->mail_status->setDbValue($row['mail_status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['certificate_id'] = $this->certificate_id->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['line_1'] = $this->line_1->DefaultValue;
        $row['line_2'] = $this->line_2->DefaultValue;
        $row['e_mail'] = $this->e_mail->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['jpg'] = $this->jpg->DefaultValue;
        $row['pdf'] = $this->pdf->DefaultValue;
        $row['mail_status'] = $this->mail_status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // certificate_id
        $this->certificate_id->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // line_1
        $this->line_1->RowCssClass = "row";

        // line_2
        $this->line_2->RowCssClass = "row";

        // e_mail
        $this->e_mail->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // jpg
        $this->jpg->RowCssClass = "row";

        // pdf
        $this->pdf->RowCssClass = "row";

        // mail_status
        $this->mail_status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // certificate_id
            $curVal = strval($this->certificate_id->CurrentValue);
            if ($curVal != "") {
                $this->certificate_id->ViewValue = $this->certificate_id->lookupCacheOption($curVal);
                if ($this->certificate_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->certificate_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->certificate_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->certificate_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->certificate_id->Lookup->renderViewRow($rswrk[0]);
                        $this->certificate_id->ViewValue = $this->certificate_id->displayValue($arwrk);
                    } else {
                        $this->certificate_id->ViewValue = FormatNumber($this->certificate_id->CurrentValue, $this->certificate_id->formatPattern());
                    }
                }
            } else {
                $this->certificate_id->ViewValue = null;
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // line_1
            $this->line_1->ViewValue = $this->line_1->CurrentValue;

            // line_2
            $this->line_2->ViewValue = $this->line_2->CurrentValue;

            // e_mail
            $this->e_mail->ViewValue = $this->e_mail->CurrentValue;

            // updated
            $this->updated->ViewValue = $this->updated->CurrentValue;
            $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

            // jpg
            $this->jpg->UploadPath = $this->jpg->getUploadPath(); // PHP
            if (!EmptyValue($this->jpg->Upload->DbValue)) {
                $this->jpg->ImageWidth = 0;
                $this->jpg->ImageHeight = 50;
                $this->jpg->ImageAlt = $this->jpg->alt();
                $this->jpg->ImageCssClass = "ew-image";
                $this->jpg->ViewValue = $this->jpg->Upload->DbValue;
            } else {
                $this->jpg->ViewValue = "";
            }

            // pdf
            $this->pdf->ViewValue = $this->pdf->CurrentValue;

            // mail_status
            $this->mail_status->ViewValue = $this->mail_status->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // certificate_id
            $this->certificate_id->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // line_1
            $this->line_1->HrefValue = "";

            // line_2
            $this->line_2->HrefValue = "";

            // e_mail
            $this->e_mail->HrefValue = "";

            // updated
            $this->updated->HrefValue = "";

            // jpg
            $this->jpg->UploadPath = $this->jpg->getUploadPath(); // PHP
            if (!EmptyValue($this->jpg->Upload->DbValue)) {
                $this->jpg->HrefValue = GetFileUploadUrl($this->jpg, $this->jpg->htmlDecode($this->jpg->Upload->DbValue)); // Add prefix/suffix
                $this->jpg->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->jpg->HrefValue = FullUrl($this->jpg->HrefValue, "href");
                }
            } else {
                $this->jpg->HrefValue = "";
            }
            $this->jpg->ExportHrefValue = $this->jpg->UploadPath . $this->jpg->Upload->DbValue;
            $this->jpg->TooltipValue = "";

            // pdf
            if (!EmptyValue($this->pdf->CurrentValue)) {
                $this->pdf->HrefValue = $this->pdf->CurrentValue; // Add prefix/suffix
                $this->pdf->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->pdf->HrefValue = FullUrl($this->pdf->HrefValue, "href");
                }
            } else {
                $this->pdf->HrefValue = "";
            }

            // mail_status
            $this->mail_status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;
            $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

            // certificate_id
            $this->certificate_id->setupEditAttributes();
            $curVal = trim(strval($this->certificate_id->CurrentValue));
            if ($curVal != "") {
                $this->certificate_id->ViewValue = $this->certificate_id->lookupCacheOption($curVal);
            } else {
                $this->certificate_id->ViewValue = $this->certificate_id->Lookup !== null && is_array($this->certificate_id->lookupOptions()) && count($this->certificate_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->certificate_id->ViewValue !== null) { // Load from cache
                $this->certificate_id->EditValue = array_values($this->certificate_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->certificate_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->certificate_id->CurrentValue, $this->certificate_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->certificate_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->certificate_id->EditValue = $arwrk;
            }
            $this->certificate_id->PlaceHolder = RemoveHtml($this->certificate_id->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // line_1
            $this->line_1->setupEditAttributes();
            if (!$this->line_1->Raw) {
                $this->line_1->CurrentValue = HtmlDecode($this->line_1->CurrentValue);
            }
            $this->line_1->EditValue = HtmlEncode($this->line_1->CurrentValue);
            $this->line_1->PlaceHolder = RemoveHtml($this->line_1->caption());

            // line_2
            $this->line_2->setupEditAttributes();
            if (!$this->line_2->Raw) {
                $this->line_2->CurrentValue = HtmlDecode($this->line_2->CurrentValue);
            }
            $this->line_2->EditValue = HtmlEncode($this->line_2->CurrentValue);
            $this->line_2->PlaceHolder = RemoveHtml($this->line_2->caption());

            // e_mail
            $this->e_mail->setupEditAttributes();
            if (!$this->e_mail->Raw) {
                $this->e_mail->CurrentValue = HtmlDecode($this->e_mail->CurrentValue);
            }
            $this->e_mail->EditValue = HtmlEncode($this->e_mail->CurrentValue);
            $this->e_mail->PlaceHolder = RemoveHtml($this->e_mail->caption());

            // updated
            $this->updated->setupEditAttributes();
            $this->updated->EditValue = $this->updated->CurrentValue;
            $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
            if (strval($this->updated->EditValue) != "" && is_numeric($this->updated->EditValue)) {
                $this->updated->EditValue = FormatNumber($this->updated->EditValue, null);
            }

            // jpg
            $this->jpg->setupEditAttributes();
            $this->jpg->UploadPath = $this->jpg->getUploadPath(); // PHP
            if (!EmptyValue($this->jpg->Upload->DbValue)) {
                $this->jpg->ImageWidth = 0;
                $this->jpg->ImageHeight = 50;
                $this->jpg->ImageAlt = $this->jpg->alt();
                $this->jpg->ImageCssClass = "ew-image";
                $this->jpg->EditValue = $this->jpg->Upload->DbValue;
            } else {
                $this->jpg->EditValue = "";
            }

            // pdf
            $this->pdf->setupEditAttributes();
            if (!$this->pdf->Raw) {
                $this->pdf->CurrentValue = HtmlDecode($this->pdf->CurrentValue);
            }
            $this->pdf->EditValue = HtmlEncode($this->pdf->CurrentValue);
            $this->pdf->PlaceHolder = RemoveHtml($this->pdf->caption());

            // mail_status
            $this->mail_status->setupEditAttributes();
            if (!$this->mail_status->Raw) {
                $this->mail_status->CurrentValue = HtmlDecode($this->mail_status->CurrentValue);
            }
            $this->mail_status->EditValue = HtmlEncode($this->mail_status->CurrentValue);
            $this->mail_status->PlaceHolder = RemoveHtml($this->mail_status->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->CurrentValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
            if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
                $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
            }

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // certificate_id
            $this->certificate_id->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // line_1
            $this->line_1->HrefValue = "";

            // line_2
            $this->line_2->HrefValue = "";

            // e_mail
            $this->e_mail->HrefValue = "";

            // updated
            $this->updated->HrefValue = "";

            // jpg
            $this->jpg->UploadPath = $this->jpg->getUploadPath(); // PHP
            if (!EmptyValue($this->jpg->Upload->DbValue)) {
                $this->jpg->HrefValue = GetFileUploadUrl($this->jpg, $this->jpg->htmlDecode($this->jpg->Upload->DbValue)); // Add prefix/suffix
                $this->jpg->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->jpg->HrefValue = FullUrl($this->jpg->HrefValue, "href");
                }
            } else {
                $this->jpg->HrefValue = "";
            }
            $this->jpg->ExportHrefValue = $this->jpg->UploadPath . $this->jpg->Upload->DbValue;
            $this->jpg->TooltipValue = "";

            // pdf
            if (!EmptyValue($this->pdf->CurrentValue)) {
                $this->pdf->HrefValue = $this->pdf->CurrentValue; // Add prefix/suffix
                $this->pdf->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->pdf->HrefValue = FullUrl($this->pdf->HrefValue, "href");
                }
            } else {
                $this->pdf->HrefValue = "";
            }

            // mail_status
            $this->mail_status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->certificate_id->Visible && $this->certificate_id->Required) {
                if (!$this->certificate_id->IsDetailKey && EmptyValue($this->certificate_id->FormValue)) {
                    $this->certificate_id->addErrorMessage(str_replace("%s", $this->certificate_id->caption(), $this->certificate_id->RequiredErrorMessage));
                }
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->line_1->Visible && $this->line_1->Required) {
                if (!$this->line_1->IsDetailKey && EmptyValue($this->line_1->FormValue)) {
                    $this->line_1->addErrorMessage(str_replace("%s", $this->line_1->caption(), $this->line_1->RequiredErrorMessage));
                }
            }
            if ($this->line_2->Visible && $this->line_2->Required) {
                if (!$this->line_2->IsDetailKey && EmptyValue($this->line_2->FormValue)) {
                    $this->line_2->addErrorMessage(str_replace("%s", $this->line_2->caption(), $this->line_2->RequiredErrorMessage));
                }
            }
            if ($this->e_mail->Visible && $this->e_mail->Required) {
                if (!$this->e_mail->IsDetailKey && EmptyValue($this->e_mail->FormValue)) {
                    $this->e_mail->addErrorMessage(str_replace("%s", $this->e_mail->caption(), $this->e_mail->RequiredErrorMessage));
                }
            }
            if ($this->updated->Visible && $this->updated->Required) {
                if (!$this->updated->IsDetailKey && EmptyValue($this->updated->FormValue)) {
                    $this->updated->addErrorMessage(str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->updated->FormValue)) {
                $this->updated->addErrorMessage($this->updated->getErrorMessage(false));
            }
            if ($this->jpg->Visible && $this->jpg->Required) {
                if ($this->jpg->Upload->FileName == "" && !$this->jpg->Upload->KeepFile) {
                    $this->jpg->addErrorMessage(str_replace("%s", $this->jpg->caption(), $this->jpg->RequiredErrorMessage));
                }
            }
            if ($this->pdf->Visible && $this->pdf->Required) {
                if (!$this->pdf->IsDetailKey && EmptyValue($this->pdf->FormValue)) {
                    $this->pdf->addErrorMessage(str_replace("%s", $this->pdf->caption(), $this->pdf->RequiredErrorMessage));
                }
            }
            if ($this->mail_status->Visible && $this->mail_status->Required) {
                if (!$this->mail_status->IsDetailKey && EmptyValue($this->mail_status->FormValue)) {
                    $this->mail_status->addErrorMessage(str_replace("%s", $this->mail_status->caption(), $this->mail_status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->operator->FormValue)) {
                $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->datetime->FormValue, $this->datetime->formatPattern())) {
                $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->jpg->OldUploadPath = $this->jpg->getUploadPath(); // PHP
        $this->jpg->UploadPath = $this->jpg->OldUploadPath;
        $rsnew = [];

        // certificate_id
        $this->certificate_id->setDbValueDef($rsnew, $this->certificate_id->CurrentValue, $this->certificate_id->ReadOnly);

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, $this->name->ReadOnly);

        // line_1
        $this->line_1->setDbValueDef($rsnew, $this->line_1->CurrentValue, $this->line_1->ReadOnly);

        // line_2
        $this->line_2->setDbValueDef($rsnew, $this->line_2->CurrentValue, $this->line_2->ReadOnly);

        // e_mail
        $this->e_mail->setDbValueDef($rsnew, $this->e_mail->CurrentValue, $this->e_mail->ReadOnly);

        // updated
        $this->updated->setDbValueDef($rsnew, $this->updated->CurrentValue, $this->updated->ReadOnly);

        // pdf
        $this->pdf->setDbValueDef($rsnew, $this->pdf->CurrentValue, $this->pdf->ReadOnly);

        // mail_status
        $this->mail_status->setDbValueDef($rsnew, $this->mail_status->CurrentValue, $this->mail_status->ReadOnly);

        // operator
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['certificate_id'])) { // certificate_id
            $this->certificate_id->CurrentValue = $row['certificate_id'];
        }
        if (isset($row['name'])) { // name
            $this->name->CurrentValue = $row['name'];
        }
        if (isset($row['line_1'])) { // line_1
            $this->line_1->CurrentValue = $row['line_1'];
        }
        if (isset($row['line_2'])) { // line_2
            $this->line_2->CurrentValue = $row['line_2'];
        }
        if (isset($row['e_mail'])) { // e_mail
            $this->e_mail->CurrentValue = $row['e_mail'];
        }
        if (isset($row['updated'])) { // updated
            $this->updated->CurrentValue = $row['updated'];
        }
        if (isset($row['pdf'])) { // pdf
            $this->pdf->CurrentValue = $row['pdf'];
        }
        if (isset($row['mail_status'])) { // mail_status
            $this->mail_status->CurrentValue = $row['mail_status'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("mgscertificatedatalist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_certificate_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
