<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MessageTemplateAdminSearch extends MessageTemplateAdmin
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MessageTemplateAdminSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "messagetemplateadminsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->description->setVisibility();
        $this->variables->setVisibility();
        $this->subject->setVisibility();
        $this->status_email_user->setVisibility();
        $this->email_template_user->setVisibility();
        $this->mail_to_office->setVisibility();
        $this->status_email_office->setVisibility();
        $this->email_template_office->setVisibility();
        $this->status_sms_user->setVisibility();
        $this->sms_template_user->setVisibility();
        $this->sms_template_user_id->setVisibility();
        $this->status_sms_office->setVisibility();
        $this->sms_to_office->setVisibility();
        $this->sms_template_office->setVisibility();
        $this->sms_template_office_id->setVisibility();
        $this->wa_status_user->setVisibility();
        $this->wa_type_user->setVisibility();
        $this->wa_template_user->setVisibility();
        $this->wa_status_office->setVisibility();
        $this->wa_type_office->setVisibility();
        $this->wa_to_office->setVisibility();
        $this->wa_template_office->setVisibility();
        $this->wa_id->setVisibility();
        $this->notification_status_user->setVisibility();
        $this->notification_template_user->setVisibility();
        $this->notification_status_office->setVisibility();
        $this->notification_to_office->setVisibility();
        $this->notification_template_office->setVisibility();
        $this->code->setVisibility();
        $this->_visible->setVisibility();
        $this->cron->setVisibility();
        $this->next_cycle->setVisibility();
        $this->delay->setVisibility();
        $this->delay_method->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->operator_admin->setVisibility();
        $this->datetime_admin->setVisibility();
        $this->company_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'message_template_admin';
        $this->TableName = 'message_template_admin';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (message_template_admin)
        if (!isset($GLOBALS["message_template_admin"]) || $GLOBALS["message_template_admin"]::class == PROJECT_NAMESPACE . "message_template_admin") {
            $GLOBALS["message_template_admin"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'message_template_admin');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "messagetemplateadminview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->status_email_user);
        $this->setupLookupOptions($this->status_email_office);
        $this->setupLookupOptions($this->status_sms_user);
        $this->setupLookupOptions($this->status_sms_office);
        $this->setupLookupOptions($this->wa_status_user);
        $this->setupLookupOptions($this->wa_type_user);
        $this->setupLookupOptions($this->wa_status_office);
        $this->setupLookupOptions($this->wa_type_office);
        $this->setupLookupOptions($this->wa_id);
        $this->setupLookupOptions($this->notification_status_user);
        $this->setupLookupOptions($this->notification_status_office);
        $this->setupLookupOptions($this->notification_to_office);
        $this->setupLookupOptions($this->_visible);
        $this->setupLookupOptions($this->cron);
        $this->setupLookupOptions($this->delay_method);
        $this->setupLookupOptions($this->company_id);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "messagetemplateadminlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->description); // description
        $this->buildSearchUrl($srchUrl, $this->variables); // variables
        $this->buildSearchUrl($srchUrl, $this->subject); // subject
        $this->buildSearchUrl($srchUrl, $this->status_email_user); // status_email_user
        $this->buildSearchUrl($srchUrl, $this->email_template_user); // email_template_user
        $this->buildSearchUrl($srchUrl, $this->mail_to_office); // mail_to_office
        $this->buildSearchUrl($srchUrl, $this->status_email_office); // status_email_office
        $this->buildSearchUrl($srchUrl, $this->email_template_office); // email_template_office
        $this->buildSearchUrl($srchUrl, $this->status_sms_user); // status_sms_user
        $this->buildSearchUrl($srchUrl, $this->sms_template_user); // sms_template_user
        $this->buildSearchUrl($srchUrl, $this->sms_template_user_id); // sms_template_user_id
        $this->buildSearchUrl($srchUrl, $this->status_sms_office); // status_sms_office
        $this->buildSearchUrl($srchUrl, $this->sms_to_office); // sms_to_office
        $this->buildSearchUrl($srchUrl, $this->sms_template_office); // sms_template_office
        $this->buildSearchUrl($srchUrl, $this->sms_template_office_id); // sms_template_office_id
        $this->buildSearchUrl($srchUrl, $this->wa_status_user); // wa_status_user
        $this->buildSearchUrl($srchUrl, $this->wa_type_user); // wa_type_user
        $this->buildSearchUrl($srchUrl, $this->wa_template_user); // wa_template_user
        $this->buildSearchUrl($srchUrl, $this->wa_status_office); // wa_status_office
        $this->buildSearchUrl($srchUrl, $this->wa_type_office); // wa_type_office
        $this->buildSearchUrl($srchUrl, $this->wa_to_office); // wa_to_office
        $this->buildSearchUrl($srchUrl, $this->wa_template_office); // wa_template_office
        $this->buildSearchUrl($srchUrl, $this->wa_id); // wa_id
        $this->buildSearchUrl($srchUrl, $this->notification_status_user); // notification_status_user
        $this->buildSearchUrl($srchUrl, $this->notification_template_user); // notification_template_user
        $this->buildSearchUrl($srchUrl, $this->notification_status_office); // notification_status_office
        $this->buildSearchUrl($srchUrl, $this->notification_to_office); // notification_to_office
        $this->buildSearchUrl($srchUrl, $this->notification_template_office); // notification_template_office
        $this->buildSearchUrl($srchUrl, $this->code); // code
        $this->buildSearchUrl($srchUrl, $this->_visible); // visible
        $this->buildSearchUrl($srchUrl, $this->cron); // cron
        $this->buildSearchUrl($srchUrl, $this->next_cycle); // next_cycle
        $this->buildSearchUrl($srchUrl, $this->delay); // delay
        $this->buildSearchUrl($srchUrl, $this->delay_method); // delay_method
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->operator_admin); // operator_admin
        $this->buildSearchUrl($srchUrl, $this->datetime_admin); // datetime_admin
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description
        if ($this->description->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // variables
        if ($this->variables->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // subject
        if ($this->subject->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status_email_user
        if ($this->status_email_user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // email_template_user
        if ($this->email_template_user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mail_to_office
        if ($this->mail_to_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status_email_office
        if ($this->status_email_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // email_template_office
        if ($this->email_template_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status_sms_user
        if ($this->status_sms_user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sms_template_user
        if ($this->sms_template_user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sms_template_user_id
        if ($this->sms_template_user_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status_sms_office
        if ($this->status_sms_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sms_to_office
        if ($this->sms_to_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sms_template_office
        if ($this->sms_template_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sms_template_office_id
        if ($this->sms_template_office_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // wa_status_user
        if ($this->wa_status_user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // wa_type_user
        if ($this->wa_type_user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // wa_template_user
        if ($this->wa_template_user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // wa_status_office
        if ($this->wa_status_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // wa_type_office
        if ($this->wa_type_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // wa_to_office
        if ($this->wa_to_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // wa_template_office
        if ($this->wa_template_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // wa_id
        if ($this->wa_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // notification_status_user
        if ($this->notification_status_user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // notification_template_user
        if ($this->notification_template_user->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // notification_status_office
        if ($this->notification_status_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // notification_to_office
        if ($this->notification_to_office->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->notification_to_office->AdvancedSearch->SearchValue)) {
            $this->notification_to_office->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->notification_to_office->AdvancedSearch->SearchValue);
        }
        if (is_array($this->notification_to_office->AdvancedSearch->SearchValue2)) {
            $this->notification_to_office->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->notification_to_office->AdvancedSearch->SearchValue2);
        }

        // notification_template_office
        if ($this->notification_template_office->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // code
        if ($this->code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // visible
        if ($this->_visible->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cron
        if ($this->cron->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // next_cycle
        if ($this->next_cycle->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // delay
        if ($this->delay->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // delay_method
        if ($this->delay_method->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator_admin
        if ($this->operator_admin->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime_admin
        if ($this->datetime_admin->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // variables
        $this->variables->RowCssClass = "row";

        // subject
        $this->subject->RowCssClass = "row";

        // status_email_user
        $this->status_email_user->RowCssClass = "row";

        // email_template_user
        $this->email_template_user->RowCssClass = "row";

        // mail_to_office
        $this->mail_to_office->RowCssClass = "row";

        // status_email_office
        $this->status_email_office->RowCssClass = "row";

        // email_template_office
        $this->email_template_office->RowCssClass = "row";

        // status_sms_user
        $this->status_sms_user->RowCssClass = "row";

        // sms_template_user
        $this->sms_template_user->RowCssClass = "row";

        // sms_template_user_id
        $this->sms_template_user_id->RowCssClass = "row";

        // status_sms_office
        $this->status_sms_office->RowCssClass = "row";

        // sms_to_office
        $this->sms_to_office->RowCssClass = "row";

        // sms_template_office
        $this->sms_template_office->RowCssClass = "row";

        // sms_template_office_id
        $this->sms_template_office_id->RowCssClass = "row";

        // wa_status_user
        $this->wa_status_user->RowCssClass = "row";

        // wa_type_user
        $this->wa_type_user->RowCssClass = "row";

        // wa_template_user
        $this->wa_template_user->RowCssClass = "row";

        // wa_status_office
        $this->wa_status_office->RowCssClass = "row";

        // wa_type_office
        $this->wa_type_office->RowCssClass = "row";

        // wa_to_office
        $this->wa_to_office->RowCssClass = "row";

        // wa_template_office
        $this->wa_template_office->RowCssClass = "row";

        // wa_id
        $this->wa_id->RowCssClass = "row";

        // notification_status_user
        $this->notification_status_user->RowCssClass = "row";

        // notification_template_user
        $this->notification_template_user->RowCssClass = "row";

        // notification_status_office
        $this->notification_status_office->RowCssClass = "row";

        // notification_to_office
        $this->notification_to_office->RowCssClass = "row";

        // notification_template_office
        $this->notification_template_office->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // visible
        $this->_visible->RowCssClass = "row";

        // cron
        $this->cron->RowCssClass = "row";

        // next_cycle
        $this->next_cycle->RowCssClass = "row";

        // delay
        $this->delay->RowCssClass = "row";

        // delay_method
        $this->delay_method->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // operator_admin
        $this->operator_admin->RowCssClass = "row";

        // datetime_admin
        $this->datetime_admin->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // variables
            $this->variables->ViewValue = $this->variables->CurrentValue;

            // subject
            $this->subject->ViewValue = $this->subject->CurrentValue;

            // status_email_user
            if (strval($this->status_email_user->CurrentValue) != "") {
                $this->status_email_user->ViewValue = $this->status_email_user->optionCaption($this->status_email_user->CurrentValue);
            } else {
                $this->status_email_user->ViewValue = null;
            }

            // email_template_user
            $this->email_template_user->ViewValue = $this->email_template_user->CurrentValue;

            // mail_to_office
            $this->mail_to_office->ViewValue = $this->mail_to_office->CurrentValue;

            // status_email_office
            if (strval($this->status_email_office->CurrentValue) != "") {
                $this->status_email_office->ViewValue = $this->status_email_office->optionCaption($this->status_email_office->CurrentValue);
            } else {
                $this->status_email_office->ViewValue = null;
            }

            // email_template_office
            $this->email_template_office->ViewValue = $this->email_template_office->CurrentValue;

            // status_sms_user
            if (strval($this->status_sms_user->CurrentValue) != "") {
                $this->status_sms_user->ViewValue = $this->status_sms_user->optionCaption($this->status_sms_user->CurrentValue);
            } else {
                $this->status_sms_user->ViewValue = null;
            }

            // sms_template_user
            $this->sms_template_user->ViewValue = $this->sms_template_user->CurrentValue;

            // sms_template_user_id
            $this->sms_template_user_id->ViewValue = $this->sms_template_user_id->CurrentValue;

            // status_sms_office
            if (strval($this->status_sms_office->CurrentValue) != "") {
                $this->status_sms_office->ViewValue = $this->status_sms_office->optionCaption($this->status_sms_office->CurrentValue);
            } else {
                $this->status_sms_office->ViewValue = null;
            }

            // sms_to_office
            $this->sms_to_office->ViewValue = $this->sms_to_office->CurrentValue;

            // sms_template_office
            $this->sms_template_office->ViewValue = $this->sms_template_office->CurrentValue;

            // sms_template_office_id
            $this->sms_template_office_id->ViewValue = $this->sms_template_office_id->CurrentValue;

            // wa_status_user
            if (strval($this->wa_status_user->CurrentValue) != "") {
                $this->wa_status_user->ViewValue = $this->wa_status_user->optionCaption($this->wa_status_user->CurrentValue);
            } else {
                $this->wa_status_user->ViewValue = null;
            }

            // wa_type_user
            $curVal = strval($this->wa_type_user->CurrentValue);
            if ($curVal != "") {
                $this->wa_type_user->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
                if ($this->wa_type_user->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_type_user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->wa_type_user->getSelectFilter($this); // PHP
                    $sqlWrk = $this->wa_type_user->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_type_user->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_type_user->ViewValue = $this->wa_type_user->displayValue($arwrk);
                    } else {
                        $this->wa_type_user->ViewValue = FormatNumber($this->wa_type_user->CurrentValue, $this->wa_type_user->formatPattern());
                    }
                }
            } else {
                $this->wa_type_user->ViewValue = null;
            }

            // wa_template_user
            $this->wa_template_user->ViewValue = $this->wa_template_user->CurrentValue;

            // wa_status_office
            if (strval($this->wa_status_office->CurrentValue) != "") {
                $this->wa_status_office->ViewValue = $this->wa_status_office->optionCaption($this->wa_status_office->CurrentValue);
            } else {
                $this->wa_status_office->ViewValue = null;
            }

            // wa_type_office
            $curVal = strval($this->wa_type_office->CurrentValue);
            if ($curVal != "") {
                $this->wa_type_office->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
                if ($this->wa_type_office->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_type_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_office->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->wa_type_office->getSelectFilter($this); // PHP
                    $sqlWrk = $this->wa_type_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_type_office->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_type_office->ViewValue = $this->wa_type_office->displayValue($arwrk);
                    } else {
                        $this->wa_type_office->ViewValue = FormatNumber($this->wa_type_office->CurrentValue, $this->wa_type_office->formatPattern());
                    }
                }
            } else {
                $this->wa_type_office->ViewValue = null;
            }

            // wa_to_office
            $this->wa_to_office->ViewValue = $this->wa_to_office->CurrentValue;

            // wa_template_office
            $this->wa_template_office->ViewValue = $this->wa_template_office->CurrentValue;

            // wa_id
            $curVal = strval($this->wa_id->CurrentValue);
            if ($curVal != "") {
                $this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
                if ($this->wa_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->wa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_id->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
                    } else {
                        $this->wa_id->ViewValue = FormatNumber($this->wa_id->CurrentValue, $this->wa_id->formatPattern());
                    }
                }
            } else {
                $this->wa_id->ViewValue = null;
            }

            // notification_status_user
            if (strval($this->notification_status_user->CurrentValue) != "") {
                $this->notification_status_user->ViewValue = $this->notification_status_user->optionCaption($this->notification_status_user->CurrentValue);
            } else {
                $this->notification_status_user->ViewValue = null;
            }

            // notification_template_user
            $this->notification_template_user->ViewValue = $this->notification_template_user->CurrentValue;

            // notification_status_office
            if (strval($this->notification_status_office->CurrentValue) != "") {
                $this->notification_status_office->ViewValue = $this->notification_status_office->optionCaption($this->notification_status_office->CurrentValue);
            } else {
                $this->notification_status_office->ViewValue = null;
            }

            // notification_to_office
            $curVal = strval($this->notification_to_office->CurrentValue);
            if ($curVal != "") {
                $this->notification_to_office->ViewValue = $this->notification_to_office->lookupCacheOption($curVal);
                if ($this->notification_to_office->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->notification_to_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->notification_to_office->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->notification_to_office->getSelectFilter($this); // PHP
                    $sqlWrk = $this->notification_to_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->notification_to_office->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->notification_to_office->Lookup->renderViewRow($row);
                            $this->notification_to_office->ViewValue->add($this->notification_to_office->displayValue($arwrk));
                        }
                    } else {
                        $this->notification_to_office->ViewValue = $this->notification_to_office->CurrentValue;
                    }
                }
            } else {
                $this->notification_to_office->ViewValue = null;
            }

            // notification_template_office
            $this->notification_template_office->ViewValue = $this->notification_template_office->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // visible
            if (strval($this->_visible->CurrentValue) != "") {
                $this->_visible->ViewValue = $this->_visible->optionCaption($this->_visible->CurrentValue);
            } else {
                $this->_visible->ViewValue = null;
            }

            // cron
            if (strval($this->cron->CurrentValue) != "") {
                $this->cron->ViewValue = $this->cron->optionCaption($this->cron->CurrentValue);
            } else {
                $this->cron->ViewValue = null;
            }

            // next_cycle
            $this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
            $this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, $this->next_cycle->formatPattern());

            // delay
            $this->delay->ViewValue = $this->delay->CurrentValue;
            $this->delay->ViewValue = FormatNumber($this->delay->ViewValue, $this->delay->formatPattern());

            // delay_method
            if (strval($this->delay_method->CurrentValue) != "") {
                $this->delay_method->ViewValue = $this->delay_method->optionCaption($this->delay_method->CurrentValue);
            } else {
                $this->delay_method->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // operator_admin
            $this->operator_admin->ViewValue = $this->operator_admin->CurrentValue;

            // datetime_admin
            $this->datetime_admin->ViewValue = $this->datetime_admin->CurrentValue;
            $this->datetime_admin->ViewValue = FormatDateTime($this->datetime_admin->ViewValue, $this->datetime_admin->formatPattern());

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // description
            if (!EmptyValue($this->id->CurrentValue)) {
                $this->description->HrefValue = $this->description->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
                $this->description->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
                }
            } else {
                $this->description->HrefValue = "";
            }
            $this->description->TooltipValue = "";

            // variables
            $this->variables->HrefValue = "";
            $this->variables->TooltipValue = "";

            // subject
            $this->subject->HrefValue = "";
            $this->subject->TooltipValue = "";

            // status_email_user
            $this->status_email_user->HrefValue = "";
            $this->status_email_user->TooltipValue = "";

            // email_template_user
            $this->email_template_user->HrefValue = "";
            $this->email_template_user->TooltipValue = "";

            // mail_to_office
            $this->mail_to_office->HrefValue = "";
            $this->mail_to_office->TooltipValue = "";

            // status_email_office
            $this->status_email_office->HrefValue = "";
            $this->status_email_office->TooltipValue = "";

            // email_template_office
            $this->email_template_office->HrefValue = "";
            $this->email_template_office->TooltipValue = "";

            // status_sms_user
            $this->status_sms_user->HrefValue = "";
            $this->status_sms_user->TooltipValue = "";

            // sms_template_user
            $this->sms_template_user->HrefValue = "";
            $this->sms_template_user->TooltipValue = "";

            // sms_template_user_id
            $this->sms_template_user_id->HrefValue = "";
            $this->sms_template_user_id->TooltipValue = "";

            // status_sms_office
            $this->status_sms_office->HrefValue = "";
            $this->status_sms_office->TooltipValue = "";

            // sms_to_office
            $this->sms_to_office->HrefValue = "";
            $this->sms_to_office->TooltipValue = "";

            // sms_template_office
            $this->sms_template_office->HrefValue = "";
            $this->sms_template_office->TooltipValue = "";

            // sms_template_office_id
            $this->sms_template_office_id->HrefValue = "";
            $this->sms_template_office_id->TooltipValue = "";

            // wa_status_user
            $this->wa_status_user->HrefValue = "";
            $this->wa_status_user->TooltipValue = "";

            // wa_type_user
            $this->wa_type_user->HrefValue = "";
            $this->wa_type_user->TooltipValue = "";

            // wa_template_user
            $this->wa_template_user->HrefValue = "";
            $this->wa_template_user->TooltipValue = "";

            // wa_status_office
            $this->wa_status_office->HrefValue = "";
            $this->wa_status_office->TooltipValue = "";

            // wa_type_office
            $this->wa_type_office->HrefValue = "";
            $this->wa_type_office->TooltipValue = "";

            // wa_to_office
            $this->wa_to_office->HrefValue = "";
            $this->wa_to_office->TooltipValue = "";

            // wa_template_office
            $this->wa_template_office->HrefValue = "";
            $this->wa_template_office->TooltipValue = "";

            // wa_id
            $this->wa_id->HrefValue = "";
            $this->wa_id->TooltipValue = "";

            // notification_status_user
            $this->notification_status_user->HrefValue = "";
            $this->notification_status_user->TooltipValue = "";

            // notification_template_user
            $this->notification_template_user->HrefValue = "";
            $this->notification_template_user->TooltipValue = "";

            // notification_status_office
            $this->notification_status_office->HrefValue = "";
            $this->notification_status_office->TooltipValue = "";

            // notification_to_office
            $this->notification_to_office->HrefValue = "";
            $this->notification_to_office->TooltipValue = "";

            // notification_template_office
            $this->notification_template_office->HrefValue = "";
            $this->notification_template_office->TooltipValue = "";

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";

            // visible
            $this->_visible->HrefValue = "";
            $this->_visible->TooltipValue = "";

            // cron
            $this->cron->HrefValue = "";
            $this->cron->TooltipValue = "";

            // next_cycle
            $this->next_cycle->HrefValue = "";
            $this->next_cycle->TooltipValue = "";

            // delay
            $this->delay->HrefValue = "";
            $this->delay->TooltipValue = "";

            // delay_method
            $this->delay_method->HrefValue = "";
            $this->delay_method->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // operator_admin
            $this->operator_admin->HrefValue = "";
            $this->operator_admin->TooltipValue = "";

            // datetime_admin
            $this->datetime_admin->HrefValue = "";
            $this->datetime_admin->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->AdvancedSearch->SearchValue = HtmlDecode($this->description->AdvancedSearch->SearchValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // variables
            $this->variables->setupEditAttributes();
            $this->variables->EditValue = HtmlEncode($this->variables->AdvancedSearch->SearchValue);
            $this->variables->PlaceHolder = RemoveHtml($this->variables->caption());

            // subject
            $this->subject->setupEditAttributes();
            if (!$this->subject->Raw) {
                $this->subject->AdvancedSearch->SearchValue = HtmlDecode($this->subject->AdvancedSearch->SearchValue);
            }
            $this->subject->EditValue = HtmlEncode($this->subject->AdvancedSearch->SearchValue);
            $this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

            // status_email_user
            $this->status_email_user->setupEditAttributes();
            $this->status_email_user->EditValue = $this->status_email_user->options(true);
            $this->status_email_user->PlaceHolder = RemoveHtml($this->status_email_user->caption());

            // email_template_user
            $this->email_template_user->setupEditAttributes();
            $this->email_template_user->EditValue = HtmlEncode($this->email_template_user->AdvancedSearch->SearchValue);
            $this->email_template_user->PlaceHolder = RemoveHtml($this->email_template_user->caption());

            // mail_to_office
            $this->mail_to_office->setupEditAttributes();
            if (!$this->mail_to_office->Raw) {
                $this->mail_to_office->AdvancedSearch->SearchValue = HtmlDecode($this->mail_to_office->AdvancedSearch->SearchValue);
            }
            $this->mail_to_office->EditValue = HtmlEncode($this->mail_to_office->AdvancedSearch->SearchValue);
            $this->mail_to_office->PlaceHolder = RemoveHtml($this->mail_to_office->caption());

            // status_email_office
            $this->status_email_office->setupEditAttributes();
            $this->status_email_office->EditValue = $this->status_email_office->options(true);
            $this->status_email_office->PlaceHolder = RemoveHtml($this->status_email_office->caption());

            // email_template_office
            $this->email_template_office->setupEditAttributes();
            $this->email_template_office->EditValue = HtmlEncode($this->email_template_office->AdvancedSearch->SearchValue);
            $this->email_template_office->PlaceHolder = RemoveHtml($this->email_template_office->caption());

            // status_sms_user
            $this->status_sms_user->setupEditAttributes();
            $this->status_sms_user->EditValue = $this->status_sms_user->options(true);
            $this->status_sms_user->PlaceHolder = RemoveHtml($this->status_sms_user->caption());

            // sms_template_user
            $this->sms_template_user->setupEditAttributes();
            $this->sms_template_user->EditValue = HtmlEncode($this->sms_template_user->AdvancedSearch->SearchValue);
            $this->sms_template_user->PlaceHolder = RemoveHtml($this->sms_template_user->caption());

            // sms_template_user_id
            $this->sms_template_user_id->setupEditAttributes();
            if (!$this->sms_template_user_id->Raw) {
                $this->sms_template_user_id->AdvancedSearch->SearchValue = HtmlDecode($this->sms_template_user_id->AdvancedSearch->SearchValue);
            }
            $this->sms_template_user_id->EditValue = HtmlEncode($this->sms_template_user_id->AdvancedSearch->SearchValue);
            $this->sms_template_user_id->PlaceHolder = RemoveHtml($this->sms_template_user_id->caption());

            // status_sms_office
            $this->status_sms_office->setupEditAttributes();
            $this->status_sms_office->EditValue = $this->status_sms_office->options(true);
            $this->status_sms_office->PlaceHolder = RemoveHtml($this->status_sms_office->caption());

            // sms_to_office
            $this->sms_to_office->setupEditAttributes();
            if (!$this->sms_to_office->Raw) {
                $this->sms_to_office->AdvancedSearch->SearchValue = HtmlDecode($this->sms_to_office->AdvancedSearch->SearchValue);
            }
            $this->sms_to_office->EditValue = HtmlEncode($this->sms_to_office->AdvancedSearch->SearchValue);
            $this->sms_to_office->PlaceHolder = RemoveHtml($this->sms_to_office->caption());

            // sms_template_office
            $this->sms_template_office->setupEditAttributes();
            $this->sms_template_office->EditValue = HtmlEncode($this->sms_template_office->AdvancedSearch->SearchValue);
            $this->sms_template_office->PlaceHolder = RemoveHtml($this->sms_template_office->caption());

            // sms_template_office_id
            $this->sms_template_office_id->setupEditAttributes();
            if (!$this->sms_template_office_id->Raw) {
                $this->sms_template_office_id->AdvancedSearch->SearchValue = HtmlDecode($this->sms_template_office_id->AdvancedSearch->SearchValue);
            }
            $this->sms_template_office_id->EditValue = HtmlEncode($this->sms_template_office_id->AdvancedSearch->SearchValue);
            $this->sms_template_office_id->PlaceHolder = RemoveHtml($this->sms_template_office_id->caption());

            // wa_status_user
            $this->wa_status_user->setupEditAttributes();
            $this->wa_status_user->EditValue = $this->wa_status_user->options(true);
            $this->wa_status_user->PlaceHolder = RemoveHtml($this->wa_status_user->caption());

            // wa_type_user
            $this->wa_type_user->setupEditAttributes();
            $curVal = trim(strval($this->wa_type_user->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->wa_type_user->AdvancedSearch->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
            } else {
                $this->wa_type_user->AdvancedSearch->ViewValue = $this->wa_type_user->Lookup !== null && is_array($this->wa_type_user->lookupOptions()) && count($this->wa_type_user->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->wa_type_user->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->wa_type_user->EditValue = array_values($this->wa_type_user->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->wa_type_user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->wa_type_user->AdvancedSearch->SearchValue, $this->wa_type_user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->wa_type_user->getSelectFilter($this); // PHP
                $sqlWrk = $this->wa_type_user->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->wa_type_user->EditValue = $arwrk;
            }
            $this->wa_type_user->PlaceHolder = RemoveHtml($this->wa_type_user->caption());

            // wa_template_user
            $this->wa_template_user->setupEditAttributes();
            $this->wa_template_user->EditValue = HtmlEncode($this->wa_template_user->AdvancedSearch->SearchValue);
            $this->wa_template_user->PlaceHolder = RemoveHtml($this->wa_template_user->caption());

            // wa_status_office
            $this->wa_status_office->setupEditAttributes();
            $this->wa_status_office->EditValue = $this->wa_status_office->options(true);
            $this->wa_status_office->PlaceHolder = RemoveHtml($this->wa_status_office->caption());

            // wa_type_office
            $this->wa_type_office->setupEditAttributes();
            $curVal = trim(strval($this->wa_type_office->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->wa_type_office->AdvancedSearch->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
            } else {
                $this->wa_type_office->AdvancedSearch->ViewValue = $this->wa_type_office->Lookup !== null && is_array($this->wa_type_office->lookupOptions()) && count($this->wa_type_office->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->wa_type_office->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->wa_type_office->EditValue = array_values($this->wa_type_office->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->wa_type_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->wa_type_office->AdvancedSearch->SearchValue, $this->wa_type_office->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->wa_type_office->getSelectFilter($this); // PHP
                $sqlWrk = $this->wa_type_office->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->wa_type_office->EditValue = $arwrk;
            }
            $this->wa_type_office->PlaceHolder = RemoveHtml($this->wa_type_office->caption());

            // wa_to_office
            $this->wa_to_office->setupEditAttributes();
            if (!$this->wa_to_office->Raw) {
                $this->wa_to_office->AdvancedSearch->SearchValue = HtmlDecode($this->wa_to_office->AdvancedSearch->SearchValue);
            }
            $this->wa_to_office->EditValue = HtmlEncode($this->wa_to_office->AdvancedSearch->SearchValue);
            $this->wa_to_office->PlaceHolder = RemoveHtml($this->wa_to_office->caption());

            // wa_template_office
            $this->wa_template_office->setupEditAttributes();
            $this->wa_template_office->EditValue = HtmlEncode($this->wa_template_office->AdvancedSearch->SearchValue);
            $this->wa_template_office->PlaceHolder = RemoveHtml($this->wa_template_office->caption());

            // wa_id
            $this->wa_id->setupEditAttributes();
            $curVal = trim(strval($this->wa_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->wa_id->AdvancedSearch->ViewValue = $this->wa_id->lookupCacheOption($curVal);
            } else {
                $this->wa_id->AdvancedSearch->ViewValue = $this->wa_id->Lookup !== null && is_array($this->wa_id->lookupOptions()) && count($this->wa_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->wa_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->wa_id->EditValue = array_values($this->wa_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->wa_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->wa_id->AdvancedSearch->SearchValue, $this->wa_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->wa_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->wa_id->EditValue = $arwrk;
            }
            $this->wa_id->PlaceHolder = RemoveHtml($this->wa_id->caption());

            // notification_status_user
            $this->notification_status_user->setupEditAttributes();
            $this->notification_status_user->EditValue = $this->notification_status_user->options(true);
            $this->notification_status_user->PlaceHolder = RemoveHtml($this->notification_status_user->caption());

            // notification_template_user
            $this->notification_template_user->setupEditAttributes();
            $this->notification_template_user->EditValue = HtmlEncode($this->notification_template_user->AdvancedSearch->SearchValue);
            $this->notification_template_user->PlaceHolder = RemoveHtml($this->notification_template_user->caption());

            // notification_status_office
            $this->notification_status_office->setupEditAttributes();
            $this->notification_status_office->EditValue = $this->notification_status_office->options(true);
            $this->notification_status_office->PlaceHolder = RemoveHtml($this->notification_status_office->caption());

            // notification_to_office
            $this->notification_to_office->setupEditAttributes();
            $curVal = trim(strval($this->notification_to_office->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->notification_to_office->AdvancedSearch->ViewValue = $this->notification_to_office->lookupCacheOption($curVal);
            } else {
                $this->notification_to_office->AdvancedSearch->ViewValue = $this->notification_to_office->Lookup !== null && is_array($this->notification_to_office->lookupOptions()) && count($this->notification_to_office->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->notification_to_office->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->notification_to_office->EditValue = array_values($this->notification_to_office->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->notification_to_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->notification_to_office->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->notification_to_office->getSelectFilter($this); // PHP
                $sqlWrk = $this->notification_to_office->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->notification_to_office->EditValue = $arwrk;
            }
            $this->notification_to_office->PlaceHolder = RemoveHtml($this->notification_to_office->caption());

            // notification_template_office
            $this->notification_template_office->setupEditAttributes();
            $this->notification_template_office->EditValue = HtmlEncode($this->notification_template_office->AdvancedSearch->SearchValue);
            $this->notification_template_office->PlaceHolder = RemoveHtml($this->notification_template_office->caption());

            // code
            $this->code->setupEditAttributes();
            $this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // visible
            $this->_visible->setupEditAttributes();
            $this->_visible->EditValue = $this->_visible->options(true);
            $this->_visible->PlaceHolder = RemoveHtml($this->_visible->caption());

            // cron
            $this->cron->setupEditAttributes();
            $this->cron->EditValue = $this->cron->options(true);
            $this->cron->PlaceHolder = RemoveHtml($this->cron->caption());

            // next_cycle
            $this->next_cycle->setupEditAttributes();
            $this->next_cycle->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->next_cycle->AdvancedSearch->SearchValue, $this->next_cycle->formatPattern()), $this->next_cycle->formatPattern()));
            $this->next_cycle->PlaceHolder = RemoveHtml($this->next_cycle->caption());

            // delay
            $this->delay->setupEditAttributes();
            $this->delay->EditValue = $this->delay->AdvancedSearch->SearchValue;
            $this->delay->PlaceHolder = RemoveHtml($this->delay->caption());

            // delay_method
            $this->delay_method->setupEditAttributes();
            $this->delay_method->EditValue = $this->delay_method->options(true);
            $this->delay_method->PlaceHolder = RemoveHtml($this->delay_method->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // operator_admin
            $this->operator_admin->setupEditAttributes();
            $this->operator_admin->EditValue = $this->operator_admin->AdvancedSearch->SearchValue;
            $this->operator_admin->PlaceHolder = RemoveHtml($this->operator_admin->caption());

            // datetime_admin
            $this->datetime_admin->setupEditAttributes();
            $this->datetime_admin->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime_admin->AdvancedSearch->SearchValue, $this->datetime_admin->formatPattern()), $this->datetime_admin->formatPattern()));
            $this->datetime_admin->PlaceHolder = RemoveHtml($this->datetime_admin->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->AdvancedSearch->SearchValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckDate($this->next_cycle->AdvancedSearch->SearchValue, $this->next_cycle->formatPattern())) {
            $this->next_cycle->addErrorMessage($this->next_cycle->getErrorMessage(false));
        }
        if (!CheckInteger($this->delay->AdvancedSearch->SearchValue)) {
            $this->delay->addErrorMessage($this->delay->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator_admin->AdvancedSearch->SearchValue)) {
            $this->operator_admin->addErrorMessage($this->operator_admin->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime_admin->AdvancedSearch->SearchValue, $this->datetime_admin->formatPattern())) {
            $this->datetime_admin->addErrorMessage($this->datetime_admin->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->variables->AdvancedSearch->load();
        $this->subject->AdvancedSearch->load();
        $this->status_email_user->AdvancedSearch->load();
        $this->email_template_user->AdvancedSearch->load();
        $this->mail_to_office->AdvancedSearch->load();
        $this->status_email_office->AdvancedSearch->load();
        $this->email_template_office->AdvancedSearch->load();
        $this->status_sms_user->AdvancedSearch->load();
        $this->sms_template_user->AdvancedSearch->load();
        $this->sms_template_user_id->AdvancedSearch->load();
        $this->status_sms_office->AdvancedSearch->load();
        $this->sms_to_office->AdvancedSearch->load();
        $this->sms_template_office->AdvancedSearch->load();
        $this->sms_template_office_id->AdvancedSearch->load();
        $this->wa_status_user->AdvancedSearch->load();
        $this->wa_type_user->AdvancedSearch->load();
        $this->wa_template_user->AdvancedSearch->load();
        $this->wa_status_office->AdvancedSearch->load();
        $this->wa_type_office->AdvancedSearch->load();
        $this->wa_to_office->AdvancedSearch->load();
        $this->wa_template_office->AdvancedSearch->load();
        $this->wa_id->AdvancedSearch->load();
        $this->notification_status_user->AdvancedSearch->load();
        $this->notification_template_user->AdvancedSearch->load();
        $this->notification_status_office->AdvancedSearch->load();
        $this->notification_to_office->AdvancedSearch->load();
        $this->notification_template_office->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->_visible->AdvancedSearch->load();
        $this->cron->AdvancedSearch->load();
        $this->next_cycle->AdvancedSearch->load();
        $this->delay->AdvancedSearch->load();
        $this->delay_method->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->operator_admin->AdvancedSearch->load();
        $this->datetime_admin->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("messagetemplateadminlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status_email_user":
                    break;
                case "x_status_email_office":
                    break;
                case "x_status_sms_user":
                    break;
                case "x_status_sms_office":
                    break;
                case "x_wa_status_user":
                    break;
                case "x_wa_type_user":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_status_office":
                    break;
                case "x_wa_type_office":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_id":
                    break;
                case "x_notification_status_user":
                    break;
                case "x_notification_status_office":
                    break;
                case "x_notification_to_office":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__visible":
                    break;
                case "x_cron":
                    break;
                case "x_delay_method":
                    break;
                case "x_company_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
