<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MessageTemplateAdminList extends MessageTemplateAdmin
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MessageTemplateAdminList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fmessage_template_adminlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "messagetemplateadminlist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->description->setVisibility();
        $this->variables->Visible = false;
        $this->subject->setVisibility();
        $this->status_email_user->setVisibility();
        $this->email_template_user->Visible = false;
        $this->mail_to_office->setVisibility();
        $this->status_email_office->setVisibility();
        $this->email_template_office->Visible = false;
        $this->status_sms_user->setVisibility();
        $this->sms_template_user->Visible = false;
        $this->sms_template_user_id->setVisibility();
        $this->status_sms_office->Visible = false;
        $this->sms_to_office->setVisibility();
        $this->sms_template_office->setVisibility();
        $this->sms_template_office_id->setVisibility();
        $this->wa_status_user->setVisibility();
        $this->wa_type_user->setVisibility();
        $this->wa_template_user->Visible = false;
        $this->wa_status_office->setVisibility();
        $this->wa_type_office->setVisibility();
        $this->wa_to_office->setVisibility();
        $this->wa_template_office->Visible = false;
        $this->wa_id->setVisibility();
        $this->notification_status_user->setVisibility();
        $this->notification_template_user->Visible = false;
        $this->notification_status_office->setVisibility();
        $this->notification_to_office->setVisibility();
        $this->notification_template_office->Visible = false;
        $this->code->Visible = false;
        $this->_visible->setVisibility();
        $this->cron->setVisibility();
        $this->next_cycle->setVisibility();
        $this->delay->setVisibility();
        $this->delay_method->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->operator_admin->setVisibility();
        $this->datetime_admin->setVisibility();
        $this->company_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'message_template_admin';
        $this->TableName = 'message_template_admin';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (message_template_admin)
        if (!isset($GLOBALS["message_template_admin"]) || $GLOBALS["message_template_admin"]::class == PROJECT_NAMESPACE . "message_template_admin") {
            $GLOBALS["message_template_admin"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "messagetemplateadminadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "messagetemplateadmindelete";
        $this->MultiUpdateUrl = "messagetemplateadminupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'message_template_admin');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "messagetemplateadminview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator_admin->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime_admin->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->status_email_user);
        $this->setupLookupOptions($this->status_email_office);
        $this->setupLookupOptions($this->status_sms_user);
        $this->setupLookupOptions($this->status_sms_office);
        $this->setupLookupOptions($this->wa_status_user);
        $this->setupLookupOptions($this->wa_type_user);
        $this->setupLookupOptions($this->wa_status_office);
        $this->setupLookupOptions($this->wa_type_office);
        $this->setupLookupOptions($this->wa_id);
        $this->setupLookupOptions($this->notification_status_user);
        $this->setupLookupOptions($this->notification_status_office);
        $this->setupLookupOptions($this->notification_to_office);
        $this->setupLookupOptions($this->_visible);
        $this->setupLookupOptions($this->cron);
        $this->setupLookupOptions($this->delay_method);
        $this->setupLookupOptions($this->company_id);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fmessage_template_admingrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fmessage_template_adminsrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->description->AdvancedSearch->toJson(), ","); // Field description
        $filterList = Concat($filterList, $this->variables->AdvancedSearch->toJson(), ","); // Field variables
        $filterList = Concat($filterList, $this->subject->AdvancedSearch->toJson(), ","); // Field subject
        $filterList = Concat($filterList, $this->status_email_user->AdvancedSearch->toJson(), ","); // Field status_email_user
        $filterList = Concat($filterList, $this->email_template_user->AdvancedSearch->toJson(), ","); // Field email_template_user
        $filterList = Concat($filterList, $this->mail_to_office->AdvancedSearch->toJson(), ","); // Field mail_to_office
        $filterList = Concat($filterList, $this->status_email_office->AdvancedSearch->toJson(), ","); // Field status_email_office
        $filterList = Concat($filterList, $this->email_template_office->AdvancedSearch->toJson(), ","); // Field email_template_office
        $filterList = Concat($filterList, $this->status_sms_user->AdvancedSearch->toJson(), ","); // Field status_sms_user
        $filterList = Concat($filterList, $this->sms_template_user->AdvancedSearch->toJson(), ","); // Field sms_template_user
        $filterList = Concat($filterList, $this->sms_template_user_id->AdvancedSearch->toJson(), ","); // Field sms_template_user_id
        $filterList = Concat($filterList, $this->status_sms_office->AdvancedSearch->toJson(), ","); // Field status_sms_office
        $filterList = Concat($filterList, $this->sms_to_office->AdvancedSearch->toJson(), ","); // Field sms_to_office
        $filterList = Concat($filterList, $this->sms_template_office->AdvancedSearch->toJson(), ","); // Field sms_template_office
        $filterList = Concat($filterList, $this->sms_template_office_id->AdvancedSearch->toJson(), ","); // Field sms_template_office_id
        $filterList = Concat($filterList, $this->wa_status_user->AdvancedSearch->toJson(), ","); // Field wa_status_user
        $filterList = Concat($filterList, $this->wa_type_user->AdvancedSearch->toJson(), ","); // Field wa_type_user
        $filterList = Concat($filterList, $this->wa_template_user->AdvancedSearch->toJson(), ","); // Field wa_template_user
        $filterList = Concat($filterList, $this->wa_status_office->AdvancedSearch->toJson(), ","); // Field wa_status_office
        $filterList = Concat($filterList, $this->wa_type_office->AdvancedSearch->toJson(), ","); // Field wa_type_office
        $filterList = Concat($filterList, $this->wa_to_office->AdvancedSearch->toJson(), ","); // Field wa_to_office
        $filterList = Concat($filterList, $this->wa_template_office->AdvancedSearch->toJson(), ","); // Field wa_template_office
        $filterList = Concat($filterList, $this->wa_id->AdvancedSearch->toJson(), ","); // Field wa_id
        $filterList = Concat($filterList, $this->notification_status_user->AdvancedSearch->toJson(), ","); // Field notification_status_user
        $filterList = Concat($filterList, $this->notification_template_user->AdvancedSearch->toJson(), ","); // Field notification_template_user
        $filterList = Concat($filterList, $this->notification_status_office->AdvancedSearch->toJson(), ","); // Field notification_status_office
        $filterList = Concat($filterList, $this->notification_to_office->AdvancedSearch->toJson(), ","); // Field notification_to_office
        $filterList = Concat($filterList, $this->notification_template_office->AdvancedSearch->toJson(), ","); // Field notification_template_office
        $filterList = Concat($filterList, $this->code->AdvancedSearch->toJson(), ","); // Field code
        $filterList = Concat($filterList, $this->_visible->AdvancedSearch->toJson(), ","); // Field visible
        $filterList = Concat($filterList, $this->cron->AdvancedSearch->toJson(), ","); // Field cron
        $filterList = Concat($filterList, $this->next_cycle->AdvancedSearch->toJson(), ","); // Field next_cycle
        $filterList = Concat($filterList, $this->delay->AdvancedSearch->toJson(), ","); // Field delay
        $filterList = Concat($filterList, $this->delay_method->AdvancedSearch->toJson(), ","); // Field delay_method
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        $filterList = Concat($filterList, $this->operator_admin->AdvancedSearch->toJson(), ","); // Field operator_admin
        $filterList = Concat($filterList, $this->datetime_admin->AdvancedSearch->toJson(), ","); // Field datetime_admin
        $filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fmessage_template_adminsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field description
        $this->description->AdvancedSearch->SearchValue = @$filter["x_description"];
        $this->description->AdvancedSearch->SearchOperator = @$filter["z_description"];
        $this->description->AdvancedSearch->SearchCondition = @$filter["v_description"];
        $this->description->AdvancedSearch->SearchValue2 = @$filter["y_description"];
        $this->description->AdvancedSearch->SearchOperator2 = @$filter["w_description"];
        $this->description->AdvancedSearch->save();

        // Field variables
        $this->variables->AdvancedSearch->SearchValue = @$filter["x_variables"];
        $this->variables->AdvancedSearch->SearchOperator = @$filter["z_variables"];
        $this->variables->AdvancedSearch->SearchCondition = @$filter["v_variables"];
        $this->variables->AdvancedSearch->SearchValue2 = @$filter["y_variables"];
        $this->variables->AdvancedSearch->SearchOperator2 = @$filter["w_variables"];
        $this->variables->AdvancedSearch->save();

        // Field subject
        $this->subject->AdvancedSearch->SearchValue = @$filter["x_subject"];
        $this->subject->AdvancedSearch->SearchOperator = @$filter["z_subject"];
        $this->subject->AdvancedSearch->SearchCondition = @$filter["v_subject"];
        $this->subject->AdvancedSearch->SearchValue2 = @$filter["y_subject"];
        $this->subject->AdvancedSearch->SearchOperator2 = @$filter["w_subject"];
        $this->subject->AdvancedSearch->save();

        // Field status_email_user
        $this->status_email_user->AdvancedSearch->SearchValue = @$filter["x_status_email_user"];
        $this->status_email_user->AdvancedSearch->SearchOperator = @$filter["z_status_email_user"];
        $this->status_email_user->AdvancedSearch->SearchCondition = @$filter["v_status_email_user"];
        $this->status_email_user->AdvancedSearch->SearchValue2 = @$filter["y_status_email_user"];
        $this->status_email_user->AdvancedSearch->SearchOperator2 = @$filter["w_status_email_user"];
        $this->status_email_user->AdvancedSearch->save();

        // Field email_template_user
        $this->email_template_user->AdvancedSearch->SearchValue = @$filter["x_email_template_user"];
        $this->email_template_user->AdvancedSearch->SearchOperator = @$filter["z_email_template_user"];
        $this->email_template_user->AdvancedSearch->SearchCondition = @$filter["v_email_template_user"];
        $this->email_template_user->AdvancedSearch->SearchValue2 = @$filter["y_email_template_user"];
        $this->email_template_user->AdvancedSearch->SearchOperator2 = @$filter["w_email_template_user"];
        $this->email_template_user->AdvancedSearch->save();

        // Field mail_to_office
        $this->mail_to_office->AdvancedSearch->SearchValue = @$filter["x_mail_to_office"];
        $this->mail_to_office->AdvancedSearch->SearchOperator = @$filter["z_mail_to_office"];
        $this->mail_to_office->AdvancedSearch->SearchCondition = @$filter["v_mail_to_office"];
        $this->mail_to_office->AdvancedSearch->SearchValue2 = @$filter["y_mail_to_office"];
        $this->mail_to_office->AdvancedSearch->SearchOperator2 = @$filter["w_mail_to_office"];
        $this->mail_to_office->AdvancedSearch->save();

        // Field status_email_office
        $this->status_email_office->AdvancedSearch->SearchValue = @$filter["x_status_email_office"];
        $this->status_email_office->AdvancedSearch->SearchOperator = @$filter["z_status_email_office"];
        $this->status_email_office->AdvancedSearch->SearchCondition = @$filter["v_status_email_office"];
        $this->status_email_office->AdvancedSearch->SearchValue2 = @$filter["y_status_email_office"];
        $this->status_email_office->AdvancedSearch->SearchOperator2 = @$filter["w_status_email_office"];
        $this->status_email_office->AdvancedSearch->save();

        // Field email_template_office
        $this->email_template_office->AdvancedSearch->SearchValue = @$filter["x_email_template_office"];
        $this->email_template_office->AdvancedSearch->SearchOperator = @$filter["z_email_template_office"];
        $this->email_template_office->AdvancedSearch->SearchCondition = @$filter["v_email_template_office"];
        $this->email_template_office->AdvancedSearch->SearchValue2 = @$filter["y_email_template_office"];
        $this->email_template_office->AdvancedSearch->SearchOperator2 = @$filter["w_email_template_office"];
        $this->email_template_office->AdvancedSearch->save();

        // Field status_sms_user
        $this->status_sms_user->AdvancedSearch->SearchValue = @$filter["x_status_sms_user"];
        $this->status_sms_user->AdvancedSearch->SearchOperator = @$filter["z_status_sms_user"];
        $this->status_sms_user->AdvancedSearch->SearchCondition = @$filter["v_status_sms_user"];
        $this->status_sms_user->AdvancedSearch->SearchValue2 = @$filter["y_status_sms_user"];
        $this->status_sms_user->AdvancedSearch->SearchOperator2 = @$filter["w_status_sms_user"];
        $this->status_sms_user->AdvancedSearch->save();

        // Field sms_template_user
        $this->sms_template_user->AdvancedSearch->SearchValue = @$filter["x_sms_template_user"];
        $this->sms_template_user->AdvancedSearch->SearchOperator = @$filter["z_sms_template_user"];
        $this->sms_template_user->AdvancedSearch->SearchCondition = @$filter["v_sms_template_user"];
        $this->sms_template_user->AdvancedSearch->SearchValue2 = @$filter["y_sms_template_user"];
        $this->sms_template_user->AdvancedSearch->SearchOperator2 = @$filter["w_sms_template_user"];
        $this->sms_template_user->AdvancedSearch->save();

        // Field sms_template_user_id
        $this->sms_template_user_id->AdvancedSearch->SearchValue = @$filter["x_sms_template_user_id"];
        $this->sms_template_user_id->AdvancedSearch->SearchOperator = @$filter["z_sms_template_user_id"];
        $this->sms_template_user_id->AdvancedSearch->SearchCondition = @$filter["v_sms_template_user_id"];
        $this->sms_template_user_id->AdvancedSearch->SearchValue2 = @$filter["y_sms_template_user_id"];
        $this->sms_template_user_id->AdvancedSearch->SearchOperator2 = @$filter["w_sms_template_user_id"];
        $this->sms_template_user_id->AdvancedSearch->save();

        // Field status_sms_office
        $this->status_sms_office->AdvancedSearch->SearchValue = @$filter["x_status_sms_office"];
        $this->status_sms_office->AdvancedSearch->SearchOperator = @$filter["z_status_sms_office"];
        $this->status_sms_office->AdvancedSearch->SearchCondition = @$filter["v_status_sms_office"];
        $this->status_sms_office->AdvancedSearch->SearchValue2 = @$filter["y_status_sms_office"];
        $this->status_sms_office->AdvancedSearch->SearchOperator2 = @$filter["w_status_sms_office"];
        $this->status_sms_office->AdvancedSearch->save();

        // Field sms_to_office
        $this->sms_to_office->AdvancedSearch->SearchValue = @$filter["x_sms_to_office"];
        $this->sms_to_office->AdvancedSearch->SearchOperator = @$filter["z_sms_to_office"];
        $this->sms_to_office->AdvancedSearch->SearchCondition = @$filter["v_sms_to_office"];
        $this->sms_to_office->AdvancedSearch->SearchValue2 = @$filter["y_sms_to_office"];
        $this->sms_to_office->AdvancedSearch->SearchOperator2 = @$filter["w_sms_to_office"];
        $this->sms_to_office->AdvancedSearch->save();

        // Field sms_template_office
        $this->sms_template_office->AdvancedSearch->SearchValue = @$filter["x_sms_template_office"];
        $this->sms_template_office->AdvancedSearch->SearchOperator = @$filter["z_sms_template_office"];
        $this->sms_template_office->AdvancedSearch->SearchCondition = @$filter["v_sms_template_office"];
        $this->sms_template_office->AdvancedSearch->SearchValue2 = @$filter["y_sms_template_office"];
        $this->sms_template_office->AdvancedSearch->SearchOperator2 = @$filter["w_sms_template_office"];
        $this->sms_template_office->AdvancedSearch->save();

        // Field sms_template_office_id
        $this->sms_template_office_id->AdvancedSearch->SearchValue = @$filter["x_sms_template_office_id"];
        $this->sms_template_office_id->AdvancedSearch->SearchOperator = @$filter["z_sms_template_office_id"];
        $this->sms_template_office_id->AdvancedSearch->SearchCondition = @$filter["v_sms_template_office_id"];
        $this->sms_template_office_id->AdvancedSearch->SearchValue2 = @$filter["y_sms_template_office_id"];
        $this->sms_template_office_id->AdvancedSearch->SearchOperator2 = @$filter["w_sms_template_office_id"];
        $this->sms_template_office_id->AdvancedSearch->save();

        // Field wa_status_user
        $this->wa_status_user->AdvancedSearch->SearchValue = @$filter["x_wa_status_user"];
        $this->wa_status_user->AdvancedSearch->SearchOperator = @$filter["z_wa_status_user"];
        $this->wa_status_user->AdvancedSearch->SearchCondition = @$filter["v_wa_status_user"];
        $this->wa_status_user->AdvancedSearch->SearchValue2 = @$filter["y_wa_status_user"];
        $this->wa_status_user->AdvancedSearch->SearchOperator2 = @$filter["w_wa_status_user"];
        $this->wa_status_user->AdvancedSearch->save();

        // Field wa_type_user
        $this->wa_type_user->AdvancedSearch->SearchValue = @$filter["x_wa_type_user"];
        $this->wa_type_user->AdvancedSearch->SearchOperator = @$filter["z_wa_type_user"];
        $this->wa_type_user->AdvancedSearch->SearchCondition = @$filter["v_wa_type_user"];
        $this->wa_type_user->AdvancedSearch->SearchValue2 = @$filter["y_wa_type_user"];
        $this->wa_type_user->AdvancedSearch->SearchOperator2 = @$filter["w_wa_type_user"];
        $this->wa_type_user->AdvancedSearch->save();

        // Field wa_template_user
        $this->wa_template_user->AdvancedSearch->SearchValue = @$filter["x_wa_template_user"];
        $this->wa_template_user->AdvancedSearch->SearchOperator = @$filter["z_wa_template_user"];
        $this->wa_template_user->AdvancedSearch->SearchCondition = @$filter["v_wa_template_user"];
        $this->wa_template_user->AdvancedSearch->SearchValue2 = @$filter["y_wa_template_user"];
        $this->wa_template_user->AdvancedSearch->SearchOperator2 = @$filter["w_wa_template_user"];
        $this->wa_template_user->AdvancedSearch->save();

        // Field wa_status_office
        $this->wa_status_office->AdvancedSearch->SearchValue = @$filter["x_wa_status_office"];
        $this->wa_status_office->AdvancedSearch->SearchOperator = @$filter["z_wa_status_office"];
        $this->wa_status_office->AdvancedSearch->SearchCondition = @$filter["v_wa_status_office"];
        $this->wa_status_office->AdvancedSearch->SearchValue2 = @$filter["y_wa_status_office"];
        $this->wa_status_office->AdvancedSearch->SearchOperator2 = @$filter["w_wa_status_office"];
        $this->wa_status_office->AdvancedSearch->save();

        // Field wa_type_office
        $this->wa_type_office->AdvancedSearch->SearchValue = @$filter["x_wa_type_office"];
        $this->wa_type_office->AdvancedSearch->SearchOperator = @$filter["z_wa_type_office"];
        $this->wa_type_office->AdvancedSearch->SearchCondition = @$filter["v_wa_type_office"];
        $this->wa_type_office->AdvancedSearch->SearchValue2 = @$filter["y_wa_type_office"];
        $this->wa_type_office->AdvancedSearch->SearchOperator2 = @$filter["w_wa_type_office"];
        $this->wa_type_office->AdvancedSearch->save();

        // Field wa_to_office
        $this->wa_to_office->AdvancedSearch->SearchValue = @$filter["x_wa_to_office"];
        $this->wa_to_office->AdvancedSearch->SearchOperator = @$filter["z_wa_to_office"];
        $this->wa_to_office->AdvancedSearch->SearchCondition = @$filter["v_wa_to_office"];
        $this->wa_to_office->AdvancedSearch->SearchValue2 = @$filter["y_wa_to_office"];
        $this->wa_to_office->AdvancedSearch->SearchOperator2 = @$filter["w_wa_to_office"];
        $this->wa_to_office->AdvancedSearch->save();

        // Field wa_template_office
        $this->wa_template_office->AdvancedSearch->SearchValue = @$filter["x_wa_template_office"];
        $this->wa_template_office->AdvancedSearch->SearchOperator = @$filter["z_wa_template_office"];
        $this->wa_template_office->AdvancedSearch->SearchCondition = @$filter["v_wa_template_office"];
        $this->wa_template_office->AdvancedSearch->SearchValue2 = @$filter["y_wa_template_office"];
        $this->wa_template_office->AdvancedSearch->SearchOperator2 = @$filter["w_wa_template_office"];
        $this->wa_template_office->AdvancedSearch->save();

        // Field wa_id
        $this->wa_id->AdvancedSearch->SearchValue = @$filter["x_wa_id"];
        $this->wa_id->AdvancedSearch->SearchOperator = @$filter["z_wa_id"];
        $this->wa_id->AdvancedSearch->SearchCondition = @$filter["v_wa_id"];
        $this->wa_id->AdvancedSearch->SearchValue2 = @$filter["y_wa_id"];
        $this->wa_id->AdvancedSearch->SearchOperator2 = @$filter["w_wa_id"];
        $this->wa_id->AdvancedSearch->save();

        // Field notification_status_user
        $this->notification_status_user->AdvancedSearch->SearchValue = @$filter["x_notification_status_user"];
        $this->notification_status_user->AdvancedSearch->SearchOperator = @$filter["z_notification_status_user"];
        $this->notification_status_user->AdvancedSearch->SearchCondition = @$filter["v_notification_status_user"];
        $this->notification_status_user->AdvancedSearch->SearchValue2 = @$filter["y_notification_status_user"];
        $this->notification_status_user->AdvancedSearch->SearchOperator2 = @$filter["w_notification_status_user"];
        $this->notification_status_user->AdvancedSearch->save();

        // Field notification_template_user
        $this->notification_template_user->AdvancedSearch->SearchValue = @$filter["x_notification_template_user"];
        $this->notification_template_user->AdvancedSearch->SearchOperator = @$filter["z_notification_template_user"];
        $this->notification_template_user->AdvancedSearch->SearchCondition = @$filter["v_notification_template_user"];
        $this->notification_template_user->AdvancedSearch->SearchValue2 = @$filter["y_notification_template_user"];
        $this->notification_template_user->AdvancedSearch->SearchOperator2 = @$filter["w_notification_template_user"];
        $this->notification_template_user->AdvancedSearch->save();

        // Field notification_status_office
        $this->notification_status_office->AdvancedSearch->SearchValue = @$filter["x_notification_status_office"];
        $this->notification_status_office->AdvancedSearch->SearchOperator = @$filter["z_notification_status_office"];
        $this->notification_status_office->AdvancedSearch->SearchCondition = @$filter["v_notification_status_office"];
        $this->notification_status_office->AdvancedSearch->SearchValue2 = @$filter["y_notification_status_office"];
        $this->notification_status_office->AdvancedSearch->SearchOperator2 = @$filter["w_notification_status_office"];
        $this->notification_status_office->AdvancedSearch->save();

        // Field notification_to_office
        $this->notification_to_office->AdvancedSearch->SearchValue = @$filter["x_notification_to_office"];
        $this->notification_to_office->AdvancedSearch->SearchOperator = @$filter["z_notification_to_office"];
        $this->notification_to_office->AdvancedSearch->SearchCondition = @$filter["v_notification_to_office"];
        $this->notification_to_office->AdvancedSearch->SearchValue2 = @$filter["y_notification_to_office"];
        $this->notification_to_office->AdvancedSearch->SearchOperator2 = @$filter["w_notification_to_office"];
        $this->notification_to_office->AdvancedSearch->save();

        // Field notification_template_office
        $this->notification_template_office->AdvancedSearch->SearchValue = @$filter["x_notification_template_office"];
        $this->notification_template_office->AdvancedSearch->SearchOperator = @$filter["z_notification_template_office"];
        $this->notification_template_office->AdvancedSearch->SearchCondition = @$filter["v_notification_template_office"];
        $this->notification_template_office->AdvancedSearch->SearchValue2 = @$filter["y_notification_template_office"];
        $this->notification_template_office->AdvancedSearch->SearchOperator2 = @$filter["w_notification_template_office"];
        $this->notification_template_office->AdvancedSearch->save();

        // Field code
        $this->code->AdvancedSearch->SearchValue = @$filter["x_code"];
        $this->code->AdvancedSearch->SearchOperator = @$filter["z_code"];
        $this->code->AdvancedSearch->SearchCondition = @$filter["v_code"];
        $this->code->AdvancedSearch->SearchValue2 = @$filter["y_code"];
        $this->code->AdvancedSearch->SearchOperator2 = @$filter["w_code"];
        $this->code->AdvancedSearch->save();

        // Field visible
        $this->_visible->AdvancedSearch->SearchValue = @$filter["x__visible"];
        $this->_visible->AdvancedSearch->SearchOperator = @$filter["z__visible"];
        $this->_visible->AdvancedSearch->SearchCondition = @$filter["v__visible"];
        $this->_visible->AdvancedSearch->SearchValue2 = @$filter["y__visible"];
        $this->_visible->AdvancedSearch->SearchOperator2 = @$filter["w__visible"];
        $this->_visible->AdvancedSearch->save();

        // Field cron
        $this->cron->AdvancedSearch->SearchValue = @$filter["x_cron"];
        $this->cron->AdvancedSearch->SearchOperator = @$filter["z_cron"];
        $this->cron->AdvancedSearch->SearchCondition = @$filter["v_cron"];
        $this->cron->AdvancedSearch->SearchValue2 = @$filter["y_cron"];
        $this->cron->AdvancedSearch->SearchOperator2 = @$filter["w_cron"];
        $this->cron->AdvancedSearch->save();

        // Field next_cycle
        $this->next_cycle->AdvancedSearch->SearchValue = @$filter["x_next_cycle"];
        $this->next_cycle->AdvancedSearch->SearchOperator = @$filter["z_next_cycle"];
        $this->next_cycle->AdvancedSearch->SearchCondition = @$filter["v_next_cycle"];
        $this->next_cycle->AdvancedSearch->SearchValue2 = @$filter["y_next_cycle"];
        $this->next_cycle->AdvancedSearch->SearchOperator2 = @$filter["w_next_cycle"];
        $this->next_cycle->AdvancedSearch->save();

        // Field delay
        $this->delay->AdvancedSearch->SearchValue = @$filter["x_delay"];
        $this->delay->AdvancedSearch->SearchOperator = @$filter["z_delay"];
        $this->delay->AdvancedSearch->SearchCondition = @$filter["v_delay"];
        $this->delay->AdvancedSearch->SearchValue2 = @$filter["y_delay"];
        $this->delay->AdvancedSearch->SearchOperator2 = @$filter["w_delay"];
        $this->delay->AdvancedSearch->save();

        // Field delay_method
        $this->delay_method->AdvancedSearch->SearchValue = @$filter["x_delay_method"];
        $this->delay_method->AdvancedSearch->SearchOperator = @$filter["z_delay_method"];
        $this->delay_method->AdvancedSearch->SearchCondition = @$filter["v_delay_method"];
        $this->delay_method->AdvancedSearch->SearchValue2 = @$filter["y_delay_method"];
        $this->delay_method->AdvancedSearch->SearchOperator2 = @$filter["w_delay_method"];
        $this->delay_method->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();

        // Field operator_admin
        $this->operator_admin->AdvancedSearch->SearchValue = @$filter["x_operator_admin"];
        $this->operator_admin->AdvancedSearch->SearchOperator = @$filter["z_operator_admin"];
        $this->operator_admin->AdvancedSearch->SearchCondition = @$filter["v_operator_admin"];
        $this->operator_admin->AdvancedSearch->SearchValue2 = @$filter["y_operator_admin"];
        $this->operator_admin->AdvancedSearch->SearchOperator2 = @$filter["w_operator_admin"];
        $this->operator_admin->AdvancedSearch->save();

        // Field datetime_admin
        $this->datetime_admin->AdvancedSearch->SearchValue = @$filter["x_datetime_admin"];
        $this->datetime_admin->AdvancedSearch->SearchOperator = @$filter["z_datetime_admin"];
        $this->datetime_admin->AdvancedSearch->SearchCondition = @$filter["v_datetime_admin"];
        $this->datetime_admin->AdvancedSearch->SearchValue2 = @$filter["y_datetime_admin"];
        $this->datetime_admin->AdvancedSearch->SearchOperator2 = @$filter["w_datetime_admin"];
        $this->datetime_admin->AdvancedSearch->save();

        // Field company_id
        $this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
        $this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
        $this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
        $this->company_id->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->grp, $default, false); // grp
        $this->buildSearchSql($where, $this->description, $default, false); // description
        $this->buildSearchSql($where, $this->variables, $default, false); // variables
        $this->buildSearchSql($where, $this->subject, $default, false); // subject
        $this->buildSearchSql($where, $this->status_email_user, $default, false); // status_email_user
        $this->buildSearchSql($where, $this->email_template_user, $default, false); // email_template_user
        $this->buildSearchSql($where, $this->mail_to_office, $default, false); // mail_to_office
        $this->buildSearchSql($where, $this->status_email_office, $default, false); // status_email_office
        $this->buildSearchSql($where, $this->email_template_office, $default, false); // email_template_office
        $this->buildSearchSql($where, $this->status_sms_user, $default, false); // status_sms_user
        $this->buildSearchSql($where, $this->sms_template_user, $default, false); // sms_template_user
        $this->buildSearchSql($where, $this->sms_template_user_id, $default, false); // sms_template_user_id
        $this->buildSearchSql($where, $this->status_sms_office, $default, false); // status_sms_office
        $this->buildSearchSql($where, $this->sms_to_office, $default, false); // sms_to_office
        $this->buildSearchSql($where, $this->sms_template_office, $default, false); // sms_template_office
        $this->buildSearchSql($where, $this->sms_template_office_id, $default, false); // sms_template_office_id
        $this->buildSearchSql($where, $this->wa_status_user, $default, false); // wa_status_user
        $this->buildSearchSql($where, $this->wa_type_user, $default, false); // wa_type_user
        $this->buildSearchSql($where, $this->wa_template_user, $default, false); // wa_template_user
        $this->buildSearchSql($where, $this->wa_status_office, $default, false); // wa_status_office
        $this->buildSearchSql($where, $this->wa_type_office, $default, false); // wa_type_office
        $this->buildSearchSql($where, $this->wa_to_office, $default, false); // wa_to_office
        $this->buildSearchSql($where, $this->wa_template_office, $default, false); // wa_template_office
        $this->buildSearchSql($where, $this->wa_id, $default, false); // wa_id
        $this->buildSearchSql($where, $this->notification_status_user, $default, false); // notification_status_user
        $this->buildSearchSql($where, $this->notification_template_user, $default, false); // notification_template_user
        $this->buildSearchSql($where, $this->notification_status_office, $default, false); // notification_status_office
        $this->buildSearchSql($where, $this->notification_to_office, $default, true); // notification_to_office
        $this->buildSearchSql($where, $this->notification_template_office, $default, false); // notification_template_office
        $this->buildSearchSql($where, $this->code, $default, false); // code
        $this->buildSearchSql($where, $this->_visible, $default, false); // visible
        $this->buildSearchSql($where, $this->cron, $default, false); // cron
        $this->buildSearchSql($where, $this->next_cycle, $default, false); // next_cycle
        $this->buildSearchSql($where, $this->delay, $default, false); // delay
        $this->buildSearchSql($where, $this->delay_method, $default, false); // delay_method
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime
        $this->buildSearchSql($where, $this->operator_admin, $default, false); // operator_admin
        $this->buildSearchSql($where, $this->datetime_admin, $default, false); // datetime_admin
        $this->buildSearchSql($where, $this->company_id, $default, false); // company_id

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->grp->AdvancedSearch->save(); // grp
            $this->description->AdvancedSearch->save(); // description
            $this->variables->AdvancedSearch->save(); // variables
            $this->subject->AdvancedSearch->save(); // subject
            $this->status_email_user->AdvancedSearch->save(); // status_email_user
            $this->email_template_user->AdvancedSearch->save(); // email_template_user
            $this->mail_to_office->AdvancedSearch->save(); // mail_to_office
            $this->status_email_office->AdvancedSearch->save(); // status_email_office
            $this->email_template_office->AdvancedSearch->save(); // email_template_office
            $this->status_sms_user->AdvancedSearch->save(); // status_sms_user
            $this->sms_template_user->AdvancedSearch->save(); // sms_template_user
            $this->sms_template_user_id->AdvancedSearch->save(); // sms_template_user_id
            $this->status_sms_office->AdvancedSearch->save(); // status_sms_office
            $this->sms_to_office->AdvancedSearch->save(); // sms_to_office
            $this->sms_template_office->AdvancedSearch->save(); // sms_template_office
            $this->sms_template_office_id->AdvancedSearch->save(); // sms_template_office_id
            $this->wa_status_user->AdvancedSearch->save(); // wa_status_user
            $this->wa_type_user->AdvancedSearch->save(); // wa_type_user
            $this->wa_template_user->AdvancedSearch->save(); // wa_template_user
            $this->wa_status_office->AdvancedSearch->save(); // wa_status_office
            $this->wa_type_office->AdvancedSearch->save(); // wa_type_office
            $this->wa_to_office->AdvancedSearch->save(); // wa_to_office
            $this->wa_template_office->AdvancedSearch->save(); // wa_template_office
            $this->wa_id->AdvancedSearch->save(); // wa_id
            $this->notification_status_user->AdvancedSearch->save(); // notification_status_user
            $this->notification_template_user->AdvancedSearch->save(); // notification_template_user
            $this->notification_status_office->AdvancedSearch->save(); // notification_status_office
            $this->notification_to_office->AdvancedSearch->save(); // notification_to_office
            $this->notification_template_office->AdvancedSearch->save(); // notification_template_office
            $this->code->AdvancedSearch->save(); // code
            $this->_visible->AdvancedSearch->save(); // visible
            $this->cron->AdvancedSearch->save(); // cron
            $this->next_cycle->AdvancedSearch->save(); // next_cycle
            $this->delay->AdvancedSearch->save(); // delay
            $this->delay_method->AdvancedSearch->save(); // delay_method
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->operator_admin->AdvancedSearch->save(); // operator_admin
            $this->datetime_admin->AdvancedSearch->save(); // datetime_admin
            $this->company_id->AdvancedSearch->save(); // company_id

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->grp->AdvancedSearch->save(); // grp
            $this->description->AdvancedSearch->save(); // description
            $this->variables->AdvancedSearch->save(); // variables
            $this->subject->AdvancedSearch->save(); // subject
            $this->status_email_user->AdvancedSearch->save(); // status_email_user
            $this->email_template_user->AdvancedSearch->save(); // email_template_user
            $this->mail_to_office->AdvancedSearch->save(); // mail_to_office
            $this->status_email_office->AdvancedSearch->save(); // status_email_office
            $this->email_template_office->AdvancedSearch->save(); // email_template_office
            $this->status_sms_user->AdvancedSearch->save(); // status_sms_user
            $this->sms_template_user->AdvancedSearch->save(); // sms_template_user
            $this->sms_template_user_id->AdvancedSearch->save(); // sms_template_user_id
            $this->status_sms_office->AdvancedSearch->save(); // status_sms_office
            $this->sms_to_office->AdvancedSearch->save(); // sms_to_office
            $this->sms_template_office->AdvancedSearch->save(); // sms_template_office
            $this->sms_template_office_id->AdvancedSearch->save(); // sms_template_office_id
            $this->wa_status_user->AdvancedSearch->save(); // wa_status_user
            $this->wa_type_user->AdvancedSearch->save(); // wa_type_user
            $this->wa_template_user->AdvancedSearch->save(); // wa_template_user
            $this->wa_status_office->AdvancedSearch->save(); // wa_status_office
            $this->wa_type_office->AdvancedSearch->save(); // wa_type_office
            $this->wa_to_office->AdvancedSearch->save(); // wa_to_office
            $this->wa_template_office->AdvancedSearch->save(); // wa_template_office
            $this->wa_id->AdvancedSearch->save(); // wa_id
            $this->notification_status_user->AdvancedSearch->save(); // notification_status_user
            $this->notification_template_user->AdvancedSearch->save(); // notification_template_user
            $this->notification_status_office->AdvancedSearch->save(); // notification_status_office
            $this->notification_to_office->AdvancedSearch->save(); // notification_to_office
            $this->notification_template_office->AdvancedSearch->save(); // notification_template_office
            $this->code->AdvancedSearch->save(); // code
            $this->_visible->AdvancedSearch->save(); // visible
            $this->cron->AdvancedSearch->save(); // cron
            $this->next_cycle->AdvancedSearch->save(); // next_cycle
            $this->delay->AdvancedSearch->save(); // delay
            $this->delay_method->AdvancedSearch->save(); // delay_method
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->operator_admin->AdvancedSearch->save(); // operator_admin
            $this->datetime_admin->AdvancedSearch->save(); // datetime_admin
            $this->company_id->AdvancedSearch->save(); // company_id
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field grp
        $filter = $this->queryBuilderWhere("grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field description
        $filter = $this->queryBuilderWhere("description");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->description, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->description->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field subject
        $filter = $this->queryBuilderWhere("subject");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->subject, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->subject->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status_email_user
        $filter = $this->queryBuilderWhere("status_email_user");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status_email_user, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status_email_user->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field mail_to_office
        $filter = $this->queryBuilderWhere("mail_to_office");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->mail_to_office, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->mail_to_office->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status_email_office
        $filter = $this->queryBuilderWhere("status_email_office");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status_email_office, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status_email_office->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status_sms_user
        $filter = $this->queryBuilderWhere("status_sms_user");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status_sms_user, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status_sms_user->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sms_template_user_id
        $filter = $this->queryBuilderWhere("sms_template_user_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sms_template_user_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sms_template_user_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sms_to_office
        $filter = $this->queryBuilderWhere("sms_to_office");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sms_to_office, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sms_to_office->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sms_template_office
        $filter = $this->queryBuilderWhere("sms_template_office");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sms_template_office, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sms_template_office->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sms_template_office_id
        $filter = $this->queryBuilderWhere("sms_template_office_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sms_template_office_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sms_template_office_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field wa_status_user
        $filter = $this->queryBuilderWhere("wa_status_user");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->wa_status_user, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->wa_status_user->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field wa_type_user
        $filter = $this->queryBuilderWhere("wa_type_user");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->wa_type_user, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->wa_type_user->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field wa_status_office
        $filter = $this->queryBuilderWhere("wa_status_office");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->wa_status_office, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->wa_status_office->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field wa_type_office
        $filter = $this->queryBuilderWhere("wa_type_office");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->wa_type_office, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->wa_type_office->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field wa_to_office
        $filter = $this->queryBuilderWhere("wa_to_office");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->wa_to_office, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->wa_to_office->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field wa_id
        $filter = $this->queryBuilderWhere("wa_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->wa_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->wa_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field notification_status_user
        $filter = $this->queryBuilderWhere("notification_status_user");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->notification_status_user, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->notification_status_user->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field notification_status_office
        $filter = $this->queryBuilderWhere("notification_status_office");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->notification_status_office, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->notification_status_office->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field notification_to_office
        $filter = $this->queryBuilderWhere("notification_to_office");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->notification_to_office, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->notification_to_office->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field visible
        $filter = $this->queryBuilderWhere("visible");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_visible, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_visible->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field cron
        $filter = $this->queryBuilderWhere("cron");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->cron, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->cron->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field next_cycle
        $filter = $this->queryBuilderWhere("next_cycle");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->next_cycle, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->next_cycle->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field delay
        $filter = $this->queryBuilderWhere("delay");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->delay, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->delay->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field delay_method
        $filter = $this->queryBuilderWhere("delay_method");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->delay_method, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->delay_method->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field operator_admin
        $filter = $this->queryBuilderWhere("operator_admin");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->operator_admin, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->operator_admin->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field datetime_admin
        $filter = $this->queryBuilderWhere("datetime_admin");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->datetime_admin, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datetime_admin->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field company_id
        $filter = $this->queryBuilderWhere("company_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->company_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->company_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->id;
        $searchFlds[] = &$this->description;
        $searchFlds[] = &$this->variables;
        $searchFlds[] = &$this->subject;
        $searchFlds[] = &$this->email_template_user;
        $searchFlds[] = &$this->mail_to_office;
        $searchFlds[] = &$this->email_template_office;
        $searchFlds[] = &$this->sms_template_user;
        $searchFlds[] = &$this->sms_template_user_id;
        $searchFlds[] = &$this->sms_to_office;
        $searchFlds[] = &$this->sms_template_office;
        $searchFlds[] = &$this->sms_template_office_id;
        $searchFlds[] = &$this->wa_template_user;
        $searchFlds[] = &$this->wa_to_office;
        $searchFlds[] = &$this->wa_template_office;
        $searchFlds[] = &$this->notification_template_user;
        $searchFlds[] = &$this->notification_to_office;
        $searchFlds[] = &$this->notification_template_office;
        $searchFlds[] = &$this->code;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->description->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->variables->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->subject->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status_email_user->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->email_template_user->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->mail_to_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status_email_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->email_template_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status_sms_user->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sms_template_user->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sms_template_user_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status_sms_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sms_to_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sms_template_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sms_template_office_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->wa_status_user->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->wa_type_user->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->wa_template_user->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->wa_status_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->wa_type_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->wa_to_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->wa_template_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->wa_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->notification_status_user->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->notification_template_user->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->notification_status_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->notification_to_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->notification_template_office->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_visible->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->cron->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->next_cycle->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->delay->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->delay_method->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator_admin->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime_admin->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->company_id->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->description->AdvancedSearch->unsetSession();
        $this->variables->AdvancedSearch->unsetSession();
        $this->subject->AdvancedSearch->unsetSession();
        $this->status_email_user->AdvancedSearch->unsetSession();
        $this->email_template_user->AdvancedSearch->unsetSession();
        $this->mail_to_office->AdvancedSearch->unsetSession();
        $this->status_email_office->AdvancedSearch->unsetSession();
        $this->email_template_office->AdvancedSearch->unsetSession();
        $this->status_sms_user->AdvancedSearch->unsetSession();
        $this->sms_template_user->AdvancedSearch->unsetSession();
        $this->sms_template_user_id->AdvancedSearch->unsetSession();
        $this->status_sms_office->AdvancedSearch->unsetSession();
        $this->sms_to_office->AdvancedSearch->unsetSession();
        $this->sms_template_office->AdvancedSearch->unsetSession();
        $this->sms_template_office_id->AdvancedSearch->unsetSession();
        $this->wa_status_user->AdvancedSearch->unsetSession();
        $this->wa_type_user->AdvancedSearch->unsetSession();
        $this->wa_template_user->AdvancedSearch->unsetSession();
        $this->wa_status_office->AdvancedSearch->unsetSession();
        $this->wa_type_office->AdvancedSearch->unsetSession();
        $this->wa_to_office->AdvancedSearch->unsetSession();
        $this->wa_template_office->AdvancedSearch->unsetSession();
        $this->wa_id->AdvancedSearch->unsetSession();
        $this->notification_status_user->AdvancedSearch->unsetSession();
        $this->notification_template_user->AdvancedSearch->unsetSession();
        $this->notification_status_office->AdvancedSearch->unsetSession();
        $this->notification_to_office->AdvancedSearch->unsetSession();
        $this->notification_template_office->AdvancedSearch->unsetSession();
        $this->code->AdvancedSearch->unsetSession();
        $this->_visible->AdvancedSearch->unsetSession();
        $this->cron->AdvancedSearch->unsetSession();
        $this->next_cycle->AdvancedSearch->unsetSession();
        $this->delay->AdvancedSearch->unsetSession();
        $this->delay_method->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
        $this->operator_admin->AdvancedSearch->unsetSession();
        $this->datetime_admin->AdvancedSearch->unsetSession();
        $this->company_id->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->variables->AdvancedSearch->load();
        $this->subject->AdvancedSearch->load();
        $this->status_email_user->AdvancedSearch->load();
        $this->email_template_user->AdvancedSearch->load();
        $this->mail_to_office->AdvancedSearch->load();
        $this->status_email_office->AdvancedSearch->load();
        $this->email_template_office->AdvancedSearch->load();
        $this->status_sms_user->AdvancedSearch->load();
        $this->sms_template_user->AdvancedSearch->load();
        $this->sms_template_user_id->AdvancedSearch->load();
        $this->status_sms_office->AdvancedSearch->load();
        $this->sms_to_office->AdvancedSearch->load();
        $this->sms_template_office->AdvancedSearch->load();
        $this->sms_template_office_id->AdvancedSearch->load();
        $this->wa_status_user->AdvancedSearch->load();
        $this->wa_type_user->AdvancedSearch->load();
        $this->wa_template_user->AdvancedSearch->load();
        $this->wa_status_office->AdvancedSearch->load();
        $this->wa_type_office->AdvancedSearch->load();
        $this->wa_to_office->AdvancedSearch->load();
        $this->wa_template_office->AdvancedSearch->load();
        $this->wa_id->AdvancedSearch->load();
        $this->notification_status_user->AdvancedSearch->load();
        $this->notification_template_user->AdvancedSearch->load();
        $this->notification_status_office->AdvancedSearch->load();
        $this->notification_to_office->AdvancedSearch->load();
        $this->notification_template_office->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->_visible->AdvancedSearch->load();
        $this->cron->AdvancedSearch->load();
        $this->next_cycle->AdvancedSearch->load();
        $this->delay->AdvancedSearch->load();
        $this->delay_method->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->operator_admin->AdvancedSearch->load();
        $this->datetime_admin->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " ASC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->grp, $ctrl); // grp
            $this->updateSort($this->description, $ctrl); // description
            $this->updateSort($this->subject, $ctrl); // subject
            $this->updateSort($this->status_email_user, $ctrl); // status_email_user
            $this->updateSort($this->mail_to_office, $ctrl); // mail_to_office
            $this->updateSort($this->status_email_office, $ctrl); // status_email_office
            $this->updateSort($this->status_sms_user, $ctrl); // status_sms_user
            $this->updateSort($this->sms_template_user_id, $ctrl); // sms_template_user_id
            $this->updateSort($this->sms_to_office, $ctrl); // sms_to_office
            $this->updateSort($this->sms_template_office, $ctrl); // sms_template_office
            $this->updateSort($this->sms_template_office_id, $ctrl); // sms_template_office_id
            $this->updateSort($this->wa_status_user, $ctrl); // wa_status_user
            $this->updateSort($this->wa_type_user, $ctrl); // wa_type_user
            $this->updateSort($this->wa_status_office, $ctrl); // wa_status_office
            $this->updateSort($this->wa_type_office, $ctrl); // wa_type_office
            $this->updateSort($this->wa_to_office, $ctrl); // wa_to_office
            $this->updateSort($this->wa_id, $ctrl); // wa_id
            $this->updateSort($this->notification_status_user, $ctrl); // notification_status_user
            $this->updateSort($this->notification_status_office, $ctrl); // notification_status_office
            $this->updateSort($this->notification_to_office, $ctrl); // notification_to_office
            $this->updateSort($this->_visible, $ctrl); // visible
            $this->updateSort($this->cron, $ctrl); // cron
            $this->updateSort($this->next_cycle, $ctrl); // next_cycle
            $this->updateSort($this->delay, $ctrl); // delay
            $this->updateSort($this->delay_method, $ctrl); // delay_method
            $this->updateSort($this->operator_admin, $ctrl); // operator_admin
            $this->updateSort($this->datetime_admin, $ctrl); // datetime_admin
            $this->updateSort($this->company_id, $ctrl); // company_id
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->grp->setSort("");
                $this->description->setSort("");
                $this->variables->setSort("");
                $this->subject->setSort("");
                $this->status_email_user->setSort("");
                $this->email_template_user->setSort("");
                $this->mail_to_office->setSort("");
                $this->status_email_office->setSort("");
                $this->email_template_office->setSort("");
                $this->status_sms_user->setSort("");
                $this->sms_template_user->setSort("");
                $this->sms_template_user_id->setSort("");
                $this->status_sms_office->setSort("");
                $this->sms_to_office->setSort("");
                $this->sms_template_office->setSort("");
                $this->sms_template_office_id->setSort("");
                $this->wa_status_user->setSort("");
                $this->wa_type_user->setSort("");
                $this->wa_template_user->setSort("");
                $this->wa_status_office->setSort("");
                $this->wa_type_office->setSort("");
                $this->wa_to_office->setSort("");
                $this->wa_template_office->setSort("");
                $this->wa_id->setSort("");
                $this->notification_status_user->setSort("");
                $this->notification_template_user->setSort("");
                $this->notification_status_office->setSort("");
                $this->notification_to_office->setSort("");
                $this->notification_template_office->setSort("");
                $this->code->setSort("");
                $this->_visible->setSort("");
                $this->cron->setSort("");
                $this->next_cycle->setSort("");
                $this->delay->setSort("");
                $this->delay_method->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->operator_admin->setSort("");
                $this->datetime_admin->setSort("");
                $this->company_id->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"message_template_admin\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"message_template_admin\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"message_template_admin\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fmessage_template_adminlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fmessage_template_adminlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"message_template_admin\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "grp");
            $this->createColumnOption($option, "description");
            $this->createColumnOption($option, "subject");
            $this->createColumnOption($option, "status_email_user");
            $this->createColumnOption($option, "mail_to_office");
            $this->createColumnOption($option, "status_email_office");
            $this->createColumnOption($option, "status_sms_user");
            $this->createColumnOption($option, "sms_template_user_id");
            $this->createColumnOption($option, "sms_to_office");
            $this->createColumnOption($option, "sms_template_office");
            $this->createColumnOption($option, "sms_template_office_id");
            $this->createColumnOption($option, "wa_status_user");
            $this->createColumnOption($option, "wa_type_user");
            $this->createColumnOption($option, "wa_status_office");
            $this->createColumnOption($option, "wa_type_office");
            $this->createColumnOption($option, "wa_to_office");
            $this->createColumnOption($option, "wa_id");
            $this->createColumnOption($option, "notification_status_user");
            $this->createColumnOption($option, "notification_status_office");
            $this->createColumnOption($option, "notification_to_office");
            $this->createColumnOption($option, "visible");
            $this->createColumnOption($option, "cron");
            $this->createColumnOption($option, "next_cycle");
            $this->createColumnOption($option, "delay");
            $this->createColumnOption($option, "delay_method");
            $this->createColumnOption($option, "operator_admin");
            $this->createColumnOption($option, "datetime_admin");
            $this->createColumnOption($option, "company_id");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fmessage_template_adminsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fmessage_template_adminsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fmessage_template_adminlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_message_template_admin", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_message_template_admin",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // description
        if ($this->description->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->description->AdvancedSearch->SearchValue != "" || $this->description->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // variables
        if ($this->variables->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->variables->AdvancedSearch->SearchValue != "" || $this->variables->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // subject
        if ($this->subject->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->subject->AdvancedSearch->SearchValue != "" || $this->subject->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status_email_user
        if ($this->status_email_user->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status_email_user->AdvancedSearch->SearchValue != "" || $this->status_email_user->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // email_template_user
        if ($this->email_template_user->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->email_template_user->AdvancedSearch->SearchValue != "" || $this->email_template_user->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // mail_to_office
        if ($this->mail_to_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->mail_to_office->AdvancedSearch->SearchValue != "" || $this->mail_to_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status_email_office
        if ($this->status_email_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status_email_office->AdvancedSearch->SearchValue != "" || $this->status_email_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // email_template_office
        if ($this->email_template_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->email_template_office->AdvancedSearch->SearchValue != "" || $this->email_template_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status_sms_user
        if ($this->status_sms_user->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status_sms_user->AdvancedSearch->SearchValue != "" || $this->status_sms_user->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sms_template_user
        if ($this->sms_template_user->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sms_template_user->AdvancedSearch->SearchValue != "" || $this->sms_template_user->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sms_template_user_id
        if ($this->sms_template_user_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sms_template_user_id->AdvancedSearch->SearchValue != "" || $this->sms_template_user_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status_sms_office
        if ($this->status_sms_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status_sms_office->AdvancedSearch->SearchValue != "" || $this->status_sms_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sms_to_office
        if ($this->sms_to_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sms_to_office->AdvancedSearch->SearchValue != "" || $this->sms_to_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sms_template_office
        if ($this->sms_template_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sms_template_office->AdvancedSearch->SearchValue != "" || $this->sms_template_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sms_template_office_id
        if ($this->sms_template_office_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sms_template_office_id->AdvancedSearch->SearchValue != "" || $this->sms_template_office_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // wa_status_user
        if ($this->wa_status_user->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->wa_status_user->AdvancedSearch->SearchValue != "" || $this->wa_status_user->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // wa_type_user
        if ($this->wa_type_user->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->wa_type_user->AdvancedSearch->SearchValue != "" || $this->wa_type_user->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // wa_template_user
        if ($this->wa_template_user->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->wa_template_user->AdvancedSearch->SearchValue != "" || $this->wa_template_user->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // wa_status_office
        if ($this->wa_status_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->wa_status_office->AdvancedSearch->SearchValue != "" || $this->wa_status_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // wa_type_office
        if ($this->wa_type_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->wa_type_office->AdvancedSearch->SearchValue != "" || $this->wa_type_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // wa_to_office
        if ($this->wa_to_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->wa_to_office->AdvancedSearch->SearchValue != "" || $this->wa_to_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // wa_template_office
        if ($this->wa_template_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->wa_template_office->AdvancedSearch->SearchValue != "" || $this->wa_template_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // wa_id
        if ($this->wa_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->wa_id->AdvancedSearch->SearchValue != "" || $this->wa_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // notification_status_user
        if ($this->notification_status_user->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->notification_status_user->AdvancedSearch->SearchValue != "" || $this->notification_status_user->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // notification_template_user
        if ($this->notification_template_user->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->notification_template_user->AdvancedSearch->SearchValue != "" || $this->notification_template_user->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // notification_status_office
        if ($this->notification_status_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->notification_status_office->AdvancedSearch->SearchValue != "" || $this->notification_status_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // notification_to_office
        if ($this->notification_to_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->notification_to_office->AdvancedSearch->SearchValue != "" || $this->notification_to_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->notification_to_office->AdvancedSearch->SearchValue)) {
            $this->notification_to_office->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->notification_to_office->AdvancedSearch->SearchValue);
        }
        if (is_array($this->notification_to_office->AdvancedSearch->SearchValue2)) {
            $this->notification_to_office->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->notification_to_office->AdvancedSearch->SearchValue2);
        }

        // notification_template_office
        if ($this->notification_template_office->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->notification_template_office->AdvancedSearch->SearchValue != "" || $this->notification_template_office->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // code
        if ($this->code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->code->AdvancedSearch->SearchValue != "" || $this->code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // visible
        if ($this->_visible->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_visible->AdvancedSearch->SearchValue != "" || $this->_visible->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // cron
        if ($this->cron->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->cron->AdvancedSearch->SearchValue != "" || $this->cron->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // next_cycle
        if ($this->next_cycle->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->next_cycle->AdvancedSearch->SearchValue != "" || $this->next_cycle->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // delay
        if ($this->delay->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->delay->AdvancedSearch->SearchValue != "" || $this->delay->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // delay_method
        if ($this->delay_method->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->delay_method->AdvancedSearch->SearchValue != "" || $this->delay_method->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator_admin
        if ($this->operator_admin->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator_admin->AdvancedSearch->SearchValue != "" || $this->operator_admin->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime_admin
        if ($this->datetime_admin->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime_admin->AdvancedSearch->SearchValue != "" || $this->datetime_admin->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->company_id->AdvancedSearch->SearchValue != "" || $this->company_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->description->setDbValue($row['description']);
        $this->variables->setDbValue($row['variables']);
        $this->subject->setDbValue($row['subject']);
        $this->status_email_user->setDbValue($row['status_email_user']);
        $this->email_template_user->setDbValue($row['email_template_user']);
        $this->mail_to_office->setDbValue($row['mail_to_office']);
        $this->status_email_office->setDbValue($row['status_email_office']);
        $this->email_template_office->setDbValue($row['email_template_office']);
        $this->status_sms_user->setDbValue($row['status_sms_user']);
        $this->sms_template_user->setDbValue($row['sms_template_user']);
        $this->sms_template_user_id->setDbValue($row['sms_template_user_id']);
        $this->status_sms_office->setDbValue($row['status_sms_office']);
        $this->sms_to_office->setDbValue($row['sms_to_office']);
        $this->sms_template_office->setDbValue($row['sms_template_office']);
        $this->sms_template_office_id->setDbValue($row['sms_template_office_id']);
        $this->wa_status_user->setDbValue($row['wa_status_user']);
        $this->wa_type_user->setDbValue($row['wa_type_user']);
        $this->wa_template_user->setDbValue($row['wa_template_user']);
        $this->wa_status_office->setDbValue($row['wa_status_office']);
        $this->wa_type_office->setDbValue($row['wa_type_office']);
        $this->wa_to_office->setDbValue($row['wa_to_office']);
        $this->wa_template_office->setDbValue($row['wa_template_office']);
        $this->wa_id->setDbValue($row['wa_id']);
        $this->notification_status_user->setDbValue($row['notification_status_user']);
        $this->notification_template_user->setDbValue($row['notification_template_user']);
        $this->notification_status_office->setDbValue($row['notification_status_office']);
        $this->notification_to_office->setDbValue($row['notification_to_office']);
        $this->notification_template_office->setDbValue($row['notification_template_office']);
        $this->code->setDbValue($row['code']);
        $this->_visible->setDbValue($row['visible']);
        $this->cron->setDbValue($row['cron']);
        $this->next_cycle->setDbValue($row['next_cycle']);
        $this->delay->setDbValue($row['delay']);
        $this->delay_method->setDbValue($row['delay_method']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->operator_admin->setDbValue($row['operator_admin']);
        $this->datetime_admin->setDbValue($row['datetime_admin']);
        $this->company_id->setDbValue($row['company_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['variables'] = $this->variables->DefaultValue;
        $row['subject'] = $this->subject->DefaultValue;
        $row['status_email_user'] = $this->status_email_user->DefaultValue;
        $row['email_template_user'] = $this->email_template_user->DefaultValue;
        $row['mail_to_office'] = $this->mail_to_office->DefaultValue;
        $row['status_email_office'] = $this->status_email_office->DefaultValue;
        $row['email_template_office'] = $this->email_template_office->DefaultValue;
        $row['status_sms_user'] = $this->status_sms_user->DefaultValue;
        $row['sms_template_user'] = $this->sms_template_user->DefaultValue;
        $row['sms_template_user_id'] = $this->sms_template_user_id->DefaultValue;
        $row['status_sms_office'] = $this->status_sms_office->DefaultValue;
        $row['sms_to_office'] = $this->sms_to_office->DefaultValue;
        $row['sms_template_office'] = $this->sms_template_office->DefaultValue;
        $row['sms_template_office_id'] = $this->sms_template_office_id->DefaultValue;
        $row['wa_status_user'] = $this->wa_status_user->DefaultValue;
        $row['wa_type_user'] = $this->wa_type_user->DefaultValue;
        $row['wa_template_user'] = $this->wa_template_user->DefaultValue;
        $row['wa_status_office'] = $this->wa_status_office->DefaultValue;
        $row['wa_type_office'] = $this->wa_type_office->DefaultValue;
        $row['wa_to_office'] = $this->wa_to_office->DefaultValue;
        $row['wa_template_office'] = $this->wa_template_office->DefaultValue;
        $row['wa_id'] = $this->wa_id->DefaultValue;
        $row['notification_status_user'] = $this->notification_status_user->DefaultValue;
        $row['notification_template_user'] = $this->notification_template_user->DefaultValue;
        $row['notification_status_office'] = $this->notification_status_office->DefaultValue;
        $row['notification_to_office'] = $this->notification_to_office->DefaultValue;
        $row['notification_template_office'] = $this->notification_template_office->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['visible'] = $this->_visible->DefaultValue;
        $row['cron'] = $this->cron->DefaultValue;
        $row['next_cycle'] = $this->next_cycle->DefaultValue;
        $row['delay'] = $this->delay->DefaultValue;
        $row['delay_method'] = $this->delay_method->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['operator_admin'] = $this->operator_admin->DefaultValue;
        $row['datetime_admin'] = $this->datetime_admin->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // grp

        // description

        // variables

        // subject

        // status_email_user

        // email_template_user

        // mail_to_office

        // status_email_office

        // email_template_office

        // status_sms_user

        // sms_template_user

        // sms_template_user_id

        // status_sms_office

        // sms_to_office

        // sms_template_office

        // sms_template_office_id

        // wa_status_user

        // wa_type_user

        // wa_template_user

        // wa_status_office

        // wa_type_office

        // wa_to_office

        // wa_template_office

        // wa_id

        // notification_status_user

        // notification_template_user

        // notification_status_office

        // notification_to_office

        // notification_template_office

        // code

        // visible

        // cron

        // next_cycle

        // delay

        // delay_method

        // operator

        // datetime

        // operator_admin

        // datetime_admin

        // company_id

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // variables
            $this->variables->ViewValue = $this->variables->CurrentValue;

            // subject
            $this->subject->ViewValue = $this->subject->CurrentValue;

            // status_email_user
            if (strval($this->status_email_user->CurrentValue) != "") {
                $this->status_email_user->ViewValue = $this->status_email_user->optionCaption($this->status_email_user->CurrentValue);
            } else {
                $this->status_email_user->ViewValue = null;
            }

            // email_template_user
            $this->email_template_user->ViewValue = $this->email_template_user->CurrentValue;

            // mail_to_office
            $this->mail_to_office->ViewValue = $this->mail_to_office->CurrentValue;

            // status_email_office
            if (strval($this->status_email_office->CurrentValue) != "") {
                $this->status_email_office->ViewValue = $this->status_email_office->optionCaption($this->status_email_office->CurrentValue);
            } else {
                $this->status_email_office->ViewValue = null;
            }

            // status_sms_user
            if (strval($this->status_sms_user->CurrentValue) != "") {
                $this->status_sms_user->ViewValue = $this->status_sms_user->optionCaption($this->status_sms_user->CurrentValue);
            } else {
                $this->status_sms_user->ViewValue = null;
            }

            // sms_template_user
            $this->sms_template_user->ViewValue = $this->sms_template_user->CurrentValue;

            // sms_template_user_id
            $this->sms_template_user_id->ViewValue = $this->sms_template_user_id->CurrentValue;

            // status_sms_office
            if (strval($this->status_sms_office->CurrentValue) != "") {
                $this->status_sms_office->ViewValue = $this->status_sms_office->optionCaption($this->status_sms_office->CurrentValue);
            } else {
                $this->status_sms_office->ViewValue = null;
            }

            // sms_to_office
            $this->sms_to_office->ViewValue = $this->sms_to_office->CurrentValue;

            // sms_template_office
            $this->sms_template_office->ViewValue = $this->sms_template_office->CurrentValue;

            // sms_template_office_id
            $this->sms_template_office_id->ViewValue = $this->sms_template_office_id->CurrentValue;

            // wa_status_user
            if (strval($this->wa_status_user->CurrentValue) != "") {
                $this->wa_status_user->ViewValue = $this->wa_status_user->optionCaption($this->wa_status_user->CurrentValue);
            } else {
                $this->wa_status_user->ViewValue = null;
            }

            // wa_type_user
            $curVal = strval($this->wa_type_user->CurrentValue);
            if ($curVal != "") {
                $this->wa_type_user->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
                if ($this->wa_type_user->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_type_user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->wa_type_user->getSelectFilter($this); // PHP
                    $sqlWrk = $this->wa_type_user->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_type_user->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_type_user->ViewValue = $this->wa_type_user->displayValue($arwrk);
                    } else {
                        $this->wa_type_user->ViewValue = FormatNumber($this->wa_type_user->CurrentValue, $this->wa_type_user->formatPattern());
                    }
                }
            } else {
                $this->wa_type_user->ViewValue = null;
            }

            // wa_status_office
            if (strval($this->wa_status_office->CurrentValue) != "") {
                $this->wa_status_office->ViewValue = $this->wa_status_office->optionCaption($this->wa_status_office->CurrentValue);
            } else {
                $this->wa_status_office->ViewValue = null;
            }

            // wa_type_office
            $curVal = strval($this->wa_type_office->CurrentValue);
            if ($curVal != "") {
                $this->wa_type_office->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
                if ($this->wa_type_office->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_type_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_office->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->wa_type_office->getSelectFilter($this); // PHP
                    $sqlWrk = $this->wa_type_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_type_office->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_type_office->ViewValue = $this->wa_type_office->displayValue($arwrk);
                    } else {
                        $this->wa_type_office->ViewValue = FormatNumber($this->wa_type_office->CurrentValue, $this->wa_type_office->formatPattern());
                    }
                }
            } else {
                $this->wa_type_office->ViewValue = null;
            }

            // wa_to_office
            $this->wa_to_office->ViewValue = $this->wa_to_office->CurrentValue;

            // wa_id
            $curVal = strval($this->wa_id->CurrentValue);
            if ($curVal != "") {
                $this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
                if ($this->wa_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->wa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_id->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
                    } else {
                        $this->wa_id->ViewValue = FormatNumber($this->wa_id->CurrentValue, $this->wa_id->formatPattern());
                    }
                }
            } else {
                $this->wa_id->ViewValue = null;
            }

            // notification_status_user
            if (strval($this->notification_status_user->CurrentValue) != "") {
                $this->notification_status_user->ViewValue = $this->notification_status_user->optionCaption($this->notification_status_user->CurrentValue);
            } else {
                $this->notification_status_user->ViewValue = null;
            }

            // notification_template_user
            $this->notification_template_user->ViewValue = $this->notification_template_user->CurrentValue;

            // notification_status_office
            if (strval($this->notification_status_office->CurrentValue) != "") {
                $this->notification_status_office->ViewValue = $this->notification_status_office->optionCaption($this->notification_status_office->CurrentValue);
            } else {
                $this->notification_status_office->ViewValue = null;
            }

            // notification_to_office
            $curVal = strval($this->notification_to_office->CurrentValue);
            if ($curVal != "") {
                $this->notification_to_office->ViewValue = $this->notification_to_office->lookupCacheOption($curVal);
                if ($this->notification_to_office->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->notification_to_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->notification_to_office->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->notification_to_office->getSelectFilter($this); // PHP
                    $sqlWrk = $this->notification_to_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->notification_to_office->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->notification_to_office->Lookup->renderViewRow($row);
                            $this->notification_to_office->ViewValue->add($this->notification_to_office->displayValue($arwrk));
                        }
                    } else {
                        $this->notification_to_office->ViewValue = $this->notification_to_office->CurrentValue;
                    }
                }
            } else {
                $this->notification_to_office->ViewValue = null;
            }

            // notification_template_office
            $this->notification_template_office->ViewValue = $this->notification_template_office->CurrentValue;

            // visible
            if (strval($this->_visible->CurrentValue) != "") {
                $this->_visible->ViewValue = $this->_visible->optionCaption($this->_visible->CurrentValue);
            } else {
                $this->_visible->ViewValue = null;
            }

            // cron
            if (strval($this->cron->CurrentValue) != "") {
                $this->cron->ViewValue = $this->cron->optionCaption($this->cron->CurrentValue);
            } else {
                $this->cron->ViewValue = null;
            }

            // next_cycle
            $this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
            $this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, $this->next_cycle->formatPattern());

            // delay
            $this->delay->ViewValue = $this->delay->CurrentValue;
            $this->delay->ViewValue = FormatNumber($this->delay->ViewValue, $this->delay->formatPattern());

            // delay_method
            if (strval($this->delay_method->CurrentValue) != "") {
                $this->delay_method->ViewValue = $this->delay_method->optionCaption($this->delay_method->CurrentValue);
            } else {
                $this->delay_method->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // operator_admin
            $this->operator_admin->ViewValue = $this->operator_admin->CurrentValue;

            // datetime_admin
            $this->datetime_admin->ViewValue = $this->datetime_admin->CurrentValue;
            $this->datetime_admin->ViewValue = FormatDateTime($this->datetime_admin->ViewValue, $this->datetime_admin->formatPattern());

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // description
            if (!EmptyValue($this->id->CurrentValue)) {
                $this->description->HrefValue = $this->description->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
                $this->description->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
                }
            } else {
                $this->description->HrefValue = "";
            }
            $this->description->TooltipValue = "";
            if (!$this->isExport()) {
                $this->description->ViewValue = $this->highlightValue($this->description);
            }

            // subject
            $this->subject->HrefValue = "";
            $this->subject->TooltipValue = "";
            if (!$this->isExport()) {
                $this->subject->ViewValue = $this->highlightValue($this->subject);
            }

            // status_email_user
            $this->status_email_user->HrefValue = "";
            $this->status_email_user->TooltipValue = "";

            // mail_to_office
            $this->mail_to_office->HrefValue = "";
            $this->mail_to_office->TooltipValue = "";
            if (!$this->isExport()) {
                $this->mail_to_office->ViewValue = $this->highlightValue($this->mail_to_office);
            }

            // status_email_office
            $this->status_email_office->HrefValue = "";
            $this->status_email_office->TooltipValue = "";

            // status_sms_user
            $this->status_sms_user->HrefValue = "";
            $this->status_sms_user->TooltipValue = "";

            // sms_template_user_id
            $this->sms_template_user_id->HrefValue = "";
            $this->sms_template_user_id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->sms_template_user_id->ViewValue = $this->highlightValue($this->sms_template_user_id);
            }

            // sms_to_office
            $this->sms_to_office->HrefValue = "";
            $this->sms_to_office->TooltipValue = "";
            if (!$this->isExport()) {
                $this->sms_to_office->ViewValue = $this->highlightValue($this->sms_to_office);
            }

            // sms_template_office
            $this->sms_template_office->HrefValue = "";
            $this->sms_template_office->TooltipValue = "";
            if (!$this->isExport()) {
                $this->sms_template_office->ViewValue = $this->highlightValue($this->sms_template_office);
            }

            // sms_template_office_id
            $this->sms_template_office_id->HrefValue = "";
            $this->sms_template_office_id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->sms_template_office_id->ViewValue = $this->highlightValue($this->sms_template_office_id);
            }

            // wa_status_user
            $this->wa_status_user->HrefValue = "";
            $this->wa_status_user->TooltipValue = "";

            // wa_type_user
            $this->wa_type_user->HrefValue = "";
            $this->wa_type_user->TooltipValue = "";

            // wa_status_office
            $this->wa_status_office->HrefValue = "";
            $this->wa_status_office->TooltipValue = "";

            // wa_type_office
            $this->wa_type_office->HrefValue = "";
            $this->wa_type_office->TooltipValue = "";

            // wa_to_office
            $this->wa_to_office->HrefValue = "";
            $this->wa_to_office->TooltipValue = "";
            if (!$this->isExport()) {
                $this->wa_to_office->ViewValue = $this->highlightValue($this->wa_to_office);
            }

            // wa_id
            $this->wa_id->HrefValue = "";
            $this->wa_id->TooltipValue = "";

            // notification_status_user
            $this->notification_status_user->HrefValue = "";
            $this->notification_status_user->TooltipValue = "";

            // notification_status_office
            $this->notification_status_office->HrefValue = "";
            $this->notification_status_office->TooltipValue = "";

            // notification_to_office
            $this->notification_to_office->HrefValue = "";
            $this->notification_to_office->TooltipValue = "";

            // visible
            $this->_visible->HrefValue = "";
            $this->_visible->TooltipValue = "";

            // cron
            $this->cron->HrefValue = "";
            $this->cron->TooltipValue = "";

            // next_cycle
            $this->next_cycle->HrefValue = "";
            $this->next_cycle->TooltipValue = "";
            if (!$this->isExport()) {
                $this->next_cycle->ViewValue = $this->highlightValue($this->next_cycle);
            }

            // delay
            $this->delay->HrefValue = "";
            $this->delay->TooltipValue = "";

            // delay_method
            $this->delay_method->HrefValue = "";
            $this->delay_method->TooltipValue = "";

            // operator_admin
            $this->operator_admin->HrefValue = "";
            $this->operator_admin->TooltipValue = "";
            if (!$this->isExport()) {
                $this->operator_admin->ViewValue = $this->highlightValue($this->operator_admin);
            }

            // datetime_admin
            $this->datetime_admin->HrefValue = "";
            $this->datetime_admin->TooltipValue = "";
            if (!$this->isExport()) {
                $this->datetime_admin->ViewValue = $this->highlightValue($this->datetime_admin);
            }

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->AdvancedSearch->SearchValue = HtmlDecode($this->description->AdvancedSearch->SearchValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // subject
            $this->subject->setupEditAttributes();
            if (!$this->subject->Raw) {
                $this->subject->AdvancedSearch->SearchValue = HtmlDecode($this->subject->AdvancedSearch->SearchValue);
            }
            $this->subject->EditValue = HtmlEncode($this->subject->AdvancedSearch->SearchValue);
            $this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

            // status_email_user
            $this->status_email_user->setupEditAttributes();
            $this->status_email_user->EditValue = $this->status_email_user->options(true);
            $this->status_email_user->PlaceHolder = RemoveHtml($this->status_email_user->caption());

            // mail_to_office
            $this->mail_to_office->setupEditAttributes();
            if (!$this->mail_to_office->Raw) {
                $this->mail_to_office->AdvancedSearch->SearchValue = HtmlDecode($this->mail_to_office->AdvancedSearch->SearchValue);
            }
            $this->mail_to_office->EditValue = HtmlEncode($this->mail_to_office->AdvancedSearch->SearchValue);
            $this->mail_to_office->PlaceHolder = RemoveHtml($this->mail_to_office->caption());

            // status_email_office
            $this->status_email_office->setupEditAttributes();
            $this->status_email_office->EditValue = $this->status_email_office->options(true);
            $this->status_email_office->PlaceHolder = RemoveHtml($this->status_email_office->caption());

            // status_sms_user
            $this->status_sms_user->setupEditAttributes();
            $this->status_sms_user->EditValue = $this->status_sms_user->options(true);
            $this->status_sms_user->PlaceHolder = RemoveHtml($this->status_sms_user->caption());

            // sms_template_user_id
            $this->sms_template_user_id->setupEditAttributes();
            if (!$this->sms_template_user_id->Raw) {
                $this->sms_template_user_id->AdvancedSearch->SearchValue = HtmlDecode($this->sms_template_user_id->AdvancedSearch->SearchValue);
            }
            $this->sms_template_user_id->EditValue = HtmlEncode($this->sms_template_user_id->AdvancedSearch->SearchValue);
            $this->sms_template_user_id->PlaceHolder = RemoveHtml($this->sms_template_user_id->caption());

            // sms_to_office
            $this->sms_to_office->setupEditAttributes();
            if (!$this->sms_to_office->Raw) {
                $this->sms_to_office->AdvancedSearch->SearchValue = HtmlDecode($this->sms_to_office->AdvancedSearch->SearchValue);
            }
            $this->sms_to_office->EditValue = HtmlEncode($this->sms_to_office->AdvancedSearch->SearchValue);
            $this->sms_to_office->PlaceHolder = RemoveHtml($this->sms_to_office->caption());

            // sms_template_office
            $this->sms_template_office->setupEditAttributes();
            $this->sms_template_office->EditValue = HtmlEncode($this->sms_template_office->AdvancedSearch->SearchValue);
            $this->sms_template_office->PlaceHolder = RemoveHtml($this->sms_template_office->caption());

            // sms_template_office_id
            $this->sms_template_office_id->setupEditAttributes();
            if (!$this->sms_template_office_id->Raw) {
                $this->sms_template_office_id->AdvancedSearch->SearchValue = HtmlDecode($this->sms_template_office_id->AdvancedSearch->SearchValue);
            }
            $this->sms_template_office_id->EditValue = HtmlEncode($this->sms_template_office_id->AdvancedSearch->SearchValue);
            $this->sms_template_office_id->PlaceHolder = RemoveHtml($this->sms_template_office_id->caption());

            // wa_status_user
            $this->wa_status_user->setupEditAttributes();
            $this->wa_status_user->EditValue = $this->wa_status_user->options(true);
            $this->wa_status_user->PlaceHolder = RemoveHtml($this->wa_status_user->caption());

            // wa_type_user
            $this->wa_type_user->setupEditAttributes();
            $this->wa_type_user->PlaceHolder = RemoveHtml($this->wa_type_user->caption());

            // wa_status_office
            $this->wa_status_office->setupEditAttributes();
            $this->wa_status_office->EditValue = $this->wa_status_office->options(true);
            $this->wa_status_office->PlaceHolder = RemoveHtml($this->wa_status_office->caption());

            // wa_type_office
            $this->wa_type_office->setupEditAttributes();
            $this->wa_type_office->PlaceHolder = RemoveHtml($this->wa_type_office->caption());

            // wa_to_office
            $this->wa_to_office->setupEditAttributes();
            if (!$this->wa_to_office->Raw) {
                $this->wa_to_office->AdvancedSearch->SearchValue = HtmlDecode($this->wa_to_office->AdvancedSearch->SearchValue);
            }
            $this->wa_to_office->EditValue = HtmlEncode($this->wa_to_office->AdvancedSearch->SearchValue);
            $this->wa_to_office->PlaceHolder = RemoveHtml($this->wa_to_office->caption());

            // wa_id
            $this->wa_id->setupEditAttributes();
            $this->wa_id->PlaceHolder = RemoveHtml($this->wa_id->caption());

            // notification_status_user
            $this->notification_status_user->setupEditAttributes();
            $this->notification_status_user->EditValue = $this->notification_status_user->options(true);
            $this->notification_status_user->PlaceHolder = RemoveHtml($this->notification_status_user->caption());

            // notification_status_office
            $this->notification_status_office->setupEditAttributes();
            $this->notification_status_office->EditValue = $this->notification_status_office->options(true);
            $this->notification_status_office->PlaceHolder = RemoveHtml($this->notification_status_office->caption());

            // notification_to_office
            $this->notification_to_office->setupEditAttributes();
            $this->notification_to_office->PlaceHolder = RemoveHtml($this->notification_to_office->caption());

            // visible
            $this->_visible->setupEditAttributes();
            $this->_visible->EditValue = $this->_visible->options(true);
            $this->_visible->PlaceHolder = RemoveHtml($this->_visible->caption());

            // cron
            $this->cron->setupEditAttributes();
            $this->cron->EditValue = $this->cron->options(true);
            $this->cron->PlaceHolder = RemoveHtml($this->cron->caption());

            // next_cycle
            $this->next_cycle->setupEditAttributes();
            $this->next_cycle->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->next_cycle->AdvancedSearch->SearchValue, $this->next_cycle->formatPattern()), $this->next_cycle->formatPattern()));
            $this->next_cycle->PlaceHolder = RemoveHtml($this->next_cycle->caption());

            // delay
            $this->delay->setupEditAttributes();
            $this->delay->EditValue = $this->delay->AdvancedSearch->SearchValue;
            $this->delay->PlaceHolder = RemoveHtml($this->delay->caption());

            // delay_method
            $this->delay_method->setupEditAttributes();
            $this->delay_method->EditValue = $this->delay_method->options(true);
            $this->delay_method->PlaceHolder = RemoveHtml($this->delay_method->caption());

            // operator_admin
            $this->operator_admin->setupEditAttributes();
            $this->operator_admin->EditValue = $this->operator_admin->AdvancedSearch->SearchValue;
            $this->operator_admin->PlaceHolder = RemoveHtml($this->operator_admin->caption());

            // datetime_admin
            $this->datetime_admin->setupEditAttributes();
            $this->datetime_admin->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime_admin->AdvancedSearch->SearchValue, $this->datetime_admin->formatPattern()), $this->datetime_admin->formatPattern()));
            $this->datetime_admin->PlaceHolder = RemoveHtml($this->datetime_admin->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->description->AdvancedSearch->load();
        $this->variables->AdvancedSearch->load();
        $this->subject->AdvancedSearch->load();
        $this->status_email_user->AdvancedSearch->load();
        $this->email_template_user->AdvancedSearch->load();
        $this->mail_to_office->AdvancedSearch->load();
        $this->status_email_office->AdvancedSearch->load();
        $this->email_template_office->AdvancedSearch->load();
        $this->status_sms_user->AdvancedSearch->load();
        $this->sms_template_user->AdvancedSearch->load();
        $this->sms_template_user_id->AdvancedSearch->load();
        $this->status_sms_office->AdvancedSearch->load();
        $this->sms_to_office->AdvancedSearch->load();
        $this->sms_template_office->AdvancedSearch->load();
        $this->sms_template_office_id->AdvancedSearch->load();
        $this->wa_status_user->AdvancedSearch->load();
        $this->wa_type_user->AdvancedSearch->load();
        $this->wa_template_user->AdvancedSearch->load();
        $this->wa_status_office->AdvancedSearch->load();
        $this->wa_type_office->AdvancedSearch->load();
        $this->wa_to_office->AdvancedSearch->load();
        $this->wa_template_office->AdvancedSearch->load();
        $this->wa_id->AdvancedSearch->load();
        $this->notification_status_user->AdvancedSearch->load();
        $this->notification_template_user->AdvancedSearch->load();
        $this->notification_status_office->AdvancedSearch->load();
        $this->notification_to_office->AdvancedSearch->load();
        $this->notification_template_office->AdvancedSearch->load();
        $this->code->AdvancedSearch->load();
        $this->_visible->AdvancedSearch->load();
        $this->cron->AdvancedSearch->load();
        $this->next_cycle->AdvancedSearch->load();
        $this->delay->AdvancedSearch->load();
        $this->delay_method->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->operator_admin->AdvancedSearch->load();
        $this->datetime_admin->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fmessage_template_adminlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fmessage_template_adminlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fmessage_template_adminlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fmessage_template_adminlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fmessage_template_adminsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"message_template_admin\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"messagetemplateadminsearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"messagetemplateadminsearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fmessage_template_adminsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status_email_user":
                    break;
                case "x_status_email_office":
                    break;
                case "x_status_sms_user":
                    break;
                case "x_status_sms_office":
                    break;
                case "x_wa_status_user":
                    break;
                case "x_wa_type_user":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_status_office":
                    break;
                case "x_wa_type_office":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_id":
                    break;
                case "x_notification_status_user":
                    break;
                case "x_notification_status_office":
                    break;
                case "x_notification_to_office":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__visible":
                    break;
                case "x_cron":
                    break;
                case "x_delay_method":
                    break;
                case "x_company_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type) {
    	if ($type == 'success') {
    		//$msg = "your success message";
    	} elseif ($type == 'failure') {
    		//$msg = "your failure message";
    	} elseif ($type == 'warning') {
    		//$msg = "your warning message";
    	} else {
    		$msg = "<a href=\"autoprogramme?ac=93e87919d9c89e6459f4fbd0b03b5bc0&apcid=86a2e69c428aafb50b38a78f62d35b8d\" class=\"btn btn-danger ew-action\" style=\"color:blue\">Import from INT_Fibre</a>";
    	}
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	if (CurrentUserLevel() !=  '-1')
    	{
    		$this->OtherOptions["addedit"]->Items["add"]->Visible = False;
    	}
    	if (CurrentUserLevel() == '-1')
    	{
    		$item = &$this->OtherOptions['action']->Add("Import from INT_Fibre");
    		$item->Body = "<a href=\"autoprogramme?ac=93e87919d9c89e6459f4fbd0b03b5bc0&apcid=86a2e69c428aafb50b38a78f62d35b8d\" class=\"btn btn-danger ew-action\" style=\"color:blue\">Import from INT_Fibre</a>";
    	$item->Visible = True;
    	}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered() {
    	// Example:
    	//$this->ListOptions->Items["new"]->Body = "xxx";
    $IDS = ExecuteRow("SELECT GROUP_CONCAT(`message_template_admin`.`id`) as `ids` FROM `message_template_admin` left join `int_fibre_message_template_admin` on `int_fibre_message_template_admin`.id = `message_template_admin`.`id` where `int_fibre_message_template_admin`.`code` != `message_template_admin`.`code` or `int_fibre_message_template_admin`.`id` is null order by `message_template_admin`.`id` desc");
    $ID = $IDS['ids'];
    $mismatch =  explode(",", $ID);
    		if ((CurrentUserID() == '-1') && (in_array($this->id->CurrentValue, $mismatch)))	
    		if (CurrentUserID() == '-1')
    		{
    				$this->ListOptions->Add("Update to INT_Fibre (Export)"); // Replace abclink with your name of the link
    				$this->ListOptions->Items["Update to INT_Fibre (Export)"]->Body ='<a href="autoprogramme?ac=6bd9e83aef373774188a51f80463f37b&apcid=86a2e69c428aafb50b38a78f62d35b8d&id=' . $this->id->CurrentValue . '" data-bs-original-title ="Update to INT_Fibre (Export)"><i data-phrase="Update to INT_Fibre (Export)" class="fa fa-recycle fa-2x ew-icon" style="color:red"></i></a>';
    			$NIDS = ExecuteRow("SELECT GROUP_CONCAT(`message_template_admin`.`id`) as `ids` FROM `message_template_admin` left join `int_fibre_message_template_admin` on `int_fibre_message_template_admin`.id = `message_template_admin`.`id` where `int_fibre_message_template_admin`.`id` is null");
    $NID = $NIDS['ids'];
    $Nmismatch =  explode(",", $NID);
    			if (((CurrentUserID() == '-1') && (in_array($this->id->CurrentValue, $Nmismatch))) === false)
    			{
    				$this->ListOptions->Add("Update from INT_Fibre (Import)"); // Replace abclink with your name of the link
    				$this->ListOptions->Items["Update from INT_Fibre (Import)"]->Body ='<a href="autoprogramme?ac=fa6c0ebbc86ee0d9d7ed3e7b4fdbf486&apcid=86a2e69c428aafb50b38a78f62d35b8d&id=' . $this->id->CurrentValue . '" data-bs-original-title ="Update from INT_Fibre (Import)"><i data-phrase="Update from INT_Fibre (Import)"  class="fa fa-sign-in fa-2x ew-icon" style="color:blue"></i></a>';
    			}	
    		}
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
