<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MessageTemplateAdminDelete extends MessageTemplateAdmin
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MessageTemplateAdminDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "messagetemplateadmindelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->description->setVisibility();
        $this->variables->Visible = false;
        $this->subject->setVisibility();
        $this->status_email_user->setVisibility();
        $this->email_template_user->Visible = false;
        $this->mail_to_office->setVisibility();
        $this->status_email_office->setVisibility();
        $this->email_template_office->Visible = false;
        $this->status_sms_user->setVisibility();
        $this->sms_template_user->Visible = false;
        $this->sms_template_user_id->setVisibility();
        $this->status_sms_office->Visible = false;
        $this->sms_to_office->setVisibility();
        $this->sms_template_office->setVisibility();
        $this->sms_template_office_id->setVisibility();
        $this->wa_status_user->setVisibility();
        $this->wa_type_user->setVisibility();
        $this->wa_template_user->Visible = false;
        $this->wa_status_office->setVisibility();
        $this->wa_type_office->setVisibility();
        $this->wa_to_office->setVisibility();
        $this->wa_template_office->Visible = false;
        $this->wa_id->setVisibility();
        $this->notification_status_user->setVisibility();
        $this->notification_template_user->Visible = false;
        $this->notification_status_office->setVisibility();
        $this->notification_to_office->setVisibility();
        $this->notification_template_office->Visible = false;
        $this->code->Visible = false;
        $this->_visible->setVisibility();
        $this->cron->setVisibility();
        $this->next_cycle->setVisibility();
        $this->delay->setVisibility();
        $this->delay_method->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->operator_admin->setVisibility();
        $this->datetime_admin->setVisibility();
        $this->company_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'message_template_admin';
        $this->TableName = 'message_template_admin';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (message_template_admin)
        if (!isset($GLOBALS["message_template_admin"]) || $GLOBALS["message_template_admin"]::class == PROJECT_NAMESPACE . "message_template_admin") {
            $GLOBALS["message_template_admin"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'message_template_admin');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->status_email_user);
        $this->setupLookupOptions($this->status_email_office);
        $this->setupLookupOptions($this->status_sms_user);
        $this->setupLookupOptions($this->status_sms_office);
        $this->setupLookupOptions($this->wa_status_user);
        $this->setupLookupOptions($this->wa_type_user);
        $this->setupLookupOptions($this->wa_status_office);
        $this->setupLookupOptions($this->wa_type_office);
        $this->setupLookupOptions($this->wa_id);
        $this->setupLookupOptions($this->notification_status_user);
        $this->setupLookupOptions($this->notification_status_office);
        $this->setupLookupOptions($this->notification_to_office);
        $this->setupLookupOptions($this->_visible);
        $this->setupLookupOptions($this->cron);
        $this->setupLookupOptions($this->delay_method);
        $this->setupLookupOptions($this->company_id);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("messagetemplateadminlist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("messagetemplateadminlist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->description->setDbValue($row['description']);
        $this->variables->setDbValue($row['variables']);
        $this->subject->setDbValue($row['subject']);
        $this->status_email_user->setDbValue($row['status_email_user']);
        $this->email_template_user->setDbValue($row['email_template_user']);
        $this->mail_to_office->setDbValue($row['mail_to_office']);
        $this->status_email_office->setDbValue($row['status_email_office']);
        $this->email_template_office->setDbValue($row['email_template_office']);
        $this->status_sms_user->setDbValue($row['status_sms_user']);
        $this->sms_template_user->setDbValue($row['sms_template_user']);
        $this->sms_template_user_id->setDbValue($row['sms_template_user_id']);
        $this->status_sms_office->setDbValue($row['status_sms_office']);
        $this->sms_to_office->setDbValue($row['sms_to_office']);
        $this->sms_template_office->setDbValue($row['sms_template_office']);
        $this->sms_template_office_id->setDbValue($row['sms_template_office_id']);
        $this->wa_status_user->setDbValue($row['wa_status_user']);
        $this->wa_type_user->setDbValue($row['wa_type_user']);
        $this->wa_template_user->setDbValue($row['wa_template_user']);
        $this->wa_status_office->setDbValue($row['wa_status_office']);
        $this->wa_type_office->setDbValue($row['wa_type_office']);
        $this->wa_to_office->setDbValue($row['wa_to_office']);
        $this->wa_template_office->setDbValue($row['wa_template_office']);
        $this->wa_id->setDbValue($row['wa_id']);
        $this->notification_status_user->setDbValue($row['notification_status_user']);
        $this->notification_template_user->setDbValue($row['notification_template_user']);
        $this->notification_status_office->setDbValue($row['notification_status_office']);
        $this->notification_to_office->setDbValue($row['notification_to_office']);
        $this->notification_template_office->setDbValue($row['notification_template_office']);
        $this->code->setDbValue($row['code']);
        $this->_visible->setDbValue($row['visible']);
        $this->cron->setDbValue($row['cron']);
        $this->next_cycle->setDbValue($row['next_cycle']);
        $this->delay->setDbValue($row['delay']);
        $this->delay_method->setDbValue($row['delay_method']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->operator_admin->setDbValue($row['operator_admin']);
        $this->datetime_admin->setDbValue($row['datetime_admin']);
        $this->company_id->setDbValue($row['company_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['variables'] = $this->variables->DefaultValue;
        $row['subject'] = $this->subject->DefaultValue;
        $row['status_email_user'] = $this->status_email_user->DefaultValue;
        $row['email_template_user'] = $this->email_template_user->DefaultValue;
        $row['mail_to_office'] = $this->mail_to_office->DefaultValue;
        $row['status_email_office'] = $this->status_email_office->DefaultValue;
        $row['email_template_office'] = $this->email_template_office->DefaultValue;
        $row['status_sms_user'] = $this->status_sms_user->DefaultValue;
        $row['sms_template_user'] = $this->sms_template_user->DefaultValue;
        $row['sms_template_user_id'] = $this->sms_template_user_id->DefaultValue;
        $row['status_sms_office'] = $this->status_sms_office->DefaultValue;
        $row['sms_to_office'] = $this->sms_to_office->DefaultValue;
        $row['sms_template_office'] = $this->sms_template_office->DefaultValue;
        $row['sms_template_office_id'] = $this->sms_template_office_id->DefaultValue;
        $row['wa_status_user'] = $this->wa_status_user->DefaultValue;
        $row['wa_type_user'] = $this->wa_type_user->DefaultValue;
        $row['wa_template_user'] = $this->wa_template_user->DefaultValue;
        $row['wa_status_office'] = $this->wa_status_office->DefaultValue;
        $row['wa_type_office'] = $this->wa_type_office->DefaultValue;
        $row['wa_to_office'] = $this->wa_to_office->DefaultValue;
        $row['wa_template_office'] = $this->wa_template_office->DefaultValue;
        $row['wa_id'] = $this->wa_id->DefaultValue;
        $row['notification_status_user'] = $this->notification_status_user->DefaultValue;
        $row['notification_template_user'] = $this->notification_template_user->DefaultValue;
        $row['notification_status_office'] = $this->notification_status_office->DefaultValue;
        $row['notification_to_office'] = $this->notification_to_office->DefaultValue;
        $row['notification_template_office'] = $this->notification_template_office->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['visible'] = $this->_visible->DefaultValue;
        $row['cron'] = $this->cron->DefaultValue;
        $row['next_cycle'] = $this->next_cycle->DefaultValue;
        $row['delay'] = $this->delay->DefaultValue;
        $row['delay_method'] = $this->delay_method->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['operator_admin'] = $this->operator_admin->DefaultValue;
        $row['datetime_admin'] = $this->datetime_admin->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // grp

        // description

        // variables

        // subject

        // status_email_user

        // email_template_user

        // mail_to_office

        // status_email_office

        // email_template_office

        // status_sms_user

        // sms_template_user

        // sms_template_user_id

        // status_sms_office

        // sms_to_office

        // sms_template_office

        // sms_template_office_id

        // wa_status_user

        // wa_type_user

        // wa_template_user

        // wa_status_office

        // wa_type_office

        // wa_to_office

        // wa_template_office

        // wa_id

        // notification_status_user

        // notification_template_user

        // notification_status_office

        // notification_to_office

        // notification_template_office

        // code

        // visible

        // cron

        // next_cycle

        // delay

        // delay_method

        // operator

        // datetime

        // operator_admin

        // datetime_admin

        // company_id

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // variables
            $this->variables->ViewValue = $this->variables->CurrentValue;

            // subject
            $this->subject->ViewValue = $this->subject->CurrentValue;

            // status_email_user
            if (strval($this->status_email_user->CurrentValue) != "") {
                $this->status_email_user->ViewValue = $this->status_email_user->optionCaption($this->status_email_user->CurrentValue);
            } else {
                $this->status_email_user->ViewValue = null;
            }

            // email_template_user
            $this->email_template_user->ViewValue = $this->email_template_user->CurrentValue;

            // mail_to_office
            $this->mail_to_office->ViewValue = $this->mail_to_office->CurrentValue;

            // status_email_office
            if (strval($this->status_email_office->CurrentValue) != "") {
                $this->status_email_office->ViewValue = $this->status_email_office->optionCaption($this->status_email_office->CurrentValue);
            } else {
                $this->status_email_office->ViewValue = null;
            }

            // status_sms_user
            if (strval($this->status_sms_user->CurrentValue) != "") {
                $this->status_sms_user->ViewValue = $this->status_sms_user->optionCaption($this->status_sms_user->CurrentValue);
            } else {
                $this->status_sms_user->ViewValue = null;
            }

            // sms_template_user
            $this->sms_template_user->ViewValue = $this->sms_template_user->CurrentValue;

            // sms_template_user_id
            $this->sms_template_user_id->ViewValue = $this->sms_template_user_id->CurrentValue;

            // status_sms_office
            if (strval($this->status_sms_office->CurrentValue) != "") {
                $this->status_sms_office->ViewValue = $this->status_sms_office->optionCaption($this->status_sms_office->CurrentValue);
            } else {
                $this->status_sms_office->ViewValue = null;
            }

            // sms_to_office
            $this->sms_to_office->ViewValue = $this->sms_to_office->CurrentValue;

            // sms_template_office
            $this->sms_template_office->ViewValue = $this->sms_template_office->CurrentValue;

            // sms_template_office_id
            $this->sms_template_office_id->ViewValue = $this->sms_template_office_id->CurrentValue;

            // wa_status_user
            if (strval($this->wa_status_user->CurrentValue) != "") {
                $this->wa_status_user->ViewValue = $this->wa_status_user->optionCaption($this->wa_status_user->CurrentValue);
            } else {
                $this->wa_status_user->ViewValue = null;
            }

            // wa_type_user
            $curVal = strval($this->wa_type_user->CurrentValue);
            if ($curVal != "") {
                $this->wa_type_user->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
                if ($this->wa_type_user->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_type_user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->wa_type_user->getSelectFilter($this); // PHP
                    $sqlWrk = $this->wa_type_user->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_type_user->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_type_user->ViewValue = $this->wa_type_user->displayValue($arwrk);
                    } else {
                        $this->wa_type_user->ViewValue = FormatNumber($this->wa_type_user->CurrentValue, $this->wa_type_user->formatPattern());
                    }
                }
            } else {
                $this->wa_type_user->ViewValue = null;
            }

            // wa_status_office
            if (strval($this->wa_status_office->CurrentValue) != "") {
                $this->wa_status_office->ViewValue = $this->wa_status_office->optionCaption($this->wa_status_office->CurrentValue);
            } else {
                $this->wa_status_office->ViewValue = null;
            }

            // wa_type_office
            $curVal = strval($this->wa_type_office->CurrentValue);
            if ($curVal != "") {
                $this->wa_type_office->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
                if ($this->wa_type_office->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_type_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_office->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->wa_type_office->getSelectFilter($this); // PHP
                    $sqlWrk = $this->wa_type_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_type_office->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_type_office->ViewValue = $this->wa_type_office->displayValue($arwrk);
                    } else {
                        $this->wa_type_office->ViewValue = FormatNumber($this->wa_type_office->CurrentValue, $this->wa_type_office->formatPattern());
                    }
                }
            } else {
                $this->wa_type_office->ViewValue = null;
            }

            // wa_to_office
            $this->wa_to_office->ViewValue = $this->wa_to_office->CurrentValue;

            // wa_id
            $curVal = strval($this->wa_id->CurrentValue);
            if ($curVal != "") {
                $this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
                if ($this->wa_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->wa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_id->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
                    } else {
                        $this->wa_id->ViewValue = FormatNumber($this->wa_id->CurrentValue, $this->wa_id->formatPattern());
                    }
                }
            } else {
                $this->wa_id->ViewValue = null;
            }

            // notification_status_user
            if (strval($this->notification_status_user->CurrentValue) != "") {
                $this->notification_status_user->ViewValue = $this->notification_status_user->optionCaption($this->notification_status_user->CurrentValue);
            } else {
                $this->notification_status_user->ViewValue = null;
            }

            // notification_template_user
            $this->notification_template_user->ViewValue = $this->notification_template_user->CurrentValue;

            // notification_status_office
            if (strval($this->notification_status_office->CurrentValue) != "") {
                $this->notification_status_office->ViewValue = $this->notification_status_office->optionCaption($this->notification_status_office->CurrentValue);
            } else {
                $this->notification_status_office->ViewValue = null;
            }

            // notification_to_office
            $curVal = strval($this->notification_to_office->CurrentValue);
            if ($curVal != "") {
                $this->notification_to_office->ViewValue = $this->notification_to_office->lookupCacheOption($curVal);
                if ($this->notification_to_office->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->notification_to_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->notification_to_office->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->notification_to_office->getSelectFilter($this); // PHP
                    $sqlWrk = $this->notification_to_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->notification_to_office->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->notification_to_office->Lookup->renderViewRow($row);
                            $this->notification_to_office->ViewValue->add($this->notification_to_office->displayValue($arwrk));
                        }
                    } else {
                        $this->notification_to_office->ViewValue = $this->notification_to_office->CurrentValue;
                    }
                }
            } else {
                $this->notification_to_office->ViewValue = null;
            }

            // notification_template_office
            $this->notification_template_office->ViewValue = $this->notification_template_office->CurrentValue;

            // visible
            if (strval($this->_visible->CurrentValue) != "") {
                $this->_visible->ViewValue = $this->_visible->optionCaption($this->_visible->CurrentValue);
            } else {
                $this->_visible->ViewValue = null;
            }

            // cron
            if (strval($this->cron->CurrentValue) != "") {
                $this->cron->ViewValue = $this->cron->optionCaption($this->cron->CurrentValue);
            } else {
                $this->cron->ViewValue = null;
            }

            // next_cycle
            $this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
            $this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, $this->next_cycle->formatPattern());

            // delay
            $this->delay->ViewValue = $this->delay->CurrentValue;
            $this->delay->ViewValue = FormatNumber($this->delay->ViewValue, $this->delay->formatPattern());

            // delay_method
            if (strval($this->delay_method->CurrentValue) != "") {
                $this->delay_method->ViewValue = $this->delay_method->optionCaption($this->delay_method->CurrentValue);
            } else {
                $this->delay_method->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // operator_admin
            $this->operator_admin->ViewValue = $this->operator_admin->CurrentValue;

            // datetime_admin
            $this->datetime_admin->ViewValue = $this->datetime_admin->CurrentValue;
            $this->datetime_admin->ViewValue = FormatDateTime($this->datetime_admin->ViewValue, $this->datetime_admin->formatPattern());

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // description
            if (!EmptyValue($this->id->CurrentValue)) {
                $this->description->HrefValue = $this->description->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
                $this->description->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
                }
            } else {
                $this->description->HrefValue = "";
            }
            $this->description->TooltipValue = "";

            // subject
            $this->subject->HrefValue = "";
            $this->subject->TooltipValue = "";

            // status_email_user
            $this->status_email_user->HrefValue = "";
            $this->status_email_user->TooltipValue = "";

            // mail_to_office
            $this->mail_to_office->HrefValue = "";
            $this->mail_to_office->TooltipValue = "";

            // status_email_office
            $this->status_email_office->HrefValue = "";
            $this->status_email_office->TooltipValue = "";

            // status_sms_user
            $this->status_sms_user->HrefValue = "";
            $this->status_sms_user->TooltipValue = "";

            // sms_template_user_id
            $this->sms_template_user_id->HrefValue = "";
            $this->sms_template_user_id->TooltipValue = "";

            // sms_to_office
            $this->sms_to_office->HrefValue = "";
            $this->sms_to_office->TooltipValue = "";

            // sms_template_office
            $this->sms_template_office->HrefValue = "";
            $this->sms_template_office->TooltipValue = "";

            // sms_template_office_id
            $this->sms_template_office_id->HrefValue = "";
            $this->sms_template_office_id->TooltipValue = "";

            // wa_status_user
            $this->wa_status_user->HrefValue = "";
            $this->wa_status_user->TooltipValue = "";

            // wa_type_user
            $this->wa_type_user->HrefValue = "";
            $this->wa_type_user->TooltipValue = "";

            // wa_status_office
            $this->wa_status_office->HrefValue = "";
            $this->wa_status_office->TooltipValue = "";

            // wa_type_office
            $this->wa_type_office->HrefValue = "";
            $this->wa_type_office->TooltipValue = "";

            // wa_to_office
            $this->wa_to_office->HrefValue = "";
            $this->wa_to_office->TooltipValue = "";

            // wa_id
            $this->wa_id->HrefValue = "";
            $this->wa_id->TooltipValue = "";

            // notification_status_user
            $this->notification_status_user->HrefValue = "";
            $this->notification_status_user->TooltipValue = "";

            // notification_status_office
            $this->notification_status_office->HrefValue = "";
            $this->notification_status_office->TooltipValue = "";

            // notification_to_office
            $this->notification_to_office->HrefValue = "";
            $this->notification_to_office->TooltipValue = "";

            // visible
            $this->_visible->HrefValue = "";
            $this->_visible->TooltipValue = "";

            // cron
            $this->cron->HrefValue = "";
            $this->cron->TooltipValue = "";

            // next_cycle
            $this->next_cycle->HrefValue = "";
            $this->next_cycle->TooltipValue = "";

            // delay
            $this->delay->HrefValue = "";
            $this->delay->TooltipValue = "";

            // delay_method
            $this->delay_method->HrefValue = "";
            $this->delay_method->TooltipValue = "";

            // operator_admin
            $this->operator_admin->HrefValue = "";
            $this->operator_admin->TooltipValue = "";

            // datetime_admin
            $this->datetime_admin->HrefValue = "";
            $this->datetime_admin->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("messagetemplateadminlist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status_email_user":
                    break;
                case "x_status_email_office":
                    break;
                case "x_status_sms_user":
                    break;
                case "x_status_sms_office":
                    break;
                case "x_wa_status_user":
                    break;
                case "x_wa_type_user":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_status_office":
                    break;
                case "x_wa_type_office":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_id":
                    break;
                case "x_notification_status_user":
                    break;
                case "x_notification_status_office":
                    break;
                case "x_notification_to_office":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__visible":
                    break;
                case "x_cron":
                    break;
                case "x_delay_method":
                    break;
                case "x_company_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
