<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MessageTemplateAdminAdd extends MessageTemplateAdmin
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MessageTemplateAdminAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "messagetemplateadminadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->description->setVisibility();
        $this->variables->setVisibility();
        $this->subject->setVisibility();
        $this->status_email_user->setVisibility();
        $this->email_template_user->setVisibility();
        $this->mail_to_office->setVisibility();
        $this->status_email_office->setVisibility();
        $this->email_template_office->setVisibility();
        $this->status_sms_user->setVisibility();
        $this->sms_template_user->setVisibility();
        $this->sms_template_user_id->setVisibility();
        $this->status_sms_office->setVisibility();
        $this->sms_to_office->setVisibility();
        $this->sms_template_office->setVisibility();
        $this->sms_template_office_id->setVisibility();
        $this->wa_status_user->setVisibility();
        $this->wa_type_user->setVisibility();
        $this->wa_template_user->setVisibility();
        $this->wa_status_office->setVisibility();
        $this->wa_type_office->setVisibility();
        $this->wa_to_office->setVisibility();
        $this->wa_template_office->setVisibility();
        $this->wa_id->setVisibility();
        $this->notification_status_user->setVisibility();
        $this->notification_template_user->setVisibility();
        $this->notification_status_office->setVisibility();
        $this->notification_to_office->setVisibility();
        $this->notification_template_office->setVisibility();
        $this->code->setVisibility();
        $this->_visible->setVisibility();
        $this->cron->setVisibility();
        $this->next_cycle->setVisibility();
        $this->delay->setVisibility();
        $this->delay_method->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->operator_admin->setVisibility();
        $this->datetime_admin->setVisibility();
        $this->company_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'message_template_admin';
        $this->TableName = 'message_template_admin';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (message_template_admin)
        if (!isset($GLOBALS["message_template_admin"]) || $GLOBALS["message_template_admin"]::class == PROJECT_NAMESPACE . "message_template_admin") {
            $GLOBALS["message_template_admin"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'message_template_admin');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "messagetemplateadminview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->status_email_user);
        $this->setupLookupOptions($this->status_email_office);
        $this->setupLookupOptions($this->status_sms_user);
        $this->setupLookupOptions($this->status_sms_office);
        $this->setupLookupOptions($this->wa_status_user);
        $this->setupLookupOptions($this->wa_type_user);
        $this->setupLookupOptions($this->wa_status_office);
        $this->setupLookupOptions($this->wa_type_office);
        $this->setupLookupOptions($this->wa_id);
        $this->setupLookupOptions($this->notification_status_user);
        $this->setupLookupOptions($this->notification_status_office);
        $this->setupLookupOptions($this->notification_to_office);
        $this->setupLookupOptions($this->_visible);
        $this->setupLookupOptions($this->cron);
        $this->setupLookupOptions($this->delay_method);
        $this->setupLookupOptions($this->company_id);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("messagetemplateadminlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "messagetemplateadminlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "messagetemplateadminview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "messagetemplateadminlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "messagetemplateadminlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->status_email_user->DefaultValue = $this->status_email_user->getDefault(); // PHP
        $this->status_email_user->OldValue = $this->status_email_user->DefaultValue;
        $this->wa_status_user->DefaultValue = $this->wa_status_user->getDefault(); // PHP
        $this->wa_status_user->OldValue = $this->wa_status_user->DefaultValue;
        $this->wa_type_user->DefaultValue = $this->wa_type_user->getDefault(); // PHP
        $this->wa_type_user->OldValue = $this->wa_type_user->DefaultValue;
        $this->wa_status_office->DefaultValue = $this->wa_status_office->getDefault(); // PHP
        $this->wa_status_office->OldValue = $this->wa_status_office->DefaultValue;
        $this->wa_type_office->DefaultValue = $this->wa_type_office->getDefault(); // PHP
        $this->wa_type_office->OldValue = $this->wa_type_office->DefaultValue;
        $this->wa_id->DefaultValue = $this->wa_id->getDefault(); // PHP
        $this->wa_id->OldValue = $this->wa_id->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id->Visible = false; // Disable update for API request
            } else {
                $this->id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 'description' first before field var 'x_description'
        $val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
        if (!$this->description->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description->Visible = false; // Disable update for API request
            } else {
                $this->description->setFormValue($val);
            }
        }

        // Check field name 'variables' first before field var 'x_variables'
        $val = $CurrentForm->hasValue("variables") ? $CurrentForm->getValue("variables") : $CurrentForm->getValue("x_variables");
        if (!$this->variables->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->variables->Visible = false; // Disable update for API request
            } else {
                $this->variables->setFormValue($val);
            }
        }

        // Check field name 'subject' first before field var 'x_subject'
        $val = $CurrentForm->hasValue("subject") ? $CurrentForm->getValue("subject") : $CurrentForm->getValue("x_subject");
        if (!$this->subject->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->subject->Visible = false; // Disable update for API request
            } else {
                $this->subject->setFormValue($val);
            }
        }

        // Check field name 'status_email_user' first before field var 'x_status_email_user'
        $val = $CurrentForm->hasValue("status_email_user") ? $CurrentForm->getValue("status_email_user") : $CurrentForm->getValue("x_status_email_user");
        if (!$this->status_email_user->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status_email_user->Visible = false; // Disable update for API request
            } else {
                $this->status_email_user->setFormValue($val);
            }
        }

        // Check field name 'email_template_user' first before field var 'x_email_template_user'
        $val = $CurrentForm->hasValue("email_template_user") ? $CurrentForm->getValue("email_template_user") : $CurrentForm->getValue("x_email_template_user");
        if (!$this->email_template_user->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->email_template_user->Visible = false; // Disable update for API request
            } else {
                $this->email_template_user->setFormValue($val);
            }
        }

        // Check field name 'mail_to_office' first before field var 'x_mail_to_office'
        $val = $CurrentForm->hasValue("mail_to_office") ? $CurrentForm->getValue("mail_to_office") : $CurrentForm->getValue("x_mail_to_office");
        if (!$this->mail_to_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mail_to_office->Visible = false; // Disable update for API request
            } else {
                $this->mail_to_office->setFormValue($val);
            }
        }

        // Check field name 'status_email_office' first before field var 'x_status_email_office'
        $val = $CurrentForm->hasValue("status_email_office") ? $CurrentForm->getValue("status_email_office") : $CurrentForm->getValue("x_status_email_office");
        if (!$this->status_email_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status_email_office->Visible = false; // Disable update for API request
            } else {
                $this->status_email_office->setFormValue($val);
            }
        }

        // Check field name 'email_template_office' first before field var 'x_email_template_office'
        $val = $CurrentForm->hasValue("email_template_office") ? $CurrentForm->getValue("email_template_office") : $CurrentForm->getValue("x_email_template_office");
        if (!$this->email_template_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->email_template_office->Visible = false; // Disable update for API request
            } else {
                $this->email_template_office->setFormValue($val);
            }
        }

        // Check field name 'status_sms_user' first before field var 'x_status_sms_user'
        $val = $CurrentForm->hasValue("status_sms_user") ? $CurrentForm->getValue("status_sms_user") : $CurrentForm->getValue("x_status_sms_user");
        if (!$this->status_sms_user->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status_sms_user->Visible = false; // Disable update for API request
            } else {
                $this->status_sms_user->setFormValue($val);
            }
        }

        // Check field name 'sms_template_user' first before field var 'x_sms_template_user'
        $val = $CurrentForm->hasValue("sms_template_user") ? $CurrentForm->getValue("sms_template_user") : $CurrentForm->getValue("x_sms_template_user");
        if (!$this->sms_template_user->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sms_template_user->Visible = false; // Disable update for API request
            } else {
                $this->sms_template_user->setFormValue($val);
            }
        }

        // Check field name 'sms_template_user_id' first before field var 'x_sms_template_user_id'
        $val = $CurrentForm->hasValue("sms_template_user_id") ? $CurrentForm->getValue("sms_template_user_id") : $CurrentForm->getValue("x_sms_template_user_id");
        if (!$this->sms_template_user_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sms_template_user_id->Visible = false; // Disable update for API request
            } else {
                $this->sms_template_user_id->setFormValue($val);
            }
        }

        // Check field name 'status_sms_office' first before field var 'x_status_sms_office'
        $val = $CurrentForm->hasValue("status_sms_office") ? $CurrentForm->getValue("status_sms_office") : $CurrentForm->getValue("x_status_sms_office");
        if (!$this->status_sms_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status_sms_office->Visible = false; // Disable update for API request
            } else {
                $this->status_sms_office->setFormValue($val);
            }
        }

        // Check field name 'sms_to_office' first before field var 'x_sms_to_office'
        $val = $CurrentForm->hasValue("sms_to_office") ? $CurrentForm->getValue("sms_to_office") : $CurrentForm->getValue("x_sms_to_office");
        if (!$this->sms_to_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sms_to_office->Visible = false; // Disable update for API request
            } else {
                $this->sms_to_office->setFormValue($val);
            }
        }

        // Check field name 'sms_template_office' first before field var 'x_sms_template_office'
        $val = $CurrentForm->hasValue("sms_template_office") ? $CurrentForm->getValue("sms_template_office") : $CurrentForm->getValue("x_sms_template_office");
        if (!$this->sms_template_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sms_template_office->Visible = false; // Disable update for API request
            } else {
                $this->sms_template_office->setFormValue($val);
            }
        }

        // Check field name 'sms_template_office_id' first before field var 'x_sms_template_office_id'
        $val = $CurrentForm->hasValue("sms_template_office_id") ? $CurrentForm->getValue("sms_template_office_id") : $CurrentForm->getValue("x_sms_template_office_id");
        if (!$this->sms_template_office_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sms_template_office_id->Visible = false; // Disable update for API request
            } else {
                $this->sms_template_office_id->setFormValue($val);
            }
        }

        // Check field name 'wa_status_user' first before field var 'x_wa_status_user'
        $val = $CurrentForm->hasValue("wa_status_user") ? $CurrentForm->getValue("wa_status_user") : $CurrentForm->getValue("x_wa_status_user");
        if (!$this->wa_status_user->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_status_user->Visible = false; // Disable update for API request
            } else {
                $this->wa_status_user->setFormValue($val);
            }
        }

        // Check field name 'wa_type_user' first before field var 'x_wa_type_user'
        $val = $CurrentForm->hasValue("wa_type_user") ? $CurrentForm->getValue("wa_type_user") : $CurrentForm->getValue("x_wa_type_user");
        if (!$this->wa_type_user->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_type_user->Visible = false; // Disable update for API request
            } else {
                $this->wa_type_user->setFormValue($val);
            }
        }

        // Check field name 'wa_template_user' first before field var 'x_wa_template_user'
        $val = $CurrentForm->hasValue("wa_template_user") ? $CurrentForm->getValue("wa_template_user") : $CurrentForm->getValue("x_wa_template_user");
        if (!$this->wa_template_user->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_template_user->Visible = false; // Disable update for API request
            } else {
                $this->wa_template_user->setFormValue($val);
            }
        }

        // Check field name 'wa_status_office' first before field var 'x_wa_status_office'
        $val = $CurrentForm->hasValue("wa_status_office") ? $CurrentForm->getValue("wa_status_office") : $CurrentForm->getValue("x_wa_status_office");
        if (!$this->wa_status_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_status_office->Visible = false; // Disable update for API request
            } else {
                $this->wa_status_office->setFormValue($val);
            }
        }

        // Check field name 'wa_type_office' first before field var 'x_wa_type_office'
        $val = $CurrentForm->hasValue("wa_type_office") ? $CurrentForm->getValue("wa_type_office") : $CurrentForm->getValue("x_wa_type_office");
        if (!$this->wa_type_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_type_office->Visible = false; // Disable update for API request
            } else {
                $this->wa_type_office->setFormValue($val);
            }
        }

        // Check field name 'wa_to_office' first before field var 'x_wa_to_office'
        $val = $CurrentForm->hasValue("wa_to_office") ? $CurrentForm->getValue("wa_to_office") : $CurrentForm->getValue("x_wa_to_office");
        if (!$this->wa_to_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_to_office->Visible = false; // Disable update for API request
            } else {
                $this->wa_to_office->setFormValue($val);
            }
        }

        // Check field name 'wa_template_office' first before field var 'x_wa_template_office'
        $val = $CurrentForm->hasValue("wa_template_office") ? $CurrentForm->getValue("wa_template_office") : $CurrentForm->getValue("x_wa_template_office");
        if (!$this->wa_template_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_template_office->Visible = false; // Disable update for API request
            } else {
                $this->wa_template_office->setFormValue($val);
            }
        }

        // Check field name 'wa_id' first before field var 'x_wa_id'
        $val = $CurrentForm->hasValue("wa_id") ? $CurrentForm->getValue("wa_id") : $CurrentForm->getValue("x_wa_id");
        if (!$this->wa_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->wa_id->Visible = false; // Disable update for API request
            } else {
                $this->wa_id->setFormValue($val);
            }
        }

        // Check field name 'notification_status_user' first before field var 'x_notification_status_user'
        $val = $CurrentForm->hasValue("notification_status_user") ? $CurrentForm->getValue("notification_status_user") : $CurrentForm->getValue("x_notification_status_user");
        if (!$this->notification_status_user->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->notification_status_user->Visible = false; // Disable update for API request
            } else {
                $this->notification_status_user->setFormValue($val);
            }
        }

        // Check field name 'notification_template_user' first before field var 'x_notification_template_user'
        $val = $CurrentForm->hasValue("notification_template_user") ? $CurrentForm->getValue("notification_template_user") : $CurrentForm->getValue("x_notification_template_user");
        if (!$this->notification_template_user->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->notification_template_user->Visible = false; // Disable update for API request
            } else {
                $this->notification_template_user->setFormValue($val);
            }
        }

        // Check field name 'notification_status_office' first before field var 'x_notification_status_office'
        $val = $CurrentForm->hasValue("notification_status_office") ? $CurrentForm->getValue("notification_status_office") : $CurrentForm->getValue("x_notification_status_office");
        if (!$this->notification_status_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->notification_status_office->Visible = false; // Disable update for API request
            } else {
                $this->notification_status_office->setFormValue($val);
            }
        }

        // Check field name 'notification_to_office' first before field var 'x_notification_to_office'
        $val = $CurrentForm->hasValue("notification_to_office") ? $CurrentForm->getValue("notification_to_office") : $CurrentForm->getValue("x_notification_to_office");
        if (!$this->notification_to_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->notification_to_office->Visible = false; // Disable update for API request
            } else {
                $this->notification_to_office->setFormValue($val);
            }
        }

        // Check field name 'notification_template_office' first before field var 'x_notification_template_office'
        $val = $CurrentForm->hasValue("notification_template_office") ? $CurrentForm->getValue("notification_template_office") : $CurrentForm->getValue("x_notification_template_office");
        if (!$this->notification_template_office->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->notification_template_office->Visible = false; // Disable update for API request
            } else {
                $this->notification_template_office->setFormValue($val);
            }
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->code->Visible = false; // Disable update for API request
            } else {
                $this->code->setFormValue($val);
            }
        }

        // Check field name 'visible' first before field var 'x__visible'
        $val = $CurrentForm->hasValue("visible") ? $CurrentForm->getValue("visible") : $CurrentForm->getValue("x__visible");
        if (!$this->_visible->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_visible->Visible = false; // Disable update for API request
            } else {
                $this->_visible->setFormValue($val);
            }
        }

        // Check field name 'cron' first before field var 'x_cron'
        $val = $CurrentForm->hasValue("cron") ? $CurrentForm->getValue("cron") : $CurrentForm->getValue("x_cron");
        if (!$this->cron->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cron->Visible = false; // Disable update for API request
            } else {
                $this->cron->setFormValue($val);
            }
        }

        // Check field name 'next_cycle' first before field var 'x_next_cycle'
        $val = $CurrentForm->hasValue("next_cycle") ? $CurrentForm->getValue("next_cycle") : $CurrentForm->getValue("x_next_cycle");
        if (!$this->next_cycle->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->next_cycle->Visible = false; // Disable update for API request
            } else {
                $this->next_cycle->setFormValue($val, true, $validate);
            }
            $this->next_cycle->CurrentValue = UnFormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern());
        }

        // Check field name 'delay' first before field var 'x_delay'
        $val = $CurrentForm->hasValue("delay") ? $CurrentForm->getValue("delay") : $CurrentForm->getValue("x_delay");
        if (!$this->delay->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delay->Visible = false; // Disable update for API request
            } else {
                $this->delay->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'delay_method' first before field var 'x_delay_method'
        $val = $CurrentForm->hasValue("delay_method") ? $CurrentForm->getValue("delay_method") : $CurrentForm->getValue("x_delay_method");
        if (!$this->delay_method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delay_method->Visible = false; // Disable update for API request
            } else {
                $this->delay_method->setFormValue($val);
            }
        }

        // Check field name 'operator_admin' first before field var 'x_operator_admin'
        $val = $CurrentForm->hasValue("operator_admin") ? $CurrentForm->getValue("operator_admin") : $CurrentForm->getValue("x_operator_admin");
        if (!$this->operator_admin->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator_admin->Visible = false; // Disable update for API request
            } else {
                $this->operator_admin->setFormValue($val);
            }
        }

        // Check field name 'datetime_admin' first before field var 'x_datetime_admin'
        $val = $CurrentForm->hasValue("datetime_admin") ? $CurrentForm->getValue("datetime_admin") : $CurrentForm->getValue("x_datetime_admin");
        if (!$this->datetime_admin->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime_admin->Visible = false; // Disable update for API request
            } else {
                $this->datetime_admin->setFormValue($val);
            }
            $this->datetime_admin->CurrentValue = UnFormatDateTime($this->datetime_admin->CurrentValue, $this->datetime_admin->formatPattern());
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->description->CurrentValue = $this->description->FormValue;
        $this->variables->CurrentValue = $this->variables->FormValue;
        $this->subject->CurrentValue = $this->subject->FormValue;
        $this->status_email_user->CurrentValue = $this->status_email_user->FormValue;
        $this->email_template_user->CurrentValue = $this->email_template_user->FormValue;
        $this->mail_to_office->CurrentValue = $this->mail_to_office->FormValue;
        $this->status_email_office->CurrentValue = $this->status_email_office->FormValue;
        $this->email_template_office->CurrentValue = $this->email_template_office->FormValue;
        $this->status_sms_user->CurrentValue = $this->status_sms_user->FormValue;
        $this->sms_template_user->CurrentValue = $this->sms_template_user->FormValue;
        $this->sms_template_user_id->CurrentValue = $this->sms_template_user_id->FormValue;
        $this->status_sms_office->CurrentValue = $this->status_sms_office->FormValue;
        $this->sms_to_office->CurrentValue = $this->sms_to_office->FormValue;
        $this->sms_template_office->CurrentValue = $this->sms_template_office->FormValue;
        $this->sms_template_office_id->CurrentValue = $this->sms_template_office_id->FormValue;
        $this->wa_status_user->CurrentValue = $this->wa_status_user->FormValue;
        $this->wa_type_user->CurrentValue = $this->wa_type_user->FormValue;
        $this->wa_template_user->CurrentValue = $this->wa_template_user->FormValue;
        $this->wa_status_office->CurrentValue = $this->wa_status_office->FormValue;
        $this->wa_type_office->CurrentValue = $this->wa_type_office->FormValue;
        $this->wa_to_office->CurrentValue = $this->wa_to_office->FormValue;
        $this->wa_template_office->CurrentValue = $this->wa_template_office->FormValue;
        $this->wa_id->CurrentValue = $this->wa_id->FormValue;
        $this->notification_status_user->CurrentValue = $this->notification_status_user->FormValue;
        $this->notification_template_user->CurrentValue = $this->notification_template_user->FormValue;
        $this->notification_status_office->CurrentValue = $this->notification_status_office->FormValue;
        $this->notification_to_office->CurrentValue = $this->notification_to_office->FormValue;
        $this->notification_template_office->CurrentValue = $this->notification_template_office->FormValue;
        $this->code->CurrentValue = $this->code->FormValue;
        $this->_visible->CurrentValue = $this->_visible->FormValue;
        $this->cron->CurrentValue = $this->cron->FormValue;
        $this->next_cycle->CurrentValue = $this->next_cycle->FormValue;
        $this->next_cycle->CurrentValue = UnFormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern());
        $this->delay->CurrentValue = $this->delay->FormValue;
        $this->delay_method->CurrentValue = $this->delay_method->FormValue;
        $this->operator_admin->CurrentValue = $this->operator_admin->FormValue;
        $this->datetime_admin->CurrentValue = $this->datetime_admin->FormValue;
        $this->datetime_admin->CurrentValue = UnFormatDateTime($this->datetime_admin->CurrentValue, $this->datetime_admin->formatPattern());
        $this->company_id->CurrentValue = $this->company_id->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->description->setDbValue($row['description']);
        $this->variables->setDbValue($row['variables']);
        $this->subject->setDbValue($row['subject']);
        $this->status_email_user->setDbValue($row['status_email_user']);
        $this->email_template_user->setDbValue($row['email_template_user']);
        $this->mail_to_office->setDbValue($row['mail_to_office']);
        $this->status_email_office->setDbValue($row['status_email_office']);
        $this->email_template_office->setDbValue($row['email_template_office']);
        $this->status_sms_user->setDbValue($row['status_sms_user']);
        $this->sms_template_user->setDbValue($row['sms_template_user']);
        $this->sms_template_user_id->setDbValue($row['sms_template_user_id']);
        $this->status_sms_office->setDbValue($row['status_sms_office']);
        $this->sms_to_office->setDbValue($row['sms_to_office']);
        $this->sms_template_office->setDbValue($row['sms_template_office']);
        $this->sms_template_office_id->setDbValue($row['sms_template_office_id']);
        $this->wa_status_user->setDbValue($row['wa_status_user']);
        $this->wa_type_user->setDbValue($row['wa_type_user']);
        $this->wa_template_user->setDbValue($row['wa_template_user']);
        $this->wa_status_office->setDbValue($row['wa_status_office']);
        $this->wa_type_office->setDbValue($row['wa_type_office']);
        $this->wa_to_office->setDbValue($row['wa_to_office']);
        $this->wa_template_office->setDbValue($row['wa_template_office']);
        $this->wa_id->setDbValue($row['wa_id']);
        $this->notification_status_user->setDbValue($row['notification_status_user']);
        $this->notification_template_user->setDbValue($row['notification_template_user']);
        $this->notification_status_office->setDbValue($row['notification_status_office']);
        $this->notification_to_office->setDbValue($row['notification_to_office']);
        $this->notification_template_office->setDbValue($row['notification_template_office']);
        $this->code->setDbValue($row['code']);
        $this->_visible->setDbValue($row['visible']);
        $this->cron->setDbValue($row['cron']);
        $this->next_cycle->setDbValue($row['next_cycle']);
        $this->delay->setDbValue($row['delay']);
        $this->delay_method->setDbValue($row['delay_method']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->operator_admin->setDbValue($row['operator_admin']);
        $this->datetime_admin->setDbValue($row['datetime_admin']);
        $this->company_id->setDbValue($row['company_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['variables'] = $this->variables->DefaultValue;
        $row['subject'] = $this->subject->DefaultValue;
        $row['status_email_user'] = $this->status_email_user->DefaultValue;
        $row['email_template_user'] = $this->email_template_user->DefaultValue;
        $row['mail_to_office'] = $this->mail_to_office->DefaultValue;
        $row['status_email_office'] = $this->status_email_office->DefaultValue;
        $row['email_template_office'] = $this->email_template_office->DefaultValue;
        $row['status_sms_user'] = $this->status_sms_user->DefaultValue;
        $row['sms_template_user'] = $this->sms_template_user->DefaultValue;
        $row['sms_template_user_id'] = $this->sms_template_user_id->DefaultValue;
        $row['status_sms_office'] = $this->status_sms_office->DefaultValue;
        $row['sms_to_office'] = $this->sms_to_office->DefaultValue;
        $row['sms_template_office'] = $this->sms_template_office->DefaultValue;
        $row['sms_template_office_id'] = $this->sms_template_office_id->DefaultValue;
        $row['wa_status_user'] = $this->wa_status_user->DefaultValue;
        $row['wa_type_user'] = $this->wa_type_user->DefaultValue;
        $row['wa_template_user'] = $this->wa_template_user->DefaultValue;
        $row['wa_status_office'] = $this->wa_status_office->DefaultValue;
        $row['wa_type_office'] = $this->wa_type_office->DefaultValue;
        $row['wa_to_office'] = $this->wa_to_office->DefaultValue;
        $row['wa_template_office'] = $this->wa_template_office->DefaultValue;
        $row['wa_id'] = $this->wa_id->DefaultValue;
        $row['notification_status_user'] = $this->notification_status_user->DefaultValue;
        $row['notification_template_user'] = $this->notification_template_user->DefaultValue;
        $row['notification_status_office'] = $this->notification_status_office->DefaultValue;
        $row['notification_to_office'] = $this->notification_to_office->DefaultValue;
        $row['notification_template_office'] = $this->notification_template_office->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['visible'] = $this->_visible->DefaultValue;
        $row['cron'] = $this->cron->DefaultValue;
        $row['next_cycle'] = $this->next_cycle->DefaultValue;
        $row['delay'] = $this->delay->DefaultValue;
        $row['delay_method'] = $this->delay_method->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['operator_admin'] = $this->operator_admin->DefaultValue;
        $row['datetime_admin'] = $this->datetime_admin->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // variables
        $this->variables->RowCssClass = "row";

        // subject
        $this->subject->RowCssClass = "row";

        // status_email_user
        $this->status_email_user->RowCssClass = "row";

        // email_template_user
        $this->email_template_user->RowCssClass = "row";

        // mail_to_office
        $this->mail_to_office->RowCssClass = "row";

        // status_email_office
        $this->status_email_office->RowCssClass = "row";

        // email_template_office
        $this->email_template_office->RowCssClass = "row";

        // status_sms_user
        $this->status_sms_user->RowCssClass = "row";

        // sms_template_user
        $this->sms_template_user->RowCssClass = "row";

        // sms_template_user_id
        $this->sms_template_user_id->RowCssClass = "row";

        // status_sms_office
        $this->status_sms_office->RowCssClass = "row";

        // sms_to_office
        $this->sms_to_office->RowCssClass = "row";

        // sms_template_office
        $this->sms_template_office->RowCssClass = "row";

        // sms_template_office_id
        $this->sms_template_office_id->RowCssClass = "row";

        // wa_status_user
        $this->wa_status_user->RowCssClass = "row";

        // wa_type_user
        $this->wa_type_user->RowCssClass = "row";

        // wa_template_user
        $this->wa_template_user->RowCssClass = "row";

        // wa_status_office
        $this->wa_status_office->RowCssClass = "row";

        // wa_type_office
        $this->wa_type_office->RowCssClass = "row";

        // wa_to_office
        $this->wa_to_office->RowCssClass = "row";

        // wa_template_office
        $this->wa_template_office->RowCssClass = "row";

        // wa_id
        $this->wa_id->RowCssClass = "row";

        // notification_status_user
        $this->notification_status_user->RowCssClass = "row";

        // notification_template_user
        $this->notification_template_user->RowCssClass = "row";

        // notification_status_office
        $this->notification_status_office->RowCssClass = "row";

        // notification_to_office
        $this->notification_to_office->RowCssClass = "row";

        // notification_template_office
        $this->notification_template_office->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // visible
        $this->_visible->RowCssClass = "row";

        // cron
        $this->cron->RowCssClass = "row";

        // next_cycle
        $this->next_cycle->RowCssClass = "row";

        // delay
        $this->delay->RowCssClass = "row";

        // delay_method
        $this->delay_method->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // operator_admin
        $this->operator_admin->RowCssClass = "row";

        // datetime_admin
        $this->datetime_admin->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // variables
            $this->variables->ViewValue = $this->variables->CurrentValue;

            // subject
            $this->subject->ViewValue = $this->subject->CurrentValue;

            // status_email_user
            if (strval($this->status_email_user->CurrentValue) != "") {
                $this->status_email_user->ViewValue = $this->status_email_user->optionCaption($this->status_email_user->CurrentValue);
            } else {
                $this->status_email_user->ViewValue = null;
            }

            // email_template_user
            $this->email_template_user->ViewValue = $this->email_template_user->CurrentValue;

            // mail_to_office
            $this->mail_to_office->ViewValue = $this->mail_to_office->CurrentValue;

            // status_email_office
            if (strval($this->status_email_office->CurrentValue) != "") {
                $this->status_email_office->ViewValue = $this->status_email_office->optionCaption($this->status_email_office->CurrentValue);
            } else {
                $this->status_email_office->ViewValue = null;
            }

            // email_template_office
            $this->email_template_office->ViewValue = $this->email_template_office->CurrentValue;

            // status_sms_user
            if (strval($this->status_sms_user->CurrentValue) != "") {
                $this->status_sms_user->ViewValue = $this->status_sms_user->optionCaption($this->status_sms_user->CurrentValue);
            } else {
                $this->status_sms_user->ViewValue = null;
            }

            // sms_template_user
            $this->sms_template_user->ViewValue = $this->sms_template_user->CurrentValue;

            // sms_template_user_id
            $this->sms_template_user_id->ViewValue = $this->sms_template_user_id->CurrentValue;

            // status_sms_office
            if (strval($this->status_sms_office->CurrentValue) != "") {
                $this->status_sms_office->ViewValue = $this->status_sms_office->optionCaption($this->status_sms_office->CurrentValue);
            } else {
                $this->status_sms_office->ViewValue = null;
            }

            // sms_to_office
            $this->sms_to_office->ViewValue = $this->sms_to_office->CurrentValue;

            // sms_template_office
            $this->sms_template_office->ViewValue = $this->sms_template_office->CurrentValue;

            // sms_template_office_id
            $this->sms_template_office_id->ViewValue = $this->sms_template_office_id->CurrentValue;

            // wa_status_user
            if (strval($this->wa_status_user->CurrentValue) != "") {
                $this->wa_status_user->ViewValue = $this->wa_status_user->optionCaption($this->wa_status_user->CurrentValue);
            } else {
                $this->wa_status_user->ViewValue = null;
            }

            // wa_type_user
            $curVal = strval($this->wa_type_user->CurrentValue);
            if ($curVal != "") {
                $this->wa_type_user->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
                if ($this->wa_type_user->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_type_user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->wa_type_user->getSelectFilter($this); // PHP
                    $sqlWrk = $this->wa_type_user->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_type_user->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_type_user->ViewValue = $this->wa_type_user->displayValue($arwrk);
                    } else {
                        $this->wa_type_user->ViewValue = FormatNumber($this->wa_type_user->CurrentValue, $this->wa_type_user->formatPattern());
                    }
                }
            } else {
                $this->wa_type_user->ViewValue = null;
            }

            // wa_template_user
            $this->wa_template_user->ViewValue = $this->wa_template_user->CurrentValue;

            // wa_status_office
            if (strval($this->wa_status_office->CurrentValue) != "") {
                $this->wa_status_office->ViewValue = $this->wa_status_office->optionCaption($this->wa_status_office->CurrentValue);
            } else {
                $this->wa_status_office->ViewValue = null;
            }

            // wa_type_office
            $curVal = strval($this->wa_type_office->CurrentValue);
            if ($curVal != "") {
                $this->wa_type_office->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
                if ($this->wa_type_office->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_type_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_office->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->wa_type_office->getSelectFilter($this); // PHP
                    $sqlWrk = $this->wa_type_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_type_office->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_type_office->ViewValue = $this->wa_type_office->displayValue($arwrk);
                    } else {
                        $this->wa_type_office->ViewValue = FormatNumber($this->wa_type_office->CurrentValue, $this->wa_type_office->formatPattern());
                    }
                }
            } else {
                $this->wa_type_office->ViewValue = null;
            }

            // wa_to_office
            $this->wa_to_office->ViewValue = $this->wa_to_office->CurrentValue;

            // wa_template_office
            $this->wa_template_office->ViewValue = $this->wa_template_office->CurrentValue;

            // wa_id
            $curVal = strval($this->wa_id->CurrentValue);
            if ($curVal != "") {
                $this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
                if ($this->wa_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->wa_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->wa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->wa_id->Lookup->renderViewRow($rswrk[0]);
                        $this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
                    } else {
                        $this->wa_id->ViewValue = FormatNumber($this->wa_id->CurrentValue, $this->wa_id->formatPattern());
                    }
                }
            } else {
                $this->wa_id->ViewValue = null;
            }

            // notification_status_user
            if (strval($this->notification_status_user->CurrentValue) != "") {
                $this->notification_status_user->ViewValue = $this->notification_status_user->optionCaption($this->notification_status_user->CurrentValue);
            } else {
                $this->notification_status_user->ViewValue = null;
            }

            // notification_template_user
            $this->notification_template_user->ViewValue = $this->notification_template_user->CurrentValue;

            // notification_status_office
            if (strval($this->notification_status_office->CurrentValue) != "") {
                $this->notification_status_office->ViewValue = $this->notification_status_office->optionCaption($this->notification_status_office->CurrentValue);
            } else {
                $this->notification_status_office->ViewValue = null;
            }

            // notification_to_office
            $curVal = strval($this->notification_to_office->CurrentValue);
            if ($curVal != "") {
                $this->notification_to_office->ViewValue = $this->notification_to_office->lookupCacheOption($curVal);
                if ($this->notification_to_office->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->notification_to_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->notification_to_office->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->notification_to_office->getSelectFilter($this); // PHP
                    $sqlWrk = $this->notification_to_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->notification_to_office->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->notification_to_office->Lookup->renderViewRow($row);
                            $this->notification_to_office->ViewValue->add($this->notification_to_office->displayValue($arwrk));
                        }
                    } else {
                        $this->notification_to_office->ViewValue = $this->notification_to_office->CurrentValue;
                    }
                }
            } else {
                $this->notification_to_office->ViewValue = null;
            }

            // notification_template_office
            $this->notification_template_office->ViewValue = $this->notification_template_office->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // visible
            if (strval($this->_visible->CurrentValue) != "") {
                $this->_visible->ViewValue = $this->_visible->optionCaption($this->_visible->CurrentValue);
            } else {
                $this->_visible->ViewValue = null;
            }

            // cron
            if (strval($this->cron->CurrentValue) != "") {
                $this->cron->ViewValue = $this->cron->optionCaption($this->cron->CurrentValue);
            } else {
                $this->cron->ViewValue = null;
            }

            // next_cycle
            $this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
            $this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, $this->next_cycle->formatPattern());

            // delay
            $this->delay->ViewValue = $this->delay->CurrentValue;
            $this->delay->ViewValue = FormatNumber($this->delay->ViewValue, $this->delay->formatPattern());

            // delay_method
            if (strval($this->delay_method->CurrentValue) != "") {
                $this->delay_method->ViewValue = $this->delay_method->optionCaption($this->delay_method->CurrentValue);
            } else {
                $this->delay_method->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // operator_admin
            $this->operator_admin->ViewValue = $this->operator_admin->CurrentValue;

            // datetime_admin
            $this->datetime_admin->ViewValue = $this->datetime_admin->CurrentValue;
            $this->datetime_admin->ViewValue = FormatDateTime($this->datetime_admin->ViewValue, $this->datetime_admin->formatPattern());

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";

            // description
            if (!EmptyValue($this->id->CurrentValue)) {
                $this->description->HrefValue = $this->description->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
                $this->description->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
                }
            } else {
                $this->description->HrefValue = "";
            }

            // variables
            $this->variables->HrefValue = "";

            // subject
            $this->subject->HrefValue = "";

            // status_email_user
            $this->status_email_user->HrefValue = "";

            // email_template_user
            $this->email_template_user->HrefValue = "";

            // mail_to_office
            $this->mail_to_office->HrefValue = "";

            // status_email_office
            $this->status_email_office->HrefValue = "";

            // email_template_office
            $this->email_template_office->HrefValue = "";

            // status_sms_user
            $this->status_sms_user->HrefValue = "";

            // sms_template_user
            $this->sms_template_user->HrefValue = "";

            // sms_template_user_id
            $this->sms_template_user_id->HrefValue = "";

            // status_sms_office
            $this->status_sms_office->HrefValue = "";

            // sms_to_office
            $this->sms_to_office->HrefValue = "";

            // sms_template_office
            $this->sms_template_office->HrefValue = "";

            // sms_template_office_id
            $this->sms_template_office_id->HrefValue = "";

            // wa_status_user
            $this->wa_status_user->HrefValue = "";

            // wa_type_user
            $this->wa_type_user->HrefValue = "";

            // wa_template_user
            $this->wa_template_user->HrefValue = "";

            // wa_status_office
            $this->wa_status_office->HrefValue = "";

            // wa_type_office
            $this->wa_type_office->HrefValue = "";

            // wa_to_office
            $this->wa_to_office->HrefValue = "";

            // wa_template_office
            $this->wa_template_office->HrefValue = "";

            // wa_id
            $this->wa_id->HrefValue = "";

            // notification_status_user
            $this->notification_status_user->HrefValue = "";

            // notification_template_user
            $this->notification_template_user->HrefValue = "";

            // notification_status_office
            $this->notification_status_office->HrefValue = "";

            // notification_to_office
            $this->notification_to_office->HrefValue = "";

            // notification_template_office
            $this->notification_template_office->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // visible
            $this->_visible->HrefValue = "";

            // cron
            $this->cron->HrefValue = "";

            // next_cycle
            $this->next_cycle->HrefValue = "";

            // delay
            $this->delay->HrefValue = "";

            // delay_method
            $this->delay_method->HrefValue = "";

            // operator_admin
            $this->operator_admin->HrefValue = "";

            // datetime_admin
            $this->datetime_admin->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());
            if (strval($this->id->EditValue) != "" && is_numeric($this->id->EditValue)) {
                $this->id->EditValue = $this->id->EditValue;
            }

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // description
            $this->description->setupEditAttributes();
            if (!$this->description->Raw) {
                $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
            }
            $this->description->EditValue = HtmlEncode($this->description->CurrentValue);
            $this->description->PlaceHolder = RemoveHtml($this->description->caption());

            // variables
            $this->variables->setupEditAttributes();
            $this->variables->EditValue = HtmlEncode($this->variables->CurrentValue);
            $this->variables->PlaceHolder = RemoveHtml($this->variables->caption());

            // subject
            $this->subject->setupEditAttributes();
            if (!$this->subject->Raw) {
                $this->subject->CurrentValue = HtmlDecode($this->subject->CurrentValue);
            }
            $this->subject->EditValue = HtmlEncode($this->subject->CurrentValue);
            $this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

            // status_email_user
            $this->status_email_user->setupEditAttributes();
            $this->status_email_user->EditValue = $this->status_email_user->options(true);
            $this->status_email_user->PlaceHolder = RemoveHtml($this->status_email_user->caption());

            // email_template_user
            $this->email_template_user->setupEditAttributes();
            $this->email_template_user->EditValue = HtmlEncode($this->email_template_user->CurrentValue);
            $this->email_template_user->PlaceHolder = RemoveHtml($this->email_template_user->caption());

            // mail_to_office
            $this->mail_to_office->setupEditAttributes();
            if (!$this->mail_to_office->Raw) {
                $this->mail_to_office->CurrentValue = HtmlDecode($this->mail_to_office->CurrentValue);
            }
            $this->mail_to_office->EditValue = HtmlEncode($this->mail_to_office->CurrentValue);
            $this->mail_to_office->PlaceHolder = RemoveHtml($this->mail_to_office->caption());

            // status_email_office
            $this->status_email_office->setupEditAttributes();
            $this->status_email_office->EditValue = $this->status_email_office->options(true);
            $this->status_email_office->PlaceHolder = RemoveHtml($this->status_email_office->caption());

            // email_template_office
            $this->email_template_office->setupEditAttributes();
            $this->email_template_office->EditValue = HtmlEncode($this->email_template_office->CurrentValue);
            $this->email_template_office->PlaceHolder = RemoveHtml($this->email_template_office->caption());

            // status_sms_user
            $this->status_sms_user->setupEditAttributes();
            $this->status_sms_user->EditValue = $this->status_sms_user->options(true);
            $this->status_sms_user->PlaceHolder = RemoveHtml($this->status_sms_user->caption());

            // sms_template_user
            $this->sms_template_user->setupEditAttributes();
            $this->sms_template_user->EditValue = HtmlEncode($this->sms_template_user->CurrentValue);
            $this->sms_template_user->PlaceHolder = RemoveHtml($this->sms_template_user->caption());

            // sms_template_user_id
            $this->sms_template_user_id->setupEditAttributes();
            if (!$this->sms_template_user_id->Raw) {
                $this->sms_template_user_id->CurrentValue = HtmlDecode($this->sms_template_user_id->CurrentValue);
            }
            $this->sms_template_user_id->EditValue = HtmlEncode($this->sms_template_user_id->CurrentValue);
            $this->sms_template_user_id->PlaceHolder = RemoveHtml($this->sms_template_user_id->caption());

            // status_sms_office
            $this->status_sms_office->setupEditAttributes();
            $this->status_sms_office->EditValue = $this->status_sms_office->options(true);
            $this->status_sms_office->PlaceHolder = RemoveHtml($this->status_sms_office->caption());

            // sms_to_office
            $this->sms_to_office->setupEditAttributes();
            if (!$this->sms_to_office->Raw) {
                $this->sms_to_office->CurrentValue = HtmlDecode($this->sms_to_office->CurrentValue);
            }
            $this->sms_to_office->EditValue = HtmlEncode($this->sms_to_office->CurrentValue);
            $this->sms_to_office->PlaceHolder = RemoveHtml($this->sms_to_office->caption());

            // sms_template_office
            $this->sms_template_office->setupEditAttributes();
            $this->sms_template_office->EditValue = HtmlEncode($this->sms_template_office->CurrentValue);
            $this->sms_template_office->PlaceHolder = RemoveHtml($this->sms_template_office->caption());

            // sms_template_office_id
            $this->sms_template_office_id->setupEditAttributes();
            if (!$this->sms_template_office_id->Raw) {
                $this->sms_template_office_id->CurrentValue = HtmlDecode($this->sms_template_office_id->CurrentValue);
            }
            $this->sms_template_office_id->EditValue = HtmlEncode($this->sms_template_office_id->CurrentValue);
            $this->sms_template_office_id->PlaceHolder = RemoveHtml($this->sms_template_office_id->caption());

            // wa_status_user
            $this->wa_status_user->setupEditAttributes();
            $this->wa_status_user->EditValue = $this->wa_status_user->options(true);
            $this->wa_status_user->PlaceHolder = RemoveHtml($this->wa_status_user->caption());

            // wa_type_user
            $this->wa_type_user->setupEditAttributes();
            $curVal = trim(strval($this->wa_type_user->CurrentValue));
            if ($curVal != "") {
                $this->wa_type_user->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
            } else {
                $this->wa_type_user->ViewValue = $this->wa_type_user->Lookup !== null && is_array($this->wa_type_user->lookupOptions()) && count($this->wa_type_user->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->wa_type_user->ViewValue !== null) { // Load from cache
                $this->wa_type_user->EditValue = array_values($this->wa_type_user->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->wa_type_user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->wa_type_user->CurrentValue, $this->wa_type_user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->wa_type_user->getSelectFilter($this); // PHP
                $sqlWrk = $this->wa_type_user->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->wa_type_user->EditValue = $arwrk;
            }
            $this->wa_type_user->PlaceHolder = RemoveHtml($this->wa_type_user->caption());

            // wa_template_user
            $this->wa_template_user->setupEditAttributes();
            $this->wa_template_user->EditValue = HtmlEncode($this->wa_template_user->CurrentValue);
            $this->wa_template_user->PlaceHolder = RemoveHtml($this->wa_template_user->caption());

            // wa_status_office
            $this->wa_status_office->setupEditAttributes();
            $this->wa_status_office->EditValue = $this->wa_status_office->options(true);
            $this->wa_status_office->PlaceHolder = RemoveHtml($this->wa_status_office->caption());

            // wa_type_office
            $this->wa_type_office->setupEditAttributes();
            $curVal = trim(strval($this->wa_type_office->CurrentValue));
            if ($curVal != "") {
                $this->wa_type_office->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
            } else {
                $this->wa_type_office->ViewValue = $this->wa_type_office->Lookup !== null && is_array($this->wa_type_office->lookupOptions()) && count($this->wa_type_office->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->wa_type_office->ViewValue !== null) { // Load from cache
                $this->wa_type_office->EditValue = array_values($this->wa_type_office->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->wa_type_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->wa_type_office->CurrentValue, $this->wa_type_office->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->wa_type_office->getSelectFilter($this); // PHP
                $sqlWrk = $this->wa_type_office->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->wa_type_office->EditValue = $arwrk;
            }
            $this->wa_type_office->PlaceHolder = RemoveHtml($this->wa_type_office->caption());

            // wa_to_office
            $this->wa_to_office->setupEditAttributes();
            if (!$this->wa_to_office->Raw) {
                $this->wa_to_office->CurrentValue = HtmlDecode($this->wa_to_office->CurrentValue);
            }
            $this->wa_to_office->EditValue = HtmlEncode($this->wa_to_office->CurrentValue);
            $this->wa_to_office->PlaceHolder = RemoveHtml($this->wa_to_office->caption());

            // wa_template_office
            $this->wa_template_office->setupEditAttributes();
            $this->wa_template_office->EditValue = HtmlEncode($this->wa_template_office->CurrentValue);
            $this->wa_template_office->PlaceHolder = RemoveHtml($this->wa_template_office->caption());

            // wa_id
            $this->wa_id->setupEditAttributes();
            $curVal = trim(strval($this->wa_id->CurrentValue));
            if ($curVal != "") {
                $this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
            } else {
                $this->wa_id->ViewValue = $this->wa_id->Lookup !== null && is_array($this->wa_id->lookupOptions()) && count($this->wa_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->wa_id->ViewValue !== null) { // Load from cache
                $this->wa_id->EditValue = array_values($this->wa_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->wa_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->wa_id->CurrentValue, $this->wa_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->wa_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->wa_id->EditValue = $arwrk;
            }
            $this->wa_id->PlaceHolder = RemoveHtml($this->wa_id->caption());

            // notification_status_user
            $this->notification_status_user->setupEditAttributes();
            $this->notification_status_user->EditValue = $this->notification_status_user->options(true);
            $this->notification_status_user->PlaceHolder = RemoveHtml($this->notification_status_user->caption());

            // notification_template_user
            $this->notification_template_user->setupEditAttributes();
            $this->notification_template_user->EditValue = HtmlEncode($this->notification_template_user->CurrentValue);
            $this->notification_template_user->PlaceHolder = RemoveHtml($this->notification_template_user->caption());

            // notification_status_office
            $this->notification_status_office->setupEditAttributes();
            $this->notification_status_office->EditValue = $this->notification_status_office->options(true);
            $this->notification_status_office->PlaceHolder = RemoveHtml($this->notification_status_office->caption());

            // notification_to_office
            $this->notification_to_office->setupEditAttributes();
            $curVal = trim(strval($this->notification_to_office->CurrentValue));
            if ($curVal != "") {
                $this->notification_to_office->ViewValue = $this->notification_to_office->lookupCacheOption($curVal);
            } else {
                $this->notification_to_office->ViewValue = $this->notification_to_office->Lookup !== null && is_array($this->notification_to_office->lookupOptions()) && count($this->notification_to_office->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->notification_to_office->ViewValue !== null) { // Load from cache
                $this->notification_to_office->EditValue = array_values($this->notification_to_office->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->notification_to_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->notification_to_office->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->notification_to_office->getSelectFilter($this); // PHP
                $sqlWrk = $this->notification_to_office->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->notification_to_office->EditValue = $arwrk;
            }
            $this->notification_to_office->PlaceHolder = RemoveHtml($this->notification_to_office->caption());

            // notification_template_office
            $this->notification_template_office->setupEditAttributes();
            $this->notification_template_office->EditValue = HtmlEncode($this->notification_template_office->CurrentValue);
            $this->notification_template_office->PlaceHolder = RemoveHtml($this->notification_template_office->caption());

            // code
            $this->code->setupEditAttributes();
            $this->code->EditValue = HtmlEncode($this->code->CurrentValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // visible
            $this->_visible->setupEditAttributes();
            $this->_visible->EditValue = $this->_visible->options(true);
            $this->_visible->PlaceHolder = RemoveHtml($this->_visible->caption());

            // cron
            $this->cron->setupEditAttributes();
            $this->cron->EditValue = $this->cron->options(true);
            $this->cron->PlaceHolder = RemoveHtml($this->cron->caption());

            // next_cycle
            $this->next_cycle->setupEditAttributes();
            $this->next_cycle->EditValue = HtmlEncode(FormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern()));
            $this->next_cycle->PlaceHolder = RemoveHtml($this->next_cycle->caption());

            // delay
            $this->delay->setupEditAttributes();
            $this->delay->EditValue = $this->delay->CurrentValue;
            $this->delay->PlaceHolder = RemoveHtml($this->delay->caption());
            if (strval($this->delay->EditValue) != "" && is_numeric($this->delay->EditValue)) {
                $this->delay->EditValue = FormatNumber($this->delay->EditValue, null);
            }

            // delay_method
            $this->delay_method->setupEditAttributes();
            $this->delay_method->EditValue = $this->delay_method->options(true);
            $this->delay_method->PlaceHolder = RemoveHtml($this->delay_method->caption());

            // operator_admin

            // datetime_admin

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // description
            if (!EmptyValue($this->id->CurrentValue)) {
                $this->description->HrefValue = $this->description->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
                $this->description->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
                }
            } else {
                $this->description->HrefValue = "";
            }

            // variables
            $this->variables->HrefValue = "";

            // subject
            $this->subject->HrefValue = "";

            // status_email_user
            $this->status_email_user->HrefValue = "";

            // email_template_user
            $this->email_template_user->HrefValue = "";

            // mail_to_office
            $this->mail_to_office->HrefValue = "";

            // status_email_office
            $this->status_email_office->HrefValue = "";

            // email_template_office
            $this->email_template_office->HrefValue = "";

            // status_sms_user
            $this->status_sms_user->HrefValue = "";

            // sms_template_user
            $this->sms_template_user->HrefValue = "";

            // sms_template_user_id
            $this->sms_template_user_id->HrefValue = "";

            // status_sms_office
            $this->status_sms_office->HrefValue = "";

            // sms_to_office
            $this->sms_to_office->HrefValue = "";

            // sms_template_office
            $this->sms_template_office->HrefValue = "";

            // sms_template_office_id
            $this->sms_template_office_id->HrefValue = "";

            // wa_status_user
            $this->wa_status_user->HrefValue = "";

            // wa_type_user
            $this->wa_type_user->HrefValue = "";

            // wa_template_user
            $this->wa_template_user->HrefValue = "";

            // wa_status_office
            $this->wa_status_office->HrefValue = "";

            // wa_type_office
            $this->wa_type_office->HrefValue = "";

            // wa_to_office
            $this->wa_to_office->HrefValue = "";

            // wa_template_office
            $this->wa_template_office->HrefValue = "";

            // wa_id
            $this->wa_id->HrefValue = "";

            // notification_status_user
            $this->notification_status_user->HrefValue = "";

            // notification_template_user
            $this->notification_template_user->HrefValue = "";

            // notification_status_office
            $this->notification_status_office->HrefValue = "";

            // notification_to_office
            $this->notification_to_office->HrefValue = "";

            // notification_template_office
            $this->notification_template_office->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // visible
            $this->_visible->HrefValue = "";

            // cron
            $this->cron->HrefValue = "";

            // next_cycle
            $this->next_cycle->HrefValue = "";

            // delay
            $this->delay->HrefValue = "";

            // delay_method
            $this->delay_method->HrefValue = "";

            // operator_admin
            $this->operator_admin->HrefValue = "";

            // datetime_admin
            $this->datetime_admin->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->id->FormValue)) {
                $this->id->addErrorMessage($this->id->getErrorMessage(false));
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->description->Visible && $this->description->Required) {
                if (!$this->description->IsDetailKey && EmptyValue($this->description->FormValue)) {
                    $this->description->addErrorMessage(str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
                }
            }
            if ($this->variables->Visible && $this->variables->Required) {
                if (!$this->variables->IsDetailKey && EmptyValue($this->variables->FormValue)) {
                    $this->variables->addErrorMessage(str_replace("%s", $this->variables->caption(), $this->variables->RequiredErrorMessage));
                }
            }
            if ($this->subject->Visible && $this->subject->Required) {
                if (!$this->subject->IsDetailKey && EmptyValue($this->subject->FormValue)) {
                    $this->subject->addErrorMessage(str_replace("%s", $this->subject->caption(), $this->subject->RequiredErrorMessage));
                }
            }
            if ($this->status_email_user->Visible && $this->status_email_user->Required) {
                if (!$this->status_email_user->IsDetailKey && EmptyValue($this->status_email_user->FormValue)) {
                    $this->status_email_user->addErrorMessage(str_replace("%s", $this->status_email_user->caption(), $this->status_email_user->RequiredErrorMessage));
                }
            }
            if ($this->email_template_user->Visible && $this->email_template_user->Required) {
                if (!$this->email_template_user->IsDetailKey && EmptyValue($this->email_template_user->FormValue)) {
                    $this->email_template_user->addErrorMessage(str_replace("%s", $this->email_template_user->caption(), $this->email_template_user->RequiredErrorMessage));
                }
            }
            if ($this->mail_to_office->Visible && $this->mail_to_office->Required) {
                if (!$this->mail_to_office->IsDetailKey && EmptyValue($this->mail_to_office->FormValue)) {
                    $this->mail_to_office->addErrorMessage(str_replace("%s", $this->mail_to_office->caption(), $this->mail_to_office->RequiredErrorMessage));
                }
            }
            if ($this->status_email_office->Visible && $this->status_email_office->Required) {
                if (!$this->status_email_office->IsDetailKey && EmptyValue($this->status_email_office->FormValue)) {
                    $this->status_email_office->addErrorMessage(str_replace("%s", $this->status_email_office->caption(), $this->status_email_office->RequiredErrorMessage));
                }
            }
            if ($this->email_template_office->Visible && $this->email_template_office->Required) {
                if (!$this->email_template_office->IsDetailKey && EmptyValue($this->email_template_office->FormValue)) {
                    $this->email_template_office->addErrorMessage(str_replace("%s", $this->email_template_office->caption(), $this->email_template_office->RequiredErrorMessage));
                }
            }
            if ($this->status_sms_user->Visible && $this->status_sms_user->Required) {
                if (!$this->status_sms_user->IsDetailKey && EmptyValue($this->status_sms_user->FormValue)) {
                    $this->status_sms_user->addErrorMessage(str_replace("%s", $this->status_sms_user->caption(), $this->status_sms_user->RequiredErrorMessage));
                }
            }
            if ($this->sms_template_user->Visible && $this->sms_template_user->Required) {
                if (!$this->sms_template_user->IsDetailKey && EmptyValue($this->sms_template_user->FormValue)) {
                    $this->sms_template_user->addErrorMessage(str_replace("%s", $this->sms_template_user->caption(), $this->sms_template_user->RequiredErrorMessage));
                }
            }
            if ($this->sms_template_user_id->Visible && $this->sms_template_user_id->Required) {
                if (!$this->sms_template_user_id->IsDetailKey && EmptyValue($this->sms_template_user_id->FormValue)) {
                    $this->sms_template_user_id->addErrorMessage(str_replace("%s", $this->sms_template_user_id->caption(), $this->sms_template_user_id->RequiredErrorMessage));
                }
            }
            if ($this->status_sms_office->Visible && $this->status_sms_office->Required) {
                if (!$this->status_sms_office->IsDetailKey && EmptyValue($this->status_sms_office->FormValue)) {
                    $this->status_sms_office->addErrorMessage(str_replace("%s", $this->status_sms_office->caption(), $this->status_sms_office->RequiredErrorMessage));
                }
            }
            if ($this->sms_to_office->Visible && $this->sms_to_office->Required) {
                if (!$this->sms_to_office->IsDetailKey && EmptyValue($this->sms_to_office->FormValue)) {
                    $this->sms_to_office->addErrorMessage(str_replace("%s", $this->sms_to_office->caption(), $this->sms_to_office->RequiredErrorMessage));
                }
            }
            if ($this->sms_template_office->Visible && $this->sms_template_office->Required) {
                if (!$this->sms_template_office->IsDetailKey && EmptyValue($this->sms_template_office->FormValue)) {
                    $this->sms_template_office->addErrorMessage(str_replace("%s", $this->sms_template_office->caption(), $this->sms_template_office->RequiredErrorMessage));
                }
            }
            if ($this->sms_template_office_id->Visible && $this->sms_template_office_id->Required) {
                if (!$this->sms_template_office_id->IsDetailKey && EmptyValue($this->sms_template_office_id->FormValue)) {
                    $this->sms_template_office_id->addErrorMessage(str_replace("%s", $this->sms_template_office_id->caption(), $this->sms_template_office_id->RequiredErrorMessage));
                }
            }
            if ($this->wa_status_user->Visible && $this->wa_status_user->Required) {
                if (!$this->wa_status_user->IsDetailKey && EmptyValue($this->wa_status_user->FormValue)) {
                    $this->wa_status_user->addErrorMessage(str_replace("%s", $this->wa_status_user->caption(), $this->wa_status_user->RequiredErrorMessage));
                }
            }
            if ($this->wa_type_user->Visible && $this->wa_type_user->Required) {
                if (!$this->wa_type_user->IsDetailKey && EmptyValue($this->wa_type_user->FormValue)) {
                    $this->wa_type_user->addErrorMessage(str_replace("%s", $this->wa_type_user->caption(), $this->wa_type_user->RequiredErrorMessage));
                }
            }
            if ($this->wa_template_user->Visible && $this->wa_template_user->Required) {
                if (!$this->wa_template_user->IsDetailKey && EmptyValue($this->wa_template_user->FormValue)) {
                    $this->wa_template_user->addErrorMessage(str_replace("%s", $this->wa_template_user->caption(), $this->wa_template_user->RequiredErrorMessage));
                }
            }
            if ($this->wa_status_office->Visible && $this->wa_status_office->Required) {
                if (!$this->wa_status_office->IsDetailKey && EmptyValue($this->wa_status_office->FormValue)) {
                    $this->wa_status_office->addErrorMessage(str_replace("%s", $this->wa_status_office->caption(), $this->wa_status_office->RequiredErrorMessage));
                }
            }
            if ($this->wa_type_office->Visible && $this->wa_type_office->Required) {
                if (!$this->wa_type_office->IsDetailKey && EmptyValue($this->wa_type_office->FormValue)) {
                    $this->wa_type_office->addErrorMessage(str_replace("%s", $this->wa_type_office->caption(), $this->wa_type_office->RequiredErrorMessage));
                }
            }
            if ($this->wa_to_office->Visible && $this->wa_to_office->Required) {
                if (!$this->wa_to_office->IsDetailKey && EmptyValue($this->wa_to_office->FormValue)) {
                    $this->wa_to_office->addErrorMessage(str_replace("%s", $this->wa_to_office->caption(), $this->wa_to_office->RequiredErrorMessage));
                }
            }
            if ($this->wa_template_office->Visible && $this->wa_template_office->Required) {
                if (!$this->wa_template_office->IsDetailKey && EmptyValue($this->wa_template_office->FormValue)) {
                    $this->wa_template_office->addErrorMessage(str_replace("%s", $this->wa_template_office->caption(), $this->wa_template_office->RequiredErrorMessage));
                }
            }
            if ($this->wa_id->Visible && $this->wa_id->Required) {
                if (!$this->wa_id->IsDetailKey && EmptyValue($this->wa_id->FormValue)) {
                    $this->wa_id->addErrorMessage(str_replace("%s", $this->wa_id->caption(), $this->wa_id->RequiredErrorMessage));
                }
            }
            if ($this->notification_status_user->Visible && $this->notification_status_user->Required) {
                if (!$this->notification_status_user->IsDetailKey && EmptyValue($this->notification_status_user->FormValue)) {
                    $this->notification_status_user->addErrorMessage(str_replace("%s", $this->notification_status_user->caption(), $this->notification_status_user->RequiredErrorMessage));
                }
            }
            if ($this->notification_template_user->Visible && $this->notification_template_user->Required) {
                if (!$this->notification_template_user->IsDetailKey && EmptyValue($this->notification_template_user->FormValue)) {
                    $this->notification_template_user->addErrorMessage(str_replace("%s", $this->notification_template_user->caption(), $this->notification_template_user->RequiredErrorMessage));
                }
            }
            if ($this->notification_status_office->Visible && $this->notification_status_office->Required) {
                if (!$this->notification_status_office->IsDetailKey && EmptyValue($this->notification_status_office->FormValue)) {
                    $this->notification_status_office->addErrorMessage(str_replace("%s", $this->notification_status_office->caption(), $this->notification_status_office->RequiredErrorMessage));
                }
            }
            if ($this->notification_to_office->Visible && $this->notification_to_office->Required) {
                if ($this->notification_to_office->FormValue == "") {
                    $this->notification_to_office->addErrorMessage(str_replace("%s", $this->notification_to_office->caption(), $this->notification_to_office->RequiredErrorMessage));
                }
            }
            if ($this->notification_template_office->Visible && $this->notification_template_office->Required) {
                if (!$this->notification_template_office->IsDetailKey && EmptyValue($this->notification_template_office->FormValue)) {
                    $this->notification_template_office->addErrorMessage(str_replace("%s", $this->notification_template_office->caption(), $this->notification_template_office->RequiredErrorMessage));
                }
            }
            if ($this->code->Visible && $this->code->Required) {
                if (!$this->code->IsDetailKey && EmptyValue($this->code->FormValue)) {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->_visible->Visible && $this->_visible->Required) {
                if (!$this->_visible->IsDetailKey && EmptyValue($this->_visible->FormValue)) {
                    $this->_visible->addErrorMessage(str_replace("%s", $this->_visible->caption(), $this->_visible->RequiredErrorMessage));
                }
            }
            if ($this->cron->Visible && $this->cron->Required) {
                if (!$this->cron->IsDetailKey && EmptyValue($this->cron->FormValue)) {
                    $this->cron->addErrorMessage(str_replace("%s", $this->cron->caption(), $this->cron->RequiredErrorMessage));
                }
            }
            if ($this->next_cycle->Visible && $this->next_cycle->Required) {
                if (!$this->next_cycle->IsDetailKey && EmptyValue($this->next_cycle->FormValue)) {
                    $this->next_cycle->addErrorMessage(str_replace("%s", $this->next_cycle->caption(), $this->next_cycle->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->next_cycle->FormValue, $this->next_cycle->formatPattern())) {
                $this->next_cycle->addErrorMessage($this->next_cycle->getErrorMessage(false));
            }
            if ($this->delay->Visible && $this->delay->Required) {
                if (!$this->delay->IsDetailKey && EmptyValue($this->delay->FormValue)) {
                    $this->delay->addErrorMessage(str_replace("%s", $this->delay->caption(), $this->delay->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->delay->FormValue)) {
                $this->delay->addErrorMessage($this->delay->getErrorMessage(false));
            }
            if ($this->delay_method->Visible && $this->delay_method->Required) {
                if (!$this->delay_method->IsDetailKey && EmptyValue($this->delay_method->FormValue)) {
                    $this->delay_method->addErrorMessage(str_replace("%s", $this->delay_method->caption(), $this->delay_method->RequiredErrorMessage));
                }
            }
            if ($this->operator_admin->Visible && $this->operator_admin->Required) {
                if (!$this->operator_admin->IsDetailKey && EmptyValue($this->operator_admin->FormValue)) {
                    $this->operator_admin->addErrorMessage(str_replace("%s", $this->operator_admin->caption(), $this->operator_admin->RequiredErrorMessage));
                }
            }
            if ($this->datetime_admin->Visible && $this->datetime_admin->Required) {
                if (!$this->datetime_admin->IsDetailKey && EmptyValue($this->datetime_admin->FormValue)) {
                    $this->datetime_admin->addErrorMessage(str_replace("%s", $this->datetime_admin->caption(), $this->datetime_admin->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->id->CurrentValue != "") { // Check field with unique index
            $filter = "(`id` = " . AdjustSql($this->id->CurrentValue, $this->Dbid) . ")";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->id->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->id->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);

        // Check if key value entered
        if ($insertRow && $this->ValidateKey && strval($rsnew['id']) == "") {
            $this->setFailureMessage($Language->phrase("InvalidKeyValue"));
            $insertRow = false;
        }

        // Check for duplicate key
        if ($insertRow && $this->ValidateKey) {
            $filter = $this->getRecordFilter($rsnew);
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
                $this->setFailureMessage($keyErrMsg);
                $insertRow = false;
            }
        }
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // id
        $this->id->setDbValueDef($rsnew, $this->id->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // description
        $this->description->setDbValueDef($rsnew, $this->description->CurrentValue, false);

        // variables
        $this->variables->setDbValueDef($rsnew, $this->variables->CurrentValue, false);

        // subject
        $this->subject->setDbValueDef($rsnew, $this->subject->CurrentValue, false);

        // status_email_user
        $this->status_email_user->setDbValueDef($rsnew, $this->status_email_user->CurrentValue, strval($this->status_email_user->CurrentValue) == "");

        // email_template_user
        $this->email_template_user->setDbValueDef($rsnew, $this->email_template_user->CurrentValue, false);

        // mail_to_office
        $this->mail_to_office->setDbValueDef($rsnew, $this->mail_to_office->CurrentValue, false);

        // status_email_office
        $this->status_email_office->setDbValueDef($rsnew, $this->status_email_office->CurrentValue, strval($this->status_email_office->CurrentValue) == "");

        // email_template_office
        $this->email_template_office->setDbValueDef($rsnew, $this->email_template_office->CurrentValue, false);

        // status_sms_user
        $this->status_sms_user->setDbValueDef($rsnew, $this->status_sms_user->CurrentValue, strval($this->status_sms_user->CurrentValue) == "");

        // sms_template_user
        $this->sms_template_user->setDbValueDef($rsnew, $this->sms_template_user->CurrentValue, false);

        // sms_template_user_id
        $this->sms_template_user_id->setDbValueDef($rsnew, $this->sms_template_user_id->CurrentValue, false);

        // status_sms_office
        $this->status_sms_office->setDbValueDef($rsnew, $this->status_sms_office->CurrentValue, strval($this->status_sms_office->CurrentValue) == "");

        // sms_to_office
        $this->sms_to_office->setDbValueDef($rsnew, $this->sms_to_office->CurrentValue, false);

        // sms_template_office
        $this->sms_template_office->setDbValueDef($rsnew, $this->sms_template_office->CurrentValue, false);

        // sms_template_office_id
        $this->sms_template_office_id->setDbValueDef($rsnew, $this->sms_template_office_id->CurrentValue, false);

        // wa_status_user
        $this->wa_status_user->setDbValueDef($rsnew, $this->wa_status_user->CurrentValue, strval($this->wa_status_user->CurrentValue) == "");

        // wa_type_user
        $this->wa_type_user->setDbValueDef($rsnew, $this->wa_type_user->CurrentValue, strval($this->wa_type_user->CurrentValue) == "");

        // wa_template_user
        $this->wa_template_user->setDbValueDef($rsnew, $this->wa_template_user->CurrentValue, false);

        // wa_status_office
        $this->wa_status_office->setDbValueDef($rsnew, $this->wa_status_office->CurrentValue, false);

        // wa_type_office
        $this->wa_type_office->setDbValueDef($rsnew, $this->wa_type_office->CurrentValue, strval($this->wa_type_office->CurrentValue) == "");

        // wa_to_office
        $this->wa_to_office->setDbValueDef($rsnew, $this->wa_to_office->CurrentValue, false);

        // wa_template_office
        $this->wa_template_office->setDbValueDef($rsnew, $this->wa_template_office->CurrentValue, false);

        // wa_id
        $this->wa_id->setDbValueDef($rsnew, $this->wa_id->CurrentValue, strval($this->wa_id->CurrentValue) == "");

        // notification_status_user
        $this->notification_status_user->setDbValueDef($rsnew, $this->notification_status_user->CurrentValue, strval($this->notification_status_user->CurrentValue) == "");

        // notification_template_user
        $this->notification_template_user->setDbValueDef($rsnew, $this->notification_template_user->CurrentValue, false);

        // notification_status_office
        $this->notification_status_office->setDbValueDef($rsnew, $this->notification_status_office->CurrentValue, strval($this->notification_status_office->CurrentValue) == "");

        // notification_to_office
        $this->notification_to_office->setDbValueDef($rsnew, $this->notification_to_office->CurrentValue, false);

        // notification_template_office
        $this->notification_template_office->setDbValueDef($rsnew, $this->notification_template_office->CurrentValue, false);

        // code
        $this->code->setDbValueDef($rsnew, $this->code->CurrentValue, false);

        // visible
        $this->_visible->setDbValueDef($rsnew, $this->_visible->CurrentValue, strval($this->_visible->CurrentValue) == "");

        // cron
        $this->cron->setDbValueDef($rsnew, $this->cron->CurrentValue, strval($this->cron->CurrentValue) == "");

        // next_cycle
        $this->next_cycle->setDbValueDef($rsnew, UnFormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern()), strval($this->next_cycle->CurrentValue) == "");

        // delay
        $this->delay->setDbValueDef($rsnew, $this->delay->CurrentValue, strval($this->delay->CurrentValue) == "");

        // delay_method
        $this->delay_method->setDbValueDef($rsnew, $this->delay_method->CurrentValue, strval($this->delay_method->CurrentValue) == "");

        // operator_admin
        $this->operator_admin->CurrentValue = $this->operator_admin->getAutoUpdateValue(); // PHP
        $this->operator_admin->setDbValueDef($rsnew, $this->operator_admin->CurrentValue, strval($this->operator_admin->CurrentValue) == "");

        // datetime_admin
        $this->datetime_admin->CurrentValue = $this->datetime_admin->getAutoUpdateValue(); // PHP
        $this->datetime_admin->setDbValueDef($rsnew, UnFormatDateTime($this->datetime_admin->CurrentValue, $this->datetime_admin->formatPattern()), false);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, strval($this->company_id->CurrentValue) == "");
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['id'])) { // id
            $this->id->setFormValue($row['id']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['description'])) { // description
            $this->description->setFormValue($row['description']);
        }
        if (isset($row['variables'])) { // variables
            $this->variables->setFormValue($row['variables']);
        }
        if (isset($row['subject'])) { // subject
            $this->subject->setFormValue($row['subject']);
        }
        if (isset($row['status_email_user'])) { // status_email_user
            $this->status_email_user->setFormValue($row['status_email_user']);
        }
        if (isset($row['email_template_user'])) { // email_template_user
            $this->email_template_user->setFormValue($row['email_template_user']);
        }
        if (isset($row['mail_to_office'])) { // mail_to_office
            $this->mail_to_office->setFormValue($row['mail_to_office']);
        }
        if (isset($row['status_email_office'])) { // status_email_office
            $this->status_email_office->setFormValue($row['status_email_office']);
        }
        if (isset($row['email_template_office'])) { // email_template_office
            $this->email_template_office->setFormValue($row['email_template_office']);
        }
        if (isset($row['status_sms_user'])) { // status_sms_user
            $this->status_sms_user->setFormValue($row['status_sms_user']);
        }
        if (isset($row['sms_template_user'])) { // sms_template_user
            $this->sms_template_user->setFormValue($row['sms_template_user']);
        }
        if (isset($row['sms_template_user_id'])) { // sms_template_user_id
            $this->sms_template_user_id->setFormValue($row['sms_template_user_id']);
        }
        if (isset($row['status_sms_office'])) { // status_sms_office
            $this->status_sms_office->setFormValue($row['status_sms_office']);
        }
        if (isset($row['sms_to_office'])) { // sms_to_office
            $this->sms_to_office->setFormValue($row['sms_to_office']);
        }
        if (isset($row['sms_template_office'])) { // sms_template_office
            $this->sms_template_office->setFormValue($row['sms_template_office']);
        }
        if (isset($row['sms_template_office_id'])) { // sms_template_office_id
            $this->sms_template_office_id->setFormValue($row['sms_template_office_id']);
        }
        if (isset($row['wa_status_user'])) { // wa_status_user
            $this->wa_status_user->setFormValue($row['wa_status_user']);
        }
        if (isset($row['wa_type_user'])) { // wa_type_user
            $this->wa_type_user->setFormValue($row['wa_type_user']);
        }
        if (isset($row['wa_template_user'])) { // wa_template_user
            $this->wa_template_user->setFormValue($row['wa_template_user']);
        }
        if (isset($row['wa_status_office'])) { // wa_status_office
            $this->wa_status_office->setFormValue($row['wa_status_office']);
        }
        if (isset($row['wa_type_office'])) { // wa_type_office
            $this->wa_type_office->setFormValue($row['wa_type_office']);
        }
        if (isset($row['wa_to_office'])) { // wa_to_office
            $this->wa_to_office->setFormValue($row['wa_to_office']);
        }
        if (isset($row['wa_template_office'])) { // wa_template_office
            $this->wa_template_office->setFormValue($row['wa_template_office']);
        }
        if (isset($row['wa_id'])) { // wa_id
            $this->wa_id->setFormValue($row['wa_id']);
        }
        if (isset($row['notification_status_user'])) { // notification_status_user
            $this->notification_status_user->setFormValue($row['notification_status_user']);
        }
        if (isset($row['notification_template_user'])) { // notification_template_user
            $this->notification_template_user->setFormValue($row['notification_template_user']);
        }
        if (isset($row['notification_status_office'])) { // notification_status_office
            $this->notification_status_office->setFormValue($row['notification_status_office']);
        }
        if (isset($row['notification_to_office'])) { // notification_to_office
            $this->notification_to_office->setFormValue($row['notification_to_office']);
        }
        if (isset($row['notification_template_office'])) { // notification_template_office
            $this->notification_template_office->setFormValue($row['notification_template_office']);
        }
        if (isset($row['code'])) { // code
            $this->code->setFormValue($row['code']);
        }
        if (isset($row['visible'])) { // visible
            $this->_visible->setFormValue($row['visible']);
        }
        if (isset($row['cron'])) { // cron
            $this->cron->setFormValue($row['cron']);
        }
        if (isset($row['next_cycle'])) { // next_cycle
            $this->next_cycle->setFormValue($row['next_cycle']);
        }
        if (isset($row['delay'])) { // delay
            $this->delay->setFormValue($row['delay']);
        }
        if (isset($row['delay_method'])) { // delay_method
            $this->delay_method->setFormValue($row['delay_method']);
        }
        if (isset($row['operator_admin'])) { // operator_admin
            $this->operator_admin->setFormValue($row['operator_admin']);
        }
        if (isset($row['datetime_admin'])) { // datetime_admin
            $this->datetime_admin->setFormValue($row['datetime_admin']);
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("messagetemplateadminlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status_email_user":
                    break;
                case "x_status_email_office":
                    break;
                case "x_status_sms_user":
                    break;
                case "x_status_sms_office":
                    break;
                case "x_wa_status_user":
                    break;
                case "x_wa_type_user":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_status_office":
                    break;
                case "x_wa_type_office":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_wa_id":
                    break;
                case "x_notification_status_user":
                    break;
                case "x_notification_status_office":
                    break;
                case "x_notification_to_office":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__visible":
                    break;
                case "x_cron":
                    break;
                case "x_delay_method":
                    break;
                case "x_company_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
