<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for message_template_admin
 */
class MessageTemplateAdmin extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $grp;
    public $description;
    public $variables;
    public $subject;
    public $status_email_user;
    public $email_template_user;
    public $mail_to_office;
    public $status_email_office;
    public $email_template_office;
    public $status_sms_user;
    public $sms_template_user;
    public $sms_template_user_id;
    public $status_sms_office;
    public $sms_to_office;
    public $sms_template_office;
    public $sms_template_office_id;
    public $wa_status_user;
    public $wa_type_user;
    public $wa_template_user;
    public $wa_status_office;
    public $wa_type_office;
    public $wa_to_office;
    public $wa_template_office;
    public $wa_id;
    public $notification_status_user;
    public $notification_template_user;
    public $notification_status_office;
    public $notification_to_office;
    public $notification_template_office;
    public $code;
    public $_visible;
    public $cron;
    public $next_cycle;
    public $delay;
    public $delay_method;
    public $operator;
    public $datetime;
    public $operator_admin;
    public $datetime_admin;
    public $company_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "message_template_admin";
        $this->TableName = 'message_template_admin';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "message_template_admin";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->Required = true; // Required field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`id` > 1 and `status` = 1 ");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'int_fibre_apc_grp', true, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // description
        $this->description = new DbField(
            $this, // Table
            'x_description', // Variable name
            'description', // Name
            '`description`', // Expression
            '`description`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->description->addMethod("getLinkPrefix", fn() => "mailerview?MTID=");
        $this->description->InputTextType = "text";
        $this->description->Nullable = false; // NOT NULL field
        $this->description->Required = true; // Required field
        $this->description->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['description'] = &$this->description;

        // variables
        $this->variables = new DbField(
            $this, // Table
            'x_variables', // Variable name
            'variables', // Name
            '`variables`', // Expression
            '`variables`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`variables`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->variables->InputTextType = "text";
        $this->variables->Nullable = false; // NOT NULL field
        $this->variables->Required = true; // Required field
        $this->variables->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['variables'] = &$this->variables;

        // subject
        $this->subject = new DbField(
            $this, // Table
            'x_subject', // Variable name
            'subject', // Name
            '`subject`', // Expression
            '`subject`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`subject`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->subject->InputTextType = "text";
        $this->subject->Nullable = false; // NOT NULL field
        $this->subject->Required = true; // Required field
        $this->subject->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['subject'] = &$this->subject;

        // status_email_user
        $this->status_email_user = new DbField(
            $this, // Table
            'x_status_email_user', // Variable name
            'status_email_user', // Name
            '`status_email_user`', // Expression
            '`status_email_user`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_email_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status_email_user->addMethod("getDefault", fn() => 0);
        $this->status_email_user->InputTextType = "text";
        $this->status_email_user->Raw = true;
        $this->status_email_user->Nullable = false; // NOT NULL field
        $this->status_email_user->Required = true; // Required field
        $this->status_email_user->setSelectMultiple(false); // Select one
        $this->status_email_user->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status_email_user->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status_email_user->Lookup = new Lookup($this->status_email_user, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status_email_user->OptionCount = 2;
        $this->status_email_user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status_email_user->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status_email_user'] = &$this->status_email_user;

        // email_template_user
        $this->email_template_user = new DbField(
            $this, // Table
            'x_email_template_user', // Variable name
            'email_template_user', // Name
            '`email_template_user`', // Expression
            '`email_template_user`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`email_template_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->email_template_user->InputTextType = "text";
        $this->email_template_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['email_template_user'] = &$this->email_template_user;

        // mail_to_office
        $this->mail_to_office = new DbField(
            $this, // Table
            'x_mail_to_office', // Variable name
            'mail_to_office', // Name
            '`mail_to_office`', // Expression
            '`mail_to_office`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mail_to_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mail_to_office->InputTextType = "text";
        $this->mail_to_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['mail_to_office'] = &$this->mail_to_office;

        // status_email_office
        $this->status_email_office = new DbField(
            $this, // Table
            'x_status_email_office', // Variable name
            'status_email_office', // Name
            '`status_email_office`', // Expression
            '`status_email_office`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_email_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status_email_office->InputTextType = "text";
        $this->status_email_office->Raw = true;
        $this->status_email_office->Nullable = false; // NOT NULL field
        $this->status_email_office->Required = true; // Required field
        $this->status_email_office->setSelectMultiple(false); // Select one
        $this->status_email_office->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status_email_office->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status_email_office->Lookup = new Lookup($this->status_email_office, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status_email_office->OptionCount = 2;
        $this->status_email_office->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status_email_office->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status_email_office'] = &$this->status_email_office;

        // email_template_office
        $this->email_template_office = new DbField(
            $this, // Table
            'x_email_template_office', // Variable name
            'email_template_office', // Name
            '`email_template_office`', // Expression
            '`email_template_office`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`email_template_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->email_template_office->InputTextType = "text";
        $this->email_template_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['email_template_office'] = &$this->email_template_office;

        // status_sms_user
        $this->status_sms_user = new DbField(
            $this, // Table
            'x_status_sms_user', // Variable name
            'status_sms_user', // Name
            '`status_sms_user`', // Expression
            '`status_sms_user`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_sms_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status_sms_user->InputTextType = "text";
        $this->status_sms_user->Raw = true;
        $this->status_sms_user->Nullable = false; // NOT NULL field
        $this->status_sms_user->Required = true; // Required field
        $this->status_sms_user->setSelectMultiple(false); // Select one
        $this->status_sms_user->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status_sms_user->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status_sms_user->Lookup = new Lookup($this->status_sms_user, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status_sms_user->OptionCount = 2;
        $this->status_sms_user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status_sms_user->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status_sms_user'] = &$this->status_sms_user;

        // sms_template_user
        $this->sms_template_user = new DbField(
            $this, // Table
            'x_sms_template_user', // Variable name
            'sms_template_user', // Name
            '`sms_template_user`', // Expression
            '`sms_template_user`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sms_template_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->sms_template_user->InputTextType = "text";
        $this->sms_template_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sms_template_user'] = &$this->sms_template_user;

        // sms_template_user_id
        $this->sms_template_user_id = new DbField(
            $this, // Table
            'x_sms_template_user_id', // Variable name
            'sms_template_user_id', // Name
            '`sms_template_user_id`', // Expression
            '`sms_template_user_id`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sms_template_user_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sms_template_user_id->InputTextType = "text";
        $this->sms_template_user_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sms_template_user_id'] = &$this->sms_template_user_id;

        // status_sms_office
        $this->status_sms_office = new DbField(
            $this, // Table
            'x_status_sms_office', // Variable name
            'status_sms_office', // Name
            '`status_sms_office`', // Expression
            '`status_sms_office`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status_sms_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status_sms_office->InputTextType = "text";
        $this->status_sms_office->Raw = true;
        $this->status_sms_office->Nullable = false; // NOT NULL field
        $this->status_sms_office->Required = true; // Required field
        $this->status_sms_office->setSelectMultiple(false); // Select one
        $this->status_sms_office->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status_sms_office->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status_sms_office->Lookup = new Lookup($this->status_sms_office, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status_sms_office->OptionCount = 2;
        $this->status_sms_office->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status_sms_office->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status_sms_office'] = &$this->status_sms_office;

        // sms_to_office
        $this->sms_to_office = new DbField(
            $this, // Table
            'x_sms_to_office', // Variable name
            'sms_to_office', // Name
            '`sms_to_office`', // Expression
            '`sms_to_office`', // Basic search expression
            200, // Type
            44, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sms_to_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sms_to_office->InputTextType = "text";
        $this->sms_to_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sms_to_office'] = &$this->sms_to_office;

        // sms_template_office
        $this->sms_template_office = new DbField(
            $this, // Table
            'x_sms_template_office', // Variable name
            'sms_template_office', // Name
            '`sms_template_office`', // Expression
            '`sms_template_office`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sms_template_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->sms_template_office->InputTextType = "text";
        $this->sms_template_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sms_template_office'] = &$this->sms_template_office;

        // sms_template_office_id
        $this->sms_template_office_id = new DbField(
            $this, // Table
            'x_sms_template_office_id', // Variable name
            'sms_template_office_id', // Name
            '`sms_template_office_id`', // Expression
            '`sms_template_office_id`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sms_template_office_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sms_template_office_id->InputTextType = "text";
        $this->sms_template_office_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sms_template_office_id'] = &$this->sms_template_office_id;

        // wa_status_user
        $this->wa_status_user = new DbField(
            $this, // Table
            'x_wa_status_user', // Variable name
            'wa_status_user', // Name
            '`wa_status_user`', // Expression
            '`wa_status_user`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_status_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->wa_status_user->addMethod("getDefault", fn() => 0);
        $this->wa_status_user->InputTextType = "text";
        $this->wa_status_user->Raw = true;
        $this->wa_status_user->Nullable = false; // NOT NULL field
        $this->wa_status_user->setSelectMultiple(false); // Select one
        $this->wa_status_user->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->wa_status_user->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->wa_status_user->Lookup = new Lookup($this->wa_status_user, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->wa_status_user->OptionCount = 2;
        $this->wa_status_user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->wa_status_user->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['wa_status_user'] = &$this->wa_status_user;

        // wa_type_user
        $this->wa_type_user = new DbField(
            $this, // Table
            'x_wa_type_user', // Variable name
            'wa_type_user', // Name
            '`wa_type_user`', // Expression
            '`wa_type_user`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_type_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->wa_type_user->addMethod("getSelectFilter", fn() => "`grp` = 2 and `status` = 1");
        $this->wa_type_user->addMethod("getDefault", fn() => 0);
        $this->wa_type_user->InputTextType = "text";
        $this->wa_type_user->Raw = true;
        $this->wa_type_user->setSelectMultiple(false); // Select one
        $this->wa_type_user->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->wa_type_user->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->wa_type_user->Lookup = new Lookup($this->wa_type_user, 'message_type', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->wa_type_user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->wa_type_user->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_type_user'] = &$this->wa_type_user;

        // wa_template_user
        $this->wa_template_user = new DbField(
            $this, // Table
            'x_wa_template_user', // Variable name
            'wa_template_user', // Name
            '`wa_template_user`', // Expression
            '`wa_template_user`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_template_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->wa_template_user->InputTextType = "text";
        $this->wa_template_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_template_user'] = &$this->wa_template_user;

        // wa_status_office
        $this->wa_status_office = new DbField(
            $this, // Table
            'x_wa_status_office', // Variable name
            'wa_status_office', // Name
            '`wa_status_office`', // Expression
            '`wa_status_office`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_status_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->wa_status_office->addMethod("getDefault", fn() => 0);
        $this->wa_status_office->InputTextType = "text";
        $this->wa_status_office->Raw = true;
        $this->wa_status_office->setSelectMultiple(false); // Select one
        $this->wa_status_office->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->wa_status_office->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->wa_status_office->Lookup = new Lookup($this->wa_status_office, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->wa_status_office->OptionCount = 2;
        $this->wa_status_office->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->wa_status_office->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_status_office'] = &$this->wa_status_office;

        // wa_type_office
        $this->wa_type_office = new DbField(
            $this, // Table
            'x_wa_type_office', // Variable name
            'wa_type_office', // Name
            '`wa_type_office`', // Expression
            '`wa_type_office`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_type_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->wa_type_office->addMethod("getSelectFilter", fn() => "`grp` = 2 and `status` = 1");
        $this->wa_type_office->addMethod("getDefault", fn() => 0);
        $this->wa_type_office->InputTextType = "text";
        $this->wa_type_office->Raw = true;
        $this->wa_type_office->setSelectMultiple(false); // Select one
        $this->wa_type_office->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->wa_type_office->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->wa_type_office->Lookup = new Lookup($this->wa_type_office, 'message_type', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->wa_type_office->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->wa_type_office->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_type_office'] = &$this->wa_type_office;

        // wa_to_office
        $this->wa_to_office = new DbField(
            $this, // Table
            'x_wa_to_office', // Variable name
            'wa_to_office', // Name
            '`wa_to_office`', // Expression
            '`wa_to_office`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_to_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->wa_to_office->InputTextType = "text";
        $this->wa_to_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_to_office'] = &$this->wa_to_office;

        // wa_template_office
        $this->wa_template_office = new DbField(
            $this, // Table
            'x_wa_template_office', // Variable name
            'wa_template_office', // Name
            '`wa_template_office`', // Expression
            '`wa_template_office`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_template_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->wa_template_office->InputTextType = "text";
        $this->wa_template_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['wa_template_office'] = &$this->wa_template_office;

        // wa_id
        $this->wa_id = new DbField(
            $this, // Table
            'x_wa_id', // Variable name
            'wa_id', // Name
            '`wa_id`', // Expression
            '`wa_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`wa_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->wa_id->addMethod("getDefault", fn() => 1);
        $this->wa_id->InputTextType = "text";
        $this->wa_id->Raw = true;
        $this->wa_id->Nullable = false; // NOT NULL field
        $this->wa_id->Required = true; // Required field
        $this->wa_id->setSelectMultiple(false); // Select one
        $this->wa_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->wa_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->wa_id->Lookup = new Lookup($this->wa_id, 'whatsapp_setup', false, 'id', ["mobile","","",""], '', '', [], [], [], [], [], [], false, '`mobile` ASC', '', "`mobile`");
        $this->wa_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->wa_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['wa_id'] = &$this->wa_id;

        // notification_status_user
        $this->notification_status_user = new DbField(
            $this, // Table
            'x_notification_status_user', // Variable name
            'notification_status_user', // Name
            '`notification_status_user`', // Expression
            '`notification_status_user`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_status_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->notification_status_user->InputTextType = "text";
        $this->notification_status_user->Raw = true;
        $this->notification_status_user->Nullable = false; // NOT NULL field
        $this->notification_status_user->Required = true; // Required field
        $this->notification_status_user->setSelectMultiple(false); // Select one
        $this->notification_status_user->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->notification_status_user->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->notification_status_user->Lookup = new Lookup($this->notification_status_user, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->notification_status_user->OptionCount = 2;
        $this->notification_status_user->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->notification_status_user->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['notification_status_user'] = &$this->notification_status_user;

        // notification_template_user
        $this->notification_template_user = new DbField(
            $this, // Table
            'x_notification_template_user', // Variable name
            'notification_template_user', // Name
            '`notification_template_user`', // Expression
            '`notification_template_user`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_template_user`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->notification_template_user->InputTextType = "text";
        $this->notification_template_user->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['notification_template_user'] = &$this->notification_template_user;

        // notification_status_office
        $this->notification_status_office = new DbField(
            $this, // Table
            'x_notification_status_office', // Variable name
            'notification_status_office', // Name
            '`notification_status_office`', // Expression
            '`notification_status_office`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_status_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->notification_status_office->InputTextType = "text";
        $this->notification_status_office->Raw = true;
        $this->notification_status_office->Nullable = false; // NOT NULL field
        $this->notification_status_office->Required = true; // Required field
        $this->notification_status_office->setSelectMultiple(false); // Select one
        $this->notification_status_office->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->notification_status_office->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->notification_status_office->Lookup = new Lookup($this->notification_status_office, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->notification_status_office->OptionCount = 2;
        $this->notification_status_office->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->notification_status_office->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['notification_status_office'] = &$this->notification_status_office;

        // notification_to_office
        $this->notification_to_office = new DbField(
            $this, // Table
            'x_notification_to_office', // Variable name
            'notification_to_office', // Name
            '`notification_to_office`', // Expression
            '`notification_to_office`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_to_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->notification_to_office->addMethod("getSelectFilter", fn() => "`activated` = 1");
        $this->notification_to_office->InputTextType = "text";
        $this->notification_to_office->setSelectMultiple(true); // Select multiple
        $this->notification_to_office->Lookup = new Lookup($this->notification_to_office, 'admin_office', false, 'id', ["user_name","mobile","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "CONCAT(COALESCE(`user_name`, ''),'" . ValueSeparator(1, $this->notification_to_office) . "',COALESCE(`mobile`,''))");
        $this->notification_to_office->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['notification_to_office'] = &$this->notification_to_office;

        // notification_template_office
        $this->notification_template_office = new DbField(
            $this, // Table
            'x_notification_template_office', // Variable name
            'notification_template_office', // Name
            '`notification_template_office`', // Expression
            '`notification_template_office`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`notification_template_office`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->notification_template_office->InputTextType = "text";
        $this->notification_template_office->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['notification_template_office'] = &$this->notification_template_office;

        // code
        $this->code = new DbField(
            $this, // Table
            'x_code', // Variable name
            'code', // Name
            '`code`', // Expression
            '`code`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->code->InputTextType = "text";
        $this->code->Raw = true;
        $this->code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['code'] = &$this->code;

        // visible
        $this->_visible = new DbField(
            $this, // Table
            'x__visible', // Variable name
            'visible', // Name
            '`visible`', // Expression
            '`visible`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`visible`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->_visible->InputTextType = "text";
        $this->_visible->Raw = true;
        $this->_visible->Nullable = false; // NOT NULL field
        $this->_visible->Required = true; // Required field
        $this->_visible->setSelectMultiple(false); // Select one
        $this->_visible->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->_visible->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->_visible->Lookup = new Lookup($this->_visible, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->_visible->OptionCount = 2;
        $this->_visible->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_visible->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['visible'] = &$this->_visible;

        // cron
        $this->cron = new DbField(
            $this, // Table
            'x_cron', // Variable name
            'cron', // Name
            '`cron`', // Expression
            '`cron`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cron`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->cron->InputTextType = "text";
        $this->cron->Raw = true;
        $this->cron->Nullable = false; // NOT NULL field
        $this->cron->Required = true; // Required field
        $this->cron->setSelectMultiple(false); // Select one
        $this->cron->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->cron->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->cron->Lookup = new Lookup($this->cron, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->cron->OptionCount = 2;
        $this->cron->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cron->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cron'] = &$this->cron;

        // next_cycle
        $this->next_cycle = new DbField(
            $this, // Table
            'x_next_cycle', // Variable name
            'next_cycle', // Name
            '`next_cycle`', // Expression
            CastDateFieldForLike("`next_cycle`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`next_cycle`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->next_cycle->InputTextType = "text";
        $this->next_cycle->Raw = true;
        $this->next_cycle->Nullable = false; // NOT NULL field
        $this->next_cycle->Required = true; // Required field
        $this->next_cycle->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->next_cycle->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['next_cycle'] = &$this->next_cycle;

        // delay
        $this->delay = new DbField(
            $this, // Table
            'x_delay', // Variable name
            'delay', // Name
            '`delay`', // Expression
            '`delay`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delay`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->delay->InputTextType = "text";
        $this->delay->Raw = true;
        $this->delay->Nullable = false; // NOT NULL field
        $this->delay->Required = true; // Required field
        $this->delay->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->delay->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['delay'] = &$this->delay;

        // delay_method
        $this->delay_method = new DbField(
            $this, // Table
            'x_delay_method', // Variable name
            'delay_method', // Name
            '`delay_method`', // Expression
            '`delay_method`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delay_method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->delay_method->InputTextType = "text";
        $this->delay_method->Raw = true;
        $this->delay_method->Nullable = false; // NOT NULL field
        $this->delay_method->Required = true; // Required field
        $this->delay_method->setSelectMultiple(false); // Select one
        $this->delay_method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->delay_method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->delay_method->Lookup = new Lookup($this->delay_method, 'message_template_admin', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->delay_method->OptionCount = 4;
        $this->delay_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->delay_method->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['delay_method'] = &$this->delay_method;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // operator_admin
        $this->operator_admin = new DbField(
            $this, // Table
            'x_operator_admin', // Variable name
            'operator_admin', // Name
            '`operator_admin`', // Expression
            '`operator_admin`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator_admin`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator_admin->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator_admin->InputTextType = "text";
        $this->operator_admin->Raw = true;
        $this->operator_admin->Nullable = false; // NOT NULL field
        $this->operator_admin->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator_admin->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['operator_admin'] = &$this->operator_admin;

        // datetime_admin
        $this->datetime_admin = new DbField(
            $this, // Table
            'x_datetime_admin', // Variable name
            'datetime_admin', // Name
            '`datetime_admin`', // Expression
            CastDateFieldForLike("`datetime_admin`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime_admin`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime_admin->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime_admin->InputTextType = "text";
        $this->datetime_admin->Raw = true;
        $this->datetime_admin->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime_admin->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime_admin'] = &$this->datetime_admin;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->company_id->addMethod("getDefault", fn() => 1001);
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Nullable = false; // NOT NULL field
        $this->company_id->Required = true; // Required field
        $this->company_id->setSelectMultiple(false); // Select one
        $this->company_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->company_id->Lookup = new Lookup($this->company_id, 'portal_info', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['company_id'] = &$this->company_id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "message_template_admin";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "" . CurrentUserLevel() . " = '-1'";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->grp->DbValue = $row['grp'];
        $this->description->DbValue = $row['description'];
        $this->variables->DbValue = $row['variables'];
        $this->subject->DbValue = $row['subject'];
        $this->status_email_user->DbValue = $row['status_email_user'];
        $this->email_template_user->DbValue = $row['email_template_user'];
        $this->mail_to_office->DbValue = $row['mail_to_office'];
        $this->status_email_office->DbValue = $row['status_email_office'];
        $this->email_template_office->DbValue = $row['email_template_office'];
        $this->status_sms_user->DbValue = $row['status_sms_user'];
        $this->sms_template_user->DbValue = $row['sms_template_user'];
        $this->sms_template_user_id->DbValue = $row['sms_template_user_id'];
        $this->status_sms_office->DbValue = $row['status_sms_office'];
        $this->sms_to_office->DbValue = $row['sms_to_office'];
        $this->sms_template_office->DbValue = $row['sms_template_office'];
        $this->sms_template_office_id->DbValue = $row['sms_template_office_id'];
        $this->wa_status_user->DbValue = $row['wa_status_user'];
        $this->wa_type_user->DbValue = $row['wa_type_user'];
        $this->wa_template_user->DbValue = $row['wa_template_user'];
        $this->wa_status_office->DbValue = $row['wa_status_office'];
        $this->wa_type_office->DbValue = $row['wa_type_office'];
        $this->wa_to_office->DbValue = $row['wa_to_office'];
        $this->wa_template_office->DbValue = $row['wa_template_office'];
        $this->wa_id->DbValue = $row['wa_id'];
        $this->notification_status_user->DbValue = $row['notification_status_user'];
        $this->notification_template_user->DbValue = $row['notification_template_user'];
        $this->notification_status_office->DbValue = $row['notification_status_office'];
        $this->notification_to_office->DbValue = $row['notification_to_office'];
        $this->notification_template_office->DbValue = $row['notification_template_office'];
        $this->code->DbValue = $row['code'];
        $this->_visible->DbValue = $row['visible'];
        $this->cron->DbValue = $row['cron'];
        $this->next_cycle->DbValue = $row['next_cycle'];
        $this->delay->DbValue = $row['delay'];
        $this->delay_method->DbValue = $row['delay_method'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->operator_admin->DbValue = $row['operator_admin'];
        $this->datetime_admin->DbValue = $row['datetime_admin'];
        $this->company_id->DbValue = $row['company_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("messagetemplateadminlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "messagetemplateadminview" => $Language->phrase("View"),
            "messagetemplateadminedit" => $Language->phrase("Edit"),
            "messagetemplateadminadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "messagetemplateadminlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "MessageTemplateAdminView",
            Config("API_ADD_ACTION") => "MessageTemplateAdminAdd",
            Config("API_EDIT_ACTION") => "MessageTemplateAdminEdit",
            Config("API_DELETE_ACTION") => "MessageTemplateAdminDelete",
            Config("API_LIST_ACTION") => "MessageTemplateAdminList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "messagetemplateadminlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("messagetemplateadminview", $parm);
        } else {
            $url = $this->keyUrl("messagetemplateadminview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "messagetemplateadminadd?" . $parm;
        } else {
            $url = "messagetemplateadminadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("messagetemplateadminedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("messagetemplateadminlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("messagetemplateadminadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("messagetemplateadminlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("messagetemplateadmindelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->description->setDbValue($row['description']);
        $this->variables->setDbValue($row['variables']);
        $this->subject->setDbValue($row['subject']);
        $this->status_email_user->setDbValue($row['status_email_user']);
        $this->email_template_user->setDbValue($row['email_template_user']);
        $this->mail_to_office->setDbValue($row['mail_to_office']);
        $this->status_email_office->setDbValue($row['status_email_office']);
        $this->email_template_office->setDbValue($row['email_template_office']);
        $this->status_sms_user->setDbValue($row['status_sms_user']);
        $this->sms_template_user->setDbValue($row['sms_template_user']);
        $this->sms_template_user_id->setDbValue($row['sms_template_user_id']);
        $this->status_sms_office->setDbValue($row['status_sms_office']);
        $this->sms_to_office->setDbValue($row['sms_to_office']);
        $this->sms_template_office->setDbValue($row['sms_template_office']);
        $this->sms_template_office_id->setDbValue($row['sms_template_office_id']);
        $this->wa_status_user->setDbValue($row['wa_status_user']);
        $this->wa_type_user->setDbValue($row['wa_type_user']);
        $this->wa_template_user->setDbValue($row['wa_template_user']);
        $this->wa_status_office->setDbValue($row['wa_status_office']);
        $this->wa_type_office->setDbValue($row['wa_type_office']);
        $this->wa_to_office->setDbValue($row['wa_to_office']);
        $this->wa_template_office->setDbValue($row['wa_template_office']);
        $this->wa_id->setDbValue($row['wa_id']);
        $this->notification_status_user->setDbValue($row['notification_status_user']);
        $this->notification_template_user->setDbValue($row['notification_template_user']);
        $this->notification_status_office->setDbValue($row['notification_status_office']);
        $this->notification_to_office->setDbValue($row['notification_to_office']);
        $this->notification_template_office->setDbValue($row['notification_template_office']);
        $this->code->setDbValue($row['code']);
        $this->_visible->setDbValue($row['visible']);
        $this->cron->setDbValue($row['cron']);
        $this->next_cycle->setDbValue($row['next_cycle']);
        $this->delay->setDbValue($row['delay']);
        $this->delay_method->setDbValue($row['delay_method']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->operator_admin->setDbValue($row['operator_admin']);
        $this->datetime_admin->setDbValue($row['datetime_admin']);
        $this->company_id->setDbValue($row['company_id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "MessageTemplateAdminList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // grp

        // description

        // variables

        // subject

        // status_email_user

        // email_template_user

        // mail_to_office

        // status_email_office

        // email_template_office

        // status_sms_user

        // sms_template_user

        // sms_template_user_id

        // status_sms_office

        // sms_to_office

        // sms_template_office

        // sms_template_office_id

        // wa_status_user

        // wa_type_user

        // wa_template_user

        // wa_status_office

        // wa_type_office

        // wa_to_office

        // wa_template_office

        // wa_id

        // notification_status_user

        // notification_template_user

        // notification_status_office

        // notification_to_office

        // notification_template_office

        // code

        // visible

        // cron

        // next_cycle

        // delay

        // delay_method

        // operator

        // datetime

        // operator_admin

        // datetime_admin

        // company_id

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // description
        $this->description->ViewValue = $this->description->CurrentValue;

        // variables
        $this->variables->ViewValue = $this->variables->CurrentValue;

        // subject
        $this->subject->ViewValue = $this->subject->CurrentValue;

        // status_email_user
        if (strval($this->status_email_user->CurrentValue) != "") {
            $this->status_email_user->ViewValue = $this->status_email_user->optionCaption($this->status_email_user->CurrentValue);
        } else {
            $this->status_email_user->ViewValue = null;
        }

        // email_template_user
        $this->email_template_user->ViewValue = $this->email_template_user->CurrentValue;

        // mail_to_office
        $this->mail_to_office->ViewValue = $this->mail_to_office->CurrentValue;

        // status_email_office
        if (strval($this->status_email_office->CurrentValue) != "") {
            $this->status_email_office->ViewValue = $this->status_email_office->optionCaption($this->status_email_office->CurrentValue);
        } else {
            $this->status_email_office->ViewValue = null;
        }

        // email_template_office
        $this->email_template_office->ViewValue = $this->email_template_office->CurrentValue;

        // status_sms_user
        if (strval($this->status_sms_user->CurrentValue) != "") {
            $this->status_sms_user->ViewValue = $this->status_sms_user->optionCaption($this->status_sms_user->CurrentValue);
        } else {
            $this->status_sms_user->ViewValue = null;
        }

        // sms_template_user
        $this->sms_template_user->ViewValue = $this->sms_template_user->CurrentValue;

        // sms_template_user_id
        $this->sms_template_user_id->ViewValue = $this->sms_template_user_id->CurrentValue;

        // status_sms_office
        if (strval($this->status_sms_office->CurrentValue) != "") {
            $this->status_sms_office->ViewValue = $this->status_sms_office->optionCaption($this->status_sms_office->CurrentValue);
        } else {
            $this->status_sms_office->ViewValue = null;
        }

        // sms_to_office
        $this->sms_to_office->ViewValue = $this->sms_to_office->CurrentValue;

        // sms_template_office
        $this->sms_template_office->ViewValue = $this->sms_template_office->CurrentValue;

        // sms_template_office_id
        $this->sms_template_office_id->ViewValue = $this->sms_template_office_id->CurrentValue;

        // wa_status_user
        if (strval($this->wa_status_user->CurrentValue) != "") {
            $this->wa_status_user->ViewValue = $this->wa_status_user->optionCaption($this->wa_status_user->CurrentValue);
        } else {
            $this->wa_status_user->ViewValue = null;
        }

        // wa_type_user
        $curVal = strval($this->wa_type_user->CurrentValue);
        if ($curVal != "") {
            $this->wa_type_user->ViewValue = $this->wa_type_user->lookupCacheOption($curVal);
            if ($this->wa_type_user->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->wa_type_user->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_user->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->wa_type_user->getSelectFilter($this); // PHP
                $sqlWrk = $this->wa_type_user->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->wa_type_user->Lookup->renderViewRow($rswrk[0]);
                    $this->wa_type_user->ViewValue = $this->wa_type_user->displayValue($arwrk);
                } else {
                    $this->wa_type_user->ViewValue = FormatNumber($this->wa_type_user->CurrentValue, $this->wa_type_user->formatPattern());
                }
            }
        } else {
            $this->wa_type_user->ViewValue = null;
        }

        // wa_template_user
        $this->wa_template_user->ViewValue = $this->wa_template_user->CurrentValue;

        // wa_status_office
        if (strval($this->wa_status_office->CurrentValue) != "") {
            $this->wa_status_office->ViewValue = $this->wa_status_office->optionCaption($this->wa_status_office->CurrentValue);
        } else {
            $this->wa_status_office->ViewValue = null;
        }

        // wa_type_office
        $curVal = strval($this->wa_type_office->CurrentValue);
        if ($curVal != "") {
            $this->wa_type_office->ViewValue = $this->wa_type_office->lookupCacheOption($curVal);
            if ($this->wa_type_office->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->wa_type_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_type_office->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->wa_type_office->getSelectFilter($this); // PHP
                $sqlWrk = $this->wa_type_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->wa_type_office->Lookup->renderViewRow($rswrk[0]);
                    $this->wa_type_office->ViewValue = $this->wa_type_office->displayValue($arwrk);
                } else {
                    $this->wa_type_office->ViewValue = FormatNumber($this->wa_type_office->CurrentValue, $this->wa_type_office->formatPattern());
                }
            }
        } else {
            $this->wa_type_office->ViewValue = null;
        }

        // wa_to_office
        $this->wa_to_office->ViewValue = $this->wa_to_office->CurrentValue;

        // wa_template_office
        $this->wa_template_office->ViewValue = $this->wa_template_office->CurrentValue;

        // wa_id
        $curVal = strval($this->wa_id->CurrentValue);
        if ($curVal != "") {
            $this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
            if ($this->wa_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->wa_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->wa_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->wa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->wa_id->Lookup->renderViewRow($rswrk[0]);
                    $this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
                } else {
                    $this->wa_id->ViewValue = FormatNumber($this->wa_id->CurrentValue, $this->wa_id->formatPattern());
                }
            }
        } else {
            $this->wa_id->ViewValue = null;
        }

        // notification_status_user
        if (strval($this->notification_status_user->CurrentValue) != "") {
            $this->notification_status_user->ViewValue = $this->notification_status_user->optionCaption($this->notification_status_user->CurrentValue);
        } else {
            $this->notification_status_user->ViewValue = null;
        }

        // notification_template_user
        $this->notification_template_user->ViewValue = $this->notification_template_user->CurrentValue;

        // notification_status_office
        if (strval($this->notification_status_office->CurrentValue) != "") {
            $this->notification_status_office->ViewValue = $this->notification_status_office->optionCaption($this->notification_status_office->CurrentValue);
        } else {
            $this->notification_status_office->ViewValue = null;
        }

        // notification_to_office
        $curVal = strval($this->notification_to_office->CurrentValue);
        if ($curVal != "") {
            $this->notification_to_office->ViewValue = $this->notification_to_office->lookupCacheOption($curVal);
            if ($this->notification_to_office->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->notification_to_office->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->notification_to_office->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->notification_to_office->getSelectFilter($this); // PHP
                $sqlWrk = $this->notification_to_office->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->notification_to_office->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->notification_to_office->Lookup->renderViewRow($row);
                        $this->notification_to_office->ViewValue->add($this->notification_to_office->displayValue($arwrk));
                    }
                } else {
                    $this->notification_to_office->ViewValue = $this->notification_to_office->CurrentValue;
                }
            }
        } else {
            $this->notification_to_office->ViewValue = null;
        }

        // notification_template_office
        $this->notification_template_office->ViewValue = $this->notification_template_office->CurrentValue;

        // code
        $this->code->ViewValue = $this->code->CurrentValue;

        // visible
        if (strval($this->_visible->CurrentValue) != "") {
            $this->_visible->ViewValue = $this->_visible->optionCaption($this->_visible->CurrentValue);
        } else {
            $this->_visible->ViewValue = null;
        }

        // cron
        if (strval($this->cron->CurrentValue) != "") {
            $this->cron->ViewValue = $this->cron->optionCaption($this->cron->CurrentValue);
        } else {
            $this->cron->ViewValue = null;
        }

        // next_cycle
        $this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
        $this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, $this->next_cycle->formatPattern());

        // delay
        $this->delay->ViewValue = $this->delay->CurrentValue;
        $this->delay->ViewValue = FormatNumber($this->delay->ViewValue, $this->delay->formatPattern());

        // delay_method
        if (strval($this->delay_method->CurrentValue) != "") {
            $this->delay_method->ViewValue = $this->delay_method->optionCaption($this->delay_method->CurrentValue);
        } else {
            $this->delay_method->ViewValue = null;
        }

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // operator_admin
        $this->operator_admin->ViewValue = $this->operator_admin->CurrentValue;

        // datetime_admin
        $this->datetime_admin->ViewValue = $this->datetime_admin->CurrentValue;
        $this->datetime_admin->ViewValue = FormatDateTime($this->datetime_admin->ViewValue, $this->datetime_admin->formatPattern());

        // company_id
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // description
        if (!EmptyValue($this->id->CurrentValue)) {
            $this->description->HrefValue = $this->description->getLinkPrefix() . $this->id->CurrentValue; // Add prefix/suffix
            $this->description->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
            }
        } else {
            $this->description->HrefValue = "";
        }
        $this->description->TooltipValue = "";

        // variables
        $this->variables->HrefValue = "";
        $this->variables->TooltipValue = "";

        // subject
        $this->subject->HrefValue = "";
        $this->subject->TooltipValue = "";

        // status_email_user
        $this->status_email_user->HrefValue = "";
        $this->status_email_user->TooltipValue = "";

        // email_template_user
        $this->email_template_user->HrefValue = "";
        $this->email_template_user->TooltipValue = "";

        // mail_to_office
        $this->mail_to_office->HrefValue = "";
        $this->mail_to_office->TooltipValue = "";

        // status_email_office
        $this->status_email_office->HrefValue = "";
        $this->status_email_office->TooltipValue = "";

        // email_template_office
        $this->email_template_office->HrefValue = "";
        $this->email_template_office->TooltipValue = "";

        // status_sms_user
        $this->status_sms_user->HrefValue = "";
        $this->status_sms_user->TooltipValue = "";

        // sms_template_user
        $this->sms_template_user->HrefValue = "";
        $this->sms_template_user->TooltipValue = "";

        // sms_template_user_id
        $this->sms_template_user_id->HrefValue = "";
        $this->sms_template_user_id->TooltipValue = "";

        // status_sms_office
        $this->status_sms_office->HrefValue = "";
        $this->status_sms_office->TooltipValue = "";

        // sms_to_office
        $this->sms_to_office->HrefValue = "";
        $this->sms_to_office->TooltipValue = "";

        // sms_template_office
        $this->sms_template_office->HrefValue = "";
        $this->sms_template_office->TooltipValue = "";

        // sms_template_office_id
        $this->sms_template_office_id->HrefValue = "";
        $this->sms_template_office_id->TooltipValue = "";

        // wa_status_user
        $this->wa_status_user->HrefValue = "";
        $this->wa_status_user->TooltipValue = "";

        // wa_type_user
        $this->wa_type_user->HrefValue = "";
        $this->wa_type_user->TooltipValue = "";

        // wa_template_user
        $this->wa_template_user->HrefValue = "";
        $this->wa_template_user->TooltipValue = "";

        // wa_status_office
        $this->wa_status_office->HrefValue = "";
        $this->wa_status_office->TooltipValue = "";

        // wa_type_office
        $this->wa_type_office->HrefValue = "";
        $this->wa_type_office->TooltipValue = "";

        // wa_to_office
        $this->wa_to_office->HrefValue = "";
        $this->wa_to_office->TooltipValue = "";

        // wa_template_office
        $this->wa_template_office->HrefValue = "";
        $this->wa_template_office->TooltipValue = "";

        // wa_id
        $this->wa_id->HrefValue = "";
        $this->wa_id->TooltipValue = "";

        // notification_status_user
        $this->notification_status_user->HrefValue = "";
        $this->notification_status_user->TooltipValue = "";

        // notification_template_user
        $this->notification_template_user->HrefValue = "";
        $this->notification_template_user->TooltipValue = "";

        // notification_status_office
        $this->notification_status_office->HrefValue = "";
        $this->notification_status_office->TooltipValue = "";

        // notification_to_office
        $this->notification_to_office->HrefValue = "";
        $this->notification_to_office->TooltipValue = "";

        // notification_template_office
        $this->notification_template_office->HrefValue = "";
        $this->notification_template_office->TooltipValue = "";

        // code
        $this->code->HrefValue = "";
        $this->code->TooltipValue = "";

        // visible
        $this->_visible->HrefValue = "";
        $this->_visible->TooltipValue = "";

        // cron
        $this->cron->HrefValue = "";
        $this->cron->TooltipValue = "";

        // next_cycle
        $this->next_cycle->HrefValue = "";
        $this->next_cycle->TooltipValue = "";

        // delay
        $this->delay->HrefValue = "";
        $this->delay->TooltipValue = "";

        // delay_method
        $this->delay_method->HrefValue = "";
        $this->delay_method->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // operator_admin
        $this->operator_admin->HrefValue = "";
        $this->operator_admin->TooltipValue = "";

        // datetime_admin
        $this->datetime_admin->HrefValue = "";
        $this->datetime_admin->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // description
        $this->description->setupEditAttributes();
        if (!$this->description->Raw) {
            $this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
        }
        $this->description->EditValue = $this->description->CurrentValue;
        $this->description->PlaceHolder = RemoveHtml($this->description->caption());

        // variables
        $this->variables->setupEditAttributes();
        $this->variables->EditValue = $this->variables->CurrentValue;
        $this->variables->PlaceHolder = RemoveHtml($this->variables->caption());

        // subject
        $this->subject->setupEditAttributes();
        if (!$this->subject->Raw) {
            $this->subject->CurrentValue = HtmlDecode($this->subject->CurrentValue);
        }
        $this->subject->EditValue = $this->subject->CurrentValue;
        $this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

        // status_email_user
        $this->status_email_user->setupEditAttributes();
        $this->status_email_user->EditValue = $this->status_email_user->options(true);
        $this->status_email_user->PlaceHolder = RemoveHtml($this->status_email_user->caption());

        // email_template_user
        $this->email_template_user->setupEditAttributes();
        $this->email_template_user->EditValue = $this->email_template_user->CurrentValue;
        $this->email_template_user->PlaceHolder = RemoveHtml($this->email_template_user->caption());

        // mail_to_office
        $this->mail_to_office->setupEditAttributes();
        if (!$this->mail_to_office->Raw) {
            $this->mail_to_office->CurrentValue = HtmlDecode($this->mail_to_office->CurrentValue);
        }
        $this->mail_to_office->EditValue = $this->mail_to_office->CurrentValue;
        $this->mail_to_office->PlaceHolder = RemoveHtml($this->mail_to_office->caption());

        // status_email_office
        $this->status_email_office->setupEditAttributes();
        $this->status_email_office->EditValue = $this->status_email_office->options(true);
        $this->status_email_office->PlaceHolder = RemoveHtml($this->status_email_office->caption());

        // email_template_office
        $this->email_template_office->setupEditAttributes();
        $this->email_template_office->EditValue = $this->email_template_office->CurrentValue;
        $this->email_template_office->PlaceHolder = RemoveHtml($this->email_template_office->caption());

        // status_sms_user
        $this->status_sms_user->setupEditAttributes();
        $this->status_sms_user->EditValue = $this->status_sms_user->options(true);
        $this->status_sms_user->PlaceHolder = RemoveHtml($this->status_sms_user->caption());

        // sms_template_user
        $this->sms_template_user->setupEditAttributes();
        $this->sms_template_user->EditValue = $this->sms_template_user->CurrentValue;
        $this->sms_template_user->PlaceHolder = RemoveHtml($this->sms_template_user->caption());

        // sms_template_user_id
        $this->sms_template_user_id->setupEditAttributes();
        if (!$this->sms_template_user_id->Raw) {
            $this->sms_template_user_id->CurrentValue = HtmlDecode($this->sms_template_user_id->CurrentValue);
        }
        $this->sms_template_user_id->EditValue = $this->sms_template_user_id->CurrentValue;
        $this->sms_template_user_id->PlaceHolder = RemoveHtml($this->sms_template_user_id->caption());

        // status_sms_office
        $this->status_sms_office->setupEditAttributes();
        $this->status_sms_office->EditValue = $this->status_sms_office->options(true);
        $this->status_sms_office->PlaceHolder = RemoveHtml($this->status_sms_office->caption());

        // sms_to_office
        $this->sms_to_office->setupEditAttributes();
        if (!$this->sms_to_office->Raw) {
            $this->sms_to_office->CurrentValue = HtmlDecode($this->sms_to_office->CurrentValue);
        }
        $this->sms_to_office->EditValue = $this->sms_to_office->CurrentValue;
        $this->sms_to_office->PlaceHolder = RemoveHtml($this->sms_to_office->caption());

        // sms_template_office
        $this->sms_template_office->setupEditAttributes();
        $this->sms_template_office->EditValue = $this->sms_template_office->CurrentValue;
        $this->sms_template_office->PlaceHolder = RemoveHtml($this->sms_template_office->caption());

        // sms_template_office_id
        $this->sms_template_office_id->setupEditAttributes();
        if (!$this->sms_template_office_id->Raw) {
            $this->sms_template_office_id->CurrentValue = HtmlDecode($this->sms_template_office_id->CurrentValue);
        }
        $this->sms_template_office_id->EditValue = $this->sms_template_office_id->CurrentValue;
        $this->sms_template_office_id->PlaceHolder = RemoveHtml($this->sms_template_office_id->caption());

        // wa_status_user
        $this->wa_status_user->setupEditAttributes();
        $this->wa_status_user->EditValue = $this->wa_status_user->options(true);
        $this->wa_status_user->PlaceHolder = RemoveHtml($this->wa_status_user->caption());

        // wa_type_user
        $this->wa_type_user->setupEditAttributes();
        $this->wa_type_user->PlaceHolder = RemoveHtml($this->wa_type_user->caption());

        // wa_template_user
        $this->wa_template_user->setupEditAttributes();
        $this->wa_template_user->EditValue = $this->wa_template_user->CurrentValue;
        $this->wa_template_user->PlaceHolder = RemoveHtml($this->wa_template_user->caption());

        // wa_status_office
        $this->wa_status_office->setupEditAttributes();
        $this->wa_status_office->EditValue = $this->wa_status_office->options(true);
        $this->wa_status_office->PlaceHolder = RemoveHtml($this->wa_status_office->caption());

        // wa_type_office
        $this->wa_type_office->setupEditAttributes();
        $this->wa_type_office->PlaceHolder = RemoveHtml($this->wa_type_office->caption());

        // wa_to_office
        $this->wa_to_office->setupEditAttributes();
        if (!$this->wa_to_office->Raw) {
            $this->wa_to_office->CurrentValue = HtmlDecode($this->wa_to_office->CurrentValue);
        }
        $this->wa_to_office->EditValue = $this->wa_to_office->CurrentValue;
        $this->wa_to_office->PlaceHolder = RemoveHtml($this->wa_to_office->caption());

        // wa_template_office
        $this->wa_template_office->setupEditAttributes();
        $this->wa_template_office->EditValue = $this->wa_template_office->CurrentValue;
        $this->wa_template_office->PlaceHolder = RemoveHtml($this->wa_template_office->caption());

        // wa_id
        $this->wa_id->setupEditAttributes();
        $this->wa_id->PlaceHolder = RemoveHtml($this->wa_id->caption());

        // notification_status_user
        $this->notification_status_user->setupEditAttributes();
        $this->notification_status_user->EditValue = $this->notification_status_user->options(true);
        $this->notification_status_user->PlaceHolder = RemoveHtml($this->notification_status_user->caption());

        // notification_template_user
        $this->notification_template_user->setupEditAttributes();
        $this->notification_template_user->EditValue = $this->notification_template_user->CurrentValue;
        $this->notification_template_user->PlaceHolder = RemoveHtml($this->notification_template_user->caption());

        // notification_status_office
        $this->notification_status_office->setupEditAttributes();
        $this->notification_status_office->EditValue = $this->notification_status_office->options(true);
        $this->notification_status_office->PlaceHolder = RemoveHtml($this->notification_status_office->caption());

        // notification_to_office
        $this->notification_to_office->setupEditAttributes();
        $this->notification_to_office->PlaceHolder = RemoveHtml($this->notification_to_office->caption());

        // notification_template_office
        $this->notification_template_office->setupEditAttributes();
        $this->notification_template_office->EditValue = $this->notification_template_office->CurrentValue;
        $this->notification_template_office->PlaceHolder = RemoveHtml($this->notification_template_office->caption());

        // code
        $this->code->setupEditAttributes();
        $this->code->EditValue = $this->code->CurrentValue;
        $this->code->PlaceHolder = RemoveHtml($this->code->caption());

        // visible
        $this->_visible->setupEditAttributes();
        $this->_visible->EditValue = $this->_visible->options(true);
        $this->_visible->PlaceHolder = RemoveHtml($this->_visible->caption());

        // cron
        $this->cron->setupEditAttributes();
        $this->cron->EditValue = $this->cron->options(true);
        $this->cron->PlaceHolder = RemoveHtml($this->cron->caption());

        // next_cycle
        $this->next_cycle->setupEditAttributes();
        $this->next_cycle->EditValue = FormatDateTime($this->next_cycle->CurrentValue, $this->next_cycle->formatPattern());
        $this->next_cycle->PlaceHolder = RemoveHtml($this->next_cycle->caption());

        // delay
        $this->delay->setupEditAttributes();
        $this->delay->EditValue = $this->delay->CurrentValue;
        $this->delay->PlaceHolder = RemoveHtml($this->delay->caption());
        if (strval($this->delay->EditValue) != "" && is_numeric($this->delay->EditValue)) {
            $this->delay->EditValue = FormatNumber($this->delay->EditValue, null);
        }

        // delay_method
        $this->delay_method->setupEditAttributes();
        $this->delay_method->EditValue = $this->delay_method->options(true);
        $this->delay_method->PlaceHolder = RemoveHtml($this->delay_method->caption());

        // operator

        // datetime

        // operator_admin

        // datetime_admin

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->variables);
                    $doc->exportCaption($this->subject);
                    $doc->exportCaption($this->status_email_user);
                    $doc->exportCaption($this->email_template_user);
                    $doc->exportCaption($this->mail_to_office);
                    $doc->exportCaption($this->status_email_office);
                    $doc->exportCaption($this->email_template_office);
                    $doc->exportCaption($this->status_sms_user);
                    $doc->exportCaption($this->sms_template_user);
                    $doc->exportCaption($this->sms_template_user_id);
                    $doc->exportCaption($this->status_sms_office);
                    $doc->exportCaption($this->sms_to_office);
                    $doc->exportCaption($this->sms_template_office);
                    $doc->exportCaption($this->sms_template_office_id);
                    $doc->exportCaption($this->wa_status_user);
                    $doc->exportCaption($this->wa_type_user);
                    $doc->exportCaption($this->wa_template_user);
                    $doc->exportCaption($this->wa_status_office);
                    $doc->exportCaption($this->wa_type_office);
                    $doc->exportCaption($this->wa_to_office);
                    $doc->exportCaption($this->wa_template_office);
                    $doc->exportCaption($this->wa_id);
                    $doc->exportCaption($this->notification_status_user);
                    $doc->exportCaption($this->notification_template_user);
                    $doc->exportCaption($this->notification_status_office);
                    $doc->exportCaption($this->notification_to_office);
                    $doc->exportCaption($this->notification_template_office);
                    $doc->exportCaption($this->code);
                    $doc->exportCaption($this->_visible);
                    $doc->exportCaption($this->cron);
                    $doc->exportCaption($this->next_cycle);
                    $doc->exportCaption($this->delay);
                    $doc->exportCaption($this->delay_method);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->operator_admin);
                    $doc->exportCaption($this->datetime_admin);
                    $doc->exportCaption($this->company_id);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->description);
                    $doc->exportCaption($this->variables);
                    $doc->exportCaption($this->subject);
                    $doc->exportCaption($this->status_email_user);
                    $doc->exportCaption($this->email_template_user);
                    $doc->exportCaption($this->mail_to_office);
                    $doc->exportCaption($this->status_email_office);
                    $doc->exportCaption($this->status_sms_user);
                    $doc->exportCaption($this->sms_template_user);
                    $doc->exportCaption($this->sms_template_user_id);
                    $doc->exportCaption($this->status_sms_office);
                    $doc->exportCaption($this->sms_to_office);
                    $doc->exportCaption($this->sms_template_office);
                    $doc->exportCaption($this->sms_template_office_id);
                    $doc->exportCaption($this->wa_status_user);
                    $doc->exportCaption($this->wa_type_user);
                    $doc->exportCaption($this->wa_status_office);
                    $doc->exportCaption($this->wa_type_office);
                    $doc->exportCaption($this->wa_to_office);
                    $doc->exportCaption($this->wa_id);
                    $doc->exportCaption($this->notification_status_user);
                    $doc->exportCaption($this->notification_template_user);
                    $doc->exportCaption($this->notification_status_office);
                    $doc->exportCaption($this->notification_to_office);
                    $doc->exportCaption($this->notification_template_office);
                    $doc->exportCaption($this->_visible);
                    $doc->exportCaption($this->cron);
                    $doc->exportCaption($this->next_cycle);
                    $doc->exportCaption($this->delay);
                    $doc->exportCaption($this->delay_method);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->operator_admin);
                    $doc->exportCaption($this->datetime_admin);
                    $doc->exportCaption($this->company_id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->description);
                        $doc->exportField($this->variables);
                        $doc->exportField($this->subject);
                        $doc->exportField($this->status_email_user);
                        $doc->exportField($this->email_template_user);
                        $doc->exportField($this->mail_to_office);
                        $doc->exportField($this->status_email_office);
                        $doc->exportField($this->email_template_office);
                        $doc->exportField($this->status_sms_user);
                        $doc->exportField($this->sms_template_user);
                        $doc->exportField($this->sms_template_user_id);
                        $doc->exportField($this->status_sms_office);
                        $doc->exportField($this->sms_to_office);
                        $doc->exportField($this->sms_template_office);
                        $doc->exportField($this->sms_template_office_id);
                        $doc->exportField($this->wa_status_user);
                        $doc->exportField($this->wa_type_user);
                        $doc->exportField($this->wa_template_user);
                        $doc->exportField($this->wa_status_office);
                        $doc->exportField($this->wa_type_office);
                        $doc->exportField($this->wa_to_office);
                        $doc->exportField($this->wa_template_office);
                        $doc->exportField($this->wa_id);
                        $doc->exportField($this->notification_status_user);
                        $doc->exportField($this->notification_template_user);
                        $doc->exportField($this->notification_status_office);
                        $doc->exportField($this->notification_to_office);
                        $doc->exportField($this->notification_template_office);
                        $doc->exportField($this->code);
                        $doc->exportField($this->_visible);
                        $doc->exportField($this->cron);
                        $doc->exportField($this->next_cycle);
                        $doc->exportField($this->delay);
                        $doc->exportField($this->delay_method);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->operator_admin);
                        $doc->exportField($this->datetime_admin);
                        $doc->exportField($this->company_id);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->description);
                        $doc->exportField($this->variables);
                        $doc->exportField($this->subject);
                        $doc->exportField($this->status_email_user);
                        $doc->exportField($this->email_template_user);
                        $doc->exportField($this->mail_to_office);
                        $doc->exportField($this->status_email_office);
                        $doc->exportField($this->status_sms_user);
                        $doc->exportField($this->sms_template_user);
                        $doc->exportField($this->sms_template_user_id);
                        $doc->exportField($this->status_sms_office);
                        $doc->exportField($this->sms_to_office);
                        $doc->exportField($this->sms_template_office);
                        $doc->exportField($this->sms_template_office_id);
                        $doc->exportField($this->wa_status_user);
                        $doc->exportField($this->wa_type_user);
                        $doc->exportField($this->wa_status_office);
                        $doc->exportField($this->wa_type_office);
                        $doc->exportField($this->wa_to_office);
                        $doc->exportField($this->wa_id);
                        $doc->exportField($this->notification_status_user);
                        $doc->exportField($this->notification_template_user);
                        $doc->exportField($this->notification_status_office);
                        $doc->exportField($this->notification_to_office);
                        $doc->exportField($this->notification_template_office);
                        $doc->exportField($this->_visible);
                        $doc->exportField($this->cron);
                        $doc->exportField($this->next_cycle);
                        $doc->exportField($this->delay);
                        $doc->exportField($this->delay_method);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->operator_admin);
                        $doc->exportField($this->datetime_admin);
                        $doc->exportField($this->company_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
