<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MenusSearch extends Menus
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MenusSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "menussearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->image->setVisibility();
        $this->show_title->setVisibility();
        $this->page_title->setVisibility();
        $this->page_url->setVisibility();
        $this->target->setVisibility();
        $this->parent_id->setVisibility();
        $this->show_in_main_menu->setVisibility();
        $this->status->setVisibility();
        $this->order_by->setVisibility();
        $this->mega_menu->setVisibility();
        $this->bgcolor->setVisibility();
        $this->submenu->setVisibility();
        $this->submenu_code->setVisibility();
        $this->footer_group->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'menus';
        $this->TableName = 'menus';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (menus)
        if (!isset($GLOBALS["menus"]) || $GLOBALS["menus"]::class == PROJECT_NAMESPACE . "menus") {
            $GLOBALS["menus"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'menus');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "menusview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->show_title);
        $this->setupLookupOptions($this->target);
        $this->setupLookupOptions($this->parent_id);
        $this->setupLookupOptions($this->show_in_main_menu);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->mega_menu);
        $this->setupLookupOptions($this->submenu);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "menuslist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->image); // image
        $this->buildSearchUrl($srchUrl, $this->show_title); // show_title
        $this->buildSearchUrl($srchUrl, $this->page_title); // page_title
        $this->buildSearchUrl($srchUrl, $this->page_url); // page_url
        $this->buildSearchUrl($srchUrl, $this->target); // target
        $this->buildSearchUrl($srchUrl, $this->parent_id); // parent_id
        $this->buildSearchUrl($srchUrl, $this->show_in_main_menu); // show_in_main_menu
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->order_by); // order_by
        $this->buildSearchUrl($srchUrl, $this->mega_menu); // mega_menu
        $this->buildSearchUrl($srchUrl, $this->bgcolor); // bgcolor
        $this->buildSearchUrl($srchUrl, $this->submenu); // submenu
        $this->buildSearchUrl($srchUrl, $this->submenu_code); // submenu_code
        $this->buildSearchUrl($srchUrl, $this->footer_group); // footer_group
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // show_title
        if ($this->show_title->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // page_title
        if ($this->page_title->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // page_url
        if ($this->page_url->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // target
        if ($this->target->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // parent_id
        if ($this->parent_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // show_in_main_menu
        if ($this->show_in_main_menu->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_by
        if ($this->order_by->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mega_menu
        if ($this->mega_menu->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bgcolor
        if ($this->bgcolor->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // submenu
        if ($this->submenu->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // submenu_code
        if ($this->submenu_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // footer_group
        if ($this->footer_group->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // show_title
        $this->show_title->RowCssClass = "row";

        // page_title
        $this->page_title->RowCssClass = "row";

        // page_url
        $this->page_url->RowCssClass = "row";

        // target
        $this->target->RowCssClass = "row";

        // parent_id
        $this->parent_id->RowCssClass = "row";

        // show_in_main_menu
        $this->show_in_main_menu->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // order_by
        $this->order_by->RowCssClass = "row";

        // mega_menu
        $this->mega_menu->RowCssClass = "row";

        // bgcolor
        $this->bgcolor->RowCssClass = "row";

        // submenu
        $this->submenu->RowCssClass = "row";

        // submenu_code
        $this->submenu_code->RowCssClass = "row";

        // footer_group
        $this->footer_group->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // image
            $this->image->ViewValue = $this->image->CurrentValue;

            // show_title
            if (strval($this->show_title->CurrentValue) != "") {
                $this->show_title->ViewValue = $this->show_title->optionCaption($this->show_title->CurrentValue);
            } else {
                $this->show_title->ViewValue = null;
            }

            // page_title
            $this->page_title->ViewValue = $this->page_title->CurrentValue;

            // page_url
            $this->page_url->ViewValue = $this->page_url->CurrentValue;

            // target
            if (strval($this->target->CurrentValue) != "") {
                $this->target->ViewValue = $this->target->optionCaption($this->target->CurrentValue);
            } else {
                $this->target->ViewValue = null;
            }

            // parent_id
            $curVal = strval($this->parent_id->CurrentValue);
            if ($curVal != "") {
                $this->parent_id->ViewValue = $this->parent_id->lookupCacheOption($curVal);
                if ($this->parent_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->parent_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->parent_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->parent_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->parent_id->Lookup->renderViewRow($rswrk[0]);
                        $this->parent_id->ViewValue = $this->parent_id->displayValue($arwrk);
                    } else {
                        $this->parent_id->ViewValue = $this->parent_id->CurrentValue;
                    }
                }
            } else {
                $this->parent_id->ViewValue = null;
            }

            // show_in_main_menu
            if (strval($this->show_in_main_menu->CurrentValue) != "") {
                $this->show_in_main_menu->ViewValue = $this->show_in_main_menu->optionCaption($this->show_in_main_menu->CurrentValue);
            } else {
                $this->show_in_main_menu->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // order_by
            $this->order_by->ViewValue = $this->order_by->CurrentValue;

            // mega_menu
            if (strval($this->mega_menu->CurrentValue) != "") {
                $this->mega_menu->ViewValue = $this->mega_menu->optionCaption($this->mega_menu->CurrentValue);
            } else {
                $this->mega_menu->ViewValue = null;
            }

            // bgcolor
            $this->bgcolor->ViewValue = $this->bgcolor->CurrentValue;

            // submenu
            if (strval($this->submenu->CurrentValue) != "") {
                $this->submenu->ViewValue = $this->submenu->optionCaption($this->submenu->CurrentValue);
            } else {
                $this->submenu->ViewValue = null;
            }

            // submenu_code
            $this->submenu_code->ViewValue = $this->submenu_code->CurrentValue;

            // footer_group
            $this->footer_group->ViewValue = $this->footer_group->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // image
            $this->image->HrefValue = "";
            $this->image->TooltipValue = "";

            // show_title
            $this->show_title->HrefValue = "";
            $this->show_title->TooltipValue = "";

            // page_title
            $this->page_title->HrefValue = "";
            $this->page_title->TooltipValue = "";

            // page_url
            $this->page_url->HrefValue = "";
            $this->page_url->TooltipValue = "";

            // target
            $this->target->HrefValue = "";
            $this->target->TooltipValue = "";

            // parent_id
            $this->parent_id->HrefValue = "";
            $this->parent_id->TooltipValue = "";

            // show_in_main_menu
            $this->show_in_main_menu->HrefValue = "";
            $this->show_in_main_menu->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // order_by
            $this->order_by->HrefValue = "";
            $this->order_by->TooltipValue = "";

            // mega_menu
            $this->mega_menu->HrefValue = "";
            $this->mega_menu->TooltipValue = "";

            // bgcolor
            $this->bgcolor->HrefValue = "";
            $this->bgcolor->TooltipValue = "";

            // submenu
            $this->submenu->HrefValue = "";
            $this->submenu->TooltipValue = "";

            // submenu_code
            $this->submenu_code->HrefValue = "";
            $this->submenu_code->TooltipValue = "";

            // footer_group
            $this->footer_group->HrefValue = "";
            $this->footer_group->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // image
            $this->image->setupEditAttributes();
            if (!$this->image->Raw) {
                $this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
            }
            $this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
            $this->image->PlaceHolder = RemoveHtml($this->image->caption());

            // show_title
            $this->show_title->setupEditAttributes();
            $this->show_title->EditValue = $this->show_title->options(true);
            $this->show_title->PlaceHolder = RemoveHtml($this->show_title->caption());

            // page_title
            $this->page_title->setupEditAttributes();
            if (!$this->page_title->Raw) {
                $this->page_title->AdvancedSearch->SearchValue = HtmlDecode($this->page_title->AdvancedSearch->SearchValue);
            }
            $this->page_title->EditValue = HtmlEncode($this->page_title->AdvancedSearch->SearchValue);
            $this->page_title->PlaceHolder = RemoveHtml($this->page_title->caption());

            // page_url
            $this->page_url->setupEditAttributes();
            if (!$this->page_url->Raw) {
                $this->page_url->AdvancedSearch->SearchValue = HtmlDecode($this->page_url->AdvancedSearch->SearchValue);
            }
            $this->page_url->EditValue = HtmlEncode($this->page_url->AdvancedSearch->SearchValue);
            $this->page_url->PlaceHolder = RemoveHtml($this->page_url->caption());

            // target
            $this->target->setupEditAttributes();
            $this->target->EditValue = $this->target->options(true);
            $this->target->PlaceHolder = RemoveHtml($this->target->caption());

            // parent_id
            $this->parent_id->setupEditAttributes();
            $curVal = trim(strval($this->parent_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->parent_id->AdvancedSearch->ViewValue = $this->parent_id->lookupCacheOption($curVal);
            } else {
                $this->parent_id->AdvancedSearch->ViewValue = $this->parent_id->Lookup !== null && is_array($this->parent_id->lookupOptions()) && count($this->parent_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->parent_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->parent_id->EditValue = array_values($this->parent_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->parent_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->parent_id->AdvancedSearch->SearchValue, $this->parent_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->parent_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->parent_id->EditValue = $arwrk;
            }
            $this->parent_id->PlaceHolder = RemoveHtml($this->parent_id->caption());

            // show_in_main_menu
            $this->show_in_main_menu->setupEditAttributes();
            $this->show_in_main_menu->EditValue = $this->show_in_main_menu->options(true);
            $this->show_in_main_menu->PlaceHolder = RemoveHtml($this->show_in_main_menu->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // order_by
            $this->order_by->setupEditAttributes();
            $this->order_by->EditValue = $this->order_by->AdvancedSearch->SearchValue;
            $this->order_by->PlaceHolder = RemoveHtml($this->order_by->caption());

            // mega_menu
            $this->mega_menu->setupEditAttributes();
            $this->mega_menu->EditValue = $this->mega_menu->options(true);
            $this->mega_menu->PlaceHolder = RemoveHtml($this->mega_menu->caption());

            // bgcolor
            $this->bgcolor->setupEditAttributes();
            if (!$this->bgcolor->Raw) {
                $this->bgcolor->AdvancedSearch->SearchValue = HtmlDecode($this->bgcolor->AdvancedSearch->SearchValue);
            }
            $this->bgcolor->EditValue = HtmlEncode($this->bgcolor->AdvancedSearch->SearchValue);
            $this->bgcolor->PlaceHolder = RemoveHtml($this->bgcolor->caption());

            // submenu
            $this->submenu->setupEditAttributes();
            $this->submenu->EditValue = $this->submenu->options(true);
            $this->submenu->PlaceHolder = RemoveHtml($this->submenu->caption());

            // submenu_code
            $this->submenu_code->setupEditAttributes();
            $this->submenu_code->EditValue = HtmlEncode($this->submenu_code->AdvancedSearch->SearchValue);
            $this->submenu_code->PlaceHolder = RemoveHtml($this->submenu_code->caption());

            // footer_group
            $this->footer_group->setupEditAttributes();
            if (!$this->footer_group->Raw) {
                $this->footer_group->AdvancedSearch->SearchValue = HtmlDecode($this->footer_group->AdvancedSearch->SearchValue);
            }
            $this->footer_group->EditValue = HtmlEncode($this->footer_group->AdvancedSearch->SearchValue);
            $this->footer_group->PlaceHolder = RemoveHtml($this->footer_group->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->order_by->AdvancedSearch->SearchValue)) {
            $this->order_by->addErrorMessage($this->order_by->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->show_title->AdvancedSearch->load();
        $this->page_title->AdvancedSearch->load();
        $this->page_url->AdvancedSearch->load();
        $this->target->AdvancedSearch->load();
        $this->parent_id->AdvancedSearch->load();
        $this->show_in_main_menu->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->order_by->AdvancedSearch->load();
        $this->mega_menu->AdvancedSearch->load();
        $this->bgcolor->AdvancedSearch->load();
        $this->submenu->AdvancedSearch->load();
        $this->submenu_code->AdvancedSearch->load();
        $this->footer_group->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("menuslist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_show_title":
                    break;
                case "x_target":
                    break;
                case "x_parent_id":
                    break;
                case "x_show_in_main_menu":
                    break;
                case "x_status":
                    break;
                case "x_mega_menu":
                    break;
                case "x_submenu":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
