<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for material_required_weekly_loomplan
 */
class MaterialRequiredWeeklyLoomplan extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $poid;
    public $weaving_works;
    public $week;
    public $po;
    public $buyer_id;
    public $product_id;
    public $batch_no;
    public $quantity;
    public $Size_wl;
    public $sqm;
    public $req_material_rid;
    public $req_material_packing;
    public $req_material_qty;
    public $unit;
    public $material_qty;
    public $method;
    public $despatch_week;
    public $production_plan;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "material_required_weekly_loomplan";
        $this->TableName = 'material_required_weekly_loomplan';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "material_required_weekly_loomplan";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // poid
        $this->poid = new DbField(
            $this, // Table
            'x_poid', // Variable name
            'poid', // Name
            '`poid`', // Expression
            '`poid`', // Basic search expression
            131, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`poid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->poid->InputTextType = "text";
        $this->poid->Raw = true;
        $this->poid->Required = true; // Required field
        $this->poid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->poid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['poid'] = &$this->poid;

        // weaving_works
        $this->weaving_works = new DbField(
            $this, // Table
            'x_weaving_works', // Variable name
            'weaving_works', // Name
            '`weaving_works`', // Expression
            '`weaving_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weaving_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->weaving_works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->weaving_works->InputTextType = "text";
        $this->weaving_works->Raw = true;
        $this->weaving_works->IsForeignKey = true; // Foreign key field
        $this->weaving_works->Nullable = false; // NOT NULL field
        $this->weaving_works->setSelectMultiple(false); // Select one
        $this->weaving_works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->weaving_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->weaving_works->Lookup = new Lookup($this->weaving_works, 'godown_table', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->weaving_works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['weaving_works'] = &$this->weaving_works;

        // week
        $this->week = new DbField(
            $this, // Table
            'x_week', // Variable name
            'week', // Name
            '`week`', // Expression
            '`week`', // Basic search expression
            200, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->week->addMethod("getSelectFilter", fn() => "`id` >= DATE_FORMAT(NOW(), '%y%u')");
        $this->week->addMethod("getDefault", fn() => 0);
        $this->week->InputTextType = "text";
        $this->week->IsForeignKey = true; // Foreign key field
        $this->week->Nullable = false; // NOT NULL field
        $this->week->Required = true; // Required field
        $this->week->setSelectMultiple(false); // Select one
        $this->week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->week->Lookup = new Lookup($this->week, 'not_week', false, 'id', ["week","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`week`");
        $this->week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->week->SearchOperators = ["=", "<>"];
        $this->Fields['week'] = &$this->week;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // buyer_id
        $this->buyer_id = new DbField(
            $this, // Table
            'x_buyer_id', // Variable name
            'buyer_id', // Name
            '`buyer_id`', // Expression
            '`buyer_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyer_id->addMethod("getSelectFilter", fn() => "`grp` = 3");
        $this->buyer_id->addMethod("getLinkPrefix", fn() => "materialrequiredlist?x_buyer_id=");
        $this->buyer_id->InputTextType = "text";
        $this->buyer_id->Raw = true;
        $this->buyer_id->Required = true; // Required field
        $this->buyer_id->setSelectMultiple(false); // Select one
        $this->buyer_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyer_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyer_id->Lookup = new Lookup($this->buyer_id, 'buyer', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`code`");
        $this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_id'] = &$this->buyer_id;

        // product_id
        $this->product_id = new DbField(
            $this, // Table
            'x_product_id', // Variable name
            'product_id', // Name
            '`product_id`', // Expression
            '`product_id`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product_id->addMethod("getLinkPrefix", fn() => "materialrequiredlist?x_product_item=");
        $this->product_id->InputTextType = "text";
        $this->product_id->Required = true; // Required field
        $this->product_id->setSelectMultiple(false); // Select one
        $this->product_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product_id->Lookup = new Lookup($this->product_id, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->product_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_id'] = &$this->product_id;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->batch_no->addMethod("getLinkPrefix", fn() => "batchnolist?x_id=");
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->Required = true; // Required field
        $this->batch_no->setSelectMultiple(false); // Select one
        $this->batch_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', false, 'id', ["batch_no","","",""], '', '', [], [], [], [], [], [], false, '`batch_no` ASC', '', "`batch_no`");
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            20, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Nullable = false; // NOT NULL field
        $this->quantity->Required = true; // Required field
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity'] = &$this->quantity;

        // Size_wl
        $this->Size_wl = new DbField(
            $this, // Table
            'x_Size_wl', // Variable name
            'Size_wl', // Name
            '`Size_wl`', // Expression
            '`Size_wl`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Size_wl`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Size_wl->InputTextType = "text";
        $this->Size_wl->Nullable = false; // NOT NULL field
        $this->Size_wl->Required = true; // Required field
        $this->Size_wl->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Size_wl'] = &$this->Size_wl;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            16, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm'] = &$this->sqm;

        // req_material_rid
        $this->req_material_rid = new DbField(
            $this, // Table
            'x_req_material_rid', // Variable name
            'req_material_rid', // Name
            '`req_material_rid`', // Expression
            '`req_material_rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__req_material_rid', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->req_material_rid->addMethod("getLinkPrefix", fn() => "materialrequiredlist?x_req_material_rid=");
        $this->req_material_rid->InputTextType = "text";
        $this->req_material_rid->Raw = true;
        $this->req_material_rid->IsForeignKey = true; // Foreign key field
        $this->req_material_rid->Lookup = new Lookup($this->req_material_rid, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_rid->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_rid'] = &$this->req_material_rid;

        // req_material_packing
        $this->req_material_packing = new DbField(
            $this, // Table
            'x_req_material_packing', // Variable name
            'req_material_packing', // Name
            '`req_material_packing`', // Expression
            '`req_material_packing`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_packing`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->req_material_packing->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->req_material_packing->InputTextType = "text";
        $this->req_material_packing->Raw = true;
        $this->req_material_packing->IsForeignKey = true; // Foreign key field
        $this->req_material_packing->setSelectMultiple(false); // Select one
        $this->req_material_packing->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->req_material_packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->req_material_packing->Lookup = new Lookup($this->req_material_packing, 'packing_type', false, 'id', ["packing","","",""], '', '', [], [], [], [], [], [], false, '`packing` ASC', '', "`packing`");
        $this->req_material_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_packing->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_packing'] = &$this->req_material_packing;

        // req_material_qty
        $this->req_material_qty = new DbField(
            $this, // Table
            'x_req_material_qty', // Variable name
            'req_material_qty', // Name
            '`req_material_qty`', // Expression
            '`req_material_qty`', // Basic search expression
            5, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_qty->InputTextType = "text";
        $this->req_material_qty->Raw = true;
        $this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->req_material_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_qty'] = &$this->req_material_qty;

        // unit
        $this->unit = new DbField(
            $this, // Table
            'x_unit', // Variable name
            'unit', // Name
            '`unit`', // Expression
            '`unit`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->unit->InputTextType = "text";
        $this->unit->Raw = true;
        $this->unit->Required = true; // Required field
        $this->unit->setSelectMultiple(false); // Select one
        $this->unit->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->unit->Lookup = new Lookup($this->unit, 'unit', false, 'id', ["description","","",""], '', '', [], [], [], [], [], [], false, '`description` ASC', '', "`description`");
        $this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unit->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unit'] = &$this->unit;

        // material_qty
        $this->material_qty = new DbField(
            $this, // Table
            'x_material_qty', // Variable name
            'material_qty', // Name
            '`material_qty`', // Expression
            '`material_qty`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`material_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->material_qty->InputTextType = "text";
        $this->material_qty->Raw = true;
        $this->material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->material_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['material_qty'] = &$this->material_qty;

        // method
        $this->method = new DbField(
            $this, // Table
            'x_method', // Variable name
            'method', // Name
            '`method`', // Expression
            '`method`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->method->addMethod("getSelectFilter", fn() => "`grp`=21");
        $this->method->InputTextType = "text";
        $this->method->Raw = true;
        $this->method->Required = true; // Required field
        $this->method->setSelectMultiple(false); // Select one
        $this->method->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->method->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->method->Lookup = new Lookup($this->method, 'misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->method->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['method'] = &$this->method;

        // despatch_week
        $this->despatch_week = new DbField(
            $this, // Table
            'x_despatch_week', // Variable name
            'despatch_week', // Name
            '`despatch_week`', // Expression
            '`despatch_week`', // Basic search expression
            18, // Type
            5, // Size
            7, // Date/Time format
            false, // Is upload field
            '`despatch_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->despatch_week->InputTextType = "text";
        $this->despatch_week->Raw = true;
        $this->despatch_week->Required = true; // Required field
        $this->despatch_week->setSelectMultiple(false); // Select one
        $this->despatch_week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->despatch_week->Lookup = new Lookup($this->despatch_week, 'not_week', false, 'id', ["nweek","","",""], '', '', [], [], [], [], [], [], false, '`nweek` ASC', '', "`nweek`");
        $this->despatch_week->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->despatch_week->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_week'] = &$this->despatch_week;

        // production_plan
        $this->production_plan = new DbField(
            $this, // Table
            'x_production_plan', // Variable name
            'production_plan', // Name
            '`production_plan`', // Expression
            '`production_plan`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->production_plan->InputTextType = "text";
        $this->production_plan->Raw = true;
        $this->production_plan->Required = true; // Required field
        $this->production_plan->setSelectMultiple(false); // Select one
        $this->production_plan->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->production_plan->Lookup = new Lookup($this->production_plan, 'material_required_weekly_loomplan', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->production_plan->OptionCount = 6;
        $this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->production_plan->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['production_plan'] = &$this->production_plan;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "material_required_weekly_loomplan_short") {
            $masterTable = Container("material_required_weekly_loomplan_short");
            if ($this->weaving_works->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->godown, $this->weaving_works->getSessionValue(), $masterTable->godown->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->week->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->week, $this->week->getSessionValue(), $masterTable->week->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->req_material_rid->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->rid, $this->req_material_rid->getSessionValue(), $masterTable->rid->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->req_material_packing->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->packing_type, $this->req_material_packing->getSessionValue(), $masterTable->packing_type->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "material_required_weekly_loomplan_short") {
            $masterTable = Container("material_required_weekly_loomplan_short");
            if ($this->weaving_works->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->weaving_works, $this->weaving_works->getSessionValue(), $masterTable->godown->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->week->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->week, $this->week->getSessionValue(), $masterTable->week->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->req_material_rid->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->req_material_rid, $this->req_material_rid->getSessionValue(), $masterTable->rid->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->req_material_packing->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->req_material_packing, $this->req_material_packing->getSessionValue(), $masterTable->packing_type->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "material_required_weekly_loomplan_short":
                $key = $keys["weaving_works"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->godown->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["week"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->week->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["req_material_rid"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->rid->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["req_material_packing"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->packing_type->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->godown, $keys["weaving_works"], $this->weaving_works->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->week, $keys["week"], $this->week->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->rid, $keys["req_material_rid"], $this->req_material_rid->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->packing_type, $keys["req_material_packing"], $this->req_material_packing->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "material_required_weekly_loomplan_short":
                return GetKeyFilter($this->weaving_works, $masterTable->godown->DbValue, $masterTable->godown->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->week, $masterTable->week->DbValue, $masterTable->week->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->req_material_rid, $masterTable->rid->DbValue, $masterTable->rid->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->req_material_packing, $masterTable->packing_type->DbValue, $masterTable->packing_type->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "material_required_weekly_loomplan";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `product_code` FROM ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = material_required_weekly_loomplan.req_material_rid LIMIT 1) AS EV__req_material_rid FROM material_required_weekly_loomplan)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->req_material_rid->AdvancedSearch->SearchValue != "" ||
            $this->req_material_rid->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->req_material_rid->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->req_material_rid->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->poid->DbValue = $row['poid'];
        $this->weaving_works->DbValue = $row['weaving_works'];
        $this->week->DbValue = $row['week'];
        $this->po->DbValue = $row['po'];
        $this->buyer_id->DbValue = $row['buyer_id'];
        $this->product_id->DbValue = $row['product_id'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->quantity->DbValue = $row['quantity'];
        $this->Size_wl->DbValue = $row['Size_wl'];
        $this->sqm->DbValue = $row['sqm'];
        $this->req_material_rid->DbValue = $row['req_material_rid'];
        $this->req_material_packing->DbValue = $row['req_material_packing'];
        $this->req_material_qty->DbValue = $row['req_material_qty'];
        $this->unit->DbValue = $row['unit'];
        $this->material_qty->DbValue = $row['material_qty'];
        $this->method->DbValue = $row['method'];
        $this->despatch_week->DbValue = $row['despatch_week'];
        $this->production_plan->DbValue = $row['production_plan'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("materialrequiredweeklyloomplanlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "materialrequiredweeklyloomplanview" => $Language->phrase("View"),
            "materialrequiredweeklyloomplanedit" => $Language->phrase("Edit"),
            "materialrequiredweeklyloomplanadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "materialrequiredweeklyloomplanlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "MaterialRequiredWeeklyLoomplanView",
            Config("API_ADD_ACTION") => "MaterialRequiredWeeklyLoomplanAdd",
            Config("API_EDIT_ACTION") => "MaterialRequiredWeeklyLoomplanEdit",
            Config("API_DELETE_ACTION") => "MaterialRequiredWeeklyLoomplanDelete",
            Config("API_LIST_ACTION") => "MaterialRequiredWeeklyLoomplanList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "materialrequiredweeklyloomplanlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("materialrequiredweeklyloomplanview", $parm);
        } else {
            $url = $this->keyUrl("materialrequiredweeklyloomplanview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "materialrequiredweeklyloomplanadd?" . $parm;
        } else {
            $url = "materialrequiredweeklyloomplanadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("materialrequiredweeklyloomplanedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("materialrequiredweeklyloomplanlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("materialrequiredweeklyloomplanadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("materialrequiredweeklyloomplanlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("materialrequiredweeklyloomplandelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "material_required_weekly_loomplan_short" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_godown", $this->weaving_works->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_week", $this->week->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_rid", $this->req_material_rid->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_packing_type", $this->req_material_packing->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->poid->setDbValue($row['poid']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->week->setDbValue($row['week']);
        $this->po->setDbValue($row['po']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->quantity->setDbValue($row['quantity']);
        $this->Size_wl->setDbValue($row['Size_wl']);
        $this->sqm->setDbValue($row['sqm']);
        $this->req_material_rid->setDbValue($row['req_material_rid']);
        $this->req_material_packing->setDbValue($row['req_material_packing']);
        $this->req_material_qty->setDbValue($row['req_material_qty']);
        $this->unit->setDbValue($row['unit']);
        $this->material_qty->setDbValue($row['material_qty']);
        $this->method->setDbValue($row['method']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->production_plan->setDbValue($row['production_plan']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "MaterialRequiredWeeklyLoomplanList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // poid

        // weaving_works

        // week

        // po

        // buyer_id

        // product_id

        // batch_no
        $this->batch_no->CellCssStyle = "white-space: nowrap;";

        // quantity

        // Size_wl

        // sqm

        // req_material_rid

        // req_material_packing

        // req_material_qty

        // unit

        // material_qty

        // method

        // despatch_week

        // production_plan

        // poid
        $this->poid->ViewValue = $this->poid->CurrentValue;
        $this->poid->ViewValue = FormatNumber($this->poid->ViewValue, $this->poid->formatPattern());

        // weaving_works
        $curVal = strval($this->weaving_works->CurrentValue);
        if ($curVal != "") {
            $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
            if ($this->weaving_works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                    $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                } else {
                    $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                }
            }
        } else {
            $this->weaving_works->ViewValue = null;
        }

        // week
        $curVal = strval($this->week->CurrentValue);
        if ($curVal != "") {
            $this->week->ViewValue = $this->week->lookupCacheOption($curVal);
            if ($this->week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->week->getSelectFilter($this); // PHP
                $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                    $this->week->ViewValue = $this->week->displayValue($arwrk);
                } else {
                    $this->week->ViewValue = $this->week->CurrentValue;
                }
            }
        } else {
            $this->week->ViewValue = null;
        }

        // po
        $this->po->ViewValue = $this->po->CurrentValue;

        // buyer_id
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                }
            }
        } else {
            $this->buyer_id->ViewValue = null;
        }

        // product_id
        $curVal = strval($this->product_id->CurrentValue);
        if ($curVal != "") {
            $this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
            if ($this->product_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_id->Lookup->renderViewRow($rswrk[0]);
                    $this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
                } else {
                    $this->product_id->ViewValue = $this->product_id->CurrentValue;
                }
            }
        } else {
            $this->product_id->ViewValue = null;
        }

        // batch_no
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                }
            }
        } else {
            $this->batch_no->ViewValue = null;
        }

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // Size_wl
        $this->Size_wl->ViewValue = $this->Size_wl->CurrentValue;

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // req_material_rid
        if ($this->req_material_rid->VirtualValue != "") {
            $this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
        } else {
            $curVal = strval($this->req_material_rid->CurrentValue);
            if ($curVal != "") {
                $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
                if ($this->req_material_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
                    } else {
                        $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
                    }
                }
            } else {
                $this->req_material_rid->ViewValue = null;
            }
        }

        // req_material_packing
        $curVal = strval($this->req_material_packing->CurrentValue);
        if ($curVal != "") {
            $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
            if ($this->req_material_packing->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                    $this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
                } else {
                    $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                }
            }
        } else {
            $this->req_material_packing->ViewValue = null;
        }

        // req_material_qty
        $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
        $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

        // unit
        $curVal = strval($this->unit->CurrentValue);
        if ($curVal != "") {
            $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            if ($this->unit->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                    $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                } else {
                    $this->unit->ViewValue = $this->unit->CurrentValue;
                }
            }
        } else {
            $this->unit->ViewValue = null;
        }

        // material_qty
        $this->material_qty->ViewValue = $this->material_qty->CurrentValue;
        $this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, $this->material_qty->formatPattern());

        // method
        $curVal = strval($this->method->CurrentValue);
        if ($curVal != "") {
            $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            if ($this->method->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                    $this->method->ViewValue = $this->method->displayValue($arwrk);
                } else {
                    $this->method->ViewValue = $this->method->CurrentValue;
                }
            }
        } else {
            $this->method->ViewValue = null;
        }

        // despatch_week
        $curVal = strval($this->despatch_week->CurrentValue);
        if ($curVal != "") {
            $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            if ($this->despatch_week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                    $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                } else {
                    $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                }
            }
        } else {
            $this->despatch_week->ViewValue = null;
        }

        // production_plan
        if (strval($this->production_plan->CurrentValue) != "") {
            $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
        } else {
            $this->production_plan->ViewValue = null;
        }

        // poid
        $this->poid->HrefValue = "";
        $this->poid->TooltipValue = "";

        // weaving_works
        $this->weaving_works->HrefValue = "";
        $this->weaving_works->TooltipValue = "";

        // week
        $this->week->HrefValue = "";
        $this->week->TooltipValue = "";

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // buyer_id
        if (!EmptyValue($this->buyer_id->CurrentValue)) {
            $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
            $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
            }
        } else {
            $this->buyer_id->HrefValue = "";
        }
        $this->buyer_id->TooltipValue = "";

        // product_id
        if (!EmptyValue($this->product_id->CurrentValue)) {
            $this->product_id->HrefValue = $this->product_id->getLinkPrefix() . $this->product_id->CurrentValue; // Add prefix/suffix
            $this->product_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
            }
        } else {
            $this->product_id->HrefValue = "";
        }
        $this->product_id->TooltipValue = "";

        // batch_no
        if (!EmptyValue($this->batch_no->CurrentValue)) {
            $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
            $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
            }
        } else {
            $this->batch_no->HrefValue = "";
        }
        $this->batch_no->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // Size_wl
        $this->Size_wl->HrefValue = "";
        $this->Size_wl->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // req_material_rid
        if (!EmptyValue($this->req_material_rid->CurrentValue)) {
            $this->req_material_rid->HrefValue = $this->req_material_rid->getLinkPrefix() . $this->req_material_rid->CurrentValue; // Add prefix/suffix
            $this->req_material_rid->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
            }
        } else {
            $this->req_material_rid->HrefValue = "";
        }
        $this->req_material_rid->TooltipValue = "";

        // req_material_packing
        $this->req_material_packing->HrefValue = "";
        $this->req_material_packing->TooltipValue = "";

        // req_material_qty
        $this->req_material_qty->HrefValue = "";
        $this->req_material_qty->TooltipValue = "";

        // unit
        $this->unit->HrefValue = "";
        $this->unit->TooltipValue = "";

        // material_qty
        $this->material_qty->HrefValue = "";
        $this->material_qty->TooltipValue = "";

        // method
        $this->method->HrefValue = "";
        $this->method->TooltipValue = "";

        // despatch_week
        $this->despatch_week->HrefValue = "";
        $this->despatch_week->TooltipValue = "";

        // production_plan
        $this->production_plan->HrefValue = "";
        $this->production_plan->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // poid
        $this->poid->setupEditAttributes();
        $this->poid->EditValue = $this->poid->CurrentValue;
        $this->poid->EditValue = FormatNumber($this->poid->EditValue, $this->poid->formatPattern());

        // weaving_works
        $this->weaving_works->setupEditAttributes();
        if ($this->weaving_works->getSessionValue() != "") {
            $this->weaving_works->CurrentValue = GetForeignKeyValue($this->weaving_works->getSessionValue());
            $curVal = strval($this->weaving_works->CurrentValue);
            if ($curVal != "") {
                $this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
                if ($this->weaving_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->weaving_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->weaving_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->weaving_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->weaving_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->weaving_works->Lookup->renderViewRow($rswrk[0]);
                        $this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
                    } else {
                        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->CurrentValue, $this->weaving_works->formatPattern());
                    }
                }
            } else {
                $this->weaving_works->ViewValue = null;
            }
        } else {
            $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());
        }

        // week
        $this->week->setupEditAttributes();
        if ($this->week->getSessionValue() != "") {
            $this->week->CurrentValue = GetForeignKeyValue($this->week->getSessionValue());
            $curVal = strval($this->week->CurrentValue);
            if ($curVal != "") {
                $this->week->ViewValue = $this->week->lookupCacheOption($curVal);
                if ($this->week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                        $this->week->ViewValue = $this->week->displayValue($arwrk);
                    } else {
                        $this->week->ViewValue = $this->week->CurrentValue;
                    }
                }
            } else {
                $this->week->ViewValue = null;
            }
        } else {
            $this->week->PlaceHolder = RemoveHtml($this->week->caption());
        }

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;

        // buyer_id
        $this->buyer_id->setupEditAttributes();
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
                }
            }
        } else {
            $this->buyer_id->EditValue = null;
        }

        // product_id
        $this->product_id->setupEditAttributes();
        $curVal = strval($this->product_id->CurrentValue);
        if ($curVal != "") {
            $this->product_id->EditValue = $this->product_id->lookupCacheOption($curVal);
            if ($this->product_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_id->Lookup->renderViewRow($rswrk[0]);
                    $this->product_id->EditValue = $this->product_id->displayValue($arwrk);
                } else {
                    $this->product_id->EditValue = $this->product_id->CurrentValue;
                }
            }
        } else {
            $this->product_id->EditValue = null;
        }

        // batch_no
        $this->batch_no->setupEditAttributes();
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->EditValue = $this->batch_no->CurrentValue;
                }
            }
        } else {
            $this->batch_no->EditValue = null;
        }

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, $this->quantity->formatPattern());

        // Size_wl
        $this->Size_wl->setupEditAttributes();
        $this->Size_wl->EditValue = $this->Size_wl->CurrentValue;

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, $this->sqm->formatPattern());

        // req_material_rid
        $this->req_material_rid->setupEditAttributes();
        if ($this->req_material_rid->VirtualValue != "") {
            $this->req_material_rid->EditValue = $this->req_material_rid->VirtualValue;
        } else {
            $curVal = strval($this->req_material_rid->CurrentValue);
            if ($curVal != "") {
                $this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
                if ($this->req_material_rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
                    } else {
                        $this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
                    }
                }
            } else {
                $this->req_material_rid->EditValue = null;
            }
        }

        // req_material_packing
        $this->req_material_packing->setupEditAttributes();
        if ($this->req_material_packing->getSessionValue() != "") {
            $this->req_material_packing->CurrentValue = GetForeignKeyValue($this->req_material_packing->getSessionValue());
            $curVal = strval($this->req_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
                if ($this->req_material_packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
                    } else {
                        $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                    }
                }
            } else {
                $this->req_material_packing->ViewValue = null;
            }
        } else {
            $this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());
        }

        // req_material_qty
        $this->req_material_qty->setupEditAttributes();
        $this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
        $this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, $this->req_material_qty->formatPattern());

        // unit
        $this->unit->setupEditAttributes();
        $curVal = strval($this->unit->CurrentValue);
        if ($curVal != "") {
            $this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
            if ($this->unit->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                    $this->unit->EditValue = $this->unit->displayValue($arwrk);
                } else {
                    $this->unit->EditValue = $this->unit->CurrentValue;
                }
            }
        } else {
            $this->unit->EditValue = null;
        }

        // material_qty
        $this->material_qty->setupEditAttributes();
        $this->material_qty->EditValue = $this->material_qty->CurrentValue;
        $this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, $this->material_qty->formatPattern());

        // method
        $this->method->setupEditAttributes();
        $curVal = strval($this->method->CurrentValue);
        if ($curVal != "") {
            $this->method->EditValue = $this->method->lookupCacheOption($curVal);
            if ($this->method->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                    $this->method->EditValue = $this->method->displayValue($arwrk);
                } else {
                    $this->method->EditValue = $this->method->CurrentValue;
                }
            }
        } else {
            $this->method->EditValue = null;
        }

        // despatch_week
        $this->despatch_week->setupEditAttributes();
        $curVal = strval($this->despatch_week->CurrentValue);
        if ($curVal != "") {
            $this->despatch_week->EditValue = $this->despatch_week->lookupCacheOption($curVal);
            if ($this->despatch_week->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                    $this->despatch_week->EditValue = $this->despatch_week->displayValue($arwrk);
                } else {
                    $this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
                }
            }
        } else {
            $this->despatch_week->EditValue = null;
        }

        // production_plan
        $this->production_plan->setupEditAttributes();
        if (strval($this->production_plan->CurrentValue) != "") {
            $this->production_plan->EditValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
        } else {
            $this->production_plan->EditValue = null;
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->req_material_qty->CurrentValue)) {
                $this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());
            $this->req_material_qty->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->poid);
                    $doc->exportCaption($this->weaving_works);
                    $doc->exportCaption($this->week);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->product_id);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->Size_wl);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->req_material_rid);
                    $doc->exportCaption($this->req_material_packing);
                    $doc->exportCaption($this->req_material_qty);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->material_qty);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->production_plan);
                } else {
                    $doc->exportCaption($this->weaving_works);
                    $doc->exportCaption($this->week);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->product_id);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->Size_wl);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->req_material_rid);
                    $doc->exportCaption($this->req_material_packing);
                    $doc->exportCaption($this->req_material_qty);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->material_qty);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->despatch_week);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->poid);
                        $doc->exportField($this->weaving_works);
                        $doc->exportField($this->week);
                        $doc->exportField($this->po);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->product_id);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->Size_wl);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->req_material_rid);
                        $doc->exportField($this->req_material_packing);
                        $doc->exportField($this->req_material_qty);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->material_qty);
                        $doc->exportField($this->method);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->production_plan);
                    } else {
                        $doc->exportField($this->weaving_works);
                        $doc->exportField($this->week);
                        $doc->exportField($this->po);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->product_id);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->Size_wl);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->req_material_rid);
                        $doc->exportField($this->req_material_packing);
                        $doc->exportField($this->req_material_qty);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->material_qty);
                        $doc->exportField($this->method);
                        $doc->exportField($this->despatch_week);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->weaving_works, '');
                $doc->exportAggregate($this->week, '');
                $doc->exportAggregate($this->po, '');
                $doc->exportAggregate($this->buyer_id, '');
                $doc->exportAggregate($this->product_id, '');
                $doc->exportAggregate($this->quantity, '');
                $doc->exportAggregate($this->Size_wl, '');
                $doc->exportAggregate($this->sqm, '');
                $doc->exportAggregate($this->req_material_rid, '');
                $doc->exportAggregate($this->req_material_packing, '');
                $doc->exportAggregate($this->req_material_qty, 'TOTAL');
                $doc->exportAggregate($this->unit, '');
                $doc->exportAggregate($this->material_qty, '');
                $doc->exportAggregate($this->method, '');
                $doc->exportAggregate($this->despatch_week, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
