<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialRequiredProcessingOutsideAdd extends MaterialRequiredProcessingOutside
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialRequiredProcessingOutsideAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "materialrequiredprocessingoutsideadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->poid->setVisibility();
        $this->location->setVisibility();
        $this->week->setVisibility();
        $this->po->Visible = false;
        $this->buyer_id->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->product_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->quantity->setVisibility();
        $this->size_cm->setVisibility();
        $this->sqm->setVisibility();
        $this->t_sqm->setVisibility();
        $this->req_material_grp->setVisibility();
        $this->req_material_sgrp->setVisibility();
        $this->req_material_product->setVisibility();
        $this->req_material_packing->setVisibility();
        $this->req_material_rid->setVisibility();
        $this->req_material_qty->setVisibility();
        $this->issued_qty->Visible = false;
        $this->issued_pkt->setVisibility();
        $this->lot_no->setVisibility();
        $this->stock->setVisibility();
        $this->short->setVisibility();
        $this->unit->setVisibility();
        $this->material_qty->setVisibility();
        $this->method->setVisibility();
        $this->despatch_week->setVisibility();
        $this->despatch_date->setVisibility();
        $this->production_plan->setVisibility();
        $this->remarks->setVisibility();
        $this->updated->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->issue_to->Visible = false;
        $this->jc_no->Visible = false;
        $this->company_id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'material_required_processing_outside';
        $this->TableName = 'material_required_processing_outside';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_required_processing_outside)
        if (!isset($GLOBALS["material_required_processing_outside"]) || $GLOBALS["material_required_processing_outside"]::class == PROJECT_NAMESPACE . "material_required_processing_outside") {
            $GLOBALS["material_required_processing_outside"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required_processing_outside');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "materialrequiredprocessingoutsideview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->week);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->product_id);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->req_material_grp);
        $this->setupLookupOptions($this->req_material_sgrp);
        $this->setupLookupOptions($this->req_material_product);
        $this->setupLookupOptions($this->req_material_packing);
        $this->setupLookupOptions($this->req_material_rid);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->issue_to);
        $this->setupLookupOptions($this->company_id);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("materialrequiredprocessingoutsidelist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "materialrequiredprocessingoutsidelist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "materialrequiredprocessingoutsideview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "materialrequiredprocessingoutsidelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "materialrequiredprocessingoutsidelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->week->DefaultValue = $this->week->getDefault(); // PHP
        $this->week->OldValue = $this->week->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->issued_pkt->DefaultValue = $this->issued_pkt->getDefault(); // PHP
        $this->issued_pkt->OldValue = $this->issued_pkt->DefaultValue;
        $this->stock->DefaultValue = $this->stock->getDefault(); // PHP
        $this->stock->OldValue = $this->stock->DefaultValue;
        $this->updated->DefaultValue = $this->updated->getDefault(); // PHP
        $this->updated->OldValue = $this->updated->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'poid' first before field var 'x_poid'
        $val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
        if (!$this->poid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->poid->Visible = false; // Disable update for API request
            } else {
                $this->poid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }

        // Check field name 'week' first before field var 'x_week'
        $val = $CurrentForm->hasValue("week") ? $CurrentForm->getValue("week") : $CurrentForm->getValue("x_week");
        if (!$this->week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->week->Visible = false; // Disable update for API request
            } else {
                $this->week->setFormValue($val);
            }
        }

        // Check field name 'buyer_id' first before field var 'x_buyer_id'
        $val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
        if (!$this->buyer_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_id->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'product_id' first before field var 'x_product_id'
        $val = $CurrentForm->hasValue("product_id") ? $CurrentForm->getValue("product_id") : $CurrentForm->getValue("x_product_id");
        if (!$this->product_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_id->Visible = false; // Disable update for API request
            } else {
                $this->product_id->setFormValue($val);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val);
            }
        }

        // Check field name 'size_cm' first before field var 'x_size_cm'
        $val = $CurrentForm->hasValue("size_cm") ? $CurrentForm->getValue("size_cm") : $CurrentForm->getValue("x_size_cm");
        if (!$this->size_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_cm->Visible = false; // Disable update for API request
            } else {
                $this->size_cm->setFormValue($val);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 't_sqm' first before field var 'x_t_sqm'
        $val = $CurrentForm->hasValue("t_sqm") ? $CurrentForm->getValue("t_sqm") : $CurrentForm->getValue("x_t_sqm");
        if (!$this->t_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_sqm->Visible = false; // Disable update for API request
            } else {
                $this->t_sqm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'req_material_grp' first before field var 'x_req_material_grp'
        $val = $CurrentForm->hasValue("req_material_grp") ? $CurrentForm->getValue("req_material_grp") : $CurrentForm->getValue("x_req_material_grp");
        if (!$this->req_material_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_grp->Visible = false; // Disable update for API request
            } else {
                $this->req_material_grp->setFormValue($val);
            }
        }

        // Check field name 'req_material_sgrp' first before field var 'x_req_material_sgrp'
        $val = $CurrentForm->hasValue("req_material_sgrp") ? $CurrentForm->getValue("req_material_sgrp") : $CurrentForm->getValue("x_req_material_sgrp");
        if (!$this->req_material_sgrp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_sgrp->Visible = false; // Disable update for API request
            } else {
                $this->req_material_sgrp->setFormValue($val);
            }
        }

        // Check field name 'req_material_product' first before field var 'x_req_material_product'
        $val = $CurrentForm->hasValue("req_material_product") ? $CurrentForm->getValue("req_material_product") : $CurrentForm->getValue("x_req_material_product");
        if (!$this->req_material_product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_product->Visible = false; // Disable update for API request
            } else {
                $this->req_material_product->setFormValue($val);
            }
        }

        // Check field name 'req_material_packing' first before field var 'x_req_material_packing'
        $val = $CurrentForm->hasValue("req_material_packing") ? $CurrentForm->getValue("req_material_packing") : $CurrentForm->getValue("x_req_material_packing");
        if (!$this->req_material_packing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_packing->Visible = false; // Disable update for API request
            } else {
                $this->req_material_packing->setFormValue($val);
            }
        }

        // Check field name 'req_material_rid' first before field var 'x_req_material_rid'
        $val = $CurrentForm->hasValue("req_material_rid") ? $CurrentForm->getValue("req_material_rid") : $CurrentForm->getValue("x_req_material_rid");
        if (!$this->req_material_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_rid->Visible = false; // Disable update for API request
            } else {
                $this->req_material_rid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'req_material_qty' first before field var 'x_req_material_qty'
        $val = $CurrentForm->hasValue("req_material_qty") ? $CurrentForm->getValue("req_material_qty") : $CurrentForm->getValue("x_req_material_qty");
        if (!$this->req_material_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_qty->Visible = false; // Disable update for API request
            } else {
                $this->req_material_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'issued_pkt' first before field var 'x_issued_pkt'
        $val = $CurrentForm->hasValue("issued_pkt") ? $CurrentForm->getValue("issued_pkt") : $CurrentForm->getValue("x_issued_pkt");
        if (!$this->issued_pkt->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issued_pkt->Visible = false; // Disable update for API request
            } else {
                $this->issued_pkt->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'lot_no' first before field var 'x_lot_no'
        $val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
        if (!$this->lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lot_no->Visible = false; // Disable update for API request
            } else {
                $this->lot_no->setFormValue($val);
            }
        }

        // Check field name 'stock' first before field var 'x_stock'
        $val = $CurrentForm->hasValue("stock") ? $CurrentForm->getValue("stock") : $CurrentForm->getValue("x_stock");
        if (!$this->stock->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->stock->Visible = false; // Disable update for API request
            } else {
                $this->stock->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'short' first before field var 'x_short'
        $val = $CurrentForm->hasValue("short") ? $CurrentForm->getValue("short") : $CurrentForm->getValue("x_short");
        if (!$this->short->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->short->Visible = false; // Disable update for API request
            } else {
                $this->short->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }

        // Check field name 'material_qty' first before field var 'x_material_qty'
        $val = $CurrentForm->hasValue("material_qty") ? $CurrentForm->getValue("material_qty") : $CurrentForm->getValue("x_material_qty");
        if (!$this->material_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->material_qty->Visible = false; // Disable update for API request
            } else {
                $this->material_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'method' first before field var 'x_method'
        $val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
        if (!$this->method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->method->Visible = false; // Disable update for API request
            } else {
                $this->method->setFormValue($val);
            }
        }

        // Check field name 'despatch_week' first before field var 'x_despatch_week'
        $val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
        if (!$this->despatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_week->Visible = false; // Disable update for API request
            } else {
                $this->despatch_week->setFormValue($val);
            }
        }

        // Check field name 'despatch_date' first before field var 'x_despatch_date'
        $val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
        if (!$this->despatch_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_date->Visible = false; // Disable update for API request
            } else {
                $this->despatch_date->setFormValue($val, true, $validate);
            }
            $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        }

        // Check field name 'production_plan' first before field var 'x_production_plan'
        $val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
        if (!$this->production_plan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->production_plan->Visible = false; // Disable update for API request
            } else {
                $this->production_plan->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'updated' first before field var 'x_updated'
        $val = $CurrentForm->hasValue("updated") ? $CurrentForm->getValue("updated") : $CurrentForm->getValue("x_updated");
        if (!$this->updated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->updated->Visible = false; // Disable update for API request
            } else {
                $this->updated->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->poid->CurrentValue = $this->poid->FormValue;
        $this->location->CurrentValue = $this->location->FormValue;
        $this->week->CurrentValue = $this->week->FormValue;
        $this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->product_id->CurrentValue = $this->product_id->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->size_cm->CurrentValue = $this->size_cm->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->t_sqm->CurrentValue = $this->t_sqm->FormValue;
        $this->req_material_grp->CurrentValue = $this->req_material_grp->FormValue;
        $this->req_material_sgrp->CurrentValue = $this->req_material_sgrp->FormValue;
        $this->req_material_product->CurrentValue = $this->req_material_product->FormValue;
        $this->req_material_packing->CurrentValue = $this->req_material_packing->FormValue;
        $this->req_material_rid->CurrentValue = $this->req_material_rid->FormValue;
        $this->req_material_qty->CurrentValue = $this->req_material_qty->FormValue;
        $this->issued_pkt->CurrentValue = $this->issued_pkt->FormValue;
        $this->lot_no->CurrentValue = $this->lot_no->FormValue;
        $this->stock->CurrentValue = $this->stock->FormValue;
        $this->short->CurrentValue = $this->short->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->material_qty->CurrentValue = $this->material_qty->FormValue;
        $this->method->CurrentValue = $this->method->FormValue;
        $this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
        $this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
        $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->production_plan->CurrentValue = $this->production_plan->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->updated->CurrentValue = $this->updated->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->poid->setDbValue($row['poid']);
        $this->location->setDbValue($row['location']);
        $this->week->setDbValue($row['week']);
        $this->po->setDbValue($row['po']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->quantity->setDbValue($row['quantity']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->t_sqm->setDbValue($row['t_sqm']);
        $this->req_material_grp->setDbValue($row['req_material_grp']);
        $this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
        $this->req_material_product->setDbValue($row['req_material_product']);
        $this->req_material_packing->setDbValue($row['req_material_packing']);
        $this->req_material_rid->setDbValue($row['req_material_rid']);
        $this->req_material_qty->setDbValue($row['req_material_qty']);
        $this->issued_qty->setDbValue($row['issued_qty']);
        $this->issued_pkt->setDbValue($row['issued_pkt']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->stock->setDbValue($row['stock']);
        $this->short->setDbValue($row['short']);
        $this->unit->setDbValue($row['unit']);
        $this->material_qty->setDbValue($row['material_qty']);
        $this->method->setDbValue($row['method']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->remarks->setDbValue($row['remarks']);
        $this->updated->setDbValue($row['updated']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->company_id->setDbValue($row['company_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['poid'] = $this->poid->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['week'] = $this->week->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_id'] = $this->product_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['size_cm'] = $this->size_cm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['t_sqm'] = $this->t_sqm->DefaultValue;
        $row['req_material_grp'] = $this->req_material_grp->DefaultValue;
        $row['req_material_sgrp'] = $this->req_material_sgrp->DefaultValue;
        $row['req_material_product'] = $this->req_material_product->DefaultValue;
        $row['req_material_packing'] = $this->req_material_packing->DefaultValue;
        $row['req_material_rid'] = $this->req_material_rid->DefaultValue;
        $row['req_material_qty'] = $this->req_material_qty->DefaultValue;
        $row['issued_qty'] = $this->issued_qty->DefaultValue;
        $row['issued_pkt'] = $this->issued_pkt->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['stock'] = $this->stock->DefaultValue;
        $row['short'] = $this->short->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['material_qty'] = $this->material_qty->DefaultValue;
        $row['method'] = $this->method->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['issue_to'] = $this->issue_to->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // poid
        $this->poid->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // week
        $this->week->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_id
        $this->product_id->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // size_cm
        $this->size_cm->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // t_sqm
        $this->t_sqm->RowCssClass = "row";

        // req_material_grp
        $this->req_material_grp->RowCssClass = "row";

        // req_material_sgrp
        $this->req_material_sgrp->RowCssClass = "row";

        // req_material_product
        $this->req_material_product->RowCssClass = "row";

        // req_material_packing
        $this->req_material_packing->RowCssClass = "row";

        // req_material_rid
        $this->req_material_rid->RowCssClass = "row";

        // req_material_qty
        $this->req_material_qty->RowCssClass = "row";

        // issued_qty
        $this->issued_qty->RowCssClass = "row";

        // issued_pkt
        $this->issued_pkt->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // stock
        $this->stock->RowCssClass = "row";

        // short
        $this->short->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // material_qty
        $this->material_qty->RowCssClass = "row";

        // method
        $this->method->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // issue_to
        $this->issue_to->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // poid
            $this->poid->ViewValue = $this->poid->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // week
            $curVal = strval($this->week->CurrentValue);
            if ($curVal != "") {
                $this->week->ViewValue = $this->week->lookupCacheOption($curVal);
                if ($this->week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                        $this->week->ViewValue = $this->week->displayValue($arwrk);
                    } else {
                        $this->week->ViewValue = FormatNumber($this->week->CurrentValue, $this->week->formatPattern());
                    }
                }
            } else {
                $this->week->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // grp
            if (strval($this->grp->CurrentValue) != "") {
                $this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_id
            $curVal = strval($this->product_id->CurrentValue);
            if ($curVal != "") {
                $this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
                if ($this->product_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_id->Lookup->renderViewRow($rswrk[0]);
                        $this->product_id->ViewValue = $this->product_id->displayValue($arwrk);
                    } else {
                        $this->product_id->ViewValue = $this->product_id->CurrentValue;
                    }
                }
            } else {
                $this->product_id->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // t_sqm
            $this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
            $this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, $this->t_sqm->formatPattern());

            // req_material_grp
            $curVal = strval($this->req_material_grp->CurrentValue);
            if ($curVal != "") {
                $this->req_material_grp->ViewValue = $this->req_material_grp->lookupCacheOption($curVal);
                if ($this->req_material_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_grp->ViewValue = $this->req_material_grp->displayValue($arwrk);
                    } else {
                        $this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->CurrentValue, $this->req_material_grp->formatPattern());
                    }
                }
            } else {
                $this->req_material_grp->ViewValue = null;
            }

            // req_material_sgrp
            $curVal = strval($this->req_material_sgrp->CurrentValue);
            if ($curVal != "") {
                $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
                if ($this->req_material_sgrp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_sgrp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_sgrp->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
                    } else {
                        $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
                    }
                }
            } else {
                $this->req_material_sgrp->ViewValue = null;
            }

            // req_material_product
            $curVal = strval($this->req_material_product->CurrentValue);
            if ($curVal != "") {
                $this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
                if ($this->req_material_product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_product->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
                    } else {
                        $this->req_material_product->ViewValue = FormatNumber($this->req_material_product->CurrentValue, $this->req_material_product->formatPattern());
                    }
                }
            } else {
                $this->req_material_product->ViewValue = null;
            }

            // req_material_packing
            $curVal = strval($this->req_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
                if ($this->req_material_packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
                    } else {
                        $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                    }
                }
            } else {
                $this->req_material_packing->ViewValue = null;
            }

            // req_material_rid
            $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
            $curVal = strval($this->req_material_rid->CurrentValue);
            if ($curVal != "") {
                $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
                if ($this->req_material_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
                    } else {
                        $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
                    }
                }
            } else {
                $this->req_material_rid->ViewValue = null;
            }

            // req_material_qty
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

            // issued_qty
            $this->issued_qty->ViewValue = $this->issued_qty->CurrentValue;
            $this->issued_qty->ViewValue = FormatNumber($this->issued_qty->ViewValue, $this->issued_qty->formatPattern());

            // issued_pkt
            $this->issued_pkt->ViewValue = $this->issued_pkt->CurrentValue;
            $this->issued_pkt->ViewValue = FormatNumber($this->issued_pkt->ViewValue, $this->issued_pkt->formatPattern());

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // stock
            $this->stock->ViewValue = $this->stock->CurrentValue;
            $this->stock->ViewValue = FormatNumber($this->stock->ViewValue, $this->stock->formatPattern());

            // short
            $this->short->ViewValue = $this->short->CurrentValue;
            $this->short->ViewValue = FormatNumber($this->short->ViewValue, $this->short->formatPattern());

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = $this->unit->CurrentValue;
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // material_qty
            $this->material_qty->ViewValue = $this->material_qty->CurrentValue;
            $this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, $this->material_qty->formatPattern());

            // method
            $curVal = strval($this->method->CurrentValue);
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
                if ($this->method->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->method->getSelectFilter($this); // PHP
                    $sqlWrk = $this->method->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->method->Lookup->renderViewRow($rswrk[0]);
                        $this->method->ViewValue = $this->method->displayValue($arwrk);
                    } else {
                        $this->method->ViewValue = $this->method->CurrentValue;
                    }
                }
            } else {
                $this->method->ViewValue = null;
            }

            // despatch_week
            $curVal = strval($this->despatch_week->CurrentValue);
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
                if ($this->despatch_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                        $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                    } else {
                        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
                    }
                }
            } else {
                $this->despatch_week->ViewValue = null;
            }

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // production_plan
            if (strval($this->production_plan->CurrentValue) != "") {
                $this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
            } else {
                $this->production_plan->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // updated
            $this->updated->ViewValue = $this->updated->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // poid
            $this->poid->HrefValue = "";
            $this->poid->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // week
            $this->week->HrefValue = "";
            $this->week->TooltipValue = "";

            // buyer_id
            if (!EmptyValue($this->buyer_id->CurrentValue)) {
                $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
                $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
                }
            } else {
                $this->buyer_id->HrefValue = "";
            }
            $this->buyer_id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // product_id
            if (!EmptyValue($this->product_id->CurrentValue)) {
                $this->product_id->HrefValue = $this->product_id->getLinkPrefix() . $this->product_id->CurrentValue; // Add prefix/suffix
                $this->product_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
                }
            } else {
                $this->product_id->HrefValue = "";
            }
            $this->product_id->TooltipValue = "";

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }
            $this->batch_no->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // t_sqm
            $this->t_sqm->HrefValue = "";
            $this->t_sqm->TooltipValue = "";

            // req_material_grp
            $this->req_material_grp->HrefValue = "";

            // req_material_sgrp
            $this->req_material_sgrp->HrefValue = "";

            // req_material_product
            $this->req_material_product->HrefValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";

            // req_material_rid
            if (!EmptyValue($this->req_material_rid->CurrentValue)) {
                $this->req_material_rid->HrefValue = $this->req_material_rid->getLinkPrefix() . $this->req_material_rid->CurrentValue; // Add prefix/suffix
                $this->req_material_rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
                }
            } else {
                $this->req_material_rid->HrefValue = "";
            }

            // req_material_qty
            $this->req_material_qty->HrefValue = "";
            $this->req_material_qty->TooltipValue = "";

            // issued_pkt
            $this->issued_pkt->HrefValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";

            // stock
            $this->stock->HrefValue = "";
            $this->stock->TooltipValue = "";

            // short
            $this->short->HrefValue = "";
            $this->short->TooltipValue = "";

            // unit
            $this->unit->HrefValue = "";
            $this->unit->TooltipValue = "";

            // material_qty
            $this->material_qty->HrefValue = "";
            $this->material_qty->TooltipValue = "";

            // method
            $this->method->HrefValue = "";
            $this->method->TooltipValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";
            $this->despatch_week->TooltipValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";
            $this->despatch_date->TooltipValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";
            $this->production_plan->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // updated
            $this->updated->HrefValue = "";
            $this->updated->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // poid
            $this->poid->setupEditAttributes();
            $this->poid->EditValue = $this->poid->CurrentValue;
            $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());
            if (strval($this->poid->EditValue) != "" && is_numeric($this->poid->EditValue)) {
                $this->poid->EditValue = $this->poid->EditValue;
            }

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->CurrentValue));
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->CurrentValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // week
            $this->week->setupEditAttributes();
            $curVal = trim(strval($this->week->CurrentValue));
            if ($curVal != "") {
                $this->week->ViewValue = $this->week->lookupCacheOption($curVal);
            } else {
                $this->week->ViewValue = $this->week->Lookup !== null && is_array($this->week->lookupOptions()) && count($this->week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->week->ViewValue !== null) { // Load from cache
                $this->week->EditValue = array_values($this->week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->week->CurrentValue, $this->week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->week->getSelectFilter($this); // PHP
                $sqlWrk = $this->week->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->week->EditValue = $arwrk;
            }
            $this->week->PlaceHolder = RemoveHtml($this->week->caption());

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $curVal = trim(strval($this->buyer_id->CurrentValue));
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            } else {
                $this->buyer_id->ViewValue = $this->buyer_id->Lookup !== null && is_array($this->buyer_id->lookupOptions()) && count($this->buyer_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_id->ViewValue !== null) { // Load from cache
                $this->buyer_id->EditValue = array_values($this->buyer_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyer_id->CurrentValue, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyer_id->EditValue = $arwrk;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->options(true);
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // product_id
            $this->product_id->setupEditAttributes();
            $curVal = trim(strval($this->product_id->CurrentValue));
            if ($curVal != "") {
                $this->product_id->ViewValue = $this->product_id->lookupCacheOption($curVal);
            } else {
                $this->product_id->ViewValue = $this->product_id->Lookup !== null && is_array($this->product_id->lookupOptions()) && count($this->product_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_id->ViewValue !== null) { // Load from cache
                $this->product_id->EditValue = array_values($this->product_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_id->CurrentValue, $this->product_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_id->EditValue = $arwrk;
            }
            $this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());

            // batch_no
            $curVal = trim(strval($this->batch_no->CurrentValue));
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
                if ($this->batch_no->ViewValue == "") {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->CurrentValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // size_cm
            $this->size_cm->setupEditAttributes();
            if (!$this->size_cm->Raw) {
                $this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
            }
            $this->size_cm->EditValue = HtmlEncode($this->size_cm->CurrentValue);
            $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
            if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
                $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
            }

            // t_sqm
            $this->t_sqm->setupEditAttributes();
            $this->t_sqm->EditValue = $this->t_sqm->CurrentValue;
            $this->t_sqm->PlaceHolder = RemoveHtml($this->t_sqm->caption());
            if (strval($this->t_sqm->EditValue) != "" && is_numeric($this->t_sqm->EditValue)) {
                $this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, null);
            }

            // req_material_grp
            $this->req_material_grp->setupEditAttributes();
            $curVal = trim(strval($this->req_material_grp->CurrentValue));
            if ($curVal != "") {
                $this->req_material_grp->ViewValue = $this->req_material_grp->lookupCacheOption($curVal);
            } else {
                $this->req_material_grp->ViewValue = $this->req_material_grp->Lookup !== null && is_array($this->req_material_grp->lookupOptions()) && count($this->req_material_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->req_material_grp->ViewValue !== null) { // Load from cache
                $this->req_material_grp->EditValue = array_values($this->req_material_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->req_material_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->req_material_grp->CurrentValue, $this->req_material_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->req_material_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->req_material_grp->EditValue = $arwrk;
            }
            $this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());

            // req_material_sgrp
            $this->req_material_sgrp->setupEditAttributes();
            $curVal = trim(strval($this->req_material_sgrp->CurrentValue));
            if ($curVal != "") {
                $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
            } else {
                $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->Lookup !== null && is_array($this->req_material_sgrp->lookupOptions()) && count($this->req_material_sgrp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->req_material_sgrp->ViewValue !== null) { // Load from cache
                $this->req_material_sgrp->EditValue = array_values($this->req_material_sgrp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->req_material_sgrp->CurrentValue, $this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->req_material_sgrp->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_sgrp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->req_material_sgrp->EditValue = $arwrk;
            }
            $this->req_material_sgrp->PlaceHolder = RemoveHtml($this->req_material_sgrp->caption());

            // req_material_product
            $this->req_material_product->setupEditAttributes();
            $curVal = trim(strval($this->req_material_product->CurrentValue));
            if ($curVal != "") {
                $this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
            } else {
                $this->req_material_product->ViewValue = $this->req_material_product->Lookup !== null && is_array($this->req_material_product->lookupOptions()) && count($this->req_material_product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->req_material_product->ViewValue !== null) { // Load from cache
                $this->req_material_product->EditValue = array_values($this->req_material_product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->req_material_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->req_material_product->CurrentValue, $this->req_material_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->req_material_product->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->req_material_product->EditValue = $arwrk;
            }
            $this->req_material_product->PlaceHolder = RemoveHtml($this->req_material_product->caption());

            // req_material_packing
            $this->req_material_packing->setupEditAttributes();
            $curVal = trim(strval($this->req_material_packing->CurrentValue));
            if ($curVal != "") {
                $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
            } else {
                $this->req_material_packing->ViewValue = $this->req_material_packing->Lookup !== null && is_array($this->req_material_packing->lookupOptions()) && count($this->req_material_packing->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->req_material_packing->ViewValue !== null) { // Load from cache
                $this->req_material_packing->EditValue = array_values($this->req_material_packing->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->req_material_packing->CurrentValue, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_packing->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->req_material_packing->EditValue = $arwrk;
            }
            $this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());

            // req_material_rid
            $this->req_material_rid->setupEditAttributes();
            $this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
            $curVal = strval($this->req_material_rid->CurrentValue);
            if ($curVal != "") {
                $this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
                if ($this->req_material_rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
                    } else {
                        $this->req_material_rid->EditValue = HtmlEncode($this->req_material_rid->CurrentValue);
                    }
                }
            } else {
                $this->req_material_rid->EditValue = null;
            }
            $this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

            // req_material_qty
            $this->req_material_qty->setupEditAttributes();
            $this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
            if (strval($this->req_material_qty->EditValue) != "" && is_numeric($this->req_material_qty->EditValue)) {
                $this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, null);
            }

            // issued_pkt
            $this->issued_pkt->setupEditAttributes();
            $this->issued_pkt->EditValue = $this->issued_pkt->CurrentValue;
            $this->issued_pkt->PlaceHolder = RemoveHtml($this->issued_pkt->caption());
            if (strval($this->issued_pkt->EditValue) != "" && is_numeric($this->issued_pkt->EditValue)) {
                $this->issued_pkt->EditValue = FormatNumber($this->issued_pkt->EditValue, null);
            }

            // lot_no
            $this->lot_no->setupEditAttributes();
            if (!$this->lot_no->Raw) {
                $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // stock
            $this->stock->setupEditAttributes();
            $this->stock->EditValue = $this->stock->CurrentValue;
            $this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
            if (strval($this->stock->EditValue) != "" && is_numeric($this->stock->EditValue)) {
                $this->stock->EditValue = FormatNumber($this->stock->EditValue, null);
            }

            // short
            $this->short->setupEditAttributes();
            $this->short->EditValue = $this->short->CurrentValue;
            $this->short->PlaceHolder = RemoveHtml($this->short->caption());
            if (strval($this->short->EditValue) != "" && is_numeric($this->short->EditValue)) {
                $this->short->EditValue = FormatNumber($this->short->EditValue, null);
            }

            // unit
            $this->unit->setupEditAttributes();
            $curVal = trim(strval($this->unit->CurrentValue));
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            } else {
                $this->unit->ViewValue = $this->unit->Lookup !== null && is_array($this->unit->lookupOptions()) && count($this->unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->unit->ViewValue !== null) { // Load from cache
                $this->unit->EditValue = array_values($this->unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->unit->CurrentValue, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->unit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->unit->EditValue = $arwrk;
            }
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // material_qty
            $this->material_qty->setupEditAttributes();
            $this->material_qty->EditValue = $this->material_qty->CurrentValue;
            $this->material_qty->PlaceHolder = RemoveHtml($this->material_qty->caption());
            if (strval($this->material_qty->EditValue) != "" && is_numeric($this->material_qty->EditValue)) {
                $this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, null);
            }

            // method
            $this->method->setupEditAttributes();
            $curVal = trim(strval($this->method->CurrentValue));
            if ($curVal != "") {
                $this->method->ViewValue = $this->method->lookupCacheOption($curVal);
            } else {
                $this->method->ViewValue = $this->method->Lookup !== null && is_array($this->method->lookupOptions()) && count($this->method->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->method->ViewValue !== null) { // Load from cache
                $this->method->EditValue = array_values($this->method->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->method->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->method->CurrentValue, $this->method->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->method->getSelectFilter($this); // PHP
                $sqlWrk = $this->method->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->method->EditValue = $arwrk;
            }
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $curVal = trim(strval($this->despatch_week->CurrentValue));
            if ($curVal != "") {
                $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            } else {
                $this->despatch_week->ViewValue = $this->despatch_week->Lookup !== null && is_array($this->despatch_week->lookupOptions()) && count($this->despatch_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->despatch_week->ViewValue !== null) { // Load from cache
                $this->despatch_week->EditValue = array_values($this->despatch_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->despatch_week->CurrentValue, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->despatch_week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->despatch_week->EditValue = $arwrk;
            }
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()));
            $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

            // production_plan
            $this->production_plan->setupEditAttributes();
            $this->production_plan->EditValue = $this->production_plan->options(true);
            $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // updated
            $this->updated->setupEditAttributes();
            $this->updated->EditValue = $this->updated->CurrentValue;
            $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
            if (strval($this->updated->EditValue) != "" && is_numeric($this->updated->EditValue)) {
                $this->updated->EditValue = $this->updated->EditValue;
            }

            // operator

            // datetime

            // Add refer script

            // poid
            $this->poid->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // week
            $this->week->HrefValue = "";

            // buyer_id
            if (!EmptyValue($this->buyer_id->CurrentValue)) {
                $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
                $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
                }
            } else {
                $this->buyer_id->HrefValue = "";
            }

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // product_id
            if (!EmptyValue($this->product_id->CurrentValue)) {
                $this->product_id->HrefValue = $this->product_id->getLinkPrefix() . $this->product_id->CurrentValue; // Add prefix/suffix
                $this->product_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_id->HrefValue = FullUrl($this->product_id->HrefValue, "href");
                }
            } else {
                $this->product_id->HrefValue = "";
            }

            // batch_no
            if (!EmptyValue($this->batch_no->CurrentValue)) {
                $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
                $this->batch_no->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
                }
            } else {
                $this->batch_no->HrefValue = "";
            }

            // quantity
            $this->quantity->HrefValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // t_sqm
            $this->t_sqm->HrefValue = "";

            // req_material_grp
            $this->req_material_grp->HrefValue = "";

            // req_material_sgrp
            $this->req_material_sgrp->HrefValue = "";

            // req_material_product
            $this->req_material_product->HrefValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";

            // req_material_rid
            if (!EmptyValue($this->req_material_rid->CurrentValue)) {
                $this->req_material_rid->HrefValue = $this->req_material_rid->getLinkPrefix() . $this->req_material_rid->CurrentValue; // Add prefix/suffix
                $this->req_material_rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
                }
            } else {
                $this->req_material_rid->HrefValue = "";
            }

            // req_material_qty
            $this->req_material_qty->HrefValue = "";

            // issued_pkt
            $this->issued_pkt->HrefValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";

            // stock
            $this->stock->HrefValue = "";

            // short
            $this->short->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // material_qty
            $this->material_qty->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // updated
            $this->updated->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->poid->Visible && $this->poid->Required) {
                if (!$this->poid->IsDetailKey && EmptyValue($this->poid->FormValue)) {
                    $this->poid->addErrorMessage(str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->poid->FormValue)) {
                $this->poid->addErrorMessage($this->poid->getErrorMessage(false));
            }
            if ($this->location->Visible && $this->location->Required) {
                if (!$this->location->IsDetailKey && EmptyValue($this->location->FormValue)) {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->week->Visible && $this->week->Required) {
                if (!$this->week->IsDetailKey && EmptyValue($this->week->FormValue)) {
                    $this->week->addErrorMessage(str_replace("%s", $this->week->caption(), $this->week->RequiredErrorMessage));
                }
            }
            if ($this->buyer_id->Visible && $this->buyer_id->Required) {
                if (!$this->buyer_id->IsDetailKey && EmptyValue($this->buyer_id->FormValue)) {
                    $this->buyer_id->addErrorMessage(str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->product_id->Visible && $this->product_id->Required) {
                if (!$this->product_id->IsDetailKey && EmptyValue($this->product_id->FormValue)) {
                    $this->product_id->addErrorMessage(str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if ($this->size_cm->Visible && $this->size_cm->Required) {
                if (!$this->size_cm->IsDetailKey && EmptyValue($this->size_cm->FormValue)) {
                    $this->size_cm->addErrorMessage(str_replace("%s", $this->size_cm->caption(), $this->size_cm->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->sqm->FormValue)) {
                $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
            }
            if ($this->t_sqm->Visible && $this->t_sqm->Required) {
                if (!$this->t_sqm->IsDetailKey && EmptyValue($this->t_sqm->FormValue)) {
                    $this->t_sqm->addErrorMessage(str_replace("%s", $this->t_sqm->caption(), $this->t_sqm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->t_sqm->FormValue)) {
                $this->t_sqm->addErrorMessage($this->t_sqm->getErrorMessage(false));
            }
            if ($this->req_material_grp->Visible && $this->req_material_grp->Required) {
                if (!$this->req_material_grp->IsDetailKey && EmptyValue($this->req_material_grp->FormValue)) {
                    $this->req_material_grp->addErrorMessage(str_replace("%s", $this->req_material_grp->caption(), $this->req_material_grp->RequiredErrorMessage));
                }
            }
            if ($this->req_material_sgrp->Visible && $this->req_material_sgrp->Required) {
                if (!$this->req_material_sgrp->IsDetailKey && EmptyValue($this->req_material_sgrp->FormValue)) {
                    $this->req_material_sgrp->addErrorMessage(str_replace("%s", $this->req_material_sgrp->caption(), $this->req_material_sgrp->RequiredErrorMessage));
                }
            }
            if ($this->req_material_product->Visible && $this->req_material_product->Required) {
                if (!$this->req_material_product->IsDetailKey && EmptyValue($this->req_material_product->FormValue)) {
                    $this->req_material_product->addErrorMessage(str_replace("%s", $this->req_material_product->caption(), $this->req_material_product->RequiredErrorMessage));
                }
            }
            if ($this->req_material_packing->Visible && $this->req_material_packing->Required) {
                if (!$this->req_material_packing->IsDetailKey && EmptyValue($this->req_material_packing->FormValue)) {
                    $this->req_material_packing->addErrorMessage(str_replace("%s", $this->req_material_packing->caption(), $this->req_material_packing->RequiredErrorMessage));
                }
            }
            if ($this->req_material_rid->Visible && $this->req_material_rid->Required) {
                if (!$this->req_material_rid->IsDetailKey && EmptyValue($this->req_material_rid->FormValue)) {
                    $this->req_material_rid->addErrorMessage(str_replace("%s", $this->req_material_rid->caption(), $this->req_material_rid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->req_material_rid->FormValue)) {
                $this->req_material_rid->addErrorMessage($this->req_material_rid->getErrorMessage(false));
            }
            if ($this->req_material_qty->Visible && $this->req_material_qty->Required) {
                if (!$this->req_material_qty->IsDetailKey && EmptyValue($this->req_material_qty->FormValue)) {
                    $this->req_material_qty->addErrorMessage(str_replace("%s", $this->req_material_qty->caption(), $this->req_material_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->req_material_qty->FormValue)) {
                $this->req_material_qty->addErrorMessage($this->req_material_qty->getErrorMessage(false));
            }
            if ($this->issued_pkt->Visible && $this->issued_pkt->Required) {
                if (!$this->issued_pkt->IsDetailKey && EmptyValue($this->issued_pkt->FormValue)) {
                    $this->issued_pkt->addErrorMessage(str_replace("%s", $this->issued_pkt->caption(), $this->issued_pkt->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->issued_pkt->FormValue)) {
                $this->issued_pkt->addErrorMessage($this->issued_pkt->getErrorMessage(false));
            }
            if ($this->lot_no->Visible && $this->lot_no->Required) {
                if (!$this->lot_no->IsDetailKey && EmptyValue($this->lot_no->FormValue)) {
                    $this->lot_no->addErrorMessage(str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
                }
            }
            if ($this->stock->Visible && $this->stock->Required) {
                if (!$this->stock->IsDetailKey && EmptyValue($this->stock->FormValue)) {
                    $this->stock->addErrorMessage(str_replace("%s", $this->stock->caption(), $this->stock->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->stock->FormValue)) {
                $this->stock->addErrorMessage($this->stock->getErrorMessage(false));
            }
            if ($this->short->Visible && $this->short->Required) {
                if (!$this->short->IsDetailKey && EmptyValue($this->short->FormValue)) {
                    $this->short->addErrorMessage(str_replace("%s", $this->short->caption(), $this->short->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->short->FormValue)) {
                $this->short->addErrorMessage($this->short->getErrorMessage(false));
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->material_qty->Visible && $this->material_qty->Required) {
                if (!$this->material_qty->IsDetailKey && EmptyValue($this->material_qty->FormValue)) {
                    $this->material_qty->addErrorMessage(str_replace("%s", $this->material_qty->caption(), $this->material_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->material_qty->FormValue)) {
                $this->material_qty->addErrorMessage($this->material_qty->getErrorMessage(false));
            }
            if ($this->method->Visible && $this->method->Required) {
                if (!$this->method->IsDetailKey && EmptyValue($this->method->FormValue)) {
                    $this->method->addErrorMessage(str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
                }
            }
            if ($this->despatch_week->Visible && $this->despatch_week->Required) {
                if (!$this->despatch_week->IsDetailKey && EmptyValue($this->despatch_week->FormValue)) {
                    $this->despatch_week->addErrorMessage(str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
                }
            }
            if ($this->despatch_date->Visible && $this->despatch_date->Required) {
                if (!$this->despatch_date->IsDetailKey && EmptyValue($this->despatch_date->FormValue)) {
                    $this->despatch_date->addErrorMessage(str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->despatch_date->FormValue, $this->despatch_date->formatPattern())) {
                $this->despatch_date->addErrorMessage($this->despatch_date->getErrorMessage(false));
            }
            if ($this->production_plan->Visible && $this->production_plan->Required) {
                if (!$this->production_plan->IsDetailKey && EmptyValue($this->production_plan->FormValue)) {
                    $this->production_plan->addErrorMessage(str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->updated->Visible && $this->updated->Required) {
                if (!$this->updated->IsDetailKey && EmptyValue($this->updated->FormValue)) {
                    $this->updated->addErrorMessage(str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->updated->FormValue)) {
                $this->updated->addErrorMessage($this->updated->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // poid
        $this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, false);

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, false);

        // week
        $this->week->setDbValueDef($rsnew, $this->week->CurrentValue, false);

        // buyer_id
        $this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, false);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // product_id
        $this->product_id->setDbValueDef($rsnew, $this->product_id->CurrentValue, false);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // size_cm
        $this->size_cm->setDbValueDef($rsnew, $this->size_cm->CurrentValue, false);

        // sqm
        $this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, false);

        // t_sqm
        $this->t_sqm->setDbValueDef($rsnew, $this->t_sqm->CurrentValue, false);

        // req_material_grp
        $this->req_material_grp->setDbValueDef($rsnew, $this->req_material_grp->CurrentValue, false);

        // req_material_sgrp
        $this->req_material_sgrp->setDbValueDef($rsnew, $this->req_material_sgrp->CurrentValue, false);

        // req_material_product
        $this->req_material_product->setDbValueDef($rsnew, $this->req_material_product->CurrentValue, false);

        // req_material_packing
        $this->req_material_packing->setDbValueDef($rsnew, $this->req_material_packing->CurrentValue, false);

        // req_material_rid
        $this->req_material_rid->setDbValueDef($rsnew, $this->req_material_rid->CurrentValue, false);

        // req_material_qty
        $this->req_material_qty->setDbValueDef($rsnew, $this->req_material_qty->CurrentValue, strval($this->req_material_qty->CurrentValue) == "");

        // issued_pkt
        $this->issued_pkt->setDbValueDef($rsnew, $this->issued_pkt->CurrentValue, strval($this->issued_pkt->CurrentValue) == "");

        // lot_no
        $this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, false);

        // stock
        $this->stock->setDbValueDef($rsnew, $this->stock->CurrentValue, strval($this->stock->CurrentValue) == "");

        // short
        $this->short->setDbValueDef($rsnew, $this->short->CurrentValue, false);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, false);

        // material_qty
        $this->material_qty->setDbValueDef($rsnew, $this->material_qty->CurrentValue, false);

        // method
        $this->method->setDbValueDef($rsnew, $this->method->CurrentValue, false);

        // despatch_week
        $this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, false);

        // despatch_date
        $this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()), false);

        // production_plan
        $this->production_plan->setDbValueDef($rsnew, $this->production_plan->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // updated
        $this->updated->setDbValueDef($rsnew, $this->updated->CurrentValue, strval($this->updated->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['poid'])) { // poid
            $this->poid->setFormValue($row['poid']);
        }
        if (isset($row['location'])) { // location
            $this->location->setFormValue($row['location']);
        }
        if (isset($row['week'])) { // week
            $this->week->setFormValue($row['week']);
        }
        if (isset($row['buyer_id'])) { // buyer_id
            $this->buyer_id->setFormValue($row['buyer_id']);
        }
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['product_id'])) { // product_id
            $this->product_id->setFormValue($row['product_id']);
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->setFormValue($row['batch_no']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['size_cm'])) { // size_cm
            $this->size_cm->setFormValue($row['size_cm']);
        }
        if (isset($row['sqm'])) { // sqm
            $this->sqm->setFormValue($row['sqm']);
        }
        if (isset($row['t_sqm'])) { // t_sqm
            $this->t_sqm->setFormValue($row['t_sqm']);
        }
        if (isset($row['req_material_grp'])) { // req_material_grp
            $this->req_material_grp->setFormValue($row['req_material_grp']);
        }
        if (isset($row['req_material_sgrp'])) { // req_material_sgrp
            $this->req_material_sgrp->setFormValue($row['req_material_sgrp']);
        }
        if (isset($row['req_material_product'])) { // req_material_product
            $this->req_material_product->setFormValue($row['req_material_product']);
        }
        if (isset($row['req_material_packing'])) { // req_material_packing
            $this->req_material_packing->setFormValue($row['req_material_packing']);
        }
        if (isset($row['req_material_rid'])) { // req_material_rid
            $this->req_material_rid->setFormValue($row['req_material_rid']);
        }
        if (isset($row['req_material_qty'])) { // req_material_qty
            $this->req_material_qty->setFormValue($row['req_material_qty']);
        }
        if (isset($row['issued_pkt'])) { // issued_pkt
            $this->issued_pkt->setFormValue($row['issued_pkt']);
        }
        if (isset($row['lot_no'])) { // lot_no
            $this->lot_no->setFormValue($row['lot_no']);
        }
        if (isset($row['stock'])) { // stock
            $this->stock->setFormValue($row['stock']);
        }
        if (isset($row['short'])) { // short
            $this->short->setFormValue($row['short']);
        }
        if (isset($row['unit'])) { // unit
            $this->unit->setFormValue($row['unit']);
        }
        if (isset($row['material_qty'])) { // material_qty
            $this->material_qty->setFormValue($row['material_qty']);
        }
        if (isset($row['method'])) { // method
            $this->method->setFormValue($row['method']);
        }
        if (isset($row['despatch_week'])) { // despatch_week
            $this->despatch_week->setFormValue($row['despatch_week']);
        }
        if (isset($row['despatch_date'])) { // despatch_date
            $this->despatch_date->setFormValue($row['despatch_date']);
        }
        if (isset($row['production_plan'])) { // production_plan
            $this->production_plan->setFormValue($row['production_plan']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['updated'])) { // updated
            $this->updated->setFormValue($row['updated']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("materialrequiredprocessingoutsidelist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_product_id":
                    break;
                case "x_batch_no":
                    break;
                case "x_req_material_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_req_material_sgrp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_req_material_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_req_material_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_req_material_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    break;
                case "x_production_plan":
                    break;
                case "x_operator":
                    break;
                case "x_issue_to":
                    break;
                case "x_company_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
