<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialRequiredPreview extends MaterialRequired
{
    use MessagesTrait;

    // Page ID
    public $PageID = "preview";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialRequiredPreview";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "materialrequiredpreview";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->company_id->setVisibility();
        $this->buyer_id->setVisibility();
        $this->poid->setVisibility();
        $this->po->setVisibility();
        $this->week->setVisibility();
        $this->product_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->quantity->setVisibility();
        $this->Size_wl->setVisibility();
        $this->sqm->setVisibility();
        $this->t_sqm->setVisibility();
        $this->unit->setVisibility();
        $this->material_qty->setVisibility();
        $this->method->setVisibility();
        $this->despatch_week->setVisibility();
        $this->production_plan->Visible = false;
        $this->remarks->Visible = false;
        $this->updated->Visible = false;
        $this->req_material_grp->Visible = false;
        $this->req_material_sgrp->Visible = false;
        $this->req_material_product->Visible = false;
        $this->req_material_rid->setVisibility();
        $this->req_material_packing->setVisibility();
        $this->req_material_qty->setVisibility();
        $this->issue_material_lcgp_rid->setVisibility();
        $this->issue_material_qty->Visible = false;
        $this->issue_material_packing->Visible = false;
        $this->issue_material_lot_no->setVisibility();
        $this->issue_material_godown->setVisibility();
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->material_out->Visible = false;
        $this->material_out_id->Visible = false;
        $this->despatch_date->setVisibility();
        $this->order_id->setVisibility();
        $this->weaving_works->setVisibility();
        $this->issue_material_grp->Visible = false;
        $this->issue_material_sgrp->Visible = false;
        $this->issue_material_product->Visible = false;
        $this->issue_material_rid->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'material_required';
        $this->TableName = 'material_required';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table ew-preview-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_required)
        if (!isset($GLOBALS["material_required"]) || $GLOBALS["material_required"]::class == PROJECT_NAMESPACE . "material_required") {
            $GLOBALS["material_required"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $Recordset;
    public $CurrentRow; // Current row // PHP
    public $TotalRecords = 0;
    public $RecordCount = 0;
    public $ListOptions; // List options
    public $OtherOptions; // Other options
    public $StartRecord = 1;
    public $DisplayRecords = 0;
    public $UseModalLinks = false;
    public $IsModal = true;
    public $DetailCounts = [];

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Set up list options
        $this->setupListOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->week);
        $this->setupLookupOptions($this->product_id);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->method);
        $this->setupLookupOptions($this->despatch_week);
        $this->setupLookupOptions($this->production_plan);
        $this->setupLookupOptions($this->req_material_grp);
        $this->setupLookupOptions($this->req_material_sgrp);
        $this->setupLookupOptions($this->req_material_product);
        $this->setupLookupOptions($this->req_material_rid);
        $this->setupLookupOptions($this->req_material_packing);
        $this->setupLookupOptions($this->issue_material_lcgp_rid);
        $this->setupLookupOptions($this->issue_material_packing);
        $this->setupLookupOptions($this->issue_material_godown);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->material_out);
        $this->setupLookupOptions($this->issue_material_grp);
        $this->setupLookupOptions($this->issue_material_sgrp);
        $this->setupLookupOptions($this->issue_material_product);
        $this->setupLookupOptions($this->issue_material_rid);
        $this->setupLookupOptions($this->operator);

        // Load filter
        $masterKeys = explode("|", Decrypt(Get("f", "")));
        $filter = array_shift($masterKeys);
        if ($filter == "") {
            $filter = "0=1";
        }
        $detailFilters = JsonDecode(Decrypt(Get("detailfilters", ""))) ?: [];
        foreach ($detailFilters as $detailTblVar => $detailFilter) {
            $this->DetailCounts[$detailTblVar] = Container($detailTblVar)?->loadRecordCount($detailFilter);
        }

        // Set up Sort Order
        $this->setupSortOrder();

        // Set up foreign keys
        $this->setupForeignKeys($masterKeys);

        // Call Recordset Selecting event
        $this->recordsetSelecting($filter);

        // Load result set
        $filter = $this->applyUserIDFilters($filter);
        $this->TotalRecords = $this->loadRecordCount($filter);
        if ($this->DisplayRecords <= 0) { // Show all records if page size not specified
            $this->DisplayRecords = $this->TotalRecords > 0 ? $this->TotalRecords : 10;
        }
        $sql = $this->previewSql($filter);
        if ($this->DisplayRecords > 0) {
            $sql->setFirstResult(max($this->StartRecord - 1, 0))->setMaxResults($this->DisplayRecords);
        }
        $this->Recordset = $sql->executeQuery();

        // Call Recordset Selected event
        $this->recordsetSelected($this->Recordset);
        $this->renderOtherOptions();

        // Set up pager (always use PrevNextPager for preview page)
        $url = CurrentPageName() . "?t=" . Get("t") . "&f=" . Get("f"); // Add table/filter parameters only
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", 10, $this->AutoHidePager, null, null, true, $url);

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Set up sort order
     *
     * @return void
     */
    protected function setupSortOrder()
    {
        $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
        if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
            $this->setSessionOrderBy($defaultSort);
        }
        $defaultSortList = ($this->id->VirtualExpression != "" ? $this->id->VirtualExpression : $this->id->Expression) . " DESC"; // Set up default sort
        if ($this->getSessionOrderByList() == "" && $defaultSortList != "") {
            $this->setSessionOrderByList($defaultSortList);
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;
        if (SameText(Get("cmd"), "resetsort")) {
            $this->StartRecord = 1;
            $this->CurrentOrder = "";
            $this->CurrentOrderType = "";
            $this->id->setSort("");
            $this->company_id->setSort("");
            $this->buyer_id->setSort("");
            $this->poid->setSort("");
            $this->po->setSort("");
            $this->week->setSort("");
            $this->product_id->setSort("");
            $this->batch_no->setSort("");
            $this->quantity->setSort("");
            $this->Size_wl->setSort("");
            $this->sqm->setSort("");
            $this->t_sqm->setSort("");
            $this->unit->setSort("");
            $this->material_qty->setSort("");
            $this->method->setSort("");
            $this->despatch_week->setSort("");
            $this->production_plan->setSort("");
            $this->remarks->setSort("");
            $this->updated->setSort("");
            $this->req_material_grp->setSort("");
            $this->req_material_sgrp->setSort("");
            $this->req_material_product->setSort("");
            $this->req_material_rid->setSort("");
            $this->req_material_packing->setSort("");
            $this->req_material_qty->setSort("");
            $this->issue_material_lcgp_rid->setSort("");
            $this->issue_material_qty->setSort("");
            $this->issue_material_packing->setSort("");
            $this->issue_material_lot_no->setSort("");
            $this->issue_material_godown->setSort("");
            $this->grp->setSort("");
            $this->s_grp->setSort("");
            $this->product->setSort("");
            $this->material_out->setSort("");
            $this->material_out_id->setSort("");
            $this->despatch_date->setSort("");
            $this->order_id->setSort("");
            $this->weaving_works->setSort("");
            $this->issue_material_grp->setSort("");
            $this->issue_material_sgrp->setSort("");
            $this->issue_material_product->setSort("");
            $this->issue_material_rid->setSort("");
            $this->operator->setSort("");
            $this->datetime->setSort("");

            // Save sort to session
            $this->setSessionOrderBy("");
            $this->setSessionOrderByList("");
        } else {
            $this->StartRecord = 1;
            $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
            $startRec = Get(Config("TABLE_START_REC"));
            if (is_numeric($pageNo)) { // Check for page parameter
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
            } elseif (is_numeric($startRec)) { // Check for "start" parameter
                $this->StartRecord = $startRec;
            }
            $this->CurrentOrder = Get("sort", "");
            $this->CurrentOrderType = Get("sortorder", "");
        }

        // Check for sort field
        if ($this->CurrentOrder !== "") {
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->company_id, $ctrl); // company_id
            $this->updateSort($this->buyer_id, $ctrl); // buyer_id
            $this->updateSort($this->poid, $ctrl); // poid
            $this->updateSort($this->po, $ctrl); // po
            $this->updateSort($this->week, $ctrl); // week
            $this->updateSort($this->product_id, $ctrl); // product_id
            $this->updateSort($this->batch_no, $ctrl); // batch_no
            $this->updateSort($this->quantity, $ctrl); // quantity
            $this->updateSort($this->Size_wl, $ctrl); // Size_wl
            $this->updateSort($this->sqm, $ctrl); // sqm
            $this->updateSort($this->t_sqm, $ctrl); // t_sqm
            $this->updateSort($this->unit, $ctrl); // unit
            $this->updateSort($this->material_qty, $ctrl); // material_qty
            $this->updateSort($this->method, $ctrl); // method
            $this->updateSort($this->despatch_week, $ctrl); // despatch_week
            $this->updateSort($this->req_material_rid, $ctrl); // req_material_rid
            $this->updateSort($this->req_material_packing, $ctrl); // req_material_packing
            $this->updateSort($this->req_material_qty, $ctrl); // req_material_qty
            $this->updateSort($this->issue_material_lcgp_rid, $ctrl); // issue_material_lcgp_rid
            $this->updateSort($this->issue_material_lot_no, $ctrl); // issue_material_lot_no
            $this->updateSort($this->issue_material_godown, $ctrl); // issue_material_godown
            $this->updateSort($this->despatch_date, $ctrl); // despatch_date
            $this->updateSort($this->order_id, $ctrl); // order_id
            $this->updateSort($this->weaving_works, $ctrl); // weaving_works
            $this->updateSort($this->operator, $ctrl); // operator
        }

        // Update field sort
        $this->updateFieldSort();
    }

    /**
     * Get preview SQL
     *
     * @param string $filter
     * @return QueryBuilder
     */
    protected function previewSql($filter)
    {
        $useVirtual = false;
        $sort = $this->getSessionOrderByList();
        if (ContainsString(" " . $sort . " ", " " . $this->req_material_rid->VirtualExpression . " ")) {
            $useVirtual = true;
        }
        if ($useVirtual) {
            return $this->buildSelectSql(
                "*",
                $this->getSqlSelectList(),
                $this->getSqlWhere(),
                $this->getSqlGroupBy(),
                $this->getSqlHaving(),
                $this->getSqlOrderBy(),
                $filter,
                $sort
            );
        } else {
            return $this->buildSelectSql(
                $this->getSqlSelect(),
                $this->getSqlFrom(),
                $this->getSqlWhere(),
                $this->getSqlGroupBy(),
                $this->getSqlHaving(),
                $this->getSqlOrderBy(),
                $filter,
                $sort
            );
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $masterKeyUrl = $this->masterKeyUrl();

        // "edit"
        $opt = $this->ListOptions["edit"];
        if ($Security->canEdit()) {
            $editCaption = $Language->phrase("EditLink");
            $editTitle = HtmlTitle($editCaption);
            $editUrl = GetUrl($this->getEditUrl($masterKeyUrl));
            if ($this->UseModalLinks && !IsMobile()) {
                $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editTitle . "\" data-caption=\"" . $editTitle . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode($editUrl) . "\" data-btn=\"SaveBtn\">" . $editCaption . "</a>";
            } else {
                $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editTitle . "\" data-caption=\"" . $editTitle . "\" href=\"" . HtmlEncode($editUrl) . "\">" . $editCaption . "</a>";
            }
        } else {
            $opt->Body = "";
        }

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
    }

    // Render other options
    protected function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
    }

    // Get master foreign key URL
    protected function masterKeyUrl()
    {
        $masterTblVar = Get("t", "");
        $url = "";
        if ($masterTblVar == "required_material_compiled") {
            $url = "" . Config("TABLE_SHOW_MASTER") . "=required_material_compiled&" . GetForeignKeyUrl("fk_po", $this->po->QueryStringValue) . "&" . GetForeignKeyUrl("fk_req_material_rid", $this->req_material_rid->QueryStringValue) . "";
        }
        return $url;
    }

    // Set up foreign keys
    protected function setupForeignKeys($keys)
    {
        $masterTblVar = Get("t", "");
        if ($masterTblVar == "required_material_compiled") {
            $this->po->setQueryStringValue($keys[0] ?? "");
            $this->req_material_rid->setQueryStringValue($keys[1] ?? "");
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("materialrequiredlist"), "", $this->TableVar, true);
        $pageId = "preview";
        $Breadcrumb->add("preview", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer_id":
                    break;
                case "x_week":
                    break;
                case "x_product_id":
                    break;
                case "x_batch_no":
                    break;
                case "x_unit":
                    break;
                case "x_method":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_despatch_week":
                    break;
                case "x_production_plan":
                    break;
                case "x_req_material_grp":
                    break;
                case "x_req_material_sgrp":
                    break;
                case "x_req_material_product":
                    break;
                case "x_req_material_rid":
                    break;
                case "x_req_material_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_lcgp_rid":
                    break;
                case "x_issue_material_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_godown":
                    break;
                case "x_grp":
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_material_out":
                    break;
                case "x_issue_material_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_sgrp":
                    break;
                case "x_issue_material_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_issue_material_rid":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }
}
