<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialRequiredMonthlyCrossCompanySearch extends MaterialRequiredMonthlyCrossCompany
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialRequiredMonthlyCrossCompanySearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "materialrequiredmonthlycrosscompanysearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->month->setVisibility();
        $this->buyer->setVisibility();
        $this->processed_by->setVisibility();
        $this->design_id->setVisibility();
        $this->size_cm->setVisibility();
        $this->sqm->setVisibility();
        $this->req_material_rid->setVisibility();
        $this->req_material_packing->setVisibility();
        $this->req_material_qty->setVisibility();
        $this->_barcode->setVisibility();
        $this->no->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'material_required_monthly_cross_company';
        $this->TableName = 'material_required_monthly_cross_company';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_required_monthly_cross_company)
        if (!isset($GLOBALS["material_required_monthly_cross_company"]) || $GLOBALS["material_required_monthly_cross_company"]::class == PROJECT_NAMESPACE . "material_required_monthly_cross_company") {
            $GLOBALS["material_required_monthly_cross_company"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required_monthly_cross_company');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "materialrequiredmonthlycrosscompanyview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->month->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->sqm->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->req_material_qty->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->_barcode->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->no->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->month);
        $this->setupLookupOptions($this->buyer);
        $this->setupLookupOptions($this->processed_by);
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->req_material_rid);
        $this->setupLookupOptions($this->req_material_packing);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "materialrequiredmonthlycrosscompanylist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->month); // month
        $this->buildSearchUrl($srchUrl, $this->buyer); // buyer
        $this->buildSearchUrl($srchUrl, $this->processed_by); // processed_by
        $this->buildSearchUrl($srchUrl, $this->design_id); // design_id
        $this->buildSearchUrl($srchUrl, $this->size_cm); // size_cm
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->req_material_rid); // req_material_rid
        $this->buildSearchUrl($srchUrl, $this->req_material_packing); // req_material_packing
        $this->buildSearchUrl($srchUrl, $this->req_material_qty); // req_material_qty
        $this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
        $this->buildSearchUrl($srchUrl, $this->no); // no
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // month
        if ($this->month->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer
        if ($this->buyer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // processed_by
        if ($this->processed_by->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design_id
        if ($this->design_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_cm
        if ($this->size_cm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_material_rid
        if ($this->req_material_rid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_material_packing
        if ($this->req_material_packing->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_material_qty
        if ($this->req_material_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // no
        if ($this->no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // month
        $this->month->RowCssClass = "row";

        // buyer
        $this->buyer->RowCssClass = "row";

        // processed_by
        $this->processed_by->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // size_cm
        $this->size_cm->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // req_material_rid
        $this->req_material_rid->RowCssClass = "row";

        // req_material_packing
        $this->req_material_packing->RowCssClass = "row";

        // req_material_qty
        $this->req_material_qty->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // no
        $this->no->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // month
            $curVal = strval($this->month->CurrentValue);
            if ($curVal != "") {
                $this->month->ViewValue = $this->month->lookupCacheOption($curVal);
                if ($this->month->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->month->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->month->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->month->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->month->Lookup->renderViewRow($rswrk[0]);
                        $this->month->ViewValue = $this->month->displayValue($arwrk);
                    } else {
                        $this->month->ViewValue = $this->month->CurrentValue;
                    }
                }
            } else {
                $this->month->ViewValue = null;
            }

            // buyer
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->ViewValue = FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern());
                    }
                }
            } else {
                $this->buyer->ViewValue = null;
            }

            // processed_by
            $this->processed_by->ViewValue = $this->processed_by->CurrentValue;
            $curVal = strval($this->processed_by->CurrentValue);
            if ($curVal != "") {
                $this->processed_by->ViewValue = $this->processed_by->lookupCacheOption($curVal);
                if ($this->processed_by->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->processed_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->processed_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->processed_by->getSelectFilter($this); // PHP
                    $sqlWrk = $this->processed_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->processed_by->Lookup->renderViewRow($rswrk[0]);
                        $this->processed_by->ViewValue = $this->processed_by->displayValue($arwrk);
                    } else {
                        $this->processed_by->ViewValue = FormatNumber($this->processed_by->CurrentValue, $this->processed_by->formatPattern());
                    }
                }
            } else {
                $this->processed_by->ViewValue = null;
            }

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // req_material_rid
            if ($this->req_material_rid->VirtualValue != "") {
                $this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
            } else {
                $curVal = strval($this->req_material_rid->CurrentValue);
                if ($curVal != "") {
                    $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
                    if ($this->req_material_rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
                        } else {
                            $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->req_material_rid->ViewValue = null;
                }
            }

            // req_material_packing
            $curVal = strval($this->req_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
                if ($this->req_material_packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
                    } else {
                        $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                    }
                }
            } else {
                $this->req_material_packing->ViewValue = null;
            }

            // req_material_qty
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // no
            $this->no->ViewValue = $this->no->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // month
            $this->month->HrefValue = "";
            $this->month->TooltipValue = "";

            // buyer
            $this->buyer->HrefValue = "";
            $this->buyer->TooltipValue = "";

            // processed_by
            $this->processed_by->HrefValue = "";
            $this->processed_by->TooltipValue = "";

            // design_id
            $this->design_id->HrefValue = "";
            $this->design_id->TooltipValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";
            $this->size_cm->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // req_material_rid
            $this->req_material_rid->HrefValue = "";
            $this->req_material_rid->TooltipValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";
            $this->req_material_packing->TooltipValue = "";

            // req_material_qty
            $this->req_material_qty->HrefValue = "";
            $this->req_material_qty->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // no
            $this->no->HrefValue = "";
            $this->no->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // month
            $this->month->setupEditAttributes();
            $curVal = trim(strval($this->month->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->month->AdvancedSearch->ViewValue = $this->month->lookupCacheOption($curVal);
            } else {
                $this->month->AdvancedSearch->ViewValue = $this->month->Lookup !== null && is_array($this->month->lookupOptions()) && count($this->month->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->month->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->month->EditValue = array_values($this->month->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->month->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->month->AdvancedSearch->SearchValue, $this->month->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->month->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->month->EditValue = $arwrk;
            }
            $this->month->PlaceHolder = RemoveHtml($this->month->caption());

            // buyer
            $this->buyer->setupEditAttributes();
            $curVal = trim(strval($this->buyer->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyer->AdvancedSearch->ViewValue = $this->buyer->lookupCacheOption($curVal);
            } else {
                $this->buyer->AdvancedSearch->ViewValue = $this->buyer->Lookup !== null && is_array($this->buyer->lookupOptions()) && count($this->buyer->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyer->EditValue = array_values($this->buyer->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyer->AdvancedSearch->SearchValue, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyer->EditValue = $arwrk;
            }
            $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

            // processed_by
            $this->processed_by->setupEditAttributes();
            $this->processed_by->EditValue = $this->processed_by->AdvancedSearch->SearchValue;
            $curVal = strval($this->processed_by->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->processed_by->EditValue = $this->processed_by->lookupCacheOption($curVal);
                if ($this->processed_by->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->processed_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->processed_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->processed_by->getSelectFilter($this); // PHP
                    $sqlWrk = $this->processed_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->processed_by->Lookup->renderViewRow($rswrk[0]);
                        $this->processed_by->EditValue = $this->processed_by->displayValue($arwrk);
                    } else {
                        $this->processed_by->EditValue = HtmlEncode(FormatNumber($this->processed_by->AdvancedSearch->SearchValue, $this->processed_by->formatPattern()));
                    }
                }
            } else {
                $this->processed_by->EditValue = null;
            }
            $this->processed_by->PlaceHolder = RemoveHtml($this->processed_by->caption());

            // design_id
            $this->design_id->setupEditAttributes();
            $curVal = trim(strval($this->design_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->lookupCacheOption($curVal);
            } else {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->Lookup !== null && is_array($this->design_id->lookupOptions()) && count($this->design_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->design_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->design_id->EditValue = array_values($this->design_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->design_id->AdvancedSearch->SearchValue, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->design_id->EditValue = $arwrk;
            }
            $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

            // size_cm
            $this->size_cm->setupEditAttributes();
            if (!$this->size_cm->Raw) {
                $this->size_cm->AdvancedSearch->SearchValue = HtmlDecode($this->size_cm->AdvancedSearch->SearchValue);
            }
            $this->size_cm->EditValue = HtmlEncode($this->size_cm->AdvancedSearch->SearchValue);
            $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // req_material_rid
            $this->req_material_rid->setupEditAttributes();
            $this->req_material_rid->EditValue = $this->req_material_rid->AdvancedSearch->SearchValue;
            $this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

            // req_material_packing
            $this->req_material_packing->setupEditAttributes();
            $curVal = trim(strval($this->req_material_packing->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
            } else {
                $this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->Lookup !== null && is_array($this->req_material_packing->lookupOptions()) && count($this->req_material_packing->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->req_material_packing->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->req_material_packing->EditValue = array_values($this->req_material_packing->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->req_material_packing->AdvancedSearch->SearchValue, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_packing->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->req_material_packing->EditValue = $arwrk;
            }
            $this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());

            // req_material_qty
            $this->req_material_qty->setupEditAttributes();
            $this->req_material_qty->EditValue = $this->req_material_qty->AdvancedSearch->SearchValue;
            $this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // no
            $this->no->setupEditAttributes();
            if (!$this->no->Raw) {
                $this->no->AdvancedSearch->SearchValue = HtmlDecode($this->no->AdvancedSearch->SearchValue);
            }
            $this->no->EditValue = HtmlEncode($this->no->AdvancedSearch->SearchValue);
            $this->no->PlaceHolder = RemoveHtml($this->no->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->processed_by->AdvancedSearch->SearchValue)) {
            $this->processed_by->addErrorMessage($this->processed_by->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->req_material_qty->AdvancedSearch->SearchValue)) {
            $this->req_material_qty->addErrorMessage($this->req_material_qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->no->AdvancedSearch->SearchValue)) {
            $this->no->addErrorMessage($this->no->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->month->AdvancedSearch->load();
        $this->buyer->AdvancedSearch->load();
        $this->processed_by->AdvancedSearch->load();
        $this->design_id->AdvancedSearch->load();
        $this->size_cm->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->req_material_rid->AdvancedSearch->load();
        $this->req_material_packing->AdvancedSearch->load();
        $this->req_material_qty->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->no->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("materialrequiredmonthlycrosscompanylist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_month":
                    break;
                case "x_buyer":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_processed_by":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_req_material_rid":
                    break;
                case "x_req_material_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
