<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MaterialRequiredJobCardEdit extends MaterialRequiredJobCard
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MaterialRequiredJobCardEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "materialrequiredjobcardedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->poid->setVisibility();
        $this->jc_no->setVisibility();
        $this->location->setVisibility();
        $this->issue_to->setVisibility();
        $this->week->setVisibility();
        $this->po->setVisibility();
        $this->buyer_id->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->product_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->quantity->setVisibility();
        $this->size_cm->setVisibility();
        $this->sqm->setVisibility();
        $this->t_sqm->setVisibility();
        $this->req_material_grp->setVisibility();
        $this->req_material_sgrp->setVisibility();
        $this->req_material_product->setVisibility();
        $this->req_material_rid->setVisibility();
        $this->req_material_qty->setVisibility();
        $this->req_material_packing->setVisibility();
        $this->stock->setVisibility();
        $this->short->setVisibility();
        $this->unit->setVisibility();
        $this->material_qty->setVisibility();
        $this->method->setVisibility();
        $this->despatch_week->setVisibility();
        $this->despatch_date->setVisibility();
        $this->production_plan->setVisibility();
        $this->remarks->setVisibility();
        $this->updated->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->jc_datetime->setVisibility();
        $this->company_id->setVisibility();
        $this->m_out_id->setVisibility();
        $this->issued_qty->setVisibility();
        $this->pending_qty->setVisibility();
        $this->m_out_remarks->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'material_required_job_card';
        $this->TableName = 'material_required_job_card';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (material_required_job_card)
        if (!isset($GLOBALS["material_required_job_card"]) || $GLOBALS["material_required_job_card"]::class == PROJECT_NAMESPACE . "material_required_job_card") {
            $GLOBALS["material_required_job_card"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'material_required_job_card');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "materialrequiredjobcardview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("materialrequiredjobcardlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "materialrequiredjobcardlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "materialrequiredjobcardlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "materialrequiredjobcardlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'poid' first before field var 'x_poid'
        $val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
        if (!$this->poid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->poid->Visible = false; // Disable update for API request
            } else {
                $this->poid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'jc_no' first before field var 'x_jc_no'
        $val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
        if (!$this->jc_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_no->Visible = false; // Disable update for API request
            } else {
                $this->jc_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'issue_to' first before field var 'x_issue_to'
        $val = $CurrentForm->hasValue("issue_to") ? $CurrentForm->getValue("issue_to") : $CurrentForm->getValue("x_issue_to");
        if (!$this->issue_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issue_to->Visible = false; // Disable update for API request
            } else {
                $this->issue_to->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'week' first before field var 'x_week'
        $val = $CurrentForm->hasValue("week") ? $CurrentForm->getValue("week") : $CurrentForm->getValue("x_week");
        if (!$this->week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->week->Visible = false; // Disable update for API request
            } else {
                $this->week->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'buyer_id' first before field var 'x_buyer_id'
        $val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
        if (!$this->buyer_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val, true, $validate);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product_id' first before field var 'x_product_id'
        $val = $CurrentForm->hasValue("product_id") ? $CurrentForm->getValue("product_id") : $CurrentForm->getValue("x_product_id");
        if (!$this->product_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_id->Visible = false; // Disable update for API request
            } else {
                $this->product_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->batch_no->Visible = false; // Disable update for API request
            } else {
                $this->batch_no->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'size_cm' first before field var 'x_size_cm'
        $val = $CurrentForm->hasValue("size_cm") ? $CurrentForm->getValue("size_cm") : $CurrentForm->getValue("x_size_cm");
        if (!$this->size_cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_cm->Visible = false; // Disable update for API request
            } else {
                $this->size_cm->setFormValue($val);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 't_sqm' first before field var 'x_t_sqm'
        $val = $CurrentForm->hasValue("t_sqm") ? $CurrentForm->getValue("t_sqm") : $CurrentForm->getValue("x_t_sqm");
        if (!$this->t_sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_sqm->Visible = false; // Disable update for API request
            } else {
                $this->t_sqm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'req_material_grp' first before field var 'x_req_material_grp'
        $val = $CurrentForm->hasValue("req_material_grp") ? $CurrentForm->getValue("req_material_grp") : $CurrentForm->getValue("x_req_material_grp");
        if (!$this->req_material_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_grp->Visible = false; // Disable update for API request
            } else {
                $this->req_material_grp->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'req_material_sgrp' first before field var 'x_req_material_sgrp'
        $val = $CurrentForm->hasValue("req_material_sgrp") ? $CurrentForm->getValue("req_material_sgrp") : $CurrentForm->getValue("x_req_material_sgrp");
        if (!$this->req_material_sgrp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_sgrp->Visible = false; // Disable update for API request
            } else {
                $this->req_material_sgrp->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'req_material_product' first before field var 'x_req_material_product'
        $val = $CurrentForm->hasValue("req_material_product") ? $CurrentForm->getValue("req_material_product") : $CurrentForm->getValue("x_req_material_product");
        if (!$this->req_material_product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_product->Visible = false; // Disable update for API request
            } else {
                $this->req_material_product->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'req_material_rid' first before field var 'x_req_material_rid'
        $val = $CurrentForm->hasValue("req_material_rid") ? $CurrentForm->getValue("req_material_rid") : $CurrentForm->getValue("x_req_material_rid");
        if (!$this->req_material_rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_rid->Visible = false; // Disable update for API request
            } else {
                $this->req_material_rid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'req_material_qty' first before field var 'x_req_material_qty'
        $val = $CurrentForm->hasValue("req_material_qty") ? $CurrentForm->getValue("req_material_qty") : $CurrentForm->getValue("x_req_material_qty");
        if (!$this->req_material_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_qty->Visible = false; // Disable update for API request
            } else {
                $this->req_material_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'req_material_packing' first before field var 'x_req_material_packing'
        $val = $CurrentForm->hasValue("req_material_packing") ? $CurrentForm->getValue("req_material_packing") : $CurrentForm->getValue("x_req_material_packing");
        if (!$this->req_material_packing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->req_material_packing->Visible = false; // Disable update for API request
            } else {
                $this->req_material_packing->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'stock' first before field var 'x_stock'
        $val = $CurrentForm->hasValue("stock") ? $CurrentForm->getValue("stock") : $CurrentForm->getValue("x_stock");
        if (!$this->stock->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->stock->Visible = false; // Disable update for API request
            } else {
                $this->stock->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'short' first before field var 'x_short'
        $val = $CurrentForm->hasValue("short") ? $CurrentForm->getValue("short") : $CurrentForm->getValue("x_short");
        if (!$this->short->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->short->Visible = false; // Disable update for API request
            } else {
                $this->short->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unit' first before field var 'x_unit'
        $val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
        if (!$this->unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit->Visible = false; // Disable update for API request
            } else {
                $this->unit->setFormValue($val);
            }
        }

        // Check field name 'material_qty' first before field var 'x_material_qty'
        $val = $CurrentForm->hasValue("material_qty") ? $CurrentForm->getValue("material_qty") : $CurrentForm->getValue("x_material_qty");
        if (!$this->material_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->material_qty->Visible = false; // Disable update for API request
            } else {
                $this->material_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'method' first before field var 'x_method'
        $val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
        if (!$this->method->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->method->Visible = false; // Disable update for API request
            } else {
                $this->method->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'despatch_week' first before field var 'x_despatch_week'
        $val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
        if (!$this->despatch_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_week->Visible = false; // Disable update for API request
            } else {
                $this->despatch_week->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'despatch_date' first before field var 'x_despatch_date'
        $val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
        if (!$this->despatch_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->despatch_date->Visible = false; // Disable update for API request
            } else {
                $this->despatch_date->setFormValue($val, true, $validate);
            }
            $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        }

        // Check field name 'production_plan' first before field var 'x_production_plan'
        $val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
        if (!$this->production_plan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->production_plan->Visible = false; // Disable update for API request
            } else {
                $this->production_plan->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'updated' first before field var 'x_updated'
        $val = $CurrentForm->hasValue("updated") ? $CurrentForm->getValue("updated") : $CurrentForm->getValue("x_updated");
        if (!$this->updated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->updated->Visible = false; // Disable update for API request
            } else {
                $this->updated->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val, true, $validate);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'jc_datetime' first before field var 'x_jc_datetime'
        $val = $CurrentForm->hasValue("jc_datetime") ? $CurrentForm->getValue("jc_datetime") : $CurrentForm->getValue("x_jc_datetime");
        if (!$this->jc_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jc_datetime->Visible = false; // Disable update for API request
            } else {
                $this->jc_datetime->setFormValue($val, true, $validate);
            }
            $this->jc_datetime->CurrentValue = UnFormatDateTime($this->jc_datetime->CurrentValue, $this->jc_datetime->formatPattern());
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'm_out_id' first before field var 'x_m_out_id'
        $val = $CurrentForm->hasValue("m_out_id") ? $CurrentForm->getValue("m_out_id") : $CurrentForm->getValue("x_m_out_id");
        if (!$this->m_out_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_out_id->Visible = false; // Disable update for API request
            } else {
                $this->m_out_id->setFormValue($val);
            }
        }

        // Check field name 'issued_qty' first before field var 'x_issued_qty'
        $val = $CurrentForm->hasValue("issued_qty") ? $CurrentForm->getValue("issued_qty") : $CurrentForm->getValue("x_issued_qty");
        if (!$this->issued_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->issued_qty->Visible = false; // Disable update for API request
            } else {
                $this->issued_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pending_qty' first before field var 'x_pending_qty'
        $val = $CurrentForm->hasValue("pending_qty") ? $CurrentForm->getValue("pending_qty") : $CurrentForm->getValue("x_pending_qty");
        if (!$this->pending_qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pending_qty->Visible = false; // Disable update for API request
            } else {
                $this->pending_qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'm_out_remarks' first before field var 'x_m_out_remarks'
        $val = $CurrentForm->hasValue("m_out_remarks") ? $CurrentForm->getValue("m_out_remarks") : $CurrentForm->getValue("x_m_out_remarks");
        if (!$this->m_out_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_out_remarks->Visible = false; // Disable update for API request
            } else {
                $this->m_out_remarks->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->poid->CurrentValue = $this->poid->FormValue;
        $this->jc_no->CurrentValue = $this->jc_no->FormValue;
        $this->location->CurrentValue = $this->location->FormValue;
        $this->issue_to->CurrentValue = $this->issue_to->FormValue;
        $this->week->CurrentValue = $this->week->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->product_id->CurrentValue = $this->product_id->FormValue;
        $this->batch_no->CurrentValue = $this->batch_no->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->size_cm->CurrentValue = $this->size_cm->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->t_sqm->CurrentValue = $this->t_sqm->FormValue;
        $this->req_material_grp->CurrentValue = $this->req_material_grp->FormValue;
        $this->req_material_sgrp->CurrentValue = $this->req_material_sgrp->FormValue;
        $this->req_material_product->CurrentValue = $this->req_material_product->FormValue;
        $this->req_material_rid->CurrentValue = $this->req_material_rid->FormValue;
        $this->req_material_qty->CurrentValue = $this->req_material_qty->FormValue;
        $this->req_material_packing->CurrentValue = $this->req_material_packing->FormValue;
        $this->stock->CurrentValue = $this->stock->FormValue;
        $this->short->CurrentValue = $this->short->FormValue;
        $this->unit->CurrentValue = $this->unit->FormValue;
        $this->material_qty->CurrentValue = $this->material_qty->FormValue;
        $this->method->CurrentValue = $this->method->FormValue;
        $this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
        $this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
        $this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->production_plan->CurrentValue = $this->production_plan->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->updated->CurrentValue = $this->updated->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->jc_datetime->CurrentValue = $this->jc_datetime->FormValue;
        $this->jc_datetime->CurrentValue = UnFormatDateTime($this->jc_datetime->CurrentValue, $this->jc_datetime->formatPattern());
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->m_out_id->CurrentValue = $this->m_out_id->FormValue;
        $this->issued_qty->CurrentValue = $this->issued_qty->FormValue;
        $this->pending_qty->CurrentValue = $this->pending_qty->FormValue;
        $this->m_out_remarks->CurrentValue = $this->m_out_remarks->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->poid->setDbValue($row['poid']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->location->setDbValue($row['location']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->week->setDbValue($row['week']);
        $this->po->setDbValue($row['po']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->quantity->setDbValue($row['quantity']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->t_sqm->setDbValue($row['t_sqm']);
        $this->req_material_grp->setDbValue($row['req_material_grp']);
        $this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
        $this->req_material_product->setDbValue($row['req_material_product']);
        $this->req_material_rid->setDbValue($row['req_material_rid']);
        $this->req_material_qty->setDbValue($row['req_material_qty']);
        $this->req_material_packing->setDbValue($row['req_material_packing']);
        $this->stock->setDbValue($row['stock']);
        $this->short->setDbValue($row['short']);
        $this->unit->setDbValue($row['unit']);
        $this->material_qty->setDbValue($row['material_qty']);
        $this->method->setDbValue($row['method']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->remarks->setDbValue($row['remarks']);
        $this->updated->setDbValue($row['updated']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->jc_datetime->setDbValue($row['jc_datetime']);
        $this->company_id->setDbValue($row['company_id']);
        $this->m_out_id->setDbValue($row['m_out_id']);
        $this->issued_qty->setDbValue($row['issued_qty']);
        $this->pending_qty->setDbValue($row['pending_qty']);
        $this->m_out_remarks->setDbValue($row['m_out_remarks']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['poid'] = $this->poid->DefaultValue;
        $row['jc_no'] = $this->jc_no->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['issue_to'] = $this->issue_to->DefaultValue;
        $row['week'] = $this->week->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_id'] = $this->product_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['size_cm'] = $this->size_cm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['t_sqm'] = $this->t_sqm->DefaultValue;
        $row['req_material_grp'] = $this->req_material_grp->DefaultValue;
        $row['req_material_sgrp'] = $this->req_material_sgrp->DefaultValue;
        $row['req_material_product'] = $this->req_material_product->DefaultValue;
        $row['req_material_rid'] = $this->req_material_rid->DefaultValue;
        $row['req_material_qty'] = $this->req_material_qty->DefaultValue;
        $row['req_material_packing'] = $this->req_material_packing->DefaultValue;
        $row['stock'] = $this->stock->DefaultValue;
        $row['short'] = $this->short->DefaultValue;
        $row['unit'] = $this->unit->DefaultValue;
        $row['material_qty'] = $this->material_qty->DefaultValue;
        $row['method'] = $this->method->DefaultValue;
        $row['despatch_week'] = $this->despatch_week->DefaultValue;
        $row['despatch_date'] = $this->despatch_date->DefaultValue;
        $row['production_plan'] = $this->production_plan->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['jc_datetime'] = $this->jc_datetime->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['m_out_id'] = $this->m_out_id->DefaultValue;
        $row['issued_qty'] = $this->issued_qty->DefaultValue;
        $row['pending_qty'] = $this->pending_qty->DefaultValue;
        $row['m_out_remarks'] = $this->m_out_remarks->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // poid
        $this->poid->RowCssClass = "row";

        // jc_no
        $this->jc_no->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // issue_to
        $this->issue_to->RowCssClass = "row";

        // week
        $this->week->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_id
        $this->product_id->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // size_cm
        $this->size_cm->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // t_sqm
        $this->t_sqm->RowCssClass = "row";

        // req_material_grp
        $this->req_material_grp->RowCssClass = "row";

        // req_material_sgrp
        $this->req_material_sgrp->RowCssClass = "row";

        // req_material_product
        $this->req_material_product->RowCssClass = "row";

        // req_material_rid
        $this->req_material_rid->RowCssClass = "row";

        // req_material_qty
        $this->req_material_qty->RowCssClass = "row";

        // req_material_packing
        $this->req_material_packing->RowCssClass = "row";

        // stock
        $this->stock->RowCssClass = "row";

        // short
        $this->short->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // material_qty
        $this->material_qty->RowCssClass = "row";

        // method
        $this->method->RowCssClass = "row";

        // despatch_week
        $this->despatch_week->RowCssClass = "row";

        // despatch_date
        $this->despatch_date->RowCssClass = "row";

        // production_plan
        $this->production_plan->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // jc_datetime
        $this->jc_datetime->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // m_out_id
        $this->m_out_id->RowCssClass = "row";

        // issued_qty
        $this->issued_qty->RowCssClass = "row";

        // pending_qty
        $this->pending_qty->RowCssClass = "row";

        // m_out_remarks
        $this->m_out_remarks->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // poid
            $this->poid->ViewValue = $this->poid->CurrentValue;
            $this->poid->ViewValue = FormatNumber($this->poid->ViewValue, $this->poid->formatPattern());

            // jc_no
            $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
            $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

            // location
            $this->location->ViewValue = $this->location->CurrentValue;
            $this->location->ViewValue = FormatNumber($this->location->ViewValue, $this->location->formatPattern());

            // issue_to
            $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
            $this->issue_to->ViewValue = FormatNumber($this->issue_to->ViewValue, $this->issue_to->formatPattern());

            // week
            $this->week->ViewValue = $this->week->CurrentValue;
            $this->week->ViewValue = FormatNumber($this->week->ViewValue, $this->week->formatPattern());

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

            // buyer_id
            $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
            $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->ViewValue, $this->buyer_id->formatPattern());

            // grp
            $this->grp->ViewValue = $this->grp->CurrentValue;
            $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

            // s_grp
            $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
            $this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, $this->s_grp->formatPattern());

            // product
            $this->product->ViewValue = $this->product->CurrentValue;
            $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

            // product_id
            $this->product_id->ViewValue = $this->product_id->CurrentValue;
            $this->product_id->ViewValue = FormatNumber($this->product_id->ViewValue, $this->product_id->formatPattern());

            // batch_no
            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
            $this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, $this->batch_no->formatPattern());

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // t_sqm
            $this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
            $this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, $this->t_sqm->formatPattern());

            // req_material_grp
            $this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
            $this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->ViewValue, $this->req_material_grp->formatPattern());

            // req_material_sgrp
            $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
            $this->req_material_sgrp->ViewValue = FormatNumber($this->req_material_sgrp->ViewValue, $this->req_material_sgrp->formatPattern());

            // req_material_product
            $this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
            $this->req_material_product->ViewValue = FormatNumber($this->req_material_product->ViewValue, $this->req_material_product->formatPattern());

            // req_material_rid
            $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
            $this->req_material_rid->ViewValue = FormatNumber($this->req_material_rid->ViewValue, $this->req_material_rid->formatPattern());

            // req_material_qty
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

            // req_material_packing
            $this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
            $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->ViewValue, $this->req_material_packing->formatPattern());

            // stock
            $this->stock->ViewValue = $this->stock->CurrentValue;
            $this->stock->ViewValue = FormatNumber($this->stock->ViewValue, $this->stock->formatPattern());

            // short
            $this->short->ViewValue = $this->short->CurrentValue;
            $this->short->ViewValue = FormatNumber($this->short->ViewValue, $this->short->formatPattern());

            // unit
            $this->unit->ViewValue = $this->unit->CurrentValue;

            // material_qty
            $this->material_qty->ViewValue = $this->material_qty->CurrentValue;
            $this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, $this->material_qty->formatPattern());

            // method
            $this->method->ViewValue = $this->method->CurrentValue;
            $this->method->ViewValue = FormatNumber($this->method->ViewValue, $this->method->formatPattern());

            // despatch_week
            $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
            $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->ViewValue, $this->despatch_week->formatPattern());

            // despatch_date
            $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
            $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

            // production_plan
            $this->production_plan->ViewValue = $this->production_plan->CurrentValue;
            $this->production_plan->ViewValue = FormatNumber($this->production_plan->ViewValue, $this->production_plan->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // updated
            $this->updated->ViewValue = $this->updated->CurrentValue;
            $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // jc_datetime
            $this->jc_datetime->ViewValue = $this->jc_datetime->CurrentValue;
            $this->jc_datetime->ViewValue = FormatDateTime($this->jc_datetime->ViewValue, $this->jc_datetime->formatPattern());

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, $this->company_id->formatPattern());

            // m_out_id
            $this->m_out_id->ViewValue = $this->m_out_id->CurrentValue;

            // issued_qty
            $this->issued_qty->ViewValue = $this->issued_qty->CurrentValue;
            $this->issued_qty->ViewValue = FormatNumber($this->issued_qty->ViewValue, $this->issued_qty->formatPattern());

            // pending_qty
            $this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
            $this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, $this->pending_qty->formatPattern());

            // m_out_remarks
            $this->m_out_remarks->ViewValue = $this->m_out_remarks->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // poid
            $this->poid->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // issue_to
            $this->issue_to->HrefValue = "";

            // week
            $this->week->HrefValue = "";

            // po
            $this->po->HrefValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // product_id
            $this->product_id->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // t_sqm
            $this->t_sqm->HrefValue = "";

            // req_material_grp
            $this->req_material_grp->HrefValue = "";

            // req_material_sgrp
            $this->req_material_sgrp->HrefValue = "";

            // req_material_product
            $this->req_material_product->HrefValue = "";

            // req_material_rid
            $this->req_material_rid->HrefValue = "";

            // req_material_qty
            $this->req_material_qty->HrefValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";

            // stock
            $this->stock->HrefValue = "";

            // short
            $this->short->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // material_qty
            $this->material_qty->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // updated
            $this->updated->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // jc_datetime
            $this->jc_datetime->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // m_out_id
            $this->m_out_id->HrefValue = "";

            // issued_qty
            $this->issued_qty->HrefValue = "";

            // pending_qty
            $this->pending_qty->HrefValue = "";

            // m_out_remarks
            $this->m_out_remarks->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // poid
            $this->poid->setupEditAttributes();
            $this->poid->EditValue = $this->poid->CurrentValue;
            $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());
            if (strval($this->poid->EditValue) != "" && is_numeric($this->poid->EditValue)) {
                $this->poid->EditValue = FormatNumber($this->poid->EditValue, null);
            }

            // jc_no
            $this->jc_no->setupEditAttributes();
            $this->jc_no->EditValue = $this->jc_no->CurrentValue;
            $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
            if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
                $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
            }

            // location
            $this->location->setupEditAttributes();
            $this->location->EditValue = $this->location->CurrentValue;
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());
            if (strval($this->location->EditValue) != "" && is_numeric($this->location->EditValue)) {
                $this->location->EditValue = FormatNumber($this->location->EditValue, null);
            }

            // issue_to
            $this->issue_to->setupEditAttributes();
            $this->issue_to->EditValue = $this->issue_to->CurrentValue;
            $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());
            if (strval($this->issue_to->EditValue) != "" && is_numeric($this->issue_to->EditValue)) {
                $this->issue_to->EditValue = FormatNumber($this->issue_to->EditValue, null);
            }

            // week
            $this->week->setupEditAttributes();
            $this->week->EditValue = $this->week->CurrentValue;
            $this->week->PlaceHolder = RemoveHtml($this->week->caption());
            if (strval($this->week->EditValue) != "" && is_numeric($this->week->EditValue)) {
                $this->week->EditValue = FormatNumber($this->week->EditValue, null);
            }

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->CurrentValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
                $this->po->EditValue = FormatNumber($this->po->EditValue, null);
            }

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());
            if (strval($this->buyer_id->EditValue) != "" && is_numeric($this->buyer_id->EditValue)) {
                $this->buyer_id->EditValue = FormatNumber($this->buyer_id->EditValue, null);
            }

            // grp
            $this->grp->setupEditAttributes();
            $this->grp->EditValue = $this->grp->CurrentValue;
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());
            if (strval($this->grp->EditValue) != "" && is_numeric($this->grp->EditValue)) {
                $this->grp->EditValue = FormatNumber($this->grp->EditValue, null);
            }

            // s_grp
            $this->s_grp->setupEditAttributes();
            $this->s_grp->EditValue = $this->s_grp->CurrentValue;
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());
            if (strval($this->s_grp->EditValue) != "" && is_numeric($this->s_grp->EditValue)) {
                $this->s_grp->EditValue = FormatNumber($this->s_grp->EditValue, null);
            }

            // product
            $this->product->setupEditAttributes();
            $this->product->EditValue = $this->product->CurrentValue;
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());
            if (strval($this->product->EditValue) != "" && is_numeric($this->product->EditValue)) {
                $this->product->EditValue = FormatNumber($this->product->EditValue, null);
            }

            // product_id
            $this->product_id->setupEditAttributes();
            $this->product_id->EditValue = $this->product_id->CurrentValue;
            $this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());
            if (strval($this->product_id->EditValue) != "" && is_numeric($this->product_id->EditValue)) {
                $this->product_id->EditValue = FormatNumber($this->product_id->EditValue, null);
            }

            // batch_no
            $this->batch_no->setupEditAttributes();
            $this->batch_no->EditValue = $this->batch_no->CurrentValue;
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());
            if (strval($this->batch_no->EditValue) != "" && is_numeric($this->batch_no->EditValue)) {
                $this->batch_no->EditValue = FormatNumber($this->batch_no->EditValue, null);
            }

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // size_cm
            $this->size_cm->setupEditAttributes();
            if (!$this->size_cm->Raw) {
                $this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
            }
            $this->size_cm->EditValue = HtmlEncode($this->size_cm->CurrentValue);
            $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
            if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
                $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
            }

            // t_sqm
            $this->t_sqm->setupEditAttributes();
            $this->t_sqm->EditValue = $this->t_sqm->CurrentValue;
            $this->t_sqm->PlaceHolder = RemoveHtml($this->t_sqm->caption());
            if (strval($this->t_sqm->EditValue) != "" && is_numeric($this->t_sqm->EditValue)) {
                $this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, null);
            }

            // req_material_grp
            $this->req_material_grp->setupEditAttributes();
            $this->req_material_grp->EditValue = $this->req_material_grp->CurrentValue;
            $this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());
            if (strval($this->req_material_grp->EditValue) != "" && is_numeric($this->req_material_grp->EditValue)) {
                $this->req_material_grp->EditValue = FormatNumber($this->req_material_grp->EditValue, null);
            }

            // req_material_sgrp
            $this->req_material_sgrp->setupEditAttributes();
            $this->req_material_sgrp->EditValue = $this->req_material_sgrp->CurrentValue;
            $this->req_material_sgrp->PlaceHolder = RemoveHtml($this->req_material_sgrp->caption());
            if (strval($this->req_material_sgrp->EditValue) != "" && is_numeric($this->req_material_sgrp->EditValue)) {
                $this->req_material_sgrp->EditValue = FormatNumber($this->req_material_sgrp->EditValue, null);
            }

            // req_material_product
            $this->req_material_product->setupEditAttributes();
            $this->req_material_product->EditValue = $this->req_material_product->CurrentValue;
            $this->req_material_product->PlaceHolder = RemoveHtml($this->req_material_product->caption());
            if (strval($this->req_material_product->EditValue) != "" && is_numeric($this->req_material_product->EditValue)) {
                $this->req_material_product->EditValue = FormatNumber($this->req_material_product->EditValue, null);
            }

            // req_material_rid
            $this->req_material_rid->setupEditAttributes();
            $this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
            $this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());
            if (strval($this->req_material_rid->EditValue) != "" && is_numeric($this->req_material_rid->EditValue)) {
                $this->req_material_rid->EditValue = FormatNumber($this->req_material_rid->EditValue, null);
            }

            // req_material_qty
            $this->req_material_qty->setupEditAttributes();
            $this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
            if (strval($this->req_material_qty->EditValue) != "" && is_numeric($this->req_material_qty->EditValue)) {
                $this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, null);
            }

            // req_material_packing
            $this->req_material_packing->setupEditAttributes();
            $this->req_material_packing->EditValue = $this->req_material_packing->CurrentValue;
            $this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());
            if (strval($this->req_material_packing->EditValue) != "" && is_numeric($this->req_material_packing->EditValue)) {
                $this->req_material_packing->EditValue = FormatNumber($this->req_material_packing->EditValue, null);
            }

            // stock
            $this->stock->setupEditAttributes();
            $this->stock->EditValue = $this->stock->CurrentValue;
            $this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
            if (strval($this->stock->EditValue) != "" && is_numeric($this->stock->EditValue)) {
                $this->stock->EditValue = FormatNumber($this->stock->EditValue, null);
            }

            // short
            $this->short->setupEditAttributes();
            $this->short->EditValue = $this->short->CurrentValue;
            $this->short->PlaceHolder = RemoveHtml($this->short->caption());
            if (strval($this->short->EditValue) != "" && is_numeric($this->short->EditValue)) {
                $this->short->EditValue = FormatNumber($this->short->EditValue, null);
            }

            // unit
            $this->unit->setupEditAttributes();
            if (!$this->unit->Raw) {
                $this->unit->CurrentValue = HtmlDecode($this->unit->CurrentValue);
            }
            $this->unit->EditValue = HtmlEncode($this->unit->CurrentValue);
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // material_qty
            $this->material_qty->setupEditAttributes();
            $this->material_qty->EditValue = $this->material_qty->CurrentValue;
            $this->material_qty->PlaceHolder = RemoveHtml($this->material_qty->caption());
            if (strval($this->material_qty->EditValue) != "" && is_numeric($this->material_qty->EditValue)) {
                $this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, null);
            }

            // method
            $this->method->setupEditAttributes();
            $this->method->EditValue = $this->method->CurrentValue;
            $this->method->PlaceHolder = RemoveHtml($this->method->caption());
            if (strval($this->method->EditValue) != "" && is_numeric($this->method->EditValue)) {
                $this->method->EditValue = FormatNumber($this->method->EditValue, null);
            }

            // despatch_week
            $this->despatch_week->setupEditAttributes();
            $this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
            $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());
            if (strval($this->despatch_week->EditValue) != "" && is_numeric($this->despatch_week->EditValue)) {
                $this->despatch_week->EditValue = FormatNumber($this->despatch_week->EditValue, null);
            }

            // despatch_date
            $this->despatch_date->setupEditAttributes();
            $this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()));
            $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

            // production_plan
            $this->production_plan->setupEditAttributes();
            $this->production_plan->EditValue = $this->production_plan->CurrentValue;
            $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());
            if (strval($this->production_plan->EditValue) != "" && is_numeric($this->production_plan->EditValue)) {
                $this->production_plan->EditValue = FormatNumber($this->production_plan->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // updated
            $this->updated->setupEditAttributes();
            $this->updated->EditValue = $this->updated->CurrentValue;
            $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
            if (strval($this->updated->EditValue) != "" && is_numeric($this->updated->EditValue)) {
                $this->updated->EditValue = FormatNumber($this->updated->EditValue, null);
            }

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->CurrentValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
            if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
                $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
            }

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // jc_datetime
            $this->jc_datetime->setupEditAttributes();
            $this->jc_datetime->EditValue = HtmlEncode(FormatDateTime($this->jc_datetime->CurrentValue, $this->jc_datetime->formatPattern()));
            $this->jc_datetime->PlaceHolder = RemoveHtml($this->jc_datetime->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());
            if (strval($this->company_id->EditValue) != "" && is_numeric($this->company_id->EditValue)) {
                $this->company_id->EditValue = FormatNumber($this->company_id->EditValue, null);
            }

            // m_out_id
            $this->m_out_id->setupEditAttributes();
            if (!$this->m_out_id->Raw) {
                $this->m_out_id->CurrentValue = HtmlDecode($this->m_out_id->CurrentValue);
            }
            $this->m_out_id->EditValue = HtmlEncode($this->m_out_id->CurrentValue);
            $this->m_out_id->PlaceHolder = RemoveHtml($this->m_out_id->caption());

            // issued_qty
            $this->issued_qty->setupEditAttributes();
            $this->issued_qty->EditValue = $this->issued_qty->CurrentValue;
            $this->issued_qty->PlaceHolder = RemoveHtml($this->issued_qty->caption());
            if (strval($this->issued_qty->EditValue) != "" && is_numeric($this->issued_qty->EditValue)) {
                $this->issued_qty->EditValue = FormatNumber($this->issued_qty->EditValue, null);
            }

            // pending_qty
            $this->pending_qty->setupEditAttributes();
            $this->pending_qty->EditValue = $this->pending_qty->CurrentValue;
            $this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());
            if (strval($this->pending_qty->EditValue) != "" && is_numeric($this->pending_qty->EditValue)) {
                $this->pending_qty->EditValue = FormatNumber($this->pending_qty->EditValue, null);
            }

            // m_out_remarks
            $this->m_out_remarks->setupEditAttributes();
            if (!$this->m_out_remarks->Raw) {
                $this->m_out_remarks->CurrentValue = HtmlDecode($this->m_out_remarks->CurrentValue);
            }
            $this->m_out_remarks->EditValue = HtmlEncode($this->m_out_remarks->CurrentValue);
            $this->m_out_remarks->PlaceHolder = RemoveHtml($this->m_out_remarks->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // poid
            $this->poid->HrefValue = "";

            // jc_no
            $this->jc_no->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // issue_to
            $this->issue_to->HrefValue = "";

            // week
            $this->week->HrefValue = "";

            // po
            $this->po->HrefValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            $this->product->HrefValue = "";

            // product_id
            $this->product_id->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // size_cm
            $this->size_cm->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // t_sqm
            $this->t_sqm->HrefValue = "";

            // req_material_grp
            $this->req_material_grp->HrefValue = "";

            // req_material_sgrp
            $this->req_material_sgrp->HrefValue = "";

            // req_material_product
            $this->req_material_product->HrefValue = "";

            // req_material_rid
            $this->req_material_rid->HrefValue = "";

            // req_material_qty
            $this->req_material_qty->HrefValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";

            // stock
            $this->stock->HrefValue = "";

            // short
            $this->short->HrefValue = "";

            // unit
            $this->unit->HrefValue = "";

            // material_qty
            $this->material_qty->HrefValue = "";

            // method
            $this->method->HrefValue = "";

            // despatch_week
            $this->despatch_week->HrefValue = "";

            // despatch_date
            $this->despatch_date->HrefValue = "";

            // production_plan
            $this->production_plan->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // updated
            $this->updated->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // jc_datetime
            $this->jc_datetime->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // m_out_id
            $this->m_out_id->HrefValue = "";

            // issued_qty
            $this->issued_qty->HrefValue = "";

            // pending_qty
            $this->pending_qty->HrefValue = "";

            // m_out_remarks
            $this->m_out_remarks->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->poid->Visible && $this->poid->Required) {
                if (!$this->poid->IsDetailKey && EmptyValue($this->poid->FormValue)) {
                    $this->poid->addErrorMessage(str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->poid->FormValue)) {
                $this->poid->addErrorMessage($this->poid->getErrorMessage(false));
            }
            if ($this->jc_no->Visible && $this->jc_no->Required) {
                if (!$this->jc_no->IsDetailKey && EmptyValue($this->jc_no->FormValue)) {
                    $this->jc_no->addErrorMessage(str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jc_no->FormValue)) {
                $this->jc_no->addErrorMessage($this->jc_no->getErrorMessage(false));
            }
            if ($this->location->Visible && $this->location->Required) {
                if (!$this->location->IsDetailKey && EmptyValue($this->location->FormValue)) {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->location->FormValue)) {
                $this->location->addErrorMessage($this->location->getErrorMessage(false));
            }
            if ($this->issue_to->Visible && $this->issue_to->Required) {
                if (!$this->issue_to->IsDetailKey && EmptyValue($this->issue_to->FormValue)) {
                    $this->issue_to->addErrorMessage(str_replace("%s", $this->issue_to->caption(), $this->issue_to->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->issue_to->FormValue)) {
                $this->issue_to->addErrorMessage($this->issue_to->getErrorMessage(false));
            }
            if ($this->week->Visible && $this->week->Required) {
                if (!$this->week->IsDetailKey && EmptyValue($this->week->FormValue)) {
                    $this->week->addErrorMessage(str_replace("%s", $this->week->caption(), $this->week->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->week->FormValue)) {
                $this->week->addErrorMessage($this->week->getErrorMessage(false));
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->po->FormValue)) {
                $this->po->addErrorMessage($this->po->getErrorMessage(false));
            }
            if ($this->buyer_id->Visible && $this->buyer_id->Required) {
                if (!$this->buyer_id->IsDetailKey && EmptyValue($this->buyer_id->FormValue)) {
                    $this->buyer_id->addErrorMessage(str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->buyer_id->FormValue)) {
                $this->buyer_id->addErrorMessage($this->buyer_id->getErrorMessage(false));
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->grp->FormValue)) {
                $this->grp->addErrorMessage($this->grp->getErrorMessage(false));
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->s_grp->FormValue)) {
                $this->s_grp->addErrorMessage($this->s_grp->getErrorMessage(false));
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->product->FormValue)) {
                $this->product->addErrorMessage($this->product->getErrorMessage(false));
            }
            if ($this->product_id->Visible && $this->product_id->Required) {
                if (!$this->product_id->IsDetailKey && EmptyValue($this->product_id->FormValue)) {
                    $this->product_id->addErrorMessage(str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->product_id->FormValue)) {
                $this->product_id->addErrorMessage($this->product_id->getErrorMessage(false));
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->batch_no->FormValue)) {
                $this->batch_no->addErrorMessage($this->batch_no->getErrorMessage(false));
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->size_cm->Visible && $this->size_cm->Required) {
                if (!$this->size_cm->IsDetailKey && EmptyValue($this->size_cm->FormValue)) {
                    $this->size_cm->addErrorMessage(str_replace("%s", $this->size_cm->caption(), $this->size_cm->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->sqm->FormValue)) {
                $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
            }
            if ($this->t_sqm->Visible && $this->t_sqm->Required) {
                if (!$this->t_sqm->IsDetailKey && EmptyValue($this->t_sqm->FormValue)) {
                    $this->t_sqm->addErrorMessage(str_replace("%s", $this->t_sqm->caption(), $this->t_sqm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->t_sqm->FormValue)) {
                $this->t_sqm->addErrorMessage($this->t_sqm->getErrorMessage(false));
            }
            if ($this->req_material_grp->Visible && $this->req_material_grp->Required) {
                if (!$this->req_material_grp->IsDetailKey && EmptyValue($this->req_material_grp->FormValue)) {
                    $this->req_material_grp->addErrorMessage(str_replace("%s", $this->req_material_grp->caption(), $this->req_material_grp->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->req_material_grp->FormValue)) {
                $this->req_material_grp->addErrorMessage($this->req_material_grp->getErrorMessage(false));
            }
            if ($this->req_material_sgrp->Visible && $this->req_material_sgrp->Required) {
                if (!$this->req_material_sgrp->IsDetailKey && EmptyValue($this->req_material_sgrp->FormValue)) {
                    $this->req_material_sgrp->addErrorMessage(str_replace("%s", $this->req_material_sgrp->caption(), $this->req_material_sgrp->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->req_material_sgrp->FormValue)) {
                $this->req_material_sgrp->addErrorMessage($this->req_material_sgrp->getErrorMessage(false));
            }
            if ($this->req_material_product->Visible && $this->req_material_product->Required) {
                if (!$this->req_material_product->IsDetailKey && EmptyValue($this->req_material_product->FormValue)) {
                    $this->req_material_product->addErrorMessage(str_replace("%s", $this->req_material_product->caption(), $this->req_material_product->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->req_material_product->FormValue)) {
                $this->req_material_product->addErrorMessage($this->req_material_product->getErrorMessage(false));
            }
            if ($this->req_material_rid->Visible && $this->req_material_rid->Required) {
                if (!$this->req_material_rid->IsDetailKey && EmptyValue($this->req_material_rid->FormValue)) {
                    $this->req_material_rid->addErrorMessage(str_replace("%s", $this->req_material_rid->caption(), $this->req_material_rid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->req_material_rid->FormValue)) {
                $this->req_material_rid->addErrorMessage($this->req_material_rid->getErrorMessage(false));
            }
            if ($this->req_material_qty->Visible && $this->req_material_qty->Required) {
                if (!$this->req_material_qty->IsDetailKey && EmptyValue($this->req_material_qty->FormValue)) {
                    $this->req_material_qty->addErrorMessage(str_replace("%s", $this->req_material_qty->caption(), $this->req_material_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->req_material_qty->FormValue)) {
                $this->req_material_qty->addErrorMessage($this->req_material_qty->getErrorMessage(false));
            }
            if ($this->req_material_packing->Visible && $this->req_material_packing->Required) {
                if (!$this->req_material_packing->IsDetailKey && EmptyValue($this->req_material_packing->FormValue)) {
                    $this->req_material_packing->addErrorMessage(str_replace("%s", $this->req_material_packing->caption(), $this->req_material_packing->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->req_material_packing->FormValue)) {
                $this->req_material_packing->addErrorMessage($this->req_material_packing->getErrorMessage(false));
            }
            if ($this->stock->Visible && $this->stock->Required) {
                if (!$this->stock->IsDetailKey && EmptyValue($this->stock->FormValue)) {
                    $this->stock->addErrorMessage(str_replace("%s", $this->stock->caption(), $this->stock->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->stock->FormValue)) {
                $this->stock->addErrorMessage($this->stock->getErrorMessage(false));
            }
            if ($this->short->Visible && $this->short->Required) {
                if (!$this->short->IsDetailKey && EmptyValue($this->short->FormValue)) {
                    $this->short->addErrorMessage(str_replace("%s", $this->short->caption(), $this->short->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->short->FormValue)) {
                $this->short->addErrorMessage($this->short->getErrorMessage(false));
            }
            if ($this->unit->Visible && $this->unit->Required) {
                if (!$this->unit->IsDetailKey && EmptyValue($this->unit->FormValue)) {
                    $this->unit->addErrorMessage(str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
                }
            }
            if ($this->material_qty->Visible && $this->material_qty->Required) {
                if (!$this->material_qty->IsDetailKey && EmptyValue($this->material_qty->FormValue)) {
                    $this->material_qty->addErrorMessage(str_replace("%s", $this->material_qty->caption(), $this->material_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->material_qty->FormValue)) {
                $this->material_qty->addErrorMessage($this->material_qty->getErrorMessage(false));
            }
            if ($this->method->Visible && $this->method->Required) {
                if (!$this->method->IsDetailKey && EmptyValue($this->method->FormValue)) {
                    $this->method->addErrorMessage(str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->method->FormValue)) {
                $this->method->addErrorMessage($this->method->getErrorMessage(false));
            }
            if ($this->despatch_week->Visible && $this->despatch_week->Required) {
                if (!$this->despatch_week->IsDetailKey && EmptyValue($this->despatch_week->FormValue)) {
                    $this->despatch_week->addErrorMessage(str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->despatch_week->FormValue)) {
                $this->despatch_week->addErrorMessage($this->despatch_week->getErrorMessage(false));
            }
            if ($this->despatch_date->Visible && $this->despatch_date->Required) {
                if (!$this->despatch_date->IsDetailKey && EmptyValue($this->despatch_date->FormValue)) {
                    $this->despatch_date->addErrorMessage(str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->despatch_date->FormValue, $this->despatch_date->formatPattern())) {
                $this->despatch_date->addErrorMessage($this->despatch_date->getErrorMessage(false));
            }
            if ($this->production_plan->Visible && $this->production_plan->Required) {
                if (!$this->production_plan->IsDetailKey && EmptyValue($this->production_plan->FormValue)) {
                    $this->production_plan->addErrorMessage(str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->production_plan->FormValue)) {
                $this->production_plan->addErrorMessage($this->production_plan->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->updated->Visible && $this->updated->Required) {
                if (!$this->updated->IsDetailKey && EmptyValue($this->updated->FormValue)) {
                    $this->updated->addErrorMessage(str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->updated->FormValue)) {
                $this->updated->addErrorMessage($this->updated->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->operator->FormValue)) {
                $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->datetime->FormValue, $this->datetime->formatPattern())) {
                $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
            }
            if ($this->jc_datetime->Visible && $this->jc_datetime->Required) {
                if (!$this->jc_datetime->IsDetailKey && EmptyValue($this->jc_datetime->FormValue)) {
                    $this->jc_datetime->addErrorMessage(str_replace("%s", $this->jc_datetime->caption(), $this->jc_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->jc_datetime->FormValue, $this->jc_datetime->formatPattern())) {
                $this->jc_datetime->addErrorMessage($this->jc_datetime->getErrorMessage(false));
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->company_id->FormValue)) {
                $this->company_id->addErrorMessage($this->company_id->getErrorMessage(false));
            }
            if ($this->m_out_id->Visible && $this->m_out_id->Required) {
                if (!$this->m_out_id->IsDetailKey && EmptyValue($this->m_out_id->FormValue)) {
                    $this->m_out_id->addErrorMessage(str_replace("%s", $this->m_out_id->caption(), $this->m_out_id->RequiredErrorMessage));
                }
            }
            if ($this->issued_qty->Visible && $this->issued_qty->Required) {
                if (!$this->issued_qty->IsDetailKey && EmptyValue($this->issued_qty->FormValue)) {
                    $this->issued_qty->addErrorMessage(str_replace("%s", $this->issued_qty->caption(), $this->issued_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->issued_qty->FormValue)) {
                $this->issued_qty->addErrorMessage($this->issued_qty->getErrorMessage(false));
            }
            if ($this->pending_qty->Visible && $this->pending_qty->Required) {
                if (!$this->pending_qty->IsDetailKey && EmptyValue($this->pending_qty->FormValue)) {
                    $this->pending_qty->addErrorMessage(str_replace("%s", $this->pending_qty->caption(), $this->pending_qty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->pending_qty->FormValue)) {
                $this->pending_qty->addErrorMessage($this->pending_qty->getErrorMessage(false));
            }
            if ($this->m_out_remarks->Visible && $this->m_out_remarks->Required) {
                if (!$this->m_out_remarks->IsDetailKey && EmptyValue($this->m_out_remarks->FormValue)) {
                    $this->m_out_remarks->addErrorMessage(str_replace("%s", $this->m_out_remarks->caption(), $this->m_out_remarks->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // poid
        $this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, $this->poid->ReadOnly);

        // jc_no
        $this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, $this->jc_no->ReadOnly);

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, $this->location->ReadOnly);

        // issue_to
        $this->issue_to->setDbValueDef($rsnew, $this->issue_to->CurrentValue, $this->issue_to->ReadOnly);

        // week
        $this->week->setDbValueDef($rsnew, $this->week->CurrentValue, $this->week->ReadOnly);

        // po
        $this->po->setDbValueDef($rsnew, $this->po->CurrentValue, $this->po->ReadOnly);

        // buyer_id
        $this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, $this->buyer_id->ReadOnly);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, $this->s_grp->ReadOnly);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, $this->product->ReadOnly);

        // product_id
        $this->product_id->setDbValueDef($rsnew, $this->product_id->CurrentValue, $this->product_id->ReadOnly);

        // batch_no
        $this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, $this->batch_no->ReadOnly);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, $this->quantity->ReadOnly);

        // size_cm
        $this->size_cm->setDbValueDef($rsnew, $this->size_cm->CurrentValue, $this->size_cm->ReadOnly);

        // sqm
        $this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, $this->sqm->ReadOnly);

        // t_sqm
        $this->t_sqm->setDbValueDef($rsnew, $this->t_sqm->CurrentValue, $this->t_sqm->ReadOnly);

        // req_material_grp
        $this->req_material_grp->setDbValueDef($rsnew, $this->req_material_grp->CurrentValue, $this->req_material_grp->ReadOnly);

        // req_material_sgrp
        $this->req_material_sgrp->setDbValueDef($rsnew, $this->req_material_sgrp->CurrentValue, $this->req_material_sgrp->ReadOnly);

        // req_material_product
        $this->req_material_product->setDbValueDef($rsnew, $this->req_material_product->CurrentValue, $this->req_material_product->ReadOnly);

        // req_material_rid
        $this->req_material_rid->setDbValueDef($rsnew, $this->req_material_rid->CurrentValue, $this->req_material_rid->ReadOnly);

        // req_material_qty
        $this->req_material_qty->setDbValueDef($rsnew, $this->req_material_qty->CurrentValue, $this->req_material_qty->ReadOnly);

        // req_material_packing
        $this->req_material_packing->setDbValueDef($rsnew, $this->req_material_packing->CurrentValue, $this->req_material_packing->ReadOnly);

        // stock
        $this->stock->setDbValueDef($rsnew, $this->stock->CurrentValue, $this->stock->ReadOnly);

        // short
        $this->short->setDbValueDef($rsnew, $this->short->CurrentValue, $this->short->ReadOnly);

        // unit
        $this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, $this->unit->ReadOnly);

        // material_qty
        $this->material_qty->setDbValueDef($rsnew, $this->material_qty->CurrentValue, $this->material_qty->ReadOnly);

        // method
        $this->method->setDbValueDef($rsnew, $this->method->CurrentValue, $this->method->ReadOnly);

        // despatch_week
        $this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, $this->despatch_week->ReadOnly);

        // despatch_date
        $this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern()), $this->despatch_date->ReadOnly);

        // production_plan
        $this->production_plan->setDbValueDef($rsnew, $this->production_plan->CurrentValue, $this->production_plan->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // updated
        $this->updated->setDbValueDef($rsnew, $this->updated->CurrentValue, $this->updated->ReadOnly);

        // operator
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // jc_datetime
        $this->jc_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->jc_datetime->CurrentValue, $this->jc_datetime->formatPattern()), $this->jc_datetime->ReadOnly);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, $this->company_id->ReadOnly);

        // m_out_id
        $this->m_out_id->setDbValueDef($rsnew, $this->m_out_id->CurrentValue, $this->m_out_id->ReadOnly);

        // issued_qty
        $this->issued_qty->setDbValueDef($rsnew, $this->issued_qty->CurrentValue, $this->issued_qty->ReadOnly);

        // pending_qty
        $this->pending_qty->setDbValueDef($rsnew, $this->pending_qty->CurrentValue, $this->pending_qty->ReadOnly);

        // m_out_remarks
        $this->m_out_remarks->setDbValueDef($rsnew, $this->m_out_remarks->CurrentValue, $this->m_out_remarks->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['poid'])) { // poid
            $this->poid->CurrentValue = $row['poid'];
        }
        if (isset($row['jc_no'])) { // jc_no
            $this->jc_no->CurrentValue = $row['jc_no'];
        }
        if (isset($row['location'])) { // location
            $this->location->CurrentValue = $row['location'];
        }
        if (isset($row['issue_to'])) { // issue_to
            $this->issue_to->CurrentValue = $row['issue_to'];
        }
        if (isset($row['week'])) { // week
            $this->week->CurrentValue = $row['week'];
        }
        if (isset($row['po'])) { // po
            $this->po->CurrentValue = $row['po'];
        }
        if (isset($row['buyer_id'])) { // buyer_id
            $this->buyer_id->CurrentValue = $row['buyer_id'];
        }
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->CurrentValue = $row['s_grp'];
        }
        if (isset($row['product'])) { // product
            $this->product->CurrentValue = $row['product'];
        }
        if (isset($row['product_id'])) { // product_id
            $this->product_id->CurrentValue = $row['product_id'];
        }
        if (isset($row['batch_no'])) { // batch_no
            $this->batch_no->CurrentValue = $row['batch_no'];
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->CurrentValue = $row['quantity'];
        }
        if (isset($row['size_cm'])) { // size_cm
            $this->size_cm->CurrentValue = $row['size_cm'];
        }
        if (isset($row['sqm'])) { // sqm
            $this->sqm->CurrentValue = $row['sqm'];
        }
        if (isset($row['t_sqm'])) { // t_sqm
            $this->t_sqm->CurrentValue = $row['t_sqm'];
        }
        if (isset($row['req_material_grp'])) { // req_material_grp
            $this->req_material_grp->CurrentValue = $row['req_material_grp'];
        }
        if (isset($row['req_material_sgrp'])) { // req_material_sgrp
            $this->req_material_sgrp->CurrentValue = $row['req_material_sgrp'];
        }
        if (isset($row['req_material_product'])) { // req_material_product
            $this->req_material_product->CurrentValue = $row['req_material_product'];
        }
        if (isset($row['req_material_rid'])) { // req_material_rid
            $this->req_material_rid->CurrentValue = $row['req_material_rid'];
        }
        if (isset($row['req_material_qty'])) { // req_material_qty
            $this->req_material_qty->CurrentValue = $row['req_material_qty'];
        }
        if (isset($row['req_material_packing'])) { // req_material_packing
            $this->req_material_packing->CurrentValue = $row['req_material_packing'];
        }
        if (isset($row['stock'])) { // stock
            $this->stock->CurrentValue = $row['stock'];
        }
        if (isset($row['short'])) { // short
            $this->short->CurrentValue = $row['short'];
        }
        if (isset($row['unit'])) { // unit
            $this->unit->CurrentValue = $row['unit'];
        }
        if (isset($row['material_qty'])) { // material_qty
            $this->material_qty->CurrentValue = $row['material_qty'];
        }
        if (isset($row['method'])) { // method
            $this->method->CurrentValue = $row['method'];
        }
        if (isset($row['despatch_week'])) { // despatch_week
            $this->despatch_week->CurrentValue = $row['despatch_week'];
        }
        if (isset($row['despatch_date'])) { // despatch_date
            $this->despatch_date->CurrentValue = $row['despatch_date'];
        }
        if (isset($row['production_plan'])) { // production_plan
            $this->production_plan->CurrentValue = $row['production_plan'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['updated'])) { // updated
            $this->updated->CurrentValue = $row['updated'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['jc_datetime'])) { // jc_datetime
            $this->jc_datetime->CurrentValue = $row['jc_datetime'];
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->CurrentValue = $row['company_id'];
        }
        if (isset($row['m_out_id'])) { // m_out_id
            $this->m_out_id->CurrentValue = $row['m_out_id'];
        }
        if (isset($row['issued_qty'])) { // issued_qty
            $this->issued_qty->CurrentValue = $row['issued_qty'];
        }
        if (isset($row['pending_qty'])) { // pending_qty
            $this->pending_qty->CurrentValue = $row['pending_qty'];
        }
        if (isset($row['m_out_remarks'])) { // m_out_remarks
            $this->m_out_remarks->CurrentValue = $row['m_out_remarks'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("materialrequiredjobcardlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
