<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for material_required_job_card
 */
class MaterialRequiredJobCard extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $poid;
    public $jc_no;
    public $location;
    public $issue_to;
    public $week;
    public $po;
    public $buyer_id;
    public $grp;
    public $s_grp;
    public $product;
    public $product_id;
    public $batch_no;
    public $quantity;
    public $size_cm;
    public $sqm;
    public $t_sqm;
    public $req_material_grp;
    public $req_material_sgrp;
    public $req_material_product;
    public $req_material_rid;
    public $req_material_qty;
    public $req_material_packing;
    public $stock;
    public $short;
    public $unit;
    public $material_qty;
    public $method;
    public $despatch_week;
    public $despatch_date;
    public $production_plan;
    public $remarks;
    public $updated;
    public $operator;
    public $datetime;
    public $jc_datetime;
    public $company_id;
    public $m_out_id;
    public $issued_qty;
    public $pending_qty;
    public $m_out_remarks;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "material_required_job_card";
        $this->TableName = 'material_required_job_card';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "material_required_job_card";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // poid
        $this->poid = new DbField(
            $this, // Table
            'x_poid', // Variable name
            'poid', // Name
            '`poid`', // Expression
            '`poid`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`poid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->poid->InputTextType = "text";
        $this->poid->Raw = true;
        $this->poid->Nullable = false; // NOT NULL field
        $this->poid->Required = true; // Required field
        $this->poid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->poid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['poid'] = &$this->poid;

        // jc_no
        $this->jc_no = new DbField(
            $this, // Table
            'x_jc_no', // Variable name
            'jc_no', // Name
            '`jc_no`', // Expression
            '`jc_no`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jc_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_no->InputTextType = "text";
        $this->jc_no->Raw = true;
        $this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jc_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_no'] = &$this->jc_no;

        // location
        $this->location = new DbField(
            $this, // Table
            'x_location', // Variable name
            'location', // Name
            '`location`', // Expression
            '`location`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`location`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->location->InputTextType = "text";
        $this->location->Raw = true;
        $this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->location->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['location'] = &$this->location;

        // issue_to
        $this->issue_to = new DbField(
            $this, // Table
            'x_issue_to', // Variable name
            'issue_to', // Name
            '`issue_to`', // Expression
            '`issue_to`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`issue_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->issue_to->InputTextType = "text";
        $this->issue_to->Raw = true;
        $this->issue_to->Nullable = false; // NOT NULL field
        $this->issue_to->Required = true; // Required field
        $this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->issue_to->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['issue_to'] = &$this->issue_to;

        // week
        $this->week = new DbField(
            $this, // Table
            'x_week', // Variable name
            'week', // Name
            '`week`', // Expression
            '`week`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->week->InputTextType = "text";
        $this->week->Raw = true;
        $this->week->Nullable = false; // NOT NULL field
        $this->week->Required = true; // Required field
        $this->week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->week->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['week'] = &$this->week;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // buyer_id
        $this->buyer_id = new DbField(
            $this, // Table
            'x_buyer_id', // Variable name
            'buyer_id', // Name
            '`buyer_id`', // Expression
            '`buyer_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_id->InputTextType = "text";
        $this->buyer_id->Raw = true;
        $this->buyer_id->Nullable = false; // NOT NULL field
        $this->buyer_id->Required = true; // Required field
        $this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['buyer_id'] = &$this->buyer_id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Nullable = false; // NOT NULL field
        $this->s_grp->Required = true; // Required field
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Nullable = false; // NOT NULL field
        $this->product->Required = true; // Required field
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product'] = &$this->product;

        // product_id
        $this->product_id = new DbField(
            $this, // Table
            'x_product_id', // Variable name
            'product_id', // Name
            '`product_id`', // Expression
            '`product_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_id->InputTextType = "text";
        $this->product_id->Raw = true;
        $this->product_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_id'] = &$this->product_id;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->Nullable = false; // NOT NULL field
        $this->batch_no->Required = true; // Required field
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['quantity'] = &$this->quantity;

        // size_cm
        $this->size_cm = new DbField(
            $this, // Table
            'x_size_cm', // Variable name
            'size_cm', // Name
            '`size_cm`', // Expression
            '`size_cm`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_cm->InputTextType = "text";
        $this->size_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_cm'] = &$this->size_cm;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm'] = &$this->sqm;

        // t_sqm
        $this->t_sqm = new DbField(
            $this, // Table
            'x_t_sqm', // Variable name
            't_sqm', // Name
            '`t_sqm`', // Expression
            '`t_sqm`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_sqm->InputTextType = "text";
        $this->t_sqm->Raw = true;
        $this->t_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->t_sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_sqm'] = &$this->t_sqm;

        // req_material_grp
        $this->req_material_grp = new DbField(
            $this, // Table
            'x_req_material_grp', // Variable name
            'req_material_grp', // Name
            '`req_material_grp`', // Expression
            '`req_material_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_grp->InputTextType = "text";
        $this->req_material_grp->Raw = true;
        $this->req_material_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_grp'] = &$this->req_material_grp;

        // req_material_sgrp
        $this->req_material_sgrp = new DbField(
            $this, // Table
            'x_req_material_sgrp', // Variable name
            'req_material_sgrp', // Name
            '`req_material_sgrp`', // Expression
            '`req_material_sgrp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_sgrp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_sgrp->InputTextType = "text";
        $this->req_material_sgrp->Raw = true;
        $this->req_material_sgrp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_sgrp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_sgrp'] = &$this->req_material_sgrp;

        // req_material_product
        $this->req_material_product = new DbField(
            $this, // Table
            'x_req_material_product', // Variable name
            'req_material_product', // Name
            '`req_material_product`', // Expression
            '`req_material_product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_product->InputTextType = "text";
        $this->req_material_product->Raw = true;
        $this->req_material_product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_product->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_product'] = &$this->req_material_product;

        // req_material_rid
        $this->req_material_rid = new DbField(
            $this, // Table
            'x_req_material_rid', // Variable name
            'req_material_rid', // Name
            '`req_material_rid`', // Expression
            '`req_material_rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_rid->InputTextType = "text";
        $this->req_material_rid->Raw = true;
        $this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_rid'] = &$this->req_material_rid;

        // req_material_qty
        $this->req_material_qty = new DbField(
            $this, // Table
            'x_req_material_qty', // Variable name
            'req_material_qty', // Name
            '`req_material_qty`', // Expression
            '`req_material_qty`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_qty->addMethod("getDefault", fn() => 0.00);
        $this->req_material_qty->InputTextType = "text";
        $this->req_material_qty->Raw = true;
        $this->req_material_qty->Nullable = false; // NOT NULL field
        $this->req_material_qty->Required = true; // Required field
        $this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->req_material_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['req_material_qty'] = &$this->req_material_qty;

        // req_material_packing
        $this->req_material_packing = new DbField(
            $this, // Table
            'x_req_material_packing', // Variable name
            'req_material_packing', // Name
            '`req_material_packing`', // Expression
            '`req_material_packing`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_packing`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_packing->InputTextType = "text";
        $this->req_material_packing->Raw = true;
        $this->req_material_packing->Nullable = false; // NOT NULL field
        $this->req_material_packing->Required = true; // Required field
        $this->req_material_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_packing->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['req_material_packing'] = &$this->req_material_packing;

        // stock
        $this->stock = new DbField(
            $this, // Table
            'x_stock', // Variable name
            'stock', // Name
            '`stock`', // Expression
            '`stock`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`stock`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->stock->addMethod("getDefault", fn() => 0.000);
        $this->stock->InputTextType = "text";
        $this->stock->Raw = true;
        $this->stock->Nullable = false; // NOT NULL field
        $this->stock->Required = true; // Required field
        $this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->stock->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['stock'] = &$this->stock;

        // short
        $this->short = new DbField(
            $this, // Table
            'x_short', // Variable name
            'short', // Name
            '`short`', // Expression
            '`short`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`short`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->short->InputTextType = "text";
        $this->short->Raw = true;
        $this->short->Nullable = false; // NOT NULL field
        $this->short->Required = true; // Required field
        $this->short->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->short->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['short'] = &$this->short;

        // unit
        $this->unit = new DbField(
            $this, // Table
            'x_unit', // Variable name
            'unit', // Name
            '`unit`', // Expression
            '`unit`', // Basic search expression
            200, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->unit->InputTextType = "text";
        $this->unit->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['unit'] = &$this->unit;

        // material_qty
        $this->material_qty = new DbField(
            $this, // Table
            'x_material_qty', // Variable name
            'material_qty', // Name
            '`material_qty`', // Expression
            '`material_qty`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`material_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->material_qty->InputTextType = "text";
        $this->material_qty->Raw = true;
        $this->material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->material_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['material_qty'] = &$this->material_qty;

        // method
        $this->method = new DbField(
            $this, // Table
            'x_method', // Variable name
            'method', // Name
            '`method`', // Expression
            '`method`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`method`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->method->InputTextType = "text";
        $this->method->Raw = true;
        $this->method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->method->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['method'] = &$this->method;

        // despatch_week
        $this->despatch_week = new DbField(
            $this, // Table
            'x_despatch_week', // Variable name
            'despatch_week', // Name
            '`despatch_week`', // Expression
            '`despatch_week`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`despatch_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->despatch_week->InputTextType = "text";
        $this->despatch_week->Raw = true;
        $this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->despatch_week->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_week'] = &$this->despatch_week;

        // despatch_date
        $this->despatch_date = new DbField(
            $this, // Table
            'x_despatch_date', // Variable name
            'despatch_date', // Name
            '`despatch_date`', // Expression
            CastDateFieldForLike("`despatch_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`despatch_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->despatch_date->InputTextType = "text";
        $this->despatch_date->Raw = true;
        $this->despatch_date->Nullable = false; // NOT NULL field
        $this->despatch_date->Required = true; // Required field
        $this->despatch_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->despatch_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['despatch_date'] = &$this->despatch_date;

        // production_plan
        $this->production_plan = new DbField(
            $this, // Table
            'x_production_plan', // Variable name
            'production_plan', // Name
            '`production_plan`', // Expression
            '`production_plan`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`production_plan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->production_plan->InputTextType = "text";
        $this->production_plan->Raw = true;
        $this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->production_plan->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['production_plan'] = &$this->production_plan;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->Nullable = false; // NOT NULL field
        $this->remarks->Required = true; // Required field
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['remarks'] = &$this->remarks;

        // updated
        $this->updated = new DbField(
            $this, // Table
            'x_updated', // Variable name
            'updated', // Name
            '`updated`', // Expression
            '`updated`', // Basic search expression
            16, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`updated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->updated->addMethod("getDefault", fn() => 0);
        $this->updated->InputTextType = "text";
        $this->updated->Raw = true;
        $this->updated->Nullable = false; // NOT NULL field
        $this->updated->Required = true; // Required field
        $this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->updated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['updated'] = &$this->updated;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->Required = true; // Required field
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->Required = true; // Required field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // jc_datetime
        $this->jc_datetime = new DbField(
            $this, // Table
            'x_jc_datetime', // Variable name
            'jc_datetime', // Name
            '`jc_datetime`', // Expression
            CastDateFieldForLike("`jc_datetime`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`jc_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jc_datetime->InputTextType = "text";
        $this->jc_datetime->Raw = true;
        $this->jc_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->jc_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jc_datetime'] = &$this->jc_datetime;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // m_out_id
        $this->m_out_id = new DbField(
            $this, // Table
            'x_m_out_id', // Variable name
            'm_out_id', // Name
            '`m_out_id`', // Expression
            '`m_out_id`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_out_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->m_out_id->InputTextType = "text";
        $this->m_out_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['m_out_id'] = &$this->m_out_id;

        // issued_qty
        $this->issued_qty = new DbField(
            $this, // Table
            'x_issued_qty', // Variable name
            'issued_qty', // Name
            '`issued_qty`', // Expression
            '`issued_qty`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`issued_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->issued_qty->InputTextType = "text";
        $this->issued_qty->Raw = true;
        $this->issued_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->issued_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['issued_qty'] = &$this->issued_qty;

        // pending_qty
        $this->pending_qty = new DbField(
            $this, // Table
            'x_pending_qty', // Variable name
            'pending_qty', // Name
            '`pending_qty`', // Expression
            '`pending_qty`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pending_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pending_qty->InputTextType = "text";
        $this->pending_qty->Raw = true;
        $this->pending_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pending_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pending_qty'] = &$this->pending_qty;

        // m_out_remarks
        $this->m_out_remarks = new DbField(
            $this, // Table
            'x_m_out_remarks', // Variable name
            'm_out_remarks', // Name
            '`m_out_remarks`', // Expression
            '`m_out_remarks`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_out_remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->m_out_remarks->InputTextType = "text";
        $this->m_out_remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['m_out_remarks'] = &$this->m_out_remarks;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "material_required_job_card";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->poid->DbValue = $row['poid'];
        $this->jc_no->DbValue = $row['jc_no'];
        $this->location->DbValue = $row['location'];
        $this->issue_to->DbValue = $row['issue_to'];
        $this->week->DbValue = $row['week'];
        $this->po->DbValue = $row['po'];
        $this->buyer_id->DbValue = $row['buyer_id'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->product_id->DbValue = $row['product_id'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->quantity->DbValue = $row['quantity'];
        $this->size_cm->DbValue = $row['size_cm'];
        $this->sqm->DbValue = $row['sqm'];
        $this->t_sqm->DbValue = $row['t_sqm'];
        $this->req_material_grp->DbValue = $row['req_material_grp'];
        $this->req_material_sgrp->DbValue = $row['req_material_sgrp'];
        $this->req_material_product->DbValue = $row['req_material_product'];
        $this->req_material_rid->DbValue = $row['req_material_rid'];
        $this->req_material_qty->DbValue = $row['req_material_qty'];
        $this->req_material_packing->DbValue = $row['req_material_packing'];
        $this->stock->DbValue = $row['stock'];
        $this->short->DbValue = $row['short'];
        $this->unit->DbValue = $row['unit'];
        $this->material_qty->DbValue = $row['material_qty'];
        $this->method->DbValue = $row['method'];
        $this->despatch_week->DbValue = $row['despatch_week'];
        $this->despatch_date->DbValue = $row['despatch_date'];
        $this->production_plan->DbValue = $row['production_plan'];
        $this->remarks->DbValue = $row['remarks'];
        $this->updated->DbValue = $row['updated'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->jc_datetime->DbValue = $row['jc_datetime'];
        $this->company_id->DbValue = $row['company_id'];
        $this->m_out_id->DbValue = $row['m_out_id'];
        $this->issued_qty->DbValue = $row['issued_qty'];
        $this->pending_qty->DbValue = $row['pending_qty'];
        $this->m_out_remarks->DbValue = $row['m_out_remarks'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("materialrequiredjobcardlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "materialrequiredjobcardview" => $Language->phrase("View"),
            "materialrequiredjobcardedit" => $Language->phrase("Edit"),
            "materialrequiredjobcardadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "materialrequiredjobcardlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "MaterialRequiredJobCardView",
            Config("API_ADD_ACTION") => "MaterialRequiredJobCardAdd",
            Config("API_EDIT_ACTION") => "MaterialRequiredJobCardEdit",
            Config("API_DELETE_ACTION") => "MaterialRequiredJobCardDelete",
            Config("API_LIST_ACTION") => "MaterialRequiredJobCardList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "materialrequiredjobcardlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("materialrequiredjobcardview", $parm);
        } else {
            $url = $this->keyUrl("materialrequiredjobcardview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "materialrequiredjobcardadd?" . $parm;
        } else {
            $url = "materialrequiredjobcardadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("materialrequiredjobcardedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("materialrequiredjobcardlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("materialrequiredjobcardadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("materialrequiredjobcardlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("materialrequiredjobcarddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->poid->setDbValue($row['poid']);
        $this->jc_no->setDbValue($row['jc_no']);
        $this->location->setDbValue($row['location']);
        $this->issue_to->setDbValue($row['issue_to']);
        $this->week->setDbValue($row['week']);
        $this->po->setDbValue($row['po']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->quantity->setDbValue($row['quantity']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->t_sqm->setDbValue($row['t_sqm']);
        $this->req_material_grp->setDbValue($row['req_material_grp']);
        $this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
        $this->req_material_product->setDbValue($row['req_material_product']);
        $this->req_material_rid->setDbValue($row['req_material_rid']);
        $this->req_material_qty->setDbValue($row['req_material_qty']);
        $this->req_material_packing->setDbValue($row['req_material_packing']);
        $this->stock->setDbValue($row['stock']);
        $this->short->setDbValue($row['short']);
        $this->unit->setDbValue($row['unit']);
        $this->material_qty->setDbValue($row['material_qty']);
        $this->method->setDbValue($row['method']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->despatch_date->setDbValue($row['despatch_date']);
        $this->production_plan->setDbValue($row['production_plan']);
        $this->remarks->setDbValue($row['remarks']);
        $this->updated->setDbValue($row['updated']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->jc_datetime->setDbValue($row['jc_datetime']);
        $this->company_id->setDbValue($row['company_id']);
        $this->m_out_id->setDbValue($row['m_out_id']);
        $this->issued_qty->setDbValue($row['issued_qty']);
        $this->pending_qty->setDbValue($row['pending_qty']);
        $this->m_out_remarks->setDbValue($row['m_out_remarks']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "MaterialRequiredJobCardList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // poid

        // jc_no

        // location

        // issue_to

        // week

        // po

        // buyer_id

        // grp

        // s_grp

        // product

        // product_id

        // batch_no

        // quantity

        // size_cm

        // sqm

        // t_sqm

        // req_material_grp

        // req_material_sgrp

        // req_material_product

        // req_material_rid

        // req_material_qty

        // req_material_packing

        // stock

        // short

        // unit

        // material_qty

        // method

        // despatch_week

        // despatch_date

        // production_plan

        // remarks

        // updated

        // operator

        // datetime

        // jc_datetime

        // company_id

        // m_out_id

        // issued_qty

        // pending_qty

        // m_out_remarks

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // poid
        $this->poid->ViewValue = $this->poid->CurrentValue;
        $this->poid->ViewValue = FormatNumber($this->poid->ViewValue, $this->poid->formatPattern());

        // jc_no
        $this->jc_no->ViewValue = $this->jc_no->CurrentValue;
        $this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, $this->jc_no->formatPattern());

        // location
        $this->location->ViewValue = $this->location->CurrentValue;
        $this->location->ViewValue = FormatNumber($this->location->ViewValue, $this->location->formatPattern());

        // issue_to
        $this->issue_to->ViewValue = $this->issue_to->CurrentValue;
        $this->issue_to->ViewValue = FormatNumber($this->issue_to->ViewValue, $this->issue_to->formatPattern());

        // week
        $this->week->ViewValue = $this->week->CurrentValue;
        $this->week->ViewValue = FormatNumber($this->week->ViewValue, $this->week->formatPattern());

        // po
        $this->po->ViewValue = $this->po->CurrentValue;
        $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

        // buyer_id
        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
        $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->ViewValue, $this->buyer_id->formatPattern());

        // grp
        $this->grp->ViewValue = $this->grp->CurrentValue;
        $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

        // s_grp
        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
        $this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, $this->s_grp->formatPattern());

        // product
        $this->product->ViewValue = $this->product->CurrentValue;
        $this->product->ViewValue = FormatNumber($this->product->ViewValue, $this->product->formatPattern());

        // product_id
        $this->product_id->ViewValue = $this->product_id->CurrentValue;
        $this->product_id->ViewValue = FormatNumber($this->product_id->ViewValue, $this->product_id->formatPattern());

        // batch_no
        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
        $this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, $this->batch_no->formatPattern());

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // size_cm
        $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // t_sqm
        $this->t_sqm->ViewValue = $this->t_sqm->CurrentValue;
        $this->t_sqm->ViewValue = FormatNumber($this->t_sqm->ViewValue, $this->t_sqm->formatPattern());

        // req_material_grp
        $this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
        $this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->ViewValue, $this->req_material_grp->formatPattern());

        // req_material_sgrp
        $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
        $this->req_material_sgrp->ViewValue = FormatNumber($this->req_material_sgrp->ViewValue, $this->req_material_sgrp->formatPattern());

        // req_material_product
        $this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
        $this->req_material_product->ViewValue = FormatNumber($this->req_material_product->ViewValue, $this->req_material_product->formatPattern());

        // req_material_rid
        $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
        $this->req_material_rid->ViewValue = FormatNumber($this->req_material_rid->ViewValue, $this->req_material_rid->formatPattern());

        // req_material_qty
        $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
        $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

        // req_material_packing
        $this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
        $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->ViewValue, $this->req_material_packing->formatPattern());

        // stock
        $this->stock->ViewValue = $this->stock->CurrentValue;
        $this->stock->ViewValue = FormatNumber($this->stock->ViewValue, $this->stock->formatPattern());

        // short
        $this->short->ViewValue = $this->short->CurrentValue;
        $this->short->ViewValue = FormatNumber($this->short->ViewValue, $this->short->formatPattern());

        // unit
        $this->unit->ViewValue = $this->unit->CurrentValue;

        // material_qty
        $this->material_qty->ViewValue = $this->material_qty->CurrentValue;
        $this->material_qty->ViewValue = FormatNumber($this->material_qty->ViewValue, $this->material_qty->formatPattern());

        // method
        $this->method->ViewValue = $this->method->CurrentValue;
        $this->method->ViewValue = FormatNumber($this->method->ViewValue, $this->method->formatPattern());

        // despatch_week
        $this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
        $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->ViewValue, $this->despatch_week->formatPattern());

        // despatch_date
        $this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
        $this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, $this->despatch_date->formatPattern());

        // production_plan
        $this->production_plan->ViewValue = $this->production_plan->CurrentValue;
        $this->production_plan->ViewValue = FormatNumber($this->production_plan->ViewValue, $this->production_plan->formatPattern());

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // updated
        $this->updated->ViewValue = $this->updated->CurrentValue;
        $this->updated->ViewValue = FormatNumber($this->updated->ViewValue, $this->updated->formatPattern());

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // jc_datetime
        $this->jc_datetime->ViewValue = $this->jc_datetime->CurrentValue;
        $this->jc_datetime->ViewValue = FormatDateTime($this->jc_datetime->ViewValue, $this->jc_datetime->formatPattern());

        // company_id
        $this->company_id->ViewValue = $this->company_id->CurrentValue;
        $this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, $this->company_id->formatPattern());

        // m_out_id
        $this->m_out_id->ViewValue = $this->m_out_id->CurrentValue;

        // issued_qty
        $this->issued_qty->ViewValue = $this->issued_qty->CurrentValue;
        $this->issued_qty->ViewValue = FormatNumber($this->issued_qty->ViewValue, $this->issued_qty->formatPattern());

        // pending_qty
        $this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
        $this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, $this->pending_qty->formatPattern());

        // m_out_remarks
        $this->m_out_remarks->ViewValue = $this->m_out_remarks->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // poid
        $this->poid->HrefValue = "";
        $this->poid->TooltipValue = "";

        // jc_no
        $this->jc_no->HrefValue = "";
        $this->jc_no->TooltipValue = "";

        // location
        $this->location->HrefValue = "";
        $this->location->TooltipValue = "";

        // issue_to
        $this->issue_to->HrefValue = "";
        $this->issue_to->TooltipValue = "";

        // week
        $this->week->HrefValue = "";
        $this->week->TooltipValue = "";

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // buyer_id
        $this->buyer_id->HrefValue = "";
        $this->buyer_id->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // product
        $this->product->HrefValue = "";
        $this->product->TooltipValue = "";

        // product_id
        $this->product_id->HrefValue = "";
        $this->product_id->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // size_cm
        $this->size_cm->HrefValue = "";
        $this->size_cm->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // t_sqm
        $this->t_sqm->HrefValue = "";
        $this->t_sqm->TooltipValue = "";

        // req_material_grp
        $this->req_material_grp->HrefValue = "";
        $this->req_material_grp->TooltipValue = "";

        // req_material_sgrp
        $this->req_material_sgrp->HrefValue = "";
        $this->req_material_sgrp->TooltipValue = "";

        // req_material_product
        $this->req_material_product->HrefValue = "";
        $this->req_material_product->TooltipValue = "";

        // req_material_rid
        $this->req_material_rid->HrefValue = "";
        $this->req_material_rid->TooltipValue = "";

        // req_material_qty
        $this->req_material_qty->HrefValue = "";
        $this->req_material_qty->TooltipValue = "";

        // req_material_packing
        $this->req_material_packing->HrefValue = "";
        $this->req_material_packing->TooltipValue = "";

        // stock
        $this->stock->HrefValue = "";
        $this->stock->TooltipValue = "";

        // short
        $this->short->HrefValue = "";
        $this->short->TooltipValue = "";

        // unit
        $this->unit->HrefValue = "";
        $this->unit->TooltipValue = "";

        // material_qty
        $this->material_qty->HrefValue = "";
        $this->material_qty->TooltipValue = "";

        // method
        $this->method->HrefValue = "";
        $this->method->TooltipValue = "";

        // despatch_week
        $this->despatch_week->HrefValue = "";
        $this->despatch_week->TooltipValue = "";

        // despatch_date
        $this->despatch_date->HrefValue = "";
        $this->despatch_date->TooltipValue = "";

        // production_plan
        $this->production_plan->HrefValue = "";
        $this->production_plan->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // updated
        $this->updated->HrefValue = "";
        $this->updated->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // jc_datetime
        $this->jc_datetime->HrefValue = "";
        $this->jc_datetime->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // m_out_id
        $this->m_out_id->HrefValue = "";
        $this->m_out_id->TooltipValue = "";

        // issued_qty
        $this->issued_qty->HrefValue = "";
        $this->issued_qty->TooltipValue = "";

        // pending_qty
        $this->pending_qty->HrefValue = "";
        $this->pending_qty->TooltipValue = "";

        // m_out_remarks
        $this->m_out_remarks->HrefValue = "";
        $this->m_out_remarks->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // poid
        $this->poid->setupEditAttributes();
        $this->poid->EditValue = $this->poid->CurrentValue;
        $this->poid->PlaceHolder = RemoveHtml($this->poid->caption());
        if (strval($this->poid->EditValue) != "" && is_numeric($this->poid->EditValue)) {
            $this->poid->EditValue = FormatNumber($this->poid->EditValue, null);
        }

        // jc_no
        $this->jc_no->setupEditAttributes();
        $this->jc_no->EditValue = $this->jc_no->CurrentValue;
        $this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());
        if (strval($this->jc_no->EditValue) != "" && is_numeric($this->jc_no->EditValue)) {
            $this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, null);
        }

        // location
        $this->location->setupEditAttributes();
        $this->location->EditValue = $this->location->CurrentValue;
        $this->location->PlaceHolder = RemoveHtml($this->location->caption());
        if (strval($this->location->EditValue) != "" && is_numeric($this->location->EditValue)) {
            $this->location->EditValue = FormatNumber($this->location->EditValue, null);
        }

        // issue_to
        $this->issue_to->setupEditAttributes();
        $this->issue_to->EditValue = $this->issue_to->CurrentValue;
        $this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());
        if (strval($this->issue_to->EditValue) != "" && is_numeric($this->issue_to->EditValue)) {
            $this->issue_to->EditValue = FormatNumber($this->issue_to->EditValue, null);
        }

        // week
        $this->week->setupEditAttributes();
        $this->week->EditValue = $this->week->CurrentValue;
        $this->week->PlaceHolder = RemoveHtml($this->week->caption());
        if (strval($this->week->EditValue) != "" && is_numeric($this->week->EditValue)) {
            $this->week->EditValue = FormatNumber($this->week->EditValue, null);
        }

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->PlaceHolder = RemoveHtml($this->po->caption());
        if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
            $this->po->EditValue = FormatNumber($this->po->EditValue, null);
        }

        // buyer_id
        $this->buyer_id->setupEditAttributes();
        $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
        $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());
        if (strval($this->buyer_id->EditValue) != "" && is_numeric($this->buyer_id->EditValue)) {
            $this->buyer_id->EditValue = FormatNumber($this->buyer_id->EditValue, null);
        }

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->EditValue = $this->grp->CurrentValue;
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());
        if (strval($this->grp->EditValue) != "" && is_numeric($this->grp->EditValue)) {
            $this->grp->EditValue = FormatNumber($this->grp->EditValue, null);
        }

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->EditValue = $this->s_grp->CurrentValue;
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());
        if (strval($this->s_grp->EditValue) != "" && is_numeric($this->s_grp->EditValue)) {
            $this->s_grp->EditValue = FormatNumber($this->s_grp->EditValue, null);
        }

        // product
        $this->product->setupEditAttributes();
        $this->product->EditValue = $this->product->CurrentValue;
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());
        if (strval($this->product->EditValue) != "" && is_numeric($this->product->EditValue)) {
            $this->product->EditValue = FormatNumber($this->product->EditValue, null);
        }

        // product_id
        $this->product_id->setupEditAttributes();
        $this->product_id->EditValue = $this->product_id->CurrentValue;
        $this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());
        if (strval($this->product_id->EditValue) != "" && is_numeric($this->product_id->EditValue)) {
            $this->product_id->EditValue = FormatNumber($this->product_id->EditValue, null);
        }

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->EditValue = $this->batch_no->CurrentValue;
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());
        if (strval($this->batch_no->EditValue) != "" && is_numeric($this->batch_no->EditValue)) {
            $this->batch_no->EditValue = FormatNumber($this->batch_no->EditValue, null);
        }

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // size_cm
        $this->size_cm->setupEditAttributes();
        if (!$this->size_cm->Raw) {
            $this->size_cm->CurrentValue = HtmlDecode($this->size_cm->CurrentValue);
        }
        $this->size_cm->EditValue = $this->size_cm->CurrentValue;
        $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // t_sqm
        $this->t_sqm->setupEditAttributes();
        $this->t_sqm->EditValue = $this->t_sqm->CurrentValue;
        $this->t_sqm->PlaceHolder = RemoveHtml($this->t_sqm->caption());
        if (strval($this->t_sqm->EditValue) != "" && is_numeric($this->t_sqm->EditValue)) {
            $this->t_sqm->EditValue = FormatNumber($this->t_sqm->EditValue, null);
        }

        // req_material_grp
        $this->req_material_grp->setupEditAttributes();
        $this->req_material_grp->EditValue = $this->req_material_grp->CurrentValue;
        $this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());
        if (strval($this->req_material_grp->EditValue) != "" && is_numeric($this->req_material_grp->EditValue)) {
            $this->req_material_grp->EditValue = FormatNumber($this->req_material_grp->EditValue, null);
        }

        // req_material_sgrp
        $this->req_material_sgrp->setupEditAttributes();
        $this->req_material_sgrp->EditValue = $this->req_material_sgrp->CurrentValue;
        $this->req_material_sgrp->PlaceHolder = RemoveHtml($this->req_material_sgrp->caption());
        if (strval($this->req_material_sgrp->EditValue) != "" && is_numeric($this->req_material_sgrp->EditValue)) {
            $this->req_material_sgrp->EditValue = FormatNumber($this->req_material_sgrp->EditValue, null);
        }

        // req_material_product
        $this->req_material_product->setupEditAttributes();
        $this->req_material_product->EditValue = $this->req_material_product->CurrentValue;
        $this->req_material_product->PlaceHolder = RemoveHtml($this->req_material_product->caption());
        if (strval($this->req_material_product->EditValue) != "" && is_numeric($this->req_material_product->EditValue)) {
            $this->req_material_product->EditValue = FormatNumber($this->req_material_product->EditValue, null);
        }

        // req_material_rid
        $this->req_material_rid->setupEditAttributes();
        $this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
        $this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());
        if (strval($this->req_material_rid->EditValue) != "" && is_numeric($this->req_material_rid->EditValue)) {
            $this->req_material_rid->EditValue = FormatNumber($this->req_material_rid->EditValue, null);
        }

        // req_material_qty
        $this->req_material_qty->setupEditAttributes();
        $this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
        $this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
        if (strval($this->req_material_qty->EditValue) != "" && is_numeric($this->req_material_qty->EditValue)) {
            $this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, null);
        }

        // req_material_packing
        $this->req_material_packing->setupEditAttributes();
        $this->req_material_packing->EditValue = $this->req_material_packing->CurrentValue;
        $this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());
        if (strval($this->req_material_packing->EditValue) != "" && is_numeric($this->req_material_packing->EditValue)) {
            $this->req_material_packing->EditValue = FormatNumber($this->req_material_packing->EditValue, null);
        }

        // stock
        $this->stock->setupEditAttributes();
        $this->stock->EditValue = $this->stock->CurrentValue;
        $this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
        if (strval($this->stock->EditValue) != "" && is_numeric($this->stock->EditValue)) {
            $this->stock->EditValue = FormatNumber($this->stock->EditValue, null);
        }

        // short
        $this->short->setupEditAttributes();
        $this->short->EditValue = $this->short->CurrentValue;
        $this->short->PlaceHolder = RemoveHtml($this->short->caption());
        if (strval($this->short->EditValue) != "" && is_numeric($this->short->EditValue)) {
            $this->short->EditValue = FormatNumber($this->short->EditValue, null);
        }

        // unit
        $this->unit->setupEditAttributes();
        if (!$this->unit->Raw) {
            $this->unit->CurrentValue = HtmlDecode($this->unit->CurrentValue);
        }
        $this->unit->EditValue = $this->unit->CurrentValue;
        $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

        // material_qty
        $this->material_qty->setupEditAttributes();
        $this->material_qty->EditValue = $this->material_qty->CurrentValue;
        $this->material_qty->PlaceHolder = RemoveHtml($this->material_qty->caption());
        if (strval($this->material_qty->EditValue) != "" && is_numeric($this->material_qty->EditValue)) {
            $this->material_qty->EditValue = FormatNumber($this->material_qty->EditValue, null);
        }

        // method
        $this->method->setupEditAttributes();
        $this->method->EditValue = $this->method->CurrentValue;
        $this->method->PlaceHolder = RemoveHtml($this->method->caption());
        if (strval($this->method->EditValue) != "" && is_numeric($this->method->EditValue)) {
            $this->method->EditValue = FormatNumber($this->method->EditValue, null);
        }

        // despatch_week
        $this->despatch_week->setupEditAttributes();
        $this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
        $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());
        if (strval($this->despatch_week->EditValue) != "" && is_numeric($this->despatch_week->EditValue)) {
            $this->despatch_week->EditValue = FormatNumber($this->despatch_week->EditValue, null);
        }

        // despatch_date
        $this->despatch_date->setupEditAttributes();
        $this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, $this->despatch_date->formatPattern());
        $this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

        // production_plan
        $this->production_plan->setupEditAttributes();
        $this->production_plan->EditValue = $this->production_plan->CurrentValue;
        $this->production_plan->PlaceHolder = RemoveHtml($this->production_plan->caption());
        if (strval($this->production_plan->EditValue) != "" && is_numeric($this->production_plan->EditValue)) {
            $this->production_plan->EditValue = FormatNumber($this->production_plan->EditValue, null);
        }

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // updated
        $this->updated->setupEditAttributes();
        $this->updated->EditValue = $this->updated->CurrentValue;
        $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
        if (strval($this->updated->EditValue) != "" && is_numeric($this->updated->EditValue)) {
            $this->updated->EditValue = FormatNumber($this->updated->EditValue, null);
        }

        // operator
        $this->operator->setupEditAttributes();
        $this->operator->EditValue = $this->operator->CurrentValue;
        $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
        if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
            $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
        }

        // datetime
        $this->datetime->setupEditAttributes();
        $this->datetime->EditValue = FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

        // jc_datetime
        $this->jc_datetime->setupEditAttributes();
        $this->jc_datetime->EditValue = FormatDateTime($this->jc_datetime->CurrentValue, $this->jc_datetime->formatPattern());
        $this->jc_datetime->PlaceHolder = RemoveHtml($this->jc_datetime->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->EditValue = $this->company_id->CurrentValue;
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());
        if (strval($this->company_id->EditValue) != "" && is_numeric($this->company_id->EditValue)) {
            $this->company_id->EditValue = FormatNumber($this->company_id->EditValue, null);
        }

        // m_out_id
        $this->m_out_id->setupEditAttributes();
        if (!$this->m_out_id->Raw) {
            $this->m_out_id->CurrentValue = HtmlDecode($this->m_out_id->CurrentValue);
        }
        $this->m_out_id->EditValue = $this->m_out_id->CurrentValue;
        $this->m_out_id->PlaceHolder = RemoveHtml($this->m_out_id->caption());

        // issued_qty
        $this->issued_qty->setupEditAttributes();
        $this->issued_qty->EditValue = $this->issued_qty->CurrentValue;
        $this->issued_qty->PlaceHolder = RemoveHtml($this->issued_qty->caption());
        if (strval($this->issued_qty->EditValue) != "" && is_numeric($this->issued_qty->EditValue)) {
            $this->issued_qty->EditValue = FormatNumber($this->issued_qty->EditValue, null);
        }

        // pending_qty
        $this->pending_qty->setupEditAttributes();
        $this->pending_qty->EditValue = $this->pending_qty->CurrentValue;
        $this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());
        if (strval($this->pending_qty->EditValue) != "" && is_numeric($this->pending_qty->EditValue)) {
            $this->pending_qty->EditValue = FormatNumber($this->pending_qty->EditValue, null);
        }

        // m_out_remarks
        $this->m_out_remarks->setupEditAttributes();
        if (!$this->m_out_remarks->Raw) {
            $this->m_out_remarks->CurrentValue = HtmlDecode($this->m_out_remarks->CurrentValue);
        }
        $this->m_out_remarks->EditValue = $this->m_out_remarks->CurrentValue;
        $this->m_out_remarks->PlaceHolder = RemoveHtml($this->m_out_remarks->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->poid);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->issue_to);
                    $doc->exportCaption($this->week);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_id);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->t_sqm);
                    $doc->exportCaption($this->req_material_grp);
                    $doc->exportCaption($this->req_material_sgrp);
                    $doc->exportCaption($this->req_material_product);
                    $doc->exportCaption($this->req_material_rid);
                    $doc->exportCaption($this->req_material_qty);
                    $doc->exportCaption($this->req_material_packing);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->short);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->material_qty);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->despatch_date);
                    $doc->exportCaption($this->production_plan);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->updated);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->jc_datetime);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->m_out_id);
                    $doc->exportCaption($this->issued_qty);
                    $doc->exportCaption($this->pending_qty);
                    $doc->exportCaption($this->m_out_remarks);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->poid);
                    $doc->exportCaption($this->jc_no);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->issue_to);
                    $doc->exportCaption($this->week);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_id);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->t_sqm);
                    $doc->exportCaption($this->req_material_grp);
                    $doc->exportCaption($this->req_material_sgrp);
                    $doc->exportCaption($this->req_material_product);
                    $doc->exportCaption($this->req_material_rid);
                    $doc->exportCaption($this->req_material_qty);
                    $doc->exportCaption($this->req_material_packing);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->short);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->material_qty);
                    $doc->exportCaption($this->method);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->despatch_date);
                    $doc->exportCaption($this->production_plan);
                    $doc->exportCaption($this->updated);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->jc_datetime);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->m_out_id);
                    $doc->exportCaption($this->issued_qty);
                    $doc->exportCaption($this->pending_qty);
                    $doc->exportCaption($this->m_out_remarks);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->poid);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->location);
                        $doc->exportField($this->issue_to);
                        $doc->exportField($this->week);
                        $doc->exportField($this->po);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_id);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->t_sqm);
                        $doc->exportField($this->req_material_grp);
                        $doc->exportField($this->req_material_sgrp);
                        $doc->exportField($this->req_material_product);
                        $doc->exportField($this->req_material_rid);
                        $doc->exportField($this->req_material_qty);
                        $doc->exportField($this->req_material_packing);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->short);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->material_qty);
                        $doc->exportField($this->method);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->despatch_date);
                        $doc->exportField($this->production_plan);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->updated);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->jc_datetime);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->m_out_id);
                        $doc->exportField($this->issued_qty);
                        $doc->exportField($this->pending_qty);
                        $doc->exportField($this->m_out_remarks);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->poid);
                        $doc->exportField($this->jc_no);
                        $doc->exportField($this->location);
                        $doc->exportField($this->issue_to);
                        $doc->exportField($this->week);
                        $doc->exportField($this->po);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_id);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->t_sqm);
                        $doc->exportField($this->req_material_grp);
                        $doc->exportField($this->req_material_sgrp);
                        $doc->exportField($this->req_material_product);
                        $doc->exportField($this->req_material_rid);
                        $doc->exportField($this->req_material_qty);
                        $doc->exportField($this->req_material_packing);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->short);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->material_qty);
                        $doc->exportField($this->method);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->despatch_date);
                        $doc->exportField($this->production_plan);
                        $doc->exportField($this->updated);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->jc_datetime);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->m_out_id);
                        $doc->exportField($this->issued_qty);
                        $doc->exportField($this->pending_qty);
                        $doc->exportField($this->m_out_remarks);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
